/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,l,C,I){"use strict";var V=C.extend("sap.m.ViewSettingsDialog",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Behavior",defaultValue:null},sortDescending:{type:"boolean",group:"Behavior",defaultValue:false},groupDescending:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{sortItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"sortItem",bindable:"bindable"},groupItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"groupItem",bindable:"bindable"},filterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"filterItem",bindable:"bindable"},presetFilterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"presetFilterItem",bindable:"bindable"}},associations:{selectedSortItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedGroupItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedPresetFilterItem:{type:"sap.m.ViewSettingsItem",multiple:false}},events:{confirm:{parameters:{sortItem:{type:"sap.m.ViewSettingsItem"},sortDescending:{type:"boolean"},groupItem:{type:"sap.m.ViewSettingsItem"},groupDescending:{type:"boolean"},presetFilterItem:{type:"sap.m.ViewSettingsItem"},filterItems:{type:"sap.m.ViewSettingsItem[]"},filterKeys:{type:"object"},filterString:{type:"string"}}},cancel:{},resetFilters:{}}}});V.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sDialogWidth="350px";this._sDialogHeight="434px";this._bAppendedToUIArea=false;this._showSubHeader=false;this._filterDetailList=undefined;this._iContentPage=-1;this._oContentItem=null;this._oPreviousState={};};V.prototype.exit=function(){this._rb=null;this._sDialogWidth=null;this._sDialogHeight=null;this._bAppendedToUIArea=null;this._showSubHeader=null;this._iContentPage=null;this._oContentItem=null;this._oPreviousState=null;this._sortContent=null;this._groupContent=null;this._filterContent=null;if(this._bAppendedToUIArea){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.removeContent(this,true);}if(this._dialog){this._dialog.destroy();this._dialog=null;}if(this._navContainer){this._navContainer.destroy();this._navContainer=null;}if(this._titleLabel){this._titleLabel.destroy();this._titleLabel=null;}if(this._page1){this._page1.destroy();this._page1=null;}if(this._header){this._header.destroy();this._header=null;}if(this._resetButton){this._resetButton.destroy();this._resetButton=null;}if(this._subHeader){this._subHeader.destroy();this._subHeader=null;}if(this._segmentedButton){this._segmentedButton.destroy();this._segmentedButton=null;}if(this._sortButton){this._sortButton.destroy();this._sortButton=null;}if(this._groupButton){this._groupButton.destroy();this._groupButton=null;}if(this._filterButton){this._filterButton.destroy();this._filterButton=null;}if(this._sortList){this._sortList.destroy();this._sortList=null;}if(this._sortOrderList){this._sortOrderList.destroy();this._sortOrderList=null;}if(this._groupList){this._groupList.destroy();this._groupList=null;}if(this._groupOrderList){this._groupOrderList.destroy();this._groupOrderList=null;}if(this._presetFilterList){this._presetFilterList.destroy();this._presetFilterList=null;}if(this._filterList){this._filterList.destroy();this._filterList=null;}if(this._page2){this._page2.destroy();this._page2=null;}if(this._detailTitleLabel){this._detailTitleLabel.destroy();this._detailTitleLabel=null;}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null;}};V.prototype.invalidate=function(){if(this._dialog&&(!arguments[0]||arguments[0]&&arguments[0].getId()!==this.getId()+"-dialog")){this._dialog.invalidate(arguments);}else{C.prototype.invalidate.apply(this,arguments);}};V.prototype.addStyleClass=function(){var d=this._getDialog();d.addStyleClass.apply(d,arguments);return this;};V.prototype.removeStyleClass=function(){var d=this._getDialog();d.removeStyleClass.apply(d,arguments);return this;};V.prototype.toggleStyleClass=function(){var d=this._getDialog();d.toggleStyleClass.apply(d,arguments);return this;};V.prototype.hasStyleClass=function(){var d=this._getDialog();return d.hasStyleClass.apply(d,arguments);};V.prototype.getDomRef=function(){if(this._dialog){return this._dialog.getDomRef.apply(this._dialog,arguments);}else{return null;}};V.prototype.setTitle=function(t){this._getTitleLabel().setText(t);this.setProperty("title",t,true);return this;};V.prototype.addSortItem=function(i){if(i.getSelected()){this.setSelectedSortItem(i);}this.addAggregation("sortItems",i);return this;};V.prototype.addGroupItem=function(i){if(i.getSelected()){this.setSelectedGroupItem(i);}this.addAggregation("groupItems",i);return this;};V.prototype.addPresetFilterItem=function(i){if(i.getSelected()){this.setSelectedPresetFilterItem(i);}this.addAggregation("presetFilterItems",i);return this;};V.prototype.setSelectedSortItem=function(o){var a=this.getSortItems(),i=0;if(typeof o==="string"){for(;i<a.length;i++){if(a[i].getKey()===o){o=a[i];break;}}}for(i=0;i<a.length;i++){a[i].setSelected(false);}if(o){o.setSelected(true);}if(this._getDialog().isOpen()){this._updateListSelection(this._sortList,o);}this.setAssociation("selectedSortItem",o,true);return this;};V.prototype.setSelectedGroupItem=function(o){var a=this.getGroupItems(),i=0;if(typeof o==="string"){for(;i<a.length;i++){if(a[i].getKey()===o){o=a[i];break;}}}for(i=0;i<a.length;i++){a[i].setSelected(false);}if(o){o.setSelected(true);}if(this._getDialog().isOpen()){this._updateListSelection(this._groupList,o);}this.setAssociation("selectedGroupItem",o,true);return this;};V.prototype.setSelectedPresetFilterItem=function(o){var a=this.getPresetFilterItems(),i=0;if(typeof o==="string"){for(;i<a.length;i++){if(a[i].getKey()===o){o=a[i];break;}}}for(i=0;i<a.length;i++){a[i].setSelected(false);}if(o){o.setSelected(true);this._clearSelectedFilters();}this.setAssociation("selectedPresetFilterItem",o,true);return this;};V.prototype.open=function(c){if(!this.getParent()&&!this._bAppendedToUIArea){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.addContent(this,true);this._bAppendedToUIArea=true;}if(c&&this._iContentPage===3){q.sap.delayedCall(0,this._getNavContainer(),"to",[this._getPage1().getId(),"show"]);}this._initDialogContent();this._oPreviousState={sortItem:sap.ui.getCore().byId(this.getSelectedSortItem()),sortDescending:this.getSortDescending(),groupItem:sap.ui.getCore().byId(this.getSelectedGroupItem()),groupDescending:this.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(this.getSelectedPresetFilterItem()),filterKeys:this.getSelectedFilterKeys(),navPage:this._getNavContainer().getCurrentPage(),contentPage:this._iContentPage,contentItem:this._oContentItem};this._getDialog().setInitialFocus((sap.ui.Device.system.desktop&&this._showSubHeader)?this._segmentedButton:null);this._getDialog().open();if(c){var S={"sort":0,"group":1,"filter":2};if(S.hasOwnProperty(c)){var a=this.getId()+"-"+c+"button";this._getSegmentedButton().setSelectedButton(a);this._switchToPage(S[c]);}}return this;};V.prototype.getSelectedFilterItems=function(){var s=[],f=this.getFilterItems(),S,m=true,i=0,j;for(;i<f.length;i++){if(f[i]instanceof sap.m.ViewSettingsCustomItem){if(f[i].getSelected()){s.push(f[i]);}}else if(f[i]instanceof sap.m.ViewSettingsFilterItem){S=f[i].getItems();m=f[i].getMultiSelect();for(j=0;j<S.length;j++){if(S[j].getSelected()){s.push(S[j]);if(!m){break;}}}}}return s;};V.prototype.getSelectedFilterString=function(){var f="",s,p=this.getSelectedPresetFilterItem(),F=this.getFilterItems(),S,m=true,i=0,j;if(p){f=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+sap.ui.getCore().byId(p).getText());}else{for(;i<F.length;i++){if(F[i]instanceof sap.m.ViewSettingsCustomItem){if(F[i].getSelected()){f+=F[i].getText()+", ";}}else if(F[i]instanceof sap.m.ViewSettingsFilterItem){S=F[i].getItems();m=F[i].getMultiSelect();s="";for(j=0;j<S.length;j++){if(S[j].getSelected()){s+=S[j].getText()+", ";if(!m){break;}}}s=s.substring(0,s.length-2);if(s){s=" ("+s+")";f+=F[i].getText()+s+", ";}}}f=f.substring(0,f.length-2);if(f){f=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+f);}}return f;};V.prototype.getSelectedFilterKeys=function(){var s={},S=this.getSelectedFilterItems(),i=0;for(;i<S.length;i++){s[S[i].getKey()]=S[i].getSelected();}return s;};V.prototype.setSelectedFilterKeys=function(s){var K="",f=this.getFilterItems(),S={},F,m,i,j,k;if(Object.keys(s).length){this._clearPresetFilter();}for(K in s){F=null;if(s.hasOwnProperty(K)){for(i=0;i<f.length;i++){if(f[i]instanceof sap.m.ViewSettingsCustomItem){if(f[i].getKey()===K){F=f[i];f[i].setSelected(s[K]);}}else if(f[i]instanceof sap.m.ViewSettingsFilterItem){S=f[i].getItems();m=f[i].getMultiSelect();for(j=0;j<S.length;j++){if(S[j].getKey()===K){F=S[j];if(!m){for(k=0;k<S.length;k++){S[k].setSelected(false);}}break;}}}if(F){break;}}if(F===null){q.sap.log.warning('Cannot set state for key "'+K+'" because there is no filter with these keys');continue;}F.setSelected(s[K]);}}return this;};V.prototype._getDialog=function(){var t=this;if(this._dialog===undefined){this._dialog=new sap.m.Dialog(this.getId()+"-dialog",{showHeader:false,stretch:sap.ui.Device.system.phone,verticalScrolling:true,horizontalScrolling:false,contentWidth:this._sDialogWidth,contentHeight:this._sDialogHeight,content:this._getNavContainer(),beginButton:new sap.m.Button({text:this._rb.getText("VIEWSETTINGS_ACCEPT")}).attachPress(this._onConfirm,this),endButton:new sap.m.Button({text:this._rb.getText("VIEWSETTINGS_CANCEL")}).attachPress(this._onCancel,this)}).addStyleClass("sapMVSD");var d=this._dialog.onsapescape;this._dialog.onsapescape=function(e){if(d){d.call(t._dialog,e);}t._onCancel();};this._dialog.onsapentermodifiers=function(e){if(e.shiftKey&&!e.ctrlKey&&!e.altKey){t._pressBackButton();}};}return this._dialog;};V.prototype._getNavContainer=function(){if(this._navContainer===undefined){this._navContainer=new sap.m.NavContainer(this.getId()+'-navcontainer',{pages:[]});}return this._navContainer;};V.prototype._getTitleLabel=function(){if(this._titleLabel===undefined){this._titleLabel=new sap.m.Label(this.getId()+"-title",{text:this._rb.getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");}return this._titleLabel;};V.prototype._getResetButton=function(){var t=this;if(this._resetButton===undefined){this._resetButton=new sap.m.Button(this.getId()+"-resetbutton",{icon:I.getIconURI("refresh"),press:function(){t._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});}return this._resetButton;};V.prototype._getDetailTitleLabel=function(){if(this._detailTitleLabel===undefined){this._detailTitleLabel=new sap.m.Label(this.getId()+"-detailtitle",{text:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")}).addStyleClass("sapMVSDTitle");}return this._detailTitleLabel;};V.prototype._getHeader=function(){if(this._header===undefined){this._header=new sap.m.Bar({contentMiddle:[this._getTitleLabel()]}).addStyleClass("sapMVSDBar");}return this._header;};V.prototype._getSubHeader=function(){if(this._subHeader===undefined){this._subHeader=new sap.m.Bar({contentLeft:[this._getSegmentedButton()]}).addStyleClass("sapMVSDBar");}return this._subHeader;};V.prototype._getSegmentedButton=function(){var t=this;if(this._segmentedButton===undefined){this._segmentedButton=new sap.m.SegmentedButton({select:function(e){var s=e.getParameter('id');if(s===t.getId()+"-sortbutton"){t._switchToPage(0);}else if(s===t.getId()+"-groupbutton"){t._switchToPage(1);}else if(s===t.getId()+"-filterbutton"){t._switchToPage(2);}q.sap.log.info('press event segmented: '+e.getParameter('id'));}}).addStyleClass("sapMVSDSeg");this._segmentedButton._fCalcBtnWidth=function(){};}return this._segmentedButton;};V.prototype._getSortButton=function(){if(this._sortButton===undefined){this._sortButton=new sap.m.Button(this.getId()+"-sortbutton",{visible:false,icon:I.getIconURI("sort"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_SORT")});}return this._sortButton;};V.prototype._getGroupButton=function(){if(this._groupButton===undefined){this._groupButton=new sap.m.Button(this.getId()+"-groupbutton",{visible:false,icon:I.getIconURI("group-2"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")});}return this._groupButton;};V.prototype._getFilterButton=function(){if(this._filterButton===undefined){this._filterButton=new sap.m.Button(this.getId()+"-filterbutton",{visible:false,icon:I.getIconURI("filter"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_FILTER")});}return this._filterButton;};V.prototype._getPage1=function(){if(this._page1===undefined){this._page1=new sap.m.Page(this.getId()+'-page1',{title:this._rb.getText("VIEWSETTINGS_TITLE"),customHeader:this._getHeader()});this._getNavContainer().addPage(this._page1);}return this._page1;};V.prototype._getPage2=function(){var t=this,d,b,D;if(this._page2===undefined){b=new sap.m.Button(this.getId()+"-backbutton",{icon:I.getIconURI("nav-back"),press:[this._pressBackButton,this]});D=new sap.m.Button(this.getId()+"-detailresetbutton",{icon:I.getIconURI("refresh"),press:function(){t._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});d=new sap.m.Bar({contentLeft:[b],contentMiddle:[this._getDetailTitleLabel()],contentRight:[D]}).addStyleClass("sapMVSDBar");this._page2=new sap.m.Page(this.getId()+'-page2',{title:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY"),customHeader:d});this._getNavContainer().addPage(this._page2);}return this._page2;};V.prototype._initSortContent=function(){var t=this;if(this._sortContent){return;}this._iContentPage=-1;this._sortOrderList=new sap.m.List(this.getId()+"-sortorderlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){t.setProperty('sortDescending',e.getParameter("listItem").data("item"),true);}}).addStyleClass("sapMVSDUpperList");this._sortOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._sortOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._sortList=new sap.m.List(this.getId()+"-sortlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){var i=e.getParameter("listItem").data("item");if(i){i.setProperty('selected',e.getParameter("listItem").getSelected(),true);}t.setAssociation("selectedSortItem",i,true);}});this._sortContent=[this._sortOrderList,this._sortList];};V.prototype._initGroupContent=function(){var t=this;if(this._groupContent){return;}this._iContentPage=-1;this._groupOrderList=new sap.m.List(this.getId()+"-grouporderlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){t.setProperty('groupDescending',e.getParameter("listItem").data("item"),true);}}).addStyleClass("sapMVSDUpperList");this._groupOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._groupOrderList.addItem(new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._groupList=new sap.m.List(this.getId()+"-grouplist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){var i=e.getParameter("listItem").data("item");if(i){i.setProperty('selected',e.getParameter("listItem").getSelected(),true);}t.setAssociation("selectedGroupItem",i,true);}});this._groupContent=[this._groupOrderList,this._groupList];};V.prototype._initFilterContent=function(){var t=this;if(this._filterContent){return;}this._iContentPage=-1;this._presetFilterList=new sap.m.List(this.getId()+"-predefinedfilterlist",{mode:sap.m.ListMode.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(e){var i=e.getParameter("listItem").data("item");if(i){i.setProperty('selected',e.getParameter("listItem").getSelected(),true);}t.setAssociation("selectedPresetFilterItem",i,true);t._clearSelectedFilters();}}).addStyleClass("sapMVSDUpperList");this._filterList=new sap.m.List(this.getId()+"-filterlist",{});this._filterContent=[this._presetFilterList,this._filterList];};V.prototype._initDialogContent=function(){var s=!!this.getSortItems().length,g=!!this.getGroupItems().length,p=!!this.getPresetFilterItems().length,f=!!this.getFilterItems().length,t=this,L,S=[],G=[],P=[],F=[];if(s){this._initSortContent();this._sortList.removeAllItems();S=this.getSortItems();if(S.length){S.forEach(function(i){L=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,selected:i.getSelected()}).data("item",i);this._sortList.addItem(L);},this);}}if(g){this._initGroupContent();this._groupList.removeAllItems();G=this.getGroupItems();if(G.length){G.forEach(function(i){L=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,selected:i.getSelected()}).data("item",i);this._groupList.addItem(L);},this);}if(G.length){L=new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),type:sap.m.ListType.Active,selected:!!this.getSelectedGroupItem()});this._groupList.addItem(L);}}if(p||f){this._initFilterContent();this._presetFilterList.removeAllItems();P=this.getPresetFilterItems();if(P.length){P.forEach(function(i){L=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,selected:i.getSelected()}).data("item",i);this._presetFilterList.addItem(L);},this);}if(P.length){L=new sap.m.StandardListItem({title:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!!this.getSelectedPresetFilterItem()});this._presetFilterList.addItem(L);}this._filterList.removeAllItems();F=this.getFilterItems();if(F.length){F.forEach(function(i){L=new sap.m.StandardListItem({title:i.getText(),type:sap.m.ListType.Active,press:(function(i){return function(e){if(t._navContainer.getCurrentPage().getId()!==t.getId()+'-page2'){t._switchToPage(3,i);t._prevSelectedFilterItem=this;q.sap.delayedCall(0,t._navContainer,"to",[t.getId()+'-page2',"slide"]);}if(sap.ui.Device.system.desktop&&t._filterDetailList&&t._filterDetailList.getItems()[0]){t._getNavContainer().attachEventOnce("afterNavigate",function(){t._filterDetailList.getItems()[0].focus();});}};}(i))}).data("item",i);this._filterList.addItem(L);},this);}}this._updateDialogState();this._updateListSelections();};V.prototype._updateDialogState=function(){var s=!!this.getSortItems().length,g=!!this.getGroupItems().length,p=!!this.getPresetFilterItems().length,f=!!this.getFilterItems().length,n=!s&&!g&&!p&&!f,i=false,a=0,S=this._getSegmentedButton();S.removeAllButtons();if(this._filterContent){this._presetFilterList.setVisible(true);this._filterList.setVisible(true);}if(this._iContentPage===-1||this._iContentPage===0&&!s||this._iContentPage===1&&!g||this._iContentPage===2&&!(p||f)){i=true;}if(s){S.addButton(this._getSortButton());if(this._iContentPage===0){S.setSelectedButton(this._getSortButton());}a++;}if(p||f){S.addButton(this._getFilterButton());if(this._iContentPage===2){S.setSelectedButton(this._getFilterButton());}if(!p){this._presetFilterList.setVisible(false);this._presetFilterList.addStyleClass("sapMVSDUpperList");}if(!f){this._filterList.setVisible(false);this._presetFilterList.removeStyleClass("sapMVSDUpperList");}a++;}if(g){S.addButton(this._getGroupButton());if(this._iContentPage===1){S.setSelectedButton(this._getGroupButton());}a++;}this._showSubHeader=(a>1?true:false);if(i){if(s||n){this._switchToPage(0);}else if(p||f){this._switchToPage(2);}else if(g){this._switchToPage(1);}}if(this._iContentPage===3){this._iContentPage=-1;this._switchToPage(3,this._oContentItem);}};sap.m.ViewSettingsDialog.prototype._pressBackButton=function(){var t=this;if(this._iContentPage===3){this._updateFilterCounters();q.sap.delayedCall(0,this._navContainer,"back");this._switchToPage(2);this._segmentedButton.setSelectedButton(this._filterButton);this._navContainer.attachEventOnce("afterNavigate",function(){if(t._prevSelectedFilterItem){t._prevSelectedFilterItem.focus();}});}};V.prototype.setModel=function(m,n){if(this._iContentPage===3&&this._oContentItem){r.call(this);}return sap.ui.base.ManagedObject.prototype.setModel.call(this,m,n);};V.prototype.removeFilterItem=function(f){if(this._iContentPage===3&&this._oContentItem&&this._oContentItem.getId()===f.getId()){r.call(this);}return this.removeAggregation('filterItems',f);};V.prototype.removeAllFilterItems=function(){if(this._iContentPage===3&&this._oContentItem){r.call(this);}return this.removeAllAggregation('filterItems');};V.prototype._switchToPage=function(w,o){var i=0,t=this,s=[],T=this._getTitleLabel(),R=this._getResetButton(),h=this._getHeader(),S=this._getSubHeader(),L;if(this._iContentPage===w&&w!==3){return false;}h.removeAllContentRight();S.removeAllContentRight();this._iContentPage=w;this._oContentItem=o;if(w>=0&&w<3){this._getPage1().removeAllAggregation("content",true);if(this._showSubHeader){if(!this._getPage1().getSubHeader()){this._getPage1().setSubHeader(S);}S.addContentRight(R);}else{if(this._getPage1().getSubHeader()){this._getPage1().setSubHeader();}h.addContentRight(R);}}else if(w===3){this._getPage2().removeAllAggregation("content",true);}if(this.getTitle()){T.setText(this.getTitle());}else{T.setText(this._rb.getText("VIEWSETTINGS_TITLE"));}switch(w){case 1:R.setVisible(false);if(!this._showSubHeader&&!this.getTitle()){T.setText(this._rb.getText("VIEWSETTINGS_TITLE_GROUP"));}for(;i<this._groupContent.length;i++){this._getPage1().addContent(this._groupContent[i]);}break;case 2:R.setVisible(!!this.getFilterItems().length);if(!this._showSubHeader&&!this.getTitle()){T.setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTER"));}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();for(;i<this._filterContent.length;i++){this._getPage1().addContent(this._filterContent[i]);}break;case 3:this._getDetailTitleLabel().setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")+" "+o.getText());if(o instanceof sap.m.ViewSettingsCustomItem&&o.getCustomControl()){this._clearPresetFilter();this._getPage2().addContent(o.getCustomControl());}else if(o instanceof sap.m.ViewSettingsFilterItem&&o.getItems()){s=o.getItems();if(this._filterDetailList){this._filterDetailList.destroy();}this._filterDetailList=new sap.m.List({mode:(o.getMultiSelect()?sap.m.ListMode.MultiSelect:sap.m.ListMode.SingleSelectLeft),includeItemInSelection:true,selectionChange:function(e){var a,E=e.getParameter("listItems"),b,i=0;t._clearPresetFilter();if(E.length>1&&o.getMultiSelect()){b=o.getItems();for(;i<b.length;i++){for(var j=0;j<E.length;j++){if(b[i].getKey()===E[j].getCustomData()[0].getValue().getKey()){b[i].setSelected(E[j].getSelected());}}}}else{a=e.getParameter("listItem").data("item");if(!o.getMultiSelect()){b=o.getItems();for(;i<b.length;i++){b[i].setSelected(false);}}a.setSelected(e.getParameter("listItem").getSelected());}}});for(i=0;i<s.length;i++){L=new sap.m.StandardListItem({title:s[i].getText(),type:sap.m.ListType.Active,selected:s[i].getSelected()}).data("item",s[i]);this._filterDetailList.addItem(L);}this._getPage2().addContent(this._filterDetailList);}break;case 0:default:R.setVisible(false);if(!this._getPage1().getSubHeader()&&!this.getTitle()){T.setText(this._rb.getText("VIEWSETTINGS_TITLE_SORT"));}if(this._sortContent){for(;i<this._sortContent.length;i++){this._getPage1().addContent(this._sortContent[i]);}}break;}};V.prototype._updateListSelections=function(){this._updateListSelection(this._sortList,sap.ui.getCore().byId(this.getSelectedSortItem()));this._updateListSelection(this._sortOrderList,this.getSortDescending());this._updateListSelection(this._groupList,sap.ui.getCore().byId(this.getSelectedGroupItem()));this._updateListSelection(this._groupOrderList,this.getGroupDescending());this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();};V.prototype._updateListSelection=function(L,o){var a,i=0;if(!L){return false;}a=L.getItems();L.removeSelections();for(;i<a.length;i++){if(a[i].data("item")===o||a[i].data("item")===null){L.setSelectedItem(a[i],(o&&o.getSelected?o.getSelected():true));return true;}}return false;};V.prototype._updateFilterCounters=function(){var L=(this._filterList?this._filterList.getItems():[]),o,s,f=0,i=0,j;for(;i<L.length;i++){o=L[i].data("item");f=0;if(o){if(o instanceof sap.m.ViewSettingsCustomItem){f=o.getFilterCount();}else if(o instanceof sap.m.ViewSettingsFilterItem){f=0;s=o.getItems();for(j=0;j<s.length;j++){if(s[j].getSelected()){f++;}}}}L[i].setCounter(f);}};V.prototype._clearSelectedFilters=function(){var a=this.getFilterItems(),s,i=0,j;for(;i<a.length;i++){if(a[i]instanceof sap.m.ViewSettingsFilterItem){s=a[i].getItems();for(j=0;j<s.length;j++){s[j].setSelected(false);}}a[i].setSelected(false);}if(this._iContentPage===2&&this._getDialog().isOpen()){this._updateFilterCounters();}};V.prototype._clearPresetFilter=function(){if(this.getSelectedPresetFilterItem()){this.setSelectedPresetFilterItem(null);}};function r(){this._iContentPage=2;this._oContentItem=null;q.sap.delayedCall(0,this._navContainer,"to",[this._getPage1().getId(),"show"]);}V.prototype._onConfirm=function(e){var t=this,d=this._getDialog(),a=function(){t._dialog.detachAfterClose(a);t.fireConfirm({sortItem:sap.ui.getCore().byId(t.getSelectedSortItem()),sortDescending:t.getSortDescending(),groupItem:sap.ui.getCore().byId(t.getSelectedGroupItem()),groupDescending:t.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(t.getSelectedPresetFilterItem()),filterItems:t.getSelectedFilterItems(),filterKeys:t.getSelectedFilterKeys(),filterString:t.getSelectedFilterString()});};d.attachAfterClose(a);d.close();};V.prototype._onCancel=function(e){var t=this,d=this._getDialog(),a=function(){t.setSelectedSortItem(t._oPreviousState.sortItem);t.setSortDescending(t._oPreviousState.sortDescending);t.setSelectedGroupItem(t._oPreviousState.groupItem);t.setGroupDescending(t._oPreviousState.groupDescending);t.setSelectedPresetFilterItem(t._oPreviousState.presetFilterItem);t._clearSelectedFilters();t.setSelectedFilterKeys(t._oPreviousState.filterKeys);if(t._navContainer.getCurrentPage()!==t._oPreviousState.navPage){q.sap.delayedCall(0,t._navContainer,"to",[t._oPreviousState.navPage.getId(),"show"]);}t._switchToPage(t._oPreviousState.contentPage,t._oPreviousState.contentItem);t._dialog.detachAfterClose(a);t.fireCancel();};d.attachAfterClose(a);d.close();};V.prototype._onClearFilters=function(){this._clearSelectedFilters();this._clearPresetFilter();this.fireResetFilters();this._updateFilterCounters();if(this._iContentPage===3){q.sap.delayedCall(0,this._getNavContainer(),"back");this._switchToPage(2);this._getSegmentedButton().setSelectedButton(this._getFilterButton());}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));};return V;},true);
