// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.m.library-all');
if ( !jQuery.sap.isDeclared('sap.m.ActionSheetRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.ActionSheetRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ActionSheetRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ActionSheet renderer. 
	 * @namespace
	 */
	var ActionSheetRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ActionSheetRenderer.render = function(oRm, oControl){
		var aActionButtons = oControl._getAllButtons(),
			i, bMixedButtons, oButton;
		
		for (i = 0 ; i < aActionButtons.length ; i++) {
			oButton = aActionButtons[i];
			if (oButton.getIcon()) {
				bMixedButtons = true;
			} else {
				oButton.addStyleClass("sapMActionSheetButtonNoIcon");
			}
		}
		
		// write the HTML into the render manager
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMActionSheet");
		if (bMixedButtons) {
			oRm.addClass("sapMActionSheetMixedButtons");
		}
		oRm.writeClasses();
		
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}
		
		oRm.write(">");
		
		for (i = 0 ; i < aActionButtons.length ; i++) {
			oRm.renderControl(aActionButtons[i].addStyleClass("sapMActionSheetButton"));
		}
		 
		if (sap.ui.Device.system.phone && oControl.getShowCancelButton()) {
			oRm.renderControl(oControl._getCancelButton());
		}
		
		oRm.write("</div>");
	};
	

	return ActionSheetRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ActionSheetRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.BarInPageEnabler') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides helper sap.m.BarInPageEnabler
jQuery.sap.declare('sap.m.BarInPageEnabler'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.Object'); // unlisted dependency retained
sap.ui.define("sap/m/BarInPageEnabler",['sap/ui/base/Object'],
	function(Object) {
	"use strict";

	var mContexts = {
		footer : {
			contextClass : "sapMFooter-CTX",
			tag : "Footer",
			ariaLabel: "BAR_ARIA_DESCRIPTION_FOOTER"
		},
		header : {
			contextClass : "sapMHeader-CTX",
			tag : "Header",
			ariaLabel: "BAR_ARIA_DESCRIPTION_HEADER"
		},
		subheader : {
			contextClass : "sapMSubHeader-CTX",
			tag : "Header",
			ariaLabel: "BAR_ARIA_DESCRIPTION_SUBHEADER"
		}
	};

	var IBAR_CSS_CLASS = "sapMIBar";

	/**
	 * @class Helper Class for implementing the IBar interface. Should be created once per IBar instance.
	 * @version 1.22
	 * @protected
	 * @alias sap.m.IBarInPageEnabler
	 */
	var BarInPageEnabler = Object.extend("sap.m.BarInPageEnabler", /** @lends sap.m.BarInPageEnabler.prototype */ {
		/**
		 * Determines whether the bar is sensitive to the container context.
		 *
		 * Implementation of the IBar interface.
		 * @returns {boolean} isContextSensitive
		 * @protected
		 */
		isContextSensitive : function() {
			return this.getDesign && this.getDesign() === "Auto";
		},

		/**
		 * Sets the HTML tag of the root element.
		 * @param {string} sTag
		 * @returns {sap.m.IBar} this for chaining
		 * @protected
		 */
		setHTMLTag : function (sNewTag) {
			if (sNewTag === this.sTag) {
				return this;
			}

			this.sTag = sNewTag;

			return this;
		},

		/**
		 * Gets the HTML tag of the root domref.
		 * @returns {string} the HTML-tag
		 * @protected
		 */
		getHTMLTag : function () {
			if (!this.hasOwnProperty("sTag")) {
				//Div is the default
				this.sTag = sap.m.IBarHTMLTag.Div;
			}

			return this.sTag;
		},

		/**
		 * Sets classes and tag according to the context in the page.
		 *
		 * Possible contexts are header, footer, subheader.
		 * @param {string} sContext allowed values are header, footer, subheader.
		 * @returns {sap.m.IBar} this for chaining
		 * @protected
		 */
		applyTagAndContextClassFor : function (sContext) {
			var oOptions = mContexts[sContext];

			if (!oOptions) {
				jQuery.sap.log.error("The context " + sContext + " is not known", this);
				return this;
			}

			this._sAriaLabel = oOptions.ariaLabel;

			if (!this.isContextSensitive || !this.setHTMLTag) {
				jQuery.sap.log.error("The bar control you are using does not implement all the members of the IBar interface", this);
				return this;
			}

			//If this class does not gets added by the renderer, add it here
			if (!this.getRenderer().shouldAddIBarContext()) {
				this.addStyleClass(IBAR_CSS_CLASS + "-CTX");
			}

			this.setHTMLTag(oOptions.tag);

			if (this.isContextSensitive()) {
				this.addStyleClass(oOptions.contextClass);
			}

			return this;
		},


		//Rendering
		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 * @protected
		 * @param {sap.ui.core.RenderManager} oRM the RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered.
		 */
		render : function(oRM, oControl) {
			var sTag = oControl.getHTMLTag().toLowerCase(),
				sLabelID = oControl.getId() + "-ariaLabel";

			oRM.write("<" + sTag);
			oRM.addClass(IBAR_CSS_CLASS);

			//ARIA
			if (oControl._sAriaLabel) {
				oRM.writeAttribute("aria-labelledby", sLabelID);
			}

			if (this.shouldAddIBarContext(oControl)) {
				oRM.addClass(IBAR_CSS_CLASS + "-CTX");
			}

			oRM.writeControlData(oControl);

			// call the hooks
			BarInPageEnabler.renderTooltip(oRM, oControl);
			this.decorateRootElement(oRM, oControl);

			oRM.writeClasses();
			oRM.writeStyles();
			oRM.write(">");

			//ARIA
			if (oControl._sAriaLabel) {
				var oMessageBundle = sap.ui.getCore().getLibraryResourceBundle("sap.m");
				oRM.write("<label id='" + sLabelID + "' style='display:none;' aria-hidden='true'>" + oMessageBundle.getText(oControl._sAriaLabel) + "</label>");
			}

			this.renderBarContent(oRM, oControl);

			oRM.write("</" + sTag + ">");
		}

	});

	/**
	 * Renders the tooltip for the given control
	 * @protected
	 * @param {sap.ui.core.RenderManager} oRM the RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered.
	 */
	BarInPageEnabler.renderTooltip = function(oRM, oControl) {
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			oRM.writeAttributeEscaped("title", sTooltip);
		}
	};


	/**
	 * Adds the sapMBarChildClass to a control.
	 * @param {sap.ui.core.Control} oControl
	 * @protected
	 * @static
	 */
	BarInPageEnabler.addChildClassTo = function (oControl) {
		oControl.addStyleClass("sapMBarChild");
	};

	return BarInPageEnabler;

}, /* bExport= */ true);

}; // end of sap/m/BarInPageEnabler.js
if ( !jQuery.sap.isDeclared('sap.m.BarRenderer') ) {
/*!

 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.BarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/BarRenderer",['jquery.sap.global', './BarInPageEnabler'],
	function(jQuery, BarInPageEnabler) {
	"use strict";


	/**
	 * Bar renderer.
	 * @namespace
	 */
	var BarRenderer = {};

	/////////////////
	//Bar in page delegation
	/////////////////

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @protected
	 * @param {sap.ui.core.RenderManager} oRM the RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered.
	 */
	BarRenderer.render = BarInPageEnabler.prototype.render;

	/////////////////
	//Bar specific rendering + implementation of enabler hooks
	/////////////////

	/**
	 * Add classes attributes and styles to the root tag
	 *
	 * @param {sap.ui.core.RenderManager} oRM the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	BarRenderer.decorateRootElement = function (oRM, oControl) {
		oRM.addClass("sapMBar");
		oRM.addClass(this.getContext(oControl));
		oRM.writeAccessibilityState(oControl, {
			role: "toolbar"
		});

		if (oControl.getTranslucent() && (sap.ui.Device.support.touch  || jQuery.sap.simulateMobileOnDesktop)) {
			oRM.addClass("sapMBarTranslucent");
		}

		oRM.addClass("sapMBar-CTX");
	};

	/**
	 * Determines, if the IBarContext classes should be added to the control
	 * @private
	 */
	BarRenderer.shouldAddIBarContext = function () {
		return true;
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRM the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	BarRenderer.renderBarContent = function(oRM, oControl) {
		var sClosingDiv = "</div>";

		//left content area
		oRM.write("<div id='" + oControl.getId() + "-BarLeft' ");
		oRM.addClass('sapMBarLeft');
		oRM.addClass('sapMBarContainer');
		oRM.writeClasses();
		oRM.write(">");

		this.renderAllControls(oControl.getContentLeft(), oRM, oControl);

		oRM.write(sClosingDiv);

		//middle content area
		oRM.write("<div id='" + oControl.getId() + "-BarMiddle' ");
		oRM.addClass('sapMBarMiddle');
		oRM.writeClasses();
		oRM.write(">");
		if (oControl.getEnableFlexBox()) {
			oControl._oflexBox = oControl._oflexBox || new sap.m.HBox(oControl.getId() + "-BarPH", {alignItems: "Center"}).addStyleClass("sapMBarPH").setParent(oControl, null, true);

			oControl.getContentMiddle().forEach(function(oMidContent) {
				oControl._oflexBox.addItem(oMidContent);
			});

			oRM.renderControl(oControl._oflexBox);
		} else {
			oRM.write("<div id='" + oControl.getId() + "-BarPH' ");
			oRM.addClass('sapMBarPH');
			oRM.addClass('sapMBarContainer');
			oRM.writeClasses();
			oRM.write(">");

			this.renderAllControls(oControl.getContentMiddle(), oRM, oControl);

			oRM.write(sClosingDiv);
		}
		oRM.write(sClosingDiv);


		//right content area
		oRM.write("<div id='" + oControl.getId() + "-BarRight'");
		oRM.addClass('sapMBarRight');
		oRM.addClass('sapMBarContainer');
		if (sap.ui.getCore().getConfiguration().getRTL()) {
			oRM.addClass("sapMRTL");
		}
		oRM.writeClasses();
		oRM.write(">");

		this.renderAllControls(oControl.getContentRight(), oRM, oControl);

		oRM.write(sClosingDiv);
	};

	/**
	 * Makes the render manager renderAllControls in an array
	 * @param {sap.ui.core.Control} aControls the Controls to be rendered
	 * @param {sap.ui.core.RenderManager} oRM the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.m.Bar} oBar an object representation of the control that should be rendered
	 */
	BarRenderer.renderAllControls = function (aControls, oRM, oBar) {
		aControls.forEach(function (oControl) {
			sap.m.BarInPageEnabler.addChildClassTo(oControl, oBar);

			oRM.renderControl(oControl);
		});
	};

	BarRenderer._mContexts = {
			Header : "sapMHeader-CTX",
			SubHeader : "sapMSubHeader-CTX",
			Footer : "sapMFooter-CTX",
			Default : "sapMContent-CTX"
	};

	/**
	 * Determines wich tag or context class the bar should have.
	 * @protected
	 * @param {sap.m.BarBase} oControl the Bar control.
	 * @returns {string} the context class
	 */
	BarRenderer.getContext = function(oControl) {
		var sDesign = oControl.getDesign(),
			mContexts = BarRenderer._mContexts;

		return mContexts[sDesign] || mContexts.Default;
	};



	return BarRenderer;

}, /* bExport= */ true);

}; // end of sap/m/BarRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.BusyDialogRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.BusyDialogRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/BusyDialogRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * BusyDialog renderer. 
	 * @namespace
	 */
	var BusyDialogRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	BusyDialogRenderer.render = function(oRm, oControl){
		// write the HTML into the render manager
		oRm.write("<div tabindex='-1'");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMBusyDialog sapMCommonDialog");
		if (jQuery.device.is.iphone) {
			oRm.addClass("sapMDialogHidden");
		}
		
		if (!oControl.getText() && !oControl.getTitle() && !oControl.getShowCancelButton()) {
			oRm.addClass("sapMBusyDialogSimple");
		}
	
		// test dialog with sap-ui-xx-formfactor=compact
		if (sap.m._bSizeCompact) {
			oRm.addClass("sapUiSizeCompact");
		}
	
		oRm.writeClasses();
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}
		oRm.write(">");
		if (oControl.getTitle()) {
			oRm.write("<header class=\"sapMDialogTitle\">");
			oRm.writeEscaped(oControl.getTitle());
			oRm.write("</header>");
		}
	
		oRm.renderControl(oControl._oLabel);
		oRm.renderControl(oControl._busyIndicator);
	
		if (oControl.getShowCancelButton()) {
			if (sap.ui.Device.system.phone) {
				oRm.write("<footer class='sapMBusyDialogFooter sapMFooter-CTX'>");
				oRm.renderControl(oControl._oButton);
				oRm.write("</footer>");
			} else {
				oRm.renderControl(oControl._oButtonToolBar);
			}
		}
		oRm.write("</div>");
	};
	

	return BusyDialogRenderer;

}, /* bExport= */ true);

}; // end of sap/m/BusyDialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.BusyIndicatorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.BusyIndicatorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/BusyIndicatorRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * BusyIndicator renderer.
	 * @namespace
	 */
	var BusyIndicatorRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	BusyIndicatorRenderer.render = function(oRm, oControl){
	
		var sSize = oControl.getSize();
		var iDesignClass = "";

		if (oControl.getDesign() == "auto") {
			iDesignClass = "sapMBusyIndicator";
		} else {
			iDesignClass = oControl.getDesign() == "dark" ? "sapMBusyIndicatorDark" : "sapMBusyIndicatorLight";
		}
	
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass(iDesignClass);
		oRm.writeClasses();
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}
		if (!oControl.getVisible()) {
			oRm.addStyle("visibility", "hidden");
			oRm.writeStyles();
		}

		oRm.writeAccessibilityState(oControl, {
			role : "progressbar",
			valuemin: "0", // required by the ARIA specification
			valuemax: "100" // required by the ARIA specification
			
		});
		oRm.write(">");
	
		if (oControl.getCustomIcon()) {
			oRm.renderControl(oControl._iconImage);
		} else if (oControl._bUseSvg) {
			this._renderSvg(oRm, oControl, sSize);
		} else {
			this._renderCanvas(oRm, oControl, sSize);
		}
	
		if (oControl.getText()) {
			oRm.renderControl(oControl._oLabel);
		}
	
		oRm.write("</div>");
	};
	
	// SVG based loading indicator
	BusyIndicatorRenderer._renderSvg = function(oRm, oControl, sSize){
		oRm.write('<svg');
		oRm.writeAttribute('id', oControl.getId() +  '-svg');
		oRm.writeAttribute('viewBox','0 0 100 100');
		oRm.writeAttribute('class','sapMBusySvg');
		if (sSize) {
			oRm.addStyle('width', sSize);
			oRm.addStyle('height', sSize);
			oRm.writeStyles();
		}
		oRm.write('><g transform = translate(50,50)>');
		oRm.write('<path d="M0,-36A36,36 0 1,0 36,0" stroke-width="20%" fill="none" class="sapMSpinSvg">');
		oRm.write('<animateTransform attributeName="transform" attributeType="XML" type="rotate" ');
		oRm.write('from="0" to="360" dur="1.1s" repeatCount="indefinite" />');
		oRm.write('</path></g></svg>');
	};
	
	// Canvas based loading indicator
	BusyIndicatorRenderer._renderCanvas = function(oRm, oControl, sSize){
		oRm.write('<canvas');
		oRm.writeAttribute("id", oControl.getId() +  "-canvas");
		oRm.writeAttribute("class","sapMSpinCanvas");
		oRm.writeAttribute("width","32"); // initially 2em * 16px
		oRm.writeAttribute("height","32");
		if (sSize) {
			oRm.addStyle('width', sSize);
			oRm.addStyle('height', sSize);
			oRm.writeStyles();
		}
		oRm.write('></canvas>');
	};
	

	return BusyIndicatorRenderer;

}, /* bExport= */ true);

}; // end of sap/m/BusyIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ButtonRenderer",['jquery.sap.global'],

	function(jQuery) {
	"use strict";

	/**
	 * Button renderer.
	 * @namespace
	 */
	var ButtonRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm
	 *            the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oButton
	 *            the button to be rendered
	 */
	ButtonRenderer.render = function(oRm, oButton) {
		// get control properties
		var sType = oButton.getType();
		var bEnabled = oButton.getEnabled();
		var sWidth = oButton.getWidth();
		var sTooltip = oButton.getTooltip_AsString();
		var sTextDir = oButton.getTextDirection();

		// get icon from icon pool
		var sBackURI = sap.ui.core.IconPool.getIconURI("nav-back");

		// start button tag
		oRm.write("<button type=\"button\"");
		oRm.writeControlData(oButton);
		oRm.addClass("sapMBtnBase");

		// button container style class
		if (!oButton._isUnstyled()) {
			oRm.addClass("sapMBtn");

			// extend  minimum button size if icon is set without text for button types back and up
			if ((sType === sap.m.ButtonType.Back || sType === sap.m.ButtonType.Up) && oButton.getIcon() && !oButton._getText()) {
				oRm.addClass("sapMBtnBack");
			}
		}

		//ARIA attributes
		var mAccProps = {};
		var sTextId = "";

		switch (sType) {
		case sap.m.ButtonType.Accept:
			sTextId = sap.m.Button._oStaticAcceptText.getId();
			break;
		case sap.m.ButtonType.Reject:
			sTextId = sap.m.Button._oStaticRejectText.getId();
			break;
		case sap.m.ButtonType.Emphasized:
			sTextId = sap.m.Button._oStaticEmphasizedText.getId();
			break;
		default: // No need to do anything for other button types
			break;
		}
		if (sTextId) {
			mAccProps["describedby"] = {value: sTextId, append: true};
		}

		//descendants (e.g. ToggleButton) callback
		if (this.renderAccessibilityAttributes) {
			this.renderAccessibilityAttributes(oRm, oButton, mAccProps);
		}
		oRm.writeAccessibilityState(oButton, mAccProps);

		// check if the button is disabled
		if (!bEnabled) {
			oRm.writeAttribute("disabled", "disabled");
			if (!oButton._isUnstyled()) {
				oRm.addClass("sapMBtnDisabled");
			}
		} else {
			switch (sType) {
			case sap.m.ButtonType.Accept:
			case sap.m.ButtonType.Reject:
			case sap.m.ButtonType.Emphasized:
				oRm.addClass("sapMBtnInverted");
				break;
			default: // No need to do anything for other button types
				break;
			}
		}

		// add tooltip if available
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}

		oRm.writeClasses();

		// set user defined width
		if (sWidth != "" || sWidth.toLowerCase() === "auto") {
			oRm.addStyle("width", sWidth);
			oRm.writeStyles();
		}

		// close button tag
		oRm.write(">");

		// start inner button tag
		oRm.write("<div");
		oRm.writeAttribute("id", oButton.getId() + "-inner");

		// button style class
		if (!oButton._isUnstyled()) {
			oRm.addClass("sapMBtnInner");
		}

		// check if button is hoverable
		if (oButton._isHoverable()) {
			oRm.addClass("sapMBtnHoverable");
		}

		// check if button is focusable (not disabled)
		if (bEnabled) {
			oRm.addClass("sapMFocusable");
		}

		//get render attributes of depended buttons (e.g. ToggleButton)
		if (this.renderButtonAttributes) {
			this.renderButtonAttributes(oRm, oButton);
		}

		// set padding depending on icons left or right or none
		if (!oButton._isUnstyled()) {
			if (!oButton.getIcon()) {
				if (sType != sap.m.ButtonType.Back && sType != sap.m.ButtonType.Up) {
					oRm.addClass("sapMBtnPaddingLeft");
				}
				if (oButton._getText()) {
					oRm.addClass("sapMBtnPaddingRight");
				}
			} else {
				if (oButton.getIcon() && oButton._getText() && oButton.getIconFirst()) {
					oRm.addClass("sapMBtnPaddingRight");
				}
				if (oButton.getIcon() && oButton._getText() && !oButton.getIconFirst()) {
					if (sType != sap.m.ButtonType.Back && sType != sap.m.ButtonType.Up) {
						oRm.addClass("sapMBtnPaddingLeft");
					}
				}
			}
		}

		// set button specific styles
		if (!oButton._isUnstyled() && sType !== "") {
			// set button specific styles
			oRm.addClass("sapMBtn" + jQuery.sap.escapeHTML(sType));
		}

		// add all classes to inner button tag
		oRm.writeClasses();

		// close inner button tag
		oRm.write(">");

		// set image for internal image control (back)
		if (sType === sap.m.ButtonType.Back || sType === sap.m.ButtonType.Up) {
			this.writeInternalIconPoolHtml(oRm, oButton, sBackURI);
		}

		// write icon
		if (oButton.getIcon()) {
			this.writeImgHtml(oRm, oButton);
		}

		// write button text
		if (oButton._getText()) {
			oRm.write("<span");
			oRm.addClass("sapMBtnContent");
			// check if textDirection property is not set to default "Inherit" and add "dir" attribute
			if (sTextDir !== sap.ui.core.TextDirection.Inherit) {
				oRm.writeAttribute("dir", sTextDir.toLowerCase());
			}
			// Check and add padding between icon and text
			if (oButton.getIcon()) {
				if (oButton.getIconFirst()) {
					if (sType === sap.m.ButtonType.Back || sType === sap.m.ButtonType.Up) {
						oRm.addClass("sapMBtnBackContentRight");
					} else {
						oRm.addClass("sapMBtnContentRight");
					}
				} else {
					if (sType === sap.m.ButtonType.Back || sType === sap.m.ButtonType.Up) {
						oRm.addClass("sapMBtnContentRight");
					}
					oRm.addClass("sapMBtnContentLeft");
				}
			} else if (sType === sap.m.ButtonType.Back || sType === sap.m.ButtonType.Up) {
				oRm.addClass("sapMBtnContentRight");
			}
			oRm.writeClasses();
			oRm.writeAttribute("id", oButton.getId() + "-content");
			oRm.write(">");
			oRm.writeEscaped(oButton._getText());
			oRm.write("</span>");
		}

		// end inner button tag
		oRm.write("</div>");

		// end button tag
		oRm.write("</button>");
	};

	/**
	 * HTML for image
	 *
	 * @param {sap.ui.core.RenderManager} oRm
	 *            the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oButton
	 *            the button to be rendered
	 * @private
	 */
	ButtonRenderer.writeImgHtml = function(oRm, oButton) {
		oRm.renderControl(oButton._getImage((oButton.getId() + "-img"), oButton.getIcon(), oButton.getActiveIcon(), oButton.getIconDensityAware()));
	};

	/**
	 * @param {sap.ui.core.RenderManager} oRm
	 *	      the RenderManager that can be used for writing to
	 *	      the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oButton
	 *	      the button to be rendered
	 * @param {sap.ui.core.URI} sURI
	 *            URI of the icon to be written
	 * HTML for internal image (icon pool)
	 */
	ButtonRenderer.writeInternalIconPoolHtml = function(oRm, oButton, sURI) {
		oRm.renderControl(oButton._getInternalIconBtn((oButton.getId() + "-iconBtn"), sURI));
	};

	return ButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.CarouselRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.CarouselRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/CarouselRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Carousel renderer.
	 * @namespace
	 */
	var CarouselRenderer = {
	};

	/**
	 * Renders the Carousel's HTML, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	CarouselRenderer.render = function(rm, oCarousel){
		//Outer carousel div
		rm.write("<div");
		rm.writeControlData(oCarousel);
		// custom F6 handling
		rm.writeAttribute("data-sap-ui-customfastnavgroup", "true");

		rm.addStyle("width", oCarousel.getWidth());
		rm.addStyle("height", oCarousel.getHeight());
		rm.writeStyles();

		rm.addClass("sapMCrsl");
		//'sapMCrslFluid' is originally from mobify-carousel
		rm.addClass("sapMCrslFluid");

		// add all classes (also custom classes) to carousel tag
		rm.writeClasses();

		var sTooltip = oCarousel.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}

		rm.writeAttributeEscaped("tabindex","0");

		// ARIA
		rm.writeAccessibilityState(oCarousel, {
			role: "list"
		});

		rm.write(">");

		var aPages = oCarousel.getPages();
		var iPageCount = aPages.length;
		var sPageIndicatorPlacement = oCarousel.getShowPageIndicator() ?
			oCarousel.getPageIndicatorPlacement() : null;


		//visual indicator
		if (sPageIndicatorPlacement === sap.m.PlacementType.Top) {
			this._renderPageIndicator(rm, iPageCount);
		}

		//inner carousel div
		rm.write("<div class='sapMCrslInner'>");
		//do housekeeping
		oCarousel._cleanUpScrollContainer();

		var fnRenderPage = function(oPage, iIndex) {
			//item div
			rm.write("<div class='sapMCrslItem");
			if (sPageIndicatorPlacement === sap.m.PlacementType.Bottom) {
				rm.write(" sapMCrslBottomOffset");
			}
			rm.write("' id='" + oCarousel.sId + "-" + oPage.sId + "-slide'");
			// ARIA
			rm.writeAccessibilityState(oPage, {
				role:"listitem"
			});

			rm.write(">");
				rm.renderControl(oCarousel._createScrollContainer(oPage, iIndex));
			rm.write("</div>");
		};

		//Render Pages
		aPages.forEach(fnRenderPage);


		rm.write("</div>");
		//inner div ends


		if (sap.ui.Device.system.desktop && iPageCount > 1) {
			//heads up controls for desktop browsers
			rm.write("<div class='sapMCrslControls sapMCrslHud'>");
				rm.write("<a class='sapMCrslPrev' href='#' data-slide='prev' tabindex='-1'><div class='sapMCrslHudInner'>");
				rm.renderControl(oCarousel._getNavigationArrow('left'));
				rm.write("</div></a>");

				rm.write("<a class='sapMCrslNext' href='#' data-slide='next' tabindex='-1'><div class='sapMCrslHudInner'>");
				rm.renderControl(oCarousel._getNavigationArrow('right'));
				rm.write("</div></a>");
			rm.write("</div>");
		}


		//visual indicator
		if (sPageIndicatorPlacement === sap.m.PlacementType.Bottom) {
			this._renderPageIndicator(rm, iPageCount, true);
		}
		rm.write("</div>");

		//page-wrap ends
	};


	/**
	 * Renders the page indicator, using the provided {@link sap.ui.core.RenderManager}.
	 * Page indicator is only rendered if there is more than one carousel page
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param aPages array of controls to be rendered
	 * @private
	 */
	CarouselRenderer._renderPageIndicator = function(rm, iPageCount, bBottom){
		var oResourceBundle = sap.ui.getCore().getLibraryResourceBundle('sap.m');

		//page indicator div
		if (iPageCount > 1) {
			rm.write("<div class='sapMCrslControls sapMCrslBulleted" +
					(bBottom ? " sapMCrslBottomOffset" : "") +
					"'>");
			for ( var i = 1; i <= iPageCount; i++) {
				//item span
				rm.write("<span role='img' data-slide=" + i + " aria-label='" + oResourceBundle.getText('CAROUSEL_POSITION', [i, iPageCount]) + "'>" + i + "</span>");
			}
			rm.write("</div>");
		}
	};

	return CarouselRenderer;

}, /* bExport= */ true);

}; // end of sap/m/CarouselRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.CheckBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.CheckBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/m/CheckBoxRenderer",['jquery.sap.global', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, ValueStateSupport) {
	"use strict";


	/**
	 * CheckBox renderer.
	 * @namespace
	 */
	var CheckBoxRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oCheckBox an object representation of the control that should be rendered
	 */
	CheckBoxRenderer.render = function(oRm, oCheckBox){
		// get control properties
		var bEnabled = oCheckBox.getEnabled();
		var bEditable = oCheckBox.getEditable();
		var bInteractible = oCheckBox.getEnabled() && oCheckBox.getEditable();

		// CheckBox wrapper
		oRm.write("<div");
		oRm.addClass("sapMCb");

		if (bInteractible) {
			oRm.addClass("sapMPointer");
		}

		if (!bEditable) {
			oRm.addClass("sapMCbRo");
		}

		if (!bEnabled) {
			oRm.addClass("sapMCbBgDis");
		}

		oRm.writeControlData(oCheckBox);
		oRm.writeClasses();

		var sTooltip = ValueStateSupport.enrichTooltip(oCheckBox, oCheckBox.getTooltip_AsString());
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}

		if (bEnabled) {
			oRm.writeAttribute("tabindex", oCheckBox.getTabIndex());
		}

		//ARIA attributes
		oRm.writeAccessibilityState(oCheckBox, {
			role: 'checkbox',		
			selected: null,
			checked: oCheckBox.getSelected()
		});		

		oRm.write(">");		// DIV element

		// write the HTML into the render manager
		oRm.write("<div id='");
		oRm.write(oCheckBox.getId() + "-CbBg'");

		// CheckBox style class
		oRm.addClass("sapMCbBg");

		if (bEnabled && bEditable && sap.ui.Device.system.desktop) {
			oRm.addClass("sapMCbHoverable");
		}

		if (!oCheckBox.getActiveHandling()) {
			oRm.addClass("sapMCbActiveStateOff");
		}

		oRm.addClass("sapMCbMark"); // TODO: sapMCbMark is redundant, remove it and simplify CSS

		if (oCheckBox.getSelected()) {
			oRm.addClass("sapMCbMarkChecked");
		}
		oRm.writeClasses();

		oRm.write(">");		// DIV element

		oRm.write("<input type='CheckBox' id='");
		oRm.write(oCheckBox.getId() + "-CB'");

		if (oCheckBox.getSelected()) {
			oRm.writeAttribute("checked", "checked");
		}

		if (oCheckBox.getName()) {
			oRm.writeAttributeEscaped('name', oCheckBox.getName());
		}

		if (!bEnabled) {
			oRm.write(" disabled=\"disabled\"");
		}

		if (!bEditable) {
			oRm.write(" readonly=\"readonly\"");
		}

		oRm.write(" /></div>");
		oRm.renderControl(oCheckBox._oLabel);
		oRm.write("</div>");
	};


	return CheckBoxRenderer;

}, /* bExport= */ true);

}; // end of sap/m/CheckBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.DialogRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.DialogRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/DialogRenderer",['jquery.sap.global', './BarRenderer'],
	function(jQuery, BarRenderer) {
	"use strict";


	/**
	 * Dialog renderer.
	 *
	 * @namespace
	 */
	var DialogRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	DialogRenderer.render = function(oRm, oControl) {
		var id = oControl.getId(),
			sType = oControl.getType(),
			oHeader = oControl._getAnyHeader(),
			oSubHeader = oControl.getSubHeader(),
			bMessage = (sType === sap.m.DialogType.Message),
			oLeftButton = oControl.getBeginButton(),
			oRightButton = oControl.getEndButton(),
			bHorizontalScrolling = oControl.getHorizontalScrolling(),
			bVerticalScrolling = oControl.getVerticalScrolling(),
			sState = oControl.getState();

		if (oHeader) {
			oHeader.applyTagAndContextClassFor("header");
		}

		if (oSubHeader) {
			oSubHeader.applyTagAndContextClassFor("subheader");
		}

		// write the HTML into the render manager
		// the initial size of the dialog have to be 0, because if there is a large dialog content the initial size can be larger then the html's height (scroller)
		// The scroller will make the initial window width smaller and in the next recalculation the maxWidth will be larger.
		var initialSmallSize = oControl.getStretch() ? '' : 'max-height: auto; max-width: auto;';
		var initialWidth =  oControl.getContentWidth() ? ' width: ' + oControl.getContentWidth() + ';' : '';
		var initialHeight = oControl.getContentHeight() ? ' height: ' +  oControl.getContentHeight() + ';' : '';
		var initialStyles = "style='" + initialSmallSize + initialWidth + initialHeight + "'";

		oRm.write('<div ' + initialStyles);
		oRm.writeControlData(oControl);
		oRm.addClass("sapMDialog");
		oRm.addClass("sapMDialog-CTX");
		oRm.addClass("sapMPopup-CTX");
		oRm.addClass(sap.m.Dialog._mStateClasses[sState]);

		// ARIA
		if (sState === "Error" || sState === "Warning") {
			oRm.writeAccessibilityState(oControl, {
				role: "alertdialog"
			});
		} else {
			oRm.writeAccessibilityState(oControl, {
				role: "dialog"
			});
		}

		if (oHeader !== null && oHeader !== undefined) {
			oRm.writeAccessibilityState(oControl, {
				labelledby: oHeader.getId()
			});
		}

		if (oControl._forceDisableScrolling) {
			oRm.addClass("sapMDialogWithScrollCont");
		}

		if (oSubHeader) {
			oRm.addClass("sapMDialogWithSubHeader");
		}

		if (bMessage) {
			oRm.addClass("sapMMessageDialog");
		}

		if (!bVerticalScrolling) {
			oRm.addClass("sapMDialogVerScrollDisabled");
		}

		if (!bHorizontalScrolling) {
			oRm.addClass("sapMDialogHorScrollDisabled");
		}

		if (sap.ui.Device.system.phone) {
			oRm.addClass("sapMDialogPhone");
		}

		// test dialog with sap-ui-xx-formfactor=compact
		if (sap.m._bSizeCompact) {
			oRm.addClass("sapUiSizeCompact");
		}

		oRm.writeClasses();

		var sTooltip = oControl.getTooltip_AsString();

		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}

		oRm.writeAttribute("tabindex", "-1");

		oRm.write(">");

		if (sap.ui.Device.system.desktop) {

			// Invisible element which is used to determine when desktop keyboard navigation
			// has reached the first focusable element of a dialog and went beyond. In that case, the controller
			// will focus the last focusable element.
			oRm.write('<span id="' + oControl.getId() + '-firstfe" tabindex="0"/>');
		}

		if (oHeader) {
			oRm.renderControl(oHeader);
		}

		if (oSubHeader) {
			oRm.renderControl(oSubHeader.addStyleClass("sapMDialogSubHeader"));
		}

		oRm.write('<section id="' + id + '-cont" style="width:' + oControl.getContentWidth() + '" class="sapMDialogSection">');
		oRm.write('<div id="' + id + '-scroll" class="sapMDialogScroll">');
		oRm.write('<div id="' + id + '-scrollCont" class="sapMDialogScrollCont">');

		var aContent = oControl.getContent();

		for (var i = 0; i < aContent.length; i++) {
			oRm.renderControl(aContent[i]);
		}

		oRm.write("</div>");
		oRm.write("</div>");
		oRm.write("</section>");

		if (oControl._oToolbar && oControl._oToolbar.getContent().length > 1) {
			oRm.renderControl(oControl._oToolbar);
		} else if (oLeftButton || oRightButton) {
			oRm.write('<footer id="' + id + '-footer" class="sapMDialogActions sapMBar-CTX sapMFooter-CTX sapMIBar-CTX">');
			// Render actions
			if (oLeftButton) {
				oRm.write('<div class="sapMDialogAction">');
				oRm.renderControl(oLeftButton.addStyleClass("sapMDialogBtn", true));
				oRm.write("</div>");
			}

			if (oRightButton) {
				oRm.write('<div class="sapMDialogAction">');
				oRm.renderControl(oRightButton.addStyleClass("sapMDialogBtn", true));
				oRm.write("</div>");
			}

			oRm.write("</footer>");
		}

		if (sap.ui.Device.system.desktop) {

			// Invisible element which is used to determine when desktop keyboard navigation
			// has reached the last focusable element of a dialog and went beyond. In that case, the controller
			// will focus the first focusable element.
			oRm.write('<span id="' + oControl.getId() + '-lastfe" tabindex="0"/>');
		}

		oRm.write("</div>");
	};


	return DialogRenderer;

}, /* bExport= */ true);

}; // end of sap/m/DialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FacetFilterRenderer') ) {
/*
* @copyright
*/

jQuery.sap.declare('sap.m.FacetFilterRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/FacetFilterRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * FacetFilter renderer. 
	 * @namespace
	 */
	var FacetFilterRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FacetFilterRenderer.render = function(oRm, oControl){
		switch (oControl.getType()) {
	
		case sap.m.FacetFilterType.Simple:
			FacetFilterRenderer.renderSimpleFlow(oRm, oControl);
			break;
	
		case sap.m.FacetFilterType.Light:
			FacetFilterRenderer.renderSummaryBar(oRm, oControl);
			break;
		}
	};
	
	/**
	 * 
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FacetFilterRenderer.renderSimpleFlow = function(oRm, oControl) {
		
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMFF");
		
		if (oControl.getShowSummaryBar()) {
			
			oRm.write(">");
			FacetFilterRenderer.renderSummaryBar(oRm, oControl);
		} else {
			
			if (oControl._lastScrolling) {
				
				oRm.addClass("sapMFFScrolling");
			} else {
				
				oRm.addClass("sapMFFNoScrolling");
			}
			
			if (oControl.getShowReset()) {
				
				oRm.addClass("sapMFFResetSpacer");
			}
			oRm.writeClasses();
			oRm.write(">");
			
			
			if (sap.ui.Device.system.desktop) {
				oRm.renderControl(oControl._getScrollingArrow("left"));
			}
/*			// dummy after focusable area.
			oRm.write("<div tabindex='-1'");
			oRm.writeAttribute("id", oControl.getId() + "-before");
			oRm.write("></div>");*/
			// Render the div for the carousel
			oRm.write("<div");
			oRm.writeAttribute("id", oControl.getId() + "-head");
			oRm.addClass("sapMFFHead");
			oRm.writeClasses();
			oRm.write(">");
			
			var aLists = oControl._getSequencedLists();
			for (var i = 0; i < aLists.length; i++) {
				
				oRm.renderControl(oControl._getButtonForList(aLists[i]));
				if (oControl.getShowPersonalization()) {
					
					oRm.renderControl(oControl._getFacetRemoveIcon(aLists[i]));
				}
			}
			
			if (oControl.getShowPersonalization()) {
				oRm.renderControl(oControl.getAggregation("addFacetButton"));
			}
			oRm.write("</div>"); // Close carousel div
			if (sap.ui.Device.system.desktop) {
				oRm.renderControl(oControl._getScrollingArrow("right"));
			}
			
			if (oControl.getShowReset()) {
				
				oRm.write("<div");
				oRm.addClass("sapMFFResetDiv");
				oRm.writeClasses();
				oRm.write(">");
				oRm.renderControl(oControl.getAggregation("resetButton"));
				oRm.write("</div>");
			}
		}
		oRm.write("</div>");
	};
	
	
	/**
	 * 
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FacetFilterRenderer.renderSummaryBar = function(oRm, oControl) {
	
		// We cannot just render the toolbar without the parent div.  Otherwise it is
		// not possible to switch type from light to simple.
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMFF");
		oRm.writeClasses();
		oRm.write(">");
		var oSummaryBar = oControl.getAggregation("summaryBar");
		oRm.renderControl(oSummaryBar);
		oRm.write("</div>");
	};
	

	return FacetFilterRenderer;

}, /* bExport= */ true);

}; // end of sap/m/FacetFilterRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FeedInputRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.FeedInputRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/FeedInputRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

var FeedInputRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FeedInputRenderer.render = function (oRm, oControl) {
		var sMyId = oControl.getId();

		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMFeedIn");
		if (!oControl.getShowIcon()) {
			oRm.addClass("sapMFeedInNoIcon");
		}
		oRm.writeClasses();
		oRm.write(">");
		if (!!oControl.getShowIcon()) {
			this._addImage(oRm, oControl, sMyId);
		}
		oRm.write('<div id="' + sMyId + '-container"');
		oRm.addClass("sapMFeedInContainer");
		oRm.writeClasses();
		oRm.write(">");
		var oTextArea = oControl._getTextArea();
		oRm.renderControl(oTextArea);
		oRm.renderControl(oControl._getPostButton());
		oRm.write("</div>");
		oRm.write("</div>");
	};

	FeedInputRenderer._addImage = function (oRm, oControl, sMyId) {
		oRm.write('<figure id="' + sMyId + '-figure" class ="sapMFeedInFigure');
		if (!!oControl.getIcon()) {
				oRm.write('">');
			} else {
				oRm.write(' sapMFeedListItemIsDefaultIcon">');
			}
		oRm.renderControl(oControl._getImageControl());
		oRm.write('</figure>');
	};

	return FeedInputRenderer;

}, /* bExport= */ true);
}; // end of sap/m/FeedInputRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FlexBoxCssPropertyMap') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.FlexBoxCssPropertyMap'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/FlexBoxCssPropertyMap",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	var FlexBoxCssPropertyMap = {
		'spec0907': {
			'display': {
				'flex': {
					'display': 'box'
				},
				'inline-flex': {
					'display': 'inline-box'
				}
			},
			'flex-direction': {
				'row': {
					'box-orient': 'horizontal',
					'box-direction': 'normal'
				},
				'row-reverse': {
					'box-orient': 'horizontal',
					'box-direction': 'reverse'
				},
				'column': {
					'box-orient': 'vertical',
					'box-direction': 'normal'
				},
				'column-reverse': {
					'box-orient': 'vertical',
					'box-direction': 'reverse'
				}
			},
			'flex-wrap': {
				'no-wrap': {
					'box-lines': 'single'
				},
				'wrap': {
					'box-lines': 'multiple'
				},
				'wrap-reverse': null
			},
			'flex-flow': null,
			'order': {
				'<number>': {
					'box-ordinal-group': '<integer>'
				}
			},
			'flex-grow': {
				'<number>': {
					'box-flex': '<number>'
				}
			},
			'flex-shrink': null,
			'flex-basis': null,
			'flex': {
				'[flex-grow] | [flex-shrink] | [flex-basis]': {
					'box-flex': '[flex-grow]'
				}
			},
			'justify-content': {
				'flex-start': {
					'box-pack': 'start'
				},
				'flex-end': {
					'box-pack': 'end'
				},
				'center': {
					'box-pack': 'center'
				},
				'space-between': {
					'box-pack': 'justify'
				},
				'space-around': null
			},
			'align-items': {
				'flex-start': {
					'box-align': 'start'
				},
				'flex-end':{
					'box-align': 'end'
				},
				'center': {
					'box-align': 'center'
				},
				'baseline': {
					'box-align': 'baseline'
				},
				'stretch': {
					'box-align': 'stretch'
				}
			},
			'align-self': null,
			'align-content': null
		},
		'specie10': {
			'display': {
				'flex': {
					'display': 'flexbox'
				},
				'inline-flex': {
					'display': 'inline-flexbox'
				}
			},
			'flex-direction': {
				'row': {
					'flex-direction': 'row'
				},
				'row-reverse': {
					'flex-direction': 'row-reverse'
				},
				'column': {
					'flex-direction': 'column'
				},
				'column-reverse': {
					'flex-direction': 'column-reverse'
				}
			},
			'flex-wrap': {
				'no-wrap': {
					'flex-wrap': 'none'
				},
				'wrap': {
					'flex-wrap': 'wrap'
				},
				'wrap-reverse': 'wrap-reverse'
			},
			'flex-flow': null,
			'order': {
				'<number>': {
					'flex-order': '<integer>'
				}
			},
			'flex-grow': {
				'<number>': {
					'flex-positive': '<number>',
					'flex-preferred-size': 'auto'
				}
			},
			'flex-shrink': {
				'<number>': {
					'flex-negative': '<number>'
				}
			},
			'flex-basis': {
				'<number>': {
					'flex-preferred-size': '<number>'
				}
			},
			'flex': {
				'[flex-grow] | [flex-shrink] | [flex-basis]': {
					'flex': '[flex-grow] | [flex-shrink] | [flex-basis]'
				}
			},
			'justify-content': {
				'flex-start': {
					'flex-pack': 'start'
				},
				'flex-end': {
					'flex-pack': 'end'
				},
				'center': {
					'flex-pack': 'center'
				},
				'space-between': {
					'flex-pack': 'justify'
				},
				'space-around': null
			},
			'align-items': {
				'flex-start': {
					'flex-align': 'start'
				},
				'flex-end':{
					'flex-align': 'end'
				},
				'center': {
					'flex-align': 'center'
				},
				'baseline': {
					'flex-align': 'baseline'
				},
				'stretch': {
					'flex-align': 'stretch'
				}
			},
			'align-self': null,
			'align-content': null
		}
	};

	return FlexBoxCssPropertyMap;

}, /* bExport= */ true);

}; // end of sap/m/FlexBoxCssPropertyMap.js
if ( !jQuery.sap.isDeclared('sap.m.FlexBoxStylingHelper') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.FlexBoxStylingHelper'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/FlexBoxStylingHelper",['jquery.sap.global', './FlexBoxCssPropertyMap'],
	function(jQuery, FlexBoxCssPropertyMap) {
	"use strict";

	if (jQuery.support.useFlexBoxPolyfill) {
		// TODO: how to properly handle conditional requires with sap.ui.define?
		jQuery.sap.require("sap.ui.thirdparty.flexie");
	}

	/**
	 * FlexBox styling helper
	 * @namespace
	 */
	var FlexBoxStylingHelper = {};
	
	/**
	 * Goes through applicable styles and calls function to sets them on the given control.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FlexBoxStylingHelper.setFlexBoxStyles = function(oRm, oControl) {
		var sDisplay;
	
		// Prepare values by converting camel-case to dash and lower-casing
		var bInline = oControl.getDisplayInline();
		var sDirection = oControl.getDirection().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
		var bFitContainer = oControl.getFitContainer();
		var sJustifyContent = oControl.getJustifyContent().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
		var sAlignItems = oControl.getAlignItems().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
	
		if (bInline) {
			sDisplay = "inline-flex";
		} else {
			sDisplay = "flex";
		}
	
		// Set width and height for outermost FlexBox only if FitContainer is set
		if (bFitContainer && !(oControl.getParent() instanceof sap.m.FlexBox)) {
			oRm.addStyle("width", "auto");
			oRm.addStyle("height", "100%");
		}
	
		// Add flex prefix to start and end values
		if (sJustifyContent === "start" || sJustifyContent === "end") {
			sJustifyContent = "flex-" + sJustifyContent;
		}
	
		if (sAlignItems === "start" || sAlignItems === "end") {
			sAlignItems = "flex-" + sAlignItems;
		}
	
		// Set values (if different from default)
		FlexBoxStylingHelper.setStyle(oRm, oControl, "display", sDisplay);
		if (sDirection !== "row") {
			FlexBoxStylingHelper.setStyle(oRm, oControl, "flex-direction", sDirection);
		}
	
		if (sJustifyContent !== "flex-start") {
			FlexBoxStylingHelper.setStyle(oRm, oControl, "justify-content", sJustifyContent);
		}
		if (sAlignItems !== "stretch") {
			FlexBoxStylingHelper.setStyle(oRm, oControl, "align-items", sAlignItems);
		}
	//	if(jQuery.support.newFlexBoxLayout) {
	//		var sWrap = oControl.getWrap().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
	//		var sAlignContent = oControl.getAlignContent().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
	//
	//		if(sWrap !== "nowrap") {
	//			sap.m.FlexBoxStylingHelper.setStyle(oRm, oControl, "flex-wrap", sWrap);
	//		}
	//		if(sAlignContent === "start" || sAlignContent === "end") {
	//			sAlignContent = "flex-" + sAlignContent;
	//		}
	//		if(sAlignContent !== "stretch") {
	//			sap.m.FlexBoxStylingHelper.setStyle(oRm, oControl, "align-content", sAlignContent);
	//		}
	//	}
	};
	
	/**
	 * Goes through applicable item styles and sets them on the given control.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.FlexItemData} oLayoutData an object representation of the layout data
	 */
	FlexBoxStylingHelper.setFlexItemStyles = function(oRm, oLayoutData) {
		// Set values if different from default
		var order = oLayoutData.getOrder();
		if (order) {
			FlexBoxStylingHelper.setStyle(oRm, null, "order", order);
		}
	
		var growFactor = oLayoutData.getGrowFactor();
		if (growFactor !== undefined) {
			FlexBoxStylingHelper.setStyle(oRm, null, "flex-grow", growFactor);
		}
	
		var alignSelf = oLayoutData.getAlignSelf().toLowerCase();
	
		// Add flex prefix to start and end values to create CSS value
		if (alignSelf === "start" || alignSelf === "end") {
			alignSelf = "flex-" + alignSelf;
		}
	
		if (alignSelf && alignSelf !== "auto") {
			FlexBoxStylingHelper.setStyle(oRm, null, "align-self", alignSelf);
		}
	
		if (jQuery.support.newFlexBoxLayout) {
			var shrinkFactor = oLayoutData.getShrinkFactor();
			if (shrinkFactor !== 1) {
				FlexBoxStylingHelper.setStyle(oRm, null, "flex-shrink", shrinkFactor);
			}
	
	//		var baseSize = oLayoutData.getBaseSize().toLowerCase();
	//		if(baseSize !== undefined) {
	//			sap.m.FlexBoxStylingHelper.setStyle(oRm, null, "flex-basis", baseSize);
	//		}
		}
	};
	
	/**
	 * Sets style (including fall-back styles) to the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * This method does NOT apply a polyfill in browsers that don't support flex box natively.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 * @param sProperty name of the property
	 * @param sValue value of the property
	 */
	FlexBoxStylingHelper.setStyle = function(oRm, oControl, sProperty, sValue) {
		if (typeof (sValue) === "string") {
			sValue = sValue.toLowerCase();
		}
	
		// Determine vendor prefix
		var sVendorPrefix = "";
	
		if (jQuery.support.flexBoxPrefixed) {
			if (sap.ui.Device.browser.webkit) {
				sVendorPrefix = "-webkit-";
			} else if (jQuery.browser.mozilla) {
				sVendorPrefix = "-moz-";
			} else if (sap.ui.Device.browser.internet_explorer) {
				sVendorPrefix = "-ms-";
			}
		}
	
		// Choose flex box styling method
		if (jQuery.support.newFlexBoxLayout) {
			// New spec
			FlexBoxStylingHelper.setFinalSpecStyle(oRm, oControl, sProperty, sValue, sVendorPrefix);
		} else if (jQuery.support.flexBoxLayout || jQuery.support.ie10FlexBoxLayout) {
			// Old spec
			FlexBoxStylingHelper.setOldSpecStyle(oRm, oControl, sProperty, sValue, sVendorPrefix);
		}
	};
	
	/**
	 * Sets style for the FINAL flex box spec to the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 * @param sProperty name of the property
	 * @param sValue value of the property
	 * @param sVendorPrefix vendor prefix
	 */
	FlexBoxStylingHelper.setFinalSpecStyle = function(oRm, oControl, sProperty, sValue, sVendorPrefix) {
		if (jQuery.support.flexBoxPrefixed) {
			// With vendor prefix
			FlexBoxStylingHelper.writeStyle(oRm, oControl, sProperty, sValue, sVendorPrefix);
		}
	
		// Pure standard
		FlexBoxStylingHelper.writeStyle(oRm, oControl, sProperty, sValue);
	};
	
	/**
	 * Sets style for the OLD or the IE10 flex box spec to the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 * @param sProperty name of the property
	 * @param sValue value of the property
	 * @param sVendorPrefix vendor prefix
	 */
	FlexBoxStylingHelper.setOldSpecStyle = function(oRm, oControl, sProperty, sValue, sVendorPrefix) {
		// Choose specification
		var sSpec = "";
		if (sVendorPrefix == "-ms-") {
			sSpec = "specie10"; // IE10 specification
		} else {
			sSpec = "spec0907";	// old specification
		}
	
		// Nothing to do if final standard is supported or property doesn't exist in this spec or is the same as standard
		// Else map to old property
		if (FlexBoxCssPropertyMap[sSpec][sProperty] !== null && FlexBoxCssPropertyMap[sSpec][sProperty] !== "<idem>") {
			// Prepare mapped properties and values
			var mLegacyMap = null;
			if (typeof (FlexBoxCssPropertyMap[sSpec][sProperty]) === "object") {
				if (FlexBoxCssPropertyMap[sSpec][sProperty]["<number>"]) {
					mLegacyMap = {};
					for (var key in FlexBoxCssPropertyMap[sSpec][sProperty]["<number>"]) {
						// Check if the target is also a number, otherwise assume it's a literal
						if (FlexBoxCssPropertyMap[sSpec][sProperty]["<number>"][key] === "<number>") {
							mLegacyMap[key] = sValue;
						} else {
							mLegacyMap[key] = FlexBoxCssPropertyMap[sSpec][sProperty]["<number>"][key];
						}
					}
				} else {
					mLegacyMap = FlexBoxCssPropertyMap[sSpec][sProperty][sValue];
				}
			} else {
				mLegacyMap = FlexBoxCssPropertyMap[sSpec][sProperty][sValue];
			}
	
			// Nothing to do if value doesn't exist or is the same as standard
			if (mLegacyMap !== null && mLegacyMap !== "<idem>") {
				if (typeof (mLegacyMap) === "object") {
					for (var sLegacyProperty in mLegacyMap) {
						// Write property/value to control
						FlexBoxStylingHelper.writeStyle(oRm, oControl, sLegacyProperty, mLegacyMap[sLegacyProperty], sVendorPrefix);
					}
				}
			}
		}
	};
	
	/**
	 * Writes the style to the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 * @param sProperty name of the property
	 * @param sValue value of the property
	 * @param sVendorPrefix vendor prefix
	 */
	FlexBoxStylingHelper.writeStyle = function(oRm, oControl, sProperty, sValue, sVendorPrefix) {
		var sPropertyPrefix = "";
		var sValuePrefix = "";
		sVendorPrefix = typeof sVendorPrefix !== "undefined" ? sVendorPrefix : "";	// default: empty string
	
		// Set prefix to value for display property
		// As display is a long-standing standard property the values are vendor-prefixed instead of the property name
		if (sProperty !== "display") {
			sPropertyPrefix = sVendorPrefix;
		} else {
			sValuePrefix = sVendorPrefix;
		}
	
		// Finally write property value to control using either renderer or element directly
		if (oRm) {
			oRm.addStyle(sPropertyPrefix + sProperty, sValuePrefix + sValue);
		} else {
			jQuery(oControl).css(sPropertyPrefix + sProperty, sValuePrefix + sValue);
		}
	};
	
	/**
	 * Applies flex box polyfill styling to the given DOM element and its children (if polyfill is being used at all)
	 *
	 * @param sId DOM ID of the control that should be turned into a flex box
	 * @param oSettings object holding the flex box settings
	 */
	FlexBoxStylingHelper.applyFlexBoxPolyfill = function(sId, oSettings) {
		// Return if polyfill is not being used
		if (!jQuery.support.useFlexBoxPolyfill) {
			jQuery.sap.log.warning("FlexBox Polyfill is not being used");
			return;
		}
		var justifyContent = {
			Start: "start",
			Center: "center",
			End: "end",
			SpaceBetween : "justify"
		};
		var alignItems = {
			Start: "start",
			Center: "center",
			End: "end",
			Stretch : "stretch"
		};
		
		var orient = "";
		var direction = "";
		
		switch (oSettings.direction) {
			case "Column" :
				orient = "vertical";
				direction = "normal";
				break;
			case "RowReverse" :
				orient = "horizontal";
				direction = "reverse";
				break;
			case "ColumnReverse" :
				orient = "vertical";
				direction = "reverse";
				break;
			case "Row" :
			default:
				orient = "horizontal";
				direction = "normal";
		}
	
		var box = new window.Flexie.box({
			target : document.getElementById(sId),
			orient : orient,
			align : alignItems[oSettings.alignItems],
			direction : direction,
			pack : justifyContent[oSettings.justifyContent],
			flexMatrix : oSettings.flexMatrix,
			ordinalMatrix : oSettings.ordinalMatrix,
		    dynamic: true
		});
		
		return box;
	};

	return FlexBoxStylingHelper;

}, /* bExport= */ true);

}; // end of sap/m/FlexBoxStylingHelper.js
if ( !jQuery.sap.isDeclared('sap.m.GrowingEnablement') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.m.GrowingEnablement
jQuery.sap.declare('sap.m.GrowingEnablement'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.Object'); // unlisted dependency retained
sap.ui.define("sap/m/GrowingEnablement",['jquery.sap.global', 'sap/ui/base/Object'],
	function(jQuery, BaseObject) {
	"use strict";


	/**
	 * Creates a GrowingEnablement delegate that can be attached to ListBase Controls requiring capabilities for growing
	 *
	 * @extends sap.ui.base.Object
	 * @alias sap.m.GrowingEnablement
	 * @experimental Since 1.16. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 *
	 * @param {sap.m.ListBase} oControl the ListBase control of which this Growing is the delegate
	 *
	 * @constructor
	 * @protected
	 */
	var GrowingEnablement = BaseObject.extend("sap.m.GrowingEnablement", /** @lends sap.m.GrowingEnablement.prototype */ {

		constructor : function(oControl) {
			BaseObject.apply(this);
			this._oControl = oControl;
			this._oControl.bUseExtendedChangeDetection = true;
			this._oControl.addDelegate(this);

			/* init growing list */
			var iRenderedItemsLength = this._oControl.getItems().length;
			this._iRenderedDataItems = iRenderedItemsLength;
			this._iItemCount = iRenderedItemsLength;
			this._bRebuilding = false;
			this._fnRebuildQ = null;
			this._bLoading = false;
			this._sGroupingPath = "";
			this._bDataRequested = false;
		},

		/**
		 * Destroys this GrowingEnablement delegate.
		 * This function must be called by the control which uses this delegate in the <code>exit</code> function.
		 */
		destroy : function() {
			if (this._oBusyIndicator) {
				this._oBusyIndicator.destroy();
				delete this._oBusyIndicator;
			}
			if (this._oTrigger) {
				this._oTrigger.destroy();
				delete this._oTrigger;
			}
			if (this._oLoading) {
				this._oLoading.destroy();
				delete this._oLoading;
			}
			if (this._oScrollDelegate) {
				this._oScrollDelegate.setGrowingList(null);
				this._oScrollDelegate = null;
			}

			jQuery(this._oControl.getId() + "-triggerList").remove();
			this._oControl.bUseExtendedChangeDetection = false;
			this._oControl.removeDelegate(this);
			this._sGroupingPath = "";
			this._bLoading = false;
			this._oControl = null;
		},

		/**
		 * Renders loading indicator or load more trigger
		 */
		render : function(rm) {
			var bHasScrollToLoadAndScrollbars = this._oControl.getGrowingScrollToLoad() && this._getHasScrollbars();

			rm.write("<ul id='" + this._oControl.getId() + "-triggerList'");

			if (bHasScrollToLoadAndScrollbars) {
				rm.addStyle("display", "none");
				rm.writeStyles();
			}

			// no header or footer no div
			rm.addClass("sapMListUl");
			rm.addClass("sapMGrowingList");
			if (this._oControl.setBackgroundDesign) {
				rm.addClass("sapMListBG" + this._oControl.getBackgroundDesign());
			}

			if (this._oControl.getInset()) {
				rm.addClass("sapMListInset");
			}
			rm.writeClasses();
			rm.write(">");

			var oActionItem;
			if (bHasScrollToLoadAndScrollbars) {
				this._showsLoading = true;
				oActionItem = this._getLoading(this._oControl.getId() + "-loading");
			} else {
				this._showsTrigger = true;
				oActionItem = this._getTrigger(this._oControl.getId() + "-trigger");
			}

			// this variable is needed to render loading indicator in list even in table mode
			oActionItem._renderInList = true;
			rm.renderControl(oActionItem);
			rm.write("</ul>");
		},

		/**
		 * Called after rendering phase of the given control
		 */
		onAfterRendering : function() {
			if (this._oControl.getGrowingScrollToLoad()) {
				var oScrollDelegate = sap.m.getScrollDelegate(this._oControl);
				if (oScrollDelegate) {
					this._oScrollDelegate = oScrollDelegate;
					oScrollDelegate.setGrowingList(this._oControl, jQuery.proxy(this._triggerLoadingByScroll, this));
				}
			} else if (this._oScrollDelegate) {
				this._oScrollDelegate.setGrowingList(null);

				this._oScrollDelegate = null;
			}

			this._updateTrigger();
		},

		setTriggerText : function(sText) {
			if (this._oTrigger) {
				this._oTrigger.$().find(".sapMSLITitle").text(sText);
			}
		},

		// call to reset paging
		reset : function() {
			this._iItemCount = 0;
		},

		// determines growing reset with binding change reason
		// according to UX sort/filter/context should reset the growing
		shouldReset : function(sChangeReason) {
			var mChangeReason = sap.ui.model.ChangeReason;

			return 	sChangeReason == mChangeReason.Sort ||
					sChangeReason == mChangeReason.Filter ||
					sChangeReason == mChangeReason.Context;
		},

		// get actual and total info
		getInfo : function() {
			return {
				total : this._oControl.getMaxItemsCount(),
				actual : this._iRenderedDataItems
			};
		},

		// call to request new page
		requestNewPage : function(oEvent) {
			// if max item count not reached
			if (this._oControl && !this._bLoading && this._iItemCount < this._oControl.getMaxItemsCount()) {
				this._showIndicator();
				this._iItemCount += this._oControl.getGrowingThreshold();
				this.updateItems("Growing");
			}
		},

		// called before new page loaded
		_onBeforePageLoaded : function(sChangeReason) {
			this._bLoading = true;
			this._oControl.onBeforePageLoaded(this.getInfo(), sChangeReason);
		},

		// called after new page loaded
		_onAfterPageLoaded : function(sChangeReason) {
			this._hideIndicator();
			this._updateTrigger();
			this._bLoading = false;
			this._oControl.onAfterPageLoaded(this.getInfo(), sChangeReason);
		},

		/**
		 *
		 * this._oRenderManager is optionally used if defined in order to improve performance. It indicates a state where multiple items can be subsequently rendered.
		 * If this._oRenderManager is defined, it is the responsibility of the caller to flush and destroy the RenderManager after the last call.
		 */
		_renderItemIntoContainer : function(oItem, bDoNotPreserve, vInsert, oDomRef) {
			oDomRef = oDomRef || this._oContainerDomRef;
			if (oDomRef) {
				var rm = this._oRenderManager || sap.ui.getCore().createRenderManager();
				rm.renderControl(oItem);
				if (!this._oRenderManager) {
					rm.flush(oDomRef, bDoNotPreserve, vInsert);
					rm.destroy();
				}
			}
		},

		_getBusyIndicator : function() {
			return this._oBusyIndicator || (this._oBusyIndicator = new sap.m.BusyIndicator({
				size : "2.0em"
			}));
		},

		/**
		 * returns loading indicator
		 */
		_getLoading : function(sId) {
			var that = this;
			
			if (this._oLoading) {
				return this._oLoading;
			}
			
			this._oLoading = new sap.m.CustomListItem({
				id : sId,
				content : new sap.ui.core.HTML({
					content :	"<div class='sapMSLIDiv sapMGrowingListLoading'>" +
									"<div class='sapMGrowingListBusyIndicator' id='" + sId + "-busyIndicator'></div>" +
								"</div>",
					afterRendering : function(e) {
						var oBusyIndicator = that._getBusyIndicator();
						var rm = sap.ui.getCore().createRenderManager();
						rm.render(oBusyIndicator, this.getDomRef().firstChild);
						rm.destroy();
					}
				})
			}).setParent(this._oControl, null, true);
			
			// growing loading indicator as a list item should not be affected from the List Mode
			this._oLoading.getMode = function() {
				return sap.m.ListMode.None;
			};
			
			return this._oLoading;
		},

		/**
		 * returns load more trigger
		 */
		_getTrigger : function(sId) {
			var that = this;

			var sTriggerText = sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");
			if (this._oControl.getGrowingTriggerText()) {
				sTriggerText = this._oControl.getGrowingTriggerText();
			}

			this._oControl.addNavSection(sId);
			
			if (this._oTrigger) {
				return this._oTrigger;
			}

			this._oTrigger = new sap.m.CustomListItem({
				id : sId,
				content : new sap.ui.core.HTML({
					content :	"<div class='sapMGrowingListTrigger'>" +
									"<div class='sapMGrowingListBusyIndicator' id='" + sId + "-busyIndicator'></div>" +
									"<div class='sapMSLITitleDiv sapMGrowingListTitel'>" +
										"<h1 class='sapMSLITitle'>" + jQuery.sap.encodeHTML(sTriggerText) + "</h1>" +
									"</div>" +
									"<div class='sapMGrowingListDescription'>" +
										"<div class='sapMSLIDescription' id='" + sId + "-itemInfo'>" + that._getListItemInfo() + "</div>" +
									"</div>" +
								"</div>",
					afterRendering : function(e) {
						var oBusyIndicator = that._getBusyIndicator();
						var rm = sap.ui.getCore().createRenderManager();
						rm.render(oBusyIndicator, this.getDomRef().firstChild);
						rm.destroy();
					}
				}),
				type : sap.m.ListType.Active
			}).setParent(this._oControl, null, true).attachPress(this.requestNewPage, this).addEventDelegate({
				onsapenter : function(oEvent) {
					this.requestNewPage();
					oEvent.preventDefault();
				},
				onsapspace : function(oEvent) {
					this.requestNewPage(oEvent);
					oEvent.preventDefault();
				},
				onAfterRendering : function(oEvent) {
					this._oTrigger.$().prop("tabindex", 0);
				}
			}, this);
			
			// growing button as a list item should not be affected from the List Mode
			this._oTrigger.getMode = function() {
				return sap.m.ListMode.None;
			};
			
			return this._oTrigger;
		},

		/**
		 * Returns the information about the list items.
		 * -> how many items are displayed
		 * -> maximum items to be displayed
		 */
		_getListItemInfo : function() {
			return ("[ " + this._iRenderedDataItems + " / " + this._oControl.getMaxItemsCount() + " ]");
		},

		/**
		 * Only call when grouped
		 */
		_getGroupForContext : function(oContext) {
			// TODO: we should document that group header depends on the first sorter
			var oNewGroup = this._oControl.getBinding("items").aSorters[0].fnGroup(oContext);
			if (typeof oNewGroup == "string") {
				oNewGroup = {
					key: oNewGroup
				};
			}
			return oNewGroup;
		},

		/**
		 * returns the first sorters grouping path when available
		 */
		_getGroupingPath : function(oBinding) {
			oBinding = oBinding || this._oControl.getBinding("items") || {};
			var aSorters = oBinding.aSorters || [];
			var oSorter = aSorters[0] || {};
			if (oSorter.fnGroup) {
				return oSorter.sPath;
			}
			return "";
		},

		/**
		 * If table has pop-in then we have two rows for one item
		 * So this method finds the correct DOM position to insert item
		 * This function should not be called within insertItem
		 */
		_getDomIndex : function(iIndex) {
			if (this._oControl.hasPopin && this._oControl.hasPopin()) {
				iIndex *= 2;
			}
			return iIndex;
		},

		/**
		 * Checks if the Scrollcontainer of the list has scrollbars
		 * @returns {Boolean}
		 */
		_getHasScrollbars : function() {
			//the containter height is needed because it gets hidden if there are scrollbars and this might lead to the list not having scrollbars again
			return this._oScrollDelegate && this._oScrollDelegate.getMaxScrollTop() > this._oControl.$("triggerList").height();
		},

		/**
		 * function is called to destroy all items in list
		 */
		destroyListItems : function() {
			this._oControl.destroyAggregation("items");
			this._iRenderedDataItems = 0;
		},

		/**
		 * function is called to add single list item or row
		 */
		addListItem : function(oItem, bSuppressInvalidate) {
			this._iRenderedDataItems++;

			// Grouping support
			var oBinding = this._oControl.getBinding("items"),
				oBindingInfo = this._oControl.getBindingInfo("items");

			if (oBinding.isGrouped() && oBindingInfo) {
				var bNewGroup = false,
					aItems = this._oControl.getItems(),
					sModelName = oBindingInfo.model || undefined,
					oNewGroup = this._getGroupForContext(oItem.getBindingContext(sModelName));

				if (aItems.length == 0) {
					bNewGroup = true;
				} else if (oNewGroup.key !== this._getGroupForContext(aItems[aItems.length - 1].getBindingContext(sModelName)).key) {
					bNewGroup = true;
				}

				if (bNewGroup) {
					var oGroupHeader = null;
					if (oBindingInfo.groupHeaderFactory) {
						oGroupHeader = oBindingInfo.groupHeaderFactory(oNewGroup);
					}
					this.addItemGroup(oNewGroup, oGroupHeader, bSuppressInvalidate);
				}
			}

			this._oControl.addAggregation("items", oItem, bSuppressInvalidate);
			if (bSuppressInvalidate) {
				this._renderItemIntoContainer(oItem, false, true);
			}
			return this;
		},

		/**
		 * function is called to add multiple items
		 */
		addListItems : function(aContexts, oBindingInfo, bSuppressInvalidate) {
			if (oBindingInfo && aContexts) {
				for (var i = 0, l = aContexts.length; i < l; i++) {
					var oClone = oBindingInfo.factory("", aContexts[i]);
					oClone.setBindingContext(aContexts[i], oBindingInfo.model);
					this.addListItem(oClone, bSuppressInvalidate);
				}
			}
		},

		/**
		 * destroy all list items and then insert
		 * this function take care async calls during the insertion
		 */
		rebuildListItems : function(aContexts, oBindingInfo, bSuppressInvalidate) {
			// check if building already started
			if (this._bRebuilding) {
				this._fnRebuildQ = jQuery.proxy(this, "rebuildListItems", aContexts, oBindingInfo, bSuppressInvalidate);
				return;
			}

			// rebuild list items
			this._bRebuilding = true;
			this.destroyListItems();
			this.addListItems(aContexts, oBindingInfo, bSuppressInvalidate);
			this._bRebuilding = false;

			// check if something is in the queue
			if (this._fnRebuildQ) {
				var fnRebuildQ = this._fnRebuildQ;
				this._fnRebuildQ = null;
				fnRebuildQ();
			}
		},

		/**
		 * adds a new GroupHeaderListItem
		 */
		addItemGroup : function(oGroup, oHeader, bSuppressInvalidate) {
			oHeader = this._oControl.addItemGroup(oGroup, oHeader, true);
			if (bSuppressInvalidate) {
				this._renderItemIntoContainer(oHeader, false, true);
			}
			return this;
		},

		/**
		 * function is called to insert single list item or row.
		 */
		insertListItem : function(oItem, iIndex) {
			this._oControl.insertAggregation("items", oItem, iIndex, true);
			this._iRenderedDataItems++;
			this._renderItemIntoContainer(oItem, false, this._getDomIndex(iIndex));
			return this;
		},

		/**
		 * function is called to remove single list item or row
		 */
		deleteListItem : function(oItem) {
			this._iRenderedDataItems--;
			oItem.destroy(true);
			return this;
		},

		/**
		 * refresh items ... called from oData model.
		 */
		refreshItems : function(sChangeReason) {
			if (!this._bDataRequested) {
				this._bDataRequested = true;
				this._onBeforePageLoaded(sChangeReason);
			}
			
			// set iItemCount to initial value if not set or no items at the control yet
			if (!this._iItemCount || this.shouldReset(sChangeReason) || !this._oControl.getItems(true).length) {
				this._iItemCount = this._oControl.getGrowingThreshold();
			}
			this._oControl.getBinding("items").getContexts(0, this._iItemCount);
		},

		/**
		 * update loaded items ... 2nd time called from oData model.
		 */
		updateItems : function(sChangeReason) {
			var oBindingInfo = this._oControl.getBindingInfo("items"),
				oBinding = oBindingInfo.binding,
				fnFactory = oBindingInfo.factory;

			// set iItemCount to initial value if not set or no items at the control yet
			if (!this._iItemCount || this.shouldReset(sChangeReason) || !this._oControl.getItems().length) {
				this._iItemCount = this._oControl.getGrowingThreshold();
			}

			// fire growing started event
			if (this._bDataRequested) {
				// if data was requested this is a followup call of updateItems, so growing started was fired already
				// and must not be fired again, instead we reset the flag
				this._bDataRequested = false;
			} else {
				this._onBeforePageLoaded(sChangeReason);
			}

			// get the context from binding
			// aContexts.diff ==> undefined : New data we should build from scratch
			// aContexts.diff ==> [] : There is no diff, means data did not changed but maybe it was already grouped and we need to handle group headers
			// aContexts.diff ==> [{index : 0, type: "delete"}, ...] : Run the diff logic
			var aContexts = oBinding ? oBinding.getContexts(0, this._iItemCount) || [] : [];

			// if getContexts did cause a request to be sent, set the internal flag so growing started event is not
			// fired again, when the response of the request is processed.
			if (aContexts.dataRequested) {
				this._bDataRequested = true;
				// a partial response may already be contained, so only return here without updating the list,
				// if no data was changed (diff is empty)
				if (aContexts.diff && aContexts.diff.length == 0) {
					return;
				}
			}

			// cache dom ref for internal functions not to lookup again and again
			this._oContainerDomRef = this._oControl.getItemsContainerDomRef();

			// check control based logic to handle from scratch is required or not
			var bCheckGrowingFromScratch = this._oControl.checkGrowingFromScratch && this._oControl.checkGrowingFromScratch();
			
			// rebuild list from scratch if there were no items and new items needs to be added 
			if (!this._oControl.getItems().length && aContexts.diff && aContexts.diff.length) {
				aContexts.diff = undefined;
			}

			// when data is grouped we insert the sequential items to the end
			// but with diff calculation we may need to create GroupHeaders
			// which can be complicated and we rebuild list from scratch
			if (oBinding.isGrouped() || bCheckGrowingFromScratch) {
				var bFromScratch = true;
				if (aContexts.length > 0) {
					if (this._oContainerDomRef) {
						// check if diff array exists
						if (aContexts.diff) {
							// check if the model diff-array is empty
							if (!aContexts.diff.length) {
								// no diff, we do not need to rebuild list when grouping is not changed
								if (this._sGroupingPath == this._getGroupingPath(oBinding)) {
									bFromScratch = false;
								}
							} else {
								// check the diff array and whether rebuild is required
								bFromScratch = false;
								var bFirstAddedItemChecked = false;
								for (var i = 0, l = aContexts.diff.length; i < l; i++) {
									if (aContexts.diff[i].type === "delete") {
										bFromScratch = true;
										break;
									} else if (aContexts.diff[i].type === "insert") {
										if (!bFirstAddedItemChecked && aContexts.diff[i].index !== this._iRenderedDataItems) {
											bFromScratch = true;
											break;
										}
										bFirstAddedItemChecked = true;
										var oClone = fnFactory("", aContexts[aContexts.diff[i].index]);
										oClone.setBindingContext(aContexts[aContexts.diff[i].index], oBindingInfo.model);
										this.addListItem(oClone, true);
									}
								}
							}
						}
						if (bFromScratch) {
							// renderer available - fill the aggregation and render list items
							this.rebuildListItems(aContexts, oBindingInfo, false);
						}
					} else {
						// no renderer - fill only the aggregation
						this.rebuildListItems(aContexts, oBindingInfo, true);
					}
				} else {
					// no context
					this.destroyListItems();
				}

			} else { // no grouping, stable implementation
				if (aContexts.length > 0) {
					if (this._oContainerDomRef) {
						// check if model diff-array exists and execute
						if (aContexts.diff) {
							// if previously grouped
							if (this._sGroupingPath) {
								// we need to remove all GroupHeaders first
								this._oControl.removeGroupHeaders(true);
							}

							this._oRenderManager = sap.ui.getCore().createRenderManager(); // one shared RenderManager for all the items that need to be rendered

							var aItems, oClone, iIndex, iFlushIndex = -1, iLastIndex = -1;
							for (var i = 0, l = aContexts.diff.length; i < l; i++) {
								iIndex = aContexts.diff[i].index;

								if (aContexts.diff[i].type === "delete") { // case 1: element is removed
									if (iFlushIndex !== -1) {
										this._oRenderManager.flush(this._oContainerDomRef, false, this._getDomIndex(iFlushIndex));
										iFlushIndex = -1;
										iLastIndex = -1;
									}

									aItems = this._oControl.mAggregations["items"]; // access via getItems() copies the array, so direct access... it is only used in the next line to give the item instance, so it's fine
									this.deleteListItem(aItems[iIndex]);
								} else if (aContexts.diff[i].type === "insert") { // case 2: element is added
									oClone = fnFactory("", aContexts[iIndex]);
									oClone.setBindingContext(aContexts[iIndex], oBindingInfo.model);

									// start a new burst of subsequent items
									if (iFlushIndex === -1) {
										iFlushIndex = iIndex; // the subsequent run/burst of items needs to be inserted at this position

									// otherwise check for the end of a burst of subsequent items
									} else if (iLastIndex >= 0 && iIndex !== iLastIndex + 1) { // this item is not simply appended to the last one that has been inserted, so we need to flush what we have so far
										this._oRenderManager.flush(this._oContainerDomRef, false, this._getDomIndex(iFlushIndex));
										iFlushIndex = iIndex;
									}

									this.insertListItem(oClone, iIndex);
									iLastIndex = iIndex;
								}
							}
							// update context on all items after applying diff
							aItems = this._oControl.getItems();
							for (var i = 0, l = aContexts.length; i < l; i++) {
								aItems[i].setBindingContext(aContexts[i], oBindingInfo.model);
							}

							if (iFlushIndex !== -1) {
								this._oRenderManager.flush(this._oContainerDomRef, false, this._getDomIndex(iFlushIndex));
							}
							// clean up the shared RenderManager
							this._oRenderManager.destroy();
							delete this._oRenderManager; // make sure there is no instance anymore

						} else {
							// most likely a new binding is set in this case - therefore remove all items and fill again
							this.rebuildListItems(aContexts, oBindingInfo, false);
						}
					} else {
						// no renderer - fill only the aggregation
						this.rebuildListItems(aContexts, oBindingInfo, true);
					}
				} else {
					// there is no context
					this.destroyListItems();
				}

			}

			// remove dom cache
			this._oContainerDomRef = null;

			// remember the old grouping path
			this._sGroupingPath = this._getGroupingPath(oBinding);

			// if no request is ongoing, trigger growing finished event
			if (!this._bDataRequested) {
				this._onAfterPageLoaded(sChangeReason);
			}
		},

		/**
		 * hide or show loading trigger according to list item count.
		 */
		_updateTrigger : function() {
			// check trigger list DOM first
			var oTriggerListDomRef = document.getElementById(this._oControl.getId() + "-triggerList");
			if (!oTriggerListDomRef) {
				return;
			}

			// hide trigger if no items or maximum of items reached
			var iMaxItems = this._oControl.getMaxItemsCount();
			var iItemsLength = this._oControl.getItems().length;
			var sDisplay = (!iItemsLength || !this._iItemCount || this._iItemCount >= iMaxItems) ? "none" : "block";

			// if we are in the popover then hiding the trigger removes focus and closes popup
			if (sap.ui.Device.system.desktop && sDisplay == "none" && oTriggerListDomRef.contains(document.activeElement)) {
				jQuery(oTriggerListDomRef).closest("[data-sap-ui-popup]").focus();
			}

			// update trigger info
			oTriggerListDomRef.style.display = sDisplay;
			this._oControl.$("trigger-itemInfo").text(this._getListItemInfo());
		},

		/**
		 * show loading indicator
		 */
		_showIndicator : function() {
			var bHasScrollToLoad = this._oControl.getGrowingScrollToLoad(),
				bHasScrollbars = this._getHasScrollbars();

			if (bHasScrollToLoad && bHasScrollbars) {

				this._checkTriggerType(bHasScrollToLoad, bHasScrollbars);

				var $trigger = this._oControl.$("triggerList").css("display", "block");
				if (sap.ui.Device.support.touch && this._oScrollDelegate) {
					if (this._oScrollDelegate.getMaxScrollTop() - this._oScrollDelegate.getScrollTop() < $trigger.height()) {
						this._oScrollDelegate.refresh();
						this._oScrollDelegate.scrollTo(this._oScrollDelegate.getScrollLeft(), this._oScrollDelegate.getMaxScrollTop());
					}
				}
			} else {
				this._oControl.$("trigger-busyIndicator").addClass("sapMGrowingListBusyIndicatorVisible");
			}

			this._getBusyIndicator().setVisible(true);
		},

		/**
		 * Emties the trigger and puts the Loading indicator in it, without rerendering the whole control.
		 *
		 * If scroll to load is disabled, this will do nothing.
		 * If the button is shown and there are scrollbars, the loading indicator will show up.
		 * If the button is not shown and there are no scrollbars, the button will show up.
		 *
		 * @private
		 */
		_checkTriggerType : function(bHasScrollToLoad, bHasScrollbars) {

			if (!bHasScrollToLoad) {
				this._showsTrigger = this._showsLoading = false;
				return;
			}

			if (!this._showsLoading && bHasScrollbars) {
				this._showsLoading = true;
				this._showsTrigger = false;
				this._switchTriggerWithLoadingIndicator(true);
			}

			if (!this._showsTrigger && !bHasScrollbars) {
				this._showsTrigger = true;
				this._showsLoading = false;
				this._switchTriggerWithLoadingIndicator(false);
			}
		},

		/**
		 * Empties the trigger and puts the Loading indicator in it, without rerendering the whole control.
		 *
		 * @private
		 */
		_switchTriggerWithLoadingIndicator : function(bShowLoading) {
			var rm = sap.ui.getCore().createRenderManager(),
				oActionItem,
				$TriggerList = this._oControl.$("triggerList");

			if (bShowLoading) {
				oActionItem = this._getLoading();
			} else {
				oActionItem = this._getTrigger();
			}

			// this variable is needed to render loading indicator in list even in table mode
			oActionItem._renderInList = true;

			$TriggerList.empty();

			rm.render(oActionItem, $TriggerList[0]);
		},

		/**
		 * hide loading indicator
		 */
		_hideIndicator : function() {
			jQuery.sap.delayedCall(0, this, function() {
				if (this._oControl) {	// maybe control is already destroyed
					this._getBusyIndicator().setVisible(false);
					if (this._oControl.getGrowingScrollToLoad() && this._getHasScrollbars()) {
						this._oControl.$("triggerList").css("display", "none");
					} else {
						this._oControl.$("trigger-itemInfo").html(this._getListItemInfo());
						this._oControl.$("trigger-busyIndicator").removeClass("sapMGrowingListBusyIndicatorVisible");
					}
				}
			});
		},

		/**
		 * ScrollDelegate call this method to inform new page needs to load
		 */
		_triggerLoadingByScroll : function() {
			this.requestNewPage();
		}
	});


	return GrowingEnablement;

}, /* bExport= */ true);

}; // end of sap/m/GrowingEnablement.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabBarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.IconTabBarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/IconTabBarRenderer",['jquery.sap.global', 'sap/ui/core/IconPool'],
	function(jQuery, IconPool) {
	"use strict";

/**
	 * HBox renderer.
	 * @namespace
	 */
	var IconTabBarRenderer = {
	};

	/**
	 * Array of all available icon color CSS classes
	 *
	 * @private
	 */
	IconTabBarRenderer._aAllIconColors = ['sapMITBFilterCritical', 'sapMITBFilterPositive', 'sapMITBFilterNegative', 'sapMITBFilterDefault'];


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	IconTabBarRenderer.render = function(oRm, oControl){
		var oContent = oControl.getContent(),
			oHeader = oControl._getIconTabHeader();

		// start control wrapper
		oRm.write("<div ");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMITB");
		if (oControl.getStretchContentHeight()) {
			oRm.addClass("sapMITBStretch");
		}
		if (!oControl.getApplyContentPadding()) {
			oRm.addClass("sapMITBNoContentPadding");
		}
		oRm.addClass("sapMITBBackgroundDesign" + oControl.getBackgroundDesign());
		oRm.writeClasses();
		oRm.write(">");

		// render icon tab header (if not configured to hide by ObjectHeader)
		if (!oControl._bHideHeader) {
			oRm.renderControl(oHeader);
		}

		// render outer content
		oRm.write("<div id='" + oControl.getId() + "-containerContent' ");
		oRm.addClass("sapMITBContainerContent");
		if (!oControl.getExpanded()) { // add special styles  when closed
			oRm.addClass("sapMITBContentClosed");
		}
		oRm.writeClasses();
		oRm.write(">");

		// render inner content
		oRm.write("<div id='" + oControl.getId() + "-content' class='sapMITBContent' role='tabpanel' ");
		if (!oControl.getExpanded()) { // hide content when closed
			oRm.write("style='display: none'");
		}
		oRm.write(">");
		if (oControl.getExpanded()) {
			// content from selected item
			if (oHeader.oSelectedItem && oHeader.oSelectedItem.getContent()) {
				var oContentSelectedTab = oHeader.oSelectedItem.getContent();
				if (oContentSelectedTab.length > 0) {
					oContent = oContentSelectedTab;
				}
			}
			// render the content
			if (oContent.length > 0) {
				for (var i = 0; i < oContent.length; i++) {
					oRm.renderControl(oContent[i]);
				}
			}
		}
		oRm.write("</div>");

		// end outer content
		oRm.write("</div>");

		// end control wrapper
		oRm.write("</div>");
	};



	return IconTabBarRenderer;

}, /* bExport= */ true);

}; // end of sap/m/IconTabBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabHeaderRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.IconTabHeaderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/IconTabHeaderRenderer",['jquery.sap.global', 'sap/ui/core/IconPool'],
	function(jQuery, IconPool) {
	"use strict";

/**
	 * HBox renderer.
	 * @namespace
	 */
	var IconTabHeaderRenderer = {
	};

	/**
	 * Array of all available icon color CSS classes
	 *
	 * @private
	 */
	IconTabHeaderRenderer._aAllIconColors = ['sapMITBFilterCritical', 'sapMITBFilterPositive', 'sapMITBFilterNegative', 'sapMITBFilterDefault'];


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	IconTabHeaderRenderer.render = function(oRM, oControl){
		// return immediately if control is not visible
		if (!oControl.getVisible()) {
			return;
		}

		var aItems = oControl.getItems(),
			bTextOnly = oControl._checkTextOnly(aItems),
			bNoText = oControl._checkNoText(aItems),
			oResourceBundle = sap.ui.getCore().getLibraryResourceBundle('sap.m');

		var oIconTabBar = oControl.getParent();
		var bUpperCase = oIconTabBar && oIconTabBar instanceof sap.m.IconTabBar && oIconTabBar.getUpperCase();

		// render wrapper div
		oRM.write("<div role='tablist' ");
		oRM.addClass("sapMITH");
		if (oControl._scrollable) {
			oRM.addClass("sapMITBScrollable");
			if (oControl._bPreviousScrollForward) {
				oRM.addClass("sapMITBScrollForward");
			} else {
				oRM.addClass("sapMITBNoScrollForward");
			}
			if (oControl._bPreviousScrollBack) {
				oRM.addClass("sapMITBScrollBack");
			} else {
				oRM.addClass("sapMITBNoScrollBack");
			}
		} else {
			oRM.addClass("sapMITBNotScrollable");
		}
		// Check for upperCase property on IconTabBar
		if (bUpperCase) {
			oRM.addClass("sapMITBTextUpperCase");
		}
		oRM.writeControlData(oControl);
		oRM.writeClasses();
		oRM.write(">");

		// render left scroll arrow
		oRM.renderControl(oControl._getScrollingArrow("left"));

		// render scroll container on touch devices
		if (oControl._bDoScroll) {
			oRM.write("<div id='" + oControl.getId() + "-scrollContainer' class='sapMITBScrollContainer'>");
		}

		oRM.write("<div id='" + oControl.getId() + "-head'");
		oRM.addClass("sapMITBHead");

		if (bTextOnly) {
			oRM.addClass("sapMITBTextOnly");
		}

		if (bNoText) {
			oRM.addClass("sapMITBNoText");
		}

		oRM.writeClasses();
		oRM.write(">");

		jQuery.each(aItems, function(iIndex, oItem) {
			if (!(oItem instanceof sap.m.IconTabSeparator) && !oItem.getVisible()) {
				return; // only render visible items
			}

			var sTabParams = '';

			if (oItem instanceof sap.m.IconTabSeparator) {
				if (oItem.getIcon()) {
					sTabParams += 'role="img" aria-label="' + oResourceBundle.getText("ICONTABBAR_NEXTSTEP") + '"';
				} else {
					sTabParams += 'role="separator"';
				}
			} else {
				sTabParams += 'role="tab" aria-controls="' + oControl.getParent().sId + '-content" ';

				//if there is tab text
				if (oItem) {
					var sIconColor = oItem.getIconColor();
					var bReadIconColor = sIconColor === 'Positive' || sIconColor === 'Critical' || sIconColor === 'Negative';

					if (oItem.getText().length || oItem.getCount() !== "" || oItem.getIcon()) {
						sTabParams += 'aria-labelledby="';
						var aIds = [];

						if (oItem.getText().length) {
							aIds.push(oItem.getId() + '-text');
						}
						if (oItem.getCount() !== "") {
							aIds.push(oItem.getId() + '-count');
						}
						if (oItem.getIcon()) {
							aIds.push(oItem.getId() + '-icon');
						}
						if (bReadIconColor) {
							aIds.push(oItem.getId() + '-iconColor');
						}

						sTabParams += aIds.join(' ');
						sTabParams += '"';
					}
				}
			}

			oRM.write('<div ' + sTabParams + ' ');

			oRM.writeElementData(oItem);
			oRM.addClass("sapMITBItem");

			if (oItem instanceof sap.m.IconTabFilter) {

				if (oItem.getDesign() === sap.m.IconTabFilterDesign.Vertical) {
					oRM.addClass("sapMITBVertical");
				} else if (oItem.getDesign() === sap.m.IconTabFilterDesign.Horizontal) {
					oRM.addClass("sapMITBHorizontal");
				}

				if (oItem.getShowAll()) {
					oRM.addClass("sapMITBAll");
				} else {
					oRM.addClass("sapMITBFilter");
					oRM.addClass("sapMITBFilter" + oItem.getIconColor());
				}

				if (!oItem.getEnabled()) {
					oRM.addClass("sapMITBDisabled");
				}

				var sTooltip = oItem.getTooltip_AsString();
				if (sTooltip) {
					oRM.writeAttributeEscaped("title", sTooltip);
				}

				oRM.writeClasses();
				oRM.write(">");
				oRM.write("<div id='" + oItem.getId() + "-tab' class='sapMITBTab'>");

				if (!oItem.getShowAll() || !oItem.getIcon()) {
					if (bReadIconColor) {
						oRM.write('<div id="' + oItem.getId() + '-iconColor" style="display: none;">' + oResourceBundle.getText('ICONTABBAR_ICONCOLOR_' + sIconColor.toUpperCase()) + '</div>');
					}

					oRM.renderControl(oItem._getImageControl(['sapMITBFilterIcon', 'sapMITBFilter' + oItem.getIconColor()], oControl, IconTabHeaderRenderer._aAllIconColors));
				}

				if (!oItem.getShowAll() && !oItem.getIcon() && !bTextOnly)  {
					oRM.write("<span class='sapMITBFilterNoIcon'> </span>");
				}

				if (oItem.getDesign() === sap.m.IconTabFilterDesign.Horizontal && !oItem.getShowAll()) {
					oRM.write("</div>");
					oRM.write("<div class='sapMITBHorizontalWrapper'>");
				}

				oRM.write("<span id='" + oItem.getId() + "-count' ");
				oRM.addClass("sapMITBCount");
				oRM.writeClasses();
				oRM.write(">");

				if ((oItem.getCount() === "") && (oItem.getDesign() === sap.m.IconTabFilterDesign.Horizontal)) {
					//this is needed for the correct placement of the text in the horizontal design
					oRM.write("&nbsp;");
				} else {
					oRM.writeEscaped(oItem.getCount());
				}

				oRM.write("</span>");

				if (oItem.getDesign() === sap.m.IconTabFilterDesign.Vertical) {
					oRM.write("</div>");
				}

				if (oItem.getText().length) {
					oRM.write("<div id='" + oItem.getId() + "-text' ");
					oRM.addClass("sapMITBText");
					// Check for upperCase property on IconTabBar
					if (bUpperCase) {
						oRM.addClass("sapMITBTextUpperCase");
					}
					oRM.writeClasses();
					oRM.write(">");
					oRM.writeEscaped(oItem.getText());
					oRM.write("</div>");
				}

				if (oItem.getDesign() === sap.m.IconTabFilterDesign.Horizontal) {
					oRM.write("</div>");
				}

				oRM.write("<div class='sapMITBContentArrow'></div>");

			} else { // separator
				oRM.addClass("sapMITBSep");

				if (!oItem.getIcon()) {
					oRM.addClass("sapMITBSepLine");
				}
				oRM.writeClasses();
				oRM.write(">");

				if (oItem.getIcon()) {
					oRM.renderControl(oItem._getImageControl(['sapMITBSepIcon'], oControl));
				}
			}
			oRM.write("</div>");
		});

		oRM.write("</div>");

		if (oControl._bDoScroll) {
			oRM.write("</div>"); //scrollContainer
		}

		// render right scroll arrow
		oRM.renderControl(oControl._getScrollingArrow("right"));

		// end wrapper div
		oRM.write("</div>");
	};

	return IconTabHeaderRenderer;

}, /* bExport= */ true);

}; // end of sap/m/IconTabHeaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ImageRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
 
// Provides default renderer for control sap.m.Image
jQuery.sap.declare('sap.m.ImageRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ImageRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Image renderer. 
	 * @author D051016
	 * @namespace
	 */
	var ImageRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ImageRenderer.render = function(rm, oImage){
		// Open the <img> tag
		rm.write("<img");
	
		rm.writeAttributeEscaped("src", oImage._getDensityAwareSrc());
		rm.writeControlData(oImage);
		
		rm.addClass("sapMImg");
		if (oImage.hasListeners("press") || oImage.hasListeners("tap")) {
			rm.addClass("sapMPointer");
		}
		
		if (oImage.getUseMap() || !oImage.getDecorative()) {
			rm.addClass("sapMImgFocusable");
		}
		
		rm.writeClasses();
		
		//TODO need further discussion to decide if tooltip is still needed for mobile
		var tooltip = oImage.getTooltip_AsString();
		if (tooltip) {
			rm.writeAttributeEscaped("title", tooltip);
		}
	
		//TODO implement the ImageMap control
		var sUseMap = oImage.getUseMap();
		if (sUseMap) {
			if (!(jQuery.sap.startsWith(sUseMap, "#"))) {
				sUseMap = "#" + sUseMap;
			}
			rm.writeAttributeEscaped("useMap", sUseMap);
		}
		
		// determine tab index and write alt attribute - both depending on "decorative" state (which is overridden by the "useMap" property
		var myTabIndex = 0;
		if ((oImage.getDecorative() && (!sUseMap))) {
			myTabIndex = -1;
			rm.writeAttribute("role", "presentation");
			rm.write(" alt=''"); // accessibility requirement: write always empty alt attribute for decorative images
		} else {
			if (oImage.getAlt()) {
				rm.writeAttributeEscaped("alt", oImage.getAlt() || tooltip); // accessibility requirement: use tooltip for alt if alt is not set
			} else if (tooltip) {
				rm.writeAttributeEscaped("alt", tooltip);
			}
		}
		rm.writeAttribute("tabIndex", myTabIndex);
		
		// Dimensions
	
		if (oImage.getWidth() && oImage.getWidth() != '') {
			rm.addStyle("width", oImage.getWidth());
		}
		if (oImage.getHeight() && oImage.getHeight() != '') {
			rm.addStyle("height", oImage.getHeight());
		}
		rm.writeStyles();
		
		var sTooltip = oImage.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		
		rm.write(" />"); // close the <img> element
	};
	

	return ImageRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ImageRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.InputBaseRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.InputBaseRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/m/InputBaseRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, Renderer, ValueStateSupport) {
	"use strict";


	/**
	 * Input renderer.
	 *
	 * @namespace
	 */
	var InputBaseRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.render = function(oRm, oControl) {
		var sValueState = oControl.getValueState();
		var sTextDir = oControl.getTextDirection();
		var sTextAlign = Renderer.getTextAlign(oControl.getTextAlign(), sTextDir);

		oRm.write("<div");
		oRm.writeControlData(oControl);

		// outer styles
		this.addOuterStyles(oRm, oControl);

		if (oControl.getWidth()) {
			oRm.addStyle("width", oControl.getWidth());
		}

		oRm.writeStyles();

		// outer classes
		oRm.addClass("sapMInputBase");
		this.addCursorClass(oRm, oControl);
		this.addOuterClasses(oRm, oControl);

		if (!oControl.getEnabled()) {
			oRm.addClass("sapMInputBaseDisabled");
		}

		if (!oControl.getEditable()) {
			oRm.addClass("sapMInputBaseReadonly");
		}

		if (sValueState !== sap.ui.core.ValueState.None) {
			this.addValueStateClasses(oRm, oControl);
		}

		oRm.writeClasses();

		// outer attributes
		this.writeOuterAttributes(oRm, oControl);
		var sTooltip = ValueStateSupport.enrichTooltip(oControl, oControl.getTooltip_AsString());

		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}

		oRm.write(">");

		this.prependInnerContent(oRm, oControl);

		// enable self-made placeholder
		if (oControl.bShowLabelAsPlaceholder) {
			oRm.write("<label");
			oRm.writeAttribute("id", oControl.getId() + "-placeholder");
			oRm.writeAttribute("for", oControl.getId() + "-inner");
			if (sTextAlign) {
				oRm.addStyle("text-align", sTextAlign);
			}
			this.addPlaceholderClasses(oRm, oControl);
			this.addPlaceholderStyles(oRm, oControl);
			oRm.writeClasses();
			oRm.writeStyles();
			oRm.write(">");
			oRm.writeEscaped(oControl._getPlaceholder());
			oRm.write("</label>");
		}

		// start inner
		this.openInputTag(oRm, oControl);

		// inner attributes
		oRm.writeAttribute("id", oControl.getId() + "-inner");

		// write the name of input
		if (oControl.getName()) {
			oRm.writeAttributeEscaped("name", oControl.getName());
		}

		// let the browser handle placeholder
		if (!oControl.bShowLabelAsPlaceholder && oControl._getPlaceholder()) {
			oRm.writeAttributeEscaped("placeholder", oControl._getPlaceholder());
		}

		// check if there is a maxLength property
		if (oControl.getMaxLength && oControl.getMaxLength() > 0) {
			oRm.writeAttribute("maxlength", oControl.getMaxLength());
		}

		// check disable and readonly
		if (!oControl.getEnabled()) {
			oRm.writeAttribute("disabled", "disabled");
			oRm.addClass("sapMInputBaseDisabledInner");
		} else if (!oControl.getEditable()) {
			oRm.writeAttribute("tabindex", "-1");
			oRm.writeAttribute("readonly", "readonly");
			oRm.addClass("sapMInputBaseReadonlyInner");
		}

		// check if textDirection property is not set to default "Inherit" and add "dir" attribute
		if (sTextDir != sap.ui.core.TextDirection.Inherit) {
			oRm.writeAttribute("dir", sTextDir.toLowerCase());
		}

		this.writeInnerValue(oRm, oControl);
		this.writeAccessibilityState(oRm, oControl);

		if (sap.ui.Device.browser.mozilla) {
			if (sTooltip) {
				// fill tooltip to mozilla validation flag too, to display it in validation error case too
				oRm.writeAttribute("x-moz-errormessage", sTooltip);
			} else {
				// if no tooltip use blank text for mozilla validation text
				oRm.writeAttribute("x-moz-errormessage", " ");
			}
		}

		this.writeInnerAttributes(oRm, oControl);

		// inner classes
		oRm.addClass("sapMInputBaseInner");
		if (sValueState !== sap.ui.core.ValueState.None) {
			oRm.addClass("sapMInputBaseStateInner");
			oRm.addClass("sapMInputBase" + sValueState + "Inner");
		}
		this.addInnerClasses(oRm, oControl);
		oRm.writeClasses();

		// write text-align
		if (sTextAlign) {
			oRm.addStyle("text-align", sTextAlign);
		}

		// inner styles
		this.addInnerStyles(oRm, oControl);
		oRm.writeStyles();
		oRm.write(">");

		// finish inner
		this.writeInnerContent(oRm, oControl);
		this.closeInputTag(oRm, oControl);

		// finish outer
		oRm.write("</div>");
	};

	/**
	 * Writes the accessibility state.
	 * To be overwritten by subclasses.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.writeAccessibilityState = function(oRm, oControl) {
		oRm.writeAccessibilityState(oControl);
	};

	/**
	 * This method is reserved for derived classes to add extra attributes to the Input.
	 *
	 * @deprecated sap.m.InputBaseRenderer#writeInnerAttributes should be called instead of this method.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.writeAttributes = function(oRm, oControl) {
		jQuery.sap.log.warning("Usage of deprecated function: sap.m.InputBaseRenderer#writeAttributes");
		this.writeInnerAttributes(oRm, oControl);
	};

	/**
	 * Adds extra CSS class.
	 *
	 * @deprecated sap.m.InputBaseRenderer#addOuterClasses should be called instead of this method.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.addClasses = function(oRm, oControl) {
		jQuery.sap.log.warning("Usage of deprecated function: sap.m.InputBaseRenderer#addClasses");
		this.addOuterClasses(oRm, oControl);
	};

	/**
	 * Write the opening tag name of the input.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.openInputTag = function(oRm, oControl) {
		oRm.write("<input");
	};

	/**
	 * Write the value of the input.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.writeInnerValue = function(oRm, oControl) {
		oRm.writeAttributeEscaped("value", oControl.getValue());
	};

	/**
	 * Add cursor class to input container.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.addCursorClass = function(oRm, oControl) {
	};

	/**
	 * This method is reserved for derived class to add extra styles for input container.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.addOuterStyles = function(oRm, oControl) {};

	/**
	 * This method is reserved for derived classes to add extra classes for input container.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.addOuterClasses = function(oRm, oControl) {};

	/**
	 * This method is reserved for derived class to add extra attributes for input container.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.writeOuterAttributes = function(oRm, oControl) {};

	/**
	 * This method is reserved for derived classes to add extra styles for input element.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.addInnerStyles = function(oRm, oControl) {};

	/**
	 * This method is reserved for derived classes to add extra classes for input element.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.addInnerClasses = function(oRm, oControl) {};

	/**
	 * This method is reserved for derived classes to add extra attributes for the input element.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.writeInnerAttributes = function(oRm, oControl) {};

	/**
	 * This method is reserved for derived classes to prepend inner content.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.prependInnerContent = function(oRm, oControl) {};

	/**
	 * Write the value of the input.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.writeInnerContent = function(oRm, oControl) {};

	/**
	 * Write the closing tag name of the input.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.closeInputTag = function(oRm, oControl) {};

	/**
	 * This method is reserved for derived classes to add extra styles for the placeholder, if rendered as label.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.addPlaceholderStyles = function(oRm, oControl) {};

	/**
	 * Adds custom placeholder classes, if native placeholder is not used.
	 * To be overwritten by subclasses.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.addPlaceholderClasses = function(oRm, oControl) {
		oRm.addClass("sapMInputBasePlaceholder");
	};

	/**
	 * Add the CSS value state classes to the control's root element using the provided {@link sap.ui.core.RenderManager}.
	 * To be overwritten by subclasses.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	InputBaseRenderer.addValueStateClasses = function(oRm, oControl) {
		oRm.addClass("sapMInputBaseState");
		oRm.addClass("sapMInputBase" + oControl.getValueState());
	};

	return InputBaseRenderer;

}, /* bExport= */ true);
}; // end of sap/m/InputBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.InputRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.InputRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/InputRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './InputBaseRenderer'],
	function(jQuery, Renderer, InputBaseRenderer) {
	"use strict";


	/**
	 * Input renderer.
	 * @namespace
	 *
	 * InputRenderer extends the InputBaseRenderer
	 */
	var InputRenderer = Renderer.extend(InputBaseRenderer);

	/**
	 * Adds control specific class
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	InputRenderer.addOuterClasses = function(oRm, oControl) {
		oRm.addClass("sapMInput");
		if (oControl.getShowValueHelp() && oControl.getEnabled() && oControl.getEditable()) {
			oRm.addClass("sapMInputVH");
			if (oControl.getValueHelpOnly()) {
				oRm.addClass("sapMInputVHO");
			}
			if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 11) {
				// IE9 and IE10 ignore padding-right in <input>
				oRm.addClass("sapMInputIE9");
			}
		}
		if (oControl.getDescription()) {
				oRm.addClass("sapMInputDescription");
		}
	};

	/**
	 * Add extra styles for input container
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	InputRenderer.addOuterStyles = function(oRm, oControl) {
	};

	/**
	 * add extra attributes to Input
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	InputRenderer.writeInnerAttributes = function(oRm, oControl) {
		oRm.writeAttribute("type", oControl.getType().toLowerCase());
		if ((!oControl.getEnabled() && oControl.getType() == "Password")
				|| (oControl.getShowSuggestion() && oControl._bUseDialog)
				|| (oControl.getValueHelpOnly() && oControl.getEnabled() && oControl.getEditable() && oControl.getShowValueHelp())) {
			// required for JAWS reader on password fields on desktop and in other cases:
			oRm.writeAttribute("readonly", "readonly");
		}
		// Screen reader: announcements
		if (oControl.getShowValueHelp() && oControl.getEnabled() && oControl.getEditable()) {
			oRm.writeAccessibilityState({
				describedby : {
					value: oControl._sAriaF4LabelId,
					append: true
				}
			});
		}
	};

	/**
	 * Adds inner css classes to the input field
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	InputRenderer.addInnerClasses = function(oRm, oControl) {
	};

	/**
	 * Add inner styles to the input field
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	InputRenderer.addInnerStyles = function(oRm, oControl) {

		if (oControl.getDescription()) {
			oRm.addStyle("width", oControl.getFieldWidth() || "50%");
		}
	};

	/**
	 * add extra content to Input
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	InputRenderer.writeInnerContent = function(oRm, oControl) {

		if (!oControl.getDescription()) {
			this.writeValueHelpIcon(oRm, oControl);
		}else {
			var sDescription = oControl.getDescription();
			oRm.write("<span>");
			this.writeValueHelpIcon(oRm, oControl);
			oRm.writeEscaped(sDescription);
			oRm.write("</span>");
		}

	};

	InputRenderer.writeValueHelpIcon = function(oRm, oControl) {

		if (oControl.getShowValueHelp() && oControl.getEnabled() && oControl.getEditable()) {
			oRm.write('<div class="sapMInputValHelp">');
			oRm.renderControl(oControl._getValueHelpIcon());
			oRm.write("</div>");
		}

	};

	/**
	 * Add inner styles to the placeholder
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	InputRenderer.addPlaceholderStyles = function(oRm, oControl) {

		if (oControl.getDescription()) {
			oRm.addStyle("width", oControl.getFieldWidth() || "50%");
		}

	};

	return InputRenderer;

}, /* bExport= */ true);

}; // end of sap/m/InputRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.InstanceManager') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.m.InstanceManager
jQuery.sap.declare('sap.m.InstanceManager'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/InstanceManager",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

/**
	 * Provides methods to manage instances. This is specifically designed for managing the opened Popover, Dialog, ActionSheet,
	 * and it's possible to close all of the opened Popover, Dialog, ActionSheet in history handling.
	 *
	 * As <code>InstanceManager</code> is a static class, a <code>jQuery.sap.require("sap.m.InstanceManager");</code> statement
	 * must be explicitly executed before the class can be used. Example:
	 * <pre>
	 *   jQuery.sap.require("sap.m.InstanceManager");
	 *   sap.m.InstanceManager.closeAllPopovers();
	 * </pre>
	 *
	 * @namespace
	 * @public
	 * @since 1.9.2
	 */
	var InstanceManager = {};
	
	(function() {
		var mRegistry = {},
			aEmptyArray = [];
		
		var sPopoverCategoryId = "_POPOVER_",
			sDialogCategoryId = "_DIALOG_";
	
		/**
		 * Adds an instance to the given category. If the instance is already added to the same category, it won't be added again.
		 *
		 * @param {string} sCategoryId The category's id.
		 * @param {object} oInstance The instance that will be added to the given category.
		 * @returns {sap.m.InstanceManager} Enable method chaining.
		 * @protected
		 * @function
		*/
		InstanceManager.addInstance = function(sCategoryId, oInstance) {
			jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.addInstance method, the parameter sCategoryId can't be null or empty string");
			jQuery.sap.assert(oInstance instanceof Object, "In sap.m.InstanceManager.addInstance method, the parameter oInstance should be an object");
	
			if (!mRegistry[sCategoryId]) {
				mRegistry[sCategoryId] = [];
			}
	
			if (mRegistry[sCategoryId].indexOf(oInstance) === -1) {
				mRegistry[sCategoryId].push(oInstance);
			}
	
			return this;
		};
	
		/**
		 * Removes a managed instance from the given category.
		 *
		 * @param {string} sCategoryId The category's id.
		 * @param {object} oInstance The instance that will be removed from the given category.
		 * @returns The removed instance or null. If the instance isn't managed, this method returns null instead of the instance object.
		 * @protected
		 * @function
		*/
		InstanceManager.removeInstance = function(sCategoryId, oInstance) {
			var aCategory = mRegistry[sCategoryId],
				i;
	
			jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.removeInstance method, the parameter sCategoryId can't be null or empty string");
			jQuery.sap.assert(oInstance instanceof Object, "In sap.m.InstanceManager.removeInstance method, the parameter oInstance should be an object");
	
			if (!aCategory) {
				jQuery.sap.log.warning("Can't remove control from a non-managed category id: " + sCategoryId);
				return null;
			}
	
			i = aCategory.indexOf(oInstance);
	
			return (i === -1) ? null : aCategory.splice(i, 1);
		};
	
		/**
		 * Returns an array of managed instances in the given category.
		 *
		 * @param {string} sCategoryId The category's id.
		 * @returns {object} Managed instances in the given category.
		 * @protected
		 * @function
		*/
		InstanceManager.getInstancesByCategoryId = function(sCategoryId) {
			jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.getInstancesByCategoryId method, the parameter sCategoryId can't be null or empty string");
	
			return mRegistry[sCategoryId] || aEmptyArray;
		};
	
		/**
		 * Checks if an instance is managed under the given category.
		 * 
		 * @param {string} sCategoryId The category that the instance is supposed to be in.
		 * @param {object} oInstance The instance that needs to be checked.
		 * @returns {boolean} Whether the instance is managed in the given category.
		 * @protected
		 * @function
		 */
		InstanceManager.isInstanceManaged = function(sCategoryId, oInstance) {
			jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.isInstanceManaged method, the parameter sCategoryId can't be null or empty string");
			jQuery.sap.assert(oInstance instanceof Object, "In sap.m.InstanceManager.isInstanceManaged method, the parameter oInstance should be an object");
	
			var aCategory = mRegistry[sCategoryId];
	
			if (!aCategory || !oInstance) {
				return false;
			}
	
			return aCategory.indexOf(oInstance) !== -1;
		};
	
		/**
		 * Returns if there's no managed instance in the given category.
		 *
		 * @param {string} sCategoryId The category's id.
		 * @returns {boolean} Whether the category is empty.
		 * @protected
		 * @function
		*/
		InstanceManager.isCategoryEmpty = function(sCategoryId) {
			jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.isCategoryEmpty method, the parameter sCategoryId can't be null or empty string");
	
			var aCategory = mRegistry[sCategoryId];
	
			return !aCategory || aCategory.length === 0;
		};
	
		/**
		 * Adds a control to predefined popover category in instance manager.
		 *
		 * @param {sap.ui.core.Control} oPopover Popover to be added to instance manager. Custom popover which doesn't inherit from sap.m.Popover can also be added as long as it has a close method.
		 * @returns {sap.m.InstanceManager} Enable method chaining.
		 * @protected
		 * @function
		*/
		InstanceManager.addPopoverInstance = function(oPopover){
			if (typeof oPopover.close === "function") {
				InstanceManager.addInstance(sPopoverCategoryId, oPopover);
			} else {
				jQuery.sap.log.warning("In method addPopoverInstance: the parameter doesn't have a close method and can't be managed.");
			}
			return this;
		};
		
		/**
		 * Adds a control to predefined dialog category in instance manager.
		 *
		 * @param {sap.ui.core.Control} oDialog Dialog to be added to instance manager. Dialog which doesn't inherit from sap.m.Dialog can also be added as long as it has a close method.
		 * @returns {sap.m.InstanceManager} Enable method chaining.
		 * @protected
		 * @function
		*/
		InstanceManager.addDialogInstance = function(oDialog){
			if (typeof oDialog.close === "function" ) {
				InstanceManager.addInstance(sDialogCategoryId, oDialog);
			} else {
				jQuery.sap.log.warning("In method addDialogInstance: the parameter doesn't have a close method and can't be managed.");
			}
			return this;
		};
		
		/**
		 * Removes control from predefined popover category in instance manager.
		 *
		 * @param {sap.ui.core.Control} oPopover to be removed from instance manager.
		 * @returns The removed popover or null. If the popover isn't managed, this method returns null instead of the removed popover.
		 * @protected
		 * @function
		*/
		InstanceManager.removePopoverInstance = function(oPopover){
			return InstanceManager.removeInstance(sPopoverCategoryId, oPopover);
		};
		
		/**
		 * Removes control from predefined dialog category in instance manager.
		 *
		 * @param {sap.ui.core.Control} oDialog to be removed from instance manager.
		 * @returns The removed popover or null. If the popover isn't managed, this method returns null instead of the removed popover.
		 * @protected
		 * @function
		*/
		InstanceManager.removeDialogInstance = function(oDialog){
			return InstanceManager.removeInstance(sDialogCategoryId, oDialog);
		};
		
		/**
		 * Returns true if there's popover(s) managed in predefined popover category, otherwise it returns false.
		 *
		 * @returns {boolean} Whether there's popover(s) open.
		 * @public
		 * @function
		*/
		InstanceManager.hasOpenPopover = function(){
			return !InstanceManager.isCategoryEmpty(sPopoverCategoryId);
		};
		
		/**
		 * Returns true if there's dialog(s) managed in predefined dialog category, otherwise it returns false.
		 *
		 * @returns {boolean} Whether there's dialog(s) open.
		 * @public
		 * @function
		*/
		InstanceManager.hasOpenDialog = function(){
			return !InstanceManager.isCategoryEmpty(sDialogCategoryId);
		};
		
		/**
		 * Check if the given dialog instance is managed under the dialog category.
		 * For dialog instances, managed means the dialog is open.
		 * 
		 * This function is specially provided for customized controls which doesn't have the possibility to check whether it's open.
		 * If the given dialog is an instance of sap.m.Dialog, sap.m.ActionSheet, the isOpen() method on the instance is 
		 * preferred to be called than this function.
		 * 
		 * @param {sap.ui.core.Control} oDialog The dialog that is checked for the openness.
		 * @returns Whether the given dialog is open.
		 * @public
		 * @function
		 */
		InstanceManager.isDialogOpen = function(oDialog){
			return InstanceManager.isInstanceManaged(sDialogCategoryId, oDialog);
		};
		
		/**
		 * Check if the given popover instance is managed under the popover category.
		 * For popover instances, managed means the popover is open.
		 * 
		 * This function is specially provided for customized controls which doesn't have the possibility to check whether it's open. 
		 * If the given popover is an instance of sap.m.Popover, sap.m.ActionSheet, the isOpen() method on the instance is 
		 * preferred to be called than this function.
		 * 
		 * @param {sap.ui.core.Control} oPopover The popover that is checked for the openness.
		 * @returns Whether the given popover is open.
		 * @public
		 * @function
		 */
		InstanceManager.isPopoverOpen = function(oPopover){
			return InstanceManager.isInstanceManaged(sPopoverCategoryId, oPopover);
		};
		
		/**
		 * Gets all of the open popovers. If there's no popover open, it returns an empty array.
		 *
		 * @return {sap.ui.core.Control[]} The open popovers.
		 * @public
		 * @function
		*/
		InstanceManager.getOpenPopovers = function(){
			return InstanceManager.getInstancesByCategoryId(sPopoverCategoryId);
		};
		
		/**
		 * Gets all of the open dialogs. If there's no dialog open, it returns an empty array.
		 *
		 * @return {sap.ui.core.Control[]} The open dialogs.
		 * @public
		 * @function
		*/
		InstanceManager.getOpenDialogs = function(){
			return InstanceManager.getInstancesByCategoryId(sDialogCategoryId);
		};
		
		/**
		 * Closes all open popovers.
		 *
		 * @public
		 * @returns {sap.m.InstanceManager} Enable method chaining.
		 * @function
		*/
		InstanceManager.closeAllPopovers = function(){
			var aIntances = InstanceManager.getOpenPopovers(), i;
			for (i = 0 ; i < aIntances.length ; i++) {
				aIntances[i].close();
			}
			return this;
		};
		
		/**
		 * Closes all of the open dialogs.
		 *
		 * @param {Function} fnCallback
		 * @public
		 * @returns {sap.m.InstanceManager} Enable method chaining.
		 * @function
		*/
		InstanceManager.closeAllDialogs = function(fnCallback) {
			var oDeferred,
				aDeferred = [],
				aIntances = InstanceManager.getOpenDialogs(),
				dialog,
				i;
			
			for (i = 0 ; i < aIntances.length; i++) {
				dialog = aIntances[i];
				
				if (fnCallback) {
					oDeferred = new jQuery.Deferred().done();
					aDeferred.push(oDeferred);
	
					/*eslint-disable no-loop-func */
					dialog.attachEvent("afterClose", (function(def){
						return function() {
							def.resolve();
						};
					}(oDeferred)));
					/*eslint-enable no-loop-func */
	
				}
				
				dialog.close();
			}
			
			if (fnCallback) {
				jQuery.when.apply(this, aDeferred).then(fnCallback);
			}
	  
			return this;
		};
	}());

	return InstanceManager;

}, /* bExport= */ true);

}; // end of sap/m/InstanceManager.js
if ( !jQuery.sap.isDeclared('sap.m.LabelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */


jQuery.sap.declare('sap.m.LabelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/LabelRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
	"use strict";


	/**
	 * Label renderer.
	 * @namespace
	 */
	var LabelRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oLabel an object representation of the control that should be rendered
	 */
	LabelRenderer.render = function(rm, oLabel){
		// convenience variable
		var r = LabelRenderer;

		// write the HTML into the render manager
		rm.write("<label");
		rm.writeControlData(oLabel);

		// Styles
		rm.addClass("sapMLabel");
		rm.addClass("sapUiSelectable");
		//set design to bold
		if (oLabel.getDesign() == sap.m.LabelDesign.Bold) {
			rm.addStyle("font-weight", "bold");
		}

		if (oLabel.getRequired()) {
			rm.addClass("sapMLabelRequired");
		}
		rm.writeAccessibilityState(oLabel, {
			role: "label",
			labelledby : {
				value : oLabel.getLabelFor(),
				append : true
			}
		});

		if (oLabel.getLabelForRendering()) {
			sap.ui.core.LabelEnablement.writeLabelForAttribute(rm, oLabel);
		} else if (oLabel.getParent() instanceof sap.m.Toolbar) {
			rm.addClass("sapMLabelTBHeader");
		}

		// Text direction
		var sTextDir = oLabel.getTextDirection();
		if (sTextDir !== sap.ui.core.TextDirection.Inherit){
			rm.writeAttribute("dir", sTextDir.toLowerCase());
		}

		// Style for width
		var sWidth = oLabel.getWidth();
		if (sWidth) {
			rm.addStyle("width", sWidth);
		} else {
			rm.addClass("sapMLabelMaxWidth");
		}

		// Style for text alignment
		var sTextAlign = oLabel.getTextAlign();
		if (sTextAlign) {
			var sTextAlign = r.getTextAlign(sTextAlign, sTextDir);
			if (sTextAlign) {
				rm.addStyle("text-align", sTextAlign);
			}
		}

		var sLabelText = oLabel.getText();
		if (sLabelText == "") {
			rm.addClass("sapMLabelNoText");
		}

		rm.writeStyles();
		rm.writeClasses();

		var sTooltip = oLabel.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}

		rm.write(">");

		// Write the label text

		if (sLabelText) {
			rm.writeEscaped(sLabelText);
		}
		rm.write("</label>");
	};

	/**
	 * Dummy inheritance of static methods/functions.
	 * @see sap.ui.core.Renderer.getTextAlign
	 * @private
	 */
	LabelRenderer.getTextAlign = Renderer.getTextAlign;

	return LabelRenderer;

}, /* bExport= */ true);

}; // end of sap/m/LabelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.LinkRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

 jQuery.sap.declare('sap.m.LinkRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/LinkRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
	"use strict";


	/**
	 * Link renderer
	 * @namespace
	 */
	var LinkRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	LinkRenderer.render = function(rm, oControl) {
		var sTextDir = oControl.getTextDirection();
		var sTextAlign = Renderer.getTextAlign(oControl.getTextAlign(), sTextDir);

		// Link is rendered as a "<a>" element
		rm.write("<a");
		rm.writeControlData(oControl);

		// ARIA attributes
		rm.writeAccessibilityState(oControl, {
			role: 'link',
			haspopup: !oControl.getHref()
		});

		rm.addClass("sapMLnk");
		if (oControl.getSubtle()) {
			rm.addClass("sapMLnkSubtle");
		}

		if (oControl.getEmphasized()) {
			rm.addClass("sapMLnkEmphasized");
		}

		if (!oControl.getEnabled()) {
			rm.addClass("sapMLnkDsbl");
			rm.writeAttribute("disabled", "true");
			rm.writeAttribute("tabIndex", "-1"); // still focusable by mouse click, but not in the tab chain
		} else {
			rm.writeAttribute("tabIndex", "0");
		}
		if (oControl.getWrapping()) {
			rm.addClass("sapMLnkWrapping");
		}

		if (oControl.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oControl.getTooltip_AsString());
		}

		/* set href only if link is enabled - BCP incident 1570020625 */
		if (oControl.getHref() && oControl.getEnabled()) {
			rm.writeAttributeEscaped("href", oControl.getHref());
		} else {
			/*eslint-disable no-script-url */
			rm.writeAttribute("href", "javascript:void(0);");
			/*eslint-enable no-script-url */
		}

		if (oControl.getTarget()) {
			rm.writeAttributeEscaped("target", oControl.getTarget());
		}

		if (oControl.getWidth()) {
			rm.addStyle("width", oControl.getWidth());
		} else {
			rm.addClass("sapMLnkMaxWidth");
		}

		if (sTextAlign) {
			rm.addStyle("text-align", sTextAlign);
		}

		// check if textDirection property is not set to default "Inherit" and add "dir" attribute
		if (sTextDir !== sap.ui.core.TextDirection.Inherit) {
			rm.writeAttribute("dir", sTextDir.toLowerCase());
		}

		rm.writeClasses();
		rm.writeStyles();
		rm.write(">"); // opening <a> tag

		if (oControl.getText()) {
			rm.writeEscaped(oControl.getText());
		}

		// ARIA write hidden element for emphasized or subtle link
		if (oControl.getEmphasized()) {
			rm.write("<label id='" + oControl.getId() + "-linkEmphasized" + "' class='sapUiHidden'>" + oControl._getLinkDescription("LINK_EMPHASIZED") + "</label>");
		}
		if (oControl.getSubtle()) {
			rm.write("<label id='" + oControl.getId() + "-linkSubtle" + "' class='sapUiHidden'>" + oControl._getLinkDescription("LINK_SUBTLE") + "</label>");
		}

		rm.write("</a>");
	};


	return LinkRenderer;

 }, /* bExport= */ true);

}; // end of sap/m/LinkRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ListBaseRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ListBaseRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/m/ListBaseRenderer",['jquery.sap.global', 'sap/ui/core/theming/Parameters'],
	function(jQuery, Parameters) {
	"use strict";


	/**
	 * List renderer.
	 * @namespace
	 */
	var ListBaseRenderer = {};
	
	/**
	 * Determines the order of the mode for the renderer
	 * -1 is for the beginning of the content
	 * +1 is for the end of the content
	 *  0 is to ignore this mode 
	 * @static
	 */
	ListBaseRenderer.ModeOrder = {
		None : 0,
		Delete : 1,
		MultiSelect : -1,
		SingleSelect : 1,
		SingleSelectLeft : -1,
		SingleSelectMaster : 0
	};
	
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *          oRenderManager the RenderManager that can be used for writing to the
	 *          Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be
	 *          rendered
	 */
	ListBaseRenderer.render = function(rm, oControl) {
		// container
		rm.write("<div");
		rm.addClass("sapMList");
		rm.writeControlData(oControl);
		rm.writeAttribute("tabindex", "-1");
		rm.writeAttribute("role", "presentation");
		
		if (oControl.getInset()) {
			rm.addClass("sapMListInsetBG");
		}
		if (oControl.getWidth()) {
			rm.addStyle("width", oControl.getWidth());
		}
	
		// background
		if (oControl.getBackgroundDesign) {
			rm.addClass("sapMListBG" + oControl.getBackgroundDesign());
		}
		
		// tooltip
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
	
		// run hook method
		this.renderContainerAttributes(rm, oControl);
	
		rm.writeStyles();
		rm.writeClasses();
		rm.write(">");
	
		// render header
		var sHeaderText = oControl.getHeaderText();
		var oHeaderTBar = oControl.getHeaderToolbar();
		if (oHeaderTBar) {
			oHeaderTBar.setDesign(sap.m.ToolbarDesign.Transparent, true);
			oHeaderTBar.addStyleClass("sapMListHdrTBar");
			rm.renderControl(oHeaderTBar);
		} else if (sHeaderText) {
			rm.write("<div class='sapMListHdr'");
			rm.writeAttribute("id", oControl.getId("header"));
			rm.write(">");
			rm.writeEscaped(sHeaderText);
			rm.write("</div>");
		}
	
		// render info bar
		var oInfoTBar = oControl.getInfoToolbar();
		if (oInfoTBar) {
			oInfoTBar.setDesign(sap.m.ToolbarDesign.Info, true);
			oInfoTBar.addStyleClass("sapMListInfoTBar");
			rm.renderControl(oInfoTBar);
		}
		
		// determine items rendering 
		var aItems = oControl.getItems();
		var bRenderItems = oControl.shouldRenderItems() && aItems.length;
	
		// run hook method to start building list
		this.renderListStartAttributes(rm, oControl);
		
		// write accessibility state
		rm.writeAccessibilityState(oControl, this.getAccessibilityState(oControl));
	
		// list attributes
		rm.addClass("sapMListUl");
		rm.writeAttribute("id", oControl.getId("listUl"));
		if (bRenderItems || oControl.getShowNoData()) {
			rm.writeAttribute("tabindex", "0");
		}
	
		// separators
		rm.addClass("sapMListShowSeparators" + oControl.getShowSeparators());
	
		// modes
		rm.addClass("sapMListMode" + oControl.getMode());
	
		// inset
		oControl.getInset() && rm.addClass("sapMListInset");
	
		// write inserted styles and classes
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
	
		// run hook method to render list head attributes
		this.renderListHeadAttributes(rm, oControl);
	
		// render child controls
		bRenderItems && aItems.forEach(function(oItem) {
			rm.renderControl(oItem);
		});
	
		// render no-data if needed
		if (!bRenderItems && oControl.getShowNoData()) {
			// hook method to render no data
			this.renderNoData(rm, oControl);
		}
	
		// run hook method to finish building list
		this.renderListEndAttributes(rm, oControl);
	
		// dummy after focusable area
		rm.write("<div");
		rm.writeAttribute("id", oControl.getId("after"));
		if (bRenderItems || oControl.getShowNoData()) {
			rm.writeAttribute("tabindex", "0");
		}
		rm.write("></div>");
		
		// render growing delegate if available
		if (bRenderItems && oControl._oGrowingDelegate) {
			oControl._oGrowingDelegate.render(rm);
		}
	
		// footer
		if (oControl.getFooterText()) {
			rm.write("<footer class='sapMListFtr'");
			rm.writeAttribute("id", oControl.getId("footer"));
			rm.write(">");
			rm.writeEscaped(oControl.getFooterText());
			rm.write("</footer>");
		}
	
		// done
		rm.write("</div>");
	};
	
	/**
	 * This hook method is called to render container attributes
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ListBaseRenderer.renderContainerAttributes = function(rm, oControl) {
	};
	
	/**
	 * This hook method is called after <ul> and before first <li>
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ListBaseRenderer.renderListHeadAttributes = function(rm, oControl) {
	};
	
	/**
	 * This hook method is called to render list tag
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ListBaseRenderer.renderListStartAttributes = function(rm, oControl) {
		rm.write("<ul");
		oControl.addNavSection(oControl.getId("listUl"));
	};
	
	/**
	 * Returns aria accessibility role
	 *
	 * @param {sap.ui.core.Control} oControl an object representation of the control
	 * @returns {String}
	 */
	ListBaseRenderer.getAriaRole = function(oControl) {
		return "listbox";
	};
	
	/**
	 * Returns the inner aria labelledby ids for the accessibility
	 *
	 * @param {sap.ui.core.Control} oControl an object representation of the control 
	 * @returns {String|undefined} 
	 */
	ListBaseRenderer.getAriaLabelledBy = function(oControl) {
		var oHeaderTBar = oControl.getHeaderToolbar();
		if (oHeaderTBar) {
			return oHeaderTBar.getTitleId();
		} else if (oControl.getHeaderText()) {
			return oControl.getId("header");
		}
	};
	
	/**
	 * Returns the inner aria describedby ids for the accessibility
	 *
	 * @param {sap.ui.core.Control} oControl an object representation of the control
	 * @returns {String|undefined} 
	 */
	ListBaseRenderer.getAriaDescribedBy = function(oControl) {
		if (oControl.getFooterText()) {
			return oControl.getId("footer");
		}
	};
	
	/**
	 * Returns the accessibility state of the control
	 *
	 * @param {sap.ui.core.Control} oControl an object representation of the control
	 */
	ListBaseRenderer.getAccessibilityState = function(oControl) {
		
		var mMode = sap.m.ListMode,
			sMode = oControl.getMode(),
			bMultiSelectable;
		
		if (sMode == mMode.MultiSelect) {
			bMultiSelectable = true;
		} else if (sMode != mMode.None && sMode != mMode.Delete) {
			bMultiSelectable = false;
		}
		
		return {
			role : this.getAriaRole(oControl),
			multiselectable : bMultiSelectable,
			labelledby : {
				value : this.getAriaLabelledBy(oControl),
				append : true
			}, 
			describedby : {
				value : this.getAriaDescribedBy(oControl),
				append : true
			}
		};
	};
	
	/**
	 * This hook method is called to finish list rendering
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ListBaseRenderer.renderListEndAttributes = function(rm, oControl) {
		rm.write("</ul>");
	};
	
	/**
	 * This hook method is called to render no data field
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ListBaseRenderer.renderNoData = function(rm, oControl) {
		rm.write("<li");
		rm.writeAttribute("tabindex", "-1");
		rm.writeAttribute("id", oControl.getId("nodata"));
		rm.addClass("sapMLIB sapMListNoData sapMLIBTypeInactive");
		rm.writeClasses();
		rm.write(">");
		
		rm.write("<div");
		rm.addClass("sapMListNoDataText");
		rm.writeAttribute("id", oControl.getId("nodata-text"));
		rm.writeClasses();
		rm.write(">");
		rm.writeEscaped(oControl.getNoDataText(true));
		rm.write("</div>");
		
		rm.write("</li>");
	};

	return ListBaseRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ListBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ListItemBaseRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ListItemBaseRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/m/ListItemBaseRenderer",['jquery.sap.global', 'sap/ui/core/IconPool', 'sap/ui/core/theming/Parameters'],
	function(jQuery, IconPool, Parameters) {
	"use strict";


	/**
	 * ListitemBase renderer.
	 *
	 * @namespace
	 */
	var ListItemBaseRenderer = {};
	
	// create ARIA announcements 
	var mAriaAnnouncements = {};
	
	/**
	 * Writes necessary invisible placeholder HTML attributes and styles.
	 * TODO: Why this functionality does not come from RenderManager
	 *
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @private
	 */
	ListItemBaseRenderer.writeInvisiblePlaceholderData = function(rm, oLI) {
		var sPlaceholderId = sap.ui.core.RenderPrefixes.Invisible + oLI.getId();
		var sPlaceholderHtml = ' ' +
			'id="' + sPlaceholderId + '" ' + 
			'class="sapUiHiddenPlaceholder" ' + 
			'data-sap-ui="' + sPlaceholderId + '" ' + 
			'style="display: none;"' + 
			'aria-hidden="true"';
		
		rm.write(sPlaceholderHtml);
	};
	
	ListItemBaseRenderer.renderInvisible = function(rm, oLI) {
		this.openItemTag(rm, oLI);
		this.writeInvisiblePlaceholderData(rm, oLI);
		rm.write(">");
		this.closeItemTag(rm, oLI);
	};
	
	ListItemBaseRenderer.isModeMatched = function(sMode, iOrder) {
		var mOrderConfig = (sap.m.ListBaseRenderer || {}).ModeOrder || {};
		return (mOrderConfig[sMode] == iOrder);
	};

	/**
	 * Renders the mode when item mode is in correct order
	 * 
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @param {int} [iOrder] expected order for the rendering
	 * @protected
	 */
	ListItemBaseRenderer.renderMode = function(rm, oLI, iOrder) {
		var sMode = oLI.getMode();
		if (!this.isModeMatched(sMode, iOrder)) {
			return;
		}
		
		var oModeControl = oLI.getModeControl();
		if (oModeControl) {
			this.renderModeContent(rm, oLI, oModeControl);
		}
	};

	ListItemBaseRenderer.renderModeContent = function(rm, oLI, oModeControl) {
		var sMode = oLI.getMode(),
			mModeConfig = {
				Delete : "D",
				MultiSelect : "M",
				SingleSelect : "S",
				SingleSelectLeft : "SL"
			};

		rm.write("<div");
		rm.writeAttribute("id", oLI.getId() + "-mode");
		rm.addClass("sapMLIBSelect" + mModeConfig[sMode]);
		this.decorateMode(rm, oLI);
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
		rm.renderControl(oModeControl);
		rm.write("</div>");
	};

	ListItemBaseRenderer.decorateMode = function(rm, oLI) {
		if (!oLI.getListProperty("modeAnimationOn")) {
			return;
		}

		var sMode = oLI.getMode(),
			sLastListMode = oLI.getListProperty("lastMode");
		
		// determine whether list mode is changed or not
		if (!sLastListMode || sLastListMode == sMode) {
			return;
		}

		if (sMode == sap.m.ListMode.None) {
			rm.addClass("sapMLIBUnselectAnimation");
		} else {
			rm.addClass("sapMLIBSelectAnimation");
		}
	};

	/**
	 * Renders counter if it is not empty
	 * 
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @protected
	 */
	ListItemBaseRenderer.renderCounter = function(rm, oLI) {
		var iCounter = oLI.getCounter();
		if (iCounter) {
			this.renderCounterContent(rm, oLI, iCounter);
		}
	};

	ListItemBaseRenderer.renderCounterContent = function(rm, oLI, iCounter) {
		rm.write("<div");
		rm.writeAttribute("id", oLI.getId() + "-counter");
		rm.addClass("sapMLIBCounter");
		rm.writeClasses();
		rm.write(">");
		rm.write(iCounter);
		rm.write("</div>");
	};

	/**
	 * Renders type for the list item
	 * 
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @protected
	 */
	ListItemBaseRenderer.renderType = function(rm, oLI) {
		var oTypeControl = oLI.getTypeControl();
		if (oTypeControl) {
			this.renderTypeContent(rm, oLI, oTypeControl);
		}
	};

	ListItemBaseRenderer.renderTypeContent = function(rm, oLI, oTypeControl) {
		var bDetail = oLI.getType().indexOf("Detail") != -1;
		if (bDetail) {
			rm.write("<div class='sapMLIBCursor'>");
		}

		rm.renderControl(oTypeControl);

		if (bDetail) {
			rm.write("</div>");
		}
	};

	/**
	 * Renders list item HTML starting tag
	 * 
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @protected
	 */
	ListItemBaseRenderer.openItemTag = function(rm, oLI) {
		rm.write("<li");
	};

	/**
	 * Renders list item HTML closing tag
	 * 
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @protected
	 */
	ListItemBaseRenderer.closeItemTag = function(rm, oLI) {
		rm.write("</li>");
	};

	/**
	 * Determines whether flex box wrapper is necessary or not.
	 * 
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @protected
	 */
	ListItemBaseRenderer.handleNoFlex = function(rm, oLI) {
		return !jQuery.support.hasFlexBoxSupport;
	};

	ListItemBaseRenderer.renderTabIndex = function(rm, oLI) {
		rm.writeAttribute("tabindex", "-1");
	};

	ListItemBaseRenderer.renderTooltip = function(rm, oLI) {
		var sTooltip = oLI.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
	};
	
	/**
	 * Creates an invisible aria node for the given message bundle text  
	 * in the static UIArea and returns its id for ARIA announcements
	 * 
	 * This method should be used when text is reached frequently.
	 * 
	 * @param {String} sKey key of the announcement
	 * @param {String} [sBundleText] key of the announcement
	 * @returns {String} id of the generated invisible aria node
	 * @protected
	 */
	ListItemBaseRenderer.getAriaAnnouncement = function(sKey, sBundleText) {
		if (mAriaAnnouncements[sKey]) {
			return mAriaAnnouncements[sKey];
		}
		
		sBundleText = sBundleText || "LIST_ITEM_" + sKey.toUpperCase();
		mAriaAnnouncements[sKey] = new sap.ui.core.InvisibleText({
			text : sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(sBundleText)
		}).toStatic().getId();
		
		return mAriaAnnouncements[sKey];
	};

	
	/**
	 * Returns aria accessibility role
	 *
	 * @param {sap.ui.core.Control} oLI an object representation of the control
	 * @returns {String}
	 * @protected
	 */
	ListItemBaseRenderer.getAriaRole = function(oLI) {
		return "option";
	};
	
	/**
	 * Returns the inner aria labelledby ids for the accessibility
	 *
	 * @param {sap.ui.core.Control} oLI an object representation of the control 
	 * @returns {String|undefined}
	 * @protected
	 */
	ListItemBaseRenderer.getAriaLabelledBy = function(oLI) {
	};
	
	/**
	 * Returns the inner aria describedby ids for the accessibility
	 *
	 * @param {sap.ui.core.Control} oLI an object representation of the control
	 * @returns {String|undefined} 
	 * @protected
	 */
	ListItemBaseRenderer.getAriaDescribedBy = function(oLI) {
		var aDescribedBy = [],
			sType = oLI.getType(),
			mType = sap.m.ListType;
		
		if (oLI.getListProperty("showUnread") && oLI.getUnread()) {
			aDescribedBy.push(this.getAriaAnnouncement("unread"));
		}
		
		if (oLI.getMode() == sap.m.ListMode.Delete) {
			aDescribedBy.push(this.getAriaAnnouncement("deletable"));
		}
		
		if (sType == mType.Navigation) {
			aDescribedBy.push(this.getAriaAnnouncement("navigation"));
		} else {
			if (sType == mType.Active || sType == mType.DetailAndActive) {
				aDescribedBy.push(this.getAriaAnnouncement("active"));
			}
			if (sType == mType.Detail || sType == mType.DetailAndActive) {
				aDescribedBy.push(this.getAriaAnnouncement("detail"));
			}
		}
		
		return aDescribedBy.join(" ");
	};
	
	/**
	 * Returns the accessibility state of the control
	 *
	 * @param {sap.ui.core.Control} oLI an object representation of the control
	 * @protected
	 */
	ListItemBaseRenderer.getAccessibilityState = function(oLI) {
		return {
			role : this.getAriaRole(oLI),
			labelledby : {
				value : this.getAriaLabelledBy(oLI),
				append : true
			},
			describedby : {
				value : this.getAriaDescribedBy(oLI),
				append : true
			}
		};
	};
	
	/**
	 * Hook for rendering list item contents
	 * 
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @protected
	 */
	ListItemBaseRenderer.renderLIContent = function(rm, oLI) {
	};
	
	/**
	 * Hook for changing list item attributes
	 * 
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @protected
	 */
	ListItemBaseRenderer.renderLIAttributes = function(rm, oLI) {
	};

	
	ListItemBaseRenderer.renderLIContentWrapper = function(rm, oLI) {
		rm.write('<div class="sapMLIBContent"');
		rm.writeAttribute("id", oLI.getId() + "-content");
		rm.write(">");
		
		// additional content with class for no-flex case
		if (this.handleNoFlex()) {
			rm.write('<div class="sapMLIBContentNF">');
		}

		this.renderLIContent(rm, oLI);

		if (this.handleNoFlex()) {
			rm.write('</div>');
		}

		rm.write('</div>');
	};


	/**
	 * Renders the HTML for the given control, using the provided.
	 *
	 * {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the Render-Output-Buffer.
	 * @param {sap.ui.core.Control} oLI an object representation of the control that should be rendered.
	 * @public
	 */
	ListItemBaseRenderer.render = function(rm, oLI) {

		// render invisible placeholder
		if (!oLI.getVisible()) {
			this.renderInvisible(rm, oLI);
			return false;
		}

		// start
		this.openItemTag(rm, oLI);
		rm.writeControlData(oLI);

		// classes
		rm.addClass("sapMLIB");
		rm.addClass("sapMLIB-CTX");
		rm.addClass("sapMLIBShowSeparator");
		rm.addClass("sapMLIBType" + oLI.getType());

		if (oLI.isClickable()) {
			rm.addClass("sapMLIBCursor");
		}

		if (oLI.getSelected()) {
			rm.addClass("sapMLIBSelected");
		}

		if (this.handleNoFlex()) {
			rm.addClass("sapMLIBNoFlex");
		}

		if (oLI.getListProperty("showUnread") && oLI.getUnread()) {
			rm.addClass("sapMLIBUnread");
		}

		// attributes
		this.renderTooltip(rm, oLI);
		this.renderTabIndex(rm, oLI);
		
		// handle accessibility states
		rm.writeAccessibilityState(oLI, this.getAccessibilityState(oLI));

		// item attributes hook
		this.renderLIAttributes(rm, oLI);

		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");

		// mode for left hand side of the content
		this.renderMode(rm, oLI, -1);
		
		this.renderLIContentWrapper(rm, oLI);
		this.renderCounter(rm, oLI);
		this.renderType(rm, oLI);

		// mode for right hand side of the content
		this.renderMode(rm, oLI, 1);

		this.closeItemTag(rm, oLI);
	};

	return ListItemBaseRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ListItemBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ListRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ListRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ListRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './ListBaseRenderer'],
	function(jQuery, Renderer, ListBaseRenderer) {
	"use strict";


	/**
	 * List renderer.
	 *
	 * ListRenderer extends the ListBaseRenderer
	 * @namespace
	 * @alias sap.m.ListRenderer
	 */
	var ListRenderer = Renderer.extend(ListBaseRenderer);
	
	ListRenderer.render = function(rm, oControl) {
		// if "columns" aggregation is not in use then we do not need backwards compatibility
		if (!oControl.getColumns().length) {
			ListBaseRenderer.render.call(this, rm, oControl);
			return;
		}
		
		/*
		 * For backwards compatibility we need to render List with columns
		 * However, if the compatibility version is 1.16 or higher then
		 * we stop rendering to force using Table control with columns
		 */
		if (oControl._isColumnsIncompatible()) {
			jQuery.sap.log.warning("Does not render sap.m.List#" + oControl.getId() + " with columns aggregation when compatibility version is 1.16 or higher. Instead use sap.m.Table control!");
			return;
		}
		
		/*
		 * FIXME: Here to support old API if columns are set
		 * We are trying to extend renderer to render list as table
		 * This is so ugly and we need to get rid of it ASAP
		 */
		jQuery.sap.require("sap.m.TableRenderer");
		var oRenderer = jQuery.extend({}, this, sap.m.TableRenderer);
		ListBaseRenderer.render.call(oRenderer, rm, oControl);
	};
	
	

	return ListRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ListRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.MessagePageRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.m.MessagePage
jQuery.sap.declare('sap.m.MessagePageRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/MessagePageRenderer",['jquery.sap.global'],
		function(jQuery) {
			"use strict";


			/**
			 * MessagePage renderer.
			 * @namespace
			 */
			var MessagePageRenderer = {};

			/**
			 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
			 *
			 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
			 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
			 */
			MessagePageRenderer.render = function(oRm, oMessagePage) {
				oRm.write("<div");
				oRm.writeControlData(oMessagePage);
				oRm.addClass("sapMMessagePage");
				oRm.writeClasses();
				oRm.write(">");
				oRm.renderControl(oMessagePage.getAggregation("_page"));
				oRm.write("</div>");
			};

			return MessagePageRenderer;

		}, /* bExport= */ true);

}; // end of sap/m/MessagePageRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.MessagePopoverRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.MessagePopoverRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/MessagePopoverRenderer",["jquery.sap.global"],
	function(jQuery) {
		"use strict";

		/**
		 * MessagePopover renderer.
		 * @namespace
		 */
		var MessagePopoverRenderer = {};

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
		 */
		MessagePopoverRenderer.render = function (oRm, oControl) {};

		return MessagePopoverRenderer;

	}, /* bExport= */ true);

}; // end of sap/m/MessagePopoverRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.MessageToast') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.MessageToast'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
sap.ui.define("sap/m/MessageToast",['jquery.sap.global', './InstanceManager', 'sap/ui/core/Popup'],
	function(jQuery, InstanceManager, Popup) {
		"use strict";

		/**
		 * @class
		 * A message toast notification offers simple feedback about an operation in a pop-up.
		 * Toasts automatically disappear after a timeout unless the user moves the mouse over
		 * the toast or taps on it. In this case the toast will remain on the screen and can
		 * be closed when the user moves the mouse out or taps out of the toast.
		 * Toasts appears close the bottom of the screen, centered horizontally, but you can change
		 * this position which is not dependent on the default values of the position settings.
		 * The default position applies as long as the application does not do any position setting.
		 * Position settings are "my", "at", "of" and "offset".
		 *
		 * Beware that only one message toast can be shown at a time in the same place.
		 * If you want to have multiple message toasts visible at the same time, you need to position
		 * the message toasts in different places.
		 * This positioning needs to be handled in the application logic.
		 *
		 * Message toast example:
		 *
		 * <pre>
		 * sap.m.MessageToast.show("This message should appear in the message toast", {
		 *     duration: 3000,                  // default
		 *     width: "15em",                   // default
		 *     my: "center bottom",             // default
		 *     at: "center bottom",             // default
		 *     of: window,                      // default
		 *     offset: "0 0",                   // default
		 *     collision: "fit fit"             // default
		 *     onClose: null,                   // default
		 *     autoClose: true,                 // default
		 *     animationTimingFunction: "ease", // default
		 *     animationDuration: 1000,         // default
		 *     closeOnBrowserNavigation: true   // default
		 * });
		 * </pre>
		 *
		 * @author SAP SE
		 * @since 1.9.2
		 *
		 * @namespace
		 * @public
		 * @alias sap.m.MessageToast
		 */
		var MessageToast = {};

		/* =========================================================== */
		/* Internal methods and properties                             */
		/* =========================================================== */

		var OFFSET = "0 -64",
			CSSCLASS = "sapMMessageToast",
			ENABLESELECTIONCLASS = "sapUiSelectable";

		MessageToast._mSettings = {
			duration: 3000,
			width: "15em",
			my: "center bottom",
			at: "center bottom",
			of: document.defaultView,
			offset: "0 0",
			collision: "fit fit",
			onClose: null,
			animationTimingFunction: "ease",
			animationDuration: 1000,
			autoClose: true,
			closeOnBrowserNavigation: true
		};

		MessageToast._aPopups = [];

		MessageToast._iOpenedPopups = 0;

		MessageToast._bBoundedEvents = false;

		MessageToast._validateSettings = function(mSettings) {

			// duration
			this._isFiniteInteger(mSettings.duration);

			// width
			this._validateWidth(mSettings.width);

			// my
			this._validateDockPosition(mSettings.my);

			// at
			this._validateDockPosition(mSettings.at);

			// of
			this._validateOf(mSettings.of);

			// offset
			this._validateOffset(mSettings.offset);

			// collision
			this._validateCollision(mSettings.collision);

			// onClose
			this._validateOnClose(mSettings.onClose);

			// autoClose
			this._validateAutoClose(mSettings.autoClose);

			// animationTimingFunction
			this._validateAnimationTimingFunction(mSettings.animationTimingFunction);

			// animationDuration
			this._isFiniteInteger(mSettings.animationDuration);
		};

		MessageToast._isFiniteInteger = function(iNumber) {
			if (typeof iNumber !== "number" || !isFinite(iNumber) || !(Math.floor(iNumber) === iNumber) || iNumber <= 0) {
				jQuery.sap.log.error('"iNumber" needs to be a finite positive nonzero integer on ' + this + "._isFiniteInteger");
			}
		};

		MessageToast._validateWidth = function(sWidth) {
			if (!sap.ui.core.CSSSize.isValid(sWidth)) {
				jQuery.sap.log.error(sWidth + ' is not of type ' + '"sap.ui.core.CSSSize" for property "width" on ' + this + "._validateWidth");
			}
		};

		MessageToast._validateDockPosition = function(sDock) {
			if (!sap.ui.core.Dock.isValid(sDock)) {
				jQuery.sap.log.error('"' + sDock + '"' + ' is not of type ' + '"sap.ui.core.Popup.Dock" on ' + this + "._validateDockPosition");
			}
		};

		MessageToast._validateOf = function(vElement) {
			if (!(vElement instanceof jQuery) &&
				!jQuery.isWindow(vElement) &&
				!(vElement && vElement.nodeType === 1) &&
				!(vElement instanceof sap.ui.core.Control)) {

				jQuery.sap.log.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on ' + this + "._validateOf");
			}
		};

		MessageToast._validateOffset = function(sOffset) {
			if (typeof sOffset !== "string") {
				jQuery.sap.log.error(sOffset + ' is of type ' + typeof sOffset + ', expected "string" for property "offset" on ' + this + "._validateOffset");
			}
		};

		MessageToast._validateCollision = function(sCollision) {
			var rValidCollisions = /^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;

			if (!rValidCollisions.test(sCollision)) {
				jQuery.sap.log.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on ' + this + "._validateOffset");
			}
		};

		MessageToast._validateOnClose = function(fn) {
			if (typeof fn !== "function" && fn !== null) {
				jQuery.sap.log.error('"onClose" should be a function or null on ' + this + "._validateOnClose");
			}
		};

		MessageToast._validateAutoClose = function(b) {
			if (typeof b !== "boolean") {
				jQuery.sap.log.error('"autoClose" should be a boolean on ' + this + "._validateAutoClose");
			}
		};

		MessageToast._validateAnimationTimingFunction = function(sTimingFunction) {
			var rValidTimingFn = /^(ease|linear|ease-in|ease-out|ease-in-out)$/i;

			if (!rValidTimingFn.test(sTimingFunction)) {
				jQuery.sap.log.error('"animationTimingFunction" should be a string, expected values: ' + "ease, linear, ease-in, ease-out, ease-in-out on " + this + "._validateAnimationTimingFunction");
			}
		};

		function hasDefaulPosition(mOptions) {
			for (var aPositionOptions = ["my", "at", "of", "offset"], i = 0; i < aPositionOptions.length; i++) {
				if (mOptions[aPositionOptions[i]] !== undefined) {
					return false;
				}
			}

			return true;
		}

		function createHTMLMarkup(mSettings) {
			var oMessageToastDomRef = document.createElement("div");

			oMessageToastDomRef.style.width = mSettings.width;
			oMessageToastDomRef.className = CSSCLASS + " " + ENABLESELECTIONCLASS;
			oMessageToastDomRef.setAttribute("role", "alert");
			oMessageToastDomRef.appendChild(document.createTextNode(mSettings.message));

			return oMessageToastDomRef;
		}

		function normalizeOptions(mOptions) {
			if (mOptions) {

				// if no position options are provided
				if (hasDefaulPosition(mOptions)) {

					// change the default offset
					mOptions.offset = OFFSET;
				}

				// if the document object is provided as an option, replace it with the window object,
				// the message toast should be showed relative to the visual viewport instead to the layout viewport
				if (mOptions.of && mOptions.of.nodeType === 9) {
					mOptions.of = document.defaultView;
				}
			} else {

				mOptions = {

					// if no options are provided, change the default offset
					offset: OFFSET
				};
			}

			return mOptions;
		}

		/* =========================================================== */
		/* Event handlers                                              */
		/* =========================================================== */

		MessageToast._handleResizeEvent = function() {

			if (sap.ui.Device.system.phone || sap.ui.Device.system.tablet) {
				this._resetPosition(this._aPopups);
			}

			jQuery.sap.delayedCall(0, this, "_applyPositions", [this._aPopups]);
		};

		MessageToast._handleMouseDownEvent = function(oEvent) {
			var bIsMessageToast = oEvent.target.hasAttribute("class") &&
				oEvent.target.getAttribute("class").indexOf(CSSCLASS) !== -1;

			if (bIsMessageToast || oEvent.isMarked("delayedMouseEvent")) {
				return;
			}

			this._aPopups.forEach(function(oPopup) {
				oPopup && oPopup.getAutoClose() && oPopup.close();
			});
		};

		MessageToast._resetPosition = function(aPopups) {
			for (var i = 0, oMessageToastDomRef; i < aPopups.length; i++) {
				oMessageToastDomRef = aPopups[i] && aPopups[i].getContent();

				if (oMessageToastDomRef) {
					oMessageToastDomRef.style.visibility = "hidden";
					oMessageToastDomRef.style.left = 0;
				}
			}
		};

		MessageToast._applyPositions = function(aPopups) {
			for (var i = 0, oPopup, mPosition; i < aPopups.length; i++) {
				oPopup = aPopups[i];
				if (oPopup) {
					mPosition = oPopup._oPosition;	// TODO _oPosition is a private property

					if (sap.ui.Device.system.phone || sap.ui.Device.system.tablet) {
						jQuery.sap.delayedCall(0, this, "_applyPosition", [oPopup, mPosition]);
					} else {
						oPopup.setPosition(mPosition.my, mPosition.at, mPosition.of, mPosition.offset);
					}
				}
			}
		};

		MessageToast._applyPosition = function(oPopup, mPosition) {
			var mPosition = mPosition || oPopup._oPosition,
				oMessageToastDomRef = oPopup.getContent();

			oPopup.setPosition(mPosition.my, mPosition.at, mPosition.of, mPosition.offset);
			oMessageToastDomRef.style.visibility = "visible";
		};

		MessageToast._setCloseAnimation = function($MessageToastDomRef, iDuration, fnClose, mSettings) {
			var sCssTransition = "opacity " + mSettings.animationTimingFunction + " " + mSettings.animationDuration + "ms",
				sTransitionEnd = "webkitTransitionEnd." + CSSCLASS + " transitionend." + CSSCLASS;

			if (mSettings.animationDuration > 0) {
				$MessageToastDomRef[0].style.webkitTransition = sCssTransition;
				$MessageToastDomRef[0].style.transition = sCssTransition;
				$MessageToastDomRef[0].style.opacity = 0;

				$MessageToastDomRef.on(sTransitionEnd, function handleMTTransitionEnd() {

					// unbound the event handler after its first invocation
					$MessageToastDomRef.off(sTransitionEnd);

					// handleMTClosed() function is called
					fnClose();
				});
			} else {
				fnClose();
			}
		};

		/* =========================================================== */
		/* API methods                                                 */
		/* =========================================================== */

		/**
		 * Creates and displays a simple message toast notification message with the given text, and optionally other options.
		 *
		 * The only mandatory parameter is <code>sMessage</code>.
		 *
		 * @param {string} sMessage The message to be displayed.
		 * @param {object} [mOptions] Optionally other options.
		 * @param {int} [mOptions.duration=3000] Time in milliseconds before the close animation starts. Needs to be a finite positive nonzero integer.
		 * @param {sap.ui.core.CSSSize} [mOptions.width='15em'] The width of the message toast, this value can be provided in %, em, px and all possible CSS measures.
		 * @param {sap.ui.core.Popup.Dock} [mOptions.my='center bottom'] Specifies which point of the message toast should be aligned.
		 * @param {sap.ui.core.Popup.Dock} [mOptions.at='center bottom'] Specifies the point of the reference element to which the message toast should be aligned.
		 * @param {sap.ui.core.Control|Element|jQuery|Window|undefined} [mOptions.of=window] Specifies the reference element to which the message toast should be aligned, by default it is aligned to the browser visual viewport.
		 * @param {string} [mOptions.offset='0 0'] The offset relative to the docking point, specified as a string with space-separated pixel values (e.g. "0 10" to move the message toast 10 pixels to the right).
		 * @param {string} [mOptions.collision='fit fit'] Specifies how the position of the message toast should be adjusted in case it overflows the screen in some direction. Possible values “fit”, “flip”, “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none".
		 * @param {function} [mOptions.onClose=null] Function to be called when the message toast closes.
		 * @param {boolean} [mOptions.autoClose=true] Specify whether the message toast should close as soon as the end user touches the screen.
		 * @param {string} [mOptions.animationTimingFunction='ease'] Describes how the close animation will progress. Possible values "ease", "linear", "ease-in", "ease-out", "ease-in-out". This feature is not supported in android and ie9 browsers.
		 * @param {int} [mOptions.animationDuration=1000] Time in milliseconds that the close animation takes to complete. Needs to be a finite positive integer. For not animation set to 0. This feature is not supported in android and ie9 browsers.
		 * @param {boolean} [mOptions.closeOnBrowserNavigation=true] Whether the message toast closes on browser navigation.
		 *
		 * @type void
		 * @public
		 */
		MessageToast.show = function(sMessage, mOptions) {
			var that = this,
				mSettings = jQuery.extend({}, this._mSettings, { message: sMessage }),
				oPopup = new Popup(),
				iPos,
				oMessageToastDomRef,
				iCloseTimeoutId;

			mOptions = normalizeOptions(mOptions);

			// merge mOptions into mSettings
			jQuery.extend(mSettings, mOptions);

			// validate all settings
			this._validateSettings(mSettings);

			// create the message toast HTML markup
			oMessageToastDomRef = createHTMLMarkup(mSettings);

			// save this pop-up instance and the position,
			// to be used inside fnMTAttachClosed closure
			iPos = this._aPopups.push(oPopup) - 1;

			// sets the content of the pop-up
			oPopup.setContent(oMessageToastDomRef);

			// sets the position of the pop-up
			oPopup.setPosition(mSettings.my, mSettings.at, mSettings.of, mSettings.offset, mSettings.collision);

			if (jQuery.support.cssTransitions) {

				// sets the animation functions to use for opening and closing the message toast
				oPopup.setAnimations(function fnMessageToastOpen($MessageToast, iDuration, fnOpened) {
					fnOpened();
				}, function fnMessageToastClose($MessageToastDomRef, iDuration, fnClose) {
					that._setCloseAnimation($MessageToastDomRef, iDuration, fnClose, mSettings);
				});
			}

			oPopup.setShadow(false);
			oPopup.setAutoClose(mSettings.autoClose);

			if (mSettings.closeOnBrowserNavigation) {

				// add the pop-up instance to the InstanceManager to handle browser back navigation
				InstanceManager.addPopoverInstance(oPopup);
			}

			// do not bind if already bound
			if (!this._bBoundedEvents) {

				// bind to the resize event to handle orientation change and resize events
				jQuery(window).on("resize." + CSSCLASS, this._handleResizeEvent.bind(this));
				jQuery(document).on("mousedown." + CSSCLASS, this._handleMouseDownEvent.bind(this));

				this._bBoundedEvents = true;
			}

			// opens the popup's content at the position specified via #setPosition
			oPopup.open();
			this._iOpenedPopups++;

			function handleMTClosed() {
				InstanceManager.removePopoverInstance(that._aPopups[iPos]);
				jQuery(that._aPopups[iPos].getContent()).remove();
				that._aPopups[iPos].detachClosed(handleMTClosed);
				that._aPopups[iPos].destroy();
				that._aPopups[iPos] = null;
				that._iOpenedPopups--;

				if (that._iOpenedPopups === 0) {
					that._aPopups = [];
					jQuery(window).off("resize." + CSSCLASS);
					jQuery(document).off("mousedown." + CSSCLASS);

					that._bBoundedEvents = false;
				}

				if (typeof mSettings.onClose === "function") {
					mSettings.onClose.call(that);
				}
			}

			// attach event handler fnFunction to the "closed" event
			oPopup.attachClosed(handleMTClosed);

			// close the message toast
			iCloseTimeoutId = jQuery.sap.delayedCall(mSettings.duration, oPopup, "close");

			function fnClearTimeout() {
				jQuery.sap.clearDelayedCall(iCloseTimeoutId);
				iCloseTimeoutId = null;
			}

			oPopup.getContent().addEventListener("touchstart", fnClearTimeout);
			oPopup.getContent().addEventListener("mouseover", fnClearTimeout);

			// WP 8.1 fires mouseleave event on tap
			if (sap.ui.Device.system.desktop) {
				oPopup.getContent().addEventListener("mouseleave", function () {
					iCloseTimeoutId = jQuery.sap.delayedCall(mSettings.duration,  oPopup, "close");
				});
			}
		};

		MessageToast.toString = function() {
			return "sap.m.MessageToast";
		};

		return MessageToast;

}, /* bExport= */ true);

}; // end of sap/m/MessageToast.js
if ( !jQuery.sap.isDeclared('sap.m.MultiComboBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.MultiComboBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/m/MultiComboBoxRenderer",['jquery.sap.global', './InputBaseRenderer', 'sap/ui/core/Renderer', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, InputBaseRenderer, Renderer, ValueStateSupport) {
	"use strict";


	/**
	 * MultiComboBox renderer.
	 * @namespace
	 */
	var MultiComboBoxRenderer = Renderer.extend(sap.m.ComboBoxBaseRenderer);
	
	/**
	 * CSS class to be applied to the HTML root element of the MultiComboBox control.
	 * 
	 * @type {string}
	 */
	MultiComboBoxRenderer.CSS_CLASS = "sapMMultiComboBox";
	
	/**
	 * CSS class to be applied to the HTML root element of the MultiComboBox control.
	 * 
	 * @type {string}
	 */
	MultiComboBoxRenderer.DOT_CSS_CLASS = ".sapMMultiComboBox";
	
	/**
	 * Add classes to the MultiComboBox.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *          oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control}
	 *          oControl An object representation of the control that should be rendered.
	 */
	MultiComboBoxRenderer.addOuterClasses = function(oRm, oControl) {
		sap.m.ComboBoxBaseRenderer.addOuterClasses.apply(this, arguments);
		oRm.addClass(MultiComboBoxRenderer.CSS_CLASS);
		if (oControl._hasTokens()) {
			oRm.addClass("sapMMultiComboBoxHasToken");
		}
	};
	
	/**
	 * Add inner classes to the MultiMultiComboBox's input element.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *          oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control}
	 *          oControl An object representation of the control that should be rendered.
	 */
	MultiComboBoxRenderer.addInnerClasses = function(oRm, oControl) {
		sap.m.ComboBoxBaseRenderer.addInnerClasses.apply(this, arguments);
		oRm.addClass(MultiComboBoxRenderer.CSS_CLASS + "InputInner");
	};
	
	MultiComboBoxRenderer.openInputTag = function(oRm, oControl) {
		oRm.write('<div class="sapMMultiComboBoxBorder"');
		oRm.writeAttribute("id", oControl.getId() + "-border");  // UI5 core expect a DIV with ID	
		oRm.write(">");
		
		oRm.renderControl(oControl._oTokenizer);
		
		oRm.write("<div class=\"sapMMultiComboBoxInputContainer\">");
		InputBaseRenderer.openInputTag.call(this, oRm, oControl);
	};
	
	MultiComboBoxRenderer.closeInputTag = function(oRm, oControl) {
		InputBaseRenderer.closeInputTag.call(this, oRm, oControl);
		oRm.write("</div>");
		oRm.write("</div>");
		oRm.write("<div class=\"sapMMultiComboBoxShadowDiv\"/>");
	};
	

	return MultiComboBoxRenderer;

}, /* bExport= */ true);

}; // end of sap/m/MultiComboBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.MultiInputRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.MultiInputRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/MultiInputRenderer",['jquery.sap.global', './InputRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, InputRenderer, Renderer) {
	"use strict";


	/**
	 * MultiInput renderer.
	 * @namespace
	 */
	var MultiInputRenderer = Renderer.extend(InputRenderer);
	
	MultiInputRenderer.openInputTag = function(oRm, oControl) {
		
		if (oControl.getEnableMultiLineMode()){
			
			oControl._isMultiLineMode = true;
			
			// add multi-line css to the boarder if the multi-line mode is on 
			if ( !oControl._bUseDialog && oControl._bShowIndicator === false ) {
				oRm.write("<div id=\"" + oControl.getId() + "-border\" class=\"sapMMultiInputBorder sapMMultiInputMultiModeBorder\">");					
			} else {
				oControl._showIndicator();	
				
				//render the single line
				oRm.write("<div id=\"" + oControl.getId() + "-border\" class=\"sapMMultiInputBorder\">");
				setTimeout(function() {
					oControl._setContainerSizes();
				}, 0);
			}

		} else {
			oRm.write("<div id=\"" + oControl.getId() + "-border\" class=\"sapMMultiInputBorder\">");
			
		}

		MultiInputRenderer._renderTokens(oRm, oControl);
		MultiInputRenderer._renderInput(oRm, oControl);	
	};

	MultiInputRenderer._renderTokens = function(oRm, oControl) {
		oRm.renderControl(oControl._tokenizer);
	};
	
	MultiInputRenderer._renderInput = function(oRm, oControl) {
		
		if ( oControl.getEnableMultiLineMode() && oControl._bShowIndicator === false ) {
			oRm.write("<div class=\"sapMMultiInputInputContainer sapMMultiInputMultiModeInputContainer\">");
		} else {
			oRm.write("<div class=\"sapMMultiInputInputContainer\">");
		}

		InputRenderer.openInputTag.call(this, oRm, oControl);
	};
	
	MultiInputRenderer.writeInnerAttributes = function(oRm, oControl) {
		if (oControl.getEnableMultiLineMode() && oControl._bShowIndicator === true) {
			oRm.writeAttribute("readonly", "readonly");
		}
	};
	
	MultiInputRenderer.closeInputTag = function(oRm, oControl) {
		InputRenderer.closeInputTag.call(this, oRm, oControl);
		oRm.write("</div>");
		oRm.write("</div>");
		oRm.write("<div class=\"sapMMultiInputShadowDiv\"/>");
	};
	

	return MultiInputRenderer;

}, /* bExport= */ true);

}; // end of sap/m/MultiInputRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.NavContainerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.NavContainerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/NavContainerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * NavContainer renderer.
	 * @namespace
	 */
	var NavContainerRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	NavContainerRenderer.render = function(rm, oControl) {
		// return immediately if control is invisible
		if (!oControl.getVisible()) {
			return;
		}

		rm.write("<div");
		rm.writeControlData(oControl);

		rm.addClass("sapMNav");
		if (oControl.getWidth()) {
			rm.addStyle("width", oControl.getWidth());
		}
		var sHeight = oControl.getHeight();
		if (sHeight && sHeight != "100%") {
			rm.addStyle("height", sHeight);
		}

		if (this.renderAttributes) {
			this.renderAttributes(rm, oControl); // may be used by inheriting renderers, but DO NOT write class or style attributes! Instead, call addClass/addStyle.
		}

		rm.writeClasses();
		rm.writeStyles();

		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		rm.write(">"); // div element

		if (this.renderBeforeContent) {
			this.renderBeforeContent(rm, oControl); // may be used by inheriting renderers
		}

		var oContent = oControl.getCurrentPage();
		if (oContent) {
			oContent.removeStyleClass("sapMNavItemHidden"); // In case the current page was hidden (the previous current page got removed)
			rm.renderControl(oContent);
		}

		rm.write("</div>");
	};


	return NavContainerRenderer;

}, /* bExport= */ true);

}; // end of sap/m/NavContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectAttributeRenderer') ) {
/*
 * @copyright
 */
jQuery.sap.declare('sap.m.ObjectAttributeRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectAttributeRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ObjectAttributeA renderer. 
	 * @namespace
	 */
	var ObjectAttributeRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ObjectAttributeRenderer.render = function(oRm, oOA) {
		// return immediately if control is invisible
		if (!oOA._isEmpty()) {
			var oParent = oOA.getParent(),
				sTextDir = oOA.getTextDirection();
			oRm.write("<div");
			oRm.writeControlData(oOA);
			oRm.addClass("sapMObjectAttributeDiv");
			if (oOA.getActive()) {
				oRm.addClass("sapMObjectAttributeActive");
				oRm.writeAttribute("tabindex", "0");
			}
			oRm.writeClasses();
	
			var sTooltip = oOA.getTooltip_AsString();
			if (sTooltip) {
				oRm.writeAttributeEscaped("title", sTooltip);
			}
			
			// ARIA
			if (oOA.getActive()) {
				oRm.writeAccessibilityState(oOA, {
					role: "link"
				});
			}

			oRm.write(">");
			if (oParent && (oParent instanceof sap.m.ObjectHeader)) {
				if (oOA.getProperty("title")) {
					oRm.write("<span id=\"" + oOA.getId() + "-title\"");
					oRm.addClass("sapMObjectAttributeTitle");
					oRm.writeClasses();
					oRm.write(">");
					oRm.writeEscaped(oOA.getProperty("title"));
					oRm.write("</span>");
					oRm.write("<span id=\"" + oOA.getId() + "-colon\"");
					oRm.addClass("sapMObjectAttributeColon");
					oRm.writeClasses();
					oRm.write(">");
					oRm.write(":&nbsp;");
					oRm.write("</span>");
				}
				oRm.write("<span id=\"" + oOA.getId() + "-text\"");
				oRm.addClass("sapMObjectAttributeText");
				if (sTextDir && sTextDir !== sap.ui.core.TextDirection.Inherit) {
					oRm.writeAttribute("dir", sTextDir.toLowerCase());
				}
				oRm.writeClasses();
				oRm.write(">");
				oRm.writeEscaped(oOA.getProperty("text"));
				oRm.write("</span>");
			} else {
				oRm.renderControl(oOA._getUpdatedTextControl());
			}
			oRm.write("</div>");
		}
	};

	return ObjectAttributeRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ObjectAttributeRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectHeaderRenderer') ) {
/**
 * @copyright
 */
jQuery.sap.declare('sap.m.ObjectHeaderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectHeaderRenderer",['jquery.sap.global', 'sap/ui/core/IconPool'],
	function(jQuery, IconPool) {
	"use strict";


	/**
	 * ObjectHeader renderer.
	 * @namespace
	 */
	var ObjectHeaderRenderer = {};

	/**
	 * Check if the object exists. In case object has _isEmpty() method then this method is called. If there is no such method then object is not empty.
	 *
	 * @param {sap.ui.core.Control}
	 *            oObject to be checked
	 *
	 * @returns true is the object is not empty, false - otherwise.
	 * @private
	 */
	ObjectHeaderRenderer._isEmptyObject = function(oObject) {

		if (!oObject) {
			return true;
		}

		if ((!oObject._isEmpty || !oObject._isEmpty()) && (!oObject.getVisible || oObject.getVisible())) {
			return false;
		}
		return true;
	};

	/**
	 * Array is considered empty if it is null or undefined or has no controls or all the controls are empty.
	 *
	 * @param {sap.ui.core.Control[]}
	 *            aArray array of controls to be checked
	 *
	 * @returns true if array is empty, false - otherwise.
	 * @private
	 */
	ObjectHeaderRenderer._isEmptyArray = function(aArray) {

		if (aArray) {
			for (var i = 0; i < aArray.length; i++) {
				if (!ObjectHeaderRenderer._isEmptyObject(aArray[i])) {
					return false;
				}
			}
		}
		return true;
	};

	/**
	 * A row is considered empty if both input parameters are empty.
	 *
	 * @param {sap.ui.core.Control}
	 *            aLeft control to be checked
	 *
	 * @param {sap.ui.core.Control[]}
	 *            aRight array of controls to be checked
	 *
	 * @returns true if array is empty, false - otherwise.
	 * @private
	 */
	ObjectHeaderRenderer._isEmptyRow = function(oLeft, aRight) {

		return ObjectHeaderRenderer._isEmptyObject(oLeft) && ObjectHeaderRenderer._isEmptyArray(aRight);
	};

	/**
	 * Render an array of controls.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.ui.core.Control[]}
	 *            aObjects array of controls to be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderObjects = function(oRM, aObjects, oOH) {

		for (var i = 0; i < aObjects.length; i++) {
			if (aObjects[i] instanceof sap.ui.core.Control) {
				this._renderChildControl(oRM, oOH, aObjects[i]);
			}
		}
	};
	
	/**
	 * Gather all controls that should be rendered inside Object Header.
	 *
	 * @param {sap.m.ObjectHeader}
	 *            oControl the ObjectHeader
	 * @private
	 */
	ObjectHeaderRenderer._computeChildControlsToBeRendered = function(oOH){
		oOH.__controlsToBeRendered = {};
		var aChildren = oOH.getAttributes();
		for (var i = 0; i < aChildren.length; i++) {
			oOH.__controlsToBeRendered[aChildren[i].getId()] = aChildren[i];
		}
		aChildren = oOH.getStatuses();
		for (var i = 0; i < aChildren.length; i++) {
			oOH.__controlsToBeRendered[aChildren[i].getId()] = aChildren[i];
		}
		var oChild = oOH.getFirstStatus();
		if (oChild) {
			oOH.__controlsToBeRendered[oChild.getId()] = oChild;
		}
		oChild = oOH.getSecondStatus();
		if (oChild) {
			oOH.__controlsToBeRendered[oChild.getId()] = oChild;
		}
		oChild = oOH.getAggregation("_objectNumber");
		if (oChild) {
			oOH.__controlsToBeRendered[oChild.getId()] = oChild;
		}
	};
	
	/**
	 * Delete all controls that were empty and were not rendered inside Object Header.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.m.ObjectHeader}
	 *            oControl the ObjectHeader
	 * @private
	 */
	ObjectHeaderRenderer._cleanupNotRenderedChildControls = function(oRM, oOH){
		for (var id in oOH.__controlsToBeRendered) {
			oRM.cleanupControlWithoutRendering(oOH.__controlsToBeRendered[id]);
		}
		delete oOH.__controlsToBeRendered;
	};
	
	/**
	 * Renders hidden div with ARIA descriptions of the favorite and flag icons.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.m.ObjectHeader}
	 *            oControl the ObjectHeader
	 *
	 * @private
	 */
	ObjectHeaderRenderer._renderMarkersAria = function(oRM, oControl) {
		var sAriaDescription = "", // ARIA description message
			oLibraryResourceBundle = sap.ui.getCore().getLibraryResourceBundle("sap.m"); // get resource translation bundle
		
			// check if flag mark is set
			if (oControl.getMarkFlagged()) {
				sAriaDescription += (oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE") + " ");
			}
		
			// check if favorite mark is set
			if (oControl.getMarkFavorite()) {
				sAriaDescription += (oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE") + " ");
			}
		
			// if there is a description render ARIA node
			if (sAriaDescription !== "") {	
				// BEGIN ARIA hidden node
				oRM.write("<div");
		
				oRM.writeAttribute("id", oControl.getId() + "-markers-aria");
				oRM.writeAttribute("aria-hidden", "false");
				oRM.addClass("sapUiHidden");
				oRM.writeClasses();
				oRM.write(">");
				oRM.writeEscaped(sAriaDescription);
		
				oRM.write("</div>");
				// END ARIA hidden node
			}
	};
	
	/**
	 * Returns the array of icons from ObjectHeader.
	 *
	 * @param {sap.m.ObjectHeader}
	 *            oOH the ObjectHeader that contains icons
	 *
	 * @returns array of {sap.m.Image} controls
	 *
	 * @private
	 */
	ObjectHeaderRenderer._getIcons = function(oOH) {

		var icons = [];

		if (oOH.getShowMarkers()) {
			oOH._oFavIcon.setVisible(oOH.getMarkFavorite());
			oOH._oFlagIcon.setVisible(oOH.getMarkFlagged());

			icons.push(oOH._oPlaceholderIcon);
			icons.push(oOH._oFavIcon);
			icons.push(oOH._oFlagIcon);
		}

		return icons;
	};

	/**
	 * Render intro as sap.m.Text or sap.m.Link depending if it's active or not.
	 * used in both ObjectHeader and ObjectHeaderResponsive
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.ObjectHeader}
	 *            oOH the ObjectHeader that contains icons
	 * @param {string}
	 *            sIntroClass the css class of the intro container
	 * @param {string}
	 *            sIntroActiveClass the css class of the intro container if the intro is active
	 * @private
	 */
	ObjectHeaderRenderer._renderIntro = function(oRM, oOH, sIntroClass, sIntroActiveClass) {
		if (oOH.getIntroActive()) {
			oOH._introText = new sap.m.Link(oOH.getId() + "-intro");
			oOH._introText.setText(oOH.getIntro());
			oOH._introText.setHref(oOH.getIntroHref());
			oOH._introText.setTarget(oOH.getIntroTarget());
			oOH._introText.press = oOH.introPress;
		} else {
			oOH._introText = new sap.m.Text(oOH.getId() + "-intro");
			oOH._introText.setText(oOH.getIntro());
			oOH._introText.setMaxLines(3);
		}
		// set text direction of the intro
		oOH._introText.setTextDirection(oOH.getIntroTextDirection());
		oRM.write("<div");
		oRM.addClass(sIntroClass);
		if (oOH.getIntroActive()) {
			oRM.addClass(sIntroActiveClass);
		}
		oRM.writeClasses();
		oRM.write(">");
		this._renderChildControl(oRM, oOH, oOH._introText);
		oRM.write("</div>");
	};

	/**
	 * Renders the HTML for Attribute.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.ObjectHeader}
	 *            oOH an object to be rendered
	 * @param {sap.m.ObjectAttribute}
	 *            oAttr an attribute to be rendered
	 * @param {boolean} bFullWidth set the attribute width to 100%
	 * @private
	 */
	ObjectHeaderRenderer._renderAttribute = function(oRM, oOH, oAttr, bFullWidth) {
		oRM.write("<div");
		oRM.addClass("sapMOHAttr");
		oRM.writeClasses();
		if (bFullWidth) {
			oRM.addStyle("width", "100%");
			oRM.writeStyles();
		}
		oRM.write(">");
		this._renderChildControl(oRM, oOH, oAttr);
		oRM.write("</div>");
	};

	/**
	 * Validate the statuses control list to only display sap.m.ObjectStatus and
	 * sap.m.ProgressIndicator and returns only the visible once that should be rendered
	 *
	 * @param {sap.m.ObjectHeader}
	 *            oOH an object to be rendered
	 * @private
	 */
	ObjectHeaderRenderer._getVisibleStatuses = function(oOH) {
		var aVisibleStatuses = [];

		if (oOH.getFirstStatus() && oOH.getFirstStatus().getVisible()) {
			aVisibleStatuses.push([oOH.getFirstStatus()]);
		}
		if (oOH.getSecondStatus() && oOH.getSecondStatus().getVisible()) {
			aVisibleStatuses.push([oOH.getSecondStatus()]);
		}

		if (oOH.getStatuses()) {
			var aStatuses = oOH.getStatuses();
			for (var i = 0; i < aStatuses.length; i++) {
				if (!aStatuses[i].getVisible || aStatuses[i].getVisible()) {
					if (aStatuses[i] instanceof sap.m.ObjectStatus || aStatuses[i] instanceof sap.m.ProgressIndicator) {
						aVisibleStatuses.push([aStatuses[i]]);
					} else {
						jQuery.sap.log.warning("Only sap.m.ObjectStatus or sap.m.ProgressIndicator are allowed in \"sap.m.ObjectHeader.statuses\" aggregation." + " Current object is "
								+ aStatuses[i].constructor.getMetadata().getName() + " with id \"" + aStatuses[i].getId() + "\"");
					}
				}
			}
		}

		return aVisibleStatuses;
	};

	/**
	 * Returns only the visible statuses and attributes that should be rendered
	 *
	 * @param {sap.m.ObjectHeader}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._getVisibleAttribsAndStatuses = function(oOH) {
		var aResult = [],
			aAttribs = oOH.getAttributes(),
			aVisibleAttribs = [];

		for (var j = 0; j < aAttribs.length; j++) {
			if (aAttribs[j].getVisible()) {
				aVisibleAttribs.push(aAttribs[j]);
			}
		}

		var aVisibleStatuses = this._getVisibleStatuses(oOH);

		aResult[0] = aVisibleAttribs;
		aResult[1] = aVisibleStatuses;

		return aResult;
	};

	/**
	 * Renders the HTML for single line of Attribute and Status.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.ObjectHeader}
	 *            oOH an object to be rendered
	 * @param {sap.m.ObjectAttribute}
	 *            oLeft an attribute to be rendered
	 * @param {sap.ui.core.Control[]}
	 * aRight a status or Progress Indicator Array to be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderRow = function(oRM, oOH, oLeft, aRight) {

		if (ObjectHeaderRenderer._isEmptyRow(oLeft, aRight)) {
			return; // nothing to render
		}

		oRM.write("<div"); // Start attribute row container
		oRM.addClass("sapMOHAttrRow");
		oRM.writeClasses();
		oRM.write(">");

		if (!ObjectHeaderRenderer._isEmptyObject(oLeft)) { // if the object with the attributes is not empty then render the attributes
			this._renderAttribute(oRM, oOH, oLeft, ObjectHeaderRenderer._isEmptyArray(aRight));
		} else if (ObjectHeaderRenderer._isEmptyObject(oLeft) && !ObjectHeaderRenderer._isEmptyArray(aRight)) {
			// if there are no attributes at all and the array containing statuses and progress indicators isn't empty
			if (aRight[0] instanceof sap.m.ProgressIndicator) { // check if the first element in the array is progress indicator, and if it's so then place an empty "attribute" div before the progress indicator
				oRM.write("<div");
				oRM.addClass("sapMOHAttr");
				oRM.writeClasses();
				oRM.write(">");
				oRM.write("</div>");
			}
		}

		if (!ObjectHeaderRenderer._isEmptyArray(aRight)) { // check do we have statuses, icons or progress indicators and render them accordingly
			oRM.write("<div");
			if (aRight[0] instanceof sap.m.ProgressIndicator) {
				oRM.addClass("sapMOHStatusFixedWidth");
			} else if (aRight[0] instanceof sap.ui.core.Icon) {
				oRM.addClass("sapMOHStatusFixedWidth");
				oRM.addClass("sapMObjStatusMarker");
				oRM.writeAttribute("aria-describedby", oOH.getId() + "-markers-aria");
			} else {
				oRM.addClass("sapMOHStatus");
			}
			oRM.writeClasses();
			oRM.write(">");
			ObjectHeaderRenderer._renderObjects(oRM, aRight, oOH);
			oRM.write("</div>");
		}

		oRM.write("</div>"); // end attribute row container
	};

	/**
	 * Renders the HTML for attributes and statuses, using the provided {@link sap.ui.core.RenderManager}. Validate the statuses control list to only display ObjectStatus and
	 * ProgressIndicator
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.ObjectHeader}
	 *            oOH an object to be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderAttributesAndStatuses = function(oRM, oOH) {
		var aAttribs = oOH.getAttributes();
		var aVisibleAttribs = [];

		for (var j = 0; j < aAttribs.length; j++) {
			if (aAttribs[j].getVisible()) {
				aVisibleAttribs.push(aAttribs[j]);
			}
		}

		var iAttribsLength = aVisibleAttribs.length;

		var aIconsAndStatuses = [];
		var aIcons = ObjectHeaderRenderer._getIcons(oOH);
		// flag and favorite are not rendered here in responsive mode
		if (!oOH.getResponsive() && !ObjectHeaderRenderer._isEmptyArray(aIcons)) {
			aIconsAndStatuses.push(aIcons);
		}

		var aVisibleStatuses = this._getVisibleStatuses(oOH);

		aIconsAndStatuses = aIconsAndStatuses.concat(aVisibleStatuses);

		var iIconsAndStatusesLength = aIconsAndStatuses.length;

		var iNoOfRows = iAttribsLength > iIconsAndStatusesLength ? iAttribsLength : iIconsAndStatusesLength;

		if (!oOH.getResponsive()) {
			if (oOH.getShowMarkers()) {
				this._renderMarkersAria(oRM, oOH);
			}
			for (var iCount = 0; iCount < iNoOfRows; iCount++) {
				this._renderRow(oRM, oOH, aVisibleAttribs[iCount], aIconsAndStatuses[iCount]);
			}
		}

	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderNumber = function(oRM, oOH) {
		if (!oOH.getNumber()) {
			return;
		}

		// Container for a number and a units qualifier.
		oRM.write("<div"); // Start Number/units container
		oRM.writeAttribute("id", oOH.getId() + "-numberdiv");
		oRM.addClass("sapMOHNumberDiv");
		oRM.writeClasses();
		oRM.write(">");

		var oObjectNumber = oOH.getAggregation("_objectNumber");

		if (oObjectNumber && oObjectNumber.getNumber()) {
			oObjectNumber.setTextDirection(oOH.getNumberTextDirection());
			this._renderChildControl(oRM, oOH, oObjectNumber);
		}

		oRM.write("</div>"); // End Number/units container
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderTitle = function(oRM, oOH) {
	
		// Start title text and title arrow container
		oOH._oTitleArrowIcon.setVisible(oOH.getShowTitleSelector());
		if (oOH.getShowTitleSelector() && oOH._oTitleArrowIcon.getVisible()) {
			oRM.write("<div");
			oRM.addClass("sapMOHTitleAndArrow");
			oRM.writeClasses();
			oRM.write(">");
		}

		if (oOH.getTitle()) {
			oOH._titleText.setText(oOH.getTitle());
			// set text direction of the title
			oOH._titleText.setTextDirection(oOH.getTitleTextDirection());

			if (oOH.getTitleActive()) {
				oRM.write("<a"); // Start Title Text container
				if (oOH.getTitleHref()) { // if title is link write it
					oRM.writeAttributeEscaped("href", oOH.getTitleHref());
					if (oOH.getTitleTarget()) {
						oRM.writeAttributeEscaped("target", oOH.getTitleTarget());
					}
				} else {
					oRM.writeAttribute("href", "#");
				}

				//ARIA attributes
				oRM.writeAccessibilityState({
					role: "link",
					haspopup: !oOH.getTitleHref()
				});
			} else {
				oRM.write("<span"); // Start Title Text container
			}

			oRM.writeAttribute("id", oOH.getId() + "-title");
			oRM.addClass("sapMOHTitle");
			if (oOH.getTitleActive()) {
				oRM.writeAttribute("tabindex", "0");
				oRM.addClass("sapMOHTitleActive");
			}
			if (oOH.getShowTitleSelector()) {
				oRM.addClass("sapMOHTitleFollowArrow");
			}
			oRM.writeClasses();
			oRM.write(">");
			oRM.write("<h1>");
			this._renderChildControl(oRM, oOH, oOH._titleText);
			oRM.write("</h1>");
			if (oOH.getTitleActive()) {
				oRM.write("</a>"); // End Title Text container
			} else {
				oRM.write("</span>"); // End Title Text container
			}
		}

		if (oOH.getShowTitleSelector()) {
			oRM.write("<span"); // Start title arrow container
			oRM.addClass("sapMOHTitleArrow");
			oRM.writeClasses();
			oRM.write(">");
			this._renderChildControl(oRM, oOH, oOH._oTitleArrowIcon);
			oRM.write("</span>"); // end title arrow container
		}

		if (oOH.getShowTitleSelector() && oOH._oTitleArrowIcon.getVisible()) {
			oRM.write("</div>"); // end title text and title arrow container
		}
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderFullTitle = function(oRM, oOH) {
		if (!oOH.getNumber()) {
			oRM.addClass("sapMOHTitleDivFull");
		}
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderFullOH = function(oRM, oOH) {
		var oLibraryResourceBundle = sap.ui.getCore().getLibraryResourceBundle("sap.m"); // get resource translation bundle

		// Introductory text at the top of the item, like "On behalf of Julie..."
		if (oOH.getIntro()) {
			this._renderIntro(oRM, oOH, "sapMOHIntro", "sapMOHIntroActive");
		}

		// Container for fields placed on the top half of the item, below the intro. This
		// includes title icon, title, title arrow, number, and number units.
		oRM.write("<div"); // Start Top row container
		oRM.addClass("sapMOHTopRow");
		oRM.writeClasses();
		oRM.write(">");

		// Title container displayed to the left of the number and number units container.
		oRM.write("<div"); // Start Title container
		oRM.writeAttribute("id", oOH.getId() + "-titlediv");
		oRM.addClass("sapMOHTitleDiv");
		if (oOH._hasIcon()) {
			oRM.addClass("sapMOHTitleIcon");
		}

		this._renderFullTitle(oRM, oOH);
		oRM.writeClasses();
		oRM.write(">");

		// Container for icon
		if (oOH._hasIcon()) {
			oRM.write("<div"); // Start icon container
			oRM.addClass("sapMOHIcon");
			if (oOH.getIconActive()) {
				oRM.writeAttribute("tabindex", "0");
				oRM.addClass("sapMPointer");
				//ARIA attributes
				oRM.writeAccessibilityState({
					role: "link",
					haspopup: true,
					label: oLibraryResourceBundle.getText("OH_ARIA_ICON")
				});
			}
			oRM.writeClasses();
			oRM.write(">");
			this._renderChildControl(oRM, oOH, oOH._getImageControl());
			oRM.write("</div>"); // end icon container
		}

		this._renderTitle(oRM, oOH);

		oRM.write("</div>"); // End Title container

		this._renderNumber(oRM, oOH);

		oRM.write("<div class=\"sapMOHDivider\"/>");
		oRM.write("</div>"); // End Top row container

		if (oOH._hasBottomContent()) {
			oRM.write("<div"); // Start Bottom row container
			oRM.addClass("sapMOHBottomRow");
			oRM.writeClasses();
			oRM.write(">");

			this._renderAttributesAndStatuses(oRM, oOH);

			oRM.write("<div class=\"sapMOHDivider\"/>");
			oRM.write("</div>"); // End Bottom row container
		}
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderCondensedOH = function(oRM, oOH) {
		// Title container displayed to the left of the number and number units container.
		oRM.write("<div"); // Start Title container
		oRM.writeAttribute("id", oOH.getId() + "-titlediv");
		oRM.addClass("sapMOHTitleDiv");

		this._renderFullTitle(oRM, oOH);

		oRM.writeClasses();
		oRM.write(">");

		this._renderTitle(oRM, oOH);

		oRM.write("</div>"); // End Title container

		this._renderNumber(oRM, oOH);

		var oFirstAttr = oOH.getAttributes()[0];

		if (oFirstAttr && !oFirstAttr._isEmpty()) {
			this._renderAttribute(oRM, oOH, oFirstAttr);
		}
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 */
	ObjectHeaderRenderer.render = function(oRM, oOH) {

		// render responsive OH
		if (oOH.getResponsive()) {
			this._renderResponsive(oRM, oOH);
			return;
		}
		
		// === old renderer, no changes here for downwards compatibility

		this._computeChildControlsToBeRendered(oOH);
		
		var bCondensed = oOH.getCondensed();

		oRM.write("<div"); // Start Main container
		oRM.writeControlData(oOH);
		oRM.addClass("sapMOH");
		if (bCondensed) {
			oRM.addClass("sapMOHC");
			oRM.addClass("sapMOHBg" + oOH.getBackgroundDesign());
		}

		oRM.writeClasses();
		var sTooltip = oOH.getTooltip_AsString();
		if (sTooltip) {
			oRM.writeAttributeEscaped("title", sTooltip);
		}
		// ARIA attributes
		oRM.writeAccessibilityState({
			role : "region",
			labelledby: {
				value: oOH.getId() + "-titleText-inner",
				append: true
			}
		});

		oRM.write(">");

		if (bCondensed) {
			this._renderCondensedOH(oRM, oOH);
		} else {
			this._renderFullOH(oRM, oOH);
		}

		oRM.write("<div class=\"sapMOHLastDivider\"/>");

		oRM.write("</div>"); // End Main container\
		
		this._cleanupNotRenderedChildControls(oRM, oOH);

	};

	/**
	 * Renders the child control contained in the OH
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @param {sap.m.Control}
	 *            oControl an object representation of the child control that should be rendered
	 * @private
	 **/
	ObjectHeaderRenderer._renderChildControl = function(oRM, oOH, oControl){
		oRM.renderControl(oControl);
	};

	/**
	 * Responsive rendering start
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 **/
	ObjectHeaderRenderer._renderResponsive = function(oRM, oOH) {
		var bStates = this._hasResponsiveStates(oOH),
			bTabs = this._hasResponsiveTabs(oOH),
			oHeaderContainer = oOH.getHeaderContainer();

		// start outer div (containing ObjectHeader and IconTabBar content div)
		oRM.write("<div");
		oRM.addClass("sapMOHROuter");
		oRM.writeClasses();

		//ARIA attributes
		oRM.writeAccessibilityState({
			role : "region",
			labelledby: {
				value: oOH.getId() + "-txt",
				append: true
			}
		});
		oRM.writeControlData(oOH);
		oRM.write(">");

		oRM.write("<div");
		oRM.addClass("sapMOHR");
		oRM.writeClasses();
		oRM.write(">");
		oRM.write("<div");

		oRM.addClass("sapMOHRBg" + oOH.getBackgroundDesign());
		if (sap.ui.Device.system.desktop && jQuery('html').hasClass("sapUiMedia-Std-Desktop") && oOH.getFullScreenOptimized() && oOH._iCountVisAttrStat >= 1 && oOH._iCountVisAttrStat <= 3) {
			oRM.addClass("sapMOHRStatesOneOrThree");
		}

		oRM.writeClasses();
		oRM.write(">");

		this._renderResponsiveTitleBlock(oRM, oOH);

		if (bStates) {
			this._renderResponsiveStates(oRM, oOH);
		}

		oRM.write("</div>"); // end wrapper div

		if (bTabs) {
			this._renderResponsiveTabs(oRM, oOH);
		}

		oRM.write("</div>");

		if (oHeaderContainer && oHeaderContainer instanceof sap.m.IconTabBar) {
			this._renderChildControl(oRM, oOH, oHeaderContainer);
		}

		oRM.write("</div>"); // end outer div

		if (!oOH.getTitle()) {
			 //if value is set through data binding, there is time delay and fake warning will be logged, so set warning only if not data binding
			if (!oOH.getBinding("title")) {
				jQuery.sap.log.warning("The title shouldn't be empty!");
			}
		}
	};

	/**
	 * first building block for the responsive object header, it contains
	 * - intro
	 * - image
	 * - title
	 * - number and unit
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 **/
	ObjectHeaderRenderer._renderResponsiveTitleBlock = function(oRM, oControl) {
		var oLibraryResourceBundle = sap.ui.getCore().getLibraryResourceBundle("sap.m"); // get resource translation bundle
		
		// Title container displayed to the left of the number and number units container.
		oRM.write("<div"); // Start Title and Number container (block1 and block2)
		oRM.writeAttribute("id", oControl.getId() + "-titlenumdiv");
		oRM.addClass("sapMOHRTitleNumberDiv"); // first block class
		oRM.writeClasses();
		oRM.write(">");

		oRM.write("<div"); // Start Title container
		oRM.writeAttribute("id", oControl.getId() + "-titlediv");
		oRM.addClass("sapMOHRTitleDiv");

		if (oControl._hasIcon()) {
			if (sap.ui.Device.system.phone || jQuery('html').hasClass("sapUiMedia-Std-Phone")) {
				if (sap.ui.Device.orientation.landscape || (jQuery('html').hasClass("sapUiMedia-Std-Phone") && !sap.ui.Device.system.phone)) {
					oRM.addClass("sapMOHRTitleIcon");
				}
			} else {
				oRM.addClass("sapMOHRTitleIcon");
			}
		}

		if (!oControl.getAggregation("_objectNumber")) {
			oRM.addClass("sapMOHRTitleDivFull");
		}
		oRM.writeClasses();
		oRM.write(">");

		this._renderResponsiveTitle(oRM, oControl);

		// render the title icon in a separate container
		if (oControl._hasIcon()) {
			oRM.write("<div");
			oRM.writeAttribute("id", oControl.getId() + "-titleIcon");
			oRM.addClass("sapMOHRIcon");
			if ((sap.ui.Device.system.phone && sap.ui.Device.orientation.portrait)) {
				oRM.addClass("sapMOHRHideIcon");
			}
			if (oControl.getIconActive()) {
				oRM.addClass("sapMPointer");
				oRM.writeAttribute("tabindex", "0");
				//ARIA attributes
				oRM.writeAccessibilityState({
					role: "link",
					haspopup: true,
					label: oLibraryResourceBundle.getText("OH_ARIA_ICON")
				});
			}
			oRM.writeClasses();
			oRM.write(">");
			this._renderChildControl(oRM, oControl, oControl._getImageControl());
			oRM.write("</div>"); // end icon container
		}
		oRM.write("</div>"); // End Title container

		this._renderResponsiveNumber(oRM, oControl);

		oRM.write("</div>"); // End Title and Number container
	};


	/**
	 * Renders the HTML for attributes and statuses, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.ObjectHeader}
	 *            oOH an object to be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveStates = function(oRM, oControl) {
		oRM.write("<div");
		oRM.writeAttribute("id", oControl.getId() + "-states");
		oRM.addClass("sapMOHRStates");
		oRM.writeClasses();
		oRM.write(">");
		this._renderResponsiveRow(oRM, oControl);
		oRM.write("</div>");
	};

	/**
	 * Renders the HTML for the row which contains columns in which attributes and statuses are displayed.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveRow = function(oRM, oOH) {
		var aVisAtribsStatuses = [];
		aVisAtribsStatuses = this._getVisibleAttribsAndStatuses(oOH);

		var aVisibleAttrAndStat = aVisAtribsStatuses[0].concat(aVisAtribsStatuses[1]),
			iCountVisibleAttr = aVisAtribsStatuses[0].length,
			iCountAttrAndStat = aVisibleAttrAndStat.length,
			iRenderCols = 1,
			sClassColCount = '';

		if (iCountAttrAndStat === 0) {
			return; //nothing to render
		}

		if (sap.ui.Device.system.desktop) {
			if (!oOH.getFullScreenOptimized()) { // if master detail
				if (iCountAttrAndStat >= 1 && iCountAttrAndStat <= 4) {
					iRenderCols = 2; // render two columns
					sClassColCount = 'sapMOHRTwoCols';
				}
				if (iCountAttrAndStat >= 5) {
					iRenderCols = 3; // render three columns
					sClassColCount = 'sapMOHRThreeCols';
				}
			} else { // if full screen
				if (iCountAttrAndStat >= 1 && iCountAttrAndStat <= 3) {
					iRenderCols = 1; // render one column
					sClassColCount = 'sapMOHROneCols';
				}
				if (iCountAttrAndStat >= 4) {
					iRenderCols = 4; // render four columns
					sClassColCount = 'sapMOHRFourCols';
				}
			}
		}

		if (sap.ui.Device.system.tablet || (sap.ui.Device.system.desktop && jQuery('html').hasClass("sapUiMedia-Std-Tablet"))) {
			if (!oOH.getFullScreenOptimized() || (sap.ui.Device.orientation.portrait && oOH.getFullScreenOptimized())) { // full screen portrait or master detail
				iRenderCols = 2; //render two columns
				sClassColCount = 'sapMOHRTwoCols';
			} else {
				if (oOH.getFullScreenOptimized() && ( sap.ui.Device.orientation.landscape || (sap.ui.Device.system.desktop && jQuery('html').hasClass("sapUiMedia-Std-Tablet")))) { //full screen landscape
					if (iCountAttrAndStat >= 1 && iCountAttrAndStat <= 2) {
						iRenderCols = 2; // render two columns
						sClassColCount = 'sapMOHRTwoCols';
					}

					if (iCountAttrAndStat >= 3) {
						iRenderCols = 3; // render three columns
						sClassColCount = 'sapMOHRThreeCols';
					}
				}
			}
		}

		if (sap.ui.Device.system.phone || (sap.ui.Device.system.desktop && jQuery('html').hasClass("sapUiMedia-Std-Phone"))) {
			iRenderCols = 1; // render one column
			sClassColCount = 'sapMOHROneCols';
		}
		
		this._renderResponsiveStatesColumn(oRM, oOH, iRenderCols, aVisibleAttrAndStat, iCountVisibleAttr, sClassColCount);
	};

	/**
	 * Renders the HTML for the columns containing the states.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @param {iRenderCols}
	 *            number of columns that should be rendered
	 * @param {aVisibleAttrAndStat}
	 *            array of attributes and statuses that should be rendered
	 * @param {iCountVisibleAttr}
	 *            number of attributes that should be rendered, since they should be rendered before the states
	 * @param {sClassColCount}
	 *            the name of the appropriate css class that should be set
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveStatesColumn = function(oRM, oOH, iRenderCols, aVisibleAttrAndStat, iCountVisibleAttr, sClassColCount) {
		var iCountInCols = Math.floor( aVisibleAttrAndStat.length / iRenderCols ); // number of attributes and states in each column
		var iCountInBigCols = aVisibleAttrAndStat.length % iRenderCols;
		var iCurrentCountInCol = 0; // contains current number of attributes and statuses in the column (will be reset to zero when it becames equal to iCountInCols)
		var iContNum = 1; // container number (start from the first one)
		for (var i = 0; i < aVisibleAttrAndStat.length; i++) {
			if (iCurrentCountInCol == 0) {
				oRM.write("<div"); // Start container
				oRM.addClass("sapMOHRStatesCont" + iContNum);
				oRM.addClass(sClassColCount);
				oRM.writeClasses();
				oRM.write(">");
			}
		
			if (i < iCountVisibleAttr) {
				this._renderResponsiveAttribute(oRM, oOH, aVisibleAttrAndStat[i]);
			} else {
				this._renderResponsiveStatus(oRM, oOH, aVisibleAttrAndStat[i]);
			}
			iCurrentCountInCol++;
			if ((iCurrentCountInCol == iCountInCols && iContNum > iCountInBigCols) || (iCurrentCountInCol == (iCountInCols + 1) && iContNum <= iCountInBigCols) || i == aVisibleAttrAndStat.length - 1) {
				oRM.write("</div>"); // end container
				iCurrentCountInCol = 0;
				iContNum++;
			}
		}
	};

	/**
	 * Renders the HTML for Attribute.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @param {sap.m.ObjectAtribute}
	 *            oAttr an object representation of the sap.m.ObjectAtribute that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveAttribute = function(oRM, oOH, oAttr) {
		oRM.write("<div");
		oRM.addClass("sapMOHRAttr");
		oRM.writeClasses();
		oRM.write(">");
		this._renderChildControl(oRM, oOH, oAttr);
		oRM.write("</div>");
	};

	/**
	 * Renders the HTML for Status.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @param {sap.m.ObjectStatus}
	 *            oStatus an object representation of the sap.m.ObjectStatus that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveStatus = function(oRM, oOH, oStatus) {
		oRM.write("<div");
		oRM.addClass("sapMOHRStatus");
		oRM.writeClasses();
		oRM.write(">");
		this._renderChildControl(oRM, oOH, oStatus[0]);
		oRM.write("</div>");
	};

	/**
	 * Renders flag and favorite icon
	 *
	* @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oControl an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveMarkers = function(oRM, oControl) {
		var aIcons = [],
			sTextDir = oControl.getTitleTextDirection(),
			bPageRTL = sap.ui.getCore().getConfiguration().getRTL();

		// load icons based on control state
		if (oControl.getShowMarkers()) {
			oControl._oFavIcon.setVisible(oControl.getMarkFavorite());
			oControl._oFlagIcon.setVisible(oControl.getMarkFlagged());

			aIcons.push(oControl._oFavIcon);
			aIcons.push(oControl._oFlagIcon);

			this._renderMarkersAria(oRM, oControl); // render hidden aria description of flag and favorite icons

			// render icons
			oRM.write("<span");
			oRM.addClass("sapMObjStatusMarker");

			if ((sTextDir === sap.ui.core.TextDirection.LTR && bPageRTL) || (sTextDir === sap.ui.core.TextDirection.RTL && !bPageRTL)) {
				oRM.addClass("sapMObjStatusMarkerOpposite");
			}
			oRM.writeClasses();
			oRM.writeAttribute("id", oControl.getId() + "-markers");
			oRM.writeAttribute("aria-describedby", oControl.getId() + "-markers-aria");

			oRM.write(">");
			for (var i = 0; i < aIcons.length; i++) {
				this._renderChildControl(oRM, oControl, aIcons[i]);
			}
			oRM.write("</span>");
		}
	};

	/**
	 * Renders the ObjectNumber, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oControl an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveNumber = function(oRM, oControl) {
		var oObjectNumber = oControl.getAggregation("_objectNumber");

		if (oObjectNumber && oObjectNumber.getNumber()) {
			oObjectNumber.setTextDirection(oControl.getNumberTextDirection());
			this._renderChildControl(oRM, oControl, oObjectNumber);
		}
	};

	/**
	 * helper function to determine wheter states need to be rendered or not
	 *
	 * @param {sap.m.Control}
	 *
	 * @private
	 */
	ObjectHeaderRenderer._hasResponsiveStates = function (oControl) {
		var aAttribs = oControl.getAttributes(),
			aVisibleAttribs = [];

		if (!(oControl._hasAttributes() || oControl._hasStatus())) {
			oControl._iCountVisAttrStat = 0;
			return false;
		}

		for (var j = 0; j < aAttribs.length; j++) {
			if (aAttribs[j].getVisible()) {
				aVisibleAttribs.push(aAttribs[j]);
			}
		}

		var aVisibleStatuses = this._getVisibleStatuses(oControl);

		//this value needs to be adapted when an attribute or status is set to visible(false) after rendering
		oControl._iCountVisAttrStat = aVisibleAttribs.length + aVisibleStatuses.length;

		return !!(aVisibleAttribs.length + aVisibleStatuses.length);
	};

	/**
	 * helper function to determine whether tabs need to be rendered or not
	 *  @param {sap.m.Control}
	 *
	 * @private
	 */
	ObjectHeaderRenderer._hasResponsiveTabs = function (oControl) {
		var oHeaderContainer = oControl.getHeaderContainer(),
			oIconTabHeader;

		if (oHeaderContainer) {
			if (oHeaderContainer instanceof sap.m.IconTabBar) {
				oIconTabHeader = oHeaderContainer._getIconTabHeader();
				if (oIconTabHeader.getVisible()) {
					oControl._iCountVisTabs = oIconTabHeader.getItems().length;
					return !!oIconTabHeader.getItems().length;
				}
			} else if (sap.suite && sap.suite.ui && sap.suite.ui.commons && oHeaderContainer instanceof sap.suite.ui.commons.HeaderContainer) {
				return !!oHeaderContainer.getItems().length;
			}
		}
		return false;
	};


	/**
	 * Renders the ITB, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveTabs = function(oRM, oControl) {
		var oHeaderContainer = oControl.getHeaderContainer(),
			oIconTabHeader;

		oRM.write("<div class=\"sapMOHRTabs" + (oHeaderContainer instanceof sap.m.IconTabBar ? " sapMOHRTabsITB" : "") + "\">");
		if (oHeaderContainer) {
			if (oHeaderContainer instanceof sap.m.IconTabBar) {
				oIconTabHeader = oHeaderContainer._getIconTabHeader();
				this._renderChildControl(oRM, oControl, oIconTabHeader);
				// tell iconTabBar to not render the header
				oHeaderContainer._bHideHeader = true;
			} else if (sap.suite && sap.suite.ui && sap.suite.ui.commons && oHeaderContainer instanceof sap.suite.ui.commons.HeaderContainer) {
				// render the header container
				this._renderChildControl(oRM, oControl, oHeaderContainer);
			} else {
				jQuery.sap.log.warning("The control " + oHeaderContainer + " is not supported for aggregation \"headerContainer\"");
			}
		}
		oRM.write("</div>");
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveTitle = function(oRM, oOH) {
		var nCutLen;

		// Start title text and title arrow container
		oOH._oTitleArrowIcon.setVisible(oOH.getShowTitleSelector());

		oRM.write("<div"); // Start Title Text container

		oRM.writeAttribute("id", oOH.getId() + "-title");
		oRM.addClass("sapMOHRTitle");

		if (oOH.getTitleActive()) {
			oRM.addClass("sapMOHRTitleActive");
		}
		if (oOH.getShowTitleSelector()) {
			oRM.addClass("sapMOHRTitleFollowArrow");
		}
		oRM.writeClasses();
		oRM.write(">");

		// Cut the title to 50 or 80 chars according to the design specification
		if ((sap.ui.Device.system.phone && sap.ui.Device.orientation.portrait)) {
			nCutLen = 50;
		} else {
			nCutLen = 80;
		}

		oRM.write("<span"); // Start TitleArrow container
		oRM.writeAttribute("id", oOH.getId() + "-title-arrow");
		oRM.write(">");
		this._renderResponsiveTitleAndArrow(oRM, oOH, nCutLen);
		oRM.write("</span>");

		// Introductory text at the top of the item, like "On behalf of Julie..."
		if (oOH.getIntro()) {
			this._renderIntro(oRM, oOH, "sapMOHRIntro", "sapMOHRIntroActive");
		}

		oRM.write("</div>"); // End Title Text container
	};

	/**
	 * Rerenders the HTML for the title of the Object Header, also called on rerender Title.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @param {nCutLen}
	 *            number of chars to which the title should be cutted
	 * @private
	 */
	ObjectHeaderRenderer._rerenderTitle = function(oRM, oOH, nCutLen) {
		var sId = oOH.getId();

		this._renderResponsiveTitleAndArrow(oRM, oOH, nCutLen);
		oRM.flush(jQuery.sap.byId(sId + "-title-arrow"));
	};

	/**
	 * Renders the HTML for the title and arrow.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @param {nCutLen}
	 *            number of chars to which the title should be cutted
	 * @private
	 */
	ObjectHeaderRenderer._renderResponsiveTitleAndArrow = function(oRM, oOH, nCutLen) {
		var sOHTitle, sEllipsis = '', sTextDir = oOH.getTitleTextDirection();
		var bMarkers = (oOH.getShowMarkers() && (oOH.getMarkFavorite() || oOH.getMarkFlagged()));
		
		oRM.write("<h1>");
		oRM.write("<span");
		oRM.addClass("sapMOHRTitleTextContainer");
		oRM.writeClasses();
		// set title text direction, it will be inherit from the "flags" also
		if (sTextDir != sap.ui.core.TextDirection.Inherit) {
			oRM.writeAttribute("dir", sTextDir.toLowerCase());
		}
		oRM.write(">");
		if (oOH.getTitleActive()) {
			oRM.write("<a");
			if (oOH.getTitleHref()) { // if title is link write it
				oRM.writeAttributeEscaped("href", oOH.getTitleHref());
				if (oOH.getTitleTarget()) {
					oRM.writeAttributeEscaped("target", oOH.getTitleTarget());
				}
			} else {
				oRM.writeAttribute("href", "#");
			}

			oRM.writeAttribute("tabindex", "0");
			//ARIA attributes
			oRM.writeAccessibilityState({
				role: "link",
				haspopup: !oOH.getTitleHref()
			});
		} else {
			oRM.write("<span");
		}
		oRM.writeAttribute("id", oOH.getId() + "-txt");
		oRM.addClass("sapMOHRTitleText");
		oRM.writeClasses();

		oRM.write(">");

		oRM.write("<span");
		oRM.addClass("sapMOHRTitleTextWrappable");
		oRM.writeClasses();
		oRM.write(">");

		if (oOH.getTitle().length > nCutLen) {
			sOHTitle = oOH.getTitle().substr(0, nCutLen).trim();
			sEllipsis = '...';
		} else {
			sOHTitle = oOH.getTitle();
		}

		if (bMarkers) {
			var sOHTitleEnd = sOHTitle.substr(sOHTitle.lastIndexOf(" ") + 1);
			var sOHTitleStart = sOHTitle.substr(0, sOHTitle.lastIndexOf(" ") + 1);

			if (sOHTitleEnd.length === 1) {
				sOHTitleEnd = sOHTitle;
				sOHTitleStart = '';
			}

			oRM.writeEscaped(sOHTitleStart);
			oRM.write("</span>");

			oRM.writeEscaped(sOHTitleEnd);
			oRM.write(sEllipsis);
			if (oOH.getTitleActive()) {
				oRM.write("</a>");
			} else {
				oRM.write("</span>");
			}
			this._renderResponsiveMarkers(oRM, oOH);
			oRM.write("</span>");
		} else {
			if (!sEllipsis){
				oRM.writeEscaped(sOHTitle);
			} else {
				oRM.writeEscaped(sOHTitle + sEllipsis);
			}
			if (oOH.getTitleActive()) {
				oRM.write("</span></a></span>");
			} else {
				oRM.write("</span></span></span>");
			}
		}

		if (oOH.getShowTitleSelector()) {
			oRM.write("<span"); // Start title arrow container
			oRM.addClass("sapMOHRTitleArrow");
			oRM.writeClasses();
			oRM.write(">");
			this._renderChildControl(oRM, oOH, oOH._oTitleArrowIcon);
			oRM.write("</span>"); // end title arrow container
		}
		oRM.write("</h1>");

	};

	/**
	 * Rerenders the HTML for the states of the responsive Object Header.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRM the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.Control}
	 *            oOH an object representation of the control that should be rendered
	 * @private
	 */
	ObjectHeaderRenderer._rerenderResponsiveStates = function(oRM, oOH) {
		var sId = oOH.getId(),
			aVisAtribsStatuses = this._getVisibleAttribsAndStatuses(oOH),
			aVisibleAttrAndStat = aVisAtribsStatuses[0].concat(aVisAtribsStatuses[1]),
			iCountVisibleAttr = aVisAtribsStatuses[0].length,
			iCountAttrAndStat = aVisibleAttrAndStat.length,
			iRenderCols = 1,
			sClassColCount = '';

		if (iCountAttrAndStat === 0) {
			return; //nothing to render
		}

		// tablet case
		if (sap.ui.Device.orientation.portrait) { // full screen portrait or master detail
			iRenderCols = 2; //render two columns
			sClassColCount = 'sapMOHRTwoCols';
		} else {
			if (iCountAttrAndStat >= 1 && iCountAttrAndStat <= 2) {
				iRenderCols = 2; // render two columns
				sClassColCount = 'sapMOHRTwoCols';
			}
			if (iCountAttrAndStat >= 3) {
				iRenderCols = 3; // render three columns
				sClassColCount = 'sapMOHRThreeCols';
			}
		}

		this._renderResponsiveStatesColumn(oRM, oOH, iRenderCols, aVisibleAttrAndStat, iCountVisibleAttr, sClassColCount);

		oRM.flush(jQuery.sap.byId(sId + "-states")[0]);
	};

	/**** responsive rendering end ****/

	return ObjectHeaderRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ObjectHeaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectIdentifierRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ObjectIdentifierRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectIdentifierRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ObjectIdentifier renderer.
	 * @namespace
	 */
	var ObjectIdentifierRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render
	 *            output buffer
	 * @param {sap.ui.core.Control}
	 *            oOI an object representation of the control that should be
	 *            rendered
	 */
	ObjectIdentifierRenderer.render = function(oRm, oOI) {

		var sTooltip;

		// Return immediately if control is invisible
		if (!oOI.getVisible()) {
			return;
		}

		// write the HTML into the render manager
		oRm.write("<div"); // Identifier begins
		oRm.writeControlData(oOI);
		oRm.addClass("sapMObjectIdentifier");
		oRm.writeClasses();

		sTooltip = oOI.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}

		oRm.write(">");

		oRm.write("<div"); // Top row begins
		oRm.addClass("sapMObjectIdentifierTopRow");
		oRm.writeClasses();
		oRm.write(">");

		oRm.write("<div"); // Icons begin
		oRm.addClass("sapMObjectIdentifierIcons");
		oRm.writeClasses();

		oRm.write(">");

		if (oOI.getBadgeAttachments()) {
			oRm.write("<span"); // Icon span begins
			oRm.addClass("sapMObjectIdentifierIconSpan");
			oRm.writeClasses();
			oRm.write(">");
			oRm.renderControl(oOI._getAttachmentsIcon());
			oRm.write("</span>"); // Icon span ends
		}
		if (oOI.getBadgeNotes()) {
			oRm.write("<span"); // Icon span begins
			oRm.addClass("sapMObjectIdentifierIconSpan");
			oRm.writeClasses();
			oRm.write(">");
			oRm.renderControl(oOI._getNotesIcon());
			oRm.write("</span>"); // Icon span ends
		}
		if (oOI.getBadgePeople()) {
			oRm.write("<span"); // Icon span begins
			oRm.addClass("sapMObjectIdentifierIconSpan");
			oRm.writeClasses();
			oRm.write(">");
			oRm.renderControl(oOI._getPeopleIcon());
			oRm.write("</span>"); // Icon span ends
		}
		
		oRm.write("</div>"); // Icons end
	
		oRm.write("<div id='" + oOI.getId() + "-title'"); // Title begins 
		oRm.addClass("sapMObjectIdentifierTitle");
		
		oRm.writeClasses();
		oRm.write(">");
		oRm.renderControl(oOI._getTitleControl());
		oRm.write("</div>"); // Title ends
	
		oRm.write("</div>"); // Top row ends
	
		oRm.write("<div id='" + oOI.getId() + "-text'"); // Text begins
		oRm.addClass("sapMObjectIdentifierText");
		
		if (!!oOI.getProperty("text") && !!oOI.getProperty("title")) {
			oRm.addClass("sapMObjectIdentifierTextBellow");
		}
		oRm.writeClasses();
		oRm.write(">");
		oRm.renderControl(oOI._getTextControl());
		oRm.write("</div>"); // Text ends
	
		oRm.write("</div>"); // Identifier ends
	};
	

	return ObjectIdentifierRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ObjectIdentifierRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectListItemRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ObjectListItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectListItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, Renderer) {
	"use strict";


	/**
	 * ObjectListItem renderer.
	 * @namespace
	 */
	var ObjectListItemRenderer = Renderer.extend(ListItemBaseRenderer);
	
	/**
	 * Renders the HTML for single line of Attribute and Status.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *            rm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.ObjectListItem}
	 *            oLI an object to be rendered
	 * @param {sap.m.ObjectAttribute}
	 *            oAttribute an attribute to be rendered
	 * @param {sap.m.ObjectStatus}
	 *            oStatus a status to be rendered
	 */
	ObjectListItemRenderer.renderAttributeStatus = function(rm, oLI, oAttribute, oStatus) {
	
		if (!oAttribute && !oStatus || (oAttribute && oAttribute._isEmpty() && oStatus && oStatus._isEmpty())) {
			return; // nothing to render
		}
	
		rm.write("<div"); // Start attribute row container
		rm.addClass("sapMObjLAttrRow");
		rm.writeClasses();
		rm.write(">");
	
		if (oAttribute && !oAttribute._isEmpty()) {
			rm.write("<div");
			rm.addClass("sapMObjLAttrDiv");
			
			// Add padding to push attribute text down since it will be raised up due
			// to markers height
			if (oStatus && (!oStatus._isEmpty())) {
				if (oStatus instanceof Array) {
					rm.addClass("sapMObjAttrWithMarker");
				}
			}
			
			rm.writeClasses();
			
			if (!oStatus || oStatus._isEmpty()) {
				rm.addStyle("width", "100%");
				rm.writeStyles();
			}
			rm.write(">");
			rm.renderControl(oAttribute);
			rm.write("</div>");
		}
	
		if (oStatus && (!oStatus._isEmpty())) {
			rm.write("<div");
			rm.addClass("sapMObjLStatusDiv");
			
			// Object marker icons (flag, favorite) are passed as an array
			if (oStatus instanceof Array) {
				rm.addClass("sapMObjStatusMarker");
			}
			rm.writeClasses();
			if (!oAttribute || oAttribute._isEmpty()) {
				rm.addStyle("width", "100%");
				rm.writeStyles();
			}
			rm.write(">");
			if (oStatus instanceof Array) {
				while (oStatus.length > 0) {
					rm.renderControl(oStatus.shift());
				}
			} else {
				rm.renderControl(oStatus);
			}
			rm.write("</div>");
		}
	
		rm.write("</div>"); // Start attribute row container
	};

	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *          oRenderManager the RenderManager that can be used for writing to the
	 *          Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be
	 *          rendered
	 */
	ObjectListItemRenderer.renderLIAttributes = function(rm, oLI) {
		rm.addClass("sapMObjLItem");
		rm.addClass("sapMObjLListModeDiv");
	};
	
	ObjectListItemRenderer.renderLIContent = function(rm, oLI) {
		var sTitleDir = oLI.getTitleTextDirection(),
			sIntroDir = oLI.getIntroTextDirection(),
			sNumberDir = oLI.getNumberTextDirection();

		rm.write("<div"); // Start Main container
		rm.writeControlData(oLI);
		rm.write(">");
	
		// Introductory text at the top of the item, like "On behalf of Julie..."
		if (oLI.getIntro()) {
			rm.write("<div");
			rm.addClass("sapMObjLIntro");
			rm.writeClasses();
			rm.writeAttribute("id", oLI.getId() + "-intro");
			rm.write(">");
			rm.write("<span");
			//sets the dir attribute to "rtl" or "ltr" if a direction
			//for the intro text is provided explicitly
			if (sIntroDir !== sap.ui.core.TextDirection.Inherit) {
				rm.writeAttribute("dir", sIntroDir.toLowerCase());
			}
			rm.write(">");
			rm.writeEscaped(oLI.getIntro());
			rm.write("</span>");
			rm.write("</div>");
		}
	
		
		// Container for fields placed on the top half of the item, below the intro. This
		// includes title, number, and number units.
		rm.write("<div");  // Start Top row container     
		rm.addClass("sapMObjLTopRow");
		rm.writeClasses();
		rm.write(">");
		
		if (!!oLI.getIcon()) {
			rm.write("<div");
			rm.addClass("sapMObjLIconDiv");
			rm.writeClasses();
			rm.write(">");
			rm.renderControl(oLI._getImageControl());
			rm.write("</div>");
		}
		
		// Container for a number and a units qualifier.
		rm.write("<div"); // Start Number/units container
		rm.addClass("sapMObjLNumberDiv");
		rm.writeClasses();
		rm.write(">");
		
		if (oLI.getNumber()) {
			rm.write("<div");
			rm.writeAttribute("id", oLI.getId() + "-number");
			rm.addClass("sapMObjLNumber");
			rm.addClass("sapMObjLNumberState" + oLI.getNumberState());
			rm.writeClasses();
			//sets the dir attribute to "rtl" or "ltr" if a direction
			//for the number text is provided explicitly
			if (sNumberDir !== sap.ui.core.TextDirection.Inherit) {
				rm.writeAttribute("dir", sNumberDir.toLowerCase());
			}
			rm.write(">");
			rm.writeEscaped(oLI.getNumber());
			rm.write("</div>");
			
			if (oLI.getNumberUnit()) {
				rm.write("<div");
				rm.writeAttribute("id", oLI.getId() + "-numberUnit");
				rm.addClass("sapMObjLNumberUnit");
				rm.addClass("sapMObjLNumberState" + oLI.getNumberState());
				rm.writeClasses();
				rm.write(">");
				rm.writeEscaped(oLI.getNumberUnit());
				rm.write("</div>");
			}
		}
		
		rm.write("</div>"); // End Number/units container
		
		// Title container displayed to the left of the number and number units container.
		rm.write("<div"); // Start Title container
		rm.addStyle("display","-webkit-box");
		rm.addStyle("overflow","hidden");
		rm.writeStyles();
		rm.write(">");
		var oTitleText = oLI._getTitleText();
		if (oTitleText) {
			//sets the text direction of the title,
			//by delegating the RTL support to sap.m.Text
			oTitleText.setTextDirection(sTitleDir);
			oTitleText.setText(oLI.getTitle());
			oTitleText.addStyleClass("sapMObjLTitle");
			rm.renderControl(oTitleText);
		}
		
		rm.write("</div>"); // End Title container	
		
		rm.write("</div>"); // End Top row container
		
		rm.write('<div style="clear:both"/>');
		
		// Bottom row container.
		if (oLI._hasBottomContent()) {
			rm.write("<div"); // Start Bottom row container
			rm.addClass("sapMObjLBottomRow");
			rm.writeClasses();
			rm.write(">");
	
			var aAttribs = oLI._getVisibleAttributes();
			var statuses = [];
			var markers = null;

			if (oLI.getShowMarkers() || oLI.getMarkLocked()) {
				var placeholderIcon = oLI._getPlaceholderIcon();
				markers = [placeholderIcon];

				markers._isEmpty = function() {
					return false;
				};

				if (oLI.getMarkLocked()) {
					var lockIcon = oLI._getLockIcon();
					lockIcon.setVisible(oLI.getMarkLocked());
					markers.push(lockIcon);
				}

				if (oLI.getShowMarkers()) {
					var favIcon = oLI._getFavoriteIcon();
					var flagIcon = oLI._getFlagIcon();

					favIcon.setVisible(oLI.getMarkFavorite());
					flagIcon.setVisible(oLI.getMarkFlagged());

					markers.push(favIcon);
					markers.push(flagIcon);
				}

				statuses.push(markers);
			}

			statuses.push(oLI.getFirstStatus());
			statuses.push(oLI.getSecondStatus());
			
			while (aAttribs.length > 0) {
				this.renderAttributeStatus(rm, oLI, aAttribs.shift(), statuses.shift());
			}
			
			while (statuses.length > 0) {
				this.renderAttributeStatus(rm, oLI, null, statuses.shift());
			}

			rm.write("</div>"); // End Bottom row container
		}
		rm.write("</div>"); // End Main container
	};
	

	return ObjectListItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ObjectListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectNumberRenderer') ) {
/*
 * @copyright
 */

jQuery.sap.declare('sap.m.ObjectNumberRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectNumberRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
	"use strict";


	/**
	 * ObjectNumber renderer.
	 * @namespace
	 */
	var ObjectNumberRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oON an object representation of the control that should be rendered
	 */
	ObjectNumberRenderer.render = function(oRm, oON) {
		var sTooltip = oON.getTooltip_AsString(),
			sTextDir = oON.getTextDirection(),
			sTextAlign = oON.getTextAlign();

		oRm.write("<div");
		oRm.writeControlData(oON);
		oRm.addClass("sapMObjectNumber");

		oRm.addClass(oON._sCSSPrefixObjNumberStatus + oON.getState());

		if (oON.getEmphasized()) {
			oRm.addClass("sapMObjectNumberEmph");
		}

		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}

		if (sTextDir !== sap.ui.core.TextDirection.Inherit) {
			oRm.writeAttribute("dir", sTextDir.toLowerCase());
		}

		sTextAlign = Renderer.getTextAlign(sTextAlign, sTextDir);

		if (sTextAlign) {
			oRm.addStyle("text-align", sTextAlign);
		}

		oRm.writeClasses();
		oRm.writeStyles();

		// ARIA
		oRm.writeAccessibilityState({
			labelledby: oON.getId() + "-state"
		});

		oRm.write(">");

		this.renderText(oRm, oON);
		oRm.write("  "); // space between the number text and unit
		this.renderUnit(oRm, oON);
		this.renderHiddenARIAElement(oRm, oON);

		oRm.write("</div>");
	};

	ObjectNumberRenderer.renderText = function(oRm, oON) {
		oRm.write("<span");
		oRm.addClass("sapMObjectNumberText");
		oRm.writeClasses();
		oRm.write(">");
		oRm.writeEscaped(oON.getNumber());
		oRm.write("</span>");
	};

	ObjectNumberRenderer.renderUnit = function(oRm, oON) {
		var sUnit = oON.getUnit() || oON.getNumberUnit();

		oRm.write("<span");
		oRm.addClass("sapMObjectNumberUnit");
		oRm.writeClasses();
		oRm.write(">");
		oRm.writeEscaped(sUnit);
		oRm.write("</span>");
	};

	ObjectNumberRenderer.renderHiddenARIAElement = function(oRm, oON) {
		var sARIAStateText = "",
			oRB = sap.ui.getCore().getLibraryResourceBundle("sap.m");

		if (oON.getState() == sap.ui.core.ValueState.None) {
			return;
		}

		oRm.write("<span id='" + oON.getId() + "-state' class='sapUiInvisibleText' aria-hidden='true'>");

		switch (oON.getState()) {
			case sap.ui.core.ValueState.Error:
				sARIAStateText = oRB.getText("OBJECTNUMBER_ARIA_VALUE_STATE_ERROR");
				break;
			case sap.ui.core.ValueState.Warning:
				sARIAStateText = oRB.getText("OBJECTNUMBER_ARIA_VALUE_STATE_WARNING");
				break;
			case sap.ui.core.ValueState.Success:
				sARIAStateText = oRB.getText("OBJECTNUMBER_ARIA_VALUE_STATE_SUCCESS");
				break;
		}

		oRm.write(sARIAStateText);
		oRm.write("</span>");
	};

	return ObjectNumberRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ObjectNumberRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectStatusRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ObjectStatusRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectStatusRenderer",['jquery.sap.global', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, ValueStateSupport) {
	"use strict";


	/**
	 * ObjectStatus renderer.
	 * @namespace
	 */
	var ObjectStatusRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ObjectStatusRenderer.render = function(oRm, oObjStatus){
		if (!oObjStatus._isEmpty()) {

			var sState = oObjStatus.getState();
			var sTextDir = oObjStatus.getTextDirection();

			oRm.write("<div");
			oRm.writeControlData(oObjStatus);

			var sTooltip = oObjStatus.getTooltip_AsString();
			if (sTooltip) {
				oRm.writeAttributeEscaped("title", sTooltip);
			}

			oRm.addClass("sapMObjStatus");
			oRm.addClass("sapMObjStatus" + sState);
			oRm.writeClasses();

			/* ARIA region adding the aria-describedby to ObjectStatus */

			if (sState != sap.ui.core.ValueState.None) {
				oRm.writeAccessibilityState(oObjStatus, {
					describedby: {
						value: oObjStatus.getId() + "sapSRH",
						append: true
					}
				});
			}

			oRm.write(">");

			if (oObjStatus.getTitle()) {
				oRm.write("<span");
				oRm.addClass("sapMObjStatusTitle");
				oRm.writeClasses();
				oRm.write(">");
				oRm.writeEscaped(oObjStatus.getTitle() + ":");
				oRm.write("</span>");
			}

			if (oObjStatus.getIcon()) {
				oRm.write("<span");
				oRm.addClass("sapMObjStatusIcon");
				oRm.writeClasses();
				oRm.write(">");
				oRm.renderControl(oObjStatus._getImageControl());
				oRm.write("</span>");
			}

			if (oObjStatus.getText()) {
				oRm.write("<span");
				oRm.addClass("sapMObjStatusText");

				if (sTextDir && sTextDir !== sap.ui.core.TextDirection.Inherit) {
					oRm.writeAttribute("dir", sTextDir.toLowerCase());
				}

				oRm.writeClasses();
				oRm.write(">");
				oRm.writeEscaped(oObjStatus.getText());
				oRm.write("</span>");
			}

			/* ARIA adding hidden node in span element */
			if (sState != sap.ui.core.ValueState.None) {
				oRm.write("<span");
				oRm.writeAttributeEscaped("id", oObjStatus.getId() + "sapSRH");
				oRm.addClass("sapUiInvisibleText");
				oRm.writeClasses();
				oRm.writeAccessibilityState({
					hidden: false
				});
				oRm.write(">");
				oRm.writeEscaped(ValueStateSupport.getAdditionalText(sState));
				oRm.write("</span>");
			}

			oRm.write("</div>");
		}
	};

	return ObjectStatusRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ObjectStatusRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.P13nColumnsPanelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.P13nColumnsPanelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/P13nColumnsPanelRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ColumnsPanel renderer.
	 * @namespace
	 */
	var P13nColumnsPanelRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be rendered
	 */
	P13nColumnsPanelRenderer.render = function(oRm, oControl) {
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMP13nColumnsPanel");
		oRm.writeClasses();
		oRm.write(">"); // div element
	
		oRm.renderControl(oControl._oToolbar);
		oRm.renderControl(oControl._oScrollContainer);
	
		oRm.write("</div>");
	};
	

	return P13nColumnsPanelRenderer;

}, /* bExport= */ true);

}; // end of sap/m/P13nColumnsPanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.P13nConditionPanelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.P13nConditionPanelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/P13nConditionPanelRenderer",[
	'jquery.sap.global'
], function(jQuery) {
	"use strict";

	/**
	 * ConditionPanel renderer.
	 * @namespace
	 */
	var P13nConditionPanelRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be rendered
	 */
	P13nConditionPanelRenderer.render = function(oRm, oControl) {
		// start ConditionPanel
		oRm.write("<section");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMConditionPanel");
		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write(">");

		// render content
		oRm.write("<div");
		oRm.addClass("sapMConditionPanelContent");
		oRm.addClass("sapMConditionPanelBG");

		oRm.writeClasses();
		oRm.write(">");
		var aChildren = oControl.getAggregation("content");
		var iLength = aChildren.length;
		for (var i = 0; i < iLength; i++) {
			oRm.renderControl(aChildren[i]);
		}
		oRm.write("</div>");

		oRm.write("</section>");
	};

	return P13nConditionPanelRenderer;

}, /* bExport= */true);

}; // end of sap/m/P13nConditionPanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.P13nDialogRenderer') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.P13nDialogRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/P13nDialogRenderer",[
	'jquery.sap.global', 'sap/ui/core/Renderer', './DialogRenderer'
], function(jQuery, Renderer, DialogRenderer) {
	"use strict";

	/**
	 * P13nDialog renderer.
	 *
	 * @namespace
	 */
	var P13nDialogRenderer = Renderer.extend(DialogRenderer);

	/**
	 * CSS class to be applied to the root element of the ComboBoxBase.
	 *
	 * @readonly
	 * @const {string}
	 */
	P13nDialogRenderer.CSS_CLASS = "sapMPersoDialog";

	P13nDialogRenderer.render = function(oRm, oControl) {
		DialogRenderer.render.apply(this, arguments);

		var sId = oControl._getVisiblePanelID();
		var oPanel = oControl.getVisiblePanel();
		if (sId && oPanel) {
			oRm.write("<div");
			oRm.writeAttribute("id", sId);
			oRm.write(">");
			oRm.renderControl(oPanel);
			oRm.write("</div>");
		}
	};

	return P13nDialogRenderer;

}, /* bExport= */true);

}; // end of sap/m/P13nDialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.P13nFilterPanelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.P13nFilterPanelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/P13nFilterPanelRenderer",[
	'jquery.sap.global'
], function(jQuery) {
	"use strict";

	/**
	 * FilterPanel renderer.
	 * @namespace
	 */
	var P13nFilterPanelRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *          oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be rendered
	 */
	P13nFilterPanelRenderer.render = function(oRm, oControl) {
		// start ConditionPanel
		oRm.write("<section");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMFilterPanel");
		// oRm.addStyle("width", oControl.getWidth());
		// oRm.addStyle("height", oControl.getHeight());
		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write(">");

		// render content
		oRm.write("<div");
		oRm.addClass("sapMFilterPanelContent");
		oRm.addClass("sapMFilterPanelBG");

		oRm.writeClasses();
		oRm.write(">");
		var aChildren = oControl.getAggregation("content");
		var iLength = aChildren.length;
		for (var i = 0; i < iLength; i++) {
			oRm.renderControl(aChildren[i]);
		}
		oRm.write("</div>");

		oRm.write("</section>");
	};

	return P13nFilterPanelRenderer;

}, /* bExport= */true);

}; // end of sap/m/P13nFilterPanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.P13nGroupPanelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.P13nGroupPanelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/P13nGroupPanelRenderer",[
	'jquery.sap.global'
], function(jQuery) {
	"use strict";

	/**
	 * GroupPanel renderer.
	 * @namespace
	 */
	var P13nGroupPanelRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be rendered
	 */
	P13nGroupPanelRenderer.render = function(oRm, oControl) {
		// start GroupPanel
		oRm.write("<section");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMGroupPanel");
		//	oRm.addStyle("width", oControl.getWidth());
		//	oRm.addStyle("height", oControl.getHeight());
		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write(">");

		// render content
		oRm.write("<div");
		oRm.addClass("sapMGroupPanelContent");
		oRm.addClass("sapMGroupPanelBG");

		oRm.writeClasses();
		oRm.write(">");
		var aChildren = oControl.getAggregation("content");
		var iLength = aChildren.length;
		for (var i = 0; i < iLength; i++) {
			oRm.renderControl(aChildren[i]);
		}
		oRm.write("</div>");

		oRm.write("</section>");
	};

	return P13nGroupPanelRenderer;

}, /* bExport= */true);

}; // end of sap/m/P13nGroupPanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.P13nPanelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.P13nPanelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/P13nPanelRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * P13nPanel renderer.
	 * @namespace
	 */
	var P13nPanelRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *          oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be rendered
	 */
	P13nPanelRenderer.render = function(oRm, oControl) {
		// write the HTML into the render manager
		oRm.write("<span");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMP13nPanel");
		oRm.writeClasses();
		oRm.write(">"); // span element
		oRm.write("</span>");
	};
	

	return P13nPanelRenderer;

}, /* bExport= */ true);

}; // end of sap/m/P13nPanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.P13nSortPanelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.P13nSortPanelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/P13nSortPanelRenderer",[
	'jquery.sap.global'
], function(jQuery) {
	"use strict";

	/**
	 * SortPanel renderer.
	 * @namespace
	 */
	var P13nSortPanelRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be rendered
	 */
	P13nSortPanelRenderer.render = function(oRm, oControl) {
		// Return immediately if control is invisible
		if (!oControl.getVisible()) {
			return;
		}

		// start SortPanel
		oRm.write("<section");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMSortPanel");
		//	oRm.addStyle("width", oControl.getWidth());
		//	oRm.addStyle("height", oControl.getHeight());
		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write(">");

		// render content
		oRm.write("<div");
		oRm.addClass("sapMSortPanelContent");
		oRm.addClass("sapMSortPanelBG");

		oRm.writeClasses();
		oRm.write(">");
		var aChildren = oControl.getAggregation("content");
		var iLength = aChildren.length;
		for (var i = 0; i < iLength; i++) {
			oRm.renderControl(aChildren[i]);
		}
		oRm.write("</div>");

		oRm.write("</section>");
	};

	return P13nSortPanelRenderer;

}, /* bExport= */true);

}; // end of sap/m/P13nSortPanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.PageRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.PageRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/PageRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Page renderer.
	 * @namespace
	 */
	var PageRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oPage an object representation of the control that should be rendered
	 */
	PageRenderer.render = function(rm, oPage) {
		var oHeader = null,
			oFooter = null,
			oSubHeader = null,
			sEnableScrolling = oPage.getEnableScrolling() ? " sapMPageScrollEnabled" : "";
	
		if (oPage.getShowHeader()) {
			oHeader = oPage._getAnyHeader();
		}
	
		if (oPage.getShowSubHeader()) {
			oSubHeader = oPage.getSubHeader();
		}
	
		if (oPage.getShowFooter()) {
			oFooter = oPage.getFooter();
		}
		rm.write("<div");
		rm.writeControlData(oPage);
		rm.addClass("sapMPage");
	
		rm.addClass("sapMPageBg" + oPage.getBackgroundDesign());
	
		if (oHeader) {
			rm.addClass("sapMPageWithHeader");
		}
	
		if (oSubHeader) {
			rm.addClass("sapMPageWithSubHeader");
		}
	
		if (oFooter) {
			// it is used in the PopOver to remove additional margin bottom for page with footer
			rm.addClass("sapMPageWithFooter");
		}
	
		rm.writeClasses();
	
		var sTooltip = oPage.getTooltip_AsString();
	
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
	
		rm.write(">");
	
		//render headers
		this.renderBarControl(rm, oHeader, {
			context : "header",
			styleClass : "sapMPageHeader"
		});
	
		this.renderBarControl(rm, oSubHeader, {
			context : "subheader",
			styleClass : "sapMPageSubHeader"
		});
	
		// render child controls
		rm.write('<section id="' + oPage.getId() + '-cont">');
		
		if (oPage._bUseScrollDiv) { // fallback to old rendering
			rm.write('<div id="' + oPage.getId() + '-scroll" class="sapMPageScroll' + sEnableScrolling + '">');
		}
	
		var aContent = oPage.getContent();
		var l = aContent.length;
	
		for (var i = 0; i < l; i++) {
			rm.renderControl(aContent[i]);
		}
	
		if (oPage._bUseScrollDiv) { // fallback to old rendering
			rm.write("</div>");
		}
	
		rm.write("</section>");
	
		// render footer Element
		this.renderBarControl(rm, oFooter, {
			context : "footer",
			styleClass : "sapMPageFooter"
		});
	
		rm.write("</div>");
	};
	
	/**
	 * Renders the bar control if it is defined. Also adds classes to it.
	 * 
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.m.IBar} oBarControl the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {object} oOptions object containing the tag, contextClass and styleClass added to the bar
	 */
	PageRenderer.renderBarControl = function (rm, oBarControl, oOptions) {
		if (!oBarControl) {
			return;
		}
	
		oBarControl.applyTagAndContextClassFor(oOptions.context);
	
		oBarControl.addStyleClass(oOptions.styleClass);
	
		rm.renderControl(oBarControl);
	};

	return PageRenderer;

}, /* bExport= */ true);

}; // end of sap/m/PageRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.PanelRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.PanelRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/PanelRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

	/**
	 * Panel renderer
	 * @namespace
	 */
	var PanelRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *          oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be rendered
	 */
	PanelRenderer.render = function(oRm, oControl) {
		this._startPanel(oRm, oControl);

		this._renderHeader(oRm, oControl);

		this._renderContent(oRm, oControl);

		this._endPanel(oRm);
	};

	PanelRenderer._startPanel = function (oRm, oControl) {
		oRm.write("<section");

		oRm.addClass("sapMPanel");
		oRm.addStyle("width", oControl.getWidth());
		oRm.addStyle("height", oControl.getHeight());

		oRm.writeAccessibilityState(oControl, { role: "form" });
		oRm.writeControlData(oControl);
		oRm.writeClasses();
		oRm.writeStyles();

		oRm.write(">");
	};

	PanelRenderer._renderHeader = function (oRm, oControl) {
		var bIsExpandable = oControl.getExpandable(),
			oHeaderTBar = oControl.getHeaderToolbar();

		if (bIsExpandable) {

			// we need a wrapping div around icon and header since otherwise the border needed for both do not exact align
			oRm.write("<div");

			if (oHeaderTBar) {
				// we are in the toolbar case
				oRm.addClass("sapMPanelWrappingDivTb");
			} else {
				oRm.addClass("sapMPanelWrappingDiv");
			}

			oRm.writeClasses();
			oRm.write(">");

			var oIcon = oControl._getIcon();
			if (oControl.getExpanded()) {
				oIcon.addStyleClass("sapMPanelExpandableIconExpanded");
			} else {
				oIcon.removeStyleClass("sapMPanelExpandableIconExpanded");
			}

			oRm.renderControl(oIcon);
		}

		// render header
		var sHeaderText = oControl.getHeaderText();

		if (oHeaderTBar) {
			oHeaderTBar.setDesign(sap.m.ToolbarDesign.Transparent, true);

			if (bIsExpandable) {
				// use this class as marker class - to ease selection later in onAfterRendering
				oHeaderTBar.addStyleClass("sapMPanelHdrExpandable");
			}

			oRm.renderControl(oHeaderTBar);

		} else if (sHeaderText || bIsExpandable) {
			oRm.write("<div");
			oRm.addClass("sapMPanelHdr");
			if (bIsExpandable) {
				// use this class as marker class - to ease selection later in onAfterRendering
				oRm.addClass("sapMPanelHdrExpandable");
			}

			oRm.writeClasses();

			// ARIA
			oRm.write("role=\"heading\">");

			oRm.writeEscaped(sHeaderText);
			oRm.write("</div>");
		}

		if (bIsExpandable) {
			oRm.write("</div>");
		}

		var oInfoTBar = oControl.getInfoToolbar();

		if (oInfoTBar) {
			if (bIsExpandable) {
				// use this class as marker class to ease selection later in onAfterRendering
				oInfoTBar.addStyleClass("sapMPanelExpandablePart");
			}

			// render infoBar
			oInfoTBar.setDesign(sap.m.ToolbarDesign.Info, true);
			oRm.renderControl(oInfoTBar);
		}
	};

	PanelRenderer._renderContent = function (oRm, oControl) {
		this._startContent(oRm, oControl.getExpandable());

		this._renderChildren(oRm, oControl.getContent());

		this._endContent(oRm);
	};

	PanelRenderer._startContent = function (oRm, bIsExpandable) {
		oRm.write("<div");
		oRm.addClass("sapMPanelContent");
		oRm.addClass("sapMPanelBG");

		if (bIsExpandable) {
			// use this class as marker class to ease selection later in onAfterRendering
			oRm.addClass("sapMPanelExpandablePart");
		}

		oRm.writeClasses();
		oRm.write(">");
	};

	PanelRenderer._renderChildren = function (oRm, aChildren) {
		var iLength = aChildren.length;

		for (var i = 0; i < iLength; i++) {
			oRm.renderControl(aChildren[i]);
		}
	};

	PanelRenderer._endContent = function (oRm) {
		oRm.write("</div>");
	};

	PanelRenderer._endPanel = function (oRm) {
		oRm.write("</section>");
	};

	return PanelRenderer;

}, /* bExport= */ true);

}; // end of sap/m/PanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.PopoverRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.PopoverRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/PopoverRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Popover renderer. 
	 * @namespace
	 */
	var PopoverRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	PopoverRenderer.render = function(rm, oControl){
		var aClassNames;
	
		//container
		rm.write("<div");
		rm.writeControlData(oControl);
	
		aClassNames = this.generateRootClasses(oControl);
		aClassNames.forEach(function(sClassName, index){
			rm.addClass(sClassName);
		});
		rm.writeClasses();
	
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		rm.writeAttribute("tabindex", "-1");
	
		rm.writeAccessibilityState(oControl, {
			role: "dialog"
		});

		if (oControl.getShowHeader() && oControl._getAnyHeader()) {
			rm.writeAccessibilityState(oControl, {
				labelledby: oControl._getAnyHeader().getId()
			});
		}

		rm.write(">");
	
		this.renderContent(rm, oControl);
	
		rm.write("</div>");// container
	};
	
	PopoverRenderer.isButtonFooter = function(footer){
		if (footer instanceof sap.m.Bar) {
			var aContentLeft = footer.getContentLeft(),
				aContentRight = footer.getContentRight(),
				aContentMiddle = footer.getContentMiddle(),
				bLeftEmpty = (!aContentLeft || aContentLeft.length === 0),
				bRightEmpty = (!aContentRight || aContentRight.length === 0),
				bMiddleTwoButtons = false;
	
			if (aContentMiddle && aContentMiddle.length === 2) {
				if ((aContentMiddle[0] instanceof sap.m.Button) && (aContentMiddle[1] instanceof sap.m.Button)) {
					bMiddleTwoButtons = true;
				}
			}
			
			return bLeftEmpty && bRightEmpty && bMiddleTwoButtons;
		} else {
			return false;
		}
	};
	
	PopoverRenderer.renderContent = function(rm, oControl){
		var oHeader,
			sId = oControl.getId(),
			i = 0,
			contents = oControl.getContent(),
			oFooter = oControl.getFooter(),
			oSubHeader = oControl.getSubHeader(),
			sContentWidth = oControl.getContentWidth(),
			sContentHeight = oControl.getContentHeight(),
			sFooterClass = "sapMPopoverFooter ";
		
		if (oControl.getShowHeader()) {
			oHeader = oControl._getAnyHeader();
		}
		
		if (sap.ui.Device.system.desktop) {
			//Invisible element for cycling keyboard navigation
			rm.write("<span class='sapMPopoverHiddenFocusable' id='" + oControl.getId() + "-firstfe' tabindex='0'></span>");
		}
	
		//header
		if (oHeader) {
			if (oHeader.applyTagAndContextClassFor) {
				oHeader.applyTagAndContextClassFor("header");
			}
			oHeader.addStyleClass("sapMPopoverHeader");
			rm.renderControl(oHeader);
		}//header
		
		if (oSubHeader) {
			if (oSubHeader.applyTagAndContextClassFor) {
				oSubHeader.applyTagAndContextClassFor("subheader");
			}
			oSubHeader.addStyleClass("sapMPopoverSubHeader");
			rm.renderControl(oSubHeader);
		}
		
		// content container
		rm.write("<div");
		rm.writeAttribute("id",sId + "-cont");
		if (sContentWidth) {
			rm.addStyle("width",sContentWidth);
		}
		if (sContentHeight) {
			rm.addStyle("height",sContentHeight);
		}
		rm.writeStyles();
		rm.addClass("sapMPopoverCont");
		rm.writeClasses();
		rm.write(">");
		
		//scroll area
		rm.write("<div id='" + oControl.getId() + "-scroll" + "' class='sapMPopoverScroll " + "'>");
		for (i = 0 ; i < contents.length ; i++) {
			rm.renderControl(contents[i]);
		}
		rm.write("</div>");//scrollArea
		
		rm.write("</div>");//content container
		
		//footer
		if (oFooter) {
			if (oFooter.applyTagAndContextClassFor) {
				oFooter.applyTagAndContextClassFor("footer");
				//TODO: check if this should also be added to a Bar instance
				oFooter.addStyleClass("sapMTBNoBorders");
			}
			if (this.isButtonFooter(oFooter)) {
				sFooterClass += "sapMPopoverSpecialFooter";
			}
			rm.renderControl(oFooter.addStyleClass(sFooterClass));
		}//footer
	
		//arrow
		rm.write("<span");
		rm.writeAttribute("id", sId + "-arrow");
		rm.addClass("sapMPopoverArr");
		rm.writeClasses();
		rm.write("></span>");//arrow tip
	
		if (sap.ui.Device.system.desktop) {
			//Invisible element for desktop keyboard navigation
			rm.write("<span class='sapMPopoverHiddenFocusable' id='" + oControl.getId() + "-lastfe' tabindex='0'></span>");
		}
	};
	
	PopoverRenderer.generateRootClasses = function(oControl){
		var aClassNames = ["sapMPopover"],
			oSubHeader = oControl.getSubHeader(),
			oFooter = oControl.getFooter(),
			bVerScrollable = oControl.getVerticalScrolling() && !oControl._forceDisableScrolling,
			bHorScrollable = oControl.getHorizontalScrolling() && !oControl._forceDisableScrolling,
			oHeaderControl;
		
		if (oControl.getShowHeader()) {
			oHeaderControl = oControl._getAnyHeader();
		}
		
		if (oHeaderControl) {
			aClassNames.push("sapMPopoverWithBar");
		} else {
			aClassNames.push("sapMPopoverWithoutBar");
		}
		
		if (oSubHeader) {
			aClassNames.push("sapMPopoverWithSubHeader");
		} else {
			aClassNames.push("sapMPopoverWithoutSubHeader");
		}
		
		if (oControl._hasSingleNavContent()) {
			aClassNames.push("sapMPopoverNav");
		}
		
		if (oControl._hasSinglePageContent()) {
			aClassNames.push("sapMPopoverPage");
		}
		if (oFooter) {
			aClassNames.push("sapMPopoverWithFooter");
		} else {
			aClassNames.push("sapMPopoverWithoutFooter");
		}
		
		if (oControl.getPlacement() === sap.m.PlacementType.Top) {
			aClassNames.push("sapMPopoverPlacedTop");
		}
		if (!bVerScrollable) {
			aClassNames.push("sapMPopoverVerScrollDisabled");
		}
		if (!bHorScrollable) {
			aClassNames.push("sapMPopoverHorScrollDisabled");
		}
		
		aClassNames.push("sapMPopup-CTX");
	
		// test popover with sap-ui-xx-formfactor=compact
		if (sap.m._bSizeCompact) {
			aClassNames.push("sapUiSizeCompact");
		}
	
		// add custom classes set by the application as well 
		return aClassNames.concat(oControl.aCustomStyleClasses);
	};
	
	PopoverRenderer.rerenderContentOnly = function(oControl){
		var $Popover = oControl.$(),
			oPopoverDomRef = oControl.getDomRef(),
			aClassNames, oRm;
	
		if (!oPopoverDomRef) {
			//popover isn't rendered yet, just return
			return;
		}
	
		$Popover.removeClass();
		aClassNames = this.generateRootClasses(oControl);
		$Popover.addClass(aClassNames.join(" "));
	
		oRm = sap.ui.getCore().createRenderManager();
		this.renderContent(oRm, oControl);
	
		oRm.flush(oPopoverDomRef, true);
		oRm.destroy();
	
		//recalculate the size and position of popover
		oControl._onOrientationChange();
	};
	

	return PopoverRenderer;

}, /* bExport= */ true);

}; // end of sap/m/PopoverRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ProgressIndicatorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.ProgressIndicatorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ProgressIndicatorRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ProgressIndicator renderer.
	 * @namespace
	 */
	var ProgressIndicatorRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ProgressIndicatorRenderer.render = function(oRm, oC) {
		var fWidthBar = oC.getPercentValue(),
			iWidthControl = oC.getWidth(),
			iHeightControl = oC.getHeight(),
			sTextValue = oC.getDisplayValue(),
			bShowText = oC.getShowValue(),
			sState = oC.getState(),
			sTextDirectionLowerCase = oC.getTextDirection().toLowerCase(),
			sControlId = oC.getId();

		// write the HTML into the render manager
		// PI border
		oRm.write("<div");
		oRm.writeControlData(oC);
		oRm.addClass("sapMPI");
		oRm.addStyle("width", iWidthControl);

		if (fWidthBar > 50) {
			oRm.addClass("sapMPIValueGreaterHalf");
		}

		if (iHeightControl) {
			oRm.addStyle("height", iHeightControl);
		}

		if (oC.getEnabled()) {
			oRm.writeAttribute('tabIndex', '-1');
		} else {
			oRm.addClass("sapMPIBarDisabled");
		}

		oRm.writeClasses();
		oRm.writeStyles();
		oRm.writeAccessibilityState(oC, {
			role: "progressbar",
			valuemin: 0,
			valuenow: fWidthBar,
			valuemax: 100,
			valuetext: oC._getAriaValueText({
				sText: sTextValue,
				fPercent: fWidthBar
			})
		});
		oRm.write(">"); // div element

		// PI bar
		oRm.write("<div");
		oRm.addClass("sapMPIBar");

		switch (sState) {
		case sap.ui.core.ValueState.Warning:
			oRm.addClass("sapMPIBarCritical");
			break;
		case sap.ui.core.ValueState.Error:
			oRm.addClass("sapMPIBarNegative");
			break;
		case sap.ui.core.ValueState.Success:
			oRm.addClass("sapMPIBarPositive");
			break;
		default:
			oRm.addClass("sapMPIBarNeutral");
			break;
		}

		oRm.writeClasses();
		oRm.writeAttribute("id", sControlId + "-bar");
		oRm.writeAttribute("style", "width:" + fWidthBar + "%");
		oRm.write(">"); // div element

		//PI textLeft
		ProgressIndicatorRenderer._renderDisplayText(oRm, sTextDirectionLowerCase, "Left", sControlId);

		//textvalue is only showed if showValue set
		if (bShowText) {
			oRm.writeEscaped(sTextValue);
		}

		oRm.write("</span>");
		oRm.write("</div>"); // div element pi bar

		//PI textRight
		ProgressIndicatorRenderer._renderDisplayText(oRm, sTextDirectionLowerCase, "Right", sControlId);

		//textvalue is only showed if showValue set
		if (bShowText) {
			oRm.writeEscaped(sTextValue);
		}

		oRm.write("</span>");
		oRm.write("</div>"); //div element pi text
	};

	ProgressIndicatorRenderer._renderDisplayText = function(oRm, sTextDirectionLowerCase, sTextAlign, oControlId){
		oRm.write("<span class='sapMPIText sapMPIText" + sTextAlign + "' id='" + oControlId + "-text" + sTextAlign + "'");

		if (sTextDirectionLowerCase !== "inherit") {
			oRm.writeAttribute("dir", sTextDirectionLowerCase);
		}

		oRm.write('>');
	};

	return ProgressIndicatorRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ProgressIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.PullToRefreshRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.PullToRefreshRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/PullToRefreshRenderer",['jquery.sap.global', 'sap/ui/core/IconPool'],
	function(jQuery, IconPool) {
	"use strict";

// TODO: consider making this conditional 
	IconPool.insertFontFaceStyle();
	
	/**
	 * PullToRefresh renderer. 
	 * @namespace
	 */
	var PullToRefreshRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	PullToRefreshRenderer.render = function(oRm, oControl){
		var bShowIcon = oControl.getShowIcon();
		var sCustomIcon = oControl.getCustomIcon();
	
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMPullDown");
		if (!oControl._bTouchMode) {
			oRm.addClass("sapMPullDownNontouch");
		} else {
			oRm.addClass("sapMPullDownTouch");
		}
		if (bShowIcon && !sCustomIcon) { // if no custom icon is provided, use SAP logo as background
			oRm.addClass("sapMPullDownLogo");
		}
		oRm.writeClasses();
		oRm.write(" tabindex=\"0\">"); // div element
	
		if (bShowIcon && sCustomIcon) {
			var oCustomImage = oControl.getCustomIconImage();
			if (oCustomImage) {
				oRm.write("<div class=\"sapMPullDownCI\">");
				oRm.renderControl(oCustomImage);
				oRm.write("</div>");
			}
		}
	
		// Pull down arrow icon
		oRm.write("<span class=\"sapMPullDownIcon\"></span>");
	
		// Busy Indicator
		oRm.write("<span class=\"sapMPullDownBusy\">");
		oRm.renderControl(oControl._oBusyIndicator);
		oRm.write("</span>");
	
		// Text - Pull down to refresh
		oRm.write("<span id=" + oControl.getId() + "-T class=\"sapMPullDownText\">");
		oRm.writeEscaped(oControl.oRb.getText(oControl._bTouchMode ? "PULL2REFRESH_PULLDOWN" : "PULL2REFRESH_REFRESH"));
		oRm.write("</span>");
	
		// Info - last updated at xx:xx:xx
		oRm.write("<span id=" + oControl.getId() + "-I class=\"sapMPullDownInfo\">");
		oRm.writeEscaped(oControl.getDescription());
		oRm.write("</span>");
	
		oRm.write("</div>");
	};
	

	return PullToRefreshRenderer;

}, /* bExport= */ true);

}; // end of sap/m/PullToRefreshRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.QuickViewPageRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.QuickViewPageRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/QuickViewPageRenderer",['jquery.sap.global'],
	function(jQuery) {
		"use strict";

		/**
		 * @class QuickViewPage renderer.
		 * @static
		 */
		var QuickViewPageRenderer = {};

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager}
		 *          oRm the RenderManager that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control}
		 *          oQuickView an object representation of the control that should be rendered
		 */
		QuickViewPageRenderer.render = function(oRm, oQuickViewPage) {

			var mPageContent = oQuickViewPage._createPageContent();

			oRm.write("<div");
			oRm.addClass("sapMQuickViewPage");
			oRm.writeControlData(oQuickViewPage);
			oRm.writeClasses();
			oRm.write(">");

			if (mPageContent.header) {
				oRm.renderControl(mPageContent.header);
			}

			oRm.renderControl(mPageContent.form);
			oRm.write("</div>");
		};

		return QuickViewPageRenderer;

	}, /* bExport= */ true);

}; // end of sap/m/QuickViewPageRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.QuickViewRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.QuickViewRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/QuickViewRenderer",['jquery.sap.global'],
	function(jQuery) {
		"use strict";

		/**
		 * @class QuickView renderer.
		 * @static
		 */
		var QuickViewRenderer = {};

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager}
		 *          oRm the RenderManager that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control}
		 *          oQuickView an object representation of the control that should be rendered
		 */
		QuickViewRenderer.render = function (oRm, oControl) {};

		return QuickViewRenderer;

	}, /* bExport= */ true);

}; // end of sap/m/QuickViewRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.RadioButtonGroupRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.m.RadioButtonGroup
jQuery.sap.declare('sap.m.RadioButtonGroupRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/RadioButtonGroupRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * RadioButtonGroup renderer.
	 * @namespace
	 */
	var RadioButtonGroupRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.m.RadioButtonGroup} oRBGroup an object representation of the control that should be rendered
	 */
	RadioButtonGroupRenderer.render = function(oRenderManager, oRBGroup) {
		// convenience variable
		var rm = oRenderManager;

		// Return immediately if control has no RadioButtons
		if (!oRBGroup.aRBs) {
			return;
		}

		var iColumns = oRBGroup.getColumns();
		var bEnabled = oRBGroup.getEnabled();
		var sControlTextDir = oRBGroup.getTextDirection();
		var bGlobalTextDir = sap.ui.getCore().getConfiguration().getRTL();

		if (bEnabled) {
			// check if at least one button is enabled
			var aButtons = oRBGroup.getButtons();
			bEnabled = false;
			for (var i = 0; i < aButtons.length; i++) {
				if (aButtons[i].getEnabled()) {
					bEnabled = true;
					break;
				}
			}
		}

		rm.write("<div");
		rm.writeControlData(oRBGroup);
		rm.addClass("sapMRbG");
		if (iColumns > 1) {
			if (iColumns == oRBGroup.aRBs.length) {
				rm.addClass("sapMRbG1Row");
			} else {
				rm.addClass("sapMRbGTab");
				if (oRBGroup.getWidth() && oRBGroup.getWidth() != "") {
					rm.addClass("sapMRbGTabFlex");
					// as in Firefox -moz-box-flex > 0 brings ellipsis even if no width is given
					// therefore flexible columns should be only used if a width is given.
				}
			}
		}

		if (oRBGroup.getWidth() && oRBGroup.getWidth() != "") {
			rm.addStyle("width", oRBGroup.getWidth());
		}

		if (oRBGroup.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oRBGroup.getTooltip_AsString());
		}

		// check global rtl config and textDirection property and add "dir" attribute
		if (!bGlobalTextDir && sControlTextDir != sap.ui.core.TextDirection.Inherit) {
			rm.writeAttribute("dir", sControlTextDir.toLowerCase());
		}

		if (bEnabled) {
			rm.writeAttribute("tabindex", "0");
		} else {
			rm.writeAttribute("tabindex", "-1");
		}

		// ARIA
		rm.writeAccessibilityState(oRBGroup, {
			role : "radiogroup"
		});

		rm.writeClasses();
		rm.writeStyles();
		rm.write(">"); // DIV

		// columns
		for (var c = 0; c < iColumns; c++) {
			if (iColumns > 1 && iColumns != oRBGroup.aRBs.length) {
				// if only 1 column -> no DIV necessary
				rm.write("<div");
				rm.addClass("sapMRbGCol");
				rm.writeClasses();
				rm.write(">"); // DIV element
			}

			// render RadioButtons
			for (var i = c; i < oRBGroup.aRBs.length; i = i + iColumns) {
				rm.renderControl(oRBGroup.aRBs[i]);
			}

			if (iColumns > 1 && iColumns != oRBGroup.aRBs.length) {
				rm.write("</div>");
			}
		}

		if (iColumns > 1 && iColumns != oRBGroup.aRBs.length) {
			// dummy Column to avoid big spaces between RadioButtons in Safari
			rm.write('<div class="sapMRbGDummy"> </div>');
		}

		rm.write("</div>");
	};

	return RadioButtonGroupRenderer;

}, /* bExport= */ true);

}; // end of sap/m/RadioButtonGroupRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.RadioButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.RadioButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/m/RadioButtonRenderer",['jquery.sap.global', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, ValueStateSupport) {
	"use strict";


	/**
	 * RadioButton renderer.
	 * @namespace
	 */
	var RadioButtonRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oRadioButton an object representation of the control that should be rendered
	 */
	RadioButtonRenderer.render = function(oRm, oRadioButton) {
		// get control properties
		var sId = oRadioButton.getId();
		var bEnabled = oRadioButton.getEnabled();
		var bEditable = oRadioButton.getEditable();
		var bReadOnly = !bEnabled || !bEditable;
		var bInErrorState = sap.ui.core.ValueState.Error == oRadioButton.getValueState();
		var bInWarningState = sap.ui.core.ValueState.Warning == oRadioButton.getValueState();

		// Radio Button style class
		oRm.addClass("sapMRb");

		if (!bReadOnly) {
			oRm.addClass("sapMPointer");
		}

		// write the HTML into the render manager
		oRm.write("<div"); // Control - DIV
		oRm.writeControlData(oRadioButton);

		var sTooltipWithStateMessage = ValueStateSupport.enrichTooltip(oRadioButton, oRadioButton.getTooltip_AsString());
		if (sTooltipWithStateMessage) {
			oRm.writeAttributeEscaped("title", sTooltipWithStateMessage);
		}

		// ARIA
		oRm.writeAccessibilityState(oRadioButton, {
			role: "radio",
			selected: null, // Avoid output aria-selected
			checked: oRadioButton.getSelected() === true ? true : undefined, // aria-checked=false is default value and must not be set explicitly
			disabled: !oRadioButton.getEditable() ? true : undefined, // Avoid output aria-disabled=false when the button is editable
			labelledby: sId + "-label",
			describedby: sTooltipWithStateMessage ? sId + "-Descr" : undefined
		});

		// Add classes and properties depending on the state
		if (oRadioButton.getSelected()) {
			oRm.addClass("sapMRbSel");
		}

		if (!bEnabled) {
			oRm.addClass("sapMRbDis");
		}

		if (!bEditable) {
			oRm.addClass("sapMRbRo");
		}

		if (bInErrorState) {
			oRm.addClass("sapMRbErr");
		}

		if (bInWarningState) {
			oRm.addClass("sapMRbWarn");
		}

		oRm.writeClasses();

		if (bEnabled) {
			oRm.writeAttribute("tabindex", oRadioButton.hasOwnProperty("_iTabIndex") ? oRadioButton._iTabIndex : 0);
		}

		oRm.write(">"); // DIV element

		oRm.write("<div class='sapMRbB'");

		oRm.write(">");

		oRm.write("<div");
		oRm.addClass("sapMRbBOut");

		//set an id on this this to be able to focus it, on ApplyFocusInfo (rerenderAllUiAreas)
		oRm.writeAttribute("id", sId + "-Button");

		if (!bReadOnly && sap.ui.Device.system.desktop) {
			oRm.addClass("sapMRbHoverable");
		}

		oRm.writeClasses();
		oRm.write(">"); // DIV element
		oRm.write("<div");
		oRm.addClass("sapMRbBInn");
		oRm.writeClasses();
		oRm.write(">"); // DIV element

		// Write the real - potentially hidden - HTML RadioButton element
		oRm.write("<input type='radio' tabindex='-1'");
		oRm.writeAttribute("id", sId + "-RB");
		oRm.writeAttributeEscaped("name", oRadioButton.getGroupName());
		if (oRadioButton.getSelected()) {
			oRm.writeAttribute("checked", "checked");
		}

		if (bReadOnly) {
			oRm.writeAttribute("readonly", "readonly");
			oRm.writeAttribute("disabled", "disabled");
		}

		oRm.write(" />"); // Close RadioButton-input-element

		oRm.write("</div></div>"); // Control - DIVs close

		oRm.write("</div>");
		oRm.renderControl(oRadioButton._oLabel);

		if (sTooltipWithStateMessage) {
			// for ARIA, the tooltip must be in a separate SPAN and assigned via aria-describedby.
			// otherwise, JAWS does not read it.
			oRm.write("<span id=\"" + sId + "-Descr\" style=\"display: none;\">");
			oRm.writeEscaped(sTooltipWithStateMessage);
			oRm.write("</span>");
		}
		oRm.write("</div>"); // Control - DIVs close
	};

	return RadioButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/m/RadioButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.RatingIndicatorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.RatingIndicatorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/m/RatingIndicatorRenderer",['jquery.sap.global', 'sap/ui/core/theming/Parameters'],
	function(jQuery, Parameters) {
	"use strict";


	/* =========================================================== */
	/*           temporary flags for jslint syntax check           */
	/* =========================================================== */
	/*jslint nomen: false */
	
	/**
	 * RatingIndicator renderer.
	 * @namespace
	 */
	var RatingIndicatorRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	RatingIndicatorRenderer.render = function (oRm, oControl) {
	
		var fRatingValue = oControl._roundValueToVisualMode(oControl.getValue()),
			iSymbolCount = oControl.getMaxValue(),
			fIconSize = oControl._iPxIconSize,
			fIconPadding = oControl._iPxPaddingSize,
			sIconSizeMeasure = 'px',
			iSelectedWidth = fRatingValue * fIconSize + (Math.round(fRatingValue) - 1) * fIconPadding,
			iWidth = iSymbolCount * (fIconSize + fIconPadding) - fIconPadding,
			oIconSel,
			oIconUnsel,
			oIconHov,
			i = 0,
			sTooltip = oControl.getTooltip_AsString(),
			// gradients in combination with background-clip: text are not supported by ie, android < 4.2 or blackberry
			bUseGradient = sap.ui.Device.browser.chrome || sap.ui.Device.browser.safari,
			sLabelID;
	
		if (iSelectedWidth < 0) { //width should not be negative
			iSelectedWidth = 0;
		}
	
		// render the control container div
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.writeAttribute("style", "width: " + iWidth + sIconSizeMeasure);
		if (!oControl.getEnabled()) {
			oRm.writeAttribute("tabindex", "-1");
		} else {
			oRm.writeAttribute("tabindex", "0");
		}
		oRm.addClass("sapMRI");
		if (oControl.getEnabled()) {
			oRm.addClass("sapMPointer");
		} else {
			oRm.addClass("sapMRIDisabled");
		}
		oRm.writeClasses();
		// add tooltip if available
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}

		// ARIA
		sLabelID = oControl.getId() + "-ariaLabel";

		oRm.writeAccessibilityState(oControl, {
			"role": "slider",
			"orientation": "horizontal",
			"live": "assertive",
			"valuemin": 0,
			"disabled": !oControl.getEnabled(),
			"labelledby": {
				value: sLabelID,
				append: true
			}
		});

		oRm.write(">");

		// ARIA
		oRm.write("<label id='" + sLabelID + "' style='display:none;' aria-hidden='true'>" + oControl._oResourceBundle.getText("RATING_ARIA_NAME") + "</label>");

		// render selected items div
		oRm.write("<div class='sapMRISel");
		if (bUseGradient) {
			oRm.write(" sapMRIGrd");
		}
		oRm.write("'");
		oRm.writeAttribute("id", oControl.getId() + "-sel");
		oRm.writeAttribute("style", "width: " + iSelectedWidth + sIconSizeMeasure);
		oRm.write(">");
		// for defined count of icons, create selected icons with oControl._getIcon(0)
		for (i = 0; i < iSymbolCount; i++) {
			oIconSel = oControl._getIcon(0);
			//check if icon is icon or image
			if (oIconSel instanceof sap.ui.core.Icon) {
				oIconSel.setSize(fIconSize + sIconSizeMeasure);
			}
			// always set width and height because icon fonts can have different dimensions
			oIconSel.setWidth(fIconSize + sIconSizeMeasure);
			oIconSel.setHeight(fIconSize + sIconSizeMeasure);
	
			oIconSel.addStyleClass("sapMRIIconSel");
			oRm.renderControl(oIconSel);
		}
		oRm.write("</div>");
	
		// render unselected items div (container and relative child)
		oRm.write("<div class='sapMRIUnselWrapper'");
		oRm.writeAttribute("id", oControl.getId() + "-unsel-wrapper");
		oRm.writeAttribute("style", "width: " + (iWidth - iSelectedWidth) + sIconSizeMeasure);
		oRm.write(">");
		oRm.write("<div class='sapMRIUnsel");
		if (bUseGradient && oControl.getEnabled()) { // see the specification for read only rating indicator
			oRm.write(" sapMRIGrd");
		}
		oRm.write("' id='" + oControl.getId() + "-unsel'>");
		// for defined count of icons, create unselected icons with oControl._getIcon(1)
		for (i = 0; i < iSymbolCount; i++) {
			oIconUnsel = oControl._getIcon(1);
			//check if icon is icon or image
			if (oIconUnsel instanceof sap.ui.core.Icon) {
				oIconUnsel.setSize(fIconSize + sIconSizeMeasure);
			}
			// always set width and height because icon fonts can have different dimensions
			oIconUnsel.setWidth(fIconSize + sIconSizeMeasure);
			oIconUnsel.setHeight(fIconSize + sIconSizeMeasure);
	
			oIconUnsel.addStyleClass("sapMRIIconUnsel");
			if (fIconSize <= 1) {
				oIconUnsel.addStyleClass("sapMRIIconUnselSmall");
			}
			oRm.renderControl(oIconUnsel);
		}
		oRm.write("</div>");
		oRm.write("</div>");
	
		// render hovered item div
		if (oControl.getEnabled()) {
			oRm.write("<div class='sapMRIHov' id='" + oControl.getId() + "-hov'>");
			// for defined count of icons, create hovered icons with oControl._getIcon(2)
			for (i = 0; i < iSymbolCount; i++) {
				oIconHov = oControl._getIcon(2);
				//check if icon is icon or image
				if (oIconHov instanceof sap.ui.core.Icon) {
					oIconHov.setSize(fIconSize + sIconSizeMeasure);
				}
				// always set width and height because icon fonts can have different dimensions
				oIconHov.setWidth(fIconSize + sIconSizeMeasure);
				oIconHov.setHeight(fIconSize + sIconSizeMeasure);
	
				oIconHov.addStyleClass("sapMRIIconHov");
				oRm.renderControl(oIconHov);
			}
			oRm.write("</div>");
	
			// render selector items div
			oRm.write("<div class='sapMRISelector' id='" + oControl.getId() + "-selector'>");
			oRm.write("</div>");
		}
	
		// close control div
		oRm.write("</div>");
	};

	return RatingIndicatorRenderer;

}, /* bExport= */ true);

}; // end of sap/m/RatingIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ResponsivePopoverRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.ResponsivePopoverRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ResponsivePopoverRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ResponsivePopover renderer.
	 * @namespace
	 */
	var ResponsivePopoverRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ResponsivePopoverRenderer.render = function (oRm, oControl) {
	};

	return ResponsivePopoverRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ResponsivePopoverRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ScrollContainerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ScrollContainerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ScrollContainerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ScrollContainer renderer. 
	 * @namespace
	 */
	var ScrollContainerRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ScrollContainerRenderer.render = function(oRm, oControl) {
		oRm.write("<div");
		oRm.writeControlData(oControl);
	
		var width = oControl.getWidth(),
		height = oControl.getHeight();
		if (width) {
			oRm.addStyle("width", width);
		}
		if (height) {
			oRm.addStyle("height", height);
		}
		oRm.writeStyles();
	
		if (oControl.getVertical()) {
			if (!oControl.getHorizontal()) {
				oRm.addClass("sapMScrollContV");
			} else {
				oRm.addClass("sapMScrollContVH");
			}
		} else if (oControl.getHorizontal()) {
			oRm.addClass("sapMScrollContH");
		}
	
		oRm.addClass("sapMScrollCont");
		oRm.writeClasses();
		
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}
		
		if (oControl.getFocusable()) {
			oRm.writeAttributeEscaped("tabindex","0");
		}
		
		oRm.write("><div id='" + oControl.getId() + "-scroll' class='sapMScrollContScroll'>");
	
		// render child controls
		var aContent = oControl.getContent(),
		l = aContent.length;
		for (var i = 0; i < l; i++) {
			oRm.renderControl(aContent[i]);
		}
	
		oRm.write("</div></div>");
	};
	

	return ScrollContainerRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ScrollContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SearchFieldRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.SearchFieldRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/SearchFieldRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * SearchField renderer.
	 * @namespace
	 */
	var SearchFieldRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oSF an object representation of the control that should be rendered
	 */
	SearchFieldRenderer.render = function(rm, oSF){
		// render nothing if control is invisible
		if (!oSF.getVisible()) {
			return;
		}
	
		var sPlaceholder = oSF.getPlaceholder(),
			sValue = oSF.getValue(),
			sWidth = oSF.getProperty("width"),
			sId = oSF.getId(),
			bShowRefreshButton = oSF.getShowRefreshButton(),
			bShowSearchBtn = oSF.getShowSearchButton(),
			oAccAttributes = {}; // additional accessibility attributes
	
		// container
		rm.write("<div");
		rm.writeControlData(oSF);
		if (sWidth) { rm.writeAttribute("style", "width:" + sWidth + ";"); }
	
		rm.addClass("sapMSF");
	
		if (sValue) {
			rm.addClass("sapMSFVal");
		}
		if (!oSF.getEnabled()) {
			rm.addClass("sapMSFDisabled");
		}
	
		rm.writeClasses();
		var sTooltip = oSF.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		rm.write(">");
	
			// 1. Input type="search".
			//    Enclose input into a <form> to show a correct keyboard
			//    method="post" to prevent unneeded "?" at the end of URL
			rm.write('<form method="post" action="javascript:void(0);"');
			rm.addClass('sapMSFF');
			if (!bShowSearchBtn) {
				rm.addClass("sapMSFNS"); //no search button
			} else if (bShowRefreshButton) {
				rm.addClass('sapMSFReload');
			}
			rm.writeClasses();
			rm.write('>');
		
			// self-made placeholder
			if (!oSF._hasPlacehoder && sPlaceholder) {
				rm.write("<label ");
				rm.writeAttribute("id", sId + "-P");
				rm.writeAttribute("for", sId + "-I");
		
				rm.addClass("sapMSFPlaceholder");
				rm.writeClasses();
				rm.write(">");
				rm.writeEscaped(sPlaceholder);
				rm.write("</label>");
			}
		
			rm.write('<input type="search" autocorrect="off"');
			rm.writeAttribute("id", oSF.getId() + "-I");
		
			rm.addClass("sapMSFI");
		
			if (sap.ui.Device.os.android && sap.ui.Device.os.version >= 4 && sap.ui.Device.os.version < 4.1 ) {
				rm.addClass("sapMSFIA4"); // specific CSS layout for Android 4.0x
			}
		
			rm.writeClasses();
		
			if (!oSF.getEnabled()) { rm.writeAttribute("disabled","disabled"); }
			if (sPlaceholder) { rm.writeAttributeEscaped("placeholder", sPlaceholder); }
			if (oSF.getMaxLength()) { rm.writeAttribute("maxLength", oSF.getMaxLength()); }
			if (sValue) { rm.writeAttributeEscaped("value", sValue); }

			//ARIA attributes
			if (oSF.getEnabled() && bShowRefreshButton) {
				oAccAttributes.describedby = {
					value: oSF._sAriaF5LabelId,
					append: true
				};
			}
			rm.writeAccessibilityState(oSF, oAccAttributes);

			rm.write(">");
		
			if (oSF.getEnabled()) {
				// 2. Reset button
				rm.write("<div");
				rm.writeAttribute("id", oSF.getId() + "-reset");
				rm.addClass("sapMSFR"); // reset
				rm.addClass("sapMSFB"); // button
				if (!bShowSearchBtn) {
					rm.addClass("sapMSFNS"); //no search button
				}
				rm.writeClasses();
				rm.write("></div>");
		
				// 3. Search/Refresh button
				if (bShowSearchBtn) {
					rm.write("<div");
					rm.writeAttribute("id", oSF.getId() + "-search");
					rm.addClass("sapMSFS"); // search
					rm.addClass("sapMSFB"); // button
					rm.writeClasses();
					if (oSF.getRefreshButtonTooltip()) {
						rm.writeAttributeEscaped("title", oSF.getRefreshButtonTooltip());
					}
					rm.write( "></div>");
				}
			}
		
			rm.write("</form>");
	
		rm.write("</div>");
	
	};
	

	return SearchFieldRenderer;

}, /* bExport= */ true);

}; // end of sap/m/SearchFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SegmentedButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.SegmentedButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/SegmentedButtonRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

	/**
	 * Segmented renderer.
	 * @namespace
	 */
	var SegmentedButtonRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	SegmentedButtonRenderer.render = function(oRM, oControl){
		var aButtons = oControl.getButtons(),
			sSelectedButton = oControl.getSelectedButton(),
			oButton,
			sTooltip,
			sButtonWidth,
			sButtonTextDirection,
			i = 0;

		// write the HTML into the render manager
		oRM.write("<ul");
		oRM.addClass("sapMSegB");
		oRM.addClass("sapMSegBHide");
		oRM.writeClasses();
		if (oControl.getWidth() && oControl.getWidth() !== '') {
			oRM.addStyle('width', oControl.getWidth());
		}
		oRM.writeStyles();
		oRM.writeControlData(oControl);
		sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			oRM.writeAttributeEscaped("title", sTooltip);
		}

		// ARIA
		oRM.writeAccessibilityState(oControl, {
			role : "radiogroup"
		});

		oRM.write(">");

		for (; i < aButtons.length; i++) {
			oButton = aButtons[i];

			var sButtonText = oButton.getText(),
				oButtonIcon = oButton.getIcon(),
				sIconAriaLabel = "";

			if (oButtonIcon) {
				var oImage = oButton._getImage((oButton.getId() + "-img"), oButtonIcon);
				if (oImage instanceof sap.m.Image) {
					oControl._overwriteImageOnload(oImage);
				} else {
					sIconAriaLabel = oControl._getIconAriaLabel(oImage);
				}
			}

			// instead of the button API we render a li element but with the id of the button
			// only the button properties enabled, width, icon, text, and tooltip are evaluated here
			oRM.write("<li");
			oRM.writeControlData(oButton);
			oRM.addClass("sapMSegBBtn");
			if (oButton.aCustomStyleClasses !== undefined && oButton.aCustomStyleClasses instanceof Array) {
				for (var j = 0; j < oButton.aCustomStyleClasses.length; j++) {
					oRM.addClass(oButton.aCustomStyleClasses[j]);
				}
			}
			if (oButton.getEnabled()) {
				oRM.addClass("sapMSegBBtnFocusable");
			} else {
				oRM.addClass("sapMSegBBtnDis");
			}
			if (sSelectedButton === oButton.getId()) {
				oRM.addClass("sapMSegBBtnSel");
			}
			if (oButtonIcon && sButtonText !== '') {
				oRM.addClass("sapMSegBBtnMixed");
			}
			oRM.writeClasses();
			sButtonWidth = oButton.getWidth();
			if (sButtonWidth) {
				oRM.addStyle('width', sButtonWidth);
				oRM.writeStyles();
			}
			sTooltip = oButton.getTooltip_AsString();
			if (sTooltip) {
				oRM.writeAttributeEscaped("title", sTooltip);
			}
			oRM.writeAttribute("tabindex", oButton.getEnabled() ? "0" : "-1");

			sButtonTextDirection = oButton.getTextDirection();
			if (sButtonTextDirection !== sap.ui.core.TextDirection.Inherit) {
				oRM.writeAttribute("dir", sButtonTextDirection.toLowerCase());
			}

			// ARIA
			oRM.writeAccessibilityState(oButton, {
				role : "radio",
				checked : sSelectedButton === oButton.getId()
			});

			// BCP:1570027826 If button has an icon add ARIA label containing the generic icon name
			if (oImage && sIconAriaLabel !== "") {
				// If there is text inside the button add it in the aria-label
				if (sButtonText !== "") {
					sIconAriaLabel += " " + sButtonText;
				}
				oRM.writeAttributeEscaped("aria-label", sIconAriaLabel);
			}

			oRM.write('>');

			if (oButtonIcon && oImage) {
				oRM.renderControl(oImage);
			}

			// render text
			if (sButtonText !== '') {
				oRM.writeEscaped(sButtonText, false);
			}
			oRM.write("</li>");
		}
		oRM.write("</ul>");
	};

	return SegmentedButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/m/SegmentedButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SelectDialogRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.SelectDialogRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/SelectDialogRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * SelectDialog renderer.
	 * @namespace
	 */
	var SelectDialogRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	SelectDialogRenderer.render = function (oRm, oControl) {
	};

	return SelectDialogRenderer;

}, /* bExport= */ true);

}; // end of sap/m/SelectDialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SelectListRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.SelectListRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/SelectListRenderer",['jquery.sap.global'],
	function(jQuery) {
		"use strict";

		/**
		 * SelectList renderer.
		 *
		 * @namespace
		 */
		var SelectListRenderer = {};

		/**
		 * CSS class to be applied to the  root element of the SelectList.
		 *
		 * @readonly
		 * @const {string}
		 */
		SelectListRenderer.CSS_CLASS = "sapMSelectList";

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oSelectList An object representation of the control that should be rendered.
		 */
		SelectListRenderer.render = function(oRm, oList) {
			var CSS_CLASS = SelectListRenderer.CSS_CLASS;

			oRm.write("<ul");
			oRm.writeControlData(oList);
			oRm.addClass(CSS_CLASS);

			if (!oList.getEnabled()) {
				oRm.addClass(CSS_CLASS + "Disabled");
			}

			oRm.addStyle("width", oList.getWidth());
			oRm.addStyle("max-width", oList.getMaxWidth());
			oRm.writeStyles();
			oRm.writeClasses();
			this.writeAccessibilityState(oRm, oList);
			oRm.write(">");
			this.renderItems(oRm, oList);
			oRm.write("</ul>");
		};

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oList An object representation of the control that should be rendered.
		 */
		SelectListRenderer.renderItems = function(oRm, oList) {
			var iSize = oList.getItems().length,
				oSelectedItem = oList.getSelectedItem();

			for (var i = 0, aItems = oList.getItems(); i < aItems.length; i++) {
				this.renderItem(oRm, oList, aItems[i], {
					selected: oSelectedItem === aItems[i],
					setsize: iSize,
					posinset: i + 1
				});
			}
		};

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oList An object representation of the control that should be rendered.
		 * @param {sap.ui.core.Element} oItem An object representation of the element that should be rendered.
		 * @param {object} mStates
		 */
		SelectListRenderer.renderItem = function(oRm, oList, oItem, mStates) {
			var bEnabled = oItem.getEnabled(),
				oSelectedItem = oList.getSelectedItem(),
				CSS_CLASS = SelectListRenderer.CSS_CLASS,
				sTooltip = oItem.getTooltip_AsString();

			if (oItem instanceof sap.ui.core.Element) {
				oRm.write("<li");
				oRm.writeElementData(oItem);

				if (oItem instanceof sap.ui.core.SeparatorItem) {
					oRm.addClass(CSS_CLASS + "SeparatorItem");
				} else {
					oRm.addClass(CSS_CLASS + "Item");

					if (oItem.bVisible === false) {
						oRm.addClass(CSS_CLASS + "ItemInvisible");
					}

					if (!bEnabled) {
						oRm.addClass(CSS_CLASS + "ItemDisabled");
					}

					if (bEnabled && sap.ui.Device.system.desktop) {
						oRm.addClass(CSS_CLASS + "ItemHoverable");
					}

					if (oItem === oSelectedItem) {
						oRm.addClass(CSS_CLASS + "ItemSelected");
					}

					if (bEnabled) {
						oRm.writeAttribute("tabindex", "0");
					}
				}

				oRm.writeClasses();

				if (sTooltip) {
					oRm.writeAttributeEscaped("title", sTooltip);
				}

				this.writeItemAccessibilityState.apply(this, arguments);

				oRm.write(">");
				oRm.writeEscaped(oItem.getText());
				oRm.write("</li>");
			}
		};

		/**
		 * Writes the accessibility state to the control's root element.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oList An object representation of the control that should be rendered.
		 */
		SelectListRenderer.writeAccessibilityState = function(oRm, oList) {
			oRm.writeAccessibilityState({
				role: "listbox"
			});
		};

		/**
		 * Writes the accessibility state to the item.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oList An object representation of the control that should be rendered.
		 * @param {sap.ui.core.Element} oItem An object representation of the element that should be rendered.
		 * @param {object} mStates
		 */
		SelectListRenderer.writeItemAccessibilityState = function(oRm, oList, oItem, mStates) {
			var sRole = (oItem instanceof sap.ui.core.SeparatorItem) ? "separator" : "option";

			oRm.writeAccessibilityState(oItem, {
				role: sRole,
				selected: mStates.selected,
				setsize: mStates.setsize,
				posinset: mStates.posinset
			});
		};

		return SelectListRenderer;

	}, /* bExport= */ true);
}; // end of sap/m/SelectListRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SelectRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.SelectRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained
sap.ui.define("sap/m/SelectRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/core/ValueStateSupport'],
	function(jQuery, Renderer, ValueStateSupport) {
		"use strict";

		/**
		 * Select renderer.
		 * @namespace
		 */
		var SelectRenderer = {};

		/**
		 * CSS class to be applied to the HTML root element of the Select control.
		 *
		 * @type {string}
		 */
		SelectRenderer.CSS_CLASS = "sapMSlt";

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.m.Select} oSelect An object representation of the control that should be rendered.
		 */
		SelectRenderer.render = function(oRm, oSelect) {
			var	sTooltip = ValueStateSupport.enrichTooltip(oSelect, oSelect.getTooltip_AsString()),
				sType = oSelect.getType(),
				bAutoAdjustWidth = oSelect.getAutoAdjustWidth(),
				bEnabled = oSelect.getEnabled(),
				CSS_CLASS = SelectRenderer.CSS_CLASS;

			oRm.write("<div");
			this.addStyleClass(oRm, oSelect);
			oRm.addClass(CSS_CLASS);
			oRm.addClass(CSS_CLASS + oSelect.getType());

			if (!bEnabled) {
				oRm.addClass(CSS_CLASS + "Disabled");
			}

			if (bAutoAdjustWidth) {
				oRm.addClass(CSS_CLASS + "AutoAdjustedWidth");
			} else {
				oRm.addStyle("width", oSelect.getWidth());
			}

			if (oSelect.getIcon()) {
				oRm.addClass(CSS_CLASS + "WithIcon");
			}

			if (bEnabled && sap.ui.Device.system.desktop) {
				oRm.addClass(CSS_CLASS + "Hoverable");
			}

			oRm.addClass(CSS_CLASS + "WithArrow");
			oRm.addStyle("max-width", oSelect.getMaxWidth());
			oRm.writeControlData(oSelect);
			oRm.writeStyles();
			oRm.writeClasses();
			this.writeAccessibilityState(oRm, oSelect);

			if (sTooltip) {
				oRm.writeAttributeEscaped("title", sTooltip);
			}

			if (bEnabled) {
				oRm.writeAttribute("tabindex", "0");
			}

			oRm.write(">");
			this.renderLabel(oRm, oSelect);

			switch (sType) {
				case sap.m.SelectType.Default:
					this.renderArrow(oRm, oSelect);
					break;

				case sap.m.SelectType.IconOnly:
					this.renderIcon(oRm, oSelect);
					break;

				// no default
			}

			if (oSelect._isRequiredSelectElement()) {
				this.renderSelectElement(oRm, oSelect);
			}

			oRm.write("</div>");
		};

		/**
		 * Renders the select's label, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.m.Select} oSelect An object representation of the control that should be rendered.
		 * @private
		 */
		SelectRenderer.renderLabel = function(oRm, oSelect) {
			var oSelectedItem = oSelect.getSelectedItem(),
				sTextDir = oSelect.getTextDirection(),
				sTextAlign = Renderer.getTextAlign(oSelect.getTextAlign(), sTextDir);

			oRm.write("<label");
			oRm.writeAttribute("id", oSelect.getId() + "-label");
			oRm.writeAttribute("for", oSelect.getId());
			oRm.addClass(SelectRenderer.CSS_CLASS + "Label");

			if (oSelect.getType() === sap.m.SelectType.IconOnly) {
				oRm.addClass("sapUiPseudoInvisibleText");
			}

			if (sTextDir !== sap.ui.core.TextDirection.Inherit) {
				oRm.writeAttribute("dir", sTextDir.toLowerCase());
			}

			if (sTextAlign) {
				oRm.addStyle("text-align", sTextAlign);
			}

			oRm.writeStyles();
			oRm.writeClasses();
			oRm.write(">");
			oRm.writeEscaped(oSelectedItem ? oSelectedItem.getText() : "");
			oRm.write('</label>');
		};

		/**
		 * Renders the select's arrow, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @private
		 */
		SelectRenderer.renderArrow = function(oRm, oSelect) {
			oRm.write('<span class="' + SelectRenderer.CSS_CLASS + 'Arrow"');
			oRm.writeAttribute("id", oSelect.getId() + "-arrow");
			oRm.write("></span>");
		};

		/**
		 * Renders the select's icon, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {string} oSelect
		 * @private
		 */
		SelectRenderer.renderIcon = function(oRm, oSelect) {
			oRm.writeIcon(oSelect.getIcon(), SelectRenderer.CSS_CLASS + "Icon", {
				id: oSelect.getId() + "-icon"
			});
		};

		/**
		 * Renders the HTMLSelectElement for the select control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.m.Select} oSelect An object representation of the select that should be rendered.
		 * @private
		 */
		SelectRenderer.renderSelectElement = function(oRm, oSelect) {
			var sName = oSelect.getName(),
				oSelectedItem = oSelect.getSelectedItem(),
				sSelectedItemText = oSelectedItem ? oSelectedItem.getText() : "";

			oRm.write('<select class="' + SelectRenderer.CSS_CLASS + "Native" + '"');

			if (sName) {
				oRm.writeAttributeEscaped("name", sName);
			}

			oRm.writeAttribute("id", oSelect.getId() + "-select");
			oRm.writeAttribute("aria-hidden", "true");
			oRm.writeAttribute("tabindex", "-1");
			oRm.write(">");
			this.renderOptions(oRm, oSelect, sSelectedItemText);
			oRm.write("</select>");
		};

		/**
		 * Renders the HTMLOptionElement(s) for the select control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.m.Select} oSelect An object representation of the select that should be rendered.
		 * @param {string} sSelectedItemText
		 * @private
		 */
		SelectRenderer.renderOptions = function(oRm, oSelect, sSelectedItemText) {
			var aItems = oSelect.getItems(),
				aItemsLength = aItems.length,
				i = 0;

			for (; i < aItemsLength; i++) {
				oRm.write("<option>");
				oRm.writeEscaped(aItems[i].getText());
				oRm.write("</option>");
			}

			if (aItemsLength === 0) {
				oRm.write("<option>" + sSelectedItemText + "</option>");
			}
		};

		/**
		 * This method is reserved for derived class to add extra classes to the HTML root element of the control.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oSelect An object representation of the control that should be rendered.
		 * @protected
		 */
		SelectRenderer.addStyleClass = function(oRm, oSelect) {};

		/**
		 * Gets accessibility role.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.Control} oSelect An object representation of the control that should be rendered.
		 * @protected
		 */
		SelectRenderer.getAriaRole = function(oSelect) {
			switch (oSelect.getType()) {
				case sap.m.SelectType.Default:
					return "combobox";

				case sap.m.SelectType.IconOnly:
					return "button";

				// no default
			}
		};

		/**
		 * Writes the accessibility state.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oSelect An object representation of the control that should be rendered.
		 */
		SelectRenderer.writeAccessibilityState = function(oRm, oSelect) {
			oRm.writeAccessibilityState(oSelect, {
				role: this.getAriaRole(oSelect),
				expanded: oSelect.isOpen(),
				live: "polite",
				labelledby: {
					value: oSelect.getId() + "-label",
					append: true
				}
			});
		};

		return SelectRenderer;

	}, /* bExport= */ true);
}; // end of sap/m/SelectRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ShellRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
 
 jQuery.sap.declare('sap.m.ShellRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ShellRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Shell renderer. 
	 * @namespace
	 */
	var ShellRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ShellRenderer.render = function(rm, oControl) {
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapMShell");
		if (oControl.getAppWidthLimited()) {
			rm.addClass("sapMShellAppWidthLimited");
		}
		
		sap.m.BackgroundHelper.addBackgroundColorStyles(rm, oControl.getBackgroundColor(),  oControl.getBackgroundImage(), "sapMShellGlobalOuterBackground");
		
		rm.writeClasses();
		rm.writeStyles();
		
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		
		rm.write(">");
		
		sap.m.BackgroundHelper.renderBackgroundImageTag(rm, oControl, "sapMShellBG",  oControl.getBackgroundImage(), oControl.getBackgroundRepeat(), oControl.getBackgroundOpacity());
		
		rm.write("<div class='sapMShellBrandingBar'></div>");
		
		
		rm.write("<div class='sapMShellCentralBox'>");
		
		
		// header
		var extraHeaderClass = "", extraBGClass = "";
		if (!oControl.getBackgroundImage()) {
			extraHeaderClass = "sapMShellBackgroundColorOnlyIfDefault";
			extraBGClass = "sapMGlobalBackgroundImageOnlyIfDefault";
		}
		rm.write("<header class='sapMShellHeader " + extraHeaderClass + "' id='" + oControl.getId() + "-hdr'>");
		rm.write("<div class='" + extraBGClass + "'></div>");
		// logo
		rm.write(ShellRenderer.getLogoImageHtml(oControl));
		
		// header title
		rm.write("<h1 id='" + oControl.getId() + "-hdrTxt' class='sapMShellHeaderText'>");
		rm.writeEscaped(oControl.getTitle());
		rm.write("</h1>");
		
		// header right area
		rm.write("<span class='sapMShellHeaderRight'>");
		
		// headerRightText
		rm.write("<span id='" + oControl.getId() + "-hdrRightTxt' ");
		if (!oControl.getHeaderRightText()) {
			rm.writeAttribute("style", "display:none;");
		}
		rm.write("class='sapMShellHeaderRightText'>" + jQuery.sap.encodeHTML(oControl.getHeaderRightText()) + "</span>");
	
		
		// logout button
		if (oControl.getShowLogout()) {
			var rb = sap.ui.getCore().getLibraryResourceBundle("sap.m");
			rm.write("<a id='" + oControl.getId() + "-logout' tabindex='0' role='button' class='sapMShellHeaderLogout'>" + rb.getText("SHELL_LOGOUT") + "</a>");
		}
		
		rm.write("</span></header>");
		
		
		
		// content
		rm.write("<section class='sapMShellContent sapMShellGlobalInnerBackground' id='" + oControl.getId() + "-content' data-sap-ui-root-content='true'>");
	
		rm.renderControl(oControl.getApp());
		
		rm.write("</section></div></div>");
	};

	ShellRenderer.getLogoImageHtml = function(oControl) {
		var sImage = oControl.getLogo(); // configured logo
		if (!sImage) {
			jQuery.sap.require("sap.ui.core.theming.Parameters");
			sImage = sap.ui.core.theming.Parameters._getThemeImage(); // theme logo
		}

		var result = "";
		if (sImage) {
			var oRb = sap.ui.getCore().getLibraryResourceBundle("sap.m");
			result = "<div class='sapMShellLogo'>";
			if (sap.ui.Device.browser.internet_explorer) {
				result += "<span class='sapMShellLogoImgAligner'></span>";
			}
			result += "<img id='" + oControl.getId() + "-logo' class='sapMShellLogoImg' src='";
			result += jQuery.sap.encodeHTML(sImage);
			result += "' alt='";
			result += oRb.getText("SHELL_ARIA_LOGO");
			result += "' /></div>";
		}
		return result;
	};

	return ShellRenderer;

 }, /* bExport= */ true);

}; // end of sap/m/ShellRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SliderRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.SliderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/SliderRenderer",['jquery.sap.global'],
	function(jQuery) {
		"use strict";

		/**
		 * Slider renderer.
		 * @namespace
		 */
		var SliderRenderer = {};

		/**
		 * CSS class to be applied to the HTML root element of the Slider control.
		 *
		 * @type {string}
		 */
		SliderRenderer.CSS_CLASS = "sapMSlider";

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oSlider An object representation of the slider that should be rendered.
		 */
		SliderRenderer.render = function(oRm, oSlider) {
			var bEnabled = oSlider.getEnabled(),
				sTooltip = oSlider.getTooltip_AsString(),
				CSS_CLASS = SliderRenderer.CSS_CLASS;

			oRm.write("<div");
			oRm.addClass(CSS_CLASS);

			if (!bEnabled) {
				oRm.addClass(CSS_CLASS + "Disabled");
			}

			oRm.addStyle("width", oSlider.getWidth());
			oRm.writeClasses();
			oRm.writeStyles();
			oRm.writeControlData(oSlider);

			if (sTooltip) {
				oRm.writeAttributeEscaped("title", sTooltip);
			}

			oRm.write(">");
			oRm.write('<div');
			oRm.writeAttribute("id", oSlider.getId() + "-inner");
			oRm.addClass(CSS_CLASS + "Inner");

			if (!bEnabled) {
				oRm.addClass(CSS_CLASS + "InnerDisabled");
			}

			oRm.writeClasses();
			oRm.writeStyles();
			oRm.write(">");

			if (oSlider.getProgress()) {
				this.renderProgressIndicator(oRm, oSlider);
			}

			this.renderHandle(oRm, oSlider);
			oRm.write("</div>");

			if (oSlider.getName()) {
				this.renderInput(oRm, oSlider);
			}

			oRm.write("</div>");
		};

		SliderRenderer.renderProgressIndicator = function(oRm, oSlider) {
			oRm.write("<div");
			oRm.writeAttribute("id", oSlider.getId() + "-progress");
			oRm.addClass(SliderRenderer.CSS_CLASS + "Progress");
			oRm.addStyle("width", oSlider._sProgressValue);
			oRm.writeClasses();
			oRm.writeStyles();
			oRm.write(' aria-hidden="true"></div>');
		};

		SliderRenderer.renderHandle = function(oRm, oSlider) {
			var bEnabled = oSlider.getEnabled();

			oRm.write("<span");
			oRm.writeAttribute("id", oSlider.getId() + "-handle");
			oRm.writeAttribute("title", oSlider.getValue());
			oRm.addClass(SliderRenderer.CSS_CLASS + "Handle");
			oRm.addStyle(sap.ui.getCore().getConfiguration().getRTL() ? "right" : "left", oSlider._sProgressValue);
			this.writeAccessibilityState(oRm, oSlider);
			oRm.writeClasses();
			oRm.writeStyles();

			if (bEnabled) {
				oRm.writeAttribute("tabindex", "0");
			}

			oRm.write("></span>");
		};

		SliderRenderer.renderInput = function(oRm, oSlider) {
			oRm.write('<input type="text"');
			oRm.writeAttribute("id", oSlider.getId() + "-input");
			oRm.addClass(SliderRenderer.CSS_CLASS + "Input");

			if (!oSlider.getEnabled()) {
				oRm.write("disabled");
			}

			oRm.writeClasses();
			oRm.writeAttributeEscaped("name", oSlider.getName());
			oRm.writeAttribute("value", oSlider.getValue());
			oRm.write("/>");
		};

		/**
		 * Writes the accessibility state to the control.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oSlider An object representation of the control that should be rendered.
		 */
		SliderRenderer.writeAccessibilityState = function(oRm, oSlider) {
			var fValue = oSlider.getValue();

			oRm.writeAccessibilityState(oSlider, {
				role: "slider",
				orientation: "horizontal",
				valuemin: oSlider.getMin(),
				valuemax: oSlider.getMax(),
				valuenow: fValue
			});
		};

		return SliderRenderer;

	}, /* bExport= */ true);
}; // end of sap/m/SliderRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SplitContainerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.SplitContainerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/SplitContainerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * SplitContainer renderer. 
	 * @namespace
	 */
	var SplitContainerRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	SplitContainerRenderer.render = function(oRm, oControl){
		var sMode = oControl.getMode();

		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMSplitContainer");
		
		if (this.renderAttributes) {
			this.renderAttributes(oRm, oControl); // may be used by inheriting renderers, but DO NOT write class or style attributes! Instead, call addClass/addStyle.
		}
		
		if (!sap.ui.Device.system.phone) {
			if (sap.ui.Device.orientation.portrait) {
				oRm.addClass("sapMSplitContainerPortrait");
			}
			switch (sMode) {
				case "ShowHideMode":
					oRm.addClass("sapMSplitContainerShowHide");
					break;
				case "StretchCompress":
					oRm.addClass("sapMSplitContainerStretchCompress");
					break;
				case "PopoverMode":
					oRm.addClass("sapMSplitContainerPopover");
					break;
				case "HideMode":
					oRm.addClass("sapMSplitContainerHideMode");
			}
		}
		oRm.writeClasses();
		oRm.writeStyles();
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}
		oRm.write(">"); // div element
		
		if (this.renderBeforeContent) {
			this.renderBeforeContent(oRm, oControl);
		}
		
		if (!sap.ui.Device.system.phone) {
			oControl._bMasterisOpen = false;
			if ((sap.ui.Device.orientation.landscape && (sMode !== "HideMode")) ||
					sap.ui.Device.orientation.portrait && (sMode === "StretchCompress")) {
				oControl._oMasterNav.addStyleClass("sapMSplitContainerMasterVisible");
				oControl._bMasterisOpen = true;
			} else {
				oControl._oMasterNav.addStyleClass("sapMSplitContainerMasterHidden");
			}

			if (oControl.getMode() === "PopoverMode" && sap.ui.Device.orientation.portrait) {
				oControl._oDetailNav.addStyleClass("sapMSplitContainerDetail");
				oRm.renderControl(oControl._oDetailNav);
				//add master to popover if it's not yet added
				if (oControl._oPopOver.getContent().length === 0) {
					oControl._oPopOver.addAggregation("content", oControl._oMasterNav, true);
				}
			} else {
				oControl._oMasterNav.addStyleClass("sapMSplitContainerMaster");
				oRm.renderControl(oControl._oMasterNav);
				
				oControl._oDetailNav.addStyleClass("sapMSplitContainerDetail");
				oRm.renderControl(oControl._oDetailNav);
			}
		} else {
			oControl._oMasterNav.addStyleClass("sapMSplitContainerMobile");
			oRm.renderControl(oControl._oMasterNav);
		}
		
		 oRm.write("</div>");
	};
	

	return SplitContainerRenderer;

}, /* bExport= */ true);

}; // end of sap/m/SplitContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.StandardListItemRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.StandardListItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/StandardListItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, Renderer) {
	"use strict";


	/**
	 * StandardListItem renderer.
	 * @namespace
	 */
	var StandardListItemRenderer = Renderer.extend(ListItemBaseRenderer);

	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *          oRenderManager the RenderManager that can be used for writing to the
	 *          Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be
	 *          rendered
	 */
	StandardListItemRenderer.renderLIAttributes = function(rm, oLI) {
		rm.addClass("sapMSLI");
		if (oLI._showSeparators  == sap.m.ListSeparators.None && !oLI.getIconInset()) {
			rm.addClass("sapMSLIShowSeparatorNone");
		}
		if (oLI.getIcon()) {
			rm.addClass("sapMSLIIcon");
		}
		if (!oLI.getIconInset()) {
			rm.addClass("sapMSLIIconThumb");
		}
		if ((oLI.getDescription() || !oLI.getAdaptTitleSize()) && oLI.getIcon() &&  oLI.getIconInset()) {
			rm.addClass("sapMSLIDescIcon");
		}
		if ((oLI.getDescription() || !oLI.getAdaptTitleSize()) && !oLI.getIcon()) {
			rm.addClass("sapMSLIDescNoIcon");
		}
		if (!oLI.getDescription() && oLI.getIcon()) {
			rm.addClass("sapMSLINoDescIcon");
		}
		if (oLI.getType() == sap.m.ListType.Detail || oLI.getType() == sap.m.ListType.DetailAndActive) {
			rm.addClass("sapMSLIDetail");
		}

	};

	StandardListItemRenderer.renderLIContent = function(rm, oLI) {

		var sTextDir = oLI.getTitleTextDirection(),
			sInfoDir = oLI.getInfoTextDirection();
		
		// image
		if (oLI.getIcon()) {
			if (oLI.getIconInset()) {
				var oList = sap.ui.getCore().byId(oLI._listId);
				if (oList && oList.getMode() == sap.m.ListMode.None & !oList.getShowUnread()) {
					rm.renderControl(oLI._getImage((oLI.getId() + "-img"), "sapMSLIImgFirst", oLI.getIcon(), oLI.getIconDensityAware()));
				} else {
					rm.renderControl(oLI._getImage((oLI.getId() + "-img"), "sapMSLIImg", oLI.getIcon(), oLI.getIconDensityAware()));
				}
			} else {
				rm.renderControl(oLI._getImage((oLI.getId() + "-img"), "sapMSLIImgThumb", oLI.getIcon(), oLI.getIconDensityAware()));
			}
		}

		var isDescription = oLI.getTitle() && (oLI.getDescription() || !oLI.getAdaptTitleSize())  || (oLI._showSeparators  == sap.m.ListSeparators.None && !oLI.getIconInset());
		var isInfo = oLI.getInfo();

		if (isDescription) {
			rm.write("<div");
			rm.addClass("sapMSLIDiv");
			rm.writeClasses();
			rm.write(">");
		}

		rm.write("<div");
		if (!isDescription) {
			rm.addClass("sapMSLIDiv");
		}
		rm.addClass("sapMSLITitleDiv");
		rm.writeClasses();
		rm.write(">");

		//noFlex: make an additional div for the contents table
		if (!isDescription && oLI._bNoFlex) {
			rm.write('<div class="sapMLIBNoFlex">');
		}
		// List item text (also written when no title for keeping the space)
		rm.write("<div");
		if (isDescription) {
			rm.addClass("sapMSLITitle");
		} else {
			rm.addClass("sapMSLITitleOnly");
		}
		rm.writeClasses();
		
		if (sTextDir !== sap.ui.core.TextDirection.Inherit) {
			rm.writeAttribute("dir", sTextDir.toLowerCase());
		}
		
		rm.write(">");
		rm.writeEscaped(oLI.getTitle());
		rm.write("</div>");

		//info div top when @sapUiInfoTop: true;
		if (isInfo && (sap.ui.core.theming.Parameters.get("sapUiInfoTop") == "true" || !isDescription)) {
			rm.write("<div");
			rm.writeAttribute("id", oLI.getId() + "-info");
			rm.addClass("sapMSLIInfo");
			rm.addClass("sapMSLIInfo" + oLI.getInfoState());
			rm.writeClasses();
			if (sInfoDir !== sap.ui.core.TextDirection.Inherit) {
				rm.writeAttribute("dir", sInfoDir.toLowerCase());
			}
			rm.write(">");
			rm.writeEscaped(isInfo);
			rm.write("</div>");
		}

		//noFlex: make an additional div for the contents table
		if (!isDescription && oLI._bNoFlex) {
			rm.write('</div>');
		}
		rm.write("</div>");

		rm.write("<div");
		rm.addClass("sapMSLIDescriptionDiv");
		rm.writeClasses();
		rm.write(">");

		// List item text
		if (isDescription) {
			rm.write("<div");
			rm.addClass("sapMSLIDescription");
			rm.writeClasses();
			rm.write(">");
			if (oLI.getDescription()) {
				rm.writeEscaped(oLI.getDescription());
			} else {
				rm.write("&nbsp;");
			}
			rm.write("</div>");
		}

		if (isInfo && sap.ui.core.theming.Parameters.get("sapUiInfoTop") == "false" && isDescription) {
			rm.write("<div");
			rm.writeAttribute("id", oLI.getId() + "-info");
			rm.addClass("sapMSLIInfo");
			if (oLI._showSeparators == sap.m.ListSeparators.None && oLI.getInfoState() == sap.ui.core.ValueState.None) {
				rm.addClass("sapMSLIInfo" + oLI.getInfoState() + "ShowSeparatorNone");
			} else {
				rm.addClass("sapMSLIInfo" + oLI.getInfoState());
			}
			rm.writeClasses();
			if (sInfoDir !== sap.ui.core.TextDirection.Inherit) {
				rm.writeAttribute("dir", sInfoDir.toLowerCase());
			}
			rm.write(">");
			rm.writeEscaped(isInfo);
			rm.write("</div>");
		}
		rm.write("</div>");

		if (isDescription) {
			rm.write("</div>");
		}

	};


	return StandardListItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/StandardListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.Support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.Support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/Support",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * <pre>
	 * <code>sap.m.Support</code> shows the technical information for SAPUI5 Mobile Applications.
	 * This technical information includes
	 * 	* SAPUI5 Version
	 * 	* User Agent
	 * 	* Configurations (Bootstrap and Computed)
	 * 	* URI parameters
	 * 	* All loaded module names
	 *
	 * In order to show the device information, the user must follow the following gestures.
	 * 	1 - Hold two finger for 3 seconds minimum.
	 * 	2 - Tab with a third finger while holding the first two fingers.
	 *
	 * NOTE: This class is internal and all its functions must not be used by an application
	 *
	 * As <code>sap.m.Support</code> is a static class, a <code>jQuery.sap.require("sap.m.Support");</code>
	 * statement must be implicitly executed before the class is used.
	 *
	 *
	 * Enable Support:
	 * --------------------------------------------------
	 * //import library
	 * jQuery.sap.require("sap.m.Support");
	 *
	 * //By default after require, support is enabled but implicitly we can call
	 * sap.m.Support.on();
	 *
	 * Disable Support:
	 * --------------------------------------------------
	 * sap.m.Support.off();
	 * </pre>
	 *
	 * @author SAP SE
	 * @since 1.11.0
	 *
	 * @static
	 * @protected
	 * @name sap.m.Support
	 */
	var Support = (function($, document) {

		var dialog, startTime, isEventRegistered, lastTouchUID;
		var timeDiff = 0;
		var minHoldTime = 3000; // 3s(3000ms) two-finger hold time
		var holdFingersNumber = 2; // two-fingers hold
		var maxFingersAllowed = 3; // two-fingers hold + 1-finger tab
		var releasedFingersNumber = 1,
			oData = {},
			e2eTraceConst = {
				btnStart : "startE2ETrace",
				selLevel : "logLevelE2ETrace",
				taContent : "outputE2ETrace",
				infoText : "Ent-to-End trace is running in the background." +
							" Navigate to the URL that you would like to trace." +
							" The result of the trace will be shown in dialog after the trace is terminated.",
				infoDuration : 5000 // 5 sec.
			},
			controlIDs = {
				dvLoadedLibs 	: "LoadedLibs",
				dvLoadedModules : "LoadedModules"
		};

		// copied from core
		function line(buffer, right, border, label, content) {
			buffer.push("<tr class='sapUiSelectable'><td class='sapUiSupportTechInfoBorder sapUiSelectable'><label class='sapUiSupportLabel sapUiSelectable'>", jQuery.sap.escapeHTML(label), "</label><br>");
			var ctnt = content;
			if ($.isFunction(content)) {
				ctnt = content(buffer) || "";
			}
			buffer.push($.sap.escapeHTML(ctnt));
			buffer.push("</td></tr>");
		}

		// copied from core
		function multiline(buffer, right, border, label, content) {
			line(buffer, right, border, label, function(buffer) {
				buffer.push("<table class='sapMSupportTable' border='0' cellspacing='5' cellpadding='5' width='100%'><tbody>");
				$.each(content, function(i, v) {
					var val = "";
					if (v) {
						if (typeof (v) == "string" || typeof (v) == "boolean" || ($.isArray(v) && v.length == 1)) {
							val = v;
						} else if (($.isArray(v) || $.isPlainObject(v)) && window.JSON) {
							val = window.JSON.stringify(v);
						}
					}
					line(buffer, false, false, i, "" + val);
				});
				buffer.push("</tbody></table>");
			});
		}

		// copied from core
		function getTechnicalContent() {
			var html,
				oConfig = sap.ui.getCore().getConfiguration();
			var oLoadedLibs = {};
			jQuery.each(sap.ui.getCore().getLoadedLibraries(), function(sName, oLibInfo) {
				oLoadedLibs[sName] = oLibInfo.version;
			});
			oData = {
					version: sap.ui.version,
					build: sap.ui.buildinfo.buildtime,
					change: sap.ui.buildinfo.lastchange,
					useragent: navigator.userAgent,
					docmode: document.documentMode ||  "",
					debug: $.sap.debug(),
					bootconfig: window["sap-ui-config"] || {},
					modules: $.sap.getAllDeclaredModules(),
					loadedlibs: oLoadedLibs,
					uriparams: $.sap.getUriParameters().mParams,
					appurl: window.location.href,
					config: {
						theme: oConfig.getTheme(),
						language: oConfig.getLanguage(),
						formatLocale: oConfig.getFormatLocale(),
						accessibility: "" + oConfig.getAccessibility(),
						animation: "" + oConfig.getAnimation(),
						rtl: "" + oConfig.getRTL(),
						debug: "" + oConfig.getDebug(),
						inspect: "" + oConfig.getInspect(),
						originInfo: "" + oConfig.getOriginInfo(),
						noDuplicateIds: "" + oConfig.getNoDuplicateIds()
					}
			};

			html = ["<table class='sapUiSelectable' border='0' cellspacing='5' cellpadding='5' width='100%'><tbody class='sapUiSelectable'>"];
			line(html, true, true, "SAPUI5 Version", function(buffer) {
				buffer.push(oData.version, " (built at ", oData.build, ", last change ", oData.change, ")");
			});
			line(html, true, true, "User Agent", function(buffer) {
				buffer.push(oData.useragent, (oData.docmode ? ", Document Mode '" + oData.docmode + "'" : ""));
			});
			line(html, true, true, "Debug Sources", function(buffer) {
				buffer.push((oData.debug ? "ON" : "OFF") );
			});
			line(html, true, true, "Application", oData.appurl);
			multiline(html, true, true, "Configuration (bootstrap)", oData.bootconfig);
			multiline(html, true, true, "Configuration (computed)", oData.config);
			multiline(html, true, true, "URI Parameters", oData.uriparams);
			// e2e trace section
			line(html, true, true, "End-to-End Trace", function(buffer) {
				buffer.push("<label class='sapUiSupportLabel'>Trace Level:</label>",
					"<select id='" + buildControlId(e2eTraceConst.selLevel) + "' class='sapUiSupportTxtFld' >",
						"<option value='low'>LOW</option>",
						"<option value='medium' selected>MEDIUM</option>",
						"<option value='high'>HIGH</option>",
					"</select>"
				);
				buffer.push("<button id='" + buildControlId(e2eTraceConst.btnStart) + "' class='sapUiSupportBtn'>Start</button>");
				buffer.push("<div class='sapUiSupportDiv'>");
				buffer.push("<label class='sapUiSupportLabel'>XML Output:</label>");
				buffer.push("<textarea id='" + buildControlId(e2eTraceConst.taContent) +  "' class='sapUiSupportTxtArea sapUiSelectable' readonly ></textarea>");
				buffer.push("</div>");
			});

			line(html, true, true, "Loaded Libraries", function(buffer) {
				buffer.push("<ul class='sapUiSelectable'>");
				$.each(oData.loadedlibs, function(i, v) {
		            if (v && (typeof (v) === "string" || typeof (v) === "boolean")) {
	                     buffer.push("<li class='sapUiSelectable'>", i + " " + v, "</li>");
		            }
				});
				buffer.push("</ul>");
			});

			line(html, true, true, "Loaded Modules", function(buffer) {
				buffer.push("<div class='sapUiSupportDiv sapUiSelectable' id='" + buildControlId(controlIDs.dvLoadedModules) + "' />");
			});

			html.push("</tbody></table>");

			return new sap.ui.core.HTML({
				content : html.join("").replace(/\{/g, "&#123;").replace(/\}/g, "&#125;")
			});
		}

		function buildControlId(controlId) {
			return dialog.getId() + "-" + controlId;
		}

		function fillPanelContent(panelId, arContent) {

			var panelHeader = "Modules";
			var libsCount = 0, arDivContent = [];

			libsCount = arContent.length;
			$.each(arContent.sort(), function(i, module) {
				arDivContent.push(new sap.m.Label({ text : " - " + module }).addStyleClass("sapUiSupportPnlLbl"));
			});

			// insert content into div placeholders
			var objPanel = new sap.m.Panel({
				expandable : true,
				expanded : false,
				headerToolbar : new sap.m.Toolbar({
					design : sap.m.ToolbarDesign.Transparent,
					content : [new sap.m.Label({
						text : panelHeader + " (" + libsCount + ")",
						design : sap.m.LabelDesign.Bold
					})]
				}),
				content : arDivContent
			});

			objPanel.placeAt( buildControlId(panelId), "only");
		}

		// setup dialog elements and bind some events
		function setupDialog() {
			// setup e2e values as log level and content
			if (dialog.traceXml) {
				dialog.$(e2eTraceConst.taContent).text(dialog.traceXml);
			}
			if (dialog.e2eLogLevel) {
				dialog.$(e2eTraceConst.selLevel).val(dialog.e2eLogLevel);
			}

			fillPanelContent(controlIDs.dvLoadedModules, oData.modules);


			// bind button Start event
			dialog.$(e2eTraceConst.btnStart).one("tap", function() {

				dialog.e2eLogLevel = dialog.$(e2eTraceConst.selLevel).val();
				dialog.$(e2eTraceConst.btnStart).addClass("sapUiSupportRunningTrace").text("Running...");
				dialog.traceXml = "";
				dialog.$(e2eTraceConst.taContent).text("");

				sap.ui.core.support.trace.E2eTraceLib.start(dialog.e2eLogLevel, function(traceXml) {
					dialog.traceXml = traceXml;
				});

				// show info message about the E2E trace activation
				sap.m.MessageToast.show(e2eTraceConst.infoText, {duration: e2eTraceConst.infoDuration});

				//close the dialog, but keep it for later use
				dialog.close();
			});
		}

		// get or create dialog instance and return
		function getDialog() {
			if (dialog) {
				return dialog;
			}

			$.sap.require("sap.m.Dialog");
			$.sap.require("sap.m.Button");
			$.sap.require("sap.ui.core.HTML");
			$.sap.require("sap.m.MessageToast");
			$.sap.require("sap.ui.core.support.trace.E2eTraceLib");

			dialog = new sap.m.Dialog({
				title : "Technical Information",
				horizontalScrolling: true,
				verticalScrolling: true,
				stretch: jQuery.device.is.phone,
				leftButton : new sap.m.Button({
					text : "Close",
					press : function() {
						dialog.close();
					}
				}),
				afterOpen : function() {
					Support.off();
				},
				afterClose : function() {
					Support.on();
				}
			}).addStyleClass("sapMSupport");

			return dialog;
		}



		//function is triggered when a touch is detected
		function onTouchStart(oEvent) {
			if (oEvent.touches) {
				var currentTouches = oEvent.touches.length;

				if (currentTouches > maxFingersAllowed) {
					document.removeEventListener('touchend', onTouchEnd);
					return;
				}

				switch (currentTouches) {

					case holdFingersNumber:
						startTime = Date.now();
						document.addEventListener('touchend', onTouchEnd);
						break;

					case maxFingersAllowed:
						if (startTime) {
							timeDiff = Date.now() - startTime;
							lastTouchUID = oEvent.touches[currentTouches - 1].identifier;
						}
						break;
				}
			}
		}

		//function is triggered when a touch is removed e.g. the user’s finger is removed from the touchscreen.
		function onTouchEnd(oEvent) {
			document.removeEventListener('touchend', onTouchEnd);

			// Check if two fingers are holded for 3 seconds or more and after that it`s tapped with a third finger
			if (timeDiff > minHoldTime
					&& oEvent.touches.length === holdFingersNumber
					&& oEvent.changedTouches.length === releasedFingersNumber
					&& oEvent.changedTouches[0].identifier === lastTouchUID) {

						timeDiff = 0;
						startTime = 0;
						show();
			}
		}

		function show() {
			var container = getDialog();
			container.removeAllAggregation("content");
			container.addAggregation("content", getTechnicalContent());
			dialog.open();
			setupDialog();
		}

		return ({
			/**
			 * Enables support.
			 *
			 * @returns {sap.m.Support} this to allow method chaining
			 * @protected
			 * @name sap.m.Support.on
			 * @function
			 */
			on : function() {
				if (!isEventRegistered && "ontouchstart" in document) {
					isEventRegistered = true;
					document.addEventListener("touchstart", onTouchStart);
				}
				return this;
			},

			/**
			 * Disables support.
			 *
			 * @returns {sap.m.Support} this to allow method chaining
			 * @protected
			 * @name sap.m.Support.off
			 * @function
			 */
			off : function() {
				if (isEventRegistered) {
					isEventRegistered = false;
					document.removeEventListener("touchstart", onTouchStart);
				}
				return this;
			},

			open : function() {
				show();
			},

			/**
			 * Returns if event is registered or not.
			 *
			 * @returns {boolean}
			 * @protected
			 * @name sap.m.Support.isEventRegistered
			 * @function
			 */
			isEventRegistered : function() {
				return isEventRegistered;
			}
		}).on();

	}(jQuery, document));


	return Support;

}, /* bExport= */ true);

}; // end of sap/m/Support.js
if ( !jQuery.sap.isDeclared('sap.m.SwitchRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.SwitchRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/SwitchRenderer",['jquery.sap.global'],
	function(jQuery) {
		"use strict";

		/**
		 * Switch renderer.
		 * @namespace
		 */
		var SwitchRenderer = {};

		/**
		 * CSS class to be applied to the HTML root element of the Switch control.
		 *
		 * @type {string}
		 */
		SwitchRenderer.CSS_CLASS = "sapMSwt";

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the Render-Output-Buffer.
		 * @param {sap.ui.core.Control} oSwitch An object representation of the control that should be rendered.
		 */
		SwitchRenderer.render = function(oRm, oSwitch) {
			var bState = oSwitch.getState(),
				sState = bState ? oSwitch._sOn : oSwitch._sOff,
				sTooltip = oSwitch.getTooltip_AsString(),
				bEnabled = oSwitch.getEnabled(),
				sName = oSwitch.getName(),
				bAccessibilityEnabled = sap.ui.getCore().getConfiguration().getAccessibility(),
				oRb = sap.ui.getCore().getLibraryResourceBundle("sap.m"),
				CSS_CLASS = SwitchRenderer.CSS_CLASS;

			oRm.write("<div");
			oRm.addClass(CSS_CLASS + "Cont");

			if (!bEnabled) {
				oRm.addClass(CSS_CLASS + "ContDisabled");
			}

			oRm.writeClasses();
			oRm.writeStyles();
			oRm.writeControlData(oSwitch);

			if (bEnabled) {
				oRm.writeAttribute("tabindex", "0");
			}

			if (sTooltip) {
				oRm.writeAttributeEscaped("title", sTooltip);
			}

			if (bAccessibilityEnabled) {
				this.writeAccessibilityState(oRm, oSwitch);
			}

			oRm.write("><div");
			oRm.writeAttribute("id", oSwitch.getId() + "-switch");
			oRm.writeAttribute("aria-hidden", "true");
			oRm.addClass(CSS_CLASS);
			oRm.addClass(bState ? CSS_CLASS + "On" : CSS_CLASS + "Off");
			oRm.addClass(CSS_CLASS + oSwitch.getType());

			if (sap.ui.Device.system.desktop && bEnabled) {
				oRm.addClass(CSS_CLASS + "Hoverable");
			}

			if (!bEnabled) {
				oRm.addClass(CSS_CLASS + "Disabled");
			}

			oRm.writeClasses();
			oRm.write("><div");
			oRm.addClass(CSS_CLASS + "Inner");
			oRm.writeAttribute("id", oSwitch.getId() + "-inner");
			oRm.writeClasses();
			oRm.write(">");

			// text
			this.renderText(oRm, oSwitch);

			// handle
			this.renderHandle(oRm, oSwitch, sState);

			oRm.write("</div>");
			oRm.write("</div>");

			if (sName) {

				// checkbox
				this.renderCheckbox(oRm, oSwitch, sState);
			}

			if (bAccessibilityEnabled) {
				this.renderInvisibleElement(oRm, oSwitch, {
					id: oSwitch.getInvisibleElementId(),
					text: oRb.getText(oSwitch.getInvisibleElementText())
				});
			}

			oRm.write("</div>");
		};

		SwitchRenderer.renderText = function(oRm, oSwitch) {
			var CSS_CLASS = SwitchRenderer.CSS_CLASS,
				bDefaultType = oSwitch.getType() === sap.m.SwitchType.Default;

			// on
			oRm.write("<div");
			oRm.addClass(CSS_CLASS + "Text");
			oRm.addClass(CSS_CLASS + "TextOn");
			oRm.writeAttribute("id", oSwitch.getId() + "-texton");
			oRm.writeClasses();
			oRm.write(">");
			oRm.write("<span");
			oRm.addClass(CSS_CLASS + "Label");
			oRm.addClass(CSS_CLASS + "LabelOn");
			oRm.writeClasses();
			oRm.write(">");

			if (bDefaultType) {
				oRm.writeEscaped(oSwitch._sOn);
			}

			oRm.write("</span>");
			oRm.write("</div>");

			// off
			oRm.write("<div");
			oRm.addClass(CSS_CLASS + "Text");
			oRm.addClass(CSS_CLASS + "TextOff");
			oRm.writeAttribute("id", oSwitch.getId() + "-textoff");
			oRm.writeClasses();
			oRm.write(">");
			oRm.write("<span");
			oRm.addClass(CSS_CLASS + "Label");
			oRm.addClass(CSS_CLASS + "LabelOff");
			oRm.writeClasses();
			oRm.write(">");

			if (bDefaultType) {
				oRm.writeEscaped(oSwitch._sOff);
			}

			oRm.write("</span>");
			oRm.write("</div>");
		};

		SwitchRenderer.renderHandle = function(oRm, oSwitch, sState) {
			var CSS_CLASS = SwitchRenderer.CSS_CLASS;

			oRm.write("<div");
			oRm.writeAttribute("id", oSwitch.getId() + "-handle");
			oRm.writeAttributeEscaped("data-sap-ui-swt", sState);
			oRm.addClass(CSS_CLASS + "Handle");

			if (sap.ui.Device.browser.webkit && Number(sap.ui.Device.browser.webkitVersion).toFixed(2) === "537.35") {
				oRm.addClass(CSS_CLASS + "WebKit537-35");
			}

			oRm.writeClasses();
			oRm.write("></div>");
		};

		SwitchRenderer.renderCheckbox = function(oRm, oSwitch, sState) {
			oRm.write('<input type="checkbox"');
			oRm.writeAttribute("id", oSwitch.getId() + "-input");
			oRm.writeAttributeEscaped("name", oSwitch.getName());
			oRm.writeAttributeEscaped("value", sState);

			if (oSwitch.getState()) {
				oRm.writeAttribute("checked", "checked");
			}

			if (!oSwitch.getEnabled()) {
				oRm.writeAttribute("disabled", "disabled");
			}

			oRm.write(">");
		};

		/**
		 * Writes the accessibility state.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oSwitch An object representation of the control that should be rendered.
		 */
		SwitchRenderer.writeAccessibilityState = function(oRm, oSwitch) {
			var mAriaLabelledby = oSwitch.getAriaLabelledBy(),
				mAccessibilityStates;

			if (mAriaLabelledby) {
				mAriaLabelledby = {
					value: oSwitch.getInvisibleElementId(),
					append: true
				};
			}

			mAccessibilityStates = {
				role: "checkbox",
				checked: oSwitch.getState(),
				labelledby: mAriaLabelledby
			};

			oRm.writeAccessibilityState(oSwitch, mAccessibilityStates);
		};

		/**
		 * Writes an invisible span element with a text node that is referenced in the ariaLabelledBy
		 * associations for screen reader announcement.
		 *
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oSwitch An object representation of the control that should be rendered.
		 * @param {object} mOptions
		 */
		SwitchRenderer.renderInvisibleElement = function(oRm, oSwitch, mOptions) {
			oRm.write("<span");
			oRm.writeAttribute("id", mOptions.id);
			oRm.writeAttribute("aria-hidden", "true");
			oRm.addClass("sapUiInvisibleText");
			oRm.writeClasses();
			oRm.write(">");
			oRm.writeEscaped(mOptions.text);
			oRm.write("</span>");
		};

		return SwitchRenderer;

	}, /* bExport= */ true);
}; // end of sap/m/SwitchRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TablePersoProvider') ) {
/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides TablePersoProvider
jQuery.sap.declare('sap.m.TablePersoProvider'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/m/TablePersoProvider",['jquery.sap.global', 'sap/ui/base/ManagedObject'],
	function(jQuery, ManagedObject) {
	"use strict";


	
	/**
	 * This is an abstract TablePersoProvider, describing the interface for a real
	 * TablePersoProvider.
	 *
	 * @public
	 *
	 * @class Table Personalization Provider
	 * @extends sap.ui.base.ManagedObject
	 * @abstract
	 * @author SAP
	 * @version 1.28.17
	 * @alias sap.m.TablePersoProvider
	 */
	var TablePersoProvider = ManagedObject.extend("sap.m.TablePersoProvider", /** @lends sap.m.TablePersoProvider */
	
	{
		constructor: function(sId, mSettings) {
	
			ManagedObject.apply(this, arguments);
	
		},
	
		metadata: {
			"abstract": true,
			library: "sap.m"
		}
	
	});
	
	
	/**
	 * Initializes the TablePersoProvider instance after creation.
	 *
	 * @protected
	 */
	TablePersoProvider.prototype.init = function() {
	
		jQuery.sap.log.warning("This is the abstract base class for a TablePersoProvider. Do not create instances of this class, but use a concrete sub class instead.");
		jQuery.sap.log.debug("TablePersoProvider init");
	
	};
	
	/**
	 * Retrieves the personalization bundle. 
	 * This must return a jQuery promise (see http://api.jquery.com/promise/)
	 * @public
	 */
	TablePersoProvider.prototype.getPersData = function() {
	
		jQuery.sap.log.debug("TablePersoProvider getPersData");
	
	};
	
	/**
	 * Stores the personalization bundle, overwriting any
	 * previous bundle completely
	 * This must return a jQuery promise (see http://api.jquery.com/promise/)
	 * @param {object} oBundle
	 * @public
	 */
	TablePersoProvider.prototype.setPersData = function(oBundle) {
	
		jQuery.sap.log.debug("TablePersoProvider setPersData");
	
	};
	
	/**
	 * Removes the personalization bundle
	 * This must return a jQuery promise (see http://api.jquery.com/promise/)
	 * @public
	 */
	TablePersoProvider.prototype.delPersData = function() {
	
		jQuery.sap.log.debug("TablePersoProvider delPersData");
	
	};
	
	/**
	 * Callback function which can be used to determine the title of a given column
	 * within the TablePersoDialog. As a default, the column header controls are
	 * asked for their 'text' or 'title' property. This works in most cases, for example
	 * if the header control is a sap.m.Label (has 'text' property) or a sap.m.ObjectListItem
	 * (has 'title' property). 
	 * 
	 * If the header control used in a column has neither 'text' nor 'title' property, or if you would like to 
	 * display a modified column name for a certain column, this callback function can be used.
	 * 
	 * If the callback delivers null for a column (which is the default implementation), the default
	 * texts described above are displayed for that column in the TablePersoDialog. 
	 * 
	 * In case neither the callback delivers null and neither 'text' nor ' title' property are at hand,
	 * the TablePersoDialog will display the column id and a warning message is logged.
	 * 
	 * @param {sap.m.Column} oColumn column whose caption shall be determined
	 * @public
	 */
	TablePersoProvider.prototype.getCaption = function(oColumn) {
		return null;
	};
	
	/**
	 * Callback function which can be used to determine the group of a given column
	 * within the TablePersoDialog. As a default, the columns are not assigned to a group. 
	 * 
	 * This information is used to group the columns within the TablePersoDialog if the TablePersoController's
	 * 'group' flag is set, otherwise, the groups are ignored. 
	 * 
	 * @param {sap.m.Column} oColumn column whose group shall be determined
	 * @public
	 */
	TablePersoProvider.prototype.getGroup = function(oColumn) {
		return null;
	};
	
	
	/**
	* Resets user’s personalization for a given table so that ‘getPersData’ will
	* deliver its initial state. If no table is specified, all personalizations
	* of the currently logged on user are reset.
	*
	* This must return a jQuery promise (see http://api.jquery.com/promise/)
	 * @public
	*/
	TablePersoProvider.prototype.resetPersData = function() {
	
		jQuery.sap.log.debug("TablePersoProvider resetPersData");
	
	};
	
	

	return TablePersoProvider;

}, /* bExport= */ true);

}; // end of sap/m/TablePersoProvider.js
if ( !jQuery.sap.isDeclared('sap.m.TableRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.TableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/TableRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './ListBaseRenderer'],
	function(jQuery, Renderer, ListBaseRenderer) {
	"use strict";


	/**
	 * List renderer.
	 * @namespace
	 *
	 * TableRenderer extends the ListBaseRenderer
	 */
	var TableRenderer = Renderer.extend(ListBaseRenderer);
	
	
	/**
	 * Renders the Header and/or Footer of the Table like List Control
	 *
	 * @param {sap.ui.core.RenderManager} rm RenderManager
	 * @param {sap.m.ListBase} oTable Table control
	 * @param {String} type Whether "Head" or "Foot"
	 */
	TableRenderer.renderColumns = function(rm, oTable, type) {
		var index = 0,
			hiddens = 0,
			hasPopin = false,
			hasFooter = false,
			mode = oTable.getMode(),
			iModeOrder = ListBaseRenderer.ModeOrder[mode],
			clsPrefix = "sapMListTbl",
			idPrefix = oTable.getId("tbl"),
			cellTag = (type == "Head") ? "th" : "td",
			cellRole = (type == "Head") ? "columnheader" : "gridcell",
			groupTag = "t" + type.toLowerCase(),
			aColumns = oTable.getColumns(),
			isHeaderHidden = (type == "Head") && aColumns.every(function(oColumn) {
				return	!oColumn.getHeader() ||
						!oColumn.getVisible() ||
						oColumn.isPopin() ||
						oColumn.isNeverVisible() ||
						oColumn.isHidden();
			}),
			hasOneHeader = (type == "Head") && aColumns.filter(function(oColumn) {
				return	oColumn.getVisible() &&
						!oColumn.isPopin() &&
						!oColumn.isNeverVisible() &&
						!oColumn.isHidden();
			}).length == 1,
			createBlankCell = function(cls, id, bAriaHidden) {
				rm.write("<");
				rm.write(cellTag);
				rm.writeAttribute("role", cellRole);
				bAriaHidden && rm.writeAttribute("aria-hidden", "true");
				id && rm.writeAttribute("id", idPrefix + id);
				rm.addClass(clsPrefix + cls);
				rm.writeClasses();
				rm.write("></");
				rm.write(cellTag);
				rm.write(">");
				index++;
			};
	
		rm.write("<" + groupTag + ">");
		rm.write("<tr");
		rm.writeAttribute("tabindex", -1);
		rm.writeAttribute("role", "rowheader");
		rm.writeAttribute("id", oTable.addNavSection(idPrefix + type + "er" ));
	
		if (isHeaderHidden) {
			rm.addClass("sapMListTblHeaderNone");
		} else {
			rm.addClass("sapMListTblRow sapMListTbl" + type + "er");
		}
	
		rm.writeClasses();
		rm.write(">");
	
		if (iModeOrder == -1) {
			if (mode == "MultiSelect" && type == "Head" && !isHeaderHidden) {
				rm.write("<th role='columnheader' class='" + clsPrefix + "SelCol'>");
				rm.write("<div class='sapMLIBSelectM'>");
				rm.renderControl(oTable._getSelectAllCheckbox());
				rm.write("</div></th>");
				index++;
			} else {
				createBlankCell("SelCol");
			}
		}
	
		aColumns.forEach(function(oColumn, order) {
			oColumn.setIndex(-1);
			oColumn.setInitialOrder(order);
		});
	
		oTable.getColumns(true).forEach(function(oColumn, order) {
			if (!oColumn.getVisible()) {
				return;
			}
			if (oColumn.isPopin()) {
				hasPopin = true;
				return;
			}
			if (oColumn.isNeverVisible()) {
				return;
			}
			if (oColumn.isHidden()) {
				hiddens++;
			}
	
			var control = oColumn["get" + type + "er"](),
				width = hasOneHeader ? "" : oColumn.getWidth(),
				cls = oColumn.getStyleClass(true),
				align = oColumn.getCssAlign();
	
			rm.write("<" + cellTag);
			cls && rm.addClass(cls);
			rm.addClass(clsPrefix + "Cell");
			rm.addClass(clsPrefix + type + "erCell");
			rm.writeAttribute("id", idPrefix + type + index);
			rm.writeAttribute("data-sap-width", oColumn.getWidth());
			rm.writeAttribute("role", cellRole);
			width && rm.addStyle("width", width);
			
			if (align) {
				rm.addStyle("text-align", align);
			}
			
			rm.writeClasses();
			rm.writeStyles();
			rm.write(">");
			if (control) {
				oColumn.applyAlignTo(control);
				rm.renderControl(control);
			}
			if (type == "Head" && !hasFooter) {
				hasFooter = !!oColumn.getFooter();
			}
			rm.write("</" + cellTag + ">");
			oColumn.setIndex(index++);
		});
	
		createBlankCell("NavCol", type + "Nav", !oTable._iItemNeedsColumn);
	
		if (iModeOrder == 1) {
			createBlankCell("SelCol");
		}
	
		rm.write("</tr></" + groupTag + ">");
	
		if (type == "Head") {
			oTable._hasPopin = hasPopin;
			oTable._colCount = index - hiddens;
			oTable._hasFooter = hasFooter;
			oTable._headerHidden = isHeaderHidden;
		}
	};
	
	
	/**
	 * add table container class name
	 */
	TableRenderer.renderContainerAttributes = function(rm, oControl) {
		rm.addClass("sapMListTblCnt");
	};
	
	/**
	 * render table tag and add required classes
	 */
	TableRenderer.renderListStartAttributes = function(rm, oControl) {
		rm.write("<table");
		rm.addClass("sapMListTbl");
		if (oControl.getFixedLayout() === false) {
			rm.addStyle("table-layout", "auto");
		}
		
		// make the type column visible if needed
		if (oControl._iItemNeedsColumn) {
			rm.addClass("sapMListTblHasNav");
		}
	};
	
	/**
	 * returns aria accessibility role
	 */
	TableRenderer.getAriaRole = function(oControl) {
		return "grid";
	};
	
	/**
	 * generate table columns
	 */
	TableRenderer.renderListHeadAttributes = function(rm, oControl) {
		this.renderColumns(rm, oControl, "Head");
		rm.write("<tbody");
		rm.writeAttribute("id", oControl.addNavSection(oControl.getId("tblBody")));
		rm.write(">");
	};
	
	/**
	 * render footer and finish rendering table
	 */
	TableRenderer.renderListEndAttributes = function(rm, oControl) {
		rm.write("</tbody>");	// items should be rendered before foot
		oControl._hasFooter && this.renderColumns(rm, oControl, "Foot");
		rm.write("</table>");
	};
	
	/**
	 * render no data
	 */
	TableRenderer.renderNoData = function(rm, oControl) {
		rm.write("<tr");
		rm.writeAttribute("role", "row");
		rm.writeAttribute("tabindex", "-1");
		rm.writeAttribute("id", oControl.getId("nodata"));
		rm.addClass("sapMLIB sapMListTblRow sapMLIBTypeInactive");
		if (!oControl._headerHidden || (!oControl.getHeaderText() && !oControl.getHeaderToolbar())) {
			rm.addClass("sapMLIBShowSeparator");
		}
		rm.writeClasses();
		rm.write(">");
		
		rm.write("<td");
		rm.writeAttribute("role", "gridcell");
		rm.writeAttribute("id", oControl.getId("nodata-text"));
		rm.writeAttribute("colspan", oControl.getColCount());
		rm.addClass("sapMListTblCell sapMListTblCellNoData");
		rm.writeClasses();
		rm.write(">");
		rm.writeEscaped(oControl.getNoDataText());
		rm.write("</td>");
		
		rm.write("</tr>");
	};

	return TableRenderer;

}, /* bExport= */ true);

}; // end of sap/m/TableRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TableSelectDialogRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.TableSelectDialogRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/TableSelectDialogRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * SelectDialog renderer.
	 * @namespace
	 */
	var TableSelectDialogRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	TableSelectDialogRenderer.render = function (oRm, oControl) {
	};

	return TableSelectDialogRenderer;

}, /* bExport= */ true);

}; // end of sap/m/TableSelectDialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TextAreaRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.TextAreaRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/TextAreaRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './InputBaseRenderer'],
	function(jQuery, Renderer, InputBaseRenderer) {
	"use strict";


	/**
	 * TextArea renderer.
	 * @namespace
	 */
	var TextAreaRenderer = {};
	
	
	/**
	 * Input renderer.
	 * @namespace
	 *
	 * TextAreaRenderer extends the TextAreaRenderer
	 */
	var TextAreaRenderer = Renderer.extend(InputBaseRenderer);
	
	// Adds control specific class
	TextAreaRenderer.addOuterClasses = function(oRm, oControl) {
		oRm.addClass("sapMTextArea");
	};
	
	// Add extra styles to Container
	TextAreaRenderer.addOuterStyles = function(oRm, oControl) {
		oControl.getHeight() && oRm.addStyle("height", oControl.getHeight());
	};
	
	// Write the opening tag name of the TextArea
	TextAreaRenderer.openInputTag = function(oRm, oControl) {
		oRm.write("<textarea");
	};
	
	// Write the closing tag name of the TextArea
	TextAreaRenderer.closeInputTag = function(oRm, oControl) {
		oRm.write("</textarea>");
	};
	
	// TextArea does not have value property as HTML element, so overwrite base method
	TextAreaRenderer.writeInnerValue = function() {
	};
	
	// Write the value of the TextArea
	TextAreaRenderer.writeInnerContent = function(oRm, oControl) {
		var sValue = oControl.getValue();
		sValue = jQuery.sap.encodeHTML(sValue);
		
		// Convert the new line HTML entity rather than displaying it as a text. 
		//Normalize the /n and /r to /r/n - Carriage Return and Line Feed
		sValue = sValue.replace(/&#xd;&#xa;|&#xd;|&#xa;/g, "&#13;&#10;");
		oRm.write(sValue);
	};
	
	// Add extra classes for TextArea element
	TextAreaRenderer.addInnerClasses = function(oRm, oControl) {
		oRm.addClass("sapMTextAreaInner");
	};
	
	// Write accessibility attributes
	TextAreaRenderer.writeAccessibilityState = function(oRm, oControl) {
		InputBaseRenderer.writeAccessibilityState.apply(this, arguments);
		oRm.writeAccessibilityState(oControl, {
			role: "textbox",
			multiline: true
		});
	}; 
	
	// Add extra attributes to TextArea
	TextAreaRenderer.writeInnerAttributes = function(oRm, oControl) {
		if (oControl.getWrapping() && oControl.getWrapping() != "None") {
			oRm.writeAttribute("wrap", oControl.getWrapping());
		}
		oRm.writeAttribute("rows", oControl.getRows());
		oRm.writeAttribute("cols", oControl.getCols());
	};

	return TextAreaRenderer;

}, /* bExport= */ true);

}; // end of sap/m/TextAreaRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TextRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.m.Text
jQuery.sap.declare('sap.m.TextRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/TextRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
	"use strict";


	/**
	 * Text renderer
	 * @author SAP SE
	 * @namespace
	 */
	var TextRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.m.Text} oText An object representation of the control that should be rendered.
	 */
	TextRenderer.render = function(oRm, oText) {
		// get control values
		var sWidth = oText.getWidth(),
			sText = oText.getText(true),
			sTextDir = oText.getTextDirection(),
			sTooltip = oText.getTooltip_AsString(),
			nMaxLines = oText.getMaxLines(),
			bWrapping = oText.getWrapping(),
			sTextAlign = oText.getTextAlign();

		// start writing html
		oRm.write("<span");
		oRm.writeControlData(oText);
		oRm.addClass("sapMText");
		oRm.addClass("sapUiSelectable");

		// set classes for wrapping
		if (!bWrapping || nMaxLines == 1) {
			oRm.addClass("sapMTextNoWrap");
		} else if (bWrapping) {
			// no space text must break
			if (sText && sText.length > 0 && !/\s/.test(sText)) {
				oRm.addClass("sapMTextBreakWord");
			}
		}

		// write style and attributes
		sWidth ? oRm.addStyle("width", sWidth) : oRm.addClass("sapMTextMaxWidth");
		if (sTextDir !== sap.ui.core.TextDirection.Inherit){
			oRm.writeAttribute("dir", sTextDir.toLowerCase());
		}
		sTooltip && oRm.writeAttributeEscaped("title", sTooltip);
		if (sTextAlign) {
			sTextAlign = Renderer.getTextAlign(sTextAlign, sTextDir);
			if (sTextAlign) {
				oRm.addStyle("text-align", sTextAlign);
			}
		}

		// finish writing html
		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write(">");

		// handle max lines
		if (oText.hasMaxLines()) {
			this.renderMaxLines(oRm, oText);
		} else {
			this.renderText(oRm, oText);
		}

		// finalize
		oRm.write("</span>");
	};

	/**
	 * Renders the max lines inner wrapper
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.m.Text} oText An object representation of the control that should be rendered.
	 */
	TextRenderer.renderMaxLines = function(oRm, oText) {
		oRm.write("<div");
		oRm.writeAttribute("id", oText.getId() + "-inner");
		oRm.addClass("sapMTextMaxLine");

		// check native line clamp support
		if (oText.canUseNativeLineClamp()) {
			oRm.addClass("sapMTextLineClamp");
			oRm.addStyle("-webkit-line-clamp", oText.getMaxLines());
		}

		oRm.writeClasses();
		oRm.writeStyles();
		oRm.write(">");
		this.renderText(oRm, oText);
		oRm.write("</div>");
	};

	/**
	 * Renders the normalized text property.
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.m.Text} oText An object representation of the control that should be rendered.
	 */
	TextRenderer.renderText = function(oRm, oText) {
		var sText = oText.getText(true);
		oRm.writeEscaped(sText);
	};

	return TextRenderer;

}, /* bExport= */ true);

}; // end of sap/m/TextRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TileContainerRenderer') ) {

/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.TileContainerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/TileContainerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Bar renderer.
	 * @namespace
	 */
	var TileContainerRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	TileContainerRenderer.render = function(rm, oControl) {
		var id =  oControl.getId();

		rm.write("<div tabindex=\"-1\"");
		rm.writeControlData(oControl);
		rm.addStyle("height",oControl.getHeight());
		rm.addStyle("width",oControl.getWidth());
		rm.writeStyles();
		rm.addClass("sapMTC");
		rm.writeClasses();

		/* WAI ARIA region */
		rm.writeAccessibilityState(oControl, {
			role: "listbox",
			multiSelectable: false,
			activeDescendant: oControl.getTiles().length > 0 ? oControl.getTiles()[0].getId() : ""
		});

		rm.write(" >");
		rm.write("<div id=\"" + id + "-scrl\" class=\"sapMTCScrl\" style=\"height:0px;");
		if (!oControl.bRtl) {
			rm.write(" overflow: hidden;");
		}
		rm.write("\">");
		rm.write("<div id=\"" + id + "-blind\" class=\"sapMTCBlind\"></div>");
		rm.write("<div id=\"" + id + "-cnt\" class=\"sapMTCCnt sapMTCAnim\" style=\"height:0px; width:0px;\" role=\"group\">");
		var aTiles = oControl.getTiles();
		for (var i = 0;i < aTiles.length;i++) {
			aTiles[i]._setVisible(false);
			rm.renderControl(aTiles[i]);
		}
		rm.write("</div>");
		rm.write("</div>");
		rm.write("<div id=\"" + id + "-pager\" class=\"sapMTCPager\">");
		rm.write("</div>");
		rm.write("<div id=\"" + id + "-leftedge\" class=\"sapMTCEdgeLeft\"></div>");
		rm.write("<div id=\"" + id + "-rightedge\" class=\"sapMTCEdgeRight\"></div>");
		rm.write("<div id=\"" + id + "-leftscroller\" class=\"sapMTCScroller sapMTCLeft\" tabindex=\"-1\"><div class=\"sapMTCInner\" ></div></div>");
		rm.write("<div id=\"" + id + "-rightscroller\" class=\"sapMTCScroller sapMTCRight\" tabindex=\"-1\"><div class=\"sapMTCInner\" ></div></div>");
		rm.write("</div>");
	};

	return TileContainerRenderer;

}, /* bExport= */ true);

}; // end of sap/m/TileContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TileRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.m.Text
jQuery.sap.declare('sap.m.TileRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/TileRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
	"use strict";


	/**
	 * Text renderer
	 * @author SAP SE
	 * @namespace
	 */
	var TileRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	TileRenderer.render = function(rm, oControl) {
		rm.write("<div tabindex=\"0\"");
		rm.writeControlData(oControl);
		rm.addClass("sapMTile");
		rm.addClass("sapMPointer");
		rm.writeClasses();
		if (oControl._invisible) {
			rm.addStyle("visibility", "hidden");
			rm.writeStyles();
		}
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}

		/* WAI ARIA if in TileContainer context */
		if (oControl.getParent() instanceof sap.m.TileContainer) {
			rm.writeAccessibilityState(oControl, {
				role: "option",
				posinset: oControl._getTileIndex(),
				setsize: oControl._getTilesCount()
			});
		}

		rm.write(">");
		if (oControl.getRemovable()) {
			rm.write("<div id=\"" + oControl.getId() + "-remove\" class=\"sapMTCRemove\"></div>");
		} else {
			rm.write("<div id=\"" + oControl.getId() + "-remove\" class=\"sapMTCNoRemove\"></div>");
		}
		rm.write("<div class=\"sapMTileContent\">");
		this._renderContent(rm,oControl);
		rm.write("</div></div>");
	};

	TileRenderer._renderContent = function(rm, oControl) {};

	return TileRenderer;

}, /* bExport= */ true);

}; // end of sap/m/TileRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TitleRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.m.Title
jQuery.sap.declare('sap.m.TitleRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/m/TitleRenderer",['jquery.sap.global', 'sap/ui/Device'],
	function(jQuery, Device) {
	"use strict";


	/**
	 * @class Title renderer.
	 * @static
	 */
	var TitleRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oShell an object representation of the control that should be rendered
	 */
	TitleRenderer.render = function(oRm, oTitle){
		var oAssoTitle = oTitle._getTitle(),
			sLevel = (oAssoTitle ? oAssoTitle.getLevel() : oTitle.getLevel()) || sap.ui.core.TitleLevel.Auto,
			bAutoLevel = sLevel == sap.ui.core.TitleLevel.Auto,
			sTag = bAutoLevel ? "div" : sLevel;
		
		oRm.write("<", sTag);
		oRm.writeControlData(oTitle);
		oRm.addClass("sapMTitle");
		oRm.addClass("sapMTitleStyle" + (oTitle.getTitleStyle() || sap.ui.core.TitleLevel.Auto));
		oRm.addClass("sapMTitleNoWrap");
		oRm.addClass("sapUiSelectable");
		
		var sWidth = oTitle.getWidth();
		if (!sWidth) {
			oRm.addClass("sapMTitleMaxWidth");
		} else {
			oRm.addStyle("width", sWidth);
		}
		
		var sTextAlign = oTitle.getTextAlign();
		if (sTextAlign && sTextAlign != sap.ui.core.TextAlign.Initial) {
			oRm.addClass("sapMTitleAlign" + sTextAlign);
		}
		
		if (oTitle.getParent() instanceof sap.m.Toolbar) {
			oRm.addClass("sapMTitleTB");
		}
		
		var sTooltip = oAssoTitle ? oAssoTitle.getTooltip_AsString() : oTitle.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}
		
		if (bAutoLevel) {
			oRm.writeAttribute("role", "heading");
		}
		
		oRm.writeClasses();
		oRm.writeStyles();

		oRm.write("><span>");
		oRm.writeEscaped(oAssoTitle ? oAssoTitle.getText() : oTitle.getText());
		oRm.write("</span></", sTag, ">");
	};
	
	return TitleRenderer;

}, /* bExport= */ true);
}; // end of sap/m/TitleRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ToggleButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.commons.Togglebutton
jQuery.sap.declare('sap.m.ToggleButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ToggleButtonRenderer",['jquery.sap.global', './ButtonRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ButtonRenderer, Renderer) {
	"use strict";


	/**
	 * ToggleButton renderer.
	 * @namespace
	 */

	var ToggleButtonRenderer = Renderer.extend(ButtonRenderer);

	/**
	 * Callback for specific rendering of accessibility attributes.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager currently rendering this control
	 * @param {sap.m.ToggleButton}
	 *            oToggleButton the ToggleButton that should be rendered
	 * @param {object} mAccProps Accessibillity properties
	 * @private
	 */
	ToggleButtonRenderer.renderAccessibilityAttributes = function(oRm, oToggleButton, mAccProps) {

		mAccProps["pressed"] = oToggleButton.getPressed();

	};

	/**
	 * Callback for specific rendering of inner button attributes.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager currently rendering this control
	 * @param {sap.m.ToggleButton}
	 *            oToggleButton the ToggleButton that should be rendered
	 * @private
	 */
	ToggleButtonRenderer.renderButtonAttributes = function(oRm, oToggleButton) {
		if (oToggleButton.getPressed() && !oToggleButton._isUnstyled()) {
			oRm.addClass("sapMToggleBtnPressed");
		}
	};

	return ToggleButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ToggleButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TokenRenderer') ) {
/*!

* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.

*/
jQuery.sap.declare('sap.m.TokenRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/TokenRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Token renderer. 
	 * @namespace
	 */
	var TokenRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	TokenRenderer.render = function(oRm, oControl){
		// write the HTML into the render manager
		oRm.write("<div tabindex=\"-1\"");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMToken");
		oRm.writeClasses();
		// add tooltip if available
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}
		oRm.write(">");
	
		TokenRenderer._renderInnerControl(oRm, oControl);
		
		if (oControl.getEditable()) {
			oRm.renderControl(oControl._deleteIcon);
		}
		
		oRm.write("</div>");
	};
	
	/**
	 * Renders the inner HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	TokenRenderer._renderInnerControl = function(oRm, oControl){
		var sTextDir = oControl.getTextDirection();
		
		oRm.write("<span");
		oRm.addClass("sapMTokenText");
		oRm.writeClasses();
		// set text direction
		if (sTextDir !== sap.ui.core.TextDirection.Inherit) {
			oRm.writeAttribute("dir", sTextDir.toLowerCase());
		}
		oRm.write(">");
		
		var title = oControl.getText();
		if (title) {
			oRm.writeEscaped(title);
		}
		oRm.write("</span>");
	};
	

	return TokenRenderer;

}, /* bExport= */ true);

}; // end of sap/m/TokenRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TokenizerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.TokenizerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/TokenizerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Tokenizer renderer. 
	 * @namespace
	 */
	var TokenizerRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	TokenizerRenderer.render = function(oRm, oControl){
		//write the HTML into the render manager
		oRm.write("<div tabindex=\"-1\"");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMTokenizer");
		oRm.writeClasses();
		oRm.write(">"); // div element
	
		var sClass = "class=\"sapMTokenizerScrollContainer\">";
		var sSpace = " ";
			
		var sIdScrollContainer = "id=" + oControl.getId() + "-scrollContainer";
		oRm.write("<div" + sSpace + sIdScrollContainer + sSpace + sClass);
		
		TokenizerRenderer._renderTokens(oRm, oControl);
		 
		oRm.write("</div>");
		oRm.write("</div>");
	};
	
	/**
	 * renders the tokens
	 * 
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	TokenizerRenderer._renderTokens = function(oRm, oControl){
		var i, length, tokens;
		tokens = oControl.getTokens();
		length = tokens.length;
		for (i = 0; i < length; i++) {
			oRm.renderControl(tokens[i]);
		}
	};

	return TokenizerRenderer;

}, /* bExport= */ true);

}; // end of sap/m/TokenizerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ToolbarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ToolbarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ToolbarRenderer",['jquery.sap.global', './BarInPageEnabler'],
	function(jQuery, BarInPageEnabler) {
	"use strict";


	/**
	 * Toolbar renderer.
	 * @namespace
	 */
	var ToolbarRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @protected
	 * @param {sap.ui.core.RenderManager} oRM the RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered.
	 */
	ToolbarRenderer.render = BarInPageEnabler.prototype.render;

	/**
	 * Add classes attributes and styles to the root tag
	 *
	 * @param {sap.ui.core.RenderManager} oRM the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ToolbarRenderer.decorateRootElement = function (rm, oToolbar) {
		rm.addClass("sapMTB");

		// ARIA
		var aContent = oToolbar.getContent();
		if (oToolbar.getActive() && (!aContent || aContent.length === 0)) {
			rm.writeAccessibilityState(oToolbar, {
				role: "button"
			});
		} else {
			rm.writeAccessibilityState(oToolbar, {
				role: "toolbar"
			});
		}


		if (!sap.m.Toolbar.hasFlexBoxSupport) {
			rm.addClass("sapMTBNoFlex");
		} else if (!sap.m.Toolbar.hasNewFlexBoxSupport) {
			rm.addClass("sapMTBOldFlex");
		} else {
			rm.addClass("sapMTBNewFlex");
		}

		if (oToolbar.getActive()) {
			rm.addClass("sapMTBActive");
			rm.writeAttribute("tabindex", "0");
		} else {
			rm.addClass("sapMTBInactive");
		}

		rm.addClass("sapMTB-" + oToolbar.getActiveDesign() + "-CTX");

		var sWidth = oToolbar.getWidth();
		var sHeight = oToolbar.getHeight();
		sWidth && rm.addStyle("width", sWidth);
		sHeight && rm.addStyle("height", sHeight);
	};

	ToolbarRenderer.renderBarContent = function(rm, oToolbar) {
		oToolbar.getContent().forEach(function(oControl) {
			sap.m.BarInPageEnabler.addChildClassTo(oControl, oToolbar);
			rm.renderControl(oControl);
		});
	};

	/**
	 * Determines, if the IBarContext classes should be added to the control
	 * @private
	 */
	ToolbarRenderer.shouldAddIBarContext = function (oControl) {
		return false;
	};



	return ToolbarRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ToolbarRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ToolbarSeparatorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ToolbarSeparatorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ToolbarSeparatorRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
	"use strict";


	/**
	 * ToolbarSeparator renderer.
	 * @namespace
	 */
	var ToolbarSeparatorRenderer = {};
	
	ToolbarSeparatorRenderer.render = function(rm, oControl) {
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapMTBSeparator");

		//ARIA
		rm.writeAccessibilityState(oControl, {
			role: "separator"
		});

		rm.writeClasses();
		rm.write("></div>");
	};

	return ToolbarSeparatorRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ToolbarSeparatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ToolbarSpacerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ToolbarSpacerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ToolbarSpacerRenderer",['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
	"use strict";


	/**
	 * ToolbarSpacer renderer.
	 * @namespace
	 */
	var ToolbarSpacerRenderer = {};
	
	ToolbarSpacerRenderer.render = function(rm, oControl) {
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapMTBSpacer");
	
		var sWidth = oControl.getWidth();
		if (sWidth) {
			rm.addStyle("width", sWidth);
		} else {
			rm.addClass(sap.m.ToolbarSpacer.flexClass);
		}
	
		rm.writeStyles();
		rm.writeClasses();
		rm.write("></div>");
	};

	return ToolbarSpacerRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ToolbarSpacerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.UploadCollectionRenderer') ) {
/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
jQuery.sap.declare('sap.m.UploadCollectionRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/UploadCollectionRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	* UploadCollection renderer.
	* @namespace
	*/
	var UploadCollectionRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	UploadCollectionRenderer.render = function(oRm, oControl) {
	
		// write the HTML into the render manager
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMUC");
		oRm.writeClasses();
		oRm.write(">");
		oRm.renderControl(oControl._oList);
		oRm.write("</div>");
	};

	return UploadCollectionRenderer;

}, /* bExport= */ true);

}; // end of sap/m/UploadCollectionRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ViewSettingsDialogRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.ViewSettingsDialogRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ViewSettingsDialogRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ViewSettingsDialogRenderer renderer.
	 * @namespace
	 */
	var ViewSettingsDialogRenderer = {
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ViewSettingsDialogRenderer.render = function (oRm, oControl) {
	};

	return ViewSettingsDialogRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ViewSettingsDialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ios7') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/*global window, document *///declare unusual global vars for JSLint/SAPUI5 validation

jQuery.sap.declare('sap.m.ios7'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/ios7",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	
		sap.ui.base.EventProvider.extend("sap.m._Ios7", {
			/**
			 * IOS 7 behaves strange if the keyboard is open and you do an orientation change:
			 * There will be a black space below the page and it will scroll away from the top in this case.
			 * Thats why we scroll to the top on orientation change.
			 * We also need to catch blur since if you do orientation change with keyboard open, close the Keyboard, Open it on another input, 
			 * the black box will appear again. Since closing the keyboard will fire blur, we attach on this one.
			 * @private
			 */
			constructor : function() {
				var bIsIOS7Safari = sap.ui.Device.os.ios && sap.ui.Device.os.version >= 7 && sap.ui.Device.os.version < 8 && sap.ui.Device.browser.name === "sf";
	
				//call the base to properly init the event registry
				sap.ui.base.EventProvider.apply(this);
	
				if (!bIsIOS7Safari) {
					return;
				}
	
				this._bIntervallAttached = false;
				this._bInputIsOpen = false;
				this._bNavigationBarEventFired = false;
	
				var bIsLandscape = window.orientation === 90 || window.orientation === -90;
				if (bIsLandscape) {
					this._attachNavigationBarPolling();
				}
	
				sap.ui.Device.orientation.attachHandler(this._onOrientationChange, this);
	
				this._onFocusin =  jQuery.proxy(this._onFocusin, this);
				document.addEventListener("focusin", this._onFocusin , true);
	
				this._onFocusout = jQuery.proxy(this._onFocusout, this);
				//attach this event in the capturing phase, so noone can stop propagation
				document.addEventListener("focusout", this._onFocusout, true);
			}
		});
	
		/*****************************
		internals
		*****************************/
		/**
		 * gets the height of the navigation bar in px. Only returns a number < 0 in landscape mode - will return 0 for portrait mode or if no navigation bar is shown.
		 * @internal
		 * @returns {int} the height of the navigation bar
		 */
		sap.m._Ios7.prototype.getNavigationBarHeight = function () {
			if (!this._bNavigationBarEventFired) {
				return 0;
			}
			return this._iNavigationBarHeight;
		};
	
		/*****************************
		privates
		*****************************/
	
		sap.m._Ios7.prototype._attachNavigationBarPolling = function () {
			if (!sap.ui.Device.system.phone || this._bIntervallAttached) {
				return;
			}
	
			sap.ui.getCore().attachIntervalTimer(this._detectNavigationBar, this);
			this._bIntervallAttached = true;
		};
	
		sap.m._Ios7.prototype._detachNavigationBarPolling = function () {
			if (!sap.ui.Device.system.phone || !this._bIntervallAttached) {
				return;
			}
	
			sap.ui.getCore().detachIntervalTimer(this._detectNavigationBar, this);
			this._bIntervallAttached = false;
		};
	
		//We cannot turn this off in landscape mode, since the inner and outer height might be different when the soft-keyboard pops up.
		//So we need to do a lot of unnecessary scrolls, since keyboard and navigation bar cannot be distinguished.
		sap.m._Ios7.prototype._detectNavigationBar = function () {
			var iHeightDifference = window.outerHeight - window.innerHeight;
	
			if (iHeightDifference === 0 || this._bInputIsOpen || this._bNavigationBarEventFired) {
				this._iPreviousHeight = null;
				return;
			}
	
			if (this._iPreviousHeight === window.innerHeight) {
				window.scrollTo(0,0);
				var iNewWindowHeightDifference = window.outerHeight - window.innerHeight;
				if (iHeightDifference !== iNewWindowHeightDifference) {
					return;
				}
	
				this._iNavigationBarHeight = iHeightDifference;
				this._bNavigationBarEventFired = true;
				this.fireEvent("navigationBarShownInLandscape", { barHeight : iHeightDifference });
				this._detachNavigationBarPolling();
				this._iPreviousHeight = null;
			} else {
				this._iPreviousHeight = window.innerHeight;
			}
		};
	
		sap.m._Ios7.prototype.destroy = function() {
			sap.ui.base.EventProvider.prototype.destroy.apply(this, arguments);
	
			document.removeEventListener("focusin", this._onFocusin , true);
			document.removeEventListener("focusout", this._onFocusout, true);
		};
		/*****************************
		window / document event handling
		*****************************/
	
		/**
		 * @param oEvent the native focusin event
		 * @private
		 */
		sap.m._Ios7.prototype._onFocusin = function (oEvent) {
			var sTagName = oEvent.target.tagName;
	
			if (!sap.m._Ios7._rTagRegex.test(sTagName)) {
				return;
			}
	
			//we have to disable polling while the keyboard is open since scrollTop(0,0) will scroll the input out of the users view
			this._inputTarget = oEvent.target;
			this._detachNavigationBarPolling();
			this._bInputIsOpen = true;
			this.fireEvent("inputOpened");
		};
	
		sap.m._Ios7._rTagRegex = /INPUT|TEXTAREA|SELECT/;
	
		/**
		 * @param oEvent the native focusout event
		 * @private
		 */
		sap.m._Ios7.prototype._onFocusout = function (oEvent) {
			var sTagName = oEvent.srcElement.tagName,
				oRelated = oEvent.relatedTarget,
				sRelatedTag = (oRelated && (oRelated.getAttribute("readonly") === null) && (oRelated.getAttribute("disabled") === null)) ? oRelated.tagName : "";
	
			//only handle the focusout for elements that can bring up a soft-keyboard
			//there are a lot of input types that might not bring up the soft-keyboard - checking for them might be a bit too much
			if (sap.m._Ios7._rTagRegex.test(sTagName) && !sap.m._Ios7._rTagRegex.test(sRelatedTag)) {
				window.scrollTo(0,0);
	
				//Attach the polling again, since it was disabled in the focus in. But only do it in landscape.
				if (window.orientation === 90 || window.orientation === -90) {
					this._attachNavigationBarPolling();
				}
	
				this._bInputIsOpen = false;
				this.fireEvent("inputClosed");
			}
		};
	
		/**
		 * handles the orientation change
		 * @private
		 */
		sap.m._Ios7.prototype._onOrientationChange = function (oEvent) {
			var bIsLandscape = oEvent.landscape;
	
			window.scrollTo(0,0);
	
			this._bNavigationBarEventFired = false;
	
			//The page gets messed up if the softkeyboard is opened
			if (this._bInputIsOpen && this._inputTarget && this._inputTarget.blur) {
				this._inputTarget.blur();
			} else if (bIsLandscape) {
				this._attachNavigationBarPolling();
				//in landscape mode the navigation bar is visible anyways - disable the polling
			} else if (!bIsLandscape) {
				this._detachNavigationBarPolling();
			}
		};
	
		//expose the singleton
		var ios7 = new sap.m._Ios7();
	

	return ios7;

}, /* bExport= */ true);

}; // end of sap/m/ios7.js
if ( !jQuery.sap.isDeclared('sap.m.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.m.
 */
jQuery.sap.declare('sap.m.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.mobile'); // unlisted dependency retained
sap.ui.define("sap/m/library",['jquery.sap.global', 'sap/ui/Device',
	'sap/ui/core/library', // library dependency
	'jquery.sap.mobile', // referenced here in case the Core decides to throw it out - shall always be available when using the mobile lib.
	'./Support'], // referenced here to enable the Support feature
	function(jQuery, Device) {

	"use strict";


	/**
	 * SAPUI5 library with controls specialized for mobile devices.
	 *
	 * @namespace
	 * @name sap.m
	 * @author SAP SE
	 * @version 1.28.17
	 * @public
	 */

	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.m",
		version: "1.28.17",
		dependencies : ["sap.ui.core"],
		types: [
			"sap.m.BackgroundDesign",
			"sap.m.BarDesign",
			"sap.m.ButtonType",
			"sap.m.DateTimeInputType",
			"sap.m.DialogType",
			"sap.m.FacetFilterListDataType",
			"sap.m.FacetFilterType",
			"sap.m.FlexAlignItems",
			"sap.m.FlexAlignSelf",
			"sap.m.FlexDirection",
			"sap.m.FlexJustifyContent",
			"sap.m.FlexRendertype",
			"sap.m.HeaderLevel",
			"sap.m.IBarHTMLTag",
			"sap.m.IconTabFilterDesign",
			"sap.m.InputType",
			"sap.m.LabelDesign",
			"sap.m.ListHeaderDesign",
			"sap.m.ListMode",
			"sap.m.ListSeparators",
			"sap.m.ListType",
			"sap.m.P13nPanelType",
			"sap.m.PageBackgroundDesign",
			"sap.m.PlacementType",
			"sap.m.PopinDisplay",
			"sap.m.QuickViewGroupElementType",
			"sap.m.RatingIndicatorVisualMode",
			"sap.m.ScreenSize",
			"sap.m.SelectType",
			"sap.m.SplitAppMode",
			"sap.m.StandardTileType",
			"sap.m.SwipeDirection",
			"sap.m.SwitchType",
			"sap.m.ToolbarDesign",
			"sap.m.VerticalPlacementType"
		],
		interfaces: [
			"sap.m.IBar",
			"sap.m.IconTab",
			"sap.m.ObjectHeaderContainer"
		],
		controls: [
			"sap.m.ActionListItem",
			"sap.m.ActionSelect",
			"sap.m.ActionSheet",
			"sap.m.App",
			"sap.m.Bar",
			"sap.m.BusyDialog",
			"sap.m.BusyIndicator",
			"sap.m.Button",
			"sap.m.Carousel",
			"sap.m.CheckBox",
			"sap.m.ColumnListItem",
			"sap.m.ComboBox",
			"sap.m.ComboBoxBase",
			"sap.m.CustomListItem",
			"sap.m.CustomTile",
			"sap.m.DatePicker",
			"sap.m.DateRangeSelection",
			"sap.m.DateTimeInput",
			"sap.m.Dialog",
			"sap.m.DisplayListItem",
			"sap.m.FacetFilter",
			"sap.m.FacetFilterItem",
			"sap.m.FacetFilterList",
			"sap.m.FeedInput",
			"sap.m.FeedListItem",
			"sap.m.FlexBox",
			"sap.m.GroupHeaderListItem",
			"sap.m.GrowingList",
			"sap.m.HBox",
			"sap.m.IconTabBar",
			"sap.m.IconTabHeader",
			"sap.m.Image",
			"sap.m.Input",
			"sap.m.InputBase",
			"sap.m.InputListItem",
			"sap.m.Label",
			"sap.m.Link",
			"sap.m.List",
			"sap.m.ListBase",
			"sap.m.ListItemBase",
			"sap.m.MessagePage",
			"sap.m.MessagePopover",
			"sap.m.MultiComboBox",
			"sap.m.MultiInput",
			"sap.m.NavContainer",
			"sap.m.ObjectAttribute",
			"sap.m.ObjectHeader",
			"sap.m.ObjectIdentifier",
			"sap.m.ObjectListItem",
			"sap.m.ObjectNumber",
			"sap.m.ObjectStatus",
			"sap.m.OverflowToolbar",
			"sap.m.OverflowToolbarButton",
			"sap.m.P13nColumnsItem",
			"sap.m.P13nColumnsPanel",
			"sap.m.P13nConditionPanel",
			"sap.m.P13nDialog",
			"sap.m.P13nFilterPanel",
			"sap.m.P13nPanel",
			"sap.m.P13nSortPanel",
			"sap.m.Page",
			"sap.m.Panel",
			"sap.m.Popover",
			"sap.m.ProgressIndicator",
			"sap.m.PullToRefresh",
			"sap.m.QuickView",
			"sap.m.QuickViewPage",
			"sap.m.QuickViewGroup",
			"sap.m.QuickViewGroupElement",
			"sap.m.RadioButton",
			"sap.m.RadioButtonGroup",
			"sap.m.RatingIndicator",
			"sap.m.ResponsivePopover",
			"sap.m.ScrollContainer",
			"sap.m.SearchField",
			"sap.m.SegmentedButton",
			"sap.m.Select",
			"sap.m.SelectDialog",
			"sap.m.SelectList",
			"sap.m.Shell",
			"sap.m.Slider",
			"sap.m.SplitApp",
			"sap.m.SplitContainer",
			"sap.m.StandardListItem",
			"sap.m.StandardTile",
			"sap.m.Switch",
			"sap.m.Table",
			"sap.m.TableSelectDialog",
			"sap.m.Text",
			"sap.m.TextArea",
			"sap.m.Tile",
			"sap.m.TileContainer",
			"sap.m.Title",
			"sap.m.ToggleButton",
			"sap.m.Token",
			"sap.m.Tokenizer",
			"sap.m.Toolbar",
			"sap.m.ToolbarSpacer",
			"sap.m.ToolbarSeparator",
			"sap.m.UploadCollection",
			"sap.m.VBox",
			"sap.m.ViewSettingsDialog"
		],
		elements: [
			"sap.m.Column",
			"sap.m.FlexItemData",
			"sap.m.IconTabFilter",
			"sap.m.IconTabSeparator",
			"sap.m.OverflowToolbarLayoutData",
			"sap.m.MessagePopoverItem",
			"sap.m.P13nFilterItem",
			"sap.m.P13nItem",
			"sap.m.P13nSortItem",
			"sap.m.SegmentedButtonItem",
			"sap.m.ToolbarLayoutData",
			"sap.m.UploadCollectionItem",
			"sap.m.UploadCollectionParameter",
			"sap.m.ViewSettingsCustomItem",
			"sap.m.ViewSettingsFilterItem",
			"sap.m.ViewSettingsItem"
		]
	});


	/**
	 * Available Background Design.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.BackgroundDesign = {

		/**
		 * A solid background color dependent on the theme.
		 * @public
		 */
		Solid : "Solid",

		/**
		 * Transparent background.
		 * @public
		 */
		Transparent : "Transparent",

		/**
		 * A translucent background depending on the opacity value of the theme.
		 * @public
		 */
		Translucent : "Translucent"

	};


	/**
	 * Types of the Bar design
	 *
	 * @enum {string}
	 * @public
	 * @since 1.20
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.BarDesign = {

		/**
		 * The Bar can be inserted into other controls and if the design is "Auto" then it inherits the design from parent control.
		 * @public
		 */
		Auto : "Auto",

		/**
		 * The bar will be styled like a header of the page.
		 * @public
		 */
		Header : "Header",

		/**
		 * The bar will be styled like a subheader of the page.
		 * @public
		 */
		SubHeader : "SubHeader",

		/**
		 * The bar will be styled like a footer of the page.
		 * @public
		 */
		Footer : "Footer"

	};


	/**
	 * Different types for a button (predefined types)
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.ButtonType = {

		/**
		 * default type (no special styling)
		 * @public
		 */
		Default : "Default",

		/**
		 * back type (back navigation button for header)
		 * @public
		 */
		Back : "Back",

		/**
		 * accept type (blue button)
		 * @public
		 */
		Accept : "Accept",

		/**
		 * reject style (red button)
		 * @public
		 */
		Reject : "Reject",

		/**
		 * transparent type
		 * @public
		 */
		Transparent : "Transparent",

		/**
		 * up type (up navigation button for header)
		 * @public
		 */
		Up : "Up",

		/**
		 * Unstyled type (no styling)
		 * @public
		 */
		Unstyled : "Unstyled",

		/**
		 * emphasized type
		 * @public
		 */
		Emphasized : "Emphasized"

	};


	/**
	 * A subset of DateTimeInput types that fit to a simple API returning one string.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.DateTimeInputType = {

		/**
		 * An input control for specifying a date value. The user can select a month, day of the month, and year.
		 * @public
		 * @deprecated Since version 1.22.
		 * Instead, use dedicated sap.m.DatePicker control.
		 */
		Date : "Date",

		/**
		 * An input control for specifying a date and time value. The user can select a month, day of the month, year, and time of day.
		 * @public
		 */
		DateTime : "DateTime",

		/**
		 * An input control for specifying a time value. The user can select the hour, minute, and optionally AM or PM.
		 * @public
		 */
		Time : "Time"

	};


	/**
	 * Enum for the type of sap.m.Dialog control.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.DialogType = {

		/**
		 * This is the default value for Dialog type. Stardard dialog in iOS has a header on the top and the left, right buttons are put inside the header. In android, the left, right buttons are put to the bottom of the Dialog.
		 * @public
		 */
		Standard : "Standard",

		/**
		 * Dialog with type Message looks the same as the Stardard Dialog in Android. And it puts the left, right buttons to the bottom of the Dialog in iOS.
		 * @public
		 */
		Message : "Message"

	};


	/**
	 * FacetFilterList data types.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.FacetFilterListDataType = {

		/**
		 * An input control for specifying a date value. The user can select a month, day of the month, and year.
		 * @public
		 */
		Date : "Date",

		/**
		 * An input control for specifying a date and time value. The user can select a month, day of the month, year, and time of day.
		 * @public
		 */
		DateTime : "DateTime",

		/**
		 * An input control for specifying a time value. The user can select the hour, minute, and optionally AM or PM.
		 * @public
		 */
		Time : "Time",

		/**
		 * >An input control for specifying a Integer value
		 * @public
		 */
		Integer : "Integer",

		/**
		 * >An input control for specifying a Float value
		 * @public
		 */
		Float : "Float",

		/**
		 * >An input control for specifying a String value
		 * @public
		 */
		String : "String",

		/**
		 * >An input control for specifying a Boolean value
		 * @public
		 */
		Boolean : "Boolean"

	};


	/**
	 * Used by the FacetFilter control to adapt its design according to type.
	 *
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.FacetFilterType = {

		/**
		 * Forces FacetFilter to display facet lists as a row of buttons, one button per facet. The FacetFilter will automatically adapt to the Light type when it detects smart phone sized displays.
		 * @public
		 */
		Simple : "Simple",

		/**
		 * Forces FacetFilter to display in light mode.
		 * @public
		 */
		Light : "Light"

	};


	/**
	 * Available options for the layout of all elements along the cross axis of the flexbox layout.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.FlexAlignItems = {

		/**
		 * The cross-start margin edges of the box items are placed flush with the cross-start edge of the line.
		 * @public
		 */
		Start : "Start",

		/**
		 * The cross-start margin edges of the box items are placed flush with the cross-end edge of the line.
		 * @public
		 */
		End : "End",

		/**
		 * The box items' margin boxes are centered in the cross axis within the line.
		 * @public
		 */
		Center : "Center",

		/**
		 * If the box items' inline axes are the same as the cross axis, this value is identical to ?start?. Otherwise, it participates in baseline alignment: all participating box items on the line are aligned such that their baselines align, and the item with the largest distance between its baseline and its cross-start margin edge is placed flush against the cross-start edge of the line.
		 * @public
		 */
		Baseline : "Baseline",

		/**
		 * Make the cross size of the items' margin boxes as close to the same size as the line as possible.
		 * @public
		 */
		Stretch : "Stretch",

		/**
		 * Inherits the value from its parent.
		 * @public
		 */
		Inherit : "Inherit"

	};


	/**
	 * Available options for the layout of individual elements along the cross axis of the flexbox layout overriding the default alignment.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.FlexAlignSelf = {

		/**
		 * Takes up the value of alignItems from the parent FlexBox
		 * @public
		 */
		Auto : "Auto",

		/**
		 * The cross-start margin edges of the box item is placed flush with the cross-start edge of the line.
		 * @public
		 */
		Start : "Start",

		/**
		 * The cross-start margin edges of the box item is placed flush with the cross-end edge of the line.
		 * @public
		 */
		End : "End",

		/**
		 * The box item's margin box is centered in the cross axis within the line.
		 * @public
		 */
		Center : "Center",

		/**
		 * If the box item's inline axis is the same as the cross axis, this value is identical to ?start?. Otherwise, it participates in baseline alignment: all participating box items on the line are aligned such that their baselines align, and the item with the largest distance between its baseline and its cross-start margin edge is placed flush against the cross-start edge of the line.
		 * @public
		 */
		Baseline : "Baseline",

		/**
		 * Make the cross size of the item's margin box as close to the same size as the line as possible.
		 * @public
		 */
		Stretch : "Stretch",

		/**
		 * Inherits the value from its parent.
		 * @public
		 */
		Inherit : "Inherit"

	};


	/**
	 * Available directions for flex layouts.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.FlexDirection = {

		/**
		 * Elements are layed out along the direction of the inline axis (text direction).
		 * @public
		 */
		Row : "Row",

		/**
		 * Elements are layed out along the direction of the block axis (usually top to bottom).
		 * @public
		 */
		Column : "Column",

		/**
		 * Elements are layed out along the reverse direction of the inline axis (against the text direction).
		 * @public
		 */
		RowReverse : "RowReverse",

		/**
		 * Elements are layed out along the reverse direction of the block axis (usually bottom to top).
		 * @public
		 */
		ColumnReverse : "ColumnReverse",

		/**
		 * Inherits the value from its parent.
		 * @public
		 */
		Inherit : "Inherit"

	};


	/**
	 * Available options for the layout of elements along the main axis of the flexbox layout.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.FlexJustifyContent = {

		/**
		 * Box items are packed toward the start of the line.
		 * @public
		 */
		Start : "Start",

		/**
		 * Box items are packed toward the end of the line.
		 * @public
		 */
		End : "End",

		/**
		 * Box items are packed toward the center of the line.
		 * @public
		 */
		Center : "Center",

		/**
		 * Box items are evenly distributed in the line.
		 * @public
		 */
		SpaceBetween : "SpaceBetween",

		/**
		 * Box items are evenly distributed in the line, with half-size spaces on either end.
		 * @public
		 */
		SpaceAround : "SpaceAround",

		/**
		 * Inherits the value from its parent.
		 * @public
		 */
		Inherit : "Inherit"

	};


	/**
	 * Determines the type of HTML elements used for rendering controls.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.FlexRendertype = {

		/**
		 * DIV elements are used for rendering
		 * @public
		 */
		Div : "Div",

		/**
		 * Unordered lists are used for rendering.
		 * @public
		 */
		List : "List"

	};


	/**
	 * Different levels for headers
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.HeaderLevel = {

		/**
		 * Header level 1
		 * @public
		 */
		H1 : "H1",

		/**
		 * Header level 2
		 * @public
		 */
		H2 : "H2",

		/**
		 * Header level 3
		 * @public
		 */
		H3 : "H3",

		/**
		 * Header level 4
		 * @public
		 */
		H4 : "H4",

		/**
		 * Header level 5
		 * @public
		 */
		H5 : "H5",

		/**
		 * Header level 6
		 * @public
		 */
		H6 : "H6"

	};


	/**
	 *
	 *   Interface for controls which are suitable as a Header, Subheader or Footer of a Page.
	 *   If the control does not want to get a context base style class, it has to implement the isContextSensitive method and return false
	 *
	 *
	 * @since 1.22
	 * @name sap.m.IBar
	 * @interface
	 * @public
	 * @ui5-metamodel This interface also will be described in the UI5 (legacy) designtime metamodel
	 */


	/**
	 * Allowed tags for the implementation of the IBar interface.
	 *
	 * @enum {string}
	 * @public
	 * @since 1.22
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.IBarHTMLTag = {

		/**
		 * Renders as a div element.
		 * @public
		 */
		Div : "Div",

		/**
		 * Renders as a header element.
		 * @public
		 */
		Header : "Header",

		/**
		 * Renders as a footer element.
		 * @public
		 */
		Footer : "Footer"

	};


	/**
	 *
	 *   Marker interface for controls which are suitable as items for the IconTabBar.
	 *   These controls must implement a method isSelectable().
	 *
	 *
	 * @name sap.m.IconTab
	 * @interface
	 * @public
	 * @ui5-metamodel This interface also will be described in the UI5 (legacy) designtime metamodel
	 */


	/**
	 * Available Filter Item Design.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.IconTabFilterDesign = {

		/**
		 * A horizontally layouted design providing more space for texts.
		 * @public
		 */
		Horizontal : "Horizontal",

		/**
		 * A vertically layouted design using minimum horizontal space.
		 * @public
		 */
		Vertical : "Vertical"

	};


	/**
	 * A subset of input types that fit to a simple API returning one string.
	 * Not available on purpose: button, checkbox, hidden, image, password, radio, range, reset, search, submit.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.InputType = {

		/**
		 * default (text)
		 * @public
		 */
		Text : "Text",

		/**
		 * An input control for specifying a date value. The user can select a month, day of the month, and year.
		 * @public
		 * @deprecated Since version 1.9.1.
		 * Please use sap.m.DateTimeInput control with type "Date" to create date input.
		 */
		Date : "Date",

		/**
		 * An input control for specifying a date and time value. The user can select a month, day of the month, year, and time of day.
		 * @public
		 * @deprecated Since version 1.9.1.
		 * Please use dedicated sap.m.DateTimeInput control with type "DateTime" to create date-time input.
		 */
		Datetime : "Datetime",

		/**
		 * An input control for specifying a date and time value where the format depends on the locale.
		 * @public
		 * @deprecated Since version 1.9.1.
		 * Please use dedicated sap.m.DateTimeInput control with type "DateTime" to create date-time input.
		 */
		DatetimeLocale : "DatetimeLocale",

		/**
		 * A text field for specifying an email address. Brings up a keyboard optimized for email address entry.
		 * @public
		 */
		Email : "Email",

		/**
		 * An input control for selecting a month.
		 * @public
		 * @deprecated Since version 1.9.1.
		 * There is no cross-platform support. Please do not use this Input type.
		 */
		Month : "Month",

		/**
		 * A text field for specifying a number. Brings up a number pad keyboard. Specifying an input type of \d* or [0-9]* is equivalent to using this type.
		 * @public
		 */
		Number : "Number",

		/**
		 * A text field for specifying a phone number. Brings up a phone pad keyboard.
		 * @public
		 */
		Tel : "Tel",

		/**
		 * An input control for specifying a time value. The user can select the hour, minute, and optionally AM or PM.
		 * @public
		 * @deprecated Since version 1.9.1.
		 * Please use dedicated sap.m.DateTimeInput control with type "Time" to create time input.
		 */
		Time : "Time",

		/**
		 * A text field for specifying a URL. Brings up a keyboard optimized for URL entry.
		 * @public
		 */
		Url : "Url",

		/**
		 * An input control for selecting a week.
		 * @public
		 * @deprecated Since version 1.9.1.
		 * There is no cross-platform support. Please do not use this Input type.
		 */
		Week : "Week",

		/**
		 * Password input where the user entry cannot be seen.
		 * @public
		 */
		Password : "Password"

	};


	/**
	 * Available label display modes.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.LabelDesign = {

		/**
		 * Displays the label in bold.
		 * @public
		 */
		Bold : "Bold",

		/**
		 * Displays the label in normal mode.
		 * @public
		 */
		Standard : "Standard"

	};


	/**
	 * Defines the different header styles.
	 *
	 * @enum {string}
	 * @public
	 * @deprecated Since version 1.16.
	 * Has no functionality since 1.16.
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.ListHeaderDesign = {

		/**
		 * Standard header style
		 * @public
		 */
		Standard : "Standard",

		/**
		 * Plain header style
		 * @public
		 */
		Plain : "Plain"

	};


	/**
	 * Different modes for the list selection (predefined modes)
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.ListMode = {

		/**
		 * default mode (no selection)
		 * @public
		 */
		None : "None",

		/**
		 * right positioned single selection mode (only one list item can be selected)
		 * @public
		 */
		SingleSelect : "SingleSelect",

		/**
		 * multi selection mode (whole list item including checkbox will be selected)
		 * @public
		 */
		MultiSelect : "MultiSelect",

		/**
		 * delete mode (only one list item can be deleted)
		 * @public
		 */
		Delete : "Delete",

		/**
		 * Single selection master mode (only one list item can be selected), selected item is highlighted but no radiobutton is visible.
		 * @public
		 */
		SingleSelectMaster : "SingleSelectMaster",

		/**
		 * left positioned single selection mode (only one list item can be selected)
		 * @public
		 */
		SingleSelectLeft : "SingleSelectLeft"

	};


	/**
	 * Defines which separator style will be applied for the items.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.ListSeparators = {

		/**
		 * Separators around the items.
		 * @public
		 */
		All : "All",

		/**
		 * Separators between the items when there is no footer. Note: This enumeration depends on the theme. Please check design documentation for more details.
		 * @public
		 */
		Inner : "Inner",

		/**
		 * No item separators.
		 * @public
		 */
		None : "None"

	};


	/**
	 * List types
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.ListType = {

		/**
		 * Inactive
		 * @public
		 */
		Inactive : "Inactive",

		/**
		 * Detail
		 * @public
		 */
		Detail : "Detail",

		/**
		 * Navigation
		 * @public
		 */
		Navigation : "Navigation",

		/**
		 * Active
		 * @public
		 */
		Active : "Active",

		/**
		 * DetailAndActive
		 * @public
		 */
		DetailAndActive : "DetailAndActive"

	};


	/**
	 * Marker interface for controls which are suitable as items for the ObjectHeader.
	 *
	 * @name sap.m.ObjectHeaderContainer
	 * @interface
	 * @public
	 * @ui5-metamodel This interface also will be described in the UI5 (legacy) designtime metamodel
	 */


	/**
	 * Type of Panels used on the Personalization Dialog
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.P13nPanelType = {

		/**
		 * Panel type for sorting
		 * @public
		 */
		sort : "sort",

		/**
		 * Panel type for filtering
		 * @public
		 */
		filter : "filter",

		/**
		 * Panel type for grouping
		 * @public
		 */
		group : "group",

		/**
		 * Panel type for columns setting
		 * @public
		 */
		columns : "columns"

	};


	/**
	 * Available Page Background Design.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.PageBackgroundDesign = {

		/**
		 * Standard Page background color.
		 * @public
		 */
		Standard : "Standard",

		/**
		 * Page background color when a List is set as the Page content.
		 * @public
		 */
		List : "List",

		/**
		 * A solid background color dependent on the theme.
		 * @public
		 */
		Solid : "Solid",

		/**
		 * Transparent background for the page.
		 * @public
		 */
		Transparent : "Transparent"

	};

	/**
	 * Types for the placement of popover control.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.PlacementType = {

		/**
		 * Popover will be placed at the left side of the reference control.
		 * @public
		 */
		Left : "Left",

		/**
		 * Popover will be placed at the right side of the reference control.
		 * @public
		 */
		Right : "Right",

		/**
		 * Popover will be placed at the top of the reference control.
		 * @public
		 */
		Top : "Top",

		/**
		 * Popover will be placed at the bottom of the reference control.
		 * @public
		 */
		Bottom : "Bottom",

		/**
		 * Popover will be placed at the top or bottom of the reference control.
		 * @public
		 */
		Vertical : "Vertical",

		/**
		 * Popover will be placed at the right or left side of the reference control.
		 * @public
		 */
		Horizontal : "Horizontal",

		/**
		 * Popover will be placed automatically at the reference control.
		 * @public
		 */
		Auto : "Auto"

	};

	/**
	 * QuickViewGroupElement is a combination of one label and another control (Link or Text) associated to this label
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.QuickViewGroupElementType = {

		/**
		 * Displays a phone number link for direct dialing
		 * @public
		 */
		phone : "phone",

		/**
		 * Displays a phone number link for direct dialing and an icon for sending a text message
		 * @public
		 */
		mobile : "mobile",

		/**
		 * Displays an e-mail link
		 * @public
		 */
		email : "email",

		/**
		 * Displayes a regular HTML link
		 * @public
		 */
		link : "link",

		/**
		 * Dislpays text
		 * @public
		 */
		text : "text",

		/**
		 * Dislpays a link for navigating to another QuickViewPage
		 * @public
		 */
		pageLink : "pageLink"

	};


	/**
	* Types for the placement of message popover control.
	*
	* @enum {string}
	* @public
	* @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	*/
	sap.m.VerticalPlacementType = {

		/**
		* Popover will be placed at the top of the reference control.
		* @public
		*/
		Top : "Top",

		/**
		* Popover will be placed at the bottom of the reference control.
		* @public
		*/
		Bottom : "Bottom",

		/**
		* Popover will be placed at the top or bottom of the reference control.
		* @public
		*/
		Vertical : "Vertical"
	};

	/**
	 * Defines the display of table pop-ins
	 *
	 * @enum {string}
	 * @public
	 * @since 1.13.2
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.PopinDisplay = {

		/**
		 * Inside the table popin, header is displayed at the first line and cell content is displayed at the next line.
		 * @public
		 */
		Block : "Block",

		/**
		 * Inside the table popin, cell content is displayed next to the header in the same line. Note: If there is not enough space for the cell content then it jumps to the next line.
		 * @public
		 */
		Inline : "Inline",


		/**
		 * Inside the table popin, only the cell content will be visible.
		 * @public
		 * @since 1.28
		 */
		WithoutHeader : "WithoutHeader"
	};


	/**
	 * Possible values for the visualization of float values in the RatingIndicator Control.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.RatingIndicatorVisualMode = {

		/**
		 * Values are rounded to the nearest integer value (e.g. 1.7 -> 2).
		 * @public
		 */
		Full : "Full",

		/**
		 * Values are rounded to the nearest half value (e.g. 1.7 -> 1.5).
		 * @public
		 */
		Half : "Half"

	};


	/**
	 * Breakpoint names for different screen sizes.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.ScreenSize = {

		/**
		 * 240px wide
		 * @public
		 */
		Phone : "Phone",

		/**
		 * 600px wide
		 * @public
		 */
		Tablet : "Tablet",

		/**
		 * 1024px wide
		 * @public
		 */
		Desktop : "Desktop",

		/**
		 * 240px wide
		 * @public
		 */
		XXSmall : "XXSmall",

		/**
		 * 320px wide
		 * @public
		 */
		XSmall : "XSmall",

		/**
		 * 480px wide
		 * @public
		 */
		Small : "Small",

		/**
		 * 560px wide
		 * @public
		 */
		Medium : "Medium",

		/**
		 * 768px wide
		 * @public
		 */
		Large : "Large",

		/**
		 * 960px wide
		 * @public
		 */
		XLarge : "XLarge",

		/**
		 * 1120px wide
		 * @public
		 */
		XXLarge : "XXLarge"

	};


	/**
	 * Enumeration for different Select types.
	 *
	 * @enum {string}
	 * @public
	 * @since 1.16
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.SelectType = {

		/**
		 * Will show the text.
		 * @public
		 */
		Default : "Default",

		/**
		 * Will show only the specified icon.
		 * @public
		 */
		IconOnly : "IconOnly"

	};


	/**
	 * The mode of SplitContainer or SplitApp control to show/hide the master area.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.SplitAppMode = {

		/**
		 * Master will automatically be hidden in portrait mode.
		 * @public
		 */
		ShowHideMode : "ShowHideMode",

		/**
		 * Master will always be shown but in a compressed version when in portrait mode.
		 * @public
		 */
		StretchCompressMode : "StretchCompressMode",

		/**
		 * Master will be shown inside a Popover when in portrait mode
		 * @public
		 */
		PopoverMode : "PopoverMode",

		/**
		 * Master area is hidden initially both in portrait and landscape. Master area can be opened by clicking on the top left corner button or swiping right. Swipe is only enabled on mobile devices. Master will keep the open state when changing the orientation of the device.
		 * @public
		 */
		HideMode : "HideMode"

	};


	/**
	 * Types for StandardTile
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.StandardTileType = {

		/**
		 * Tile representing that something needs to be created
		 * @public
		 */
		Create : "Create",

		/**
		 * Monitor tile
		 * @public
		 */
		Monitor : "Monitor",

		/**
		 * Default type
		 * @public
		 */
		None : "None"

	};


	/**
	 * Directions for swipe event.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.SwipeDirection = {

		/**
		 * Swipe from left to right
		 * @public
		 */
		LeftToRight : "LeftToRight",

		/**
		 * Swipe from right to left.
		 * @public
		 */
		RightToLeft : "RightToLeft",

		/**
		 * Both directions (left to right or right to left)
		 * @public
		 */
		Both : "Both"

	};


	/**
	 * Enumaration for different switch types.
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.SwitchType = {

		/**
		 * Will show "ON" and "OFF" translated to the current language or the custom text if provided
		 * @public
		 */
		Default : "Default",

		/**
		 * Switch with accept and reject icons
		 * @public
		 */
		AcceptReject : "AcceptReject"

	};


	/**
	 * Types of the Toolbar Design.
	 *
	 * @enum {string}
	 * @public
	 * @since 1.16.8
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.m.ToolbarDesign = {

		/**
		 * The toolbar can be inserted into other controls and if the design is "Auto" then it inherits the design from parent control.
		 * @public
		 */
		Auto : "Auto",

		/**
		 * The toolbar and its content will be displayed transparent.
		 * @public
		 */
		Transparent : "Transparent",

		/**
		 * The toolbar appears smaller than the regular size to show information(e.g: text, icon).
		 * @public
		 */
		Info : "Info",

		/**
		 * The toolbar has a solid background. Its content will be rendered in a standard way.
		 * @public
		 * @since 1.22
		 */
		Solid : "Solid"

	};
	/*global Element: true */


	//lazy imports for MessageToast
	sap.ui.lazyRequire("sap.m.MessageToast", "show");

	// requires for routing
	sap.ui.lazyRequire("sap.m.routing.RouteMatchedHandler");
	sap.ui.lazyRequire("sap.m.routing.Router");
	sap.ui.lazyRequire("sap.m.routing.Target");
	sap.ui.lazyRequire("sap.m.routing.TargetHandler");
	sap.ui.lazyRequire("sap.m.routing.Targets");

	//enable ios7 support
	if (Device.os.ios && Device.os.version >= 7 && Device.os.version < 8 && Device.browser.name === "sf") {
		jQuery.sap.require("sap.m.ios7");
	}

	//Internal: test the whole page with compact design
	if (/sap-ui-xx-formfactor=compact/.test(location.search)) {
		jQuery("html").addClass("sapUiSizeCompact");
		sap.m._bSizeCompact = true;
	}

	//Internal: test the whole page with compact design
	if (/sap-ui-xx-formfactor=condensed/.test(location.search)) {
		jQuery("html").addClass("sapUiSizeCondensed");
		sap.m._bSizeCondensed = true;
	}

	// central mobile functionality that should not go into the UI5 Core can go from here
	// ----------------------------------------------------------------------------------

	!(function(oLib) {

		/**
		 * Returns invalid date value of UI5
		 *
		 * @deprecated Since 1.12 UI5 returns null for invalid date
		 * @returns {null}
		 * @public
		 * @since 1.10
		 * @name sap.m#getInvalidDate
		 * @function
		 */
		oLib.getInvalidDate = function() {
			return null;
		};


		/**
		 * Finds default locale settings once and returns always the same.
		 * We should not need to create new instance to get same locale settings
		 * This method keep the locale instance in the scope and returns the same after first run
		 *
		 * @return {Object} sap.ui.core.Locale instane
		 * @public
		 * @since 1.10
		 * @name sap.m#getLocale
		 * @function
		 */
		oLib.getLocale = function() {
			var oConfig = sap.ui.getCore().getConfiguration(),
				sLocale = oConfig.getFormatSettings().getFormatLocale().toString(),
				oLocale = new sap.ui.core.Locale(sLocale);

			oConfig = sLocale = null; //maybe helps GC
			oLib.getLocale = function() {
				return oLocale;
			};

			return oLocale;
		};

		/**
		 * Finds default locale data once and returns always the same
		 *
		 * @return {Object} sap.ui.core.LocaleData instance
		 * @public
		 * @since 1.10
		 * @name sap.m#getLocaleData
		 * @function
		 */
		oLib.getLocaleData = function() {
			jQuery.sap.require("sap.ui.model.type.Date");
			var oLocaleData = sap.ui.core.LocaleData.getInstance(oLib.getLocale());

			oLib.getLocaleData = function() {
				return oLocaleData;
			};

			return oLocaleData;
		};

		/**
		 * Checks if the given parameter is a valid JsDate Object
		 *
		 * @param {any} value Any variable to test.
		 * @return {boolean}
		 * @public
		 * @since 1.10
		 * @name sap.m#isDate
		 * @function
		 */
		oLib.isDate = function(value) {
			return value && Object.prototype.toString.call(value) == "[object Date]" && !isNaN(value);
		};


		/**
		 * Search given control's parents and try to find iScroll
		 *
		 * @param {sap.ui.core.Control} oControl
		 * @return {iScroll|undefined} iScroll reference or undefined if cannot find
		 * @name sap.m#getIScroll
		 * @public
		 * @since 1.11
		 */
		oLib.getIScroll = function(oControl) {
			if (typeof window.iScroll != "function" || !(oControl instanceof sap.ui.core.Control)) {
				return;
			}

			var parent, scroller;
			/*eslint-disable no-cond-assign */
			for (parent = oControl; parent = parent.oParent;) {
				scroller = parent.getScrollDelegate ? parent.getScrollDelegate()._scroller : null;
				if (scroller && scroller instanceof window.iScroll) {
					return scroller;
				}
			}
			/*eslint-enable no-cond-assign */
		};


		/**
		 * Search given control's parents and try to find ScrollDelegate
		 *
		 * @param {sap.ui.core.Control} oControl
		 * @return {Object|undefined} ScrollDelegate or undefined if cannot find
		 * @name sap.m#getScrollDelegate
		 * @public
		 * @since 1.11
		 */
		oLib.getScrollDelegate = function(oControl) {
			if (!(oControl instanceof sap.ui.core.Control)) {
				return;
			}

			/*eslint-disable no-cond-assign */
			for (var parent = oControl; parent = parent.oParent;) {
				if (typeof parent.getScrollDelegate == "function") {
					return parent.getScrollDelegate();
				}
			}
			/*eslint-enable no-cond-assign */
		};

		/**
		 * screen size definitions in pixel
		 * if you change any value here, please also change
		 * 	1. the documentation of sap.m.ScreenSize
		 *  2. media queries in list.css
		 *
		 * @private
		 * @since 1.12
		 * @name sap.m#ScreenSizes
		 */
		oLib.ScreenSizes = {
			phone : 240,
			tablet : 600,
			desktop : 1024,
			xxsmall : 240,
			xsmall : 320,
			small : 480,
			medium : 560,
			large : 768,
			xlarge : 960,
			xxlarge : 1120
		};

		/**
		 * Base font-size
		 * @private
		 * @since 1.12
		 * @name sap.m#BaseFontSize
		 */
		oLib.BaseFontSize = jQuery(document.documentElement).css("font-size");

		/**
		 * Hide the soft keyboard
		 *
		 * @name sap.m#closeKeyboard
		 * @public
		 * @since 1.20
		 */
		oLib.closeKeyboard = function() {
			var activeElement = document.activeElement;
			if (!Device.system.desktop && activeElement && /(INPUT|TEXTAREA)/i.test(activeElement.tagName)) {
				activeElement.blur();
			}
		};

	}(sap.m));


	/**
	 * Touch helper.
	 *
	 * @namespace
	 * @name sap.m.touch
	 * @public
	 **/

	if (sap.m && !sap.m.touch) {

		sap.m.touch = {};
	}

	/**
	 * Given a list of touch objects, find the touch that matches the given one.
	 *
	 * @param {TouchList} oTouchList The list of touch objects to search.
	 * @param {Touch | number} oTouch A touch object to find or a Touch.identifier that uniquely identifies the current finger in the touch session.
	 * @return {object | undefined} The touch matching if any.
	 * @public
	 * @name sap.m.touch.find
	 * @function
	*/
	sap.m.touch.find = function(oTouchList, oTouch) {
		var i,
			iTouchListLength;

		if (!oTouchList) {
			return;
		}

		if (oTouch && typeof oTouch.identifier !== "undefined") {
			oTouch = oTouch.identifier;
		} else if (typeof oTouch !== "number") {
			jQuery.sap.assert(false, 'sap.m.touch.find(): oTouch must be a touch object or a number');
			return;
		}

		iTouchListLength = oTouchList.length;

		// A TouchList is an object not an array, so we shouldn't use
		// Array.prototype.forEach, etc.
		for (i = 0; i < iTouchListLength; i++) {
			if (oTouchList[i].identifier === oTouch) {
				return oTouchList[i];
			}
		}

		// if the given touch object or touch identifier is not found in the touches list, then return undefined
	};

	/**
	 * Given a list of touches, count the number of touches related with the given element.
	 *
	 * @param {TouchList} oTouchList The list of touch objects to search.
	 * @param {jQuery | Element | string} vElement A jQuery element or an element reference or an element id.
	 * @return {number} The number of touches related with the given element.
	 * @public
	 * @name sap.m.touch.countContained
	 * @function
	*/
	sap.m.touch.countContained = function(oTouchList, vElement) {
		var i,
			iTouchCount = 0,
			iTouchListLength,
			iElementChildrenL,
			$TouchTarget;

		if (!oTouchList) {
			return 0;
		}

		if (vElement instanceof Element) {
			vElement = jQuery(vElement);
		} else if (typeof vElement === "string") {
			vElement = jQuery.sap.byId(vElement);
		} else if (!(vElement instanceof jQuery)) {
			jQuery.sap.assert(false, 'sap.m.touch.countContained(): vElement must be a jQuery object or Element reference or a string');
			return 0;
		}

		iElementChildrenL = vElement.children().length;
		iTouchListLength = oTouchList.length;

		// A TouchList is an object not an array, so we shouldn't use
		// Array.prototype.forEach, etc.
		for (i = 0; i < iTouchListLength; i++) {
			$TouchTarget = jQuery(oTouchList[i].target);

			//	If the current target have only one HTML element or
			//	have a HTML element antecessor that match with the given element id.
			if ((iElementChildrenL === 0  && $TouchTarget.is(vElement)) ||
				(vElement[0].contains($TouchTarget[0]))) {

				iTouchCount++;
			}
		}

		return iTouchCount;
	};

	/**
	 * <pre>
	 * URL(Uniform Resource Locator) Helper
	 * This helper can be used to trigger a native application(e.g email, sms, tel) from Browser.
	 * That means we are restricted of browser or application implementation. e.g.
	 *  - Some browsers do not let you to pass more than 2022 characters in URL
	 *  - MAPI (Outlook) limit is 2083, max. path under Internet Explorer is 2048
	 *  - Different Internet Explorer versions have different limitation in IE9 approximately 1000 characters
	 *  - MS mail app under Windows 8 cuts mail links after approximately 100 characters
	 *  - Safari gets a confirmation from user before opening a native application and can block rest triggers if user cancels it.
	 *  - Some mail applications(Outlook) do not respect all encodings(e.g. Cyrillic texts are not encoded correctly)
	 *
	 * Note: all the given limitation lengths are for encoded text(e.g space character will be encoded to "%20")
	 * </pre>
	 *
	 * @namespace
	 * @name sap.m.URLHelper
	 * @since 1.10
	 * @public
	 */
	sap.m.URLHelper = (function($, window) {

		function isValidString(value) {
			return value && Object.prototype.toString.call(value) == "[object String]";
		}

		function formatTel(sTel) {
			if (!isValidString(sTel)) {
				return "";
			}
			return sTel.replace(/[^0-9\+\*#]/g, "");
		}

		function formatMessage(sText) {
			if (!isValidString(sText)) {
				return "";
			}
			// line breaks in the  body of a message MUST be encoded with "%0D%0A"
			// space character in the  body of a message MUST be encoded with "%20"
			// see http://www.ietf.org/rfc/rfc2368.txt for details
			sText = sText.split(/\r\n|\r|\n/g).join("\r\n");
			return window.encodeURIComponent(sText);
		}

		return $.extend(new sap.ui.base.EventProvider(), {
			/**
			 * Sanitize the given telephone number and returns telephone URI scheme
			 *
			 * @param {String} [sTel] telephone number.
			 * @return {String} telephone URI scheme.
			 * @public
			 * @name sap.m.URLHelper#normalizeTel
			 * @function
			 */
			normalizeTel : function(sTel) {
				return "tel:" + formatTel(sTel);
			},

			/**
			 * Sanitize the given telephone number and returns SMS URI scheme
			 *
			 * @param {String} [sTel] telephone number.
			 * @return {String} SMS URI scheme.
			 * @public
			 * @name sap.m.URLHelper#normalizeSms
			 * @function
			 */
			normalizeSms : function(sTel) {
				return "sms:" + formatTel(sTel);
			},

			/**
			 * Builds Email URI from given parameter.
			 * Trims spaces from email addresses
			 *
			 * @param {String} [sEmail] Destination email address.
			 * @param {String} [sSubject] Subject of the email address.
			 * @param {String} [sBody] Default message text.
			 * @param {String} [sCC] Carbon Copy email address.
			 * @param {String} [sBCC] Blind carbon copy email address.
			 * @return {String} Email URI scheme.
			 * @public
			 * @name sap.m.URLHelper#normalizeEmail
			 * @function
			 */
			normalizeEmail : function(sEmail, sSubject, sBody, sCC, sBCC) {
				var aParams = [],
					sURL = "mailto:",
					encode = window.encodeURIComponent;

				// Within mailto URLs, the characters "?", "=", "&" are reserved
				isValidString(sEmail) && (sURL += encode($.trim(sEmail)));
				isValidString(sSubject) && aParams.push("subject=" + encode(sSubject));
				isValidString(sBody) && aParams.push("body=" + formatMessage(sBody));
				isValidString(sBCC) && aParams.push("bcc=" + encode($.trim(sBCC)));
				isValidString(sCC) && aParams.push("cc=" + encode($.trim(sCC)));

				if (aParams.length) {
					sURL += "?" + aParams.join("&");
				}
				return sURL;
			},

			/**
			 * Redirects to given URL
			 * This method fires "redirect" event before open the URL
			 *
			 * @param {String} sURL Uniform resource locator.
			 * @param {boolean} [bNewWindow] Opens URL in a new browser window
			 * @public
			 * @name sap.m.URLHelper#redirect
			 * @function
			 */
			redirect : function (sURL, bNewWindow) {
				$.sap.assert(isValidString(sURL), this + "#redirect: URL must be a string" );

				this.fireEvent("redirect", sURL);
				if (!bNewWindow) {
					window.location.href = sURL;
				} else {
					window.open(sURL, "_blank");
				}
			},

			/**
			 * Adds an event registration for redirect
			 *
			 * @param {Function} fnFunction The function to call, when the event occurs.
			 * @param {Object} [oListener] The object, that wants to be notified, when the event occurs
			 * @return {Object} sap.m.URLHelper instance
			 * @public
			 * @name sap.m.URLHelper#attachRedirect
			 * @function
			 */
			attachRedirect : function (fnFunction, oListener) {
				return this.attachEvent("redirect", fnFunction, oListener);
			},

			/**
			 * Detach already registered redirect event
			 *
			 * @param {Function} fnFunction The function to call, when the event occurs.
			 * @param {Object} [oListener] The object, that wants to be notified, when the event occurs
			 * @return {Object} sap.m.URLHelper instance
			 * @public
			 * @name sap.m.URLHelper#detachRedirect
			 * @function
			 */
			detachRedirect : function (fnFunction, oListener) {
				return this.detachEvent("redirect", fnFunction, oListener);
			},

			/**
			 * Trigger telephone to call given telephone number
			 *
			 * @param {String} [sTel] telephone number.
			 * @public
			 * @name sap.m.URLHelper#triggerTel
			 * @function
			 */
			triggerTel : function(sTel) {
				this.redirect(this.normalizeTel(sTel));
			},

			/**
			 * Trigger SMS application to send SMS to given telephone number
			 *
			 * @param {String} [sTel] telephone number.
			 * @public
			 * @name sap.m.URLHelper#triggerSms
			 * @function
			 */
			triggerSms : function(sTel) {
				this.redirect(this.normalizeSms(sTel));
			},

			/**
			 * Trigger email application to send email
			 * Trims spaces from email addresses
			 *
			 * @param {String} [sEmail] Destination email address.
			 * @param {String} [sSubject] Subject of the email address.
			 * @param {String} [sBody] Default message text.
			 * @param {String} [sCC] Carbon Copy email address.
			 * @param {String} [sBCC] Blind carbon copy email address.
			 * @public
			 * @name sap.m.URLHelper#triggerEmail
			 * @function
			 */
			triggerEmail : function(sEmail, sSubject, sBody, sCC, sBCC) {
				this.redirect(this.normalizeEmail.apply(0, arguments));
			},

			toString : function() {
				return "sap.m.URLHelper";
			}
		});

	}(jQuery, window));


	/**
	 * Helper for rendering themable background
	 *
	 * @namespace
	 * @name sap.m.BackgroundHelper
	 * @since 1.12
	 * @protected
	 */
	sap.m.BackgroundHelper = (function($, window) {

		return {
			/**
			 * Adds CSS classes and styles to the given RenderManager, depending on the given configuration for background color and background image.
			 * To be called by control renderers supporting the global themable background image within their root tag, before they call writeClasses() and writeStyles().
			 *
			 * @param {sap.ui.core.RenderManager} rm the RenderManager
			 * @param {String} [sBgColor] a configured custom background color for the control, if any
			 * @param {sap.ui.core.URI} [sBgImgUrl] the configured custom background image for the control, if any
			 *
			 * @protected
			 * @name sap.m.BackgroundHelper#addBackgroundColorStyles
			 * @function
			 */
			addBackgroundColorStyles: function(rm, sBgColor, sBgImgUrl, sCustomBGClass) {
				rm.addClass(sCustomBGClass || "sapMGlobalBackgroundColor");

				if (sBgColor || sBgImgUrl) { // when an image or color is configured, the gradient needs to be removed, so the color can be seen behind the image
					rm.addStyle("background-image", "none");
					rm.addStyle("filter", "none");
				}
				if (sBgColor) {
					rm.addStyle("background-color", jQuery.sap.escapeHTML(sBgColor));
				}
			},


			/**
			 * @protected
			 * @returns
			 */
			/* currently not needed
			isThemeBackgroundImageModified: function() {
				jQuery.sap.require("sap.ui.core.theming.Parameters");
				var sBgImgUrl = sap.ui.core.theming.Parameters.get('sapUiGlobalBackgroundImage'); // the global background image from the theme
				if (sBgImgUrl && sBgImgUrl !== "''") {
					var sBgImgUrlDefault = sap.ui.core.theming.Parameters.get('sapUiGlobalBackgroundImageDefault');
					if (sBgImgUrl !== sBgImgUrlDefault) {
						return true;
					}
				}
				return false;
			},
			*/

			/**
			 * Renders an HTML tag into the given RenderManager which carries the background image which is either configured and given or coming from the current theme.
			 * Should be called right after the opening root tag has been completed, so this is the first child element inside the control.
			 *
			 * @param rm the RenderManager
			 * @param {sap.ui.core.Control} oControl the control within which the tag will be rendered; its ID will be used to generate the element ID
			 * @param {String}  sCssClass a css class to add to the element
			 * @param {sap.ui.core.URI}  [sBgImgUrl] the image of a configured background image; if this is not given, the theme background will be used and also the other settings are ignored.
			 * @param {boolean} [bRepeat] whether the background image should be repeated/tiled (or stretched)
			 * @param {float}   [fOpacity] the background image opacity, if any
			 *
			 * @protected
			 * @name sap.m.BackgroundHelper#renderBackgroundImageTag
			 * @function
			 */
			renderBackgroundImageTag: function(rm, oControl, sCssClass, sBgImgUrl, bRepeat, fOpacity) {
				rm.write("<div id='" + oControl.getId() + "-BG' ");
				rm.addClass(sCssClass);
				rm.addClass("sapMGlobalBackgroundImage"); // this adds the background image from the theme

				if (sBgImgUrl) { // use the settings only if a background image is configured
					rm.addStyle("display", "block"); // enforce visibility even if a parent has also a background image
					rm.addStyle("background-image", "url(" + jQuery.sap.encodeHTML(sBgImgUrl) + ")");

					rm.addStyle("background-repeat", bRepeat ? "repeat" : "no-repeat");
					if (!bRepeat) {
						rm.addStyle("background-size", "cover");
						rm.addStyle("background-position", "center");
					} else { // repeat
						rm.addStyle("background-position", "left top");
					}

				} //else {
					// the theme defines the background
				//}

				if (fOpacity !== 1) {
					if (fOpacity > 1) { // greater than 1 enforces 1
						fOpacity = 1;
					}
					rm.addStyle("opacity", fOpacity);
				}

				rm.writeClasses();
				rm.writeStyles();
				rm.write("></div>");
			}
		};
	}(jQuery, window));

	/**
	 * Helper for Images
	 *
	 * @namespace
	 * @name sap.m.ImageHelper
	 * @since 1.12
	 * @protected
	 */
	sap.m.ImageHelper = (function($, window) {

		/**
		 * Checks if value is not undefined, in which case the
		 * setter function for a given property is called.
		 * Returns true if value is set, false otherwise.
		 *
		 * @private
		 */
		function checkAndSetProperty(oControl, property, value) {
			if (value !== undefined) {
				var fSetter = oControl['set' + jQuery.sap.charToUpperCase(property)];
				if (typeof (fSetter) === "function") {
					fSetter.call(oControl, value);
					return true;
				}
			}
			return false;
		}

		return {
			/**
			 * Creates or updates an image control.
			 *
			 * @param {string} sImgId id of the image to be dealt with.
			 * @param {sap.m.Image} oImageControl the image to update. If undefined, a new image will be created.
			 * @param {sap.ui.core.Control} oParent oImageControl's parentControl.
			 * @param {Map} mProperties map object that contains key value pairs if image propeties. The 'src' property
			 * MUST be contained. Also the map's keys must be names of image properties
			 * @param {Array} aCssClassesToAdd array of css classes which will be added if the image needs to be created.
			 * @param {Array} aCssClassesToRemove all css clases that oImageControl has and which are contained in this array
			 * are removed bevore adding the css classes listed in aCssClassesToAdd.
			 * @returns the new or updated image control
			 *
			 * @protected
			 * @name sap.m.ImageHelper#getImageControl
			 * @function
			 */
			getImageControl: function(sImgId, oImageControl, oParent, mProperties, aCssClassesToAdd, aCssClassesToRemove) {
				jQuery.sap.assert( !!mProperties['src'] , "sap.m.ImageHelper.getImageControl: mProperties do not contain 'src'");

				// make sure, image is rerendered if icon source has changed
				if (oImageControl && (oImageControl.getSrc() != mProperties['src'])) {
					oImageControl.destroy();
					oImageControl = undefined;
				}
				// update or create image control
				var oImage = oImageControl;
				if (!!oImage && (oImage instanceof sap.m.Image || oImage instanceof sap.ui.core.Icon)) {
					//Iterate through properties
					for (var key in mProperties) {
						checkAndSetProperty(oImage, key,  mProperties[key]);
					}
				} else {
					if (!sap.m.Image) {
						jQuery.sap.require("sap.m.Image");
					}
					var mSettings = mProperties;
					//add 'id' to properties. This is required by utility
					//method 'createControlByURI'
					mSettings['id'] = sImgId;
					oImage = sap.ui.core.IconPool.createControlByURI(
							mSettings, sap.m.Image);
					//Set the parent so the image gets re-rendered, when the parent is
					oImage.setParent(oParent, null, true);
				}

				//Remove existing style classes which are contained in aCssClassesToRemove
				//(the list of css classes allowed for deletion) to have them updated later on
				//Unfortunately, there is no other way to do this but remove
				//each class individually
				if (!!aCssClassesToRemove) {
					for (var l = 0, removeLen = aCssClassesToRemove.length; l !== removeLen; l++) {
						oImage.removeStyleClass(aCssClassesToRemove[l]);
					}
				}
				//Add style classes if necessary
				if (!!aCssClassesToAdd) {
					for (var k = 0, len = aCssClassesToAdd.length; k !== len; k++) {
						oImage.addStyleClass(aCssClassesToAdd[k]);
					}
				}
				oImageControl = oImage;
				return oImageControl;
			}
		};
	}(jQuery, window));

	/**
	 * Helper for Popups
	 *
	 * @namespace
	 * @name sap.m.PopupHelper
	 * @since 1.16.7
	 * @protected
	 */
	sap.m.PopupHelper = (function(){
		return {
			/**
			 * This methods converts the percentage value to an absolute number based on the given base number.
			 *
			 * @param {string} sPercentage A percentage value in string format, for example "25%"
			 * @param {float} fBaseSize A float number which the calculation is based on.
			 * @returns The calculated size string with "px" as unit or null when the format of given parameter is wrong.
			 *
			 * @protected
			 * @name sap.m.PopupHelper.calcPercentageSize
			 * @function
			 */
			calcPercentageSize: function(sPercentage, fBaseSize){
				if (typeof sPercentage !== "string") {
					jQuery.sap.log.warning("sap.m.PopupHelper: calcPercentageSize, the first parameter" + sPercentage + "isn't with type string");
					return null;
				}

				if (sPercentage.indexOf("%") <= 0) {
					jQuery.sap.log.warning("sap.m.PopupHelper: calcPercentageSize, the first parameter" + sPercentage + "is not a percentage string (for example '25%')");
					return null;
				}

				var fPercent = parseFloat(sPercentage) / 100,
					fParsedBaseSize = parseFloat(fBaseSize);

				return Math.floor(fPercent * fParsedBaseSize) + "px";
			}
		};
	}());

	/**
	 * Suggestion helper for sap.m.Input fields: Creates a multi column suggest list for a sap.m.Input field based on a ValueList
	 * annotation. The ValueList annotation will be resolved via the binding information of the Input field.
	 *
	 * If the annotation describes multiple input parameter the suggest provider will resolve all of these relative to the
	 * context of the Input filed and use them for the suggestion query. The suggest provider will write all values that are
	 * described as output parameters back to the model (relative to the context of the Input field). This can only be done if
	 * the model runs in "TwoWay" binding mode. Both features can be switched of via the bResolveInput/bResolveOutput parameter
	 * of the suggest function:
	 *
	 * @param {event} oEvent
	 * @param {boolean} bResolveInput SuggestProvider resolves all input parameters for the data query
	 * @param {boolean} bResolveOutput SuggestProvider writes back all output parameters.
	 * @param {int} iLength If iLength is provided only these number of entries will be requested.
	 *
	 * @name sap.m.InputODataSuggestProvider
	 * @since 1.21.2
	 *
	 * @public
	 *
	 */
	sap.m.InputODataSuggestProvider = (function(){
		var _fnSuggestionItemSelected = function(oEvent) {
			var oCtrl = oEvent.getSource();
			var mValueListAnnotation = oCtrl.data(oCtrl.getId() + "-#valueListAnnotation");
			var oModel = oCtrl.getModel();
			var oInputBinding = oCtrl.getBinding("value");
			var sInputPath = oModel.resolve(oInputBinding.getPath(), oInputBinding.getContext());

			if (!mValueListAnnotation) {
				return;
			}
			var oRow = oEvent.getParameter("selectedRow");
			jQuery.each(oRow.getCells(), function(iIndex, oCell) {
				var oCellBinding =  oCell.getBinding("text");
				jQuery.each(mValueListAnnotation.outParameters, function(sKey, oObj) {
					if (!oObj.displayOnly && oObj.value == oCellBinding.getPath()) {
						var oValue = oCellBinding.getValue();
						var sValuePath = oModel.resolve(sKey, oInputBinding.getContext());
						if (oValue && sValuePath !== sInputPath) {
							oModel.setProperty(sValuePath, oValue);
						}
					}
				});
			});
			return true;
		};
		var _setValueListAnnotationData = function(oCtrl, bResolveOutput) {
			var oModel = oCtrl.getModel();
			var oMetadata = oModel.oMetadata;

			var sPath = oModel.resolve(oCtrl.getBindingPath("value"), oCtrl.getBindingContext());

			var mValueListAnnotation = {};
			mValueListAnnotation.searchSupported = false;
			mValueListAnnotation.collectionPath = "";
			mValueListAnnotation.outParameters = {};
			mValueListAnnotation.inParameters = {};
			mValueListAnnotation.selection = [];

			var oAnnotation = oModel.getProperty(sPath + "/#com.sap.vocabularies.Common.v1.ValueList");
			if (!oAnnotation) {
				return false;
			}
			var sProperty = sPath.substr(sPath.lastIndexOf('/') + 1);
			mValueListAnnotation.inProperty = sProperty;

			jQuery.each(oAnnotation.record, function(i, aPropertyValues){
				jQuery.each(aPropertyValues, function(j, oPropertyValue){
					if (oPropertyValue.property === "SearchSupported" && oPropertyValue.bool) {
						mValueListAnnotation.searchSupported = true;
					}
					if (oPropertyValue.property === "CollectionPath") {
						mValueListAnnotation.collectionPath = oPropertyValue.string;
					}
					if (oPropertyValue.property === "Parameters") {
						jQuery.each(oPropertyValue.collection.record, function(k, oRecord) {
							if (oRecord.type === "com.sap.vocabularies.Common.v1.ValueListParameterIn") {
								var sLocalProperty;
								jQuery.each(oRecord.propertyValue, function(m, oPropVal) {
									if (oPropVal.property === "LocalDataProperty") {
										sLocalProperty = oPropVal.propertyPath;
									}
								});
								jQuery.each(oRecord.propertyValue, function(m, oPropVal) {
									if (oPropVal.property === "ValueListProperty") {
										mValueListAnnotation.inParameters[sLocalProperty] = {value:oPropVal.string};
									}
								});
							} else if (oRecord.type === "com.sap.vocabularies.Common.v1.ValueListParameterInOut") {
								var sLocalProperty;
								jQuery.each(oRecord.propertyValue, function(m, oPropVal) {
									if (oPropVal.property === "LocalDataProperty") {
										sLocalProperty = oPropVal.propertyPath;
									}
								});
								jQuery.each(oRecord.propertyValue, function(m, oPropVal) {
									if (oPropVal.property === "ValueListProperty") {
										mValueListAnnotation.outParameters[sLocalProperty] = {value:oPropVal.string};
										mValueListAnnotation.inParameters[sLocalProperty] = {value:oPropVal.string};
									}
								});
							} else if (oRecord.type === "com.sap.vocabularies.Common.v1.ValueListParameterOut") {
								var sLocalProperty;
								jQuery.each(oRecord.propertyValue, function(m, oPropVal) {
									if (oPropVal.property === "LocalDataProperty") {
										sLocalProperty = oPropVal.propertyPath;
									}
								});
								jQuery.each(oRecord.propertyValue, function(m, oPropVal) {
									if (oPropVal.property === "ValueListProperty") {
										mValueListAnnotation.outParameters[sLocalProperty] = {value:oPropVal.string};
									}
								});
							} else if (oRecord.type === "com.sap.vocabularies.Common.v1.ValueListParameterDisplayOnly") {
								var sLocalProperty;
								jQuery.each(oRecord.propertyValue, function(m, oPropVal) {
									if (oPropVal.property === "ValueListProperty") {
										mValueListAnnotation.outParameters[oPropVal.string] = {value:oPropVal.string, displayOnly:true};
									}
								});
							}
						});
					}
				});
			});
			mValueListAnnotation.resultEntity = oMetadata._getEntityTypeByPath("/" + mValueListAnnotation.collectionPath);
			mValueListAnnotation.listItem = new sap.m.ColumnListItem();
			jQuery.each(mValueListAnnotation.outParameters, function(sKey, oObj) {
				mValueListAnnotation.listItem.addCell(new sap.m.Text({text:"{" + oObj.value + "}", wrapping:false}));
				oCtrl.addSuggestionColumn(new sap.m.Column({header: new sap.m.Text({text:"{/#" + mValueListAnnotation.resultEntity.name + "/" + oObj.value + "/@sap:label}", wrapping:false})}));
				mValueListAnnotation.selection.push(oObj.value);
			});
			oCtrl.data(oCtrl.getId() + "-#valueListAnnotation",mValueListAnnotation);
			if (bResolveOutput) {
				oCtrl.attachSuggestionItemSelected(_fnSuggestionItemSelected);
			}
		};
		return {
			suggest: function(oEvent, bResolveInput, bResolveOutput, iLength){
				var mValueListAnnotation,
					oCtrl = oEvent.getSource();

				bResolveInput = bResolveInput === undefined ? true : bResolveInput;
				bResolveOutput = bResolveOutput === undefined ? true : bResolveOutput;

				if (!oCtrl.data(oCtrl.getId() + "-#valueListAnnotation")) {
					_setValueListAnnotationData(oCtrl, bResolveOutput);
				}
				mValueListAnnotation = oCtrl.data(oCtrl.getId() + "-#valueListAnnotation");

				if (!mValueListAnnotation) {
					return;
				}
				var _fnButtonHandler = function(oEvent) {
					var iBindingLength = this.getLength();
					if (iBindingLength && iBindingLength <= iLength) {
						oCtrl.setShowTableSuggestionValueHelp(false);
					} else {
						oCtrl.setShowTableSuggestionValueHelp(true);
					}
				};
				if (mValueListAnnotation.searchSupported) {
					var aFilters = [];
					var sSearchFocus, oCustomParams = {};
					if (bResolveInput) {
						jQuery.each(mValueListAnnotation.inParameters, function(sKey, oObj) {
							if (sKey == mValueListAnnotation.inProperty) {
								sSearchFocus = oObj.value;
							} else if (bResolveInput) {
								var oValue = oCtrl.getModel().getProperty(sKey,oCtrl.getBinding("value").getContext());
								if (oValue) {
									aFilters.push(new sap.ui.model.Filter(oObj.value, sap.ui.model.FilterOperator.StartsWith,oValue));
								}
							}
						});
					}
					oCustomParams.search = oEvent.getParameter("suggestValue");

					if (mValueListAnnotation.inParameters.length) {
						if (sSearchFocus) {
							oCustomParams["search-focus"] = sSearchFocus;
						} else {
							jQuery.sap.assert(false, 'no search-focus defined');
						}
					}

					oCtrl.bindAggregation("suggestionRows",{
						path:"/" + mValueListAnnotation.collectionPath,
						length: iLength,
						filters: aFilters,
						parameters: {
							select: mValueListAnnotation.selection.join(','),
							custom: oCustomParams
						},
						events: {
							dataReceived: _fnButtonHandler
						},
						template: mValueListAnnotation.listItem
					});
				} else {
					//create filter array
					var aFilters = [];
					jQuery.each(mValueListAnnotation.inParameters, function(sKey, oObj) {
						if (sKey == mValueListAnnotation.inProperty) {
							aFilters.push(new sap.ui.model.Filter(oObj.value, sap.ui.model.FilterOperator.StartsWith,oEvent.getParameter("suggestValue")));
						} else if (bResolveInput) {
							var oValue = oCtrl.getModel().getProperty(sKey,oCtrl.getBinding("value").getContext());
							if (oValue) {
								aFilters.push(new sap.ui.model.Filter(oObj.value, sap.ui.model.FilterOperator.StartsWith,oValue));
							}
						}
					});
					oCtrl.bindAggregation("suggestionRows",{
						path:"/" + mValueListAnnotation.collectionPath,
						filters: aFilters,
						template: mValueListAnnotation.listItem,
						length: iLength,
						parameters: {
							select: mValueListAnnotation.selection.join(',')
						},
						events: {
							dataReceived: _fnButtonHandler
						}
					});
				}
			}
		};
	}());

	// implement Form helper factory with m controls
	// possible is set before layout lib is loaded.
	jQuery.sap.setObject("sap.ui.layout.form.FormHelper", {
		createLabel: function(sText){
			return new sap.m.Label({text: sText});
		},
		createButton: function(sId, fPressFunction, oThis){
			var oButton = new sap.m.Button(sId);
			oButton.attachEvent('press', fPressFunction, oThis); // attach event this way to have the right this-reference in handler
			return oButton;
		},
		setButtonContent: function(oButton, sText, sTooltip, sIcon, sIconHovered){
			oButton.setText(sText);
			oButton.setTooltip(sTooltip);
			oButton.setIcon(sIcon);
			oButton.setActiveIcon(sIconHovered);
		},
		addFormClass: function(){ return "sapUiFormM"; },
		bArrowKeySupport: false, /* disables the keyboard support for arrow keys */
		bFinal: true
	});

	//implement FileUploader helper factory with m controls
	jQuery.sap.setObject("sap.ui.unified.FileUploaderHelper", {
		createTextField: function(sId){
			var oTextField = new sap.m.Input(sId);
			return oTextField;
		},
		setTextFieldContent: function(oTextField, sWidth){
			oTextField.setWidth(sWidth);
		},
		createButton: function(){
			var oButton = new sap.m.Button();
			return oButton;
		},
		addFormClass: function(){ return "sapUiFUM"; },
		bFinal: true
	});

	//implement table helper factory with m controls
	//possible is set before layout lib is loaded.
	jQuery.sap.setObject("sap.ui.table.TableHelper", {
		createLabel: function(mConfig){
			return new sap.m.Label(mConfig);
		},
		createTextView: function(mConfig){
			return new sap.m.Label(mConfig);
		},
		createTextField: function(mConfig){
			return new sap.m.Input(mConfig);
		},
		createImage: function(mConfig){
			var oImage = new sap.m.Image(mConfig);
			oImage.setDensityAware(false); // by default we do not have density aware images in the Table
			return oImage;
		},
		addTableClass: function() { return "sapUiTableM"; },
		bFinal: true
	});


	/* Android and Blackberry browsers do not scroll a focused input into the view correctly after resize */
	if (sap.ui.Device.os.blackberry || sap.ui.Device.os.android && sap.ui.Device.os.version >= 4) {
		jQuery(window).on("resize", function(){
			var oActive = document.activeElement;
			var sTagName = oActive ? oActive.tagName : "";
			if (sTagName == "INPUT" || sTagName == "TEXTAREA") {
				window.setTimeout(function(){
					oActive.scrollIntoViewIfNeeded();
				}, 0);
			}
		});
	}

	return sap.m;

});

}; // end of sap/m/library.js
if ( !jQuery.sap.isDeclared('sap.m.routing.Target') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.routing.Target'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.routing.Target'); // unlisted dependency retained
sap.ui.define("sap/m/routing/Target",['sap/ui/core/routing/Target'],
	function(Target) {
		"use strict";

		/**
		 * The mobile extension for targets that target the controls {@link sap.m.SplitContainer} or a {@link sap.m.NavContainer} and all controls extending these.
		 * Other controls are also allowed, but the extra parameters listed below will just be ignored.
		 *
		 * Don't call this constructor directly, use {@link sap.m.Targets} instead, it will create instances of a Target
		 * The parameters you may pass into {@link sap.m.Targets#constructor} are described here.
		 * Please have a look at {@link sap.ui.core.Target#constructor} all values allowed in this constructor will be allowed here, plus the additional parameters listed below:
		 *
		 * @class
		 * @extends sap.ui.core.routing.Target
		 * @private
		 * @alias sap.m.routing.Target
		 */
		return Target.extend("sap.m.routing.Target", /** @lends sap.m.routing.Target.prototype */ {
			constructor : function (oOptions, oViews, oParent, oTargetHandler) {
				this._oTargetHandler = oTargetHandler;

				Target.prototype.constructor.apply(this, arguments);
			},

			_place : function (oParentInfo, vData) {
				var oReturnValue = Target.prototype._place.apply(this, arguments);

				this._oTargetHandler.addNavigation({

					navigationIdentifier : this._oOptions.name,
					transition: this._oOptions.transition,
					transitionParameters: this._oOptions.transitionParameters,
					eventData: vData,
					targetControl: oReturnValue.oTargetControl,
					view: oReturnValue.oTargetParent,
					preservePageInSplitContainer: this._oOptions.preservePageInSplitContainer
				});

				return oReturnValue;

			}
		});

	}, /* bExport= */ true);

}; // end of sap/m/routing/Target.js
if ( !jQuery.sap.isDeclared('sap.m.ActionListItemRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ActionListItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ActionListItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, Renderer) {
	"use strict";


	/**
	 * ActionListItem renderer.
	 * @namespace
	 */
	var ActionListItemRenderer = Renderer.extend(ListItemBaseRenderer);
	
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *          oRenderManager the RenderManager that can be used for writing to the
	 *          Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be
	 *          rendered
	 */
	ActionListItemRenderer.renderLIAttributes = function(rm, oLI) {
		rm.addClass("sapMALI");
	};
	
	ActionListItemRenderer.renderLIContent = function(rm, oLI) {
	
		var isText = oLI.getText();
	
		// List item label
		if (isText) {
			rm.write("<div class='sapMALIText'>");
			rm.writeEscaped(isText);
			rm.write("</div>");
		}
	};

	return ActionListItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ActionListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ActionSelectRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.ActionSelectRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ActionSelectRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './SelectRenderer'],
	function(jQuery, Renderer, SelectRenderer) {
		"use strict";

		var ActionSelectRenderer = Renderer.extend(SelectRenderer);

		/**
		 * CSS class to be applied to the HTML root element of the ActionSelect control.
		 *
		 * @type {string}
		 */
		ActionSelectRenderer.CSS_CLASS = "sapMActionSelect";

		/**
		 * Apply a CSS class to the HTML root element of the ActionSelect control.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oActionSelect An object representation of the control that should be rendered.
		 * @override
		 * @protected
		 */
		ActionSelectRenderer.addStyleClass = function(oRm, oActionSelect) {
			oRm.addClass(ActionSelectRenderer.CSS_CLASS);
		};

		return ActionSelectRenderer;

	}, /* bExport= */ true);

}; // end of sap/m/ActionSelectRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.AppRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.AppRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/AppRenderer",['jquery.sap.global', './NavContainerRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, NavContainerRenderer, Renderer) {
	"use strict";


	/**
	 * App renderer. 
	 * @namespace
	 */
	var AppRenderer = {
	};
	
	var AppRenderer = Renderer.extend(NavContainerRenderer);
	
	AppRenderer.renderAttributes = function(rm, oControl) {
		sap.m.BackgroundHelper.addBackgroundColorStyles(rm, oControl.getBackgroundColor(),  oControl.getBackgroundImage());
	};
	
	AppRenderer.renderBeforeContent = function(rm, oControl) {
		sap.m.BackgroundHelper.renderBackgroundImageTag(rm, oControl, "sapMAppBG",  oControl.getBackgroundImage(), oControl.getBackgroundRepeat(), oControl.getBackgroundOpacity());
	};
	

	return AppRenderer;

}, /* bExport= */ true);

}; // end of sap/m/AppRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.Bar') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.Bar.
jQuery.sap.declare('sap.m.Bar'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/m/Bar",['jquery.sap.global', './BarInPageEnabler', './library', 'sap/ui/core/Control'],
	function(jQuery, BarInPageEnabler, library, Control) {
	"use strict";



	/**
	 * Constructor for a new Bar.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A bar that may be used as a header of a page. It has the capability to center a content like a title, while having few controls on the left and right side.
	 * @extends sap.ui.core.Control
	 * @implements sap.m.IBar
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.Bar
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Bar = Control.extend("sap.m.Bar", /** @lends sap.m.Bar.prototype */ { metadata : {

		interfaces : [
			"sap.m.IBar"
		],
		library : "sap.m",
		properties : {

			/**
			 * If this flag is set to true, contentMiddle will be rendered as a HBox and layoutData can be used to allocate available space
			 * @deprecated Since version 1.16.
			 * This property is no longer supported, instead, contentMiddle will always occupy 100% width when no contentLeft and contentRight are being set.
			 */
			enableFlexBox : {type : "boolean", group : "Misc", defaultValue : false, deprecated: true},

			/**
			 * A boolean value indicating whether the bar is partially translucent.
			 * It is only applied for touch devices.
			 * @since 1.12
			 * @deprecated Since version 1.18.6.
			 * This property has no effect since release 1.18.6 and should not be used. Translucent bar may overlay an input and make it difficult to edit.
			 */
			translucent : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true},

			/**
			 * The design of the bar. If set to auto it is dependent on the place, where the bar is placed.
			 * @since 1.22
			 */
			design : {type : "sap.m.BarDesign", group : "Appearance", defaultValue : sap.m.BarDesign.Auto}
		},
		aggregations : {

			/**
			 * this is the left content area, usually containing a button or an app icon. If this is overlapped by the right content, its content will disappear and text will show an elipsis.
			 */
			contentLeft : {type : "sap.ui.core.Control", multiple : true, singularName : "contentLeft"},

			/**
			 * This is the middle content area. Controls such as label, segmented buttons or select should be placed here. Content that is placed here will be centrally positioned, if there is enough space. If the right or left content overlaps the middle content, the middle content will be centered in the space between the left and the right content.
			 */
			contentMiddle : {type : "sap.ui.core.Control", multiple : true, singularName : "contentMiddle"},

			/**
			 * this is the right content area. Controls such as action buttons or search field could be placed here.
			 */
			contentRight : {type : "sap.ui.core.Control", multiple : true, singularName : "contentRight"}
		}
	}});


	/**
	 * @private
	 */
	Bar.prototype.onBeforeRendering = function() {
		this._removeAllListeners();
	};

	Bar.prototype.onAfterRendering = function() {
		this._handleResize();
	};

	/**
	 * Called when the control is initialized.
	 * @private
	 */
	Bar.prototype.init = function() {
		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};

	/**
	 * Called when the control is destroyed.
	 * Clean up resize listeners and destroy flexbox,
	 * emties cache
	 * @private
	 */
	Bar.prototype.exit = function() {
		this._removeAllListeners();

		if (this._oflexBox) {

			this._oflexBox.destroy();
			this._oflexBox = null;

		}

		this._$MidBarPlaceHolder = null;
		this._$RightBar = null;
		this._$LeftBar = null;
	};

	/**
	 * @private
	 */
	Bar._aResizeHandlers = ["_sResizeListenerId", "_sResizeListenerIdMid", "_sResizeListenerIdRight", "_sResizeListenerIdLeft"];

	/**
	 * removes all resize listeners, that the bar could have registered.
	 * @private
	 */
	Bar.prototype._removeAllListeners = function() {
		var that = this;

		Bar._aResizeHandlers.forEach(function(sItem) {

			that._removeListenerFailsave(sItem);

		});
	};

	/**
	 * Removes a listener with the specified name and sets it to null, if the listener is defined.
	 * @param sListenerName the name of the listener that has to be removed
	 *
	 * @private
	 */
	Bar.prototype._removeListenerFailsave = function(sListenerName) {
		if (this[sListenerName]) {

			sap.ui.core.ResizeHandler.deregister(this[sListenerName]);
			this[sListenerName] = null;

		}
	};

	/**
	 * Invoked, when bar is rerendered, its size changed, or the size of one for the content bars changed.
	 * @private
	 */
	Bar.prototype._handleResize = function() {
		this._removeAllListeners();

		var bContentLeft = !!this.getContentLeft().length,
			bContentMiddle = !!this.getContentMiddle().length,
			bContentRight = !!this.getContentRight().length;

		//Invisible bars also do not need resize listeners
		if (!this.getVisible()) {
			return;
		}

		//No content was set yet - no need to listen to resizes
		if (!bContentLeft && !bContentMiddle && !bContentRight) {
			return;
		}

		this._$LeftBar = this.$("BarLeft");
		this._$RightBar = this.$("BarRight");
		this._$MidBarPlaceHolder = this.$("BarPH");

		this._updatePosition(bContentLeft, bContentMiddle, bContentRight);

		this._sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(), jQuery.proxy(this._handleResize, this));

		if (this.getEnableFlexBox()) {
			return;
		}

		if (bContentLeft) {
			this._sResizeListenerIdLeft = sap.ui.core.ResizeHandler.register(this._$LeftBar[0], jQuery.proxy(this._handleResize, this));
		}

		if (bContentMiddle) {
			this._sResizeListenerIdMid = sap.ui.core.ResizeHandler.register(this._$MidBarPlaceHolder[0], jQuery.proxy(this._handleResize, this));
		}

		if (bContentRight) {
			this._sResizeListenerIdRight = sap.ui.core.ResizeHandler.register(this._$RightBar[0], jQuery.proxy(this._handleResize, this));
		}
	};

	/**
	 * Repositions the bar.
	 * If there is only one aggregation filled, this aggregation will take 100% of the bars space.
	 * @param bContentLeft indicates if there is left content in the bar
	 * @param bContentMiddle indicates if there is middle content in the bar
	 * @param bContentRight indicates if there is right content in the bar
	 * @private
	 */
	Bar.prototype._updatePosition = function(bContentLeft, bContentMiddle, bContentRight) {

		if (!bContentLeft && !bContentRight) {

			this._$MidBarPlaceHolder.css({ width : '100%'});
			return;

		}

		if (bContentLeft && !bContentMiddle && !bContentRight) {

			this._$LeftBar.css({ width : '100%'});
			return;

		}

		if (!bContentLeft && !bContentMiddle && bContentRight) {

			this._$RightBar.css({ width : '100%'});
			return;

		}

		var iBarWidth = this.$().outerWidth(true);

		// reset to default
		this._$RightBar.css({ width : "" });
		this._$LeftBar.css({ width : "" });
		this._$MidBarPlaceHolder.css({ position : "", width : "", visibility : 'hidden' });

		var iRightBarWidth = this._$RightBar.outerWidth(true);

		//right bar is bigger than the bar - only show the right bar
		if (iRightBarWidth > iBarWidth) {

			if (bContentLeft) {
				this._$LeftBar.css({ width : "0px" });
			}

			if (bContentMiddle) {
				this._$MidBarPlaceHolder.css({ width : "0px" });
			}

			this._$RightBar.css({ width : iBarWidth + "px"});
			return;

		}

		var iLeftBarWidth = this._getBarContainerWidth(this._$LeftBar);

		// handle the case when left and right content are wider than the bar itself
		if (iBarWidth < (iLeftBarWidth + iRightBarWidth)) {

			// this scenario happens mostly when a very long title text is set in the left content area
			// hence we make sure the rightContent always has enough space and reduce the left content area width accordingly
			iLeftBarWidth = iBarWidth - iRightBarWidth;

			this._$LeftBar.width(iLeftBarWidth);
			this._$MidBarPlaceHolder.width(0);
			return;

		}

		//middle bar will be shown
		this._$MidBarPlaceHolder.css(this._getMidBarCss(iRightBarWidth, iBarWidth, iLeftBarWidth));

	};

	/**
	 * Returns the css for the contentMiddle aggregation. It is centered if there is enough space for it to fit between the left and right content.
	 * If not it will be centered between those two.
	 * @param iRightBarWidth the width in pixel
	 * @param iBarWidth the width in pixel
	 * @param iLeftBarWidth the width in pixel
	 * @returns {object} the new _$MidBarPlaceHolder css value
	 * @private
	 */
	Bar.prototype._getMidBarCss = function(iRightBarWidth, iBarWidth, iLeftBarWidth) {
		var iMidBarPlaceholderWidth = this._$MidBarPlaceHolder.outerWidth(true),
			bRtl = sap.ui.getCore().getConfiguration().getRTL(),
			sLeftOrRight = bRtl ? "right" : "left",
			oMidBarCss = { visibility : "" };

		if (this.getEnableFlexBox()) {

			iMidBarPlaceholderWidth = iBarWidth - iLeftBarWidth - iRightBarWidth - parseInt(this._$MidBarPlaceHolder.css('margin-left'), 10) - parseInt(this._$MidBarPlaceHolder.css('margin-right'), 10);

			oMidBarCss.position = "absolute";
			oMidBarCss.width = iMidBarPlaceholderWidth + "px";
			oMidBarCss[sLeftOrRight] = iLeftBarWidth;

			//calculation for flex is done
			return oMidBarCss;

		}

		var iSpaceBetweenLeftAndRight = iBarWidth - iLeftBarWidth - iRightBarWidth,

			iMidBarStartingPoint = (iBarWidth / 2) - (iMidBarPlaceholderWidth / 2),
			bLeftContentIsOverlapping = iLeftBarWidth > iMidBarStartingPoint,

			iMidBarEndPoint = (iBarWidth / 2) + (iMidBarPlaceholderWidth / 2),
			bRightContentIsOverlapping = (iBarWidth - iRightBarWidth) < iMidBarEndPoint;

		if (iSpaceBetweenLeftAndRight > 0 && (bLeftContentIsOverlapping || bRightContentIsOverlapping)) {

			//Left or Right content is overlapping the Middle content

			// place the middle positioned element directly next to the end of left content area
			oMidBarCss.position = "absolute";

			//Use the remaining space
			oMidBarCss.width = iSpaceBetweenLeftAndRight + "px";

			oMidBarCss.left = bRtl ? iRightBarWidth : iLeftBarWidth;
		}

		return oMidBarCss;

	};

	/**
	 * Gets the width of a container.
	 * @static
	 * @param $Container a container with children
	 * @returns {number} the width of one of the bar containers
	 * @private
	 */
	Bar.prototype._getBarContainerWidth = function($Container) {
		var i,
			iContainerWidth = 0,
			aContainerChildren = $Container.children(),
			iContainerChildrenTotalWidth = 0;

		// Chrome browser has a problem in providing the correct div size when image inside does not have width explicitly set
		//since ff version 24 the calculation is correct, since we don't support older versions we won't check it
		if (sap.ui.Device.browser.webkit || sap.ui.Device.browser.firefox) {

			for (i = 0; i < aContainerChildren.length; i++) {

				iContainerChildrenTotalWidth += jQuery(aContainerChildren[i]).outerWidth(true);

			}

			iContainerWidth = $Container.outerWidth(true);

		} else {

			// IE has a rounding issue with JQuery.outerWidth
			var oContainerChildrenStyle;

			for (i = 0; i < aContainerChildren.length; i++) {

				oContainerChildrenStyle = window.getComputedStyle(aContainerChildren[i]);

				if (oContainerChildrenStyle.width == "auto") {

					iContainerChildrenTotalWidth += jQuery(aContainerChildren[i]).width() + 1; //add an additional 1 pixel because of rounding issue.

				} else {

					iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.width);

				}

				iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.marginLeft);
				iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.marginRight);
				iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.paddingLeft);
				iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.paddingRight);
			}

			var oContainerComputedStyle = window.getComputedStyle($Container[0]);

			iContainerWidth += parseFloat(oContainerComputedStyle.width);
			iContainerWidth += parseFloat(oContainerComputedStyle.marginLeft);
			iContainerWidth += parseFloat(oContainerComputedStyle.marginRight);
			iContainerWidth += parseFloat(oContainerComputedStyle.paddingLeft);
			iContainerWidth += parseFloat(oContainerComputedStyle.paddingRight);

		}

		if (iContainerWidth < iContainerChildrenTotalWidth) {

			iContainerWidth = iContainerChildrenTotalWidth;

		}

		return iContainerWidth;
	};

	/////////////////
	//Bar in page delegation
	/////////////////
	/**
	 * Determines whether the bar is sensitive to the container context.
	 *
	 * Implementation of the IBar interface.
	 * @returns {boolean} isContextSensitive
	 * @protected
	 */
	Bar.prototype.isContextSensitive = BarInPageEnabler.prototype.isContextSensitive;

	/**
	 * Sets the HTML tag of the root element.
	 * @param {sap.m.IBarHTMLTag} sTag
	 * @returns {sap.m.IBar} this for chaining
	 * @protected
	 */
	Bar.prototype.setHTMLTag = BarInPageEnabler.prototype.setHTMLTag;
	/**
	 * Gets the HTML tag of the root element.
	 * @returns {sap.m.IBarHTMLTag} the HTML-tag
	 * @protected
	 */
	Bar.prototype.getHTMLTag  = BarInPageEnabler.prototype.getHTMLTag;

	/**
	 * Sets classes and tag according to the context in the page. Possible contexts are header, footer, subheader.
	 * @returns {sap.m.IBar} this for chaining
	 * @protected
	 */
	Bar.prototype.applyTagAndContextClassFor  = BarInPageEnabler.prototype.applyTagAndContextClassFor;

	return Bar;

}, /* bExport= */ true);

}; // end of sap/m/Bar.js
if ( !jQuery.sap.isDeclared('sap.m.BusyDialog') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.BusyDialog.
jQuery.sap.declare('sap.m.BusyDialog'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/m/BusyDialog",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/Popup', 'sap/ui/core/theming/Parameters'],
	function(jQuery, library, Control, Popup, Parameters) {
	"use strict";


	
	/**
	 * Constructor for a new BusyDialog.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Busy Dialog is used to indicate that the system is busy with some task and the user has to wait. During this time the UI is blocked.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.BusyDialog
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var BusyDialog = Control.extend("sap.m.BusyDialog", /** @lends sap.m.BusyDialog.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {
	
			/**
			 * Optional text shown inside the popup.
			 */
			text : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * Sets a title to the busy dialog. Default is no title.
			 */
			title : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * Icon that is displayed in the dialog header. This icon is invisible in iOS platform and it's density aware that you can use the density convention (@2, @1.5, etc.) to provide higher resolution image for higher density screen.
			 */
			customIcon : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
	
			/**
			 * Defines the rotation speed of the given image. If a gif is used, the speed has to be set to 0. The unit is in ms.
			 */
			customIconRotationSpeed : {type : "int", group : "Appearance", defaultValue : 1000},
	
			/**
			 * If this is set to false, the src image will be loaded directly without attempting to fetch the density perfect image for high density device.
			 * 
			 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
			 * 
			 * If bandwidth is the key for the application, set this value to false.
			 */
			customIconDensityAware : {type : "boolean", defaultValue : true},
	
			/**
			 * Width of the provided icon. By default 44px are used.
			 */
			customIconWidth : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : "30px"},
	
			/**
			 * Height of the provided icon. By default 44px are used.
			 */
			customIconHeight : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : "44px"},
	
			/**
			 * The text of the cancel button. The default text is "Cancel" (translated to the respective language).
			 */
			cancelButtonText : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * A cancel button will be rendered inside the busy dialog if this property is set to true.
			 */
			showCancelButton : {type : "boolean", group : "Appearance", defaultValue : false}
		},
		aggregations : {
	
			/**
			 * The hidden aggregation for internal maintained label.
			 */
			_busyLabel : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}, 
	
			/**
			 * The hidden aggregation for internal maintained busyIndicator.
			 */
			_busyIndicator : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}, 
	
			/**
			 * The hidden aggregation for internal maintained toolbar which contains the cancel button.
			 */
			_toolbar : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}, 
	
			/**
			 * The hidden aggregation for internal maintained button.
			 */
			_cancelButton : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}
		},
		events : {
	
			/**
			 * This event will be fired when the busy dialog is closed.
			 */
			close : {
				parameters : {
	
					/**
					 * this parameter is for an app to differ for a "close" event if it was fired because user pressed cancel button or because the operation was terminated.
					 * This parameter is set to true if the close event is fired by user interaction.
					 */
					cancelPressed : {type : "boolean"}
				}
			}
		}
	}});
	
	
	BusyDialog.prototype.init = function(){
		var that = this;
		this._$window = jQuery(window);
	
		this._busyIndicator = new sap.m.BusyIndicator(this.getId() + '-busyInd', {visible: false}).addStyleClass('sapMBsyInd');
		this.setAggregation("_busyIndicator", this._busyIndicator, true);
		
		this.iOldWinHeight = 0;
		this._oPopup = new Popup();
		this._oPopup.setShadow(false);
		this._oPopup.setModal(true, 'sapMDialogBLyInit');
		this._oPopup.setAnimations(this.openAnimation, this.closeAnimation);
		this._oPopup.setInitialFocusId(this.getId());
	
		//the orientationchange event listener
		this._fOrientationChange = jQuery.proxy(this._reposition, this);
		
		this._oPopup._applyPosition = function(oPosition){
			that._setDimensions();
			Popup.prototype._applyPosition.call(this, oPosition);
		};
		this._oPopup._showBlockLayer = function(){
			Popup.prototype._showBlockLayer.call(this);
			var $BlockRef = jQuery("#sap-ui-blocklayer-popup");
			$BlockRef.toggleClass("sapMDialogBLyInit", true);
		};
		this._oPopup._hideBlockLayer = function(){
			var $BlockRef = jQuery("#sap-ui-blocklayer-popup");
			var $BlockBarRef = jQuery("#sap-ui-blocklayer-popup-bar");//$BlockRef.next('div');
			/*$BlockRef.one("webkitTransitionEnd", function(){*/
				$BlockBarRef.css({'visibility': '', 'display': 'none'});
				$BlockRef.toggleClass('sapMDialogBLyInit', false);
				$BlockRef.css("top", "");
				Popup.prototype._hideBlockLayer.call(this);
			/*});*/
			/*$BlockRef.toggleClass('sapMDialogBLyShown', false);*/
			
		};
		//keyboard support for desktop environments
		if (sap.ui.Device.system.desktop) {
			var fnOnEscape = jQuery.proxy(function(oEvent) {
					this.close(true);
					//event should not trigger any further actions
					oEvent.stopPropagation();
			}, this);
			//use pseudo event 'onsapescape' to implement keyboard-trigger for closing this dialog
			this._oPopup.onsapescape = fnOnEscape;
		}
	};
	
	BusyDialog.prototype.openAnimation = function($Ref, iRealDuration, fnOpened) {
		fnOpened();
	};
	
	BusyDialog.prototype.closeAnimation = function($Ref, iRealDuration, fnClose) {
		fnClose();
	};
	
	/**
	 * Destroys the dialog control
	 * @private
	 */
	BusyDialog.prototype.exit = function(){
		this._oPopup.close();
		this._oPopup.destroy();
		this._oPopup = null;
		
		this._$window.unbind("resize", this._fOrientationChange);
	};
	
	/**
	 * Opens the busy popup.
	 *
	 * @type sap.m.BusyDialog
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	BusyDialog.prototype.open = function(){
		jQuery.sap.log.debug("sap.m.BusyDialog.open called at " + new Date().getTime());
		
		var oPopup = this._oPopup;
		if (oPopup.isOpen()) {
			return this;
		}
		// Open popup
		oPopup.setContent(this);
		oPopup.attachOpened(this._handleOpened, this);
		oPopup.setPosition("center center", "center center", document, "0 0", "fit");
	
		this._bOpenRequested = true;
		this._openNowIfPossibleAndRequested();
	
		return this;
	};
	
	
	BusyDialog.prototype._openNowIfPossibleAndRequested = function(){
		if (!this._bOpenRequested) {
			return;
		}
		
		// If body/Core are not available yet, give them some more time and open later if still required
		if (!document.body || !sap.ui.getCore().isInitialized()) {
			jQuery.sap.delayedCall(50, this, "_openNowIfPossibleAndRequested");
			return;
		}
		
		this._bOpenRequested = false; // opening request is handled
		this._oPopup.open();
	};
	
	/**
	 * Close the busy popup.
	 *
	 * @type sap.m.BusyDialog
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	BusyDialog.prototype.close = function(bFromCancelButton){
		this._bOpenRequested = false;
		var oPopup = this._oPopup;
	
		var eOpenState = this._oPopup.getOpenState();
		if (!(eOpenState === sap.ui.core.OpenState.CLOSED || eOpenState === sap.ui.core.OpenState.CLOSING)) {
			oPopup.attachClosed(this._handleClosed, this);
			jQuery.sap.log.debug("sap.m.BusyDialog.close called at " + new Date().getTime());
			oPopup.close();
			// stop busy indicator
			this._busyIndicator.setVisible(false);

			this.fireClose({
				cancelPressed: !!bFromCancelButton
			});
		}
		return this;
	};
	
	BusyDialog.prototype.setText = function(sText){
		this.setProperty("text", sText, true);
		if (!this._oLabel) {
			this._oLabel = new sap.m.Label(this.getId() + "-busyLabel", {}).addStyleClass("sapMBusyDialogLabel");
			this.setAggregation("_busyLabel", this._oLabel, true);
		}
		this._oLabel.setText(sText);
		return this;
	};
	
	BusyDialog.prototype.setCustomIcon = function(oIcon){
		this.setProperty("customIcon", oIcon, true);
		this._busyIndicator.setCustomIcon(oIcon);
		return this;
	};
	
	BusyDialog.prototype.setCustomIconRotationSpeed = function(iSpeed){
		this.setProperty("customIconRotationSpeed", iSpeed, true);
		this._busyIndicator.setCustomIconRotationSpeed(iSpeed);
		return this;
	};
	
	BusyDialog.prototype.setCustomIconDensityAware = function(bAware){
		this.setProperty("customIconDensityAware", bAware, true);
		this._busyIndicator.setCustomIconDensityAware(bAware);
		return this;
	};
	
	BusyDialog.prototype.setCustomIconWidth = function(sWidth){
		this.setProperty("customIconWidth", sWidth, true);
		this._busyIndicator.setCustomIconWidth(sWidth);
		return this;
	};
	
	BusyDialog.prototype.setCustomIconHeight = function(sHeight){
		this.setProperty("customIconHeight", sHeight, true);
		this._busyIndicator.setCustomIconHeight(sHeight);
		return this;
	};
	
	BusyDialog.prototype.setShowCancelButton = function(bShow){
		this.setProperty("showCancelButton", bShow, false);
		if (bShow) {
			this._createCancelButton();
		}
		return this;
	};
	
	BusyDialog.prototype.setCancelButtonText = function(sText){
		this.setProperty("cancelButtonText", sText, true);
		this._createCancelButton();
		this._oButton.setText(sText);
		return this;
	};
	
	BusyDialog.prototype._createCancelButton = function(){
		if (!this._oButton) {
			var that = this;
			var sButtonText = (this.getCancelButtonText()) ? this.getCancelButtonText() : sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("BUSYDIALOG_CANCELBUTTON_TEXT");
	
			this._oButton = new sap.m.Button(this.getId() + 'busyCancelBtn', {
					text: sButtonText,
					type: sap.m.ButtonType.Transparent,
					press : function() {
						that.close(true);
					}
			}).addStyleClass("sapMDialogBtn");
	
			if (sap.ui.Device.system.phone) {
				this._oButton.addStyleClass("sapMDialogBtnPhone");
				this.setAggregation("_cancelButton", this._oButton, true);
			} else {
				this._oButtonToolBar = new sap.m.Toolbar(this.getId() + "-toolbar", {
					content: [
						new sap.m.ToolbarSpacer(this.getId() + "-toolbarspacer"),
						this._oButton
					]
				}).addStyleClass("sapMTBNoBorders").addStyleClass("sapMBusyDialogFooter").applyTagAndContextClassFor("footer");
				this.setAggregation("_toolbar", this._oButtonToolBar, true);
			}
		}
	};
	
	BusyDialog.prototype._reposition = function() {
		var ePopupState = this._oPopup.getOpenState();
		if (!(ePopupState === sap.ui.core.OpenState.OPEN)) {
			return;
		}
		this._oPopup._applyPosition(this._oPopup._oLastPosition);
		
	};
	
	BusyDialog.prototype._handleOpened = function(){
		this._oPopup.detachOpened(this._handleOpened, this);
		// start busy indicator
		this._busyIndicator.setVisible(true);
		// bind to window resize
		// In android, the orientationchange fires before the size of the window changes
		//  that's why the resize event is used here.
		this._$window.bind("resize", this._fOrientationChange);
	};
	
	BusyDialog.prototype._handleClosed = function(){
		this._oPopup.detachClosed(this._handleClosed, this);
		this._$window.unbind("resize", this._fOrientationChange);
	};
	
	BusyDialog.prototype._setDimensions = function() {
		// Derive width and height from viewport
		var iWindowHeight =  this._$window.height();
		var $this = this.$();
		//reset
		$this.css({
			"left": "0px",
			"top": "0px",
			"max-height": this._$window.height() + "px"
		});
		if (iWindowHeight <= this.iOldWinHeight) {
			if (!this.$().hasClass("sapMBsyDSmall")) {
				this._checkSize(iWindowHeight);
			}
		}
		if (iWindowHeight > this.iOldWinHeight) {
			if ((this.$().hasClass("sapMBsyDSmall"))) {
				this._checkSize(iWindowHeight);
			}
		}
		if (this.iOldWinHeight == 0) {
			this._checkSize(iWindowHeight);
		}
		this.iOldWinHeight = this._$window.height();
	};
	
	BusyDialog.prototype._checkSize = function(iWindowHeight) {
		if (iWindowHeight < this.$()[0].scrollHeight) {
			this.$().toggleClass("sapMBsyDSmall", true);
		} else {
			this.$().toggleClass("sapMBsyDSmall", false);
			this.$().css("width", "18.75em");
		}
	};
	

	return BusyDialog;

}, /* bExport= */ true);

}; // end of sap/m/BusyDialog.js
if ( !jQuery.sap.isDeclared('sap.m.BusyIndicator') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.BusyIndicator.
jQuery.sap.declare('sap.m.BusyIndicator'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/m/BusyIndicator",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/theming/Parameters'],
	function(jQuery, library, Control, Parameters) {
	"use strict";


	
	/**
	 * Constructor for a new BusyIndicator.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Control to indicate that the system is busy with some task and the user has to wait.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.BusyIndicator
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var BusyIndicator = Control.extend("sap.m.BusyIndicator", /** @lends sap.m.BusyIndicator.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {
	
			/**
			 * Defines the text displayed next to the busy indicator (optional)
			 */
			text : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction from its parent container.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
	
			/**
			 * Set to false to make the control invisible.
			 */
			visible : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * Icon URL if an icon is used as the busy indicator.
			 */
			customIcon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * Defines the rotation speed of the given image. If a .gif is used, the speed has to be set to 0. The unit is in ms.
			 */
			customIconRotationSpeed : {type : "int", group : "Appearance", defaultValue : 1000},
	
			/**
			 * If this is set to false, the src image will be loaded directly without attempting to fetch the density perfect image for high density device.
			 * 
			 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
			 * 
			 * If bandwidth is the key for the application, set this value to false.
			 */
			customIconDensityAware : {type : "boolean", defaultValue : true},
	
			/**
			 * Width of the provided icon. By default 44px are used.
			 */
			customIconWidth : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : "44px"},
	
			/**
			 * Height of the provided icon. By default 44px are used.
			 */
			customIconHeight : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : "44px"},
	
			/**
			 * Defines the size of the busy indicator.
			 */
			size : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},
	
			/**
			 * The design defines how the BusyIndicator should look like. There are 3 possibilities:
			 * auto: automatically sets the design according to the context
			 * dark: dark theme, useful within a light context
			 * light: light theme, useful within a dark context
			 */
			design : {type : "string", group : "Appearance", defaultValue : 'auto'}
		},
		associations: {
			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 * @since 1.27.0
			 */
			ariaLabelledBy: { type: "sap.ui.core.Control", multiple: true, singularName: "ariaLabelledBy" }
		},
		aggregations : {
	
			/**
			 * The hidden aggregation for internal maintained icon image.
			 */
			_iconImage : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}, 
	
			/**
			 * The hidden aggregation for internal maintained busy label.
			 */
			_busyLabel : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}
		}
	}});
	
	
	BusyIndicator.prototype.init = function(){
		// Blue crystal design: rotating arc
		// bugs.webkit.org: id=82647, id=74801 dynamically created SVG does not animate
		// do not use SVG in ios and android < 4.2 
		if (sap.ui.Device.browser.chrome
				|| sap.ui.Device.os.blackberry
				|| sap.ui.Device.os.android && sap.ui.Device.os.version > 4.1) {
			// Browsers with correct SMIL animation show SVG (crisp rendering)
			this._bUseSvg = true;
		} else {
			// Fall-back for other browsers: show canvas animation (aliased rendering)
			this._bUseCanvas = true;
		}
	
		this._sBColor = Parameters.get("sapUiPageBG") || "rgba(0, 0, 0, 0)";
	};
	
	BusyIndicator.prototype.exit = function(){
		this._cancelAnimation();
	};
	
	// Request canvas animation
	if (window.requestAnimationFrame) {
		BusyIndicator.prototype._requestAnimation = function(fCallback){
			return window.requestAnimationFrame(fCallback);
		};
	} else if (window.webkitRequestAnimationFrame) {
		BusyIndicator.prototype._requestAnimation = function(fCallback, oDOM){
			return window.webkitRequestAnimationFrame(fCallback, oDOM);
		};
	} else if (window.mozRequestAnimationFrame) {
		BusyIndicator.prototype._requestAnimation = function(fCallback){
			return window.mozRequestAnimationFrame(fCallback);
		};
	} else {
		BusyIndicator.prototype._requestAnimation = function(fCallback){
			return window.setTimeout(fCallback, 1000 / 60);
		};
	}
	
	// Stop canvas animation
	BusyIndicator.prototype._cancelAnimation = function(){
		if (!this._animationId) { return;}
	
		if (window.cancelAnimationFrame) {
			window.cancelAnimationFrame(this._animationId);
		} else if (window.webkitCancelAnimationFrame) {
			window.webkitCancelAnimationFrame(this._animationId);
		} else if (window.mozCancelAnimationFrame) {
			window.mozCancelAnimationFrame(this._animationId);
		} else {
			window.clearTimeout(this._animationId);
		}
		this._animationId = undefined;
	};
	
	// Do the next animation step
	BusyIndicator.prototype._animateCanvas = function(){
		if (!this.oCanvas) { return; }
	
		var clientWidth = this.oCanvas.clientWidth,
			clientHeight = this.oCanvas.clientHeight;
	
		if (!this.getVisible() || !clientWidth || !clientHeight) {
				// if the indicator becomes invisible, client width and height are set to 0.
				// Stop animation
				this._animationId = undefined;
				return;
		}
	
		// Adjust the canvas size to avoid aliasing artifacts
		// This is needed only once after first rendering and only for custom size
		if (clientWidth != this.oCanvas.width) {
			this.oCanvas.setAttribute("width", clientWidth);
		}
		if (clientHeight != this.oCanvas.height) {
			this.oCanvas.setAttribute("height", clientHeight);
		}
	
		var context = this.oCanvas.getContext("2d"),
			w = this.oCanvas.width,
			h = this.oCanvas.height,
			x = Math.round(w / 2),
			y = Math.round(h / 2),
			r = Math.round(x * 0.7),
			t = new Date(),
			startAngle = 0.9 * (t.getSeconds() + t.getMilliseconds() / 1000) * 2 * Math.PI,
			endAngle = startAngle + 1.25 * Math.PI, // 225 grad
			counterClock = false,
			strokeStyle = window.getComputedStyle(this.oCanvas).color,
			lineWidth = Math.round(w / 10) * 2;
	
		context.clearRect(0,0,w,h);
	
		// clearRect does not clear canvas in Android browser 4.1,
		// workaround: draw a white circle underneath
		if (sap.ui.Device.os.android && sap.ui.Device.os.version == 4.1 && !sap.ui.Device.browser.chrome) {
			context.strokeStyle = this._sBColor;
			context.lineWidth = lineWidth + 2;
			context.beginPath();
			context.arc(x, y, r, 0, 2 * Math.PI);
			context.stroke();
		}
	
		context.strokeStyle = strokeStyle;
		context.lineWidth = lineWidth;
		context.beginPath();
		context.arc(x, y, r, startAngle, endAngle, counterClock);
		context.stroke();
	
		this._animationId = this._requestAnimation(this._fAnimateCallback, this.oCanvas);
	};
	
	// Start the canvas based animation
	BusyIndicator.prototype._doCanvas = function(){
		this.oCanvas = this.getDomRef("canvas");
		this._fAnimateCallback = jQuery.proxy(this._animateCanvas, this);
		this._animationId = this._requestAnimation(this._fAnimateCallback, this.oCanvas);
	};
	
	// Start/stop SVG animation
	// Though SVG animates itself, stop it when invisible to avoid unneeded layer updates
	BusyIndicator.prototype._setSvg = function(){
		var oSvg = this.getDomRef("svg");
		if (oSvg) {
			if ( this.getVisible() ) {
				oSvg.unpauseAnimations();
			} else {
				oSvg.pauseAnimations();
			}
		}
	};
	
	// Create internal icon image
	BusyIndicator.prototype._createCustomIcon = function(sName, sValue){
		var that = this;
		if (!this._iconImage) {
			this._iconImage = new sap.m.Image(this.getId() + "-icon", {
					width: "44px",
					height: "44px"
				}).addStyleClass('sapMBsyIndIcon');
			this._iconImage.addDelegate({onAfterRendering : function() {
					that._setRotationSpeed();
				}
			});
			this.setAggregation("_iconImage", this._iconImage, true);
		}
		this._iconImage[sName](sValue);
		this._setRotationSpeed();
	};
	
	// Create internal label
	BusyIndicator.prototype._createLabel = function(sName, sValue){
		if (!this._oLabel) {
			this._oLabel = new sap.m.Label(this.getId() + "-label", {labelFor: this.getId()}).addStyleClass("sapMBsyIndLabel");
			this.setAggregation("_busyLabel", this._oLabel);
		}
		this._oLabel[sName](sValue);
	};
	
	// Set the rotation speed of the image
	BusyIndicator.prototype._setRotationSpeed = function(){
	
		if (!this._iconImage) {
			return;
		}
	
		if (jQuery.support.cssAnimations) {
			var $icon = this._iconImage.$();
			var sRotationSpeed = this.getCustomIconRotationSpeed() + "ms";
			$icon.css("-webkit-animation-duration", sRotationSpeed)
				.css("animation-duration", sRotationSpeed);
			//Bug in Chrome: After changing height of image -> changing the rotationspeed will have no affect
			//chrome needs a rerendering of this element.
			$icon.css("display", "none");
			setTimeout(function() {
				$icon.css("display", "inline");
			}, 0);
		} else { // IE9
			this._rotateCustomIcon();
		}
	};
	
	//Animate custom icon in IE9
	BusyIndicator.prototype._rotateCustomIcon = function(){
	
		if (!this._iconImage) {
			return;
		}
		var $icon = this._iconImage.$();
	
		// stop if the custom icon is not available or hidden:
		if (!$icon[0] || !$icon[0].offsetWidth) {
			return;
		}
	
		var iRotationSpeed = this.getCustomIconRotationSpeed();
		if (!iRotationSpeed) {
			return;
		}
	
		if (!this._fnRotateCustomIcon) {
			this._fnRotateCustomIcon = jQuery.proxy(this._rotateCustomIcon, this);
		}
		var fnRotateCustomIcon = this._fnRotateCustomIcon;
	
		if (!this._$CustomRotator) {
			this._$CustomRotator = jQuery({deg: 0});
		}
		var $rotator = this._$CustomRotator;
	
		if ($rotator.running) {
			return;
		}
	
		// restart animation
		$rotator[0].deg = 0;
	
		$rotator.animate({deg: 360}, {
			duration: iRotationSpeed,
			easing: "linear",
			step: function(now) {
				$rotator.running = true;
				$icon.css("-ms-transform", 'rotate(' + now + 'deg)');
			},
			complete: function(){
				$rotator.running = false;
				window.setTimeout(fnRotateCustomIcon, 10);
			}
		});
	};
	
	BusyIndicator.prototype.onBeforeRendering = function(){
		this._cancelAnimation();
	};
	
	BusyIndicator.prototype.onAfterRendering = function(){
		// SVG animates itself, canvas animates by JavaScript:
		if (this._bUseCanvas) {
			this._doCanvas();
		} else {
			this._setSvg();
		}
	};
	
	BusyIndicator.prototype.setText = function(sText){
		this.setProperty("text", sText, true);
		this._createLabel("setText", sText);
		return this;
	};
	
	BusyIndicator.prototype.setTextDirection = function(sDirection){
		this.setProperty("textDirection", sDirection, true);
		this._createLabel("setTextDirection", sDirection);
		return this;
	};
	
	BusyIndicator.prototype.setCustomIcon = function(iSrc){
		this.setProperty("customIcon", iSrc, false);
		this._createCustomIcon("setSrc", iSrc);
		return this;
	};
	
	BusyIndicator.prototype.setCustomIconRotationSpeed = function(iSpeed){
		if (isNaN(iSpeed) || iSpeed < 0) {
			iSpeed = 0;
		}
		if (iSpeed !== this.getCustomIconRotationSpeed()) {
			this.setProperty("customIconRotationSpeed", iSpeed, true);
			this._setRotationSpeed();
		}
		return this;
	};
	
	BusyIndicator.prototype.setCustomIconDensityAware = function(bAware){
		this.setProperty("customIconDensityAware", bAware, true);
		this._createCustomIcon("setDensityAware", bAware);
		return this;
	};
	
	BusyIndicator.prototype.setCustomIconWidth = function(sWidth){
		this.setProperty("customIconWidth", sWidth, true);
		this._createCustomIcon("setWidth", sWidth);
		return this;
	};
	
	BusyIndicator.prototype.setCustomIconHeight = function(sHeight){
		this.setProperty("customIconHeight", sHeight, true);
		this._createCustomIcon("setHeight", sHeight);
		return this;
	};
	
	BusyIndicator.prototype.setDesign = function(sDesign) {
		this.setProperty("design", sDesign, true);
		this.$().toggleClass("sapMBusyIndicatorLight", (this.getDesign() === "light"));
		this.$().toggleClass("sapMBusyIndicatorDark", (this.getDesign() === "dark"));
		return this;
	};
	
	/**
	 * Setter for property <code>visible</code>.
	 *
	 * Default value is <code>true</code>
	 *
	 * The default implementation of the "setVisible" function is enhanced 
	 * in order to toggle the "visibility:hidden;" attribute over the control.
	 *
	 * @param {boolean} bVisible  new value for property <code>visible</code>
	 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
	 * @public
	 */
	BusyIndicator.prototype.setVisible = function(bVisible){
		var oDomRef = this.getDomRef();
		//only suppress rerendering when it's already rendered
		this.setProperty("visible", bVisible, !!oDomRef);
		
		if (oDomRef) {
			this.getDomRef().style.visibility = bVisible ? "visible" : "hidden";
			if (this._bUseCanvas) {
				if (bVisible && !this._animationId) {
					this._animateCanvas();
				}
			} else {
				this._setSvg();
			}
		}
		
		return this;
	};
	

	return BusyIndicator;

}, /* bExport= */ true);

}; // end of sap/m/BusyIndicator.js
if ( !jQuery.sap.isDeclared('sap.m.Button') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.Button.
jQuery.sap.declare('sap.m.Button'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/m/Button",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/EnabledPropagator', 'sap/ui/core/IconPool', 'sap/ui/core/theming/Parameters'],
	function(jQuery, library, Control, EnabledPropagator, IconPool, Parameters) {
	"use strict";

	/**
	 * Constructor for a new Button.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Enables users to trigger actions. For the button UI, you can define some text or an icon, or both.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.Button
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Button = Control.extend("sap.m.Button", /** @lends sap.m.Button.prototype */ { metadata : {

		library : "sap.m",
		properties : {

			/**
			 * Button text
			 */
			text : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Type of a button (e.g. Default, Accept, Reject, Back, etc.)
			 */
			type : {type : "sap.m.ButtonType", group : "Appearance", defaultValue : sap.m.ButtonType.Default},

			/**
			 * Defines the width of the button.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},

			/**
			 * Boolean property to enable the control (default is true). Buttons that are disabled have other colors than enabled ones, depending on custom settings
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Icon to be displayed as graphical element within the button. This can be an image or an icon from the icon font.
			 */
			icon : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},

			/**
			 * If set to true (default), the display sequence is 1. icon 2. control text
			 */
			iconFirst : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * The source property when this icon is tapped. Graphical element is changed to the new source as long as the icon is tapped.
			 */
			activeIcon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},

			/**
			 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
			 *
			 * If only one version of image is provided, set this value to false to avoid the attempt of fetching density perfect image.
			 */
			iconDensityAware : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * This property specifies the element's text directionality with enumerated options. By default, the control inherits text direction from the DOM.
			 * @since 1.28.0
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit}
		},
		associations : {

			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"},

			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
		},
		events : {

			/**
			 * Event is fired when the user taps the control.
			 * @deprecated Since version 1.20.0.
			 * This event is deprecated, use the press event instead.
			 */
			tap : {deprecated: true},

			/**
			 * Event is fired when the user clicks on the control.
			 */
			press : {}
		}
	}});

	EnabledPropagator.call(Button.prototype);

	/**
	 * Function is called when exiting the control.
	 *
	 * @private
	 */
	Button.prototype.exit = function() {

		// destroy image controls if initialized
		if (this._image) {
			this._image.destroy();
		}

		if (this._iconBtn) {
			this._iconBtn.destroy();
		}
	};

	/**
	 * Function is called when touchstart occurs on button .
	 * @param {jQuery.Event} oEvent - the touch event.
	 * @private
	 */
	Button.prototype.ontouchstart = function(oEvent) {

		// mark the event for components that needs to know if the event was handled by the button
		oEvent.setMarked();

		// change the source only when the first finger is on the control, the
		// following fingers doesn't affect
		if (oEvent.targetTouches.length === 1) {

			// set active button state
			this._activeButton();

			// set target which started the event
			this._target = oEvent.target;
		}
	};

	/**
	 * Function is called when touchend occurs on button .
	 * @param {jQuery.Event} oEvent - the touch event.
	 * @private
	 */
	Button.prototype.ontouchend = function() {

		// set inactive button state
		this._inactiveButton();
	};

	/**
	 * Function is called when touchcancel occurs .
	 * @param {jQuery.Event} oEvent - the touch event.
	 * @private
	 */
	Button.prototype.ontouchcancel = function() {

		// set inactive button state
		this._inactiveButton();
	};

	/**
	 * Function is called when tap occurs on button.
	 * @param {jQuery.Event} oEvent - the touch event.
	 * @private
	 */
	Button.prototype.ontap = function(oEvent) {

		// mark the event for components that needs to know if the event was handled by the button
		oEvent.setMarked();

		// fire tap event
		if (this.getEnabled()) {

			// if target is empty set target (specially for selenium test)
			if (!this._target) {
				this._target = oEvent.target;
			}

			// check if target which started the event is the same
			if ((!!this._target) && (this._target === oEvent.target)) {

				// note: on mobile, the press event should be fired after the focus is on the button
				if (oEvent.originalEvent && oEvent.originalEvent.type === "touchend") {
					this.focus();
				}

				this.fireTap({/* no parameters */}); // (This event is deprecated, use the "press" event instead)
				this.firePress({/* no parameters */});
			}
		}

		// reset target which started the event
		delete this._target;
	};

	/**
	 * Handle the key down event for SPACE and ENTER.
	 * This implementation differs from that of commons button.
	 * Commons listens to the click event and ignores touchstart.
	 * @param {jQuery.Event} oEvent - the keyboard event.
	 * @private
	 */
	Button.prototype.onkeydown = function(oEvent) {

		if (oEvent.which === jQuery.sap.KeyCodes.SPACE || oEvent.which === jQuery.sap.KeyCodes.ENTER) {

			// mark the event for components that needs to know if the event was handled by the button
			oEvent.setMarked();

			// set active button state
			this._activeButton();

			// set target which started the event
			this._target = oEvent.target;
		}
	};

	/**
	 * Handle the key up event for SPACE and ENTER.
	 *
	 * @param {jQuery.Event} oEvent - the keyboard event.
	 * @private
	 */
	Button.prototype.onkeyup = function(oEvent) {

		// if keydown isn't caught by button, ignore the keyup.
		if (!this._target) {
			return;
		}

		this._target = null;

		if (oEvent.which === jQuery.sap.KeyCodes.SPACE || oEvent.which === jQuery.sap.KeyCodes.ENTER) {

			// mark the event for components that needs to know if the event was handled by the button
			oEvent.setMarked();

			// set inactive button state
			this._inactiveButton();
			this.firePress({/* no parameters */});
		}
	};

	/**
	 * Ensure that the active button state is removed by focus loss.
	 *
	 * @param {jQuery.Event} oEvent - the focus event
	 * @private
	 */
	Button.prototype.onfocusout = function() {

		// set inactive button state
		this._inactiveButton();
	};

	/**
	 * Function is called when button is active.
	 *
	 * @private
	 */
	Button.prototype._activeButton = function() {
		if (!this._isUnstyled()) {
			this.$("inner").addClass("sapMBtnActive");
		}

		// handling active icon
		if (this.getEnabled()) {
			if (this.getIcon() && this.getActiveIcon() && this._image instanceof sap.m.Image) {
				this._image.setSrc(this.getActiveIcon());
			}
		}
	};

	/**
	 * Function is called when button is inactive.
	 *
	 * @private
	 */
	Button.prototype._inactiveButton = function() {
		if (!this._isUnstyled()) {
			this.$("inner").removeClass("sapMBtnActive");
		}

		// handling active icon
		if (this.getEnabled()) {
			if (this.getIcon() && this.getActiveIcon() && this._image instanceof sap.m.Image) {
				this._image.setSrc(this.getIcon());
			}
		}
	};

	/**
	 * Function to determine if the button is hoverable
	 *
	 * @return {sap.m.Button} this to allow method chaining
	 * @private
	 */
	Button.prototype._isHoverable = function() {
		return this.getEnabled() && sap.ui.Device.system.desktop;
	};

	/**
	 * Function is called when image control needs to be loaded.
	 *
	 * @param {string} sImgId - id to be used for the image
	 * @param {sap.ui.core.URI} sSrc - URI indicating the image to use as image source
	 * @param {sap.ui.core.URI} sActiveSrc - URI indicating the image to use as active image source
	 * @param {boolean} bIconDensityAware - value for DensityAware attribute of images
	 * @return {sap.m.Button} this to allow method chaining
	 * @private
	 */
	Button.prototype._getImage = function(sImgId, sSrc, sActiveSrc, bIconDensityAware) {

		// check if image source has changed - if yes destroy and reset image control
		if (this._image && (this._image.getSrc() !== sSrc)) {
			this._image.destroy();
			this._image = undefined;
		}

		// update or create image control
		var oImage = this._image;

		if (!!oImage) {
			oImage.setSrc(sSrc);
			if (oImage instanceof sap.m.Image) {
				oImage.setActiveSrc(sActiveSrc);
				oImage.setDensityAware(bIconDensityAware);
			}
		} else {
			oImage = IconPool.createControlByURI({
				id: sImgId,
				src : sSrc,
				activeSrc : sActiveSrc,
				densityAware : bIconDensityAware
			}, sap.m.Image).addStyleClass("sapMBtnCustomIcon").setParent(this, null, true);
		}

		// add style classes to the object
		oImage.addStyleClass("sapMBtnIcon");

		// remove previous set style classes
		if (oImage.hasStyleClass("sapMBtnIconLeft")) {
			oImage.removeStyleClass("sapMBtnIconLeft");
		}
		if (oImage.hasStyleClass("sapMBtnIconRight")) {
			oImage.removeStyleClass("sapMBtnIconRight");
		}
		if (oImage.hasStyleClass("sapMBtnBackIconLeft")) {
			oImage.removeStyleClass("sapMBtnBackIconLeft");
		}

		if (this._getText()) {
			// check and set absolute position depending on icon and icon position
			if (this.getIconFirst()) {
				if (this.getType() === sap.m.ButtonType.Back || this.getType() === sap.m.ButtonType.Up) {
					oImage.addStyleClass("sapMBtnBackIconLeft");
				} else {
					oImage.addStyleClass("sapMBtnIconLeft");
				}
			} else {
				oImage.addStyleClass("sapMBtnIconRight");
			}
		}

		this._image = oImage;
		return this._image;
	};

	/**
	 * Function is called when internal image control needs to be loaded.
	 *
	 * @param {string} sImgId - id to be used for the image
	 * @param {sap.ui.core.URI} sSrc - URI indicating the image to use as image source
	 * @return {sap.m.Button} this to allow method chaining
	 * @private
	 */
	Button.prototype._getInternalIconBtn = function(sImgId, sSrc) {
		var oIcon = this._iconBtn;

		// update or create image control
		if (!!oIcon) {
			oIcon.setSrc(sSrc);
		} else {
			oIcon = IconPool.createControlByURI(sSrc, sap.m.Image);
		}

		// add style classes to the object
		oIcon.addStyleClass("sapMBtnIcon");
		if (this._getText()) {
			oIcon.addStyleClass("sapMBtnIconLeft");
		}

		this._iconBtn = oIcon;
		return this._iconBtn;
	};

	/**
	 * Function is called to determine if the button is.unstyled
	 *
	 * @return {sap.m.Button} this to allow method chaining
	 * @private
	 */
	Button.prototype._isUnstyled = function() {
		var bUnstyled = false;

		if (this.getType()	=== sap.m.ButtonType.Unstyled) {
			bUnstyled = true;
		}

		return bUnstyled;
	};

	/**
	 * Property setter for the text
	 *
	 * @param {string} sText - new value of the Text attribute
	 * @return {sap.m.Button} this to allow method chaining
	 * @public
	 */
	Button.prototype.setText = function(sText) {
		var sValue = this.getText();

		if (sText === null || sText === undefined) {
			sText = "";
		}

		if (sValue !== sText) {
			var oDomRef = this.getDomRef("content");
			var bShouldSupressRendering = !!oDomRef;

			// Render control if element is not available in the DOM
			this.setProperty("text", sText, bShouldSupressRendering);

			if (bShouldSupressRendering) {
				// Get text to have the type conversation for non-string values done by the framework
				sText = this.getText();
				oDomRef.innerHTML = jQuery.sap.escapeHTML(sText);

				// Check if an icon is set
				if (this.getIcon()) {
					// Remove all text padding classes
					this._removeTextPadding();

					// Add the text padding classes
					if (sText.length > 0) {
						this._addTextPadding(this.getIconFirst());
					}

					// extend  minimum button size if icon is set without text for button types back and up
					if (this.$().hasClass("sapMBtnBack")) {
						this.$().removeClass("sapMBtnBack");
					}
					if ((this.getType() === sap.m.ButtonType.Back || this.getType() === sap.m.ButtonType.Up) && this.getIcon() && !this.getText()) {
						this.$().addClass("sapMBtnBack");
					}
				}
			}
		}

		return this;
	};

	/**
	 * Property setter for the icon
	 *
	 * @param {sap.ui.core.URI} sIcon - new value of the Icon property
	 * @return {sap.m.Button} this to allow method chaining
	 * @public
	 */
	Button.prototype.setIcon = function(sIcon) {
		var sValue = this.getIcon() || "";
		sIcon = sIcon || "";

		if (sValue !== sIcon) {
			var bSupressRendering = !!sValue && !!sIcon && IconPool.isIconURI(sIcon) === IconPool.isIconURI(sValue);
			this.setProperty("icon", sIcon, bSupressRendering);
			if (bSupressRendering && this._image) {
				this._image.setSrc(sIcon);
			}
		}
		return this;
	};


	/**
	 * Property setter for the icon first
	 *
	 * @param {boolean} bIconFirst - true IFF the icon goes before the text
	 * @return {sap.m.Button} this to allow method chaining
	 * @public
	 */
	Button.prototype.setIconFirst = function(bIconFirst) {
		var sValue = this.getIconFirst();

		if (sValue !== bIconFirst) {
			var oDomRef = this.getDomRef("img");
			var bShouldSupressRendering = !!oDomRef;

			// Render control if element is not available in the DOM
			this.setProperty("iconFirst", bIconFirst, bShouldSupressRendering);

			if (bShouldSupressRendering) {

				// remove previous set style classes
				if (this.$("img").hasClass("sapMBtnIconLeft")) {
					this.$("img").removeClass("sapMBtnIconLeft");
				}
				if (this.$("img").hasClass("sapMBtnIconRight")) {
					this.$("img").removeClass("sapMBtnIconRight");
				}
				if (this.$("img").hasClass("sapMBtnBackIconLeft")) {
					this.$("img").removeClass("sapMBtnBackIconLeft");
				}
				if (this.$("content").hasClass("sapMBtnContentLeft")) {
					this.$("content").removeClass("sapMBtnContentLeft");
				}
				if (this.$("content").hasClass("sapMBtnContentRight")) {
					this.$("content").removeClass("sapMBtnContentRight");
				}
				if (this.$("content").hasClass("sapMBtnBackContentRight")) {
					this.$("content").removeClass("sapMBtnBackContentRight");
				}

				if (this._getText()) {
					// check and set absolute position depending on icon and icon position
					if (bIconFirst) {
						if (this.getType() === sap.m.ButtonType.Back || this.getType() === sap.m.ButtonType.Up) {
							this.$("img").addClass("sapMBtnBackIconLeft");
							this.$("content").addClass("sapMBtnBackContentRight");
						} else {
							this.$("img").addClass("sapMBtnIconLeft");
							this.$("content").addClass("sapMBtnContentRight");
						}
					} else {
						if (this.getType() === sap.m.ButtonType.Back || this.getType() === sap.m.ButtonType.Up) {
							this.$("content").addClass("sapMBtnContentRight");
						} else {
							this.$("content").addClass("sapMBtnContentLeft");
						}
						this.$("img").addClass("sapMBtnIconRight");
					}
				}

				// Remove all text padding classes
				this._removeTextPadding();

				// Add the text padding classes
				if (this._getText().length > 0) {
					this._addTextPadding(bIconFirst);
				}
			}
		}

		return this;
	};

	/**
	 * Function is called to remove the padding classes for the text
	 *
	 * @private
	 */
	Button.prototype._removeTextPadding = function() {

		// Search and remove padding classes
		if (this.$("inner").hasClass("sapMBtnPaddingLeft")) {
			this.$("inner").removeClass("sapMBtnPaddingLeft");
		} else if (this.$("inner").hasClass("sapMBtnPaddingRight")) {
			this.$("inner").removeClass("sapMBtnPaddingRight");
		}

		// Search and remove padding between icon and text
		if (!this._getText()) {
			if (this.$("content").hasClass("sapMBtnContentLeft")) {
				this.$("content").removeClass("sapMBtnContentLeft");
			}
			if (this.$("content").hasClass("sapMBtnContentRight")) {
				this.$("content").removeClass("sapMBtnContentRight");
			}
			if (this.$("content").hasClass("sapMBtnBackContentRight")) {
				this.$("content").removeClass("sapMBtnBackContentRight");
			}
		}
	};

	/**
	 * Function is called to add the padding classes for the text
	 *
	 * @param {boolean} bIconFirst - true IFF the icon goes before the text
	 * @private
	 */
	Button.prototype._addTextPadding = function( bIconFirst) {
		var sType = this.getType();

		// Add text padding classes
		if (bIconFirst) {
			this.$("inner").addClass("sapMBtnPaddingRight");
		} else if (sType != sap.m.ButtonType.Back && sType != sap.m.ButtonType.Up) {
			this.$("inner").addClass("sapMBtnPaddingLeft");
		}

		// Add text padding classes between icon and text
		if (this._getText()) {
			if (this.getIcon()) {
				if (this.getIconFirst()) {
					if (this.getType() === sap.m.ButtonType.Back || this.getType() === sap.m.ButtonType.Up) {
						this.$("content").addClass("sapMBtnBackContentRight");
					} else {
						this.$("content").addClass("sapMBtnContentRight");
					}
				} else {
					if (this.getType() === sap.m.ButtonType.Back || this.getType() === sap.m.ButtonType.Up) {
						this.$("content").addClass("sapMBtnContentRight");
					}
					this.$("content").addClass("sapMBtnContentLeft");
				}
			} else if (this.getType() === sap.m.ButtonType.Back || this.getType() === sap.m.ButtonType.Up) {
				this.$("content").addClass("sapMBtnContentRight");
			}
		}
	};

	/**
	 * Defines to which DOM reference the Popup should be docked
	 *
	 * @protected
	 * @return {DomNode} the DOM reference that Popup should dock to
	 */
	Button.prototype.getPopupAnchorDomRef = function() {
		return this.getDomRef("inner");
	};
	
	// A hook to be used by controls that extend sap.m.Button and want to display the text in a different way
	Button.prototype._getText = function() {
		return this.getText();
	};

	Button.prototype.setType = function(sType) {

		this.setProperty("type", sType);

		// Aria desciption for type
		var sTypeText = "";
		var oRb;

		switch (sType) {
		case sap.m.ButtonType.Accept:
			if (!sap.m.Button._oStaticAcceptText) {
				oRb = sap.ui.getCore().getLibraryResourceBundle("sap.m");
				sTypeText = oRb.getText("BUTTON_ARIA_TYPE_ACCEPT");
				sap.m.Button._oStaticAcceptText = new sap.ui.core.InvisibleText({text: sTypeText});
				sap.m.Button._oStaticAcceptText.toStatic(); //Put to Static UiArea
			}
			break;
		case sap.m.ButtonType.Reject:
			if (!sap.m.Button._oStaticRejectText) {
				oRb = sap.ui.getCore().getLibraryResourceBundle("sap.m");
				sTypeText = oRb.getText("BUTTON_ARIA_TYPE_REJECT");
				sap.m.Button._oStaticRejectText = new sap.ui.core.InvisibleText({text: sTypeText});
				sap.m.Button._oStaticRejectText.toStatic(); //Put to Static UiArea
			}
			break;
		case sap.m.ButtonType.Emphasized:
			if (!sap.m.Button._oStaticEmphasizedText) {
				oRb = sap.ui.getCore().getLibraryResourceBundle("sap.m");
				sTypeText = oRb.getText("BUTTON_ARIA_TYPE_EMPHASIZED");
				sap.m.Button._oStaticEmphasizedText = new sap.ui.core.InvisibleText({text: sTypeText});
				sap.m.Button._oStaticEmphasizedText.toStatic(); //Put to Static UiArea
			}
			break;
		default: // No need to do anything for other button types
			break;
		}

		return this;

	};

	return Button;

}, /* bExport= */ true);

}; // end of sap/m/Button.js
if ( !jQuery.sap.isDeclared('sap.m.Carousel') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.Carousel.
jQuery.sap.declare('sap.m.Carousel'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.mobify-carousel'); // unlisted dependency retained
sap.ui.define("sap/m/Carousel",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/thirdparty/mobify-carousel'],
	function(jQuery, library, Control, mobifycarousel) {
	"use strict";



	/**
	 * Constructor for a new Carousel.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The Carousel control can be used to navigate through a list of sap.m controls just like flipping through the pages of a book by swiping right or left. An indicator shows the current position within the control list. When displayed in a desktop browser, a left- and right-arrow button is displayed on the carousel's sides, which can be used to navigate through the carousel.
	 *
	 * Note: when displa Internet Explorer 9, page changes are not animated.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.Carousel
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Carousel = Control.extend("sap.m.Carousel", /** @lends sap.m.Carousel.prototype */ { metadata : {

		library : "sap.m",
		properties : {

			/**
			 * The height of the carousel. Note that when a percentage value is used, the height of the surrounding container must be defined.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},

			/**
			 * The width of the carousel. Note that when a percentage value is used, the height of the surrounding container must be defined.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},

			/**
			 * Defines whether the carousel should loop, i.e show the first page after the last page is reached and vice versa.
			 */
			loop : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Show or hide carousel's page indicator.
			 */
			showPageIndicator : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * Defines where the carousel's page indicator is displayed. Possible values are sap.m.PlacementType.Top, sap.m.PlacementType.Bottom. Other values are ignored and the default value will be applied. The default value is sap.m.PlacementType.Bottom.
			 */
			pageIndicatorPlacement : {type : "sap.m.PlacementType", group : "Appearance", defaultValue : sap.m.PlacementType.Bottom},

			/**
			 * Show or hide busy indicator in the carousel when loading pages after swipe.
			 * @deprecated Since version 1.18.7.
			 * Since 1.18.7 pages are no longer loaded or unloaded. Therefore busy indicator is not necessary any longer.
			 */
			showBusyIndicator : {type : "boolean", group : "Appearance", defaultValue : true, deprecated: true},

			/**
			 * Size of the busy indicators which can be displayed in the carousel.
			 * @deprecated Since version 1.18.7.
			 * Since 1.18.7 pages are no longer loaded or unloaded. Therefore busy indicator is not necessary any longer.
			 */
			busyIndicatorSize : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '6em', deprecated: true}
		},
		defaultAggregation : "pages",
		aggregations : {

			/**
			 * The content which the carousel displays.
			 */
			pages : {type : "sap.ui.core.Control", multiple : true, singularName : "page"}
		},
		associations : {

			/**
			 * Provides getter and setter for the currently displayed page. For the setter, argument may be the control itself, which must be member of the carousel's page list, or the control's id.
			 * The getter will return the control id
			 */
			activePage : {type : "sap.ui.core.Control", multiple : false}
		},
		events : {

			/**
			 * Carousel requires a new page to be loaded. This event may be used to fill the content of that page
			 * @deprecated Since version 1.18.7.
			 * Since 1.18.7 pages are no longer loaded or unloaded
			 */
			loadPage : {deprecated: true,
				parameters : {

					/**
					 * Id of the page which will be loaded
					 */
					pageId : {type : "string"}
				}
			},

			/**
			 * Carousel does not display a page any longer and unloads it. This event may be used to clean up the content of that page.
			 * @deprecated Since version 1.18.7.
			 * Since 1.18.7 pages are no longer loaded or unloaded
			 */
			unloadPage : {deprecated: true,
				parameters : {

					/**
					 * Id of the page which will be unloaded
					 */
					pageId : {type : "string"}
				}
			},

			/**
			 * This event is fired after a carousel swipe has been completed. It is triggered both by physical swipe events and through API carousel manipulations such as calling 'next', 'previous' or 'setActivePageId' functions.
			 */
			pageChanged : {
				parameters : {

					/**
					 * Id of the page which was active before the page change.
					 */
					oldActivePageId : {type : "string"},

					/**
					 * Id of the page which is active after the page change.
					 */
					newActivePageId : {type : "string"}
				}
			}
		}
	}});


	//Constants convenient class selections
	Carousel._INNER_SELECTOR = ".sapMCrslInner";
	Carousel._PAGE_INDICATOR_SELECTOR = ".sapMCrslBulleted";
	Carousel._HUD_SELECTOR = ".sapMCrslHud";
	Carousel._ITEM_SELECTOR = ".sapMCrslItem";
	Carousel._LEFTMOST_CLASS = "sapMCrslLeftmost";
	Carousel._RIGHTMOST_CLASS = "sapMCrslRightmost";
	Carousel._LATERAL_CLASSES = "sapMCrslLeftmost sapMCrslRightmost";
	Carousel._bIE9 = (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 10);

	/**
	 * Initialize member variables which are needed later on.
	 *
	 * @private
	 */
	Carousel.prototype.init = function() {
		//Scroll container list for clean- up
		this._aScrollContainers = [];

		//Initialize '_fnAdjustAfterResize' to be used by window
		//'resize' event
		this._fnAdjustAfterResize = jQuery.proxy(function() {
			var $carouselInner = this.$().find(Carousel._INNER_SELECTOR);
			this._oMobifyCarousel.resize($carouselInner);
		}, this);

		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};



	/**
	 * Called when the control is destroyed.
	 *
	 * @private
	 */
	Carousel.prototype.exit = function() {
		if (this._oMobifyCarousel) {
			this._oMobifyCarousel.destroy();
			delete this._oMobifyCarousel;
		}

		if (this._oArrowLeft) {
			this._oArrowLeft.destroy();
			delete this._oArrowLeft;
		}
		if (this._oArrowRight) {
			this._oArrowRight.destroy();
			delete this._oArrowRight;
		}

		if (this._sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
			this._sResizeListenerId = null;
		}
		this.$().off('afterSlide');

		this._cleanUpScrollContainer();
		this._fnAdjustAfterResize = null;
		this._aScrollContainers = null;
		if (!Carousel._bIE9 && this._$InnerDiv) {
			jQuery(window).off("resize", this._fnAdjustAfterResize);
		}
		this._$InnerDiv = null;
	};

	/**
	 * Housekeeping for scroll containers: Removes content for each container,
	 * destroys the contianer and clears the local container list.
	 *
	 * @private
	 */
	Carousel.prototype._cleanUpScrollContainer = function() {
		var oScrollCont;
		while (this.length > 0) {
			oScrollCont = this._aScrollContainers.pop();
			oScrollCont.removeAllContent();
			if (oScrollCont && typeof oScrollCont.destroy === 'function') {
				oScrollCont.destroy();
			}
		}
	};

	/**
	 * Delegates 'touchstart' event to mobify carousel
	 *
	 * @param oEvent
	 */
	Carousel.prototype.ontouchstart = function(oEvent) {
		if (this._oMobifyCarousel) {
			this._oMobifyCarousel.touchstart(oEvent);
		}
	};

	/**
	 * Delegates 'touchmove' event to mobify carousel
	 *
	 * @param oEvent
	 */
	Carousel.prototype.ontouchmove = function(oEvent) {
		if (this._oMobifyCarousel) {
			this._oMobifyCarousel.touchmove(oEvent);
		}
	};

	/**
	 * Delegates 'touchend' event to mobify carousel
	 *
	 * @param oEvent
	 */
	Carousel.prototype.ontouchend = function(oEvent) {
		if (this._oMobifyCarousel) {
			this._oMobifyCarousel.touchend(oEvent);
		}
	};



	/**
	 * Cleans up bindings
	 *
	 * @private
	 */
	Carousel.prototype.onBeforeRendering = function() {
		//make sure, active page has an initial value
		var sActivePage = this.getActivePage();
		if (!sActivePage && this.getPages().length > 0) {
			//if no active page is specified, set first page.
			this.setAssociation("activePage", this.getPages()[0].getId(), true);
		}
		if (this._sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
			this._sResizeListenerId = null;
		}
		if (!Carousel._bIE9 && this._$InnerDiv) {
			jQuery(window).off("resize", this._fnAdjustAfterResize);
		}
		return this;
	};

	/**
	 * When this method is called for the first time, a swipe-view instance is created which is renders
	 * itself into its dedicated spot within the DOM tree. This instance is used throughout the
	 * Carousel instance's lifecycle.
	 *
	 * @private
	 */
	Carousel.prototype.onAfterRendering = function() {

		//Check if carousel has been initialized
		if (this._oMobifyCarousel) {
			//Clean up existing mobify carousel
			this._oMobifyCarousel.destroy();
		}
		//Create and initialize new carousel
		this.$().carousel();
		this._oMobifyCarousel = this.getDomRef()._carousel;
		this._oMobifyCarousel.setLoop(this.getLoop());
		this._oMobifyCarousel.setRTL(sap.ui.getCore().getConfiguration().getRTL());

		//Go to active page: this may be necessary after adding or
		//removing pages
		var sActivePage = this.getActivePage();

		if (sActivePage) {
			var iIndex = this._getPageNumber(sActivePage);
			if (isNaN(iIndex) || iIndex == 0) {
				if (this.getPages().length > 0) {
					//First page is always shown as default
					//Do not fire page changed event, though
					this.setAssociation("activePage", this.getPages()[0].getId(), true);
					this._adjustHUDVisibility(1);
				}
			} else {
				this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');
				//mobify carousel is 1-based
				this._oMobifyCarousel.move(iIndex + 1);
				this._changePage(iIndex + 1);
			}
		}



		//attach delegate for firing 'PageChanged' events to mobify carousel's
		//'afterSlide'
		this.$().on('afterSlide', jQuery.proxy(function(e, iPreviousSlide, iNextSlide) {
			//the event might bubble up from another carousel inside of this one.
			//in this case we ignore the event
			if (e.target !== this.getDomRef()) {
				return;
			}

			if (iNextSlide > 0) {
				this._changePage(iNextSlide);
			}
		}, this));
		this._$InnerDiv = this.$().find(Carousel._INNER_SELECTOR)[0];
		if (Carousel._bIE9) {
			this._sResizeListenerId = sap.ui.core.ResizeHandler.register(this._$InnerDiv, this._fnAdjustAfterResize);
		} else {
			jQuery(window).on("resize", this._fnAdjustAfterResize);
		}
	};

	/**
	 * Private method which adjusts the Hud visibility and fires a page change
	 * event when the active page changes
	 *
	 * @param iNewPageIndex index of new page in 'pages' aggregation.
	 * @private
	 */
	Carousel.prototype._changePage = function(iNewPageIndex) {
		this._adjustHUDVisibility(iNewPageIndex);
		var sOldActivePageId = this.getActivePage();
		var sNewActivePageId = this.getPages()[iNewPageIndex - 1].getId();
		this.setAssociation("activePage", sNewActivePageId, true);

		jQuery.sap.log.debug("sap.m.Carousel: firing pageChanged event: old page: " + sOldActivePageId
				+ ", new page: " + sNewActivePageId);

		this.firePageChanged( { oldActivePageId: sOldActivePageId,
			newActivePageId: sNewActivePageId});
	};



	/**
	 * Sets HUD control's visibility after page has changed
	 *
	 * @param iNextSlide index of the next active page
	 * @private
	 *
	 */
	Carousel.prototype._adjustHUDVisibility = function(iNextSlide) {
		if (sap.ui.Device.system.desktop && !this.getLoop() && this.getPages().length > 1) {
			//update HUD arrow visibility for left- and
			//rightmost pages
			var $HUDContainer = this.$().find(Carousel._HUD_SELECTOR);
			//clear marker classes first
			$HUDContainer.removeClass(Carousel._LATERAL_CLASSES);

			if (iNextSlide === 1) {
				$HUDContainer.addClass(Carousel._LEFTMOST_CLASS);
			} else if (iNextSlide === this.getPages().length) {
				$HUDContainer.addClass(Carousel._RIGHTMOST_CLASS);
			}
		}
	};

	/*
	 * API method to set carousel's active page during runtime.
	 *
	 * @param vPage Id of the page or page which shall become active
	 * @override
	 *
	 */
	Carousel.prototype.setActivePage = function (vPage) {
		var sPageId = null;
		if (typeof (vPage) == 'string') {
			sPageId = vPage;
		} else if (vPage instanceof Control) {
			sPageId = vPage.getId();
		}

		if (sPageId) {
			if (sPageId === this.getActivePage()) {
				//page has not changed, nothing to do, return
				return this;
			}
			var iPageNr = this._getPageNumber(sPageId);

			if (!isNaN(iPageNr)) {
				if (this._oMobifyCarousel) {
					//mobify carousel's move function is '1' based
					this._oMobifyCarousel.move(iPageNr + 1);
				}
				// if oMobifyCarousel is not present yet, move takes place
				// 'onAfterRendering', when oMobifyCarousel is created
			}
		}
		this.setAssociation("activePage", sPageId, true);

		return this;
	};



	/*
	 * API method to set the carousel's height
	 *
	 * @param {sap.ui.core.CSSSize} oHeight the new height as CSSSize
	 * @public
	 * @override
	 */
	Carousel.prototype.setHeight = function(oHeight) {
		//do suppress rerendering
		this.setProperty("height", oHeight, true);
		this.$().css("height", oHeight);
		return this;
	};

	/*
	 * API method to set the carousel's width
	 *
	 * @param {sap.ui.core.CSSSize} oWidth the new width as CSSSize
	 * @public
	 * @override
	 */
	Carousel.prototype.setWidth = function(oWidth) {
		//do suppress rerendering
		this.setProperty("width", oWidth, true);
		this.$().css("width", oWidth);
		return this;
	};

	/*
	 * API method to place the page indicator.
	 *
	 * @param {sap.m.PlacementType} sPlacement either sap.m.PlacementType.Top or sap.m.PlacementType.Bottom
	 * @public
	 * @override
	 */
	Carousel.prototype.setPageIndicatorPlacement = function(sPlacement) {
		if (sap.m.PlacementType.Top != sPlacement &&
				sap.m.PlacementType.Bottom != sPlacement) {
			jQuery.sap.assert(false, "sap.m.Carousel.prototype.setPageIndicatorPlacement: invalid value '" +
					sPlacement + "'. Valid values: sap.m.PlacementType.Top, sap.m.PlacementType.Bottom." +
							"\nUsing default value sap.m.PlacementType.Bottom");
			sPlacement = sap.m.PlacementType.Bottom;
		}

		//do suppress rerendering
		this.setProperty("pageIndicatorPlacement", sPlacement, true);

		var $PageIndicator = this.$().find(Carousel._PAGE_INDICATOR_SELECTOR);

		//set placement regardless of whether indicator is visible: it may become
		//visible later on and then it should be at the right place
		if (sap.m.PlacementType.Top === sPlacement) {
			this.$().prepend($PageIndicator);
			$PageIndicator.removeClass('sapMCrslBottomOffset');
			this.$().find(Carousel._ITEM_SELECTOR).removeClass('sapMCrslBottomOffset');
		} else {
			this.$().append($PageIndicator);
			$PageIndicator.addClass('sapMCrslBottomOffset');
			this.$().find(Carousel._ITEM_SELECTOR).addClass('sapMCrslBottomOffset');
		}
		return this;
	};


	/*
	 * API method to set whether the carousel should display the page indicator
	 *
	 * @param {boolean} bShowPageIndicator the new show property
	 * @public
	 * @override
	 */
	Carousel.prototype.setShowPageIndicator = function(bShowPageIndicator) {

		var $PageInd = this.$().find(Carousel._PAGE_INDICATOR_SELECTOR);

		bShowPageIndicator ? $PageInd.show() : $PageInd.hide();

		//do suppress rerendering
		this.setProperty("showPageIndicator", bShowPageIndicator, true);
		return this;
	};



	/*
	 * API method to set whether the carousel should loop, i.e
	 * show the first page after the last page is reached and vice
	 * versa.
	 *
	 * @param {boolean} bLoop the new loop property
	 * @public
	 * @override
	 */
	Carousel.prototype.setLoop = function(bLoop) {
		//do suppress rerendering
		this.setProperty("loop", bLoop, true);
		if (this._oMobifyCarousel) {
			this._oMobifyCarousel.setLoop(bLoop);
		}
		return this;
	};

	/**
	 * Gets the icon of the requested arrow (left/right).
	 * @private
	 * @param sName left or right
	 * @returns icon of the requested arrow
	 */
	Carousel.prototype._getNavigationArrow = function(sName) {
		jQuery.sap.require("sap.ui.core.IconPool");
		var mProperties = {
			src : "sap-icon://navigation-" + sName + "-arrow"
		};

		if (sName === "left") {
			if (!this._oArrowLeft) {
				this._oArrowLeft = sap.m.ImageHelper.getImageControl(this.getId() + "-arrowScrollLeft", this._oArrowLeft, this, mProperties);
			}
			return this._oArrowLeft;
		} else if (sName === "right") {
			if (!this._oArrowRight) {
				this._oArrowRight = sap.m.ImageHelper.getImageControl(this.getId() + "-arrowScrollRight", this._oArrowRight, this, mProperties);
			}
			return this._oArrowRight;
		}
	};


	/**
	 * Private method that places a given page control into
	 * a scroll container which does not scroll. That container does
	 * not scroll itself. This is necessary to achieve the 100% height
	 * effect with an offset for the page indicator.
	 *
	 * @param oPage the page to check
	 * @private
	 */
	Carousel.prototype._createScrollContainer = function(oPage) {

		var cellClasses = oPage instanceof sap.m.Image ? "sapMCrslItemTableCell sapMCrslImg" : "sapMCrslItemTableCell",
			oContent = new sap.ui.core.HTML({
			content :	"<div class='sapMCrslItemTable'>" +
							"<div class='" + cellClasses + "'></div>" +
						"</div>",
			afterRendering : function(e) {
				var rm = sap.ui.getCore().createRenderManager();
				rm.render(oPage, this.getDomRef().firstChild);
				rm.destroy();
			}
		});

		var oScrollContainer = new sap.m.ScrollContainer({
			horizontal: false,
			vertical: false,
			content:[oContent],
			width:'100%',
			height:'100%'
		});
		oScrollContainer.setParent(this, null, true);
		this._aScrollContainers.push(oScrollContainer);
		return oScrollContainer;
	};




	/**
	 * Call this method to display the previous page (corresponds to a swipe left). Returns 'this' for method chaining.
	 *
	 * @type sap.m.Carousel
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Carousel.prototype.previous = function () {
		if (this._oMobifyCarousel) {
			this._oMobifyCarousel.prev();
		} else {
			jQuery.sap.log.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");
		}
		return this;
	};

	/**
	 * Call this method to display the next page (corresponds to a swipe right). Returns 'this' for method chaining.
	 *
	 * @type sap.m.Carousel
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Carousel.prototype.next = function () {
		if (this._oMobifyCarousel) {
			this._oMobifyCarousel.next();
		} else {
			jQuery.sap.log.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");
		}
		return this;
	};

	/**
	 * Determines the position of a given page in the carousel's page list
	 *
	 * @return the position of a given page in the carousel's page list or 'undefined' if it does not exist in the list.
	 * @private
	 */
	Carousel.prototype._getPageNumber = function(sPageId) {
		var i, result;

		for (i = 0; i < this.getPages().length; i++) {
			if (this.getPages()[i].getId() == sPageId) {
				result = i;
				break;
			}
		}
		return result;
	};

	/**
	 * Handler for 'tab previous' key event.
	 *
	 * @param oEvent - key event
	 * @private
	 *
	 */
	Carousel.prototype.onsaptabprevious = function(oEvent) {
		this._fnOnTabPress(oEvent, false);
	};

	/**
	 * Handler for 'tab next' key event.
	 *
	 * @param oEvent - key event
	 * @private
	 *
	 */
	Carousel.prototype.onsaptabnext = function(oEvent) {
		this._fnOnTabPress(oEvent, true);
	};

	/**
	 * This method is called when pressing tab or shift+tab. Perform logic depending
	 * on the current focused element.
	 *
	 * @param oEvent - key event
	 * @param { bDirection } serving as a reference for the Carousel slide direction
	 * @private
	 */
	Carousel.prototype._fnOnTabPress = function(oEvent, bDirection) {
		var oSourceDomRef = oEvent.target;
		var $activePage = this.$().find('.sapMCrslItem.sapMCrslActive');

		// Check if the focus is received form the Carousel
		if (oSourceDomRef === this.$()[0]) {
			this._fnOnCarouselEnter(oEvent, bDirection);
			return;
		}

		if (bDirection === true) {
			// If the event is from the last focusable element
			// focus the next focusable control after the Carousel
			if (oSourceDomRef === $activePage.lastFocusableDomRef()) {
				this._handleGroupNavigation(oEvent, false);
			}
		} else {
			// If the event is from the first focusable element
			// focus the Carousel
			if (oSourceDomRef === $activePage.firstFocusableDomRef()) {
				oEvent.preventDefault();
				this.$().focus();
			}
		}

		// keep a reference to the current active carousel page
		this._iLastActivePage = this._getPageNumber(this.getActivePage());

		// keep a reference to the current focused element
		this._oLastFocusedElement = oSourceDomRef;
	};

	/**
	 * Checks which time the user is entering the Carousel
	 *
	 * @param {jQuery.EventObject}
	 * @param { bDirection } serving as a reference for the carousel slide direction
	 * @private
	 */
	Carousel.prototype._fnOnCarouselEnter = function(oEvent, bDirection) {
		var $activePage = this.$().find('.sapMCrslItem.sapMCrslActive');

		// First time entering
		if (this._bIsTabUsed === undefined) {
			this._bIsTabUsed = true;
			oEvent.preventDefault();

			if ($activePage.firstFocusableDomRef() !== null) {
				$activePage.firstFocusableDomRef().focus();
			} else {
				// If there is no focusable element if the page,
				// focus the next focusable control after the Carousel
				this._handleGroupNavigation(oEvent, false);
			}

			return;
		}

		// Entering any consecutive time
		if (this._iLastActivePage === this._getPageNumber(this.getActivePage()) && this._oLastFocusedElement) {
			// Checks if the last focused element is child of the current active page
			if ($activePage.has(this._oLastFocusedElement).length && bDirection === true) {
				oEvent.preventDefault();
				this._oLastFocusedElement.focus();
			}
		}

	};

	/**
	 * Handler for F6 and Shift + F6 group navigation
	 *
	 * @param oEvent {jQuery.EventObject}
	 * @param bShiftKey serving as a reference if shift is used
	 * @private
	 */
	Carousel.prototype._handleGroupNavigation = function(oEvent, bShiftKey) {
		var oEventF6 = jQuery.Event("keydown");

		// Prevent the event and focus Carousel control
		oEvent.preventDefault();
		this.$().focus();

		oEventF6.target = oEvent.target;
		oEventF6.keyCode = jQuery.sap.KeyCodes.F6;
		oEventF6.shiftKey = bShiftKey;

		jQuery.sap.handleF6GroupNavigation(oEventF6);
	};

	/**
	 * Change Carousel Active Page from given page index.
	 *
	 * @param oEvent - The event object
	 * @param nIndex - The index of the page that need to be shown.
	 *	If the index is 0 the next shown page will be the first in the Carousel
	 * @private
	 */
	Carousel.prototype._fnSkipToIndex = function(oEvent, nIndex) {
		oEvent.preventDefault();
		var nNewIndex = nIndex;

		// Exit the function if the event is not from the Carousel
		if (oEvent.target !== this.$()[0]) {
			return;
		}

		// Calculate the index of the next page that will be shown
		if (nIndex !== 0) {
			nNewIndex = this._getPageNumber(this.getActivePage()) + 1 + nIndex;
		}

		// Set the index in the interval between 1 and the total page count in the Carousel
		nNewIndex = Math.max(nNewIndex, 1);
		nNewIndex = Math.min(nNewIndex, this.getPages().length);

		this._oMobifyCarousel.move(nNewIndex);
	};

	/**
	 * Handler for focus event
	 *
	 * @param oEvent - The event object
	 * @private
	 *
	 */
	Carousel.prototype.onfocusin = function(oEvent) {
		var $activePage = this.$().find('.sapMCrslItem.sapMCrslActive');

		// Create the property if it is not defined before
		// The property is used as a reference to the first active page when the focus is received
		if (this.nFirstActivePageIndex === undefined) {
			this.nFirstActivePageIndex = this._getPageNumber(this.getActivePage());
		}

		// Check if the event target is the last focusable element in the Carousel
		// If the current active page is different from the parent page of the last focusable element in the Carousel,
		// the event is from the keyboard and should be overwritten
		if (oEvent.target === this.$().lastFocusableDomRef() && oEvent.target.parentNode !== $activePage[0]){
			oEvent.preventDefault();

			if (this._iLastActivePage === this._getPageNumber(this.getActivePage()) && this._oLastFocusedElement) {
				this._oLastFocusedElement.focus();
				return;
			}

			if ($activePage.lastFocusableDomRef() !== null){
				$activePage.lastFocusableDomRef().focus();
			} else {
				this.$().focus();
			}
		}

	};

	/**
	 * Handler for F6
	 *
	 * @param oEvent - The event object
	 */
	Carousel.prototype.onsapskipforward = function(oEvent) {
		oEvent.preventDefault();

		// keep a reference to the current active carousel page
		this._iLastActivePage = this._getPageNumber(this.getActivePage());

		// keep a reference to the current focused element
		this._oLastFocusedElement = oEvent.target;

		this._handleGroupNavigation(oEvent, false);
	};

	/**
	 * Handler for Shift + F6
	 *
	 * @param oEvent - The event object
	 */
	Carousel.prototype.onsapskipback = function(oEvent) {
		oEvent.preventDefault();

		// keep a reference to the current active carousel page
		this._iLastActivePage = this._getPageNumber(this.getActivePage());

		// keep a reference to the current focused element
		this._oLastFocusedElement = oEvent.target;

		this._handleGroupNavigation(oEvent, true);
	};

	/**
	 * Handler for key down
	 *
	 * @param oEvent - The event object
	 */
	Carousel.prototype.onkeydown = function(oEvent) {
		var $activePage;

		// Filter F7 key down
		if (oEvent.keyCode ===  jQuery.sap.KeyCodes.F7){
			// Needed for IE
			oEvent.preventDefault();

			$activePage = this.$().find('.sapMCrslItem.sapMCrslActive');

			// Focus the Carousel if the F7 is from item level
			if (this._oLastFocusedElementFromF7 === undefined){
				this.$().focus();
				this._oLastFocusedElementFromF7 = oEvent.target;
				return;
			}

			// Check if F7 is used on the current page
			if ($activePage.has(this._oLastFocusedElementFromF7).length > 0){
				// Focus the element from which F7 was accrued
				this._oLastFocusedElementFromF7.focus();
				this._oLastFocusedElementFromF7 = undefined;
			} else {
				// Focus the Carousel
				this.$().focus();
				this._oLastFocusedElementFromF7 = oEvent.target;
			}
		}

		// Filter minus key down
		if (oEvent.keyCode ===  jQuery.sap.KeyCodes.MINUS || oEvent.keyCode === jQuery.sap.KeyCodes.NUMPAD_MINUS){
			this._fnSkipToIndex(oEvent, -1);
		}

		// Filter plus key down
		if (oEvent.keyCode ===  jQuery.sap.KeyCodes.PLUS || oEvent.keyCode === jQuery.sap.KeyCodes.NUMPAD_PLUS){
			this._fnSkipToIndex(oEvent, 1);
		}
	};

	/**
	 * Set carousel back to the first position it had.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsapescape = function(oEvent) {
		if (this.nFirstActivePageIndex) {
			this._oMobifyCarousel.move(this.nFirstActivePageIndex + 1);
			this._changePage(this.nFirstActivePageIndex + 1);
		}
	};

	/**
	 * Move focus to the next item. If focus is on the last item, do nothing.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsapright = function(oEvent) {
		this._fnSkipToIndex(oEvent, 1);
	};

	/**
	 * Move focus to the next item. If focus is on the last item, do nothing.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsapup = function(oEvent) {
		this._fnSkipToIndex(oEvent, 1);
	};

	/**
	 * Move focus to the previous item. If focus is on the first item, do nothing.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsapleft = function(oEvent) {
		this._fnSkipToIndex(oEvent, -1);
	};

	/**
	 * Move focus to the previous item. If focus is on the first item, do nothing.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsapdown = function(oEvent) {
		this._fnSkipToIndex(oEvent, -1);
	};

	/**
	 * Move focus to the first item.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsaphome = function(oEvent) {
		this._fnSkipToIndex(oEvent, 0);
	};

	/**
	 * Move focus to the last item.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsapend = function(oEvent) {
		this._fnSkipToIndex(oEvent, this.getPages().length);
	};

	/**
	 * Move focus 10 items to the right. If there are less than 10 items right, move
	 * focus to last item.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsaprightmodifiers = function(oEvent) {
		if (oEvent.ctrlKey) {
			this._fnSkipToIndex(oEvent, 10);
		}
	};

	/**
	 * Move focus 10 items to the right. If there are less than 10 items right, move
	 * focus to last item.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsapupmodifiers = function(oEvent) {
		if (oEvent.ctrlKey) {
			this._fnSkipToIndex(oEvent, 10);
		}
	};

	/**
	 * Move focus 10 items to the right. If there are less than 10 items right, move
	 * focus to last item.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsappageup = function(oEvent) {
		this._fnSkipToIndex(oEvent, 10);
	};

	/**
	 * Move focus 10 items to the left. If there are less than 10 items left, move
	 * focus to first item.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsapleftmodifiers = function(oEvent) {
		if (oEvent.ctrlKey) {
			this._fnSkipToIndex(oEvent, -10);
		}
	};

	/**
	 * Move focus 10 items to the left. If there are less than 10 items left, move
	 * focus to first item.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsapdownmodifiers = function(oEvent) {
		if (oEvent.ctrlKey) {
			this._fnSkipToIndex(oEvent, -10);
		}
	};

	/**
	 * Move focus 10 items to the left. If there are less than 10 items left, move
	 * focus to first item.
	 *
	 * @param oEvent - key event
	 * @private
	 */
	Carousel.prototype.onsappagedown = function(oEvent) {
		this._fnSkipToIndex(oEvent, -10);
	};

	//DEPRECATED METHODS


	/*
	 * API method to set whether the carousel should display the busy indicators.
	 * This property has been deprecated since 1.18.7. Does nothing and returns the carousel reference.
	 *
	 * @deprecated
	 * @public
	 */
	Carousel.prototype.setShowBusyIndicator = function() {
		jQuery.sap.log.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");
		return this;
	};

	/*
	 * API method to check whether the carousel should display the busy indicators.
	 * This property has been deprecated since 1.18.7. Always returns false,
	 *
	 * @deprecated
	 * @public
	 */
	Carousel.prototype.getShowBusyIndicator = function() {
		jQuery.sap.log.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");
		return false;
	};

	/*
	 * API method to set the carousel's busy indicator size.
	 * This property has been deprecated since 1.18.7. Does nothing and returns the carousel reference.
	 *
	 * @deprecated
	 * @public
	 */
	Carousel.prototype.setBusyIndicatorSize = function() {
		jQuery.sap.log.warning("sap.m.Carousel: Deprecated function 'setBusyIndicatorSize' called. Does nothing.");
		return this;
	};


	/*
	 * API method to retrieve the carousel's busy indicator size.
	 * This property has been deprecated since 1.18.6. Always returns an empty string.
	 *
	 * @deprecated
	 * @public
	 */
	Carousel.prototype.getBusyIndicatorSize = function() {
		jQuery.sap.log.warning("sap.m.Carousel: Deprecated function 'getBusyIndicatorSize' called. Does nothing.");
		return "";
	};


	return Carousel;

}, /* bExport= */ true);

}; // end of sap/m/Carousel.js
if ( !jQuery.sap.isDeclared('sap.m.Column') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.Column.
jQuery.sap.declare('sap.m.Column'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/Column",['jquery.sap.global', './library', 'sap/ui/core/Element', 'sap/ui/core/Renderer'],
	function(jQuery, library, Element, Renderer) {
	"use strict";


	
	/**
	 * Constructor for a new Column.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The column allows to define column specific properties that will be applied when rendering the List.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.12
	 * @alias sap.m.Column
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Column = Element.extend("sap.m.Column", /** @lends sap.m.Column.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {
	
			/**
			 * Defines the width of the column. If you leave it empty then this column covers the remaining space.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
	
			/**
			 * Horizontal alignment of the column content. Available alignment settings are "Begin", "Center", "End", "Left", and "Right".
			 * 
			 * NOTE: Control with a "textAlign" property inherits the horizontal alignment.
			 */
			hAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},
	
			/**
			 * Vertical alignment of the cells in a column. Possible values are "Inherit", "Top", "Middle", "Bottom"
			 * This property does not affect the vertical alignment of header and footer.
			 */
			vAlign : {type : "sap.ui.core.VerticalAlign", group : "Appearance", defaultValue : sap.ui.core.VerticalAlign.Inherit},
	
			/**
			 * CSS class name for column contents(header, cells and footer of column). This property can be used for different column styling. If column is shown as pop-in then this class name is applied to related pop-in row.
			 */
			styleClass : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * Specifies whether or not the column is visible. Invisible columns are not rendered.
			 */
			visible : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * By default column is always shown. If you set this property, control checks the minimum width of the screen to show or hide this column.
			 * As you can give specific CSS sizes(e.g: "480px" or "40em"), you can also use sap.m.ScreenSize enumeration(e.g: "Phone", "Tablet", "Desktop", "Small", "Medium", "Large", ....).
			 * 
			 * sap.m.Column.MediaQuery1->Range1 = 199
			 * 
			 * This property can be used for responsive design. e.g: "40em"(or "640px" or "Tablet") setting shows this column in iPad(and Desktop) but hides in iPhone.
			 * Please also see "demandPopin" property
			 */
			minScreenWidth : {type : "string", group : "Behavior", defaultValue : null},
	
			/**
			 * According to your minScreenWidth settings, the column can be hidden in different screen sizes.
			 * Setting this property to true, shows this column as pop-in instead of hiding it.
			 */
			demandPopin : {type : "boolean", group : "Behavior", defaultValue : false},
	
			/**
			 * Horizontal alignment of the pop-in content. Available alignment settings are "Begin", "Center", "End", "Left", and "Right".
			 * 
			 * NOTE: Controls with a text align do not inherit the horizontal alignment.
			 * @deprecated Since version 1.14. 
			 * Use popinDisplay property instead.
			 */
			popinHAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin, deprecated: true},
	
			/**
			 * Defines the display options of pop-in.
			 * Possible values are
			 * 1 - "Block"(Header is displayed in first line and value field in next line.)
			 * 2 - "Inline" (Value field is displayed next to the header in same line.)
			 * @since 1.13.2
			 */
			popinDisplay : {type : "sap.m.PopinDisplay", group : "Appearance", defaultValue : sap.m.PopinDisplay.Block},
	
			/**
			 * Set "true" to merge repeating cells(duplicates) into one.
			 * Also see "mergeFunctionName" property to customize.
			 * Note: this property gets disabled if any column is in pop-in!
			 * @since 1.16
			 */
			mergeDuplicates : {type : "boolean", group : "Behavior", defaultValue : false},
	
			/**
			 * Defines the value getter(serialization) function if "mergeDuplicates" property is set "true"
			 * Control itself uses this function to compare values of two repeating cells.
			 * Default value "getText" is suitable for Label and Text control.
			 * e.g. For "Icon" control "getSrc" can be used.
			 * Note: You can pass one string parameter to given function after "#" sign. e.g. "data#myparameter"
			 * @since 1.16
			 */
			mergeFunctionName : {type : "string", group : "Misc", defaultValue : 'getText'}
		},
		defaultAggregation : "header",
		aggregations : {
	
			/**
			 * Control to be displayed in the column header.
			 */
			header : {type : "sap.ui.core.Control", multiple : false}, 
	
			/**
			 * Control to be displayed in the column footer.
			 */
			footer : {type : "sap.ui.core.Control", multiple : false}
		}
	}});
	
	
	// default index
	Column.prototype._index = -1;
	
	// predefined screen size
	Column.prototype._screen = "";
	
	// default media value
	Column.prototype._media = null;
	
	Column.prototype._clearMedia = function() {
		if (this._media && this._minWidth) {
			sap.ui.Device.media.removeRangeSet(this.getId());
			this._media = null;
		}
	};
	
	Column.prototype._addMedia = function() {
		if (this._minWidth) {
			sap.ui.Device.media.initRangeSet(this.getId(), [parseFloat(this._minWidth)]);
			sap.ui.Device.media.attachHandler(this._notifyResize, this, this.getId());
			this._media = sap.ui.Device.media.getCurrentRange(this.getId());
			if (this._media) {
				this._media.triggered = false;
				this._media.matches = !!this._media.from;
			}
		}
	};
	
	/**
	 * Notify parent to re-render
	 * Also fire media event for listeners
	 *
	 * @private
	 */
	Column.prototype._notifyResize = function(oMedia) {
		// ignore the first call
		if (!this._media.triggered) {
			this._media.triggered = true;
			return;
		}
	
		// keep media info
		this._media = oMedia;
		this._media.triggered = true;
		this._media.matches = !!oMedia.from;
	
		// wait all events to come
		jQuery.sap.delayedCall(0, this, function() {
			var parent = this.getParent();
			this.fireEvent("media", this);
			if (parent && parent.onColumnResize) {
				parent.onColumnResize(this);
			}
		});
	};
	
	Column.prototype._validateMinWidth = function(sWidth) {
		if (Object.prototype.toString.call(sWidth) != "[object String]") {
			throw new Error('expected string for property "minScreenWidth" of ' + this);
		}
		if (Object.keys(sap.m.ScreenSizes).indexOf(sWidth.toLowerCase()) != -1) {
			return;
		}
		if (!/^\d+(\.\d+)?(px|em|rem)$/i.test(sWidth)) {
			throw new Error('invalid CSS size("px", "em", "rem" required) or sap.m.ScreenSize enumeration for property "minScreenWidth" of ' + this);
		}
	};
	
	
	// Checks the given width(px or em), if it is a predefined screen value
	Column.prototype._isWidthPredefined = function(sWidth) {
		var that = this,
			unit = sWidth.replace(/[^a-z]/ig, ""),
			baseFontSize = parseFloat(sap.m.BaseFontSize) || 16;
	
		jQuery.each(sap.m.ScreenSizes, function(screen, size) {
			if (unit != "px") {
				size /= baseFontSize;
			}
			if (size + unit == sWidth) {
				that._minWidth = this + "px";
				that._screen = screen;
				return false;
			}
		});
		
		if (this._minWidth) {
			return true;
		}
		
		if (unit == "px") {
			this._minWidth = sWidth;
		} else {
			this._minWidth = parseFloat(sWidth) * baseFontSize + "px";
		}
	};
	
	/**
	 * Apply text alignment of the Column to Text/Label/Link...
	 *
	 * TODO: This is so ugly to check content functions
	 * instead we should document how to use our controls
	 * to inherit text-alignment and we should add a new
	 * sap.ui.core.TextAlign type called "Inherit"
	 *
	 * @param {sap.ui.core.Control} oControl List control
	 * @param {String} [sAlign] TextAlign enumeration
	 * @return {sap.ui.core.Control} oControl
	 * @protected
	 */
	Column.prototype.applyAlignTo = function(oControl, sAlign) {
		sAlign = sAlign || this.getHAlign();
		if (sAlign === sap.ui.core.TextAlign.Initial ||
			!oControl.getMetadata().getProperties().textAlign ||
			oControl.getTextAlign() === sAlign) {
			return oControl;
		}

		oControl.setProperty("textAlign", sAlign, true);
		var oDomRef = oControl.getDomRef();
		sAlign = this.getCssAlign(sAlign);
		
		if (oDomRef && sAlign) {
			oDomRef.style.textAlign = sAlign;
		}

		return oControl;
	};
	
	
	/**
	 * Returns CSS alignment according to column hAlign setting or given parameter
	 * for Begin/End values checks the locale settings
	 *
	 * @param {String} [sAlign] TextAlign enumeration
	 * @return {String} left|center|right
	 * @protected
	 */
	Column.prototype.getCssAlign = function(sAlign) {
		sAlign = sAlign || this.getHAlign();
		
		var mTextAlign = sap.ui.core.TextAlign;
		if (sAlign === mTextAlign.Begin || sAlign === mTextAlign.End || sAlign === mTextAlign.Initial) {
			sAlign = Renderer.getTextAlign(sAlign);
		}
	
		return sAlign.toLowerCase();
	};
	
	
	// Returns styleClass property with extra responsive class if second parameter is set true
	Column.prototype.getStyleClass = function(bResponsive) {
		var cls = this.getProperty("styleClass");
		if (!bResponsive) {
			return cls;
		}
		if (this._screen && (!this.getDemandPopin() || !window.matchMedia)) {
			cls += " sapMSize-" + this._screen;
		} else if (this._media && !this._media.matches) {
			cls += " sapMListTblNone";
		}
		return cls;
	};
	
	
	/**
	 * Returns visible probability of the column
	 *
	 * @param {boolean} [bReturnCache] Whether return cache or new result
	 * @return {boolean}
	 * @protected
	 */
	Column.prototype.isNeverVisible = function(bReturnCache) {
		if (bReturnCache) {
			return this._isNeverVisible;
		}
	
		if (!this._minWidth) {
			this._isNeverVisible = false;
			return this._isNeverVisible;
		}
	
		var width = parseFloat(this._minWidth),
			unit = this._minWidth.replace(/[^a-z]/g, ""),
			baseFontSize = parseFloat(sap.m.BaseFontSize) || 16;
	
		if (unit != "px") {
			width *= baseFontSize;
		}
	
		this._isNeverVisible = (width > Math.max(window.screen.width, window.screen.height));
		return this._isNeverVisible;
	};
	
	
	/**
	 * Sets the visible column index
	 * Negative index values can be used to clear
	 *
	 * @param {int} nIndex index of the visible column
	 * @protected
	 */
	Column.prototype.setIndex = function(nIndex) {
		this._index = +nIndex;
	};
	
	
	/**
	 * Sets the order of the column
	 * Does not do the visual effect
	 * Table should be invalidate to re-render
	 *
	 * @param {int} nOrder order of the column
	 * @protected
	 */
	Column.prototype.setOrder = function(nOrder) {
		this._order = +nOrder;
	};
	
	/**
	 * Gets the order of the column
	 *
	 * @returns {int} nOrder order of the column
	 * @protected
	 */
	Column.prototype.getOrder = function() {
		return this.hasOwnProperty("_order") ? this._order : this.getInitialOrder();
	};
	
	/**
	 * Sets the initial order of the column
	 *
	 * @param {int} nOrder initial order of the column
	 * @protected
	 */
	Column.prototype.setInitialOrder = function(nOrder) {
		this._initialOrder = +nOrder;
	};
	
	/**
	 * Gets the initial order of the column
	 *
	 * @returns {int} initial order of the column
	 * @protected
	 */
	Column.prototype.getInitialOrder = function() {
		if (this.hasOwnProperty("_initialOrder")) {
			return this._initialOrder;
		}
	
		var oParent = this.getParent();
		if (oParent && oParent.indexOfColumn) {
			return oParent.indexOfColumn(this);
		}
	
		return -1;
	};
	
	/**
	 * Display or hide the column from given table
	 * This does not set the visibility property of the column
	 *
	 * @param {Object} oTableDomRef Table DOM reference
	 * @param {boolean} [bDisplay] whether visible or not
	 * @protected
	 */
	Column.prototype.setDisplay = function(oTableDomRef, bDisplay) {
		if (!oTableDomRef || this._index < 0) {
			return;
		}
	
		// go with native we need speed
		var i = this._index + 1,
			parent =  this.getParent(),
			display = bDisplay ? "table-cell" : "none",
			header = oTableDomRef.querySelector("tr > th:nth-child(" + i + ")"),
			cells = oTableDomRef.querySelectorAll("tr > td:nth-child(" + i + ")"),
			length = cells.length;
	
		// set display and aria
		header.style.display = display;
		header.setAttribute("aria-hidden", !bDisplay);
		for (i = 0; i < length; i++) {
			cells[i].style.display = display;
			cells[i].setAttribute("aria-hidden", !bDisplay);
		}
	
		// let the parent know the visibility change
		if (parent && parent.setTableHeaderVisibility) {
			// make it sure rendering phase is done with timeout
			setTimeout(function() {
				parent.setTableHeaderVisibility(bDisplay);
			}, 0);
		}
	};
	
	/**
	 * Display or hide the column from given table via checking media query changes
	 *
	 * @param {Object} oTableDomRef Table DOM reference
	 * @protected
	 */
	Column.prototype.setDisplayViaMedia = function(oTableDomRef) {
		var oParent = this.getParent(),
			bDisplay = this._media && this._media.matches;
	
		if (!this.getDemandPopin() && this._screen && oParent && oParent.setTableHeaderVisibility) {
			// this means CSS media queries already change the column visibility
			// let the parent know the visibility change
			// make it sure rendering phase is done with timeout
			setTimeout(function() {
				oParent.setTableHeaderVisibility(bDisplay);
			}, 0);
		} else {
			this.setDisplay(oTableDomRef, bDisplay);
		}
	};
	
	Column.prototype.setVisible = function(bVisible) {
		if (bVisible == this.getVisible()) {
			return this;
		}
		
		var oParent = this.getParent(),
			oTableDomRef = oParent && oParent.getTableDomRef && oParent.getTableDomRef(),
			bSupressInvalidate = oTableDomRef && this._index >= 0;
	
		this.setProperty("visible", bVisible, bSupressInvalidate);
		if (bSupressInvalidate) {
			this.setDisplay(oTableDomRef, bVisible);
		}
	
		return this;
	};
	
	/*
	 * Decides if we need media query or not according to given settings
	 * Checks the given width is known screen size
	 */
	Column.prototype.setMinScreenWidth = function(sWidth) {
		// check if setting the old value
		if (sWidth == this.getMinScreenWidth()) {
			return this;
		}
	
		// first validate the value
		this._validateMinWidth(sWidth);
	
		// initialize
		this._clearMedia();
		this._minWidth = 0;
		this._screen = "";
	
		if (sWidth) {
			// check given width is known screen-size
			sWidth = sWidth.toLowerCase();
			var width = sap.m.ScreenSizes[sWidth];
			if (width) {
				this._screen = sWidth;
				this._minWidth = width + "px";
			} else {
				this._isWidthPredefined(sWidth);
			}

			this._addMedia();
		}
	
		return this.setProperty("minScreenWidth", sWidth);
	};
	
	/*
	 * Decides if we need media query or not according to given settings
	 * if pop-in is demanded then we always need JS media queries
	 * if not demanded but if screen size is known CSS media query can handle
	 */
	Column.prototype.setDemandPopin = function(bValue) {
		// check if setting the old value
		if (bValue == this.getDemandPopin()) {
			return this;
		}
	
		// minimum width should have been set
		if (!this.getMinScreenWidth()) {
			return this.setProperty("demandPopin", bValue, true);
		}
	
		return this.setProperty("demandPopin", bValue);
	};
	
	
	/**
	 * Checks the column will be shown as pop-in
	 *
	 * @protected
	 */
	Column.prototype.isPopin = function() {
		if (!this.getDemandPopin()) {
			return false;
		}
		if (this._media) {
			return !this._media.matches;
		}
		return false;
	};
	
	/**
	 * Checks the column will be hidden
	 *
	 * @protected
	 */
	Column.prototype.isHidden = function() {
		if (this._media) {
			return !this._media.matches;
		}
	
		if (this._screen && this._minWidth) {
			return parseFloat(this._minWidth) > window.innerWidth;
		}
		return false;
	};
	
	/**
	 * Sets the last value of the column if mergeDuplicates property is true
	 *
	 * @param {any} value Any Value
	 * @returns {sap.m.Column}
	 * @since 1.16
	 * @protected
	 */
	Column.prototype.setLastValue = function(value) {
		if (this.getMergeDuplicates()) {
			this._lastValue = value;
		}
		return this;
	};
	
	/**
	 * Clears the last value of the column if mergeDuplicates property is true
	 *
	 * @returns {sap.m.Column}
	 * @since 1.20.4
	 * @protected
	 */
	Column.prototype.clearLastValue = function() {
		return this.setLastValue(NaN);
	};
	
	/**
	 * Gets the last value of the column
	 *
	 * @since 1.16
	 * @protected
	 */
	Column.prototype.getLastValue = function() {
		return this._lastValue;
	};
	
	/**
	 * Gets called from the Table when the all items are removed
	 *
	 * @since 1.16
	 * @protected
	 */
	Column.prototype.onItemsRemoved = function() {
		this.clearLastValue();
	};
	
	/**
	 * Determines whether the given width is relative or not
	 *
	 * @private
	 * @returns {boolean}
	 */
	Column.prototype.isRelativeWidth = function() {
		return /^(|auto|[-+]?\d+\.?\d*%|inherit)$/i.test(this.getWidth());
	};
	
	/**
	 * Determines whether box-sizing content-box works for columns or not
	 * Native android browsers does not honour content-box for fixed table layout
	 * https://bugs.webkit.org/show_bug.cgi?id=18565
	 * 
	 * @protected
	 * @readonly
	 * @static
	 */
	Column.bContentBoxSupport = (function() {
		var iWidth = 5,
			sTable = "<table style='table-layout:fixed; width:" + iWidth + "px; position:absolute; left:-999px; top:-999px'>" +
						"<tr><td style='width:" + iWidth + "px; padding:1px; border:1px solid transparent;'></td></tr>" +
					"</table>",
			$Table = jQuery(sTable);

		jQuery(document.documentElement).append($Table);
		var iContentWidth = $Table.find("td").width();
		$Table.remove();

		return (iContentWidth == iWidth);
	})();
	
	/**
	 * Gets called from the parent after all cells in column are rendered
	 *
	 * @param {jQuery} $Table Table jQuery reference
	 * @param {Boolean} [bAutoTableLayout] Table layout
	 * @see sap.m.Column#bContentBoxSupport
	 * @protected
	 */
	Column.prototype.onColumnRendered = function($Table, bAutoTableLayout) {
		// native android browsers does not honour box-sizing content-box for fixed table layout
		// if there is no content-box support and column is visible and not in popin then run the workaround
		if (bAutoTableLayout ||
			Column.bContentBoxSupport ||
			!this.getVisible() ||
			this.isRelativeWidth() ||
			this.isPopin() ||
			this.isNeverVisible()) {
			return;
		}

		var $Header = $Table.find("th").eq(this._index),
			iOuterWidth = $Header.outerWidth(),
			iContentWidth = $Header.width(),
			iWidth = 2 * iOuterWidth - iContentWidth;

		// set the outer-width as column width
		$Header.attr("data-sap-width", iWidth + "px");
		$Header.width(iWidth);
	};

	return Column;

}, /* bExport= */ true);

}; // end of sap/m/Column.js
if ( !jQuery.sap.isDeclared('sap.m.ColumnListItemRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.ColumnListItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ColumnListItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', './ListRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, ListRenderer, Renderer) {
	"use strict";


	/**
	 * ColumnListItem renderer.
	 * @namespace
	 */
	var ColumnListItemRenderer = Renderer.extend(ListItemBaseRenderer);
	
	ColumnListItemRenderer.render = function(rm, oLI) {
		var oTable = oLI.getTable();
		if (!oTable) {
			return;
		}

		ListItemBaseRenderer.render.apply(this, arguments);

		if (oLI.getVisible() && oTable.hasPopin()) {
			this.renderPopin(rm, oLI, oTable);
		}
	};

	ColumnListItemRenderer.openItemTag = function(rm, oLI) {
		rm.write("<tr");
	};

	ColumnListItemRenderer.closeItemTag = function(rm, oLI) {
		rm.write("</tr>");
	};

	ColumnListItemRenderer.handleNoFlex = function(rm, oLI) {
	};

	// render type content always within a cell
	ColumnListItemRenderer.renderType = function(rm, oLI) {
		rm.write('<td role="gridcell" class="sapMListTblNavCol"');
		
		if (oLI.getSelected()) {
			rm.writeAttribute("aria-selected", "true");
		}
		
		if (!oLI.needsTypeColumn()) {
			rm.writeAttribute("aria-hidden", "true");
		}
		
		rm.write('>');
		
		// let the list item base render the type
		ListItemBaseRenderer.renderType.apply(this, arguments);
		
		rm.write('</td>');
	};

	// wrap mode content with a cell
	ColumnListItemRenderer.renderModeContent = function(rm, oLI) {
		rm.write('<td role="gridcell" class="sapMListTblSelCol"');
		oLI.getSelected() && rm.writeAttribute("aria-selected", "true");
		rm.write('>');
		
		// let the list item base render the mode control
		ListItemBaseRenderer.renderModeContent.apply(this, arguments);
		
		rm.write('</td>');
	};

	// ColumnListItem does not respect counter property of the LIB
	ColumnListItemRenderer.renderCounter = function(rm, oLI) {
	};
	
	// Returns aria accessibility role
	ColumnListItemRenderer.getAriaRole = function(oLI) {
		return "row";
	};
	
	// Returns the inner aria labelledby ids for the accessibility
	ColumnListItemRenderer.getAriaLabelledBy = function(oLI) {
		var oTable = oLI.getTable(); 
		if (!oTable || !oTable.hasPopin()) {
			return;
		}
		
		// when table has pop-in let the screen readers announce it
		return oLI.getId() + " " + oLI.getId() + "-sub";
	};
	
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ColumnListItemRenderer.renderLIAttributes = function(rm, oLI) {
		rm.addClass("sapMListTblRow");
		var vAlign = oLI.getVAlign();
		if (vAlign != sap.ui.core.VerticalAlign.Inherit) {
			rm.addClass("sapMListTblRow" + vAlign);
		}
	};
	
	
	/**
	 * Overwriting hook method of ListItemBase
	 *
	 * @public
	 *
	 * @param {sap.ui.core.RenderManager} rm RenderManager
	 * @param {sap.m.ListItemBase} oLI List item
	 */
	ColumnListItemRenderer.renderLIContentWrapper = function(rm, oLI) {
		var oTable = oLI.getTable();
		if (!oTable) {
			return;
		}
	
		var aColumns = oTable.getColumns(true),
			aCells = oLI.getCells(),
			bSelected = oLI.getSelected();
	
		// remove cloned headers
		oLI.destroyClonedHeaders();
	
		aColumns.forEach(function(oColumn, i) {
			var cls,
				oHeader,
				bRenderCell = true,
				oCell = aCells[oColumn.getInitialOrder()];
	
			if (!oCell || !oColumn.getVisible() || oColumn.isNeverVisible(true) || oColumn.isPopin()) {
				// update the visible index of the column
				oColumn.setIndex(-1);
				return;
			}
	
			rm.write("<td");
			rm.addClass("sapMListTblCell");
			rm.writeAttribute("id", oLI.getId() + "_cell" + i);
			rm.writeAttribute("role", "gridcell");
			
			if (bSelected) {
				// write aria-selected explicitly for the cells
				rm.writeAttribute("aria-selected", "true");
			}
	
			// check column properties
			if (oColumn) {
				cls = oColumn.getStyleClass(true);
				cls && rm.addClass(cls);
				
				// aria for virtual keyboard mode
				oHeader = oColumn.getHeader();
				if (oHeader) {
					rm.writeAttribute("aria-describedby", oHeader.getId());
				}
				
				// merge duplicate cells
				if (!oTable.hasPopin() && oColumn.getMergeDuplicates()) {
					var sFuncWithParam = oColumn.getMergeFunctionName(),
						aFuncWithParam = sFuncWithParam.split("#"),
						sFuncParam = aFuncWithParam[1],
						sFuncName = aFuncWithParam[0];
	
					if (typeof oCell[sFuncName] != "function") {
						jQuery.sap.log.warning("mergeFunctionName property is defined on " + oColumn + " but this is not function of " + oCell);
					} else {
						var lastColumnValue = oColumn.getLastValue(),
							cellValue = oCell[sFuncName](sFuncParam);
	
						if (lastColumnValue === cellValue) {
							// it is not necessary to render cell content but
							// screen readers need content to announce it
							bRenderCell = sap.ui.getCore().getConfiguration().getAccessibility();
							oCell.addStyleClass("sapMListTblCellDupCnt");
							rm.addClass("sapMListTblCellDup");
						} else {
							oColumn.setLastValue(cellValue);
						}
					}
				}
	
				oColumn.getVAlign() != "Inherit" && rm.addStyle("vertical-align", oColumn.getVAlign().toLowerCase());
				var sAlign = oColumn.getCssAlign();
				if (sAlign) {
					rm.addStyle("text-align", sAlign);
				}
				
				rm.writeStyles();
			}
	
			rm.writeClasses();
			rm.write(">");
			if (bRenderCell) {
				rm.renderControl(oColumn.applyAlignTo(oCell));
			}
			rm.write("</td>");
		});
	};
	
	
	/**
	 * Renders pop-ins for Table Rows
	 *
	 * @private
	 *
	 * @param {sap.ui.core.RenderManager} rm RenderManager
	 * @param {sap.m.ListItemBase} oLI List item
	 * @param {sap.m.Table} oTable Table control
	 */
	ColumnListItemRenderer.renderPopin = function(rm, oLI, oTable) {
		oLI._popinId = oLI.getId() + "-sub";
		rm.write("<tr class='sapMListTblSubRow'");
		rm.writeAttribute("id", oLI._popinId);
		rm.writeAttribute("role", "row");
		rm.writeAttribute("tabindex", "-1");
		
		// logical parent of the popin is the base row
		rm.writeAttribute("aria-owns", oLI.getId());
		
		rm.write("><td");
		rm.writeAttribute("role", "gridcell");
		rm.writeAttribute("colspan", oTable.getColCount());
		rm.write("><div class='sapMListTblSubCnt'>");
	
		var aCells = oLI.getCells(),
			aColumns = oTable.getColumns(true);
	
		aColumns.forEach(function(oColumn) {
			if (!oColumn.getVisible() || !oColumn.isPopin()) {
				return;
			}
	
			var oCell = aCells[oColumn.getInitialOrder()],
				oHeader = oColumn.getHeader();
	
			if (!oHeader && !oCell) {
				return;
			}
	
			var sStyleClass = oColumn.getStyleClass(),
				sPopinDisplay = oColumn.getPopinDisplay();
	
			/* row start */
			rm.write("<div");
			rm.addClass("sapMListTblSubCntRow");
			sStyleClass && rm.addClass(sStyleClass);
			rm.writeClasses();
			rm.write(">");
	
			/* header cell */
			if (oHeader && sPopinDisplay != sap.m.PopinDisplay.WithoutHeader) {
				rm.write("<div");
				rm.addClass("sapMListTblSubCntHdr");
				rm.writeClasses();
				rm.write(">");
				oHeader = oHeader.clone();
				oColumn.addDependent(oHeader);
				oLI.addClonedHeader(oHeader);
				oColumn.applyAlignTo(oHeader, "Begin");
				rm.renderControl(oHeader);
				rm.write("</div>");
	
				/* separator cell */
				rm.write("<div class='sapMListTblSubCntSpr'>:</div>");
			}
	
			/* value cell */
			if (oCell) {
				rm.write("<div");
				rm.addClass("sapMListTblSubCntVal");
				rm.addClass("sapMListTblSubCntVal" + sPopinDisplay);
				rm.writeClasses();
				rm.write(">");
				oColumn.applyAlignTo(oCell, "Begin");
				rm.renderControl(oCell);
				rm.write("</div>");
			}
	
			/* row end */
			rm.write("</div>");
		});
	
		rm.write("</div></td></tr>");
	};

	return ColumnListItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/ColumnListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ComboBoxBaseRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.ComboBoxBaseRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ComboBoxBaseRenderer",['jquery.sap.global', './InputBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, InputBaseRenderer, Renderer) {
		"use strict";

		/**
		 * ComboBoxBase renderer.
		 *
		 * @namespace
		 */
		var ComboBoxBaseRenderer = Renderer.extend(InputBaseRenderer);

		/**
		 * CSS class to be applied to the root element of the ComboBoxBase.
		 *
		 * @readonly
		 * @const {string}
		 */
		ComboBoxBaseRenderer.CSS_CLASS = "sapMComboBoxBase";

		/**
		 * Add attributes to the input element.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxBaseRenderer.writeInnerAttributes = function(oRm, oControl) {
			oRm.writeAttribute("autocomplete", "off");
			oRm.writeAttribute("autocorrect", "off");
			oRm.writeAttribute("autocapitalize", "off");
		};

		/**
		 * Writes the accessibility state.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxBaseRenderer.writeAccessibilityState = function(oRm, oControl) {
			InputBaseRenderer.writeAccessibilityState.apply(this, arguments);
			oRm.writeAccessibilityState(oControl, {
				role: "combobox",
				expanded: oControl.isOpen(),
				autocomplete: "both"
			});
		};

		/**
		 * Add extra styles for input container.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxBaseRenderer.addOuterStyles = function(oRm, oControl) {
			oRm.addStyle("max-width", oControl.getMaxWidth());
		};

		/**
		 * Add classes to the ComboBox.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxBaseRenderer.addOuterClasses = function(oRm, oControl) {
			var CSS_CLASS = ComboBoxBaseRenderer.CSS_CLASS;

			oRm.addClass(CSS_CLASS);
			oRm.addClass(CSS_CLASS + "Input");

			if (!oControl.getEnabled()) {
				oRm.addClass(CSS_CLASS + "Disabled");
			}

			if (!oControl.getEditable()) {
				oRm.addClass(CSS_CLASS + "Readonly");
			}
		};

		/**
		 * Add inner classes to the ComboBox's input element.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxBaseRenderer.addInnerClasses = function(oRm, oControl) {
			var CSS_CLASS = ComboBoxBaseRenderer.CSS_CLASS;
			oRm.addClass(CSS_CLASS + "InputInner");

			if (!oControl.getEditable()) {
				oRm.addClass(CSS_CLASS + "InputInnerReadonly");
			}
		};

		/**
		 * Add the CSS value state classes to the control's root element using the provided {@link sap.ui.core.RenderManager}.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxBaseRenderer.addValueStateClasses = function(oRm, oControl) {
			InputBaseRenderer.addValueStateClasses.apply(this, arguments);
			var CSS_CLASS = ComboBoxBaseRenderer.CSS_CLASS;
			oRm.addClass(CSS_CLASS + "State");
			oRm.addClass(CSS_CLASS + oControl.getValueState());
		};

		/**
		 * Renders the ComboBox's arrow, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxBaseRenderer.writeInnerContent = function(oRm, oControl) {
			this.renderButton(oRm, oControl);
		};

		/**
		 * Renders the combo box button, using the provided {@link sap.ui.core.RenderManager}.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxBaseRenderer.renderButton = function(oRm, oControl) {
			var sId = oControl.getId(),
				sButtonId = sId + "-arrow",
				sButtonLabelId = sId + "-buttonlabel",
				oRb = sap.ui.getCore().getLibraryResourceBundle("sap.m");

			oRm.write('<button tabindex="-1"');
			oRm.writeAttribute("id", sButtonId);
			oRm.writeAttribute("aria-labelledby", sButtonLabelId);
			this.addButtonClasses(oRm, oControl);
			oRm.writeClasses();
			oRm.write(">");
			oRm.write("<label");
			oRm.writeAttribute("id", sButtonLabelId);
			oRm.addClass("sapUiInvisibleText");
			oRm.addClass(ComboBoxBaseRenderer.CSS_CLASS + "ButtonLabel");
			oRm.writeClasses();
			oRm.write(">");
			oRm.write(oRb.getText("COMBOBOX_BUTTON"));
			oRm.write("</label>");
			oRm.write("</button>");
		};

		/**
		 * Add CSS classes to the combo box arrow button, using the provided {@link sap.ui.core.RenderManager}.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxBaseRenderer.addButtonClasses = function(oRm, oControl) {
			oRm.addClass(ComboBoxBaseRenderer.CSS_CLASS + "Arrow");
		};

		return ComboBoxBaseRenderer;

	}, /* bExport= */ true);
}; // end of sap/m/ComboBoxBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ComboBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.ComboBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ComboBoxRenderer",['jquery.sap.global', './ComboBoxBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ComboBoxBaseRenderer, Renderer) {
		"use strict";

		/**
		 * ComboBox renderer.
		 *
		 * @namespace
		 */
		var ComboBoxRenderer = Renderer.extend(sap.m.ComboBoxBaseRenderer);

		/**
		 * CSS class to be applied to the root element of the ComboBox.
		 *
		 * @readonly
		 * @const {string}
		 */
		ComboBoxRenderer.CSS_CLASS = "sapMComboBox";

		/**
		 * Add classes to the ComboBox.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxRenderer.addOuterClasses = function(oRm, oControl) {
			ComboBoxBaseRenderer.addOuterClasses.apply(this, arguments);
			var CSS_CLASS = ComboBoxRenderer.CSS_CLASS;
			oRm.addClass(CSS_CLASS);
			oRm.addClass(CSS_CLASS + "Input");
		};

		/**
		 * Add inner classes to the ComboBox's input element.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxRenderer.addInnerClasses = function(oRm, oControl) {
			ComboBoxBaseRenderer.addInnerClasses.apply(this, arguments);
			oRm.addClass(ComboBoxRenderer.CSS_CLASS + "InputInner");
		};

		/**
		 * Add CSS classes to the combo box arrow button, using the provided {@link sap.ui.core.RenderManager}.
		 * To be overwritten by subclasses.
		 *
		 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
		 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
		 */
		ComboBoxRenderer.addButtonClasses = function(oRm, oControl) {
			ComboBoxBaseRenderer.addButtonClasses.apply(this, arguments);
			oRm.addClass(ComboBoxRenderer.CSS_CLASS + "Arrow");
		};

		ComboBoxRenderer.addPlaceholderClasses = function(oRm, oControl) {
			ComboBoxBaseRenderer.addPlaceholderClasses.apply(this, arguments);
			oRm.addClass(ComboBoxRenderer.CSS_CLASS + "Placeholder");
		};

		return ComboBoxRenderer;

	}, /* bExport= */ true);
}; // end of sap/m/ComboBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.CustomListItemRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.CustomListItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/CustomListItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, Renderer) {
	"use strict";


	/**
	 * CustomListItem renderer.
	 * @namespace
	 */
	var CustomListItemRenderer = Renderer.extend(ListItemBaseRenderer);
	
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	CustomListItemRenderer.renderLIAttributes = function(rm, oLI) {
		rm.addClass("sapMCLI");
	};
	
	CustomListItemRenderer.renderLIContent = function(rm, oLI) {
		var aContent = oLI.getContent();
		var cLength = aContent.length;
		for ( var i = 0; i < cLength; i++) {
			rm.renderControl(aContent[i]);
		}
	};

	return CustomListItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/CustomListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.CustomTileRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.CustomTileRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/CustomTileRenderer",['jquery.sap.global', './TileRenderer'],
	function(jQuery, TileRenderer) {
	"use strict";

/**
	 * CustomTile renderer.
	 * @namespace
	 */
	var CustomTileRenderer = sap.ui.core.Renderer.extend(TileRenderer);

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *                oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control}
	 *                oControl an object representation of the control that should be rendered
	 */
	 CustomTileRenderer.render = function(rm, oControl) {
		rm.write("<div tabindex=\"0\"");
		rm.writeControlData(oControl);
		rm.addClass("sapMCustomTile");
		rm.writeClasses();
		if (oControl._invisible) {
			rm.addStyle("visibility", "hidden");
			rm.writeStyles();
		}

		/* WAI ARIA if in TileContainer context */
		if (oControl.getParent() instanceof sap.m.TileContainer) {
			rm.writeAccessibilityState({
				role: "option",
				posinset: oControl._getTileIndex(),
				setsize: oControl._getTilesCount()
			});
		}

		rm.write(">");
		rm.write("<div id=\"" + oControl.getId() + "-remove\" class=\"sapMTCRemove\"></div>");
		rm.write("<div class=\"sapMCustomTileContent\">");
		this._renderContent(rm,oControl);
		rm.write("</div></div>");
	};

	CustomTileRenderer._renderContent = function (rm, oTile) {
		rm.renderControl(oTile.getContent());
	};

	return CustomTileRenderer;

}, /* bExport= */ true);

}; // end of sap/m/CustomTileRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.DatePickerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.DatePickerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/DatePickerRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './InputBaseRenderer'],
	function(jQuery, Renderer, InputBaseRenderer) {
	"use strict";


	/**
	 * DatePicker renderer.
	 * @namespace
	 */
	var DatePickerRenderer = Renderer.extend(InputBaseRenderer);

	/**
	 * Adds control specific class
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.DatePicker} oDP an object representation of the control that should be rendered
	 */
	DatePickerRenderer.addOuterClasses = function(oRm, oDP) {

		oRm.addClass("sapMDP");
		if (oDP.getEnabled() && oDP.getEditable()) {
			oRm.addClass("sapMInputVH"); // just reuse styling of value help icon
		}

		if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 11) {
			oRm.addClass("sapMInputIE9");
		}

	};

	/**
	 * add extra content to Input
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.m.DatePicker} oDP an object representation of the control that should be rendered
	 */
	DatePickerRenderer.writeInnerContent = function(oRm, oDP) {

		if (oDP.getEnabled() && oDP.getEditable()) {
			var aClasses = ["sapMInputValHelpInner"];
			var mAttributes = {};

			mAttributes["id"] = oDP.getId() + "-icon";
			mAttributes["tabindex"] = "-1"; // to get focus events on it, needed for popup autoclose handling
			oRm.write('<div class="sapMInputValHelp">');
			oRm.writeIcon("sap-icon://appointment-2", aClasses, mAttributes);
			oRm.write("</div>");
		}

		// invisible span with description for keyboard navigation
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");
			// ResourceBundle always returns the key if the text is not found
		// ResourceBundle always returns the key if the text is not found
		var sText = rb.getText("DATEPICKER_DATE_TYPE");

		var sTooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oDP, oDP.getTooltip_AsString());
		if (sTooltip) {
			// add tooltip to description because it is not read by JAWS from title-attribute if a label is assigned
			sText = sText + ". " + sTooltip;
		}
		oRm.write('<SPAN id="' + oDP.getId() + '-Descr" style="visibility: hidden; display: none;">');
		oRm.writeEscaped(sText);
		oRm.write('</SPAN>');

	};

	/**
	 * Write the value of the input.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.m.DatePicker} oDP An object representation of the control that should be rendered.
	 */
	DatePickerRenderer.writeInnerValue = function(oRm, oDP) {

		oRm.writeAttributeEscaped("value", oDP._formatValue(oDP.getDateValue()));

	};

	/**
	 * This method is reserved for derived classes to add extra attributes for the input element.
	 *
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.m.DatePicker} oDP An object representation of the control that should be rendered.
	 */
	DatePickerRenderer.writeInnerAttributes = function(oRm, oDP) {

		if (oDP._bMobile) {
			// prevent keyboard in mobile devices
			oRm.writeAttribute("readonly", "readonly");
		}

	};

	DatePickerRenderer.writeAccessibilityState = function(oRm, oDP) {

		var mProps = {
			role: "combobox",
			multiline: false,
			autocomplete: "none",
			haspopup: true,
			owns: oDP.getId() + "-cal",
			describedby: {value: oDP.getId() + "-Descr", append: true}};

		if (oDP.getValueState() == sap.ui.core.ValueState.Error) {
			mProps["invalid"] = true;
		}

		oRm.writeAccessibilityState(oDP, mProps);

	};

	return DatePickerRenderer;

}, /* bExport= */ true);

}; // end of sap/m/DatePickerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.DateRangeSelectionRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.DateRangeSelectionRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/DateRangeSelectionRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './DatePickerRenderer'],
	function(jQuery, Renderer, DatePickerRenderer) {
	"use strict";


	/**
	 * DateRangeSelection renderer.
	 * @namespace
	 */
	var DateRangeSelectionRenderer = Renderer.extend(DatePickerRenderer);

	/**
	 * Write the value of the input.
	 *
	 * @public
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
	 */
	DateRangeSelectionRenderer.writeInnerValue = function(oRm, oControl) {

		oRm.writeAttributeEscaped("value", oControl._formatValue(oControl.getDateValue(), oControl.getSecondDateValue()));

	};

	return DateRangeSelectionRenderer;

}, /* bExport= */ true);

}; // end of sap/m/DateRangeSelectionRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.DateTimeInputRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.m.DateTimeInputRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/DateTimeInputRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './InputBaseRenderer'],
	function(jQuery, Renderer, InputBaseRenderer) {
	"use strict";


	
	/**
	 * DateTimeInput renderer.
	 * @namespace
	 *
	 * For a common look & feel,
	 * DateTimeInputRenderer extends the InputRenderer
	 */
	var DateTimeInputRenderer = Renderer.extend(InputBaseRenderer);
	
	/**
	 * Adds control specific class
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	DateTimeInputRenderer.addOuterClasses = function(oRm, oControl) {
		oRm.addClass("sapMDTI");
	};
	
	/**
	 * Add pointer cursor to date-time input
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	DateTimeInputRenderer.addCursorClass = function(oRm, oControl) {
		if (oControl.getEnabled() && oControl.getEditable()) {
			oRm.addClass("sapMPointer");
		}
	};
	
	/**
	 * Add extra styles for input container
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	DateTimeInputRenderer.addOuterStyles = function(oRm, oControl) {
		oRm.addStyle("width", oControl.getWidth());
	};

	return DateTimeInputRenderer;

}, /* bExport= */ true);

}; // end of sap/m/DateTimeInputRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.DisplayListItemRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.DisplayListItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/DisplayListItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, Renderer) {
	"use strict";


	/**
	 * DisplayListItem renderer.
	 * @namespace
	 */
	var DisplayListItemRenderer = Renderer.extend(ListItemBaseRenderer);
	
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *          oRenderManager the RenderManager that can be used for writing to the
	 *          Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be
	 *          rendered
	 */
	DisplayListItemRenderer.renderLIAttributes = function(rm, oLI) {
		rm.addClass("sapMDLI");
	};
	
	DisplayListItemRenderer.renderLIContent = function(rm, oLI) {
	
		var isLabel = oLI.getLabel();
	
		// List item label
		if (isLabel) {
			rm.write("<label for='" + oLI.getId() + "-value' class='sapMDLILabel'>");
			rm.writeEscaped(oLI.getLabel());
			rm.write("</label>");
		}
		
		var isValue = oLI.getValue();
		var sValueTextDir = oLI.getValueTextDirection();

		// List item value
		if (isValue) {
			rm.write("<div id='" + oLI.getId() + "-value' class='sapMDLIValue'");

			if (sValueTextDir != sap.ui.core.TextDirection.Inherit) {
				rm.writeAttribute("dir", sValueTextDir.toLowerCase());
			}

			rm.write(">");
			rm.writeEscaped(oLI.getValue());
			rm.write("</div>");
		}
	};
	

	return DisplayListItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/DisplayListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FacetFilterItemRenderer') ) {
/*
 * @copyright
 */

jQuery.sap.declare('sap.m.FacetFilterItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/FacetFilterItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, Renderer) {
	"use strict";


	var FacetFilterItemRenderer = Renderer.extend(ListItemBaseRenderer);
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *          oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be rendered
	 */
	FacetFilterItemRenderer.renderLIContent = function(oRm, oControl) {
	
		oRm.write("<div");
		if (oControl.getParent() && oControl.getParent().getWordWrap()) {
			oRm.addClass("sapMFFLITitleWrap");
		} else {
			oRm.addClass("sapMFFLITitle");
		}
		oRm.writeClasses();
		oRm.write(">");
	  oRm.writeEscaped(oControl.getText());
	  oRm.write("</div>");
	};
	

	return FacetFilterItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/FacetFilterItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FacetFilterListRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.FacetFilterListRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/FacetFilterListRenderer",['jquery.sap.global', './ListRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListRenderer, Renderer) {
	"use strict";

	/**
	 * FacetFilterList renderer.
	 *
	 * ListRenderer extends the ListBaseRenderer
	 * @namespace
	 * @alias sap.m.FacetFilterListRenderer
	 */
	var FacetFilterListRenderer = Renderer.extend(ListRenderer);

	return FacetFilterListRenderer;

}, /* bExport= */ true);

}; // end of sap/m/FacetFilterListRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FeedInput') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.FeedInput.
jQuery.sap.declare('sap.m.FeedInput'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.HTML'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/FeedInput",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/HTML', 'sap/ui/core/IconPool'],
	function(jQuery, library, Control, HTML, IconPool) {
	"use strict";


	
	/**
	 * Constructor for a new FeedInput.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The Feed Input allows the user to enter text for a new feed entry and then post it.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.22
	 * @alias sap.m.FeedInput
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FeedInput = Control.extend("sap.m.FeedInput", /** @lends sap.m.FeedInput.prototype */ { metadata : {

		library : "sap.m",
		properties : {

			/**
			 * Set this flag to "false" to disable both text input and post button.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * The maximum length (the maximum number of characters) for the feed input's value. By default this is not limited.
			 */
			maxLength : {type : "int", group : "Behavior", defaultValue : 0},

			/**
			 * The placeholder text shown in the input area as long as the user has not entered any text value.
			 */
			placeholder : {type : "string", group : "Appearance", defaultValue : "Post something here"},

			/**
			 * The text value of the feed input. As long as the user has not entered any text the post butoon is disabled
			 */
			value : {type : "string", group : "Data", defaultValue : null},

			/**
			 * Icon to be displayed as a graphical element within the feed input. This can be an image or an icon from the icon font.
			 */
			icon : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},

			/**
			 * If set to "true" (default), icons will be displayed. In case no icon is provided the standard placeholder will be displayed. if set to "false" icons are hidden
			 */
			showIcon : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Some mobile devices support higher resolution images while others do not. Therefore, you should provide image resources for all relevant densities.
			 * If the property is set to "true", one or more requests are sent to the server to try and get the perfect density version of an image. If an image of a certain density is not available, the image control falls back to the default image, which should be provided.
			 *
			 * If you do not have higher resolution images, you should set the property to "false" to avoid unnecessary round-trips.
			 *
			 * Please be aware that this property is relevant only for images and not for icons.
			 */
			iconDensityAware : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * Sets a new tooltip for submit button. The tooltip can either be a simple string (which in most cases will be rendered as the title attribute of this Element)
			 * or an instance of sap.ui.core.TooltipBase.
			 * If a new tooltip is set, any previously set tooltip is deactivated.
			 * The default value is set language dependent.
			 * @since 1.28
			 */
			buttonTooltip : {type : "string" , altTypes : ["sap.ui.core.TooltipBase"], multiple : false, group : "Data", defaultValue : "Submit"}
		},

		events : {

			/**
			 * The post event is triggered when the user has entered a value and pressed the post button. After firing this event the value is reset.
			 */
			post : {
				parameters : {
					/**
					 * The value of the feed input before reseting it.
					 */
					value : {type : "string"}
				}
			}
		}
	}});



	/////////////////////////////////// Lifecycle /////////////////////////////////////////////////////////

	/**
	 * Overrides sap.ui.core.Element.init
	 */
	FeedInput.prototype.init = function () {
		// override text defaults
		var oBundle = sap.ui.getCore().getLibraryResourceBundle("sap.m");
		this.setProperty("placeholder", oBundle.getText("FEEDINPUT_PLACEHOLDER"), true);
		this.setProperty("buttonTooltip", oBundle.getText("FEEDINPUT_SUBMIT"), true);
	};

	/**
	 * Overrides sap.ui.core.Element.exit
	 */
	FeedInput.prototype.exit = function () {
		if (this._oTextArea) {
			this._oTextArea.destroy();
		}
		if (this._oButton) {
			this._oButton.destroy();
		}
		if (this._oImageControl) {
			this._oImageControl.destroy();
		}
	};

	/////////////////////////////////// Properties /////////////////////////////////////////////////////////

	FeedInput.prototype.setIconDensityAware = function (iIconDensityAware) {
		this.setProperty("iconDensityAware", iIconDensityAware, true);
		if (this._getImageControl() instanceof sap.m.Image) {
			this._getImageControl().setDensityAware(iIconDensityAware);
		}
		return this;
	};

	FeedInput.prototype.setMaxLength = function (iMaxLength) {
		this.setProperty("maxLength", iMaxLength, true);
		this._getTextArea().setMaxLength(iMaxLength);
		return this;
	};

	FeedInput.prototype.setValue = function (sValue) {
		this.setProperty("value", sValue, true);
		this._getTextArea().setValue(sValue);
		this._enablePostButton();
		return this;
	};

	FeedInput.prototype.setPlaceholder = function (sValue) {
		this.setProperty("placeholder", sValue, true);
		this._getTextArea().setPlaceholder(sValue);
		return this;
	};

	FeedInput.prototype.setEnabled = function (bEnabled) {
		this.setProperty("enabled", bEnabled, true);
		this._getTextArea().setEnabled(bEnabled);
		this._enablePostButton();
		return this;
	};

	FeedInput.prototype.setButtonTooltip = function (sButtonTooltip) {
		this.setProperty("buttonTooltip", sButtonTooltip, true);
		this._getPostButton().setTooltip(sButtonTooltip);
		return this;
	};
	/////////////////////////////////// Private /////////////////////////////////////////////////////////

	/**
	 * Access and initialization for the text area
	 */
	FeedInput.prototype._getTextArea = function () {
		if (!this._oTextArea) {
			this._oTextArea = new sap.m.TextArea(this.getId() + "-textArea", {
				rows : 1,
				value : null,
				maxLength : this.getMaxLength(),
				placeholder : this.getPlaceholder(),
				liveChange : jQuery.proxy(function (oEvt) {
					var sValue = oEvt.getParameter("value");
					this.setProperty("value", sValue, true); // update myself without re-rendering
					this._enablePostButton();
				}, this)
			});
			this._oTextArea.setParent(this);
		}
		return this._oTextArea;
	};

	/**
	 * Access and initialization for the button
	 */
	FeedInput.prototype._getPostButton = function () {
		if (!this._oButton) {
			this._oButton = new sap.m.Button(this.getId() + "-button", {
				enabled : false,
				type : sap.m.ButtonType.Default,
				icon : "sap-icon://feeder-arrow",
				tooltip : this.getButtonTooltip(),
				press : jQuery.proxy(function (oEvt) {
					this.firePost({
						value : this.getValue()
					});
					this.setValue(null);
					this._oTextArea.focus();
				}, this)
			});
			this._oButton.setParent(this);
		}
		return this._oButton;
	};

	/**
	 * Enable post button depending on the current value
	 */
	FeedInput.prototype._enablePostButton = function () {
		var sValue = this.getProperty("value");
		var bInputEnabled = this.getProperty("enabled");
		var bPostButtonEnabled = (bInputEnabled && !!sValue && sValue.trim().length > 0);
		var oButton = this._getPostButton();
		if (oButton.getEnabled() !== bPostButtonEnabled) {
			oButton.setEnabled(bPostButtonEnabled);
		}
	};

	/**
	 * Lazy load feed icon image.
	 *
	 * @private
	 */
	FeedInput.prototype._getImageControl = function() {

		var sIconSrc = this.getIcon() || IconPool.getIconURI("person-placeholder"),
			sImgId = this.getId() + '-icon',
			mProperties = {
				src : sIconSrc,
				densityAware : this.getIconDensityAware()
			},
			aCssClasses = ['sapMFeedInImage'];

		this._oImageControl = sap.m.ImageHelper.getImageControl(sImgId, this._oImageControl, this, mProperties, aCssClasses);

		return this._oImageControl;
	};


	return FeedInput;

}, /* bExport= */ true);
}; // end of sap/m/FeedInput.js
if ( !jQuery.sap.isDeclared('sap.m.FeedListItemRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.m.FeedListItem
jQuery.sap.declare('sap.m.FeedListItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/FeedListItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, Renderer) {
	"use strict";


	/**
	 * FeedListItem renderer.
	 * @namespace
	 */
	var FeedListItemRenderer = Renderer.extend(ListItemBaseRenderer);
	
	/**
	 * Make sure that parent li is displayed as a horizontal webkit-box.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *          rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oFeedListItem an object representation of the feed list item that should be rendered
	 */
	FeedListItemRenderer.renderLIAttributes = function(rm, oFeedListItem) {
		rm.addClass("sapMFeedListItemTitleDiv");
		if (oFeedListItem._showSeparators === sap.m.ListSeparators.None) {
			rm.addClass("sapMFeedListShowSeparatorsNone");
		} else {
			rm.addClass("sapMFeedListShowSeparatorsAll");
		}
	
	};
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *          rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oFeedListItem an object representation of the feed list item that should be rendered
	 */
	FeedListItemRenderer.renderLIContent = function(rm, oFeedListItem) {
		// convenience variable
		var sMyId = oFeedListItem.getId(), bIsPhone = sap.ui.Device.system.phone;
	
		rm.write('<article');
		rm.writeControlData(oFeedListItem);
		rm.addClass('sapMFeedListItem');
	
		rm.writeClasses();
		rm.write('>');
	
		// icon
		if (!!oFeedListItem.getShowIcon()) {
			this._writeImageControl(rm, oFeedListItem, sMyId);
		}
	
		// text (starting with sender)
	
		if (bIsPhone) {
			rm.write('<div class= "sapMFeedListItemHeader ');
			if (!!oFeedListItem.getShowIcon()) {
				rm.write('sapMFeedListItemHasFigure ');
			}
			if (!!oFeedListItem.getSender() && !!oFeedListItem.getTimestamp()) {
				rm.write('sapMFeedListItemFullHeight');
			}
			rm.write('" >');
			if (!!oFeedListItem.getSender()) {
				rm.write('<p id="' + sMyId + '-name" class="sapMFeedListItemTextName">');
				rm.renderControl(oFeedListItem._getLinkSender(false));
				rm.write('</p>');
			}
			if (!!oFeedListItem.getTimestamp()) {
				// write date
				rm.write('<p class="sapMFeedListItemTimestamp">');
				rm.writeEscaped(oFeedListItem.getTimestamp());
				rm.write('</p>');
			}
	
			rm.write('</div>');
			rm.write('<p class="sapMFeedListItemText">');
			rm.write('<span id="' + sMyId + '-realtext" class="sapMFeedListItemText">');
			if (!!oFeedListItem._checkTextIsExpandable()) {
				this._writeCollapsedText(rm, oFeedListItem, sMyId);
			} else {
				rm.writeEscaped(oFeedListItem.getText(), true);
			}
			rm.write('</span>');
			rm.write('</p>');
			if (!!oFeedListItem.getInfo()) {
				// info
				rm.write('<p class="sapMFeedListItemFooter">');
				if (!!oFeedListItem.getInfo()) {
					rm.write('<span id="' + sMyId + '-info" class="sapMFeedListItemInfo">');
					rm.writeEscaped(oFeedListItem.getInfo());
					rm.write('</span>');
				}
			}
		} else {
			rm.write('<div class= "sapMFeedListItemText ');
			if (!!oFeedListItem.getShowIcon()) {
				rm.write('sapMFeedListItemHasFigure ');
			}
			rm.write('" >');
			rm.write('<p id="' + sMyId + '-text" class="sapMFeedListItemTextText" >');
			if (!!oFeedListItem.getSender()) {
				rm.write('<span id="' + sMyId + '-name" class="sapMFeedListItemTextName">');
				rm.renderControl(oFeedListItem._getLinkSender(true));
				rm.write(' ');
				rm.write('</span>');
			}
			rm.write('<span id="' + sMyId + '-realtext" class="sapMFeedListItemTextString">');
			if (!!oFeedListItem._checkTextIsExpandable()) {
				this._writeCollapsedText(rm, oFeedListItem, sMyId);
			} else {
				rm.writeEscaped(oFeedListItem.getText(), true);
			}
			rm.write('</span>');
			if (!!oFeedListItem.getInfo() || !!oFeedListItem.getTimestamp()) {
				// info and date
				rm.write('<p class="sapMFeedListItemFooter">');
				if (!sap.ui.getCore().getConfiguration().getRTL()) {
					if (!!oFeedListItem.getInfo()) {
						this._writeInfo(rm, oFeedListItem, sMyId);
						// Write Interpunct separator if necessary (with spaces before and after)
						if (!!oFeedListItem.getTimestamp()) {
							rm.write("<span>&#160&#160&#x00B7&#160&#160</span>");
						}
					}
					if (!!oFeedListItem.getTimestamp()) {
						this._writeTimestamp(rm, oFeedListItem, sMyId);
					}
				} else {
					if (!!oFeedListItem.getTimestamp()) {
						this._writeTimestamp(rm, oFeedListItem, sMyId);
					}
					if (!!oFeedListItem.getInfo()) {
						// Write Interpunct separator if necessary (with spaces before and after)
						if (!!oFeedListItem.getTimestamp()) {
							rm.write("<span>&#160&#160&#x00B7&#160&#160</span>");
						}
						this._writeInfo(rm, oFeedListItem, sMyId);
					}
	
				}
	
			}
			rm.write('</p>');
			rm.write('</div>');
		}
		rm.write('</article>');
	};
	
	FeedListItemRenderer._writeImageControl = function(rm, oFeedListItem, sMyId) {
		rm.write('<figure id="' + sMyId + '-figure"');
		rm.addClass('sapMFeedListItemFigure');
		if (!oFeedListItem.getIcon()) {
			rm.addClass('sapMFeedListItemIsDefaultIcon');
		}
		rm.writeClasses();
		rm.write('>');
	
		if (!!oFeedListItem.getIconActive()) {
			rm.write('<a id="' + sMyId + '-iconRef" ');
			rm.write('tabindex="-1"'); // according to design there should be never a tab stop on the icon
			/*eslint-disable no-script-url */
			rm.writeAttribute('href', 'javascript:void(0);');
			/*eslint-enable no-script-url */
			rm.write('>');
		}
		rm.renderControl(oFeedListItem._getImageControl());
		if (!!oFeedListItem.getIconActive()) {
			rm.write('</a>');
		}
		rm.write('</figure>');
	};
	
	FeedListItemRenderer._writeCollapsedText = function(rm, oFeedListItem, sMyId) {
		// 'oFeedListItem._bTextExpanded' is true if the text had been expanded and rendering needs to be done again.
		if (oFeedListItem._bTextExpanded) {
			rm.writeEscaped(oFeedListItem._sFullText, true);
			rm.write('</span>');
			rm.write('<span id="' + sMyId + '-threeDots" class ="sapMFeedListItemTextString">');
			rm.write("&#32"); // space
			rm.write('</span>');
		} else {
			rm.writeEscaped(oFeedListItem._getCollapsedText(), true);
			rm.write('</span>');
			rm.write('<span id="' + sMyId + '-threeDots" class ="sapMFeedListItemTextString">');
			rm.write("&#32&#46&#46&#46&#32"); // space + three dots + space
			rm.write('</span>');
		}
		var oLinkExpandCollapse = oFeedListItem._getLinkExpandCollapse();
		oLinkExpandCollapse.addStyleClass("sapMFeedListItemLinkExpandCollapse");
		rm.renderControl(oLinkExpandCollapse);
	};
	
	FeedListItemRenderer._writeTimestamp = function(rm, oFeedListItem, sMyId) {
		rm.write('<span id="' + sMyId + '-timestamp">');
		rm.writeEscaped(oFeedListItem.getTimestamp());
		rm.write('</span>');
	};
	
	FeedListItemRenderer._writeInfo = function(rm, oFeedListItem, sMyId) {
		rm.write('<span id="' + sMyId + '-info">');
		rm.writeEscaped(oFeedListItem.getInfo());
		rm.write('</span>');
	};
	

	return FeedListItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/FeedListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FlexBox') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.FlexBox.
jQuery.sap.declare('sap.m.FlexBox'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/m/FlexBox",['jquery.sap.global', './FlexBoxStylingHelper', './library', 'sap/ui/core/Control'],
	function(jQuery, FlexBoxStylingHelper, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new FlexBox.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The FlexBox control builds the container for a flexible box layout.
	 * 
	 * Browser support:
	 * This control is not supported in Internet Explorer 9!
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.FlexBox
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FlexBox = Control.extend("sap.m.FlexBox", /** @lends sap.m.FlexBox.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {
	
			/**
			 * The height of the FlexBox. Note that when a percentage is given, for the height to work as expected, the height of the surrounding container must be defined.
			 * @since 1.9.1
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
	
			/**
			 * The width of the FlexBox. Note that when a percentage is given, for the width to work as expected, the width of the surrounding container must be defined.
			 * @since 1.9.1
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
	
			/**
			 * Determines whether the flexbox is in block or inline mode
			 */
			displayInline : {type : "boolean", group : "Appearance", defaultValue : false},
	
			/**
			 * Determines the direction of the layout of child elements
			 */
			direction : {type : "sap.m.FlexDirection", group : "Appearance", defaultValue : sap.m.FlexDirection.Row},
	
			/**
			 * Determines whether the flexbox will be sized to completely fill its container. If the FlexBox is inserted into a Page, the property 'enableScrolling' of the Page needs to be set to 'false' for the FlexBox to fit the entire viewport.
			 */
			fitContainer : {type : "boolean", group : "Appearance", defaultValue : false},
	
			/**
			 * Determines whether the layout is rendered as a series of divs or as an unordered list (ul)
			 */
			renderType : {type : "sap.m.FlexRendertype", group : "Misc", defaultValue : sap.m.FlexRendertype.Div},
	
			/**
			 * Determines the layout behavior along the main axis. "SpaceAround" is currently not supported in most non-Webkit browsers.
			 */
			justifyContent : {type : "sap.m.FlexJustifyContent", group : "Appearance", defaultValue : sap.m.FlexJustifyContent.Start},
	
			/**
			 * Determines the layout behavior of items along the cross-axis. "Baseline" is not supported in Internet Explorer <10.
			 */
			alignItems : {type : "sap.m.FlexAlignItems", group : "Appearance", defaultValue : sap.m.FlexAlignItems.Stretch}
		},
		defaultAggregation : "items",
		aggregations : {
	
			/**
			 * Flex items within the FlexBox layout
			 */
			items : {type : "sap.ui.core.Control", multiple : true, singularName : "item"}
		}
	}});
	
	
	FlexBox.prototype.init = function() {
		// Make sure that HBox and VBox have a valid direction
		if (this instanceof sap.m.HBox && (this.getDirection() !== "Row" || this.getDirection() !== "RowReverse")) {
			this.setDirection('Row');
		}
		if (this instanceof sap.m.VBox && (this.getDirection() !== "Column" || this.getDirection() !== "ColumnReverse")) {
			this.setDirection('Column');
		}
	};
	
	FlexBox.prototype.setDisplayInline = function(bInline) {
		var sDisplay = "";
	
		this.setProperty("displayInline", bInline, false);
		if (bInline) {
			sDisplay = "inline-flex";
		} else {
			sDisplay = "flex";
		}
		FlexBoxStylingHelper.setStyle(null, this, "display", sDisplay);
		return this;
	};
	
	FlexBox.prototype.setDirection = function(sValue) {
		this.setProperty("direction", sValue, false);
		FlexBoxStylingHelper.setStyle(null, this, "flex-direction", sValue);
		return this;
	};
	
	FlexBox.prototype.setFitContainer = function(sValue) {
		if (sValue && !(this.getParent() instanceof FlexBox)) {
			jQuery.sap.log.info("FlexBox fitContainer set to true. Remember, if the FlexBox is inserted into a Page, the property 'enableScrolling' of the Page needs to be set to 'false' for the FlexBox to fit the entire viewport.");
			var $flexContainer = this.$();
			$flexContainer.css("width", "auto");
			$flexContainer.css("height", "100%");
		}
		
		this.setProperty("fitContainer", sValue, false);
	
		return this;
	};
	
	//TODO Enable wrapping when any browser supports it
	/*sap.m.FlexBox.prototype.setJustifyContent = function(sValue) {
		this.setProperty("wrap", sValue, true);
		sap.m.FlexBoxStylingHelper.setStyle(null, this, "flex-wrap", sValue);
		return this;
	}*/
	
	FlexBox.prototype.setJustifyContent = function(sValue) {
		this.setProperty("justifyContent", sValue, false);
		FlexBoxStylingHelper.setStyle(null, this, "justify-content", sValue);
		return this;
	};
	
	FlexBox.prototype.setAlignItems = function(sValue) {
		this.setProperty("alignItems", sValue, false);
		FlexBoxStylingHelper.setStyle(null, this, "align-items", sValue);
		return this;
	};
	
	FlexBox.prototype.setAlignContent = function(sValue) {
		this.setProperty("alignContent", sValue, false);
		FlexBoxStylingHelper.setStyle(null, this, "align-content", sValue);
		return this;
	};
	
	FlexBox.prototype.onAfterRendering = function() {
		if (jQuery.support.useFlexBoxPolyfill) {
			// Check for parent FlexBoxes. Size calculations need to be made from top to bottom
			// while the renderer goes from bottom to top.
			var that = this;
			var currentElement = that;
			var parent = null;
			jQuery.sap.log.info("Check #" + currentElement.getId() + " for nested FlexBoxes");
	
			for (parent = currentElement.getParent();
				parent !== null && parent !== undefined &&
				(parent instanceof FlexBox
				|| (parent.getLayoutData() !== null && parent.getLayoutData() instanceof sap.m.FlexItemData));
				) {
				currentElement = parent;
				parent = currentElement.getParent();
			}
	
			this.sanitizeChildren(this);
			this.renderFlexBoxPolyFill();
		}
	};
	
	/*
	 * @private
	 */
	FlexBox.prototype.sanitizeChildren = function(oControl) {
		// Check the flex items
		var aChildren = oControl.getItems();
		for (var i = 0; i < aChildren.length; i++) {
			if (aChildren[i].getVisible === undefined || aChildren[i].getVisible()) {
				var $child = "";
				if (aChildren[i] instanceof FlexBox) {
					$child = aChildren[i].$();
				} else {
					$child = aChildren[i].$().parent();	// Get wrapper <div>
				}
				$child.width("auto");
				//$child.height("100%");
				if (aChildren[i] instanceof FlexBox) {
					this.sanitizeChildren(aChildren[i]);
				}
			}
		}
	};
	
	/*
	 * @private
	 */
	FlexBox.prototype.renderFlexBoxPolyFill = function() {
		var flexMatrix = [];
		var ordinalMatrix = [];
	
		// Prepare flex and ordinal matrix
		var aChildren = this.getItems();
		for (var i = 0; i < aChildren.length; i++) {
			// If no visible property or if visible
			if (aChildren[i].getVisible === undefined || aChildren[i].getVisible()) {
				// Get layout properties
				var oLayoutData = aChildren[i].getLayoutData();
	
				if (oLayoutData !== "undefined" && oLayoutData !== null && oLayoutData instanceof sap.m.FlexItemData) {
					if (oLayoutData.getGrowFactor() !== 1) {
						flexMatrix.push(oLayoutData.getGrowFactor());
					} else {
						flexMatrix.push(1);		// default value
					}
					if (oLayoutData.getOrder() != 0) {
						ordinalMatrix.push(oLayoutData.getOrder());
					} else {
						ordinalMatrix.push(0);	// default value
					}
				}
			}
		}
	
		if (flexMatrix.length === 0) {
			flexMatrix = null;
		}
		if (ordinalMatrix.length === 0) {
			ordinalMatrix = null;
		}
	
		if (this.getFitContainer()) {
			// Call setter for fitContainer to apply the appropriate styles which are normally applied by the FlexBoxStylingHelper
			this.setFitContainer(true);
		}
	
		var oSettings = {
		    direction : this.getDirection(),
		    alignItems : this.getAlignItems(),
		    justifyContent : this.getJustifyContent(),
		    flexMatrix : flexMatrix,
		    ordinalMatrix : ordinalMatrix
		};
	
		FlexBoxStylingHelper.applyFlexBoxPolyfill(this.getId(), oSettings);
	};

	return FlexBox;

}, /* bExport= */ true);

}; // end of sap/m/FlexBox.js
if ( !jQuery.sap.isDeclared('sap.m.FlexBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.FlexBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/FlexBoxRenderer",['jquery.sap.global', './FlexBoxStylingHelper'],
	function(jQuery, FlexBoxStylingHelper) {
	"use strict";


	/**
	 * FlexBox renderer
	 * @namespace
	 */
	var FlexBoxRenderer = {};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FlexBoxRenderer.render = function(oRm, oControl) {
		if (!jQuery.support.flexBoxLayout && !jQuery.support.newFlexBoxLayout && !jQuery.support.ie10FlexBoxLayout) {
			jQuery.sap.log.warning("This browser does not support Flexible Box Layouts natively.");
			FlexBoxRenderer.usePolyfill = true;
		}
	
		// Make sure HBox and VBox don't get the wrong direction and get the appropriate class
		var hvClass = "";
		if (oControl.getDirection() === "Row" || oControl.getDirection() === "RowReverse") {
			if (oControl instanceof sap.m.VBox) {
				jQuery.sap.log.error("Flex direction cannot be set to Row or RowReverse on VBox controls.");
			} else {
				hvClass = "sapMHBox";
			}
		} else if (oControl.getDirection() === "Column" || oControl.getDirection() === "ColumnReverse") {
			if (oControl instanceof sap.m.HBox) {
				jQuery.sap.log.error("Flex direction cannot be set to Column or ColumnReverse on HBox controls.");
			} else {
				hvClass = "sapMVBox";
			}
		}
	
		// Special treatment if FlexBox is itself an item of a parent FlexBox
		var oParent = oControl.getParent();
		if (oControl.getParent() instanceof sap.m.FlexBox) {
			oRm.addClass("sapMFlexItem");
	
	
			// Set layout properties
			var oLayoutData = oControl.getLayoutData();
			if (oLayoutData instanceof sap.m.FlexItemData && !FlexBoxRenderer.usePolyfill) {
				FlexBoxStylingHelper.setFlexItemStyles(oRm, oLayoutData);
			}
	
			if (oParent.getRenderType() === 'List') {
				oRm.write('<li');
				oRm.writeClasses();
				oRm.writeStyles();
			}
		}
	
		if (oControl.getRenderType() === 'List') {
			oRm.write('<ul');
		} else {
			oRm.write('<div');
		}
	
		oRm.writeControlData(oControl);
		oRm.addClass("sapMFlexBox");
		oRm.addClass(hvClass);
		oRm.writeClasses();
		if (oControl.getWidth()) {
			oRm.addStyle("width", oControl.getWidth());
		}
		if (oControl.getHeight()) {
			oRm.addStyle("height", oControl.getHeight());
		}
		if (!FlexBoxRenderer.usePolyfill) {
			FlexBoxStylingHelper.setFlexBoxStyles(oRm, oControl);
		}
		oRm.writeStyles();
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}
		oRm.write(">");
	
		// Now render the flex items
		var aChildren = oControl.getItems();
		var bWrapItem = true;
		for (var i = 0; i < aChildren.length; i++) {
			// Don't wrap if it's a FlexBox control or if it's not visible
			if (aChildren[i] instanceof sap.m.FlexBox || (aChildren[i].getVisible !== undefined && !aChildren[i].getVisible())) {
				bWrapItem = false;
			} else {
				bWrapItem = true;
			}
	
			// Create wrapper if it's not a FlexBox control
			if (bWrapItem) {
				if (oControl.getRenderType() === 'List') {
					oRm.write('<li');
				} else {
					oRm.write('<div');
				}
	
				// Set layout properties
				var oLayoutData = aChildren[i].getLayoutData();
				if (oLayoutData instanceof sap.m.FlexItemData) {
					if (oLayoutData.getId()) {
						oRm.write(" id='" + oLayoutData.getId() + "'");
					}
					if (oLayoutData.getStyleClass()) {
						oRm.addClass(oLayoutData.getStyleClass());
					}
	
					if (!FlexBoxRenderer.usePolyfill) {
						FlexBoxStylingHelper.setFlexItemStyles(oRm, oLayoutData);
					}
	
					// ScrollContainer needs height:100% on the flex item
					if (aChildren[i] instanceof sap.m.ScrollContainer) {
						oRm.addStyle("height", "100%");
					}
					oRm.writeStyles();
				}
	
				oRm.addClass("sapMFlexItem");
				oRm.writeClasses();
				oRm.write(">");
			}
	
			// Render control
			oRm.renderControl(aChildren[i]);
	
			if (bWrapItem) {
				// Close wrapper
				if (oControl.getRenderType() === 'List') {
					oRm.write('</li>');
				} else {
					oRm.write('</div>');
				}
			}
		}
	
		// Close the flexbox
		if (oControl.getRenderType() === "List") {
			oRm.write("</ul>");
		} else {
			oRm.write("</div>");
		}
	};

	return FlexBoxRenderer;

}, /* bExport= */ true);

}; // end of sap/m/FlexBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FlexItemData') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.FlexItemData.
jQuery.sap.declare('sap.m.FlexItemData'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.LayoutData'); // unlisted dependency retained
sap.ui.define("sap/m/FlexItemData",['jquery.sap.global', './FlexBoxStylingHelper', './library', 'sap/ui/core/LayoutData'],
	function(jQuery, FlexBoxStylingHelper, library, LayoutData) {
	"use strict";


	
	/**
	 * Constructor for a new FlexItemData.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Holds layout data for a FlexBox
	 * @extends sap.ui.core.LayoutData
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.FlexItemData
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FlexItemData = LayoutData.extend("sap.m.FlexItemData", /** @lends sap.m.FlexItemData.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {
	
			/**
			 * Determines cross-axis alignment of individual element (not currently supported in Internet Explorer)
			 */
			alignSelf : {type : "sap.m.FlexAlignSelf", group : "Misc", defaultValue : sap.m.FlexAlignSelf.Auto},
	
			/**
			 * Determines the display order of flex items independent of their source code order.
			 */
			order : {type : "int", group : "Misc", defaultValue : 0},
	
			/**
			 * Determines the flexibility of the flex item when allocatable space is remaining.
			 */
			growFactor : {type : "float", group : "Misc", defaultValue : 0},
	
			/**
			 * The shrink factor determines how much the flex item will shrink relative to the rest of the flex items in the flex container when negative free space is distributed.
			 * 
			 * http://www.w3.org/TR/css3-flexbox/#flex-shrink-factor
			 * 
			 * This property is not supported in Internet Explorer 9, Android Native Browser/Webview <4.4, and Safari <7.
			 * @since 1.24
			 */
			shrinkFactor : {type : "float", group : "Misc", defaultValue : 1},
	
			/**
			 * The style class will be applied to the flex item and can be used for CSS selectors
			 * @deprecated Since version 1.11.2. 
			 * Generic addStyleClass method is available on the control
			 */
			styleClass : {type : "string", group : "Misc", defaultValue : '', deprecated: true}
		}
	}});
	
	
	FlexItemData.prototype.setAlignSelf = function(sValue) {
		this.setProperty("alignSelf", sValue);
		FlexBoxStylingHelper.setStyle(null, this, "align-self", sValue);
		return this;
	};
	
	FlexItemData.prototype.setOrder = function(sValue) {
		this.setProperty("order", sValue);
		FlexBoxStylingHelper.setStyle(null, this, "order", sValue);
		return this;
	};
	
	FlexItemData.prototype.setGrowFactor = function(sValue) {
		this.setProperty("growFactor", sValue);
		FlexBoxStylingHelper.setStyle(null, this, "flex-grow", sValue);
		return this;
	};
	
	FlexItemData.prototype.setShrinkFactor = function(sValue) {
		this.setProperty("shrinkFactor", sValue, true);
		FlexBoxStylingHelper.setStyle(null, this, "flex-shrink", sValue);
		return this;
	};
	
	//TODO Uncomment when property is supported by any browser
	/*sap.m.FlexItemData.prototype.setBaseSize = function(sValue) {
		this.setProperty("baseSize", sValue, true);
		sap.m.FlexBoxStylingHelper.setStyle(null, this, "flex-basis", sValue);
		return this;
	};*/
	

	return FlexItemData;

}, /* bExport= */ true);

}; // end of sap/m/FlexItemData.js
if ( !jQuery.sap.isDeclared('sap.m.GroupHeaderListItemRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.GroupHeaderListItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/GroupHeaderListItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, Renderer) {
	"use strict";


	/**
	 * GroupHeaderListItem renderer.
	 * @namespace
	 */
	var GroupHeaderListItemRenderer = Renderer.extend(ListItemBaseRenderer);
	
	GroupHeaderListItemRenderer.openItemTag = function(rm, oLI) {
		rm.write(oLI.getTable() ? "<tr" : "<li");
	};

	GroupHeaderListItemRenderer.closeItemTag = function(rm, oLI) {
		rm.write(oLI.getTable() ? "</tr>" : "</li>");
	};
	
	GroupHeaderListItemRenderer.renderType = function(rm, oLI) {
		var oTable = oLI.getTable();
		
		// for table render navigation column always
		oTable && rm.write('<td role="gridcell" class="sapMListTblNavCol">');
		ListItemBaseRenderer.renderType.apply(this, arguments);
		oTable && rm.write('</td>');
	};
	
	// it is not necessary to handle non flex case
	GroupHeaderListItemRenderer.handleNoFlex = function(rm, oLI) {
	};
	
	// GroupHeaderListItem does not respect counter property of the LIB
	GroupHeaderListItemRenderer.renderCounter = function(rm, oLI) {
	};
	
	// Returns aria accessibility role
	GroupHeaderListItemRenderer.getAriaRole = function(oLI) {
		return oLI.getTable() ? "row" : "option";
	};
	
	// Returns the inner aria describedby ids for the accessibility
	GroupHeaderListItemRenderer.getAriaDescribedBy = function(oLI) {
		// announce group header first
		var sDescribedBy = this.getAriaAnnouncement("group_header"),
			sBaseDescribedBy = ListItemBaseRenderer.getAriaDescribedBy.call(this, oLI) || "";

		return sDescribedBy + " " + sBaseDescribedBy;
	};
	
	/**
	 * Renders the attributes for the given list item, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *          rm the RenderManager that can be used for writing to the
	 *          Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oLI an object representation of the list item that should be
	 *          rendered
	 */
	GroupHeaderListItemRenderer.renderLIAttributes = function(rm, oLI) {
		rm.addClass("sapMGHLI");
		if (oLI.getUpperCase()) {
			rm.addClass("sapMGHLIUpperCase");
		}
	};
	
	
	/**
	 * Renders the List item content
	 *
	 * @param {sap.ui.core.RenderManager}
	 *          rm the RenderManager that can be used for writing to the
	 *          Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oLI an object representation of the list item that should be
	 *          rendered
	 */
	GroupHeaderListItemRenderer.renderLIContentWrapper = function(rm, oLI) {
		var oTable = oLI.getTable();
		
		if (oTable) {
			rm.write('<td class="sapMGHLICell" role="gridcell"');
			rm.writeAttribute("colspan", oTable.getColSpan());
			rm.write(">");
		}
	
		ListItemBaseRenderer.renderLIContentWrapper.apply(this, arguments);
	
		if (oTable) {
			rm.write("</td>");
		}
	};
	
	GroupHeaderListItemRenderer.renderLIContent = function(rm, oLI) {
		var sTextDir = oLI.getTitleTextDirection();
		rm.write("<label class='sapMGHLITitle'");
		
		if (sTextDir != sap.ui.core.TextDirection.Inherit) {
			rm.writeAttribute("dir", sTextDir.toLowerCase());
		}
		rm.write(">");
		
		rm.writeEscaped(oLI.getTitle());
		
		var iCount = oLI.getCount();
		if (iCount) {
			rm.writeEscaped(" (" + iCount + ")");
		}

		rm.write("</label>");
	};
	

	return GroupHeaderListItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/GroupHeaderListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.GrowingListRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.GrowingListRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/GrowingListRenderer",['jquery.sap.global', './ListRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListRenderer, Renderer) {
	"use strict";


	
	/**
	 * GrowingList renderer.
	 * @namespace
	 */
	var GrowingListRenderer = Renderer.extend(ListRenderer);
	
	GrowingListRenderer.render = function(rm, oControl) {
		/**
		 * For backwards compatibility we can't remove GrowingList control
		 * However, if the compatibility version is 1.16 or higher then
		 * we stop rendering to force using List control with growing feature
		 */
		if (oControl._isIncompatible()) {
			jQuery.sap.log.warning("Does not render sap.m.GrowingList#" + oControl.getId() + " when compatibility version is 1.16 or higher. Instead use sap.m.List/Table control with growing feature!");
		} else {
			ListRenderer.render.call(this, rm, oControl);
		}
	};
	

	return GrowingListRenderer;

}, /* bExport= */ true);

}; // end of sap/m/GrowingListRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.HBox') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.HBox.
jQuery.sap.declare('sap.m.HBox'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/HBox",['jquery.sap.global', './FlexBox', './library'],
	function(jQuery, FlexBox, library) {
	"use strict";


	
	/**
	 * Constructor for a new HBox.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The HBox control builds the container for a horizontal flexible box layout. HBox is a convenience control as it is just a specialized FlexBox control.
	 * 
	 * Browser support:
	 * This control is not supported in Internet Explorer 9!
	 * @extends sap.m.FlexBox
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.HBox
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var HBox = FlexBox.extend("sap.m.HBox", /** @lends sap.m.HBox.prototype */ { metadata : {
	
		library : "sap.m"
	}});
	
	

	return HBox;

}, /* bExport= */ true);

}; // end of sap/m/HBox.js
if ( !jQuery.sap.isDeclared('sap.m.HBoxRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.HBoxRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/HBoxRenderer",['jquery.sap.global', './FlexBoxRenderer'],
	function(jQuery, FlexBoxRenderer) {
	"use strict";


	/**
	 * HBox renderer.
	 * @namespace
	 */
	var HBoxRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	HBoxRenderer.render = function(oRm, oControl){
		FlexBoxRenderer.render.apply(this, [oRm, oControl]);
	};
	

	return HBoxRenderer;

}, /* bExport= */ true);

}; // end of sap/m/HBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabBar') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.IconTabBar.
jQuery.sap.declare('sap.m.IconTabBar'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/m/IconTabBar",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";



	/**
	 * Constructor for a new IconTabBar.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * IconTabBar control is similar to the standard tab bar control. It represents a collection of tabs with associated content. The tabs can have text, count and an icon.
	 * 
	 * IconTabBar can have two behaviors:
	 * - Like a filter – There is only one main content for all tabs. The main content can be filtered, based on the selected tab.
	 * - Like a normal tab bar - The contents of each tab are independent from each other.
	 * @extends sap.ui.core.Control
	 * @implements sap.m.ObjectHeaderContainer
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.IconTabBar
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var IconTabBar = Control.extend("sap.m.IconTabBar", /** @lends sap.m.IconTabBar.prototype */ { metadata : {

		interfaces : [
			"sap.m.ObjectHeaderContainer"
		],
		library : "sap.m",
		properties : {

			/**
			 * Defines whether the current selection should be visualized
			 * @deprecated Since version 1.15.0.
			 * Regarding to changes of this control this property is not needed anymore.
			 */
			showSelection : {type : "boolean", group : "Misc", defaultValue : true, deprecated: true},

			/**
			 * Defines if the tabs can be collapsed and expanded
			 * @since 1.15.0
			 */
			expandable : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Indicates if the actual tab is expanded or not
			 * @since 1.15.0
			 */
			expanded : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Key of the selected item.
			 *
			 * If the key has no corresponding aggregated item, no changes will apply.
			 * If duplicate keys exists the first item matching the key is used.
			 * @since 1.15.0
			 */
			selectedKey : {type : "string", group : "Data", defaultValue : null},

			/**
			 * Determines whether the text of the icon tab filter (not the count) is uppercased.
			 * @since 1.22
			 */
			upperCase : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Determines whether the IconTabBar height is stretched to the maximum possible height of its parent container. As a
			 * prerequisite, the height of the parent container must be defined as a fixed value.
			 *
			 * @since 1.26
			 */
			stretchContentHeight : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Determines whether the IconTabBar content will fit to the full area (if set to false paddings are removed).
			 *
			 * @since 1.26
			 */
			applyContentPadding : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * This property is used to set the background color of the IconTabBar. Depending on the theme you can change the state of the background
			 * from "Solid" over "Translucent" to "Transparent".
			 *
			 * @since 1.26
			 */
			backgroundDesign : {type : "sap.m.BackgroundDesign", group : "Appearance", defaultValue : sap.m.BackgroundDesign.Solid}
		},
		aggregations : {

			/**
			 * The items displayed in the IconTabBar
			 */
			items : {type : "sap.m.IconTab", multiple : true, singularName : "item"},

			/**
			 * The contents displayed below the IconTabBar.
			 * If there are multiple contents, they are rendered after each other. The developer has to manage to display the right one or use the content aggregation inside the IconTabFilter (which will be displayed instead if it is set).
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"},

			/**
			 * An internal aggregation for managing the icon tab elements.
			 */
			_header : {type : "sap.m.IconTabHeader", multiple : false, visibility : "hidden"}
		},
		events : {

			/**
			 * This event will be fired when an item is selected.
			 */
			select : {
				parameters : {

					/**
					 * The selected item.
					 * @since 1.15.0
					 */
					item : {type : "sap.m.IconTabFilter"},

					/**
					 * The key of the selected item.
					 * @since 1.15.0
					 */
					key : {type : "string"},

					/**
					 * This parameter is deprecated since 1.15.0! Please use parameter "item" instead.
					 */
					selectedItem : {type : "sap.m.IconTabFilter"},

					/**
					 * This parameter is deprecated since 1.15.0! Please use parameter "key" instead.
					 */
					selectedKey : {type : "string"}
				}
			},

			/**
			 * Indicates that the tab will expand or collapse
			 * @since 1.15.0
			 */
			expand : {
				parameters : {

					/**
					 * If the tab will expand, this is true.
					 */
					expand : {type : "boolean"},

					/**
					 * If the tab will collapse, this is true.
					 */
					collapse : {type : "boolean"}
				}
			}
		}
	}});


	IconTabBar.prototype.clone = function () {
		var oClone = Control.prototype.clone.apply(this, arguments);

		// "_header" aggregation is hidden and it is not cloned by default
		var oIconTabHeader = this._getIconTabHeader();
		oClone.setAggregation("_header", oIconTabHeader.clone(), true);

		return oClone;
	};

	/**
	 * Sets the expanded flag and toggles the expand/collapse animation if the control is already rendered
	 * @overwrite
	 * @public
	 * @param {boolean} bExpanded new parameter value
	 * @return {sap.m.IconTabBar} this pointer for chaining
	 */
	IconTabBar.prototype.setExpanded = function (bExpanded) {
		// set internal property
		this.setProperty("expanded", bExpanded, true);

		// toggle animation if control is already rendered
		if (this.$().length) {
			this._toggleExpandCollapse(bExpanded);
		}
		return this;
	};

	/**
	 * Sets the expandable flag without rerendering
	 * @overwrite
	 * @public
	 * @param {boolean} bExpandable new parameter value
	 * @return {sap.m.IconTabBar} this pointer for chaining
	 */
	IconTabBar.prototype.setExpandable = function (bExpandable) {
		// set internal property
		this.setProperty("expandable", bExpandable, true);
		return this;
	};

	/**
	 * Rerenders only shown content of the IconTabBar.
	 * @private
	 * @param oContent content which should be rendered.
	 */
	IconTabBar.prototype._rerenderContent = function(oContent) {
		var $content = this.$("content");
		if (oContent && ($content.length > 0)) {
			var rm = sap.ui.getCore().createRenderManager();
			for (var i = 0; i < oContent.length; i++) {
				rm.renderControl(oContent[i]);
			}
			rm.flush($content[0]);
			rm.destroy();
		}
	};

	/**
	 * Opens and closes the content Container
	 *
	 * @param {boolean|undefined} bExpanded the new state of the container. If not specified, it will use the property expanded
	 * @private
	 * @return {sap.m.IconTabBar} this pointer for chaining
	 */
	IconTabBar.prototype._toggleExpandCollapse = function(bExpanded) {
		var $content = this.$("content");
		var oSelectedItem = this._getIconTabHeader().oSelectedItem;

		// use inverted control state if not specified by parameter
		if (bExpanded === undefined) {
			bExpanded = !this.getExpanded();
		}

		// TODO: do this in header now
		// manage selection state

		if (oSelectedItem) {
			oSelectedItem.$().toggleClass("sapMITBSelected", bExpanded);

			oSelectedItem.$().attr({
				'aria-expanded': bExpanded
			});

			if (bExpanded) {
				oSelectedItem.$().attr({ 'aria-selected': bExpanded });
			} else {
				oSelectedItem.$().removeAttr('aria-selected');
			}
		}

		// show animation (keep track of active animations to avoid flickering of controls)
		this._iAnimationCounter = (this._iAnimationCounter === undefined ? 1 : ++this._iAnimationCounter);
		if (bExpanded) { // expanding
			if (oSelectedItem) {
				if (this.$("content").children().length === 0) { //content is not rendered yet
					//if item has own content, this content is shown
					var oSelectedItemContent = oSelectedItem.getContent();
					if (oSelectedItemContent.length > 0) {
						this._rerenderContent(oSelectedItemContent);
					//if item has not own content, general content of the icontabbar is shown
					} else {
						this._rerenderContent(this.getContent());
					}
				}
				$content.stop(true, true).slideDown('400', jQuery.proxy(this.onTransitionEnded, this, bExpanded));
				this.$("containerContent").toggleClass("sapMITBContentClosed", !bExpanded);
			}
		} else { // collapsing
			this.$("contentArrow").hide();
			$content.stop(true, true).slideUp('400', jQuery.proxy(this.onTransitionEnded, this, bExpanded));
		}

		// update property (if we have a selected item) and fire event
		if (!bExpanded || oSelectedItem) {
			this.setProperty("expanded", bExpanded, true);
		}
		this.fireExpand({
			expand: bExpanded,
			collapse: !bExpanded
		});

		return this;
	};

	/**
	 * Function is executed when the expand/collapse animation is finished to adjust the UI.
	 *
	 * @param {boolean} bExpanded the new state of the container. Passed in
	 * @private
	 * @return {sap.m.IconTabBar} this pointer for chaining
	 */
	IconTabBar.prototype.onTransitionEnded = function(bExpanded) {
		var $content = this.$("content"),
			$container = this.$("containerContent"),
			$arrow = this.$("contentArrow");

		// if multiple animations are triggered, this function is executed multiple times in the end, so we need to ignore all except the last call
		if (this._iAnimationCounter === 1) {
			$container.toggleClass("sapMITBContentClosed", !bExpanded);
			if (bExpanded) { // expanding
				$arrow.show();
				$content.css("display", "block");
			} else { // collapsing
				$arrow.hide();
				$content.css("display", "none");
			}
		}
		// reduce animation counter
		this._iAnimationCounter = (this._iAnimationCounter > 0 ? --this._iAnimationCounter : 0);
		return this;
	};


	/* =========================================================== */
	/*           end: event handlers                               */
	/* =========================================================== */

	/**
	 * lazy initializes the iconTabHeader aggregation
	 */
	IconTabBar.prototype._getIconTabHeader = function () {
		var oControl = this.getAggregation("_header");

		if (!oControl) {
			oControl = new sap.m.IconTabHeader(this.getId() + "--header", {
			});
			this.setAggregation("_header", oControl, true);
		}
		return oControl;
	};

	/* =========================================================== */
	/*           begin: reflectors for header properties           */
	/* =========================================================== */

	/*
	 * Reflector for the internal header's showSelection property
	 * @overwrite
	 * @public
	 * @param {boolean} bValue the new value
	 * @returns {sap.m.IconTabBar} this pointer for chaining
	 */
	IconTabBar.prototype.setShowSelection = function (bValue) {
		this._getIconTabHeader().setShowSelection(bValue);
		return this;
	};

	/*
	 * Reflector for the internal header's showSelection property
	 * @overwrite
	 * @public
	 * @returns {boolean} the current property value
	 */
	IconTabBar.prototype.getShowSelection = function () {
		return this._getIconTabHeader().getShowSelection();
	};

	/**
	 * Reflector for the internal header's selectedKey property
	 * @overwrite
	 * @public
	 * @param {string} sValue the new value
	 * @returns {sap.m.IconTabBar} this pointer for chaining
	 */
	IconTabBar.prototype.setSelectedKey = function (sValue) {
		this._getIconTabHeader().setSelectedKey(sValue);
		return this;
	};

	/**
	 * Reflector for the internal header's selectedKey property
	 * @overwrite
	 * @public
	 * @returns {string} the current property value
	 */
	IconTabBar.prototype.getSelectedKey = function () {
		return this._getIconTabHeader().getSelectedKey();
	};

	/**
	 * Reflector for the internal header's selectedItem
	 * Sets the selected item, updates the UI, and fires the select event
	 * @overwrite
	 * @private
	 * @param {sap.m.IconTabFilter} oItem the item to be selected
	 * @return {sap.m.IconTabHeader} this pointer for chaining
	 */
	IconTabBar.prototype.setSelectedItem = function(oItem, bAPIchange) {
		return this._getIconTabHeader().setSelectedItem(oItem, bAPIchange);
	};

	/* =========================================================== */
	/*           end: reflectors for header properties             */
	/* =========================================================== */

	/* =========================================================== */
	/*           begin: forward aggregation  methods to header     */
	/* =========================================================== */

	/*
	 * Forwards a function call to a managed object based on the aggregation name.
	 * If the name is items, it will be forwarded to the list, otherwise called locally
	 * @private
	 * @param {string} sFunctionName the name of the function to be called
	 * @param {string} sAggregationName the name of the aggregation asociated
	 * @returns {mixed} the return type of the called function
	 */
	IconTabBar.prototype._callMethodInManagedObject = function (sFunctionName, sAggregationName) {
		var aArgs = Array.prototype.slice.call(arguments),
			oHeader;

		if (sAggregationName === "items") {
			// apply to the internal header control
			oHeader = this._getIconTabHeader();
			return oHeader[sFunctionName].apply(oHeader, aArgs.slice(1));
		} else {
			// apply to this control
			return sap.ui.base.ManagedObject.prototype[sFunctionName].apply(this, aArgs.slice(1));
		}
	};

	/**
	 * Forwards aggregations with the name of items to the internal list.
	 * @overwrite
	 * @public
	 * @param {string} sAggregationName the name for the binding
	 * @param {object} oBindingInfo the configuration parameters for the binding
	 * @returns {sap.m.IconTabBar} this pointer for chaining
	 */
	IconTabBar.prototype.bindAggregation = function () {
		var args = Array.prototype.slice.call(arguments);

		// propagate the bind aggregation function to list
		this._callMethodInManagedObject.apply(this, ["bindAggregation"].concat(args));
		return this;
	};

	IconTabBar.prototype.validateAggregation = function (sAggregationName, oObject, bMultiple) {
		return this._callMethodInManagedObject("validateAggregation", sAggregationName, oObject, bMultiple);
	};

	IconTabBar.prototype.setAggregation = function (sAggregationName, oObject, bSuppressInvalidate) {
		this._callMethodInManagedObject("setAggregation", sAggregationName, oObject, bSuppressInvalidate);
		return this;
	};

	IconTabBar.prototype.getAggregation = function (sAggregationName, oDefaultForCreation) {
		return this._callMethodInManagedObject("getAggregation", sAggregationName, oDefaultForCreation);
	};

	IconTabBar.prototype.indexOfAggregation = function (sAggregationName, oObject) {
		return this._callMethodInManagedObject("indexOfAggregation", sAggregationName, oObject);
	};

	IconTabBar.prototype.insertAggregation = function (sAggregationName, oObject, iIndex, bSuppressInvalidate) {
		this._callMethodInManagedObject("insertAggregation", sAggregationName, oObject, iIndex, bSuppressInvalidate);
		return this;
	};

	IconTabBar.prototype.addAggregation = function (sAggregationName, oObject, bSuppressInvalidate) {
		this._callMethodInManagedObject("addAggregation", sAggregationName, oObject, bSuppressInvalidate);
		return this;
	};

	IconTabBar.prototype.removeAggregation = function (sAggregationName, oObject, bSuppressInvalidate) {
		return this._callMethodInManagedObject("removeAggregation", sAggregationName, oObject, bSuppressInvalidate);
	};

	IconTabBar.prototype.removeAllAggregation = function (sAggregationName, bSuppressInvalidate) {
		return this._callMethodInManagedObject("removeAllAggregation", sAggregationName, bSuppressInvalidate);
	};

	IconTabBar.prototype.destroyAggregation = function (sAggregationName, bSuppressInvalidate) {
		this._callMethodInManagedObject("destroyAggregation", sAggregationName, bSuppressInvalidate);
		return this;
	};

	IconTabBar.prototype.getBinding = function (sAggregationName) {
		return this._callMethodInManagedObject("getBinding", sAggregationName);
	};


	IconTabBar.prototype.getBindingInfo = function (sAggregationName) {
		return this._callMethodInManagedObject("getBindingInfo", sAggregationName);
	};

	IconTabBar.prototype.getBindingPath = function (sAggregationName) {
		return this._callMethodInManagedObject("getBindingPath", sAggregationName);
	};

	/* =========================================================== */
	/*           end: forward aggregation  methods to header       */
	/* =========================================================== */

	return IconTabBar;

}, /* bExport= */ true);

}; // end of sap/m/IconTabBar.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabFilter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.IconTabFilter.
jQuery.sap.declare('sap.m.IconTabFilter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Item'); // unlisted dependency retained
sap.ui.define("sap/m/IconTabFilter",['jquery.sap.global', './library', 'sap/ui/core/Item'],
	function(jQuery, library, Item) {
	"use strict";



	/**
	 * Constructor for a new IconTabFilter.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The filter item class
	 * @extends sap.ui.core.Item
	 * @implements sap.m.IconTab
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.IconTabFilter
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var IconTabFilter = Item.extend("sap.m.IconTabFilter", /** @lends sap.m.IconTabFilter.prototype */ { metadata : {

		interfaces : [
			"sap.m.IconTab",
			// The IconTabBar doesn't have renderer. The sap.ui.core.PopupInterface is used to indicate
			// that the IconTabFilter content is not rendered by the IconTabFilter, it is rendered by IconTabBar.
			"sap.ui.core.PopupInterface"
		],
		library : "sap.m",
		properties : {

			/**
			 * The number of available items if this filter is applied
			 */
			count : {type : "string", group : "Data", defaultValue : ''},

			/**
			 * Enables special visualization for disabled filter (show all items)
			 */
			showAll : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * The icon to display for this item.
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : ''},

			/**
			 * If an icon font is used, the color can be chosen from the icon colors (sap.ui.core.IconColor).
			 * Possible semantic colors are: Neutral, Positive, Critical, Negative.
			 * Instead of the semantic icon color the brand color can be used, this is named Default.
			 * Semantic colors and brand colors should not be mixed up inside one IconTabBar.
			 */
			iconColor : {type : "sap.ui.core.IconColor", group : "Appearance", defaultValue : sap.ui.core.IconColor.Default},

			/**
			 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
			 *
			 * If bandwidth is the key for the application, set this value to false.
			 */
			iconDensityAware : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * If set to false, the control is not rendered.
			 */
			visible : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Design for the filter item.
			 */
			design : {type : "sap.m.IconTabFilterDesign", group : "Appearance", defaultValue : sap.m.IconTabFilterDesign.Vertical}
		},
		defaultAggregation : "content",
		aggregations : {

			/**
			 * The content to show for this item (optional).
			 * If this content is set, it will be displayed instead of the general content inside the IconTabBar.
			 * @since 1.15.0
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
		}
	}});

	/**
	 * Lazy load icon tab filter image.
	 *
	 * @param {Array} aCssClassesToAdd array of css classes which will be added if the image needs to be created.
	 * @param {sap.ui.core.Control} oParent this element's parent.
	 * @param {Array} aCssClassesToRemove all css clases that oImageControl has and which are contained in this array
	 * are removed before adding the css classes listed in aCssClassesToAdd.
	 *
	 * @private
	 */
	IconTabFilter.prototype._getImageControl = function(aCssClassesToAdd, oParent, aCssClassesToRemove) {
		var mProperties = {
			src : this.getIcon(),
			densityAware : this.getIconDensityAware()
		};
		if (mProperties.src) {
			this._oImageControl = sap.m.ImageHelper.getImageControl(this.getId() + "-icon", this._oImageControl, oParent, mProperties, aCssClassesToAdd, aCssClassesToRemove);
		} else if (this._oImageControl) {
			this._oImageControl.destroy();
			this._oImageControl = null;
		}

		return this._oImageControl;
	};

	/**
	 * Function is called when exiting the element.
	 *
	 * @private
	 */
	IconTabFilter.prototype.exit = function(oEvent) {
		if (this._oImageControl) {
			this._oImageControl.destroy();
		}

		if (Item.prototype.exit) {
			Item.prototype.exit.call(this, oEvent);
		}
	};

	IconTabFilter.prototype.invalidate = function() {
		var oIconTabHeader = this.getParent(),
			oIconTabBar;

		// invalidate the whole IconTabBar or the ObjectHeader
		if (oIconTabHeader instanceof sap.m.IconTabHeader &&
			oIconTabHeader.getParent() instanceof sap.m.IconTabBar) {
			oIconTabBar = oIconTabHeader.getParent();

			if (oIconTabBar.getParent() instanceof sap.m.ObjectHeader) {
				// invalidate the object header to re-render IconTabBar content and header
				var oObjectHeader = oIconTabBar.getParent();
				oObjectHeader.invalidate();
			} else {
				oIconTabBar.invalidate();
			}
		}
	};

	IconTabFilter.prototype.setProperty = function (sPropertyName, oValue, bSuppressInvalidate) {

		// invalidate only the IconTabHeader if a property change
		// doesn't affect the IconTabBar content
		switch (sPropertyName) {
			case 'text':
			case 'count':
			case 'showAll':
			case 'icon':
			case 'iconColor':
			case 'iconDensityAware':
			case 'design':
				sap.ui.core.Control.prototype.setProperty.call(this, sPropertyName, oValue, true);
				if (!bSuppressInvalidate) {
					var oIconTabHeader = this.getParent();
					if (oIconTabHeader instanceof sap.m.IconTabHeader) {
						oIconTabHeader.invalidate();
					}
				}
				break;
			default:
				sap.ui.core.Control.prototype.setProperty.apply(this, arguments);
				break;
		}

		return this;
	};

	/**
	 * If the IconTabFilter doesn't have a key, the function returns the id of the IconTabFilter,
	 * so the IconTabBar can remember the selected IconTabFilter.
	 *
	 * @private
	 */
	IconTabFilter.prototype._getNonEmptyKey = function () {

		// BCP: 1482007468
		var sKey = this.getKey();

		if (sKey) {
			return sKey;
		}

		return this.getId();
	};

	return IconTabFilter;

}, /* bExport= */ true);

}; // end of sap/m/IconTabFilter.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabHeader') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.IconTabHeader.
jQuery.sap.declare('sap.m.IconTabHeader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/m/IconTabHeader",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/EnabledPropagator', 'sap/ui/core/delegate/ItemNavigation'],
	function(jQuery, library, Control, EnabledPropagator, ItemNavigation) {
	"use strict";

	/**
	 * Constructor for a new IconTabHeader.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This control display a number of iconTabFilters and Separators. If the available horizontal space is exceeded, it will allow for scrolling horziontally to show all items.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.IconTabHeader
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var IconTabHeader = Control.extend("sap.m.IconTabHeader", /** @lends sap.m.IconTabHeader.prototype */ { metadata : {

		library : "sap.m",
		properties : {

			/**
			 * Defines whether the current selection should be visualized.
			 * @deprecated Since version 1.15.0.
			 * Regarding to changes of this control this property is not needed anymore.
			 */
			showSelection : {type : "boolean", group : "Misc", defaultValue : true, deprecated: true},

			/**
			 * Key of the selected item.
			 *
			 * If the key has no corresponding aggregated item, no changes will apply.
			 * If duplicate keys exists the first item matching the key is used.
			 * @since 1.15.0
			 */
			selectedKey : {type : "string", group : "Data", defaultValue : null},

			/**
			 * Invisible controls are not rendered.
			 * @since 1.15.0
			 */
			visible : {type : "boolean", group : "Behavior", defaultValue : true}
		},
		aggregations : {

			/**
			 * The items displayed in the IconTabBar
			 */
			items : {type : "sap.m.IconTab", multiple : true, singularName : "item"}
		},
		events : {

			/**
			 * This event will be fired when an item is selected.
			 */
			select : {
				parameters : {

					/**
					 * The selected item.
					 * @since 1.15.0
					 */
					item : {type : "sap.m.IconTabFilter"},

					/**
					 * The key of the selected item.
					 * @since 1.15.0
					 */
					key : {type : "string"}
				}
			}
		}
	}});

	EnabledPropagator.apply(IconTabHeader.prototype, [true]);

	IconTabHeader.SCROLL_STEP = 264; // how many pixels to scroll with every overflow arrow click

	// When to create a scroll delegate:
	IconTabHeader.prototype._bDoScroll = !sap.ui.Device.system.desktop || (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8);

	/**
	 * Init
	 */
	IconTabHeader.prototype.init = function() {
		this._bPreviousScrollForward = false; // remember the item overflow state
		this._bPreviousScrollBack = false;
		this._iCurrentScrollLeft = 0;
		this._bRtl = sap.ui.getCore().getConfiguration().getRTL();

		this.startScrollX = 0;
		this.startTouchX = 0;
		this._scrollable = null;

		this._aTabKeys = [];

		// Initialize the ItemNavigation
		this._oItemNavigation = new ItemNavigation().setCycling(false);
		this._oItemNavigation.attachEvent(ItemNavigation.Events.FocusLeave, this._onItemNavigationFocusLeave, this);
		this._oItemNavigation.attachEvent(ItemNavigation.Events.AfterFocus, this._onItemNavigationAfterFocus, this);
		this.addDelegate(this._oItemNavigation);

		if (this._bDoScroll) {
			jQuery.sap.require("sap.ui.core.delegate.ScrollEnablement");
			this._oScroller = new sap.ui.core.delegate.ScrollEnablement(this, this.getId() + "-head", {
				horizontal: true,
				vertical: false,
				nonTouchScrolling: true
			});
		}

	};

	IconTabHeader.prototype._onItemNavigationFocusLeave = function() {

		// BCP: 1570034646
		if (!this.oSelectedItem) {
			return;
		}

		var aItems = this.getItems();
		var iIndex = -1;
		var oItem;

		for (var i = 0; i < aItems.length; i++) {
			oItem = aItems[i];

			if (oItem instanceof sap.m.IconTabFilter == false) {
				continue;
			}

			iIndex++;

			if (this.oSelectedItem == oItem) {
				break;
			}
		}

		this._oItemNavigation.setFocusedIndex(iIndex);
	};

	/**
	 * Adjusts arrows when keyboard is used for navigation and the beginning/end of the toolbar is reached
	 */
	IconTabHeader.prototype._onItemNavigationAfterFocus = function(oEvent) {
		var oHead = this.getDomRef("head"),
			oIndex = oEvent.getParameter("index"),
			$event = oEvent.getParameter('event');

		// handle only keyboard navigation here
		if ($event.keyCode === undefined) {
			return;
		}

		this._iCurrentScrollLeft = oHead.scrollLeft;

		this._checkOverflow(oHead, this.$());

		if (oIndex !== null && oIndex !== undefined) {
			this._scrollIntoView(this.getTabFilters()[oIndex], 0);
		}
	};

	/**
	 * Returns all tab filters, without the tab separators
	 * @private
	 */
	IconTabHeader.prototype.getTabFilters = function() {

		var aItems = this.getItems();
		var aTabFilters = [];

		aItems.forEach(function(oItem) {
			if (oItem instanceof sap.m.IconTabFilter) {
				aTabFilters.push(oItem);
			}
		});

		return aTabFilters;
	};

	/**
	 * Exit
	 */
	IconTabHeader.prototype.exit = function() {
		if (this._oArrowLeft) {
			this._oArrowLeft.destroy();
		}
		if (this._oArrowRight) {
			this._oArrowRight.destroy();
		}

		if (this._oItemNavigation) {
			this.removeDelegate(this._oItemNavigation);
			this._oItemNavigation.destroy();
			delete this._oItemNavigation;
		}

		if (this._oScroller) {
			this._oScroller.destroy();
			this._oScroller = null;
		}

		if (this._sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
			this._sResizeListenerId = null;
		}
		if (this._aTabKeys) {
			this._aTabKeys = null;
		}
	};

	/**
	 * Before Rendering
	 */
	IconTabHeader.prototype.onBeforeRendering = function() {
		var aItems = this.getItems(),
			sSelectedKey = this.getSelectedKey(),
			i = 0;

		if (this._sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
			this._sResizeListenerId = null;
		}

		if (aItems.length > 0) {
			if (!this.oSelectedItem || sSelectedKey && sSelectedKey !== this.oSelectedItem._getNonEmptyKey()) {
				if (sSelectedKey) {
					// selected key was specified by API: set oSelectedItem to the item specified by key
					for (; i < aItems.length; i++) {
						if (!(aItems[i] instanceof sap.m.IconTabSeparator) && aItems[i]._getNonEmptyKey() === sSelectedKey) {
							this.oSelectedItem = aItems[i];
							break;
						}
					}
				}

				// no key and no item, we set the first visible item as selected if container is not explicitly set to collapsed
				if (!this.oSelectedItem && this.getParent() instanceof sap.m.IconTabBar && this.getParent().getExpanded()) {
					for (i = 0; i < aItems.length; i++) { // tab item
						if (!(aItems[i] instanceof sap.m.IconTabSeparator) && aItems[i].getVisible()) {
							this.oSelectedItem = aItems[i];
							break;
						}
					}
				}
			}

			//in case the selected tab is not visible anymore and the content is expanded, the selected tab will change to the first visible tab
			if (this.oSelectedItem && !this.oSelectedItem.getVisible() && this.getParent() instanceof sap.m.IconTabBar && this.getParent().getExpanded()) {
				for (i = 0; i < aItems.length; i++) { // tab item
					if (!(aItems[i] instanceof sap.m.IconTabSeparator) && aItems[i].getVisible()) {
						this.oSelectedItem = aItems[i];
						break;
					}
				}
			}

			if (this.oSelectedItem) {
				this.setProperty("selectedKey", this.oSelectedItem._getNonEmptyKey(), true);
			}
		}

		// Deregister resize event before re-rendering
		if (this._sResizeListenerNoFlexboxSupportId) {
			sap.ui.core.ResizeHandler.deregister(this._sResizeListenerNoFlexboxSupportId);
			this._sResizeListenerNoFlexboxSupportId = null;
		}
	};

	/**
	 * Sets the selected item based on key
	 * @overwrite
	 * @public
	 * @param {string} sKey the key of the item to be selected
	 * @return {sap.m.IconTabHeader} this pointer for chaining
	 */
	IconTabHeader.prototype.setSelectedKey = function (sKey) {
		var aItems = this.getItems(),
			i = 0;

		// adjust UI and internal variables if already rendered (otherwise taken care by onBeforeRendering)
		if (this.$().length) {
			for (; i < aItems.length; i++) {
				if (!(aItems[i] instanceof sap.m.IconTabSeparator) && aItems[i]._getNonEmptyKey() === sKey) {
					this.setSelectedItem(aItems[i], true);
					break;
				}
			}
		}

		// set internal property
		this.setProperty("selectedKey", sKey, true);
		return this;
	};

	/*
	 * Sets the selected item, updates the UI, and fires the select event
	 * @private
	 * @param {sap.m.IconTabFilter} oItem the item to be selected
	 * @return {sap.m.IconTabHeader} this pointer for chaining
	 */
	IconTabHeader.prototype.setSelectedItem = function(oItem, bAPIchange) {

		if (!oItem || !oItem.getEnabled()) {
			return this;
		}

		//if the old selected tab and the new selected tab both have no own content, which means they both use the same content from the icontabbar
		//there is no need to rerender the content
		//fix for xml views css: 0120061532 0001427250 2014
		var bIsContentTheSame = false;
		if (oItem.getContent().length === 0  && this.oSelectedItem && this.oSelectedItem.getContent().length === 0) {
			bIsContentTheSame = true;
		}

		if (this.oSelectedItem && this.oSelectedItem.getVisible() && (this.getParent() instanceof sap.m.IconTabBar && this.getParent().getExpandable() || this.oSelectedItem !== oItem )) {
			this.oSelectedItem.$()
					.removeClass("sapMITBSelected")
					.removeAttr('aria-selected')
					.removeAttr('aria-expanded');
		}

		if (oItem.getVisible()) {
			//click on already selected item leads to expanding/collapsing of the content (if expandable enabled)
			if (this.oSelectedItem === oItem) {
				//if content is not expandable nothing should happen otherwise content will be expanded/collapsed
				if (this.getParent() instanceof sap.m.IconTabBar && this.getParent().getExpandable()) {
					this.getParent()._toggleExpandCollapse();
				}
			//click on other item leads to showing the right content of this item
			} else {
				//change the content aria-labaled by the newly selected tab;
				if (this.getParent() instanceof sap.m.IconTabBar) {
					this.getParent().$("content").attr('aria-labelledby', oItem.sId);
				}

				// set new item
				this.oSelectedItem = oItem;
				this.setProperty("selectedKey", this.oSelectedItem._getNonEmptyKey(), true);

				//if the IconTabBar is not expandable and the content not expanded (which means content can never be expanded), we do not need
				//to visualize the selection and we do not need to render the content
				if (this.getParent() instanceof sap.m.IconTabBar && (this.getParent().getExpandable() || this.getParent().getExpanded())) {
					// add selected styles
					this.oSelectedItem.$()
							.addClass("sapMITBSelected")
							.attr({ 'aria-selected': true });

					//if item has own content, this content is shown
					var oSelectedItemContent = this.oSelectedItem.getContent();
					if (oSelectedItemContent.length > 0) {
						this.getParent()._rerenderContent(oSelectedItemContent);
					//if item has not own content, general content of the icontabbar is shown
					} else {
						//if the general content was already shown there is no need to rerender
						if (!bIsContentTheSame) {
							this.getParent()._rerenderContent(this.getParent().getContent());
						}
					}
					//if content is not expanded, content will be expanded (first click on item always leads to expanding the right content)
					if (this.getParent().getExpandable() && !this.getParent().getExpanded()) {
						this.getParent()._toggleExpandCollapse(true);
					}
				}
			}

			// scroll to item if out of viewport
			if (this.oSelectedItem.$().length > 0) {
				this._scrollIntoView(oItem, 500);
			} else {
				this._scrollAfterRendering = true;
			}
		}

		var sSelectedKey = this.oSelectedItem._getNonEmptyKey();
		this.oSelectedItem = oItem;
		this.setProperty("selectedKey", sSelectedKey, true);
		if (this.getParent() instanceof sap.m.IconTabBar) {
			this.getParent().setProperty("selectedKey", sSelectedKey, true);
		}

		if (!bAPIchange) {
			// fire event on iconTabBar
			if (this.getParent() instanceof sap.m.IconTabBar) {
				this.getParent().fireSelect({
					selectedItem: this.oSelectedItem,
					selectedKey: sSelectedKey,
					item: this.oSelectedItem,
					key: sSelectedKey
				});
			} else {
				// fire event on header
				this.fireSelect({
					selectedItem: this.oSelectedItem,
					selectedKey: sSelectedKey,
					item: this.oSelectedItem,
					key: sSelectedKey
				});
			}
		}
		return this;
	};

	/**
	 * return first visible item, which is needed for correct arrow calculation
	 */
	IconTabHeader.prototype._getFirstVisibleItem = function(aItems) {
		for (var i = 0; i < aItems.length; i++) {
			if (aItems[i].getVisible()) {
				return aItems[i];
			}
		}

		return null;
	};

	/**
	 * afterRendering
	 */
	IconTabHeader.prototype.onAfterRendering = function() {
		var oHeadDomRef = this.getDomRef("head"),
			$bar = this.$();

		// initialize scrolling
		if (this._oScroller) {
			this._oScroller.setIconTabBar(this, jQuery.proxy(this._afterIscroll, this), jQuery.proxy(this._scrollPreparation, this));
		}

		if (this.oSelectedItem && this.getParent() instanceof sap.m.IconTabBar && this.getParent().getExpanded()) {
			this.oSelectedItem.$()
					.addClass("sapMITBSelected")
					.attr({ 'aria-selected': true });
		}

		if (this._bDoScroll) {
			jQuery.sap.delayedCall(350, this, "_checkOverflow", [oHeadDomRef, $bar]);
		} else {
			this._checkOverflow(oHeadDomRef, $bar);
		}

		// reset scroll state after re-rendering for non-touch devices (iScroll will handle this internally)
		if (this._iCurrentScrollLeft !== 0 && !this._bDoScroll) {
			oHeadDomRef.scrollLeft = this._iCurrentScrollLeft;
		}

		// scroll to selected item if it is out of screen and we render the control the first time
		if (this.oSelectedItem) {
			if (!this._bDoThisOnlyOnce) {
				jQuery.sap.delayedCall(1000, this, "_scrollIntoView", [this.oSelectedItem, 0]); // needs some delay to have correct position info
				this._bDoThisOnlyOnce = true;
			} else if (this._scrollAfterRendering) {
				this._scrollIntoView(this.oSelectedItem, 500);
				this._scrollAfterRendering = false;
			}
		}

		//use ItemNavigation for keyboardHandling
		var aItems = this.getItems();
		var aTabDomRefs = [];
		var iSelectedDomIndex = -1;
		var that = this;

		// find a collection of all tabs
		aItems.forEach(function(oItem) {
			if (oItem instanceof sap.m.IconTabFilter) {
				var oItemDomRef = that.getFocusDomRef(oItem);
				jQuery(oItemDomRef).attr("tabindex", "-1");
				aTabDomRefs.push(oItemDomRef);
				if (oItem === that.oSelectedItem) {
					iSelectedDomIndex = aTabDomRefs.indexOf(oItem);
				}
			}
		});

		//Initialize the ItemNavigation
		if (!this._oItemNavigation) {
			this._oItemNavigation = new ItemNavigation();
			this._oItemNavigation.attachEvent(ItemNavigation.Events.FocusLeave, this._onItemNavigationFocusLeave, this);
			this._oItemNavigation.attachEvent(ItemNavigation.Events.AfterFocus, this._onItemNavigationAfterFocus, this);
			this.addDelegate(this._oItemNavigation);
		}

		//Reinitialize the ItemNavigation after rendering
		this._oItemNavigation.setRootDomRef(oHeadDomRef);
		this._oItemNavigation.setItemDomRefs(aTabDomRefs);
		this._oItemNavigation.setSelectedIndex(iSelectedDomIndex);


		//listen to resize
		this._sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(),  jQuery.proxy(this._fnResize, this));

		// Change ITB content height on resize when ITB stretchContentHeight is set to true (IE9 fix)
		if (!jQuery.support.newFlexBoxLayout &&
			this.getParent() instanceof sap.m.IconTabBar &&
			this.getParent().getStretchContentHeight()) {
			this._sResizeListenerNoFlexboxSupportId = sap.ui.core.ResizeHandler.register(this.getParent().getDomRef(), jQuery.proxy(this._fnResizeNoFlexboxSupport, this));
			this._fnResizeNoFlexboxSupport();
		}

	};

	/*
	 * Destroys the item aggregation.
	 */
	IconTabHeader.prototype.destroyItems = function() {
		this.oSelectedItem = null;
		this._aTabKeys = [];
		this.destroyAggregation("items");
	};

	IconTabHeader.prototype.addItem = function(oItem) {
		if (!(oItem instanceof sap.m.IconTabSeparator)) {
			var sKey = oItem.getKey();
			// check if key is a duplicate
			if (this._aTabKeys.indexOf(sKey) !== -1) {
				jQuery.sap.log.warning("sap.m.IconTabHeader: duplicate key '" + sKey + "' inside the IconTabFilter. Please use unique keys.");
			}
			this._aTabKeys.push(sKey);
		}
		this.addAggregation("items", oItem);
	};

	IconTabHeader.prototype.insertItem = function(oItem, iIndex) {
		if (!(oItem instanceof sap.m.IconTabSeparator)) {
			var sKey = oItem.getKey();
			//check if key is a duplicate
			if (this._aTabKeys.indexOf(sKey) !== -1) {
				jQuery.sap.log.warning("sap.m.IconTabHeader: duplicate key '" + sKey + "' inside the IconTabFilter. Please use unique keys.");
			}
			this._aTabKeys.push(sKey);
		}
		this.insertAggregation("items", oItem, iIndex);
	};

	IconTabHeader.prototype.removeAllItems = function() {
		this._aTabKeys = [];
		this.removeAllAggregation("items");
	};

	IconTabHeader.prototype.removeItem = function(oItem) {
		// Make sure we have the actual Item and not just an ID
		oItem = this.removeAggregation("items", oItem);

		if (oItem && !(oItem instanceof sap.m.IconTabSeparator)) {
			var sKey = oItem.getKey();
			this._aTabKeys.splice(this._aTabKeys.indexOf(sKey) , 1);
		}

		// Return the original value from removeAggregation
		return oItem;
	};

	IconTabHeader.prototype.removeAggregation = function (sAggregationName, oObject, bSuppressInvalidate) {
		var aItems = this.getItems();

		var oItem = Control.prototype.removeAggregation.apply(this, arguments);

		if (oItem && oItem == this.oSelectedItem && sAggregationName == 'items') {

			var iIndexOf = jQuery.inArray(oItem, aItems);
			aItems = this.getItems();

			iIndexOf = Math.max(0, Math.min(iIndexOf, aItems.length - 1));

			var oSelectedItem = aItems[iIndexOf];

			if (oSelectedItem) {
				this.setSelectedItem(oSelectedItem);
			} else {
				var oIconTabBar = this.getParent();
				if (oIconTabBar instanceof sap.m.IconTabBar && oIconTabBar.getExpanded()) {
					oIconTabBar.$("content").children().remove();
				}
			}
		}

		return oItem;
	};

	IconTabHeader.prototype.removeAllAggregation = function (sAggregationName, bSuppressInvalidate) {

		if (sAggregationName == 'items') {
			var oIconTabBar = this.getParent();
			if (oIconTabBar instanceof sap.m.IconTabBar && oIconTabBar.getExpanded()) {
				oIconTabBar.$("content").children().remove();
			}
		}

		return Control.prototype.removeAllAggregation.apply(this, arguments);
	};


	/**
	 * Checks if all tabs are textOnly version.
	 * @private
	 * @returns true if all tabs are textOnly version, otherwise false
	 */
	IconTabHeader.prototype._checkTextOnly = function(aItems) {
		if (aItems.length > 0) {
			for (var i = 0; i < aItems.length; i++) {
				if (!(aItems[i] instanceof sap.m.IconTabSeparator)) {
					if (aItems[i].getIcon()) {
						this._bTextOnly = false;
						return false;
					}
				}
			}
		}
		this._bTextOnly = true;
		return true;
	};

	/**
	 * Checks if all tabs are noText version.
	 * @private
	 * @returns true if all tabs are noText version, otherwise false
	 */
	IconTabHeader.prototype._checkNoText = function(aItems) {
		if (aItems.length > 0) {
			for (var i = 0; i < aItems.length; i++) {
				if (!(aItems[i] instanceof sap.m.IconTabSeparator)) {
					if (aItems[i].getText().length > 0) {
						return false;
					}
				}
			}
		}
		return true;
	};

	/**
	 * Checks if scrolling is needed.
	 * @private
	 * @returns true if scrolling is needed, otherwise false
	 */
	IconTabHeader.prototype._checkScrolling = function(oHead, $bar) {
		var bScrolling = false;

		if (this._bDoScroll) { //iScroll is used, therefore we need other calculation then in desktop mode
			var domScrollCont = this.getDomRef("scrollContainer");
			var domHead = this.getDomRef("head");

			if (domHead && domScrollCont) {
				if (domHead.offsetWidth > domScrollCont.offsetWidth) {
					bScrolling = true;
				}
			}
		} else { //desktop mode
			//check if there are more tabs as displayed
			if (oHead) {
				if (oHead.scrollWidth > oHead.clientWidth) {
					//scrolling possible
					bScrolling = true;
				}
			}
		}

		if (this._scrollable !== bScrolling) {
			$bar.toggleClass("sapMITBScrollable", bScrolling);
			$bar.toggleClass("sapMITBNotScrollable", !bScrolling);
			this._scrollable = bScrolling;
		}

		return bScrolling;
	};

	/**
	 * Gets the icon of the requested arrow (left/right).
	 * @private
	 * @param sName left or right
	 * @returns icon of the requested arrow
	 */
	IconTabHeader.prototype._getScrollingArrow = function(sName) {
		var src;

		if (sap.ui.Device.system.desktop) {
			// use navigation arrows on desktop and win8 combi devices
			src = "sap-icon://navigation-" + sName + "-arrow";
		} else {
			// use slim arrows on mobile devices
			src = "sap-icon://slim-arrow-" + sName;
		}

		var mProperties = {
			src : src
		};

		var sSuffix = this._bTextOnly ? "TextOnly" : "";
		var sLeftArrowClass = "sapMITBArrowScrollLeft" + sSuffix;
		var sRightArrowClass = "sapMITBArrowScrollRight" + sSuffix;

		var aCssClassesToAddLeft = ["sapMITBArrowScroll", sLeftArrowClass];
		var aCssClassesToAddRight = ["sapMITBArrowScroll", sRightArrowClass];

		if (sName === "left") {
			if (!this._oArrowLeft) {
				this._oArrowLeft = sap.m.ImageHelper.getImageControl(this.getId() + "-arrowScrollLeft", this._oArrowLeft, this, mProperties, aCssClassesToAddLeft);
			}
			return this._oArrowLeft;
		}
		if (sName === "right") {
			if (!this._oArrowRight) {
				this._oArrowRight = sap.m.ImageHelper.getImageControl(this.getId() + "-arrowScrollRight", this._oArrowRight, this, mProperties, aCssClassesToAddRight);
			}
			return this._oArrowRight;
		}
	};

	/**
	 * Changes the state of the scroll arrows depending on whether they are required due to overflow.
	 *
	 * @param oListDomRef the ul tag containing the items
	 * @param of_back the backward scroll arrow
	 * @param of_fw the forward scroll arrow
	 * @private
	 */
	IconTabHeader.prototype._checkOverflow = function(oBarHead, $bar) {

		if (this._checkScrolling(oBarHead, $bar) && oBarHead) {
			// check whether scrolling to the left is possible
			var bScrollBack = false;
			var bScrollForward = false;

			if (this._bDoScroll) { //ScrollEnablement is used, therefore we need other calculation then in desktop mode
				var domScrollCont = this.getDomRef("scrollContainer");
				var domHead = this.getDomRef("head");
				if (this._oScroller.getScrollLeft() > 0) {
					bScrollBack = true;
				}
				if ((this._oScroller.getScrollLeft() + domScrollCont.offsetWidth) < domHead.offsetWidth) {
					bScrollForward = true;
				}

			} else { //desktop mode
				var iScrollLeft = this._iCurrentScrollLeft;
				var realWidth = oBarHead.scrollWidth;
				var availableWidth = oBarHead.clientWidth;

				if (Math.abs(realWidth - availableWidth) == 1) { // Avoid rounding issues see CSN 1316630 2013
					realWidth = availableWidth;
				}

				if (!this._bRtl) {   // normal LTR mode
					if (iScrollLeft > 0) {
						bScrollBack = true;
					}
					if ((realWidth > availableWidth) && (iScrollLeft + availableWidth < realWidth)) {
						bScrollForward = true;
					}
				} else {  // RTL mode
					var $List = jQuery(oBarHead);
					if ($List.scrollLeftRTL() > 0) {
						bScrollForward = true;
					}
					if ($List.scrollRightRTL() > 0) {
						bScrollBack = true;
					}
				}
			}

			// only do DOM changes if the state changed to avoid periodic application of identical values
			if ((bScrollForward != this._bPreviousScrollForward) || (bScrollBack != this._bPreviousScrollBack)) {
				this._bPreviousScrollForward = bScrollForward;
				this._bPreviousScrollBack = bScrollBack;
				$bar.toggleClass("sapMITBScrollBack", bScrollBack);
				$bar.toggleClass("sapMITBNoScrollBack", !bScrollBack);
				$bar.toggleClass("sapMITBScrollForward", bScrollForward);
				$bar.toggleClass("sapMITBNoScrollForward", !bScrollForward);
			}
		} else {
			this._bPreviousScrollForward = false;
			this._bPreviousScrollBack = false;
		}
	};

	/**
	 * Handles the activation of the tabs and arrows.
	 * @private
	 */
	IconTabHeader.prototype._handleActivation = function(oEvent) {
		var sTargetId = oEvent.target.id,
			oControl = oEvent.srcControl,
			sControlId;

		var $sTargetId = jQuery.sap.byId(sTargetId);
		/*eslint-disable no-empty */
		// TODO check better implementation
		if (jQuery.inArray(this.$("content")[0], $sTargetId.parents()) > -1) {
		/*eslint-enable no-empty */
			//do nothing because element is inside content
		} else {
			if (sTargetId) {
				var sId = this.getId();

				// For items: do not navigate away! Stay on the page and handle the click in-place. Right-click + "Open in new Tab" still works.
				// For scroll buttons: Prevent IE from firing beforeunload event -> see CSN 4378288 2012
				oEvent.preventDefault();

				//on mobile devices click on arrows has no effect
				if (sTargetId == sId + "-arrowScrollLeft" && sap.ui.Device.system.desktop) {
					if (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8) {
						//combi devices with windows 8 should also scroll on click on arrows
						//need to use iscroll
						var iScrollLeft = this._oScroller.getScrollLeft() - IconTabHeader.SCROLL_STEP;
						if (iScrollLeft < 0) {
							iScrollLeft = 0;
						}
						// execute manual scrolling with iScroll's scrollTo method (delayedCall 0 is needed for positioning glitch)
						this._scrollPreparation();
						jQuery.sap.delayedCall(0, this._oScroller, "scrollTo", [iScrollLeft, 0, 500]);
						jQuery.sap.delayedCall(500, this, "_afterIscroll");
					} else {
						// scroll back/left button
						this._scroll(-IconTabHeader.SCROLL_STEP, 500);
					}

				} else if (sTargetId == sId + "-arrowScrollRight" && sap.ui.Device.system.desktop) {
					if (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8) {
						//combi devices with windows 8 should also scroll on click on arrows
						//need to use iscroll
						var iScrollLeft = this._oScroller.getScrollLeft() + IconTabHeader.SCROLL_STEP;
						var iContainerWidth = this.$("scrollContainer").width();
						var iHeadWidth = this.$("head").width();
						if (iScrollLeft > (iHeadWidth - iContainerWidth)) {
							iScrollLeft = iHeadWidth - iContainerWidth;
						}
						// execute manual scrolling with iScroll's scrollTo method (delayedCall 0 is needed for positioning glitch)
						this._scrollPreparation();
						jQuery.sap.delayedCall(0, this._oScroller, "scrollTo", [iScrollLeft, 0, 500]);
						jQuery.sap.delayedCall(500, this, "_afterIscroll");
					} else {
						// scroll forward/right button
						this._scroll(IconTabHeader.SCROLL_STEP, 500);
					}

				} else {

					// should be one of the items - select it
					if (oControl instanceof sap.ui.core.Icon || oControl instanceof sap.m.Image) {
						// click on icon: fetch filter instead
						sControlId = oEvent.srcControl.getId().replace(/-icon$/, "");
						oControl = sap.ui.getCore().byId(sControlId);
						if (oControl.getMetadata().isInstanceOf("sap.m.IconTab") && !(oControl instanceof sap.m.IconTabSeparator)) {
							this.setSelectedItem(oControl);
						}
					} else if (oControl.getMetadata().isInstanceOf("sap.m.IconTab") && !(oControl instanceof sap.m.IconTabSeparator)) {
						// select item if it is an iconTab but not a separator

						this.setSelectedItem(oControl);
					}
				}
			} else {
				//no target id, so we have to check if showAll is set or it's a text only item, because clicking on the number then also leads to selecting the item
				if (oControl.getMetadata().isInstanceOf("sap.m.IconTab") && !(oControl instanceof sap.m.IconTabSeparator)) {
					this.setSelectedItem(oControl);
				}
			}
		}
	};

	/*
	 * Scrolls to the item passed as parameter if it is not (fully) visible
	 * If the item is to the left of the viewport it will be put leftmost.
	 * If the item is to the right of the viewport it will be put rightmost.
	 * @param {sap.m.IconTabFilter} oItem The item to be scrolled into view
	 * @param {int} iDuration The duration of the animation effect
	 * @private
	 * @return {sap.m.IconTabHeader} this pointer for chaining
	 */
	IconTabHeader.prototype._scrollIntoView = function(oItem, iDuration) {
		var $item = oItem.$(),
		oHeadDomRef,
		iScrollLeft,
		iNewScrollLeft,
		iContainerWidth;

		if ($item.length > 0) {
			var $head = this.$('head');
			var iHeadPaddingWidth = $head.innerWidth() - $head.width();
			var iItemWidth = $item.outerWidth(true);
			var iItemPosLeft = $item.position().left - iHeadPaddingWidth / 2;

			// switch based on scrolling mode
			if (this._bDoScroll) { // ScrollEnablement
				iScrollLeft = this._oScroller.getScrollLeft();
				iContainerWidth = this.$("scrollContainer").width();
				iNewScrollLeft = 0;

				// check if item is outside of viewport
				if (iItemPosLeft - iScrollLeft < 0 || iItemPosLeft - iScrollLeft > iContainerWidth - iItemWidth) {
					if (iItemPosLeft - iScrollLeft < 0) { // left side: make this the first item
						iNewScrollLeft += iItemPosLeft;
					} else { // right side: make this the last item
						iNewScrollLeft += iItemPosLeft + iItemWidth - iContainerWidth;
					}

					// execute manual scrolling with scrollTo method (delayedCall 0 is needed for positioning glitch)
					this._scrollPreparation();
					// store current scroll state to set it after rerendering
					this._iCurrentScrollLeft = iNewScrollLeft;
					jQuery.sap.delayedCall(0, this._oScroller, "scrollTo", [iNewScrollLeft, 0, iDuration]);
					jQuery.sap.delayedCall(iDuration, this, "_afterIscroll");
				}
			} else { // desktop scrolling with jQuery
				oHeadDomRef = this.getDomRef("head");
				iScrollLeft = oHeadDomRef.scrollLeft;
				iContainerWidth = $item.parent().width();
				iNewScrollLeft = iScrollLeft;

				// check if item is outside of viewport
				if (iItemPosLeft < 0 || iItemPosLeft > iContainerWidth - iItemWidth) {
					if (iItemPosLeft < 0) { // left side: make this the first item
						iNewScrollLeft += iItemPosLeft;
					} else { // right side: make this the last item
						iNewScrollLeft += iItemPosLeft + iItemWidth - iContainerWidth;
					}

					// execute scrolling
					this._scrollPreparation();
					// store current scroll state to set it after rerendering
					this._iCurrentScrollLeft = iNewScrollLeft;
					jQuery(oHeadDomRef).stop(true, true).animate({scrollLeft: iNewScrollLeft}, iDuration, jQuery.proxy(this._adjustAndShowArrow, this));
				}
			}
		}

		return this;
	};

	/*
	 * Scrolls the items if possible, using an animation.
	 *
	 * @param iDelta how far to scroll
	 * @param iDuration how long to scroll (ms)
	 * @private
	 */
	IconTabHeader.prototype._scroll = function(iDelta, iDuration) {
		this._scrollPreparation();

		var oDomRef = this.getDomRef("head");
		var iScrollLeft = oDomRef.scrollLeft;
		if (!!!sap.ui.Device.browser.internet_explorer && this._bRtl) {
			iDelta = -iDelta;
		} // RTL lives in the negative space
		var iScrollTarget = iScrollLeft + iDelta;
		jQuery(oDomRef).stop(true, true).animate({scrollLeft: iScrollTarget}, iDuration, jQuery.proxy(this._adjustAndShowArrow, this));
		this._iCurrentScrollLeft = iScrollTarget;
	};

	/**
	 * Adjusts the arrow position and shows the arrow.
	 * @private
	 */
	IconTabHeader.prototype._adjustAndShowArrow = function() {
		this._$bar && this._$bar.toggleClass("sapMITBScrolling", false);
		this._$bar = null;
		//update the arrows on desktop
		if (sap.ui.Device.system.desktop) {
			this._checkOverflow(this.getDomRef("head"), this.$());
		}
	};

	/**
	 * Scroll preparation.
	 * @private
	 */
	IconTabHeader.prototype._scrollPreparation = function() {
		if (!this._$bar) {
			this._$bar = this.$().toggleClass("sapMITBScrolling", true);
		}
	};

	/**
	 * After iscroll.
	 * @private
	*/
	IconTabHeader.prototype._afterIscroll = function() {
		var oHead = this.getDomRef("head");
		this._checkOverflow(oHead, this.$());
		this._adjustAndShowArrow();
	};

	/**
	 * Resize  handling.
	 * @private
	*/
	IconTabHeader.prototype._fnResize = function() {
		var oHead = this.getDomRef("head");
		this._checkOverflow(oHead, this.$());
	};

	/**
	 * Resize handler for ITB content inside FixFlex layout (IE9 fix)
	 * Calculate height on the content
	 * @private
	 */
	sap.m.IconTabHeader.prototype._fnResizeNoFlexboxSupport = function() {
		var $content = this.getParent().$("containerContent"),
			iDiffOuterInnerHeight = $content.outerHeight(true) - $content.height();

		// calculate and set content div height
		$content.height(this.getParent().$().height() - $content.position().top - iDiffOuterInnerHeight);
	};

	sap.m.IconTabHeader.prototype.onExit = function() {
		// Deregister resize event before re-rendering
		if (this._sResizeListenerNoFlexboxSupportId) {
			sap.ui.core.ResizeHandler.deregister(this._sResizeListenerNoFlexboxSupportId);
			this._sResizeListenerNoFlexboxSupportId = null;
		}
	};

	/**
	 * @overwrite
	 */
	//overwritten method, returns for most cases the iconDomRef, if the given tab has no icon, the textDomRef is returned.
	IconTabHeader.prototype.getFocusDomRef = function (oFocusTab) {
		var oTab = oFocusTab || this.oSelectedItem;
		if (!oTab) {
			return null;
		}

		return oTab.getDomRef();
	};

	IconTabHeader.prototype.applyFocusInfo = function (oFocusInfo) {
		//sets the focus depending on the used IconTabFilter
		if (oFocusInfo.focusDomRef) {
			jQuery(oFocusInfo.focusDomRef).focus();
		}
	};

	/* =========================================================== */
	/*           begin: event handlers                             */
	/* =========================================================== */

	/**
	 * Initializes scrolling on the IconTabHeader.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	IconTabHeader.prototype.ontouchstart = function(oEvent) {
		var oTargetTouch = oEvent.targetTouches[0];

		// store & init touch state
		this._iActiveTouch = oTargetTouch.identifier;
		this._iTouchStartPageX = oTargetTouch.pageX;
		this._iTouchDragX = 0;

		var $target = jQuery(oEvent.target);

		// prevent text selecting when click on the scrolling arrows
		if ($target.hasClass('sapMITBArrowScroll')) {
			oEvent.preventDefault();
		}

		//if the browser is IE prevent click events on dom elements in the tab, because the IE will focus them, not the tab itself.
		if (sap.ui.Device.browser.internet_explorer) {
			if ($target.hasClass('sapMITBFilterIcon') || $target.hasClass('sapMITBCount') || $target.hasClass('sapMITBText') || $target.hasClass('sapMITBTab') || $target.hasClass('sapMITBContentArrow') || $target.hasClass('sapMITBSep') || $target.hasClass('sapMITBSepIcon')) {
				oEvent.preventDefault();
			}
		}
	};

	/**
	 * Sets an internal flag if horizontal drag was executed.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	IconTabHeader.prototype.ontouchmove = function(oEvent) {
		var oTouch = sap.m.touch.find(oEvent.changedTouches, this._iActiveTouch);

		// check for valid changes
		if (!oTouch || oTouch.pageX === this._iTouchStartPageX) {
			return;
		}

		// sum up movement to determine in touchend event if selection should be executed
		this._iTouchDragX += Math.abs(this._iTouchStartPageX - oTouch.pageX);
		this._iTouchStartPageX = oTouch.pageX;
	};

	/**
	 * Handles touch end and events and trigger selection if bar was not dragged.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	IconTabHeader.prototype.ontouchend = function(oEvent) {
		// suppress selection if there ware a drag (moved more than 5px on desktop or 20px on others)
		if (this._scrollable && this._iTouchDragX > (sap.ui.Device.system.desktop ? 5 : 15)) {
			return;
		}

		this._handleActivation(oEvent);
	};


	/**
	 * Handle the touch cancel event.
	 *
	 * @param {jQuery.EventObject} oEvent The event object
	 * @private
	 */
	IconTabHeader.prototype.ontouchcancel = IconTabHeader.prototype.ontouchend;

	/**
	 * Keyboard navigation event when the user presses Enter or Space.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	IconTabHeader.prototype.onsapselect = function(oEvent) {
		this._handleActivation(oEvent);
	};

	/* =========================================================== */
	/*           end: event handlers                               */
	/* =========================================================== */


	return IconTabHeader;

}, /* bExport= */ true);

}; // end of sap/m/IconTabHeader.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabSeparator') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.IconTabSeparator.
jQuery.sap.declare('sap.m.IconTabSeparator'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/m/IconTabSeparator",['jquery.sap.global', './library', 'sap/ui/core/Element'],
	function(jQuery, library, Element) {
	"use strict";


	
	/**
	 * Constructor for a new IconTabSeparator.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A tab separator item class
	 * @extends sap.ui.core.Element
	 * @implements sap.m.IconTab
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.IconTabSeparator
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var IconTabSeparator = Element.extend("sap.m.IconTabSeparator", /** @lends sap.m.IconTabSeparator.prototype */ { metadata : {
	
		interfaces : [
			"sap.m.IconTab"
		],
		library : "sap.m",
		properties : {
	
			/**
			 * The icon to display for this separator. If no icon is given, a separator line will be used instead.
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : ''},
	
			/**
			 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
			 * 
			 * If bandwidth is the key for the application, set this value to false.
			 */
			iconDensityAware : {type : "boolean", group : "Appearance", defaultValue : true}
		}
	}});
	
	/**
	 * Lazy load feed icon image.
	 *
	 * @param {Array} aCssClasses array of css classes which will be added if the image needs to be created.
	 * @param {sap.ui.core.Control} oParent this element's parent.
	 * @private
	 */
	IconTabSeparator.prototype._getImageControl = function(aCssClasses, oParent) {
		var mProperties = {
			src : this.getIcon(),
			densityAware : this.getIconDensityAware()
		};
		
		this._oImageControl = sap.m.ImageHelper.getImageControl(this.getId() + "-icon", this._oImageControl, oParent, mProperties, aCssClasses);
		
		return this._oImageControl;
	};
	
	/**
	 * Function is called when exiting the element.
	 * 
	 * @private
	 */
	IconTabSeparator.prototype.exit = function(oEvent) {
		
		if (this._oImageControl) {
			this._oImageControl.destroy();
		}
		
		if (sap.ui.core.Item.prototype.exit) {
			sap.ui.core.Item.prototype.exit.call(this, oEvent);
		}
	};
	
	return IconTabSeparator;

}, /* bExport= */ true);

}; // end of sap/m/IconTabSeparator.js
if ( !jQuery.sap.isDeclared('sap.m.Image') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.Image.
jQuery.sap.declare('sap.m.Image'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/m/Image",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new Image.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A wrapper around the IMG tag. The image can be loaded from a remote or local server.
	 * 
	 * Density related image will be loaded if image with density awareness name in format [imageName]@[densityValue].[extension] is provided. The valid desity values are 1, 1.5, 2. If the original devicePixelRatio isn't one of the three valid numbers, it's rounded up to the nearest one.
	 * 
	 * There are various size setting options available, and the images can be combined with actions.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.Image
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Image = Control.extend("sap.m.Image", /** @lends sap.m.Image.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {
	
			/**
			 * Relative or absolute path to URL where the image file is stored. The path will be adapted to the density aware format according to the density of the device following the convention that [imageName]@[densityValue].[extension]
			 */
			src : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
	
			/**
			 * When the empty value is kept, the original size is not changed. It is also possible to make settings for width or height only, the original ratio between width/height is maintained.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null},
	
			/**
			 * When the empty value is kept, the original size is not changed. It is also possible to make settings for width or height only, the original ratio between width/height is maintained.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null},
	
			/**
			 * A decorative image is included for design reasons. Accessibility tools will ignore decorative images.
			 * 
			 * Note: If the Image has an image map (useMap is set), this property will be overridden (the image will not be rendered as decorative).
			 * A decorative image has no ALT attribute, so the Alt property is ignored if the image is decorative.
			 */
			decorative : {type : "boolean", group : "Accessibility", defaultValue : true},
	
			/**
			 * The alternative text that is displayed in case the Image is not available, or cannot be displayed.
			 * If the image is set to decorative this property is ignored.
			 */
			alt : {type : "string", group : "Accessibility", defaultValue : null},
	
			/**
			 * The name of the image map that defines the clickable areas
			 */
			useMap : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * If this is set to false, the src image will be loaded directly without attempting to fetch the density perfect image for high density device.
			 * 
			 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
			 * 
			 * If bandwidth is the key for the application, set this value to false.
			 */
			densityAware : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * The source property when this image is tapped.
			 */
			activeSrc : {type : "sap.ui.core.URI", group : "Data", defaultValue : ""}
		},
		events : {
	
			/**
			 * Event is fired when the user clicks on the control. (This event is deprecated, use the press event instead)
			 */
			tap : {}, 
	
			/**
			 * Event is fired when the user clicks on the control.
			 */
			press : {}
		}
	}});
	
	Image._currentDevicePixelRatio = (function() {
	
		// if devicePixelRatio property is not available, value 1 is assumed by default.
		var ratio = (window.devicePixelRatio === undefined ? 1 : window.devicePixelRatio);
	
		// for ratio in our library, only 1 1.5 2 are valid
		if (ratio <= 1) {
			ratio = 1;
		} else {
	
			// round it to the nearest valid value
			ratio *= 2;
			ratio = Math.round(ratio);
			ratio /= 2;
		}
	
		if (ratio > 2) {
			ratio = 2;
		}
	
		return ratio;
	}());
	
	/**
	 * Function is called when image is loaded successfully.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Image.prototype.onload = function(oEvent) {	
		// This is used to fix the late load event handler problem on ios platform, if the event handler
		// has not been called right after image is loaded, event is triggered manually in onAfterRendering
		// method.
		if (!this._defaultEventTriggered) {
			this._defaultEventTriggered = true;
		}

		// reset the flag for the next rerendering
		this._bVersion2Tried = false;

		var $DomNode = this.$(),
			oDomRef = $DomNode[0];

		if (!this._isWidthOrHeightSet()) {
			if (this._iLoadImageDensity > 1) {
				if (($DomNode.width() === oDomRef.naturalWidth) && ($DomNode.height() === oDomRef.naturalHeight)) {
					$DomNode.width($DomNode.width() / this._iLoadImageDensity);
				}
			}
		}

		$DomNode.removeClass("sapMNoImg");
	};
	
	/**
	 * Function is called when error occurs during image loading.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Image.prototype.onerror = function(oEvent) {
	
		// This is used to fix the late load event handler problem on ios platform, if the event handler
		// has not been called right after image is loaded with errors, event is triggered manually in onAfterRendering
		// method.
		if (!this._defaultEventTriggered) {
			this._defaultEventTriggered = true;
		}
	
		var $DomNode = this.$(),
			sCurrentSrc = $DomNode.attr("src"),
			d = Image._currentDevicePixelRatio;
	
		$DomNode.addClass("sapMNoImg");
	
		// if src is empty or there's no image existing, just stop
		if (!sCurrentSrc || this._iLoadImageDensity === 1) {
			return;
		}
	
		if (d === 2 || d < 1) {
	
			// load the default image
			this._iLoadImageDensity = 1;
			$DomNode.attr("src", this._generateSrcByDensity(this._isActiveState ? this.getActiveSrc() : this.getSrc(), 1));
		} else if (d === 1.5) {
			if (this._bVersion2Tried) {
				setTimeout(jQuery.proxy(function() {

					// if version 2 isn't on the server, load the default image
					this._iLoadImageDensity = 1;
					$DomNode.attr("src", this._generateSrcByDensity(this._isActiveState ? this.getActiveSrc() : this.getSrc(), 1));
				}, this), 0);
			} else {
				setTimeout(jQuery.proxy(function() {
	
					// special treatment for density 1.5
					// verify if the version for density 2 is provided or not
					this._iLoadImageDensity = 2;
					$DomNode.attr("src", this._generateSrcByDensity(this._isActiveState ? this.getActiveSrc() : this.getSrc(), 2));
					this._bVersion2Tried = true;
				}, this), 0);
			}
		}
	};
	
	/**
	 * This function is called to register event handlers for load and error event on the image DOM after it's rendered.
	 * It also check if the event handlers are called accordingly after the image is loaded, if not the event handlers are triggered
	 * manually.
	 *
	 * @private
	 */
	Image.prototype.onAfterRendering = function() {
	
		// if densityAware is set to true, we need to do extra steps for getting and resizing the density perfect version of the image.
		if (this.getDensityAware()) {
			var $DomNode = this.$();
	
			// bind the load and error event handler
			$DomNode.on("load", jQuery.proxy(this.onload, this));
			$DomNode.on("error", jQuery.proxy(this.onerror, this));
	
			var oDomRef = this.getDomRef();
	
			// if image has already been loaded and the load or error event handler hasn't been called, trigger it manually.
			if (oDomRef.complete && !this._defaultEventTriggered) {
	
				// need to use the naturalWidth property instead of jDomNode.width(),
				// the later one returns positive value even in case of broken image
				$DomNode.trigger(oDomRef.naturalWidth > 0 ? "load" : "error");	//  image loaded successfully or with error
			}
		}
	};
	
	/**
	 * This binds to the touchstart event to change the src property of the image to the activeSrc.
	 *
	 * @private
	 */
	Image.prototype.ontouchstart = function(oEvent) {
		if (oEvent.srcControl.mEventRegistry["press"] || oEvent.srcControl.mEventRegistry["tap"]) {
	
			// mark the event for components that needs to know if the event was handled by the Image
			oEvent.setMarked();
		}
	
		if (oEvent.targetTouches.length === 1 && this.getActiveSrc()) {
	
			// change the source only when the first finger is on the image, the following fingers doesn't affect
			this.$().attr("src", this._getDensityAwareActiveSrc());
			this._isActiveState = true;
		}
	};
	
	/**
	 * This changes the src property of the image back to the src property of the image control.
	 *
	 * @private
	 */
	Image.prototype.ontouchend = function(oEvent) {
		// change the source back only when all fingers leave the image
		// avoid setting the normal state src again when there's no activeSrc property set
		if (oEvent.targetTouches.length === 0 && this.getActiveSrc()) {
			this._isActiveState = false;
			this.$().attr("src", this._getDensityAwareSrc()).removeClass("sapMNoImg");
		}
	};
	
	/**
	 * This overrides the default setter of the src property and update the dom node.
	 *
	 * @param {sap.ui.core.URI} sSrc
	 * @public
	 */
	Image.prototype.setSrc = function(sSrc) {
		if (sSrc === this.getSrc()) {
			return;
		}
	
		this.setProperty("src", sSrc, true);
	
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			this.$().attr("src", this._getDensityAwareSrc());
		}
	};
	
	/**
	 * This overrides the default setter of the activeSrc property in order to avoid the rerendering.
	 *
	 * @param {sap.ui.core.URI} sActiveSrc
	 * @public
	 */
	Image.prototype.setActiveSrc = function(sActiveSrc) {
		if (!sActiveSrc) {
			sActiveSrc = "";
		}
	
		this.setProperty("activeSrc", sActiveSrc, true);
	};
	
	/**
	 * Function is called when image is clicked.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Image.prototype.ontap = function(oEvent) {
		this.fireTap({/* no parameters */}); //	(This event is deprecated, use the press event instead)
		this.firePress({/* no parameters */});
	};
	
	/**
	 * Handle the key up event for SPACE and ENTER.
	 *
	 * @param {jQuery.Event} oEvent - the keyboard event.
	 * @private
	 */
	Image.prototype.onkeyup = function(oEvent) {
		if (oEvent.which === jQuery.sap.KeyCodes.SPACE || oEvent.which === jQuery.sap.KeyCodes.ENTER) {
			this.firePress({/* no parameters */});
		}
	};
	
	/**
	 * Test if at least one of the width and height properties is set.
	 *
	 * @private
	 */
	Image.prototype._isWidthOrHeightSet = function() {
		return (this.getWidth() && this.getWidth() !== '') || (this.getHeight() && this.getHeight() !== '');
	};
	
	/**
	 * This function returns the density aware source based on the deviceDensityRatio value.
	 * The return value is in the format [src]@[densityValue].[extension] if the densityValue not equal 1, otherwise it returns the src property.
	 *
	 * @private
	 */
	Image.prototype._getDensityAwareSrc = function() {
		var d = Image._currentDevicePixelRatio,
			sSrc = this.getSrc();
	
		// this property is used for resizing the higher resolution image when image is loaded.
		this._iLoadImageDensity = d;
	
		// if devicePixelRatio equals 1 or densityAware set to false, simply return the src property
		if (d === 1 || !this.getDensityAware()) {
			return sSrc;
		}
	
		return this._generateSrcByDensity(sSrc, d);
	};
	
	/**
	 * This function returns the density aware version of the Active source base on the deviceDensityRatio value.
	 *
	 * @private
	 */
	Image.prototype._getDensityAwareActiveSrc = function() {
		var d = Image._currentDevicePixelRatio,
			sActiveSrc = this.getActiveSrc();
	
		// this property is used for resizing the higher resolution image when image is loaded.
		this._iLoadImageDensity = d;
	
		// if devicePixelRatio equals 1 or densityAware set to false, simply return the src property
		if (d === 1 || !this.getDensityAware()) {
			return sActiveSrc;
		}
	
		return this._generateSrcByDensity(sActiveSrc, d);
	};
	
	/**
	 * This function generates the density aware version of the src property according to the iDensity provided.
	 * It returns the density aware version of the src property.
	 *
	 * @private
	 */
	Image.prototype._generateSrcByDensity = function(sSrc, iDensity) {
		if (!sSrc) {
			return "";
		}
	
		// if src is in data uri format, disable the density handling
		if (this._isDataUri(sSrc)) {
			this._iLoadImageDensity = 1;
			return sSrc;
		}
	
		if (iDensity === 1) {
			return sSrc;
		}
	
		var iLastDotPos = sSrc.lastIndexOf("."),
			iLastSlashPos = sSrc.lastIndexOf("/"),
			sName = sSrc.substring(0, iLastDotPos),
			sExtension = sSrc.substring(iLastDotPos);
	
		// if there's no extension
		// or there's slash after the last dot, this means that the dot may come from the host name
		if (iLastDotPos === -1 || (iLastSlashPos > iLastDotPos)) {
			return sSrc + "@" + iDensity;
		}
	
		sName = sName + "@" + iDensity;
		return sName + sExtension;
	};
	
	Image.prototype._isDataUri = function(src) {
		return src ? src.indexOf("data:") === 0 : false;
	};

	return Image;

}, /* bExport= */ true);

}; // end of sap/m/Image.js
if ( !jQuery.sap.isDeclared('sap.m.InputBase') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.InputBase.
jQuery.sap.declare('sap.m.InputBase'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
sap.ui.define("sap/m/InputBase",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/EnabledPropagator', 'sap/ui/core/IconPool', 'sap/ui/core/Popup'],
	function(jQuery, library, Control, EnabledPropagator, IconPool, Popup) {
	"use strict";

	/**
	 * Constructor for a new InputBase.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Base control for Input fields.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.12.0
	 * @alias sap.m.InputBase
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var InputBase = Control.extend("sap.m.InputBase", /** @lends sap.m.InputBase.prototype */ { metadata: {

		library: "sap.m",
		properties: {

			/**
			 * Defines the value of the input.
			 */
			value: { type: "string", group: "Data", defaultValue: null, bindable: "bindable" },

			/**
			 * Defines the width of the input.
			 */
			width: { type: "sap.ui.core.CSSSize", group: "Dimension", defaultValue: null },

			/**
			 * Determines whether the user can change the input value (default is true).
			 */
			enabled: { type: "boolean", group: "Behavior", defaultValue: true },

			/**
			 * Visualizes warnings or errors related to the text field. Possible values: Warning, Error, Success.
			 */
			valueState: { type: "sap.ui.core.ValueState", group: "Appearance", defaultValue: sap.ui.core.ValueState.None },

			/**
			 * The "name" property to be used in the HTML code (e.g. for HTML forms that send data to the server via 'submit').
			 */
			name: { type: "string", group: "Misc", defaultValue: null },

			/**
			 * Text shown when no value available.
			 */
			placeholder: { type: "string", group: "Misc", defaultValue: null },

			/**
			 * Controls if a user can change the value.
			 * @since 1.12.0
			 */
			editable: { type: "boolean", group: "Behavior", defaultValue: true },

			/**
			 * The text which is shown in the value state message popup. If not specfied a default text is shown. This property is already available for sap.m.Input since 1.16.0.
			 * @since 1.26.0
			 */
			valueStateText: { type: "string", group: "Misc", defaultValue: null },

			/**
			 * Whether the value state message should be shown. This property is already available for sap.m.Input since 1.16.0.
			 * @since 1.26.0
			 */
			showValueStateMessage: { type: "boolean", group: "Misc", defaultValue: true },

			/**
			 * Sets the horizontal alignment of the text.
			 * @since 1.26.0
			 */
			textAlign: { type: "sap.ui.core.TextAlign", group: "Appearance", defaultValue: sap.ui.core.TextAlign.Initial },

			/**
			 * This property specifies the element's text directionality with enumerated options. By default, the control inherits text direction from the DOM.
			 * @since 1.28.0
			 */
			textDirection: { type: "sap.ui.core.TextDirection", group: "Appearance", defaultValue: sap.ui.core.TextDirection.Inherit }
		},
		associations: {

			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 * @since 1.27.0
			 */
			ariaLabelledBy: { type: "sap.ui.core.Control", multiple: true, singularName: "ariaLabelledBy" }
		},
		events: {

			/**
			 * This event gets fired when the text in the input field has changed and the focus leaves the input field or the enter key is pressed.
			 */
			change: {
				parameters: {

					/**
					 * The new value of the input.
					 */
					value: { type: "string" }
				}
			}
		}
	}});

	EnabledPropagator.call(InputBase.prototype);
	IconPool.insertFontFaceStyle();

	/* =========================================================== */
	/* Private methods and properties                              */
	/* =========================================================== */

	/* ----------------------------------------------------------- */
	/* Private properties                                          */
	/* ----------------------------------------------------------- */

	/**
	 * Use labels as placeholder configuration.
	 * It can be necessary for the subclasses to overwrite this when
	 * native placeholder usage causes undesired input events or when
	 * placeholder attribute is not supported for the specified type.
	 * https://html.spec.whatwg.org/multipage/forms.html#input-type-attr-summary
	 *
	 * @see sap.m.InputBase#oninput
	 * @protected
	 */
	InputBase.prototype.bShowLabelAsPlaceholder = !sap.ui.Device.support.input.placeholder;

	/* ----------------------------------------------------------- */
	/* Private methods                                             */
	/* ----------------------------------------------------------- */

	/**
	 * To allow setting of default placeholder e.g. in DatePicker
	 *
	 * FIXME: Remove this workaround
	 * What is the difference between _getPlaceholder and getPlaceholder
	 */
	InputBase.prototype._getPlaceholder = function() {
		return this.getPlaceholder();
	};

	/**
	 * Update the synthetic placeholder visibility.
	 */
	InputBase.prototype._setLabelVisibility = function() {
		if (!this.bShowLabelAsPlaceholder || !this._$label || !this.isActive()) {
			return;
		}

		var sValue = this._getInputValue();
		this._$label.css("display", sValue ? "none" : "inline");
	};

	/**
	 * Returns the DOM value respect to maxLength
	 * When parameter is set chops the given parameter
	 *
	 * TODO: write two different functions for two different behaviour
	 */
	InputBase.prototype._getInputValue = function(sValue) {
		sValue = (typeof sValue == "undefined") ? this._$input.val() : sValue.toString();

		if (this.getMaxLength && this.getMaxLength() > 0) {
			sValue = sValue.substring(0, this.getMaxLength());
		}

		return sValue;
	};

	/**
	 * Triggers input event from the input field delayed
	 * This event is marked as synthetic since it is not a native input event
	 * Event properties can be specified with first parameter when necessary
	 */
	InputBase.prototype._triggerInputEvent = function(mProperties) {
		mProperties = mProperties || {};
		var oEvent = new jQuery.Event("input", mProperties);
		oEvent.originalEvent = mProperties;
		oEvent.setMark("synthetic", true);

		// not to break real event order fire the event delayed
		jQuery.sap.delayedCall(0, this, function() {
			this.$("inner").trigger(oEvent);
		});
	};

	/* =========================================================== */
	/* Lifecycle methods                                           */
	/* =========================================================== */

	/**
	 * Initialization hook.
	 *
	 * TODO: respect hungarian notation for variables
	 * @private
	 */
	InputBase.prototype.init = function() {
		this._lastValue = "";	// last changed value
		this._changeProxy = jQuery.proxy(this.onChange, this);

		/**
		 * Indicates whether the input field is in the rendering phase.
		 *
		 * @protected
		 */
		this.bRenderingPhase = false;

		/**
		 * Indicates whether the <code>focusout</code> event is triggered due a rendering.
		 */
		this.bFocusoutDueRendering = false;
	};

	/**
	 * Required adaptations before rendering.
	 *
	 * @private
	 */
	InputBase.prototype.onBeforeRendering = function() {

		// mark the rendering phase
		this.bRenderingPhase = true;

		if (this._bCheckDomValue) {

			// remember dom value in case of invalidation during keystrokes
			// so the following should only be used onAfterRendering
			this._sDomValue = this._getInputValue();
		}
	};

	/**
	 * Required adaptations after rendering.
	 *
	 * @private
	 */
	InputBase.prototype.onAfterRendering = function() {

		// cache input as jQuery
		this._$input = this.$("inner");

		// maybe control is invalidated on keystrokes and
		// even the value property did not change
		// dom value is still the old value
		// FIXME: This is very ugly to implement this because of the binding
		if (this._bCheckDomValue && this._sDomValue !== this._getInputValue()) {

			// so we should keep the dom up-to-date
			this._$input.val(this._sDomValue);
		}

		// now dom value is up-to-date
		this._bCheckDomValue = false;

		// handle synthetic placeholder visibility
		if (this.bShowLabelAsPlaceholder) {
			this._$label = this.$("placeholder");
			this._setLabelVisibility();
		}

		// rendering phase is finished
		this.bRenderingPhase = false;
	};

	/**
	 * Cleans up before destruction.
	 *
	 * @private
	 */
	InputBase.prototype.exit = function() {
		this._$input = null;
		this._$label = null;
		if ( this._popup ){
			this._popup.destroy();
			this._popup = null;
		}
	};

	/* =========================================================== */
	/* Event handlers                                              */
	/* =========================================================== */

	/**
	 * Handles the touch start event of the Input.
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @private
	 */
	InputBase.prototype.ontouchstart = function(oEvent) {

		// mark the event for components that needs to know if the event was handled
		oEvent.setMarked();
	};

	/**
	 * Sets up at focus a touch listener on mobile devices.
	 *
	 * @private
	 */
	InputBase.prototype.onfocusin = function(oEvent) {
		this.$().toggleClass("sapMFocus", true);
		if (sap.ui.Device.support.touch) {
			// listen to all touch events
			jQuery(document).on('touchstart.sapMIBtouchstart', jQuery.proxy(this._touchstartHandler, this));
		}

		// open value state message popup when focus is in the input
		this.openValueStateMessage();
	};

	/**
	 * Captures the initial touch position and sets up listeners for touchmove, touchcancel and touchend
	 *
	 * @private
	 */
	InputBase.prototype._touchstartHandler = function (oEvent) {
		if (oEvent.target != this._$input[0]) {
			this._touchX = oEvent.targetTouches[0].pageX;
			this._touchY = oEvent.targetTouches[0].pageY;
			this._touchT = oEvent.timestamp;
			jQuery(oEvent.target)
				.on(  'touchmove.sapMIBtouch', jQuery.proxy(this._touchmoveHandler,this))
				.on(   'touchend.sapMIBtouch', jQuery.proxy(this._touchendHandler ,this))
				.on('touchcancel.sapMIBtouch', this._removeTouchHandler);
		}
	};

	/**
	 * Calculates if a touch session is a click event or something else (scoll, longtouch)
	 *
	 * @private
	 */
	InputBase.prototype._isClick = function(oEvent) {
		return Math.abs(oEvent.changedTouches[0].pageX - this._touchX) < 10 && Math.abs(oEvent.changedTouches[0].pageY - this._touchY) < 10 &&  oEvent.timestamp - this._touchT < jQuery.event.special.tap.tapholdThreshold; // 750ms
	};

	/**
	 * Cancels the action if the touch session is a long tap or scroll
	 *
	 * @private
	 */
	InputBase.prototype._touchmoveHandler = function(oEvent){
		if (!this._isClick(oEvent)) {
			jQuery(oEvent.target).off('.sapMIBtouch');
		}
	};

	/**
	 * Sends an early change event to the input if a tap has happened outside the input - e.g. on a button
	 *
	 * @private
	 */
	InputBase.prototype._touchendHandler = function(oEvent) {
		// cancel if scrolling or long tap
		if (this._isClick(oEvent)) {
			// simulate change event
			this.onChange(oEvent);
		}

		// remove all touch handlers
		jQuery(oEvent.target).off('.sapMIBtouch');
	};

	/**
	 * Handles the <code>focusout</code> event of the Input.
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @private
	 */
	InputBase.prototype.onfocusout = function(oEvent) {
		this.bFocusoutDueRendering = this.bRenderingPhase;
		this.$().toggleClass("sapMFocus", false);

		// remove touch handler from document for mobile devices
		jQuery(document).off(".sapMIBtouchstart");

		// because dom is replaced during the rendering
		// onfocusout event is triggered probably focus goes to the document
		// so we ignore this event that comes during the rendering
		if (this.bRenderingPhase) {
			return;
		}

		// close value state message popup when focus is out of the input
		this.closeValueStateMessage();
	};

	/**
	 * Handles the <code>sapfocusleave</code> event of the input.
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @private
	 */
	InputBase.prototype.onsapfocusleave = function(oEvent) {

		if (this.bFocusoutDueRendering) {
			return;
		}

		this.onChange(oEvent);
	};

	/**
	 * Handles the change event.
	 *
	 * @protected
	 * @param {object} oEvent
	 * @returns {true|undefined} true when change event is fired
	 */
	InputBase.prototype.onChange = function(oEvent) {

		// check the control is editable or not
		if (!this.getEditable() || !this.getEnabled()) {
			return;
		}

		// get the dom value respect to max length
		var sValue = this._getInputValue();

		// compare with the old known value
		if (sValue !== this._lastValue) {

			// save the value on change
			this.setValue(sValue);

			// get the value back maybe formatted
			sValue = this.getValue();

			// remember the last value on change
			this._lastValue = sValue;

			// fire change event
			this.fireChangeEvent(sValue);

			// inform change detection
			return true;
		}
	};

	/**
	 * Fires the change event for the listeners
	 *
	 * @protected
	 * @param {String} sValue value of the input.
	 * @param {Object} [oParams] extra event parameters.
	 * @since 1.22.1
	 */
	InputBase.prototype.fireChangeEvent = function(sValue, oParams) {
		// generate event parameters
		var oChangeEvent = jQuery.extend({
			value : sValue,

			// backwards compatibility
			newValue : sValue
		}, oParams);

		// fire change event
		this.fireChange(oChangeEvent);
	};

	/**
	 * Hook method that gets called when the input value is reverted with hitting escape.
	 * It may require to re-implement this method from sub classes for control specific behaviour.
	 *
	 * @protected
	 * @param {String} sValue Reverted value of the input.
	 * @since 1.26
	 */
	InputBase.prototype.onValueRevertedByEscape = function(sValue) {
		// fire private live change event
		this.fireEvent("liveChange", {
			value: sValue,

			// backwards compatibility
			newValue: sValue
		});
	};

	/* ----------------------------------------------------------- */
	/* Keyboard handling                                           */
	/* ----------------------------------------------------------- */

	/**
	 * Handle when enter is pressed.
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @private
	 */
	InputBase.prototype.onsapenter = function(oEvent) {

		// handle change event on enter
		this.onChange(oEvent);
	};

	/**
	 * Handle when escape is pressed.
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @private
	 */
	InputBase.prototype.onsapescape = function(oEvent) {

		// get the dom value that respect to max length
		var sValue = this._getInputValue();

		// compare last known value and dom value
		if (sValue !== this._lastValue) {

			// mark the event that it is handled
			oEvent.setMarked();
			oEvent.preventDefault();

			// revert to the old dom value
			this.updateDomValue(this._lastValue);

			// value is reverted, now call the hook to inform
			this.onValueRevertedByEscape(this._lastValue);
		}
	};

	/**
	 * Handle DOM input event.
	 *
	 * This event is fired synchronously when the value of an <input> or <textarea> element is changed.
	 * IE9 does not fire an input event when the user removes characters via BACKSPACE / DEL / CUT
	 * InputBase normalize this behaviour for IE9 and calls oninput for the subclasses
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @private
	 */
	InputBase.prototype.oninput = function(oEvent) {

		// dom value updated other than value property
		this._bCheckDomValue = true;

		// update the synthetic placeholder visibility
		this._setLabelVisibility();
	};

	/**
	 * Handle keydown event.
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @private
	 */
	InputBase.prototype.onkeydown = function(oEvent) {

		// IE9 does not fire input event on BACKSPACE & DEL
		var mKC = jQuery.sap.KeyCodes;
		var mBrowser = sap.ui.Device.browser;

		if ((mBrowser.msie && mBrowser.version < 10) &&
			(oEvent.which === mKC.DELETE || oEvent.which === mKC.BACKSPACE)) {

			// trigger synthetic input event
			this._triggerInputEvent();
		}
	};

	/**
	 * Handle cut event.
	 *
	 * @param {jQuery.Event} oEvent The event object.
	 * @private
	 */
	InputBase.prototype.oncut = function(oEvent) {

		// IE9 does not fire input event on cut
		var mBrowser = sap.ui.Device.browser;
		if (mBrowser.msie && mBrowser.version < 10) {

			// trigger synthetic input event
			this._triggerInputEvent();
		}
	};

	/* =========================================================== */
	/* API methods                                                 */
	/* =========================================================== */

	/* ----------------------------------------------------------- */
	/* protected methods                                           */
	/* ----------------------------------------------------------- */

	/**
	 * Selects the text within the input field between the specified start and end positions.
	 * Only supported for input control's type of Text, Url, Tel and Password.
	 *
	 * @param {integer} iSelectionStart The index into the text at which the first selected character is located.
	 * @param {integer} iSelectionEnd The index into the text at which the last selected character is located.
	 * @returns {sap.m.InputBase} <code>this</code> to allow method chaining.
	 * @protected
	 * @since 1.22.1
	 */
	InputBase.prototype.selectText = function(iSelectionStart, iSelectionEnd) {
		jQuery(this.getFocusDomRef()).selectText(iSelectionStart, iSelectionEnd);
		return this;
	};

	/**
	 * Overwrite setProperty function to know value property changes via API
	 * @overwrite
	 */
	InputBase.prototype.setProperty = function(sPropertyName, oValue, bSuppressInvalidate) {
		if (sPropertyName == "value") {

			// dom value will be updated with value property
			this._bCheckDomValue = false;
		}

		return Control.prototype.setProperty.apply(this, arguments);
	};

	/**
	 * Returns an object representing the serialized focus information.
	 * To be overwritten by subclasses.
	 *
	 * @returns {object} An object representing the serialized focus information.
	 * @protected
	 */
	InputBase.prototype.getFocusInfo = function() {
		var oFocusInfo = Control.prototype.getFocusInfo.call(this),
			oFocusDomRef = this.getFocusDomRef();

		// extend the serialized focus information with the current text selection and the cursor position
		jQuery.extend(oFocusInfo, {
			cursorPos: 0,
			selectionStart: 0,
			selectionEnd: 0
		});

		if (oFocusDomRef) {
			oFocusInfo.cursorPos = jQuery(oFocusDomRef).cursorPos();

			try {
				oFocusInfo.selectionStart = oFocusDomRef.selectionStart;
				oFocusInfo.selectionEnd = oFocusDomRef.selectionEnd;
			} catch (e) {
				// note: chrome fail to read the "selectionStart" property from HTMLInputElement: The input element's type "number" does not support selection.
			}
		}

		return oFocusInfo;
	};

	/**
	 * Applies the focus info.
	 * To be overwritten by subclasses.
	 *
	 * @param {object} oFocusInfo
	 * @protected
	 */
	InputBase.prototype.applyFocusInfo = function(oFocusInfo) {
		Control.prototype.applyFocusInfo.call(this, oFocusInfo);
		this.$("inner").cursorPos(oFocusInfo.cursorPos);
		this.selectText(oFocusInfo.selectionStart, oFocusInfo.selectionEnd);
		return this;
	};

	/**
	 * Registers an event listener to the browser input event.
	 *
	 * @param {function} fnCallback Function to be called when the value of the input element is changed.
	 * @deprecated Since 1.22. Instead, use event delegation(oninput) to listen input event.
	 * @return {sap.m.InputBase} <code>this</code> to allow method chaining.
	 * @protected
	 */
	InputBase.prototype.bindToInputEvent = function(fnCallback) {

		// remove the previous event delegate
		if (this._oInputEventDelegate) {
			this.removeEventDelegate(this._oInputEventDelegate);
		}

		// generate new input event delegate
		this._oInputEventDelegate = {
			oninput : fnCallback
		};

		// add the input event delegate
		return this.addEventDelegate(this._oInputEventDelegate);
	};

	/**
	 * Sets the DOM value of the input field and handles placeholder visibility.
	 *
	 * @param {string} sValue value of the input field.
	 * @return {sap.m.InputBase} <code>this</code> to allow method chaining.
	 * @since 1.22
	 * @protected
	 */
	InputBase.prototype.updateDomValue = function(sValue) {

		// respect to max length
		sValue = this._getInputValue(sValue);

		// update the DOM value when necessary
		// otherwise cursor can goto end of text unnecessarily
		if (this.isActive() && (this._getInputValue() !== sValue)) {
			this._$input.val(sValue);

			// dom value updated other than value property
			this._bCheckDomValue = true;
		}

		// update synthetic placeholder visibility
		this._setLabelVisibility();

		return this;
	};

	/**
	 * Close value state message.
	 *
	 * @since 1.26
	 * @protected
	 */
	InputBase.prototype.closeValueStateMessage = function (){
		if (this._popup) {
			this._popup.close();
		}
	};

	/**
	 * Get the reference element which the message popup should dock to.
	 *
	 * @return {object} DOM element which the message popup should dock to
	 * @since 1.26
	 * @protected
	 */
	InputBase.prototype.getDomRefForValueStateMessage = function(){
		return this.getFocusDomRef();
	};

	InputBase.prototype.iOpenMessagePopupDuration = 200;

	/**
	 * Open value state message popup.
	 *
	 * @since 1.26
	 * @protected
	 */
	InputBase.prototype.openValueStateMessage = function (){
		var sState = this.getValueState();
		var mValueState = sap.ui.core.ValueState;

		if (this.getShowValueStateMessage() && sState && ((sState === mValueState.Warning)
				|| (sState === mValueState.Error)) && this.getEnabled() && this.getEditable()) {

			//get value state text
			var sText = this.getValueStateText();
			if (!sText) {
				sText = sap.ui.core.ValueStateSupport.getAdditionalText(this);
			}

			if (!sText) {
				return;
			}

			//create message popup
			var sMessageId = this.getId() + "-message";
			if (!this._popup) {

				this._popup = new Popup(jQuery("<span></span>")[0] /* Just some dummy */, false, false, false);
				this._popup.attachClosed(function () {
					jQuery.sap.byId(sMessageId).remove();
				});
			}

			var $Input = jQuery(this.getFocusDomRef());
			var mDock = Popup.Dock;
			var bIsRightAligned = $Input.css("text-align") === "right";

			var sClass = "sapMInputBaseMessage sapMInputBaseMessage" + sState;
			var sTextClass = "sapMInputBaseMessageText";
			var $Content = jQuery("<div>",{
				"id": sMessageId,
				"class": sClass
			}).append(
				jQuery("<span>",{
					"id": sMessageId + "-text",
					"class": sTextClass,
					"text": sText
			}));

			this._popup.setContent($Content[0]);

			this._popup.close(0);
			var that = this;
			this._popup.open(
				this.iOpenMessagePopupDuration,
				bIsRightAligned ? mDock.EndTop : mDock.BeginTop,
				bIsRightAligned ? mDock.EndBottom : mDock.BeginBottom,
				this.getDomRefForValueStateMessage(),
				null,
				null,
				function() {
					that._popup.close();
				}
			);

			// Check whether popup is below or above the input
			if ($Input.offset().top < this._popup._$().offset().top) {
				this._popup._$().addClass("sapMInputBaseMessageBottom");
			} else {
				this._popup._$().addClass("sapMInputBaseMessageTop");
			}
		}
	};

	InputBase.prototype.updateValueStateClasses = function(sValueState, sOldValueState) {
		var mValueState = sap.ui.core.ValueState,
			$This = this.$(),
			$Input = jQuery(this.getFocusDomRef());

		if (sOldValueState !== mValueState.None) {
			$This.removeClass("sapMInputBaseState sapMInputBase" + sOldValueState);
			$Input.removeClass("sapMInputBaseStateInner sapMInputBase" + sOldValueState + "Inner");
		}

		if (sValueState !== mValueState.None) {
			$This.addClass("sapMInputBaseState sapMInputBase" + sValueState);
			$Input.addClass("sapMInputBaseStateInner sapMInputBase" + sValueState + "Inner");
		}
	};

	/* ----------------------------------------------------------- */
	/* public methods                                              */
	/* ----------------------------------------------------------- */

	/**
	 * Setter for property <code>valueState</code>.
	 *
	 * Default value is <code>None</code>.
	 *
	 * @param {sap.ui.core.ValueState} sValueState New value for property <code>valueState</code>.
	 * @return {sap.m.InputBase} <code>this</code> to allow method chaining.
	 * @public
	 */
	InputBase.prototype.setValueState = function(sValueState) {
		var sOldValueState = this.getValueState();
		sValueState = this.validateProperty("valueState", sValueState);

		if (sValueState === sOldValueState) {
			return this;
		}

		if (!this.isActive()) {
			return this.setProperty("valueState", sValueState);
		}

		this.setProperty("valueState", sValueState, true);
		this.updateValueStateClasses(sValueState, sOldValueState);

		// set tooltip based on state (will be undefined when state is None)
		var sTooltip = sap.ui.core.ValueStateSupport.enrichTooltip(this, this.getTooltip_AsString());
		this.$().attr("title", sTooltip || "");

		if (this.getFocusDomRef() === document.activeElement) {
			switch (sValueState) {
				case sap.ui.core.ValueState.Error:
				case sap.ui.core.ValueState.Warning:
					this.openValueStateMessage();
					break;
				default:
					this.closeValueStateMessage();
			}
		}

		return this;
	};

	/**
	 * Setter for property <code>valueStateText</code>.
	 *
	 * Default value is empty/<code>undefined</code>.
	 *
	 * @param {string} sValueStateText  new value for property <code>valueStateText</code>
	 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
	 * @since 1.26
	 * @public
	 */
	InputBase.prototype.setValueStateText = function (sText) {
		this.setProperty("valueStateText", sText, true);
		this.$("message-text").text( this.getValueStateText() );
		return this;
	};

	/**
	 * Setter for property <code>value</code>.
	 *
	 * Default value is empty/<code>undefined</code>.
	 *
	 * @param {string} sValue New value for property <code>value</code>.
	 * @return {sap.m.InputBase} <code>this</code> to allow method chaining.
	 * @public
	 */
	InputBase.prototype.setValue = function(sValue) {

		// validate given value
		sValue = this.validateProperty("value", sValue);

		// get the value respect to the max length
		sValue = this._getInputValue(sValue);

		// update the dom value when necessary
		this.updateDomValue(sValue);

		// check if we need to update the last value because
		// when setProperty("value") called setValue is called again via binding
		if (sValue !== this.getProperty("value")) {
			this._lastValue = sValue;
		}

		// update value property
		this.setProperty("value", sValue, true);

		return this;
	};

	InputBase.prototype.getFocusDomRef = function() {
		return this.getDomRef("inner");
	};

	InputBase.prototype.getIdForLabel = function() {
		return this.getId() + "-inner";
	};

	/**
	 * Message handling
	 * @param {string} sName The Property Name
	 * @param {array} aMessages Array of Messages
	 */
	InputBase.prototype.propagateMessages = function(sName, aMessages) {
		if (aMessages && aMessages.length > 0) {
			this.setValueState(aMessages[0].type);
			this.setValueStateText(aMessages[0].message);
		} else {
			this.setValueState(sap.ui.core.ValueState.None);
			this.setValueStateText('');
		}
	};

	InputBase.prototype.setTooltip = function(vTooltip) {
		var oDomRef = this.getDomRef(),
			oDescribedByDomRef = null,
			sAnnouncement;

		this._refreshTooltipBaseDelegate(vTooltip);
		this.setAggregation("tooltip", vTooltip, true);

		if (!oDomRef) {
			return this;
		}

		sAnnouncement = this.getRenderer().getDescribedByAnnouncement(this);

		if (sAnnouncement) {
			oDomRef.setAttribute("title", this.getTooltip_AsString());
		} else {
			oDomRef.removeAttribute("title");
		}

		oDescribedByDomRef = this.getDomRef("describedby");

		if (!oDescribedByDomRef && sAnnouncement) {
			oDescribedByDomRef = document.createElement("span");
			oDescribedByDomRef.setAttribute("id", this.getId() + "-describedby");
			oDescribedByDomRef.setAttribute("aria-hidden", "true");
			oDescribedByDomRef.setAttribute("class", "sapUiInvisibleText");
			oDomRef.appendChild(oDescribedByDomRef);
		}

		if (oDescribedByDomRef && !sAnnouncement) {
			oDomRef.removeChild(oDescribedByDomRef);
		}

		if (oDescribedByDomRef) {
			oDescribedByDomRef.textContent = sAnnouncement;
		}

		return this;
	};

	return InputBase;

}, /* bExport= */ true);
}; // end of sap/m/InputBase.js
if ( !jQuery.sap.isDeclared('sap.m.InputListItemRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.InputListItemRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/InputListItemRenderer",['jquery.sap.global', './ListItemBaseRenderer', 'sap/ui/core/Renderer'],
	function(jQuery, ListItemBaseRenderer, Renderer) {
	"use strict";


	/**
	 * InputListItem renderer.
	 * @namespace
	 */
	var InputListItemRenderer = Renderer.extend(ListItemBaseRenderer);
	
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *          oRenderManager the RenderManager that can be used for writing to the
	 *          Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *          oControl an object representation of the control that should be
	 *          rendered
	 */
	InputListItemRenderer.renderLIAttributes = function(rm, oLI) {
		rm.addClass("sapMILI");
	};
	
	InputListItemRenderer.renderLIContent = function(rm, oLI) {
	
		var sLabel = oLI.getLabel();
	
		// List item label
		if (sLabel) {
			rm.write("<label for='" + oLI.getId() + "-content' class='sapMILILabel'>");
			rm.writeEscaped(oLI.getLabel());
			rm.write("</label>");
		}
	
		// List item input content
		rm.write("<div class='sapMILIDiv sapMILI-CTX'>");
	
		var aContent = oLI.getContent();
		var cLength = aContent.length;
		for ( var i = 0; i < cLength; i++) {
			rm.renderControl(aContent[i]);
		}
		rm.write("</div>");
	};
	

	return InputListItemRenderer;

}, /* bExport= */ true);

}; // end of sap/m/InputListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.Label') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.Label.
jQuery.sap.declare('sap.m.Label'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.LabelEnablement'); // unlisted dependency retained
sap.ui.define("sap/m/Label",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/LabelEnablement'],
	function(jQuery, library, Control, LabelEnablement) {
	"use strict";



	/**
	 * Constructor for a new Label.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Label control is used in a UI5 mobile application to provide label text for other controls. Design such as bold, and text alignment can be specified.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.core.Label,sap.ui.core.IShrinkable
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.Label
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Label = Control.extend("sap.m.Label", /** @lends sap.m.Label.prototype */ { metadata : {

		interfaces : [
			"sap.ui.core.Label",
			"sap.ui.core.IShrinkable"
		],
		library : "sap.m",
		properties : {

			/**
			 * set design of a label to either Standard or Bold
			 */
			design : {type : "sap.m.LabelDesign", group : "Appearance", defaultValue : sap.m.LabelDesign.Standard},

			/**
			 * Label Text to be displayed
			 */
			text : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Available alignment settings are "Begin", "Center", "End", "Left", and "Right".
			 */
			textAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},

			/**
			 * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction from its parent container.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},

			/**
			 * Width of Label
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},

			/**
			 * Indicates that user input is required in the input this label labels.
			 */
			required : {type : "boolean", group : "Misc", defaultValue : false}
		},
		associations : {

			/**
			 * Association to the labeled control.
			 * By default the label set the for attribute to the ID of the labeled control. This can be changed implementing function getIdForLabel on the labelled control.
			 */
			labelFor : {type : "sap.ui.core.Control", multiple : false}
		}
	}});
	

	Label.prototype.setText = function(sText) {
		var sValue = this.getText();
		if (sValue !== sText) {
			this.setProperty("text", sText, true);
			this.$().html(jQuery.sap.encodeHTML(this.getProperty("text")));
			if (sText) {
				this.$().removeClass("sapMLabelNoText");
			}else {
				this.$().addClass("sapMLabelNoText");
			}
		}
		return this;
	};

	Label.prototype.setTooltip = function(oTooltip) {
		var oValue = this.getTooltip();
		if (oValue !== oTooltip) {
			this.setAggregation("tooltip", oTooltip, true);
			this.$().attr("title", this.getTooltip());
		}
		return this;
	};
	
	//Enrich Label functionality
	LabelEnablement.enrich(Label.prototype);

	return Label;

}, /* bExport= */ true);

}; // end of sap/m/Label.js
if ( !jQuery.sap.isDeclared('sap.m.Link') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.Link.
jQuery.sap.declare('sap.m.Link'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained
sap.ui.define("sap/m/Link",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/EnabledPropagator'],
	function(jQuery, library, Control, EnabledPropagator) {
	"use strict";



	/**
	 * Constructor for a new Link.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A hyperlink control which can be used to trigger actions or to navigate to other applications or web pages.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.core.IShrinkable
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.12
	 * @alias sap.m.Link
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Link = Control.extend("sap.m.Link", /** @lends sap.m.Link.prototype */ { metadata : {

		interfaces : [
			"sap.ui.core.IShrinkable"
		],
		library : "sap.m",
		properties : {

			/**
			 * Link text to be displayed.
			 */
			text : {type : "string", group : "Data", defaultValue : ''},

			/**
			 * Whether the link can be triggered by the user.
			 */
			enabled : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Options are the standard values for window.open() supported by browsers: _self, _top, _blank, _parent, _search. Alternatively, a frame name can be entered. This property is only used for href URLs.
			 */
			target : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * Width of the link. When it is set (CSS-size such as % or px), this is the exact size. When left blank, the text defines the size.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * The link target URI. Supports standard hyperlink behavior. If a JavaScript action should be triggered, this should not be set, but instead an event handler for the "press" event should be registered.
			 */
			href : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},

			/**
			 * Whether the link text is allowed to wrap when there is not sufficient space.
			 */
			wrapping : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Sets the horizontal alignment of the text.
			 * @since 1.28.0
			 */
			textAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Initial},

			/**
			 * This property specifies the element's text directionality with enumerated options. By default, the control inherits text direction from the parent DOM.
			 * @since 1.28.0
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},

			/**
			 * Subtle links look more like standard text than like links. They should only be used to help with visual hierarchy between large data lists of important and less important links. Subtle links should not be used in any other usecase.
			 * @since 1.22
			 */
			subtle : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Set this property to true if the link should appear emphasized.
			 * @since 1.22
			 */
			emphasized : {type : "boolean", group : "Behavior", defaultValue : false}
		},
		associations : {

			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy: {type: "sap.ui.core.Control", multiple: true, singularName: "ariaDescribedBy"},

			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy: {type: "sap.ui.core.Control", multiple: true, singularName: "ariaLabelledBy"}
		},
		events : {

			/**
			 * Event is fired when the user triggers the link control.
			 */
			press : {allowPreventDefault : true}
		}
	}});



	EnabledPropagator.call(Link.prototype); // inherit "disabled" state from parent controls

	/**
	 * Also trigger link activation when space is pressed on the focused control
	 */
	Link.prototype.onsapspace = function(oEvent) {
		this._handlePress(oEvent); // this calls any JS event handlers
		// _handlePress() checks the return value of the event handler and prevents default if required or of the Link is disabled
		if (this.getHref() && !oEvent.isDefaultPrevented()) {
			// Normal browser link, the browser does the job. According to the keyboard spec, Space should do the same as Enter/Click.
			// To make the browser REALLY do the same (history, referrer, frames, target,...), create a new "click" event and let the browser "do the needful".

			// first disarm the Space key event
			oEvent.preventDefault(); // prevent any scrolling which the browser might do because from its perspective the Link does not handle the "space" key
			oEvent.setMarked();

			// then create the click event
			var oClickEvent = document.createEvent('MouseEvents');
			oClickEvent.initEvent('click' /* event type */, false, true); // non-bubbling, cancelable
			this.getDomRef().dispatchEvent(oClickEvent);
		}
	};


	/**
	 * Function is called when Link is triggered.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Link.prototype._handlePress = function(oEvent) {
		if (this.getEnabled()) {
			// mark the event for components that needs to know if the event was handled by the link
			oEvent.setMarked();
			
			if (!this.firePress() || !this.getHref()) { // fire event and check return value whether default action should be prevented
				oEvent.preventDefault();
			}
		} else { // disabled
			oEvent.preventDefault(); // even prevent URLs from being triggered
		}
	};

	if (sap.ui.Device.support.touch) {
		Link.prototype.ontap = Link.prototype._handlePress;
	} else {
		Link.prototype.onclick = Link.prototype._handlePress;
	}


	Link.prototype.ontouchstart = function(oEvent) {
		if (this.getEnabled()) {
			// for controls which need to know whether they should handle events bubbling from here
			oEvent.setMarked();
		}
	};


	/* override standard setters with direct DOM manipulation */

	Link.prototype.setText = function(sText){
		this.setProperty("text", sText, true);
		sText = this.getProperty("text");
		this.$().text(sText);
		return this;
	};

	Link.prototype.setHref = function(sUri){
		this.setProperty("href", sUri, true);
		if (this.getEnabled()) {
			sUri = this.getProperty("href");
			this.$().attr("href", sUri);
		}
		return this;
	};

	Link.prototype.setSubtle = function(bSubtle){
		this.setProperty("subtle", bSubtle, true);

		var $this = this.$();
		if ($this.length) { // only when actually rendered
			$this.toggleClass("sapMLnkSubtle", bSubtle);
			if (bSubtle) {
				if (!jQuery.sap.domById(this.getId() + "-linkSubtle")) {
					$this.append("<label id='" + this.getId() + "-linkSubtle" + "' class='sapUiHidden'>" + this._getLinkDescription("LINK_SUBTLE") + "</label>");
				}
			} else {
				jQuery.sap.byId(this.getId() + "-linkSubtle").remove();
			}
		}
		return this;
	};

	Link.prototype.setEmphasized = function(bEmphasized){
		this.setProperty("emphasized", bEmphasized, true);

		var $this = this.$();
		if ($this.length) { // only when actually rendered
			$this.toggleClass("sapMLnkEmphasized", bEmphasized);
			if (bEmphasized) { // strictly spoken this should only be done when accessibility mode is true. But it is true by default, so not sure it is worth checking...
				if (!jQuery.sap.domById(this.getId() + "-linkEmphasized")) {
					$this.append("<label id='" + this.getId() + "-linkEmphasized" + "' class='sapUiHidden'>" + this._getLinkDescription("LINK_EMPHASIZED") + "</label>");
				}
			} else {
				jQuery.sap.byId(this.getId() + "-linkEmphasized").remove();
			}
		}
		return this;
	};

	Link.prototype.setWrapping = function(bWrapping){
		this.setProperty("wrapping", bWrapping, true);
		this.$().toggleClass("sapMLnkWrapping", bWrapping);
		return this;
	};

	Link.prototype.setEnabled = function(bEnabled){
		if (bEnabled !== this.getProperty("enabled")) { // do nothing when the same value is set again (virtual table scrolling!) - don't use this.getEnabled() because of EnabledPropagator
			this.setProperty("enabled", bEnabled, true);
			var $this = this.$();
			$this.toggleClass("sapMLnkDsbl", !bEnabled);
			if (bEnabled) {
				$this.attr("disabled", false);
				$this.attr("tabindex", "0");
				$this.removeAttr("aria-disabled");
				if (this.getHref()) {
					$this.attr("href", this.getHref());
				}
			} else {
				$this.attr("disabled", true);
				$this.attr("tabindex", "-1");
				$this.attr("aria-disabled", true);
				/*eslint-disable no-script-url */
				$this.attr("href", "javascript:void(0);");
				/*eslint-disable no-script-url */
			}
		}
		return this;
	};

	Link.prototype.setWidth = function(sWidth){
		this.setProperty("width", sWidth, true);
		this.$().toggleClass("sapMLnkMaxWidth", !sWidth);
		this.$().css("width", sWidth);
		return this;
	};

	Link.prototype.setTarget = function(sTarget){
		this.setProperty("target", sTarget, true);
		if (!sTarget) {
			this.$().removeAttr("target");
		} else {
			this.$().attr("target", sTarget);
		}
		return this;
	};

	/**
	 * Function that translates the resource text.
	 *
	 * @param {String} sKey the resource to be translated
	 * @private
	 * @returns {String} the translated text
	 */
	Link.prototype._getLinkDescription = function(sKey) {
		var oRb = sap.ui.getCore().getLibraryResourceBundle("sap.m");
		var sText = oRb.getText(sKey);
		return sText;
	};

	return Link;

}, /* bExport= */ true);

}; // end of sap/m/Link.js
if ( !jQuery.sap.isDeclared('sap.m.ListItemBase') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.ListItemBase.
jQuery.sap.declare('sap.m.ListItemBase'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/m/ListItemBase",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";


	
	/**
	 * Constructor for a new ListItemBase.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * ListItemBase contains the core features of all specific list items.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.ListItemBase
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ListItemBase = Control.extend("sap.m.ListItemBase", /** @lends sap.m.ListItemBase.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {
	
			/**
			 * Type of the list item, defines the behaviour
			 */
			type : {type : "sap.m.ListType", group : "Misc", defaultValue : sap.m.ListType.Inactive},
	
			/**
			 * Invisible list items are not rendered
			 */
			visible : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * If the unread indicator is set on the list, this boolean defines if it will be shown on this list item. Default is false.
			 */
			unread : {type : "boolean", group : "Misc", defaultValue : false},
	
			/**
			 * This property defines the select state of the list item when using Single/Multi-Selection.
			 * 
			 * Note: Binding the "selected" property in single selection mode, may cause unwanted results, if you have more than one selected item in your binding
			 */
			selected : {type : "boolean", defaultValue : false},
	
			/**
			 * Property sets a counter bubble with the integer given.
			 */
			counter : {type : "int", group : "Misc", defaultValue : null}
		},
		associations: {

			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 * @since 1.28.0
			 */
			ariaLabelledBy: { type: "sap.ui.core.Control", multiple: true, singularName: "ariaLabelledBy" }
		},
		events : {
	
			/**
			 * Event is fired when the user taps on the control.
			 * @deprecated Since version 1.20.0. 
			 * This event is deprecated, use the press event instead.
			 */
			tap : {deprecated: true}, 
	
			/**
			 * Event is fired when the user taps on the detail button of the control.
			 * @deprecated Since version 1.20.0. 
			 * This event is deprecated, use the detailPress event instead.
			 */
			detailTap : {deprecated: true}, 
	
			/**
			 * Event is fired when the user clicks on the control.
			 * 
			 * Note: When the parent mode is SingleSelectMaster or includeItemInSelection is true then this event is not fired but the parent fires a selectionChange event instead.
			 * Also if there is an interactive element that handles the press event then the list item's press is not fired.
			 * 
			 * If mode detection is not necessary for the press event then the itemPress event of the parent can be used. 
			 * {@link sap.m.ListBase#attachItemPress}
			 */
			press : {}, 
	
			/**
			 * Event is fired when the user clicks on the detail button of the control.
			 */
			detailPress : {}
		}
	}});
	
	// internal active state of the listitem
	ListItemBase.prototype.init = function() {
		this._active = false;
	};
	
	ListItemBase.prototype.onAfterRendering = function() {
		this.informList("DOMUpdate", true);
	};
	
	/*
	 * Returns the binding context path via checking the named model of parent
	 *
	 * @protected
	 * @since 1.16.3
	 */
	ListItemBase.prototype.getBindingContextPath = function(sModelName) {
		var oList = this.getList();
		if (oList && !sModelName) {
			sModelName = (oList.getBindingInfo("items") || {}).model;
		}
	
		var oContext = this.getBindingContext(sModelName);
		if (oContext) {
			return oContext.getPath();
		}
	};
	
	/*
	 * Returns the responsible list control
	 * 
	 * @returns {sap.m.ListBase|undefined} 
	 * @protected
	 */
	ListItemBase.prototype.getList = function(fnCallback) {
		var oParent = this.getParent();
		if (oParent instanceof sap.m.ListBase) {
			return oParent;
		}
	};
	
	/*
	 * Returns the property of the responsible list container according to given parameter. 
	 * 
	 * @param {string} sProperty property name
	 * @param {*} [vFallbackValue] fallback value when list is not found
	 * @return {*}
	 * @protected
	 */
	ListItemBase.prototype.getListProperty = function(sProperty, vFallbackValue) {
		var oList = this.getList();
		if (oList) {
			sProperty = jQuery.sap.charToUpperCase(sProperty);
			return oList["get" + sProperty]();
		}

		return vFallbackValue;
	};
	
	/*
	 * Informs the responsible list for item events
	 * 
	 * @param {string} sEvent the name of the event
	 * @param {*} [vParam1] first additional parameter
	 * @param {*} [vParam2] second additional parameter
	 * @protected
	 */
	ListItemBase.prototype.informList = function(sEvent, vParam1, vParam2) {
		var oList = this.getList();
		if (oList) {
			var sMethod = "onItem" + sEvent;
			if (oList[sMethod]) {
				oList[sMethod](this, vParam1, vParam2);
			}
		}
	};
	
	/*
	 * Returns the mode of the current item according to list mode
	 * Subclasses can overwrite this if item should not have any mode
	 * Default empty mode is used when list mode is not yet known
	 * 
	 * @returns {sap.m.ListMode|""}
	 * @protected
	 */
	ListItemBase.prototype.getMode = function() {
		return this.getListProperty("mode", "");
	};
	
	/*
	 * Updates the accessibility state of the control.
	 * 
	 * @param {Object} [mAccessibility] a map of accessibility properties
	 * @protected
	 */
	ListItemBase.prototype.updateAccessibilityState = function(mAccessibility) {
		var $This = this.$();
		if (!$This.length) {
			return;
		}
		
		var $Items = $This.parent().find(".sapMLIB");
		$This.attr(jQuery.extend({
			"aria-setsize": $Items.length,
			"aria-posinset": $Items.index($This) + 1
		}, mAccessibility));
	};
	
	/**
	 * Returns the delete icon when mode is Delete
	 * 
	 * @return {sap.ui.core.Icon}
	 * @private
	 */
	ListItemBase.prototype.getDeleteControl = function() {
		if (this._oDeleteControl) {
			return this._oDeleteControl;
		}

		this._oDeleteControl = new sap.ui.core.Icon({
			id : this.getId() + "-imgDel",
			src : sap.ui.core.IconPool.getIconURI("sys-cancel")
		}).setParent(this, null, true).addStyleClass("sapMLIBIconDel").attachPress(function(oEvent) {
			this.informList("Delete");
		}, this);
		
		return this._oDeleteControl;
	};
	
	/**
	 * Returns the detail icon when item type is Detail|DetailAndActive
	 * 
	 * @return {sap.ui.core.Icon}
	 * @private
	 */
	ListItemBase.prototype.getDetailControl = function() {
		if (this._oDetailControl) {
			return this._oDetailControl;
		}

		this._oDetailControl = new sap.ui.core.Icon({
			id : this.getId() + "-imgDet",
			src : sap.ui.core.IconPool.getIconURI("edit")
		}).setParent(this, null, true).addStyleClass("sapMLIBType sapMLIBIconDet").attachPress(function() {
			this.fireDetailTap();
			this.fireDetailPress();
		}, this);
		
		return this._oDetailControl;
	};
	
	/**
	 * Returns the navigation icon when item type is Navigation
	 * 
	 * @return {sap.ui.core.Icon}
	 * @private
	 */
	ListItemBase.prototype.getNavigationControl = function() {
		if (this._oNavigationControl) {
			return this._oNavigationControl;
		}

		this._oNavigationControl = new sap.ui.core.Icon({
			id : this.getId() + "-imgNav",
			src : sap.ui.core.IconPool.getIconURI("slim-arrow-right")
		}).setParent(this, null, true).addStyleClass("sapMLIBType sapMLIBImgNav");
		
		return this._oNavigationControl;
	};
	
	/**
	 * Returns RadioButton control when mode is one of Single Selection type
	 * 
	 * @return {sap.m.RadioButton}
	 * @private
	 */
	ListItemBase.prototype.getSingleSelectControl = function() {
		if (this._oSingleSelectControl) {
			this._oSingleSelectControl.setSelected(this.getSelected());
			return this._oSingleSelectControl;
		}

		this._oSingleSelectControl = new sap.m.RadioButton({
			id : this.getId() + "-selectSingle",
			groupName : this.getListProperty("id") + "_selectGroup",
			activeHandling : false,
			selected : this.getSelected()
		}).setParent(this, null, true).setTabIndex(-1).attachSelect(function(oEvent) {
			var bSelected = oEvent.getParameter("selected");
			this.setSelected(bSelected);
			this.informList("Select", bSelected);
		}, this);
		
		return this._oSingleSelectControl;
	};
	
	/**
	 * Returns CheckBox control when mode is MultiSelection
	 * 
	 * @return {sap.m.CheckBox}
	 * @private
	 */
	ListItemBase.prototype.getMultiSelectControl = function() {
		if (this._oMultiSelectControl) {
			this._oMultiSelectControl.setSelected(this.getSelected());
			return this._oMultiSelectControl;
		}

		this._oMultiSelectControl = new sap.m.CheckBox({
			id : this.getId() + "-selectMulti",
			activeHandling : false,
			selected : this.getSelected()
		}).setParent(this, null, true).setTabIndex(-1).attachSelect(function(oEvent) {
			var bSelected = oEvent.getParameter("selected");
			this.setSelected(bSelected);
			this.informList("Select", bSelected);
		}, this);
		
		return this._oMultiSelectControl;
	};
	
	/**
	 * Returns responsible control depends on the mode
	 * 
	 * @returns {sap.ui.core.Control}
	 * @private
	 */
	ListItemBase.prototype.getModeControl = function() {
		var sMode = this.getMode(),
			mListMode = sap.m.ListMode;
			
		if (!sMode || sMode == mListMode.None) {
			return;
		}

		if (sMode == mListMode.Delete) {
			return this.getDeleteControl();
		}
		
		if (sMode == mListMode.MultiSelect) {
			return this.getMultiSelectControl();
		}
		
		return this.getSingleSelectControl();
	};

	/**
	 * Returns item type icon 
	 * 
	 * @returns {sap.ui.core.Icon}
	 * @private
	 */
	ListItemBase.prototype.getTypeControl = function() {
		var sType = this.getType(),
			mType = sap.m.ListType;

		if (sType == mType.Detail || sType == mType.DetailAndActive) {
			return this.getDetailControl();
		}
		
		if (sType == mType.Navigation) {
			return this.getNavigationControl();
		}
	};
	
	/**
	 * Destroys generated mode/type controls
	 * 
	 * @param {String[]} aControls array of control names
	 * @private
	 */
	ListItemBase.prototype.destroyControls = function(aControls) {
		aControls.forEach(function(sControl) {
			sControl = "_o" + sControl + "Control";
			if (this[sControl]) {
				this[sControl].destroy();
				this[sControl] = null;
			}
		}, this);
	};
	
	/**
	 * Determines whether item should be clickable or not
	 * @private
	 */
	ListItemBase.prototype.isClickable = function() {
		return	this.getListProperty("includeItemInSelection") ||
				this.getMode() == sap.m.ListMode.SingleSelectMaster || (
					this.getType() != sap.m.ListType.Inactive &&
					this.getType() != sap.m.ListType.Detail
				);
	};
	
	
	ListItemBase.prototype.exit = function() {
		this._oLastFocused = null;
		this.destroyControls([
			"Delete", 
			"SingleSelect", 
			"MultiSelect", 
			"Detail", 
			"Navigation"
		]);
	};
	
	/**
	 * Determines whether item is selectable or not.
	 * By default, when item should be in selectable mode
	 * 
	 * Subclasses can overwrite in case of unselectable item.
	 * @returns {Boolean}
	 * @private
	 */
	ListItemBase.prototype.isSelectable = function() {
		var sMode = this.getMode();
		return !(sMode == sap.m.ListMode.None || sMode == sap.m.ListMode.Delete);
	};
	
	ListItemBase.prototype.getSelected = function() {
		if (this.isSelectable()) {
			return this.getProperty("selected");
		}
		return false;
	};

	/**
	 * Returns the state of the item selection as a boolean
	 *
	 * @public
	 * @return boolean
	 * @deprecated Since version 1.10.2. 
	 * API Change makes this method unnecessary. Use getSelected method instead.
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ListItemBase.prototype.isSelected = ListItemBase.prototype.getSelected;
	
	ListItemBase.prototype.setSelected = function(bSelected, bDontNotifyParent) {
		// do not handle when item is not selectable or in same status
		bSelected = this.validateProperty("selected", bSelected);
		if (!this.isSelectable() || bSelected == this.getSelected()) {
			return this;
		}
	
		// notify parent about the selection first
		if (!bDontNotifyParent) {
			this.informList("SelectedChange", bSelected);
		}
	
		// update the selection control status
		var oSelectionControl = this.getModeControl();
		if (oSelectionControl) {
			oSelectionControl.setSelected(bSelected);
		}

		// run the hook to update dom state 
		this.updateSelectedDOM(bSelected, this.$());
	
		// set the property and do not invalidate
		this.setProperty("selected", bSelected, true);
		
		return this;
	};
	
	// Updates the selected state of the DOM
	ListItemBase.prototype.updateSelectedDOM = function(bSelected, $LI) {
		$LI.toggleClass("sapMLIBSelected", bSelected);
		$LI.attr("aria-selected", bSelected);
	};
	
	/**
	 * Determines whether item is in SingleSelectMaster mode or 
	 * other selection modes when includeItemInSelection is true
	 * 
	 * @return {Boolean}
	 */
	ListItemBase.prototype.isIncludedIntoSelection = function() {
		var sMode = this.getMode(),
			mMode = sap.m.ListMode;
		
		return (sMode == mMode.SingleSelectMaster || (
				 this.getListProperty("includeItemInSelection") && (
					sMode == mMode.SingleSelectLeft ||
					sMode == mMode.SingleSelect ||  
					sMode == mMode.MultiSelect)
				));
	};
	
	/**
	 * Determines whether item needs icon to render type or not
	 * 
	 * @return {Boolean}
	 */
	ListItemBase.prototype.hasActiveType = function() {
		var mType = sap.m.ListType,
			sType = this.getType();
		
		return (sType == mType.Active || 
				sType == mType.Navigation || 
				sType == mType.DetailAndActive);
	};
	
	ListItemBase.prototype.setActive = function(bActive) {
		if (bActive != this._active) {
			this._active = bActive;
			this._activeHandling();
	
			if (this.getType() == sap.m.ListType.Navigation) {
				this._activeHandlingNav();
			}
	
			if (bActive) {
				this._activeHandlingInheritor();
			} else {
				this._inactiveHandlingInheritor();
			}
		}
	
		return this;
	};
	
	ListItemBase.prototype.setUnread = function(bUnread) {
		this.setProperty("unread", bUnread, true);
		this.$().toggleClass("sapMLIBUnread", bUnread);
		return this;
	};
	
	ListItemBase.prototype.ontap = function(oEvent) {
		
		// do not handle already handled events
		if (this._eventHandledByControl) {
			return;
		}
	
		// if includeItemInSelection all tap events will be used for the mode select and delete
		// SingleSelectMaster always behaves like includeItemInSelection is set
		if (this.isIncludedIntoSelection()) {
			
			// update selected property
			if (this.getMode() == sap.m.ListMode.MultiSelect) {
				this.setSelected(!this.getSelected());
				this.informList("Select", this.getSelected());
			} else if (!this.getSelected()) {
				this.setSelected(true);
				this.informList("Select", true);
			}
		} else if (this.hasActiveType()) {
	
			// if a fast tap happens deactivate the touchstart/touchend timers and their logic
			window.clearTimeout(this._timeoutIdStart);
			window.clearTimeout(this._timeoutIdEnd);
			
			// active feedback
			this.setActive(true);
			
			jQuery.sap.delayedCall(180, this, function() {
				this.setActive(false);
			});

			jQuery.sap.delayedCall(0, this, function() {
				this.fireTap();
				this.firePress();
			});
		}
	
		// tell the parent, item is pressed
		this.informList("Press", oEvent.srcControl);
	};
	
	ListItemBase.prototype.ontouchstart = function(oEvent) {
		this._eventHandledByControl = oEvent.isMarked();
		
		var oTargetTouch = oEvent.targetTouches[0];
		this._touchedY = oTargetTouch.clientY;
		this._touchedX = oTargetTouch.clientX;
		
		// active handling if not handled already by control
		// several fingers could be used 
		if (this._eventHandledByControl || 
			oEvent.touches.length != 1 || 
			!this.hasActiveType()) {
			return;
		}
	
		// timeout regarding active state when scrolling
		this._timeoutIdStart = jQuery.sap.delayedCall(100, this, function() {
			this.setActive(true);
			oEvent.setMarked();
		});
	};
	
	// handle touchmove to prevent active state when scrolling
	ListItemBase.prototype.ontouchmove = function(oEvent) {
		
		if ((this._active || this._timeoutIdStart) && 
			(Math.abs(this._touchedY - oEvent.targetTouches[0].clientY) > 10 || Math.abs(this._touchedX - oEvent.targetTouches[0].clientX) > 10)) {
	
			// there is movement and therefore no tap...remove active styles
			clearTimeout(this._timeoutIdStart);
			this._timeoutIdStart = null;
			this._timeoutIdEnd = null;
			this.setActive(false);
		}
	};
	
	ListItemBase.prototype.ontouchend = function(oEvent) {
	
		// several fingers could be used
		if (oEvent.targetTouches.length == 0 && this.hasActiveType()) {
			this._timeoutIdEnd = jQuery.sap.delayedCall(100, this, function() {
				this.setActive(false);
			});
		}
	};
	
	// During native scrolling: Chrome sends touchcancel and no touchend thereafter
	ListItemBase.prototype.ontouchcancel = ListItemBase.prototype.ontouchend;
	
	// toggle active styles for navigation items
	ListItemBase.prototype._activeHandlingNav = function() {};
	
	// hook method for active handling...inheritors should overwrite this method
	ListItemBase.prototype._activeHandlingInheritor = function() {};
	
	// hook method for inactive handling...inheritors should overwrite this method
	ListItemBase.prototype._inactiveHandlingInheritor = function() {};
	
	// switch background style... toggle active feedback
	ListItemBase.prototype._activeHandling = function() {
		this.$().toggleClass("sapMLIBActive", this._active);
	};
	
	/* Keyboard Handling */
	ListItemBase.prototype.onsapspace = function(oEvent) {
		
		// handle only the events that are coming from ListItemBase
		if (oEvent.srcControl !== this) {
			return;
		}
		
		// prevent default not to scroll down
		oEvent.preventDefault();
		
		// allow only for selectable items
		if (oEvent.isMarked() || !this.isSelectable()) {
			return;
		}
		
		// update selected property
		if (this.getMode() == sap.m.ListMode.MultiSelect) {
			this.setSelected(!this.getSelected());
			this.informList("Select", this.getSelected());
		} else if (!this.getSelected()) {
			this.setSelected(true);
			this.informList("Select", true);
		}
	
		// event is handled
		oEvent.setMarked();
	};
	
	ListItemBase.prototype.onsapenter = function(oEvent) {
		if (oEvent.isMarked() ||
			oEvent.srcControl !== this) {
			return;
		}
		
		if (this.isIncludedIntoSelection()) {
			
			// support old bug and mimic space key handling and 
			// do not fire item's press event when item is included into selection
			this.onsapspace(oEvent);
			
		} else if (this.hasActiveType()) {
			
			// active feedback
			oEvent.setMarked();
			this.setActive(true);
			
			jQuery.sap.delayedCall(180, this, function() {
				this.setActive(false);
			});

			// fire own press event
			jQuery.sap.delayedCall(0, this, function() {
				this.fireTap();
				this.firePress();
			});
		}
		
		// let the parent know item is pressed
		this.informList("Press", this);
	};
	
	ListItemBase.prototype.onsapdelete = function(oEvent) {
		if (oEvent.isMarked() ||
			oEvent.srcControl !== this ||
			this.getMode() != sap.m.ListMode.Delete) {
			return;
		}
	
		this.informList("Delete");
		oEvent.preventDefault();
		oEvent.setMarked();
	};
	
	ListItemBase.prototype._switchFocus = function(oEvent) {
		var oParent = this.getParent();
		var $Tabbables = this.getTabbables();
		
		if (oEvent.srcControl !== this) {
			oParent._iLastFocusPosOfItem = $Tabbables.index(oEvent.target);
			this.focus();
		} else if ($Tabbables.length) {
			var iFocusPos = oParent._iLastFocusPosOfItem || 0;
			iFocusPos = $Tabbables[iFocusPos] ? iFocusPos : -1;
			$Tabbables.eq(iFocusPos).focus();
		}
	};
	
	ListItemBase.prototype.onkeydown = function(oEvent) {
		// check whether event is marked or not
		var mKeyCodes = jQuery.sap.KeyCodes;
		if (oEvent.isMarked()) {
			return;
		}
	
		// switch focus to row and focused item with F7
		if (oEvent.which == mKeyCodes.F7) {
			this._switchFocus(oEvent);
			oEvent.preventDefault();
			oEvent.setMarked();
			return;
		}
	
		// handle only the events that are coming from ListItem
		if (oEvent.srcControl !== this) {
			return;
		}
		
		// F2 should fire detail event
		if (oEvent.which == mKeyCodes.F2 && this.getType().indexOf("Detail") == 0) {
			this.fireDetailTap();
			this.fireDetailPress();
			oEvent.preventDefault();
			oEvent.setMarked();
		}
	};
	
	/**
	 * Returns the tabbable DOM elements as a jQuery collection
	 *
	 * @returns {jQuery} jQuery object
	 * @protected
	 * @since 1.26
	 */
	ListItemBase.prototype.getTabbables = function() {
		return this.$().find(":sapTabbable");
	};
	
	// handle the TAB key
	ListItemBase.prototype.onsaptabnext = function(oEvent) {
		// check whether event is marked or not
		var oList = this.getList();
		if (!oList || oEvent.isMarked()) {
			return;
		}
	
		// if tab key is pressed while the last tabbable element of the list item
		// has been focused, we forward tab to the last pseudo element of the table
		var oLastTabbableDomRef = this.getTabbables().get(-1) || this.getDomRef();
		if (oEvent.target === oLastTabbableDomRef) {
			oList.forwardTab(true);
			oEvent.setMarked();
		}
	};
	
	// handle the SHIFT-TAB key
	ListItemBase.prototype.onsaptabprevious = function(oEvent) {
		var oList = this.getList();
		if (!oList || oEvent.isMarked()) {
			return;
		}
	
		// if shift-tab is pressed while the list item has been focused,
		// we forward tab to the root element of the list
		if (oEvent.target === this.getDomRef()) {
			oList.forwardTab(false);
			oEvent.setMarked();
		}
	};
	
	// handle propagated focus to make the item row focusable
	ListItemBase.prototype.onfocusin = function(oEvent) {
		var oList = this.getList();
		if (!oList ||
			oEvent.isMarked() ||
			oEvent.srcControl === this ||
			!jQuery(oEvent.target).is(":sapFocusable")) {
			return;
		}
	
		// inform the list async that this item should be focusable
		jQuery.sap.delayedCall(0, oList, "setItemFocusable", [this]);
		oEvent.setMarked();
	};

	return ListItemBase;

}, /* bExport= */ true);

}; // end of sap/m/ListItemBase.js
if ( !jQuery.sap.isDeclared('sap.m.MessagePage') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.MessagePage.
jQuery.sap.declare('sap.m.MessagePage'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/MessagePage",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/IconPool'],
	function(jQuery, library, Control, IconPool) {
		"use strict";

		/**
		 * Constructor for a new MessagePage.
		 *
		 * @param {string} [sId] id for the new control, generated automatically if no id is given
		 * @param {object} [mSettings] initial settings for the new control
		 *
		 * @class
		 * MessagePage is displayed when there is no data or matching content. There are different use cases where a MessagePage might be visualized, for example:
		 *		- The search query returned no results
		 *		- The app contains no items
		 *		- There are too many items
		 *		- The application is loading
		 *	The layout is unchanged but the text varies depending on the use case.
		 * @extends sap.ui.core.Control
		 * @version 1.28.17
		 *
		 * @constructor
		 * @public
		 * @since 1.28
		 * @alias sap.m.MessagePage
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var MessagePage = Control.extend("sap.m.MessagePage", /** @lends sap.m.MessagePage.prototype */ { metadata : {

			library : "sap.m",
			properties : {
				/**
				 * MessagePage text
				 */
				text : {type : "string", group : "Misc", defaultValue : "No matching items found."},
				/**
				 * MessagePage description
				 */
				description : {type : "string", group : "Misc", defaultValue : "Check the filter settings."},
				/**
				 * MessagePage title
				 */
				title : { type : "string", group : "Misc", defaultValue : null },
				/**
				 * Determines whether the header of the MessagePage is rendered when it's embedded in another page.
				 */
				showHeader : { type : "boolean", group : "Appearance", defaultValue : true },
				/**
				 * A nav button will be rendered in the header if this property is set to true.
				 */
				showNavButton : {type : "boolean", group : "Appearance", defaultValue : false},
				/**
				 * MessagePage main icon
				 */
				icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : "sap-icon://documents" },
				/**
				 * This property specifies the element's text directionality with enumerated options. By default, the control inherits text direction from the DOM.
				 */
				textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit}
			},
			aggregations : {
				/**
				 * The (optional) custom Text control of this page.
				 * Use this aggregation when the "text" (sap.m.Text) control needs to be replaced with a sap.m.Link control.
				 * "text" and "textDirection" setters can be used for this aggregation.
				 */
				customText : {type : "sap.m.Link", multiple : false},
				/**
				 * The (optional) custom description control of this page.
				 * Use this aggregation when the "description" (sap.m.Text) control needs to be replaced with a sap.m.Link control.
				 * "description" and "textDirection" setters can be used for this aggregation.
				 */
				customDescription : {type : "sap.m.Link", multiple : false},
				/**
				 * A Page control which is managed internally by the MessagePage control
				 */
				_page : {type : "sap.m.Page", multiple : false, visibility : "hidden"}
			},
			associations : {

				/**
				 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
				 */
				ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"},

				/**
				 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
				 */
				ariaLabelledBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaLabelledBy"}
			},
			events : {
				/**
				 * this event is fired when Nav Button is pressed
				 * @since 1.28.1
				 */
				navButtonPress : {}
			}
		}});

		MessagePage.prototype.init = function() {
			var oBundle = sap.ui.getCore().getLibraryResourceBundle("sap.m");

			this.setAggregation("_page", new sap.m.Page({
				showHeader : this.getShowHeader(),
				navButtonPress : jQuery.proxy(function() {
					this.fireNavButtonPress();
				}, this)
			}));
			this.setProperty("text", oBundle.getText("MESSAGE_PAGE_TEXT"), true);
			this.setProperty("description", oBundle.getText("MESSAGE_PAGE_DESCRIPTION"), true);
		};

		MessagePage.prototype.onBeforeRendering = function() {
			// Don't want controls to be added again on re-rendering
			if (!(this._oText && this._oDescription)) {
				this._addPageContent();
			}
		};

		MessagePage.prototype.exit = function() {
			var oPage = this.getAggregation("_page");

			if (oPage) {
				oPage.destroy();
				oPage = null;
			}

			if (this._oText) {
				this._oText = null;
			}

			if (this._oDescription) {
				this._oDescription = null;
			}

			if (this._oIconControl) {
				this._oIconControl = null;
			}
		};

		MessagePage.prototype.setTitle = function(sTitle) {
			this.setProperty("title", sTitle, true); // no re-rendering
			this.getAggregation("_page").setTitle(sTitle);
		};

		MessagePage.prototype.setText = function(sText) {
			this.setProperty("text", sText, true); // no re-rendering
			this._oText && this._oText.setText(sText);
		};

		MessagePage.prototype.setDescription = function(sDescription) {
			this.setProperty("description", sDescription, true); // no re-rendering
			this._oDescription && this._oDescription.setText(sDescription);
		};

		MessagePage.prototype.setShowHeader = function(bShowHeader) {
			this.setProperty("showHeader", bShowHeader, true); // no re-rendering
			this.getAggregation("_page").setShowHeader(bShowHeader);
		};

		MessagePage.prototype.setShowNavButton = function(bShowNavButton) {
			this.setProperty("showNavButton", bShowNavButton, true); // no re-rendering
			this.getAggregation("_page").setShowNavButton(bShowNavButton);
		};

		MessagePage.prototype.setTextDirection = function(sTextDirection) {
			this.setProperty("textDirection", sTextDirection, true); // no re-rendering
			this._oText && this._oText.setTextDirection(sTextDirection);
			this._oDescription && this._oDescription.setTextDirection(sTextDirection);
		};

		MessagePage.prototype.setIcon = function(sIconUri) {
			var sOldIconUri = this.getIcon();
			this.setProperty("icon", sIconUri, true); // no re-rendering

			if (this._oIconControl) {
				// check if the value is changed and if URIs are from different type(icon or image) in order to avoid destroying and creating of icon control
				if (sOldIconUri !== sIconUri && IconPool.isIconURI(sOldIconUri) != IconPool.isIconURI(sIconUri)) {
					var oPage = this.getAggregation("_page");

					oPage.removeContent(this._oIconControl);
					this._oIconControl.destroy();
					oPage.insertContent(this._getIconControl(), 0);
				} else {
					this._oIconControl.setSrc(sIconUri);
				}
			}
		};

		MessagePage.prototype._addPageContent = function() {
			var oPage = this.getAggregation("_page");

			if (this.getAggregation("customText")) {
				this._oText = this.getAggregation("customText");
			} else {
				this._oText = new sap.m.Text({
					text: this.getText(),
					textAlign: sap.ui.core.TextAlign.Center,
					textDirection: this.getTextDirection()
				});
			}

			if (this.getAggregation("customDescription")) {
				this._oDescription = this.getAggregation("customDescription");
			} else {
				this._oDescription = new sap.m.Text({
					text: this.getDescription(),
					textAlign: sap.ui.core.TextAlign.Center,
					textDirection: this.getTextDirection()
				});
			}

			oPage.addContent(this._getIconControl());
			oPage.addContent(this._oText.addStyleClass("sapMMessagePageMainText"));
			oPage.addContent(this._oDescription.addStyleClass("sapMMessagePageDescription"));
		};

		MessagePage.prototype._getIconControl = function() {
			this._oIconControl = IconPool.createControlByURI({
				id: this.getId() + "-pageIcon",
				src: this.getIcon(),
				height: "8rem"
			}, sap.m.Image).addStyleClass("sapMMessagePageIcon");

			return this._oIconControl;
		};

		/**
		 * Returns the internal header
		 * Adding this functions because they are needed by the SplitContainer logic to show the "hamburger" button.
		 * @private
		 * @returns {sap.m.IBar}
		 */
		MessagePage.prototype._getAnyHeader = function() {
			return this._getInternalHeader();
		};

		/**
		 * Adding this functions because they are needed by the SplitContainer logic to show the "hamburger" button.
		 * @returns {sap.m.IBar}
		 * @private
		 */

		MessagePage.prototype._getInternalHeader = function() {
			return this.getAggregation("_page").getAggregation("_internalHeader");
		};


		return MessagePage;
	}, /* bExport= */ true);

}; // end of sap/m/MessagePage.js
if ( !jQuery.sap.isDeclared('sap.m.MessagePopoverItem') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.MessagePopoverItem.
jQuery.sap.declare('sap.m.MessagePopoverItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Item'); // unlisted dependency retained
sap.ui.define("sap/m/MessagePopoverItem",["jquery.sap.global", "./library", "sap/ui/core/Item"],
	function(jQuery, library, Item) {
		"use strict";

		/**
		 * Constructor for a new MessagePopoverItem.
		 *
		 * @param {string} [sId] id for the new control, generated automatically if no id is given
		 * @param {object} [mSettings] initial settings for the new control
		 *
		 * @class
		 * Items provide information about Error Messages in the page.
		 * @extends sap.ui.core.Element
		 *
		 * @author SAP SE
		 * @version 1.28.17
		 *
		 * @constructor
		 * @public
		 * @since 1.28
		 * @alias sap.m.MessagePopoverItem
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var MessagePopoverItem = Item.extend("sap.m.MessagePopoverItem", /** @lends sap.m.MessagePopoverItem.prototype */ {
				metadata: {
					library: "sap.m",
					properties: {
						/**
						 * Specifies the type of the message
						 */
						type: { type: "sap.ui.core.MessageType", group: "Appearance", defaultValue: sap.ui.core.MessageType.Error },

						/**
						 * Specifies the title of the message
						 */
						title: { type: "string", group: "Misc" },

						/**
						 * Specifies detailed description of the message
						 */
						description: { type: "string", group: "Misc" }
					}
				}
			});

		return MessagePopoverItem;

	}, /* bExport= */true);

}; // end of sap/m/MessagePopoverItem.js
if ( !jQuery.sap.isDeclared('sap.m.NavContainer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.NavContainer.
jQuery.sap.declare('sap.m.NavContainer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.PopupSupport'); // unlisted dependency retained
sap.ui.define("sap/m/NavContainer",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/PopupSupport'],
	function(jQuery, library, Control, PopupSupport) {
	"use strict";



	/**
	 * Constructor for a new NavContainer.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The NavContainer control handles hierarchic navigation between Pages or other fullscreen controls.
	 *
	 * All children of this control will receive navigation events like {@link sap.m.NavContainerChild#beforeShow beforeShow}, they are documented in the pseudo interface {@link sap.m.NavContainerChild sap.m.NavContainerChild}
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.NavContainer
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var NavContainer = Control.extend("sap.m.NavContainer", /** @lends sap.m.NavContainer.prototype */ { metadata : {

		library : "sap.m",
		properties : {

			/**
			 * The height of the NavContainer. Can be changed when the NavContainer should not cover the whole available area.
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},

			/**
			 * The width of the NavContainer. Can be changed when the NavContainer should not cover the whole available area.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},

			/**
			 * Whether the NavContainer is visible.
			 */
			visible : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * The type of the transition/animation to apply when "to()" is called without defining a transition type to use. The default is "slide". Other options are: "fade", "flip" and "show" - and the names of any registered custom transitions.
			 * @since 1.7.1
			 */
			defaultTransitionName : {type : "string", group : "Appearance", defaultValue : "slide"}
		},
		defaultAggregation : "pages",
		aggregations : {

			/**
			 * The content entities between which this NavContainer navigates. These can be of type sap.m.Page, sap.ui.core.View, sap.m.Carousel or any other control with fullscreen/page semantics.
			 *
			 * These aggregated controls will receive navigation events like {@link sap.m.NavContainerChild#beforeShow beforeShow}, they are documented in the pseudo interface {@link sap.m.NavContainerChild sap.m.NavContainerChild}
			 */
			pages : {type : "sap.ui.core.Control", multiple : true, singularName : "page"}
		},
		associations : {

			/**
			 * This association can be used to define which page is displayed initially. If the given page does not exist or no page is given, the first page which has been added is considered as initial page.
			 * This value should be set initially and not set/modified while the application is running.
			 *
			 * This could be used not only for the initial display, but also if the user wants to navigate "up to top", so this page serves as a sort of "home/root page".
			 */
			initialPage : {type : "sap.ui.core.Control", multiple : false}
		},
		events : {

			/**
			 * The event is fired when navigation between two pages has been triggered. The transition (if any) to the new page has not started yet.
			 * This event can be aborted by the application with preventDefault(), which means that there will be no navigation.
			 * @since 1.7.1
			 */
			navigate : {allowPreventDefault : true,
				parameters : {

					/**
					 * The page which was shown before the current navigation.
					 */
					from : {type : "sap.ui.core.Control"},

					/**
					 * The ID of the page which was shown before the current navigation.
					 */
					fromId : {type : "string"},

					/**
					 * The page which will be shown after the current navigation.
					 */
					to : {type : "sap.ui.core.Control"},

					/**
					 * The ID of the page which will be shown after the current navigation.
					 */
					toId : {type : "string"},

					/**
					 * Whether the "to" page (more precisely: a control with the ID of the page which is currently navigated to) has not been shown/navigated to before.
					 */
					firstTime : {type : "boolean"},

					/**
					 * Whether this is a forward navigation, triggered by "to()".
					 */
					isTo : {type : "boolean"},

					/**
					 * Whether this is a back navigation, triggered by "back()".
					 */
					isBack : {type : "boolean"},

					/**
					 * Whether this is a navigation to the root page, triggered by "backToTop()".
					 */
					isBackToTop : {type : "boolean"},

					/**
					 * Whether this was a navigation to a specific page, triggered by "backToPage()".
					 * @since 1.7.2
					 */
					isBackToPage : {type : "boolean"},

					/**
					 * How the navigation was triggered, possible values are "to", "back", "backToPage", and "backToTop".
					 */
					direction : {type : "string"}
				}
			},

			/**
			 * The event is fired when navigation between two pages has completed. In case of animated transitions this event is fired with some delay after the "navigate" event.
			 * @since 1.7.1
			 */
			afterNavigate : {
				parameters : {

					/**
					 * The page which had been shown before navigation.
					 */
					from : {type : "sap.ui.core.Control"},

					/**
					 * The ID of the page which had been shown before navigation.
					 */
					fromId : {type : "string"},

					/**
					 * The page which is now shown after navigation.
					 */
					to : {type : "sap.ui.core.Control"},

					/**
					 * The ID of the page which is now shown after navigation.
					 */
					toId : {type : "string"},

					/**
					 * Whether the "to" page (more precisely: a control with the ID of the page which has been navigated to) had not been shown/navigated to before.
					 */
					firstTime : {type : "boolean"},

					/**
					 * Whether was a forward navigation, triggered by "to()".
					 */
					isTo : {type : "boolean"},

					/**
					 * Whether this was a back navigation, triggered by "back()".
					 */
					isBack : {type : "boolean"},

					/**
					 * Whether this was a navigation to the root page, triggered by "backToTop()".
					 */
					isBackToTop : {type : "boolean"},

					/**
					 * Whether this was a navigation to a specific page, triggered by "backToPage()".
					 * @since 1.7.2
					 */
					isBackToPage : {type : "boolean"},

					/**
					 * How the navigation was triggered, possible values are "to", "back", "backToPage", and "backToTop".
					 */
					direction : {type : "string"}
				}
			}
		}
	}});


	NavContainer.prototype.init = function() {
		this._pageStack = [];
		this._aQueue = [];
		this._mVisitedPages = {};
		this._mFocusObject = {};
		this._iTransitionsCompleted = 0; // to track proper callback at the end of transitions
		this._bNeverRendered = true;
		this._bNavigating = false;
	};

	NavContainer.prototype.onBeforeRendering = function() {
		var pageToRenderFirst = this.getCurrentPage();
		// for the very first rendering
		if (this._bNeverRendered && pageToRenderFirst) { // will be set to false after rendering

			// special handling for the page which is the first one which is rendered in this NavContainer
			var pageId = pageToRenderFirst.getId();

			if (!this._mVisitedPages[pageId]) { // events could already be fired by initial "to()" call
				this._mVisitedPages[pageId] = true;

				var oNavInfo = {
						from:null,
						fromId:null,
						to:pageToRenderFirst,
						toId:pageId,
						firstTime:true,
						isTo:false,
						isBack:false,
						isBackToPage:false,
						isBackToTop:false,
						direction:"initial"
				};

				var oEvent = jQuery.Event("BeforeFirstShow", oNavInfo);
				oEvent.srcControl = this;
				oEvent.data = this._oToDataBeforeRendering || {};
				oEvent.backData = {};
				pageToRenderFirst._handleEvent(oEvent);

				oEvent = jQuery.Event("BeforeShow", oNavInfo);
				oEvent.srcControl = this;
				oEvent.data = this._oToDataBeforeRendering || {};
				oEvent.backData = {};
				pageToRenderFirst._handleEvent(oEvent);
			}
		}
	};

	NavContainer.prototype.onAfterRendering = function() {
		var pageToRenderFirst = this.getCurrentPage();
		// for the very first rendering
		if (this._bNeverRendered && pageToRenderFirst) {
			this._bNeverRendered = false;
			delete this._bNeverRendered;

			// special handling for the page which is the first one which is rendered in this NavContainer
			var pageId = pageToRenderFirst.getId();

			// set focus to first focusable object
			// when NavContainer is inside a popup, the focus is managed by the popup and shouldn't be set here
			if (!this.$().closest('[data-sap-ui-area="sap-ui-static"]').length) {
				var focusObject = jQuery.sap.byId(pageId).firstFocusableDomRef();
				if (focusObject) {
					jQuery.sap.focus(focusObject);
					this._mFocusObject[pageId] = focusObject;
				}
			}

			var oNavInfo = {
					from:null,
					fromId:null,
					to:pageToRenderFirst,
					toId:pageId,
					firstTime:true,
					isTo:false,
					isBack:false,
					isBackToTop:false,
					isBackToPage:false,
					direction:"initial"
			};

			var oEvent = jQuery.Event("AfterShow", oNavInfo);
			oEvent.srcControl = this;
			oEvent.data = this._oToDataBeforeRendering || {};
			oEvent.backData = {};
			pageToRenderFirst._handleEvent(oEvent);
		}
	};

	/**
	 * Returns the page that should act as initial page - either the one designated as such, or, if it does not exist,
	 * the first page (index 0 in the aggregation). Returns null if no page is aggregated.
	 *
	 * @private
	 */
	NavContainer.prototype._getActualInitialPage = function() {
		var pageId = this.getInitialPage();
		if (pageId) {
			var page = sap.ui.getCore().byId(pageId);
			if (page) {
				return page;
			} else {
				jQuery.sap.log.error("NavContainer: control with ID '" + pageId + "' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: " + this.getPages().length + ").");
			}
		}
		var pages = this.getPages();
		return (pages.length > 0 ? pages[0] : null);
	};


	//*** API methods ***


	/**
	 * Returns the control with the given ID from the "pages" aggregation (if available).
	 *
	 * @param {string} sId
	 *         The ID of the aggregated control to find.
	 * @type sap.ui.core.Control
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.getPage = function(pageId) {
		var aPages = this.getPages();
		for (var i = 0; i < aPages.length; i++) {
			if (aPages[i] && (aPages[i].getId() == pageId)) {
				return aPages[i];
			}
		}
		return null;
	};

	NavContainer.prototype._ensurePageStackInitialized = function() {
		if (this._pageStack.length === 0) {
			var page = this._getActualInitialPage(); // TODO: with bookmarking / deep linking this is the initial, but not the "home"/root page
			if (page) {
				this._pageStack.push({id:page.getId(), mode:"initial", data:{}});
			}
		}
		return this._pageStack;
	};


	/**
	 * Returns the currently displayed page-level control. Note: it is not necessarily an instance of sap.m.Page, but it could also be a sap.ui.core.View, sap.m.Carousel, or whatever is aggregated.
	 *
	 * Returns undefined if no page has been added yet.
	 *
	 * @type sap.ui.core.Control
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.getCurrentPage = function() {
		var stack = this._ensurePageStackInitialized();

		if (stack.length >= 1) {
			return this.getPage(stack[stack.length - 1].id);
		} else {
			jQuery.sap.log.warning(this + ": page stack is empty but should have been initialized - application failed to provide a page to display");
			return undefined;
		}
	};


	/**
	 * Returns the previous page (the page from which the user drilled down to the current page with "to()").
	 * Note: this is not the page which the user has seen before, but the page which is the target of the next "back()" navigation.
	 * If there is no previous page, "undefined" is returned.
	 *
	 * @type sap.ui.core.Control
	 * @public
	 * @since 1.7.1
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.getPreviousPage = function() {
		var stack = this._ensurePageStackInitialized();

		if (stack.length > 1) {
			return this.getPage(stack[stack.length - 2].id);

		} else if (stack.length == 1) { // the current one is the only page on the stack
			return undefined;

		} else {
			jQuery.sap.log.warning(this + ": page stack is empty but should have been initialized - application failed to provide a page to display");
		}
	};


	/**
	 * Returns whether the current page is the top/initial page.
	 *
	 * Note: going to the initial page again with a row of "to" navigations causes the initial page to be displayed again, but logically one is not at the top level, so this method returns "false" in this case.
	 *
	 * @type boolean
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.currentPageIsTopPage = function() {
		var stack = this._ensurePageStackInitialized();
		return (stack.length === 1);
	};



	/**
	 * Inserts the page/control with the specified ID into the navigation history stack of the NavContainer.
	 *
	 * This can be used for deep-linking when the user directly reached a drilldown detail page using a bookmark and then wants to navigate up in the drilldown hierarchy. Normally such a back navigation would not be possible because there is no previous page in the NavContainer's history stack.
	 *
	 * @param {string} sPageId
	 *         The ID of the control/page/screen which is inserted into the history stack. The respective control must be aggregated by the NavContainer, otherwise this will cause an error.
	 * @param {string} sTransitionName
	 *         The type of the transition/animation which would have been used to navigate from the (inserted) previous page to the current page. When navigating back, the inverse animation will be applied.
	 *         This parameter can be omitted; then the default is "slide" (horizontal movement from the right).
	 * @param {object} oData
	 *         This optional object can carry any payload data which would have been given to the inserted previous page if the user would have done a normal forward navigation to it.
	 * @type sap.m.NavContainer
	 * @public
	 * @since 1.16.1
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.insertPreviousPage = function(pageId, transitionName, data) {
		var stack = this._ensurePageStackInitialized();
		if (this._pageStack.length > 0) {
			var index = stack.length - 1;
			var pageInfo = {id:pageId,mode:transitionName,data:data};
			if (index === 0) {
				pageInfo.mode = "initial";
				delete stack[stack.length - 1].mode;
			}
			stack.splice(index, 0, pageInfo);
		} else {
			jQuery.sap.log.warning(this + ": insertPreviousPage called with empty page stack; ignoring");
		}

		return this;
	};


	NavContainer.prototype._afterTransitionCallback = function(oNavInfo, oData, oBackData) {
		var oEvent = jQuery.Event("AfterShow", oNavInfo);
		oEvent.data = oData || {};
		oEvent.backData = oBackData || {};
		oEvent.srcControl = this; // store the element on the event (aligned with jQuery syntax)
		oNavInfo.to._handleEvent(oEvent);

		oEvent = jQuery.Event("AfterHide", oNavInfo);
		oEvent.srcControl = this; // store the element on the event (aligned with jQuery syntax)
		oNavInfo.from._handleEvent(oEvent);

		this._iTransitionsCompleted++;
		this._bNavigating = false;

		// check navigation type (backward or forward)
		var focusObject = null;
		if (oNavInfo.isBack || oNavInfo.isBackToPage || oNavInfo.isBackToTop) {
			// set focus to the remembered focus object if available
			// if no focus was set set focus to first focusable object in "to page"
			focusObject = this._mFocusObject[oNavInfo.toId];
			if (focusObject) {
				jQuery.sap.focus(focusObject);
			} else {
				focusObject = jQuery('#' + oNavInfo.toId).firstFocusableDomRef();
				if (focusObject) {
					jQuery.sap.focus(focusObject);
				}
			}
		} else if (oNavInfo.isTo) {
			// set focus to first focusable object in "to page"
			focusObject = jQuery('#' + oNavInfo.toId).firstFocusableDomRef();
			if (focusObject) {
				jQuery.sap.focus(focusObject);
			}
		}

		this.fireAfterNavigate(oNavInfo);
		// TODO: destroy HTML? Remember to destroy ALL HTML of several pages when backToTop has been called

		jQuery.sap.log.info(this + ": _afterTransitionCallback called, to: " + oNavInfo.toId);

		if (oNavInfo.to.hasStyleClass("sapMNavItemHidden")) {
			jQuery.sap.log.warning(this.toString() + ": target page '" + oNavInfo.toId + "' still has CSS class 'sapMNavItemHidden' after transition. This should not be the case, please check the preceding log statements.");
			oNavInfo.to.removeStyleClass("sapMNavItemHidden");
		}

		if (this._aQueue.length > 0) {
			var fnNavigate = this._aQueue.shift();
			fnNavigate();
		}
	};


	/**
	 * Navigates to the next page (with drill-down semantic) with the given (or default) animation. This creates a new history item inside the NavContainer and allows going back.
	 *
	 * Note that any modifications to the target page (like setting its title, or anything else that could cause a re-rendering) should be done BEFORE calling to(), in order to avoid unwanted side effects, e.g. related to the page animation.
	 *
	 * Available transitions currently include "slide" (default), "fade", "flip", and "show". None of these is currently making use of any given transitionParameters.
	 *
	 * Calling this navigation method triggers first the (cancelable) "navigate" event on the NavContainer, then the "beforeHide" pseudo event on the source page and "beforeFirstShow" (if applicable) and"beforeShow" on the target page. Later - after the transition has completed - the "afterShow" pseudo event is triggered on the target page and "afterHide" on the page which has been left. The given data object is available in the "beforeFirstShow", "beforeShow" and "afterShow" event object as "data" property.
	 *
	 * @param {string} sPageId
	 *         The screen to which drilldown should happen. The ID or the control itself can be given.
	 * @param {string} sTransitionName
	 *         The type of the transition/animation to apply. This parameter can be omitted; then the default is "slide" (horizontal movement from the right).
	 *         Other options are: "fade", "flip", and "show" and the names of any registered custom transitions.
	 *
	 *         None of the standard transitions is currently making use of any given transition parameters.
	 * @param {object} oData
	 *         Since version 1.7.1. This optional object can carry any payload data which should be made available to the target page. The "beforeShow" event on the target page will contain this data object as "data" property.
	 *
	 *         Use case: in scenarios where the entity triggering the navigation can or should not directly initialize the target page, it can fill this object and the target page itself (or a listener on it) can take over the initialization, using the given data.
	 *
	 *         When the "transitionParameters" object is used, this "data" object must also be given (either as object or as null) in order to have a proper parameter order.
	 * @param {object} oTransitionParameters
	 *         Since version 1.7.1. This optional object can contain additional information for the transition function, like the DOM element which triggered the transition or the desired transition duration.
	 *
	 *         For a proper parameter order, the "data" parameter must be given when the "transitionParameters" parameter is used. (it can be given as "null")
	 *
	 *         NOTE: it depends on the transition function how the object should be structured and which parameters are actually used to influence the transition.
	 *         The "show", "slide" and "fade" transitions do not use any parameter.
	 * @type sap.m.NavContainer
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.to = function(pageId, transitionName, data, oTransitionParameters) {
		if (pageId instanceof Control) {
			pageId = pageId.getId();
		}

		// fix parameters
		if (typeof (transitionName) !== "string") {
			// transitionName is omitted, shift parameters
			oTransitionParameters = data;
			data = transitionName;
		}
		transitionName = transitionName || this.getDefaultTransitionName();
		oTransitionParameters = oTransitionParameters || {};
		data = data || {};

		// make sure the initial page is on the stack
		this._ensurePageStackInitialized();

		//add to the queue before checking the current page, because this might change
		if (this._bNavigating) {
			jQuery.sap.log.info(this.toString() + ": Cannot navigate to page " + pageId + " because another navigation is already in progress. - navigation will be executed after the previous one");

			this._aQueue.push(jQuery.proxy( function() {
				this.to(pageId, transitionName, data, oTransitionParameters);
			},this));

			return this;
		}

		// If to is called before rendering, remember the data so we can pass it to the events as soon as the navContainer gets rendered
		if (this._bNeverRendered) {
			this._oToDataBeforeRendering = data;
		}

		var oFromPage = this.getCurrentPage();
		if (oFromPage && (oFromPage.getId() === pageId)) { // cannot navigate to the page that is already current
			jQuery.sap.log.warning(this.toString() + ": Cannot navigate to page " + pageId + " because this is the current page.");
			return this;
		}

		var oToPage = this.getPage(pageId);

		if (oToPage) {

			// remember the focused object in "from page"
			this._mFocusObject[oFromPage.getId()] = document.activeElement;

			var oNavInfo = {
					from:oFromPage,
					fromId:oFromPage.getId(),
					to:oToPage,
					toId:pageId,
					firstTime:!this._mVisitedPages[pageId],
					isTo:true,
					isBack:false,
					isBackToTop:false,
					isBackToPage:false,
					direction:"to"
			};
			var bContinue = this.fireNavigate(oNavInfo);
			if (bContinue) { // ok, let's do the navigation

				sap.m.closeKeyboard();

				// TODO: let one of the pages also cancel navigation?
				var oEvent = jQuery.Event("BeforeHide", oNavInfo);
				oEvent.srcControl = this; // store the element on the event (aligned with jQuery syntax)
				// no data needed for hiding
				oFromPage._handleEvent(oEvent);

				if (!this._mVisitedPages[pageId]) { // if this page has not been shown before
					oEvent = jQuery.Event("BeforeFirstShow", oNavInfo);
					oEvent.srcControl = this;
					oEvent.data = data || {};
					oEvent.backData = {};
					oToPage._handleEvent(oEvent);
				}

				oEvent = jQuery.Event("BeforeShow", oNavInfo);
				oEvent.srcControl = this;
				oEvent.data = data || {};
				oEvent.backData = {};
				oToPage._handleEvent(oEvent);


				this._pageStack.push({id:pageId,mode:transitionName,data:data}); // this actually causes/is the navigation
				jQuery.sap.log.info(this.toString() + ": navigating to page '" + pageId + "': " + oToPage.toString());
				this._mVisitedPages[pageId] = true;

				if (!this.getDomRef()) { // the wanted animation has been recorded, but when the NavContainer is not rendered, we cannot animate, so just return
					jQuery.sap.log.info("'Hidden' 'to' navigation in not-rendered NavContainer " + this.toString());
					return this;
				}

				// render the page that should get visible
				var oToPageDomRef;

				if (!(oToPageDomRef = oToPage.getDomRef()) || oToPageDomRef.parentNode != this.getDomRef() || sap.ui.core.RenderManager.isPreservedContent(oToPageDomRef)) {
					oToPage.addStyleClass("sapMNavItemRendering");
					jQuery.sap.log.debug("Rendering 'to' page '" + oToPage.toString() + "' for 'to' navigation");
					var rm = sap.ui.getCore().createRenderManager();
					rm.render(oToPage, this.getDomRef());
					rm.destroy();
					oToPage.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");
				}

				var oTransition = NavContainer.transitions[transitionName] || NavContainer.transitions["slide"];

				// Track proper invocation of the callback  TODO: only do this during development?
				var iCompleted = this._iTransitionsCompleted;
				var that = this;
				window.setTimeout(function(){
					if (that && (that._iTransitionsCompleted < iCompleted + 1)) {
						jQuery.sap.log.warning("Transition '" + transitionName + "' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");
					}
				}, 5000);

				this._bNavigating = true;
				oTransition.to.call(this, oFromPage, oToPage, jQuery.proxy(function(){this._afterTransitionCallback(oNavInfo, data);}, this), oTransitionParameters); // trigger the transition

			} else {
				jQuery.sap.log.info("Navigation to page with ID '" + pageId + "' has been aborted by the application");
			}

		} else {
			jQuery.sap.log.warning("Navigation triggered to page with ID '" + pageId + "', but this page is not known/aggregated by " + this);
		}
		return this;
	};



	/**
	 * Navigates back one level. If already on the initial page and there is no place to go back, nothing happens.
	 *
	 * Calling this navigation method triggers first the (cancelable) "navigate" event on the NavContainer, then the "beforeHide" pseudo event on the source page and "beforeFirstShow" (if applicable) and"beforeShow" on the target page. Later - after the transition has completed - the "afterShow" pseudo event is triggered on the target page and "afterHide" on the page which has been left. The given backData object is available in the "beforeFirstShow", "beforeShow" and "afterShow" event object as "data" property. The original "data" object from the "to" navigation is also available in these event objects.
	 *
	 * @param {object} oBackData
	 *         Since version 1.7.1. This optional object can carry any payload data which should be made available to the target page of the back navigation. The event on the target page will contain this data object as "backData" property. (The original data from the "to()" navigation will still be available as "data" property.)
	 *
	 *         In scenarios where the entity triggering the navigation can or should not directly initialize the target page, it can fill this object and the target page itself (or a listener on it) can take over the initialization, using the given data.
	 *         For back navigation this can be used e.g. when returning from a detail page to transfer any settings done there.
	 *
	 *         When the "transitionParameters" object is used, this "data" object must also be given (either as object or as null) in order to have a proper parameter order.
	 * @param {object} oTransitionParameters
	 *         Since version 1.7.1. This optional object can give additional information to the transition function, like the DOM element which triggered the transition or the desired transition duration.
	 *         The animation type can NOT be selected here - it is always the inverse of the "to" navigation.
	 *
	 *         In order to use the "transitionParameters" property, the "data" property must be used (at least "null" must be given) for a proper parameter order.
	 *
	 *         NOTE: it depends on the transition function how the object should be structured and which parameters are actually used to influence the transition.
	 * @type sap.m.NavContainer
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.back = function(backData, oTransitionParameters) {
		this._backTo("back", backData, oTransitionParameters);
		return this;
	};


	/**
	 * Navigates back to the nearest previous page in the NavContainer history with the given ID. If there is no such page among the previous pages, nothing happens.
	 * The transition effect which had been used to get to the current page is inverted and used for this navigation.
	 *
	 * Calling this navigation method triggers first the (cancelable) "navigate" event on the NavContainer, then the "beforeHide" pseudo event on the source page and "beforeFirstShow" (if applicable) and"beforeShow" on the target page. Later - after the transition has completed - the "afterShow" pseudo event is triggered on the target page and "afterHide" on the page which has been left. The given backData object is available in the "beforeFirstShow", "beforeShow" and "afterShow" event object as "data" property. The original "data" object from the "to" navigation is also available in these event objects.
	 *
	 * @param {string} sPageId
	 *         The ID of the screen to which back navigation should happen. The ID or the control itself can be given. The nearest such page among the previous pages in the history stack will be used.
	 * @param {object} oBackData
	 *         This optional object can carry any payload data which should be made available to the target page of the "backToPage" navigation. The event on the target page will contain this data object as "backData" property.
	 *
	 *         When the "transitionParameters" object is used, this "data" object must also be given (either as object or as null) in order to have a proper parameter order.
	 * @param {object} oTransitionParameters
	 *         This optional object can give additional information to the transition function, like the DOM element which triggered the transition or the desired transition duration.
	 *         The animation type can NOT be selected here - it is always the inverse of the "to" navigation.
	 *
	 *         In order to use the "transitionParameters" property, the "data" property must be used (at least "null" must be given) for a proper parameter order.
	 *
	 *         NOTE: it depends on the transition function how the object should be structured and which parameters are actually used to influence the transition.
	 * @type sap.m.NavContainer
	 * @public
	 * @since 1.7.2
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.backToPage = function(pageId, backData, oTransitionParameters) {
		this._backTo("backToPage", backData, oTransitionParameters, pageId);
		return this;
	};


	/**
	 * Navigates back to the initial/top level (this is the element aggregated as "initialPage", or the first added element). If already on the initial page, nothing happens.
	 * The transition effect which had been used to get to the current page is inverted and used for this navigation.
	 *
	 * Calling this navigation method triggers first the (cancelable) "navigate" event on the NavContainer, then the "beforeHide" pseudo event on the source page and "beforeFirstShow" (if applicable) and"beforeShow" on the target page. Later - after the transition has completed - the "afterShow" pseudo event is triggered on the target page and "afterHide" on the page which has been left. The given backData object is available in the "beforeFirstShow", "beforeShow" and "afterShow" event object as "data" property.
	 *
	 * @param {object} oBackData
	 *         This optional object can carry any payload data which should be made available to the target page of the "backToTop" navigation. The event on the target page will contain this data object as "backData" property.
	 *
	 *         When the "transitionParameters" object is used, this "data" object must also be given (either as object or as null) in order to have a proper parameter order.
	 * @param {object} oTransitionParameters
	 *         This optional object can give additional information to the transition function, like the DOM element which triggered the transition or the desired transition duration.
	 *         The animation type can NOT be selected here - it is always the inverse of the "to" navigation.
	 *
	 *         In order to use the "transitionParameters" property, the "data" property must be used (at least "null" must be given) for a proper parameter order.
	 *
	 *         NOTE: it depends on the transition function how the object should be structured and which parameters are actually used to influence the transition.
	 * @type sap.m.NavContainer
	 * @public
	 * @since 1.7.1
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.backToTop = function(backData, oTransitionParameters) {
		this._backTo("backToTop", backData, oTransitionParameters);
		return this;
	};


	NavContainer.prototype._backTo = function(sType, backData, oTransitionParameters, sRequestedPageId) {
		if (this._bNavigating) {
			jQuery.sap.log.warning(this.toString() + ": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");


			this._aQueue.push(jQuery.proxy( function() {
				this._backTo(sType, backData, oTransitionParameters, sRequestedPageId);
			},this));

			return this;
		}

		if (this._pageStack.length <= 1) {
			// there is no place to go back

			// but then the assumption is that the only page on the stack is the initial one and has not been navigated to. Check this:
			if (this._pageStack.length === 1 && this._pageStack[0].mode != "initial") {
				throw new Error("Initial page not found on the stack. How did this happen?");
			}
			return this;

		} else { // normal back navigation

			if (sRequestedPageId instanceof Control) {
				sRequestedPageId = sRequestedPageId.getId();
			}

			var oFromPageInfo = this._pageStack[this._pageStack.length - 1];
			var mode = oFromPageInfo.mode;
			var oFromPage = this.getPage(oFromPageInfo.id);
			var oToPage;
			var oToPageData;

			if (sType === "backToTop") {
				oToPage = this._getActualInitialPage();
				oToPageData = null;

			} else if (sType === "backToPage") {
				var info = this._findClosestPreviousPageInfo(sRequestedPageId);
				if (!info) {
					jQuery.sap.log.error(this.toString() + ": Cannot navigate backToPage('" + sRequestedPageId + "') because target page was not found among the previous pages.");
					return this;
				}
				oToPage = sap.ui.getCore().byId(info.id);
				if (!oToPage) {
					jQuery.sap.log.error(this.toString() + ": Cannot navigate backToPage('" + sRequestedPageId + "') because target page does not exist anymore.");
					return this;
				}
				oToPageData = info.data;

			} else { // normal "back"
				oToPage = this.getPreviousPage();
				oToPageData = this._pageStack[this._pageStack.length - 2].data;
			}

			if (!oToPage) {
				jQuery.sap.log.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");
				return;
			}

			var oToPageId = oToPage.getId();
			backData = backData || {};
			oTransitionParameters = oTransitionParameters || {};

			var oNavInfo = {
				from:oFromPage,
				fromId:oFromPage.getId(),
				to:oToPage,
				toId:oToPageId,
				firstTime:!this._mVisitedPages[oToPageId],
				isTo:false,
				isBack:(sType === "back"),
				isBackToPage:(sType === "backToPage"),
				isBackToTop:(sType === "backToTop"),
				direction:sType
			};
			var bContinue = this.fireNavigate(oNavInfo);
			if (bContinue) { // ok, let's do the navigation

				sap.m.closeKeyboard();

				var oEvent = jQuery.Event("BeforeHide", oNavInfo);
				oEvent.srcControl = this; // store the element on the event (aligned with jQuery syntax)
				// no data needed for hiding
				oFromPage._handleEvent(oEvent);

				if (!this._mVisitedPages[oToPageId]) { // if this page has not been shown before
					oEvent = jQuery.Event("BeforeFirstShow", oNavInfo);
					oEvent.srcControl = this;
					oEvent.backData = backData || {};
					// the old data from the forward navigation should not exist because there was never a forward navigation
					oEvent.data = {};
					oToPage._handleEvent(oEvent);
				}

				oEvent = jQuery.Event("BeforeShow", oNavInfo);
				oEvent.srcControl = this;
				oEvent.backData = backData || {};
				oEvent.data =  oToPageData || {}; // the old data from the forward navigation
				oToPage._handleEvent(oEvent);

				this._pageStack.pop(); // this actually causes/is the navigation
				jQuery.sap.log.info(this.toString() + ": navigating back to page " + oToPage.toString());
				this._mVisitedPages[oToPageId] = true;

				if (sType === "backToTop") { // if we should navigate to top, just clean up the whole stack
					this._pageStack = [];
					jQuery.sap.log.info(this.toString() + ": navigating back to top");
					this.getCurrentPage(); // this properly restores the initial page on the stack

				} else if (sType === "backToPage") {
					var aPages = [], interimPage;
					while (this._pageStack[this._pageStack.length - 1].id !== sRequestedPageId) { // by now it is guaranteed that we will find it
						interimPage = this._pageStack.pop();
						aPages.push(interimPage.id);
					}
					jQuery.sap.log.info(this.toString() + ": navigating back to specific page " + oToPage.toString() + " across the pages: " + aPages.join(", "));
				}

				if (!this.getDomRef()) { // the wanted animation has been recorded, but when the NavContainer is not rendered, we cannot animate, so just return
					jQuery.sap.log.info("'Hidden' back navigation in not-rendered NavContainer " + this.toString());
					return this;
				}

				var oTransition = NavContainer.transitions[mode] || NavContainer.transitions["slide"];

				// Track proper invocation of the callback  TODO: only do this during development?
				var iCompleted = this._iTransitionsCompleted;
				var that = this;
				window.setTimeout(function(){
					if (that && (that._iTransitionsCompleted < iCompleted + 1)) {
						jQuery.sap.log.warning("Transition '" + mode + "' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");
					}
				}, 5000);

				this._bNavigating = true;

				// make sure the to-page is rendered
				var oToPageDomRef;
				if (!(oToPageDomRef = oToPage.getDomRef()) || oToPageDomRef.parentNode != this.getDomRef() || sap.ui.core.RenderManager.isPreservedContent(oToPageDomRef)) {
					oToPage.addStyleClass("sapMNavItemRendering");
					jQuery.sap.log.debug("Rendering 'to' page '" + oToPage.toString() + "' for back navigation");
					var rm = sap.ui.getCore().createRenderManager();
					var childPos = this.$().children().index(oFromPage.getDomRef());
					rm.renderControl(oToPage);
					rm.flush(this.getDomRef(), false, childPos);
					rm.destroy();
					oToPage.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");
				}

				//if the from page and to page are identical, the transition is skipped.
				if (oFromPage.getId() === oToPage.getId()) {
					jQuery.sap.log.info("Transition is skipped when navigating back to the same page instance" + oToPage.toString());
					this._afterTransitionCallback(oNavInfo, oToPageData, backData);
					return this;
				}

				// trigger the transition
				oTransition.back.call(this, oFromPage, oToPage, jQuery.proxy(function(){this._afterTransitionCallback(oNavInfo, oToPageData, backData);}, this), oTransitionParameters); // trigger the transition
			}
		}
		return this;
	};

	NavContainer.prototype._findClosestPreviousPageInfo = function(sRequestedPreviousPageId) {
		for (var i = this._pageStack.length - 2; i >= 0; i--) {
			var info = this._pageStack[i];
			if (info.id === sRequestedPreviousPageId) {
				return info;
			}
		}
		return null;
	};


	NavContainer.transitions = NavContainer.transitions || {}; // make sure the object exists


	//*** SHOW Transition ***

	NavContainer.transitions["show"] = {
		to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class which has been added by the NavContainer before the transition was called
			oFromPage && oFromPage.addStyleClass("sapMNavItemHidden");
			fCallback();
		},

		back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			oToPage.removeStyleClass("sapMNavItemHidden");
			oFromPage && oFromPage.addStyleClass("sapMNavItemHidden"); // instantly hide the previous page
			fCallback();
		}
	};


	//*** SLIDE Transition ***

	if (jQuery.support.cssTransitions) {
		NavContainer.transitions["slide"] = {

			to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				oFromPage.addStyleClass("sapMNavItemCenter");
				window.setTimeout(function(){ // iPhone seems to need a zero timeout here, otherwise the to page is black (and may suddenly become visible when the DOM is touched)

					// set the style classes that represent the initial state
					oToPage.addStyleClass("sapMNavItemRight");     // the page to navigate to should be placed just right of the visible area
					oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called


					// iPhone needs some time... there is no animation without waiting
					window.setTimeout(function(){

						var bOneTransitionFinished = false;
						var bTransitionEndPending = true;
						var fAfterTransition = null; // make Eclipse aware that this variable is defined
						fAfterTransition = function() {
							jQuery(this).unbind("webkitTransitionEnd transitionend");
							if (!bOneTransitionFinished) {
								// the first one of both transitions finished
								bOneTransitionFinished = true;
							} else {
								// the second transition now also finished => clean up the style classes
								bTransitionEndPending = false;
								oToPage.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");
								oFromPage.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemLeft");

								// notify the NavContainer that the animation is complete
								fCallback();
							}
						};

						oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
						oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);

						// set the new style classes that represent the end state (and thus start the transition)
						oToPage.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemRight");
						oFromPage.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemLeft");

						window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
							if (bTransitionEndPending) {
								bOneTransitionFinished = true;
								fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
							}
						}, 400);

					}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few

				},0); // iPhone seems to need a zero timeout here, otherwise the to page is black (and may suddenly become visible when the DOM is touched)
			},

			back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				// set the style classes that represent the initial state
				oToPage.addStyleClass("sapMNavItemLeft");     // the page to navigate back to should be placed just left of the visible area
				oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called
				oFromPage.addStyleClass("sapMNavItemCenter");

				// iPhone needs some time... there is no animation without waiting
				window.setTimeout(function() {

					var bOneTransitionFinished = false;
					var bTransitionEndPending = true;
					var fAfterTransition = null; // make Eclipse aware that this variable is defined
					fAfterTransition = function() {
						jQuery(this).unbind("webkitTransitionEnd transitionend");
						if (!bOneTransitionFinished) {
							// the first one of both transitions finished
							bOneTransitionFinished = true;
						} else {
							// the second transition now also finished => clean up the style classes
							bTransitionEndPending = false;
							oToPage.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");
							oFromPage.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRight");

							// notify the NavContainer that the animation is complete
							fCallback();
						}
					};

					oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
					oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);

					// workaround for bug in current webkit versions: in slided-in elements the z-order may be wrong and will be corrected once a re-layout is enforced
					// see http://code.google.com/p/chromium/issues/detail?id=246965
					if (sap.ui.Device.browser.webkit) {
						window.setTimeout(function(){
							oToPage.$().css("box-shadow", "0em 1px 0em rgba(128, 128, 1280, 0.1)"); // add box-shadow
							window.setTimeout(function(){
								oToPage.$().css("box-shadow", ""); // remove it again
							},50);
						},0);
					}

					// set the new style classes that represent the end state (and thus start the transition)
					oToPage.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemLeft"); // transition from left position to normal/center position starts now
					oFromPage.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemRight"); // transition from normal position to right position starts now

					window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
						if (bTransitionEndPending) {
							bOneTransitionFinished = true;
							fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
						}
					}, 400);

				}, 100); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few
			}
		};

	} else { // no CSS transitions, IE9 support
		NavContainer.transitions["slide"] = {
			to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				var $ToPage = oToPage.$();
				$ToPage.css("left", "100%");
				oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class which has been added by the NavContainer before the transition was called

				$ToPage.animate({left: "0%"}, 300);
				var $FromPage = oFromPage.$();
				$FromPage.animate({left: "-100%"}, 300, function(){
					oFromPage.addStyleClass("sapMNavItemHidden");
					$FromPage.css("left", "0");
					fCallback();
				});
			},

			back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				var $ToPage = oToPage.$();
				$ToPage.css("left", "-100%");
				oToPage.removeStyleClass("sapMNavItemHidden");

				$ToPage.animate({left: "0%"}, 300);
				var $FromPage = oFromPage.$();
				$FromPage.animate({left: "100%"}, 300, function(){
					oFromPage.addStyleClass("sapMNavItemHidden");
					$FromPage.css("left", "0");
					fCallback();
				});
			}
		};
	}


	//*** FADE Transition ***

	if (jQuery.support.cssTransitions) {
		NavContainer.transitions["fade"] = {

				to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
					// set the style classes that represent the initial state
					oToPage.addStyleClass("sapMNavItemTransparent");
					oToPage.removeStyleClass("sapMNavItemHidden");

					// iPhone needs some time for rendering, there is no animation without waiting
					window.setTimeout(function(){

						// the code to be executed after the new page has completed fading in
						var fAfterTransition = null; // make Eclipse aware that this variable is defined
						var bTransitionEndPending = true;
						fAfterTransition = function() {
							jQuery(this).unbind("webkitTransitionEnd transitionend");
							// clean up the style classes
							bTransitionEndPending = false;
							oFromPage.addStyleClass("sapMNavItemHidden");
							oToPage.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");

							// notify the NavContainer that the animation is complete
							fCallback();
						};

						oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);

						// set the new style classes that represent the end state (and thus start the transition)
						oToPage.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");

						window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
							if (bTransitionEndPending) {
								fAfterTransition.apply(oToPage.$());
							}
						}, 600);

					}, 10);
				},

				back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
					// set the style classes that represent the initial state
					oFromPage.addStyleClass("sapMNavItemOpaque");
					oToPage.removeStyleClass("sapMNavItemHidden");

					// iPhone needs some time for rendering, there is no animation without waiting
					window.setTimeout(function() {

						// the code to be executed after the new page has completed fading in
						var fAfterTransition = null; // make Eclipse aware that this variable is defined
						var bTransitionEndPending = true;
						fAfterTransition = function() {
							jQuery(this).unbind("webkitTransitionEnd transitionend");
							// clean up the style classes
							bTransitionEndPending = false;
							oFromPage.removeStyleClass("sapMNavItemFading").addStyleClass("sapMNavItemHidden"); // TODO: destroy HTML?
							oFromPage.removeStyleClass("sapMNavItemTransparent");

							// notify the NavContainer that the animation is complete
							fCallback();
						};

						oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);

						// set the new style classes that represent the end state (and thus start the transition)
						oFromPage.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");
						oFromPage.addStyleClass("sapMNavItemTransparent");

						window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
							if (bTransitionEndPending) {
								fAfterTransition.apply(oToPage.$());
							}
						}, 600);

					}, 10);
				}
		};

	} else { // no CSS transitions, IE9 support
		NavContainer.transitions["fade"] = {
			to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				var $ToPage = oToPage.$();
				$ToPage.css("opacity", "0");
				oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class which has been added by the NavContainer before the transition was called

				$ToPage.animate({opacity: "1"}, 500, function(){
					oFromPage.addStyleClass("sapMNavItemHidden");
					fCallback();
				});
			},

			back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				var $FromPage = oFromPage.$();
				oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class which has been added by the NavContainer before the transition was called

				$FromPage.animate({opacity: "0"}, 500, function(){
					oFromPage.addStyleClass("sapMNavItemHidden");
					$FromPage.css("opacity", "1");
					fCallback();
				});
			}
		};
	}


	//*** FLIP Transition ***

	if (jQuery.support.cssTransitions) {
		NavContainer.transitions["flip"] = {

			to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				var that = this;
				window.setTimeout(function(){ // iPhone seems to need a zero timeout here, otherwise the to page is black (and may suddenly become visible when the DOM is touched)

					var isAndroid23 = (sap.ui.Device.os.android && sap.ui.Device.os.version === 2.3);

					// if not Android2.3 then add perspective styles to NavContainer
					!isAndroid23 && that.$().addClass("sapMNavFlip");

					// set the style classes that represent the initial state
					oToPage.addStyleClass("sapMNavItemFlipNext");     // the page to navigate to should be placed just right of the visible area
					oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called

					// iPhone needs some time... there is no animation without waiting
					window.setTimeout(function(){

						var bOneTransitionFinished = false;
						var bTransitionEndPending = true;
						var fAfterTransition = null; // make Eclipse aware that this variable is defined
						fAfterTransition = function() {
							jQuery(this).unbind("webkitTransitionEnd transitionend");
							if (!bOneTransitionFinished) {
								// the first one of both transitions finished
								bOneTransitionFinished = true;
							} else {
								// the second transition now also finished => clean up the style classes
								bTransitionEndPending = false;
								oToPage.removeStyleClass("sapMNavItemFlipping");
								oFromPage.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious");
								!isAndroid23 && that.$().removeClass("sapMNavFlip");

								// notify the NavContainer that the animation is complete
								fCallback();
							}
						};

						oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
						oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);

						// set the new style classes that represent the end state (and thus start the transition)
						oToPage.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");
						oFromPage.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");

						window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
							if (bTransitionEndPending) {
								bOneTransitionFinished = true;
								fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
							}
						}, 600);

					}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few#
				}, 0);
			},

			back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				var that = this,
					isAndroid23 = (sap.ui.Device.os.android && sap.ui.Device.os.version === 2.3);

				// if not Android2.3 then add perspective styles to NavContainer
				!isAndroid23 && that.$().addClass("sapMNavFlip");

				// set the style classes that represent the initial state
				oToPage.addStyleClass("sapMNavItemFlipPrevious");     // the page to navigate back to should be placed just left of the visible area
				oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called

				// iPhone needs some time... there is no animation without waiting
				window.setTimeout(function() {

					var bOneTransitionFinished = false;
					var bTransitionEndPending = true;
					var fAfterTransition = null; // make Eclipse aware that this variable is defined
					fAfterTransition = function() {
						jQuery(this).unbind("webkitTransitionEnd transitionend");
						if (!bOneTransitionFinished) {
							// the first one of both transitions finished
							bOneTransitionFinished = true;
						} else {
							// the second transition now also finished => clean up the style classes
							bTransitionEndPending = false;
							oToPage.removeStyleClass("sapMNavItemFlipping");
							oFromPage.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext");
							!isAndroid23 && that.$().removeClass("sapMNavFlip");

							// notify the NavContainer that the animation is complete
							fCallback();
						}
					};

					oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
					oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);

					// set the new style classes that represent the end state (and thus start the transition)
					oToPage.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious"); // transition from left position to normal/center position starts now
					oFromPage.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext"); // transition from normal position to right position starts now

					window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
						if (bTransitionEndPending) {
							bOneTransitionFinished = true;
							fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
						}
					}, 600);

				}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few
			}
		};

	} else { // no CSS transitions, IE9 support
		NavContainer.transitions["flip"] = NavContainer.transitions["slide"];
	}


	//*** DOOR Transition ***

	if (jQuery.support.cssTransitions) {
		NavContainer.transitions["door"] = {

			to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				var that = this;
				window.setTimeout(function(){ // iPhone seems to need a zero timeout here, otherwise the to page is black (and may suddenly become visible when the DOM is touched)

					var isAndroid23 = (sap.ui.Device.os.android && sap.ui.Device.os.version === 2.3);

					// if not Android2.3 then add perspective styles to NavContainer
					!isAndroid23 && that.$().addClass("sapMNavDoor");

					// set the style classes that represent the initial state
					oToPage.addStyleClass("sapMNavItemDoorInNext");     // the page to navigate to should be placed just right of the visible area
					oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called

					// iPhone needs some time... there is no animation without waiting
					window.setTimeout(function(){

						var bOneTransitionFinished = false;
						var bTransitionEndPending = true;
						var fAfterTransition = null; // make Eclipse aware that this variable is defined
						fAfterTransition = function() {
							jQuery(this).unbind("webkitAnimationEnd animationend");
							if (!bOneTransitionFinished) {
								// the first one of both transitions finished
								bOneTransitionFinished = true;
							} else {
								// the second transition now also finished => clean up the style classes
								bTransitionEndPending = false;
								oToPage.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext");
								oFromPage.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious");
								!isAndroid23 && that.$().removeClass("sapMNavDoor");

								// notify the NavContainer that the animation is complete
								fCallback();
							}
						};

						oFromPage.$().bind("webkitAnimationEnd animationend", fAfterTransition);
						oToPage.$().bind("webkitAnimationEnd animationend", fAfterTransition);

						// set the new style classes that represent the end state (and thus start the transition)
						oToPage.addStyleClass("sapMNavItemDooring");
						oFromPage.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");

						window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
							if (bTransitionEndPending) {
								bOneTransitionFinished = true;
								fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
							}
						}, 1000);

					}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few#
				}, 0);
			},

			back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				var that = this,
					isAndroid23 = (sap.ui.Device.os.android && sap.ui.Device.os.version === 2.3);

				// if not Android2.3 then add perspective styles to NavContainer
				!isAndroid23 && that.$().addClass("sapMNavDoor");

				// set the style classes that represent the initial state
				oToPage.addStyleClass("sapMNavItemDoorOutNext");     // the page to navigate back to should be placed just left of the visible area
				oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called

				// iPhone needs some time... there is no animation without waiting
				window.setTimeout(function() {

					var bOneTransitionFinished = false;
					var bTransitionEndPending = true;
					var fAfterTransition = null; // make Eclipse aware that this variable is defined
					fAfterTransition = function() {
						jQuery(this).unbind("webkitAnimationEnd animationend");
						if (!bOneTransitionFinished) {
							// the first one of both transitions finished
							bOneTransitionFinished = true;
						} else {
							// the second transition now also finished =>  clean up the style classes
							bTransitionEndPending = false;
							oToPage.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext");
							oFromPage.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious");
							!isAndroid23 && that.$().removeClass("sapMNavDoor");

							// notify the NavContainer that the animation is complete
							fCallback();
						}
					};

					oFromPage.$().bind("webkitAnimationEnd animationend", fAfterTransition);
					oToPage.$().bind("webkitAnimationEnd animationend", fAfterTransition);

					// set the new style classes that represent the end state (and thus start the transition)
					oToPage.addStyleClass("sapMNavItemDooring"); // transition from left position to normal/center position starts now
					oFromPage.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious"); // transition from normal position to right position starts now

					window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
						if (bTransitionEndPending) {
							bOneTransitionFinished = true;
							fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
						}
					}, 1000);

				}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few
			}
		};

	} else { // no CSS transitions, IE9 support
		NavContainer.transitions["door"] = NavContainer.transitions["slide"];
	}



	/**
	 * Adds a custom transition to the NavContainer type (not to a particular instance!). The transition is identified by a "name". Make sure to only use names that will not collide with transitions which may be added to the NavContainer later. A suggestion is to use the prefix "c_" or "_" for your custom transitions to ensure this.
	 *
	 * "to" and "back" are the transition functions for the forward and backward navigation.
	 * Both will be called with the following parameters:
	 * - oFromPage: the Control which is currently being displayed by the NavContainer
	 * - oToPage: the Control which should be displayed by the NavContainer after the transition
	 * - fCallback: a function which MUST be called when the transition has completed
	 * - oTransitionParameters: a data object that can be given by application code when triggering the transition by calling to() or back(); this object could give additional information to the transition function, like the DOM element which triggered the transition or the desired transition duration
	 *
	 * The contract for "to" and "back" is that they may do an animation of their choice, but it should not take "too long". At the beginning of the transition the target page "oToPage" does have the CSS class "sapMNavItemHidden" which initially hides the target page (visibility:hidden). The transition can do any preparation (e.g. move that page out of the screen or make it transparent) and then should remove this CSS class.
	 * After the animation the target page "oToPage" should cover the entire screen and the source page "oFromPage" should not be visible anymore. This page should then have the CSS class "sapMNavItemHidden".
	 * For adding/removing this or other CSS classes, the transition can use the addStyleClass/removeStyleClass method:
	 * oFromPage.addStyleClass("sapMNavItemHidden");
	 * When the transition is complete, it MUST call the given fCallback method to inform the NavContainer that navigation has finished!
	 *
	 * Hint: if the target page of your transition stays black on iPhone, try wrapping the animation start into a
	 * setTimeout(..., 0)
	 * block (delayed, but without waiting).
	 *
	 * This method can be called on any NavContainer instance or statically on the sap.m.NavContainer type. However, the transition will always be registered for the type (and ALL instances), not for the single instance on which this method was invoked.
	 *
	 * Returns the sap.m.NavContainer type if called statically, or "this" (to allow method chaining) if called on a particular NavContainer instance.
	 *
	 * @param {string} sName
	 *         The name of the transition. This name can be used by the application to choose this transition when navigating "to()" or "back()": the "transitionName" parameter of "NavContainer.to()" corresponds to this name, the back() navigation will automatically use the same transition.
	 *
	 *         Make sure to only use names that will not collide with transitions which may be added to the NavContainer later. A suggestion is to use the prefix "c_" or "_" for your custom transitions to ensure this.
	 * @param {object} oTo
	 *         The function which will be called by the NavContainer when the application navigates "to()", using this animation's name. The NavContainer instance is the "this" context within the animation function.
	 *
	 *         See the documentation of NavContainer.addCustomTransitions for more details about this function.
	 * @param {object} oBack
	 *         The function which will be called by the NavContainer when the application navigates "back()" from a page where it had navigated to using this animation's name. The NavContainer instance is the "this" context within the animation function.
	 *
	 *         See the documentation of NavContainer.addCustomTransitions for more details about this function.
	 * @type sap.m.NavContainer
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavContainer.prototype.addCustomTransition = function(sName, fTo, fBack) {
		if (NavContainer.transitions[sName]) {
			jQuery.sap.log.warning("Transition with name " + sName + " already exists in " + this + ". It is now being replaced by custom transition.");
		}

		NavContainer.transitions[sName] = {to:fTo, back:fBack};
		return this;
	};
	NavContainer.addCustomTransition = NavContainer.prototype.addCustomTransition;



	// ----------------- code for tracking and avoiding invalidation --------------------------

	/**
	 * Forces invalidation and rerendering (.invalidate() is disabled)
	 * @private
	 */
	NavContainer.prototype.forceInvalidation = NavContainer.prototype.invalidate;

	NavContainer.prototype.invalidate = function(oSource) {

		/*eslint-disable no-empty */
		if (oSource == this) {
		/*eslint-enable no-empty */
			// does not happen because the source is only given when propagating to a parent

		} else if (!oSource) {
			// direct invalidation of the NavContainer; this means a property has been modified
			this.forceInvalidation(); // let invalidation occur

		} else if (oSource instanceof Control) {
			// an aggregated control is invalidated
			var bIsInPages = false,
				aPages = this.getPages(),
				l = aPages.length;

			for (var i = 0; i < l; i++) {
				if (aPages[i] === oSource) {
					bIsInPages = true;
					break;
				}
			}

			if (!bIsInPages || oSource.getId() === this.getCurrentPage()) {
				// TODO: there will be more cases where invalidation is not required...
				this.forceInvalidation();
			} // else : the invalidation source is a non-current page, so do not rerender anything

		} else {
			// TODO: which cases are ending up here?
			this.forceInvalidation();

		}
	};

	NavContainer.prototype.removePage = function(oPage) {
		oPage = this.removeAggregation("pages", oPage);

		this._onPageRemoved(oPage);

		return oPage;
	};

	NavContainer.prototype._onPageRemoved = function (oPage) {
		if (!oPage) {
			return;
		}

		// remove the dom because if you remove the hidden class, the page will get visible until the rerendering of the navContainer - causes a flickering
		oPage.$().remove();

		// remove the style classes that might be added by the navContainer
		oPage.removeStyleClass("sapMNavItemHidden");
		oPage.removeStyleClass("sapMNavItem");

		var aStack = this._ensurePageStackInitialized();
		// Remove all occurences from the stack
		this._pageStack = aStack.filter(function (oPageStackInfo) {
			return oPage.getId() !== oPageStackInfo.id;
		});

	};

	NavContainer.prototype.removeAllPages = function() {
		var aPages = this.getPages();
		if (!aPages) {
			return [];
		}

		for (var i = 0; i < aPages.length; i++) {
			this._onPageRemoved(aPages[i]);
		}

		return this.removeAllAggregation("pages");
	};

	NavContainer.prototype.addPage = function(oPage) {
		var aPages = this.getPages();
		// Routing often adds an already existing page. ManagedObject would remove and re-add it because the order is affected,
		// but here the order does not matter, so just ignore the call in this case.
		if (jQuery.inArray(oPage, aPages) > -1) {
			return this;
		}

		this.addAggregation("pages", oPage, true);

		// sapMNavItem must be added after addAggregation is called because addAggregation can lead
		// to a removePage-call where the class is removed again.
		oPage.addStyleClass("sapMNavItem");
		var iPreviousPageCount = aPages.length;

		if (iPreviousPageCount === 0 && /* get the NEW pages count */ this.getPages().length === 1 && this.getDomRef()) { // the added page is the first and only page and has been newly added
			this._ensurePageStackInitialized();
			this.rerender();
		}

		return this;
	};

	NavContainer.prototype.insertPage = function(oPage, iIndex) {
		this.insertAggregation("pages", oPage, iIndex, true);

		// sapMNavItem must be added after addAggregation is called because addAggregation can lead
		// to a removePage-call where the class is removed again.
		oPage.addStyleClass("sapMNavItem");
		var iPreviousPageCount = this.getPages().length;

		if (iPreviousPageCount === 0 && this.getPages().length === 1 && this.getDomRef()) { // the added page is the first and only page and has been newly added
			this._ensurePageStackInitialized();
			this.rerender();
		}

		return this;
	};



	// documentation of the pseudo events (beforeShow, afterShow, beforeHide etc.)

	/**
	 * sap.m.NavContainerChild is an artificial interface with the only purpose to bear the documentation of
	 * pseudo events triggered by sap.m.NavContainer on its child controls when navigation occurs and child controls are displayed/hidden.
	 *
	 * Interested parties outside the child control can listen to one or more of these events by registering a Delegate:
	 * <pre>
	 * page1.addEventDelegate({
	 *    onBeforeShow: function(evt) {
	 *       // page1 is about to be shown; act accordingly - if required you can read event information from the evt object
	 *    },
	 *    onAfterHide: function(evt) {
	 *       // ...
	 *    }
	 * });
	 * </pre>
	 *
	 * @name sap.m.NavContainerChild
	 * @interface
	 * @public
	*/


	/**
	 * This event is fired before the NavContainer shows this child control for the first time.
	 * @event
	 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
	 * @param {object} oEvent.data the data object which has been passed with the "to" navigation, or an empty object
	 * @param {object} oEvent.backData the data object which has been passed with the back navigation, or an empty object
	 * @name sap.m.NavContainerChild.prototype.BeforeFirstShow
	 * @public
	*/

	/**
	 * This event is fired every time before the NavContainer shows this child control. In case of animated transitions this
	 * event is fired before the transition starts.
	 * @event
	 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
	 * @param {object} oEvent.data the data object which has been passed with the "to" navigation, or an empty object
	 * @param {object} oEvent.backData the data object which has been passed with the back navigation, or an empty object
	 * @name sap.m.NavContainerChild.prototype.BeforeShow
	 * @public
	*/

	/**
	 * This event is fired every time when the NavContainer has made this child control visible. In case of animated transitions this
	 * event is fired after the transition finishes. This control is now being displayed and not animated anymore.
	 * @event
	 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
	 * @param {object} oEvent.data the data object which has been passed with the "to" navigation, or an empty object
	 * @param {object} oEvent.backData the data object which has been passed with the back navigation, or an empty object
	 * @name sap.m.NavContainerChild.prototype.AfterShow
	 * @public
	*/

	/**
	 * This event is fired every time before the NavContainer hides this child control. In case of animated transitions this
	 * event is fired before the transition starts.
	 * @event
	 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
	 * @name sap.m.NavContainerChild.prototype.BeforeHide
	 * @public
	*/

	/**
	 * This event is fired every time when the NavContainer has made this child control invisible. In case of animated transitions this
	 * event is fired after the transition finishes. This control is now no longer being displayed and not animated anymore.
	 * @event
	 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
	 * @name sap.m.NavContainerChild.prototype.AfterHide
	 * @public
	*/


	return NavContainer;

}, /* bExport= */ true);

}; // end of sap/m/NavContainer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectAttribute') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.ObjectAttribute.
jQuery.sap.declare('sap.m.ObjectAttribute'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectAttribute",['jquery.sap.global', './library', 'sap/ui/core/Control'],
	function(jQuery, library, Control) {
	"use strict";



	/**
	 * Constructor for a new ObjectAttribute.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * ObjectAttribute displays a text field that can be normal or active. Object attribute fires a press event when the user selects active text.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.12
	 * @alias sap.m.ObjectAttribute
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectAttribute = Control.extend("sap.m.ObjectAttribute", /** @lends sap.m.ObjectAttribute.prototype */ { metadata : {

		library : "sap.m",
		properties : {

			/**
			 * The object attribute title.
			 */
			title : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * The object attribute text.
			 */
			text : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Indicates if the object attribute text is selectable by the user.
			 */
			active : {type : "boolean", group : "Misc", defaultValue : null},

			/**
			 * Determines the direction of the text, not including the title.
			 * Available options for the text direction are LTR (left-to-right) and RTL (right-to-left). By default the control inherits the text direction from its parent control.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit}
		},
		aggregations : {

			/**
			 * Text control to display title and text property
			 */
			_textControl : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}
		},
		events : {

			/**
			 * Event is fired when the user clicks active text
			 */
			press : {
				parameters : {

					/**
					 * Dom reference of the object attributes' text to be used for positioning.
					 */
					domRef : {type : "string"}
				}
			}
		}
	}});

	///**
	// * This file defines behavior for the control,
	// */

	/**
	 *  Initialize member variables
	 *
	 * @private
	 */
	ObjectAttribute.prototype.init = function() {
		this.setAggregation('_textControl', new sap.m.Text());
	};

	/**
	 * Delivers text control with updated title, text and maxLines property
	 *
	 * @private
	 */
	ObjectAttribute.prototype._getUpdatedTextControl = function() {
		var oTextControl = this.getAggregation('_textControl');
		var sTextDir = this.getTextDirection();
		var oParent = this.getParent();
		var bPageRTL = sap.ui.getCore().getConfiguration().getRTL();
		var oMaxLinesConst = {
			singleLine : 1,
			multiLine : 2
		};
		var iMaxLines = oMaxLinesConst.multiLine;
		var oppositeDirectionMarker = '';
		if (sTextDir === sap.ui.core.TextDirection.LTR && bPageRTL) {
			oppositeDirectionMarker = '\u200e';
		}
		if (sTextDir === sap.ui.core.TextDirection.RTL && !bPageRTL) {
			oppositeDirectionMarker = '\u200f';
		}

		oTextControl.setProperty('text', (this.getTitle() ? this.getTitle() + ": " : "") + oppositeDirectionMarker + this.getText() + oppositeDirectionMarker, true);
		//if attribute is used inside responsive ObjectHeader or in ObjectListItem - only 1 line
		if (oParent && ((oParent instanceof sap.m.ObjectHeader && oParent.getResponsive()) || oParent instanceof sap.m.ObjectListItem)) {
			iMaxLines = oMaxLinesConst.singleLine;
		}
		oTextControl.setProperty('maxLines', iMaxLines, true);
		return oTextControl;
	};

	/**
	 * @private
	 */
	ObjectAttribute.prototype.ontap = function(oEvent) {
		//event should only be fired if the click is on the text
		if (!!this.getActive() && (oEvent.target.id != this.getId())) {
			this.firePress({
				domRef : this.getDomRef()
			});
		}
	};

	/**
	 * @private
	 */
	sap.m.ObjectAttribute.prototype.onsapenter = function(oEvent) {
		if (!!this.getActive()) {
			this.firePress({
				domRef : this.getDomRef()
			});
		}
	};

	/**
	 * @private
	 */
	sap.m.ObjectAttribute.prototype.onsapspace = function(oEvent) {
		this.onsapenter(oEvent);
	};

	/**
	 * See 'return'.
	 *
	 * @private
	 * @returns {boolean} true if attribute's text is empty or only consists of whitespaces.
	 */
	ObjectAttribute.prototype._isEmpty = function() {
		return !(this.getText().trim() || this.getTitle().trim());
	};

	/**
	 * Function is called when the control is touched.
	 *
	 * @private
	 */
	ObjectAttribute.prototype.ontouchstart = function(oEvent) {
		if (!!this.getActive()) {
			// for control who need to know if they should handle events from the ObjectAttribute control
			oEvent.originalEvent._sapui_handledByControl = true;
		}
	};

	/**
	 * Defines to which DOM reference the Popup should be docked
	 *
	 * @protected
	 * @return {DomNode} the DOM reference that Popup should dock to
	 */
	ObjectAttribute.prototype.getPopupAnchorDomRef = function() {
		return this.getDomRef("text");
	};


	return ObjectAttribute;

}, /* bExport= */ true);

}; // end of sap/m/ObjectAttribute.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectHeader') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.ObjectHeader.
jQuery.sap.declare('sap.m.ObjectHeader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectHeader",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/IconPool'],
	function(jQuery, library, Control, IconPool) {
	"use strict";



	/**
	 * Constructor for a new ObjectHeader.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * ObjectHeader is a display control that enables the user to easily identify a specific object. The object header title is the key identifier of the object and additional text and icons can be used to further distinguish it from other objects.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.12
	 * @alias sap.m.ObjectHeader
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectHeader = Control.extend("sap.m.ObjectHeader", /** @lends sap.m.ObjectHeader.prototype */ { metadata : {

		library : "sap.m",
		properties : {

			/**
			 * Object header title
			 */
			title : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Object header number field
			 */
			number : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Object header number units qualifier.
			 */
			numberUnit : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Introductory text for the object header.
			 */
			intro : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Indicates that the intro is clickable
			 */
			introActive : {type : "boolean", group : "Misc", defaultValue : null},

			/**
			 * Indicates that the title is clickable
			 */
			titleActive : {type : "boolean", group : "Misc", defaultValue : null},

			/**
			 * Object header icon
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},

			/**
			 * Indicates that the object header icon is clickable
			 */
			iconActive : {type : "boolean", group : "Misc", defaultValue : null},

			/**
			 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
			 *
			 * If bandwidth is the key for the application, set this value to false.
			 */
			iconDensityAware : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Set the favorite state to true or false. The showMarkers property must be true for this property to take effect.
			 * @since 1.16.0
			 */
			markFavorite : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Set the flagged state to true or false. The showMarkers property must be true for this property to take effect.
			 * @since 1.16.0
			 */
			markFlagged : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Indicates if object header supports showing markers such as flagged and favorite.
			 * @since 1.16.0
			 */
			showMarkers : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * When it is true, the selector arrow icon/image is shown and can be pressed.
			 * @since 1.16.0
			 */
			showTitleSelector : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Object header number and numberUnit value state.
			 * @since 1.16.0
			 */
			numberState : {type : "sap.ui.core.ValueState", group : "Misc", defaultValue : sap.ui.core.ValueState.None},

			/**
			 * Displays the condensed object header with title, one attribute, number and number unit.
			 */
			condensed : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * NOTE: Only applied if you set "condensed=true" or "responsive=true".
			 * This property is used to set the background color of the ObjectHeader. Possible values are "Solid", "Translucent" and "Transparent".
			 */
			backgroundDesign : {type : "sap.m.BackgroundDesign", group : "Appearance", defaultValue : sap.m.BackgroundDesign.Transparent},

			/**
			 * If this property is set to true the ObjectHeader is rendered with a different design and reacts responsively to the screen sizes.
			 * Be aware that the design and behavior of the responsive ObjectHeader can change without further notification.
			 * @since 1.21.1
			 */
			responsive : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * NOTE: Only applied if you set "responsive=true".
			 * If this property is set to true, the control occupies the available screen area so that the contents are arranged in a different way to fit in that area.
			 * If it is set to false, the control is optimized for the master detail view.
			 * @since 1.28
			 */
			fullScreenOptimized : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * The title link target URI. Supports standard hyperlink behavior. If an action should be triggered, this should not be set, but instead an event handler for the "titlePress" event should be registered.
			 * @since 1.28
			 */
			titleHref : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},

			/**
			 * Options are _self, _top, _blank, _parent, _search. Alternatively, a frame name can be entered.
			 * @since 1.28
			 */
			titleTarget : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * The intro link target URI. Supports standard hyperlink behavior. If an action should be triggered, this should not be set, but instead an event handler for the "introPress" event should be registered.
			 * @since 1.28
			 */
			introHref : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},

			/**
			 * Options are _self, _top, _blank, _parent, _search. Alternatively, a frame name can be entered.
			 * @since 1.28
			 */
			introTarget : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * This property specifies the title text directionality with enumerated options. By default, the control inherits text direction from the DOM.
			 * @since 1.28.0
			 */
			titleTextDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},

			/**
			 * This property specifies the intro text directionality with enumerated options. By default, the control inherits text direction from the DOM.
			 * @since 1.28.0
			 */
			introTextDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},

			/**
			 * This property specifies the number and unit directionality with enumerated options. By default, the control inherits text direction from the DOM.
			 * @since 1.28.0
			 */
			numberTextDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit}

		},
		defaultAggregation : "attributes",
		aggregations : {

			/**
			 * The list of Object Attributes
			 */
			attributes : {type : "sap.m.ObjectAttribute", multiple : true, singularName : "attribute"},

			/**
			 * First status shown on the right side of the attributes above the second status.
			 * If it is not set the first attribute will expand to take the entire row.
			 * @deprecated Since version 1.16.0.
			 * Use the statuses aggregation instead.
			 */
			firstStatus : {type : "sap.m.ObjectStatus", multiple : false, deprecated: true},

			/**
			 * Second status shown on the right side of the attributes below the first status.
			 * If it is not set the second attribute will expand to take the entire row.
			 * @deprecated Since version 1.16.0.
			 * Use the statuses aggregation instead.
			 */
			secondStatus : {type : "sap.m.ObjectStatus", multiple : false, deprecated: true},

			/**
			 * The list of Object sap.ui.core.Control. It will only allow sap.m.ObjectStatus and sap.m.ProgressIndicator controls.
			 * @since 1.16.0
			 */
			statuses : {type : "sap.ui.core.Control", multiple : true, singularName : "status"},

			/**
			 * The object number and unit are managed in this aggregation
			 */
			_objectNumber : {type : "sap.m.ObjectNumber", multiple : false, visibility : "hidden"},

			/**
			 * This aggregation takes only effect when you set "responsive" to true.
			 * It can either be filled with an sap.m.IconTabBar or a sap.suite.ui.commons.HeaderContainer control. Overflow handling must be taken care of by the inner control. If used with an IconTabBar control, only the header will be displayed inside the object header, the content will be displayed below the ObjectHeader.
			 * @since 1.21.1
			 */
			headerContainer : {type : "sap.m.ObjectHeaderContainer", multiple : false}
		},
		associations : {

			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy: {type: "sap.ui.core.Control", multiple: true, singularName: "ariaDescribedBy"},

			/**
			 * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
			 */
			ariaLabelledBy: {type: "sap.ui.core.Control", multiple: true, singularName: "ariaLabelledBy"}
		},
		events : {

			/**
			 * Event is fired when the title is active and the user tap/click on it
			 */
			titlePress : {
				parameters : {

					/**
					 * Dom reference of the object header' title to be used for positioning.
					 */
					domRef : {type : "object"}
				}
			},

			/**
			 * Event is fired when the title is active and the user tap/click on it
			 */
			introPress : {
				parameters : {

					/**
					 * Dom reference of the object header' intro to be used for positioning.
					 */
					domRef : {type : "object"}
				}
			},

			/**
			 * Event is fired when the title icon is active and the user tap/click on it
			 */
			iconPress : {
				parameters : {

					/**
					 * Dom reference of the object header' icon to be used for positioning.
					 */
					domRef : {type : "object"}
				}
			},

			/**
			 * Event is fired when the object header title selector (down-arrow) is pressed
			 * @since 1.16.0
			 */
			titleSelectorPress : {
				parameters : {

					/**
					 * Dom reference of the object header' titleArrow to be used for positioning.
					 */
					domRef : {type : "object"}
				}
			}
		}
	}});

	ObjectHeader.prototype.init = function() {
		var that = this;

		//TODO Remove placeholder when Safari iconFont issue is addressed.
		this._oPlaceholderIcon = IconPool.createControlByURI({
			id : this.getId() + "-placeholder",
			src : IconPool.getIconURI("fridge")
		});
		this._oPlaceholderIcon.addStyleClass("sapMObjStatusMarkerInvisible");

		this._oFlagIcon = IconPool.createControlByURI({
			id : this.getId() + "-flag",
			src : IconPool.getIconURI("flag"),
			visible : false
		});

		this._oFavIcon = IconPool.createControlByURI({
			id : this.getId() + "-favorite",
			src : IconPool.getIconURI("favorite"),
			visible : false
		});

		this._oTitleArrowIcon = IconPool.createControlByURI({
			id : this.getId() + "-titleArrow",
			src: IconPool.getIconURI("arrow-down"),
			decorative: false,
			visible : false,
			size: "1.375rem",
			press : function(oEvent) {
				that.fireTitleSelectorPress({
					domRef : this.getDomRef()
				});
			}
		});

		this._fNumberWidth = undefined;
		this._titleText = new sap.m.Text(this.getId() + "-titleText");
		this._titleText.setMaxLines(3);

	};

	/**
	 * Set the condensed flag
	 * @override
	 * @public
	 * @param {boolean} bCondensed the new value
	 * @returns {sap.m.ObjectHeader} this pointer for chaining
	 */
	ObjectHeader.prototype.setCondensed = function (bCondensed) {
		this.setProperty("condensed", bCondensed);
		if (this.getCondensed()) {
			this._oTitleArrowIcon.setSize("1rem");
		} else {
			this._oTitleArrowIcon.setSize("1.375rem");
		}
		
		return this;
	};

	/**
	 * Set the number value to the internal aggregation
	 * @override
	 * @public
	 * @param {string} sNumber the new value
	 * @returns {sap.m.ObjectHeader} this pointer for chaining
	 */
	ObjectHeader.prototype.setNumber = function (sNumber) {
		this.setProperty("number", sNumber);
		this._getObjectNumber().setNumber(sNumber);
		return this;
	};

	/**
	 * Set the number unit to the internal aggregation
	 * @override
	 * @public
	 * @param {string} sUnit the new value
	 * @returns {sap.m.ObjectHeader} this pointer for chaining
	 */
	ObjectHeader.prototype.setNumberUnit = function (sUnit) {
		this.setProperty("numberUnit", sUnit);
		this._getObjectNumber().setUnit(sUnit);
		return this;
	};

	/**
	 * Set the number state to the internal aggregation
	 * @override
	 * @public
	 * @param {sap.ui.core.ValueState} sState the new value
	 * @returns {sap.m.ObjectHeader} this pointer for chaining
	 */
	ObjectHeader.prototype.setNumberState = function (sState) {
		this.setProperty("numberState", sState, true);
		this._getObjectNumber().setState(sState);
		return this;
	};

	/**
	 * lazy initializes the object number aggregation
	 * @private
	 * @returns {Object} the newly created control
	 */
	ObjectHeader.prototype._getObjectNumber = function () {
		var oControl = this.getAggregation("_objectNumber");

		if (!oControl) {
			oControl = new sap.m.ObjectNumber(this.getId() + "-number", {
				emphasized: false
			});

			this.setAggregation("_objectNumber", oControl, true);
		}
		return oControl;
	};

	ObjectHeader.prototype.ontap = function(oEvent) {
		var sSourceId = oEvent.target.id;
		if (this.getIntroActive() && sSourceId === this.getId() + "-intro") {
			if (!this.getIntroHref()) {
				this.fireIntroPress({
					domRef : jQuery.sap.domById(sSourceId)
				});
			}
		} else if (!this.getResponsive() && this.getTitleActive() && ( sSourceId === this.getId() + "-title" ||
				jQuery(oEvent.target).parent().attr('id') === this.getId() + "-title" || // check if the parent of the "h" tag is the "title"
				sSourceId === this.getId() + "-titleText-inner" )) {
			if (!this.getTitleHref()) {
				oEvent.preventDefault();
				sSourceId = this.getId() + "-title";

				this.fireTitlePress({
					domRef : jQuery.sap.domById(sSourceId)
				});
			}
		} else if (this.getResponsive() && this.getTitleActive() && ( sSourceId === this.getId() + "-txt" || jQuery(oEvent.target).parent().attr('id') === this.getId() + "-txt" )) {
			if (!this.getTitleHref()) {
				oEvent.preventDefault();
				// The sourceId should be always the id of the "a", even if we click on the inside span element
				sSourceId = this.getId() + "-txt";

				this.fireTitlePress({
					domRef : jQuery.sap.domById(sSourceId)
				});
			}
		} else if (this.getIconActive() && (sSourceId === this.getId() + "-img" || sSourceId === this.getId() + "-icon")) {
			this.fireIconPress({
				domRef : jQuery.sap.domById(sSourceId)
			});
		}
	};

	/**
	 * Handles space or enter key
	 *
	 * @private
	 */
	ObjectHeader.prototype._handleSpaceOrEnter = function(oEvent) {
		var sSourceId = oEvent.target.id;

		if (!this.getResponsive() && this.getTitleActive() && ( sSourceId === this.getId() + "-title" || 
				jQuery(oEvent.target).parent().attr('id') === this.getId() + "-title" || // check if the parent of the "h" tag is the "title"
				sSourceId === this.getId() + "-titleText-inner" )) {
			if (oEvent.type === "sapspace") {
				oEvent.preventDefault();
			}
			sSourceId = this.getId() + "-title";

			if (!this.getTitleHref()) {
				oEvent.preventDefault();
				this.fireTitlePress({
					domRef : jQuery.sap.domById(sSourceId)
				});
			} else {
				if (oEvent.type === "sapspace") {
					this._linkClick(oEvent, sSourceId);
				}
			}
		} else if (this.getResponsive() && this.getTitleActive() && ( sSourceId === this.getId() + "-txt" || jQuery(oEvent.target).parent().attr('id') === this.getId() + "-txt" )) {
			if (oEvent.type === "sapspace") {
				oEvent.preventDefault();
			}
			// The sourceId should be always the id of the "a", even if we click on the inside span element
			sSourceId = jQuery(oEvent.target).parent().attr('id');

			if (!this.getTitleHref()) {
				oEvent.preventDefault();
				this.fireTitlePress({
					domRef : jQuery.sap.domById(sSourceId)
				});
			} else {
				if (oEvent.type === "sapspace") {
					this._linkClick(oEvent, sSourceId);
				}
			}
		} else if (this.getIntroActive() && sSourceId === this.getId() + "-intro") {
			if (oEvent.type === "sapspace") {
				oEvent.preventDefault();
			}
			if (!this.getIntroHref()) {
				this.fireIntroPress({
					domRef : jQuery.sap.domById(sSourceId)
				});
			}
		} else if (this.getIconActive() && jQuery(oEvent.target).hasClass('sapMOHIcon')){
			if (oEvent.type === "sapspace") {
				oEvent.preventDefault();
			}

			var iconOrImg = jQuery.sap.domById(this.getId() + "-icon");
			if (!iconOrImg) {
				iconOrImg = jQuery.sap.domById(this.getId() + "-img");
			}

			this.fireIconPress({
				domRef : iconOrImg
			});
		}
	};

	/**
	 * Handles space key
	 *
	 * @private
	*/
	ObjectHeader.prototype.onsapspace = ObjectHeader.prototype._handleSpaceOrEnter;

	/**
	 * Handles enter key
	 *
	 * @private
	 */
	ObjectHeader.prototype.onsapenter = ObjectHeader.prototype._handleSpaceOrEnter;

	/**
	 * Handle link behaviour of the link and title when are active
	 *
	 * @private
	 */
	ObjectHeader.prototype._linkClick = function(oEvent, sSourceId) {
		// mark the event for components that needs to know if the event was handled
		oEvent.setMarked();

		// When there is the normal browser link, the browser does the job. According to the keyboard specification, Space should do the same as Enter or Click.
		// To make the browser REALLY do the same (history, referrer, frames, target,...), create a new "click" event and let the browser "do the needful".
		var oClickEvent = document.createEvent('MouseEvents');
		oClickEvent.initEvent('click', false, true); //event type, non-bubbling, cancelable
		jQuery.sap.domById(sSourceId).dispatchEvent(oClickEvent);
	};

	/**
	 * The title or states are rendered in a different way depending of the device
	 * when the orientation is changed
	 *
	 * @private
	 */
	ObjectHeader.prototype._onOrientationChange = function() {
		var sId = this.getId();

		if (sap.ui.Device.system.tablet && this.getFullScreenOptimized() && (this._hasAttributes() || this._hasStatus())){
			this._rerenderStates();
		}

		if (sap.ui.Device.system.phone) {

			if (sap.ui.Device.orientation.portrait){

				if (this.getTitle().length > 50) { // if on phone portrait mode, cut the title to 50 characters
					this._rerenderTitle(50);
				}

				if (this.getIcon()){
					jQuery.sap.byId(sId + "-titlediv").removeClass("sapMOHRTitleIcon");
					jQuery.sap.byId(sId + "-titleIcon").addClass("sapMOHRHideIcon");
				}
			} else {
				if (sap.ui.Device.orientation.landscape) {

					if (this.getTitle().length > 80) { // if on phone landscape mode, cut the title to 80 characters
						this._rerenderTitle(80);
					}
					if (this.getIcon()){
						jQuery.sap.byId(sId + "-titlediv").addClass("sapMOHRTitleIcon");
						jQuery.sap.byId(sId + "-titleIcon").removeClass("sapMOHRHideIcon");
					}
				}
			}
			this._adjustNumberDiv();
		}
		this._adjustIntroDiv();
	};

	/**
	 * Called on orientation change to rerender the title.
	 * nCutLen - the number of the characters to which the title should be cut
	 * according to the design specification (80 or 50 chars)
	 *
	 * @private
	 */
	ObjectHeader.prototype._rerenderTitle = function(nCutLen) {
		var oRm = sap.ui.getCore().createRenderManager();
		this.getRenderer()._rerenderTitle(oRm, this, nCutLen);
		oRm.destroy();
	};

	/**
	 * Called on orientation changed to rerender states.
	 *
	 * @private
	 */
	ObjectHeader.prototype._rerenderStates = function() {
		var oRm = sap.ui.getCore().createRenderManager();
		this.getRenderer()._rerenderResponsiveStates(oRm, this);
		oRm.destroy();
	};

	/**
	 * Called when the control is destroyed.
	 *
	 * @private
	 */
	ObjectHeader.prototype.exit = function() {
		if (sap.ui.Device.system.desktop) {
			sap.ui.Device.media.detachHandler(this._rerenderOH, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
		}

		if (sap.ui.Device.system.tablet || sap.ui.Device.system.phone) {
			sap.ui.Device.orientation.detachHandler(this._onOrientationChange, this);
		}

		if (this._oImageControl) {
			this._oImageControl.destroy();
			this._oImageControl = undefined;
		}

		if (this._oPlaceholderIcon) {
			this._oPlaceholderIcon.destroy();
			this._oPlaceholderIcon = undefined;
		}

		if (this._oFavIcon) {
			this._oFavIcon.destroy();
			this._oFavIcon = undefined;
		}

		if (this._oFlagIcon) {
			this._oFlagIcon.destroy();
			this._oFlagIcon = undefined;
		}

		if (this._oTitleArrowIcon) {
			this._oTitleArrowIcon.destroy();
			this._oTitleArrowIcon = undefined;
		}

		if (this._titleText) {
			this._titleText.destroy();
			this._titleText = undefined;
		}

		if (this._introText) {
			this._introText.destroy();
			this._introText = undefined;
		}
	};

	/**
	 * Lazy load object header's image.
	 *
	 * @private
	 */
	ObjectHeader.prototype._getImageControl = function() {
		var sImgId = this.getId() + "-img";
		var sSize = "2.5rem";
		var sHeight = "3rem";
		var sWidth = "3rem";

		var mProperties = jQuery.extend(
				{
					src : this.getIcon(),
					densityAware : this.getIconDensityAware()
				},
					IconPool.isIconURI(this.getIcon()) ? 
						{ size : sSize } : {height : sHeight, width : sWidth }
		);

		this._oImageControl = sap.m.ImageHelper.getImageControl(sImgId, this._oImageControl, this, mProperties);

		return this._oImageControl;
	};

	ObjectHeader.prototype.onBeforeRendering = function() {
		if (sap.ui.Device.system.tablet || sap.ui.Device.system.phone) {
			sap.ui.Device.orientation.detachHandler(this._onOrientationChange, this);
		}
		if (sap.ui.Device.system.desktop) {
			sap.ui.Device.media.detachHandler(this._rerenderOHR, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
		}

		if (this._introText) {
			this._introText.destroy();
			this._introText = undefined;
		}
	};

	ObjectHeader.prototype.onAfterRendering = function() {
		var oObjectNumber = this.getAggregation("_objectNumber");
		var bPageRTL = sap.ui.getCore().getConfiguration().getRTL();
		var $titleArrow = jQuery.sap.byId(this.getId() + "-titleArrow");

		$titleArrow.attr("aria-haspopup", "true");
		$titleArrow.attr("role", "link");
		$titleArrow.attr("aria-label", sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("OH_ARIA_SELECT_ARROW_VALUE")); // set label from resource translation bundle
		
		if (this.getResponsive()) {
			this._adjustIntroDiv();

			if (oObjectNumber && oObjectNumber.getNumber()) {// adjust alignment according the design specification
				if (sap.ui.Device.system.desktop && jQuery('html').hasClass("sapUiMedia-Std-Desktop") && this.getFullScreenOptimized() && this._iCountVisAttrStat >= 1 && this._iCountVisAttrStat <= 3) {
					oObjectNumber.setTextAlign(bPageRTL ? sap.ui.core.TextAlign.Right : sap.ui.core.TextAlign.Left);
				} else {
					oObjectNumber.setTextAlign(bPageRTL ? sap.ui.core.TextAlign.Left : sap.ui.core.TextAlign.Right);
				}
			}
			// adjust number div after initial alignment
			this._adjustNumberDiv();
			
			// watch for orientation change only on tablet and phone
			if (sap.ui.Device.system.tablet || sap.ui.Device.system.phone) {
				sap.ui.Device.orientation.attachHandler(this._onOrientationChange, this);
			}

			// When size of the browser window is changed and sap ui media query is changed rerender Responsive OH
			if (sap.ui.Device.system.desktop) {
				sap.ui.Device.media.attachHandler(this._rerenderOHR, this, sap.ui.Device.media.RANGESETS.SAP_STANDARD);
			}
		} else {
			if (oObjectNumber && oObjectNumber.getNumber()) { // adjust alignment according the design specification
				oObjectNumber.setTextAlign(bPageRTL ? sap.ui.core.TextAlign.Left : sap.ui.core.TextAlign.Right);
			}
		}
	};

	/**
	 * Called on device media changed to rerender the OHR accordingly.
	 *
	 * @private
	 */
	ObjectHeader.prototype._rerenderOHR = function() {
		this.invalidate();
	};

	/**
	 * Adjust Number div depending on it's size
	 *
	 * @private
	 */
	ObjectHeader.prototype._adjustNumberDiv = function() {
		var sId = this.getId();
		var oObjectNumber = this.getAggregation("_objectNumber");
		var bPageRTL = sap.ui.getCore().getConfiguration().getRTL();

		if (oObjectNumber && oObjectNumber.getNumber()) {
			var $numberDiv = jQuery.sap.byId(sId + "-number");
			var $titleDiv = jQuery.sap.byId(sId + "-titlediv");

			if (sap.ui.Device.system.phone || (sap.ui.Device.system.desktop && jQuery('html').hasClass("sapUiMedia-Std-Phone"))) {
				if ($numberDiv.hasClass("sapMObjectNumberBelowTitle")) {
					// change alignment to fit the design depending
					oObjectNumber.setTextAlign(bPageRTL ? sap.ui.core.TextAlign.Left : sap.ui.core.TextAlign.Right);
					$numberDiv.removeClass("sapMObjectNumberBelowTitle");
					$titleDiv.removeClass("sapMOHRTitleDivFull");
				}

				var nParentWidth40 = $numberDiv.parent().width() * 0.4; //calculate 40% number div in pixels

				if ($numberDiv.outerWidth() > nParentWidth40) {
					// change alignment to fit the design
					oObjectNumber.setTextAlign(bPageRTL ? sap.ui.core.TextAlign.Right : sap.ui.core.TextAlign.Left);
					$numberDiv.addClass("sapMObjectNumberBelowTitle");
					$titleDiv.addClass("sapMOHRTitleDivFull");
				}
			}
		}
	};

	/**
	 * Adjust margin of the Intro div depending on size of the title and title arrow
	 *
	 * @private
	 */
	ObjectHeader.prototype._adjustIntroDiv = function() {
		var sId = this.getId();
		var $titleTxt = jQuery.sap.byId(sId + "-txt");
		var $titleArrow = jQuery.sap.byId(sId + "-titleArrow");
		var $intro = jQuery.sap.byId(sId + "-intro");

		if ($intro.parent().hasClass("sapMOHRIntroMargin")) {
			$intro.parent().removeClass("sapMOHRIntroMargin");
		}

		if ($titleArrow.height() !== null && ($titleTxt.height() < $titleArrow.height())) {
			$intro.parent().addClass("sapMOHRIntroMargin");
		}
	};


	/**
	 * @param [string]
	 *            sId control id to be escaped
	 * @returns escaped control id with "#" prefix
	 * @private
	 */
	ObjectHeader._escapeId = function(sId) {
		return sId ? "#" + sId.replace(/(:|\.)/g, '\\$1') : "";
	};

	/**
	 * @private
	 * @returns {boolean}
	 */
	ObjectHeader.prototype._hasBottomContent = function() {
		return (this._hasAttributes() || this._hasStatus() || this.getShowMarkers());
	};

	/**
	 * @private
	 * @returns {boolean}
	 */
	ObjectHeader.prototype._hasIcon = function() {
		return !!this.getIcon().trim();
	};

	/**
	 * @private
	 * @returns {boolean}
	 */
	ObjectHeader.prototype._hasAttributes = function() {
		var attributes = this.getAttributes();
		if (attributes && attributes.length > 0) {
			for ( var i = 0; i < attributes.length; i++) {
				if (!attributes[i]._isEmpty()) {
					return true;
				}
			}
		}
		return false;
	};

	/**
	 * @private
	 * @returns {boolean}
	 */
	ObjectHeader.prototype._hasStatus = function() {
		var bHasStatus = ((this.getFirstStatus() && !this.getFirstStatus()._isEmpty()) || (this.getSecondStatus() && !this.getSecondStatus()._isEmpty()));

		if (!bHasStatus && this.getStatuses() && this.getStatuses().length > 0) {
			var statuses = this.getStatuses();
			for ( var i = 0; i < statuses.length; i++) {
				if (statuses[i] instanceof sap.m.ObjectStatus && !statuses[i]._isEmpty()) {
					bHasStatus = true;
					break;
				} else if (statuses[i] instanceof sap.m.ProgressIndicator) {
					bHasStatus = true;
					break;
				}
			}
		}
		return bHasStatus;
	};


	return ObjectHeader;

}, /* bExport= */ true);

}; // end of sap/m/ObjectHeader.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectIdentifier') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.ObjectIdentifier.
jQuery.sap.declare('sap.m.ObjectIdentifier'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectIdentifier",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/IconPool'],
	function(jQuery, library, Control, IconPool) {
	"use strict";


	
	/**
	 * Constructor for a new ObjectIdentifier.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * ObjectIdentifier is a display control that enables the user to easily identify a specific object. The object identifier title is the key identifier of the object and additional text and icons can be used to further distinguish it from other objects.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.12
	 * @alias sap.m.ObjectIdentifier
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectIdentifier = Control.extend("sap.m.ObjectIdentifier", /** @lends sap.m.ObjectIdentifier.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {
	
			/**
			 * The object title.
			 */
			title : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * The object text.
			 */
			text : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Indicates whether or not the notes icon is displayed.
			 * @deprecated Since version 1.24.0. 
			 * Will be replaced in the future by a more generic mechansism.
			 */
			badgeNotes : {type : "boolean", group : "Misc", defaultValue : null, deprecated: true},
	
			/**
			 * Indicates whether or not the address book icon is displayed.
			 * @deprecated Since version 1.24.0. 
			 * Will be replaced in the future by a more generic mechansism.
			 */
			badgePeople : {type : "boolean", group : "Misc", defaultValue : null, deprecated: true},
	
			/**
			 * Indicates whether or not the attachments icon is displayed.
			 * @deprecated Since version 1.24.0. 
			 * Will be replaced in the future by a more generic mechansism.
			 */
			badgeAttachments : {type : "boolean", group : "Misc", defaultValue : null, deprecated: true},
	
			/**
			 * Indicates if the object identifier is visible. An invisible object identifier is not being rendered.
			 */
			visible : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * Indicates if the object identifier's title is clickable.
			 * @since 1.26
			 */
			titleActive : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * This property specifies the element's text directionality with enumerated options. By default, the control inherits text direction from the DOM.
			 * @since 1.28.0
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit}
		},
		aggregations : {
	
			/**
			 * Control to display the object title (can be either Text or Link)
			 * 
			 * @private
			 */
			_titleControl : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"},
			
			/**
			 * Text control to display the object text
			 * 
			 * @private
			 */
			_textControl : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}
		},
		events : {
	
			/**
			 * Event is fired when the title is active and the user taps/clicks on it.
			 * @since 1.26
			 */
			titlePress : {
				parameters : {
	
					/**
					 * Dom reference of the object identifier's title
					 */
					domRef : {type : "object"}
				}
			}
		}
	}});
	
	///**
	// * This file defines behavior for the control
	// */
	
	/**
	 * Called when the control is destroyed.
	 * 
	 * @private
	 */
	ObjectIdentifier.prototype.exit = function() {
	
	    if (this._attachmentsIcon) {
	        this._attachmentsIcon.destroy();
	        this._attachmentsIcon = null;
	    }
	
	    if (this._peopleIcon) {
	        this._peopleIcon.destroy();
	        this._peopleIcon = null;
	    }
	
	    if (this._notesIcon) {
	        this._notesIcon.destroy();
	        this._notesIcon = null;
	    }
	};
	
	/**
	 * Lazy load attachments icon.
	 * 
	 * @private
	 */
	ObjectIdentifier.prototype._getAttachmentsIcon = function() {
	
		if (!this._attachmentsIcon) {
			this._attachmentsIcon = this._getIcon(IconPool.getIconURI("attachment"), this.getId() + "-attachments");
		}
	
	    return this._attachmentsIcon;
	};
	
	/**
	 * Lazy load people icon.
	 * 
	 * @private
	 */
	ObjectIdentifier.prototype._getPeopleIcon = function() {
	
		if (!this._peopleIcon) {
			this._peopleIcon = this._getIcon(IconPool.getIconURI("group"), this.getId() + "-people");
		}
	
	    return this._peopleIcon;
	};
	
	/**
	 * Lazy load notes icon.
	 * 
	 * @private
	 */
	ObjectIdentifier.prototype._getNotesIcon = function() {
	
		if (!this._notesIcon ) {
			this._notesIcon  = this._getIcon(IconPool.getIconURI("notes"), this.getId() + "-notes");
		}
	
	    return this._notesIcon;
	};
	
	/**
	 * Create icon image.
	 * 
	 * @private
	 */
	ObjectIdentifier.prototype._getIcon = function(sURI, sImageId) {
	
	    var sSize = sap.ui.Device.system.phone ? "1em" : "1em";
	    var oImage;
	
	    oImage = this._icon || IconPool.createControlByURI({
	        src : sURI,
	        id : sImageId + "-icon",
	        size : sSize
	    }, sap.m.Image);
	
	    oImage.setSrc(sURI);
	
	    return oImage;
	};	

	/**
	 * Get the proper control for the title.
	 * 
	 * @private
	 */
	ObjectIdentifier.prototype._getTitleControl = function() {

		var oTitleControl = this.getAggregation("_titleControl"),
			bIsTitleActive;

		if (!oTitleControl) {
			// Lazy initialization
			if (this.getProperty("titleActive")) {
				oTitleControl = new sap.m.Link({
					text: this.getProperty("title")
				});
			} else {
				oTitleControl = new sap.m.Text({
					text: this.getProperty("title")
				});
			}
			this.setAggregation("_titleControl", oTitleControl);
		} else {
			// Update the title control if necessary
			bIsTitleActive = this.getProperty("titleActive");

			if (bIsTitleActive && oTitleControl instanceof sap.m.Text) {
				this.destroyAggregation("_titleControl", true);
				oTitleControl = new sap.m.Link({
					text: this.getProperty("title")
				});
				this.setAggregation("_titleControl", oTitleControl);
			} else if (!bIsTitleActive && oTitleControl instanceof sap.m.Link) {
				this.destroyAggregation("_titleControl", true);
				oTitleControl = new sap.m.Text({
					text: this.getProperty("title")
				});
				this.setAggregation("_titleControl", oTitleControl);
			}
		}

		return oTitleControl;
	};
	
	/**
	 * Lazy initialization of _textControl aggregation
	 * 
	 * @private
	 */
	ObjectIdentifier.prototype._getTextControl = function() {

		var oTextControl = this.getAggregation("_textControl");

		if (!oTextControl) {
			oTextControl = new sap.m.Text();
			oTextControl.setProperty("text", this.getProperty("text"));
			this.setAggregation("_textControl", oTextControl);
		}

		oTextControl.setTextDirection(this.getTextDirection());
		oTextControl.setVisible(!!this.getText());
		
		return oTextControl;
	};
	
	/**
	 * Updates the text of the title control and rerenders it
	 * If titleActive = true, a Link control is rendered,
	 * otherwise a Text control will be rendered
	 * 
	 * @private
	 */
	ObjectIdentifier.prototype._rerenderTitle = function() {
		var oTitleControl = this._getTitleControl();
		oTitleControl.setProperty("text", this.getProperty("title"), true);
		var oRm = sap.ui.getCore().createRenderManager();
		oRm.renderControl(oTitleControl);
		oRm.flush(this.$("title")[0]);
		oRm.destroy();
	};
	
	/**
	 * Setter for property title.
	 * Default value is empty/undefined
	 * @public
	 * @param {string} sTitle new value for property title
	 * @returns {sap.m.ObjectIdentifier} this to allow method chaining
	 */
	ObjectIdentifier.prototype.setTitle = function (sTitle) {
		//always suppress rerendering because title div is rendered
		//if text is empty or not
		var oTitleControl = this._getTitleControl();
		oTitleControl.setProperty("text", sTitle, false);
		this.setProperty("title", sTitle, true);
		this.$("text").toggleClass("sapMObjectIdentifierTextBellow", 
				!!this.getProperty("text") && !!this.getProperty("title"));
	
		return this;
	};
	
	/**
	 * Setter for property text.
	 * Default value is empty/undefined
	 * @public
	 * @param {string} sText new value for property text
	 * @returns {sap.m.ObjectIdentifier} this to allow method chaining
	 */
	ObjectIdentifier.prototype.setText = function (sText) {
		//always suppress rerendering because text div is rendered
		//if text is empty or not
		this.setProperty("text", sText, true);
		
		var oTextControl = this._getTextControl();
		oTextControl.setProperty("text", sText, false);
		this.$("text").toggleClass("sapMObjectIdentifierTextBellow", 
				!!this.getProperty("text") && !!this.getProperty("title"));
	
		return this;
	};
	
	/**
	 * Setter for property titleActive.
	 * Default value is false
	 * @public
	 * @param {boolean} bValue new value for property titleActive
	 * @returns {sap.m.ObjectIdentifier} this to allow method chaining
	 */
	ObjectIdentifier.prototype.setTitleActive = function(bValue) {
		var bPrevValue = this.getProperty("titleActive");

		// Return if the new value is the same as the old one
		if (bPrevValue != bValue) {
			this.setProperty("titleActive", bValue, true);
			// If the title is already rendered, then the title control has to be updated and rerendered
			if (this.$("title").children().length > 0) {
				this._rerenderTitle();
			}
		}
		return this;
	};
	
	/**
	 * Function is called when ObjectIdentifier's title is triggered.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	ObjectIdentifier.prototype._handlePress = function(oEvent) {
		var oClickedItem = oEvent.target;
		if (this.getTitleActive() && this.$("title")[0].firstChild == oClickedItem) { // checking if the title is clicked
			this.fireTitlePress({
				domRef: oClickedItem
			});
		}
	};
	
	/**
	 * Event handler called when the enter key is pressed.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	ObjectIdentifier.prototype.onsapenter = function(oEvent) {
		ObjectIdentifier.prototype._handlePress.apply(this, arguments);
	};
	
	/**
	 * Event handler called when the space key is pressed.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	ObjectIdentifier.prototype.onsapspace = function(oEvent) {
		ObjectIdentifier.prototype._handlePress.apply(this, arguments);
	};
	
	/**
	 * Event handler called when the title is clicked/taped. 
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	ObjectIdentifier.prototype.ontap = function(oEvent) {
		ObjectIdentifier.prototype._handlePress.apply(this, arguments);
	};
	

	return ObjectIdentifier;

}, /* bExport= */ true);

}; // end of sap/m/ObjectIdentifier.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectListItem') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.ObjectListItem.
jQuery.sap.declare('sap.m.ObjectListItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectListItem",['jquery.sap.global', './ListItemBase', './library', 'sap/ui/core/IconPool'],
	function(jQuery, ListItemBase, library, IconPool) {
	"use strict";


	
	/**
	 * Constructor for a new ObjectListItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * ObjectListItem is a display control that provides summary information about an object as an item in a list. The object list item title is the key identifier of the object. Additional text and icons can be used to further distinguish it from other objects. Attributes and statuses can be used to provide additional meaning about the object to the user.
	 * @extends sap.m.ListItemBase
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.12
	 * @alias sap.m.ObjectListItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectListItem = ListItemBase.extend("sap.m.ObjectListItem", /** @lends sap.m.ObjectListItem.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {
	
			/**
			 * Object list item title
			 */
			title : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Object list item number
			 */
			number : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * The number units qualifier of the object list item
			 */
			numberUnit : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Introductory text for the object list item.
			 */
			intro : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Object list item icon displayed to the left of the title.
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * Icon displayed when the object list item is active.
			 */
			activeIcon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
			 * 
			 * If bandwidth is the key for the application, set this value to false.
			 */
			iconDensityAware : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Set the favorite state for the object list item
			 * @since 1.16.0
			 */
			markFavorite : {type : "boolean", group : "Misc", defaultValue : null},
	
			/**
			 * Set the flagged state for the object list item
			 * @since 1.16.0
			 */
			markFlagged : {type : "boolean", group : "Misc", defaultValue : null},
	
			/**
			 * Set to true if the object list item can be marked with icons such as favorite and flag.
			 * @since 1.16.0
			 */
			showMarkers : {type : "boolean", group : "Misc", defaultValue : null},
	
			/**
			 * Object list item number and numberUnit value state.
			 * @since 1.16.0
			 */
			numberState : {type : "sap.ui.core.ValueState", group : "Misc", defaultValue : sap.ui.core.ValueState.None},

			/**
			 * Determines the text direction of the item title.
			 * Available options for the title direction are LTR (left-to-right) and RTL (right-to-left).
			 * By default the item title inherits the text direction from its parent.
			 */
			titleTextDirection: {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},

			/**
			 * Determines the text direction of the item intro.
			 * Available options for the intro direction are LTR (left-to-right) and RTL (right-to-left).
			 * By default the item intro inherits the text direction from its parent.
			 */
			introTextDirection: {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},

			/**
			 * Determines the text direction of the item number.
			 * Available options for the number direction are LTR (left-to-right) and RTL (right-to-left).
			 * By default the item number inherits the text direction from its parent.
			 */
			numberTextDirection: {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},

			/**
			 * Set the locked state of the object list item.
			 * @since 1.28
			 */
			markLocked : {type : "boolean", group : "Misc", defaultValue : false}			
		},
		defaultAggregation : "attributes",
		aggregations : {
	
			/**
			 * List of attributes displayed below the title to the left of the status fields.
			 */
			attributes : {type : "sap.m.ObjectAttribute", multiple : true, singularName : "attribute"}, 
	
			/**
			 * First status text field shown on the right side of the attributes.
			 */
			firstStatus : {type : "sap.m.ObjectStatus", multiple : false}, 
	
			/**
			 * Second status text field shown on the right side of the attributes.
			 */
			secondStatus : {type : "sap.m.ObjectStatus", multiple : false}
		}
	}});
	
	///**
	// * This file defines behavior for the control,
	// */
	
	
	/**
	 * @private
	 */
	ObjectListItem.prototype.exit = function(oEvent) {
		// image or icon if initialized
		if (this._oImageControl) {
			this._oImageControl.destroy();
		}
		
		if (this._oPlaceholderIcon) {
			this._oPlaceholderIcon.destroy();
			this._oPlaceholderIcon = undefined;
		}
	
		if (this._oFavIcon) {
			this._oFavIcon.destroy();
			this._oFavIcon = undefined;
		}
		
		if (this._oFlagIcon) {
			this._oFlagIcon.destroy();
			this._oFlagIcon = undefined;
		}

		if (this._oLockIcon) {
			this._oLockIcon.destroy();
			this._oLockIcon = undefined;
		}
		
		if (this._oTitleText) {
			this._oTitleText.destroy();
			this._oTitleText = undefined;
		}
		
		ListItemBase.prototype.exit.apply(this);
	};
	
	/**
	 * @private
	 * @returns {boolean}
	 */
	ObjectListItem.prototype._hasAttributes = function() {
		var attributes = this.getAttributes();
		if (attributes.length > 0) {
			for (var i = 0; i < attributes.length; i++) {
				if (!attributes[i]._isEmpty()) {
					return true;
				}
			}
		}
		return false;
	};
	
	/**
	 * @private
	 * @returns {boolean}
	 */
	ObjectListItem.prototype._hasStatus = function() {
		return ((this.getFirstStatus() && !this.getFirstStatus()._isEmpty())
				|| (this.getSecondStatus() && !this.getSecondStatus()._isEmpty() ));
	};
	
	/**
	 * @private
	 * @returns {boolean}
	 */
	ObjectListItem.prototype._hasBottomContent = function() {
		
		return (this._hasAttributes() || this._hasStatus() || this.getShowMarkers() || this.getMarkLocked());
	};
	
	/**
	 * @private
	 * @returns {Array}
	 */
	ObjectListItem.prototype._getVisibleAttributes = function() {
	
		var aAllAttributes = this.getAttributes();
		var aVisibleAttributes = [];
	
		for (var i = 0; i < aAllAttributes.length; i++) {
			if (aAllAttributes[i].getVisible()) {
				aVisibleAttributes.push(aAllAttributes[i]);
			}
		}
	
		return aVisibleAttributes;
	};

	/**
	 * Lazy load list item's image.
	 *
	 * @private
	 */
	ObjectListItem.prototype._getImageControl = function() {
	
		var sImgId = this.getId() + '-img';
		var sSize = "2.5rem";
		var mProperties = {
			src : this.getIcon(),
			height : sSize,
			width : sSize,
			size: sSize,
			densityAware : this.getIconDensityAware()
		};
		var aCssClasses = ['sapMObjLIcon'];
		
		this._oImageControl = sap.m.ImageHelper.getImageControl(sImgId, this._oImageControl, this, mProperties, aCssClasses);
		
		return this._oImageControl;
	};
	
	/**
	 * Overwrite base method to hook into list item's active handling
	 * 
	 * @private
	 */
	ObjectListItem.prototype._activeHandlingInheritor = function() {
		var sActiveSrc = this.getActiveIcon();
		
		if (!!this._oImageControl  && !!sActiveSrc) {
			this._oImageControl.setSrc(sActiveSrc);
		}
	};
	
	/**
	 * Overwrite base method to hook into list item's inactive handling
	 * 
	 * @private
	 */
	ObjectListItem.prototype._inactiveHandlingInheritor = function() {
		var sSrc = this.getIcon();
		if (!!this._oImageControl) {
			this._oImageControl.setSrc(sSrc);
		}
	};
	
	/**
	 * @private
	 * @returns Flag icon control
	 */
	//TODO Remove placeholder when Safari iconFont issue is addressed.
	ObjectListItem.prototype._getPlaceholderIcon = function() {
		
		if (!this._oPlaceholderIcon) {
	
			var oPlaceholderIconUri = IconPool.getIconURI("fridge");
			this._oPlaceholderIcon = IconPool.createControlByURI({
				id: this.getId() + "-placeholder",
				src: oPlaceholderIconUri
			});
			
			this._oPlaceholderIcon.addStyleClass("sapMObjStatusMarkerInvisible");
		}
		return this._oPlaceholderIcon;
	};
	
	/**
	 * @private
	 * @returns Flag icon control
	 */
	ObjectListItem.prototype._getFlagIcon = function() {
		
		if (!this._oFlagIcon) {
	
			var oFlagIconUri = IconPool.getIconURI("flag");
			this._oFlagIcon = IconPool.createControlByURI({
				id: this.getId() + "-flag",
				src: oFlagIconUri
			});
		}
		return this._oFlagIcon;
	};

	/**
	 * @private
	 * @returns Lock icon control
	 */
	ObjectListItem.prototype._getLockIcon = function() {

		if (!this._oLockIcon) {
			var oLockIconUri = IconPool.getIconURI("locked");
			this._oLockIcon = IconPool.createControlByURI({
				id: this.getId() + "-lock",
				src: oLockIconUri
			}).addStyleClass("sapMObjStatusMarkerLocked");
		}
		return this._oLockIcon;
	};
	
	/**
	 * @private
	 * @returns Favorite icon control
	 */
	ObjectListItem.prototype._getFavoriteIcon = function() {
		
		if (!this._oFavIcon) {
	
		    var oFavIconUri = IconPool.getIconURI("favorite");
		    this._oFavIcon = IconPool.createControlByURI({
		           id: this.getId() + "-favorite",
		           src: oFavIconUri
		    });
		}
		return this._oFavIcon;
	};
	
	/**
	 * @private
	 * @returns title text control
	 */
	ObjectListItem.prototype._getTitleText = function() {
		
		if (!this._oTitleText) {
			this._oTitleText = new sap.m.Text(this.getId() + "-titleText", {
				maxLines: 2
			});

			this._oTitleText.setParent(this, null, true);
		}
		return this._oTitleText;
	};

	return ObjectListItem;

}, /* bExport= */ true);

}; // end of sap/m/ObjectListItem.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectNumber') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.ObjectNumber.
jQuery.sap.declare('sap.m.ObjectNumber'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectNumber",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/Renderer'],
	function(jQuery, library, Control, Renderer) {
	"use strict";


	/**
	 * Constructor for a new ObjectNumber.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * ObjectNumber displays number and number unit properties for an object. The number can be displayed using semantic
	 * colors to provide addition meaning about the object to the user.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @since 1.12
	 * @alias sap.m.ObjectNumber
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectNumber = Control.extend("sap.m.ObjectNumber", /** @lends sap.m.ObjectNumber.prototype */ { metadata : {

		library : "sap.m",
		properties : {

			/**
			 * Number field of the object number
			 */
			number : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Number units qualifier
			 * @deprecated Since version 1.16.1.
			 *
			 * Replaced by unit property due to the number before unit is redundant.
			 */
			numberUnit : {type : "string", group : "Misc", defaultValue : null, deprecated: true},

			/**
			 * Indicates if the object number should appear emphasized
			 */
			emphasized : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * The object number's value state. Setting this state will cause the number to be rendered in state-specific colors (only blue-crystal theme).
			 */
			state : {type : "sap.ui.core.ValueState", group : "Misc", defaultValue : sap.ui.core.ValueState.None},

			/**
			 * Number units qualifier. If numberUnit and unit are both set, the unit value is used.
			 * @since 1.16.1
			 */
			unit : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Available options for the number and unit text direction are LTR and RTL. By default the control inherits the text direction from its parent control.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},

			/**
			 * Sets the horizontal alignment of the number and unit.
			 */
			textAlign : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin}
		}
	}});

	/**
	 * String to prefix css class for number status to be used in
	 * controler and renderer
	 *
	 * @private
	 */
	ObjectNumber.prototype._sCSSPrefixObjNumberStatus = 'sapMObjectNumberStatus';

	/**
	 * API method to set the object number's value state
	 *
	 * @override
	 * @public
	 * @param {sap.ui.core.ValueState} sState
	 * @returns {ObjectNumber}
	 */
	ObjectNumber.prototype.setState = function(sState) {
		//remove the current value state css class
		this.$().removeClass(this._sCSSPrefixObjNumberStatus + this.getState());

		//do suppress rerendering
		this.setProperty("state", sState, true);

		//now set the new css state class
		this.$().addClass(this._sCSSPrefixObjNumberStatus + this.getState());

		return this;
	};

	/**
	 * API method to set the text alignment of the control without rerendering the whole object number
	 *
	 * @override
	 * @public
	 * @param {sap.ui.core.TextAlign} sAlign the new value
	 */
	ObjectNumber.prototype.setTextAlign = function(sAlign) {
		var sAlignVal = Renderer.getTextAlign(sAlign, this.getTextDirection());

		//do suppress rerendering
		this.setProperty("textAlign", sAlign, true);

		sAlignVal = sAlignVal || sAlign;
		this.$().css("text-align", sAlign);
	};

	return ObjectNumber;

}, /* bExport= */ true);

}; // end of sap/m/ObjectNumber.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectStatus') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.ObjectStatus.
jQuery.sap.declare('sap.m.ObjectStatus'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/m/ObjectStatus",['jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/IconPool'],
	function(jQuery, library, Control, IconPool) {
	"use strict";



	/**
	 * Constructor for a new ObjectStatus.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Status information that may be either text with a value state, or an icon.
	 * @extends sap.ui.core.Control
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @alias sap.m.ObjectStatus
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectStatus = Control.extend("sap.m.ObjectStatus", /** @lends sap.m.ObjectStatus.prototype */ { metadata : {

		library : "sap.m",
		properties : {

			/**
			 * The object status title.
			 */
			title : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * The object status text.
			 */
			text : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Text value state.
			 */
			state : {type : "sap.ui.core.ValueState", group : "Misc", defaultValue : sap.ui.core.ValueState.None},

			/**
			 * Icon URI. This may be either an icon font or image path.
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},

			/**
			 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
			 *
			 * If bandwidth is the key for the application, set this value to false.
			 */
			iconDensityAware : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * Determines the direction of the text, not including the title.
			 * Available options for the text direction are LTR (left-to-right) and RTL (right-to-left). By default the control inherits the text direction from its parent control.
			 */
			textDirection : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit}
		},
		associations : {

			/**
			 * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
			 */
			ariaDescribedBy : {type : "sap.ui.core.Control", multiple : true, singularName : "ariaDescribedBy"}
		}
	}});

	///**
	// * This file defines behavior for the control
	// */


	/**
	 * Called when the control is destroyed.
	 *
	 * @private
	 */
	ObjectStatus.prototype.exit = function() {
		if (this._oImageControl) {
			this._oImageControl.destroy();
			this._oImageControl = null;
		}
	};

	/**
	 * Lazy load feed icon image.
	 *
	 * @private
	 */
	ObjectStatus.prototype._getImageControl = function() {
		var sImgId = this.getId() + '-icon';
		var mProperties = {
			src : this.getIcon(),
			densityAware : this.getIconDensityAware()
		};

		this._oImageControl = sap.m.ImageHelper.getImageControl(sImgId, this._oImageControl, this, mProperties);

		return this._oImageControl;
	};

	/**
	 * Setter for property title.
	 * Default value is empty/undefined
	 * @public
	 * @param {string} sTitle new value for property title
	 * @returns {sap.m.ObjectStatus} this to allow method chaining
	 */
	ObjectStatus.prototype.setTitle = function (sTitle) {
		var $Title = this.$().children(".sapMObjStatusTitle"),
			bShouldSuppressInvalidate = !!$Title.length && !!this.validateProperty("title", sTitle).trim();

		this.setProperty("title", sTitle, bShouldSuppressInvalidate);

		if (bShouldSuppressInvalidate) {
			$Title.text(this.getTitle() + ":");
		}

		return this;
	};

	/**
	 * Setter for property text.
	 * Default value is empty/undefined
	 * @public
	 * @param {string} sText new value for property text
	 * @returns {sap.m.ObjectStatus} this to allow method chaining
	 */
	ObjectStatus.prototype.setText = function (sText) {
		var $Text = this.$().children(".sapMObjStatusText"),
			bShouldSuppressInvalidate = !!$Text.length && !!this.validateProperty("text", sText).trim();

		this.setProperty("text", sText, bShouldSuppressInvalidate);

		if (bShouldSuppressInvalidate) {
			$Text.text(this.getText());
		}

		return this;
	};

	/**
	 * @private
	 * @returns {boolean}
	 */
	ObjectStatus.prototype._isEmpty = function() {

		return !(this.getText().trim() || this.getIcon().trim() || this.getTitle().trim());
	};

	return ObjectStatus;

}, /* bExport= */ true);

}; // end of sap/m/ObjectStatus.js
if ( !jQuery.sap.isDeclared('sap.m.OverflowToolbarButton') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.OverflowToolbarHelpers._OverflowToolbarButton.
jQuery.sap.declare('sap.m.OverflowToolbarButton'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/m/OverflowToolbarButton",['sap/m/Button', 'sap/m/ButtonRenderer'],
	function(Button, ButtonRenderer) {
	"use strict";



	/**
	 * Constructor for a new OverflowToolbarButton.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * OverflowToolbarButton is a version of Button that shows its text only when in the overflow area of a sap.m.OverflowToolbar.
	 * This control is intended to be used exclusively in the context of OverflowToolbar, when it is required to have buttons that show only
	 * an icon in the toolbar, but icon and text in the overflow menu.
	 * @extends sap.m.Button
	 *
	 * @author SAP SE
	 * @version 1.28.17
	 *
	 * @constructor
	 * @private
	 * @since 1.28
	 * @alias sap.m.OverflowToolbarButton
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var OverflowToolbarButton = Button.extend("sap.m.OverflowToolbarButton", /** @lends sap.m.OverflowToolbarButton.prototype */ {
		renderer: ButtonRenderer.render
	});

	OverflowToolbarButton.prototype._getText = function() {
			if (this._bInOverflow) {
				return Button.prototype._getText.call(this);
			}

			return "";
	};

	return OverflowToolbarButton;

}, /* bExport= */ true);

}; // end of sap/m/OverflowToolbarButton.js
if ( !jQuery.sap.isDeclared('sap.m.OverflowToolbarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.m.OverflowToolbarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/m/OverflowToolbarRenderer",['sap/ui/core/Renderer', './ToolbarRenderer'],
	function(Renderer, ToolbarRenderer) {
		"use strict";


		/**
		 * OverflowToolbar renderer.
		 * @namespace
		 */
		var OverflowToolbarRenderer = Renderer.extend(ToolbarRenderer);

		OverflowToolbarRenderer.renderBarContent = function(rm, oToolbar) {

			oToolbar._getVisibleContent().forEach(function(oControl) {
				sap.m.BarInPageEnabler.addChildClassTo(oControl,oToolbar);
				rm.renderControl(oControl);
			});

			if (oToolbar._getOverflowButtonNeeded()) {
				OverflowToolbarRenderer.renderOverflowButton(rm,oToolbar);
			}
		};

		OverflowToolbarRenderer.renderOverflowButton = function(rm,oToolbar) {
			var oOverflowButtonLabel = oToolbar._getOverflowButtonLabel();
			rm.renderControl(oOverflowButtonLabel);
			
			var oOverflowButton = oToolbar._getOverflowButton();
			sap.m.BarInPageEnabler.addChildClassTo(oOverflowButton,oToolbar);
			rm.renderControl(oOverflowButton);
		};

		return OverflowToolbarRenderer;

	}, /* bExport= */ true);

}; // end of sap/m/OverflowToolbarRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.P13nColumnsItem') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.P13nColumnsItem.
jQuery.sap.declare('sap.m.P13nColumnsItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Item'); // unlisted dependency retained
sap.ui.define("sap/m/P13nColumnsItem",['jquery.sap.global', './library', 'sap/ui/core/Item'],
	function(jQuery, library, Item) {
	"use strict";


	
	/**
	 * Constructor for a new P13nColumnsItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class The ColumnsItem can be used to fill columnsItem aggregation in P13nColumnsPanel
	 * @extends sap.ui.core.Item
	 * @version 1.28.17
	 * @constructor
	 * @author SAP SE 
	 * @public
	 * @since 1.26.0 
	 * @alias sap.m.P13nColumnsItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var P13nColumnsItem = Item.extend("sap.m.P13nColumnsItem", /** @lends sap.m.P13nColumnsItem.prototype */ { metadata : {
	
		library : "sap.m",
		properties : {

			/**
			 *  This property contains the unique table column key
			 *  @since 1.26.0
			 */
			columnKey : {type : "string", group : "Misc"}, //don't set a default value
			
			/**
			 * This property contains the index of a table column
			 * @since 1.26.0
			 */
			index : {type : "int", group : "Appearance"}, //don't set a default value
			
			/**
			 * This property decides whether a P13nColumnsItem is visible
			 * @since 1.26.0
			 */
			visible : {type : "boolean", group : "Appearance"},  //don't set a default value

			/**
			 *  This property contains the with of a table column.
			 *  @since 1.26.0
			 */
			width : {type : "string", group : "Misc"} //don't set a default value

		}
	}});
	
	return P13nColumnsItem;

}, /* bExport= */ true);

}; // end of sap/m/P13nColumnsItem.js
if ( !jQuery.sap.isDeclared('sap.m.P13nConditionPanel') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.m.P13nConditionPanel.
jQuery.sap.declare('sap.m.P13nConditionPanel'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.format.DateFormat'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.format.NumberFormat'); // unlisted dependency retained
sap.ui.define("sap/m/P13nConditionPanel",[
	'jquery.sap.global', './library', 'sap/ui/core/Control', 'sap/ui/core/format/DateFormat', 'sap/ui/core/format/NumberFormat'
], function(jQuery, library, Control, DateFormat, NumberFormat) {
	"use strict";

	/**
	 * Constructor for a new P13nConditionPanel.
	 *
	 * @param {string}
	 *            [sId] id for the new control, generated automatically if no id is given
	 * @param {object}
	 *            [mSettings] initial settings for the new control
	 *
	 * @class The ConditionPanel Control will be used to realize the Sorting, Filtering and Grouping
	 *        panel of the new Personalization dialog.
	 * @extends sap.m.P13nPanel
	 * @version 1.28.17
	 *
	 * @constructor
	 * @public
	 * @experimental since version 1.26 !!! THIS CONTROL IS ONLY FOR INTERNAL USE !!!
	 * @alias sap.m.P13nConditionPanel
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var P13nConditionPanel = Control.extend("sap.m.P13nConditionPanel", /** @lends sap.m.P13nConditionPanel.prototype */
	{
		metadata: {

			library: "sap.m",
			properties: {

				/**
				 * defines the max number of conditions on the ConditionPanel
				 */
				maxConditions: {
					type: "string",
					group: "Misc",
					defaultValue: '-1'
				},

				/**
				 * exclude options for filter
				 */
				exclude: {
					type: "boolean",
					group: "Misc",
					defaultValue: false
				},

				/**
				 * defines if the mediaQuery or a ContainerResize will be used for layout update. When
				 * the P13nConditionPanel is used on a dialog the property should be set to true!
				 */
				containerQuery: {
					type: "boolean",
					group: "Misc",
					defaultValue: false
				},

				/**
				 * adds initial a new empty condition row
				 */
				autoAddNewRow: {
					type: "boolean",
					group: "Misc",
					defaultValue: false
				},

				/**
				 * makes the remove icon on the first condition row disabled when only one condition
				 * exist.
				 */
				disableFirstRemoveIcon: {
					type: "boolean",
					group: "Misc",
					defaultValue: false
				},

				/**
				 * makes the Add icon visible on each condition row. If is set to false the Add is only
				 * visible at the end and you can only append a new condition.
				 */
				alwaysShowAddIcon: {
					type: "boolean",
					group: "Misc",
					defaultValue: true
				},

				/**
				 * new added condition use the settings from the previous condition as default.
				 */
				usePrevConditionSetting: {
					type: "boolean",
					group: "Misc",
					defaultValue: true
				},

				/**
				 * KeyField value can only be selected once. When you set the property to true the
				 * ConditionPanel will automatically offers on the KeyField drop down only the keyFields
				 * which are not used. The default behavior is that in each keyField dropdown all
				 * keyfields are listed.
				 */
				autoReduceKeyFieldItems: {
					type: "boolean",
					group: "Misc",
					defaultValue: false
				},

				/**
				 * can be used to control the layout behavior. Default is "" which will automatically
				 * change the layout. With "Desktop", "Table" or"Phone" you can set a fixed layout.
				 */
				layoutMode: {
					type: "string",
					group: "Misc",
					defaultValue: null
				},

				/**
				 * show additional labels in the condition
				 */
				showLabel: {
					type: "boolean",
					group: "Misc",
					defaultValue: false
				},

				/**
				 * This represents the displayFormat of the condition Values.
				 * With the value "UpperCase" the entered value of the condition will be converted to upperCase.
				 */
				displayFormat: {
					type: "string",
					group: "Misc",
					defaultValue: null
				}
			},
			aggregations: {

				/**
				 * Content for the ConditionPanel. This property is not public!
				 */
				content: {
					type: "sap.ui.core.Control",
					multiple: true,
					singularName: "content",
					visibility: "hidden"
				}
			},
			events: {

				/**
				 * Workaround for updating the binding
				 */
				dataChange: {}
			}
		}
	});

	// EXC_ALL_CLOSURE_003
	/**
	 * This method must be used to assign a list of conditions.
	 *
	 * @param {object[]}
	 *            aConditions array of Conditions.
	 *
	 * @public
	 * @since 1.26.0
	 */
	P13nConditionPanel.prototype.setConditions = function(aConditions) {
		if (!aConditions) {
			jQuery.sap.log.error("sap.m.P13nConditionPanel : aCondition is not defined");
		}

		if (this._bIgnoreSetConditions) {
			return;
		}

		this._oConditionsMap = {};
		this._iConditions = 0;
		for (var i = 0; i < aConditions.length; i++) {
			this._addCondition2Map(aConditions[i]);
		}

		this._clearConditions();
		this._fillConditions();
	};

	/**
	 * remove all conditions.
	 *
	 * @public
	 * @since 1.26.0
	 */
	P13nConditionPanel.prototype.removeAllConditions = function() {
		this._oConditionsMap = {};
		this._iConditions = 0;

		this._clearConditions();
		this._fillConditions();
	};

	/**
	 * add a single condition.
	 *
	 * @param {object}
	 *            oCondition the new condition of type { "key": "007", "operation":
	 *            sap.m.P13nConditionOperation.Ascending, "keyField": "keyFieldKey", "value1": "", "value2": ""};
	 * @public
	 * @since 1.26.0
	 */
	P13nConditionPanel.prototype.addCondition = function(oCondition) {
		if (this._bIgnoreSetConditions) {
			return;
		}
		oCondition.index = this._iConditions;

		this._addCondition2Map(oCondition);
		this._addCondition(oCondition);
	};

	/**
	 * insert a single condition.
	 *
	 * @param {object}
	 *            oCondition the new condition of type { "key": "007", "operation":
	 *            sap.m.P13nConditionOperation.Ascending, "keyField": "keyFieldKey", "value1": "", "value2": ""};
	 * @param {integer}
	 *            index of the new condition
	 * @public
	 * @since 1.26.0
	 */
	P13nConditionPanel.prototype.insertCondition = function(oCondition, index) {
		if (this._bIgnoreSetConditions) {
			return;
		}
		if (index !== undefined) {
			oCondition.index = index;
		}
		this._addCondition2Map(oCondition);
		this._addCondition(oCondition);
	};

	/**
	 * remove a single condition.
	 *
	 * @param {object}
	 *            vCondition is the condition which should be removed. can be either a string with the
	 *            key of the condition of the condition object itself.
	 * @public
	 * @since 1.26.0
	 */
	P13nConditionPanel.prototype.removeCondition = function(vCondition) {
		this._clearConditions();

		if (typeof (vCondition) == "string") {
			delete this._oConditionsMap[vCondition];
		}

		if (typeof (vCondition) == "object") {
			delete this._oConditionsMap[vCondition.key];
		}

		this._fillConditions();
	};

	/**
	 * add a single condition into the _oConditionMap.
	 *
	 * @private
	 * @param {object}
	 *            oCondition the new condition of type { "key": "007", "operation":
	 *            sap.m.P13nConditionOperation.Ascending, "keyField": "keyFieldKey", "value1": "", "value2": ""};
	 */
	P13nConditionPanel.prototype._addCondition2Map = function(oCondition) {
		if (!oCondition.key) {
			oCondition.key = "condition_" + this._iConditions;
			if (this.getExclude()) {
				oCondition.key = "x" + oCondition.key;
			}
		}
		this._iConditions++;
		this._oConditionsMap[oCondition.key] = oCondition;
	};

	/**
	 * returns array of all defined conditions.
	 *
	 * @public
	 * @returns {object[]} array of Conditions
	 * @since 1.26.0
	 */
	P13nConditionPanel.prototype.getConditions = function() {
		var oCondition;
		var aConditions = [];

		if (this._oConditionsMap) {
			for ( var conditionId in this._oConditionsMap) {
				oCondition = this._oConditionsMap[conditionId];
				var sValue = oCondition.value;
				if (!sValue) {
					sValue = this._getFormatedConditionText(oCondition.operation, oCondition.value1, oCondition.value2, oCondition.exclude, oCondition.keyField, oCondition.showIfGrouped);
				}

				if (!oCondition._oGrid || oCondition._oGrid.select.getSelected()) {
					aConditions.push({
						"key": conditionId,
						"text": sValue,
						"exclude": oCondition.exclude,
						"operation": oCondition.operation,
						"keyField": oCondition.keyField,
						"value1": oCondition.value1,
						"value2": oCondition.value2,
						"showIfGrouped": oCondition.showIfGrouped
					});

				}
			}
		}

		return aConditions;
	};

	/**
	 * setter for the supported operations which we show per condition row. This array of "default"
	 * operations will only be used when we do not have on the keyfield itself some specific operations
	 * and a keyfield is of not of type date or numeric.
	 *
	 * @public
	 * @since 1.26.0
	 * @param {sap.m.P13nConditionOperation[]}
	 *            aOperations array of operations [sap.m.P13nConditionOperation.BT,
	 *            sap.m.P13nConditionOperation.EQ]
	 * @param {string}
	 *            sType defines the type for which this operations will be used. is sTyp