/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','./AnalyticalBinding'],function(q,T,A){"use strict";var a=function(){if(!(this instanceof T&&this.getContexts===undefined)){return;}for(var f in a.prototype){if(a.prototype.hasOwnProperty(f)){this[f]=a.prototype[f];}}this._aContexts=[];this._aContextInfos=[];this._bInitial=true;this._oExpanded={};this._oOpenGroups={};this._bTriggeredOpenGroupsLoad=false;};a.prototype._updateContexts=function(p,c,C,r){var I=p;for(var i=0;i<c.length;i++){var o=c[i];var b=C[i];this._aContexts.splice(p,r?1:0,o);this._aContextInfos.splice(p,r?1:0,b);p++;}if(!r){this._fireContextChange({type:"insert",index:I,length:c.length});}return C;};a.prototype.getLength=function(){return this._aContexts.length;};a.prototype.getContextInfo=function(i){return this._aContextInfos.slice(i,i+1)[0];};a.prototype._createContextInfos=function(c,p,P,l,L,t,s,I,b){if(!I){I=0;}var C=[];for(var i=0;i<c.length;i++){var o=c[i];C.push({context:o,level:l,expanded:false,childCount:0,parent:p,sum:s,position:P,index:i+I,autoExpand:b,expandLength:L,expandThreshold:t});P++;}return C;};a.prototype.getContexts=function(s,l,t){var b=this;if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength["null"]&&this.mLength["null"]===0){this._bInitial=false;}if(this._bInitial){var n=this.mParameters&&this.mParameters.numberOfExpandedLevels;var r=this.getRootContexts({startIndex:s,length:l,threshold:t,numberOfExpandedLevels:n});if(r&&r.length>0){this._bInitial=false;var N=this._createContextInfos(r,null,0,0,l,t,true,0,parseInt(n,10)+1);if(this.bProvideGrandTotals&&this.hasTotaledMeasures()){this._updateContexts(0,r,N);}else{this._expandNodesForContexts(N,0,l,t);}}}if(this._oOpenGroups!={}&&this._bTriggeredOpenGroupsLoad==false){this.loadGroups(this._oOpenGroups);this._bTriggeredOpenGroupsLoad=true;}this._expandNodesForContexts(this._aContextInfos.slice(s,s+l),s,l,t);var c=this._aContexts.slice(s,s+l);var m={};q.each(c,function(i,C){if(!C){var o=b._aContextInfos[s+i];var p=o.parent;var S=m[p.getPath()];if(S){S.startIndex=Math.min(S.startIndex,o.index);S.position=Math.min(S.position,o.position);S.endIndex=Math.max(S.endIndex,o.index);}else{m[p.getPath()]={startIndex:o.index,endIndex:o.index,parent:o.parent,level:o.level-1,position:o.position};}}});var b=this,u=false;q.each(m,function(i,S){var d=S.endIndex-S.startIndex+1;var e=Math.max(b.mParameters.numberOfExpandedLevels-S.level,0);var M=b.getNodeContexts(S.parent,{startIndex:S.startIndex,length:d,threshold:t,level:S.level,numberOfExpandedLevels:e});if(M.length>0){b._updateContexts(S.position,M,b._createContextInfos(M,S.parent,S.position,S.level+1,d,t,false,0,e),true);b._updateExpandedInfo(S.parent,S.level,S.startIndex,S.endIndex-S.startIndex+1,t);u=true;}});if(u){this._expandNodesForContexts(this._aContextInfos.slice(s,s+l),s,l,t);c=this._aContexts.slice(s,s+l);}return c;};a.prototype._expandNodesForContexts=function(c,s,l,t){var e=q.grep(c,function(C){return C.autoExpand>0;});for(var i=0;i<e.length;i++){this._expandNode(e[i],s,l,t);}};a.prototype._expandNode=function(c,s,l,t){var C=c.context,n=c.expandLength,N=c.expandThreshold,h=this.hasMeasures();if(!(c.position>=s&&c.position<=s+l)||c.expanded===true){return;}var b=this.getNodeContexts(C,{startIndex:0,length:n,threshold:N,level:c.level,numberOfExpandedLevels:c.autoExpand?c.autoExpand-1:0});if(b&&b.length>0){var r=this.getGroupSize(C,c.level),i=c.parent?c.position+1:0,p=i,L=c.level+1,I=L,d=this._createContextInfos(b,C,p,L,n,N,false,0,c.autoExpand?c.autoExpand-1:0);p+=d.length;var e=d.length;if(r>-1){for(var j=b.length;j<r;j++){b.push(undefined);d.push(this._createContextInfos([undefined],C,p,L,l,t,false,e,c.autoExpand?c.autoExpand-1:0)[0]);p++;e++;}}if(C&&c.parent!=null&&r>1&&!this.mParameters.sumOnTop&&h&&this.bProvideGrandTotals){b.push(C);d.push(this._createContextInfos([C],C,p,L-1,l,t,true,e,0)[0]);}var f=b.length;this._updateContexts(i,b,d);var g=i+f;var P;L--;var k=i;while((P=this._aContextInfos[k])!==undefined){if(P.level==L){P.childCount=P.childCount+f;L--;}k--;if(L<0){break;}}var o=this._aContextInfos[g];if(o){var m=this._aContextInfos[g-1].position-o.position+1;for(var j=g;j<this._aContextInfos.length;j++){this._aContextInfos[j].position+=m;}}if(c){c.expanded=true;}this._updateExpandedInfo(c.context,c.level,0,l,t);var u=false;for(var j=0;j<b.length;j++){if(I<=this.aAggregationLevel.length&&this._oOpenGroups[this._getGroupIdFromContext(b[j],I)]){this._expandNode(d[j],s,l,t);delete this._oOpenGroups[this._getGroupIdFromContext(b[j],I)];u=true;}if(d[j].autoExpand>0&&this.hasAvailableNodeContexts(b[j],I)>0&&!u){this._expandNode(d[j],s,l,t);}}c.autoExpand=0;}};a.prototype._updateExpandedInfo=function(c,l,s,L,t){var b=this._getGroupIdFromContext(c,l);var p=b.substr(0,b.length-1).split("/");var e=this._oExpanded;for(var j=0;j<p.length;j++){var P=p[j];if(j==0){P="root";}e[P]=e[P]||{};e=e[P];if(j==p.length-1){e["sections"]=e["sections"]||[];if(e["sections"].length==0){e["sections"].push({startIndex:s,length:L,threshold:t});}var E=false;for(var k=0;k<e["sections"].length;k++){var S=e["sections"][k];var i=S.startIndex+S.length+S.threshold;var d=s+L+t;if(S.startIndex<=s&&i>=d){return;}else if(S.startIndex<=s&&i>=s){S.threshold=Math.max(S.threshold,t);S.length=d-S.startIndex-S.threshold;E=true;}else if(S.startIndex>s&&i>d){S.length=S.length+(S.startIndex-s);S.startIndex=s;S.threshold=Math.max(S.threshold,t);E=true;}else if(S.startIndex>s&&S.endIndex<d){S.startIndex=s;S.length=L;S.threshold=t;E=true;}}if(!E){e["sections"].push({startIndex:s,length:L,threshold:t});}}else{e["children"]=e["children"]||{};e["childProperty"]=this.aAggregationLevel[j];e=e["children"];}}};a.prototype.isExpanded=function(i){var c=this._aContextInfos[i];return c&&c.expanded;};a.prototype.expand=function(i,p){var c=this._aContextInfos[i];if(c.expanded){return;}c.autoExpand=c.autoExpand||1;if(!p){this._fireChange();}};a.prototype.collapse=function(I,p){var c=this._aContextInfos[I];var C=this._aContexts[I];if(!c.expanded){return;}var P=c.position+1,l=c.childCount,L=c.level;var e=this._oExpanded["root"];var s=this._getGroupIdFromContext(C,L);var b=s.substr(0,s.length-1).split("/");for(var i=1;i<L;i++){e=e["children"][b[i]];}delete e["children"][b[b.length-1]];var r=P;this._aContexts.splice(P,l);this._aContextInfos.splice(P,l);P--;var o;while((o=this._aContextInfos[P])!==undefined){if(o.level==L){o.childCount=o.childCount-l;L--;}P--;if(L<0){break;}}if(r<this._aContextInfos.length){var d=this._aContextInfos[r-1].position-this._aContextInfos[r].position+1;for(var j=r;j<this._aContextInfos.length;j++){this._aContextInfos[j].position+=d;}this._fireContextChange({type:"remove",index:r,length:Math.abs(d)});}c.expanded=false;if(!p){this._fireChange();}};a.prototype.collapseAll=function(l){if(!l||l<1){l=1;}for(var i=0,j=this._aContextInfos.length;i<j;i++){if(this._aContextInfos[i].autoExpand>0){this._aContextInfos[i].autoExpand=Math.max(l-1,0);}if(this._aContextInfos[i].level==l){this.collapse(i,true);j=this._aContextInfos.length;}}this._fireChange();};a.prototype.toggleIndex=function(i){if(!this._aContextInfos[i].expanded){this.expand(i);}else{this.collapse(i);}};a.prototype.indexHasChildren=function(i){var c=this._aContextInfos[i];if(!c.parent||c.sum){return false;}else{return A.prototype.hasChildren.call(this,c.context,{level:c.level});}};a.prototype.resetData=function(c){var r=A.prototype.resetData.call(this,c);this._aContexts=[];this._aContextInfos=[];this._oOpenGroups={};this._removeGroups(this._oExpanded["root"],0,'');this._oExpanded={};this._bInitial=true;this._bTriggeredOpenGroupsLoad=false;return r;};a.prototype.updateAnalyticalInfo=function(c){var r=A.prototype.updateAnalyticalInfo.call(this,c);this._aContexts=[];this._aContextInfos=[];this._oOpenGroups={};this._removeGroups(this._oExpanded["root"],0,'');this._oExpanded={};this._bInitial=true;this._bTriggeredOpenGroupsLoad=false;return r;};a.prototype._removeGroups=function(g,l,p){if(!g){return;}this._oOpenGroups[p+'/']=g.sections;if(!g.childProperty){return;}if(g.childProperty!=this.aAggregationLevel[l]){delete g.children;delete g.childProperty;}else{for(var c in g.children){this._removeGroups(g.children[c],l+1,p+'/'+c);}}};a.prototype.hasTotaledMeasures=function(){var h=false;q.each(this.getMeasureDetails(),function(i,m){if(m.analyticalInfo.total){h=true;return false;}});return h;};a.prototype.attachContextChange=function(f,l){this.attachEvent("contextChange",f,l);};a.prototype.detachContextChange=function(f,l){this.detachEvent("contextChange",f,l);};a.prototype._fireContextChange=function(m){this.fireEvent("contextChange",m);};a.prototype.setNumberOfExpandedLevels=function(l){l=l||0;if(l<0){q.sap.log.warning("TreeBindingAdapter: numberOfExpanded levels was set to 0. Negative values are prohibited.");l=0;}this.mParameters.numberOfExpandedLevels=l;};a.prototype.getNumberOfExpandedLevels=function(){return this.mParameters.numberOfExpandedLevels;};return a;},true);
