/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/commons/ListBox','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./library','jquery.sap.dom'],function(q,L,C,P,a,l){"use strict";var E=C.extend("sap.ui.ux3.ExactList",{metadata:{library:"sap.ui.ux3",properties:{showClose:{type:"boolean",group:"Misc",defaultValue:false},topTitle:{type:"string",group:"Misc",defaultValue:null},topHeight:{type:"int",group:"Appearance",defaultValue:290}},aggregations:{subLists:{type:"sap.ui.ux3.ExactList",multiple:true,singularName:"subList"},controls:{type:"sap.ui.commons.ListBox",multiple:true,singularName:"control",visibility:"hidden"}},associations:{data:{type:"sap.ui.ux3.ExactAttribute",multiple:false}},events:{attributeSelected:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"},allAttributes:{type:"object"}}}}}});(function(){L.extend("sap.ui.ux3.ExactList.LB",{init:function(){L.prototype.init.apply(this,arguments);this.setAllowMultiSelect(true);this.setDisplayIcons(true);this.addStyleClass("sapUiUx3ExactLstLb");},invalidate:function(){L.prototype.invalidate.apply(this,arguments);if(!this.bInvalidated&&this.getParent()){this.getParent().invalidate();}this.bInvalidated=true;},_handleUserActivation:function(i){i.metaKey=true;L.prototype._handleUserActivation.apply(this,[i]);},onclick:function(i){L.prototype.onclick.apply(this,arguments);this.getParent().onclick(i);},onAfterRendering:function(){L.prototype.onAfterRendering.apply(this,arguments);this.bInvalidated=false;var s=this.getParent();var F=this.getItems();var I=s._isTop();var H=false;for(var i=0;i<F.length;i++){var G=F[i];var J=sap.ui.getCore().byId(G.getKey());var K=G.$();H=false;if(I||(!J||!J.getShowSubAttributesIndicator_Computed())){K.addClass("sapUiUx3ExactLstNoIco");H=I;}else{H=true;}if(H&&!I){K.attr("aria-label",s._rb.getText(K.hasClass("sapUiLbxISel")?"EXACT_LST_LIST_ITEM_SEL_ARIA_LABEL":"EXACT_LST_LIST_ITEM_ARIA_LABEL",[G.getText()]));}}var M=s._bRTL?"left":"right";q(".sapUiLbxITxt",this.getDomRef()).css("margin-"+M,20+q.sap.scrollbarSize().width+"px");q(".sapUiLbxIIco",this.getDomRef()).css(M,5+q.sap.scrollbarSize().width+"px");q(this.getDomRef()).attr("tabindex","-1");var N;if(I){N=s.getTopTitle();}else{N=s._rb.getText("EXACT_LST_LIST_ARIA_LABEL",[s._iLevel,s._getAtt().getText()]);}q(this.getFocusDomRef()).attr("aria-label",N).attr("aria-expanded","true");this.oItemNavigation.iActiveTabIndex=-1;this.oItemNavigation.setSelectedIndex(-1);this.oItemNavigation.onsapnext=function(O){if(O.keyCode!=q.sap.KeyCodes.ARROW_DOWN){return;}sap.ui.core.delegate.ItemNavigation.prototype.onsapnext.apply(this,arguments);};this.oItemNavigation.onsapprevious=function(O){if(O.keyCode!=q.sap.KeyCodes.ARROW_UP){return;}sap.ui.core.delegate.ItemNavigation.prototype.onsapprevious.apply(this,arguments);};},renderer:"sap.ui.commons.ListBoxRenderer"});E.prototype.init=function(){var i=this;this._iLevel=0;this._bCollapsed=false;this._bIsFirstRendering=true;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._lb=new E.LB(this.getId()+"-lb",{select:function(s){n(i);var K=s.getParameter("selectedItem").getKey();var F=sap.ui.getCore().byId(K);var S=s.getParameter("selectedIndex");if(i._lb.isIndexSelected(S)){F.setProperty("selected",true,true);var G=y(i,F);if(G){var H=e(i,F);if(H<0){i.addSubList(G);}else{i.insertSubList(G,H);}}}else{z(i,F,S);}B(i)._selectionChanged(F);}});this.addAggregation("controls",this._lb);this._closeHandle=q.proxy(this.onForceVerticalClose,this);};E.prototype.exit=function(){if(this.bIsDestroyed){return;}A(this);this._lb.removeAllItems();this._lb=null;this._closeHandle=null;this._scrollCheckHandle=null;this._rb={getText:function(){return"";}};this._oTopList=null;if(this._dirtyListsCleanupTimer){q.sap.clearDelayedCall(this._dirtyListsCleanupTimer);this._dirtyListsCleanupTimer=null;this._dirtyLists=null;}};E.prototype.getFocusDomRef=function(){if(this._isTop()&&this.$().hasClass("sapUiUx3ExactLstTopHidden")){return this.getDomRef("foc");}return this._bCollapsed?this.getDomRef("head"):this._lb.getFocusDomRef();};E.prototype.onBeforeRendering=function(){this._oTopList=null;if(!this._bIsFirstRendering){return;}this._bRTL=sap.ui.getCore().getConfiguration().getRTL();if(!this._isTop()){this._bCollapsed=true;this._oCollapseStyles={"cntnt":"margin-"+(this._bRTL?"right":"left")+":"+a.get("sapUiUx3ExactLstCollapseWidth")+";border-top-width:0px;","lst":"width:0px;"};}else{this._bIsFirstRendering=false;}};E.prototype.onAfterRendering=function(){var i=this;var I=this._isTop();if(!this._iCurrentWidth){this._iCurrentWidth=this._getAtt().getWidth();}if(I){this._iScrollWidthDiff=-1;this.onCheckScrollbar();this.$("lst").css("bottom",q.sap.scrollbarSize().height+"px");this.$("cntnt").bind("scroll",function(s){if(s.target.id===i.getId()+"-cntnt"&&s.target.scrollTop!=0){s.target.scrollTop=0;}});}if(!this._bCollapsed){m(this,this._iCurrentWidth);}n(this);if(this._bIsFirstRendering){this._bIsFirstRendering=false;u(this,false,null,true);}else{r(this);v(this);}if(this._bRefreshList){this._bRefreshList=false;setTimeout(function(){i._lb.invalidate();},0);}};E.prototype.onfocusin=function(i){if(i.target===this.getDomRef()){this.getFocusDomRef().focus();}var $=this.$("head");if(this._isTop()){$.attr("tabindex","-1");this.$("foc").attr("tabindex","-1");if(!c(this)&&i.target===$[0]){this.getFocusDomRef().focus();}if(this.$().hasClass("sapUiUx3ExactLstTopHidden")&&i.target===this.getDomRef("foc")){var s=this.getSubLists();if(s.length>0){s[0].getFocusDomRef().focus();}}}if(!i.__exactHandled){$.addClass("sapUiUx3ExactLstHeadFocus");i.__exactHandled=true;}};E.prototype.onfocusout=function(i){var $=this.$("head");if(this._isTop()){$.attr("tabindex","0");this.$("foc").attr("tabindex","0");}$.removeClass("sapUiUx3ExactLstHeadFocus");};E.prototype.onclick=function(i){var s=this._lb.getScrollTop();if(q(i.target).attr("id")==this.getId()+"-exp"){w(this);this.focus();i.stopPropagation();}else if(q(i.target).attr("id")==this.getId()+"-close"){x(this);}else if(q(i.target).attr("id")==this.getId()+"-hide"){u(this,!this._bCollapsed,i);}else if(this._isTop()&&c(this)&&q.sap.containsOrEquals(this.$("head")[0],i.target)){f(this,i,false);return;}else if(!q.sap.containsOrEquals(this.$("cntnt")[0],i.target)){this.focus();}this._lb.setScrollTop(s);};E.prototype.onkeydown=function(i){function _(i,T){if(q(T).hasClass("sapUiUx3ExactLstFoc")){return;}if(T){T.focus();}i.preventDefault();i.stopPropagation();}switch(i.keyCode){case q.sap.KeyCodes.ENTER:case q.sap.KeyCodes.SPACE:if(this._isTop()&&c(this)&&q.sap.containsOrEquals(this.$("head")[0],i.target)){f(this,i,true);}break;case q.sap.KeyCodes.DELETE:if(!this._isTop()&&this.getShowClose()){x(this);_(i,this.getParent().getFocusDomRef());}break;case q.sap.KeyCodes.NUMPAD_MINUS:if(i.shiftKey){if(!this._bCollapsed){m(this,this._iCurrentWidth-10);_(i);}}else if(!this._bCollapsed){u(this,true,i);}break;case q.sap.KeyCodes.NUMPAD_PLUS:if(i.shiftKey){if(!this._bCollapsed){m(this,this._iCurrentWidth+10);_(i);}}else if(this._bCollapsed){u(this,false,i);}break;case q.sap.KeyCodes.TAB:if(this._iLevel==0){var H=c(this);if(!i.shiftKey&&H&&q.sap.containsOrEquals(this.$("head")[0],i.target)){_(i,this.getFocusDomRef());}else if(q.sap.containsOrEquals(this.getFocusDomRef(),i.target)){if(i.shiftKey&&H){_(i,this.$("head")[0]);}else if(!i.shiftKey){var s=b(this);if(s){_(i,s.getFocusDomRef());}}}return;}if(this._iLevel==1){var s=null;if(i.shiftKey){if(q.sap.containsOrEquals(this.$("cntnt")[0],i.target)){s=this;}else{s=g(this);}}else{s=b(this);}if(s){_(i,s.getFocusDomRef());}i.stopPropagation();}break;case q.sap.KeyCodes.ARROW_LEFT:case q.sap.KeyCodes.ARROW_RIGHT:var s=null;if(this._iLevel>=1){if((this._bRTL&&i.keyCode===q.sap.KeyCodes.ARROW_LEFT)||(!this._bRTL&&i.keyCode===q.sap.KeyCodes.ARROW_RIGHT)){s=b(this,true);}else{s=g(this,true);}if(s){_(i,s.getFocusDomRef());}i.stopPropagation();}break;}};E.prototype.onmousedown=function(i){if(i.target.id===this.getId()+"-rsz"){q(document.body).append("<div id=\""+this.getId()+"-ghost\" class=\"sapUiUx3ExactLstRSzGhost\" style =\" z-index:"+P.getNextZIndex()+"\" ></div>");q(document.body).bind("selectstart."+this.getId(),o);var H=!!sap.ui.Device.browser.internet_explorer?q(document.body):this.$("ghost");H.bind("mouseup."+this.getId(),q.proxy(k,this)).bind("mousemove."+this.getId(),q.proxy(j,this));this._iStartDragX=i.pageX;this._iStartWidth=this.$("lst").width();this.$("rsz").addClass("sapUiUx3ExactLstRSzDrag");}};E.prototype.onForceVerticalClose=function(i){if(i.type=="mousedown"||i.type=="click"||i.type=="dblclick"||i.type=="focusin"||i.type=="focusout"||i.type=="keydown"||i.type=="keypress"||i.type=="keyup"||i.type=="mousedown"||i.type=="mouseup"){var R=this.$("lst");if(!q.sap.containsOrEquals(R[0],i.target)||i.target.tagName=="BODY"){if(R.hasClass("sapUiUx3ExactLstExpanded")){this._oPopup.close(true);}}}};E.prototype.onCheckScrollbar=function(i){this._scrollCheckTimer=null;var s=this.$("cntnt");var F=s[0];if(F){var N=F.scrollWidth-F.clientWidth;if(this._iScrollWidthDiff!=N){this._iScrollWidthDiff=N;if(N<=0){s.css({"overflow-x":"hidden","bottom":q.sap.scrollbarSize().height+"px"});}else{s.css({"overflow-x":"scroll","bottom":"0px"});}}this._scrollCheckTimer=q.sap.delayedCall(300,this,this.onCheckScrollbar);}};E.prototype.insertSubList=function(s,i){this.insertAggregation("subLists",s,i);if(s){p(s,this._iLevel+1);}return this;};E.prototype.addSubList=function(s){this.addAggregation("subLists",s);if(s){p(s,this._iLevel+1);}return this;};E.prototype.setData=function(s){if(s!=null&&typeof(s)!="string"){s=s.getId();}if(s){this.setAssociation("data",s);s=this._getAtt();this._lb.removeAllItems();if(!s){return this;}var F=s.getAttributesInternal(true);var S=[];var G=[];for(var i=0;i<F.length;i++){var I=D(F[i]);this._lb.addItem(I);if(F[i].getSelected()){var H=y(this,F[i]);if(H){G.push(H);}S.push(I.getKey());}}this._lb.setSelectedKeys(S);var O=this.getSubLists();for(var i=0;i<O.length;i++){var J=q.inArray(O[i],G);if(J>=0){if(s.getListOrder()!=sap.ui.ux3.ExactOrder.Fixed){G.splice(J,1);}}else{O[i]._lb.removeAllItems();O[i].destroy();}}if(s.getListOrder()===sap.ui.ux3.ExactOrder.Fixed){this.removeAllSubLists();}for(var i=0;i<G.length;i++){this.addSubList(G[i]);}var K=this;s.setChangeListener({id:K.getId(),_notifyOnChange:function(T,M){if(T==="width"){if(K._getAtt()===M&&K.getDomRef()){m(K,M.getWidth());}return;}var N=B(K);if(!N._dirtyLists){N._dirtyLists={};}if(!N._dirtyLists[K.getId()]){N._dirtyLists[K.getId()]=K;}if(!N._dirtyListsCleanupTimer){N._dirtyListsCleanupTimer=q.sap.delayedCall(0,N,function(){this._dirtyListsCleanupTimer=null;q.each(this._dirtyLists,function(i,H){if(H._lb&&H.getParent()){if(!H._isTop()){H.getParent().setData(H.getParent().getData());}else{H.setData(H.getData());}}});this._dirtyLists=null;},[]);}}});}return this;};E.prototype.setShowClose=function(s){if(this._isTop()){this.setProperty("showClose",s);}return this;};E.prototype.getShowClose=function(){return B(this).getProperty("showClose");};E.prototype.getTopTitle=function(){var T=this.getProperty("topTitle");return T?T:this._rb.getText("EXACT_BRWSR_LST_TITLE");};E.prototype._getAtt=function(){return sap.ui.getCore().byId(this.getData());};E.prototype._isTop=function(){return!(this.getParent()instanceof E);};E.prototype._selectionChanged=function(i){if(!this._isTop()){return;}i=sap.ui.getCore().byId(i.getId());var _=function(G,R){if(!G.getSelected()){return;}R.push(G);var V=G.getAttributesInternal();for(var F=0;F<V.length;F++){_(V[F],R);}};var s=[];var T=this._getAtt().getAttributesInternal();for(var F=0;F<T.length;F++){_(T[F],s);}this.fireAttributeSelected({attribute:i,allAttributes:s});};E.prototype._closeAll=function(){if(!this._isTop()){return;}var s=this;var F=function(){s._getAtt()._clearSelection();s._lb.clearSelection();s.fireAttributeSelected({attribute:undefined,allAttributes:[]});};var G=this.getSubLists();if(G.length>0){for(var i=0;i<G.length;i++){x(G[i],true,i==G.length-1?F:null);}}else{F();}};var g=function(i,s){function F(J){var K=J.getParent();var M=K.getSubLists();var N=K.indexOfSubList(J)-1;if(N>=0){return M[N];}return null;}function G(J){var S=J.getSubLists();if(S.length>0){return G(S[S.length-1]);}return J;}if(i._iLevel==0){return null;}else if(i._iLevel==1){if(s){return null;}var H=F(i);if(H){return H;}return i.getParent();}else if(i._iLevel>1){var H=F(i);if(H){return G(H);}var I=i.getParent();if(I._iLevel>=1){return I;}}return null;};var b=function(i,s){function F(I){var J=I.getParent();var K=J.getSubLists();var M=J.indexOfSubList(I)+1;if(M<K.length){return K[M];}return null;}function G(I){var S=I.getSubLists();if(S.length>0){return S[0];}return null;}function H(I){var J=F(I);if(J){return J;}var K=I.getParent();if(K._iLevel>(s?1:0)){return H(K);}else{return null;}}if(i._iLevel==0){return G(i);}else if(i._iLevel==1){return s?G(i):F(i);}else if(i._iLevel>1){var N=G(i);if(N){return N;}return H(i);}return null;};var f=function(i,s,K){i.fireEvent("_headerPress",{kexboard:K,domRef:i.$("head")});s.stopPropagation();};var c=function(i){return!d(i)&&i.$().hasClass("sapUiUx3ExactLstTopActive");};var d=function(i){return i.$().hasClass("sapUiUx3ExactLstTopHidden");};var e=function(s,F){if(s._getAtt().getListOrder()!=sap.ui.ux3.ExactOrder.Fixed){return-1;}var G=s._getAtt().getAttributes();var H=0;for(var i=0;i<G.length;i++){if(G[i]===F){break;}if(G[i].getChangeListener()){H++;}}return H;};var r=function(i){if(t(i)){i.$("lst").addClass("sapUiUx3ExactLstLstExp");if(!i._oPopup){var s=function(F){i._handleEvent(F);};i._oPopup=new P();if(!!!sap.ui.Device.browser.firefox){i._oPopup._fixPositioning=function(F,R){P.prototype._fixPositioning.apply(this,arguments);if(R){var $=this._$();var O=q(F.of);var G=0;if(F.offset){G=parseInt(F.offset.split(" ")[0],10);}$.css("right",(q(window).width()-O.outerWidth()-O.offset().left+G)+"px");}};}i._oPopup.open=function(){var F=i.$("lst");h(F,false,-1,function(R){F.addClass("sapUiUx3ExactLstExpanded");i.$("exp").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(true,false));i.__sOldHeight=F.css("height");F.css("height",i.__sOldHeight);var G=i.$("head");var H=q(i._lb.getDomRef());var I=H[0].scrollHeight+i.$("exp").height()+H.outerHeight()-H.height()+1;var M=q(window).height()-parseInt(H.offset().top,10)+q(window).scrollTop()-G.outerHeight();var T=Math.min(I,M);i._oPopup.setContent(F[0]);var O=a.get()["sapUiUx3ExactLst"+(i._isTop()?"Root":"")+"ExpandOffset"]||"0 0";P.prototype.open.apply(i._oPopup,[0,P.Dock.BeginTop,P.Dock.BeginBottom,G[0],O,"none none"]);i._bPopupOpened=true;return T;},function(R){F.addClass("sapUiUx3ExactLstExpandedBL");i._oPopup._updateBlindLayer();t(i);i.getFocusDomRef().focus();q.sap.bindAnyEvent(i._closeHandle);R.bind(q.sap.ControlEvents.join(" "),s);});};i._oPopup.close=function(S){var F=i.$("lst");F.removeClass("sapUiUx3ExactLstExpandedBL");h(F,false,i.__sOldHeight,function(R){q.sap.unbindAnyEvent(i._closeHandle);R.unbind(q.sap.ControlEvents.join(" "),s);F.removeClass("sapUiUx3ExactLstExpanded");i.$("exp").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(false,false));},function(R){R.detach();F.removeClass("sapUiShd");R.attr("style","width:"+i._iCurrentWidth+"px;");q(i.getDomRef()).prepend(R);i._oPopup.setContent(null);i._bPopupOpened=undefined;i.__sOldHeight=null;if(i._isTop()){R.css("bottom",q.sap.scrollbarSize().height+"px");}t(i);P.prototype.close.apply(i._oPopup,[0]);if(!S){i.getFocusDomRef().focus();}});};}}};var h=function(R,W,V,i,s){if(i){var F=i(R);if(F!=undefined){V=F;}}var _=s?function(){s(R);}:function(){};if(q.fx.off){if(W){R.width(V);}else{R.height(V);}_();}else{var G=W?{width:V}:{height:V};R.stop(true,true).animate(G,200,'linear',_);}};var o=function(i){i.preventDefault();i.stopPropagation();return false;};var j=function(i){var s=i.pageX;var F=this._bRTL?(this._iStartDragX-s):(s-this._iStartDragX);m(this,this._iStartWidth+F);};var k=function(i){q(document.body).unbind("selectstart."+this.getId()).unbind("mouseup."+this.getId()).unbind("mousemove."+this.getId());this.$("ghost").remove();this.$("rsz").removeClass("sapUiUx3ExactLstRSzDrag");this._iStartWidth=undefined;this._iStartDragX=undefined;this.focus();};var m=function(i,W){W=sap.ui.ux3.ExactAttribute._checkWidth(W);var s=i._bRTL?"right":"left";i._iCurrentWidth=W;i._getAtt()._setWidth(i._iCurrentWidth);i.$("lst").css("width",W+"px");i.$("rsz").css(s,(W-4)+"px");if(i._isTop()){if(!d(i)){i.$("head").css("width",W+"px");i.$("cntnt").css(s,(W+8)+"px");i.$("scroll").css(s,(W+8)+"px");}}else{if(!i.$().hasClass("sapUiUx3ExactLstCollapsed")){i.$("cntnt").css("margin-"+s,W+"px");}}};var n=function(i){var s=i._getAtt();if(s&&!i._isTop()){i.$("head-txt").html(q.sap.encodeHTML(s.getText())+"<span class=\"sapUiUx3ExactLstHeadInfo\">&nbsp;("+i._lb.getSelectedIndices().length+"/"+i._lb.getItems().length+")</span>");}};var p=function(s,F){s._iLevel=F;var G=s.getSubLists();for(var i=0;i<G.length;i++){p(G[i],F+1);}};var t=function(i){if(i._lb){var s=q(i._lb.getDomRef());i.$("lst").removeClass("sapUiUx3ExactLstScroll");if(s.length>0&&s.outerHeight()<s[0].scrollHeight){i.$("lst").addClass("sapUiUx3ExactLstScroll");return true;}}return false;};var u=function(i,s,F,S){if(F){F.preventDefault();F.stopPropagation();}if(i._isTop()){return;}if(i._bCollapsed!=s){var G=!!F;var H={};H["margin-"+(i._bRTL?"right":"left")]=(i._bCollapsed?(i._iCurrentWidth+"px"):a.get("sapUiUx3ExactLstCollapseWidth"));H["border-top-width"]=(i._bCollapsed?a.get("sapUiUx3ExactLstContentTop"):"0px");var $=i.$("cntnt");if(q.fx.off){for(var I in H){$.css(I,H[I]);}}else{$.stop(true,true).animate(H,200,'linear');}if(i._bCollapsed){h(i.$("lst"),true,i._iCurrentWidth+"px",function(){q(i.getDomRef()).removeClass("sapUiUx3ExactLstCollapsed");i.$("head").css("overflow","hidden");},function(R){i.$("hide").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(true,true)).attr("title",i._rb.getText("EXACT_LST_LIST_COLLAPSE"));if(G){i.focus();}var M=i.$("head");i.$("head-txt").removeAttr("style");M.removeAttr("style");R.removeAttr("style");r(i);m(i,i._iCurrentWidth);v(i);M.removeAttr("role");M.removeAttr("aria-label");M.removeAttr("aria-expanded");var N=i._getAtt();if(N&&N._scrollToAttributeId){N.scrollTo(sap.ui.getCore().byId(N._scrollToAttributeId));}});i._oCollapseStyles=undefined;}else{i._oCollapseStyles={};h(i.$("lst"),true,0,null,function(){q(i.getDomRef()).addClass("sapUiUx3ExactLstCollapsed");i.$("hide").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(false,true)).attr("title",i._rb.getText("EXACT_LST_LIST_EXPAND"));if(G){i.focus();}v(i);var M=i.$("head");M.attr("role","region");M.attr("aria-label",i._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL",[i._iLevel,i._getAtt().getText()]));M.attr("aria-expanded","false");});var J=[];for(var I in H){J.push(I,":",H[I],";");}i._oCollapseStyles["cntnt"]=J.join("");i._oCollapseStyles["lst"]="width:0px;";}i._bCollapsed=!i._bCollapsed;}if(S){return;}var K=i.getParent();if(!i._isTop()&&K&&K._isTop&&!K._isTop()){u(K,s);}};var v=function(s){if(s._bCollapsed){var W=s.$("cntnt").height()-50;var $=s.$("head-txt");$.css("width",W+"px");if(q("html").attr("data-sap-ui-browser")=="ie8"){var F=75-(90-W);$.css("bottom",F+"px");}}var S=s.getSubLists();for(var i=0;i<S.length;i++){v(S[i]);}};var w=function(i){var s=i.$("lst");if(s.hasClass("sapUiUx3ExactLstExpanded")){i._oPopup.close();}else{i._oPopup.open();}};var x=function(i,s,F){var G=function(R){if(!s){var I=i._getAtt();var S=I.getParent().indexOfAttribute(I);z(i.getParent(),I,S,true);n(i.getParent());B(i)._selectionChanged(I);}i.destroy();if(F){F();}};var H=i.getDomRef();if(H){h(q(H),true,0,function(R){R.css("overflow","hidden");},G);}else{G();}};var y=function(i,s){if(s.getSelected()){var F=s.getAttributesInternal(true);if(F.length>0){var S;if(s.getChangeListener()){S=sap.ui.getCore().byId(s.getChangeListener().id);}else{S=new E();}S.setData(s);return S;}}return null;};var z=function(s,F,S,G){s._lb.removeSelectedIndex(S);F._clearSelection();if(!G){var H=s.getSubLists();for(var i=0;i<H.length;i++){if(H[i].getData()===F.getId()){x(H[i],true);}}}};var A=function(i){var s=i._getAtt();if(s&&s.getChangeListener()&&s.getChangeListener().id===i.getId()){s.setChangeListener(null);}};var B=function(i){if(i._isTop()){return i;}if(!i._oTopList){i._oTopList=B(i.getParent());}return i._oTopList;};var D=function(i){var I;if(i.__oItem){I=i.__oItem;if(I.getText()!=i.getText()){I.setText(i.getText());}if(I.getKey()!=i.getId()){I.setKey(i.getId());}}else{I=new sap.ui.core.ListItem({text:i.getText(),key:i.getId()});i.exit=function(){if(sap.ui.ux3.ExactAttribute.prototype.exit){sap.ui.ux3.ExactAttribute.prototype.exit.apply(i,[]);}this.__oItem.destroy();this.__oItem=null;};i.__oItem=I;}return I;};}());return E;},true);
