/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ComboBoxBase','./ComboBoxRenderer','./library'],function(q,C,a,l){"use strict";var b=C.extend("sap.m.ComboBox",{metadata:{library:"sap.m",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});function h(i){var d=this.getFocusDomRef(),s=d.selectionStart,S=d.selectionEnd,I=s!==S,t=d.value.substring(0,d.selectionStart),o=this.getSelectedItem();if(i&&(i!==o)){this.updateDomValue(i.getText());this.setSelection(i,{suppressInvalidate:true});this.fireSelectionChange({selectedItem:i});i=this.getSelectedItem();if(!q.sap.startsWithIgnoreCase(i.getText(),t)||!I){s=0;}this.selectText(s,d.value.length);}this.scrollToItem(this.getList().getSelectedItem());}b.prototype._createPopover=function(){var p=new sap.m.Popover({showHeader:false,placement:sap.m.PlacementType.Vertical,offsetX:0,offsetY:0,initialFocus:this,bounce:false});this._decoratePopover(p);return p;};b.prototype._decoratePopover=function(p){var t=this;p._removeArrow=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];};p._setPosition=function(){this._myPositions=["begin bottom","begin center","begin top","end center"];this._atPositions=["begin top","end center","begin bottom","begin center"];};p._setArrowPosition=function(){};p.open=function(){return this.openBy(t.getFocusDomRef());};};b.prototype.onAfterRenderingPopover=function(){var p=this.getPicker();p._removeArrow();p._setPosition();};b.prototype._createDialog=function(){var c=sap.m.ComboBoxBaseRenderer.CSS_CLASS;var d=new sap.m.Dialog({stretchOnPhone:true,customHeader:new sap.m.Bar({contentLeft:new sap.m.InputBase({value:this.getSelectedItem().getText(),width:"100%",editable:false}).addStyleClass(c+"Input")}).addStyleClass(c+"Bar")});d.getAggregation("customHeader").attachBrowserEvent("tap",function(){d.close();},this);return d;};b.prototype.onBeforeOpenDialog=function(){var H=this.getPicker().getCustomHeader();H.getContentLeft()[0].setValue(this.getSelectedItem().getText());};b.prototype.onBeforeRendering=function(){C.prototype.onBeforeRendering.apply(this,arguments);this.synchronizeSelection();this._clearList();this._fillList(this.getItems());};b.prototype.oninput=function(e){C.prototype.oninput.apply(this,arguments);if(!this.getEditable()){return;}var s=this.getSelectedItem(),I=this.getItems(),o=e.target,v=o.value,f=true,V=false,c,m,L,i=0;for(;i<I.length;i++){c=I[i];m=q.sap.startsWithIgnoreCase(c.getText(),v);L=this.getListItem(c);if(v===""){m=true;}L.setVisible(m);if(m&&!V){V=true;}if(f&&m&&v!==""){f=false;if(this._bDoTypeAhead){this.updateDomValue(c.getText());}this.setSelection(c,{suppressInvalidate:true});if(s!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}if(this._bDoTypeAhead){this.selectText(v.length,9999999);}this.scrollToItem(this.getList().getSelectedItem());}}if(v===""||!V){this.setSelection(null,{suppressInvalidate:true});if(s!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}}if(V){this.open();}else{this.isOpen()?this.close():this.clearFilter();}};b.prototype.onSelectionChange=function(c){var L=c.getParameter("listItem"),n=this._findMappedItem(L),v;if((L.getType()==="Inactive")||!this.getEnabled()||!this.getEditable()){return;}if(n){this.updateDomValue(n.getText());this.setSelection(n,{suppressInvalidate:true,listItemUpdated:true});this.fireSelectionChange({selectedItem:this.getSelectedItem()});v=this.getValue();if(sap.ui.Device.system.desktop){q.sap.delayedCall(0,this,"selectText",[v.length,v.length]);}}};b.prototype.onItemPress=function(){this.close();};b.prototype.onkeydown=function(e){C.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();var k=q.sap.KeyCodes;this._bDoTypeAhead=(e.which!==k.BACKSPACE)&&(e.which!==k.DELETE);};b.prototype.oncut=function(e){C.prototype.oncut.apply(this,arguments);this._bDoTypeAhead=false;};b.prototype.onsapenter=function(e){C.prototype.onsapenter.apply(this,arguments);e.setMarked();if(!this.getEnabled()||!this.getEditable()){return;}var v=this.getValue();this.setValue(v);this.selectText(v.length,v.length);if(this.isOpen()){this.close();}};b.prototype.onsapdown=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var n,s=this.getSelectableItems();n=s[s.indexOf(this.getSelectedItem())+1];h.call(this,n);};b.prototype.onsapup=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var p,s=this.getSelectableItems();p=s[s.indexOf(this.getSelectedItem())-1];h.call(this,p);};b.prototype.onsaphome=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var f=this.getSelectableItems()[0];h.call(this,f);};b.prototype.onsapend=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var L=this.findLastEnabledItem(this.getSelectableItems());h.call(this,L);};b.prototype.onsappagedown=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var s=this.getSelectableItems(),i=s.indexOf(this.getSelectedItem())+10,I;i=(i>s.length-1)?s.length-1:Math.max(0,i);I=s[i];h.call(this,I);};b.prototype.onsappageup=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var s=this.getSelectableItems(),i=s.indexOf(this.getSelectedItem())-10,I;i=(i>s.length-1)?s.length-1:Math.max(0,i);I=s[i];h.call(this,I);};b.prototype.onfocusin=function(e){this.$().addClass("sapMComboBoxFocused");if(e.target===this.getOpenArea()){this.bCanNotOpenMessage=true;if(sap.ui.Device.system.desktop){this.focus();}}else{if(sap.ui.Device.system.desktop){q.sap.delayedCall(0,this,function(){if(document.activeElement===this.getFocusDomRef()){this.selectText(0,this.getValue().length);}});}if(!this.isOpen()&&!this.bCanNotOpenMessage){this.openValueStateMessage();}this.bCanNotOpenMessage=false;}};b.prototype.onsapfocusleave=function(e){var p=this.getAggregation("picker");this.$().removeClass("sapMComboBoxFocused");if(!e.relatedControlId||!p){return;}var c=sap.ui.getCore().byId(e.relatedControlId),f=c&&c.getFocusDomRef();if(q.sap.containsOrEquals(p.getFocusDomRef(),f)){if(sap.ui.Device.system.desktop){this.focus();}}};b.prototype.setSelection=function(i,o){var L,d,A="aria-activedescendant";o=o||{};this.setAssociation("selectedItem",i||null,o.suppressInvalidate);this.setProperty("selectedItemId",(i instanceof sap.ui.core.Item)?i.getId():i,o.suppressInvalidate);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setProperty("selectedKey",i?i.getKey():"",o.suppressInvalidate);L=this.getListItem(i);d=this.getFocusDomRef();if(d){if(i&&L&&L.getDomRef()&&this.isOpen()){d.setAttribute(A,L.getId());}else{d.removeAttribute(A);}}if(!o.listItemUpdated){if(L){this.getList().setSelectedItem(L,true);}else if(this.getList()){if(this.getDefaultSelectedItem()){this.getList().setSelectedItem(this.getListItem(this.getDefaultSelectedItem()),true);}else if(this.getList().getSelectedItem()){this.getList().setSelectedItem(this.getList().getSelectedItem(),false);}}}};b.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};b.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText());}}};b.prototype.isFiltered=function(){return this.getVisibleItems().length!==this.getItems().length;};b.prototype.createPicker=function(p){var P=this.getAggregation("picker");if(P){return P;}P=this["_create"+p]();this.setAggregation("picker",P,true);P.setHorizontalScrolling(false).addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Picker").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return P;};b.prototype.createList=function(){this._oList=new sap.m.List({width:"100%",mode:sap.m.ListMode.SingleSelectMaster,rememberSelections:false}).addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"List").attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);};b.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this);};b.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this);};b.prototype.onBeforeOpen=function(){var p=this["onBeforeOpen"+this.getPickerType()],d=this.getFocusDomRef();this.addStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Pressed");if(d){d.setAttribute("aria-owns",this.getList().getId());}this.addContent();p&&p.call(this);};b.prototype.onBeforeOpenPopover=function(){var d=this.getDomRef();if(d){this.getPicker().setContentWidth((d.offsetWidth/parseFloat(sap.m.BaseFontSize))+"rem");}};b.prototype.onAfterOpen=function(){var d=this.getFocusDomRef(),L=this.getListItem(this.getSelectedItem());if(d){d.setAttribute("aria-expanded","true");L&&d.setAttribute("aria-activedescendant",L.getId());}};b.prototype.onBeforeClose=function(){var d=this.getFocusDomRef();if(d){d.removeAttribute("aria-owns");d.removeAttribute("aria-activedescendant");}this.removeStyleClass(sap.m.ComboBoxBaseRenderer.CSS_CLASS+"Pressed");};b.prototype.onAfterClose=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("aria-expanded","false");}if(document.activeElement===d){this.openValueStateMessage();}this.clearFilter();};b.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};b.prototype.getDefaultSelectedItem=function(){return null;};b.prototype.clearSelection=function(){this.setSelection(null);};b.prototype.selectText=function(s,S){C.prototype.selectText.apply(this,arguments);this.textSelectionStart=s;this.textSelectionEnd=S;return this;};b.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(!(i instanceof sap.ui.core.Item)&&i!==null){q.sap.log.warning('Warning: setSelectedItem() "vItem" has to be an instance of sap.ui.core.Item, a valid sap.ui.core.Item id, or null on',this);return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i,{suppressInvalidate:true});if(i){this.setValue(i.getText(),true);}else if(i=this.getDefaultSelectedItem()){this.setValue(i.getText(),true);}else{this.setValue("",true);}return this;};b.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i,{suppressInvalidate:true});i=this.getSelectedItem();if(i){this.setValue(i.getText(),true);}else if(i=this.getDefaultSelectedItem()){this.setValue(i.getText(),true);}else{this.setValue("",true);}return this;};b.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var i=this.getItemByKey(k);if(i||(k==="")){if(!i&&k===""){i=this.getDefaultSelectedItem();}this.setSelection(i,{suppressInvalidate:true});if(i){this.setValue(i.getText(),true);}else if(i=this.getDefaultSelectedItem()){this.setValue(i.getText(),true);}else{this.setValue("",true);}return this;}this._sValue=this.getValue();return this.setProperty("selectedKey",k);};b.prototype.getSelectedItem=function(){var s=this.getAssociation("selectedItem");return(s===null)?null:sap.ui.getCore().byId(s)||null;};b.prototype.removeItem=function(i){i=C.prototype.removeItem.call(this,i);var v=this.getValue(),I;if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){I=this.getDefaultSelectedItem();this.setSelection(I);this.setValue(v);}return i;};return b;},true);
