/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./DatePicker','./library'],function(q,D,l){"use strict";var a=D.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}},events:{change:{parameters:{from:{type:"object"},to:{type:"object"}}}}}});(function(){a.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};a.prototype.onkeypress=function(e){if(e.charCode){var t=this;var f=d(t);var s=c(t);var A=f.sAllowedCharacters+s+" ";var C=String.fromCharCode(e.charCode);if(C&&f.sAllowedCharacters&&A.indexOf(C)<0){e.preventDefault();}}};a.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this.getDisplayFormat();if(!p){p="medium";}if(p==="short"||p==="medium"||p==="long"){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);p=o.getDatePattern(p);}var t=this;var s=c(t);if(s&&s!==""){p=p+" "+s+" "+p;}}return p;};a.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v,true);this._bValid=true;var e=[undefined,undefined];if(v){e=this._parseValue(v);e=b(this,e[0],e[1]);if(!e[0]){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid dates",this);}}if(this._bValid){this.setProperty("dateValue",e[0],true);this.setProperty("secondDateValue",e[1],true);}if(this.getDomRef()){var o=this._formatValue(e[0],e[1]);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};a.prototype.setFrom=function(f){this.setDateValue(f);};a.prototype.getFrom=function(){return this.getDateValue();};a.prototype.setTo=function(t){this.setSecondDateValue(t);};a.prototype.getTo=function(){return this.getSecondDateValue();};a.prototype.setDateValue=function(o){if(q.sap.equal(this.getDateValue(),o)){return this;}if(o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime())){this._bValid=false;}else{this._bValid=true;this.setProperty("dateValue",o,true);}var s=this.getSecondDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};a.prototype.setSecondDateValue=function(s){if(q.sap.equal(this.getSecondDateValue(),s)){return this;}if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;}else{this._bValid=true;this.setProperty("secondDateValue",s,true);}var o=this.getDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};a.prototype._parseValue=function(v){var f;var e=[];var o,g;var t=this;var s=c(t);if((s&&s!=="")&&v){e=v.split(s);if(e.length===2){if(e[0].slice(e[0].length-1,e[0].length)==" "){e[0]=e[0].slice(0,e[0].length-1);}if(e[1].slice(0,1)==" "){e[1]=e[1].slice(1);}}else{e=v.split(" "+s+" ");}if(e.length<2){var h=v.split(" ");if(h.length===2){e=h;}}}if(v&&e.length<=2){f=d(t);if((!s||s==="")||e.length===1){o=f.parse(v);}else if(e.length===2){o=f.parse(e[0]);g=f.parse(e[1]);if(!o||!g){o=undefined;g=undefined;}}}return[o,g];};a.prototype._formatValue=function(o,s){var v="";var t=this;var e=c(t);if(o){var f;f=d(t);if(e&&e!==""&&s){v=f.format(o)+" "+e+" "+f.format(s);}else{v=f.format(o);}}return v;};a.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var e=[undefined,undefined];this._bValid=true;if(v!=""){e=this._parseValue(v);e=b(this,e[0],e[1]);if(e[0]){v=this._formatValue(e[0],e[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",e[0],true);this.setProperty("secondDateValue",e[1],true);}this._setLabelVisibility();this._lastValue=v;if(this._oPopup&&this._oPopup.isOpen()){var s=this.getDateValue();if(s){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));this._oCalendar.focusDate(s);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));this._oCalendar.focusDate(E);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}var t=this;_(t,this._bValid);}};a.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);return v;};a.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var e=this._parseValue(v);v=this._formatValue(e[0],e[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}this._setLabelVisibility();return this;};a.prototype._setLabelVisibility=function(){if(!this._bShowLabelAsPlaceholder||!this._$label||!this.isActive()){return;}var v=this._$input.val();this._$label.css("display",v?"none":"inline");};a.prototype.onsappageup=function(){};a.prototype.onsappageupmodifiers=function(){};a.prototype.onsappagedown=function(){};a.prototype.onsappagedownmodifiers=function(){};a.prototype._fillDateRange=function(){D.prototype._fillDateRange.apply(this,arguments);var e=this.getSecondDateValue();if(e){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==e.getTime()){this._oDateRange.setEndDate(new Date(e.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};a.prototype._selectDate=function(e){var s=this._oCalendar.getSelectedDates();if(s.length>0){var o=s[0].getStartDate();var f=s[0].getEndDate();if(o&&f){var g=this.getDateValue();var h=this.getSecondDateValue();this._oPopup.close();this._bFocusNoPopup=true;this.focus();var v;var t=this;if(!q.sap.equal(o,g)||!q.sap.equal(f,h)){if(q.sap.equal(f,h)){this.setDateValue(o);}else{this.setProperty("dateValue",o,true);this.setSecondDateValue(f);}v=this.getValue();_(t,true);this._curpos=v.length;this._$input.cursorPos(this._curpos);}else if(!this._bValid){v=this._formatValue(o,f);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);}_(t,true);}}if(sap.ui.Device.browser.mobile){window.document.activeElement.blur();}}}};function _(t,v){t.fireChangeEvent(t.getValue(),{from:t.getDateValue(),to:t.getSecondDateValue(),valid:v});}function b(t,o,s){if(o&&s&&o.getTime()>s.getTime()){var T=o;o=s;s=T;}if((o&&(o.getTime()<t._oMinDate.getTime()||o.getTime()>t._oMaxDate.getTime()))||(s&&(s.getTime()<t._oMinDate.getTime()||s.getTime()>t._oMaxDate.getTime()))){return[undefined,undefined];}else{return[o,s];}}function c(t){var s=t.getDelimiter();if(!s){if(!t._sLocaleDelimiter){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);var p=o.getIntervalPattern();var i=p.indexOf("{0}")+3;var I=p.indexOf("{1}");s=p.slice(i,I);if(s.length>1){if(s.slice(0,1)==" "){s=s.slice(1);}if(s.slice(s.length-1,s.length)==" "){s=s.slice(0,s.length-1);}}t._sLocaleDelimiter=s;}else{s=t._sLocaleDelimiter;}}return s;}function d(t){var p=(t.getDisplayFormat()||"medium");var f;if(p==t._sUsedDisplayPattern){f=t._sDisplayFormat;}else{if(p==="short"||p==="medium"||p==="long"){f=sap.ui.core.format.DateFormat.getInstance({style:p,strictParsing:true});}else{f=sap.ui.core.format.DateFormat.getInstance({pattern:p,strictParsing:true});}t._sUsedDisplayPattern=p;t._sDisplayFormat=f;}return f;}}());return a;},true);
