/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/LocaleData'],function(q,L){"use strict";var N=sap.ui.base.Object.extend("sap.ui.core.format.NumberFormat",{constructor:function(f){throw new Error();}});var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",PERCENT:"percent"};var g={ARABIC:"arabic",INDIAN:"indian"};var r={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var R={};R[r.FLOOR]=Math.floor;R[r.CEILING]=Math.ceil;R[r.TOWARDS_ZERO]=function(d){return d>0?Math.floor(d):Math.ceil(d);};R[r.AWAY_FROM_ZERO]=function(d){return d>0?Math.ceil(d):Math.floor(d);};R[r.HALF_TOWARDS_ZERO]=function(d){return d>0?Math.ceil(d-0.5):Math.floor(d+0.5);};R[r.HALF_AWAY_FROM_ZERO]=function(d){return d>0?Math.floor(d+0.5):Math.ceil(d-0.5);};R[r.HALF_FLOOR]=function(d){return Math.ceil(d-0.5);};R[r.HALF_CEILING]=Math.round;N.RoundingMode=r;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingType:g.ARABIC,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingType:g.ARABIC,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingType:g.ARABIC,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingType:g.ARABIC,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO};N.getInstance=function(f,l){return this.getFloatInstance(f,l);};N.getFloatInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.FLOAT);F.oFormatOptions=q.extend(false,{},this.oDefaultFloatFormat,o,f);return F;};N.getIntegerInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.INTEGER);F.oFormatOptions=q.extend(false,{},this.oDefaultIntegerFormat,o,f);return F;};N.getCurrencyInstance=function(f,l){var F=this.createInstance(f,l),C=f&&f.currencyContext,o=this.getLocaleFormatOptions(F.oLocaleData,n.CURRENCY,C);F.oFormatOptions=q.extend(false,{},this.oDefaultCurrencyFormat,o,f);return F;};N.getPercentInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.PERCENT);F.oFormatOptions=q.extend(false,{},this.oDefaultPercentFormat,o,f);return F;};N.createInstance=function(f,l){var F=q.sap.newObject(this.prototype),p;if(f instanceof sap.ui.core.Locale){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}F.oLocale=l;F.oLocaleData=L.getInstance(l);if(f&&f.pattern){p=this.parseNumberPattern(f.pattern);q.each(p,function(s,o){f[s]=o;});}return F;};N.getLocaleFormatOptions=function(l,t,C){var o={},s;switch(t){case n.PERCENT:s=l.getPercentPattern();break;case n.CURRENCY:s=l.getCurrencyPattern(C);break;default:s=l.getDecimalPattern();}o=this.parseNumberPattern(s);o.plusSign=l.getNumberSymbol("plusSign");o.minusSign=l.getNumberSymbol("minusSign");o.decimalSeparator=l.getNumberSymbol("decimal");o.groupingSeparator=l.getNumberSymbol("group");o.percentSign=l.getNumberSymbol("percentSign");o.pattern=s;switch(t){case n.FLOAT:case n.PERCENT:o.minFractionDigits=0;o.maxFractionDigits=99;break;case n.INTEGER:o.minFractionDigits=0;o.maxFractionDigits=0;o.groupingEnabled=false;break;case n.CURRENCY:o.minFractionDigits=undefined;o.maxFractionDigits=undefined;break;}return o;};N.parseNumberPattern=function(f){var m=0;var M=0;var d=0;var G=false;var s=g.ARABIC;var S=f.indexOf(";");if(S!==-1){f=f.substring(0,S);}var e=0;for(var i=0;i<f.length;i++){var C=f[i];if(C===","){if(G){s=g.INDIAN;}G=true;continue;}else if(C==="."){e=1;continue;}else if(e==0&&C==="0"){m++;}else if(e==1){if(C==="0"){M++;d++;}else if(C==="#"){d++;}}}return{minIntegerDigits:m,minFractionDigits:M,maxFractionDigits:d,groupingEnabled:G,groupingType:s};};N.prototype.format=function(v,m){if(q.isArray(v)){m=v[1];v=v[0];}var i="",f="",G="",s="",d="",p="",P=0,l=0,e=0,h=v<0,D=-1,o=q.extend({},this.oFormatOptions),j;if(o.decimals!==undefined){o.minFractionDigits=o.decimals;o.maxFractionDigits=o.decimals;}var S=a(v,this.oFormatOptions.style,this.oLocaleData);if(S){if(o.shortDecimals!==undefined){o.minFractionDigits=o.shortDecimals;o.maxFractionDigits=o.shortDecimals;}v=v/S.magnitude;}if(o.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(o.type==n.CURRENCY){var k=this.oLocaleData.getCurrencyDigits(m);if(o.maxFractionDigits===undefined){o.maxFractionDigits=k;}if(o.minFractionDigits===undefined){o.minFractionDigits=k;}}if(typeof v=="number"){v=c(v,o);}d=this.convertToDecimal(v);if(d=="NaN"){return d;}if(h){d=d.substr(1);}D=d.indexOf(".");if(D>-1){i=d.substr(0,D);f=d.substr(D+1);}else{i=d;}if(i.length<o.minIntegerDigits){i=q.sap.padLeft(i,"0",o.minIntegerDigits);}else if(i.length>o.maxIntegerDigits){i=q.sap.padLeft("","?",o.maxIntegerDigits);}if(f.length<o.minFractionDigits){f=q.sap.padRight(f,"0",o.minFractionDigits);}else if(f.length>o.maxFractionDigits){f=f.substr(0,o.maxFractionDigits);}l=i.length;if(o.groupingEnabled&&l>3){if(o.groupingType==g.ARABIC){P=l%3||3;e=3;}else{P=l%2+1||3;e=2;}G=i.substr(0,P);while(P<i.length-1){G+=o.groupingSeparator;G+=i.substr(P,e);P+=e;}G+=i.substr(P);i=G;}if(h){s=o.minusSign;}s+=i;if(f){s+=o.decimalSeparator+f;}if(S&&S.formatString){s=S.formatString.replace(S.valueSubString,s);s=s.replace(/'.'/g,".");}if(o.type==n.CURRENCY){p=o.pattern;j=p.split(";");if(j.length===2){p=h?j[1]:j[0];if(h){s=s.substring(1);}}if(!o.currencyCode){m=this.oLocaleData.getCurrencySymbol(m);}if(o.showMeasure&&m){p=p.replace(/\u00a4/,m);}else{p=p.replace(/\s*\u00a4\s*/,"");}if(h){p=p.replace(/-/,o.minusSign);}p=p.replace(/[0#.,]+/,s);s=p;}if(o.type==n.PERCENT){p=o.pattern;s=p.replace(/[0#.,]+/,s);s=s.replace(/%/,o.percentSign);}if(sap.ui.getCore().getConfiguration().getOriginInfo()){s=new String(s);s.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return s;};N.prototype.parse=function(v){var o=this.oFormatOptions,s="^\\s*([+-]?(?:[0-9\\"+o.groupingSeparator+"]+|[0-9\\"+o.groupingSeparator+"]*\\"+o.decimalSeparator+"[0-9]+)(?:[eE][+-][0-9]+)?)\\s*$",d="^\\s*([+-]?[0-9\\"+o.groupingSeparator+"]+)\\s*$",G=new RegExp("\\"+o.groupingSeparator,"g"),D=new RegExp("\\"+o.decimalSeparator,"g"),p=this.oLocaleData.getPercentPattern(),P=this.oLocaleData.getNumberSymbol("percentSign"),e,f,h,i,j,C,k=0;if(p.charAt(0)==="%"){s=s.slice(0,1)+"%?"+s.slice(1);}else if(p.charAt(p.length-1)==="%"){s=s.slice(0,s.length-1)+"%?"+s.slice(s.length-1);}v=v.replace(/\s/g,"");var S=b(v,this.oFormatOptions.style,this.oLocaleData);v=S.number;if(o.isInteger){e=new RegExp(d);}else if(o.type===n.CURRENCY){i="[^\\d\\s+-]*";h="(?:^("+i+")"+s.substring(1,s.length-1)+"$)|(?:^"+s.substring(1,s.length-1)+"("+i+")\\s*$)";e=new RegExp(h);}else{e=new RegExp(s);}if(!e.test(v)){return o.type===n.CURRENCY?null:NaN;}if(o.type===n.CURRENCY){j=e.exec(v);if(j[2]){v=j[2];C=j[1]||undefined;}else{v=j[3];C=j[4]||undefined;}if(C&&!o.showMeasure){return null;}}if(C){C=this.oLocaleData.getCurrencyCodeBySymbol(C)||C;}v=v.replace(G,"");v=v.replace(/^\+/,"");if(o.isInteger){k=o.parseAsString?v:parseInt(v,10);}else{v=v.replace(D,".");if(v.indexOf(P)!==-1){f=true;v=v.replace(P,"");}k=o.parseAsString?v:parseFloat(v);if(f){k=N._shiftDecimalPoint(k,-2);}}if(S.factor>1||o.parseAsString){k=N._shiftDecimalPoint(k,Math.round(Math.log(S.factor)/Math.LN10));}return o.type===n.CURRENCY?[k,C]:k;};N.prototype.convertToDecimal=function(v){var V=""+v,d,B,D,f,e,p;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var h=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);d=h[1]=="-";B=h[2].replace(/\./g,"");D=h[3]?h[3].length:0;f=h[4]?h[4].length:0;e=parseInt(h[5],10);if(e>0){if(e<f){p=D+e;V=B.substr(0,p)+"."+B.substr(p);}else{V=B;e-=f;for(var i=0;i<e;i++){V+="0";}}}else{if(-e<D){p=D+e;V=B.substr(0,p)+"."+B.substr(p);}else{V=B;e+=D;for(var i=0;i>e;i--){V="0"+V;}V="0."+V;}}if(d){V="-"+V;}return V;};N._shiftDecimalPoint=function(v,s){if(typeof s!=="number"){return NaN;}var e=v.toString().toLowerCase().split("e");if(typeof v==="number"){s=e[1]?(+e[1]+s):s;return+(e[0]+"e"+s);}else if(typeof v==="string"){if(parseInt(v,10)===0&&s>=0){return v;}v=e[0];var d=v.indexOf("."),A,i,D;if(d===-1){v=v+".";d=v.length-1;}if(e[1]){d+=(+e[1]);}A=d+s;if(A<=0){v=q.sap.padLeft(v,'0',v.length-A+1);A=1;}else if(A>=v.length-1){v=q.sap.padRight(v,'0',A+1);A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);D=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return i+(D?("."+D):"");}else{return null;}};function a(v,s,l){var S;if(s!="short"&&s!="long"){return S;}var k=1;while(Math.abs(v)>=k*10&&k<1e14){k=k*10;}var f=v/k;var p="other";if(f==0){p="zero";}else if(f==1){p="one";}else if(f==2){p="two";}else if(f>2&&f<=5){p="few";}else if(f>5&&f<=10){p="many";}var C=l.getDecimalFormat(s,k.toString(),p);if(!C){return S;}S={};if(!C||C=="0"){S.magnitude=1;}else{S.formatString=C;var m=C.match(/0+\.*0*/);if(m){S.valueSubString=m[0];var d=S.valueSubString.indexOf(".");if(d==-1){S.decimals=0;S.magnitude=k*Math.pow(10,1-S.valueSubString.length);}else{S.decimals=S.valueSubString.length-d-1;S.magnitude=k*Math.pow(10,1-d);}}else{S.magnitude=1;}}return S;}function b(v,s,l){var d;var f=1;if(s!="short"&&s!="long"){return{number:v,factor:f};}var k=10;var p;var C;while(k<1e14){for(var i=0;i<6;i++){switch(i){case 0:p="zero";break;case 1:p="one";break;case 2:p="two";break;case 3:p="few";break;case 4:p="many";break;default:p="other";}C=l.getDecimalFormat(s,k.toString(),p);if(C){C=C.replace(/[\s\u00a0]/g,"");var m=C.match(/0+\.*0*/);if(m){var V=m[0];var u=C.replace(V,"");var I=v.indexOf(u);if(I>=0){d=v.replace(u,"");f=k;break;}}}}if(d){break;}k=k*10;}if(!d){d=v;}return{number:d,factor:f};}function c(v,o){if(typeof v!=="number"){return NaN;}var s=o.roundingMode||N.RoundingMode.HALF_AWAY_FROM_ZERO,m=parseInt(o.maxFractionDigits,10);if(typeof s==="function"){v=s(v,m);}else{if(!m){return R[s](v);}v=N._shiftDecimalPoint(R[s](N._shiftDecimalPoint(v,m)),-m);}return v;}return N;},true);
