/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./library'],function(q,C,L,D,a,H,M,b,Y,l){"use strict";var c=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",properties:{intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},months:{type:"int",group:"Misc",defaultValue:1}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},cancel:{}}}});(function(){c.prototype.init=function(){this._iMode=0;this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new Date(Date.UTC(1,0,1));this._oMinDate.setUTCFullYear(1);this._oMaxDate=new Date(Date.UTC(9999,11,31));var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",r,this);i.attachEvent("pressNext",s,this);i.attachEvent("pressButton1",t,this);i.attachEvent("pressButton2",u,this);this.setAggregation("header",i);var E=new M(this.getId()+"--Month0");E.attachEvent("focus",x,this);E.attachEvent("select",w,this);E.attachEvent("_renderMonth",v,this);E.attachEvent("_bindMousemove",y,this);E.attachEvent("_unbindMousemove",z,this);E._bNoThemeChange=true;this.addAggregation("month",E);var F=new b(this.getId()+"--MP");F.attachEvent("select",A,this);F._bNoThemeChange=true;this.setAggregation("monthPicker",F);var G=new Y(this.getId()+"--YP");G.attachEvent("select",B,this);this.setAggregation("yearPicker",G);};c.prototype.exit=function(){};sap.ui.unified.Calendar.prototype.onBeforeRendering=function(){var E=this._getFocusedDate();var F=this;n(F,E);var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];var J=new Date(E.getTime());if(i>0){J.setUTCDate(1);}J.setUTCMonth(E.getUTCMonth()+i);I.setDate(a._createLocalDate(J));}};c.prototype.onAfterRendering=function(){var i=this;j(i);k(i,this._getFocusedDate(),true);};c.prototype.invalidate=function(O){if(!O||!(O instanceof sap.ui.unified.DateRange)){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0){var E=this.getAggregation("month");for(var i=0;i<E.length;i++){var F=E[i];F.invalidate(O);}}};c.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){var i=this;d(i);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(i){this._oFocusedDate=new Date(i);};c.prototype.focusDate=function(i){var E=this;o(E,i,false);return this;};c.prototype.displayDate=function(i){var E=this;o(E,i,true);return this;};c.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};c.prototype.setMonths=function(E){this.setProperty("months",E,false);var F=this;E=p(F);var G=this.getAggregation("month");var i=0;var I;if(G.length<E){for(i=G.length;i<E;i++){I=new M(this.getId()+"--Month"+i);I.attachEvent("focus",x,this);I.attachEvent("select",w,this);I.attachEvent("_renderMonth",v,this);I.attachEvent("_bindMousemove",y,this);I.attachEvent("_unbindMousemove",z,this);I._bNoThemeChange=true;this.addAggregation("month",I);}}else if(G.length>E){for(i=G.length;i>E;i--){I=this.removeAggregation("month",i-1);I.destroy();}}return this;};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var E=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(E);}return this._oLocaleData;};c.prototype._getShowMonthHeader=function(){var i=this;var E=p(i);if(E>2){return true;}else{return false;}};c.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};c.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};c.prototype.onsapescape=function(E){var i=this;switch(this._iMode){case 0:this.fireCancel();break;case 1:f(i);break;case 2:h(i);break;}};c.prototype.onsapshow=function(E){if(this._bPoupupMode){var i=this;switch(this._iMode){case 1:f(i);break;case 2:h(i);break;}this.fireCancel();E.preventDefault();}};c.prototype.onsaphide=c.prototype.onsapshow;c.prototype.onsaptabnext=function(E){var F=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(F.getDomRef("B1"));if(!this._bPoupupMode){var G=this.getAggregation("month");var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");for(var i=0;i<G.length;i++){var K=G[i];q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}else if(E.target.id==F.getId()+"-B1"){q.sap.focus(F.getDomRef("B2"));E.preventDefault();}};c.prototype.onsaptabprevious=function(E){var F=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(F.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==F.getId()+"-B1"){var G=this.getAggregation("month");var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");var K;switch(this._iMode){case 0:K=this._getFocusedDate();for(var i=0;i<G.length;i++){var N=G[i];var O=a._createUTCDate(N.getDate());if(K.getTime()==O.getTime()){N._oItemNavigation.focusItem(N._oItemNavigation.getFocusedIndex());}else{q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());break;case 2:J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}else if(E.target.id==F.getId()+"-B2"){q.sap.focus(F.getDomRef("B1"));E.preventDefault();}};c.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var F=this.getAggregation("header");var G=this.getAggregation("month");var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");q.sap.focus(F.getDomRef("B2"));if(!this._bPoupupMode){for(var i=0;i<G.length;i++){var K=G[i];q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}q.sap.byId(this.getId()+"-end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){q.sap.byId(this.getId()+"-end").attr("tabindex","0");if(!this._bPoupupMode){var F=this.getAggregation("month");var G=this.getAggregation("monthPicker");var I=this.getAggregation("yearPicker");for(var i=0;i<F.length;i++){var J=F[i];q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}};c.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}var E=this;this._bNamesLengthChecked=undefined;var F=this.getAggregation("monthPicker");e(E);F._bNoThemeChange=false;F.onThemeChanged(arguments);F._bNoThemeChange=true;this._bLongMonth=F._bLongMonth;f(E);var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];I._bNoThemeChange=false;I.onThemeChanged(arguments);I._bNoThemeChange=true;}var J=this._getFocusedDate();n(E,J);j(E);};function _(T,N){var E=T._getFocusedDate();var F=T.getAggregation("month");var G=false;var I;var J;var K;var i=0;for(i=0;i<F.length;i++){I=F[i];J=a._createUTCDate(I.getDate());if(i==0){K=new Date(J.getTime());}if(J.getUTCFullYear()==E.getUTCFullYear()&&J.getUTCMonth()==E.getUTCMonth()){G=true;if(!N){I.setDate(a._createLocalDate(E));}else{I.setDisplay(a._createLocalDate(E));}}}if(!G){K=new Date(E.getTime());for(i=0;i<F.length;i++){I=F[i];J=new Date(E.getTime());if(i>0){J.setUTCDate(1);}J.setUTCMonth(E.getUTCMonth()+i);if(!N&&J.getUTCFullYear()==E.getUTCFullYear()&&J.getUTCMonth()==E.getUTCMonth()){I.setDate(a._createLocalDate(J));}else{I.displayDate(a._createLocalDate(J));}}n(T,K);k(T,E,true);}}function d(T){var S=T.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){T._oFocusedDate=a._createUTCDate(S[0].getStartDate());}else{var i=new Date();T._oFocusedDate=a._createUTCDate(i);}}function e(T){if(T._iMode==2){h(T);}var i=T._getFocusedDate();var E=T.getAggregation("monthPicker");if(E.getDomRef()){E.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=T.$("content");R.renderControl(E);R.flush($[0],false,true);R.destroy();}T.$("contentOver").css("display","");E.setMonth(i.getUTCMonth());T._iMode=1;k(T,i,false);}function f(T){T._iMode=0;var i=T.getAggregation("monthPicker");i.$().css("display","none");T.$("contentOver").css("display","none");_(T);}function g(T){if(T._iMode==1){f(T);}var i=T._getFocusedDate();var E=i.getUTCFullYear();var F=T._oMaxDate.getUTCFullYear();var G=T._oMinDate.getUTCFullYear();if(F-G<=20){return;}var I=T.getAggregation("header");if(E>(F-10)){E=F-9;I.setEnabledNext(false);}else{I.setEnabledNext(true);}if(E<(G+9)){E=G+10;I.setEnabledPrevious(false);}else{I.setEnabledPrevious(true);}var J=T.getAggregation("yearPicker");if(J.getDomRef()){J.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=T.$("content");R.renderControl(J);R.flush($[0],false,true);R.destroy();}T.$("contentOver").css("display","");J.setYear(E);if(p(T)>1){var K=T.getAggregation("month")[0];var N=K.$("days").children(".sapUiCalDay");if(N.length==28){J.$().addClass("sapUiCalYearNoTop");}else{J.$().removeClass("sapUiCalYearNoTop");}}T._iMode=2;}function h(T){T._iMode=0;var i=T.getAggregation("yearPicker");i.$().css("display","none");T.$("contentOver").css("display","none");_(T);}function j(T){if(!T._bNamesLengthChecked){e(T);f(T);var i=T.getAggregation("monthPicker");T._bLongMonth=i._bLongMonth;T._bNamesLengthChecked=true;if(!T._bLongMonth){var E=T._getFocusedDate();n(T,E);}}}function k(T,i,E){var F=i.getUTCFullYear();var G=T._oMaxDate.getUTCFullYear();var I=T._oMinDate.getUTCFullYear();var J=i.getUTCMonth();var K=T._oMaxDate.getUTCMonth();var N=T._oMinDate.getUTCMonth();var O=T.getAggregation("header");if(F>G||(F==G&&(!E||J>=K))){O.setEnabledNext(false);}else{O.setEnabledNext(true);}if(F<I||(F==I&&(!E||J<=N))){O.setEnabledPrevious(false);}else{O.setEnabledPrevious(true);}}function m(T,i,O){var F;var E=false;if(i.getTime()<T._oMinDate.getTime()){F=T._oMinDate;E=true;}else if(i.getTime()>T._oMaxDate.getTime()){F=T._oMaxDate;E=true;}else{F=i;}T._setFocusedDate(F);if(E||O){_(T);}}function n(T,i){var E=T._getLocaleData();var F=i.getUTCMonth();var G=[];var I=[];var J;var S=false;if(T._bLongMonth||!T._bNamesLengthChecked){G=E.getMonthsStandAlone("wide");}else{S=true;G=E.getMonthsStandAlone("abbreviated");I=E.getMonthsStandAlone("wide");}var K=p(T);var N;if(K>1){var P=E.getIntervalPattern();N=P.replace(/\{0\}/,G[F]).replace(/\{1\}/,G[(F+K-1)%12]);if(S){J=P.replace(/\{0\}/,I[F]).replace(/\{1\}/,I[(F+K-1)%12]);}}else{N=G[F];if(S){J=I[F];}}var O=T.getAggregation("header");O.setTextButton1(N);if(S){O.setAriaLabelButton1(J);}O.setTextButton2((i.getUTCFullYear()).toString());}function o(T,i,N){if(i&&(!T._oFocusedDate||T._oFocusedDate.getTime()!=i.getTime())){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+T);}var E=i.getFullYear();if(E<1||E>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+T);}T._setFocusedDate(a._createUTCDate(i));if(T.getDomRef()&&T._iMode==0){_(T,N);}}}function p(T){if(sap.ui.Device.system.phone){return 1;}else{return T.getMonths();}}function r(E){var i=this;var F=this._getFocusedDate();var G=this.getAggregation("header");var I=this.getAggregation("yearPicker");var J=p(i);var K;var N=false;switch(this._iMode){case 0:if(J>1){K=a._createUTCDate(this.getAggregation("month")[0].getDate());K.setUTCDate(1);K.setUTCMonth(K.getUTCMonth()-J+1);this._setFocusedDate(K);F=this._getFocusedDate();N=true;}else{F.setUTCDate(1);}F.setUTCDate(F.getUTCDate()-1);_(i,N);if(J>1){F.setUTCMonth(F.getUTCMonth()+J,1);F.setUTCDate(F.getUTCDate()-1);_(i);}break;case 1:F.setUTCFullYear(F.getUTCFullYear()-1);G.setTextButton2((F.getUTCFullYear()).toString());k(i,F);break;case 2:I.previousPage();break;}}function s(E){var i=this;var F=this._getFocusedDate();var G=this.getAggregation("header");var I=this.getAggregation("yearPicker");var J=p(i);var K;switch(this._iMode){case 0:if(J>1){K=a._createUTCDate(this.getAggregation("month")[0].getDate());this._setFocusedDate(K);F=this._getFocusedDate();}F.setUTCMonth(F.getUTCMonth()+J,1);_(i);break;case 1:F.setUTCFullYear(F.getUTCFullYear()+1);G.setTextButton2((F.getUTCFullYear()).toString());k(i,F);break;case 2:I.nextPage();break;}}function t(E){var i=this;if(this._iMode!=1){e(i);}else{f(i);}}function u(E){var i=this;if(this._iMode!=2){g(i);}else{h(i);}}function v(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function w(E){var F=this;if(p(F)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];if(I.getId()!=E.oSource.getId()){I._updateSelection();}}}this.fireSelect();}function x(E){var i=E.getParameter("date");var O=E.getParameter("otherMonth");var F=this;m(F,i,O);}function y(E){var F=this;if(p(F)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];if(I.getId()!=E.oSource.getId()){I._bindMousemove();}}}}function z(E){var F=this;if(p(F)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];if(I.getId()!=E.oSource.getId()){I._unbindMousemove();}}}}function A(E){var F=this._getFocusedDate();var i=this.getAggregation("monthPicker");var G=i.getMonth();var I=this;F.setUTCMonth(G);if(G!=F.getUTCMonth()){F.setUTCDate(0);}if(F.getTime()<this._oMinDate.getTime()){this._setFocusedDate(this._oMinDate);}else if(F.getTime()>this._oMaxDate.getTime()){this._setFocusedDate(this._oMaxDate);}f(I);}function B(E){var F=this._getFocusedDate();var i=this.getAggregation("yearPicker");var G=i.getYear();var I=this;F.setUTCFullYear(G);if(F.getTime()<this._oMinDate.getTime()){this._setFocusedDate(this._oMinDate);}else if(F.getTime()>this._oMaxDate.getTime()){this._setFocusedDate(this._oMaxDate);}h(I);}}());return c;},true);
