/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/library'],function(q,C,L,I,D,a,l){"use strict";var M=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Misc"},intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},showHeader:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"}}}}}});(function(){M.prototype.init=function(){this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"});this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);};M.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sRenderMonth){q.sap.clearDelayedCall(this._sRenderMonth);}};M.prototype.onAfterRendering=function(){var t=this;_(t);n(t);};M.prototype.invalidate=function(o){if(!o||!(o instanceof sap.ui.unified.DateRange)){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sRenderMonth){var t=this;this._sRenderMonth=q.sap.delayedCall(0,this,h,[t]);}};M.prototype.setDate=function(o){var t=this;f(t,o,false);return this;};M.prototype._setDate=function(o){var i=a._createLocalDate(o);this.setProperty("date",i,true);this._oUTCDate=o;};M.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUTCDate(new Date());}return this._oUTCDate;};M.prototype.displayDate=function(o){var t=this;f(t,o,true);return this;};M.prototype._getLocale=function(){var p=this.getParent();if(p&&p.getLocale){return p.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};M.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var o=new sap.ui.core.Locale(s);this._oLocaleData=L.getInstance(o);}return this._oLocaleData;};M.prototype._getFormatLong=function(){var s=this._getLocale();if(this._oFormatLong.oLocale.toString()!=s){var o=new sap.ui.core.Locale(s);this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long"},o);}return this._oFormatLong;};M.prototype.getIntervalSelection=function(){var p=this.getParent();if(p&&p.getIntervalSelection){return p.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};M.prototype.getSingleSelection=function(){var p=this.getParent();if(p&&p.getSingleSelection){return p.getSingleSelection();}else{return this.getProperty("singleSelection");}};M.prototype.getSelectedDates=function(){var p=this.getParent();if(p&&p.getSelectedDates){return p.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};M.prototype.getSpecialDates=function(){var p=this.getParent();if(p&&p.getSpecialDates){return p.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};M.prototype.getShowHeader=function(){var p=this.getParent();if(p&&p._getShowMonthHeader){return p._getShowMonthHeader();}else{return this.getProperty("showHeader");}};M.prototype.getAriaLabelledBy=function(){var p=this.getParent();if(p&&p.getAriaLabelledBy){return p.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};M.prototype._checkDateSelected=function(o){if(!(o instanceof Date)){throw new Error("Date must be a JavaScript date object "+this);}var s=0;var S=this.getSelectedDates();var t=o.getTime();for(var i=0;i<S.length;i++){var r=S[i];var T=a._createUTCDate(r.getStartDate());var p;var u=0;if(T){p=T;u=p.getTime();}var E;var v=0;if(this.getIntervalSelection()){T=a._createUTCDate(r.getEndDate());if(T){E=T;v=E.getTime();}}if(t==u&&!E){s=1;break;}else if(t==u&&E){s=2;if(E&&t==v){s=5;}break;}else if(E&&t==v){s=3;break;}else if(E&&t>u&&t<v){s=4;break;}if(this.getSingleSelection()){break;}}return s;};M.prototype._getDateType=function(o){if(!(o instanceof Date)){throw new Error("Date must be a JavaScript date object "+this);}var t;var s=this.getSpecialDates();var T=o.getTime();for(var i=0;i<s.length;i++){var r=s[i];var p=a._createUTCDate(r.getStartDate());var S;var u=0;if(p){S=p;u=S.getTime();}var E;var v=0;p=a._createUTCDate(r.getEndDate());if(p){E=p;v=E.getTime();}if((T==u&&!E)||(T>=u&&T<=v)){t={type:r.getType(),tooltip:r.getTooltip_AsString()};break;}}return t;};M.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var t=q(E.target);if(t.hasClass("sapUiCalDayNum")){t=t.parent();}var i=this;if(t.hasClass("sapUiCalDay")){var o=this._getDate();if(!q.sap.containsOrEquals(this.getDomRef(),E.target)){var s=this.getSelectedDates();if(s.length>0&&this.getSingleSelection()){var S=a._createUTCDate(s[0].getStartDate());var p=this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true);if(p.getTime()>=S.getTime()){k(i,S,p);}else{k(i,p,S);}}}else{var F=this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true);if(F.getTime()!=o.getTime()){if(t.hasClass("sapUiCalDayOtherMonth")){this.fireFocus({date:F,otherMonth:true});}else{this._setDate(F);j(i,F,false,true);this._bMoveChange=true;}}}}};M.prototype.onmouseup=function(E){if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var o=this._oItemNavigation.getItemDomRefs();for(var i=0;i<o.length;i++){var $=q(o[i]);if(!$.hasClass("sapUiCalDayOtherMonth")){if($.attr("data-sap-day")==this._oFormatYyyymmdd.format(F,true)){$.focus();break;}}}if(this._bMoveChange){var t=q(E.target);if(t.hasClass("sapUiCalDayNum")){t=t.parent();}if(t.hasClass("sapUiCalDay")){F=this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true);}var p=this;j(p,F);this._bMoveChange=false;m(p);}}};M.prototype.onsapselect=function(E){var t=this;j(t,t._getDate());m(t);E.stopPropagation();E.preventDefault();};M.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};M.prototype.onsappageupmodifiers=function(E){var F=new Date(this._getDate().getTime());var y=F.getUTCFullYear();if(E.metaKey||E.ctrlKey){F.setUTCFullYear(y-10);}else{F.setUTCFullYear(y-1);}this.fireFocus({date:F,otherMonth:true});E.preventDefault();};M.prototype.onsappagedownmodifiers=function(E){var F=new Date(this._getDate().getTime());var y=F.getUTCFullYear();if(E.metaKey||E.ctrlKey){F.setUTCFullYear(y+10);}else{F.setUTCFullYear(y+1);}this.fireFocus({date:F,otherMonth:true});E.preventDefault();};M.prototype._updateSelection=function(){var s=this.getSelectedDates();if(s.length>0&&this.getSingleSelection()){var t=this;var S=a._createUTCDate(s[0].getStartDate());var E=a._createUTCDate(s[0].getEndDate());k(t,S,E);}};M.prototype._bindMousemove=function(F){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};M.prototype._unbindMousemove=function(F){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;if(F){this.fireEvent("_unbindMousemove");}};M.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var w=this.$().children(".sapUiCalWH");var o=this._getLocaleData();var F=o.getFirstDayOfWeek();var p=o.getDaysStandAlone("abbreviated");for(var i=0;i<p.length;i++){var W=w[i];q(W).text(p[(i+F)%7]);}var t=this;n(t);};function _(t){var o=t._getDate();var y=t._oFormatYyyymmdd.format(o,true);var p=0;var r=t.$("days").get(0);var s=t.$("days").find(".sapUiCalDay");for(var i=0;i<s.length;i++){var $=q(s[i]);if($.attr("data-sap-day")===y){p=i;break;}}if(!t._oItemNavigation){t._oItemNavigation=new I();t._oItemNavigation.attachEvent(I.Events.AfterFocus,b,t);t._oItemNavigation.attachEvent(I.Events.FocusAgain,c,t);t._oItemNavigation.attachEvent(I.Events.BorderReached,d,t);t.addDelegate(t._oItemNavigation);t._oItemNavigation.setHomeEndColumnMode(true,true);t._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}t._oItemNavigation.setRootDomRef(r);t._oItemNavigation.setItemDomRefs(s);t._oItemNavigation.setCycling(false);t._oItemNavigation.setColumns(7,true);t._oItemNavigation.setFocusedIndex(p);t._oItemNavigation.setPageSize(s.length);}function b(o){var p=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}var t=this;var O=this._getDate();var F=new Date(O.getTime());var r=false;var s=this._oItemNavigation.getItemDomRefs();var i=0;var $=q(s[p]);var u;if($.hasClass("sapUiCalDayOtherMonth")){if(E.type=="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){F.setUTCDate(1);g(t,F);}else if(E.type=="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(i=s.length-1;i>0;i--){u=q(s[i]);if(!u.hasClass("sapUiCalDayOtherMonth")){F=this._oFormatYyyymmdd.parse(u.attr("data-sap-day"),true);break;}}g(t,F);}else{r=true;F=this._oFormatYyyymmdd.parse($.attr("data-sap-day"),true);if(!F){F=new Date(O.getTime());}g(t,O);}}else{if(q(E.target).hasClass("sapUiCalWeekNum")){g(t,F);}else{F=this._oFormatYyyymmdd.parse($.attr("data-sap-day"),true);this._setDate(F);}}this.fireFocus({date:F,otherMonth:r});if(E.type=="mousedown"){e(t,E,F,p);}}function c(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var t=this;var F=this._getDate();e(t,E,F,i);}}function d(o){var E=o.getParameter("event");var i=0;var O=this._getDate();var F=new Date(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_DOWN){F.setUTCDate(F.getUTCDate()+7);}else{F.setUTCDate(F.getUTCDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_UP){F.setUTCDate(F.getUTCDate()-7);}else{F.setUTCDate(F.getUTCDate()-1);}break;case"sappagedown":i=F.getUTCMonth()+1;F.setUTCMonth(i);if(i%12!=F.getUTCMonth()){while(i!=F.getUTCMonth()){F.setUTCDate(F.getUTCDate()-1);}}break;case"sappageup":i=F.getUTCMonth()-1;F.setUTCMonth(i);if(i<0){i=11;}if(i!=F.getUTCMonth()){while(i!=F.getUTCMonth()){F.setUTCDate(F.getUTCDate()-1);}}break;default:break;}this.fireFocus({date:F,otherMonth:true});}}function e(t,E,F,i){j(t,F,E.shiftKey);m(t);if(t.getIntervalSelection()&&t.$().is(":visible")){t._bindMousemove(true);}E.preventDefault();E.setMark("cancelAutoClose");}function f(t,o,N){if(!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+t);}var y=o.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+t);}var O=t._getDate();t.setProperty("date",o,true);t._oUTCDate=a._createUTCDate(o);if(t.getDomRef()){o=a._createUTCDate(o);if(t._oUTCDate.getUTCFullYear()==O.getUTCFullYear()&&t._oUTCDate.getUTCMonth()==O.getUTCMonth()){if(!N){g(t,t._oUTCDate,true);}}else{h(t,N);}}}function g(t,o,N){if(!N){t.setDate(o);}var y=t._oFormatYyyymmdd.format(o,true);var p=t._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<p.length;i++){$=q(p[i]);if($.attr("data-sap-day")==y){t._oItemNavigation.focusItem(i);break;}}}function h(t,N){t._sRenderMonth=undefined;var o=t._getDate();var $=t.$("days");if($.length>0){var r=sap.ui.getCore().createRenderManager();t.getRenderer().renderDays(r,t,o);r.flush($[0]);r.destroy();}if(t.getShowHeader()){var i=t._getLocaleData();var p=i.getMonthsStandAlone("wide");t.$("Head").text(p[o.getUTCMonth()]);}t.fireEvent("_renderMonth",{days:$.children(".sapUiCalDay").length});_(t);if(!N){t._oItemNavigation.focusItem(t._oItemNavigation.getFocusedIndex());}}function j(t,o,p,r){var s=t.getSelectedDates();var u;var v=t._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=t.getParent();var A=t;if(P&&P.getSelectedDates){A=P;}if(t.getSingleSelection()){var S;if(s.length>0){u=s[0];S=a._createUTCDate(u.getStartDate());}else{u=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",u,true);}if(t.getIntervalSelection()&&(!u.getEndDate()||r)&&S){var E;if(o.getTime()<S.getTime()){E=S;S=o;if(!r){u.setProperty("startDate",a._createLocalDate(S),true);u.setProperty("endDate",a._createLocalDate(E),true);}}else if(o.getTime()>=S.getTime()){E=o;if(!r){u.setProperty("endDate",a._createLocalDate(E),true);}}k(t,S,E);}else{k(t,o);u.setProperty("startDate",a._createLocalDate(o),true);u.setProperty("endDate",undefined,true);}}else{if(t.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var w=t._checkDateSelected(o);if(w>0){for(i=0;i<s.length;i++){if(s[i].getStartDate()&&o.getTime()==a._createUTCDate(s[i].getStartDate()).getTime()){A.removeAggregation("selectedDates",i,true);break;}}}else{u=new sap.ui.unified.DateRange({startDate:a._createLocalDate(o)});A.addAggregation("selectedDates",u,true);}y=t._oFormatYyyymmdd.format(o,true);for(i=0;i<v.length;i++){$=q(v[i]);if(!$.hasClass("sapUiCalDayOtherMonth")&&$.attr("data-sap-day")==y){if(w>0){$.removeClass("sapUiCalDaySel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");}}}}}}function k(t,s,E){var o=t._oItemNavigation.getItemDomRefs();var $;var i=0;if(!E){var y=t._oFormatYyyymmdd.format(s,true);for(i=0;i<o.length;i++){$=q(o[i]);if(!$.hasClass("sapUiCalDayOtherMonth")&&$.attr("data-sap-day")==y){$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");}else if($.hasClass("sapUiCalDaySel")){$.removeClass("sapUiCalDaySel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalDaySelStart")){$.removeClass("sapUiCalDaySelStart");}else if($.hasClass("sapUiCalDaySelBetween")){$.removeClass("sapUiCalDaySelBetween");}else if($.hasClass("sapUiCalDaySelEnd")){$.removeClass("sapUiCalDaySelEnd");}}}else{var p;for(i=0;i<o.length;i++){$=q(o[i]);p=t._oFormatYyyymmdd.parse($.attr("data-sap-day"),true);if(p.getTime()==s.getTime()){$.addClass("sapUiCalDaySelStart");$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");if(E&&p.getTime()==E.getTime()){$.addClass("sapUiCalDaySelEnd");}$.removeClass("sapUiCalDaySelBetween");}else if(E&&p.getTime()>s.getTime()&&p.getTime()<E.getTime()){$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");$.addClass("sapUiCalDaySelBetween");$.removeClass("sapUiCalDaySelStart");$.removeClass("sapUiCalDaySelEnd");}else if(E&&p.getTime()==E.getTime()){$.addClass("sapUiCalDaySelEnd");$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");$.removeClass("sapUiCalDaySelStart");$.removeClass("sapUiCalDaySelBetween");}else{if($.hasClass("sapUiCalDaySel")){$.removeClass("sapUiCalDaySel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalDaySelStart")){$.removeClass("sapUiCalDaySelStart");}else if($.hasClass("sapUiCalDaySelBetween")){$.removeClass("sapUiCalDaySelBetween");}else if($.hasClass("sapUiCalDaySelEnd")){$.removeClass("sapUiCalDaySelEnd");}}}}}function m(t){if(t._bMouseMove){t._unbindMousemove(true);}t.fireSelect();}function n(t){if(!t._bNamesLengthChecked){var w;var W=t.$().find(".sapUiCalWH");var T=false;var i=0;for(i=0;i<W.length;i++){w=W[i];if(w.clientWidth<w.scrollWidth){T=true;break;}}if(T){t._bLongWeekDays=false;var o=t._getLocaleData();var F=o.getFirstDayOfWeek();var p=o.getDaysStandAlone("narrow");for(i=0;i<p.length;i++){w=W[i];q(w).text(p[(i+F)%7]);}}else{t._bLongWeekDays=true;}t._bNamesLengthChecked=true;}}}());return M;},true);
