/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,M,b,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",properties:{intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},months:{type:"int",group:"Misc",defaultValue:1}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},cancel:{}}}});(function(){c.prototype.init=function(){this._iMode=0;this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(U.UTC(1,0,1));this._oMinDate.setUTCFullYear(1);this._oMaxDate=new U(U.UTC(9999,11,31));var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",r,this);i.attachEvent("pressButton2",s,this);this.setAggregation("header",i);var A=this._createMonth(this.getId()+"--Month0");A.attachEvent("focus",v,this);A.attachEvent("select",u,this);A.attachEvent("_renderMonth",t,this);A.attachEvent("_bindMousemove",w,this);A.attachEvent("_unbindMousemove",x,this);A._bNoThemeChange=true;this.addAggregation("month",A);var B=new b(this.getId()+"--MP");B.attachEvent("select",y,this);B._bNoThemeChange=true;this.setAggregation("monthPicker",B);var E=new Y(this.getId()+"--YP");E.attachEvent("select",z,this);this.setAggregation("yearPicker",E);};c.prototype.exit=function(){};c.prototype._createMonth=function(i){var A=new M(i);return A;};c.prototype.onBeforeRendering=function(){var A=this.getAggregation("month");var B;var E=A[0].getDate();if(A.length>1&&E){B=new U(E.getTime());}else{B=this._getFocusedDate();}this._updateHeader(B);for(var i=0;i<A.length;i++){var F=A[i];E=new U(B.getTime());if(i>0){E.setUTCDate(1);E.setUTCMonth(B.getUTCMonth()+i);}F.setDate(a._createLocalDate(E));}};c.prototype.onAfterRendering=function(){var i=this;j(i);};c.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];B._bDateRangeChanged=true;if(A.length>1){B._bNoFocus=true;}B.invalidate(O);}if(A.length>1){var E=this;q.sap.delayedCall(0,this,m,[E,E._getFocusedDate(),true]);}this._bDateRangeChanged=undefined;}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};c.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){var i=this;d(i);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(i.getTime());};c.prototype.focusDate=function(i){var A=this;o(A,i,false);return this;};c.prototype.displayDate=function(i){var A=this;o(A,i,true);return this;};c.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};c.prototype.setMonths=function(A){this.setProperty("months",A,false);var B=this;A=p(B);var E=this.getAggregation("month");var i=0;var F;if(E.length<A){for(i=E.length;i<A;i++){F=this._createMonth(this.getId()+"--Month"+i);F.attachEvent("focus",v,this);F.attachEvent("select",u,this);F.attachEvent("_renderMonth",t,this);F.attachEvent("_bindMousemove",w,this);F.attachEvent("_unbindMousemove",x,this);F._bNoThemeChange=true;this.addAggregation("month",F);}}else if(E.length>A){for(i=E.length;i>A;i--){F=this.removeAggregation("month",i-1);F.destroy();}}return this;};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var A=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(A);}return this._oLocaleData;};c.prototype._getShowMonthHeader=function(){var i=this;var A=p(i);if(A>2){return true;}else{return false;}};c.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};c.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};c.prototype.onsapescape=function(E){var i=this;switch(this._iMode){case 0:this.fireCancel();break;case 1:f(i);break;case 2:h(i);break;}};c.prototype.onsapshow=function(E){if(this._bPoupupMode){var i=this;switch(this._iMode){case 1:f(i);break;case 2:h(i);break;}this.fireCancel();E.preventDefault();}};c.prototype.onsaphide=c.prototype.onsapshow;c.prototype.onsaptabnext=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(A.getDomRef("B1"));if(!this._bPoupupMode){var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");for(var i=0;i<B.length;i++){var I=B[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}else if(E.target.id==A.getId()+"-B1"){q.sap.focus(A.getDomRef("B2"));E.preventDefault();}};c.prototype.onsaptabprevious=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(A.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==A.getId()+"-B1"){var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");var I;switch(this._iMode){case 0:I=this._getFocusedDate();for(var i=0;i<B.length;i++){var J=B[i];var K=a._createUniversalUTCDate(J.getDate());if(I.getTime()==K.getTime()){J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());}else{q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:F._oItemNavigation.focusItem(F._oItemNavigation.getFocusedIndex());break;case 2:G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}else if(E.target.id==A.getId()+"-B2"){q.sap.focus(A.getDomRef("B1"));E.preventDefault();}};c.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var A=this.getAggregation("header");var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");q.sap.focus(A.getDomRef("B2"));if(!this._bPoupupMode){for(var i=0;i<B.length;i++){var I=B[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}q.sap.byId(this.getId()+"-end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){q.sap.byId(this.getId()+"-end").attr("tabindex","0");if(!this._bPoupupMode){var A=this.getAggregation("month");var B=this.getAggregation("monthPicker");var F=this.getAggregation("yearPicker");for(var i=0;i<A.length;i++){var G=A[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}if(B.getDomRef()){q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}};c.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}var A=this;this._bNamesLengthChecked=undefined;var B=this.getAggregation("monthPicker");e(A);B._bNoThemeChange=false;B.onThemeChanged(arguments);B._bNoThemeChange=true;this._bLongMonth=B._bLongMonth;f(A);var E=this.getAggregation("month");for(var i=0;i<E.length;i++){var F=E[i];F._bNoThemeChange=false;F.onThemeChanged(arguments);F._bNoThemeChange=true;}var G=this._getFocusedDate();n(A,G);j(A);};c.prototype._updateHeader=function(i){var A=this;n(A,i);k(A,i,true);};c.prototype._handlePrevious=function(E){var i=this;var F=this._getFocusedDate();var A=this.getAggregation("header");var B=this.getAggregation("yearPicker");var G=p(i);var I;var N=false;switch(this._iMode){case 0:if(G>1){I=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate());I.setUTCDate(1);this._setFocusedDate(I);F=this._getFocusedDate();}else{F.setUTCDate(1);}F.setUTCDate(F.getUTCDate()-1);_(i,N,true);break;case 1:F.setUTCFullYear(F.getUTCFullYear()-1);A.setTextButton2((F.getUTCFullYear()).toString());k(i,F);break;case 2:B.previousPage();break;}};c.prototype._handleNext=function(E){var i=this;var F=this._getFocusedDate();var A=this.getAggregation("header");var B=this.getAggregation("yearPicker");var G=p(i);var I;switch(this._iMode){case 0:if(G>1){I=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate());this._setFocusedDate(I);F=this._getFocusedDate();}F.setUTCMonth(F.getUTCMonth()+G,1);_(i);break;case 1:F.setUTCFullYear(F.getUTCFullYear()+1);A.setTextButton2((F.getUTCFullYear()).toString());k(i,F);break;case 2:B.nextPage();break;}};c.prototype._getDisplayedMonths=function(A){var B=this;var E=[];var F=A.getUTCMonth();var G=p(B);if(G>1){for(var i=0;i<G;i++){E.push((F+i)%12);}}else{E.push(F);}return E;};function _(T,N,I){var A=T._getFocusedDate();var B=T.getAggregation("month");var F=false;var E;var G;var J;var i=0;for(i=0;i<B.length;i++){E=B[i];if(E.checkDateFocusable(a._createLocalDate(A))){F=true;}if(F||B.length==1){if(!N){E.setDate(a._createLocalDate(A));}else{E.displayDate(a._createLocalDate(A));}break;}}if(!F){J=new U(A.getTime());}if(!F&&B.length>1){J.setUTCDate(1);if(I){J.setUTCMonth(J.getUTCMonth()-B.length+1);}for(i=0;i<B.length;i++){E=B[i];G=new U(J.getTime());G.setUTCMonth(J.getUTCMonth()+i);if(!N&&G.getUTCFullYear()==A.getUTCFullYear()&&G.getUTCMonth()==A.getUTCMonth()){E.setDate(a._createLocalDate(A));}else{E.displayDate(a._createLocalDate(G));}}}if(!F){T._updateHeader(J);}}function d(T){var S=T.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){T._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate());}else{var N=new Date();T._oFocusedDate=a._createUniversalUTCDate(N);}}function e(T){if(T._iMode==2){h(T);}var i=T._getFocusedDate();var A=T.getAggregation("monthPicker");if(A.getDomRef()){A.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=T.$("content");R.renderControl(A);R.flush($[0],false,true);R.destroy();}T.$("contentOver").css("display","");A.setMonth(i.getUTCMonth());T._iMode=1;k(T,i,false);}function f(T){T._iMode=0;var i=T.getAggregation("monthPicker");i.$().css("display","none");T.$("contentOver").css("display","none");_(T);}function g(T){if(T._iMode==1){f(T);}var i=T._getFocusedDate();var A=i.getUTCFullYear();var B=T._oMaxDate.getUTCFullYear();var E=T._oMinDate.getUTCFullYear();if(B-E<=20){return;}var F=T.getAggregation("header");if(A>(B-10)){A=B-9;F.setEnabledNext(false);}else{F.setEnabledNext(true);}if(A<(E+9)){A=E+10;F.setEnabledPrevious(false);}else{F.setEnabledPrevious(true);}var G=T.getAggregation("yearPicker");if(G.getDomRef()){G.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=T.$("content");R.renderControl(G);R.flush($[0],false,true);R.destroy();}T.$("contentOver").css("display","");G.setYear(A);if(p(T)>1){var I=T.getAggregation("month")[0];var J=I.$("days").children(".sapUiCalDay");if(J.length==28){G.$().addClass("sapUiCalYearNoTop");}else{G.$().removeClass("sapUiCalYearNoTop");}}T._iMode=2;}function h(T){T._iMode=0;var i=T.getAggregation("yearPicker");i.$().css("display","none");T.$("contentOver").css("display","none");_(T);}function j(T){if(!T._bNamesLengthChecked){e(T);f(T);var i=T.getAggregation("monthPicker");T._bLongMonth=i._bLongMonth;T._bNamesLengthChecked=true;if(!T._bLongMonth){var A=T._getFocusedDate();n(T,A);}}else if(T.getMonths()>1){m(T,T._getFocusedDate(),true);}}function k(T,i,A){var B=i.getUTCFullYear();var E=T._oMaxDate.getUTCFullYear();var F=T._oMinDate.getUTCFullYear();var G=i.getUTCMonth();var I=T._oMaxDate.getUTCMonth();var J=T._oMinDate.getUTCMonth();var K=T.getAggregation("header");if(B>E||(B==E&&(!A||G>=I))){K.setEnabledNext(false);}else{K.setEnabledNext(true);}if(B<F||(B==F&&(!A||G<=J))){K.setEnabledPrevious(false);}else{K.setEnabledPrevious(true);}}function m(T,i,O){var F;var A=false;if(i.getTime()<T._oMinDate.getTime()){F=T._oMinDate;A=true;}else if(i.getTime()>T._oMaxDate.getTime()){F=T._oMaxDate;A=true;}else{F=i;}if(T._focusDateExtend){T._focusDateExtend(i,O);}var I=F.getTime()<T._getFocusedDate().getTime();T._setFocusedDate(F);if(A||O){_(T,false,I);}}function n(T,i){var A=T._getLocaleData();var B=[];var E=[];var F;var S=false;if(T._bLongMonth||!T._bNamesLengthChecked){B=A.getMonthsStandAlone("wide");}else{S=true;B=A.getMonthsStandAlone("abbreviated");E=A.getMonthsStandAlone("wide");}var G=T._getDisplayedMonths(i);var I;if(G.length>1){var P=A.getIntervalPattern();I=P.replace(/\{0\}/,B[G[0]]).replace(/\{1\}/,B[G[G.length-1]]);if(S){F=P.replace(/\{0\}/,E[G[0]]).replace(/\{1\}/,E[G[G.length-1]]);}}else{I=B[G[0]];if(S){F=E[B[G[0]]];}}var J=T.getAggregation("header");J.setTextButton1(I);if(S){J.setAriaLabelButton1(F);}J.setTextButton2((i.getUTCFullYear()).toString());}function o(T,i,N){if(i&&(!T._oFocusedDate||T._oFocusedDate.getTime()!=i.getTime())){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+T);}i=a._createUniversalUTCDate(i);var A=i.getUTCFullYear();if(A<1||A>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+T);}T._setFocusedDate(i);if(T.getDomRef()&&T._iMode==0){_(T,N);}}}function p(T){if(sap.ui.Device.system.phone){return 1;}else{return T.getMonths();}}function r(E){var i=this;if(this._iMode!=1){e(i);}else{f(i);}}function s(E){var i=this;if(this._iMode!=2){g(i);}else{h(i);}}function t(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function u(E){var A=this;if(p(A)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var F=B[i];if(F.getId()!=E.oSource.getId()){F._updateSelection();}}}this.fireSelect();}function v(E){var i=a._createUniversalUTCDate(E.getParameter("date"));var O=E.getParameter("otherMonth");var A=this;m(A,i,O);}function w(E){var A=this;if(p(A)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var F=B[i];if(F.getId()!=E.oSource.getId()){F._bindMousemove();}}}}function x(E){var A=this;if(p(A)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var F=B[i];if(F.getId()!=E.oSource.getId()){F._unbindMousemove();}}}}function y(E){var F=new U(this._getFocusedDate().getTime());var i=this.getAggregation("monthPicker");var A=i.getMonth();var B=this;F.setUTCMonth(A);if(A!=F.getUTCMonth()){F.setUTCDate(0);}m(B,F,true);f(B);}function z(E){var F=new U(this._getFocusedDate().getTime());var i=this.getAggregation("yearPicker");var A=i.getYear();var B=this;F.setUTCFullYear(A);m(B,F,true);h(B);}}());return c;},true);
