/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library'],function(q,C,L,I,D,a,U,l){"use strict";var M=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Misc"},intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},showHeader:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"}}}}}});(function(){M.prototype.init=function(){this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"});this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._iColumns=7;};M.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sRenderMonth){q.sap.clearDelayedCall(this._sRenderMonth);}};M.prototype.onAfterRendering=function(){var t=this;_(t);m(t);};M.prototype.invalidate=function(o){if(!this._bDateRangeChanged&&(!o||!(o instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sRenderMonth){var t=this;this._sRenderMonth=q.sap.delayedCall(0,this,g,[t,this._bNoFocus]);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}};M.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var r=this.removeAllAggregation("selectedDates");return r;};M.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var o=this.destroyAggregation("selectedDates");return o;};M.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var r=this.removeAllAggregation("selectedDates");return r;};M.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var o=this.destroyAggregation("selectedDates");return o;};M.prototype.setDate=function(o){var t=this;e(t,o,false);return this;};M.prototype._setDate=function(o){var i=a._createLocalDate(o);this.setProperty("date",i,true);this._oUTCDate=o;};M.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date());}return this._oUTCDate;};M.prototype.displayDate=function(o){var t=this;e(t,o,true);return this;};M.prototype._getLocale=function(){var p=this.getParent();if(p&&p.getLocale){return p.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};M.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var o=new sap.ui.core.Locale(s);this._oLocaleData=L.getInstance(o);}return this._oLocaleData;};M.prototype._getFormatLong=function(){var s=this._getLocale();if(this._oFormatLong.oLocale.toString()!=s){var o=new sap.ui.core.Locale(s);this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long"},o);}return this._oFormatLong;};M.prototype.getIntervalSelection=function(){var p=this.getParent();if(p&&p.getIntervalSelection){return p.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};M.prototype.getSingleSelection=function(){var p=this.getParent();if(p&&p.getSingleSelection){return p.getSingleSelection();}else{return this.getProperty("singleSelection");}};M.prototype.getSelectedDates=function(){var p=this.getParent();if(p&&p.getSelectedDates){return p.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};M.prototype.getSpecialDates=function(){var p=this.getParent();if(p&&p.getSpecialDates){return p.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};M.prototype.getShowHeader=function(){var p=this.getParent();if(p&&p._getShowMonthHeader){return p._getShowMonthHeader();}else{return this.getProperty("showHeader");}};M.prototype.getAriaLabelledBy=function(){var p=this.getParent();if(p&&p.getAriaLabelledBy){return p.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};M.prototype._checkDateSelected=function(o){if(!(o instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var s=0;var S=this.getSelectedDates();var t=o.getTime();for(var i=0;i<S.length;i++){var r=S[i];var n=r.getStartDate();var p=0;if(n){n=a._createUniversalUTCDate(n);p=n.getTime();}var E=r.getEndDate();var u=0;if(E){E=a._createUniversalUTCDate(E);u=E.getTime();}if(t==p&&!E){s=1;break;}else if(t==p&&E){s=2;if(E&&t==u){s=5;}break;}else if(E&&t==u){s=3;break;}else if(E&&t>p&&t<u){s=4;break;}if(this.getSingleSelection()){break;}}return s;};M.prototype._getDateType=function(o){if(!(o instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var t;var s=this.getSpecialDates();var T=o.getTime();for(var i=0;i<s.length;i++){var r=s[i];var S=r.getStartDate();var n=0;if(S){S=a._createUniversalUTCDate(S);n=S.getTime();}var E=r.getEndDate();var p=0;if(E){E=a._createUniversalUTCDate(E);p=E.getTime();}if((T==n&&!E)||(T>=n&&T<=p)){t={type:r.getType(),tooltip:r.getTooltip_AsString()};break;}}return t;};M.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var t=q(E.target);if(t.hasClass("sapUiCalDayNum")){t=t.parent();}var i=this;if(t.hasClass("sapUiCalDay")){var o=this._getDate();if(!q.sap.containsOrEquals(this.getDomRef(),E.target)){var s=this.getSelectedDates();if(s.length>0&&this.getSingleSelection()){var S=s[0].getStartDate();if(S){S=a._createUniversalUTCDate(S);}var n=new U(this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true).getTime());if(n.getTime()>=S.getTime()){j(i,S,n);}else{j(i,n,S);}}}else{var F=new U(this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true).getTime());if(F.getTime()!=o.getTime()){if(t.hasClass("sapUiCalDayOtherMonth")){this.fireFocus({date:a._createLocalDate(F),otherMonth:true});}else{this._setDate(F);h(i,F,false,true);this._bMoveChange=true;}}}}};M.prototype.onmouseup=function(E){if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var n=this._oItemNavigation.getItemDomRefs();for(var i=0;i<n.length;i++){var $=q(n[i]);if(!$.hasClass("sapUiCalDayOtherMonth")){if($.attr("data-sap-day")==this._oFormatYyyymmdd.format(F,true)){$.focus();break;}}}if(this._bMoveChange){var t=q(E.target);if(t.hasClass("sapUiCalDayNum")){t=t.parent();}if(t.hasClass("sapUiCalDay")){F=new U(this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true).getTime());}var o=this;h(o,F);this._bMoveChange=false;k(o);}}};M.prototype.onsapselect=function(E){var t=this;h(t,t._getDate());k(t);E.stopPropagation();E.preventDefault();};M.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};M.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var y=F.getUTCFullYear();if(E.metaKey||E.ctrlKey){F.setUTCFullYear(y-10);}else{F.setUTCFullYear(y-1);}this.fireFocus({date:a._createLocalDate(F),otherMonth:true});E.preventDefault();};M.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var y=F.getUTCFullYear();if(E.metaKey||E.ctrlKey){F.setUTCFullYear(y+10);}else{F.setUTCFullYear(y+1);}this.fireFocus({date:a._createLocalDate(F),otherMonth:true});E.preventDefault();};M.prototype._updateSelection=function(){var s=this.getSelectedDates();if(s.length>0&&this.getSingleSelection()){var t=this;var S=s[0].getStartDate();if(S){S=a._createUniversalUTCDate(S);}var E=s[0].getEndDate();if(E){E=a._createUniversalUTCDate(E);}j(t,S,E);}};M.prototype._bindMousemove=function(F){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};M.prototype._unbindMousemove=function(F){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;if(F){this.fireEvent("_unbindMousemove");}};M.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var w=this.$().find(".sapUiCalWH");var o=this._getLocaleData();var F=o.getFirstDayOfWeek();var n=o.getDaysStandAlone("abbreviated");for(var i=0;i<n.length;i++){var W=w[i];q(W).text(n[(i+F)%7]);}var t=this;m(t);};M.prototype._handleBorderReached=function(o){var E=o.getParameter("event");var i=0;var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_DOWN){F.setUTCDate(F.getUTCDate()+7);}else{F.setUTCDate(F.getUTCDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_UP){F.setUTCDate(F.getUTCDate()-7);}else{F.setUTCDate(F.getUTCDate()-1);}break;case"sappagedown":i=F.getUTCMonth()+1;F.setUTCMonth(i);if(i%12!=F.getUTCMonth()){while(i!=F.getUTCMonth()){F.setUTCDate(F.getUTCDate()-1);}}break;case"sappageup":i=F.getUTCMonth()-1;F.setUTCMonth(i);if(i<0){i=11;}if(i!=F.getUTCMonth()){while(i!=F.getUTCMonth()){F.setUTCDate(F.getUTCDate()-1);}}break;default:break;}this.fireFocus({date:a._createLocalDate(F),otherMonth:true});}};M.prototype.checkDateFocusable=function(o){if(!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var i=this._getDate();var u=a._createUniversalUTCDate(o);if(u.getUTCFullYear()==i.getUTCFullYear()&&u.getUTCMonth()==i.getUTCMonth()){return true;}else{return false;}};M.prototype._renderHeader=function(){if(this.getShowHeader()){var o=this._getDate();var i=this._getLocaleData();var n=i.getMonthsStandAlone("wide");this.$("Head").text(n[o.getUTCMonth()]);}};function _(t){var o=t._getDate();var y=t._oFormatYyyymmdd.format(o,true);var n=0;var r=t.$("days").get(0);var p=t.$("days").find(".sapUiCalDay");for(var i=0;i<p.length;i++){var $=q(p[i]);if($.attr("data-sap-day")===y){n=i;break;}}if(!t._oItemNavigation){t._oItemNavigation=new I();t._oItemNavigation.attachEvent(I.Events.AfterFocus,b,t);t._oItemNavigation.attachEvent(I.Events.FocusAgain,c,t);t._oItemNavigation.attachEvent(I.Events.BorderReached,t._handleBorderReached,t);t.addDelegate(t._oItemNavigation);if(t._iColumns>1){t._oItemNavigation.setHomeEndColumnMode(true,true);}t._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});t._oItemNavigation.setCycling(false);t._oItemNavigation.setColumns(t._iColumns,true);}t._oItemNavigation.setRootDomRef(r);t._oItemNavigation.setItemDomRefs(p);t._oItemNavigation.setFocusedIndex(n);t._oItemNavigation.setPageSize(p.length);}function b(o){var n=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}var t=this;var O=this._getDate();var F=new U(O.getTime());var p=false;var r=this._oItemNavigation.getItemDomRefs();var i=0;var $=q(r[n]);var s;if($.hasClass("sapUiCalDayOtherMonth")){if(E.type=="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){F.setUTCDate(1);f(t,F);}else if(E.type=="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(i=r.length-1;i>0;i--){s=q(r[i]);if(!s.hasClass("sapUiCalDayOtherMonth")){F=new U(this._oFormatYyyymmdd.parse(s.attr("data-sap-day"),true).getTime());break;}}f(t,F);}else{p=true;F=new U(this._oFormatYyyymmdd.parse($.attr("data-sap-day"),true).getTime());if(!F){F=new U(O.getTime());}f(t,O);}}else{if(q(E.target).hasClass("sapUiCalWeekNum")){f(t,F);}else{F=new U(this._oFormatYyyymmdd.parse($.attr("data-sap-day"),true).getTime());this._setDate(F);}}this.fireFocus({date:a._createLocalDate(F),otherMonth:p});if(E.type=="mousedown"){d(t,E,F,n);}}function c(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var t=this;var F=this._getDate();d(t,E,F,i);}}function d(t,E,F,i){h(t,F,E.shiftKey);k(t);if(t.getIntervalSelection()&&t.$().is(":visible")){t._bindMousemove(true);}E.preventDefault();E.setMark("cancelAutoClose");}function e(t,o,n){if(!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+t);}var y=o.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+t);}var u=a._createUniversalUTCDate(o);var F=t.checkDateFocusable(o);t.setProperty("date",o,true);t._oUTCDate=u;if(t.getDomRef()){if(F){if(!n){f(t,t._oUTCDate,true);}}else{g(t,n);}}}function f(t,o,n){if(!n){t.setDate(new Date(o.getTime()));}var y=t._oFormatYyyymmdd.format(o,true);var p=t._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<p.length;i++){$=q(p[i]);if($.attr("data-sap-day")==y){t._oItemNavigation.focusItem(i);break;}}}function g(t,n){t._sRenderMonth=undefined;var o=t.getRenderer().getStartDate(t);var $=t.$("days");if($.length>0){var r=sap.ui.getCore().createRenderManager();t.getRenderer().renderDays(r,t,o);r.flush($[0]);r.destroy();}t._renderHeader();t.fireEvent("_renderMonth",{days:$.children(".sapUiCalDay").length});_(t);if(!n){t._oItemNavigation.focusItem(t._oItemNavigation.getFocusedIndex());}}function h(t,o,n,p){var s=t.getSelectedDates();var r;var u=t._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=t.getParent();var A=t;var S;if(P&&P.getSelectedDates){A=P;}if(t.getSingleSelection()){if(s.length>0){r=s[0];S=r.getStartDate();if(S){S=a._createUniversalUTCDate(S);}}else{r=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",r,true);}if(t.getIntervalSelection()&&(!r.getEndDate()||p)&&S){var E;if(o.getTime()<S.getTime()){E=S;S=o;if(!p){r.setProperty("startDate",a._createLocalDate(new Date(S.getTime())),true);r.setProperty("endDate",a._createLocalDate(new Date(E.getTime())),true);}}else if(o.getTime()>=S.getTime()){E=o;if(!p){r.setProperty("endDate",a._createLocalDate(new Date(E.getTime())),true);}}j(t,S,E);}else{j(t,o);r.setProperty("startDate",a._createLocalDate(new Date(o.getTime())),true);r.setProperty("endDate",undefined,true);}}else{if(t.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var v=t._checkDateSelected(o);if(v>0){for(i=0;i<s.length;i++){S=s[i].getStartDate();if(S&&o.getTime()==a._createUniversalUTCDate(S)){A.removeAggregation("selectedDates",i,true);break;}}}else{r=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(o.getTime()))});A.addAggregation("selectedDates",r,true);}y=t._oFormatYyyymmdd.format(o,true);for(i=0;i<u.length;i++){$=q(u[i]);if(!$.hasClass("sapUiCalDayOtherMonth")&&$.attr("data-sap-day")==y){if(v>0){$.removeClass("sapUiCalDaySel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");}}}}}}function j(t,s,E){var n=t._oItemNavigation.getItemDomRefs();var $;var i=0;if(!E){var y=t._oFormatYyyymmdd.format(s,true);for(i=0;i<n.length;i++){$=q(n[i]);if(!$.hasClass("sapUiCalDayOtherMonth")&&$.attr("data-sap-day")==y){$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");}else if($.hasClass("sapUiCalDaySel")){$.removeClass("sapUiCalDaySel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalDaySelStart")){$.removeClass("sapUiCalDaySelStart");}else if($.hasClass("sapUiCalDaySelBetween")){$.removeClass("sapUiCalDaySelBetween");}else if($.hasClass("sapUiCalDaySelEnd")){$.removeClass("sapUiCalDaySelEnd");}}}else{var o;for(i=0;i<n.length;i++){$=q(n[i]);o=new U(t._oFormatYyyymmdd.parse($.attr("data-sap-day"),true).getTime());if(o.getTime()==s.getTime()){$.addClass("sapUiCalDaySelStart");$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");if(E&&o.getTime()==E.getTime()){$.addClass("sapUiCalDaySelEnd");}$.removeClass("sapUiCalDaySelBetween");}else if(E&&o.getTime()>s.getTime()&&o.getTime()<E.getTime()){$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");$.addClass("sapUiCalDaySelBetween");$.removeClass("sapUiCalDaySelStart");$.removeClass("sapUiCalDaySelEnd");}else if(E&&o.getTime()==E.getTime()){$.addClass("sapUiCalDaySelEnd");$.addClass("sapUiCalDaySel");$.attr("aria-selected","true");$.removeClass("sapUiCalDaySelStart");$.removeClass("sapUiCalDaySelBetween");}else{if($.hasClass("sapUiCalDaySel")){$.removeClass("sapUiCalDaySel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalDaySelStart")){$.removeClass("sapUiCalDaySelStart");}else if($.hasClass("sapUiCalDaySelBetween")){$.removeClass("sapUiCalDaySelBetween");}else if($.hasClass("sapUiCalDaySelEnd")){$.removeClass("sapUiCalDaySelEnd");}}}}}function k(t){if(t._bMouseMove){t._unbindMousemove(true);}t.fireSelect();}function m(t){if(!t._bNamesLengthChecked){var w;var W=t.$().find(".sapUiCalWH");var T=false;var i=0;for(i=0;i<W.length;i++){w=W[i];if(w.clientWidth<w.scrollWidth){T=true;break;}}if(T){t._bLongWeekDays=false;var o=t._getLocaleData();var F=o.getFirstDayOfWeek();var n=o.getDaysStandAlone("narrow");for(i=0;i<n.length;i++){w=W[i];q(w).text(n[(i+F)%7]);}}else{t._bLongWeekDays=true;}t._bNamesLengthChecked=true;}}}());return M;},true);
