/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";var S=C.extend("sap.m.ScrollContainer",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},horizontal:{type:"boolean",group:"Behavior",defaultValue:true},vertical:{type:"boolean",group:"Behavior",defaultValue:false},focusable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});S.prototype.init=function(){q.sap.require("sap.ui.core.delegate.ScrollEnablement");this._oScroller=new sap.ui.core.delegate.ScrollEnablement(this,this.getId()+"-scroll",{horizontal:true,vertical:false});};S.prototype.onBeforeRendering=function(){this._oScroller.setHorizontal(this.getHorizontal());this._oScroller.setVertical(this.getVertical());};S.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}};S.prototype.getScrollDelegate=function(){return this._oScroller;};S.prototype.scrollTo=function(x,y,t){if(this._oScroller){var d=this.getDomRef();if(d){if(sap.ui.getCore().getConfiguration().getRTL()){x=q.sap.denormalizeScrollBeginRTL(x,d);}this._oScroller.scrollTo(x,y,t);}else{this._oScroller._scrollX=x;this._oScroller._scrollY=y;}}return this;};S.prototype.scrollToElement=function(e,t){if(e instanceof sap.ui.core.Element){e=e.getDomRef();}if(this._oScroller){this._oScroller.scrollToElement(e,t);}return this;};S.prototype.setHorizontal=function(h){this._oScroller.setHorizontal(h);this.setProperty("horizontal",h,true);};S.prototype.setVertical=function(v){this._oScroller.setVertical(v);this.setProperty("vertical",v,true);};return S;},true);
