/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Bar','./Dialog','./InputBase','./Popover','./SelectList','./SelectRenderer','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool'],function(q,B,D,I,P,S,a,l,C,E,b){"use strict";var c=C.extend("sap.m.Select",{metadata:{library:"sap.m",properties:{name:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},type:{type:"sap.m.SelectType",group:"Appearance",defaultValue:sap.m.SelectType.Default},autoAdjustWidth:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});b.insertFontFaceStyle();E.apply(c.prototype,[true]);function h(i){if(i){this.setSelection(i);this.setValue(i.getText());}this.scrollToItem(i);}c.prototype._handleFocusout=function(){this._bFocusoutDueRendering=this._bRenderingPhase;if(this._bFocusoutDueRendering){this._bProcessChange=false;return;}if(this._bProcessChange){this._checkSelectionChange();this._bProcessChange=false;}else{this._bProcessChange=true;}};c.prototype._checkSelectionChange=function(){var i=this.getSelectedItem();if(this._oSelectionOnFocus!==i){this.fireChange({selectedItem:i});}};c.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};c.prototype._callMethodInControl=function(f,A){var L=this.getList();if(A[0]==="items"){if(L){return S.prototype[f].apply(L,A);}}else{return C.prototype[f].apply(this,A);}};c.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};c.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};c.prototype.setSelectedIndex=function(i,_){var o;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);o=_[i];if(o){this.setSelection(o);}};c.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),d=i&&i.getDomRef();if(!p||!o||!d){return;}var e=o.scrollTop,f=d.offsetTop,g=o.clientHeight,j=d.offsetHeight;if(e>f){o.scrollTop=f;}else if((f+j)>(e+g)){o.scrollTop=Math.ceil(f+j-g);}};c.prototype.setValue=function(v){this.$("label").text(v);};c.prototype._isRequiredSelectElement=function(){if(this.getAutoAdjustWidth()){return false;}else if(this.getWidth()==="auto"){return true;}return false;};c.prototype._handleAriaActiveDescendant=function(i){var d=this.getDomRef(),o=i&&i.getDomRef(),A="aria-activedescendant";if(!d){return;}if(o&&this.isOpen()){d.setAttribute(A,i.getId());}else{d.removeAttribute(A);}};c.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};c.prototype.updateItems=function(r){S.prototype.updateItems.apply(this,arguments);this._oSelectionOnFocus=this.getSelectedItem();};c.prototype.refreshItems=function(){S.prototype.refreshItems.apply(this,arguments);};c.prototype.onBeforeOpen=function(){var p=this["_onBeforeOpen"+this.getPickerType()];this.addStyleClass(a.CSS_CLASS+"Pressed");this.addContent();p&&p.call(this);};c.prototype.onAfterOpen=function(){var d=this.getFocusDomRef(),i=null;if(!d){return;}i=this.getSelectedItem();d.setAttribute("aria-expanded","true");d.setAttribute("aria-owns",this.getList().getId());if(i){d.setAttribute("aria-activedescendant",i.getId());}};c.prototype.onBeforeClose=function(){var d=this.getFocusDomRef();if(d){d.removeAttribute("aria-owns");d.removeAttribute("aria-activedescendant");}this.removeStyleClass(a.CSS_CLASS+"Pressed");};c.prototype.onAfterClose=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("aria-expanded","false");d.removeAttribute("aria-owns");}};c.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};c.prototype.setPickerType=function(p){this._sPickerType=p;};c.prototype.getPickerType=function(){return this._sPickerType;};c.prototype._createPopover=function(){var t=this,p=new P({showHeader:false,placement:sap.m.PlacementType.Vertical,offsetX:0,offsetY:0,initialFocus:this,bounce:false});p.addEventDelegate({ontouchstart:function(e){var o=this.getDomRef("cont");if(e.target===o){t._bProcessChange=false;}}},p);this._decoratePopover(p);return p;};c.prototype._decoratePopover=function(p){var t=this;p._removeArrow=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];};p._setPosition=function(){this._myPositions=["begin bottom","begin center","begin top","end center"];this._atPositions=["begin top","end center","begin bottom","begin center"];};p._setMinWidth=function(w){this.getDomRef().style.minWidth=w;};p._setWidth=function(w){var A=t.getAutoAdjustWidth(),i=t.getType()==="IconOnly",o=this.getDomRef();if(sap.ui.Device.system.desktop||sap.ui.Device.system.tablet){if(A){o.style.width="auto";o.style.minWidth=w;}}if(!i){o.style.minWidth=w;}};p.open=function(){return this.openBy(t);};};c.prototype._onAfterRenderingPopover=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(sap.m.BaseFontSize))+"rem";p._removeArrow();p._setPosition();if(sap.ui.Device.system.phone){p._setMinWidth("100%");}else{p._setWidth(w);}};c.prototype._createDialog=function(){var d=a.CSS_CLASS;var o=new D({stretchOnPhone:true,customHeader:new B({contentLeft:new I({width:"100%",editable:false}).addStyleClass(d+"Input")}).addStyleClass(d+"Bar")});o.getAggregation("customHeader").attachBrowserEvent("tap",function(){o.close();},this);return o;};c.prototype._onBeforeOpenDialog=function(){var i=this.getPicker().getCustomHeader().getContentLeft()[0];i.setValue(this.getSelectedItem().getText());i.setTextDirection(this.getTextDirection());i.setTextAlign(this.getTextAlign());};c.prototype.init=function(){this.setPickerType(sap.ui.Device.system.phone?"Dialog":"Popover");this.createPicker(this.getPickerType());this._oSelectionOnFocus=null;this._bRenderingPhase=false;this._bFocusoutDueRendering=false;this._bProcessChange=false;};c.prototype.onBeforeRendering=function(){this._bRenderingPhase=true;if(this.getFocusDomRef()===document.activeElement){this._handleFocusout();}this.synchronizeSelection();};c.prototype.onAfterRendering=function(){this._bRenderingPhase=false;};c.prototype.exit=function(){this._oSelectionOnFocus=null;};c.prototype.ontouchstart=function(e){e.setMarked();if(this.getEnabled()&&this.isOpenArea(e.target)){this.addStyleClass(a.CSS_CLASS+"Pressed");}};c.prototype.ontouchend=function(e){e.setMarked();if(this.getEnabled()&&(!this.isOpen()||!this.hasContent())&&this.isOpenArea(e.target)){this.removeStyleClass(a.CSS_CLASS+"Pressed");}};c.prototype.ontap=function(e){var d=a.CSS_CLASS;e.setMarked();if(!this.getEnabled()){return;}if(this.isOpenArea(e.target)){if(this.isOpen()){this.close();this.removeStyleClass(d+"Pressed");return;}if(this.hasContent()){this.open();}}if(this.isOpen()){this.addStyleClass(d+"Pressed");}};c.prototype.onSelectionChange=function(o){var i=o.getParameter("selectedItem");this.close();this.setSelection(i);this.fireChange({selectedItem:i});this.setValue(this._getSelectedItemText());};c.prototype.onkeypress=function(e){e.setMarked();if(!this.getEnabled()){return;}var i=this.findNextItemByFirstCharacter(String.fromCharCode(e.which));h.call(this,i);};c.prototype.onsapshow=function(e){e.setMarked();if(e.which===q.sap.KeyCodes.F4){e.preventDefault();}this.toggleOpenState();};c.prototype.onsaphide=c.prototype.onsapshow;c.prototype.onsapescape=function(e){if(this.isOpen()){e.setMarked();this.close();this._checkSelectionChange();}};c.prototype.onsapenter=function(e){e.setMarked();this.close();this._checkSelectionChange();};c.prototype.onsapspace=function(e){e.setMarked();e.preventDefault();if(this.isOpen()){this._checkSelectionChange();}this.toggleOpenState();};c.prototype.onsapdown=function(e){e.setMarked();e.preventDefault();var n,s=this.getSelectableItems();n=s[s.indexOf(this.getSelectedItem())+1];h.call(this,n);};c.prototype.onsapup=function(e){e.setMarked();e.preventDefault();var p,s=this.getSelectableItems();p=s[s.indexOf(this.getSelectedItem())-1];h.call(this,p);};c.prototype.onsaphome=function(e){e.setMarked();e.preventDefault();var f=this.getSelectableItems()[0];h.call(this,f);};c.prototype.onsapend=function(e){e.setMarked();e.preventDefault();var L=this.findLastEnabledItem(this.getSelectableItems());h.call(this,L);};c.prototype.onsappagedown=function(e){e.setMarked();e.preventDefault();var s=this.getSelectableItems(),o=this.getSelectedItem();this.setSelectedIndex(s.indexOf(o)+10,s);o=this.getSelectedItem();if(o){this.setValue(o.getText());}this.scrollToItem(o);};c.prototype.onsappageup=function(e){e.setMarked();e.preventDefault();var s=this.getSelectableItems(),o=this.getSelectedItem();this.setSelectedIndex(s.indexOf(o)-10,s);o=this.getSelectedItem();if(o){this.setValue(o.getText());}this.scrollToItem(o);};c.prototype.onfocusin=function(e){if(!this._bFocusoutDueRendering&&!this._bProcessChange){this._oSelectionOnFocus=this.getSelectedItem();}this._bProcessChange=true;if(e.target!==this.getFocusDomRef()){this.focus();}};c.prototype.onfocusout=function(){this._handleFocusout();};c.prototype.onsapfocusleave=function(e){var p=this.getAggregation("picker");if(!e.relatedControlId||!p){return;}var o=sap.ui.getCore().byId(e.relatedControlId),f=o&&o.getFocusDomRef();if(sap.ui.Device.system.desktop&&q.sap.containsOrEquals(p.getFocusDomRef(),f)){this.focus();}};c.prototype.setSelection=function(i){var L=this.getList(),k;if(L){L.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof sap.ui.core.Item)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}k=i?i.getKey():"";this.setProperty("selectedKey",k,true);this._handleAriaActiveDescendant(i);};c.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};c.prototype.synchronizeSelection=function(){S.prototype.synchronizeSelection.call(this);};c.prototype.addContent=function(p){};c.prototype.createPicker=function(p){var o=this.getAggregation("picker"),d=a.CSS_CLASS;if(o){return o;}o=this["_create"+p]();this.setAggregation("picker",o,true);o.setHorizontalScrolling(false).addStyleClass(d+"Picker").addStyleClass(d+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.createList());return o;};c.prototype.findNextItemByFirstCharacter=function(s){var d=this.getItems(),e=this.getSelectedIndex(),f=d.splice(e+1,d.length-e),g=d.splice(0,d.length-1);d=f.concat(g);for(var i=0,o;i<d.length;i++){o=d[i];if(o.getEnabled()&&!(o instanceof sap.ui.core.SeparatorItem)&&q.sap.startsWithIgnoreCase(o.getText(),s)){return o;}}return null;};c.prototype.createList=function(){this._oList=new S({width:"100%"}).addEventDelegate({ontap:function(e){this.close();}},this).attachSelectionChange(this.onSelectionChange,this);return this._oList;};c.prototype.hasContent=function(){return!!this.getItems().length;};c.prototype.onBeforeRenderingPicker=function(){var o=this["_onBeforeRendering"+this.getPickerType()];o&&o.call(this);};c.prototype.onAfterRenderingPicker=function(){var o=this["_onAfterRendering"+this.getPickerType()];o&&o.call(this);};c.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};c.prototype.toggleOpenState=function(){if(this.isOpen()){this.close();}else if(this.hasContent()){this.open();}return this;};c.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};c.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};c.prototype.getSelectedIndex=function(){var s=this.getSelectedItem();return s?this.indexOfItem(this.getSelectedItem()):-1;};c.prototype.getDefaultSelectedItem=function(i){return this.findFirstEnabledItem();};c.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};c.prototype.getOpenArea=function(){return this.getDomRef();};c.prototype.isOpenArea=function(d){var o=this.getOpenArea();return o&&o.contains(d);};c.prototype.findItem=function(p,v){var L=this.getList();return L?L.findItem(p,v):null;};c.prototype.clearSelection=function(){this.setSelection(null);};c.prototype.onItemChange=function(o){var s=this.getAssociation("selectedItem"),n=o.getParameter("newValue"),p=o.getParameter("name");if(s===o.getParameter("id")){switch(p){case"text":this.setValue(n);break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(n);}break;}}};c.prototype.fireChange=function(p){this._oSelectionOnFocus=p.selectedItem;return this.fireEvent("change",p);};c.prototype.addAggregation=function(A,o,s){this._callMethodInControl("addAggregation",arguments);if(A==="items"&&!s&&!this.isInvalidateSuppressed()){this.invalidate(o);}return this;};c.prototype.getAggregation=function(){return this._callMethodInControl("getAggregation",arguments);};c.prototype.setAssociation=function(A,i,s){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.setAssociation.apply(L,arguments);}return C.prototype.setAssociation.apply(this,arguments);};c.prototype.indexOfAggregation=function(){return this._callMethodInControl("indexOfAggregation",arguments);};c.prototype.insertAggregation=function(){this._callMethodInControl("insertAggregation",arguments);return this;};c.prototype.removeAggregation=function(){return this._callMethodInControl("removeAggregation",arguments);};c.prototype.removeAllAggregation=function(){return this._callMethodInControl("removeAllAggregation",arguments);};c.prototype.destroyAggregation=function(A,s){this._callMethodInControl("destroyAggregation",arguments);if(!s&&!this.isInvalidateSuppressed()){this.invalidate();}return this;};c.prototype.setProperty=function(p,v,s){var L=this.getList();if((p==="selectedKey")||(p==="selectedItemId")){L&&S.prototype.setProperty.apply(L,arguments);}return C.prototype.setProperty.apply(this,arguments);};c.prototype.removeAllAssociation=function(A,s){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.removeAllAssociation.apply(L,arguments);}return C.prototype.removeAllAssociation.apply(this,arguments);};c.prototype.clone=function(s){var o=C.prototype.clone.apply(this,arguments),L=this.getList();if(!this.isBound("items")&&L){for(var i=0,d=L.getItems();i<d.length;i++){o.addItem(d[i].clone());}o.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return o;};c.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}return this;};c.prototype.insertItem=function(i,d){this.insertAggregation("items",i,d);if(i){i.attachEvent("_change",this.onItemChange,this);}return this;};c.prototype.findAggregatedObjects=function(){var L=this.getList();if(L){return S.prototype.findAggregatedObjects.apply(L,arguments);}return[];};c.prototype.getItems=function(){var L=this.getList();return L?L.getItems():[];};c.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(!(i instanceof sap.ui.core.Item)&&i!==null){q.sap.log.warning('Warning: setSelectedItem() "vItem" has to be an instance of sap.ui.core.Item, a valid sap.ui.core.Item id, or null on',this);return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};c.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText());return this;};c.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var i=this.getItemByKey(k);if(i||(k==="")){if(!i&&k===""){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;}return this.setProperty("selectedKey",k);};c.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};c.prototype.getSelectedItem=function(){var s=this.getAssociation("selectedItem");return(s===null)?null:sap.ui.getCore().byId(s)||null;};c.prototype.getFirstItem=function(){return this.getItems()[0]||null;};c.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};c.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};c.prototype.getItemByKey=function(k){var L=this.getList();return L?L.getItemByKey(k):null;};c.prototype.removeItem=function(i){var L=this.getList(),o;i=L?L.removeItem(i):null;if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){o=this.findFirstEnabledItem();if(o){this.setSelection(o);}}this.setValue(this._getSelectedItemText());if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};c.prototype.removeAllItems=function(){var L=this.getList(),d=L?L.removeAllItems():[];this.clearSelection();this.setValue("");this.$("select").children().remove();for(var i=0;i<d.length;i++){d[i].detachEvent("_change",this.onItemChange,this);}return d;};c.prototype.destroyItems=function(){var L=this.getList();if(L){L.destroyItems();}if(!this.isInvalidateSuppressed()){this.invalidate();}return this;};c.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};c.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};return c;},true);
