/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/Device'],function(q,C,R,D){"use strict";var S="S",M="M",L="L",X="XL",H="sapUiHidden",a="sapUiDSCSpan12",b=3,c=4,d=6,e=8,f=9,g=12,I="Invalid Breakpoint. Expected: S, M, L or XL",h="Invalid input. Only values greater then 0 are allowed",i="SCGridCell",j="MCGridCell",k=720,l=1053,m=1440;var n=C.extend("sap.ui.layout.DynamicSideContent",{metadata:{library:"sap.ui.layout",properties:{showSideContent:{type:"boolean",group:"Appearance",defaultValue:true},showMainContent:{type:"boolean",group:"Appearance",defaultValue:true},sideContentVisibility:{type:"sap.ui.layout.SideContentVisibility",group:"Appearance",defaultValue:sap.ui.layout.SideContentVisibility.ShowAboveS},sideContentFallDown:{type:"sap.ui.layout.SideContentFallDown",group:"Appearance",defaultValue:sap.ui.layout.SideContentFallDown.OnMinimumWidth},equalSplit:{type:"boolean",group:"Appearance",defaultValue:false},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mainContent",aggregations:{mainContent:{type:"sap.ui.core.Control",multiple:true},sideContent:{type:"sap.ui.core.Control",multiple:true}}}});n.prototype.setShowSideContent=function(v,s){this.setProperty("showSideContent",v,true);if(!s){this._changeGridState();}return this;};n.prototype.setShowMainContent=function(v,s){this.setProperty("showMainContent",v,true);if(!s){this._changeGridState();}return this;};n.prototype.setEqualSplit=function(s){this.setShowMainContent(true,true);this.setShowSideContent(true,true);this.setProperty("equalSplit",s,true);if(this._currentBreakpoint){this._setResizeData(this._currentBreakpoint,s);this._changeGridState();}return this;};n.prototype.addSideContent=function(o){this.addAggregation("sideContent",o,true);this._rerenderControl(this.getAggregation("sideContent"),this.$(i));return this;};n.prototype.addMainContent=function(o){this.addAggregation("mainContent",o,true);this._rerenderControl(this.getAggregation("mainContent"),this.$(j));return this;};n.prototype.toggle=function(){if(this._currentBreakpoint===S){if(this.getShowMainContent()&&!this.getShowSideContent()){this.setShowMainContent(false,true);this.setShowSideContent(true,true);}else if(!this.getShowMainContent()&&this.getShowSideContent()){this.setShowMainContent(true,true);this.setShowSideContent(false,true);}this._changeGridState();}return this;};n.prototype.getCurrentBreakpoint=function(){return this._currentBreakpoint;};n.prototype.onBeforeRendering=function(){this._detachContainerResizeListener();if(!this.getContainerQuery()){this._iWindowWidth=q(window).width();this._currentBreakpoint=this._getBreakPointFromWidth(this._iWindowWidth);this._setResizeData(this._currentBreakpoint,this.getEqualSplit());}};n.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._attachContainerResizeListener();}else{var t=this;q(window).resize(function(){t._handleMediaChange();});this._changeGridState();}this._initScrolling();};n.prototype.exit=function(){this._detachContainerResizeListener();if(this._oSCScroller){this._oSCScroller.destroy();this._oSCScroller=null;}if(this._oMCScroller){this._oMCScroller.destroy();this._oMCScroller=null;}};n.prototype._rerenderControl=function(o,$){if(this.getDomRef()){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderControls(r,o);r.flush($[0]);r.destroy();}return this;};n.prototype._initScrolling=function(){var s=this.getId(),o=s+"-"+i,p=s+"-"+j;if(!this._oSCScroller&&!this._oMCScroller){q.sap.require("sap.ui.core.delegate.ScrollEnablement");this._oSCScroller=new sap.ui.core.delegate.ScrollEnablement(this,null,{scrollContainerId:o,horizontal:false,vertical:true});this._oMCScroller=new sap.ui.core.delegate.ScrollEnablement(this,null,{scrollContainerId:p,horizontal:false,vertical:true});}};n.prototype._attachContainerResizeListener=function(){if(!this._sContainerResizeListener){this._sContainerResizeListener=R.register(this,q.proxy(this._handleMediaChange,this));}};n.prototype._detachContainerResizeListener=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}};n.prototype._getBreakPointFromWidth=function(w){if(w<=0){throw new Error(h);}if(w<=k&&this._currentBreakpoint!==S){return S;}else if((w>k)&&(w<=l)&&this._currentBreakpoint!==M){return M;}else if((w>l)&&(w<=m)&&this._currentBreakpoint!==L){return L;}else if(w>m&&this._currentBreakpoint!==X){return X;}return this._currentBreakpoint;};n.prototype._handleMediaChange=function(){if(this.getContainerQuery()){this._iWindowWidth=this.$().parent().width();}else{this._iWindowWidth=q(window).width();}if(this._iWindowWidth!==this._iOldWindowWidth){this._iOldWindowWidth=this._iWindowWidth;this._oldBreakPoint=this._currentBreakpoint;this._currentBreakpoint=this._getBreakPointFromWidth(this._iWindowWidth);if((this._oldBreakPoint!==this._currentBreakpoint)||this._currentBreakpoint===M){this._setResizeData(this._currentBreakpoint,this.getEqualSplit());this._changeGridState();}}};n.prototype._setResizeData=function(s,o){var p=this.getSideContentVisibility(),r=this.getSideContentFallDown();if(!o){switch(s){case S:this._setSpanSize(g,g);if(p===sap.ui.layout.SideContentVisibility.AlwaysShow){this.setShowSideContent(true,true);}else{this.setShowSideContent(false,true);}break;case M:var t=Math.ceil((33.333/100)*this._iWindowWidth);if(r===sap.ui.layout.SideContentFallDown.BelowL||r===sap.ui.layout.SideContentFallDown.BelowXL||(t<=320&&r===sap.ui.layout.SideContentFallDown.OnMinimumWidth)){this._setSpanSize(g,g);}else{this._setSpanSize(c,e);}if(p===sap.ui.layout.SideContentVisibility.ShowAboveS||p===sap.ui.layout.SideContentVisibility.AlwaysShow){this.setShowSideContent(true,true);}else{this.setShowSideContent(false,true);}this.setShowMainContent(true,true);break;case L:if(r===sap.ui.layout.SideContentFallDown.BelowXL){this._setSpanSize(g,g);}else{this._setSpanSize(c,e);}if(p===sap.ui.layout.SideContentVisibility.ShowAboveS||p===sap.ui.layout.SideContentVisibility.ShowAboveM||p===sap.ui.layout.SideContentVisibility.AlwaysShow){this.setShowSideContent(true,true);}else{this.setShowSideContent(false,true);}this.setShowMainContent(true,true);break;case X:this._setSpanSize(b,f);if(p!==sap.ui.layout.SideContentVisibility.NeverShow){this.setShowSideContent(true,true);}else{this.setShowSideContent(false,true);}this.setShowMainContent(true,true);break;default:throw new Error(I);}}else{switch(s){case S:this._setSpanSize(g,g);this.setShowSideContent(false,true);break;default:this._setSpanSize(d,d);this.setShowSideContent(true,true);this.setShowMainContent(true,true);}}return this;};n.prototype._shouldSetHeight=function(){if((this._iScSpan+this._iMcSpan)===g&&this.getShowMainContent()&&this.getShowSideContent()){return true;}return false;};n.prototype._changeGridState=function(){var $=this.$(i),o=this.$(j);if(this.getShowSideContent()&&this.getShowMainContent()){o.removeClass().addClass("sapUiDSCSpan"+this._iMcSpan);$.removeClass().addClass("sapUiDSCSpan"+this._iScSpan);if(this._shouldSetHeight()){$.css("height","100%").css("float","left");o.css("height","100%").css("float","left");}else{$.css("height","auto").css("float","none");o.css("height","auto").css("float","none");}}else if(!this.getShowSideContent()&&!this.getShowMainContent()){o.addClass(H);$.addClass(H);}else if(this.getShowMainContent()){o.removeClass().addClass(a);$.addClass(H);}else if(this.getShowSideContent()){$.removeClass().addClass(a);o.addClass(H);}};n.prototype._setSpanSize=function(s,o){this._iScSpan=s;this._iMcSpan=o;};return n;},true);
