/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./_AnnotationHelperBasics','sap/ui/base/BindingParser','sap/ui/core/format/DateFormat'],function(q,B,a,D){'use strict';var d="\\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\\d|3[01])",s="[-+]?\\d+(?:\\.\\d+)?",t="(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d(\\.\\d{1,12})?)?",E={Bool:/^true$|^false$/i,Float:new RegExp("^"+s+"(?:[eE][-+]?\\d+)?$|^NaN$|^-INF$|^INF$"),Date:new RegExp("^"+d+"$"),DateTimeOffset:new RegExp("^"+d+"T"+t+"(?:Z|[-+](?:0\\d|1[0-3]):[0-5]\\d|[-+]14:00)$","i"),Decimal:new RegExp("^"+s+"$"),Guid:/^[A-F0-9]{8}-(?:[A-F0-9]{4}-){3}[A-F0-9]{12}$/i,Int:/^[-+]?\d{1,19}$/,TimeOfDay:new RegExp("^"+t+"$")},r=/^(\/dataServices\/schema\/\d+\/entityType\/\d+)(?:\/|$)/,b,c=/^\d+$/,o={And:"&&",Eq:"===",Ge:">=",Gt:">",Le:"<=",Lt:"<",Ne:"!==",Not:"!",Or:"||"},f=/^(\/dataServices\/schema\/\d+)(?:\/|$)/,T={"Edm.Boolean":"boolean","Edm.Byte":"number","Edm.Date":"date","Edm.DateTime":"datetime","Edm.DateTimeOffset":"datetime","Edm.Decimal":"decimal","Edm.Double":"number","Edm.Float":"number","Edm.Guid":"string","Edm.Int16":"number","Edm.Int32":"number","Edm.Int64":"decimal","Edm.SByte":"number","Edm.Single":"number","Edm.String":"string","Edm.Time":"time","Edm.TimeOfDay":"time"},m={Bool:"Edm.Boolean",Float:"Edm.Double",Date:"Edm.Date",DateTimeOffset:"Edm.DateTimeOffset",Decimal:"Edm.Decimal",Guid:"Edm.Guid",Int:"Edm.Int64",String:"Edm.String",TimeOfDay:"Edm.TimeOfDay"},g={"boolean":false,"date":true,"datetime":true,"decimal":true,"number":false,"string":false,"time":true};b={adjustOperands:function(O,e){if(O.result!=="constant"&&O.category==="number"&&e.result==="constant"&&e.type==="Edm.Int64"){e.category=O.category;}if(O.result==="constant"&&O.category==="date"&&e.result!=="constant"&&e.category==="datetime"){e.category=O.category;}},apply:function(i,p,e){var n=B.descend(p,"Name","string"),P=B.descend(p,"Parameters");switch(n.value){case"odata.concat":return b.concat(i,P,e);case"odata.fillUriTemplate":return b.fillUriTemplate(i,P);case"odata.uriEncode":return b.uriEncode(i,P);default:B.error(n,"unknown function: "+n.value);}},concat:function(I,p,e){var P=[],R,h=[];B.expectType(p,"array");p.value.forEach(function(u,i){R=b.parameter(I,p,i);e=e||R.result==="expression";h.push(R);});h.forEach(function(R){if(e){b.wrapExpression(R);}if(R.type!=='edm:Null'){P.push(B.resultToString(R,e,true));}});R=e?{result:"expression",value:P.join("+")}:{result:"composite",value:P.join("")};R.type="Edm.String";return R;},conditional:function(i,p){var C=b.parameter(i,p,0,"Edm.Boolean"),e=b.parameter(i,p,1),h=b.parameter(i,p,2),j=e.type;if(e.type==="edm:Null"){j=h.type;}else if(h.type!=="edm:Null"&&e.type!==h.type){B.error(p,"Expected same type for second and third parameter, types are '"+e.type+"' and '"+h.type+"'");}return{result:"expression",type:j,value:B.resultToString(b.wrapExpression(C),true)+"?"+B.resultToString(b.wrapExpression(e),true)+":"+B.resultToString(b.wrapExpression(h),true)};},constant:function(i,p,e){var v=p.value;B.expectType(p,"string");if(e==="String"){if(i.getSetting&&i.getSetting("bindTexts")){return{result:"binding",type:"Edm.String",ignoreTypeInPath:true,value:"/##"+b.replaceIndexes(i.getModel(),p.path)};}}else if(!E[e].test(v)){B.error(p,"Expected "+e+" value but instead saw '"+v+"'");}return{result:"constant",type:m[e],value:v};},expression:function(i,p,e){var R=p.value,S,h;B.expectType(p,"object");if(R.hasOwnProperty("Type")){h=B.property(p,"Type","string");S=B.descend(p,"Value");}else{["And","Apply","Bool","Date","DateTimeOffset","Decimal","Float","Eq","Ge","Gt","Guid","If","Int","Le","Lt","Ne","Not","Null","Or","Path","PropertyPath","String","TimeOfDay"].forEach(function(P){if(R.hasOwnProperty(P)){h=P;S=B.descend(p,P);}});}switch(h){case"Apply":return b.apply(i,S,e);case"If":return b.conditional(i,S);case"Path":case"PropertyPath":return b.path(i,S);case"Bool":case"Date":case"DateTimeOffset":case"Decimal":case"Float":case"Guid":case"Int":case"String":case"TimeOfDay":return b.constant(i,S,h);case"And":case"Eq":case"Ge":case"Gt":case"Le":case"Lt":case"Ne":case"Or":return b.operator(i,S,h);case"Not":return b.not(i,S);case"Null":return{result:"constant",value:"null",type:"edm:Null"};default:B.error(p,"Unsupported OData expression");}},formatOperand:function(p,i,R,w){var e;if(R.result==="constant"){switch(R.category){case"boolean":case"number":return R.value;case"date":e=b.parseDate(R.value);if(!e){B.error(B.descend(p,i),"Invalid Date "+R.value);}return String(e.getTime());case"datetime":e=b.parseDateTimeOffset(R.value);if(!e){B.error(B.descend(p,i),"Invalid DateTime "+R.value);}return String(e.getTime());case"time":return String(b.parseTimeOfDay(R.value).getTime());}}if(w){b.wrapExpression(R);}return B.resultToString(R,true);},getExpression:function(i,R,w){var h;try{h=b.expression(i,{path:i.getPath(),value:R},false);return B.resultToString(h,false,w);}catch(e){if(e instanceof SyntaxError){return"Unsupported: "+a.complexParser.escape(B.toErrorString(R));}throw e;}},fillUriTemplate:function(I,p){var i,n,P=[],e="",h,j=p.value,R,k=b.parameter(I,p,0,"Edm.String");P.push('odata.fillUriTemplate(',B.resultToString(k,true),',{');for(i=1;i<j.length;i+=1){h=B.descend(p,i,"object");n=B.property(h,"Name","string");R=b.expression(I,B.descend(h,"Value"),true);P.push(e,B.toJSON(n),":",B.resultToString(R,true));e=",";}P.push("})");return{result:"expression",value:P.join(""),type:"Edm.String"};},not:function(i,p){var P=b.expression(i,p,true);return{result:"expression",value:"!"+B.resultToString(b.wrapExpression(P),true),type:"Edm.Boolean"};},operator:function(i,p,e){var h=e==="And"||e==="Or"?"Edm.Boolean":undefined,P=b.parameter(i,p,0,h),j=b.parameter(i,p,1,h),k,n,v,V;if(P.type!=="edm:Null"&&j.type!=="edm:Null"){P.category=T[P.type];j.category=T[j.type];b.adjustOperands(P,j);b.adjustOperands(j,P);if(P.category!==j.category){B.error(p,"Expected two comparable parameters but instead saw "+P.type+" and "+j.type);}k=P.category==="decimal"?",true":"";n=g[P.category];}v=b.formatOperand(p,0,P,!n);V=b.formatOperand(p,1,j,!n);return{result:"expression",value:n?"odata.compare("+v+","+V+k+")"+o[e]+"0":v+o[e]+V,type:"Edm.Boolean"};},parameter:function(i,p,I,e){var P=B.descend(p,I),R=b.expression(i,P,true);if(e&&e!==R.type){B.error(P,"Expected "+e+" but instead saw "+R.type);}return R;},parseDate:function(v){return D.getDateInstance({pattern:"yyyy-MM-dd",strictParsing:true,UTC:true}).parse(v);},parseDateTimeOffset:function(v){var M=E.DateTimeOffset.exec(v);if(M&&M[1]&&M[1].length>4){v=v.replace(M[1],M[1].slice(0,4));}return D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSX",strictParsing:true}).parse(v.toUpperCase());},parseTimeOfDay:function(v){if(v.length>12){v=v.slice(0,12);}return D.getTimeInstance({pattern:"HH:mm:ss.SSS",strictParsing:true,UTC:true}).parse(v);},path:function(i,p){var e=p.value,C={},h,M=i.getModel(),j=r.exec(p.path),P,k,R={result:"binding",value:e};B.expectType(p,"string");if(j){h=M.getProperty(j[1]);P=e.split('/');k=M.getODataProperty(h,P);if(k&&!P.length){R.type=k.type;switch(k.type){case"Edm.DateTime":C.displayFormat=k["sap:display-format"];break;case"Edm.Decimal":C.precision=k.precision;C.scale=k.scale;break;case"Edm.String":C.maxLength=k.maxLength;break;}if(k.nullable==="false"){C.nullable=k.nullable;}R.constraints=C;}if(!R.type){q.sap.log.warning("Could not determine type for property '"+e+"' of entity type '"+h.name+"'",null,"sap.ui.model.odata.AnnotationHelper");}}return R;},replaceIndexes:function(M,p){var e,P=p.split('/'),O,R;function h(j,i){var k=M.getProperty(O+"/"+j);if(typeof k==="string"){P[i]="[${"+j+"}==="+B.toJSON(k)+"]";return true;}return false;}e=f.exec(p);if(!e){return p;}O=e[1];if(!h("namespace",3)){return p;}for(var i=4;i<P.length;i++){O=O+"/"+P[i];if(c.test(P[i])&&!h("name",i)){R=M.getProperty(O+"/RecordType");if(R){if(R==="com.sap.vocabularies.UI.v1.DataFieldForAction"){h("Action/String",i);}else if(R==="com.sap.vocabularies.UI.v1.DataFieldForAnnotation"){h("Target/AnnotationPath",i);}else if(R.indexOf("com.sap.vocabularies.UI.v1.DataField")===0){h("Value/Path",i);}}}}return P.join('/');},uriEncode:function(i,p){var R=b.parameter(i,p,0);if(R.result==="constant"){if(R.type==="Edm.Date"){R.type="Edm.DateTime";R.value=R.value+"T00:00:00Z";}else if(R.type==="Edm.TimeOfDay"){R.type="Edm.Time";R.value="PT"+R.value.slice(0,2)+"H"+R.value.slice(3,5)+"M"+R.value.slice(6,8)+"S";}}return{result:"expression",value:'odata.uriEncode('+B.resultToString(R,true)+","+B.toJSON(R.type)+")",type:"Edm.String"};},wrapExpression:function(R){if(R.result==="expression"){R.value="("+R.value+")";}return R;}};return b;},false);
