/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/m/ToggleButton','sap/ui/core/InvisibleText','sap/m/Toolbar','sap/m/ToolbarSpacer','sap/m/OverflowToolbarLayoutData','sap/m/OverflowToolbarAssociativePopover','sap/m/OverflowToolbarAssociativePopoverControls'],function(q,l,T,I,a,b,O,c,d){"use strict";var e=a.extend("sap.m.OverflowToolbar",{metadata:{aggregations:{_overflowButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}}}});e.prototype._callToolbarMethod=function(f,A){return a.prototype[f].apply(this,A);};e.prototype.init=function(){this._callToolbarMethod("init",arguments);this._iPreviousToolbarWidth=null;this._bOverflowButtonNeeded=false;this._bListenForControlPropertyChanges=false;this._bControlsInfoCached=false;this._bSkipOptimization=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");e.prototype._sAriaOverflowButtonLabelId=new I({text:this._oResourceBundle.getText("LOAD_MORE_DATA")}).toStatic().getId();};e.prototype.onAfterRendering=function(){if(this._bControlWasFocused){this._getOverflowButton().focus();this._bControlWasFocused=false;}if(this._bOverflowButtonWasFocused&&!this._getOverflowButtonNeeded()){this.$().lastFocusableDomRef().focus();this._bOverflowButtonWasFocused=false;}this._getOverflowButton().$().attr("aria-haspopup","true");this._doLayout();};e.prototype._doLayout=function(){this._bListenForControlPropertyChanges=false;this._deregisterToolbarResize();this._polyfillFlexboxSupport();if(!this._bControlsInfoCached){this._cacheControlsInfo();}if(this._iPreviousToolbarWidth!==this.$().width()){this._iPreviousToolbarWidth=this.$().width();this._setControlsOverflowAndShrinking();}this._registerToolbarResize();this._bListenForControlPropertyChanges=true;};e.prototype._polyfillFlexboxSupport=function(){if(a.hasNewFlexBoxSupport){return;}if(a.hasFlexBoxSupport){var t=this.$();var D=t[0]||{};t.removeClass("sapMTBOverflow");var o=D.scrollWidth>D.clientWidth;o&&t.addClass("sapMTBOverflow");}else{a.flexie(this.$());}};e.prototype._cacheControlsInfo=function(){var s,m;this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aActionSheetOnlyControls=[];this._aControlSizes={};this._iContentSize=0;this.getContent().forEach(function(C){var L=C.getLayoutData();if(L instanceof O){s=L.getStayInOverflow();m=L.getMoveToOverflow();}else{s=false;m=true;}var i=e._getOptimalControlWidth(C);this._aControlSizes[C.getId()]=i;if(d.supportsControl(C)&&s){this._aActionSheetOnlyControls.push(C);}else{this._iContentSize+=i;if(d.supportsControl(C)&&m){this._aMovableControls.push(C);}else{this._aToolbarOnlyControls.push(C);}}},this);this._bControlsInfoCached=true;};e.prototype._setControlsOverflowAndShrinking=function(){var t=this.$().width(),C=this._iContentSize,B=[],s,i,f=function(h){h.forEach(function(o){this._moveButtonToActionSheet(o);},this);},g=function(h){if(typeof h==="undefined"||this._getPopover()._getContentIdsHash()!==h){this.invalidate();if(this._getControlsIds().indexOf(sap.ui.getCore().getCurrentFocusedControlId())!==-1){this._bControlWasFocused=true;}if(sap.ui.getCore().getCurrentFocusedControlId()===this._getOverflowButton().getId()){this._bOverflowButtonWasFocused=true;}}},A=function(C){if(!this._getOverflowButtonNeeded()){C+=this._getOverflowButtonSize();this._setOverflowButtonNeeded(true);}return C;};if(this._bSkipOptimization){this._bSkipOptimization=false;}else{s=this._getPopover()._getContentIdsHash();}this._resetToolbar();if(this._aActionSheetOnlyControls.length){for(i=this._aActionSheetOnlyControls.length-1;i>=0;i--){B.unshift(this._aActionSheetOnlyControls[i]);}C=A.call(this,C);}if(C<=t){f.call(this,B);g.call(this,s);return;}if(this._aMovableControls.length){C=A.call(this,C);for(i=this._aMovableControls.length-1;i>=0;i--){B.unshift(this._aMovableControls[i]);C-=this._aControlSizes[this._aMovableControls[i].getId()];if(C<=t){break;}}}f.call(this,B);if(C>t){this._checkContents();}g.call(this,s);};e.prototype._resetToolbar=function(){this._getPopover().close();this._getPopover()._getAllContent().forEach(function(B){this._restoreButtonInToolbar(B);},this);this._setOverflowButtonNeeded(false);this.getContent().forEach(function(C){C.removeStyleClass(a.shrinkClass);});};e.prototype._moveButtonToActionSheet=function(B){this._getPopover().addAssociatedContent(B);};e.prototype._restoreButtonInToolbar=function(B){if(typeof B==="object"){B=B.getId();}this._getPopover().removeAssociatedContent(B);};e.prototype._resetAndInvalidateToolbar=function(h){this._resetToolbar();this._bControlsInfoCached=false;this._iPreviousToolbarWidth=null;if(h){this._bSkipOptimization=true;}this.invalidate();};e.prototype._getVisibleContent=function(){var t=this.getContent(),A=this._getPopover()._getAllContent();return t.filter(function(C){return A.indexOf(C)===-1;});};e.prototype._getOverflowButton=function(){var o;if(!this.getAggregation("_overflowButton")){o=new T({icon:"sap-icon://overflow",press:this._overflowButtonPressed.bind(this),ariaLabelledBy:this._sAriaOverflowButtonLabelId,tooltip:this._oResourceBundle.getText("LOAD_MORE_DATA"),type:sap.m.ButtonType.Transparent});this.setAggregation("_overflowButton",o,true);}return this.getAggregation("_overflowButton");};e.prototype._overflowButtonPressed=function(E){var p=this._getPopover(),B=this._getBestActionSheetPlacement();if(p.getPlacement()!==B){p.setPlacement(B);}if(p.isOpen()){p.close();}else{p.openBy(E.getSource());}};e.prototype._getPopover=function(){var p;if(!this.getAggregation("_popover")){p=new c(this.getId()+"-popover",{showHeader:false,modal:false,horizontalScrolling:sap.ui.Device.system.phone?false:true,contentWidth:sap.ui.Device.system.phone?"100%":"auto"});if(sap.ui.Device.system.phone){p.attachBeforeOpen(this._shiftPopupShadow,this);p.attachAfterOpen(this._shiftPopupShadow,this);}p.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",p,true);}return this.getAggregation("_popover");};e.prototype._shiftPopupShadow=function(){var p=this._getPopover(),P=p.getCurrentPosition();if(P===sap.m.PlacementType.Bottom){p.addStyleClass("sapMOTAPopoverNoShadowTop");p.removeStyleClass("sapMOTAPopoverNoShadowBottom");}else if(P===sap.m.PlacementType.Top){p.addStyleClass("sapMOTAPopoverNoShadowBottom");p.removeStyleClass("sapMOTAPopoverNoShadowTop");}};e.prototype._popOverClosedHandler=function(){this._getOverflowButton().setPressed(false);this._getOverflowButton().$().focus();this._getOverflowButton().setEnabled(false);q.sap.delayedCall(0,this,function(){this._getOverflowButton().setEnabled(true);q.sap.delayedCall(0,this,function(){this._getOverflowButton().$().focus();});});};e.prototype._getOverflowButtonNeeded=function(){return this._bOverflowButtonNeeded;};e.prototype._setOverflowButtonNeeded=function(v){if(this._bOverflowButtonNeeded!==v){this._bOverflowButtonNeeded=v;}return this;};e.prototype.onLayoutDataChange=function(){this._resetAndInvalidateToolbar(true);};e.prototype.addContent=function(C){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("addContent",arguments);};e.prototype.insertContent=function(C,i){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("insertContent",arguments);};e.prototype.removeContent=function(C){var v=this._callToolbarMethod("removeContent",arguments);this._resetAndInvalidateToolbar(false);this._deregisterControlListener(v);return v;};e.prototype.removeAllContent=function(){var C=this._callToolbarMethod("removeAllContent",arguments);C.forEach(this._deregisterControlListener,this);this._resetAndInvalidateToolbar(false);return C;};e.prototype.destroyContent=function(){this._resetAndInvalidateToolbar(false);q.sap.delayedCall(0,this,function(){this._resetAndInvalidateToolbar(false);});return this._callToolbarMethod("destroyContent",arguments);};e.prototype._registerControlListener=function(C){if(C){C.attachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};e.prototype._deregisterControlListener=function(C){if(C){C.detachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};e.prototype._onContentPropertyChangedOverflowToolbar=function(E){if(!this._bListenForControlPropertyChanges){return;}var s=E.getSource().getMetadata().getName();var C=d.getControlConfig(s);var p=E.getParameter("name");if(typeof C!=="undefined"&&C.noInvalidationProps.indexOf(p)!==-1){return;}this._resetAndInvalidateToolbar(true);};e.prototype._getOverflowButtonSize=function(){var B=parseInt(sap.m.BaseFontSize,10),C=this.$().parents().hasClass('sapUiSizeCompact')?2.5:3;return parseInt(B*C,10);};e.prototype._getBestActionSheetPlacement=function(){var h=this.getHTMLTag();if(h==="Footer"){return sap.m.PlacementType.Top;}else if(h==="Header"){return sap.m.PlacementType.Bottom;}return sap.ui.Device.system.phone?sap.m.PlacementType.Vertical:sap.m.PlacementType.Auto;};e.prototype._getControlsIds=function(){return this.getContent().map(function(i){return i.getId();});};e._getOptimalControlWidth=function(C){var o;if(C instanceof b){o=parseInt(C.$().css('min-width'),10)||0+C.$().outerWidth(true)-C.$().outerWidth();}else{o=C.$().outerWidth(true);}return o;};return e;},true);
