/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","./Page","./WizardStep","./WizardProgressNavigator","./Toolbar","./ToolbarSpacer","./Button"],function(q,l,C,P,W,a,T,b,B){"use strict";var c=C.extend("sap.m.Wizard",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},showNextButton:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"steps",aggregations:{steps:{type:"sap.m.WizardStep",multiple:true,singularName:"step"},_page:{type:"sap.m.Page",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{stepActivate:{parameters:{index:{type:"int"}}},complete:{parameters:{}}}}});c.CONSTANTS={MINIMUM_STEPS:3,MAXIMUM_STEPS:8,ANIMATION_TIME:300,LOCK_TIME:450};c.prototype.init=function(){this._stepCount=0;this._scrollLocked=false;this._autoStepLock=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._initPage();};c.prototype.onBeforeRendering=function(){if(!this._isMinStepCountReached()||this._isMaxStepCountExceeded()){q.sap.log.error("The Wizard is supposed to handle from 3 to 8 steps.");}this._saveInitialValidatedState();this._initNextButton();};c.prototype.onAfterRendering=function(){var s=this._getWizardStep(0);if(s){s._activate();}};c.prototype.exit=function(){this._stepCount=null;this._scrollLocked=null;this._oResourceBundle=null;};c.prototype.validateStep=function(s){if(!this._containsStep(s)){q.sap.log.error("The wizard does not contain this step");return this;}s.setProperty("validated",true,true);this._updateNextButtonState();return this;};c.prototype.invalidateStep=function(s){if(!this._containsStep(s)){q.sap.log.error("The wizard does not contain this step");return this;}s.setProperty("validated",false,true);this._updateNextButtonState();return this;};c.prototype.nextStep=function(){this.validateStep(this.getSteps()[this._getProgressNavigator().getProgress()-1]);this._handleNextButtonPress();return this;};c.prototype.previousStep=function(){var d=this._getProgressNavigator().getProgress()-2;if(d>0){this.discardProgress(this.getSteps()[d]);}return this;};c.prototype.getProgress=function(){return this._getProgressNavigator().getProgress();};c.prototype.getProgressStep=function(){return this._getWizardStep(this.getProgress()-1);};c.prototype.goToStep=function(s,f){this._scrollLocked=true;this._getPage().scrollToElement(s,c.CONSTANTS.ANIMATION_TIME);q.sap.delayedCall(c.CONSTANTS.LOCK_TIME,this,function(){var p=this._getProgressNavigator();if(!p){this._scrollLocked=false;return;}p._updateCurrentStep(this._getStepIndex(s)+1);this._scrollLocked=false;if(f||f===undefined){this._focusFirstStepElement(s);}});return this;};c.prototype.discardProgress=function(s){var p=this.getProgress(),d=this._getStepCount(),e=this.getSteps(),f=this._getStepIndex(s)+1;if(f>p||f<=0){q.sap.log.warning("The given step is either not yet reached, or is not present in the wizard control.");return;}this._getProgressNavigator().discardProgress(f);this._updateNextButtonState();this._setNextButtonPosition();this._restoreInitialValidatedState(f);this._getWizardStep(f-1)._markAsLast();for(var i=f;i<d;i++){e[i]._deactivate(this._getAutoStepLock());}if(this._getAutoStepLock()){s._unlockContent();}return this;};c.prototype.setShowNextButton=function(v){this.setProperty("showNextButton",v,true);if(this._getNextButton()){this._getNextButton().setVisible(v);}return this;};c.prototype.getSteps=function(){return this._getPage().getContent().filter(function(d){return d instanceof W;});};c.prototype.addStep=function(w){if(this._isMaxStepCountExceeded()){q.sap.log.error("The Wizard is supposed to handle up to 8 steps.");return this;}this._incrementStepCount();this._getPage().addContent(w);return this;};c.prototype.insertStep=function(w,i){throw new Error("Dynamic step insertion is not yet supported.");};c.prototype.removeStep=function(w){throw new Error("Dynamic step removal is not yet supported.");};c.prototype.removeAllSteps=function(){this._resetStepCount();return this._getPage().removeAllContent();};c.prototype.destroySteps=function(){this._resetStepCount();this._getProgressNavigator().setStepCount(this._getStepCount());this._getPage().destroyContent();return this;};c.prototype._initPage=function(){var p=new P({showHeader:false,subHeader:this._createSubHeader()});p.addEventDelegate({onAfterRendering:this._attachScrollHandler.bind(this)});this.setAggregation("_page",p);};c.prototype._setAutoStepLock=function(e){this._autoStepLock=e;};c.prototype._getAutoStepLock=function(){return this._autoStepLock;};c.prototype._createSubHeader=function(){var t=this,p=new a({stepChanged:this._handleStepChanged.bind(this),stepActivated:this._handleStepActivated.bind(this)});p._setOnEnter(function(e,s){var d=t._getWizardStep(s);q.sap.delayedCall(c.CONSTANTS.ANIMATION_TIME,this,function(){this._focusFirstStepElement(d);});});return new T({height:"4rem",content:p});};c.prototype._focusFirstStepElement=function(s){var $=s.$();if($.firstFocusableDomRef()){$.firstFocusableDomRef().focus();}};c.prototype._handleStepChanged=function(e){if(this._scrollLocked){return;}var d=e.getParameter("current");var f=this._getWizardStep(d-1);this.goToStep(f,false);};c.prototype._handleStepActivated=function(e){var i=e.getParameter("index"),s=this.getSteps();s[i-2]._complete(this._getAutoStepLock());s[i-1]._activate();this.fireStepActivate({index:i});this._setNextButtonPosition();};c.prototype._getPage=function(){return this.getAggregation("_page");};c.prototype._isMaxStepCountExceeded=function(){var s=this._getStepCount();return s>=c.CONSTANTS.MAXIMUM_STEPS;};c.prototype._isMinStepCountReached=function(){var s=this._getStepCount();return s>=c.CONSTANTS.MINIMUM_STEPS;};c.prototype._getStepCount=function(){return this._stepCount;};c.prototype._incrementStepCount=function(){this._stepCount+=1;this._getProgressNavigator().setStepCount(this._getStepCount());};c.prototype._decrementStepCount=function(){this._stepCount-=1;this._getProgressNavigator().setStepCount(this._getStepCount());};c.prototype._resetStepCount=function(){this._stepCount=0;this._getProgressNavigator().setStepCount(this._getStepCount());};c.prototype._getProgressNavigator=function(){var p=this._getPage();if(!p){return null;}return p.getSubHeader().getContent()[0];};c.prototype._saveInitialValidatedState=function(){var s=this.getSteps();if(this._initialValidatedState){return;}this._initialValidatedState=[];for(var i=0;i<s.length;i++){this._initialValidatedState[i]=s[i].getValidated();}};c.prototype._restoreInitialValidatedState=function(d){var s=this.getSteps();for(var i=d;i<s.length;i++){var e=this._initialValidatedState[i];s[i].setValidated(e);}};c.prototype._initNextButton=function(){if(this._getNextButton()){return;}this.setAggregation("_nextButton",this._createNextButton());this._setNextButtonPosition();};c.prototype._createNextButton=function(){var f=this._getWizardStep(0),i=(f)?f.getValidated():true,n=new B({text:this._oResourceBundle.getText("WIZARD_NEXT"),type:sap.m.ButtonType.Emphasized,enabled:i,press:this._handleNextButtonPress.bind(this),visible:this.getShowNextButton()});n.addStyleClass("sapMWizardNextButton");n.addEventDelegate({onAfterRendering:this._toggleNextButtonVisibility},this);this._nextButton=n;return n;};c.prototype._handleNextButtonPress=function(){var p=this._getProgressNavigator(),d=p.getProgress(),s=p.getStepCount();if(d===s){this.fireComplete();}else{p.incrementProgress();}this._updateNextButtonState();};c.prototype._toggleNextButtonVisibility=function(){q.sap.delayedCall(0,this,function(){if(this._getNextButton().getEnabled()){this._getNextButton().addStyleClass("sapMWizardNextButtonVisible");}else{this._getNextButton().removeStyleClass("sapMWizardNextButtonVisible");}});};c.prototype._setNextButtonPosition=function(){if(sap.ui.Device.system.phone){return;}var d=this._getNextButton(),p=this._getProgressNavigator().getProgress(),e=this._getWizardStep(p-1);if(e){e.addContent(d);}};c.prototype._updateNextButtonState=function(){var s=this._getStepCount(),n=this._getNextButton(),p=this.getProgress(),i=this._getWizardStep(p-1).getValidated();n.setEnabled(i);if(p===s){n.setText(this._oResourceBundle.getText("WIZARD_FINISH"));}else{n.setText(this._oResourceBundle.getText("WIZARD_NEXT"));}};c.prototype._getNextButton=function(){return this._nextButton;};c.prototype._getWizardStep=function(i){return this.getSteps()[i];};c.prototype._attachScrollHandler=function(){var p=this._getPage(),d=p.getDomRef("cont");d.onscroll=this._scrollHandler.bind(this);};c.prototype._scrollHandler=function(e){if(this._scrollLocked){return;}var s=e.target.scrollTop,p=this._getProgressNavigator(),d=this._getWizardStep(p.getCurrentStep()-1).getDomRef(),f=d.clientHeight,g=d.offsetTop,h=100;this._scrollLocked=true;if(s+h>=g+f){p.nextStep();}if(s+h<=g){p.previousStep();}this._scrollLocked=false;};c.prototype._containsStep=function(s){return this.getSteps().some(function(o){return o===s;});};c.prototype._getStepIndex=function(s){var d=this.getSteps();for(var i=0;i<d.length;i++){if(d[i]==s){return i;}}return-1;};return c;},true);
