/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","./Button","./MessageBox"],function(l,C,B,M){"use strict";var W=C.extend("sap.m.WizardStep",{metadata:{properties:{title:{type:"string",group:"appearance",defaultValue:""},validated:{type:"boolean",group:"Behavior",defaultValue:true}},events:{complete:{parameters:{}},activate:{parameters:{}}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_editButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}}});W.prototype.init=function(){this._enabled=true;this._initEditButton();};W.prototype.getEnabled=function(){return this._enabled;};W.prototype.setValidated=function(v){this.setProperty("validated",v,true);var p=this._getWizardParent();if(p===null){return this;}if(v){p.validateStep(this);}else{p.invalidateStep(this);}return this;};W.prototype._getWizardParent=function(){var p=this.getParent();while(!(p instanceof sap.m.Wizard)){if(p===null){return null;}p=p.getParent();}return p;};W.prototype._initEditButton=function(){var t=this;var e=new B({visible:false,icon:"sap-icon://edit",press:function(){M.confirm("Are you sure you want to edit this step and discard the progress?",{actions:[M.Action.YES,M.Action.NO],onClose:function(a){if(a===M.Action.YES){var w=t._getWizardParent();w.discardProgress(t);}}});}});e.getEnabled=function(){return true;};this.setAggregation("_editButton",e);};W.prototype._markAsLast=function(){this.addStyleClass("sapMWizardLastActivatedStep");};W.prototype._unMarkAsLast=function(){this.removeStyleClass("sapMWizardLastActivatedStep");};W.prototype._activate=function(){if(this.hasStyleClass("sapMWizardStepActivated")){return;}this._markAsLast();this.addStyleClass("sapMWizardStepActivated");this.fireActivate();};W.prototype._deactivate=function(u){this.removeStyleClass("sapMWizardStepActivated");if(u){this._unlockContent();}};W.prototype._complete=function(a){this._unMarkAsLast();this.fireComplete();if(a){this._lockContent();}};W.prototype._lockContent=function(){this._enabled=false;this._getEditButton().setVisible(true);this.invalidate();};W.prototype._unlockContent=function(){this._enabled=true;this._getEditButton().setVisible(false);this.invalidate();};W.prototype._getEditButton=function(){return this.getAggregation("_editButton");};return W;},true);
