/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','sap/ui/model/odata/ODataAnnotations','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/UpdateMethod','sap/ui/model/odata/OperationMode','./ODataContextBinding','./ODataListBinding','sap/ui/model/odata/ODataMetadata','sap/ui/model/odata/ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/odata/ODataMetaModel','sap/ui/core/message/MessageParser','sap/ui/model/odata/ODataMessageParser','sap/ui/thirdparty/datajs'],function(q,B,C,M,O,a,b,U,c,d,e,f,g,h,k,l,m,n){"use strict";var o=M.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(s,p){M.apply(this,arguments);var u,P,H,t,w,i,j,r,A,L,D,v,x,y,S,z,E,J,F,G,I,K=this;if(typeof(s)==="object"){p=s;s=p.serviceUrl;}if(p){u=p.user;P=p.password;H=p.headers;t=p.tokenHandling;w=p.withCredentials;i=p.maxDataServiceVersion;j=p.useBatch;r=p.refreshAfterChange;A=p.annotationURI;L=p.loadAnnotationsJoined;v=p.defaultBindingMode;D=p.defaultCountMode;x=p.defaultOperationMode;y=p.metadataNamespaces;S=p.serviceUrlParams;z=p.metadataUrlParams;J=p.json;F=p.messageParser;G=p.skipMetadataAnnotationParsing;I=p.defaultUpdateMethod;}this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.sDefaultBindingMode=v||B.OneWay;this.bJSON=J!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredBatchGroups={};this.mChangeBatchGroups={'*':{batchGroupId:undefined,single:true}};this.sDefaultUpdateMethod=I||U.Merge;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=j!==false;this.bRefreshAfterChange=r!==false;this.sMaxDataServiceVersion=i;this.bLoadMetadataAsync=true;this.bLoadAnnotationsJoined=L!==false;this.sAnnotationURI=A;this.sDefaultCountMode=D||b.Request;this.sDefaultOperationMode=x||c.Server;this.oMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshBatchGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=G;if(F){F.setProcessor(this);}this.oMessageParser=F;this.sDefaultChangeBatchGroup="changes";this.setDeferredBatchGroups([this.sDefaultChangeBatchGroup]);this.setChangeBatchGroups({"*":{batchGroupId:this.sDefaultChangeBatchGroup}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.sServiceUrl=s;var N=s.split("?");if(N.length>1){this.sServiceUrl=N[0];if(N[1]){this.aUrlParams.push(N[1]);}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=u;this.sPassword=P;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.oHeaders={};this.setHeaders(H);E=a._createUrlParamsArray(z);var Q=this._createRequestUrl("/$metadata",undefined,E);this.oServiceData=o.mServiceData[Q];if(!this.oServiceData){o.mServiceData[Q]={};this.oServiceData=o.mServiceData[Q];}if(!this.oServiceData.oMetadata){this.oMetadata=new f(Q,{async:this.bLoadMetadataAsync,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:y,withCredentials:this.bWithCredentials});this.oServiceData.oMetadata=this.oMetadata;}else{this.oMetadata=this.oServiceData.oMetadata;}this.pAnnotationsLoaded=this.oMetadata.loaded();if(this.sAnnotationURI||!this.bSkipMetadataAnnotationParsing){var R=this._getAnnotationParser();if(!this.bSkipMetadataAnnotationParsing){this.pAnnotationsLoaded=this.oMetadata.loaded().then(function(T,V){if(this.bDestroyed){return Promise.reject();}return this.addAnnotationXML(V["metadataString"],T);}.bind(this,!!this.sAnnotationURI));}if(this.sAnnotationURI){this.pAnnotationsLoaded=Promise.all([this.pAnnotationsLoaded,R.addUrl(this.sAnnotationURI)]);}}if(S){this.aUrlParams=this.aUrlParams.concat(a._createUrlParamsArray(S));}this.onMetadataLoaded=function(T){K._initializeMetadata();};this.onMetadataFailed=function(T){K.fireMetadataFailed(T.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachLoaded(this.onMetadataLoaded);this.oMetadata.attachFailed(this.onMetadataFailed);}if(this.oMetadata.isFailed()){this.refreshMetadata();}if(this.oMetadata.isLoaded()){this._initializeMetadata(true);}if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}this.oHeaders["Content-Type"]="application/json";}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";this.oHeaders["Content-Type"]="application/atom+xml";}if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguage();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});o.M_EVENTS={RejectChange:"rejectChange",MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};o.prototype.attachBatchRequestFailed=function(D,F,L){this.attachEvent("batchRequestFailed",D,F,L);return this;};o.prototype.detachBatchRequestFailed=function(F,L){this.detachEvent("batchRequestFailed",F,L);return this;};o.prototype.fireBatchRequestFailed=function(A){this.fireEvent("batchRequestFailed",A);return this;};o.prototype.attachBatchRequestSent=function(D,F,L){this.attachEvent("batchRequestSent",D,F,L);return this;};o.prototype.detachBatchRequestSent=function(F,L){this.detachEvent("batchRequestSent",F,L);return this;};o.prototype.fireBatchRequestSent=function(A){this.fireEvent("batchRequestSent",A);return this;};o.prototype.attachBatchRequestCompleted=function(D,F,L){this.attachEvent("batchRequestCompleted",D,F,L);return this;};o.prototype.detachBatchRequestCompleted=function(F,L){this.detachEvent("batchRequestCompleted",F,L);return this;};o.prototype.fireBatchRequestCompleted=function(A){this.fireEvent("batchRequestCompleted",A);return this;};o.mServiceData={};o.prototype.fireRejectChange=function(A){this.fireEvent("rejectChange",A);return this;};o.prototype.attachRejectChange=function(D,F,L){this.attachEvent("rejectChange",D,F,L);return this;};o.prototype.detachRejectChange=function(F,L){this.detachEvent("rejectChange",F,L);return this;};o.prototype._initializeMetadata=function(D){var t=this;this.bUseBatch=this.bUseBatch||this.oMetadata.getUseBatch();var i=function(I,j){if(j){t.metadataLoadEvent=q.sap.delayedCall(0,t,i,[t.bLoadMetadataAsync]);}else{if(I){t.initialize();}t.fireMetadataLoaded({metadata:t.oMetadata});q.sap.log.debug(t+" - metadataloaded fired");}};if(this.bLoadMetadataAsync&&this.sAnnotationURI&&this.bLoadAnnotationsJoined){if(this.oAnnotations&&this.oAnnotations.bInitialized){i(true);}else{this.oAnnotations.attachEventOnce("loaded",function(){i(true);});}}else{i(this.bLoadMetadataAsync,D);}};o.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh();}};o.prototype.fireAnnotationsLoaded=function(A){this.fireEvent("annotationsLoaded",A);return this;};o.prototype.attachAnnotationsLoaded=function(D,F,L){this.attachEvent("annotationsLoaded",D,F,L);return this;};o.prototype.detachAnnotationsLoaded=function(F,L){this.detachEvent("annotationsLoaded",F,L);return this;};o.prototype.fireAnnotationsFailed=function(A){this.fireEvent("annotationsFailed",A);q.sap.log.debug(this+" - annotationsfailed fired");return this;};o.prototype.attachAnnotationsFailed=function(D,F,L){this.attachEvent("annotationsFailed",D,F,L);return this;};o.prototype.detachAnnotationsFailed=function(F,L){this.detachEvent("annotationsFailed",F,L);return this;};o.prototype.fireMetadataLoaded=function(A){this.fireEvent("metadataLoaded",A);return this;};o.prototype.attachMetadataLoaded=function(D,F,L){this.attachEvent("metadataLoaded",D,F,L);return this;};o.prototype.detachMetadataLoaded=function(F,L){this.detachEvent("metadataLoaded",F,L);return this;};o.prototype.fireMetadataFailed=function(A){this.fireEvent("metadataFailed",A);return this;};o.prototype.attachMetadataFailed=function(D,F,L){this.attachEvent("metadataFailed",D,F,L);return this;};o.prototype.detachMetadataFailed=function(F,L){this.detachEvent("metadataFailed",F,L);return this;};o.prototype._createEventInfo=function(r,R,p){var E={};E.url=r.requestUri;E.method=r.method;E.async=r.async;E.headers=r.headers;if(p){E.requests=[];for(var i=0;i<p.length;i++){var s={};if(q.isArray(p[i])){var t=p[i];for(var j=0;j<t.length;j++){var r=t[j].request;var I=p[i][j].response;s={};s.url=r.requestUri;s.method=r.method;s.headers=r.headers;if(I){s.response={};if(r._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}else{var r=p[i].request;var I=p[i].response;s.url=r.requestUri;s.method=r.method;s.headers=r.headers;if(I){s.response={};if(r._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}}if(R){E.response={};E.success=true;if(R.message){E.response.message=R.message;E.success=false;}if(R.response){R=R.response;}if(R&&R.statusCode!=undefined){E.response.headers=R.headers;E.response.statusCode=R.statusCode;E.response.statusText=R.statusText;E.response.responseText=R.body!==undefined?R.body:R.responseText;}}E.ID=r.requestID;return E;};o.prototype._createRequestID=function(){var r;r=q.sap.uid();return r;};o.prototype._createRequestUrl=function(p,i,u,j){var N,A=[],s="";N=this._normalizePath(p,i);if(!j){s=this.sServiceUrl+N;}else{s=N.substr(N.indexOf('/')+1);}if(this.aUrlParams){A=A.concat(this.aUrlParams);}if(u){A=A.concat(u);}if(A&&A.length>0){s+="?"+A.join("&");}return s;};o.prototype._importData=function(D,j){var t=this,L,K,r,E;if(D.results){L=[];q.each(D.results,function(i,p){var K=t._importData(p,j);if(K){L.push(K);}});return L;}else{K=this._getKey(D);if(!K){return K;}E=this.oData[K];if(!E){E=D;this.oData[K]=E;}q.each(D,function(N,p){if(p&&(p.__metadata&&p.__metadata.uri||p.results)&&!p.__deferred){r=t._importData(p,j);if(q.isArray(r)){E[N]={__list:r};}else{E[N]={__ref:r};}}else if(!p||!p.__deferred){E[N]=p;}});j[K]=true;return K;}};o.prototype._removeReferences=function(D){var t=this,L;if(D.results){L=[];q.each(D.results,function(i,j){L.push(t._removeReferences(j));});return L;}else{q.each(D,function(p,i){if(i){if(i["__ref"]||i["__list"]){delete D[p];}}});return D;}};o.prototype._restoreReferences=function(D){var t=this,L,r=[];if(D.results){L=[];q.each(D.results,function(i,j){L.push(t._restoreReferences(j));});return L;}else{q.each(D,function(p,i){if(i&&i["__ref"]){var s=t._getObject("/"+i["__ref"]);if(s){delete i["__ref"];D[p]=s;t._restoreReferences(s);}}else if(i&&i["__list"]){q.each(i["__list"],function(j,E){var s=t._getObject("/"+i["__list"][j]);if(s){r.push(s);t._restoreReferences(s);}});delete i["__list"];i.results=r;r=[];}});return D;}};o.prototype.removeData=function(){this.oData={};};o.prototype.initialize=function(){var i=this.aBindings.slice(0);q.each(i,function(I,j){j.initialize();});};o.prototype.refresh=function(F,r,s){if(typeof F==="string"){s=F;F=false;r=false;}if(r){this.removeData();}this._refresh(F,s);};o.prototype._refresh=function(F,s,i,E){var j=this.aBindings.slice(0);this.sRefreshBatchGroupId=s;q.each(j,function(I,p){p._refresh(F,i,E);});this.sRefreshBatchGroupId=undefined;};o.prototype.checkUpdate=function(F,A,j){if(A){if(!this.sUpdateTimer){this.sUpdateTimer=q.sap.delayedCall(0,this,function(){this.checkUpdate(F,false,j);});}return;}if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);this.sUpdateTimer=null;}var p=this.aBindings.slice(0);q.each(p,function(I,s){s.checkUpdate(F,j);});var r=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var i=0;i<r.length;i++){r[i]();}};o.prototype.bindProperty=function(p,i,P){var j=new g(this,p,i,P);return j;};o.prototype.bindList=function(p,i,s,F,P){var j=new e(this,p,i,s,F,P);return j;};o.prototype.bindTree=function(p,i,F,P,s){var j=new h(this,p,i,F,P,s);return j;};o.prototype.createBindingContext=function(p,i,P,j,r){var F=this.resolve(p,i);r=!!r;if(typeof i=="function"){j=i;i=null;}if(typeof P=="function"){j=P;P=null;}if(!F){if(j){j(null);}return null;}var D=this._getObject(p,i),K,N,s,t=this;if(!r){r=this._isReloadNeeded(F,D,P);}if(!r){K=this._getKey(D);N=this.getContext('/'+K);if(j){j(N);}return N;}if(j){var I=!q.sap.startsWith(p,"/");if(F){var u=[],v=this.createCustomParams(P);if(v){u.push(v);}if(P&&P.batchGroupId){s=P.batchGroupId;}var w=function(D){K=D?t._getKey(D):undefined;if(K&&i&&I){var y=i.getPath();y=y.substr(1);if(t.oData[y]){t.oData[y][p]={__ref:K};}}N=t.getContext('/'+K);j(N);};var x=function(E){if(E.statusCode=='404'&&i&&I){var y=i.getPath();y=y.substr(1);if(t.oData[y]){t.oData[y][p]={__ref:null};}}j(null);};this.read(F,{batchGroupId:s,urlParameters:u,success:w,error:x});}else{j(null);}}};o.prototype._isReloadNeeded=function(F,D,p){var N,j=[],s,S=[],i;if(!F){return false;}if(!D){return true;}if(p&&p["expand"]){N=p["expand"].replace(/\s/g,"");j=N.split(',');}if(j){for(i=0;i<j.length;i++){var r=j[i].indexOf("/");if(r!==-1){var t=j[i].slice(0,r);var u=j[i].slice(r+1);j[i]=[t,u];}}}for(i=0;i<j.length;i++){var v=j[i];if(q.isArray(v)){var w=D[v[0]];var x=v[1];if(!w||(w&&w.__deferred)){return true;}else{if(w){var P,y,R;if(w.__list&&w.__list.length>0){for(var z=0;z<w.__list.length;z++){P="/"+w.__list[z];y=this.getObject(P);R=this._isReloadNeeded(P,y,{expand:x});if(R){return true;}}}else if(w.__ref){P="/"+w.__ref;y=this.getObject(P);R=this._isReloadNeeded(P,y,{expand:x});if(R){return true;}}}}}else{if(D[v]===undefined||(D[v]&&D[v].__deferred)){return true;}}}if(p&&p["select"]){s=p["select"].replace(/\s/g,"");S=s.split(',');}for(i=0;i<S.length;i++){if(D[S[i]]===undefined){return true;}}if(S.length===0){var E=this.oMetadata._getEntityTypeByPath(F);if(!E){return false;}else{for(i=0;i<E.property.length;i++){if(D[E.property[i].name]===undefined){return true;}}}}return false;};o.prototype.createCustomParams=function(p){var i=[],j,s={expand:true,select:true};for(var N in p){if(N in s){i.push("$"+N+"="+q.sap.encodeURL(p[N]));}if(N==="custom"){j=p[N];for(N in j){if(N.indexOf("$")===0){q.sap.log.warning(this+" - Trying to set OData parameter '"+N+"' as custom query option!");}else{i.push(N+"="+q.sap.encodeURL(j[N]));}}}}return i.join("&");};o.prototype.bindContext=function(p,i,P){var j=new d(this,p,i,P);return j;};o.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s;};o.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};o.prototype._getKey=function(i){var K,u;if(i instanceof C){K=i.getPath().substr(1);}else if(i&&i.__metadata&&i.__metadata.uri){u=i.__metadata.uri;K=u.substr(u.lastIndexOf("/")+1);}return K;};o.prototype.getKey=function(i){return this._getKey(i);};o.prototype.createKey=function(s,K){var E=this.oMetadata._getEntityTypeByPath(s),j=s,t=this,N,p;j+="(";if(E.key.propertyRef.length===1){N=E.key.propertyRef[0].name;p=this.oMetadata._getPropertyMetadata(E,N);j+=a.formatValue(K[N],p.type);}else{q.each(E.key.propertyRef,function(i,P){if(i>0){j+=",";}N=P.name;p=t.oMetadata._getPropertyMetadata(E,N);j+=N;j+="=";j+=a.formatValue(K[N],p.type);});}j+=")";return j;};o.prototype.getProperty=function(p,i,I){var v=this._getObject(p,i);if(!I){return v;}if(!q.isPlainObject(v)){return v;}v=q.sap.extend(true,{},v);if(I===true){return this._restoreReferences(v);}else{return this._removeReferences(v);}};o.prototype._getObject=function(p,i){var N=this.isLegacySyntax()?this.oData:null,r=this.resolve(p,i),s,D,j,t,K,u;if(this.oMetadata&&this.oMetadata.isLoaded()&&r&&r.indexOf('/#')>-1){s=r.indexOf('/##');if(s>=0){u=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=r.substr(0,s);j=r.substr(s+3);t=u.getMetaContext(D);N=u.getProperty(j,t);}else{N=this.oMetadata._getAnnotation(r);}}else{if(i){K=i.getPath();K=K.substr(1);N=this.mChangedEntities[K]?this.mChangedEntities[K]:this.oData[K];}if(!p){return N;}var P=p.split("/"),I=0;if(!P[0]){I++;if(this.mChangedEntities[P[I]]){N=this.mChangedEntities;}else{N=this.oData;}}while(N&&P[I]){N=N[P[I]];if(N){if(N.__ref){N=this.oData[N.__ref];}else if(N.__list){N=N.__list;}else if(N.__deferred){N=undefined;}}I++;}}return N;};o.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}}};o.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"];};o.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken;}return t;};o.prototype.refreshSecurityToken=function(s,E){var t=this,u,T;u=this._createRequestUrl("/");var r=this._createRequest(u,"GET",this._getHeaders(),null,null,false);r.headers["x-csrf-token"]="Fetch";function _(D,R){if(R){T=t._getHeader("x-csrf-token",R.headers);if(T){t.oServiceData.securityToken=T;t.oHeaders["x-csrf-token"]=T;}else{t.resetSecurityToken();t.bTokenHandling=false;}}if(s){s(D,R);}}function i(j){t.resetSecurityToken();t.bTokenHandling=false;t._handleError(j);if(E){E(j);}}return this._request(r,_,i,undefined,undefined,this.getServiceMetadata());};o.prototype._submitRequest=function(r,s,E){var t=this,H;function _(D,R){if(s){s(D,R);}}function i(p){if(t.bTokenHandling&&p.response){var T=t._getHeader("x-csrf-token",p.response.headers);if(!r.bTokenReset&&p.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){t.resetSecurityToken();r.bTokenReset=true;j();return;}}if(E){E(p);}}function j(){if(t.bTokenHandling&&r.method!=="GET"){t.updateSecurityToken();if(t.bTokenHandling){r.headers["x-csrf-token"]=t.oServiceData.securityToken;}}H=t._getODataHandler(r.requestUri);return t._request(r,_,i,H,undefined,t.getServiceMetadata());}return j();};o.prototype._submitSingleRequest=function(r,s,E){var t=this,R,i={},G={},j={},p;var u=function(D,w){var S=function(D,w){if(s){s(D,w);}if(r.requestUri.indexOf("$count")===-1){t.checkUpdate(false,false,G);if(t._isRefreshNeeded(r,w)){t._refresh(false,undefined,i,j);}}t._updateChangedEntities(i);};t._processSuccess(r,w,S,G,i,j);};var v=function(w){if(w.message=="Request aborted"){t._processAborted(r,w,E);}else{t._processError(r,w,E);}};R=this._submitRequest(r,u,v);p=this._createEventInfo(r);this.fireRequestSent(p);return R;};o.prototype._submitBatchRequest=function(p,r,s,E){var t=this;var u=function(D,x){var y,z,A,F=D.__batchResponses,G,H={},I={},J={};if(F){var i,j;for(i=0;i<F.length;i++){y=F[i];if(q.isArray(r[i])){if(y.message){for(j=0;j<r[i].length;j++){z=r[i][j];if(z.request._aborted){t._processAborted(z.request,y,z.fnError);}else{t._processError(z.request,y,z.fnError);}z.response=y;}}else{A=y.__changeResponses;for(j=0;j<A.length;j++){var K=A[j];z=r[i][j];if(z.request._aborted){t._processAborted(z.request,K,z.fnError);}else if(K.message){t._processError(z.request,K,z.fnError);}else{t._processSuccess(z.request,K,z.fnSuccess,I,H,J);}z.response=K;}}}else{z=r[i];if(z.request._aborted){t._processAborted(z.request,y,z.fnError);}else if(y.message){t._processError(z.request,y,z.fnError);}else{t._processSuccess(z.request,y,z.fnSuccess,I,H,J);}z.response=y;}}t.checkUpdate(false,false,I);}if(s){s(D);}G=t._createEventInfo(p,x,r);t.fireBatchRequestCompleted(G);};var v=function(j){var x,A=R&&R.bAborted;q.each(r,function(i,y){if(q.isArray(y)){q.each(y,function(i,y){if(A){t._processAborted(y.request,j,y.fnError);}else{t._processError(y.request,j,y.fnError);}});}else{if(A){t._processAborted(y.request,j,y.fnError);}else{t._processError(y.request,j,y.fnError);}}});if(E){E(j);}x=t._createEventInfo(p,j,r);t.fireBatchRequestCompleted(x);if(!A){t.fireBatchRequestFailed(x);}};var w=function(T,p,j,r){var x;q.each(r,function(i,y){if(q.isArray(y)){q.each(y,function(i,y){x=t._createEventInfo(y.request,j);t["fireRequest"+T](x);});}else{x=t._createEventInfo(y.request,j);t["fireRequest"+T](x);}});x=t._createEventInfo(p,j,r);t["fireBatchRequest"+T](x);};var R=this._submitRequest(p,u,v);w("Sent",p,null,r);return R;};o.prototype._createBatchRequest=function(i){var u,r,j={},p={};p.__batchRequests=i;u=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){u+="?"+this.aUrlParams.join("&");}q.extend(j,this.mCustomHeaders,this.oHeaders);delete j["Content-Type"];r={headers:j,requestUri:u,method:"POST",data:p,user:this.sUser,password:this.sPassword,async:true};r.withCredentials=this.bWithCredentials;return r;};o.prototype._pushToRequestQueue=function(r,s,i,R,S,E){var j,p=r[s];if(!p){p={};p.requests=[];r[s]=p;}if(R.method!=="GET"){if(!p.changes){p.changes={};}if(R.key&&p.map&&R.key in p.map){p.map[R.key].method=R.method;if(R.method==="PUT"){delete p.map[R.key].headers["x-http-method"];}if(p.map[R.key]._aborted){delete p.map[R.key]._aborted;}p.map[R.key].data=R.data;}else{j=p.changes[i];if(!j){j=[];p.changes[i]=j;}R._changeSetId=i;j.push({request:R,fnSuccess:S,fnError:E,changeSetId:i});if(R.key){if(!p.map){p.map={};}p.map[R.key]=R;}}}else{p.requests.push({request:R,fnSuccess:S,fnError:E});}};o.prototype._collectChangedEntities=function(G,j,E){var t=this;if(G.changes){q.each(G.changes,function(s,p){for(var i=0;i<p.length;i++){var r=p[i].request,K=r.requestUri.split('?')[0];if(r.method==="POST"){var u=t.oMetadata._getEntityTypeByPath("/"+K);if(u){E[u.entityType]=true;}}else{j[K]=true;}}});}};o.prototype._processRequestQueue=function(r,s,S,E){var t=this,R=[];if(this.oRequestTimer&&r!==this.mDeferredRequests){q.sap.clearDelayedCall(this.oRequestTimer);this.oRequestTimer=undefined;}if(this.bUseBatch){if(t.bRefreshAfterChange){q.each(r,function(G,i){if(G===s||!s){var j={},p={};t._collectChangedEntities(i,j,p);t.bIncludeInCurrentBatch=true;t._refresh(false,G,j,p);t.bIncludeInCurrentBatch=false;}});}q.each(r,function(G,j){if(G===s||!s){var p=[],u=[],v,w;if(j.changes){q.each(j.changes,function(z,A){v={__changeRequests:[]};w=[];for(var i=0;i<A.length;i++){if(A[i].request._aborted){t._processAborted(A[i].request,null,A[i].fnError);}else{if(A[i].request.data&&A[i].request.data.__metadata){delete A[i].request.data.__metadata.created;}v.__changeRequests.push(A[i].request);w.push(A[i]);}}if(v.__changeRequests&&v.__changeRequests.length>0){p.push(v);u.push(w);}});}if(j.requests){var x=j.requests;for(var i=0;i<x.length;i++){if(x[i].request._aborted){t._processAborted(x[i].request,null,x[i].fnError);}else{p.push(x[i].request);u.push(x[i]);}}}if(p.length>0){var y=t._createBatchRequest(p,true);R.push(t._submitBatchRequest(y,u,S,E));}delete r[G];}});}else{q.each(r,function(G,j){if(G===s||!s){if(j.changes){q.each(j.changes,function(u,v){for(var i=0;i<v.length;i++){if(v[i].request._aborted){t._processAborted(v[i].request,null,v[i].fnError);}else{v[i].request._handle=t._submitSingleRequest(v[i].request,v[i].fnSuccess,v[i].fnError);R.push(v[i].request._handle);}}});}if(j.requests){var p=j.requests;for(var i=0;i<p.length;i++){if(p[i].request._aborted){t._processAborted(p[i].request,null,p[i].fnError);}else{p[i].request._handle=t._submitSingleRequest(p[i].request,p[i].fnSuccess,p[i].fnError);R.push(p[i].request._handle);}}}delete r[G];}});}return R.length==1?R[0]:R;};o.prototype._processSuccess=function(r,R,s,G,i,E){var j=R.data,p,u,P,t,v,L={},w={},x=this;p=!(R.statusCode===204||R.statusCode==='204');if(p&&!j&&R){this._parseResponse(R,r);q.sap.log.fatal(this+" - No data was retrieved by service: '"+R.requestUri+"'");x.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false;}if(j&&j.results&&!q.isArray(j.results)){j=j.results;}if(j&&(q.isArray(j)||typeof j=='object')){j=q.sap.extend(true,{},j);x._importData(j,L);}u=r.requestUri;P=u.replace(this.sServiceUrl,"");if(!q.sap.startsWith(P,'/')){P='/'+P;}P=this._normalizePath(P);if(!p){t=P.split("/");if(t[1]){w[t[1]]=true;var y={};y[t[1]]=true;this._updateChangedEntities(y);}if(r.method==="DELETE"){delete x.oData[t[1]];delete x.mContexts["/"+t[1]];}}if(p&&r.method==="POST"){v=this.oMetadata._getEntityTypeByPath(P);if(v){E[v.entityType]=true;}if(r.context){var K=this._getKey(j);delete this.mChangedEntities[r.context.sPath.substr(1)];delete this.oData[r.context.sPath.substr(1)];r.context.sPath='/'+K;}}this._parseResponse(R,r,L,w);q.extend(G,L);q.extend(i,w);this._updateETag(r,R);if(s){s(R.data,R);}var z=this._createEventInfo(r,R);this.fireRequestCompleted(z);return true;};o.prototype._processError=function(r,R,E){var i=this._handleError(R,r);if(E){E(i);}var j=this._createEventInfo(r,i);this.fireRequestCompleted(j);this.fireRequestFailed(j);};o.prototype._processAborted=function(r,R,E){var i={message:"Request aborted",statusCode:0,statusText:"abort",headers:{},responseText:""};if(E){E(i);}if(R){var j=this._createEventInfo(r,i);j.success=false;this.fireRequestCompleted(j);}};o.prototype._processChange=function(K,D,u){var p,E,s,i,j,H,r,t,v,w=this;E=this.oMetadata._getEntityTypeByPath(K);if(!u){u="MERGE";}if(D.__metadata&&D.__metadata.created){i="POST";K=D.__metadata.created.key;}else if(u==="MERGE"){i="MERGE";v=this.oData[K];}else{i="PUT";}p=q.sap.extend(true,{},D);if(p.__metadata){t=p.__metadata.type;s=p.__metadata.etag;delete p.__metadata;if(t||s){p.__metadata={};}if(t){p.__metadata.type=t;}if(s){p.__metadata.etag=s;}}if(E){var N=this.oMetadata._getNavigationPropertyNames(E);q.each(N,function(I,y){delete p[y];});}if(i==="MERGE"&&E&&v){q.each(p,function(y,z){if(y!=='__metadata'){if(q.sap.equal(v[y],z)){delete p[y];}}});var P="/"+K,x;q.each(p,function(y,z){if(y!=='__metadata'){x=w.getProperty(P+"/"+y+"/#@sap:unit");if(x){if(p[x]===undefined){p[x]=v[x];}}}});}p=this._removeReferences(p);j=this._createRequestUrl('/'+K);H=this._getHeaders();r=this._createRequest(j,i,H,p,s);if(this.bUseBatch){r.requestUri=r.requestUri.replace(this.sServiceUrl+'/','');}return r;};o.prototype._resolveGroup=function(K){var i,E,s,j;E=this.oMetadata._getEntityTypeByPath(K);if(this.mChangeBatchGroups[E.name]){i=this.mChangeBatchGroups[E.name];s=i.batchGroupId;j=i.single?q.sap.uid():i.changeSetId;}else if(this.mChangeBatchGroups['*']){i=this.mChangeBatchGroups['*'];s=i.batchGroupId;j=i.single?q.sap.uid():i.changeSetId;}return{batchGroupId:s,changeSetId:j};};o.prototype._updateETag=function(r,R){var u,E,s;u=r.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u);s=this._getHeader("etag",R.headers);if(E&&E.__metadata&&s){E.__metadata.etag=s;}};o.prototype._handleError=function(E,r){var p={},t;var s="The following problem occurred: "+E.message;p.message=E.message;if(E.response){this._parseResponse(E.response,r);if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()==="required"){this.resetSecurityToken();}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;p.statusCode=E.response.statusCode;p.statusText=E.response.statusText;p.headers=E.response.headers;p.responseText=E.response.body;}q.sap.log.fatal(s);return p;};o.prototype.getData=function(p,i,I){return this.getProperty(p,i,I);};o.prototype._getODataHandler=function(u){if(u.indexOf("$batch")>-1){return n.batchHandler;}else if(u.indexOf("$count")>-1){return undefined;}else if(this.bJSON){return n.jsonHandler;}else{return n.atomHandler;}};o.prototype.getETag=function(p,i,E){if(typeof p=="object"){E=p;p="";}return this._getETag(p,i,E);};o.prototype._getETag=function(p,i,D){if(!D||!D.__metadata){D=this._getObject(p,i);}if(D&&D.__metadata){return D.__metadata.etag;}return null;};o.prototype._createRequest=function(u,s,H,D,E,A){A=A!==false;if(E&&s!=="GET"){H["If-Match"]=E;}if(this.bJSON&&s!=="DELETE"&&this.sMaxDataServiceVersion==="2.0"){H["Content-Type"]="application/json";}if(u.indexOf("$count")>-1){H["Accept"]="text/plain, */*;q=0.5";}if(s==="MERGE"&&!this.bUseBatch){H["x-http-method"]="MERGE";s="POST";}var r={headers:H,requestUri:u,method:s,user:this.sUser,password:this.sPassword,async:A};if(D){r.data=D;}if(this.bWithCredentials){r.withCredentials=this.bWithCredentials;}r.requestID=this._createRequestID();return r;};o.prototype._isRefreshNeeded=function(r,R){var i=false;if(this.bRefreshAfterChange){i=true;}return i;};o.prototype._processRequest=function(p){var r,R,A=false,t=this;this.oMetadata.loaded().then(function(){R=p();if(!t.oRequestTimer){t.oRequestTimer=q.sap.delayedCall(0,t,t._processRequestQueue,[t.mRequests]);}if(A){r.abort();}});r={abort:function(){A=true;if(R){R._aborted=true;if(R._handle){R._handle.abort();}}}};return r;};o.prototype.update=function(p,D,P){var s,E,r,u,i,j,S,K,t,v,w,x,H,y,R,z={},A=this;if(P){v=P.batchGroupId;w=P.changeSetId;i=P.context;s=P.success;E=P.error;j=P.eTag;H=P.headers;x=P.urlParameters;if(P.merge!==undefined){y=P.merge?"MERGE":"PUT";}}t=a._createUrlParamsArray(x);H=this._getHeaders(H);y=y?y:this.sDefaultUpdateMethod;j=j||this._getETag(p,i,D);S=A._getObject(p,i);if(S){K=this._getKey(S);z[K]=true;}return this._processRequest(function(){u=A._createRequestUrl(p,i,t,A.bUseBatch);r=A._createRequest(u,y,H,D,j);r.keys=z;R=A.mRequests;if(v in A.mDeferredBatchGroups){R=A.mDeferredRequests;}A._pushToRequestQueue(R,v,w,r,s,E);return r;});};o.prototype.create=function(p,D,P){var r,u,E,i,s,j,t,R,H,v,w,x,y,z,A=this;if(P){i=P.context;t=P.urlParameters;s=P.success;j=P.error;x=P.batchGroupId;z=P.changeSetId;w=P.eTag;H=P.headers;}v=a._createUrlParamsArray(t);H=this._getHeaders(H);y="POST";return this._processRequest(function(){u=A._createRequestUrl(p,i,v,A.bUseBatch);r=A._createRequest(u,y,H,D,w);p=A._normalizePath(p,i);E=A.oMetadata._getEntityTypeByPath(p);r.entityTypes={};if(E){r.entityTypes[E.entityType]=true;}R=A.mRequests;if(x in A.mDeferredBatchGroups){R=A.mDeferredRequests;}A._pushToRequestQueue(R,x,z,r,s,j);return r;});};o.prototype.remove=function(p,P){var i,E,s,j,r,u,t,v,w,x,y,H,z,A,R,D=this;if(P){t=P.batchGroupId;v=P.changeSetId;i=P.context;s=P.success;j=P.error;w=P.eTag;H=P.headers;y=P.urlParameters;}z=a._createUrlParamsArray(y);H=this._getHeaders(H);A="DELETE";w=w||this._getETag(p,i);x=function(F,G){E=u.substr(u.lastIndexOf('/')+1);if(E.indexOf('?')!==-1){E=E.substr(0,E.indexOf('?'));}delete D.oData[E];delete D.mContexts["/"+E];if(s){s(F,G);}};return this._processRequest(function(){u=D._createRequestUrl(p,i,z,D.bUseBatch);r=D._createRequest(u,A,H,undefined,w);R=D.mRequests;if(t in D.mDeferredBatchGroups){R=D.mDeferredRequests;}D._pushToRequestQueue(R,t,v,r,x,j);return r;});};o.prototype.callFunction=function(F,p){var r,u,i,R,j,s,S,E,t="GET",s,I={},v,w,H,x=this;if(p){v=p.batchGroupId;w=p.changeSetId;t=p.method?p.method:t;j=p.urlParameters;S=p.success;E=p.error;H=p.headers;}if(!q.sap.startsWith(F,"/")){q.sap.log.fatal(this+" callFunction: path '"+F+"' must be absolute!");return;}H=this._getHeaders(H);return this._processRequest(function(){i=x.oMetadata._getFunctionImportMetadata(F,t);if(!i){return;}if(i.parameter!=null){q.each(j,function(P,y){var z=q.grep(i.parameter,function(A){return A.name===P&&(!A.mode||A.mode==="In");});if(z!=null&&z.length>0){I[P]=a.formatValue(y,z[0].type);}else{q.sap.log.warning(x+" - Parameter '"+P+"' is not defined for function call '"+F+"'!");}});}s=a._createUrlParamsArray(I);u=x._createRequestUrl(F,null,s,x.bUseBatch);r=x._createRequest(u,t,H,undefined);R=x.mRequests;if(v in x.mDeferredBatchGroups){R=x.mDeferredRequests;}x._pushToRequestQueue(R,v,w,r,S,E);return r;});};o.prototype.read=function(p,P){var r,u,i,j,s,E,F,S,t,v,w,N,x,H,y,z,A,R,D=this;if(P){i=P.context;j=P.urlParameters;s=P.success;E=P.error;F=P.filters;S=P.sorters;z=P.batchGroupId;H=P.headers;}if(this.sRefreshBatchGroupId){z=this.sRefreshBatchGroupId;}x=a._createUrlParamsArray(j);H=this._getHeaders(H);y="GET";A=this._getETag(p,i);function G(){v=a.createSortParams(S);if(v){x.push(v);}var T=p;var I=p.indexOf("$count");if(I!==-1){T=p.substring(0,I-1);}N=D._normalizePath(T,i);w=D.oMetadata._getEntityTypeByPath(N);t=a.createFilterParams(F,D.oMetadata,w);if(t){x.push(t);}u=D._createRequestUrl(p,i,x,D.bUseBatch);r=D._createRequest(u,y,H,null,A);R=D.mRequests;if(z in D.mDeferredBatchGroups){R=D.mDeferredRequests;}D._pushToRequestQueue(R,z,null,r,s,E);return r;}if(this.bUseBatch&&this.bIncludeInCurrentBatch){r=G();return{abort:function(){if(r){r._aborted=true;}}};}else{return this._processRequest(G);}};o.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};o.prototype.metadataLoaded=function(){return this.oMetadata.loaded();};o.prototype.getServiceAnnotations=function(){if(this.oAnnotations&&this.oAnnotations.getAnnotationsData){return this.oAnnotations.getAnnotationsData();}};o.prototype._getAnnotationParser=function(A){if(!this.oAnnotations){q.sap.require("sap.ui.model.odata.ODataAnnotations");this.oAnnotations=new O({annotationData:A,url:null,metadata:this.oMetadata,async:this.bLoadMetadataAsync});this.oAnnotations.attachFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachLoaded(this.onAnnotationsLoaded,this);}return this.oAnnotations;};o.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};o.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};o.prototype.addAnnotationUrl=function(u){var j=[].concat(u),p=[],A=[],E=[],t=this;q.each(j,function(i,s){var I=s.indexOf("$metadata");if(I>=0){if(I==0){s=t.sServiceUrl+'/'+s;}p.push(s);}else{A.push(s);}});return this.oMetadata._addUrl(p).then(function(P){return Promise.all(q.map(P,function(i){E=E.concat(i.entitySets);return t.addAnnotationXML(i["metadataString"]);}));}).then(function(){return t._getAnnotationParser().addUrl(A);}).then(function(P){return{annotations:P.annotations,entitySets:E};});};o.prototype.addAnnotationXML=function(x,s){return new Promise(function(r,i){this._getAnnotationParser().setXML(null,x,{success:r,error:i,fireEvents:!s});}.bind(this));};o.prototype.submitChanges=function(p){var r,s,G,S,E,R,v,A=false,j,t=this;if(p){s=p.batchGroupId;S=p.success;E=p.error;if(p.merge!==undefined){j=p.merge?"MERGE":"PUT";}}if(s&&!this.mDeferredBatchGroups[s]){q.sap.log.fatal(this+" submitChanges: \""+s+"\" is not a deferred batch group!");}this.oMetadata.loaded().then(function(){q.each(t.mChangedEntities,function(K,D){G=t._resolveGroup(K);if(G.batchGroupId===s||!s){r=t._processChange(K,D,j||t.sDefaultUpdateMethod);r.key=K;if(G.batchGroupId in t.mDeferredBatchGroups){t._pushToRequestQueue(t.mDeferredRequests,G.batchGroupId,G.changeSetId,r);}}});v=t._processRequestQueue(t.mDeferredRequests,s,S,E);if(A){R.abort();}});R={abort:function(){if(v){if(q.isArray(v)){q.each(v,function(i,R){R.abort();});}else{v.abort();}}else{A=true;}}};return R;};o.prototype._updateChangedEntities=function(i){var t=this;q.each(i,function(K,j){if(K in t.mChangedEntities){var p=t._getObject('/'+K);delete t.mChangedEntities[K];var E=t._getObject('/'+K);q.sap.extend(true,E,p);}});};o.prototype.resetChanges=function(K){var t=this;if(K){q.each(K,function(i,s){if(s in t.mChangedEntities){t.mChangeHandles[s].abort();delete t.mChangeHandles[s];delete t.mChangedEntities[s];}else{q.sap.log.warning(t+" - resetChanges: "+s+" is not changed nor a valid change key!");}});}else{q.each(this.mChangedEntities,function(s,i){t.mChangeHandles[s].abort();delete t.mChangeHandles[s];delete t.mChangedEntities[s];});}this.checkUpdate();};o.prototype.setProperty=function(p,v,j,A){var P,r,R,E={},D={},s=this.resolve(p,j),t,K,G,u,w={},x;if(!s){q.sap.log.warning(this+" - TwoWay binding: path '"+p+"' not resolvable!");return false;}t=s.split("/");P=t[t.length-1];D=this._getObject(s.substr(0,s.lastIndexOf("/")));if(!D){return false;}for(var i=t.length-1;i>=0;i--){x=t.join("/");E=this._getObject(x);if(E){K=this._getKey(E);if(K){break;}}t.splice(i,1);}if(!this.mChangedEntities[K]){E=q.sap.extend(true,{},E);}this.mChangedEntities[K]=E;var y=E;t=s.substr(x.length).split("/");for(var i=1;i<t.length-1;i++){if(!y.hasOwnProperty(t[i])){y[t[i]]={};}y=y[t[i]];}y[P]=v;G=this._resolveGroup(K);r=this.mRequests;if(G.batchGroupId in this.mDeferredBatchGroups){r=this.mDeferredRequests;R=this._processChange(K,{__metadata:E.__metadata});R.key=K;}else{R=this._processChange(K,E);}if(!this.mChangeHandles[K]){u={abort:function(){R._aborted=true;}};this.mChangeHandles[K]=u;}this._pushToRequestQueue(r,G.batchGroupId,G.changeSetId,R);if(this.bUseBatch){if(!this.oRequestTimer){this.oRequestTimer=q.sap.delayedCall(0,this,this._processRequestQueue,[this.mRequests]);}}else{this._processRequestQueue(this.mRequests);}w[K]=true;this.checkUpdate(false,A,w);return true;};o.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;default:return false;}return false;};o.prototype.setHeaders=function(H){var i={},t=this;this.mCustomHeaders={};if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{i[s]=j;}});this.mCustomHeaders=i;}};o.prototype._getHeaders=function(H){var i={},t=this;if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{i[s]=j;}});}return q.extend({},this.mCustomHeaders,i,this.oHeaders);};o.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders);};o.prototype._getHeader=function(H,i){var s;for(s in i){if(s.toLowerCase()===H.toLowerCase()){return i[s];}}return null;};o.prototype.hasPendingChanges=function(){return!q.isEmptyObject(this.mChangedEntities);};o.prototype.getPendingChanges=function(){return q.sap.extend(true,{},this.mChangedEntities);};o.prototype.updateBindings=function(F){this.checkUpdate(F);};o.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t;};o.prototype.setUseBatch=function(u){this.bUseBatch=u;};o.prototype.formatValue=function(v,t){return a.formatValue(v,t);};o.prototype.deleteCreatedEntry=function(i){if(i){var p=i.getPath();delete this.mContexts[p];if(q.sap.startsWith(p,"/")){p=p.substr(1);}this.mChangeHandles[p].abort();delete this.mChangeHandles[p];delete this.mChangedEntities[p];delete this.oData[p];}};o.prototype.createEntry=function(p,P){var s,E,r,u,j,t,K,v,w,x,R,y,H,z,A,D={},F,G="POST",I=this;if(P){A=P.properties;w=P.batchGroupId;x=P.changeSetId;t=P.context;s=P.success;E=P.error;F=P.created;j=P.eTag;H=P.headers;y=P.urlParameters;}w=w?w:this.sDefaultChangeBatchGroup;v=a._createUrlParamsArray(y);H=this._getHeaders(H);function J(){var L;if(!q.sap.startsWith(p,"/")){p="/"+p;}var N=I.oMetadata._getEntityTypeByPath(p);if(!N){return undefined;}if(typeof A==="object"&&!q.isArray(A)){D=A;}else{for(var i=0;i<N.property.length;i++){var Q=N.property[i];var T=Q.type.split('.');var S=q.inArray(Q.name,A)>-1;if(!A||S){D[Q.name]=I._createPropertyValue(T);if(S){A.splice(A.indexOf(Q.name),1);}}}if(A){}}K=p.substring(1)+"('"+q.sap.uid()+"')";I.oData[K]=D;D.__metadata={type:""+N.entityType,uri:I.sServiceUrl+'/'+K,created:{key:p.substring(1)}};u=I._createRequestUrl(p,t,v,I.bUseBatch);r=I._createRequest(u,G,H,D,undefined,j);L=I.getContext("/"+K);r.context=L;r.key=K;z=I.mRequests;if(w in I.mDeferredBatchGroups){z=I.mDeferredRequests;}I._pushToRequestQueue(z,w,x,r,s,E,P);R={abort:function(){r._aborted=true;}};I.mChangeHandles[K]=R;if(I.bUseBatch){if(!I.oRequestTimer){I.oRequestTimer=q.sap.delayedCall(0,I,I._processRequestQueue,[I.mRequests]);}}else{I._processRequestQueue(I.mRequests);}return L;}if(F){this.oMetadata.loaded().then(function(){F(J());});}else if(this.oMetadata.isLoaded()){return J();}else{q.sap.log.error("Tried to use createEntry without created-callback, before metadata is available!");}};o.prototype._createPropertyValue=function(t){var N=t[0];var T=t[1];if(N.toUpperCase()!=='EDM'){var j={};var p=this.oMetadata._getObjectMetadata("complexType",T,N);for(var i=0;i<p.property.length;i++){var P=p.property[i];t=P.type.split('.');j[P.name]=this._createPropertyValue(t);}return j;}else{return this._getDefaultPropertyValue(T,N);}};o.prototype._getDefaultPropertyValue=function(t,N){return undefined;};o.prototype._normalizePath=function(p,i){if(p&&p.indexOf('?')!==-1){p=p.substr(0,p.indexOf('?'));}if(!i&&!q.sap.startsWith(p,"/")){q.sap.log.fatal(this+" path "+p+" must be absolute if no Context is set");}return this.resolve(p,i);};o.prototype.setRefreshAfterChange=function(r){this.bRefreshAfterChange=r;};o.prototype.isList=function(p,i){p=this.resolve(p,i);return p&&p.substr(p.lastIndexOf("/")).indexOf("(")===-1;};o.prototype._request=function(r,s,E,H,i,j){var R;if(this.bDestroyed){return{abort:function(){}};}var t=this;function w(p){return function(){var I=q.inArray(R,t.aPendingRequestHandles);if(I>-1){t.aPendingRequestHandles.splice(I,1);}if(!(R&&R.bSuppressErrorHandlerCall)){p.apply(this,arguments);}};}R=n.request(r,w(s||n.defaultSuccess),w(E||n.defaultError),H,i,j);if(r.async!==false){this.aPendingRequestHandles.push(R);}return R;};o.prototype.destroy=function(){this.bDestroyed=true;M.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var r=this.aPendingRequestHandles[i];if(r&&r.abort){r.bSuppressErrorHandlerCall=true;r.abort();}}delete this.aPendingRequestHandles;}if(this.oMetadataLoadEvent){q.sap.clearDelayedCall(this.oMetadataLoadEvent);}if(this.oMetadataFailedEvent){q.sap.clearDelayedCall(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachLoaded(this.onMetadataLoaded);this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oServiceData.oMetadata;}delete this.oMetadata;}if(this.oAnnotations){this.oAnnotations.detachLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;}};o.prototype.setDeferredBatchGroups=function(G){var t=this;this.mDeferredBatchGroups={};q.each(G,function(i,s){t.mDeferredBatchGroups[s]=s;});};o.prototype.getDeferredBatchGroups=function(){var G=[],i=0;q.each(this.mDeferredBatchGroups,function(K,s){G[i]=s;i++;});return G;};o.prototype.setChangeBatchGroups=function(G){this.mChangeBatchGroups=G;};o.prototype.getChangeBatchGroups=function(){return this.mChangeBatchGroups;};o.prototype.setMessageParser=function(p){if(!(p instanceof l)){q.sap.log.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return;}p.setProcessor(this);this.oMessageParser=p;return this;};o.prototype._parseResponse=function(r,R,G,i){try{if(!this.oMessageParser){this.oMessageParser=new m(this.sServiceUrl,this.oMetadata);this.oMessageParser.setProcessor(this);}return this.oMessageParser.parse(r,R,G,i);}catch(j){q.sap.log.error("Error parsing OData messages: "+j);}};o.prototype.callAfterUpdate=function(F){this.aCallAfterUpdate.push(F);};o.prototype.getMetaModel=function(){var t=this;if(!this.oMetaModel){this.oMetaModel=new k(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){t.bMetaModelLoaded=true;t.checkUpdate();});}return this.oMetaModel;};return o;});
