/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,M,b,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",properties:{intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},months:{type:"int",group:"Misc",defaultValue:1},firstDayOfWeek:{type:"int",group:"Misc",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},cancel:{}}}});(function(){c.prototype.init=function(){this._iMode=0;this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(U.UTC(1,0,1));this._oMinDate.setUTCFullYear(1);this._oMaxDate=new U(U.UTC(9999,11,31));var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",r,this);i.attachEvent("pressButton2",s,this);this.setAggregation("header",i);var E=this._createMonth(this.getId()+"--Month0");E.attachEvent("focus",v,this);E.attachEvent("select",u,this);E.attachEvent("_renderMonth",t,this);E.attachEvent("_bindMousemove",w,this);E.attachEvent("_unbindMousemove",x,this);E._bNoThemeChange=true;this.addAggregation("month",E);var F=new b(this.getId()+"--MP");F.attachEvent("select",y,this);F._bNoThemeChange=true;this.setAggregation("monthPicker",F);var G=new Y(this.getId()+"--YP");G.attachEvent("select",z,this);this.setAggregation("yearPicker",G);};c.prototype.exit=function(){if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}};c.prototype._createMonth=function(i){var E=new M(i);return E;};c.prototype.onBeforeRendering=function(){var E=this.getAggregation("month");var F;var G=E[0].getDate();var I=this._getFocusedDate();if(E.length>1&&G){F=new U(G.getTime());}else if(E.length>1){F=B.call(this,this._getFocusedDate());}else{F=I;}this._updateHeader(F);for(var i=0;i<E.length;i++){var J=E[i];G=new U(F.getTime());if(i>0){G.setUTCDate(1);G.setUTCMonth(F.getUTCMonth()+i);}if(I.getUTCFullYear()==G.getUTCFullYear()&&I.getUTCMonth()==G.getUTCMonth()){J.setDate(a._createLocalDate(I));}else{J.displayDate(a._createLocalDate(G));}}};c.prototype.onAfterRendering=function(){var i=this;j(i);};c.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){var i=this;this._sInvalidateMonth=q.sap.delayedCall(0,i,A,[i]);}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};c.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){var i=this;d(i);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(i.getTime());};c.prototype.focusDate=function(i){var E=this;o(E,i,false);return this;};c.prototype.displayDate=function(i){var E=this;o(E,i,true);return this;};c.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};c.prototype.setMonths=function(E){this.setProperty("months",E,false);var F=this;E=p(F);var G=this.getAggregation("month");var i=0;var I;if(G.length<E){for(i=G.length;i<E;i++){I=this._createMonth(this.getId()+"--Month"+i);I.attachEvent("focus",v,this);I.attachEvent("select",u,this);I.attachEvent("_renderMonth",t,this);I.attachEvent("_bindMousemove",w,this);I.attachEvent("_unbindMousemove",x,this);I._bNoThemeChange=true;this.addAggregation("month",I);}}else if(G.length>E){for(i=G.length;i>E;i--){I=this.removeAggregation("month",i-1);I.destroy();}}if(E>1&&G[0].getDate()){G[0].setProperty("date",null,true);}return this;};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var E=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(E);}return this._oLocaleData;};c.prototype._getShowMonthHeader=function(){var i=this;var E=p(i);if(E>2){return true;}else{return false;}};c.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};c.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};c.prototype.onsapescape=function(E){var i=this;switch(this._iMode){case 0:this.fireCancel();break;case 1:f(i);break;case 2:h(i);break;}};c.prototype.onsapshow=function(E){if(this._bPoupupMode){var i=this;switch(this._iMode){case 1:f(i);break;case 2:h(i);break;}this.fireCancel();E.preventDefault();}};c.prototype.onsaphide=c.prototype.onsapshow;c.prototype.onsaptabnext=function(E){var F=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(F.getDomRef("B1"));if(!this._bPoupupMode){var G=this.getAggregation("month");var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");for(var i=0;i<G.length;i++){var K=G[i];q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}else if(E.target.id==F.getId()+"-B1"){q.sap.focus(F.getDomRef("B2"));E.preventDefault();}};c.prototype.onsaptabprevious=function(E){var F=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(F.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==F.getId()+"-B1"){var G=this.getAggregation("month");var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");var K;switch(this._iMode){case 0:K=this._getFocusedDate();for(var i=0;i<G.length;i++){var N=G[i];var O=a._createUniversalUTCDate(N.getDate());if(K.getTime()==O.getTime()){N._oItemNavigation.focusItem(N._oItemNavigation.getFocusedIndex());}else{q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());break;case 2:J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}else if(E.target.id==F.getId()+"-B2"){q.sap.focus(F.getDomRef("B1"));E.preventDefault();}};c.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var F=this.getAggregation("header");var G=this.getAggregation("month");var I=this.getAggregation("monthPicker");var J=this.getAggregation("yearPicker");q.sap.focus(F.getDomRef("B2"));if(!this._bPoupupMode){for(var i=0;i<G.length;i++){var K=G[i];q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(J.getDomRef()){q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var F=this.getAggregation("month");var G=this.getAggregation("monthPicker");var I=this.getAggregation("yearPicker");switch(this._iMode){case 0:for(var i=0;i<F.length;i++){var J=F[i];q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};c.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}var E=this;this._bNamesLengthChecked=undefined;var F=this.getAggregation("monthPicker");e(E,true);F._bNoThemeChange=false;F.onThemeChanged(arguments);F._bNoThemeChange=true;this._bLongMonth=F._bLongMonth;f(E,true);var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];I._bNoThemeChange=false;I.onThemeChanged(arguments);I._bNoThemeChange=true;}var J=this._getFocusedDate();n(E,J);j(E);};c.prototype._updateHeader=function(i){var E=this;n(E,i);k(E,i,true);};c.prototype._handlePrevious=function(E){var i=this;var F=this._getFocusedDate();var G=this.getAggregation("header");var I=this.getAggregation("yearPicker");var J=p(i);var K;var N=false;switch(this._iMode){case 0:if(J>1){K=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate());K.setUTCDate(1);this._setFocusedDate(K);F=this._getFocusedDate();}else{F.setUTCDate(1);}F.setUTCDate(F.getUTCDate()-1);_(i,N,true);break;case 1:F.setUTCFullYear(F.getUTCFullYear()-1);G.setTextButton2((F.getUTCFullYear()).toString());k(i,F);break;case 2:I.previousPage();break;}};c.prototype._handleNext=function(E){var i=this;var F=this._getFocusedDate();var G=this.getAggregation("header");var I=this.getAggregation("yearPicker");var J=p(i);var K;switch(this._iMode){case 0:if(J>1){K=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate());this._setFocusedDate(K);F=this._getFocusedDate();}F.setUTCMonth(F.getUTCMonth()+J,1);_(i);break;case 1:F.setUTCFullYear(F.getUTCFullYear()+1);G.setTextButton2((F.getUTCFullYear()).toString());k(i,F);break;case 2:I.nextPage();break;}};c.prototype._getDisplayedMonths=function(E){var F=this;var G=[];var I=E.getUTCMonth();var J=p(F);if(J>1){for(var i=0;i<J;i++){G.push((I+i)%12);}}else{G.push(I);}return G;};function _(T,N,I){var E=T._getFocusedDate();var F=T.getAggregation("month");var G=false;var J;var K;var O;var i=0;for(i=0;i<F.length;i++){J=F[i];if(J.checkDateFocusable(a._createLocalDate(E))){G=true;}if(G||F.length==1){if(!N){J.setDate(a._createLocalDate(E));}else{J.displayDate(a._createLocalDate(E));}break;}}if(!G){O=new U(E.getTime());if(F.length>1){O=B.call(T,O);for(i=0;i<F.length;i++){J=F[i];K=new U(O.getTime());K.setUTCMonth(O.getUTCMonth()+i);if(!N&&K.getUTCFullYear()==E.getUTCFullYear()&&K.getUTCMonth()==E.getUTCMonth()){J.setDate(a._createLocalDate(E));}else{J.displayDate(a._createLocalDate(K));}}}T._updateHeader(O);}}function d(T){var S=T.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){T._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate());}else{var N=new Date();T._oFocusedDate=a._createUniversalUTCDate(N);}}function e(T,N){if(T._iMode==2){h(T,true);}var E=T._getFocusedDate();var F=T.getAggregation("monthPicker");if(F.getDomRef()){F.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=T.$("content");R.renderControl(F);R.flush($[0],false,true);R.destroy();}T.$("contentOver").css("display","");if(!N){F.setMonth(E.getUTCMonth());if(T._iMode==0){var G=T.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}T._iMode=1;k(T,E,false);}function f(T,N){T._iMode=0;var E=T.getAggregation("monthPicker");E.$().css("display","none");T.$("contentOver").css("display","none");if(!N){_(T);if(T.getMonths()>1){var F=T.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}}function g(T){if(T._iMode==1){f(T,true);}var E=T._getFocusedDate();var F=E.getUTCFullYear();var G=T._oMaxDate.getUTCFullYear();var I=T._oMinDate.getUTCFullYear();if(G-I<=20){return;}var J=T.getAggregation("header");if(F>(G-10)){F=G-9;J.setEnabledNext(false);}else{J.setEnabledNext(true);}if(F<(I+9)){F=I+10;J.setEnabledPrevious(false);}else{J.setEnabledPrevious(true);}var K=T.getAggregation("yearPicker");if(K.getDomRef()){K.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=T.$("content");R.renderControl(K);R.flush($[0],false,true);R.destroy();}T.$("contentOver").css("display","");K.setYear(F);if(p(T)==1){var N=T.getAggregation("month")[0];var O=N.$("days").find(".sapUiCalItem");if(O.length==28){K.$().addClass("sapUiCalYearNoTop");}else{K.$().removeClass("sapUiCalYearNoTop");}}if(T._iMode==0){var P=T.getAggregation("month");for(var i=0;i<P.length;i++){var N=P[i];q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}T._iMode=2;}function h(T,N){T._iMode=0;var E=T.getAggregation("yearPicker");E.$().css("display","none");T.$("contentOver").css("display","none");if(!N){_(T);if(T.getMonths()>1){var F=T.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}}function j(T){if(!T._bNamesLengthChecked){e(T,true);f(T,true);var i=T.getAggregation("monthPicker");T._bLongMonth=i._bLongMonth;T._bNamesLengthChecked=true;if(!T._bLongMonth){var E=T._getFocusedDate();n(T,E);}}else if(T.getMonths()>1){m(T,T._getFocusedDate(),true);}}function k(T,i,E){var F=i.getUTCFullYear();var G=T._oMaxDate.getUTCFullYear();var I=T._oMinDate.getUTCFullYear();var J=i.getUTCMonth();var K=T._oMaxDate.getUTCMonth();var N=T._oMinDate.getUTCMonth();var O=T.getAggregation("header");if(F>G||(F==G&&(!E||J>=K))){O.setEnabledNext(false);}else{O.setEnabledNext(true);}if(F<I||(F==I&&(!E||J<=N))){O.setEnabledPrevious(false);}else{O.setEnabledPrevious(true);}}function m(T,i,O){var F;var E=false;if(i.getTime()<T._oMinDate.getTime()){F=T._oMinDate;E=true;}else if(i.getTime()>T._oMaxDate.getTime()){F=T._oMaxDate;E=true;}else{F=i;}if(T._focusDateExtend){T._focusDateExtend(i,O);}var I=F.getTime()<T._getFocusedDate().getTime();T._setFocusedDate(F);if(E||O){_(T,false,I);}}function n(T,i){var E=T._getLocaleData();var F=[];var G=[];var I;var S=false;if(T._bLongMonth||!T._bNamesLengthChecked){F=E.getMonthsStandAlone("wide");}else{S=true;F=E.getMonthsStandAlone("abbreviated");G=E.getMonthsStandAlone("wide");}var J=T._getDisplayedMonths(i);var K;if(J.length>1){var P=E.getIntervalPattern();K=P.replace(/\{0\}/,F[J[0]]).replace(/\{1\}/,F[J[J.length-1]]);if(S){I=P.replace(/\{0\}/,G[J[0]]).replace(/\{1\}/,G[J[J.length-1]]);}}else{K=F[J[0]];if(S){I=G[F[J[0]]];}}var N=T.getAggregation("header");N.setTextButton1(K);if(S){N.setAriaLabelButton1(I);}N.setTextButton2((i.getUTCFullYear()).toString());}function o(T,i,N){if(i&&(!T._oFocusedDate||T._oFocusedDate.getTime()!=i.getTime())){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+T);}i=a._createUniversalUTCDate(i);var E=i.getUTCFullYear();if(E<1||E>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+T);}T._setFocusedDate(i);if(T.getDomRef()&&T._iMode==0){_(T,N);}}}function p(T){if(sap.ui.Device.system.phone){return 1;}else{return T.getMonths();}}function r(E){var i=this;if(this._iMode!=1){e(i);}else{f(i);}}function s(E){var i=this;if(this._iMode!=2){g(i);}else{h(i);}}function t(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function u(E){var F=this;if(p(F)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];if(I.getId()!=E.oSource.getId()){I._updateSelection();}}}this.fireSelect();}function v(E){var i=a._createUniversalUTCDate(E.getParameter("date"));var O=E.getParameter("otherMonth");var R=E.getParameter("restoreOldDate");var F=this;if(R){if(!q.sap.equal(this._getFocusedDate(),i)){_(F,false);}}else{m(F,i,O);}}function w(E){var F=this;if(p(F)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];if(I.getId()!=E.oSource.getId()){I._bindMousemove();}}}}function x(E){var F=this;if(p(F)>1){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];if(I.getId()!=E.oSource.getId()){I._unbindMousemove();}}}}function y(E){var F=new U(this._getFocusedDate().getTime());var i=this.getAggregation("monthPicker");var G=i.getMonth();var I=this;F.setUTCMonth(G);if(G!=F.getUTCMonth()){F.setUTCDate(0);}m(I,F,true);f(I);}function z(E){var F=new U(this._getFocusedDate().getTime());var i=this.getAggregation("yearPicker");var G=i.getYear();var I=this;F.setUTCFullYear(G);m(I,F,true);h(I);}function A(T){T._sInvalidateMonth=undefined;var E=T.getAggregation("month");for(var i=0;i<E.length;i++){var F=E[i];F._bDateRangeChanged=true;F._bInvalidateSync=true;if(E.length>1){F._bNoFocus=true;}F.invalidate();F._bInvalidateSync=undefined;}if(E.length>1){m(T,T._getFocusedDate(),true);}T._bDateRangeChanged=undefined;}function B(i){var F=new U(i.getTime());F.setUTCDate(1);var E=this;var G=p(E);if(G<=12){var I=i.getUTCMonth();I=I-I%G;if(12%G>0&&I+G>11){I=12-G;}F.setUTCMonth(I);}return F;}}());return c;},true);
