/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library'],function(q,C,L,I,D,a,U,l){"use strict";var M=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Misc"},intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},showHeader:{type:"boolean",group:"Misc",defaultValue:false},firstDayOfWeek:{type:"int",group:"Misc",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}}}}});(function(){M.prototype.init=function(){this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"});this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._iColumns=7;};M.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}};M.prototype.onAfterRendering=function(){var t=this;_(t);n(t);};M.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){var t=this;if(this._bMouseMove){this._unbindMousemove(true);h(t,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;m(t);}if(this._bMousedownChange){this._bMousedownChange=false;m(t);}}};M.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateMonth){var t=this;if(this._bInvalidateSync){o(t);}else{this._sInvalidateMonth=q.sap.delayedCall(0,t,o,[t]);}}};M.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var r=this.removeAllAggregation("selectedDates");return r;};M.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};M.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var r=this.removeAllAggregation("specialDates");return r;};M.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};M.prototype.setDate=function(i){var t=this;e(t,i,false);return this;};M.prototype._setDate=function(i){var p=a._createLocalDate(i);this.setProperty("date",p,true);this._oUTCDate=i;};M.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date());}return this._oUTCDate;};M.prototype.displayDate=function(i){var t=this;e(t,i,true);return this;};M.prototype._getLocale=function(){var p=this.getParent();if(p&&p.getLocale){return p.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};M.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var i=new sap.ui.core.Locale(s);this._oLocaleData=L.getInstance(i);}return this._oLocaleData;};M.prototype._getFormatLong=function(){var s=this._getLocale();if(this._oFormatLong.oLocale.toString()!=s){var i=new sap.ui.core.Locale(s);this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long"},i);}return this._oFormatLong;};M.prototype.getIntervalSelection=function(){var p=this.getParent();if(p&&p.getIntervalSelection){return p.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};M.prototype.getSingleSelection=function(){var p=this.getParent();if(p&&p.getSingleSelection){return p.getSingleSelection();}else{return this.getProperty("singleSelection");}};M.prototype.getSelectedDates=function(){var p=this.getParent();if(p&&p.getSelectedDates){return p.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};M.prototype.getSpecialDates=function(){var p=this.getParent();if(p&&p.getSpecialDates){return p.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};M.prototype._getShowHeader=function(){var p=this.getParent();if(p&&p._getShowMonthHeader){return p._getShowMonthHeader();}else{return this.getProperty("showHeader");}};M.prototype.getAriaLabelledBy=function(){var p=this.getParent();if(p&&p.getAriaLabelledBy){return p.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};M.prototype._getFirstDayOfWeek=function(){var p=this.getParent();var F=0;if(p&&p.getFirstDayOfWeek){F=p.getFirstDayOfWeek();}else{F=this.getProperty("firstDayOfWeek");}if(F<0||F>6){var i=this._getLocaleData();F=i.getFirstDayOfWeek();}return F;};M.prototype._getNonWorkingDays=function(){var p=this.getParent();var N;if(p&&p.getNonWorkingDays){N=p.getNonWorkingDays();}else{N=this.getProperty("nonWorkingDays");}if(N&&!q.isArray(N)){N=[];}return N;};M.prototype._checkDateSelected=function(p){if(!(p instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var s=0;var S=this.getSelectedDates();var t=p.getTime();for(var i=0;i<S.length;i++){var r=S[i];var u=r.getStartDate();var v=0;if(u){u=a._createUniversalUTCDate(u);v=u.getTime();}var E=r.getEndDate();var w=0;if(E){E=a._createUniversalUTCDate(E);w=E.getTime();}if(t==v&&!E){s=1;break;}else if(t==v&&E){s=2;if(E&&t==w){s=5;}break;}else if(E&&t==w){s=3;break;}else if(E&&t>v&&t<w){s=4;break;}if(this.getSingleSelection()){break;}}return s;};M.prototype._getDateType=function(p){if(!(p instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var t;var s=this.getSpecialDates();var T=p.getTime();for(var i=0;i<s.length;i++){var r=s[i];var S=r.getStartDate();var u=0;if(S){S=a._createUniversalUTCDate(S);u=S.getTime();}var E=r.getEndDate();var v=0;if(E){E=a._createUniversalUTCDate(E);v=E.getTime();}if((T==u&&!E)||(T>=u&&T<=v)){t={type:r.getType(),tooltip:r.getTooltip_AsString()};break;}}return t;};M.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var t=q(E.target);if(t.hasClass("sapUiCalItemText")){t=t.parent();}if(this._sLastTargetId&&this._sLastTargetId==t.attr("id")){return;}this._sLastTargetId=t.attr("id");var i=this;if(t.hasClass("sapUiCalItem")){var O=this._getDate();if(!q.sap.containsOrEquals(this.getDomRef(),E.target)){var s=this.getSelectedDates();if(s.length>0&&this.getSingleSelection()){var S=s[0].getStartDate();if(S){S=a._createUniversalUTCDate(S);}var p=new U(this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true).getTime());if(p.getTime()>=S.getTime()){j(i,S,p);}else{j(i,p,S);}}}else{var F=new U(this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),true).getTime());if(F.getTime()!=O.getTime()){if(t.hasClass("sapUiCalItemOtherMonth")){this.fireFocus({date:a._createLocalDate(F),otherMonth:true});}else{this._setDate(F);h(i,F,true);this._bMoveChange=true;}}}}};M.prototype.onmouseup=function(E){var t=this;if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var p=this._oItemNavigation.getItemDomRefs();for(var i=0;i<p.length;i++){var $=q(p[i]);if(!$.hasClass("sapUiCalItemOtherMonth")){if($.attr("data-sap-day")==this._oFormatYyyymmdd.format(F,true)){$.focus();break;}}}if(this._bMoveChange){var T=q(E.target);if(T.hasClass("sapUiCalItemNum")){T=T.parent();}if(T.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyymmdd.parse(T.attr("data-sap-day"),true).getTime());}h(t,F);this._bMoveChange=false;this._bMousedownChange=false;m(t);}}if(this._bMousedownChange){this._bMousedownChange=false;m(t);}};M.prototype.onsapselect=function(E){var t=this;h(t,t._getDate());m(t);E.stopPropagation();E.preventDefault();};M.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};M.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var y=F.getUTCFullYear();if(E.metaKey||E.ctrlKey){F.setUTCFullYear(y-10);}else{F.setUTCFullYear(y-1);}this.fireFocus({date:a._createLocalDate(F),otherMonth:true});E.preventDefault();};M.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var y=F.getUTCFullYear();if(E.metaKey||E.ctrlKey){F.setUTCFullYear(y+10);}else{F.setUTCFullYear(y+1);}this.fireFocus({date:a._createLocalDate(F),otherMonth:true});E.preventDefault();};M.prototype._updateSelection=function(){var s=this.getSelectedDates();if(s.length>0&&this.getSingleSelection()){var t=this;var S=s[0].getStartDate();if(S){S=a._createUniversalUTCDate(S);}var E=s[0].getEndDate();if(E){E=a._createUniversalUTCDate(E);}j(t,S,E);}};M.prototype._bindMousemove=function(F){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};M.prototype._unbindMousemove=function(F){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(F){this.fireEvent("_unbindMousemove");}};M.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var w=this.$().find(".sapUiCalWH");var p=this._getLocaleData();var s=this._getFirstWeekDay();var r=p.getDaysStandAlone("abbreviated");for(var i=0;i<w.length;i++){var W=w[i];q(W).text(r[(i+s)%7]);}var t=this;n(t);};M.prototype._handleBorderReached=function(i){var E=i.getParameter("event");var p=0;var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_DOWN){F.setUTCDate(F.getUTCDate()+7);}else{F.setUTCDate(F.getUTCDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_UP){F.setUTCDate(F.getUTCDate()-7);}else{F.setUTCDate(F.getUTCDate()-1);}break;case"sappagedown":p=F.getUTCMonth()+1;F.setUTCMonth(p);if(p%12!=F.getUTCMonth()){while(p!=F.getUTCMonth()){F.setUTCDate(F.getUTCDate()-1);}}break;case"sappageup":p=F.getUTCMonth()-1;F.setUTCMonth(p);if(p<0){p=11;}if(p!=F.getUTCMonth()){while(p!=F.getUTCMonth()){F.setUTCDate(F.getUTCDate()-1);}}break;default:break;}this.fireFocus({date:a._createLocalDate(F),otherMonth:true});}};M.prototype.checkDateFocusable=function(i){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var p=this._getDate();var u=a._createUniversalUTCDate(i);if(u.getUTCFullYear()==p.getUTCFullYear()&&u.getUTCMonth()==p.getUTCMonth()){return true;}else{return false;}};M.prototype._renderHeader=function(){if(this._getShowHeader()){var i=this._getDate();var p=this._getLocaleData();var r=p.getMonthsStandAlone("wide");this.$("Head").text(r[i.getUTCMonth()]);}};M.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek();};function _(t){var p=t._getDate();var y=t._oFormatYyyymmdd.format(p,true);var r=0;var R=t.$("days").get(0);var s=t.$("days").find(".sapUiCalItem");for(var i=0;i<s.length;i++){var $=q(s[i]);if($.attr("data-sap-day")===y){r=i;break;}}if(!t._oItemNavigation){t._oItemNavigation=new I();t._oItemNavigation.attachEvent(I.Events.AfterFocus,b,t);t._oItemNavigation.attachEvent(I.Events.FocusAgain,c,t);t._oItemNavigation.attachEvent(I.Events.BorderReached,t._handleBorderReached,t);t.addDelegate(t._oItemNavigation);if(t._iColumns>1){t._oItemNavigation.setHomeEndColumnMode(true,true);}t._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});t._oItemNavigation.setCycling(false);t._oItemNavigation.setColumns(t._iColumns,true);}t._oItemNavigation.setRootDomRef(R);t._oItemNavigation.setItemDomRefs(s);t._oItemNavigation.setFocusedIndex(r);t._oItemNavigation.setPageSize(s.length);}function b(p){var r=p.getParameter("index");var E=p.getParameter("event");if(!E){return;}var t=this;var O=this._getDate();var F=new U(O.getTime());var s=false;var u=true;var v=this._oItemNavigation.getItemDomRefs();var i=0;var $=q(v[r]);var w;if($.hasClass("sapUiCalItemOtherMonth")){if(E.type=="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){F.setUTCDate(1);f(t,F);}else if(E.type=="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(i=v.length-1;i>0;i--){w=q(v[i]);if(!w.hasClass("sapUiCalItemOtherMonth")){F=new U(this._oFormatYyyymmdd.parse(w.attr("data-sap-day"),true).getTime());break;}}f(t,F);}else{s=true;F=new U(this._oFormatYyyymmdd.parse($.attr("data-sap-day"),true).getTime());if(!F){F=new U(O.getTime());}f(t,O);if(E.type=="mousedown"||(this._sTouchstartYyyyMMdd&&E.type=="focusin"&&this._sTouchstartYyyyMMdd==$.attr("data-sap-day"))){u=false;this.fireFocus({date:a._createLocalDate(O),otherMonth:false,restoreOldDate:true});}if(E.originalEvent&&E.originalEvent.type=="touchstart"){this._sTouchstartYyyyMMdd=$.attr("data-sap-day");}else{this._sTouchstartYyyyMMdd=undefined;}}}else{if(q(E.target).hasClass("sapUiCalWeekNum")){f(t,F);}else{F=new U(this._oFormatYyyymmdd.parse($.attr("data-sap-day"),true).getTime());this._setDate(F);}this._sTouchstartYyyyMMdd=undefined;}if(E.type=="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=$.attr("id");}if(u){this.fireFocus({date:a._createLocalDate(F),otherMonth:s});}if(E.type=="mousedown"){d(t,E,F,r);}}function c(i){var p=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var t=this;var F=this._getDate();if(this.getIntervalSelection()){var r=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=r[p].id;}d(t,E,F,p);}}function d(t,E,F,i){if(E.button){return;}h(t,F);t._bMousedownChange=true;t._bMousedownChange=true;if(t._bMouseMove){t._unbindMousemove(true);t._bMoveChange=false;}else if(t.getIntervalSelection()&&t.$().is(":visible")){t._bindMousemove(true);}E.preventDefault();E.setMark("cancelAutoClose");}function e(t,i,N){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+t);}var y=i.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+t);}var F=true;if(!q.sap.equal(t.getDate(),i)){var u=a._createUniversalUTCDate(i);F=t.checkDateFocusable(i);t.setProperty("date",i,true);t._oUTCDate=u;}if(t.getDomRef()){if(F){if(!N){f(t,t._oUTCDate,true);}}else{g(t,N);}}}function f(t,p,N){if(!N){t.setDate(a._createLocalDate(new Date(p.getTime())));}var y=t._oFormatYyyymmdd.format(p,true);var r=t._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<r.length;i++){$=q(r[i]);if($.attr("data-sap-day")==y){if(document.activeElement!=r[i]){t._oItemNavigation.focusItem(i);}break;}}}function g(t,N){var p=t.getRenderer().getStartDate(t);var $=t.$("days");var r;var s;var i=0;var u=0;if(t._sLastTargetId){r=t._oItemNavigation.getItemDomRefs();for(i=0;i<r.length;i++){s=q(r[i]);if(s.attr("id")==t._sLastTargetId){u=i;break;}}}if($.length>0){var R=sap.ui.getCore().createRenderManager();t.getRenderer().renderDays(R,t,p);R.flush($[0]);R.destroy();}t._renderHeader();t.fireEvent("_renderMonth",{days:$.find(".sapUiCalItem").length});_(t);if(!N){t._oItemNavigation.focusItem(t._oItemNavigation.getFocusedIndex());}if(t._sLastTargetId){r=t._oItemNavigation.getItemDomRefs();if(u<=r.length-1){s=q(r[u]);t._sLastTargetId=s.attr("id");}}}function h(t,p,r){var s=t.getSelectedDates();var u;var v=t._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=t.getParent();var A=t;var S;if(P&&P.getSelectedDates){A=P;}if(t.getSingleSelection()){if(s.length>0){u=s[0];S=u.getStartDate();if(S){S=a._createUniversalUTCDate(S);}}else{u=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",u,true);}if(t.getIntervalSelection()&&(!u.getEndDate()||r)&&S){var E;if(p.getTime()<S.getTime()){E=S;S=p;if(!r){u.setProperty("startDate",a._createLocalDate(new Date(S.getTime())),true);u.setProperty("endDate",a._createLocalDate(new Date(E.getTime())),true);}}else if(p.getTime()>=S.getTime()){E=p;if(!r){u.setProperty("endDate",a._createLocalDate(new Date(E.getTime())),true);}}j(t,S,E);}else{j(t,p);u.setProperty("startDate",a._createLocalDate(new Date(p.getTime())),true);u.setProperty("endDate",undefined,true);}}else{if(t.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var w=t._checkDateSelected(p);if(w>0){for(i=0;i<s.length;i++){S=s[i].getStartDate();if(S&&p.getTime()==a._createUniversalUTCDate(S).getTime()){A.removeAggregation("selectedDates",i,true);break;}}}else{u=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(p.getTime()))});A.addAggregation("selectedDates",u,true);}y=t._oFormatYyyymmdd.format(p,true);for(i=0;i<v.length;i++){$=q(v[i]);if($.attr("data-sap-day")==y){if(w>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}}function j(t,s,E){var p=t._oItemNavigation.getItemDomRefs();var $;var i=0;var S=false;var r=false;if(!E){var y=t._oFormatYyyymmdd.format(s,true);for(i=0;i<p.length;i++){$=q(p[i]);S=false;r=false;if($.attr("data-sap-day")==y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");S=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}k(t,$,S,r);}}else{var u;for(i=0;i<p.length;i++){$=q(p[i]);S=false;r=false;u=new U(t._oFormatYyyymmdd.parse($.attr("data-sap-day"),true).getTime());if(u.getTime()==s.getTime()){$.addClass("sapUiCalItemSelStart");S=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&u.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");r=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&u.getTime()>s.getTime()&&u.getTime()<E.getTime()){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&u.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");r=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}k(t,$,S,r);}}}function k(t,$,s,E){if(!t.getIntervalSelection()){return;}var p="";var r=[];var u=t.getId();var v=false;p=$.attr("aria-describedby");if(p){r=p.split(" ");}var S=-1;var w=-1;for(var i=0;i<r.length;i++){var x=r[i];if(x==(u+"-Start")){S=i;}if(x==(u+"-End")){w=i;}}if(S>=0&&!s){r.splice(S,1);v=true;if(w>S){w--;}}if(w>=0&&!E){r.splice(w,1);v=true;}if(S<0&&s){r.push(u+"-Start");v=true;}if(w<0&&E){r.push(u+"-End");v=true;}if(v){p=r.join(" ");$.attr("aria-describedby",p);}}function m(t){if(t._bMouseMove){t._unbindMousemove(true);}t.fireSelect();}function n(t){if(!t._bNamesLengthChecked){var w;var W=t.$().find(".sapUiCalWH");var T=false;var i=0;for(i=0;i<W.length;i++){w=W[i];if(Math.abs(w.clientWidth-w.scrollWidth)>1){T=true;break;}}if(T){t._bLongWeekDays=false;var p=t._getLocaleData();var s=t._getFirstWeekDay();var r=p.getDaysStandAlone("narrow");for(i=0;i<W.length;i++){w=W[i];q(w).text(r[(i+s)%7]);}}else{t._bLongWeekDays=true;}t._bNamesLengthChecked=true;}}function o(t){t._sInvalidateMonth=undefined;g(t,t._bNoFocus);t._bDateRangeChanged=undefined;t._bNoFocus=undefined;}}());return M;},true);
