/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./library'],function(q,C,I,P,a,l){"use strict";var T=C.extend("sap.ui.ux3.ToolPopup",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHover:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},inverted:{type:"boolean",group:"Misc",defaultValue:true},autoClose:{type:"boolean",group:"Misc",defaultValue:false},maxHeight:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},openDuration:{type:"int",group:"Misc",defaultValue:400},closeDuration:{type:"int",group:"Misc",defaultValue:400}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{initialFocus:{type:"sap.ui.core.Control",multiple:false},opener:{type:"sap.ui.core.Control",multiple:false},defaultButton:{type:"sap.ui.core.Control",multiple:false}},events:{open:{},close:{allowPreventDefault:true},enter:{parameters:{originalEvent:{type:"object"},originalSrcControl:{type:"sap.ui.core.Control"}}},iconChanged:{},closed:{},opened:{}}}});T.ARROW_LEFT=new RegExp(/my:(left|begin)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(right|end)\|[a-z]+/);T.ARROW_RIGHT=new RegExp(/my:(right|end)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(left|begin)\|[a-z]+/);T.ARROW_UP=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|top([-+]\d*\%?)? at:[a-z]+\|bottom/);T.ARROW_DOWN=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|bottom([-+]\d*\%?)? at:[a-z]+\|top/);(function(){T.prototype.init=function(){this.oPopup=null;this._bPositionSet=false;this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-firstFocusable";this._mParameters.lastFocusable=this.getId()+"-lastFocusable";this._bFocusSet=false;this._proxyOpened=q.proxy(p,this);this._proxyClosed=q.proxy(o,this);this._proxyFixSize=q.proxy(f,this);this._proxyOnResize=q.proxy(O,this);s(this);};T.prototype.exit=function(){if(this.oPopup){this.oPopup.detachOpened(this._proxyOpened);this.oPopup.detachClosed(this._proxyClosed);this.oPopup.destroy();delete this.oPopup;}delete this._bPositionSet;delete this._mParameters;delete this._bFocusSet;delete this._bPreventRestoreFocus;delete this._proxyOpened;delete this._proxyClosed;delete this._bRTL;delete this._sArrowDir;delete this._oArrowIcon;delete this._bThemeInverted;delete this._sInitialFocusId;};var _=function(t){if(!t._bFocusSet){b(t);}else{t._sInitialFocusId=t.oPopup._sInitialFocusId;}return t._sInitialFocusId;};var b=function(t){var E;var F;var h=[t._mParameters.firstFocusable,t._mParameters.lastFocusable];var j=q(":sapTabbable",t.$()).get();for(var i=0;i<j.length;i++){if(h.indexOf(j[i].id)===-1){E=j[i];break;}}F=q(E).control();if(F[0]){var k=F[0].getFocusDomRef();E=k||E;}else{E=q.sap.domById(h[0]);}if(E){q.sap.focus(E);t._sInitialFocusId=E.id;}};function c(i){var h=sap.ui.getCore().byId(i);return h;}T.prototype.getFocusDomRef=function(){var h;var i=c(this._sInitialFocusId);if(!i){this._bFocusSet=false;h=_(this);i=c(h);}return i?i.getDomRef():this.getDomRef();};T.prototype.onfocusin=function(E){this._mParameters.event=E;this._mParameters.$FocusablesContent=q(":sapTabbable",this.$("content"));this._mParameters.$FocusablesFooter=q(":sapTabbable",this.$("buttons"));this.oPopup.focusTabChain(this._mParameters);};var f=function(){var t=this.$();var v=0;var m=this.getMaxHeight();var M=m?parseInt(m,10):0;var h=this.getMaxWidth();if(h){var i=parseInt(h,10);var B=t.css("border-left-width");var j=parseInt(B,10);var k=t.css("border-right-width");var n=parseInt(k,10);var w=t.css("padding-left");var x=parseInt(w,10);var y=t.css("padding-right");var z=parseInt(y,10);i-=j+x+z+n;t.css("max-width",i+"px");}else{t.css("max-width","");}var A=t.css("padding-top");var D=parseInt(A,10);var E=t.css("padding-bottom");var F=parseInt(E,10);var G=t.css("border-top-width");var H=parseInt(G,10);var J=t.css("border-bottom-width");var K=parseInt(J,10);var L=D+F+H+K;var N=q(document).scrollTop();var Q=t.rect();var U=Q.top-N+t.outerHeight(true);var W=q(window).height();var V=(U>W)&&(M===0);var Y=0;if(V){var $=q.sap.byId(this.getOpener());var X=$.rect();var Z=X.top-N+$.outerHeight(true);var a1=this.oPopup._getPositionOffset();if(U>Z&&a1.length>0){Y=Math.abs(parseInt(a1[1],10));if((U-Y)<W){V=false;var b1="Offset of "+Y+" pushes ToolPopup out of the window";q.sap.log.warning(b1,"","sap.ui.ux3.ToolPopup");}}M=M?M:W-Q.top;}t.toggleClass("sapUiUx3TPLargeContent",V);if(M||V){t.css("max-height",M+"px");var c1=this.$("title");var d1=this.$("title-separator");var e1=this.$("buttons");var f1=this.$("buttons-separator");v=M>0?M:W-Q.top-F-Y;v-=L;v-=c1.outerHeight(true);v-=d1.outerHeight(true);v-=f1.outerHeight(true);v-=e1.length>0?e1.outerHeight(true):0;v=parseInt(v,10);var g1=this.$("content");g1.css("max-height",v+"px");g1.toggleClass("sapUiUx3TPLargeContent",true);}S(this);};var p=function(){this._proxyFixSize();if(!this._sInitialFocusId){var i=_(this);if(i!==sap.ui.getCore().getCurrentFocusedControlId()){var h=q.sap.byId(i);h.focus();}}if(!this._sResizeID){this._sResizeID=sap.ui.core.ResizeHandler.register(this.$('content')[0],this._proxyOnResize);}this.fireOpened();};T.prototype.isOpen=function(){return this.oPopup&&(this.oPopup.getOpenState()=="OPENING"||this.oPopup.getOpenState()=="OPEN");};T.prototype.willBeClosed=function(){var h=this.oPopup&&this.oPopup.getOpenState();return h!==sap.ui.core.OpenState.OPENING&&h!==sap.ui.core.OpenState.OPEN;};T.prototype.open=function(m,h){this._my=m;this._at=h;this._sArrowDir=g(this);var $=null;this.sOffset="";u(this);if(!this._bPositionSet){var i=0;var j=0;if(!this._my){this._my=P.Dock.BeginTop;}if(!this._at){this._at=P.Dock.EndTop;}$=q.sap.domById(this.getOpener());if($){switch(this._sArrowDir){case"Up":i=0;j=this.iArrowWidth;break;case"Down":i=0;j=-this.iArrowWidth;break;case"Right":i=-this.iArrowWidth;break;default:case"Left":i=this.iArrowWidth;break;}i=parseInt(i,10);j=parseInt(j,10);this.sOffset=""+i+" "+j;this.setPosition(this._my,this._at,$,this.sOffset,"none");}else{this.setPosition(P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","fit");q.sap.log.warning("No opener set. Using a default position for Popup","","sap.ui.ux3.ToolPopup");}this._bPositionSet=false;}this._ensurePopup();var A=this.getAutoClose();var M=this.getModal();if(A&&M){q.sap.log.warning("A modal & autoclose ToolPopup will not work properly. Therefore 'autoclose' will be deactived!");A=false;}this.oPopup.setAutoClose(A);this.oPopup.setModal(M);this._oPreviousFocus=P.getCurrentFocusInfo();this.fireOpen();d(this);this.oPopup.open(this.getOpenDuration(),this._my,this._at,$,this.sOffset,"",true);S(this);return this;};var d=function(t){if(!t.getOpener()){var i="";if(t.oPopup){if(t.oPopup._oPosition.of instanceof sap.ui.core.Element){i=t.oPopup._oPosition.of.getId();}else{if(t.oPopup._oPosition.of.length>0){i=t.oPopup._oPosition.of[0].id;}else{i=t.oPopup._oPosition.of.id;}}}if(i!==""){t.setAssociation("opener",i,true);}else{q.sap.log.error("Neither an opener was set properly nor a corresponding one can be distinguished","","sap.ui.ux3.ToolPopup");}}};var s=function(t){var h="sapUiUx3ToolPopupArrowWidth";t.sArrowWidth=a.get(h);t.iArrowWidth=parseInt(t.sArrowWidth,10);h="sapUiUx3ToolPopupArrowHeight";t.sArrowHeight=a.get(h);t.iArrowHeight=parseInt(t.sArrowHeight,10);h="sapUiUx3ToolPopupArrowRightMarginCorrection";t.sArrowPadding=a.get(h);t.iArrowPadding=parseInt(t.sArrowPadding,10);h="sapUiUx3ToolPopupArrowRightMarginCorrectionInverted";t.sArrowPaddingInverted=a.get(h);t.iArrowPaddingInverted=parseInt(t.sArrowPaddingInverted,10);};var g=function(t){var D="Left";var m=t._my;var h=t._at;if(!m&&t.oPopup){m=t.oPopup._oPosition.my;}if(!h&&t.oPopup){h=t.oPopup._oPosition.at;}t._bHorizontalArrow=false;if(m&&h){var M=m.split(" ");var A=h.split(" ");var i="my:"+M[0]+"|"+M[1];i+=" at:"+A[0]+"|"+A[1];if(T.ARROW_LEFT.exec(i)){t._bHorizontalArrow=true;D="Left";}else if(T.ARROW_RIGHT.exec(i)){t._bHorizontalArrow=true;D="Right";}else if(T.ARROW_UP.exec(i)){D="Up";}else if(T.ARROW_DOWN.exec(i)){D="Down";}if(t.getDomRef()&&t.isOpen()){var $=t.$();var j=$.rect();var k=q.sap.byId(t.getOpener());var n=k.rect();if(n){if(t._bHorizontalArrow){var v=j.left+$.outerWidth(true)+t.iArrowWidth;var w=n.left+k.outerWidth(true);if(v<=w){D="Right";}else{D="Left";}}else{var x=j.top+$.outerHeight(true)+t.iArrowWidth;var y=n.top+k.outerHeight(true);if(x<=y){D="Down";}else{D="Up";}}}}}return D;};var S=function(t){var k="",v=0,z=0,h=t.iArrowHeight/2,i=sap.ui.getCore().getConfiguration().getRTL(),A,j=t.$().rect(),m=q.sap.byId(t.getOpener()),n=m.rect(),$=t.$("arrow");if(!t.getDomRef()){return;}t._sArrowDir=g(t);A=t._sArrowDir;if(i){if(t._sArrowDir==="Right"){A="Left";}else if(t._sArrowDir==="Left"){A="Right";}}if(!n){q.sap.log.warning("Opener wasn't set properly. Therefore arrow will be at a default position","","sap.ui.ux3.ToolPopup");}if(!t._my&&t.oPopup){t._my=t.oPopup._oPosition.my;}if(t._bHorizontalArrow){k="top";if(n){z=parseInt(n.top-j.top,10);v=Math.round(z+n.height/2);v=v+h>j.height?v-t.iArrowHeight:v;}}else{k="left";if(n){var w=parseInt(q(m).css('border-left'),10);var x=parseInt(q(m).css('border-right'),10);if(i){k="right";z=parseInt(j.left+j.width-n.left-n.width-x,10);}else{z=parseInt(n.left-j.left-w,10);}v=Math.round(z+n.width/2-h);v=v+h>j.width?v-t.iArrowHeight:v;}}if(!n){v=t.iArrowHeight;}var y="";if($.hasClass("sapUiUx3TPNewArrow")){y="sapUiUx3TPNewArrow sapUiUx3TPNewArrow";}else{y=t.isInverted()?"sapUiUx3TPArrow sapUiTPInverted sapUiUx3TPArrow":"sapUiUx3TPArrow sapUiUx3TPArrow";}$.attr("class",y+A);if(A==="Right"){var W=j.width;if(t.isInverted()){W+=t.iArrowPaddingInverted;}else{W+=t.iArrowPadding;}if(i){$.css("right",W+"px");}else{$.css("left",W+"px");}}else{$.css({"left":"","right":""});}v=parseInt(v,10);v=v<0?0:v;$.css(k,v+"px");};T.prototype.onsapescape=function(){if(this.fireClose()){this.close();}};var o=function(E){if(!this._bPreventRestoreFocus){P.applyFocusInfo(this._oPreviousFocus);}this.$().remove();this.fireClosed();};T.prototype.close=function(h){if(this.oPopup&&this.oPopup.isOpen()){if(this._sResizeID){sap.ui.core.ResizeHandler.deregister(this._sResizeID);delete this._sResizeID;}this.oPopup.close(this.getCloseDuration());this._bPreventRestoreFocus=h;}return this;};T.prototype.getEnabled=function(){var h=this.oPopup?this.oPopup.getOpenState():sap.ui.core.OpenState.CLOSED;return h===sap.ui.core.OpenState.OPENING||h===sap.ui.core.OpenState.OPEN;};T.prototype.onsapenter=function(E){var i=this.getDefaultButton();var F=sap.ui.getCore().byId(i);if(i&&F&&q.contains(this.getDomRef(),F.getDomRef())){if(F instanceof sap.ui.commons.Button){var $=F.$();$.click();$.focus();}}E.preventDefault();E.stopPropagation();};T.prototype.onBeforeRendering=function(){var i=this.getInitialFocus()||this._sInitialFocusId;var D=this.getDefaultButton();this._bFocusSet=true;if(i){this.oPopup.setInitialFocusId(i);}else if(D){this.oPopup.setInitialFocusId(D);}else{this._bFocusSet=false;}this._bRTL=sap.ui.getCore().getConfiguration().getRTL();};T.prototype._ensurePopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.attachOpened(this._proxyOpened);this.oPopup.attachClosed(this._proxyClosed);var t=this;this.oPopup._applyPosition=function(){P.prototype._applyPosition.apply(t.oPopup,arguments);var h=t.oPopup._oLastPosition.of;if(!h){t.oPopup.close();}else{var $=q.sap.byId(h.id);if(t._bPositionSet){if(!$.hasClass("sapUiUx3ShellTool")){t._my=t.oPopup._oLastPosition.my;t._at=t.oPopup._oLastPosition.at;}}S(t);}};}return this.oPopup;};var O=function(){if(this.getContent().length){this._proxyFixSize();this.oPopup._applyPosition(this.oPopup._oLastPosition);}};T.prototype.setPosition=function(){this._ensurePopup();this.oPopup.setPosition.apply(this.oPopup,arguments);this._bPositionSet=true;d(this);return this;};var e=function(t,h){if(h==="content"){r(t);}else if(h==="buttons"){R(t);}t._proxyFixSize();t.oPopup._applyPosition(t.oPopup._oLastPosition);};var r=function(t){var h=t.getDomRef("content");h.innerHTML="";var j=t.getContent();var k=sap.ui.getCore().createRenderManager();for(var i=0;i<j.length;i++){k.renderControl(j[i]);}k.flush(h,true);k.destroy();};var R=function(t){var B=t.getDomRef("buttons");var h=t.getDomRef("buttons-separator");var j=t.getButtons();if(j.length===0){q(B).addClass("sapUiUx3TPButtonRowHidden");q(h).addClass("sapUiUx3TPButtonRowHidden");}else{q(B).removeClass("sapUiUx3TPButtonRowHidden");q(h).removeClass("sapUiUx3TPButtonRowHidden");B.innerHTML="";var k=sap.ui.getCore().createRenderManager();for(var i=0;i<j.length;i++){k.renderControl(j[i]);}k.flush(B,true);k.destroy();}};T.prototype.addContent=function(h){this.addAggregation("content",h,true);if(this.isOpen()){e(this,"content");}return this;};T.prototype.insertContent=function(h,i){this.insertAggregation("content",h,i,true);if(this.isOpen()){e(this,"content");}return this;};T.prototype.removeContent=function(h){this.removeAggregation("content",h,true);if(this.isOpen()){e(this,"content");}return this;};T.prototype.addButton=function(B){this.addAggregation("buttons",B,true);if(this.isOpen()){e(this,"buttons");}return this;};T.prototype.insertButton=function(B,i){this.insertAggregation("buttons",B,i,true);if(this.isOpen()){e(this,"buttons");}return this;};T.prototype.removeButton=function(B){this.removeAggregation("button",B,true);if(this.isOpen()){e(this,"buttons");}return this;};var u=function(t){var h="sapUiUx3ToolPopupInverted";h=a.get(h);t._bThemeInverted=h==="true";};T.prototype.onThemeChanged=function(){u(this);};T.prototype.isInverted=function(){u(this);return this.getInverted()&&this._bThemeInverted;};T.prototype.setAutoCloseAreas=function(A){this._ensurePopup();return this.oPopup.setAutoCloseAreas(A);};T.prototype.addFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._addFocusableArea("channelId","eventId",{id:i});return this;}else{q.sap.log.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};T.prototype.removeFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._removeFocusableArea("channelId","eventId",{id:i});return this;}else{q.sap.log.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};}());T.prototype.setIcon=function(i){this.setProperty("icon",i,true);this.fireIconChanged();return this;};T.prototype.setIconHover=function(i){this.setProperty("iconHover",i,true);this.fireIconChanged();return this;};T.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,true);this.fireIconChanged();return this;};T.prototype.getIconSelected=function(){return this.getProperty("iconSelected")||this.getProperty("iconHover");};T.prototype.setMaxWidth=function(m){var p=/[0-9]+px/;if(p.test(m)){this.setProperty("maxWidth",m);}else{q.sap.log.error("Only values in pixels are possible","","sap.ui.ux3.ToolPopup");}};return T;},true);
