/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Table','sap/ui/model/odata/ODataTreeBindingAdapter','sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./library'],function(q,T,O,C,a,l){"use strict";var b=T.extend("sap.ui.table.TreeTable",{metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},rootLevel:{type:"int",group:"Data",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}}});b.prototype.init=function(){T.prototype.init.apply(this,arguments);this._iLastFixedColIndex=0;if(sap.ui.getCore().getConfiguration().getTheme()==="sap_bluecrystal"||sap.ui.getCore().getConfiguration().getTheme()==="sap_hcb"){q.sap.require("sap.ui.core.IconPool");sap.ui.core.IconPool.insertFontFaceStyle();}};b.prototype.bindRows=function(B,t,s,f){var p,o,s,f;if(typeof B=="string"){p=arguments[0];o=arguments[1];s=arguments[2];f=arguments[3];B={path:p,sorter:s,filters:f,template:o};}if(typeof B==="object"){B.parameters=B.parameters||{};B.parameters.rootLevel=this.getRootLevel();B.parameters.collapseRecursive=this.getCollapseRecursive();B.parameters.numberOfExpandedLevels=B.parameters.numberOfExpandedLevels||(this.getExpandFirstLevel()?1:0);B.parameters.rootNodeID=B.parameters.rootNodeID;}return this.bindAggregation("rows",B);};b.prototype.setSelectionMode=function(s){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();this.setProperty("selectionMode",s);}else{T.prototype.setSelectionMode.call(this,s);}return this;};b.prototype.refreshRows=function(r){this._bBusyIndicatorAllowed=true;this._attachBindingListener();var B=this.getBinding("rows");if(B&&this.isTreeBinding("rows")&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}this._bRefreshing=true;this._onBindingChange(r);this._updateBindingContexts(true);this._bRefreshing=false;};b.prototype.setFixedRowCount=function(r){q.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");return this;};b.prototype.onAfterRendering=function(){T.prototype.onAfterRendering.apply(this,arguments);this.$().find("[role=grid]").attr("role","treegrid");};b.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return true;}return sap.ui.core.Element.prototype.isTreeBinding.apply(this,arguments);};b.prototype.getBinding=function(n){n=n||"rows";var B=sap.ui.core.Element.prototype.getBinding.call(this,n);if(B&&this.isTreeBinding(n)&&n==="rows"&&!B.getLength){if(sap.ui.model.odata.ODataTreeBinding&&B instanceof sap.ui.model.odata.ODataTreeBinding){a(B,this);}else if(sap.ui.model.odata.v2.ODataTreeBinding&&B instanceof sap.ui.model.odata.v2.ODataTreeBinding){O.apply(B);}else if(sap.ui.model.ClientTreeBinding&&B instanceof sap.ui.model.ClientTreeBinding){C.apply(B);}else{q.sap.log.error("Binding not supported by sap.ui.table.TreeTable");}}return B;};b.prototype._updateTableContent=function(){T.prototype._updateTableContent.apply(this,arguments);var B=this.getBinding("rows"),f=this.getFirstVisibleRow(),c=this.getVisibleRowCount(),F=this.getFixedBottomRowCount(),i=c-F;var I=f;if(B){for(var r=0;r<c;r++){if(F>0&&r>=i){I=B.getLength()-c+r;}else{I=f+r;}var o=this.getContextByIndex(I),d=this.getRows()[r].getDomRefs(true),$=d.rowFixedPart||d.rowScrollPart;this._updateExpandIcon($,o,I);if(this.getUseGroupMode()){var e=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(B.hasChildren&&B.hasChildren(o)){$.addClass("sapUiTableGroupHeader sapUiTableRowHidden");var s=B.isExpanded(f+r)?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";e.html("<div class=\"sapUiTableGroupIcon "+s+"\" tabindex=\"-1\">"+this.getModel().getProperty(this.getGroupHeaderProperty(),o)+"</div>");e.addClass("sapUiTableGroupHeader").removeAttr("title");}else{$.removeClass("sapUiTableGroupHeader");if(o){$.removeClass("sapUiTableRowHidden");}e.html("");e.removeClass("sapUiTableGroupHeader");}}}}};b.prototype._updateTableCell=function(){return true;};b.prototype._updateExpandIcon=function($,c,A){var B=this.getBinding("rows");if(B){var L=0,i=false;if(B.getLevel){L=B.getLevel(c);i=B.isExpanded(A);}else if(B.findNode){var n=B.findNode(A);L=n?n.level:0;i=n&&n.nodeState?n.nodeState.expanded:false;}var t=$.find(".sapUiTableTreeIcon");var s="sapUiTableTreeIconLeaf";var f=$.children("td.sapUiTableTdFirst");if(!this.getUseGroupMode()){if(this._bRtlMode===true){t.css("marginRight",L*17);}else{t.css("marginLeft",L*17);}}if(B.hasChildren&&B.hasChildren(c)){s=i?"sapUiTableTreeIconNodeOpen":"sapUiTableTreeIconNodeClosed";f.attr('aria-expanded',i);var N=i?this._oResBundle.getText("TBL_COLLAPSE"):this._oResBundle.getText("TBL_EXPAND");t.attr('title',N);}else{f.attr('aria-expanded',false);t.attr('aria-label',this._oResBundle.getText("TBL_LEAF"));}t.removeClass("sapUiTableTreeIconLeaf sapUiTableTreeIconNodeOpen sapUiTableTreeIconNodeClosed").addClass(s);$.attr("data-sap-ui-level",L);f.attr('aria-level',L+1);}};b.prototype.onclick=function(e){if(q(e.target).hasClass("sapUiTableGroupIcon")){this._onGroupSelect(e);}else if(q(e.target).hasClass("sapUiTableTreeIcon")){this._onNodeSelect(e);}else{if(T.prototype.onclick){T.prototype.onclick.apply(this,arguments);}}};b.prototype.onsapselect=function(e){if(q(e.target).hasClass("sapUiTableTreeIcon")){this._onNodeSelect(e);}else{if(T.prototype.onsapselect){T.prototype.onsapselect.apply(this,arguments);}}};b.prototype.onkeydown=function(e){T.prototype.onkeydown.apply(this,arguments);var t=q(e.target),$=t.closest('td');if(e.keyCode==q.sap.KeyCodes.TAB&&this._bActionMode&&$.find('.sapUiTableTreeIcon').length>0){if(t.hasClass('sapUiTableTreeIcon')){if(!t.hasClass("sapUiTableTreeIconLeaf")){$.find(':sapFocusable:not(.sapUiTableTreeIcon)').first().focus();}}else{$.find('.sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)').focus();}e.preventDefault();}};b.prototype._onNodeSelect=function(e){var $=q(e.target).parents("tr");if($.length>0){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var c=this.getContextByIndex(r);this.fireToggleOpenState({rowIndex:r,rowContext:c,expanded:!this.getBinding().isExpanded(r)});this.getBinding("rows").toggleIndex(r);}e.preventDefault();e.stopPropagation();};b.prototype._onGroupSelect=function(e){var $=q(e.target).parents("[data-sap-ui-rowindex]");if($.length>0){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var c=this.getContextByIndex(r);if(this.getBinding().isExpanded(r)){q(e.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");}else{q(e.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");}this.fireToggleOpenState({rowIndex:r,rowContext:c,expanded:!this.getBinding().isExpanded(r)});this.getBinding("rows").toggleIndex(r);}e.preventDefault();e.stopPropagation();};b.prototype.expand=function(r){var B=this.getBinding("rows");if(B){B.expand(r);}return this;};b.prototype.collapse=function(r){var B=this.getBinding("rows");if(B){B.collapse(r);}return this;};b.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};b.prototype.expandToLevel=function(L){var B=this.getBinding("rows");if(B&&B.expandToLevel){B.expandToLevel(L);}return this;};b.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};b.prototype.isIndexSelected=function(r){var B=this.getBinding("rows");if(B&&B.isIndexSelected){return B.isIndexSelected(r);}else{return T.prototype.isIndexSelected.call(this,r);}};b.prototype.setSelectedIndex=function(r){if(r===-1){this.clearSelection();}var B=this.getBinding("rows");if(B&&B.findNode&&B.setNodeSelection){B.setSelectedIndex(r);}else{T.prototype.setSelectedIndex.call(this,r);}return this;};b.prototype.getSelectedIndices=function(){var B=this.getBinding("rows");if(B&&B.findNode&&B.getSelectedIndices){return B.getSelectedIndices();}else{return T.prototype.getSelectedIndices.call(this);}};b.prototype.setSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.setSelectionInterval){B.setSelectionInterval(f,t);}else{T.prototype.setSelectionInterval.call(this,f,t);}return this;};b.prototype.addSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.addSelectionInterval){B.addSelectionInterval(f,t);}else{T.prototype.addSelectionInterval.call(this,f,t);}return this;};b.prototype.removeSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.removeSelectionInterval){B.removeSelectionInterval(f,t);}else{T.prototype.removeSelectionInterval.call(this,f,t);}return this;};b.prototype.selectAll=function(){var s=this.getSelectionMode();if(!this.getEnableSelectAll()||(s!="Multi"&&s!="MultiToggle")||!this._getSelectableRowCount()){return this;}var B=this.getBinding("rows");if(B.selectAll){B.selectAll();this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}else{T.prototype.selectAll.call(this);}return this;};b.prototype.getSelectedIndex=function(){var B=this.getBinding("rows");if(B&&B.findNode){return B.getSelectedIndex();}else{return T.prototype.getSelectedIndex.call(this);}};b.prototype.clearSelection=function(){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}else{T.prototype.clearSelection.call(this);}return this;};b.prototype._enterActionMode=function(t){var $=t.eq(0);T.prototype._enterActionMode.apply(this,arguments);if(t.length>0&&$.hasClass("sapUiTableTreeIcon")&&!$.hasClass("sapUiTableTreeIconLeaf")){$.attr("tabindex",0).focus();this._bActionMode=true;}};b.prototype._leaveActionMode=function(e){T.prototype._leaveActionMode.apply(this,arguments);this.$().find(".sapUiTableTreeIcon").attr("tabindex",-1);};b.prototype.getContextByIndex=function(r){var B=this.getBinding("rows");if(B){return B.getContextByIndex(r);}};b.prototype.setRootLevel=function(r){this.setFirstVisibleRow(0);var B=this.getBinding("rows");if(B){if(B.setRootLevel){B.setRootLevel(r);}}this.setProperty("rootLevel",r,true);return this;};b.prototype.setCollapseRecursive=function(c){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(c);}}this.setProperty("collapseRecursive",!!c,true);return this;};return b;},true);
