/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,T,b,M,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Misc"},intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},items:{type:"int",group:"Misc",defaultValue:12},intervalMinutes:{type:"int",group:"Misc",defaultValue:60}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.DatesRow",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},cancel:{}}}});(function(){c.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(U.UTC(1,0,1));this._oMinDate.setUTCFullYear(1);this._oMaxDate=new U(U.UTC(9999,11,31));var I=new H(this.getId()+"--Head",{visibleButton0:true,visibleButton1:true,visibleButton2:true});I.attachEvent("pressPrevious",this._handlePrevious,this);I.attachEvent("pressNext",this._handleNext,this);I.attachEvent("pressButton0",t,this);I.attachEvent("pressButton1",u,this);I.attachEvent("pressButton2",v,this);this.setAggregation("header",I);var J=new T(this.getId()+"--TimesRow");J.attachEvent("focus",x,this);J.attachEvent("select",w,this);J._bNoThemeChange=true;this.setAggregation("timesRow",J);var K=new b(this.getId()+"--DatesRow",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});K.attachEvent("focus",z,this);K.attachEvent("select",y,this);K.getIntervalSelection=function(){return this.getProperty("intervalSelection");};K.getSingleSelection=function(){return this.getProperty("singleSelection");};K.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};K.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};K.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};K._bNoThemeChange=true;this.setAggregation("datesRow",K);var N=new M(this.getId()+"--MP",{columns:0,months:6});N.attachEvent("select",A,this);N._bNoThemeChange=true;this.setAggregation("monthPicker",N);var O=new Y(this.getId()+"--YP",{columns:0,years:6});O.attachEvent("select",B,this);this.setAggregation("yearPicker",O);this._iItemsHead=15;};c.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};c.prototype.onBeforeRendering=function(){var I=this.getAggregation("timesRow");var J=this._getFocusedDate();n.call(this);I.setDate(a._createLocalDate(J,true));};c.prototype.setStartDate=function(S){if(!(S instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var I=S.getFullYear();if(I<1||I>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this.setProperty("startDate",S,true);var J=this.getAggregation("timesRow");J.setStartDate(S);this._oUTCStartDate=new U(J._getStartDate().getTime());n.call(this);var K=a._createLocalDate(this._getFocusedDate(),true);if(!J.checkDateFocusable(K)){this._setFocusedDate(this._oUTCStartDate);J.setDate(S);}return this;};c.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){if(!O||(!(O instanceof sap.ui.unified.calendar.DatesRow||O instanceof sap.ui.unified.calendar.MonthPicker||O instanceof sap.ui.unified.calendar.YearPicker||O instanceof sap.ui.unified.calendar.Header))){C.prototype.invalidate.apply(this,arguments);}}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,E);}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var I=this.destroyAggregation("selectedDates");return I;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var I=this.destroyAggregation("specialDates");return I;};c.prototype.setIntervalMinutes=function(I){if(I>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%I>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",I,false);var J=this.getAggregation("timesRow");var K=a._createLocalDate(this._getFocusedDate(),true);if(!J.checkDateFocusable(K)){var S=d.call(this);this._setFocusedDate(S);J.setDate(a._createLocalDate(S,true));}return this;};c.prototype.setLocale=function(I){if(this._sLocale!=I){this._sLocale=I;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){f.call(this);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(I){if(!(I instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(I.getTime());};c.prototype.focusDate=function(I){var J=this.getAggregation("timesRow");if(!J.checkDateFocusable(I)){var K=a._createUniversalUTCDate(I,true);F.call(this,K);}s.call(this,I,false);return this;};c.prototype.displayDate=function(I){s.call(this,I,true);return this;};c.prototype.setItems=function(I){this.setProperty("items",I,true);I=this._getItems();var J=this.getAggregation("timesRow");J.setItems(I);var K=a._createLocalDate(this._getFocusedDate(),true);if(!J.checkDateFocusable(K)){var S=d.call(this);this._setFocusedDate(S);J.setDate(a._createLocalDate(S,true));}var N=this.getAggregation("datesRow");var O=Math.floor(I*1.5);if(O>31){O=31;}N.setDays(O);var P=this.getAggregation("monthPicker");var Q=Math.floor(I/2);if(Q>12){Q=12;}P.setMonths(Q);var R=this.getAggregation("yearPicker");var V=Math.floor(I/2);if(V>20){V=20;}R.setYears(V);n.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}};c.prototype._getItems=function(){var I=this.getItems();if(sap.ui.Device.system.phone&&I>6){return 6;}else{return I;}};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var I=this.getLocale();var J=new sap.ui.core.Locale(I);this._oLocaleData=L.getInstance(J);}return this._oLocaleData;};c.prototype.onclick=function(I){if(I.isMarked("delayedMouseEvent")){return;}if(I.target.id==this.getId()+"-cancel"){this.onsapescape(I);}};c.prototype.onmousedown=function(I){I.preventDefault();I.setMark("cancelAutoClose");};c.prototype.onsapescape=function(I){switch(this._iMode){case 0:this.fireCancel();break;case 2:j.call(this);break;case 3:m.call(this);break;}};c.prototype.onsaptabnext=function(I){var J=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),I.target)){q.sap.focus(J.getDomRef("B0"));if(!this._bPoupupMode){var K=this.getAggregation("timesRow");var N=this.getAggregation("monthPicker");var O=this.getAggregation("yearPicker");q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(N.getDomRef()){q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(O.getDomRef()){q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}I.preventDefault();}else if(I.target.id==J.getId()+"-B0"){q.sap.focus(J.getDomRef("B1"));I.preventDefault();}else if(I.target.id==J.getId()+"-B1"){q.sap.focus(J.getDomRef("B2"));I.preventDefault();}};c.prototype.onsaptabprevious=function(I){var J=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),I.target)){if(this._bPoupupMode){q.sap.focus(J.getDomRef("B2"));I.preventDefault();}}else if(I.target.id==J.getId()+"-B0"){var K=this.getAggregation("timesRow");var N=this.getAggregation("monthPicker");var O=this.getAggregation("yearPicker");switch(this._iMode){case 0:K._oItemNavigation.focusItem(K._oItemNavigation.getFocusedIndex());break;case 2:N._oItemNavigation.focusItem(N._oItemNavigation.getFocusedIndex());break;case 3:O._oItemNavigation.focusItem(O._oItemNavigation.getFocusedIndex());break;}I.preventDefault();}else if(I.target.id==J.getId()+"-B2"){q.sap.focus(J.getDomRef("B1"));I.preventDefault();}else if(I.target.id==J.getId()+"-B1"){q.sap.focus(J.getDomRef("B0"));I.preventDefault();}};c.prototype.onfocusin=function(I){if(I.target.id==this.getId()+"-end"){var J=this.getAggregation("header");var K=this.getAggregation("timesRow");var N=this.getAggregation("monthPicker");var O=this.getAggregation("yearPicker");q.sap.focus(J.getDomRef("B2"));if(!this._bPoupupMode){q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(N.getDomRef()){q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(O.getDomRef()){q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(I){if(!I.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(I.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var J=this.getAggregation("timesRow");var K=this.getAggregation("monthPicker");var N=this.getAggregation("yearPicker");switch(this._iMode){case 0:q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 3:q(N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};c.prototype._handlePrevious=function(I){var J=this._getFocusedDate();switch(this._iMode){case 0:var K=this._getItems();var S=new U(d.call(this).getTime());var N=this.getIntervalMinutes();S.setUTCMinutes(S.getUTCMinutes()-K*N);J.setUTCMinutes(J.getUTCMinutes()-K*N);this._setFocusedDate(J);_.call(this,S,true);break;case 1:var O=this.getAggregation("datesRow");var P=a._createUniversalUTCDate(O.getDate());var Q=O.getDays();if(P.getUTCDate()<=Q){P.setUTCDate(1);}else{P.setUTCDate(P.getUTCDate()-Q);}G.call(this,P);break;case 2:var R=this.getAggregation("monthPicker");if(R.getMonths()<12){R.previousPage();}else{J.setUTCFullYear(J.getUTCFullYear()-1);F.call(this,J);this._setFocusedDate(J);n.call(this);}break;case 3:var V=this.getAggregation("yearPicker");V.previousPage();break;}};c.prototype._handleNext=function(I){var J=this._getFocusedDate();switch(this._iMode){case 0:var K=this._getItems();var S=new U(d.call(this).getTime());var N=this.getIntervalMinutes();S.setUTCMinutes(S.getUTCMinutes()+K*N);J.setUTCMinutes(J.getUTCMinutes()+K*N);this._setFocusedDate(J);_.call(this,S,true);break;case 1:var O=this.getAggregation("datesRow");var P=a._createUniversalUTCDate(O.getDate());var Q=new U(P.getTime());Q.setUTCDate(1);Q.setUTCMonth(Q.getUTCMonth()+1);Q.setUTCDate(0);var R=O.getDays();if(P.getUTCDate()+R>Q.getUTCDate()){P.setUTCDate(Q.getUTCDate());}else{P.setUTCDate(P.getUTCDate()+R);}G.call(this,P);break;case 2:var V=this.getAggregation("monthPicker");if(V.getMonths()<12){V.nextPage();}else{J.setUTCFullYear(J.getUTCFullYear()+1);F.call(this,J);this._setFocusedDate(J);n.call(this);}break;case 3:var W=this.getAggregation("yearPicker");W.nextPage();break;}};c.prototype._getShowItemHeader=function(){var I=this.getItems();if(I>this._iItemsHead){return true;}else{return false;}};function _(S,I){var J=new U(this._oMaxDate.getTime());J.setUTCMonth(J.getUTCDate()-this._getItems());if(S.getTime()<this._oMinDate.getTime()){S=this._oMinDate;}else if(S.getTime()>J.getTime()){S=J;}var K=this.getAggregation("timesRow");var N=a._createLocalDate(S,true);K.setStartDate(N);this._oUTCStartDate=new U(K._getStartDate().getTime());N=a._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",N,true);n.call(this);if(I){var O=a._createLocalDate(this._getFocusedDate(),true);if(!K.checkDateFocusable(O)){this._setFocusedDate(S);K.setDate(N);}else{K.setDate(O);}}}function d(){if(!this._oUTCStartDate){var I=this.getAggregation("timesRow");I.setStartDate(a._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(I._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}function e(N){var I=this._getFocusedDate();var J=this.getAggregation("timesRow");if(!N){J.setDate(a._createLocalDate(I,true));}else{J.displayDate(a._createLocalDate(I,true));}n.call(this);}function f(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate(),true);}else{var N=new Date();this._oFocusedDate=a._createUniversalUTCDate(N,true);}}function g(){if(this._iMode==3){m.call(this,true);}else if(this._iMode==2){j.call(this,true);}var I=this._getFocusedDate();var J=this._getItems();var K=this.getAggregation("datesRow");var N=new U(I.getTime());N.setUTCDate(1);N.setUTCMonth(N.getUTCMonth()+1);N.setUTCDate(0);var O=N.getUTCDate();var P=Math.floor(J*1.5);if(P>O){P=O;}K.setDays(P);var Q=K.getSelectedDates()[0];Q.setStartDate(a._createLocalDate(I,true));if(K.getDomRef()){K.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(K);R.flush($[0],false,true);R.destroy();}this.$("contentOver").css("display","");G.call(this,I);if(this._iMode==0){var S=this.getAggregation("timesRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;o.call(this);}function h(N){this._iMode=0;var I=this.getAggregation("datesRow");I.$().css("display","none");this.$("contentOver").css("display","none");if(!N){e.call(this);var J=this.getAggregation("timesRow");q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function i(){if(this._iMode==3){m.call(this,true);}var I=this._getFocusedDate();var J=this.getAggregation("monthPicker");if(J.getDomRef()){J.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(J);R.flush($[0],false,true);R.destroy();}this.$("contentOver").css("display","");J.setMonth(I.getUTCMonth());if(this._iMode==0){var K=this.getAggregation("timesRow");q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;o.call(this);}function j(N){this._iMode=0;var I=this.getAggregation("monthPicker");I.$().css("display","none");this.$("contentOver").css("display","none");if(!N){e.call(this);var J=this.getAggregation("timesRow");q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function k(){if(this._iMode==2){j.call(this,true);}var I=this._getFocusedDate();var J=I.getUTCFullYear();var K=this._oMaxDate.getUTCFullYear();var N=this._oMinDate.getUTCFullYear();if(K-N<=20){return;}var O=this.getAggregation("header");if(J>(K-10)){J=K-9;O.setEnabledNext(false);}else{O.setEnabledNext(true);}if(J<(N+9)){J=N+10;O.setEnabledPrevious(false);}else{O.setEnabledPrevious(true);}var P=this.getAggregation("yearPicker");if(P.getDomRef()){P.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(P);R.flush($[0],false,true);R.destroy();}this.$("contentOver").css("display","");P.setYear(J);if(this._iMode==0){var Q=this.getAggregation("timesRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=3;}function m(N){this._iMode=0;var I=this.getAggregation("yearPicker");I.$().css("display","none");this.$("contentOver").css("display","none");if(!N){e.call(this);var J=this.getAggregation("timesRow");q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function n(){p.call(this);o.call(this);}function o(I){var J=new U(d.call(this).getTime());var K=this._getItems();var N=J.getUTCFullYear();var O=this._oMaxDate.getUTCFullYear();var P=this._oMinDate.getUTCFullYear();var Q=J.getUTCMonth();var R=this._oMaxDate.getUTCMonth();var S=this._oMinDate.getUTCMonth();var V=J.getUTCDate();var W=this._oMaxDate.getUTCDate();var X=this._oMinDate.getUTCDate();var Z=this.getAggregation("header");if(N<P||(N==P&&(!I||(Q<S||(Q==S&&V<=X))))){Z.setEnabledPrevious(false);}else{Z.setEnabledPrevious(true);}J.setUTCMinutes(J.getUTCMinutes()+K*this.getIntervalMinutes()-1);N=J.getUTCFullYear();Q=J.getUTCMonth();if(N>O||(N==O&&(!I||(Q>R||(Q==R&&V>=W))))){Z.setEnabledNext(false);}else{Z.setEnabledNext(true);}}function p(){var I=this.getAggregation("header");var J;var S=d.call(this);I.setTextButton0((S.getUTCDate()).toString());var K=this._getLocaleData();var N=[];var O=[];var P;var Q=false;if(this._bLongMonth||!this._bNamesLengthChecked){N=K.getMonthsStandAlone("wide");}else{Q=true;N=K.getMonthsStandAlone("abbreviated");O=K.getMonthsStandAlone("wide");}var R=S.getUTCMonth();J=N[R];if(Q){P=O[N[R]];}I.setTextButton1(J);if(Q){I.setAriaLabelButton1(P);}I.setTextButton2((S.getUTCFullYear()).toString());}function r(I,N){var J;var K=false;if(I.getTime()<this._oMinDate.getTime()){J=this._oMinDate;K=true;}else if(I.getTime()>this._oMaxDate.getTime()){J=this._oMaxDate;K=true;}else{J=I;}this._setFocusedDate(J);if(K||N){F.call(this,J);e.call(this,false);}}function s(I,N){if(I&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=I.getTime())){if(!(I instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}I=a._createUniversalUTCDate(I,true);var J=I.getUTCFullYear();if(J<1||J>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this._setFocusedDate(I);if(this.getDomRef()&&this._iMode==0){e.call(this,N);}}}function t(I){if(this._iMode!=1){g.call(this);}else{h.call(this);}}function u(I){if(this._iMode!=2){i.call(this);}else{j.call(this);}}function v(I){if(this._iMode!=3){k.call(this);}else{m.call(this);}}function w(I){this.fireSelect();}function x(I){var J=a._createUniversalUTCDate(I.getParameter("date"),true);var N=I.getParameter("notVisible");r.call(this,J,N);}function y(I){var J=new U(this._getFocusedDate().getTime());var K=I.oSource;var N=K.getSelectedDates()[0];var O=a._createUniversalUTCDate(N.getStartDate());J.setUTCDate(O.getUTCDate());J.setUTCMonth(O.getUTCMonth());J.setUTCFullYear(O.getUTCFullYear());r.call(this,J,true);h.call(this);}function z(I){var J=new U(this._getFocusedDate().getTime());var K=a._createUniversalUTCDate(I.getParameter("date"),true);var N=I.getParameter("otherMonth");if(N&&K.getUTCMonth()==J.getUTCMonth()&&K.getUTCFullYear()==J.getUTCFullYear()){G.call(this,K);}}function A(I){var J=new U(this._getFocusedDate().getTime());var K=this.getAggregation("monthPicker");var N=K.getMonth();J.setUTCMonth(N);if(N!=J.getUTCMonth()){J.setUTCDate(0);}r.call(this,J,true);j.call(this);}function B(I){var J=new U(this._getFocusedDate().getTime());var K=this.getAggregation("yearPicker");var N=K.getYear();var O=J.getUTCMonth();J.setUTCFullYear(N);if(O!=J.getUTCMonth()){J.setUTCDate(0);}r.call(this,J,true);m.call(this);}function E(){this._sInvalidateContent=undefined;var I=this.getAggregation("timesRow");I._bDateRangeChanged=true;I._bInvalidateSync=true;I.invalidate();I._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function F(I){var J=this.getAggregation("timesRow");var S=d.call(this);var K=J._oItemNavigation.getFocusedIndex();S=new U(I.getTime());S.setUTCMinutes(S.getUTCMinutes()-K*this.getIntervalMinutes());_.call(this,S,false);}function G(I){var J=this.getAggregation("datesRow");var K=new U(I.getTime());K.setUTCDate(1);K.setUTCMonth(K.getUTCMonth()+1);K.setUTCDate(0);var N=J.getDays();var S=new U(I.getTime());S.setUTCDate(1+(Math.ceil(I.getUTCDate()/N)-1)*N);if(K.getUTCDate()-S.getUTCDate()<N){S.setUTCDate(K.getUTCDate()-N+1);}J.setStartDate(a._createLocalDate(S,true));J.setDate(a._createLocalDate(I,true));}}());return c;},true);
