/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Sorter','sap/ui/model/FilterOperator','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo'],function(Q,T,C,S,F,a,B,A){"use strict";var b=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,c,s,f,P){T.call(this,m,p,c,f,P);this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(f);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==sap.ui.model.odata.CountMode.None){Q.sap.log.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==sap.ui.model.odata.CountMode.Request||P.countMode==sap.ui.model.odata.CountMode.Both)){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==sap.ui.model.odata.CountMode.Request){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){Q.sap.log.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});b.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.bInitial){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:sap.ui.model.ChangeReason.Refresh});}return this;};b.prototype.getRootContexts=function(p){if(this.bInitial){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(b._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(b._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var c=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);c.push(R);this._considerRequestGrouping(c);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){Q.sap.log.fatal("assertion failed: grand total represented by a single entry");}return r;};b.prototype.getNodeContexts=function(c,p){if(this.bInitial){return[];}var s,l,t,L,n,d;if(typeof p=="object"){s=p.startIndex;l=p.length;t=p.threshold;L=p.level;n=p.numberOfExpandedLevels;d=p.supressRequest;}else{s=arguments[1];l=arguments[2];t=arguments[3];L=arguments[4];n=arguments[5];d=arguments[6];}var e=this._getContextsForParentContext(c,s,l,t,L,n,d);return e;};b.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};b.prototype.hasAvailableNodeContexts=function(c,l){var g=this._getGroupIdFromContext(c,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return b.prototype.ContextsAvailabilityStatus.ALL;}else{return b.prototype.ContextsAvailabilityStatus.SOME;}}else{return b.prototype.ContextsAvailabilityStatus.NONE;}};b.prototype.getGroupSize=function(c,l){if(c===undefined){return 0;}var g=this._getGroupIdFromContext(c,l);return this.mFinalLength[g]?this.mLength[g]:-1;};b.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){Q.sap.log.fatal("total size of result explicitly turned off, but getter invoked");}return this.iTotalSize;};b.prototype.hasChildren=function(c,p){if(c===undefined){return false;}if(c==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return Q.inArray(this.aAggregationLevel[i-1],this.aMaxAggregationLevel)<this.aMaxAggregationLevel.length-1;};b.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};b.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};b.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};b.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};b.prototype.getProperty=function(p){if(this.bInitial){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};b.prototype.getFilterablePropertyNames=function(){if(this.bInitial){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};b.prototype.getSortablePropertyNames=function(){if(this.bInitial){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};b.prototype.getPropertyLabel=function(p){if(this.bInitial){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};b.prototype.getPropertyHeading=function(p){if(this.bInitial){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};b.prototype.getPropertyQuickInfo=function(p){if(this.bInitial){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};b.prototype.isMeasure=function(p){return Q.inArray(p,this.aMeasureName)!==-1;};b.prototype.filter=function(f,s){if(!f){f=[];}if(f instanceof sap.ui.model.Filter){f=[f];}f=this._convertDeprecatedFilterObjects(f);if(s==sap.ui.model.FilterType.Application){this.aApplicationFilter=f;}else{this.aControlFilter=f;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this._fireRefresh({reason:C.Filter});return this;};b.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};b.prototype.getGroupName=function(c,l){if(c===undefined){return"";}var g=this.aAggregationLevel[l-1],d=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),v=this.mAnalyticalInfoByProperty[g].formatter,p=c.getProperty(g),t,f,G;if(d&&this.oDimensionDetailsSet[g].textPropertyName){t=d.getTextProperty();}var s,e,h;if(t){s=d.getTextProperty().name;h=this.mAnalyticalInfoByProperty[s].formatter;e=c.getProperty(s);}if(!t){f=v?v(p):p;G=((d.getLabelText())?d.getLabelText()+': ':'')+f;}else{f=v?v(p,e):p;G=((d.getLabelText())?d.getLabelText()+': ':'')+f;var i=h?h(e,p):e;if(i){G+=' - '+i;}}return G;};b.prototype.updateAnalyticalInfo=function(c){if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.bInitial){this.aInitialAnalyticalInfo=c;return;}var p=this.oDimensionDetailsSet;this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};for(var i=0;i<c.length;i++){var d=this.oAnalyticalQueryResult.findDimensionByPropertyName(c[i].name);if(d&&(c[i].inResult==true||c[i].visible==true)){c[i].dimensionPropertyName=d.getName();var D=this.oDimensionDetailsSet[d.getName()];if(!D){D={};D.name=d.getName();D.aAttributeName=[];D.grouped=false;this.oDimensionDetailsSet[d.getName()]=D;this.aMaxAggregationLevel.push(D.name);if(c[i].grouped==true){this.aAggregationLevel.push(D.name);}}if(c[i].grouped==true){if(Q.inArray(d.getName(),this.getSortablePropertyNames())==-1){Q.sap.log.fatal("property "+d.getName()+" must be sortable in order to be used as grouped dimension");}D.grouped=true;}if(d.getName()==c[i].name){D.keyPropertyName=c[i].name;}var t=d.getTextProperty();if(t&&t.name==c[i].name){D.textPropertyName=c[i].name;}if(d.findAttributeByName(c[i].name)){D.aAttributeName.push(c[i].name);}D.analyticalInfo=c[i];}var m=this.oAnalyticalQueryResult.findMeasureByPropertyName(c[i].name);if(m&&(c[i].inResult==true||c[i].visible==true)){c[i].measurePropertyName=m.getName();var M=this.oMeasureDetailsSet[m.getName()];if(!M){M={};M.name=m.getName();this.oMeasureDetailsSet[m.getName()]=M;this.aMeasureName.push(M.name);}if(m.getRawValueProperty().name==c[i].name){M.rawValuePropertyName=c[i].name;}var f=m.getFormattedValueProperty();if(f&&f.name==c[i].name){M.formattedValuePropertyName=c[i].name;}M.analyticalInfo=c[i];}this.mAnalyticalInfoByProperty[c[i].name]=c[i];}for(var e in this.oMeasureDetailsSet){var u=this.oAnalyticalQueryResult.findMeasureByName(e).getUnitProperty();if(u){this.oMeasureDetailsSet[e].unitPropertyName=u.name;}}var g=function(o){var n=[];for(var h in o)n.push(h.name);return n.sort().join(";");};if(g(p)!=g(this.oDimensionDetailsSet)){this.iTotalSize=-1;}this.aAnalyticalInfo=c;this.resetData();this.bNeedsUpdate=false;};b.prototype.getAnalyticalInfoForColumn=function(c){return this.mAnalyticalInfoByProperty[c];};b.prototype.loadGroups=function(g){var G=[];for(var s in g){G.push(s);this._resetData(s);var c=g[s];for(var i=0;i<c.length;i++){var o=c[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,d;(d=G[++j])!==undefined;){r.push(this._getRequestId(b._requestType.groupMembersQuery,{groupId:d}));}this._considerRequestGrouping(r);}};b.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};b._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};b._artificialRootContextGroupId="artificialRootContext";b.prototype._getContextsForParentContext=function(p,s,l,t,L,n,c){if(p===undefined){return[];}if(p&&p.getPath()=="/"+b._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,L);return this._getContextsForParentGroupId(P,s,l,t,n,c);};b.prototype._getContextsForParentGroupId=function(p,s,l,t,n,c){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){Q.sap.log.fatal("invalid start index greater than total group length passed");}}if(!t){t=0;}if(!n){n=0;}if(p==null){if(n>0){Q.sap.log.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){Q.sap.log.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var d=[],L,g,G,m;var e=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[e]){this.aMultiUnitLoadFactor[e]=1;}var f=n>0&&p!=null;if(f){var M=this._getGroupIdLevel(p);var h=M+n;var D=true;if(!c){G=this._calculateRequiredGroupExpansion(p,h,s,l+t);D=G.groupId_Missing==null;D=D||G.groupId_Missing.length<p.length||G.groupId_Missing.substring(0,p.length)!=p;}if(D){d=this._getLoadedContextsForGroup(p,s,l);}else{m=l+t;}L=!D;m=Math.ceil(m*this.aMultiUnitLoadFactor[e]);}else{d=this._getLoadedContextsForGroup(p,s,l,c);L=false;if(!c){g=this._calculateRequiredGroupSection(p,s,l,t,d);var P=g.length>0&&l<g.length;L=(d.length!=l&&!(this.mFinalLength[p]&&d.length>=this.mLength[p]-s))||P;g.length=Math.ceil(g.length*this.aMultiUnitLoadFactor[e]);}}if(!L){this._cleanupGroupingForCompletedRequest(this._getRequestId(b._requestType.groupMembersQuery,{groupId:p}));}var E=false;if(this.oModel.getServiceMetadata()){if(L){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(b._requestType.totalSizeQuery));E=true;var k;if(this.bUseBatchRequests){if(f){k=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,r;(r=k[++i])!==undefined;){if(this._isRequestPending(r)){E=false;break;}}if(E){this.aBatchRequestQueue.push([b._requestType.groupMembersAutoExpansionQuery,p,G,m,n]);}}else{E=!this._isRequestPending(this._getRequestId(b._requestType.groupMembersQuery,{groupId:p}));if(E){this.aBatchRequestQueue.push([b._requestType.groupMembersQuery,p,g.startIndex,g.length]);k=[this._getRequestId(b._requestType.groupMembersQuery,{groupId:p})];}}if(E&&N){k.push(this._getRequestId(b._requestType.totalSizeQuery));this._considerRequestGrouping(k);this.aBatchRequestQueue.push([b._requestType.totalSizeQuery]);}if(E){if(p==null){this._abortAllPendingRequests();}Q.sap.delayedCall(0,this,b.prototype._processRequestQueue);}}else{var o;if(f){k=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,q;(q=k[++j])!==undefined;){if(this._isRequestPending(q)){E=false;break;}}if(E){o=this._prepareGroupMembersAutoExpansionQueryRequest(b._requestType.groupMembersAutoExpansionQuery,p,G,m,n);}}else{E=!this._isRequestPending(this._getRequestId(b._requestType.groupMembersQuery,{groupId:p}));if(E){o=this._prepareGroupMembersQueryRequest(b._requestType.groupMembersQuery,p,g.startIndex,g.length);k=[o.sRequestId];}}if(E){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(o);if(N&&!o.bIsFlatListRequest){k.push(this._getRequestId(b._requestType.totalSizeQuery));this._considerRequestGrouping(k);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(b._requestType.totalSizeQuery));}}}}}return d;};b.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var f=false;var i,o,c;for(i=-1;(c=r[++i])!==undefined;){if(c[0]==b._requestType.groupMembersQuery){o=b.prototype._prepareGroupMembersQueryRequest.apply(this,c);f=f||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(c=r[++i])!==undefined;){o=null;switch(c[0]){case b._requestType.groupMembersQuery:continue;case b._requestType.totalSizeQuery:if(!f){o=b.prototype._prepareTotalSizeQueryRequest.apply(this,c);R.push(o);}break;case b._requestType.groupMembersAutoExpansionQuery:o=b.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,c);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case b._requestType.reloadMeasuresQuery:{var d=c[1];for(var k=-1,e;(e=d[++k])!==undefined;){R.push(e);}break;}default:Q.sap.log.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};b.prototype._prepareGroupMembersQueryRequest=function(r,g,s,L){var G=[];var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var c=0,d=-1;if(g){G=this._getGroupIdComponents(g);c=d=G.length;var u=0;for(var j=0,e=0;j<c;e++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[e]].grouped==false){++u;}else{++j;}}c=d=c+u;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[d]].grouped==false){if(++d==this.aMaxAggregationLevel.length){break;}}}}var I=d>=this.aMaxAggregationLevel.length-1;var f=this.aMaxAggregationLevel.slice(0,d+1);o.setAggregationLevel(f);for(var i=0;i<f.length;i++){var D=this.oDimensionDetailsSet[f[i]];var h=(D.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(D.name,true,h,D.aAttributeName);if(D.grouped){o.getSortExpression().addSorter(f[i],a.SortOrder.Ascending);}}var p=o.getFilterExpression();p.clear();if(this.aApplicationFilter){p.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){p.addUI5FilterConditions(this.aControlFilter);}if(c>=1){for(var k=0,l=G.length;k<l;k++){p.removeConditions(this.aAggregationLevel[k]);p.addCondition(this.aAggregationLevel[k],F.EQ,G[k]);}}var q;var t;var v;var M;var w=[];if(g!=null||this.bProvideGrandTotals){o.setMeasures(this.aMeasureName);for(var x in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[x];if(!I&&this.mAnalyticalInfoByProperty[x].total==false){q=false;t=false;v=false;}else{q=(M.rawValuePropertyName!=undefined);t=(M.formattedValuePropertyName!=undefined);v=(M.unitPropertyName!=undefined);if(v){if(Q.inArray(M.unitPropertyName,w)==-1){w.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,q,t,v);}for(var n in f){var y;if((y=Q.inArray(f[n],w))!=-1){w.splice(y,1);}}}var z=o.getSortExpression();for(var m=0;m<this.aSorter.length;m++){if(this.aSorter[m]){z.addSorter(this.aSorter[m].sPath,this.aSorter[m].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var K=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){o.setResultPageBoundaries(K.iServiceKeyIndex+1,K.iServiceKeyIndex+L);}o.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(b._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:o,sGroupId:g,aSelectedUnitPropertyName:w,aAggregationLevel:f,bIsFlatListRequest:I&&c==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:L,oKeyIndexMapping:K};};b.prototype._prepareTotalSizeQueryRequest=function(r){var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.setAggregationLevel(this.aMaxAggregationLevel);o.setMeasures([]);var f=o.getFilterExpression();f.clear();if(this.aApplicationFilter){f.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){f.addUI5FilterConditions(this.aControlFilter);}o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(b._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};b.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,G,L,n){var t=this;var p=function(G,e){var m=[];if(G.groupId_Missing==null){Q.sap.log.fatal("missing group Id not present");return m;}var f=t._getGroupIdComponents(G.groupId_Missing);var h=f.length;if(h>e){Q.sap.log.fatal("the given group ID is too deep for requested level for auto expansion");return m;}var k=[];for(var i=0;i<h;i++){var l=t.aAggregationLevel[i];var V=f[i];var E=t._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new sap.ui.model.Filter(l,E,V);}var H=null;if(G.startIndex_Missing>0){var I=t._getKey(G.groupId_Missing,G.startIndex_Missing-1);var J=t.oModel.getObject("/"+I);var K=t.aAggregationLevel[h];var M=J[K];H=new sap.ui.model.Filter(K,t._getFilterOperatorMatchingPropertySortOrder(K,false),M);}for(var o=0;o<e;o++){var N=[];var O=Math.min(h,o+1);for(var P=0;P<O;P++){var U=[];var W=Math.min(h,P+1);var X=G.startIndex_Missing>0;for(var Y=0;Y<W;Y++){var Z=new sap.ui.model.Filter("x",sap.ui.model.FilterOperator.EQ,"x");Z=Q.extend(true,Z,k[Y]);if(W>1&&Y<W-1){Z.sOperator=sap.ui.model.FilterOperator.EQ;}if(Y==h-1&&o>h-1&&!X){if(Z.sOperator==sap.ui.model.FilterOperator.GT){Z.sOperator=sap.ui.model.FilterOperator.GE;}else{Z.sOperator=sap.ui.model.FilterOperator.LE;}}U.push(Z);}if(U.length>0){N.push(new sap.ui.model.Filter(U,true));if(o>h-1&&P==h-1&&X){var $=[];for(var j=0;j<U.length;j++){var _=new sap.ui.model.Filter("x",sap.ui.model.FilterOperator.EQ,"x");_=Q.extend(true,_,U[j]);$.push(_);}$[h-1].sOperator=sap.ui.model.FilterOperator.EQ;$.push(H);N.push(new sap.ui.model.Filter($,true));break;}}}if(N.length>0){m[o]=new sap.ui.model.Filter(N,false);}else{m[o]=null;}}return m;};var c=function(r,g,o,E,q,L,H,U){var I=new a.QueryResultRequest(t.oAnalyticalQueryResult);I.setResourcePath(t._getResourcePath());I.getSortExpression().clear();var J=0,K=-1;J=K=o-1;var M=0;for(var i=0,P=0;i<J;P++){if(t.oDimensionDetailsSet[t.aMaxAggregationLevel[P]].grouped==false){++M;}else{++i;}}J=K=J+M;if(t.aMaxAggregationLevel.length>0){while(t.oDimensionDetailsSet[t.aMaxAggregationLevel[K]].grouped==false){if(++K==t.aMaxAggregationLevel.length){break;}}}var N=K>=t.aMaxAggregationLevel.length-1;var O=t.aMaxAggregationLevel.slice(0,K+1);I.setAggregationLevel(O);for(var l=0;l<O.length;l++){var V=t.oDimensionDetailsSet[O[l]];var W=(V.textPropertyName!=undefined);I.includeDimensionKeyTextAttributes(V.name,true,W,V.aAttributeName);if(V.grouped){I.getSortExpression().addSorter(O[l],a.SortOrder.Ascending);}}var X=I.getFilterExpression();X.clear();if(t.aApplicationFilter){X.addUI5FilterConditions(t.aApplicationFilter);}if(t.aControlFilter){X.addUI5FilterConditions(t.aControlFilter);}if(E){X.addUI5FilterConditions([E]);}var Y;var Z;var $;var _;var a1=[];I.setMeasures(t.aMeasureName);for(var b1 in t.oMeasureDetailsSet){_=t.oMeasureDetailsSet[b1];if(!N&&t.mAnalyticalInfoByProperty[b1].total==false){Y=false;Z=false;$=false;}else{Y=(_.rawValuePropertyName!=undefined);Z=(_.formattedValuePropertyName!=undefined);$=(_.unitPropertyName!=undefined);if($){if(Q.inArray(_.unitPropertyName,a1)==-1){a1.push(_.unitPropertyName);}}}I.includeMeasureRawFormattedValueUnit(_.name,Y,Z,$);}for(var j in O){var c1;if((c1=Q.inArray(O[j],a1))!=-1){a1.splice(c1,1);}}var d1=I.getSortExpression();for(var k=0;k<t.aSorter.length;k++){if(t.aSorter[k]){d1.addSorter(t.aSorter[k].sPath,t.aSorter[k].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var e1=q;if(!U){e1=0;}else{var f1=0;for(var g1 in t.mServiceKey){if(g1.split("/").length===o+1){f1+=t.mServiceKey[g1].length;}}e1=Math.max(e1,f1);}if(!t.bNoPaging){I.setResultPageBoundaries(e1+1,L);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:I,iLevel:o,aSelectedUnitPropertyName:a1,aAggregationLevel:O,bIsFlatListRequest:N,bIsLeafGroupsRequest:N,iStartIndex:q,iLength:L,bAvoidLengthUpdate:H};};var d=[];var R=[];if(!G){Q.sap.log.fatal("no first missing group member specified");}var e=this._getGroupIdLevel(g)+n+1;var f=t._getGroupIdComponents(G.groupId_Missing);var h=f.length;var m=p(G,e);var s;for(var o=1;o<=e;o++){var q;if(o>=h+2){q=0;s=undefined;}else if(o==h+1){q=G.startIndex_Missing;s=G.groupId_Missing;}else if(h>0){if(o==h){s=G.groupId_Missing;}else{s=this._getGroupIdAncestors(G.groupId_Missing,-(h-o))[0];}var u=this._getGroupIdAncestors(G.groupId_Missing,-(h-o+1))[0];if(!u){Q.sap.log.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+o);}q=this._findKeyIndex(u,this.mEntityKey[s]);if(q==-1){Q.sap.log.fatal("failed to determine position of value "+s+" in group "+u);}s=u;q++;}var v=L>o?Math.ceil((L-o)/(e-o+1)):L;var w=m[o-1];if(this.bUseAcceleratedAutoExpand){var x=c(b._requestType.levelMembersQuery,g,o,w,q,v,false,w==null?true:false);x.sGroupId_Missing_AtLevel=s;x.sRequestId=this._getRequestId(b._requestType.levelMembersQuery,{groupId:g,level:o});d.push(x);R.push(x.sRequestId);}else if(w&&w.aFilters.length>0){if(!w._bMultiFilter||w.bAnd){Q.sap.log.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<w.aFilters.length;i++){var y=w.aFilters[i];var z=c(b._requestType.levelMembersQuery,g,o,y,q,v,false,w==null?true:false);z.sGroupId_Missing_AtLevel=s;z.sRequestId=this._getRequestId(b._requestType.levelMembersQuery,{groupId:g,level:o,tupleIndex:i});d.push(z);R.push(z.sRequestId);}}else{var D=c(b._requestType.levelMembersQuery,g,o,null,q,v,false,w==null?true:false);D.sGroupId_Missing_AtLevel=s;D.sRequestId=this._getRequestId(b._requestType.levelMembersQuery,{groupId:g,level:o});d.push(D);R.push(D.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:d,sGroupId:g,iLength:L};};b.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var c=g.aAggregationLevel;o.setAggregationLevel(c);var I=g.bIsLeafGroupsRequest;var f=o.getFilterExpression();f.clear();if(this.aApplicationFilter){f.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){f.addUI5FilterConditions(this.aControlFilter);}var d=[];for(var i=0;i<c.length;i++){var e=new sap.ui.model.Filter(c[i],sap.ui.model.FilterOperator.EQ,m.oEntry[c[i]]);d.push(e);}f.addUI5FilterConditions(d);var h;var k;var l;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var n in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[n];if(Q.inArray(M.name,m.aReloadMeasurePropertyName)==-1){continue;}if(!I&&this.mAnalyticalInfoByProperty[n].total==false){h=false;k=false;l=false;}else{h=(M.rawValuePropertyName!=undefined);k=(M.formattedValuePropertyName!=undefined);l=(M.unitPropertyName!=undefined);if(l){if(Q.inArray(M.unitPropertyName,s)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,h,k,l);}for(var j in c){var p;if((p=Q.inArray(c[j],s))!=-1){s.splice(p,1);}}return{iRequestType:r,sRequestId:this._getRequestId(b._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:c,oMultiUnitRepresentative:m};};b.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(b._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};b.prototype._getQueryODataRequestOptions=function(o,p){p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){Q.sap.log.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var f=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var c=o.getURIQueryOptionValue("$skip");var t=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(this.mParameters&&this.mParameters["filter"]){f+="and ("+this.mParameters["filter"]+")";}var P=[];if(s!==null){P.push("$select="+s);}if(f!==null){P.push("$filter="+f);}if(O!==null){P.push("$orderby="+O);}if(c!==null){P.push("$skip="+c);}if(t!==null){P.push("$top="+t);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(var i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};b.prototype._executeBatchRequest=function(r){var c=this.iAnalyticalInfoVersionNumber;var t=this;var d=[],e=[];function f(){t.fireDataReceived();}var R=new B();function s(D,j){R.success(j);}function g(D,j){R.error(j||D);}for(var i=-1,o;(o=r[++i])!==undefined;){var h=o.oAnalyticalQueryRequest,G=o.sGroupId;if(h.getURIQueryOptionValue("$select")==null){this.fireDataRequested();G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),b._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(f);this.bArtificalRootContext=true;continue;}var p=h.getURIToQueryResultEntries();if(!this.oContext&&p[0]!=="/"){p="/"+p;}if(!this._isRequestPending(o.sRequestId)){this._registerNewRequest(o.sRequestId);if(this.iModelVersion===A.V1){d.push(this.oModel.createBatchOperation(p.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var u=this._getQueryODataRequestOptions(h,{encode:true});if(this.sCustomParams){u.push(this.sCustomParams);}var l=this.oModel.read(p.replace(/\ /g,"%20"),{success:s,error:g,context:this.oContext,urlParameters:u});d.push(l);}e.push(o);}}if(d.length>0){Q.sap.log.debug("AnalyticalBinding: executing batch request with "+e.length+" operations");var m;var n=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(d);m=this.oModel.submitBatch(q,E,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{m={abort:function(){for(var j=0;j<d.length;j++){d[j].abort();}}};R.setup({executedRequests:e,binding:this,success:q,error:E});}this._registerNewRequestHandle(n,m);}function q(D,v){t._deregisterHandleOfCompletedRequest(n);if(e.length!=D.__batchResponses.length){Q.sap.log.fatal("assertion failed: received "+D.__batchResponses.length+" responses for "+e.length+" read operations in the batch request");}if(c!=t.iAnalyticalInfoVersionNumber){for(var j=-1,w;(w=e[++j].sRequestId)!==undefined;){t._deregisterCompletedRequest(w);t._cleanupGroupingForCompletedRequest(w);}return;}for(var k=0;k<D.__batchResponses.length;k++){if(D.__batchResponses[k].data!=undefined){switch(e[k].iRequestType){case b._requestType.groupMembersQuery:t._processGroupMembersQueryResponse(e[k],D.__batchResponses[k].data);break;case b._requestType.totalSizeQuery:t._processTotalSizeQueryResponse(e[k],D.__batchResponses[k].data);break;case b._requestType.levelMembersQuery:t._processLevelMembersQueryResponse(e[k],D.__batchResponses[k].data);break;case b._requestType.reloadMeasuresQuery:t._processReloadMeasurePropertiesQueryResponse(e[k],D.__batchResponses[k].data);break;default:Q.sap.log.fatal("invalid request type "+e[k].iRequestType);continue;}}t._deregisterCompletedRequest(e[k].sRequestId);t._cleanupGroupingForCompletedRequest(e[k].sRequestId);}var O=true;var x;t.fireDataReceived();var V={};if(t.iModelVersion===A.V1){x=t.oModel._getBatchErrors(D);if(x.length>0){O=false;V=t.oModel._handleError(x[0]);}t.oModel.fireRequestCompleted({url:v.requestUri,type:"POST",async:true,info:"",infoObject:{},success:O,errorobject:O?{}:V});}if(O){t.oModel.checkUpdate();}}function E(k){t._deregisterHandleOfCompletedRequest(n);for(var j=-1,v;(v=e[++j])!==undefined;){t._deregisterCompletedRequest(v.sRequestId);t._cleanupGroupingForCompletedRequest(v.sRequestId);}if(c!=t.iAnalyticalInfoVersionNumber){return;}var V=k;if(t.iModelVersion===A.V1){V=t.oModel._handleError(k);}t.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:V});t.oModel.fireRequestFailed(V);t.fireDataReceived();}};b.prototype._executeQueryRequest=function(r){if(r.iRequestType==b._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var c=this.iAnalyticalInfoVersionNumber;var d=r.oAnalyticalQueryRequest,g=r.sGroupId;var p=d.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(d);if(!P){return;}var t=this;if(d.getURIQueryOptionValue("$select")==null){this.fireDataRequested();g=null;this.mServiceLength[g]=this.mLength[g]=1;this.mServiceFinalLength[g]=true;this._setServiceKey(this._getKeyIndexMapping(g,0),b._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(t._cleanupGroupingForCompletedRequest(r.sRequestId)){t.fireDataReceived();}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}Q.sap.log.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,s,E,false,u,f);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var e=this.oModel.read(p,{success:s,error:E,context:this.oContext,urlParameters:P});t._registerNewRequestHandle(R,e);}function s(D){t._deregisterHandleOfCompletedRequest(R);if(c!=t.iAnalyticalInfoVersionNumber){t._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case b._requestType.groupMembersQuery:t._processGroupMembersQueryResponse(r,D);break;case b._requestType.totalSizeQuery:t._processTotalSizeQueryResponse(r,D);break;case b._requestType.levelMembersQuery:t._processLevelMembersQueryResponse(r,D);break;case b._requestType.reloadMeasuresQuery:t._processReloadMeasurePropertiesQueryResponse(r,D);break;default:Q.sap.log.fatal("invalid request type "+r.iRequestType);break;}t._deregisterCompletedRequest(r.sRequestId);if(t.iModelVersion===A.V2){f();}}function f(){if(c!=t.iAnalyticalInfoVersionNumber){return;}if(t._cleanupGroupingForCompletedRequest(r.sRequestId)){t.fireDataReceived();}}function E(D){t._deregisterHandleOfCompletedRequest(R);t._deregisterCompletedRequest(r.sRequestId);t._cleanupGroupingForCompletedRequest(r.sRequestId);if(c!=t.iAnalyticalInfoVersionNumber){return;}t.fireDataReceived();}function u(e){t._registerNewRequestHandle(R,e);}};b.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};b.prototype._processGroupMembersQueryResponse=function(R,d){var G=R.sGroupId,s=R.aSelectedUnitPropertyName,c=R.aAggregationLevel,e=R.oKeyIndexMapping.iIndex,f=R.oKeyIndexMapping.iServiceKeyIndex,L=R.iLength,K=R.oKeyIndexMapping,n=G==null?0:this._getGroupIdLevel(G)+1;var u=(s.length>0);var P,D;var t;var v=0;var w;var x,y=[];var O=d.results.length;var z=this._getServiceKeys(G,K.iIndex-1);P=undefined;if(z&&z.length>0){for(var i=0,E=z.length;i<E;i++){d.results[i-E]=this.oModel.getObject("/"+z[i]);}var H=d.results[-z.length];P="";for(var j=0;j<c.length;j++){P+=H[c[j]]+"|";}}w=z&&z.length==1;for(var h=0;h<O;h++){var I=d.results[h];if(u){D="";for(var g=0;g<c.length;g++){D+=I[c[g]]+"|";}if(P==D){if(t===undefined){if(h==0){t=-z.length;K.iServiceKeyIndex-=z.length-1;}else{t=h-1;}}var J=-1,M=d.results[h-1];for(var k=0;k<s.length;k++){if(M[s[k]]!=I[s[k]]){J=k;break;}}if(J==-1){Q.sap.log.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h);}}if((P!=D||h==O-1)&&t!==undefined){var N=[];for(var l=t;l<h;l++){N.push(d.results[l]);}if(P==D){N.push(d.results[h]);}var U=[];for(var m=0;m<s.length;m++){var V=s[m];for(var o=1;o<N.length;o++){if(N[o-1][V]!=N[o][V]){U.push(V);break;}}}var W=this._createMultiUnitRepresentativeEntry(G,d.results[t],s,U,R.bIsFlatListRequest);if(W.aReloadMeasurePropertyName.length>0){x=this._prepareReloadMeasurePropertiesQueryRequest(b._requestType.reloadMeasuresQuery,R,W);if(x.oAnalyticalQueryRequest&&x.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){y.push(x);}}var X=this._setAdjacentMultiUnitKeys(K,W,N);var Y;if(W.bIsNewEntry){Y=N.length-1;}else{Y=X;}if(w){w=false;}if(Y<0){Q.sap.log.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}v+=Y;var Z=this.oModel._getKey(W.oEntry);var $=this.oModel.getContext('/'+Z);this._getGroupIdFromContext($,n);this.mEntityKey[a1]=Z;t=undefined;if(P!=D){w=this._setServiceKey(K,this.oModel._getKey(I));}}else if(P!=D){w=this._setServiceKey(K,this.oModel._getKey(I));}P=D;}else{this._setServiceKey(K,this.oModel._getKey(I));}if(!R.bIsLeafGroupsRequest){var _=this._getKey(G,K.iIndex-1),a1=this._getGroupIdFromContext(this.oModel.getContext('/'+_),n);this.mEntityKey[a1]=_;}}var b1=[];if(this.bReloadSingleUnitMeasures&&y.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([b._requestType.reloadMeasuresQuery,y]);Q.sap.delayedCall(0,this,b.prototype._processRequestQueue);}else{for(var q=0;q<y.length;q++){var c1=y[q];this._executeQueryRequest(c1);}}for(var p=0;p<y.length;p++){var d1=y[p];b1.push(d1.sRequestId);}this._considerRequestGrouping(b1);}if(z&&z.length>0){for(var r=0,e1=z.length;r<e1;r++){delete d.results[r-e1];}}if(u){v+=this._mergeLoadedKeyIndexWithSubsequentIndexes(K,c,s,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var f1=false;if(d.__count){this.mServiceLength[G]=parseInt(d.__count,10);this.mLength[G]=this.mServiceLength[G]-v;this.mFinalLength[G]=true;if(R.bIsFlatListRequest){this.iTotalSize=d.__count;}f1=true;}if(this.mServiceLength[G]<f+O){this.mServiceLength[G]=f+O;this.mLength[G]=e+O-v;this.mFinalLength[G]=false;}if(O<L||L===undefined){this.mServiceLength[G]=f+O;this.mLength[G]=e+K.iIndex-e;this.mFinalLength[G]=true;f1=true;}if(O==0){this.mLength[G]=this.mServiceLength[G]=0;this.mFinalLength[G]=true;f1=true;}if(!f1&&this.mLength[G]!==undefined&&v>0){this.mLength[G]-=v;}}this.bNeedsUpdate=true;if(v>0){this.aMultiUnitLoadFactor[c.length]=d.results.length/(d.results.length-v);if(this.aMultiUnitLoadFactor[c.length]<1.5){this.aMultiUnitLoadFactor[c.length]=2;}}Q.sap.log.info("MultiUnit Situation in Group ("+G+"), discarded: "+v+", load-factor is now: "+this.aMultiUnitLoadFactor[c.length]);};b.prototype._processTotalSizeQueryResponse=function(r,d){if(d.__count==undefined){Q.sap.log.fatal("missing entity count in query result");return;}this.iTotalSize=d.__count;};b.prototype._processLevelMembersQueryResponse=function(r,d){var t=this;var p,P;var c=function(e,I){var g={iRequestType:b._requestType.groupMembersQuery,sRequestId:t._getRequestId(b._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:e?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(e&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=g.sGroupId||t._getKeys(g.sGroupId)===undefined)){var s=t._getParentGroupId(g.sGroupId);var f=t._findKeyIndex(s,t.mEntityKey[g.sGroupId]);if(f==-1){Q.sap.log.fatal("assertion failed: failed to determine position of "+g.sGroupId+" in group "+s);}if(f>0&&t._getKey(s,f-1)!==undefined){var h=t._getKey(s,f-1);var j=t._getGroupIdFromContext(t.oModel.getContext('/'+h),t._getGroupIdLevel(g.sGroupId));t.mFinalLength[j]=true;g.iStartIndex=0;}}if(I){g.iLength=P.length;}g.oKeyIndexMapping=t._getKeyIndexMapping(g.sGroupId,g.iStartIndex);var k=Q.extend(true,{},d);k.results=P;t._processGroupMembersQueryResponse(g,k);};if(d.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(d.results[0])),r.iLevel-1);P=[];var e=true;for(var i=0;i<d.results.length;i++){var E=d.results[i];var o=this.oModel.getContext("/"+this.oModel._getKey(d.results[i]));var s=this._getGroupIdFromContext(o,r.iLevel-1);if(p==s){P.push(E);if(i<d.results.length-1){continue;}}c(e,d.results.length==r.iLength&&i==d.results.length-1);e=false;if(p!=s){P=[E];}p=s;}if(d.results.length>1&&P.length==1){c(e,d.results.length==r.iLength);}};b.prototype._processReloadMeasurePropertiesQueryResponse=function(r,d){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(d.results.length!=1){Q.sap.log.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=d.results[0];var o=this.oModel.getObject("/"+M);if(!o){Q.sap.log.fatal("assertion failed: no entity found with key "+M);return;}var c=m.aReloadMeasurePropertyName;for(var i=0;i<c.length;i++){o[c[i]]=R[c[i]];}};b.prototype._getLoadedContextsForGroup=function(g,s,l,f){var c=[],o,k=this._getKeys(g),K;if(!k){return c;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(f){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);c.push(o);i++;K=k(i);}return c;}for(var i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);c.push(o);}return c;};b.prototype._calculateRequiredGroupSection=function(g,s,l,t,c){var d,e,p,P,r,o={},k=this._getKeys(g),K;e=s;d=0;if(!k){P=s;p=s+l;}else{for(var i=s-1;i>=Math.max(s-t,0);i--){K=k(i);if(!K){P=i+1;break;}}for(var j=s+l;j<s+l+t;j++){K=k(j);if(!K){p=j;break;}}}r=s-P;if(P&&s>t&&r<t){if(c.length!==l){e=s-t;}else{e=P-t;}d=t;}e=Math.max(e,0);if(e===s){e+=c.length;}if(c.length!==l){d+=l-c.length;}r=p-s-l;if(r==0){d+=t;}if(p&&r<t&&r>0){if(e>s){e=p;d+=t;}}if(this.mFinalLength[g]&&this.mLength[g]<(d+e)){d=this.mLength[g]-e;}o.startIndex=e;o.length=d;return o;};b.prototype._calculateRequiredGroupExpansion=function(g,c,s,l){var n={groupId_Missing:null,length_Missing:0};var t=this;var d=function(g,c,s,l){var L=t._getGroupIdLevel(g);if(L==c){var m=t._getLoadedContextsForGroup(g,s,l);var o=s+m.length-1;if(m.length>=l){return n;}else if(t.mFinalLength[g]){if(m.length>=t.mLength[g]){return{groupId_Missing:null,length_Missing:l-m.length};}else{return{groupId_Missing:g,startIndex_Missing:o+1,length_Missing:l-m.length};}}else{return{groupId_Missing:g,startIndex_Missing:o+1,length_Missing:l-m.length};}}var q=t._getLoadedContextsForGroup(g,s,l);var e=l,r=s+q.length-1;for(var i=-1,u;(u=q[++i])!==undefined;){e--;var G=d(t._getGroupIdFromContext(u,L+1),c,0,e);if(G.groupId_Missing==null){if(G.length_Missing==0){return G;}else{e=G.length_Missing;}}else{return G;}if(e==0){break;}}if(t.mFinalLength[g]||e==0){return{groupId_Missing:null,length_Missing:e};}else{return{groupId_Missing:g,startIndex_Missing:r+1,length_Missing:e};}};var L=this._getGroupIdLevel(g);if(L==c+1){g=this._getParentGroupId(g);--L;}if(g==null||L>c){return n;}var e=l,f=s;while(g!=null){var G=d(g,c,f,e);if(G.groupId_Missing!=null){return G;}else if(G.length_Missing==0){return G;}else{var h=false;while(!h){var p=this._getParentGroupId(g);if(p==null){g=p;--L;break;}var j=this.mEntityKey[g];if(!j){return n;}var k=this._findKeyIndex(p,j);if(k==-1){return n;}if(k==this._getKeyCount(p)-1){if(this.mFinalLength[p]){g=p;--L;continue;}else{return{groupId_Missing:p,startIndex_Missing:k+1,length_Missing:e};}}else{j=this._getKey(p,k+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+j),L);h=true;}}f=0;e=G.length_Missing;}}return{groupId_Missing:null,length_Missing:e};};b.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};b.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};b.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending;}}return null;};b.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,w){var f;switch(this._getEffectiveSortOrder(p)){case a.SortOrder.Ascending:if(w){f=sap.ui.model.FilterOperator.GE;}else{f=sap.ui.model.FilterOperator.GT;}break;case a.SortOrder.Descending:if(w){f=sap.ui.model.FilterOperator.LE;}else{f=sap.ui.model.FilterOperator.LT;}break;default:f=sap.ui.model.FilterOperator.GT;}return f;};b.prototype._convertDeprecatedFilterObjects=function(f){if(!f){return f;}for(var i=0,l=f.length;i<l;i++){if(sap.ui.model.odata&&typeof sap.ui.model.odata.Filter==="function"&&f[i]instanceof sap.ui.model.odata.Filter){f[i]=f[i].convert();}}return f;};b.prototype._getGroupIdFromContext=function(c,l){if(!c){return null;}var g="/";var d=null;if(l>this.aAggregationLevel.length){Q.sap.log.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){d=c.getProperty(this.aAggregationLevel[i]);if(d!=null){g+=encodeURIComponent(d)+"/";}else{g+="@/";}}return g;};b.prototype._getGroupIdLevel=function(g){if(g==null){Q.sap.log.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};b.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var G=g.split("/");var d=[];for(var i=1;i<G.length-1;i++){if(G[i]=="@"){d[i-1]=null;}else{d[i-1]=decodeURIComponent(G[i]);}}return d;};b.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){Q.sap.log.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var G=g.split("/");var c=[],s="";var f=0,t=G.length-3;if(n>0){if(n-1>t){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{t=n-1;}}else if(-(n+1)>t){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{f=t+1+n;for(var i=0;i<f;i++){s+=G[i]+"/";}}for(var j=f;j<=t;j++){s+=G[j]+"/";c.push(s);}return c;};b.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};b.prototype._removeDuplicatesFromStringArray=function(c){var t={};for(var i=0;i<c.length;i++){t[c[i]]=true;}var u=[];for(var s in t){u.push(s);}return u;};b.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};b.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){Q.sap.log.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};b.prototype._deregisterHandleOfCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequestHandle)){Q.sap.log.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){Q.sap.log.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};b.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};b.prototype._getRequestId=function(r,p){switch(r){case b._requestType.groupMembersQuery:if(p.groupId===undefined){Q.sap.log.fatal("missing group ID");}return b._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case b._requestType.levelMembersQuery:if(p.level===undefined){Q.sap.log.fatal("missing level");}if(p.groupId===undefined){Q.sap.log.fatal("missing groupId");}return""+b._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case b._requestType.totalSizeQuery:return b._requestType.totalSizeQuery;case b._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){Q.sap.log.fatal("missing multi unit entry key");}return b._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:Q.sap.log.fatal("invalid request type "+r);return-1;}};b.prototype._registerNewRequest=function(r){if(r==undefined||r==""){Q.sap.log.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};b.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};b.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};b.prototype._deregisterCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequests)){Q.sap.log.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){Q.sap.log.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};b.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};b.prototype._getKeyIndexMapping=function(g,s){var k=this.mKeyIndex[g];var c=this.mServiceKey[g];var i=s;if(k!==undefined){var l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}var L;if(l==0){L=0;}else{if(k[l]>=0){L=k[l];}else if(k[l+1]===undefined){L=k[l]=="ZERO"?0:-k[l];while(c[L+1]!==undefined){++L;}}else{L=Math.abs(k[l+1])-1;}if(c[L]===undefined){Q.sap.log.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+L);}}var d=s-l;i=L+d;}var K={sGroupId:g,iIndex:s,iServiceKeyIndex:i};return K;};b.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};b.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};b.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var t=this;return function(i){return t._getKey(g,i);};};b.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],c=k[I];if(c===undefined){return undefined;}if(c>=0){return[s[c]];}var G=[];if(k[I+1]===undefined){c=k[I]=="ZERO"?0:-k[I];while(s[c]!==undefined){G.push(s[c++]);}}else{c=k[I]=="ZERO"?0:-k[I];for(var i=c,n=Math.abs(k[I+1]);i<n;i++){G.push(s[i]);}}return G;};b.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};b.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};b.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};b.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};b.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,c,s,I){var K=this.mKeyIndex[k.sGroupId],d=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],D=0,n=k.iServiceKeyIndex,e=k.iIndex;var M,o;if(K===undefined){return D;}var N=false;var p=d[n-1],f=d[n];if(f===undefined){return D;}if(p===undefined){Q.sap.log.fatal("assertion failed: missing expected entry before given key index");return D;}var P=this.oModel.getObject("/"+p);var g=this.oModel.getObject("/"+f);var h="",j="";for(var i=0;i<c.length;i++){h+=P[c[i]]+"|";j+=g[c[i]]+"|";}N=h==j;var l=e;if(l>=this.mLength[k.sGroupId]){Q.sap.log.fatal("assertion failed: service key exists,but no corresponding key index found");return D;}while(K[l]===undefined||Math.abs(K[l])<n){++l;}if(N){if(Math.abs(K[l])==n&&K[l]<0){if(l>e){if(K[e-1]<0){m[l]=undefined;K.splice(e,l-e+1);m.splice(e,l-e+1);}else{K[e-1]=-K[e-1];m[e-1]=m[l];m[l]=undefined;K.splice(e,l-e+1);m.splice(e,l-e+1);D=1;}}}else if(Math.abs(K[l])>n){var q=l-1;if(K[q]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[q]=-K[q];m[q]=o;if(q>e){K.splice(e,q-e);m.splice(e,q-e);}if(M.bIsNewEntry){D=1;}else{D=0;}}else if(K[e-1]<0){if(l>e){m[q]=undefined;K.splice(e,q-e+1);m.splice(e,q-e+1);}}else{K[e-1]=-K[e-1];m[e-1]=m[q];m[q]=undefined;K.splice(e,q-e+1);m.splice(e,q-e+1);}}else if(K[l]==n){if(l>e){if(K[e-1]<0){K.splice(e,l-e+1);m.splice(e,l-e+1);D=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){Q.sap.log.fatal("assertion failed: multi-unit entry already existed before");}K[e-1]=-K[e-1];m[e-1]=o;K.splice(e,l-e+1);m.splice(e,l-e+1);D=1;}}}else{Q.sap.log.fatal("assertion failed: uncovered case detected");return D;}}else if(K[l]>n){Q.sap.log.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(l-e>0){K.splice(e,l-e);m.splice(e,l-e);}return D;};b.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,d,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(d){if(!o.unitPropertyName||Q.inArray(o.unitPropertyName,d)==-1){R.push(o.rawValuePropertyName);}}}for(var k=0;k<s.length;k++){if(Q.inArray(s[k],d)!=-1){m[s[k]]="*";}}var c="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var D=m[this.aAllDimensionSortedByName[l]];c+=(D===undefined?"":D)+",";}c+="-multiple-units-not-dereferencable";var e;if(this.mMultiUnitKey[g]&&(e=Q.inArray(c,this.mMultiUnitKey[g]))!=-1){return{oEntry:this.oModel.getObject("/"+c),bIsNewEntry:false,iIndex:e,aReloadMeasurePropertyName:R};}m.__metadata.uri=c;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{});var f=this.oModel._getKey(m);this.oModel.getContext('/'+f)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};b.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};b.prototype.resetData=function(c){var g=c?c.getPath():undefined;this._resetData(g);};b.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};b.prototype.refresh=function(f){b.prototype._refresh.apply(this,arguments);};b.prototype._refresh=function(f,c,e){var d=false;if(!f){if(e){var r=this.oModel.resolve(this.sPath,this.oContext);var E=this.oModel.oMetadata._getEntityTypeByPath(r);if(E&&(E.entityType in e)){d=true;}}if(c&&!d){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in c){d=true;return false;}});if(d){return false;}});}if(!c&&!e){d=true;}}if(f||d){this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:sap.ui.model.ChangeReason.Refresh});}};b.prototype.checkUpdate=function(f,c){var d=false;if(!f){if(this.bNeedsUpdate||!c){d=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in c){d=true;return false;}});if(d){return false;}});}}if(f||d){this.bNeedsUpdate=false;this._fireChange();}};b.prototype.getDownloadUrl=function(f){var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var s=[];var c=[];for(var d in this.oDimensionDetailsSet)s.push(d);o.setAggregationLevel(s);for(var D in this.oDimensionDetailsSet){var e=this.oDimensionDetailsSet[D];var I=(e.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(e.name,true,I,e.aAttributeName);}for(var M in this.oMeasureDetailsSet)c.push(M);o.setMeasures(c);for(var g in this.oMeasureDetailsSet){var h=this.oMeasureDetailsSet[g];var n=(h.rawValuePropertyName!=undefined);var p=(h.formattedValuePropertyName!=undefined);var q=(h.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(h.name,n,p,q);}var r=o.getSortExpression();r.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){r.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending);}}var t=o.getFilterExpression();t.clear();if(this.aApplicationFilter){t.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){t.addUI5FilterConditions(this.aControlFilter);}var P=o.getURIToQueryResultEntitySet();var u=this._getQueryODataRequestOptions(o);if(!u){return undefined;}var E=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var v=this.aAnalyticalInfo[k];if((v.visible||v.inResult)&&v.name!==""){E.push(v.name);if(this.oMeasureDetailsSet[v.name]!=undefined&&this.oMeasureDetailsSet[v.name].unitPropertyName!=undefined){E.push(this.oMeasureDetailsSet[v.name].unitPropertyName);}}}for(var j=0,l=u.length;j<l;j++){if(/^\$select/i.test(u[j])){u[j]="$select="+E.join(",");break;}}if(f){u.splice(0,0,"$format="+encodeURIComponent(f));}if(P){return this.oModel._createRequestUrl(P,null,u);}};return b;});
