/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/Popup','./library'],function(q,C,P,l){"use strict";var O=C.extend("sap.ui.ux3.Overlay",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{openButtonVisible:{type:"boolean",group:"Misc",defaultValue:true},closeButtonVisible:{type:"boolean",group:"Misc",defaultValue:true}},events:{close:{allowPreventDefault:true,parameters:{id:{type:"string"}}},closed:{allowPreventDefault:true,parameters:{id:{type:"string"}}},openNew:{parameters:{id:{type:"string"}}},open:{parameters:{id:{type:"string"}}}}}});O.prototype.init=function(){var t=this;this._oPopup=new P(this,false,true);this._oPopup.attachOpened(function(e){var d=q.sap.byId(t._initialFocusId)[0];if(!d&&t._getShell()&&t.getOpenButtonVisible()){d=q.sap.domById(t._getOpenButtonId());}else if(!d&&t._getShell()&&t.getCloseButtonVisible()){d=q.sap.domById(t._getCloseButtonId());}else if(!d){d=t.$("content").firstFocusableDomRef();}if(!d){d=t.$().firstFocusableDomRef();}if(d){q.sap.focus(d);}});this._oPopup.attachClosed(function(e){t.fireClosed({id:t.getId()});});this._overridePopupEventing();};O.prototype._overridePopupEventing=function(){this._oPopup.onmousedown=function(e){return;};};O.prototype._getShell=function(){var s=q(".sapUiUx3Shell").control();if(s.length>0&&!this._oShell){this._oShell=s.length?s[0]:null;}return this._oShell;};O.prototype._getCloseButtonId=function(){return this.getId()+"-close";};O.prototype._getOpenButtonId=function(){return this.getId()+"-openNew";};O.prototype._initDom=function(f,F,a){var s=q(".sapUiUx3Shell").control();this._oShell=s.length?s[0]:null;s=this._oShell;this.$().css("position","fixed");if(s){this._bFocusEventsRegistered=true;s.syncWithCanvasSize(this.getId(),true,f,F,a);this.$("firstFocusDummyPaneFw").attr("tabindex","0").focusin(q.proxy(s.focusFirstHdr,s));this.$("firstFocusDummyPaneBw").attr("tabindex","0").focusin(q.proxy(s.focusLastTool,s));this.$("LastFocusDummyPane").attr("tabindex","0").focusin(q.proxy(s.focusPaneStart,s));}else{this.$().css("bottom","0").css("top","0").css("left","0").css("right","0");}};O.prototype._cleanupDom=function(){if(this._oShell){this._oShell.syncWithCanvasSize(this.getId(),false);}if(this._bFocusEventsRegistered){this._bFocusEventsRegistered=false;this.$("firstFocusDummyPaneFw").removeAttr("tabindex").unbind("focusin");this.$("firstFocusDummyPaneBw").removeAttr("tabindex").unbind("focusin");this.$("LastFocusDummyPane").removeAttr("tabindex").unbind("focusin");}};O.prototype.onAfterRendering=function(){var p=this._oPopup.getOpenState();if(p===sap.ui.core.OpenState.OPEN||p===sap.ui.core.OpenState.OPENING){this._initDom(q.proxy(this._setFocusFirst,this),q.proxy(this._setFocusLast,this),q.proxy(this._applyChanges,this));}};O.prototype.onBeforeRendering=function(){};O.prototype.exit=function(){this.close();this._oPopup.destroy();this._oPopup=null;this._oShell=null;};O.prototype.open=function(i){this._initialFocusId=i;if(this._oPopup.isOpen()){return;}if(i){this._oPopup.setInitialFocusId(i);}this._oPreviousFocus=P.getCurrentFocusInfo();this._oPopup.open(400);this._initDom(q.proxy(this._setFocusFirst,this),q.proxy(this._setFocusLast,this),q.proxy(this._applyChanges,this));this.fireOpen({id:this.getId()});};O.prototype.close=function(){if(!this._oPopup.isOpen()){return;}this._oPopup.close(400);q.sap.delayedCall(400,this,'restorePreviousFocus');this._cleanupDom();};O.prototype.onclick=function(e){this._handleButtonEvent(e);};O.prototype.onsapselect=function(e){this._handleButtonEvent(e);};O.prototype._handleButtonEvent=function(e){var a=e.target.id;if(a===this._getCloseButtonId()){if(this.fireClose({id:this.getId()})){this.close();}}else if(a===this._getOpenButtonId()){this.fireOpenNew({id:this.getId()});}};O.prototype._getText=function(k,a){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var t;if(r){t=r.getText(k);}if(t&&a){for(var i=0;i<a.length;i++){t=t.replace("{"+i+"}",a[i]);}}return t?t:k;};O.prototype._setFocusFirst=function(){q.sap.focus(q.sap.domById(this._getOpenButtonId()));};O.prototype._setFocusLast=function(){q.sap.focus(q.sap.domById(this._getCloseButtonId()));};O.prototype._applyChanges=function(c){return this;};O.prototype.isOpen=function(){return this._oPopup.isOpen();};O.prototype.restorePreviousFocus=function(){P.applyFocusInfo(this._oPreviousFocus);};return O;},true);
