/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/core/theming/Parameters'],function(q,l,C,E,I,a,P){"use strict";var S=C.extend("sap.m.SearchField",{metadata:{library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},maxLength:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Misc",defaultValue:null},showMagnifier:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},showRefreshButton:{type:"boolean",group:"Behavior",defaultValue:false},refreshButtonTooltip:{type:"string",group:"Misc",defaultValue:null},showSearchButton:{type:"boolean",group:"Behavior",defaultValue:true},selectOnFocus:{type:"boolean",group:"Behavior",defaultValue:true}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{search:{parameters:{query:{type:"string"},refreshButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}}}}});E.call(S.prototype);I.insertFontFaceStyle();var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");S.prototype._sAriaF5LabelId=new sap.ui.core.InvisibleText({text:r.getText("SEARCHFIELD_ARIA_F5")}).toStatic().getId();S.prototype.init=function(){this._inputEvent=sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10?"keyup":"input";this.setProperty("placeholder",r.getText("FACETFILTER_SEARCH"),true);};S.prototype.getFocusDomRef=function(){return this._inputElement;};S.prototype.getWidth=function(){return this.getProperty("width")||"100%";};S.prototype._hasPlacehoder=(function(){return"placeholder"in document.createElement("input");}());S.prototype.onBeforeRendering=function(){if(this._inputElement){if(sap.ui.Device.browser.firefox){this.$().find(".sapMSFB").unbind();}this.$().unbind();q(this._inputElement).unbind();this._inputElement=null;}};S.prototype.onAfterRendering=function(){this._inputElement=this.getDomRef("I");q(this._inputElement).bind(this._inputEvent,q.proxy(this.onInput,this)).bind("search",q.proxy(this.onSearch,this)).bind("change",q.proxy(this.onChange,this)).bind("focus",q.proxy(this.onFocus,this)).bind("blur",q.proxy(this.onBlur,this));if(sap.ui.Device.system.desktop||sap.ui.Device.system.combi){this.$().bind("touchstart mousedown",q.proxy(this.onButtonPress,this));if(sap.ui.Device.browser.firefox){this.$().find(".sapMSFB").bind("mouseup mouseout",function(e){q(e.target).removeClass("sapMSFBA");});}}};S.prototype.clear=function(){if(!this._inputElement||this.getValue()===""){return;}this.setValue("");this.fireLiveChange({newValue:""});this.fireSearch({query:""});};S.prototype.onButtonPress=function(e){if(e.originalEvent.button===2){return;}if(document.activeElement===this._inputElement&&e.target!==this._inputElement){e.preventDefault();}if(sap.ui.Device.browser.firefox){var b=q(e.target);if(b.hasClass("sapMSFB")){b.addClass("sapMSFBA");}}};S.prototype.ontouchend=function(e){if(e.originalEvent.button===2){return;}var s=e.target;if(s.id==this.getId()+"-reset"){var b=!this.getValue();this.clear();var c=document.activeElement;if((sap.ui.Device.system.desktop||b||/(INPUT|TEXTAREA)/i.test(c.tagName))&&(c!==this._inputElement)){this._inputElement.focus();}}else if(s.id==this.getId()+"-search"){if(sap.ui.Device.system.desktop&&!this.getShowRefreshButton()&&(document.activeElement!==this._inputElement)){this._inputElement.focus();}this.fireSearch({query:this.getValue(),refreshButtonPressed:this.getShowRefreshButton()&&!this.$().hasClass("sapMFocus")});}else{this.onmouseup(e);}};S.prototype.onmouseup=function(e){if(this.getEnabled()&&e.target.tagName=="FORM"){this._inputElement.focus();}};S.prototype.onSearch=function(e){var v=this._inputElement.value;this.setValue(v);this.fireSearch({query:v});if(!sap.ui.Device.system.desktop){this._blur();}};S.prototype._blur=function(){var t=this;window.setTimeout(function(){if(t._inputElement){t._inputElement.blur();}},13);};S.prototype.onChange=function(e){this.setValue(this._inputElement.value);};S.prototype.onInput=function(e){var v=this._inputElement.value;if(v!=this.getValue()){this.setValue(v);this.fireLiveChange({newValue:v});}};S.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.F5||e.which===q.sap.KeyCodes.ENTER){this.$("search").toggleClass("sapMSFBA",true);e.stopPropagation();e.preventDefault();}};S.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.F5||e.which===q.sap.KeyCodes.ENTER){this.$("search").toggleClass("sapMSFBA",false);this.fireSearch({query:this.getValue(),refreshButtonPressed:this.getShowRefreshButton()&&e.which===q.sap.KeyCodes.F5});}};S.prototype.onFocus=function(e){if(sap.ui.Device.browser.internet_explorer&&!document.hasFocus()){return;}this.$().toggleClass("sapMFocus",true);if(this.getShowRefreshButton()){this.$("search").removeAttr("title");}var i=this._inputElement;if(i&&i.value&&!this.getSelectOnFocus()){i.setSelectionRange(i.value.length,i.value.length);}};S.prototype.onBlur=function(e){var t;this.$().toggleClass("sapMFocus",false);if(this.getShowRefreshButton()){t=this.getRefreshButtonTooltip();if(t){this.$("search").attr("title",t);}}};S.prototype.setValue=function(v){v=v||"";if(this._inputElement){if(this._inputElement.value!==v){this._inputElement.value=v;}var $=this.$();if($.hasClass("sapMSFVal")==!v){$.toggleClass("sapMSFVal",!!v);}}this.setProperty("value",v,true);return this;};return S;},true);
