/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','../Device','../Global','../base/Object','./Locale','sap/ui/thirdparty/URI','jquery.sap.script'],function(q,D,G,B,L,U){"use strict";var C,a;var b=B.extend("sap.ui.core.Configuration",{constructor:function(o){this._oCore=o;function h(){var m;if(D.os.android){m=navigator.userAgent.match(/\s([a-z]{2}-[a-z]{2})[;)]/i);if(m){return m[1];}}return(navigator.languages&&navigator.languages[0])||navigator.language||navigator.userLanguage||navigator.browserLanguage;}var j={"theme":{type:"string",defaultValue:"base"},"language":{type:"string",defaultValue:h()},"formatLocale":{type:"string",defaultValue:null},"calendarType":{type:"string",defaultValue:null},"accessibility":{type:"boolean",defaultValue:true},"autoAriaBodyRole":{type:"boolean",defaultValue:true,noUrl:true},"animation":{type:"boolean",defaultValue:true},"rtl":{type:"boolean",defaultValue:null},"debug":{type:"boolean",defaultValue:false},"inspect":{type:"boolean",defaultValue:false},"originInfo":{type:"boolean",defaultValue:false},"noConflict":{type:"boolean",defaultValue:false,noUrl:true},"noDuplicateIds":{type:"boolean",defaultValue:true},"trace":{type:"boolean",defaultValue:false,noUrl:true},"modules":{type:"string[]",defaultValue:[],noUrl:true},"areas":{type:"string[]",defaultValue:null,noUrl:true},"onInit":{type:"code",defaultValue:undefined,noUrl:true},"uidPrefix":{type:"string",defaultValue:"__",noUrl:true},"ignoreUrlParams":{type:"boolean",defaultValue:false,noUrl:true},"weinreServer":{type:"string",defaultValue:"",noUrl:true},"weinreId":{type:"string",defaultValue:""},"preload":{type:"string",defaultValue:"auto"},"rootComponent":{type:"string",defaultValue:"",noUrl:true},"preloadLibCss":{type:"string[]",defaultValue:[]},"application":{type:"string",defaultValue:""},"appCacheBuster":{type:"string[]",defaultValue:[]},"bindingSyntax":{type:"string",defaultValue:"default",noUrl:true},"versionedLibCss":{type:"boolean",defaultValue:false},"whitelistService":{type:"string",defaultValue:null,noUrl:true},"frameOptions":{type:"string",defaultValue:"allow",noUrl:true},"frameOptionsConfig":{type:"object",defaultValue:undefined,noUrl:true},"xx-rootComponentNode":{type:"string",defaultValue:"",noUrl:true},"xx-appCacheBusterMode":{type:"string",defaultValue:"sync"},"xx-appCacheBusterHooks":{type:"object",defaultValue:undefined,noUrl:true},"xx-disableCustomizing":{type:"boolean",defaultValue:false,noUrl:true},"xx-loadAllMode":{type:"boolean",defaultValue:false,noUrl:true},"xx-test-mobile":{type:"boolean",defaultValue:false},"xx-domPatching":{type:"boolean",defaultValue:false},"xx-componentPreload":{type:"string",defaultValue:""},"xx-designMode":{type:"boolean",defaultValue:false},"xx-supportedLanguages":{type:"string[]",defaultValue:[]},"xx-bootTask":{type:"function",defaultValue:undefined,noUrl:true},"xx-suppressDeactivationOfControllerCode":{type:"boolean",defaultValue:false},"xx-lesssupport":{type:"boolean",defaultValue:false},"xx-handleValidation":{type:"boolean",defaultValue:false},"statistics":{type:"boolean",defaultValue:false}};var k={"xx-test":"1.15","flexBoxPolyfill":"1.14","sapMeTabContainer":"1.14","sapMeProgessIndicator":"1.14","sapMGrowingList":"1.14","sapMListAsTable":"1.14","sapMDialogWithPadding":"1.14","sapCoreBindingSyntax":"1.24"};this.oFormatSettings=new b.FormatSettings(this);var l=this;function s(N,V){if(typeof V==="undefined"||V===null){return;}switch(j[N].type){case"boolean":if(typeof V==="string"){if(j[N].defaultValue){l[N]=V.toLowerCase()!="false";}else{l[N]=V.toLowerCase()==="true"||V.toLowerCase()==="x";}}else{l[N]=!!V;}break;case"string":l[N]=""+V;break;case"code":l[N]=typeof V==="function"?V:String(V);break;case"function":if(typeof V!=="function"){throw new Error("unsupported value");}l[N]=V;break;case"string[]":if(q.isArray(V)){l[N]=V;}else if(typeof V==="string"){l[N]=q.map(V.split(/[ ,;]/),function($){return q.trim($);});}else{throw new Error("unsupported value");}break;case"object":if(typeof V!=="object"){throw new Error("unsupported value");}l[N]=V;break;default:throw new Error("illegal state");}}function p(y){var i,m;try{i=new U(y,window.location.href).normalize();m=i.path();return m+(m.slice(-1)==='/'?'':'/')+"UI5/";}catch(e){}}for(var n in j){l[n]=j[n].defaultValue;}var r=window["sap-ui-config"]||{};r.oninit=r.oninit||r["evt-oninit"];for(var n in j){if(r.hasOwnProperty(n.toLowerCase())){s(n,r[n.toLowerCase()]);}else if(!/^xx-/.test(n)&&r.hasOwnProperty("xx-"+n.toLowerCase())){s(n,r["xx-"+n.toLowerCase()]);}}if(r.libs){l.modules=q.map(r.libs.split(","),function($){return q.trim($)+".library";}).concat(l.modules);}var P="compatversion";var t=r[P];var u=q.sap.Version("1.14");this._compatversion={};function _(e){var v=!e?t||u.toString():r[P+"-"+e.toLowerCase()]||t||k[e]||u.toString();v=q.sap.Version(v.toLowerCase()==="edge"?G.version:v);return q.sap.Version(v.getMajor(),v.getMinor());}this._compatversion._default=_();for(var n in k){this._compatversion[n]=_(n);}if(!l.ignoreUrlParams){var w="sap-ui-";var x=q.sap.getUriParameters();if(x.mParams['sap-locale']||x.mParams['sap-language']){var V=x.get('sap-locale')||M[x.get('sap-language').toUpperCase()]||x.get('sap-language');if(V===""){l['language']=j['language'].defaultValue;}else{s('language',V);}}if(x.mParams['sap-rtl']){var V=x.get('sap-rtl');if(V==="X"||V==="x"){s('rtl',true);}else{s('rtl',false);}}if(x.mParams['sap-theme']){var V=x.get('sap-theme');if(V===""){l['theme']=j['theme'].defaultValue;}else{s('theme',V);}}if(x.mParams['sap-statistics']){var V=x.get('sap-statistics');s('statistics',V);}for(var n in j){if(j[n].noUrl){continue;}var V=x.get(w+n);if(V==null&&!/^xx-/.test(n)){V=x.get(w+"xx-"+n);}if(V===""){l[n]=j[n].defaultValue;}else{s(n,V);}}}this.derivedRTL=L._impliesRTL(l.language);var T=l.theme;var y;var I=T.indexOf("@");if(I>=0){y=p(T.slice(I+1));if(y){l.theme=T.slice(0,I);l.themeRoot=y;}else{l.theme=(r.theme&&r.theme!==T)?r.theme:"base";I=-1;}}l.theme=this._normalizeTheme(l.theme,y);var z=l['languagesDeliveredWithCore']=L._coreI18nLocales;var A=l['xx-supportedLanguages'];if(A.length===0||(A.length===1&&A[0]==='*')){A=[];}else if(A.length===1&&A[0]==='default'){A=z||[];}l['xx-supportedLanguages']=A;if(l["bindingSyntax"]==="default"){l["bindingSyntax"]=(l.getCompatibilityVersion("sapCoreBindingSyntax").compareTo("1.26")<0)?"simple":"complex";}if(!l["frameOptions"]||(l["frameOptions"]!=='allow'&&l["frameOptions"]!=='deny'&&l["frameOptions"]!=='trusted')){l["frameOptions"]='allow';}var E=l['preloadLibCss'];if(E.length>0){E.appManaged=E[0].slice(0,1)==="!";if(E.appManaged){E[0]=E[0].slice(1);}if(E[0]==="*"){E.splice(0,1);var F=0;q.each(l.modules,function(i,e){var m=e.match(/^(.*)\.library$/);if(m){E.splice(F,0,m[1]);}});}}for(var n in j){if(l[n]!==j[n].defaultValue){q.sap.log.info("  "+n+" = "+l[n]);}}},getVersion:function(){if(this._version){return this._version;}this._version=new q.sap.Version(G.version);return this._version;},getCompatibilityVersion:function(F){if(typeof(F)==="string"&&this._compatversion[F]){return this._compatversion[F];}return this._compatversion._default;},getTheme:function(){return this.theme;},_setTheme:function(t){this.theme=t;return this;},_normalizeTheme:function(t,T){if(t&&T==null&&t.match(/^sap_corbu$/i)){return"sap_goldreflection";}return t;},getLanguage:function(){return this.language;},setLanguage:function(l){g(typeof l==="string"&&l,"sLanguage must be a BCP47 language tag or Java Locale id or null");var o=this.getRTL(),m;if(l!=this.language){m=this._collect();this.language=m.language=l;this.derivedRTL=L._impliesRTL(l);if(o!=this.getRTL()){m.rtl=this.getRTL();}this._endCollect();}return this;},getLocale:function(){return new L(this.language);},getCalendarType:function(){var n;if(!C){G.getCore().loadLibrary('sap.ui.core');C=sap.ui.require("sap/ui/core/library").CalendarType;}if(!a){q.sap.require("sap.ui.core.LocaleData");a=sap.ui.require("sap/ui/core/LocaleData");}if(this.calendarType){for(n in C){if(n.toLowerCase()===this.calendarType.toLowerCase()){this.calendarType=n;return this.calendarType;}}q.sap.log.warning("Parameter 'calendarType' is set to "+this.calendarType+" which isn't a valid value and therefore ignored. The calendar type is determined from format setting and current locale");}var l=this.oFormatSettings.getLegacyDateFormat();if(l==="A"||l==="B"){return C.Islamic;}return a.getInstance(this.getLocale()).getPreferredCalendarType();},setCalendarType:function(s){var m;if(this.calendarType!==s){m=this._collect();this.calendarType=m.calendarType=s;this._endCollect();}return this;},getFormatLocale:function(){return this.formatLocale||this.language;},setFormatLocale:function(F){g(F===null||typeof F==="string"&&F,"sFormatLocale must be a BCP47 language tag or Java Locale id or null");var m;if(F!=this.formatLocale){m=this._collect();this.formatLocale=m.formatLocale=F;this._endCollect();}return this;},getLanguagesDeliveredWithCore:function(){return this["languagesDeliveredWithCore"];},getSupportedLanguages:function(){return this["xx-supportedLanguages"];},getAccessibility:function(){return this.accessibility;},getAutoAriaBodyRole:function(){return this.autoAriaBodyRole;},getAnimation:function(){return this.animation;},getRTL:function(){return this.rtl===null?this.derivedRTL:this.rtl;},setRTL:function(r){g(r===null||typeof r==="boolean","bRTL must be null or a boolean");var m;if(r!=this.rtl){m=this._collect();this.rtl=m.rtl=this.getRTL();this._endCollect();}return this;},getDebug:function(){return this.debug;},getInspect:function(){return this.inspect;},getOriginInfo:function(){return this.originInfo;},getNoDuplicateIds:function(){return this.noDuplicateIds;},getTrace:function(){return this.trace;},getUIDPrefix:function(){return this.uidPrefix;},getDesignMode:function(){return this["xx-designMode"];},getSuppressDeactivationOfControllerCode:function(){return this["xx-suppressDeactivationOfControllerCode"];},getControllerCodeDeactivated:function(){return this.getDesignMode()&&!this.getSuppressDeactivationOfControllerCode();},getWeinreServer:function(){var w=this.weinreServer;if(!w){w=window.location.protocol+"//"+window.location.hostname+":";w+=(parseInt(window.location.port,10)||8080)+1;}return w;},getWeinreId:function(){return this.weinreId;},getApplication:function(){return this.application;},getRootComponent:function(){return this.rootComponent;},getAppCacheBuster:function(){return this.appCacheBuster;},getAppCacheBusterMode:function(){return this["xx-appCacheBusterMode"];},getAppCacheBusterHooks:function(){return this["xx-appCacheBusterHooks"];},getDisableCustomizing:function(){return this["xx-disableCustomizing"];},getDomPatching:function(){return this["xx-domPatching"];},getPreload:function(){return this.preload;},getComponentPreload:function(){return this['xx-componentPreload']||this.preload;},getFormatSettings:function(){return this.oFormatSettings;},_collect:function(){var m=this.mChanges||(this.mChanges={__count:0});m.__count++;return m;},_endCollect:function(){var m=this.mChanges;if(m&&(--m.__count)===0){delete m.__count;this._oCore&&this._oCore.fireLocalizationChanged(m);delete this.mChanges;}},getStatistics:function(){return this.statistics||window.localStorage.getItem("sap-ui-statistics")=="X";},getNoNativeScroll:function(){return false;},getHandleValidation:function(){return this["xx-handleValidation"];}});var M={"ZH":"zh-Hans","ZF":"zh-Hant","1Q":"en-US-x-saptrc","2Q":"en-US-x-sappsd"};var c={"":{pattern:null},"1":{pattern:"dd.MM.yyyy"},"2":{pattern:"MM/dd/yyyy"},"3":{pattern:"MM-dd-yyyy"},"4":{pattern:"yyyy.MM.dd"},"5":{pattern:"yyyy/MM/dd"},"6":{pattern:"yyyy-MM-dd"},"7":{pattern:"Gyy.MM.dd",ignore:true},"8":{pattern:"Gyy/MM/dd",ignore:true},"9":{pattern:"Gyy-MM-dd",ignore:true},"A":{pattern:"yyyy/MM/dd"},"B":{pattern:"yyyy/MM/dd"},"C":{pattern:"yyyy/MM/dd",ignore:true}};var d={"":{"short":null,medium:null,dayPeriods:null},"0":{"short":"HH:mm",medium:"HH:mm:ss",dayPeriods:null},"1":{"short":"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["AM","PM"]},"2":{"short":"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["am","pm"]},"3":{"short":"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["AM","PM"]},"4":{"short":"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["am","pm"]}};var f={"":{groupingSeparator:null,decimalSeparator:null}," ":{groupingSeparator:".",decimalSeparator:","},"X":{groupingSeparator:",",decimalSeparator:"."},"Y":{groupingSeparator:" ",decimalSeparator:","}};function g(e,m){if(!e){throw new Error(m);}}B.extend("sap.ui.core.Configuration.FormatSettings",{constructor:function(o){this.oConfiguration=o;this.mSettings={};this.sLegacyDateFormat=undefined;this.sLegacyTimeFormat=undefined;this.sLegacyNumberFormatSymbolSet=undefined;},getFormatLocale:function(){function e(t){var l=t.oConfiguration.language;if(!q.isEmptyObject(t.mSettings)){if(l.indexOf("-x-")<0){l=l+"-x-sapufmt";}else if(l.indexOf("-sapufmt")<=l.indexOf("-x-")){l=l+"-sapufmt";}}return l;}return new L(this.oConfiguration.formatLocale||e(this));},_set:function(k,v){var o=this.mSettings[k];if(v!=null){this.mSettings[k]=v;}else{delete this.mSettings[k];}if((o==null!=v==null)||!q.sap.equal(o,v)){var m=this.oConfiguration._collect();m[k]=v;this.oConfiguration._endCollect();}},getDatePattern:function(s){return this.mSettings["dateFormat-"+s];},setDatePattern:function(s,p){g(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");this._set("dateFormat-"+s,p);return this;},getTimePattern:function(s){return this.mSettings["timeFormat-"+s];},setTimePattern:function(s,p){g(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");this._set("timeFormat-"+s,p);return this;},getNumberSymbol:function(t){return this.mSettings["symbols-latn-"+t];},setNumberSymbol:function(t,s){g(t=="decimal"||t=="group"||t=="plusSign"||t=="minusSign","sType must be decimal, group, plusSign or minusSign");this._set("symbols-latn-"+t,s);return this;},setFirstDayOfWeek:function(v){g(typeof v=="number"&&v>=0&&v<=6,"iValue must be an integer value between 0 and 6");this._set("weekData-firstDay",v);return this;},_setDayPeriods:function(w,t){this._set("dayPeriods-format-"+w,t);return this;},getLegacyDateFormat:function(){return this.sLegacyDateFormat||undefined;},setLegacyDateFormat:function(F){F=F?String(F).toUpperCase():"";g(!F||c.hasOwnProperty(F),"sFormatId must be one of ['1','2','3','4','5','6','7','8','9','A','B','C'] or empty");if(c[F].ignore){q.sap.log.warning("The ABAP date format '"+F+"' ("+c[F].pattern+") is not supported yet. Falling back to locale specific date formats.");F="";}var m=this.oConfiguration._collect();this.sLegacyDateFormat=m.legacyDateFormat=F;this.setDatePattern("short",c[F].pattern);this.setDatePattern("medium",c[F].pattern);this.oConfiguration._endCollect();return this;},getLegacyTimeFormat:function(){return this.sLegacyTimeFormat||undefined;},setLegacyTimeFormat:function(F){g(!F||d.hasOwnProperty(F),"sFormatId must be one of ['0','1','2','3','4'] or empty");var m=this.oConfiguration._collect();this.sLegacyTimeFormat=m.legacyTimeFormat=F=F||"";this.setTimePattern("short",d[F]["short"]);this.setTimePattern("medium",d[F]["medium"]);this._setDayPeriods("abbreviated",d[F].dayPeriods);this.oConfiguration._endCollect();return this;},getLegacyNumberFormat:function(){return this.sLegacyNumberFormat||undefined;},setLegacyNumberFormat:function(F){F=F?F.toUpperCase():"";g(!F||f.hasOwnProperty(F),"sFormatId must be one of [' ','X','Y'] or empty");var m=this.oConfiguration._collect();this.sLegacyNumberFormat=m.legacyNumberFormat=F;this.setNumberSymbol("group",f[F].groupingSeparator);this.setNumberSymbol("decimal",f[F].decimalSeparator);this.oConfiguration._endCollect();return this;},setLegacyDateCalendarCustomizing:function(m){g(q.isArray(m),"aMappings must be an Array");var e=this.oConfiguration._collect();this.aLegacyDateCalendarCustomizing=e.legacyDateCalendarCustomizing=m;this.oConfiguration._endCollect();return this;},getLegacyDateCalendarCustomizing:function(){return this.aLegacyDateCalendarCustomizing;},getCustomLocaleData:function(){return this.mSettings;}});return b;});
