/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/base/Object','./Control','./IntervalTrigger','./RenderManager','./ResizeHandler','./PopupSupport','./Element','jquery.sap.script'],function(q,D,M,B,C,I,R,a,P,E){"use strict";var b=M.extend("sap.ui.core.Popup",{constructor:function(c,m,s,A){M.apply(this);P.apply(this);this._popupUID=q.sap.uid();this.bOpen=false;this.eOpenState=sap.ui.core.OpenState.CLOSED;this._mFocusEvents={};this._mFocusEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mFocusEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mFocusEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mFocusEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mFocusEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;if(c){this.setContent(c);}this._oDefaultPosition={my:b.Dock.CenterCenter,at:b.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=q.extend({},this._oDefaultPosition);this._bModal=!!m;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof(s)==="boolean"?s:true;this._bAutoClose=!!A;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this._oBlindLayer=null;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(e){if(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose")){return;}if(this.eOpenState===sap.ui.core.OpenState.CLOSING||this.eOpenState===sap.ui.core.OpenState.CLOSED){return;}var d=e.target,p=this._$().get(0),f=q.sap.containsOrEquals(p,d);if(!f){var g=this.getChildPopups();for(var i=0,l=g.length;i<l;i++){var o=q.sap.domById(g[i]);if(q.sap.containsOrEquals(o,d)){f=true;break;}}}if(!f){this.close();}};}this._F6NavigationHandler=function(e){var S={},d=this._sF6NavMode,o;if(d=="DOCK"){if(this._bModal){d="NONE";}else if(this._oLastPosition&&this._oLastPosition.of){o=this._getOfDom(this._oLastPosition.of);if(!o||o===document){o=null;d="NONE";}}}switch(d){case"SCOPE":S.scope=this._$()[0];break;case"DOCK":S.target=o;var $=q(o).parents("[data-sap-ui-popup]");S.scope=$.length?$[0]:null;break;default:S.skip=true;}q.sap.handleF6GroupNavigation(e,S);};},metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{"childPopups":{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{"opened":{},"closed":{}}}});b._activateBlindLayer=true;b.blStack=[];b.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};b.prototype.touchEnabled=D.support.touch||q.sap.simulateMobileOnDesktop;b.prototype.restoreFocus=!D.support.touch&&!q.sap.simulateMobileOnDesktop;B.extend("sap.ui.core.Popup.Layer",{constructor:function(){var d=this.getDomString();this._$Ref=q(d).appendTo(sap.ui.getCore().getStaticAreaRef());}});b.Layer.prototype.init=function(o,z){this._$Ref.css({"visibility":"visible","z-index":z});this.update(o,z);this._$Ref.insertAfter(o).show();};b.Layer.prototype.update=function(o,z){var c=o.rect();this._$Ref.css({"left":c.left,"top":c.top});if(o.css("right")!="auto"&&o.css("right")!="inherit"){this._$Ref.css({"right":o.css("right"),"width":"auto"});}else{this._$Ref.css({"width":c.width,"right":"auto"});}if(o.css("bottom")!="auto"&&o.css("bottom")!="inherit"){this._$Ref.css({"bottom":o.css("bottom"),"height":"auto"});}else{this._$Ref.css({"height":c.height,"bottom":"auto"});}if(typeof(z)==="number"){this._$Ref.css("z-index",z);}};b.Layer.prototype.reset=function(){this._$Ref.hide().css("visibility","hidden").appendTo(sap.ui.getCore().getStaticAreaRef());};b.Layer.prototype.getDomString=function(){q.sap.log.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return"";};b.Layer.extend("sap.ui.core.Popup.BlindLayer",{constructor:function(){b.Layer.apply(this);}});b.BlindLayer.prototype.getDomString=function(){return"<div class=\"sapUiBliLy\" id=\"sap-ui-blindlayer-"+q.sap.uid()+"\"><iframe scrolling=\"no\" src=\"javascript:''\"	tabIndex=\"-1\"></iframe></div>";};b.prototype.oBlindLayerPool=new sap.ui.base.ObjectPool(b.BlindLayer);b.Layer.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){b.Layer.apply(this);}});b.ShieldLayer.prototype.getDomString=function(){return"<div class=\"sapUiPopupShield\" id=\"sap-ui-shieldlayer-"+q.sap.uid()+"\"></div>";};b.prototype.oShieldLayerPool=new sap.ui.base.ObjectPool(b.ShieldLayer);(function(){var l=0;var m=Math.pow(2,32)-1;b.setInitialZIndex=function(i){if(i>=m){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}l=Math.max(i,this.getLastZIndex());};b.getLastZIndex=function(){return l;};b.prototype.getLastZIndex=function(){return b.getLastZIndex();};b.getNextZIndex=function(){l+=10;if(l>=m){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}return l;};b.prototype.getNextZIndex=function(){return b.getNextZIndex();};}());var r=function(o,c){var p=3;var l=Math.abs(o.left-c.left);var t=Math.abs(o.top-c.top);var w=Math.abs(o.width-c.width);var h=Math.abs(o.height-c.height);if(l>p||t>p||w>p||h>p){return false;}return true;};b.prototype.open=function(d,m,c,o,f,g,h){if(this.eOpenState!=sap.ui.core.OpenState.CLOSED){return;}this.eOpenState=sap.ui.core.OpenState.OPENING;var s;try{s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);}catch(e){q.sap.log.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}this._bContentAddedToStatic=false;if(this.oContent instanceof C&&!this.oContent.getParent()){s.addContent(this.oContent,true);this._bContentAddedToStatic=true;}if(this.oContent.getUIArea){var A=this.oContent.getUIArea();if(A===null){q.sap.log.warning("The Popup content is NOT connected with an UIArea and may not work properly!");}else if(b._bEnableUIAreaCheck&&A.getRootNode().id!==s.getRootNode().id){q.sap.log.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!");}}if(typeof(d)=="string"){h=g;g=f;f=o;o=c;c=m;m=d;d=-1;}if(d===undefined){d=-1;}if(this.restoreFocus){this._oPreviousFocus=b.getCurrentFocusInfo();}if(this.isInPopup(o)||this.isInPopup(this._oPosition.of)){var p=this.getParentPopupId(o)||this.getParentPopupId(this._oPosition.of);var i="";var j=this.getContent();if(j instanceof E){i=j.getId();}else if(typeof j==="object"){i=j.id;}this.addChildToPopup(p,i);this.addChildToPopup(p,this._popupUID);}var $=this._$(true);var k="fast";if((d===0)||(d>0)){k=d;}else if((this._durations.open===0)||(this._durations.open>0)){k=this._durations.open;}var _;if(m||c||o||f||g){_=this._createPosition(m,c,o,f,g);this._oPosition=_;}else{_=this._oPosition;}if(!_.of){_.of=this._oPosition.of||document;}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var S=sap.ui.getCore().getStaticAreaRef();$.css({"position":"absolute","visibility":"hidden"});if(!($[0].parentNode==S)){$.appendTo(S);}$.css("z-index",this._iZIndex);q.sap.log.debug("position popup content "+$.attr("id")+" at "+(window.JSON?JSON.stringify(_.at):String(_.at)));this._applyPosition(_);if(h!==undefined){this.setFollowOf(h);}var t=this;if(q.sap.isMouseEventDelayed){if(this._oTopShieldLayer){q.sap.clearDelayedCall(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null;}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex+1);}this._iTopShieldRemoveTimer=q.sap.delayedCall(500,this,function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;});}var O=function(){t.bOpen=true;$.css("display","block");if(t._bModal||t._bAutoClose||t._sInitialFocusId){var l=null;if(t._sInitialFocusId){var n=sap.ui.getCore().byId(t._sInitialFocusId);if(n){l=n.getFocusDomRef();}l=l||q.sap.domById(t._sInitialFocusId);}q.sap.focus(l||$.firstFocusableDomRef());var u=t._getOfDom(t._oLastPosition.of);var v=q(u).rect();if(t._oLastOfRect&&v&&!r(t._oLastOfRect,v)){t._applyPosition(t._oLastPosition);}}t.eOpenState=sap.ui.core.OpenState.OPEN;if(t.getFollowOf()){b.DockTrigger.addListener(b.checkDocking,t);}t._updateBlindLayer();if(!!D.browser.internet_explorer&&D.browser.version===9){q.sap.delayedCall(0,t,function(){t.fireOpened();});}else{t.fireOpened();}};$.toggleClass("sapUiShd",this._bShadow).hide().css("visibility","visible");if(k==0){O.apply();}else if(this._animations.open){this._animations.open.call(null,$,k,O);}else{$.fadeIn(k,O);}if(!!D.browser.internet_explorer&&!D.os.windows_phone&&b._activateBlindLayer){this._oBlindLayer=this.oBlindLayerPool.borrowObject($,this._iZIndex-1);}if(this._bModal){this._showBlockLayer();}if(this.oContent instanceof E){this.oContent.addDelegate(this);}this.bOpen=true;if(this._bModal||this._bAutoClose){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}if(D.os.ios&&D.support.touch){q(document).on("touchmove",this._fnPreventScroll);}};b.prototype.onFocusEvent=function(o){var e=q.event.fix(o);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){e=q.event.fix(arguments[2]);}var t=(e.type=="focus"||e.type=="activate")?"focus":"blur";var c=false;if(t=="focus"){var d=this._$().get(0);if(d){c=q.sap.containsOrEquals(d,e.target);var f=this.getChildPopups();if(!c){for(var i=0,l=f.length;i<l;i++){var g=q.sap.domById(f[i]);if(g){c=q.sap.containsOrEquals(g,e.target);if(c){break;}}}}q.sap.log.debug("focus event on "+e.target.id+", contains: "+c);if(this._bModal&&!c){var T=(b.getLastZIndex()==this._iZIndex);if(T){if(!D.support.touch||q(e.target).is(":input")){var h=this.oLastBlurredElement?this.oLastBlurredElement:d;q.sap.focus(h);}}}else if(this._bAutoClose&&c&&this._sTimeoutId){q.sap.clearDelayedCall(this._sTimeoutId);this._sTimeoutId=null;}}}else if(t=="blur"){q.sap.log.debug("blur event on "+e.target.id);if(this._bModal){this.oLastBlurredElement=e.target;}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(e.target===document.activeElement){return;}var j=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=q.sap.delayedCall(j,this,function(){this.close(j,"autocloseBlur");var O=this._oLastPosition&&this._oLastPosition.of;if(O){var p=this.getParentPopupId(O);if(p){var s="sap.ui.core.Popup.onFocusEvent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",s,e);}}});}}}};b.prototype.setInitialFocusId=function(i){this._sInitialFocusId=i;};b.prototype.close=function(d){if(b._autoCloseDebug){return;}if(this._sTimeoutId){q.sap.clearDelayedCall(this._sTimeoutId);this._sTimeoutId=null;if(arguments.length>1){var A=arguments[1];if(typeof A=="string"&&A=="autocloseBlur"&&this._isFocusInsidePopup()){return;}}}if(this.eOpenState==sap.ui.core.OpenState.CLOSED||this.eOpenState==sap.ui.core.OpenState.CLOSING){return;}var i="fast";if((d===0)||(d>0)){i=d;}else if((this._durations.close===0)||(this._durations.close>0)){i=this._durations.close;}if(i===0&&this.eOpenState==sap.ui.core.OpenState.OPENING){return;}this.eOpenState=sap.ui.core.OpenState.CLOSING;if(this.getFollowOf()){b.DockTrigger.removeListener(b.checkDocking,this);}if(this.oContent&&this._bContentAddedToStatic){sap.ui.getCore().getEventBus().publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.removeContent(s.indexOfContent(this.oContent),true);}this._bContentAddedToStatic=false;this._sTimeoutId=null;if(this.fEventHandler){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.touchEnabled){if(!this._bModal&&this._bAutoClose){q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}if(D.os.ios&&D.support.touch){q(document).off("touchmove",this._fnPreventScroll);}if(this.oContent instanceof E){this.oContent.removeDelegate(this);}var $=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._oBlindLayer){this.oBlindLayerPool.returnObject(this._oBlindLayer);}this._oBlindLayer=null;var t=this;if(q.sap.isMouseEventDelayed){if(this._oBottomShieldLayer){q.sap.clearDelayedCall(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null;}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex-3);}this._iBottomShieldRemoveTimer=q.sap.delayedCall(500,this,function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;});}if(this.isInPopup(this._oLastPosition.of)){var p=this.getParentPopupId(this._oLastPosition.of);var c="";var o=this.getContent();if(o instanceof E){c=o.getId();}else if(typeof o==="object"){c=o.id;}this.removeChildFromPopup(p,c);this.removeChildFromPopup(p,this._popupUID);}var f=function(){q($).hide().css({"visibility":"hidden","left":"0px","top":"0px","right":""});$=t._$(false,true);if($.length){q($).hide().css({"visibility":"hidden","left":"0px","top":"0px","right":""});}if(t.restoreFocus){if(t._bModal){b.applyFocusInfo(t._oPreviousFocus);t._oPreviousFocus=null;t.oLastBlurredElement=null;}}t.bOpen=false;t.eOpenState=sap.ui.core.OpenState.CLOSED;t.fireClosed();var e=t.getChildPopups();for(var j=0,l=e.length;j<l;j++){t.closePopup(e[j]);}};if(i==0){f.apply();}else if(this._animations.close){this._animations.close.call(null,$,i,f);}else{$.fadeOut(i,f);}if(this._bModal){this._hideBlockLayer();}if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}};b.getCurrentFocusInfo=function(){var _=null;var f=sap.ui.getCore().getCurrentFocusedControlId();if(f){var F=sap.ui.getCore().byId(f);_={'sFocusId':f,'oFocusInfo':F?F.getFocusInfo():{}};}else{try{var e=document.activeElement;if(e){_={'sFocusId':e.id,'oFocusedElement':e,'oFocusInfo':{}};}}catch(c){_=null;}}if(_){_.popup=this;}return _;};b.applyFocusInfo=function(p){if(p){var f=sap.ui.getCore().byId(p.sFocusId);if(f){f.applyFocusInfo(p.oFocusInfo);}else{var e=q.sap.domById(p.sFocusId)||p.oFocusedElement;q.sap.focus(e);}}};b.prototype.setContent=function(c){this.oContent=c;return this;};b.prototype.getContent=function(){return this.oContent;};b.prototype.setPosition=function(m,c,o,d,e){this._oPosition=this._createPosition(m,c,o,d,e);if(this.eOpenState!=sap.ui.core.OpenState.CLOSED){this._applyPosition(this._oPosition);this._oBlindLayer&&this._oBlindLayer.update(this._$());}return this;};b.prototype._createPosition=function(m,c,o,d,e){var n=false;if(m&&(m.indexOf("+")>=0||m.indexOf("-")>=0)){n=true;if(d&&d!="0 0"){q.sap.log.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition");}d=null;}var p=q.extend({},this._oDefaultPosition,{"my":m||this._oDefaultPosition.my,"at":c||this._oDefaultPosition.at,"of":o,"offset":d,"collision":e});if(!q.ui.version){if(b._bNewOffset==null){b._bNewOffset=true;if(!(D.browser.internet_explorer&&D.browser.version==8&&q.sap.Version(q().jquery).compareTo("1.8.1")<0)){var $=q(document.createElement("div"));$.position({of:window,using:function(g,h){b._bNewOffset=(h!==undefined);}});}}}var f=[];var O=[];if(b._bNewOffset||q.sap.Version(q.ui.version).compareTo("1.8.23")>0){if(d&&d!="0 0"){f=p.my.split(" ");O=d.split(" ");var s=[parseInt(O[0],10)<0?"":"+",parseInt(O[1],10)<0?"":"+"];p.my=f[0]+s[0]+O[0]+" "+f[1]+s[1]+O[1];p.offset=null;}}else if(n){f=p.my.split(" ");O=["",""];var i=f[0].indexOf("+");if(i<0){i=f[0].indexOf("-");}if(i>=0){O[0]=f[0].slice(i);f[0]=f[0].slice(0,i);}i=f[1].indexOf("+");if(i<0){i=f[1].indexOf("-");}if(i>=0){O[1]=f[1].slice(i);f[1]=f[1].slice(0,i);}p.my=f[0]+" "+f[1];p.offset=O[0]+" "+O[1];}return p;};b.prototype._getPositionOffset=function(){var o=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var m=this._oPosition.my.split(" ");var i=m[0].indexOf("+");if(i<0){i=m[0].indexOf("-");}if(i>=0){o[0]=m[0].slice(i);}i=m[1].indexOf("+");if(i<0){i=m[1].indexOf("-");}if(i>=0){o[1]=m[1].slice(i);}}else if(this._oPosition.offset){o=this._oPosition.offset.split(" ");}return o;};b.prototype._applyPosition=function(p){var c=sap.ui.getCore().getConfiguration().getRTL();var $=this._$();var A=p.at;if(typeof(A)==="string"){$.css("display","block").position(this._resolveReference(this._convertPositionRTL(p,c)));this._fixPositioning(p,c);}else if(sap.ui.core.CSSSize.isValid(A.left)&&sap.ui.core.CSSSize.isValid(A.top)){$.css({"left":A.left,"top":A.top});}else if(sap.ui.core.CSSSize.isValid(A.right)&&sap.ui.core.CSSSize.isValid(A.top)){$.css({"right":A.right,"top":A.top});}else if(typeof(A.left)==="number"&&typeof(A.top)==="number"){var d=$[0];if(d&&d.style.right){var w=$.outerWidth();$.css({"right":(document.documentElement.clientWidth-(A.left+w))+"px","top":A.top+"px"});}else{$.css({"left":A.left+"px","top":A.top+"px"});}}this._oLastPosition=p;this._oLastOfRect=this._calcOfRect(p.of);};b.prototype._calcOfRect=function(o){var O=this._getOfDom(o);if(O){return q(O).rect();}return null;};b.prototype._getOfDom=function(o){if(o instanceof q.Event){return null;}var O;if(typeof(o)==="string"){O=q.sap.byId(o);}else if(o instanceof q){O=o;}else{O=q(o instanceof E?o.getDomRef():o);}return O[0];};b.prototype._convertPositionRTL=function(p,c){var f=q.extend({},p);if(c){var n=false;if(f.my&&(f.my.indexOf("+")>=0||f.my.indexOf("-")>=0)){n=true;}if((f.offset||n)&&((f.my.indexOf("begin")>-1)||(f.my.indexOf("end")>-1))&&((f.at.indexOf("begin")>-1)||(f.at.indexOf("end")>-1))){if(n){var m=f.my.split(" ");if(m.length==2){f.my="";if(m[0]){if(m[0].indexOf("begin")>-1||m[0].indexOf("end")>-1){if(m[0].indexOf("+")>-1){m[0]=m[0].replace("+","-");}else if(m[0].indexOf("-")>-1){m[0]=m[0].replace("-","+");}}f.my=m[0];}if(m[1]){if(m[1].indexOf("begin")>-1||m[1].indexOf("end")>-1){if(m[1].indexOf("+")>-1){m[1]=m[1].replace("+","-");}else if(m[1].indexOf("-")>-1){m[1]=m[1].replace("-","+");}}if(m[0]){f.my=f.my+" ";}f.my=f.my+m[1];}}}else{f.offset=this._mirrorOffset(f.offset);}}f.my=f.my.replace("begin","right").replace("end","left");f.at=f.at.replace("begin","right").replace("end","left");}else{f.my=f.my.replace("end","right").replace("begin","left");f.at=f.at.replace("end","right").replace("begin","left");}return f;};b.prototype._mirrorOffset=function(o){var O=q.trim(o).split(/\s/);var p=parseInt(O[0],10);return(-p)+" "+O[O.length-1];};b.prototype._fixPositioning=function(p,c){var m=p.my;var $=this._$();var d=0;if(typeof(m)==="string"){if(c&&((m.indexOf("right")>-1)||(m.indexOf("begin")>-1)||(m.indexOf("center")>-1))){$=this._$();d=q(window).width()-$.outerWidth()-$.offset().left;$.css({"right":d+"px","left":""});}else if((m.indexOf("right")>-1)||(m.indexOf("end")>-1)){$=this._$();d=q(window).width()-$.outerWidth()-$.offset().left;$.css({"right":d+"px","left":""});}}};b.prototype._resolveReference=function(p){var o=p;if(p.of instanceof E){o=q.extend({},p,{of:p.of.getDomRef()});}return o;};b.prototype.setShadow=function(s){this._bShadow=s;if(this.eOpenState!=sap.ui.core.OpenState.CLOSED){this._$().toggleClass("sapUiShd",s);}return this;};b.prototype.setModal=function(m,s){var o=this._bModal;this._bModal=m;this._sModalCSSClass=s;if(this.isOpen()){if(o!==m){if(m){this._showBlockLayer();}else{this._hideBlockLayer();}if(this.touchEnabled&&this._bAutoClose){if(!m){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}}return this;};b.prototype.getModal=function(){return this._bModal;};b.prototype.setNavigationMode=function(m){if(m!="NONE"&&m!="DOCK"&&m!="SCOPE"){this._sF6NavMode="NONE";}this._sF6NavMode=m;};b.prototype.setAutoClose=function(A){if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==A){if(!this._bModal){if(A){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}this._bAutoClose=A;return this;};b.prototype.setAutoCloseAreas=function(A){for(var i=0,l=A.length;i<l;i++){var s="";if(A[i]instanceof E){s=A[i].getId();}else if(typeof A[i]==="object"){s=A[i].id;}else if(typeof A[i]==="string"){s=A[i];}if(q.inArray(s,this.getChildPopups())===-1){this.addChildPopup(s);}}return this;};b.prototype.setAnimations=function(o,c){if(o&&(typeof(o)=="function")){this._animations.open=o;}if(c&&(typeof(c)=="function")){this._animations.close=c;}return this;};b.prototype.setDurations=function(o,c){if((o>0)||(o===0)){this._durations.open=o;}if((c>0)||(c===0)){this._durations.close=c;}return this;};b.prototype._fnPreventScroll=function(e){if(!e.isMarked()){e.preventDefault();}};b.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";b.prototype._fnCloseOnScroll=function(e){this.close();};b.prototype.setFollowOf=function(f){b.DockTrigger.removeListener(b.checkDocking,this);var u=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof(f)==="function"){this._followOfHandler=f;u=true;}else if(typeof(f)==="boolean"){u=f;}else if(f===b.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;u=true;}else{this._bFollowOf=false;if(f!==null){q.sap.log.error("Trying to set an invalid type to 'followOf: "+f);}}if(u&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of);}if(this._bFollowOf&&this.getOpenState()===sap.ui.core.OpenState.OPEN){b.DockTrigger.addListener(b.checkDocking,this);}};b.prototype.getAutoClose=function(){return this._bAutoClose;};b.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof(this._followOfHandler)==="function"?this._followOfHandler:true;}return false;};b.prototype.isOpen=function(){return this.bOpen;};b.prototype.getOpenState=function(){return this.eOpenState;};b.prototype.destroy=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}this.close();this.oContent=null;if(this._bFollowOf){this.setFollowOf(null);}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}};b.prototype.exit=function(){delete this._mFocusEvents;};b.prototype._addFocusEventListeners=function(c,e,o){if(!this.fEventHandler){this.fEventHandler=q.proxy(this.onFocusEvent,this);}var p=this._$();var d=this.getChildPopups();var f={};var i=0,l=0;if(document.addEventListener&&!D.browser.internet_explorer){document.addEventListener("focus",this.fEventHandler,true);p.get(0).addEventListener("blur",this.fEventHandler,true);for(i=0,l=d.length;i<l;i++){f=q.sap.domById(d[i]);if(f){f.addEventListener("blur",this.fEventHandler,true);}}}else{q(document).bind("activate."+this._popupUID,this.fEventHandler);p.bind("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=d.length;i<l;i++){f=q.sap.domById(d[i]);if(f){q(f).bind("deactivate."+this._popupUID,this.fEventHandler);}}}};b.prototype._removeFocusEventListeners=function(c,e,o){var p=this._$(false,true);if(!p.length){return;}var d=this.getChildPopups();var f={};var i=0,l=0;if(document.removeEventListener&&!D.browser.internet_explorer){document.removeEventListener("focus",this.fEventHandler,true);p.get(0).removeEventListener("blur",this.fEventHandler,true);for(i=0,l=d.length;i<l;i++){f=q.sap.domById(d[i]);if(f){f.removeEventListener("blur",this.fEventHandler,true);}this.closePopup(d[i]);}}else{q(document).unbind("activate."+this._popupUID,this.fEventHandler);p.unbind("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=d.length;i<l;i++){f=q.sap.domById(d[i]);if(f){q(f).unbind("deactivate."+this._popupUID,this.fEventHandler);}}}this.fEventHandler=null;};b.prototype._registerEventBusEvents=function(c,e,o){var t=this;q.each(t._mFocusEvents,function(s,l){sap.ui.getCore().getEventBus().subscribe("sap.ui",s,l,t);});this._bEventBusEventsRegistered=true;};b.prototype._unregisterEventBusEvents=function(c,e,o){var t=this;q.each(t._mFocusEvents,function(s,l){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",s,l,t);});delete this._bEventBusEventsRegistered;};b.prototype._addFocusableArea=function(c,e,o){if(q.inArray(o.id,this.getChildPopups())===-1){this.addChildPopup(o.id);}};b.prototype._removeFocusableArea=function(c,e,o){this.removeChildPopup(o.id);};b.prototype._closePopup=function(c,e,o){this.close(typeof this._durations.close==="string"?0:this._durations.close);};b.prototype._setIdentity=function($){if(typeof $==="object"){$.attr("data-sap-ui-popup",this._popupUID);}else{q.sap.log.warning("Incorrect DomRef-type for 'setIdentity': "+$,this);return;}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents();}};b.prototype._$=function(f,g){var c;if(this.oContent instanceof C){c=this.oContent.$();if(f||(c.length===0&&!g)){q.sap.log.info("Rendering of popup content: "+this.oContent.getId());if(c.length>0){R.preserveContent(c[0],true,false);}sap.ui.getCore().getRenderManager().render(this.oContent,sap.ui.getCore().getStaticAreaRef());c=this.oContent.$();}}else if(this.oContent instanceof E){c=this.oContent.$();}else{c=q(this.oContent);}this._setIdentity(c);return c;};b.prototype._showBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),c="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:"");if($.length===0){$=q('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+c+'"></div>');$.appendTo(sap.ui.getCore().getStaticAreaRef());}else{$.removeClass().addClass(c);}b.blStack.push(this._iZIndex-2);$.css({"z-index":this._iZIndex-2,"visibility":"visible"}).show();q("html").addClass("sapUiBLyBack");};b.prototype._hideBlockLayer=function(){b.blStack.pop();if(b.blStack.length>0){q("#sap-ui-blocklayer-popup").css({"z-index":b.blStack[b.blStack.length-1],"visibility":"visible"}).show();}else{q("#sap-ui-blocklayer-popup").css("visibility","hidden").hide();q("html").removeClass("sapUiBLyBack");}};b.prototype._isFocusInsidePopup=function(){var d=this._$(false).get(0);if(d&&q.sap.containsOrEquals(d,document.activeElement)){return true;}return false;};b.DockTrigger=new I(200);b.checkDocking=function(){if(this.getOpenState()===sap.ui.core.OpenState.OPEN){var c=this._getOfDom(this._oLastPosition.of),o=q(c).rect();if(!o){this.close();return;}else if(o.left===0&&o.top===0&&o.height===0&&o.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=q.sap.domById(this._oLastPosition.of.id);c=this._getOfDom(this._oLastPosition.of);o=q(c).rect();if(!o){this.close();return;}}if(!q.sap.containsOrEquals(document.documentElement,c)){if(c.id&&c.id!==""){var n=q.sap.domById(c.id);var N=q(n).rect();if(N&&!r(o,N)){o=N;delete this._oLastPosition.of;this._oLastPosition.of=n;}}}if(this._oLastOfRect){if(!r(this._oLastOfRect,o)){if(this._followOfHandler){var l=q.extend(true,{},this._oLastPosition),L=q.extend(true,{},this._oLastOfRect);this._followOfHandler({lastPosition:l,lastOfRect:L,currentOfRect:o});}else{this._applyPosition(this._oLastPosition);}}}}};b.prototype.ontouchstart=function(e){this.onmousedown(e,true);this._bMousedownCalled=true;};b.prototype.onmousedown=function(e,s){if(this._bMousedownCalled&&!s){this._bMousedownCalled=false;return;}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return;}this._increaseMyZIndex("","mousedown",e);};b.prototype._increaseMyZIndex=function(c,e,o){var p=this.getParentPopup(this._oLastPosition.of);if(o.type&&o.type==="mousedown"||o.isFromParentPopup||p.length===0){this._iZIndex=this.getNextZIndex();var $=this._$();$.css("z-index",this._iZIndex);if(this._oBlindLayer){this._oBlindLayer.update($,this._iZIndex-1);}if(!o.type||o.type!="mousedown"){var d=this.getChildPopups();for(var i=0,l=d.length;i<l;i++){this.increaseZIndex(d[i],true);}}}else if(p.length>0){this.increaseZIndex(q(p.get(0)).attr("data-sap-ui-popup"),false);}};b.prototype.onAfterRendering=function(e){var $=this.getContent().$();$.toggleClass("sapUiShd",this._bShadow);$.css("position","absolute");this._setIdentity($);var c=$[0];var l=c.style.left;var d=c.style.right;var t=c.style.top;var f=c.style.bottom;if(!(l&&l!="auto"||d&&d!="auto"||t&&t!="auto"||f&&f!="auto")){q.sap.log.debug("reposition popup content "+$.attr("id")+" at "+(window.JSON?JSON.stringify(this._oLastPosition.at):String(this._oLastPosition.at)));this._applyPosition(this._oLastPosition);}$.show().css({"visibility":"visible","z-index":this._iZIndex});if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};b.prototype.onBeforeRendering=function(e){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);};b.prototype.onresize=function(e){if(this.eOpenState!=sap.ui.core.OpenState.CLOSED&&this._oBlindLayer){var t=this;setTimeout(function(){t._updateBlindLayer();},0);}};b.prototype._updateBlindLayer=function(){if(this.eOpenState!=sap.ui.core.OpenState.CLOSED&&this._oBlindLayer){this._oBlindLayer.update(this._$());}};return b;});
