/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','../base/ManagedObject','./Component','./UIComponentMetadata','./mvc/View'],function(q,M,C,U,V){"use strict";var a=C.extend("sap.ui.core.UIComponent",{constructor:function(i,s){try{C.apply(this,arguments);}catch(e){this._destroyCreatedInstances();throw e;}},metadata:{"abstract":true,rootView:null,publicMethods:["render"],aggregations:{"rootControl":{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},routing:{}}},U);a.prototype.init=function(){var t=this;var p={};if(this.getAutoPrefixId()){p.id=function(i){return t.createId(i);};}var m=this.getMetadata(),r=m._getRoutingSection()||{},R=r.config||{},v=r.routes;if(v){q.sap.require("sap.ui.core.routing.Router");var f=g(R.routerClass||sap.ui.core.routing.Router);this._oRouter=new f(v,R,this,r.targets);this._oTargets=this._oRouter.getTargets();this._oViews=this._oRouter.getViews();}else if(r.targets){q.sap.require("sap.ui.core.routing.Targets");q.sap.require("sap.ui.core.routing.Views");this._oViews=new sap.ui.core.routing.Views({component:this});var T=g(R.targetsClass||sap.ui.core.routing.Targets);this._oTargets=new T({targets:r.targets,config:R,views:this._oViews});}this.runAsOwner(function(){M.runWithPreprocessors(function(){t.setAggregation("rootControl",t.createContent());},p);});var o=this.getAggregation("rootControl");if(o instanceof V){if(R.targetParent===undefined){R.targetParent=o.getId();}if(this._oTargets){this._oTargets._setRootViewId(o.getId());}}};function g(r){var c;if(typeof r==="string"){c=q.sap.getObject(r);if(!c){q.sap.log.error("The specified class for router or targets '"+r+"' is undefined.",this);}}else{c=r;}return c;}a.prototype.destroy=function(){this._destroyCreatedInstances();C.prototype.destroy.apply(this,arguments);};a.prototype._destroyCreatedInstances=function(){if(this._oRouter){this._oRouter.destroy();delete this._oRouter;}if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}if(this._oViews){this._oViews.destroy();this._oViews=null;}};a.getRouterFor=function(c){var v=c;if(v instanceof sap.ui.core.mvc.Controller){v=v.getView();}if(v instanceof V){var o=sap.ui.core.Component.getOwnerComponentFor(v);if(o){return o.getRouter();}else{return undefined;}}};a.prototype.getRouter=function(){return this._oRouter;};a.prototype.getTargets=function(){return this._oTargets;};a.prototype.getAutoPrefixId=function(){return false;};a.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};a.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"---"+i;}return i;};a.prototype.isPrefixedId=function(i){return(i&&i.indexOf(this.getId()+"---")===0);};a.prototype.createContent=function(){var r=this.getMetadata().getRootView();if(r){return sap.ui.view(r);}return null;};a.prototype.render=function(r){var c=this.getAggregation("rootControl");if(c&&r){r.renderControl(c);}};a.prototype.getUIArea=function(){return(this.oContainer?this.oContainer.getUIArea():null);};a.prototype.getEventingParent=function(){return this.getUIArea();};a.prototype.setContainer=function(c){this.oContainer=c;return this;};a.prototype.onBeforeRendering=function(){};a.prototype.onAfterRendering=function(){};return a;});
