/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Locale','sap/ui/core/LocaleData','jquery.sap.strings','sap/ui/core/date/IslamicDate'],function(q,L,a,Q,I){"use strict";var D=function(){throw new Error();};D.oDateInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"day"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,getPattern:function(l,s,c){return l.getDatePattern(s,c);},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","month","week","day","hour","minute","second"]};D.oDateTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(l,s,c){var d=l.getDateTimePattern(s,c),b=l.getDatePattern(s,c),t=l.getTimePattern(s,c);return d.replace("{1}",b).replace("{0}",t);},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","month","week","day","hour","minute","second"]};D.oTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(l,s,c){return l.getTimePattern(s,c);},oRequiredParts:{"text":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","month","week","day","hour","minute","second"]};D.getInstance=function(f,l){return this.getDateInstance(f,l);};D.getDateInstance=function(f,l){return this.createInstance(f,l,this.oDateInfo);};D.getDateTimeInstance=function(f,l){return this.createInstance(f,l,this.oDateTimeInfo);};D.getTimeInstance=function(f,l){return this.createInstance(f,l,this.oTimeInfo);};D.createInstance=function(f,l,o){var F=q.sap.newObject(this.prototype);if(f instanceof sap.ui.core.Locale){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}F.oLocale=l;F.oLocaleData=a.getInstance(l);F.oFormatOptions=q.extend(false,{},o.oDefaultFormatOptions,f);if(!F.oFormatOptions.calendarType){F.oFormatOptions.calendarType=sap.ui.getCore().getConfiguration().getCalendarType();}if(!F.oFormatOptions.pattern){F.oFormatOptions.pattern=o.getPattern(F.oLocaleData,F.oFormatOptions.style,F.oFormatOptions.calendarType);}if(!o.oFallbackFormats){o.oFallbackFormats={};}var s=l.toString(),c=F.oFormatOptions.calendarType,k=s+"-"+c,b=o.oFallbackFormats[k];if(!b){b=[];o.oFallbackFormats[k]=b;var d=o.aFallbackFormatOptions.slice(0);if(o.bShortFallbackFormatOptions){var p=o.getPattern(F.oLocaleData,"short").replace(/[^dMyGU]/g,"");p=p.replace(/d+/g,"dd");p=p.replace(/M+/g,"MM");d.push({pattern:p.replace(/[yU]+/g,"yyyy"),strictParsing:true});d.push({pattern:p.replace(/[yU]+/g,"yy"),strictParsing:true});}q.each(d,function(i,f){f.calendarType=c;var e=D.createInstance(f,l,o);e.bIsFallback=true;b.push(e);});}F.aFallbackFormats=b;F.oRequiredParts=o.oRequiredParts;F.aRelativeScales=o.aRelativeScales;F.aRelativeParseScales=o.aRelativeParseScales;F.init();return F;};D.prototype.init=function(){var c=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData.getMonths("abbreviated",c);this.aMonthsWide=this.oLocaleData.getMonths("wide",c);this.aMonthsAbbrevSt=this.oLocaleData.getMonthsStandAlone("abbreviated",c);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",c);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",c);this.aDaysWide=this.oLocaleData.getDays("wide",c);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",c);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",c);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",c);this.aQuartersWide=this.oLocaleData.getQuarters("wide",c);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",c);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",c);this.aDayPeriods=this.oLocaleData.getDayPeriods("abbreviated",c);this.aFormatArray=this.parseJavaDateFormat(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray);};D.prototype.oStates={"G":"era","y":"year","Y":"weekYear","M":"month","L":"monthStandalone","w":"weekInYear","W":"weekInMonth","D":"dayInYear","d":"day","Q":"quarter","q":"quarterStandalone","F":"dayOfWeekInMonth","E":"dayNameInWeek","c":"dayNameInWeekStandalone","u":"dayNumberOfWeek","a":"amPmMarker","H":"hour0_23","k":"hour1_24","K":"hour0_11","h":"hour1_12","m":"minute","s":"second","S":"millisecond","z":"timezoneGeneral","Z":"timezoneRFC822","X":"timezoneISO8601"};D.prototype.format=function(d,u){if(u===undefined){u=this.oFormatOptions.UTC;}if(isNaN(d.getTime())){return"";}var c=this.oFormatOptions.calendarType;if((c===sap.ui.core.CalendarType.Islamic)&&d instanceof Date){d=new I(d.getTime());}if(this.oFormatOptions.relative){var r=this.formatRelative(d,u,this.oFormatOptions.relativeRange||[-6,6]);if(r){return r;}}var b=[],p,e=u?d.getUTCDay():d.getDay(),f=u?d.getUTCDate():d.getDate(),m=u?d.getUTCMonth():d.getMonth(),y=u?d.getUTCFullYear():d.getFullYear(),M=u?d.getUTCMilliseconds():d.getMilliseconds(),s=u?d.getUTCSeconds():d.getSeconds(),g=u?d.getUTCMinutes():d.getMinutes(),h=u?d.getUTCHours():d.getHours(),t=Math.abs(d.getTimezoneOffset()),P=d.getTimezoneOffset()>0,H=Math.floor(t/60),j=t%60,k=Math.floor(m/3),Y,w,l,R;for(var i=0;i<this.aFormatArray.length;i++){p=this.aFormatArray[i];switch(p.sType){case"text":b.push(p.sValue);break;case"day":b.push(q.sap.padLeft(String(f),"0",p.iDigits));break;case"dayNameInWeek":if(p.iDigits<4){b.push(this.aDaysAbbrev[e]);}else if(p.iDigits>=4){b.push(this.aDaysWide[e]);}break;case"dayNameInWeekStandalone":if(p.iDigits<4){b.push(this.aDaysAbbrevSt[e]);}else if(p.iDigits>=4){b.push(this.aDaysWideSt[e]);}break;case"dayNumberOfWeek":b.push(e||7);break;case"month":if(p.iDigits==3){b.push(this.aMonthsAbbrev[m]);}else if(p.iDigits>=4){b.push(this.aMonthsWide[m]);}else{b.push(q.sap.padLeft(String(m+1),"0",p.iDigits));}break;case"monthStandalone":if(p.iDigits==3){b.push(this.aMonthsAbbrevSt[m]);}else if(p.iDigits>=4){b.push(this.aMonthsWideSt[m]);}else{b.push(q.sap.padLeft(String(m+1),"0",p.iDigits));}break;case"quarter":if(p.iDigits==3){b.push(this.aQuartersAbbrev[k]);}else if(p.iDigits>=4){b.push(this.aQuartersWide[k]);}else{b.push(q.sap.padLeft(String(k+1),"0",p.iDigits));}break;case"quarterStandalone":if(p.iDigits==3){b.push(this.aQuartersAbbrevSt[k]);}else if(p.iDigits>=4){b.push(this.aQuartersWideSt[k]);}else{b.push(q.sap.padLeft(String(k+1),"0",p.iDigits));}break;case"era":if(p.iDigits<=3){b.push(this.oLocaleData.getEra("abbreviated",c));}else if(p.iDigits===4){b.push(this.oLocaleData.getEra("wide",c));}else{b.push(this.oLocaleData.getEra("narrow",c));}break;case"year":case"weekYear":Y=""+y;if(p.iDigits==2&&Y.length>2){Y=Y.substr(Y.length-2);}if(p.iDigits==1&&y<100){Y=q.sap.padLeft(Y,"0",4);}b.push(q.sap.padLeft(Y,"0",p.iDigits));break;case"weekInYear":if(c===sap.ui.core.CalendarType.Gregorian){w=""+D.calculateWeekNumber(d,{UTC:u,baseYear:y,locale:this.oLocale.toString()});if(p.iDigits<3){w=q.sap.padLeft(w,"0",p.iDigits);}else{w=this.oLocaleData.getCalendarWeek(p.iDigits===3?"narrow":"wide",q.sap.padLeft(w,"0",2));}b.push(w);}break;case"hour0_23":b.push(q.sap.padLeft(String(h),"0",p.iDigits));break;case"hour1_24":if(h==0){l="24";}else{l=String(h);}b.push(q.sap.padLeft(l,"0",p.iDigits));break;case"hour0_11":if(h>11){l=String(h-12);}else{l=String(h);}b.push(q.sap.padLeft(l,"0",p.iDigits));break;case"hour1_12":if(h>12){l=String(h-12);}else if(h==0){l="12";}else{l=String(h);}b.push(q.sap.padLeft(l,"0",p.iDigits));break;case"minute":b.push(q.sap.padLeft(String(g),"0",p.iDigits));break;case"second":b.push(q.sap.padLeft(String(s),"0",p.iDigits));break;case"millisecond":b.push(q.sap.padRight(q.sap.padLeft(String(M),"0",Math.min(3,p.iDigits)),"0",p.iDigits));break;case"amPmMarker":var n=h<12?0:1;b.push(this.aDayPeriods[n]);break;case"timezoneGeneral":if(p.iDigits>3&&d.getTimezoneLong){b.push(d.getTimezoneLong());break;}else if(d.getTimezoneShort){b.push(d.getTimezoneShort());break;}b.push("GMT");case"timezoneISO8601":if(!u&&t!=0){b.push(P?"-":"+");b.push(q.sap.padLeft(String(H),"0",2));b.push(":");b.push(q.sap.padLeft(String(j),"0",2));}else{b.push("Z");}break;case"timezoneRFC822":if(!u&&t!=0){b.push(P?"-":"+");b.push(q.sap.padLeft(String(H),"0",2));b.push(q.sap.padLeft(String(j),"0",2));}break;}}R=b.join("");if(sap.ui.getCore().getConfiguration().getOriginInfo()){R=new String(R);R.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern};}return R;};D.prototype.parse=function(v,u,s){if(u===undefined){u=this.oFormatOptions.UTC;}if(s===undefined){s=this.oFormatOptions.strictParsing;}var d,b=0,c=null,m=null,y=null,h=null,M=null,S=null,e=null,f=null,p=false,P,g,t=null,V=true,F,k,r=this.oRequiredParts,C=this.oFormatOptions.calendarType,l=[this.aDaysWide,this.aDaysWideSt,this.aDaysAbbrev,this.aDaysAbbrevSt],n=[this.aMonthsWide,this.aMonthsWideSt,this.aMonthsAbbrev,this.aMonthsAbbrevSt],o=[this.aQuartersWide,this.aQuartersWideSt,this.aQuartersAbbrev,this.aQuartersAbbrevSt];function w(j){return j>=48&&j<=57;}function x(j){var O=0;while(O<j&&w(v.charCodeAt(b+O))){O++;}return v.substr(b,O);}function z(O){var U=-1,W=0;for(var j=0;j<O.length;j++){if(O[j].length>W&&v.indexOf(O[j],b)==b){U=j;W=O[j].length;}}return{index:U,value:U===-1?null:O[U]};}function A(j){var O=v.charAt(b)=="+"?-1:1;b++;g=x(2);var U=parseInt(g,10);b=b+2;if(j){b++;}g=x(2);b=b+2;t=parseInt(g,10);t=(t+60*U)*O;}function B(j,O){if(j in r&&O){V=false;}}function E(j){F=z(j);if(F.index!==-1){b+=F.value.length;return true;}}v=q.trim(v);var d=this.parseRelative(v,u);if(d){return d;}for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];switch(P.sType){case"text":if(v.indexOf(P.sValue,b)==b){b+=P.sValue.length;}else{B(P.sType,this.aFormatArray[i+1].sType in r);}break;case"day":g=x(Math.max(P.iDigits,2));B(P.sType,g==="");b+=g.length;c=parseInt(g,10);if(s&&(c>31||c<1)){V=false;}break;case"dayNameInWeek":case"dayNameInWeekStandalone":l.some(E);break;case"dayNumberOfWeek":g=x(P.iDigits);b+=g.length;break;case"month":case"monthStandalone":if(P.iDigits<3){g=x(Math.max(P.iDigits,2));B(P.sType,g==="");m=parseInt(g,10)-1;b+=g.length;if(s&&(m>11||m<0)){V=false;}}else{k=n.some(E);if(k){m=F.index;}else{B(P.sType,true);}}break;case"quarter":case"quarterStandalone":if(P.iDigits<3){g=x(Math.max(P.iDigits,2));B(P.sType,g==="");f=parseInt(g,10)-1;b+=g.length;if(s&&f>3){V=false;}}else{k=o.some(E);if(k){f=F.index;}else{B(P.sType,true);}}break;case"era":if(P.iDigits<=3){g="abbreviated";}else if(P.iDigits===4){g="wide";}else{g="narrow";}b+=(this.oLocaleData.getEra(g).length);break;case"year":case"weekYear":if(P.iDigits==1){g=x(4);}else if(P.iDigits==2){g=x(2);}else{g=x(P.iDigits);}b+=g.length;B(P.sType,g==="");y=parseInt(g,10);if(g.length<=2){var G=this._now().getFullYear(),H=Math.floor(G/100),Y=H*100+y-G;if(Y<-70){y+=(H+1)*100;}else if(Y<30){y+=H*100;}else{y+=(H-1)*100;}}break;case"weekInYear":if(P.iDigits<3){g=x(2);b+=g.length;B(P.sType,!g);}else{g=this.oLocaleData.getCalendarWeek(P.iDigits===3?"narrow":"wide");g=g.replace("{0}","[0-9]+");var J=new RegExp(g),R=J.exec(v.substring(b));if(R){b+=R[0].length;}else{B(P.sType,true);}}break;case"hour0_23":g=x(Math.max(P.iDigits,2));B(P.sType,g==="");b+=g.length;h=parseInt(g,10);if(s&&h>23){V=false;}break;case"hour1_24":g=x(Math.max(P.iDigits,2));B(P.sType,g==="");b+=g.length;h=parseInt(g,10);if(h==24){h=0;}if(s&&h>23){V=false;}break;case"hour0_11":g=x(Math.max(P.iDigits,2));B(P.sType,g==="");b+=g.length;h=parseInt(g,10);if(s&&h>11){V=false;}break;case"hour1_12":g=x(Math.max(P.iDigits,2));B(P.sType,g==="");b+=g.length;h=parseInt(g,10);if(h==12){h=0;p=true;}if(s&&h>11){V=false;}break;case"minute":g=x(Math.max(P.iDigits,2));B(P.sType,g==="");b+=g.length;M=parseInt(g,10);if(s&&M>59){V=false;}break;case"second":g=x(Math.max(P.iDigits,2));B(P.sType,g==="");b+=g.length;S=parseInt(g,10);if(s&&S>59){V=false;}break;case"millisecond":g=x(Math.max(P.iDigits,3));b+=g.length;g=q.sap.padRight(g,"0",3);e=parseInt(g,10);break;case"amPmMarker":var K=this.aDayPeriods[0],N=this.aDayPeriods[1];if(v.indexOf(K,b)==b){p=false;b+=K.length;}else if(v.indexOf(N,b)==b){p=true;b+=N.length;}break;case"timezoneGeneral":var T=v.substring(b,b+3);if(T==="GMT"||T==="UTC"){b=b+3;}else if(v.substring(b,b+2)==="UT"){b=b+2;}else if(v.charAt(b)=="Z"){b=b+1;t=0;break;}else{q.sap.log.error(v+" cannot be parsed correcly by sap.ui.core.format.DateFormat: The given timezone is not supported!");break;}case"timezoneISO8601":if(v.charAt(b)=="Z"){b=b+1;t=0;break;}A(true);break;case"timezoneRFC822":A(false);break;}if(!V){break;}}if(b<v.length){V=false;}if(p){h+=12;}if(V){if(u||t!=null){d=D.createDate(C,0);d.setUTCFullYear(y||1970);d.setUTCMonth(m||0);d.setUTCDate(c||1);d.setUTCHours(h||0);d.setUTCMinutes(M||0);d.setUTCSeconds(S||0);d.setUTCMilliseconds(e||0);if(s&&(c||1)!==d.getUTCDate()){V=false;d=undefined;}else if(t){d.setUTCMinutes((M||0)+t);}}else{d=D.createDate(C,1970,0,1,0,0,0);d.setFullYear(y||1970);d.setMonth(m||0);d.setDate(c||1);d.setHours(h||0);d.setMinutes(M||0);d.setSeconds(S||0);d.setMilliseconds(e||0);if(s&&(c||1)!==d.getDate()){V=false;d=undefined;}}if(V){if(d instanceof I){d=new Date(d.getTime());}return d;}}if(!this.bIsFallback){q.each(this.aFallbackFormats,function(i,j){d=j.parse(v,u,s);if(d){return false;}});return d;}return null;};D.prototype.parseJavaDateFormat=function(f){var F=[],i,b=false,c=null,s="",n="";for(i=0;i<f.length;i++){var C=f.charAt(i),N,p,P;if(b){if(C=="'"){p=f.charAt(i-1);P=f.charAt(i-2);N=f.charAt(i+1);if(p=="'"&&P!="'"){b=false;}else if(N=="'"){i+=1;}else{b=false;continue;}}if(s=="text"){c.sValue+=C;}else{c={sType:"text",sValue:C};F.push(c);s="text";}}else{if(C=="'"){b=true;}else if(this.oStates[C]){n=this.oStates[C];if(s==n){c.iDigits++;}else{c={sType:n,iDigits:1};F.push(c);s=n;}}else{if(s=="text"){c.sValue+=C;}else{c={sType:"text",sValue:C};F.push(c);s="text";}}}}return F;};D.prototype._now=function(){return D.createDate(this.oFormatOptions.calendarType);};D.createDate=function(c){switch(c){case sap.ui.core.CalendarType.Islamic:return new(Function.prototype.bind.apply(I,arguments));default:return new(Function.prototype.bind.apply(Date,arguments));}};D.createUTCDate=function(c){var t=Array.prototype.shift.apply(arguments);switch(t){case sap.ui.core.CalendarType.Islamic:return I.UTC.apply(I,arguments);default:return Date.UTC.apply(Date,arguments);}};D.prototype.parseRelative=function(v,u){var t=this,c=this.oFormatOptions.calendarType,p,_,b,i,s,T,m,z;if(!v){return null;}for(var i=0;i<this.aRelativeParseScales.length;i++){T=this.aRelativeParseScales[i];m="getRelative"+T[0].toUpperCase()+T.substr(1);for(z=-2;z<=2;z++){p=this.oLocaleData[m](z);s=z<0?-1:1;if(p){switch(p.search(/\{0\}/)){case-1:if(p===v){return e(z,T);}break;case 0:_=p.replace(/\{0\}/,"");if(q.sap.endsWithIgnoreCase(v,_)){b=d(v);return e(b*s,T);}break;case p.length-3:_=p.replace(/\{0\}/,"");if(q.sap.startsWithIgnoreCase(v,_)){b=d(v);return e(b*s,T);}break;default:_=p.split(/\{0\}/);if(_.length==2&&q.sap.startsWithIgnoreCase(v,_[0])&&q.sap.endsWithIgnoreCase(v,_[1])){b=d(v);return e(b*s,T);}break;}}}}function d(v){return parseInt(v.match(/\d+/),10);}function e(f,S){var g,h,o=t._now(),U,j=f*t._mScales[S]*1000;if(t.oFormatOptions.relativeScale=="auto"&t.aRelativeScales[t.aRelativeScales.length-1]==="second"){if(u){h=o.getTime();}else{h=D.createUTCDate(c,o.getFullYear(),o.getMonth(),o.getDate(),o.getHours(),o.getMinutes(),o.getSeconds());}}else{if(u){h=D.createUTCDate(c,o.getUTCFullYear(),o.getUTCMonth(),o.getUTCDate());}else{h=D.createUTCDate(c,o.getFullYear(),o.getMonth(),o.getDate());}}var g=h+j;U=D.createDate(c,g);if(u){return U;}else{return D.createDate(c,U.getUTCFullYear(),U.getUTCMonth(),U.getUTCDate(),U.getUTCHours(),U.getUTCMinutes(),U.getUTCSeconds());}}};D.prototype.formatRelative=function(d,u,r){var t=this._now(),c=this.oFormatOptions.calendarType,s=this.oFormatOptions.relativeScale||"day",i,b,p,e,m;if(this.oFormatOptions.relativeScale=="auto"&this.aRelativeScales[this.aRelativeScales.length-1]==="second"){var T=D.createUTCDate(c,t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds());if(u){i=D.createUTCDate(c,d.getUTCFullYear(),d.getUTCMonth(),d.getUTCDate(),d.getUTCHours(),d.getUTCMinutes(),d.getUTCSeconds());}else{i=D.createUTCDate(c,d.getFullYear(),d.getMonth(),d.getDate(),d.getHours(),d.getMinutes(),d.getSeconds());}}else{var T=D.createUTCDate(c,t.getFullYear(),t.getMonth(),t.getDate());if(u){i=D.createUTCDate(c,d.getUTCFullYear(),d.getUTCMonth(),d.getUTCDate());}else{i=D.createUTCDate(c,d.getFullYear(),d.getMonth(),d.getDate());}}e=(i-T)/1000;if(this.oFormatOptions.relativeScale=="auto"){s=this._getScale(e,this.aRelativeScales);}b=this._getDifference(s,e);if(this.oFormatOptions.relativeScale!="auto"&&(b<r[0]||b>r[1])){return null;}m="getRelative"+s[0].toUpperCase()+s.substr(1);p=this.oLocaleData[m](b);if(!p){return null;}return q.sap.formatMessage(p,[Math.abs(b)]);};D.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592000,year:31536000};D.prototype._getScale=function(d,s){var S,t;d=Math.abs(d);for(var i=0;i<s.length;i++){t=s[i];if(d>=this._mScales[t]){S=t;break;}}if(!S){S=s[s.length-1];}return S;};D.prototype._getDifference=function(s,d){var S=this._mScales[s],i=d/S;if(d>0){i=Math.floor(i);}else{i=Math.ceil(i);}return i;};D.prototype.getAllowedCharacters=function(f){if(this.oFormatOptions.relative){return"";}var A="";var n=false;var b=false;var p;for(var i=0;i<this.aFormatArray.length;i++){p=this.aFormatArray[i];switch(p.sType){case"text":if(A.indexOf(p.sValue)<0){A+=p.sValue;}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"millisecond":if(!n){A+="0123456789";n=true;}break;case"month":case"monthStandalone":if(p.iDigits<3){if(!n){A+="0123456789";n=true;}}else{b=true;}break;default:b=true;break;}}if(b){A="";}return A;};D.calculateWeekNumber=function(d,p){var o={UTC:false,locale:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()};q.extend(o,p);if(o.baseYear===undefined){o.baseYear=o.UTC?d.getUTCFullYear():d.getFullYear();}var u=o.UTC,y=o.baseYear,l=o.locale;var w=0,W=0,b=new L(l),c=a.getInstance(b),f=c.getFirstDayOfWeek(),P=d.constructor.prototype;var s=u?P.setUTCFullYear:P.setFullYear,S=u?P.setUTCDate:P.setDate,g=u?P.getUTCDate:P.getDate,G=u?P.getUTCDay:P.getDay,e=u?P.setUTCMonth:P.setMonth;var h=function(d){return new d.constructor(d.getTime());};if(b.getLanguage()==="en"&&b.getRegion()==="US"){var j=h(d);s.apply(j,[y,0,1]);W=G.apply(j);var C=h(d);S.apply(C,[g.apply(C)-G.apply(C)+W]);w=Math.round((C.getTime()-j.getTime())/86400000/7)+1;}else{var t=h(d);S.apply(t,[g.apply(t)-f]);W=G.apply(t);S.apply(t,[g.apply(t)-W+4]);var F=h(t);e.apply(F,[0,1]);W=G.apply(F);var A=0;if(W>4){A=7;}var i=h(F);S.apply(i,[1-W+4+A]);w=Math.round((t.getTime()-i.getTime())/86400000/7)+1;}return w;};return D;},true);
