/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/dt/ElementOverlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/Selection','sap/ui/dt/DesignTimeMetadata','sap/ui/dt/ElementUtil','./library'],function(M,E,O,S,D,a){"use strict";var b=M.extend("sap.ui.dt.DesignTime",{metadata:{library:"sap.ui.dt",properties:{selectionMode:{type:"sap.ui.dt.SelectionMode",defaultValue:sap.ui.dt.SelectionMode.Single},designTimeMetadata:{type:"object"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{overlayCreated:{parameters:{ElementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},overlayDestroyed:{parameters:{ElementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},selectionChange:{parameters:{selection:{type:"sap.ui.dt.ElementOverlay[]"}}}}}});b.prototype.init=function(){this._oSelection=this.createSelection();this._oSelection.attachEvent("change",function(e){this.fireSelectionChange({selection:e.getParameter("selection")});},this);};b.prototype.exit=function(){this._destroyAllOverlays();this._oSelection.destroy();};b.prototype.createSelection=function(){return new S();};b.prototype.getSelection=function(){return this._oSelection.getSelection();};b.prototype.setSelectionMode=function(m){this.setProperty("selectionMode",m);this._oSelection.setMode(m);return this;};b.prototype.getPlugins=function(){return this.getAggregation("plugins")||[];};b.prototype.addPlugin=function(p){p.setDesignTime(this);this.addAggregation("plugins",p);return this;};b.prototype.insertPlugin=function(p,i){p.setDesignTime(this);this.insertAggregation("plugins",p,i);return this;};b.prototype.removePlugin=function(p){this.getPlugins().forEach(function(c){if(c===p){p.setDesignTime(null);return;}});this.removeAggregation("plugins",p);return this;};b.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(p){p.setDesignTime(null);});this.removeAllAggregation("plugins");return this;};b.prototype.getRootElements=function(){return this.getAssociation("rootElements")||[];};b.prototype.getDesignTimeMetadata=function(){return this.getProperty("designTimeMetadata")||{};};b.prototype.getDesignTimeMetadataFor=function(e){var c=e;var d=this.getDesignTimeMetadata();if(e.getMetadata){c=e.getMetadata()._sClassName;}return d[c];};b.prototype.addRootElement=function(r){this.addAssociation("rootElements",r);this.createOverlayFor(a.getElementInstance(r));return this;};b.prototype.removeRootElement=function(r){this.removeAssociation("rootElements",r);this._destroyOverlaysForElement(a.getElementInstance(r));return this;};b.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this;};b.prototype.createOverlay=function(e,d){return new E({element:e,designTimeMetadata:d?new D({data:d}):null});};b.prototype.getOverlays=function(){var o=[];this._iterateAllElements(function(e){var c=O.getOverlay(e);if(c){if(o.indexOf(c)===-1){o.push(c);}}});return o;};b.prototype._createOverlay=function(e){if(!O.getOverlay(e)){var m=this.getDesignTimeMetadataFor(e);var d=a.getDesignTimeMetadata(e);jQuery.extend(true,d,m);d=d!=={}?d:null;var o=this.createOverlay(e,d);o.attachEvent("elementModified",this._onElementModified,this);o.attachEvent("destroyed",this._onOverlayDestroyed,this);o.attachEvent("selectionChange",this._onOverlaySelectionChange,this);this.fireOverlayCreated({overlay:o});return o;}};b.prototype.createOverlayFor=function(r){var t=this;var R;this._iterateRootElementPublicChildren(r,function(e){var o=t._createOverlay(e);R=R||o;});return R;};b.prototype._destroyOverlaysForElement=function(r){this._iterateRootElementPublicChildren(r,function(e){var o=O.getOverlay(e);if(o){o.destroy();}});};b.prototype._destroyAllOverlays=function(){var t=this;this._iterateRootElements(function(r){t._destroyOverlaysForElement(r);});};b.prototype._onOverlayDestroyed=function(e){var o=e.getSource();if(o.getSelected()){this._oSelection.remove(o);}this.fireOverlayDestroyed({overlay:o});};b.prototype._onOverlaySelectionChange=function(e){var o=e.getSource();var s=e.getParameter("selected");this._oSelection.set(o,s);};b.prototype._onElementModified=function(e){var p=e.getParameters();if(p.type==="addAggregation"||p.type==="insertAggregation"){this._onOverlayElementAddAggregation(p.value);}else if(p.type==="setParent"){this._onOverlayElementSetParent(p.target,p.value);}};b.prototype._onOverlayElementAddAggregation=function(e){var o=O.getOverlay(e);if(!o){this.createOverlayFor(e);}};b.prototype._onOverlayElementSetParent=function(e,p){var o=O.getOverlay(e);if(o&&!this._isElementInRootElements(e)&&!e.__bSapUiDtSupressOverlayDestroy){o.destroy();}};b.prototype._isElementInRootElements=function(e){var f=false;this._iterateRootElements(function(r){if(a.hasAncestor(e,r)){f=true;return false;}});return f;};b.prototype._iterateRootElements=function(s){var r=this.getRootElements();r.forEach(function(R){var o=a.getElementInstance(R);s(o);});};b.prototype._iterateRootElementPublicChildren=function(r,s){var A=a.findAllPublicElements(r);A.forEach(function(e){s(e);});};b.prototype._iterateAllElements=function(s){var t=this;this._iterateRootElements(function(r){t._iterateRootElementPublicChildren(r,s);});};return b;},true);
