/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/dt/Overlay','sap/ui/dt/ControlObserver','sap/ui/dt/ManagedObjectObserver','sap/ui/dt/DesignTimeMetadata','sap/ui/dt/AggregationOverlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/DOMUtil'],function(q,O,C,M,D,A,a,E,b,c){"use strict";var d=O.extend("sap.ui.dt.ElementOverlay",{metadata:{library:"sap.ui.dt",properties:{visible:{type:"boolean",defaultValue:true},selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},draggable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false}},aggregations:{designTimeMetadata:{type:"sap.ui.dt.DesignTimeMetadata",multiple:false},aggregationOverlays:{type:"sap.ui.dt.AggregationOverlay",multiple:true}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},draggableChange:{parameters:{draggable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{selected:{editable:"boolean"}}},elementModified:{parameters:{type:{type:"string"},value:{type:"any"},oldValue:{type:"any"},target:{type:"sap.ui.core.Element"}}}}}});d.prototype.init=function(){O.prototype.init.apply(this,arguments);this._oDefaultDesignTimeMetadata=null;this.placeAt(O.getOverlayContainer());this._bVisible=null;};d.prototype.exit=function(){O.prototype.exit.apply(this,arguments);this._destroyDefaultDesignTimeMetadata();var e=this.getElementInstance();if(e){a.deregister(e);this._unobserve(e);}else{a.deregister(this._elementId);}if(!a.hasOverlays()){O.removeOverlayContainer();}delete this._bVisible;delete this._elementId;};d.prototype.setElement=function(e){var o=this.getElementInstance();if(o instanceof sap.ui.core.Element){a.deregister(o);this._unobserve(o);}this.destroyAggregation("aggregationOverlays");this._destroyDefaultDesignTimeMetadata();delete this._elementId;this.setAssociation("element",e);this._createAggregationOverlays();var f=this.getElementInstance();this._elementId=f.getId();a.register(f,this);this._observe(f);var p=b.getClosestOverlayFor(f);if(p){p.sync();}return this;};O.prototype.getAssociatedDomRef=function(){return E.getDomRef(this.getElementInstance());};d.prototype.getVisible=function(){if(this._bVisible===null){return this.getDesignTimeMetadata().isVisible();}else{return this.getProperty("visible");}};d.prototype.setVisible=function(v){this.setProperty("visible",v);this._bVisible=v;return this;};d.prototype.setSelectable=function(s){if(s!==this.isSelectable()){if(!s){this.setSelected(false);}this.toggleStyleClass("sapUiDtOverlaySelectable",s);this.setProperty("selectable",s);this.fireSelectableChange({selectable:s});}return this;};d.prototype.setSelected=function(s,S){if(this.isSelectable()&&s!==this.isSelected()){this.setProperty("selected",s);this.toggleStyleClass("sapUiDtOverlaySelected",s);if(!S){this.fireSelectionChange({selected:s});}}return this;};d.prototype.setDraggable=function(e){if(this.getDraggable()!==e){this.toggleStyleClass("sapUiDtOverlayDraggable",e);this.setProperty("draggable",e);this.fireDraggableChange({draggable:e});}return this;};d.prototype.setEditable=function(e){if(this.getEditable()!==e){this.toggleStyleClass("sapUiDtOverlayEditable",e);this.setProperty("editable",e);this.fireEditableChange({editable:e});}return this;};d.prototype.getDesignTimeMetadata=function(){var o=this.getAggregation("designTimeMetadata");if(!o&&!this._oDefaultDesignTimeMetadata){this._oDefaultDesignTimeMetadata=new D({data:E.getDesignTimeMetadata(this.getElementInstance())});}return o||this._oDefaultDesignTimeMetadata;};d.prototype.sync=function(){var t=this;var e=this.getAggregationOverlays();e.forEach(function(o){t._syncAggregationOverlay(o);});};d.prototype._createAggregationOverlays=function(){var e=this.getElementInstance();var o=this.getDesignTimeMetadata();if(e){var t=this;E.iterateOverAllPublicAggregations(e,function(f,g){var s=f.name;var h=new A({aggregationName:s,element:e,visible:o.isAggregationVisible(s)});t._syncAggregationOverlay(h);t.addAggregation("aggregationOverlays",h);});}};d.prototype._destroyDefaultDesignTimeMetadata=function(){if(this._oDefaultDesignTimeMetadata){this._oDefaultDesignTimeMetadata.destroy();this._oDefaultDesignTimeMetadata=null;}};d.prototype._observe=function(e){if(e instanceof sap.ui.core.Control){this._oObserver=new C({target:e});this._oObserver.attachDomChanged(this._onElementDomChanged,this);}else{this._oObserver=new M({target:e});}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this);};d.prototype._unobserve=function(e){this._oObserver.destroy();};d.prototype._syncAggregationOverlay=function(o){var s=o.getAggregationName();var e=E.getAggregation(this.getElementInstance(),s);e.forEach(function(f){var g=a.getOverlay(f);if(g){o.addChild(g);}});};d.prototype._onElementModified=function(e){this.sync();this.invalidate();this.fireElementModified(e.getParameters());};d.prototype._onElementDomChanged=function(){this.invalidate();};d.prototype._onElementDestroyed=function(){this.destroy();};d.prototype.getAggregationOverlays=function(){return this.getAggregation("aggregationOverlays")||[];};d.prototype.getChildren=function(){return this.getAggregationOverlays();};d.prototype.getAggregationOverlay=function(s){var e=this.getAggregationOverlays().filter(function(o){return o.getAggregationName()===s;});if(e.length){return e[0];}};d.prototype.getParentElementOverlay=function(){var p=this.getParentAggregationOverlay();if(p){return p.getParent();}};d.prototype.getParentAggregationOverlay=function(){var p=this.getParent();return p instanceof sap.ui.dt.AggregationOverlay?p:null;};d.prototype.isSelected=function(){return this.getSelected();};d.prototype.isSelectable=function(){return this.getSelectable();};d.prototype.isDraggable=function(){return this.getDraggable();};d.prototype.isEditable=function(){return this.getEditable();};d.prototype.isVisible=function(){return this.getVisible();};return d;},true);
