/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/Device","sap/ui/core/library","sap/ui/thirdparty/URI","sap/ui/core/message/MessageParser","sap/ui/core/message/Message"],function(q,D,c,U,M,a){"use strict";var s={"error":sap.ui.core.MessageType.Error,"warning":sap.ui.core.MessageType.Warning,"success":sap.ui.core.MessageType.Success,"info":sap.ui.core.MessageType.Information};var O=M.extend("sap.ui.model.odata.ODataMessageParser",{metadata:{publicMethods:["parse","setProcessor","getHeaderField","setHeaderField"]},constructor:function(S,m){M.apply(this);this._serviceUrl=b(this._parseUrl(S).url);this._metadata=m;this._processor=null;this._headerField="sap-message";this._lastMessages=[];}});O.prototype.getHeaderField=function(){return this._headerField;};O.prototype.setHeaderField=function(f){this._headerField=f;return this;};O.prototype.parse=function(r,R,G,C){var m=[];var e={url:R?R.requestUri:r.requestUri,request:R,response:r};if(r.statusCode>=200&&r.statusCode<300){this._parseHeader(m,r,e);}else if(r.statusCode>=400&&r.statusCode<600){this._parseBody(m,r,e);}else{q.sap.log.warning("No rule to parse OData response with status "+r.statusCode+" for messages");}if(this._processor){this._propagateMessages(m,e,G,C);}else{this._outputMesages(m);}};O.prototype._getAffectedTargets=function(m,r,G,C){var A=q.extend({"":true},G,C);var R=this._parseUrl(r).url;if(R.indexOf(this._serviceUrl)===0){R=R.substr(this._serviceUrl.length+1);}var e=this._metadata._getEntitySetByPath(R);if(e){A[e.name]=true;}for(var i=0;i<m.length;++i){var t=m[i].getTarget();if(t){var T=t.replace(/^\/+|\/$/g,"");A[T]=true;var p=T.lastIndexOf("/");while(p>-1){T=T.substr(0,p);A[T]=true;p=T.lastIndexOf("/");}e=this._metadata._getEntitySetByPath(t);if(e){A[e.name]=true;}}}return A;};O.prototype._propagateMessages=function(m,r,G,C){var i,t;var A=this._getAffectedTargets(m,r.url,G,C);var R=[];var k=[];for(i=0;i<this._lastMessages.length;++i){t=this._lastMessages[i].getTarget().replace(/^\/+|\/$/g,"");var p=t.lastIndexOf(")/");if(p>0){t=t.substr(0,p+1);}if(A[t]){R.push(this._lastMessages[i]);}else{k.push(this._lastMessages[i]);}}this.getProcessor().fireMessageChange({oldMessages:R,newMessages:m});this._lastMessages=k.concat(m);};O.prototype._createMessage=function(m,r,i){var t=m["@sap.severity"]?m["@sap.severity"]:m["severity"];t=s[t]?s[t]:t;var C=m.code?m.code:"";var T=typeof m["message"]==="object"&&m["message"]["value"]?m["message"]["value"]:m["message"];var e=m.longtext_url?m.longtext_url:"";var f=this._createTarget(m,r);return new a({type:t,code:C,message:T,descriptionUrl:e,target:f,processor:this._processor,technical:i});};O.prototype._getFunctionTarget=function(f,r,u){var t="";var i;if(r.response&&r.response.headers&&r.response.headers["location"]){t=r.response.headers["location"];var p=t.lastIndexOf(this._serviceUrl);if(p>-1){t=t.substr(p+this._serviceUrl.length);}}else{var A=null;if(f.extensions){for(i=0;i<f.extensions.length;++i){if(f.extensions[i].name==="action-for"){A=f.extensions[i].value;break;}}}var e;if(A){e=this._metadata._getEntityTypeByName(A);}else if(f.entitySet){e=this._metadata._getEntityTypeByPath(f.entitySet);}else if(f.returnType){e=this._metadata._getEntityTypeByName(f.returnType);}var E=this._metadata._getEntitySetByType(e);if(E&&e&&e.key&&e.key.propertyRef){var I="";var P;if(e.key.propertyRef.length===1){P=e.key.propertyRef[0].name;if(u.parameters[P]){I=u.parameters[P];}}else{var k=[];for(i=0;i<e.key.propertyRef.length;++i){P=e.key.propertyRef[i].name;if(u.parameters[P]){k.push(P+"="+u.parameters[P]);}}I=k.join(",");}t="/"+E.name+"("+I+")";}else if(!E){q.sap.log.error("Could not determine path of EntitySet for function call: "+u.url);}else{q.sap.log.error("Could not determine keys of EntityType for function call: "+u.url);}}return t;};O.prototype._createTarget=function(m,r){var t="";if(m.target){t=m.target;}else if(m.propertyref){t=m.propertyref;}if(t.substr(0,1)!=="/"){var R="";var u=this._parseUrl(r.url);var e=u.url;var p=e.lastIndexOf(this._serviceUrl);if(p>-1){R=e.substr(p+this._serviceUrl.length+1);}else{R=e;}var f=(r.request&&r.request.method)?r.request.method:"GET";var F=this._metadata._getFunctionImportMetadata(R,f);if(F){R=this._getFunctionTarget(F,r,u);if(t){t=R+"/"+t;}else{t=R;}}else{R="/"+R;var S=R.lastIndexOf("/");var h=S>-1?R.substr(S):R;if(h.indexOf("(")>-1){t=R+"/"+t;}else{t=R+t;}}}return t;};O.prototype._parseHeader=function(m,r,R){var f=this.getHeaderField();if(!r.headers||!r.headers[f]){return;}var e=r.headers[f];var S=null;try{S=JSON.parse(e);m.push(this._createMessage(S,R));if(S.details&&q.isArray(S.details)){for(var i=0;i<S.details.length;++i){m.push(this._createMessage(S.details[i],R));}}}catch(h){q.sap.log.error("The message string returned by the back-end could not be parsed");return;}};O.prototype._parseBody=function(m,r,R){var C=g(r);if(C&&C.indexOf("xml")>-1){this._parseBodyXML(m,r,R,C);}else{this._parseBodyJSON(m,r,R);}if(m.length>1){if(m[0].getCode()==m[1].getCode()&&m[0].getMessage()==m[1].getMessage()){m.shift();}}};O.prototype._parseBodyXML=function(e,r,R,C){try{var o=new DOMParser().parseFromString(r.body,C);var E=d(o,["error","errordetail"]);for(var i=0;i<E.length;++i){var N=E[i];var f={};f["severity"]=sap.ui.core.MessageType.Error;for(var n=0;n<N.childNodes.length;++n){var h=N.childNodes[n];var j=h.nodeName;if(j==="errordetails"||j==="details"||j==="innererror"||j==="#text"){continue;}if(j==="message"&&h.hasChildNodes()&&h.firstChild.nodeType!==window.Node.TEXT_NODE){for(var m=0;m<h.childNodes.length;++m){if(h.childNodes[m].nodeName==="value"){f["message"]=h.childNodes[m].text||h.childNodes[m].textContent;}}}else{f[h.nodeName]=h.text||h.textContent;}}e.push(this._createMessage(f,R,true));}}catch(k){q.sap.log.error("Error message returned by server could not be parsed");}};O.prototype._parseBodyJSON=function(m,r,R){try{var e=JSON.parse(r.body);var E;if(e["error"]){E=e["error"];}else{E=e["odata.error"];}if(!E){q.sap.log.error("Error message returned by server did not contain error-field");return;}E["severity"]=sap.ui.core.MessageType.Error;m.push(this._createMessage(E,R,true));var f=null;if(q.isArray(E.details)){f=E.details;}else if(E.innererror&&q.isArray(E.innererror.errordetails)){f=E.innererror.errordetails;}else{f=[];}for(var i=0;i<f.length;++i){m.push(this._createMessage(f[i],R,true));}}catch(h){q.sap.log.error("Error message returned by server could not be parsed");}};O.prototype._parseUrl=function(u){var m={url:u,parameters:{},hash:""};var p=-1;p=u.indexOf("#");if(p>-1){m.hash=m.url.substr(p+1);m.url=m.url.substr(0,p);}p=u.indexOf("?");if(p>-1){var P=m.url.substr(p+1);m.parameters=U.parseQuery(P);m.url=m.url.substr(0,p);}return m;};O.prototype._outputMesages=function(m){for(var i=0;i<m.length;++i){var o=m[i];var e="[OData Message] "+o.getMessage()+" - "+o.getDescription()+" ("+o.getTarget()+")";switch(m[i].getType()){case sap.ui.core.MessageType.Error:q.sap.log.error(e);break;case sap.ui.core.MessageType.Warning:q.sap.log.warning(e);break;case sap.ui.core.MessageType.Success:q.sap.log.debug(e);break;case sap.ui.core.MessageType.Information:case sap.ui.core.MessageType.None:default:q.sap.log.info(e);break;}}};function g(r){if(r&&r.headers){for(var h in r.headers){if(h.toLowerCase()==="content-type"){return r.headers[h].replace(/([^;]*);.*/,"$1");}}}return false;}var l=document.createElement("a");function b(u){l.href=u;return U.parse(l.href).path;}function d(o,e){var E=[];var m={};for(var i=0;i<e.length;++i){m[e[i]]=true;}var f=o;while(f){if(m[f.tagName]){E.push(f);}if(f.hasChildNodes()){f=f.firstChild;}else{while(!f.nextSibling){f=f.parentNode;if(!f||f===o){f=null;break;}}if(f){f=f.nextSibling;}}}return E;}return O;});
