/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/IntervalTrigger','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/SelectionModel','./Row','./library','sap/ui/core/IconPool','jquery.sap.dom'],function(q,C,I,S,a,P,b,R,c,d){"use strict";var T=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:sap.ui.table.SelectionMode.Multi},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:sap.ui.table.SelectionBehavior.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:sap.ui.table.NavigationMode.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:sap.ui.table.VisibleRowCountMode.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},allowColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},noDataText:{type:"string",group:"Appearance",defaultValue:null,deprecated:true}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}}}});T.ResizeTrigger=new I(300);d.insertFontFaceStyle();T.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bAccMode=sap.ui.getCore().getConfiguration().getAccessibility();this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._initSelectionModel(sap.ui.model.SelectionModel.MULTI_SELECTION);this._iColMinWidth=20;if('ontouchstart'in document){this._iColMinWidth=88;}this._oCalcColumnWidths=[];this._aIdxCols2Cells=[];this._aVisibleColumns=[];var f={onAfterRendering:function(e){e.srcControl.$("sb").attr("tabindex","-1").css("outline","none");}};this._oVSb=new S(this.getId()+"-vsb",{size:"100%"});this._oVSb._bLargeDataScrolling=false;this._oVSb.attachScroll(this.onvscroll,this);this._oVSb.addDelegate(f);this._oHSb=new S(this.getId()+"-hsb",{size:"100%",contentSize:"0px",vertical:false});this._oHSb.attachScroll(this.onhscroll,this);this._oHSb.addDelegate(f);this._bActionMode=false;this._iLastFixedColIndex=-1;this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._bCallUpdateTableCell=false;this._iTimerDelay=250;this._doubleclickDelay=300;this._clicksRegistered=0;this._bjQueryLess18=q.sap.Version(q.fn.jquery).compareTo("1.8")<0;this._iDataRequestedCounter=0;this._bDataRequestedListenersAttached=false;};T.prototype.exit=function(){this._oVSb.destroy();this._oHSb.destroy();if(this._oPaginator){this._oPaginator.destroy();}this._destroyItemNavigation();this._cleanUpTimers();this._detachEvents();};T.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};T.prototype.onBeforeRendering=function(){this._cleanUpTimers();this._detachEvents();};T.prototype.onAfterRendering=function(){this._bOnAfterRendering=true;var $=this.$();if('ontouchstart'in document){$.addClass("sapUiTableTouch");}this._renderOverlay();this._updateVSb(true);this._updateTableContent();this._handleResize();this._attachEvents();var e=this.getColumns();for(var i=0,l=e.length;i<l;i++){if(e[i].getVisible()){e[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._initItemNavigation();if(this._bDetermineVisibleCols===true){this._determineVisibleCols();this._bDetermineVisibleCols=false;}};T.prototype._renderOverlay=function(){var $=this.$(),e=$.find(".sapUiTableOverlay"),s=this.getShowOverlay();if(s&&e.length===0){e=q("<div>").addClass("sapUiOverlay sapUiTableOverlay").css("z-index","1");$.append(e);}else if(!s){e.remove();}};T.prototype.setShowOverlay=function(s){this.setProperty("showOverlay",s,true);this._renderOverlay();return this;};T.prototype._updateTableContent=function(){this._updateNoData();this._updateSelection();if(this._modifyRow){q.each(this.getRows(),function(i,r){this._modifyRow(i+this.getFirstVisibleRow(),r.$());this._modifyRow(i+this.getFirstVisibleRow(),r.$("fixed"));}.bind(this));}var B=this.getBinding("rows");var f=this.getFixedRowCount();var F=this.getFixedBottomRowCount();var v=this.getVisibleRowCount();q.each(this.getRows(),function(i,r){var $=r.getDomRefs(true);if(r.getBindingContext()&&this._isRowSelectable(r.getIndex())){$.rowSelector.attr("title",this._oResBundle.getText("TBL_ROW_SELECT"));}else{$.rowSelector.attr("title","");}if(f>0){$.row.toggleClass("sapUiTableFixedTopRow",i<f);$.row.toggleClass("sapUiTableFixedLastTopRow",i==f-1);}if(F>0){var e=false;if(B){if(B.getLength()>=v){e=(i==v-F-1);}else{e=(this.getFirstVisibleRow()+i)==(B.getLength()-F-1)&&(this.getFirstVisibleRow()+i)<B.getLength();}}$.row.toggleClass("sapUiTableFixedPreBottomRow",e);}}.bind(this));this._updateRowHeader();if(this._bOnAfterRendering&&(this._bCallUpdateTableCell||typeof this._updateTableCell==="function")){var o=this.mBindingInfos["rows"];q.each(this.getRows(),function(i,r){var A=this.getFirstVisibleRow()+i;q.each(r.getCells(),function(i,e){if(e._updateTableCell){e._updateTableCell(e,e.getBindingContext(o&&o.model),e.$().closest("td"),A);}if(this._updateTableCell){this._updateTableCell(e,e.getBindingContext(o&&o.model),e.$().closest("td"),A);}});}.bind(this));}};T.prototype._initItemNavigation=function(){var $=this.$();var e=this._getVisibleColumnCount();var t=e;var h=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;if(!this._oColHdrItemNav){this._oColHdrItemNav=new a();this._oColHdrItemNav.setCycling(false);this.addDelegate(this._oColHdrItemNav);}var f=[];if(this.getFixedColumnCount()==0){f=$.find(".sapUiTableCtrl td[tabindex]").get();}else{var g=this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixed');var j=this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixed');var k=this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowScroll');var l=this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowScroll');var m=this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom');var n=this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom');for(var i=0;i<this.getVisibleRowCount();i++){f=f.concat(g.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());f=f.concat(j.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());f=f.concat(k.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());f=f.concat(l.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());f=f.concat(m.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());f=f.concat(n.find('tr[data-sap-ui-rowindex="'+i+'"]').find('td[tabindex]').get());}}var o=f.length;var p=0;if(h){var r=$.find(".sapUiTableRowHdr").get();for(var i=r.length-1;i>=0;i--){f.splice(i*e,0,r[i]);o++;}o--;t++;p=1;}if(this.getColumnHeaderVisible()){f=$.find(".sapUiTableCol").get().concat(f);}if(h&&this.getColumnHeaderVisible()){var s=$.find(".sapUiTableColRowHdr").get();for(var i=this._getHeaderRowCount()-1;i>=0;i--){f.splice(i*e,0,s[0]);}}if(!this._oItemNavigation){this._iLastSelectedDataRow=this._getHeaderRowCount();this._oItemNavigation=new a();this._oItemNavigation.setTableMode(true);this._oItemNavigation.attachEvent(a.Events.BeforeFocus,function(E){this.$("ariadesc").text("");},this);this._oItemNavigation.attachEvent(a.Events.AfterFocus,function(E){var u=Math.floor(E.getParameter("index")/this._oItemNavigation.iColumns);if(u>0){this._iLastSelectedDataRow=u;}},this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setColumns(t);this._oItemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));this._oItemNavigation.setItemDomRefs(f);this._oItemNavigation.setFocusedIndex(p);};T.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this._oItemNavigation.destroy();this._oItemNavigation=undefined;}};T.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return sap.ui.core.Element.prototype.getFocusInfo.apply(this,arguments);}};T.prototype.applyFocusInfo=function(f){if(f&&f.customId){this.$().find("#"+f.customId).focus();}else{sap.ui.core.Element.prototype.getFocusInfo.apply(this,arguments);}return this;};T.prototype.setTitle=function(t){var o=t;if(typeof(t)==="string"||t instanceof String){o=sap.ui.table.TableHelper.createTextView({text:t,width:"100%"});o.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",o);return this;};T.prototype.setFooter=function(f){var F=f;if(typeof(f)==="string"||f instanceof String){F=sap.ui.table.TableHelper.createTextView({text:f,width:"100%"});}this.setAggregation("footer",F);return this;};T.prototype.setSelectionMode=function(s){this.clearSelection();if(s===sap.ui.table.SelectionMode.Single){this._oSelection.setSelectionMode(b.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(b.MULTI_SELECTION);}this.setProperty("selectionMode",s);return this;};T.prototype.setFirstVisibleRow=function(r,o){this.setProperty("firstVisibleRow",r,true);if(this.getBinding("rows")&&!this._bRefreshing){this.updateRows();}this._updateAriaRowOfRowsText(true);if(o&&!this._$AriaLiveDomRef&&this._bAccMode){if(this._ariaLiveTimer){q.sap.clearDelayedCall(this._ariaLiveTimer);}var s=function(){if(this._oItemNavigation){this._$AriaLiveDomRef=q(this._oItemNavigation.getFocusedDomRef()).attr("aria-live","rude");var t=this;var f=function(){if(t._$AriaLiveDomRef){t._$AriaLiveDomRef.removeAttr("aria-live");delete t._$AriaLiveDomRef;}};q.sap.delayedCall(0,this,f);delete this._ariaLiveTimer;}};this._ariaLiveTimer=q.sap.delayedCall(60,this,s);}return this;};T.prototype.getAllowColumnReordering=function(){q.sap.log.warning("getAllowColumnReordering is deprecated - please use getEnableColumnReordering!");return T.prototype.getEnableColumnReordering.apply(this,arguments);};T.prototype.setAllowColumnReordering=function(){q.sap.log.warning("setAllowColumnReordering is deprecated - please use setEnableColumnReordering!");return T.prototype.setEnableColumnReordering.apply(this,arguments);};T.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;T.prototype.bindRows=function(B,t,s,f){if(typeof B==="string"&&(t instanceof sap.ui.model.Sorter||q.isArray(s)&&s[0]instanceof sap.ui.model.Filter)){f=s;s=t;t=undefined;}return this.bindAggregation("rows",B,t,s,f);};T.prototype._bindAggregation=function(n,p,t,s,f){sap.ui.core.Element.prototype._bindAggregation.apply(this,arguments);var B=this.getBinding("rows");if(n==="rows"&&B){B.attachChange(this._onBindingChange,this);}this._initSelectionModel(sap.ui.model.SelectionModel.MULTI_SELECTION);if(B&&this.isTreeBinding("rows")&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}return this;};T.prototype._initSelectionModel=function(s){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new sap.ui.model.SelectionModel(s);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};T.prototype._onBindingChange=function(e){var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r==="sort"||r==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};T.prototype.unbindAggregation=function(n,s){var B=this.getBinding("rows");if(n==="rows"&&B){B.detachChange(this._onBindingChange);s=true;this._restoreAppDefaultsColumnHeaderSortFilter();}this.updateRows();return sap.ui.core.Element.prototype.unbindAggregation.apply(this,[n,s]);};T.prototype.setVisibleRowCountMode=function(v){this.setProperty("visibleRowCountMode",v);this._handleRowCountMode();return this;};T.prototype.setVisibleRowCount=function(v){if(v!=null&&!isFinite(v)){return this;}if(v<=(this.getFixedRowCount()+this.getFixedBottomRowCount())){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+v+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')");return this;}v=this.validateProperty("visibleRowCount",v);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=v){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",v);return this;};T.prototype.refreshRows=function(r){this._attachBindingListener();this._bBusyIndicatorAllowed=true;this._bRefreshing=true;this._onBindingChange(r);this._updateBindingContexts(true);this._bRefreshing=false;};T.prototype.updateRows=function(r){this._setBusy(r?{changeReason:r}:false);var s=this.getFirstVisibleRow();s=Math.max(s,0);if(this.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar&&this._getRowCount()>0){s=Math.min(s,Math.max(this._getRowCount()-this.getVisibleRowCount(),0));}this.setProperty("firstVisibleRow",s,true);if(this._oVSb.getScrollPosition()!==s){this._oVSb.setScrollPosition(s);this._updateAriaRowOfRowsText(true);}if(this._oPaginator&&this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){var n=1;if(s<this.getBinding("rows").getLength()){n=Math.ceil((s+1)/this.getVisibleRowCount());}if(n!==this._oPaginator.getCurrentPage()){this.setProperty("firstVisibleRow",(n-1)*this.getVisibleRowCount(),true);this._oPaginator.setCurrentPage(n);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}}if(this.getDomRef()){this._sBindingTimer=this._sBindingTimer||q.sap.delayedCall(50,this,function(){if(!this.bIsDestroyed){this._determineVisibleCols();this._updateBindingContexts();this._updateVSb();this._updateTableContent();this._sBindingTimer=undefined;this.fireEvent("_rowsUpdated");}});}};T.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!");};T.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!");};T.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!");};T.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!");};T.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!");};T.prototype.autoResizeColumn=function(i){var o=this.getColumns()[i];this._iColumnResizeStart=null;var n=this._calculateAutomaticColumnWidth(i);if(n==null){return;}o._iNewWidth=n;this._oCalcColumnWidths[i]=o._iNewWidth;this._onColumnResized(null,i);};T.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableRowHdr").hover(function(){q(this).addClass("sapUiTableRowHvr");var i=$.find(".sapUiTableRowHdr").index(this);$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlFixed > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var i=$.find(".sapUiTableCtrlFixed > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+(i)+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableCtrlScroll > tbody > tr").hover(function(){q(this).addClass("sapUiTableRowHvr");var i=$.find(".sapUiTableCtrlScroll > tbody > tr").index(this);$.find(".sapUiTableRowHdr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq("+i+")").addClass("sapUiTableRowHvr");},function(){q(this).removeClass("sapUiTableRowHvr");$.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");$.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");});$.find(".sapUiTableColRsz").mousedown(q.proxy(this._onColumnResizeStart,this));this._enableColumnAutoResizing();T.ResizeTrigger.addListener(this._checkTableSize,this);this._oHSb.bind($.find(".sapUiTableCtrlScr").get(0));this._oVSb.bind($.find(".sapUiTableCtrlScr").get(0));this._oHSb.bind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.bind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.bind($.find(".sapUiTableRowHdrScr").get(0));q("body").bind('webkitTransitionEnd transitionend',q.proxy(function(e){if(q(e.target).has($).length>0){this._handleResize();}},this));};T.prototype._detachEvents=function(){var $=this.$();$.find(".sapUiTableRowHdrScr").unbind();$.find(".sapUiTableColHdrScr").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();T.ResizeTrigger.removeListener(this._checkTableSize,this);$.find(".sapUiTableColRsz").unbind();this._oHSb.unbind($.find(".sapUiTableCtrlScr").get(0));this._oVSb.unbind($.find(".sapUiTableCtrlScr").get(0));this._oHSb.unbind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.unbind($.find(".sapUiTableCtrlScrFixed").get(0));this._oVSb.unbind($.find(".sapUiTableRowHdrScr").get(0));q("body").unbind('webkitTransitionEnd transitionend');};T.prototype._cleanUpTimers=function(){if(this._sBindingTimer){q.sap.clearDelayedCall(this._sBindingTimer);this._sBindingTimer=undefined;}if(this._sScrollBarTimer){q.sap.clearDelayedCall(this._sScrollBarTimer);this._sScrollBarTimer=undefined;}if(this._sDelayedMenuTimer){q.sap.clearDelayedCall(this._sDelayedMenuTimer);this._sDelayedMenuTimer=undefined;}if(this._sDelayedActionTimer){q.sap.clearDelayedCall(this._sDelayedActionTimer);this._sDelayedActionTimer=undefined;}if(this._sColHdrPosTimer){q.sap.clearDelayedCall(this._sColHdrPosTimer);this._sColHdrPosTimer=undefined;}if(this._visibleRowCountTimer){q.sap.clearDelayedCall(this._visibleRowCountTimer);this._visibleRowCountTimer=undefined;}T.ResizeTrigger.removeListener(this._checkTableSize,this);};T.prototype._getFixedBottomRowContexts=function(B){var f=this.getFixedBottomRowCount();var v=this.getVisibleRowCount();var e;if(f>0&&(v-f)<B.getLength()){e=B.getContexts(B.getLength()-f,f,1);}else{e=[];}return e;};T.prototype._createRows=function(s){var f=this.getFirstVisibleRow();var v=this.getVisibleRowCount();s=s===undefined?f:s;var t=new R(this.getId()+"-rows");var e=this.getColumns();var g=0;for(var i=0,l=e.length;i<l;i++){if(e[i].getVisible()){var o=e[i].getTemplate();if(o){var h=o.clone("col"+i);if(this._bInheritEditableToControls&&!this.getEditable()&&h.setEditable){h.setEditable(false);}h.data("sap-ui-colindex",i);h.data("sap-ui-colid",e[i].getId());t.addCell(h);this._aIdxCols2Cells[i]=g++;}}}this.destroyAggregation("rows",true);var j;var B=this.getBinding("rows");var k=this.mBindingInfos["rows"];if(B&&v>0){var m=this.getThreshold()?Math.max(this.getVisibleRowCount(),this.getThreshold()):0;var F=this.getFixedBottomRowCount();j=B.getContexts(s,v-F,m);this._setBusy({requestedLength:v-F,receivedLength:j.length,contexts:j});var n=[];n=this._getFixedBottomRowContexts(B);j=j.concat(n);if(F>0&&(v-F)<B.getLength()){this._setBusy({requestedLength:F,receivedLength:n.length,contexts:n});}}for(var i=0;i<v;i++){var h=t.clone("row"+i);if(j&&j[i]){h.setBindingContext(j[i],k.model);h._bHidden=false;}else{if(k){h.setBindingContext(null,k.model);}else{h.setBindingContext(null);}h._bHidden=true;}this.addAggregation("rows",h,true);}t.destroy();};T.prototype._updateHSb=function(){var $=this.$();var i=$.find(".sapUiTableCtrlScroll").width();if(!!sap.ui.Device.browser.safari){i=Math.max(i,this._getColumnsWidth(this.getFixedColumnCount()));}if(i>$.find(".sapUiTableCtrlScr").width()){if(!$.hasClass("sapUiTableHScr")){$.addClass("sapUiTableHScr");if(!!sap.ui.Device.browser.safari){var e=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");if(this._bjQueryLess18){e.width(i);}else{e.outerWidth(i);}}}var s=$.find(".sapUiTableCtrlFixed").width();if($.find(".sapUiTableRowHdrScr:visible").length>0){s+=$.find(".sapUiTableRowHdrScr").width();}var f=$.find(".sapUiTableHSb");if(this._bRtlMode){f.css('padding-right',s+'px');}else{f.css('padding-left',s+'px');}var m=f.parent().width();f.css('max-width',m+"px");this._oHSb.setContentSize(i+"px");if(this._oHSb.getDomRef()){this._oHSb.rerender();}}else{if($.hasClass("sapUiTableHScr")){$.removeClass("sapUiTableHScr");if(!!sap.ui.Device.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}this._syncHeaderAndContent();};T.prototype._updateVSb=function(o){var $=this.$();var D=false;var f=false;var B=this.getBinding("rows");if(B){var F=this.getFixedRowCount();if(F>0){var O=$.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetTop;this.$().find('.sapUiTableVSb').css('top',(O-1)+'px');f=true;}var i=this.getFixedBottomRowCount();if(i>0){var e=$.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetHeight;this.$().find('.sapUiTableVSb').css('height',e+'px');f=true;}var l=B.getLength();var s=Math.max(0,(l||0)-this.getVisibleRowCount());if(this._oPaginator&&this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){var n=Math.ceil((l||0)/this.getVisibleRowCount());this._oPaginator.setNumberOfPages(n);var p=Math.min(n,Math.ceil((this.getFirstVisibleRow()+1)/this.getVisibleRowCount()));this.setProperty("firstVisibleRow",(Math.max(p,1)-1)*this.getVisibleRowCount(),true);this._oPaginator.setCurrentPage(p);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}if($.hasClass("sapUiTableVScr")){$.removeClass("sapUiTableVScr");}}else{if(s>0){if(!$.hasClass("sapUiTableVScr")){$.addClass("sapUiTableVScr");D=true;}}else{if(l>0){this.setFirstVisibleRow(0);}if($.hasClass("sapUiTableVScr")){$.removeClass("sapUiTableVScr");D=true;}}}if(o||f||s!==this._oVSb.getSteps()||this.getFirstVisibleRow()!==this._oVSb.getScrollPosition()){q.sap.clearDelayedCall(this._sScrollBarTimer);this._sScrollBarTimer=q.sap.delayedCall(o?0:250,this,function(){var s=0;if(B){s=Math.max(0,(B.getLength()||0)-this.getVisibleRowCount());}this._oVSb.setSteps(s);if(this._oVSb.getDomRef()){this._oVSb.rerender();}this._oVSb.setScrollPosition(this.getFirstVisibleRow());});}}else{if(this._oPaginator&&this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){this._oPaginator.setNumberOfPages(0);this._oPaginator.setCurrentPage(0);if(this._oPaginator.getDomRef()){this._oPaginator.rerender();}}else{if($.hasClass("sapUiTableVScr")){$.removeClass("sapUiTableVScr");D=true;}}}if(D&&!this._bOnAfterRendering){this._handleResize();}};T.prototype._updateBindingContexts=function(s){var r=this.getRows(),B=this.getBinding("rows"),o=this.mBindingInfos["rows"],f,e,F,i=this.getFixedRowCount(),g=this.getFixedBottomRowCount(),v=this.getVisibleRowCount();if(B){var t;if((i>0||g>0)&&r.length>0){var h=i+g;t=this.getThreshold()?Math.max((this.getVisibleRowCount()-h),this.getThreshold()):0;var j=Math.max(0,r.length-h);e=B.getContexts(this.getFirstVisibleRow()+i,j,t);this._setBusy({requestedLength:j,receivedLength:e.length,contexts:e});if(i>0){f=B.getContexts(0,i);this._setBusy({requestedLength:i,receivedLength:f.length,contexts:f});e=f.concat(e);}var F=this._getFixedBottomRowContexts(B);e=e.concat(F);if(g>0&&(v-g)<B.getLength()){this._setBusy({requestedLength:g,receivedLength:F.length,contexts:F});}}else if(r.length>0){t=this.getThreshold()?Math.max(this.getVisibleRowCount(),this.getThreshold()):0;e=B.getContexts(this.getFirstVisibleRow(),r.length,t);this._setBusy({requestedLength:r.length,receivedLength:e.length,contexts:e});}}if(!s){for(var k=r.length-1;k>=0;k--){var l=e?e[k]:undefined;var m=r[k];if(m){var A=this.getFirstVisibleRow()+k;this._updateRowBindingContext(m,l,o&&o.model,A);}}}};T.prototype._updateRowBindingContext=function(r,o,m,A){var e=r.getCells();var $=r.getDomRefs(true).row;r.setBindingContext(o,m);if(o&&o instanceof sap.ui.model.Context){for(var i=0,l=this._aVisibleColumns.length;i<l;i++){var f=this._aIdxCols2Cells[this._aVisibleColumns[i]];if(e[f]){this._updateCellBindingContext(e[f],o,m,A);}}$.removeClass("sapUiTableRowHidden");r._bHidden=false;}else{$.addClass("sapUiTableRowHidden");$.removeClass('sapUiTableFixedPreBottomRow sapUiTableFixedTopRow');r._bHidden=true;for(var i=0,l=this._aVisibleColumns.length;i<l;i++){var f=this._aIdxCols2Cells[this._aVisibleColumns[i]];if(e[f]){this._updateCellBindingContext(e[f],o,m,A);}}}};T.prototype._updateCellBindingContext=function(o,e,m,A){if(this._bCallUpdateTableCell&&o._updateTableCell){o._updateTableCell(o,e,o.$().closest("td"),A);}if(typeof this._updateTableCell==="function"){this._updateTableCell(o,e,o.$().closest("td"),A);}};T.prototype._hasData=function(){var B=this.getBinding("rows");if(!B||(B.getLength()||0)===0){return false;}return true;};T.prototype._updateNoData=function(){if(this.getShowNoData()){var B=this.getBinding("rows");if(!this._hasData()){if(!this.$().hasClass("sapUiTableEmpty")){this.$().addClass("sapUiTableEmpty");}this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS",[0]));}else{if(this.$().hasClass("sapUiTableEmpty")){this.$().removeClass("sapUiTableEmpty");}this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS",[(B.getLength()||0)]));}}};T.prototype._determineVisibleCols=function(){var $=this.$(),t=this;if($.hasClass("sapUiTableHScr")){var r=this._bRtlMode;var s=this._oHSb.getNativeScrollPosition();if(r&&sap.ui.Device.browser.firefox&&s<0){s=s*-1;}var e=s+this._getScrollWidth();if(this._iOldScrollLeft!==s||this._iOldScrollRight!==e||this._bForceVisibleColCalc){var L=r?$.find(".sapUiTableCtrlScroll").width():0;if((sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.firefox)&&r){L=0;}this._aVisibleColumns=[];for(var i=0,l=this.getFixedColumnCount();i<l;i++){this._aVisibleColumns.push(i);}var f=$.find(".sapUiTableCtrl.sapUiTableCtrlScroll .sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex]");f.each(function(h,E){var w=q(E).width();if(r&&sap.ui.Device.browser.chrome){L-=w;}if(L+w>=s&&L<=e){t._aVisibleColumns.push(parseInt(q(E).data('sap-ui-headcolindex'),10));}if(!r||(sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.firefox)){L+=w;}});this._iOldScrollLeft=s;this._iOldScrollRight=e;this._bForceVisibleColCalc=false;}}else{this._aVisibleColumns=[];var g=this.getColumns();for(var i=0,l=g.length;i<l;i++){if(g[i].shouldRender()){this._aVisibleColumns.push(i);}}}};T.prototype._enableColumnAutoResizing=function(){var t=this;q.each(this.getColumns(),function(i,o){if(!!o.getAutoResizable()){var $=q.find(".sapUiTableColRsz[data-sap-ui-colindex="+i+"]");if($){t._bindSimulatedDoubleclick($,null,t._onAutomaticColumnResize);}}});};T.prototype.removeColumn=function(o){var r=this.removeAggregation('columns',o);this._bDetermineVisibleCols=true;if(typeof o==="number"&&o>-1){o=this.getColumns()[o];}var i=q.inArray(o,this._aSortedColumns);if(this._iNewColPos===undefined&&i>=0){this._aSortedColumns.splice(i,1);}return r;};T.prototype.removeAllColumns=function(){var r=this.removeAllAggregation('columns');this._aSortedColumns=[];return r;};T.prototype.destroyColumns=function(){var r=this.destroyAggregation('columns');this._aSortedColumns=[];return r;};T.prototype.addColumn=function(o){var t=this;this.addAggregation('columns',o);o.attachEvent('_widthChanged',function(e){t._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;return this;};T.prototype.insertColumn=function(o,i){var t=this;this.insertAggregation('columns',o,i);o.attachEvent('_widthChanged',function(){t._bForceVisibleColCalc=true;});this._bDetermineVisibleCols=true;return this;};T.prototype._getRowCount=function(){var B=this.getBinding("rows");return B?(B.getLength()||0):0;};T.prototype._getSelectableRowCount=function(){return this._getRowCount();};T.prototype._getScrollTop=function(){if(this.$().hasClass("sapUiTableVScr")){return this._oVSb.getScrollPosition()||0;}else{if(this.getNavigationMode()===sap.ui.table.NavigationMode.Paginator){return(((this._oPaginator.getCurrentPage()||1)-1)*this.getVisibleRowCount());}else{return 0;}}};T.prototype._getScrollWidth=function(){return this.$().find(".sapUiTableCtrlScr").width();};T.prototype._getScrollHeight=function(){return this.$().find(".sapUiTableCtrlScr").height();};T.prototype._getVisibleColumns=function(){var e=[];var f=this.getColumns();for(var i=0,l=f.length;i<l;i++){if(f[i].shouldRender()){e.push(f[i]);}}return e;};T.prototype._getVisibleColumnCount=function(){return this._getVisibleColumns().length;};T.prototype._getHeaderRowCount=function(){if(!this.getColumnHeaderVisible()){return 0;}else if(!this._useMultiHeader()){return 1;}var h=0;q.each(this._getVisibleColumns(),function(i,o){h=Math.max(h,o.getMultiLabels().length);});return h;};T.prototype._useMultiHeader=function(){var u=false;q.each(this._getVisibleColumns(),function(i,o){if(o.getMultiLabels().length>0){u=true;return false;}});return u;};T.prototype._getColumnsWidth=function(s,e){var f=this.getColumns();var g=0;if(s!==0&&!s){s=0;}if(e!==0&&!e){e=f.length;}for(var i=s,l=e;i<l;i++){if(f[i]&&f[i].shouldRender()){g+=this._CSSSizeToPixel(f[i].getWidth());}}return g;};T.prototype._CSSSizeToPixel=function(s,r){var p=this._iColMinWidth;if(s){if(q.sap.endsWith(s,"px")){p=parseInt(s,10);}else if(q.sap.endsWith(s,"em")||q.sap.endsWith(s,"rem")){p=Math.ceil(parseFloat(s)*this._getBaseFontSize());}}if(r){return p+"px";}else{return parseInt(p,10);}};T.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};T.prototype._handleResize=function(){if(!this.getDomRef()){return;}this._updateHSb();this._updateColumnHeader();this._updateRowHeader();this._handleRowCountMode();};T.prototype._checkTableSize=function(){if(!this.getDomRef()){return;}var p=this.getDomRef().parentNode,h=p.offsetHeight,w=p.offsetWidth;if(p!=this._lastParent||h!=this._lastParentHeight||w!=this._lastParentWidth){this._handleResize();this._lastParent=p;this._lastParentHeight=h;this._lastParentWidth=w;if(this.getBinding("rows")){this.updateRows();}}};T.prototype._handleRowCountMode=function(){if(this.getVisibleRowCountMode()==sap.ui.table.VisibleRowCountMode.Auto){var i=this.$().parent().height();var r=this._calculateRowsToDisplay(i);if(isNaN(r)){return;}var t=this;this._visibleRowCountTimer=setTimeout(function(){t.setVisibleRowCount(r);},0);}};T.prototype._updateRowHeader=function(){if(this.getFixedRowCount()>=0||this.getFixedColumnCount()>=0||this.getRowHeight()<=0){var $=this.$();var e=$.find(".sapUiTableCtrlFixed > tbody > tr");var f=$.find(".sapUiTableCtrlScroll > tbody > tr");var g=$.find(".sapUiTableRowHdr");if(this.getFixedColumnCount()>0&&!this.getRowHeight()){e.css('height','');f.css('height','');}for(var i=0,l=f.length;i<l;i++){var h=Math.max(e[i]?(e[i].getBoundingClientRect().bottom-e[i].getBoundingClientRect().top):0,f[i]?(f[i].getBoundingClientRect().bottom-f[i].getBoundingClientRect().top):0);if(this._bjQueryLess18){q(g[i]).height(h);if(this.getFixedColumnCount()>0&&!this.getRowHeight()){q(e[i]).height(h);q(f[i]).height(h);}}else{q(g[i]).outerHeight(h);if(this.getFixedColumnCount()>0&&!this.getRowHeight()){q(e[i]).outerHeight(h);q(f[i]).outerHeight(h);}}}}};T.prototype._syncColumnHeaders=function(u){var D=this.getDomRef();if(!D){return;}var $=this.$();var r=D.getBoundingClientRect();var t=r.right-r.left;var v=this._getVisibleColumns();if(v.length==0){return;}var e=0;var f=this._bRtlMode;var l=f?99000:-99000;var g=$.find(".sapUiTableColHdr");var h=$.find(".sapUiTableCtrlFirstCol > th");var H=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;if(H){var o=h.get(0);e=o.getBoundingClientRect().right-o.getBoundingClientRect().left;h=h.not(":nth-child(1)");}var m={};h.each(function(z,E){var A=E.getAttribute("data-sap-ui-headcolindex");var B=E.getBoundingClientRect();var F;var V=v[z];if(V){F=B.right-B.left;}if(z==0){F+=e;}var G=v[z]?v[z].getHeaderSpan():1,J=[],K;if(G){if(!q.isArray(G)){G=[G];}q.each(G,function(O,Q){G[O]=Math.max((Q+z>v.length)?Math.min(Q,v.length-z):Q,1);});K=G;}else{K=[1];}for(var i=0;i<K.length;i++){J[i]={width:F,span:1};for(var j=1;j<K[i];j++){var L=h[z+j];var M=L.getBoundingClientRect();if(L){J[i].width+=M.right-M.left;J[i].span=K[i];}}}if(V){var N=document.getElementById(V.getId()+"-rsz");m[A]={domRefColumnTh:E,domRefColumnDivs:[],domRefColumnResizer:N,domRefColumnResizerPosition:undefined,rect:B,aHeaderData:J};}});var k=g.find(".sapUiTableCol");k.each(function(j,E){var z=parseInt(E.getAttribute("data-sap-ui-colindex"),10);var A=m[z];A.domRefColumnDivs.push(E);var B=0;if(A){if(!f){B=A.rect.right-r.left;}else{B=A.rect.left-r.left;}}if(!B||B<=0||B>=t){B=l;}A.domRefColumnResizerPosition=B;});q.each(m,function(j,z){for(var i=0;i<z.domRefColumnDivs.length;i++){var A=z.aHeaderData[0];if(z.aHeaderData[i]){A=z.aHeaderData[i];}z.domRefColumnDivs[i].style.width=A.width+"px";z.domRefColumnDivs[i].setAttribute("data-sap-ui-colspan",A.span);if(z.domRefColumnResizer){z.domRefColumnResizer.style.left=z.domRefColumnResizerPosition+"px";}}});var n=this._getHeaderRowCount();var p=this.getColumnHeaderHeight()>0;if(!p&&!u){var s=$.find(".sapUiTableColHdrCnt,.sapUiTableColRowHdr");var w=k.length;for(var i=0;i<w;i++){k[i].style.height='auto';}s.height("auto");var x=Math.max(g.height(),s.height());var y=x/n;if(this._bjQueryLess18){k.height(y);s.height(x);}else{k.outerHeight(y);s.outerHeight(x);}}};T.prototype._updateColumnHeader=function(u){if(this._sColHdrPosTimer){q.sap.clearDelayedCall(this._sColHdrPosTimer);}if(this._bOnAfterRendering){this._syncColumnHeaders.apply(this,arguments);}else{this._sColHdrPosTimer=q.sap.delayedCall(150,this,this._syncColumnHeaders,arguments);}};T.prototype._disableTextSelection=function(e){q(e||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(E){E.preventDefault();return false;});};T.prototype._enableTextSelection=function(e){q(e||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};T.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(e){}}};T.prototype.onvscroll=function(e){this._leaveActionMode();this.setFirstVisibleRow(this._getScrollTop(),true);};T.prototype._syncHeaderAndContent=function(){if(!this._bSyncScrollLeft){this._bSyncScrollLeft=true;var $=this.$();var s=this._oHSb.getNativeScrollPosition();$.find(".sapUiTableCtrlScr").scrollLeft(s);if(!!sap.ui.Device.browser.webkit&&this._bRtlMode){var o=$.find(".sapUiTableColHdrScr").get(0);s=o.scrollWidth-o.clientWidth-this._oHSb.getScrollPosition();}$.find(".sapUiTableColHdrScr").scrollLeft(s);this._bSyncScrollLeft=false;}};T.prototype.onhscroll=function(e){if(!this._bOnAfterRendering){this._syncHeaderAndContent();this._updateColumnHeader(true);if(this.getBinding("rows")){this.updateRows();}}};T.prototype._oncolscroll=function(e){if(!this._bSyncScrollLeft){var $=this.$().find(".sapUiTableColHdrScr");if(!!sap.ui.Device.browser.webkit&&this._bRtlMode){var s=this.$().find(".sapUiTableColHdrScr").get(0);this._oHSb.setScrollPosition(s.scrollWidth-s.clientWidth-$.scrollLeft());}else{this._oHSb.setNativeScrollPosition($.scrollLeft());}}};T.prototype._oncntscroll=function(e){if(!this._bSyncScrollLeft){var $=this.$().find(".sapUiTableCtrlScr");this._oHSb.setNativeScrollPosition($.scrollLeft());}};T.prototype.onmousedown=function(e){var l=e.button===(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=8?1:0);var i=this._isTouchMode(e);if(l){var $=q(e.target);var f=this.$("sb");if(e.target==f[0]){q(document.body).bind("selectstart",q.proxy(this._splitterSelectStart,this));var o=f.offset();var h=f.height();var w=f.width();q(document.body).append("<div id=\""+this.getId()+"-ghost\" class=\"sapUiHSBGhost\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px\" ></div>");f.append("<div id=\""+this.getId()+"-overlay\" style =\"left: 0px;"+" right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");var D=q(document);if(i){D.bind("touchend",q.proxy(this._onGhostMouseRelease,this));D.bind("touchmove",q.proxy(this._onGhostMouseMove,this));}else{D.bind("mouseup",q.proxy(this._onGhostMouseRelease,this));D.bind("mousemove",q.proxy(this._onGhostMouseMove,this));}this._disableTextSelection();return;}var g=$.closest(".sapUiTableCol");if(g.length===1){this._bShowMenu=true;this._sDelayedMenuTimer=q.sap.delayedCall(200,this,function(){this._bShowMenu=false;});var j=this._isTouchMode(e)&&($.hasClass("sapUiTableColDropDown")||$.hasClass("sapUiTableColResizer"));if(this.getEnableColumnReordering()&&!j){var k=parseInt(g.attr("data-sap-ui-colindex"),10);if(k>this._iLastFixedColIndex){var m=this.getColumns()[k];this._sDelayedActionTimer=q.sap.delayedCall(200,this,function(){this._onColumnMoveStart(m,i);});}}}var n=!!(e.metaKey||e.ctrlKey);if(!!sap.ui.Device.browser.firefox&&n){e.preventDefault();}}};T.prototype.onmouseup=function(e){q.sap.clearDelayedCall(this._sDelayedActionTimer);if(e.isMarked()){return;}if(this.$().find(".sapUiTableCtrl td :focus").length>0){this._enterActionMode(this.$().find(".sapUiTableCtrl td :focus"));}else{this._leaveActionMode(e);}};T.prototype.onclick=function(e){q.sap.clearDelayedCall(this._sDelayedActionTimer);if(e.isMarked()){return;}if(!this._findAndfireCellEvent(this.fireCellClick,e)){this._onSelect(e);}else{e.preventDefault();}};T.prototype.oncontextmenu=function(e){var t=q(e.target);var h=t.closest('.sapUiTableCol');if(h.length>0){var o=sap.ui.getCore().byId(h.attr("data-sap-ui-colid"));if(o){o._openMenu(h[0]);}e.preventDefault();}else{if(this._findAndfireCellEvent(this.fireCellContextmenu,e,this._oncellcontextmenu)){e.preventDefault();}}};T.prototype._oncellcontextmenu=function(p){if(this.getEnableCellFilter()){if(!this._oContextMenu){q.sap.require("sap.ui.unified.Menu");q.sap.require("sap.ui.unified.MenuItem");this._oContextMenu=new sap.ui.unified.Menu(this.getId()+"-contextmenu");this.addDependent(this._oContextMenu);}var o=sap.ui.getCore().byId(p.columnId);var s=o.getFilterProperty();if(o&&o.isFilterableByMenu()&&p.rowBindingContext){this._oContextMenu.destroyItems();this._oContextMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_FILTER"),select:[function(){var f=this.getContextByIndex(p.rowIndex);var v=f.getProperty(s);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:o,value:v});}else{this.filter(o,v);}},this]}));var e=sap.ui.core.Popup.Dock;this._oContextMenu.open(false,p.cellDomRef,e.BeginTop,e.BeginBottom,p.cellDomRef,"none none");return true;}}};T.prototype._bindSimulatedDoubleclick=function(e,f,D){var g="click";var t=this;if(!!sap.ui.Device.support.touch){g="touchend";}q(e).on(g,function(E){E.preventDefault();E.stopPropagation();t._clicksRegistered=t._clicksRegistered+1;if(t._clicksRegistered<2){t._singleClickTimer=q.sap.delayedCall(t._doubleclickDelay,t,function(){t._clicksRegistered=0;if(f){f.call(t,E);}},[E]);}else{q.sap.clearDelayedCall(t._singleClickTimer);t._clicksRegistered=0;D.call(t,E);}});};T.prototype._findAndfireCellEvent=function(f,e,g){var $=q(e.target);var h=$.closest("td[role='gridcell']");var i=h.attr("id");var m=/.*-row(\d*)-col(\d*)/i.exec(i);var j=false;if(m){var r=m[1];var k=m[2];var o=this.getRows()[r];var l=o&&o.getCells()[k];var n=o&&o.getIndex();var s=l.data("sap-ui-colid");var p;if(this.getBindingInfo("rows")){p=o.getBindingContext(this.getBindingInfo("rows").model);}var t={rowIndex:n,columnIndex:k,columnId:s,cellControl:l,rowBindingContext:p,cellDomRef:h.get(0)};j=!f.call(this,t);if(!j&&typeof g==="function"){t.cellDomRef=h[0];j=g.call(this,t);}}return j;};T.prototype.onfocusin=function(e){var $=q(e.target);var n=this.$().hasClass("sapUiTableEmpty");var f=$.hasClass("sapUiTableCtrlBefore");this._updateAriaRowOfRowsText();if(!this._bIgnoreFocusIn&&(f||$.hasClass("sapUiTableCtrlAfter"))){this.$("ariadesc").text(this._oResBundle.getText("TBL_TABLE"));this._leaveActionMode();if(q.contains(this.$().find('.sapUiTableColHdrCnt')[0],e.target)){q(this._oItemNavigation.getFocusedDomRef()||this._oItemNavigation.getRootDomRef()).focus();}else{if(f){if(n){this._bIgnoreFocusIn=true;this.$().find(".sapUiTableCtrlEmpty").focus();this._bIgnoreFocusIn=false;}else{this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex()%this._oItemNavigation.iColumns,e);}}else{this._oItemNavigation.focusItem((this._oItemNavigation.getFocusedIndex()%this._oItemNavigation.iColumns)+(this._oItemNavigation.iColumns*this._iLastSelectedDataRow),e);}}if(!n){e.preventDefault();}}else if(q.sap.endsWith(e.target.id,"-rsz")){e.preventDefault();e.stopPropagation();}};T.prototype._getAbsoluteRowIndex=function(r){var i=0;var f=this.getFirstVisibleRow();var F=this.getFixedBottomRowCount();var v=this.getVisibleRowCount();var e=v-F;if(F>0&&r>=e){i=this.getBinding().getLength()-v+r;}else{i=f+r;}return i;};T.prototype._onSelect=function(e){var $=q(e.target);var s=e.shiftKey;var f=!!(e.metaKey||e.ctrlKey);var g=$.closest(".sapUiTableCol");if(this._bShowMenu&&g.length===1){var i=parseInt(g.attr("data-sap-ui-colindex"),10);var o=this.getColumns()[i];if($.hasClass("sapUiTableColDropDown")){var E=this.fireColumnSelect({column:o});if(E){o._openMenu(g[0]);}}else{this._onColumnSelect(o,g[0],this._isTouchMode(e));}return;}var h=$.closest(".sapUiTableRowHdr");if(h.length===1){var i=parseInt(h.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(i),s,f);return;}var j;if(e.target){var k=q(e.target).closest("td");if(k.length>0){j=k[0];}}if(j&&j.getAttribute("role")=="gridcell"&&(this.getSelectionBehavior()===sap.ui.table.SelectionBehavior.Row||this.getSelectionBehavior()===sap.ui.table.SelectionBehavior.RowOnly)){var h=$.closest(".sapUiTableCtrl > tbody > tr");if(h.length===1){var i=parseInt(h.attr("data-sap-ui-rowindex"),10);this._onRowSelect(this._getAbsoluteRowIndex(i),s,f);return;}}if(q.sap.containsOrEquals(this.getDomRef("selall"),e.target)){this._toggleSelectAll();return;}};T.prototype._isRowSelectable=function(r){return true;};T.prototype._onRowSelect=function(r,s,e){if(!!sap.ui.Device.browser.internet_explorer&&s){this._clearTextSelection();}var B=this.getBinding("rows");if(!B){return;}if(r<0||r>=(B.getLength()||0)){return;}if(!this._isRowSelectable(r)){return;}this._iSourceRowIndex=r;var o=this.getSelectionMode();if(o!==sap.ui.table.SelectionMode.None){if(o===sap.ui.table.SelectionMode.Single){if(!this.isIndexSelected(r)){this.setSelectedIndex(r);}else{this.clearSelection();}}else{if(o===sap.ui.table.SelectionMode.MultiToggle){e=true;}if(s){var i=this.getSelectedIndex();if(i>=0){this.addSelectionInterval(i,r);}else{this.setSelectedIndex(r);}}else{if(!this.isIndexSelected(r)){if(e){this.addSelectionInterval(r,r);}else{this.setSelectedIndex(r);}}else{if(e){this.removeSelectionInterval(r,r);}else{if(this.getSelectedIndices().length===1){this.clearSelection();}else{this.setSelectedIndex(r);}}}}}}this._iSourceRowIndex=undefined;};T.prototype._onColumnSelect=function(o,D,i){if(i){var $=q(D);var e=$.find(".sapUiTableColCell");if($.find(".sapUiTableColCellMenu").length<1){e.hide();var s="";if(o._menuHasItems()){s="<div class='sapUiTableColDropDown'></div>";}var f="";if(o.getResizable()){f="<div class='sapUiTableColResizer''></div>";}var g=q("<div class='sapUiTableColCellMenu'>"+s+f+"</div>");$.append(g);$.bind("focusout",function(){this.cell.show();this.menu.remove();this.self.unbind("focusout");}.bind({cell:e,menu:g,self:$}));if(o.getResizable()){$.find(".sapUiTableColResizer").bind("touchstart",q.proxy(this._onColumnResizeStart,this));}}return;}var E=this.fireColumnSelect({column:o});if(E){o._openMenu(D);}};T.prototype._onColumnMoveStart=function(o,i){this._disableTextSelection();var $=o.$();var e=parseInt($.attr("data-sap-ui-colindex"),10);if(e<this.getFixedColumnCount()){return;}this.$().addClass("sapUiTableDragDrop");this._$colGhost=$.clone().removeAttr("id");$.css({"opacity":".25"});this._$colGhost.addClass("sapUiTableColGhost").css({"left":-10000,"top":-10000,"position":"absolute","z-index":this.$().zIndex()+10});this.$().find(".sapUiTableCol").each(function(g,E){var $=q(this);$.css({position:"relative"});$.data("pos",{left:$.position().left,center:$.position().left+$.outerWidth()/2,right:$.position().left+$.outerWidth()});});this._$colGhost.appendTo(document.body);var f=q(document.body);if(i){f.bind("touchmove",q.proxy(this._onColumnMove,this));f.bind("touchend",q.proxy(this._onColumnMoved,this));}else{f.mousemove(q.proxy(this._onColumnMove,this));f.mouseup(q.proxy(this._onColumnMoved,this));}};T.prototype._onColumnMove=function(e){var $=this.$();var l=e.pageX;var L=e.pageY;if(e&&this._isTouchMode(e)){l=e.targetTouches[0].pageX;L=e.targetTouches[0].pageY;e.stopPropagation();e.preventDefault();}var r=this._bRtlMode;var i=l-$.offset().left;var D=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var f=this.getColumns()[D].$();var o=this._iNewColPos;this._iNewColPos=D;var t=this;$.find(".sapUiTableCol").each(function(g,h){var j=q(h);var k=parseInt(j.attr("data-sap-ui-colindex"),10);var H=sap.ui.getCore().byId(j.attr("data-sap-ui-colid")).getHeaderSpan();var s;if(H){if(q.isArray(H)){s=H[0];}else{s=H;}}else{s=1;}if(j.get(0)!==f.get(0)){var p=j.data("pos");var B=i>=p.left&&i<=p.center;var A=i>=p.center&&i<=p.right;if(!r){if(B){t._iNewColPos=k;}else if(A){t._iNewColPos=k+s;}else{t._iNewColPos=t._iNewColPos;}}else{if(A){t._iNewColPos=k;}else if(B){t._iNewColPos=k+s;}else{t._iNewColPos=t._iNewColPos;}}if((B||A)&&k>D){t._iNewColPos--;}}});if(this._iNewColPos<=this._iLastFixedColIndex){this._iNewColPos=o;}if(this._iNewColPos<this.getFixedColumnCount()){this._iNewColPos=o;}this._animateColumnMove(D,o,this._iNewColPos);this._$colGhost.css({"left":l+5,"top":L+5});};T.prototype._animateColumnMove=function(e,o,n){var r=this._bRtlMode;var D=this.getColumns()[e].$();if(o!==n){for(var i=Math.min(o,n),l=Math.max(o,n);i<=l;i++){var f=this.getColumns()[i];if(i!==e&&f.getVisible()){f.$().stop(true,true).animate({left:"0px"});}}var O=0;if(n<e){for(var i=n;i<e;i++){var f=this.getColumns()[i];if(f.getVisible()){var $=f.$();O-=$.outerWidth();$.stop(true,true).animate({left:D.outerWidth()*(r?-1:1)+"px"});}}}else{for(var i=e+1,l=n+1;i<l;i++){var f=this.getColumns()[i];if(f.getVisible()){var $=f.$();O+=$.outerWidth();$.stop(true,true).animate({left:D.outerWidth()*(r?1:-1)+"px"});}}}D.stop(true,true).animate({left:O*(r?-1:1)+"px"});}};T.prototype._onColumnMoved=function(e){this.$().removeClass("sapUiTableDragDrop");var D=parseInt(this._$colGhost.attr("data-sap-ui-colindex"),10);var o=this.getColumns()[D];var B=q(document.body);B.unbind("touchmove",this._onColumnMove);B.unbind("touchend",this._onColumnMoved);B.unbind("mousemove",this._onColumnMove);B.unbind("mouseup",this._onColumnMoved);this._$colGhost.remove();this._$colGhost=undefined;this._enableTextSelection();var E=this.fireColumnMove({column:o,newPos:this._iNewColPos});var m=D<this._iNewColPos;if(E&&this._iNewColPos!==undefined&&this._iNewColPos!==D){this.removeColumn(o);this.insertColumn(o,this._iNewColPos);var h=o.getHeaderSpan(),s;if(h){if(q.isArray(h)){s=h[0];}else{s=h;}}else{s=1;}if(s>1){if(!m){this._iNewColPos++;}for(var i=1;i<s;i++){var f=this.getColumns()[m?D:D+i];this.removeColumn(f);this.insertColumn(f,this._iNewColPos);this.fireColumnMove({column:f,newPos:this._iNewColPos});if(!m){this._iNewColPos++;}}}this._oColHdrItemNav.setFocusedIndex(this._iNewColPos);}else{this._animateColumnMove(D,this._iNewColPos,D);o.$().css({"backgroundColor":"","backgroundImage":"","opacity":""});}setTimeout(function(){var O=this._oItemNavigation.getFocusedIndex();this._oItemNavigation.focusItem(0,e);this._oItemNavigation.focusItem(O,e);}.bind(this),0);delete this._iNewColPos;};T.prototype._onAutomaticColumnResize=function(e){var i,o,h,m,f=1,r=false;q.sap.log.debug("doubleclick fired");this._disableTextSelection();this._$colResize=q(e.target);this._$colResize.addClass("sapUiTableColRszActive");var p=parseInt(this._$colResize.prevAll(".sapUiTableCol").first().attr("data-sap-ui-colindex"),10);i=parseInt(this._$colResize.attr("data-sap-ui-colindex"),10);if(p!=i){r=true;}if(r){o=this.getColumns()[p];h=o.getHeaderSpan();if(h instanceof Array){m=Math.max.apply(Math,h);}else if(!!h){m=h;}if(i+h-1!=p){f=m;i=p+m;}}if(f>1){while(i>p){i--;this.autoResizeColumn(i);}}else{this.autoResizeColumn(i);}e.preventDefault();e.stopPropagation();};T.prototype._getResizerIdForColumn=function(i,e){if(e>0){e--;}var o=this.getColumns()[this._aIdxCols2Cells[i+e]];return o.getId()+"-rsz";};T.prototype._onColumnResizeStart=function(e){if(this._isTouchMode(e)){this._iColumnResizeStart=e.targetTouches[0].pageX;this._disableTextSelection();var $=q(e.target).closest(".sapUiTableCol");var i=parseInt($.attr("data-sap-ui-colindex"),10);var f=$.attr("data-sap-ui-colspan");var r=this._getResizerIdForColumn(i,f);this._$colResize=q.sap.byId(r);q(document.body).bind("touchmove",q.proxy(this._onColumnResize,this));q(document.body).bind("touchend",q.proxy(this._onColumnResized,this));return;}var l=e.button===(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=8?1:0);if(l){this._iColumnResizeStart=e.pageX;this._disableTextSelection();this._$colResize=q(e.target);q(document.body).mousemove(q.proxy(this._onColumnResize,this)).mouseup(q.proxy(this._onColumnResized,this));}};T.prototype._onColumnResize=function(e){var l;if(this._isTouchMode(e)){l=e.targetTouches[0].pageX;e.stopPropagation();e.preventDefault();}else{l=e.pageX;}if(this._iColumnResizeStart&&l<this._iColumnResizeStart+3&&l>this._iColumnResizeStart-3){return;}if(this._isTouchMode(e)){this._$colResize.addClass("sapUiTableColTouchRszActive");}else{this._$colResize.addClass("sapUiTableColRszActive");}var $=this.$();var r=this._bRtlMode;var i=parseInt(this._$colResize.attr("data-sap-ui-colindex"),10);var o=this.getColumns()[i];var f=$.find(".sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex='"+i+"']");var g=f.position().left;var w;if(!r){if(this.getFixedColumnCount()>0&&i>=this.getFixedColumnCount()){var F=$.find(".sapUiTableColHdrFixed").width();g=g+F;g=g-$.find(".sapUiTableCtrlScr").scrollLeft();}var O=$.find(".sapUiTableCtrlFirstCol > th:first").offset().left;var h=l-O;w=h-g;}else{var s;if(this.getFixedColumnCount()>0&&i<this.getFixedColumnCount()){s=$.find('.sapUiTableCtrlScrFixed');}else{s=$.find('.sapUiTableCtrlScr');}var j=s.scrollLeft();if(sap.ui.Device.browser.internet_explorer){j=s[0].scrollWidth-j-s[0].clientWidth;}else if(sap.ui.Device.browser.firefox){j=j+s[0].scrollWidth-s[0].clientWidth;}var D=g-j-l+s.offset().left;w=f.outerWidth()+D;}w=Math.max(w,this._iColMinWidth);var k=$.find(".sapUiTableCnt").offset().left;var m=l-k;m-=this._$colResize.width()/2;this._$colResize.css("left",m);o._iNewWidth=w;};T.prototype._onColumnResized=function(e,i){var f;if(!this._$colResize&&(i===null||i===undefined)){return;}if(i===null||i===undefined){f=parseInt(this._$colResize.attr("data-sap-ui-colindex"),10);}else{f=i;}var o=this.getColumns()[f];var r=false;if(o._iNewWidth){var w;var A=this.$().find(".sapUiTableCtrl").width();if(!this._checkPercentageColumnWidth()){w=o._iNewWidth+"px";}else{var g=Math.round(100/A*o._iNewWidth);w=g+"%";}this._updateColumnWidth(o,w);this._resizeDependentColumns(o,w);delete o._iNewWidth;r=true;}var B=q(document.body);B.unbind("touchmove",this._onColumnResize);B.unbind("touchend",this._onColumnResized);B.unbind("mousemove",this._onColumnResize);B.unbind("mouseup",this._onColumnResized);o.focus();if(this._$colResize){this._$colResize.removeClass("sapUiTableColTouchRszActive sapUiTableColRszActive");this._$colResize=undefined;}this._enableTextSelection();if(r){this.invalidate();}};T.prototype._resizeDependentColumns=function(o,w){if(this._checkPercentageColumnWidth()){var v=this._getVisibleColumns();var e;q.each(v,function(s,u){if(o===u){e=s;}});var O=0;var l=v.length-1;var t;if(e===undefined){t=0;}else{t=parseInt(w,10);}var p=0;var f=[];var g=this;q.each(v,function(s,u){var x=g._getColumnPercentageWidth(u);if((((e===l&&s<e)||((e!==l)&&s>e))&&u.getFlexible())||e===undefined){O+=u.$().outerWidth();p+=x;f.push(u);}else if(s!==e){t+=x;}});var h=t;q.each(f,function(s,u){var x=g._getColumnPercentageWidth(u);var N=Math.round((100-h)/p*x);if(s===f.length-1){N=100-t;}else{t+=N;}g._updateColumnWidth(u,N+"%");});}else if(!this._hasOnlyFixColumnWidths()){var v=this._getVisibleColumns(),A=this.$().find(".sapUiTableCtrl").width(),e,r=0,L=0,j=0,n=0;q.each(v,function(s,u){if(!q.sap.endsWith(u.getWidth(),"px")&&!q.sap.endsWith(u.getWidth(),"em")&&!q.sap.endsWith(u.getWidth(),"rem")){n++;return false;}if(e!=undefined){j+=this._CSSSizeToPixel(u.getWidth());r++;}else if(o!==u){L+=this._CSSSizeToPixel(u.getWidth());}if(o===u){e=s;L+=this._CSSSizeToPixel(w);}}.bind(this));if(n>0||(L+j>A)){return;}A-=L;for(var i=e+1;i<v.length;i++){var o=v[i],k=this._CSSSizeToPixel(o.getWidth()),m=k/j*100,N=A/100*m;this._updateColumnWidth(o,Math.round(N)+'px');}}};T.prototype._getColumnPercentageWidth=function(o){var s=o.getWidth();var i=parseInt(o.getWidth(),10);var t=this.$().find(".sapUiTableCtrl").width();if(q.sap.endsWith(s,"px")||q.sap.endsWith(s,"em")||q.sap.endsWith(s,"rem")){i=Math.round(100/t*i);}else if(!q.sap.endsWith(s,"%")){i=Math.round(100/t*o.$().width());}return i;};T.prototype._updateColumnWidth=function(o,w){var e=this.fireColumnResize({column:o,width:w});if(e){o.setProperty("width",w,true);this.$().find('th[aria-owns="'+o.getId()+'"]').css('width',w);}};T.prototype._checkPercentageColumnWidth=function(){var e=this.getColumns();var h=false;q.each(e,function(i,o){if(q.sap.endsWith(o.getWidth(),"%")){h=true;return false;}});return h;};T.prototype._hasOnlyFixColumnWidths=function(){var o=true;q.each(this.getColumns(),function(i,e){var w=e.getWidth();if(e.getFlexible()||!w||w.substr(-2)!=="px"){o=false;return false;}});return o;};T.prototype.pushSortedColumn=function(o,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(o);};T.prototype.getSortedColumns=function(){return this._aSortedColumns;};T.prototype.sort=function(o,s,A){if(q.inArray(o,this.getColumns())>=0){o.sort(s===sap.ui.table.SortOrder.Descending,A);}};T.prototype.filter=function(o,v){if(q.inArray(o,this.getColumns())>=0){o.filter(v);}};T.prototype._getSelectOnCellsAllowed=function(){var s=this.getSelectionBehavior();var e=this.getSelectionMode();return e!==sap.ui.table.SelectionMode.None&&(s===sap.ui.table.SelectionBehavior.Row||s===sap.ui.table.SelectionBehavior.RowOnly);};T.prototype._getAriaTextsForSelectionMode=function(e,s){if(!s){s=this.getSelectionMode();}var r=this._oResBundle;var t={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};if(s===sap.ui.table.SelectionMode.Single){t.mouse.rowSelect=r.getText("TBL_ROW_SELECT");t.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");t.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");t.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(s===sap.ui.table.SelectionMode.Multi){t.mouse.rowSelect=r.getText("TBL_ROW_SELECT_MULTI");t.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT_MULTI");t.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_KEY");t.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_MULTI_KEY");if(e===true){if(this.getSelectedIndices().length===1){t.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");t.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(this.getSelectedIndices().length===0){t.mouse.rowSelect=r.getText("TBL_ROW_SELECT");t.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}}else if(s===sap.ui.table.SelectionMode.MultiToggle){t.mouse.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE");t.mouse.rowDeselect=r.getText("TBL_ROW_DESELECT");t.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE_KEY");t.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");if(e===true&&this.getSelectedIndices().length===0){t.mouse.rowSelect=r.getText("TBL_ROW_SELECT");t.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}return t;};T.prototype._updateSelection=function(){if(this.getSelectionMode()===sap.ui.table.SelectionMode.None){return;}var t=this._getAriaTextsForSelectionMode(true);var s=this._getSelectOnCellsAllowed();var r=this.getRows();for(var i=0;i<r.length;i++){var o=r[i];o._updateSelection(this,t,s);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);};T.prototype._onSelectionChanged=function(e){var r=e.getParameter("rowIndices");var i=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();var s=this.getSelectionMode();if(s==="Multi"||s==="MultiToggle"){this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");}this.fireRowSelectionChange({rowIndex:i,rowContext:this.getContextByIndex(i),rowIndices:r});};T.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContexts(i,1)[0]:null;};T.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};T.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};T.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};T.prototype.selectAll=function(){var s=this.getSelectionMode();if(!this.getEnableSelectAll()||(s!="Multi"&&s!="MultiToggle")){return this;}var B=this.getBinding("rows");if(B){this._oSelection.setSelectionInterval((B.getLength()||0)-1,0);this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");}return this;};T.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};T.prototype.addSelectionInterval=function(i,e){this._oSelection.addSelectionInterval(i,e);return this;};T.prototype.setSelectionInterval=function(i,e){this._oSelection.setSelectionInterval(i,e);return this;};T.prototype.removeSelectionInterval=function(i,e){this._oSelection.removeSelectionInterval(i,e);return this;};T.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};T.prototype._scrollNext=function(){if(this.getFirstVisibleRow()<this._getRowCount()-this.getVisibleRowCount()){this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow()+1,this._getRowCount()-this.getVisibleRowCount()));}};T.prototype._scrollPrevious=function(){if(this.getFirstVisibleRow()>0){this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow()-1,0));}};T.prototype._scrollPageUp=function(){this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow()-this.getVisibleRowCount(),0));};T.prototype._scrollPageDown=function(){this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow()+this.getVisibleRowCount()-this.getFixedBottomRowCount(),this._getRowCount()-this.getVisibleRowCount()));};T.prototype._isTopRow=function(e){var $=q(e.target);var r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=this.getFixedRowCount();if(f>0&&r>=f){return r===f;}return r===0;};T.prototype._isBottomRow=function(e){var $=q(e.target);var r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"),10);var f=this.getFixedBottomRowCount();if(f>0&&r<=this.getVisibleRowCount()-1-f){return r===this.getVisibleRowCount()-1-f;}return r===this.getVisibleRowCount()-1;};T.prototype._enterActionMode=function(f){if(f.length>0&&!this._bActionMode){if(f.filter(":sapTabbable").length==0){return;}this._bActionMode=true;this.removeDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","-1");f.filter(":sapTabbable").eq(0).focus();}};T.prototype._leaveActionMode=function(e){if(this._bActionMode){this._bActionMode=false;this.addDelegate(this._oItemNavigation);q(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","0");if(e){if(q(e.target).closest("td[tabindex='-1']").length>0){var i=q(this._oItemNavigation.aItemDomRefs).index(q(e.target).closest("td[tabindex='-1']").get(0));this._oItemNavigation.focusItem(i,null);}else{if(q.sap.containsOrEquals(this.$().find(".sapUiTableCCnt").get(0),e.target)){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}}else{this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null);}}};T.prototype._getFocusedRowIndex=function(){var f=this._oItemNavigation.iFocusedIndex;var i=this._oItemNavigation.iColumns;var s=f%i;var e=this.getFirstVisibleRow()+(f-s)/i;if(!this.getColumnHeaderVisible()){e++;}return e-1;};T.prototype._isFocusedRowSelected=function(){var s=this._getFocusedRowIndex();var i=this.isIndexSelected(s);var e=(this._oItemNavigation.iFocusedIndex%this._oItemNavigation.iColumns==0);if(e){return i;}else{var h=this.getSelectionMode()!==sap.ui.table.SelectionMode.None&&this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly;if(h){return null;}else{return i;}}};T.prototype.onkeyup=function(e){if(!this._bEventSapSelect===true){return;}this._bEventSapSelect=false;if(e.keyCode!==q.sap.KeyCodes.ENTER&&e.keyCode!==q.sap.KeyCodes.SPACE&&e.keyCode!==q.sap.KeyCodes.F4||e.srcControl!==this&&q.inArray(e.srcControl,this.getRows())===-1&&q.inArray(e.srcControl,this.getColumns())===-1){return;}var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B){if(B.isExpanded(r)){B.collapse(r);}else{B.expand(r);}}e.preventDefault();return;}this._bShowMenu=true;this._onSelect(e);this._bShowMenu=false;e.preventDefault();};T.prototype.onsapselect=function(){this._bEventSapSelect=true;};T.prototype.onsapselectmodifiers=function(){this._bEventSapSelect=true;};T.prototype.onsapspace=function(e){var $=q(e.target);if(((this.getSelectionBehavior()==sap.ui.table.SelectionBehavior.Row||this.getSelectionBehavior()==sap.ui.table.SelectionBehavior.RowOnly)&&e.srcControl instanceof sap.ui.table.Row)||$.hasClass("sapUiTableRowHdr")||$.hasClass("sapUiTableColRowHdr")||$.hasClass("sapUiTableCol")){e.preventDefault();}};T.prototype.onkeydown=function(e){var $=this.$();if(!this._bActionMode&&e.keyCode==q.sap.KeyCodes.F2||e.keyCode==q.sap.KeyCodes.ENTER){if($.find(".sapUiTableCtrl td:focus").length>0){this._enterActionMode($.find(".sapUiTableCtrl td:focus").find(":sapFocusable"));e.preventDefault();e.stopPropagation();}}else if(this._bActionMode&&e.keyCode==q.sap.KeyCodes.F2){this._leaveActionMode(e);}else if(e.keyCode==q.sap.KeyCodes.TAB&&this._bActionMode){if(this.getFixedColumnCount()>0){var f=q(e.target);if(f.is("td[role=gridcell]")==false){f=f.parents("td[role=gridcell]");}var g=f.parent("tr[data-sap-ui-rowindex]");var h=g.closest(".sapUiTableCtrl");var r=parseInt(g.attr("data-sap-ui-rowindex"),10);var i=g.find("td[role=gridcell]");var j=i.index(f);var t=i.length;if(j===(t-1)){var k;if(h.hasClass("sapUiTableCtrlFixed")){k=$.find(".sapUiTableCtrl.sapUiTableCtrlScroll");}else{k=$.find(".sapUiTableCtrl.sapUiTableCtrlFixed");r++;if(r==this.getVisibleRowCount()){r=0;}}var l=k.find("tr[data-sap-ui-rowindex='"+r+"']");var m=l.find("td :sapFocusable[tabindex='0']").first();if(m.length>0){m.focus();e.preventDefault();}}}}else if(e.keyCode==q.sap.KeyCodes.A&&(e.metaKey||e.ctrlKey)){var o=this._oItemNavigation;var F=o.getFocusedIndex();this._toggleSelectAll();o.focusItem(F,e);e.preventDefault();e.stopImmediatePropagation(true);}else if(e.keyCode===q.sap.KeyCodes.F10&&(e.shiftKey)){this.oncontextmenu(e);}};T.prototype.onsapescape=function(e){this._leaveActionMode(e);};T.prototype.onsaptabprevious=function(e){var $=this.$();if(this._bActionMode){this._leaveActionMode();e.preventDefault();}else{var i=this._oItemNavigation;var n=this.$().hasClass("sapUiTableEmpty");var s=$.find('.sapUiTableCCnt')[0];var f=q.contains(s,e.target);if(f&&this.getColumnHeaderVisible()){var g=i.getFocusedIndex()%i.iColumns;i.focusItem(g,e);e.preventDefault();}else if(i.getFocusedDomRef()===e.target&&q.sap.containsOrEquals(s,e.target)||(!this.getColumnHeaderVisible()&&n&&f)){this._bIgnoreFocusIn=true;$.find(".sapUiTableCtrlBefore").focus();this._bIgnoreFocusIn=false;}}};T.prototype.onsaptabnext=function(e){var $=this.$();if(this._bActionMode){this._leaveActionMode();e.preventDefault();}else{var i=this._oItemNavigation;var f=q.contains($.find('.sapUiTableColHdrCnt')[0],e.target);var n=this.$().hasClass("sapUiTableEmpty");if(f&&!n){i.focusItem(i.getFocusedIndex()+i.iColumns*this._iLastSelectedDataRow,e);e.preventDefault();}else if(i.getFocusedDomRef()===e.target||(n&&f)){this._bIgnoreFocusIn=true;$.find(".sapUiTableCtrlAfter").focus();this._bIgnoreFocusIn=false;}}};T.prototype._updateAriaRowOfRowsText=function(f){var A=document.getElementById(this.getId()+"-rownumberofrows");if(!A){return;}var i=this._oItemNavigation;if(i){var e=i.getFocusedIndex();var g=e%i.iColumns;var F=this.getFirstVisibleRow();var t=this._getRowCount();var r=Math.floor(e/i.iColumns)+F+1-this._getHeaderRowCount();var s=this._oResBundle.getText("TBL_ROW_ROWCOUNT",[r,t]);if(r>0&&g===0||f){A.innerText=s;}else{A.innerText=" ";}}};T.prototype.onsapdown=function(e){if(!this._bActionMode&&this._isBottomRow(e)){if(this.getFirstVisibleRow()!=this._getRowCount()-this.getVisibleRowCount()){e.stopImmediatePropagation(true);if(this.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar){this._scrollNext();}else{this._scrollPageDown();}}}e.preventDefault();};T.prototype.onsapdownmodifiers=function(e){if(e.shiftKey){var f=this._getFocusedRowIndex();var i=this._isFocusedRowSelected();if(i===true){this.addSelectionInterval(f+1,f+1);}else if(i===false){this.removeSelectionInterval(f+1,f+1);}if(this._isBottomRow(e)){this._scrollNext();}}else if(e.altKey){this._toggleGroupHeader(e);}};T.prototype.onsapupmodifiers=function(e){if(e.shiftKey){var f=this._getFocusedRowIndex();var i=this._isFocusedRowSelected();if(i===true){this.addSelectionInterval(f-1,f-1);}else if(i===false){this.removeSelectionInterval(f-1,f-1);}if(this._isTopRow(e)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}this._scrollPrevious();}}else if(e.altKey){this._toggleGroupHeader(e);}};T.prototype.onsapup=function(e){if(!this._bActionMode&&this._isTopRow(e)){if(this.getFirstVisibleRow()!=0){e.stopImmediatePropagation(true);}if(this.getNavigationMode()===sap.ui.table.NavigationMode.Scrollbar){this._scrollPrevious();}else{this._scrollPageUp();}}e.preventDefault();};T.prototype.onsappagedown=function(e){if(!this._bActionMode){var $=this.$();var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;if(this.getColumnHeaderVisible()&&i.iFocusedIndex<(i.iColumns*h)){var f=i.iFocusedIndex%i.iColumns;if((i.iFocusedIndex<=(i.iColumns*h)&&i.iFocusedIndex>=(i.iColumns*h)-i.iColumns)||(f===0&&r)){this.setFirstVisibleRow(0);i.focusItem(i.iColumns*h+f,e);}else{i.focusItem(i.iColumns*h-i.iColumns+f,e);}e.stopImmediatePropagation(true);}else{if(this._isBottomRow(e)){this._scrollPageDown();}var F=this.getFixedBottomRowCount();if(this.getFirstVisibleRow()===this._getRowCount()-this.getVisibleRowCount()){F=0;}var g=(i.aItemDomRefs.length/i.iColumns)-F;var f=i.iFocusedIndex%i.iColumns;var j=(g-1)*i.iColumns+f;i.focusItem(j,e);e.stopImmediatePropagation(true);}e.preventDefault();}};T.prototype.onsappagedownmodifiers=function(e){if(!this._bActionMode&&e.altKey){var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var f=i.iFocusedIndex%i.iColumns;var n;if(f==0&&r){n=1;}else{var v=this._aVisibleColumns.length;var m=this._getVisibleColumns().length;if(!r){m--;}if(v===0){n=m;}else{n=Math.min(m,f+v);}}i.focusItem(i.iFocusedIndex-(f-n),e);e.stopImmediatePropagation(true);e.preventDefault();}};T.prototype.onsappageup=function(e){if(!this._bActionMode){var $=this.$();var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var h=$.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;var f=i.iFocusedIndex%i.iColumns;if(this.getColumnHeaderVisible()&&i.iFocusedIndex<(i.iColumns*h)){if(i.iFocusedIndex>i.iColumns){i.focusItem(f,e);}e.stopImmediatePropagation(true);}else{if(this.getColumnHeaderVisible()&&this.getFirstVisibleRow()==0&&this._isTopRow(e)){if(r&&f===0){i.focusItem(f,e);}else{i.focusItem(i.iColumns*h-i.iColumns+f,e);}e.stopImmediatePropagation(true);}else{var g=this.getColumnHeaderVisible()?i.iColumns*h:0;i.focusItem(g+f,e);e.stopImmediatePropagation(true);if(this._isTopRow(e)){this._scrollPageUp();}}}e.preventDefault();}};T.prototype.onsappageupmodifiers=function(e){if(!this._bActionMode&&e.altKey){var i=this._oItemNavigation;var r=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var f=i.iFocusedIndex%i.iColumns;if(f>0){var n;if(f==1&&r){n=0;}else{var v=this._aVisibleColumns.length;if(v===0){if(r){n=1;}else{n=0;}}else{var m=1;if(!r){m=0;}n=Math.max(m,f-v);}}i.focusItem(i.iFocusedIndex-(f-n),e);}e.stopImmediatePropagation(true);e.preventDefault();}};T.prototype.onsaphome=function(e){var i=(this.getSelectionBehavior()==sap.ui.table.SelectionBehavior.RowOnly);var f=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(f){e.stopImmediatePropagation(true);return;}var F=this._oItemNavigation.iFocusedIndex;var g=this._oItemNavigation.iColumns;var s=F%g;var o=0;if(!i){o=1;}if(s>this.getFixedColumnCount()+o){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(F-s+this.getFixedColumnCount()+o,null);}else if(!i){if(s>1){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(F-s+1,null);}else if(s==1){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(F-1,null);}else{e.stopImmediatePropagation(true);}}};T.prototype.onsapend=function(e){var i=q(e.target).parents(".sapUiTableGroupHeader").length>0;if(i){e.stopImmediatePropagation(true);return;}var f=this._oItemNavigation.iFocusedIndex;var g=this._oItemNavigation.iColumns;var s=f%g;var h=(this.getSelectionBehavior()!==sap.ui.table.SelectionBehavior.RowOnly);var o=0;if(!h){o=1;}if(s===0&&h){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f+1,null);}else if(s<this.getFixedColumnCount()-o){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(f-s+this.getFixedColumnCount()-o,null);}};T.prototype.onsaphomemodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);if(i){e.stopImmediatePropagation(true);return;}var f=this._oItemNavigation.iFocusedIndex;var g=this._oItemNavigation.iColumns;var s=Math.ceil(f/g)-1;var h=f%g;if(this.getColumnHeaderVisible()){if(s==1){e.stopImmediatePropagation(true);this._oItemNavigation.focusItem(h,e);}else if(s>1){e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var j=h+g;this._oItemNavigation.focusItem(j,e);}}else{e.stopImmediatePropagation(true);this.setFirstVisibleRow(0);var j=f-s*g;this._oItemNavigation.focusItem(j,e);}}};T.prototype.onsapendmodifiers=function(e){if(e.metaKey||e.ctrlKey){var $=this.$();var t=$.find(".sapUiTableColHdrCnt")[0];var i=q.contains(t,e.target);var f=this._oItemNavigation.iFocusedIndex;var g=this._oItemNavigation.iColumns;var s=f%g;e.stopImmediatePropagation(true);if(i){this._oItemNavigation.focusItem(f+g,e);}else{this.setFirstVisibleRow(this._getRowCount()-this.getVisibleRowCount());var h=this._oItemNavigation.aItemDomRefs.length-(g-s);this._oItemNavigation.focusItem(h,e);}}};T.prototype.onsapleft=function(e){this._collapseGroupHeader(e);};T.prototype.onsapright=function(e){this._expandGroupHeader(e);};T.prototype._toggleGroupHeader=function(e){var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&B.isExpanded(r)){B.collapse(r);}else{B.expand(r);}e.preventDefault();e.stopImmediatePropagation();}};T.prototype._collapseGroupHeader=function(e){var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&B.isExpanded(r)){B.collapse(r);}e.preventDefault();e.stopImmediatePropagation();}};T.prototype._expandGroupHeader=function(e){var p=q(e.target).closest('.sapUiTableGroupHeader');if(p.length>0){var r=this.getFirstVisibleRow()+parseInt(p.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B&&!B.isExpanded(r)){B.expand(r);}e.preventDefault();e.stopImmediatePropagation();}};T.prototype.onsapleftmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var f=parseInt(t.attr('data-sap-ui-colindex'),10),v=this._getVisibleColumns(),o=v[this._aVisibleColumns.indexOf(f)];if(e.shiftKey){var n=parseInt(o.getWidth(),10)-16;o.setWidth((n>20?n:20)+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){if(f-1>=0){var N=0;for(var p=this._aVisibleColumns.indexOf(f)-1;p>=0;p--){N=this._aVisibleColumns[p];if(v[p].$().css("display")!=="none"){break;}}this.removeColumn(o);this.insertColumn(o,N);var h=o.getHeaderSpan();if(h>1){for(var i=1;i<h;i++){o=v[f+i];this.removeColumn(o);this.insertColumn(o,N+i);}}}e.preventDefault();e.stopImmediatePropagation();}}};T.prototype.onsaprightmodifiers=function(e){var t=q(e.target);if(t.hasClass('sapUiTableCol')){var f=parseInt(t.attr('data-sap-ui-colindex'),10);var v=this._getVisibleColumns();var p=this._aVisibleColumns.indexOf(f);var o=v[p];if(e.shiftKey){o.setWidth(parseInt(o.getWidth(),10)+16+"px");e.preventDefault();e.stopImmediatePropagation();}else if(e.ctrlKey||e.metaKey){var h=o.getHeaderSpan();if(p<v.length-h){var n=v[p+1].getHeaderSpan(),N=this._aVisibleColumns[p+n];for(var i=h-1;i>=0;i--){o=v[p+i];this.removeColumn(o);this.insertColumn(o,N+i);}}e.preventDefault();e.stopImmediatePropagation();}}};T.prototype.setGroupBy=function(v){var g=v;if(typeof g==="string"){g=sap.ui.getCore().byId(g);}var r=false;if(g&&g instanceof sap.ui.table.Column){if(q.inArray(g,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var e=this.fireGroup({column:g,groupedColumns:[g.getId()],type:sap.ui.table.GroupEventType.group});var o=sap.ui.getCore().byId(this.getGroupBy());if(o){o.setGrouped(false);r=true;}if(e&&g instanceof sap.ui.table.Column){g.setGrouped(true);}}if(!g||r){var B=this.getBindingInfo("rows");delete B.binding;this._bindAggregation("rows",B);}return this.setAssociation("groupBy",g);};T.prototype.getBinding=function(n){n=n||"rows";var B=sap.ui.core.Element.prototype.getBinding.call(this,n);if(this.getEnableGrouping()){q.sap.require("sap.ui.model.ClientListBinding");var g=sap.ui.getCore().byId(this.getGroupBy());var e=g&&g.getGrouped()&&n==="rows"&&B&&B instanceof sap.ui.model.ClientListBinding;if(e&&!B._modified){B._modified=true;this._modifyRow=function(r,$){this.$().find(".sapUiTableRowHdrScr").css("display","block");var j=this.$().find("div[data-sap-ui-rowindex='"+$.attr("data-sap-ui-rowindex")+"']");if(B.isGroupHeader(r)){$.addClass("sapUiTableGroupHeader sapUiTableRowHidden");var s=B.isExpanded(r)?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";j.html("<div class=\"sapUiTableGroupIcon "+s+"\" tabindex=\"-1\">"+B.getTitle(r)+"</div>");j.addClass("sapUiTableGroupHeader").removeAttr("title");}else{$.removeClass("sapUiTableGroupHeader");j.html("");j.removeClass("sapUiTableGroupHeader");}};this.onclick=function(E){if(q(E.target).hasClass("sapUiTableGroupIcon")){var $=q(E.target).parents("[data-sap-ui-rowindex]");if($.length>0){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");if(B.isExpanded(r)){B.collapse(r);q(E.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");}else{B.expand(r);q(E.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");}}}else{if(T.prototype.onclick){T.prototype.onclick.apply(this,arguments);}}};var p=g.getSortProperty();B.sort(new sap.ui.model.Sorter(p));var l=B.getLength(),f=B.getContexts(0,l);var k;var h=0;for(var i=l-1;i>=0;i--){var N=f[i].getProperty(p);if(!k){k=N;}if(k!==N){f.splice(i+1,0,{oContext:f[i+1],name:k,count:h,groupHeader:true,expanded:true});k=N;h=0;}h++;}f.splice(0,0,{oContext:f[0],name:k,count:h,groupHeader:true,expanded:true});q.extend(B,{getLength:function(){return f.length;},getContexts:function(s,l){return f.slice(s,s+l);},isGroupHeader:function(j){var o=f[j];return o&&!(o instanceof sap.ui.model.Context);},getTitle:function(j){var o=f[j];return o&&!(o instanceof sap.ui.model.Context)&&(o["name"]+" - "+o["count"]);},isExpanded:function(j){return this.isGroupHeader(j)&&f[j].expanded;},expand:function(j){if(this.isGroupHeader(j)&&!f[j].expanded){for(var i=0;i<f[j].childs.length;i++){f.splice(j+1+i,0,f[j].childs[i]);}delete f[j].childs;f[j].expanded=true;this._fireChange();}},collapse:function(j){if(this.isGroupHeader(j)&&f[j].expanded){f[j].childs=f.splice(j+1,f[j].count);f[j].expanded=false;this._fireChange();}}});}}return B;};T.prototype.resetGrouping=function(){var B=this.getBinding("rows");if(B&&B._modified){this.$().find(".sapUiTableRowHdrScr").css("display","");this.onclick=T.prototype.onclick;this._modifyRow=undefined;var o=this.getBindingInfo("rows");this.unbindRows();this.bindRows(o);}};T.prototype.setEnableGrouping=function(e){this.setProperty("enableGrouping",e);if(!e){this.resetGrouping();}this._invalidateColumnMenus();return this;};T.prototype.setEnableCustomFilter=function(e){this.setProperty("enableCustomFilter",e);this._invalidateColumnMenus();return this;};T.prototype.setEnableColumnFreeze=function(e){this.setProperty("enableColumnFreeze",e);this._invalidateColumnMenus();return this;};T.prototype.setShowColumnVisibilityMenu=function(s){this.setProperty("showColumnVisibilityMenu",s);this._invalidateColumnMenus();return this;};T.prototype.setFixedColumnCount=function(f){var e=this._getVisibleColumns();var h=e[f-1]&&e[f-1].getHeaderSpan();if(h){var H;if(q.isArray(h)){H=parseInt(h[0],10);}else{H=parseInt(h,10);}f+=H-1;}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(var i=0;i<f;i++){var o=e[i];if(o){var g=q.inArray(o,this.getColumns());if(!o.getWidth()){o.setWidth($.filter("[data-sap-ui-headcolindex='"+g+"']").width()+"px");}}}this.setProperty("fixedColumnCount",f);this._invalidateColumnMenus();return this;};T.prototype.setFixedRowCount=function(f){if(!(parseInt(f,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0");return this;}if((f+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",f);}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(f+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')");}return this;};T.prototype.setFixedBottomRowCount=function(f){if(!(parseInt(f,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0");return this;}if((f+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",f);}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(f+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')");}return this;};T.prototype._invalidateColumnMenus=function(){var e=this.getColumns();for(var i=0,l=e.length;i<l;i++){if(e[i].getMenu()){e[i].getMenu()._bInvalidated=true;}}};T.prototype._splitterSelectStart=function(e){e.preventDefault();e.stopPropagation();return false;};T.prototype._isTouchMode=function(e){return!!e.originalEvent["touches"];};T.prototype._onGhostMouseRelease=function(e){var s=this.getDomRef("ghost");var l=this._isTouchMode(e)?e.changedTouches[0].pageY:e.pageY;var n=l-this.$().offset().top;this.setVisibleRowCount(this._calculateRowsToDisplay(n));q(s).remove();this.$("overlay").remove();q(document.body).unbind("selectstart",this._splitterSelectStart);var D=q(document);D.unbind("touchend",this._onGhostMouseRelease);D.unbind("touchmove",this._onGhostMouseMove);D.unbind("mouseup",this._onGhostMouseRelease);D.unbind("mousemove",this._onGhostMouseMove);this._enableTextSelection();};T.prototype._onGhostMouseMove=function(e){var s=this.getDomRef("ghost");var l=this._isTouchMode(e)?e.targetTouches[0].pageY:e.pageY;var m=this.$().offset().top;if(l>m){q(s).css("top",l+"px");}};T.prototype._calculateRowsToDisplay=function(h){var m=this.getMinAutoRowCount()||5;if(!h){return m;}var $=this.$();if(!$.get(0)){return;}var i=$.get(0).getBoundingClientRect().height;var e=$.find('.sapUiTableCCnt').outerHeight();var r=$.find(".sapUiTableCtrl tr:not(.sapUiAnalyticalTableSum) > td").outerHeight();if(!r){var s="sap.ui.table.Table:sapUiTableRowHeight";if($.parents().hasClass('sapUiSizeCompact')){s="sap.ui.table.Table:sapUiTableCompactRowHeight";}r=parseInt(P.get(s),10);}var M=window.innerHeight-2*r;var f=h-(i-e);var A=Math.min(f,M);return Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount())+1,Math.max(m,Math.floor((A+1)/r)));};T.prototype.setShowNoData=function(s){this.setProperty('showNoData',s,true);s=this.getProperty('showNoData');if(!s){this.$().removeClass("sapUiTableEmpty");}else{this._updateNoData();}return this;};T.prototype.setNoDataText=function(t){this.setProperty("noDataText",t,true);this.$().find('.sapUiTableCtrlEmptyMsg').text(t);};T.prototype.exportData=function(s){q.sap.require("sap.ui.core.util.Export");s=s||{};if(!s.rows){var B=this.getBinding("rows"),o=this.getBindingInfo("rows");var f=B.aFilters.concat(B.aApplicationFilters);s.rows={path:o.path,model:o.model,sorter:B.aSorters,filters:f,parameters:o.parameters};}if(!s.exportType){q.sap.require("sap.ui.core.util.ExportTypeCSV");s.exportType=new sap.ui.core.util.ExportTypeCSV();}var m=s.rows.model;if(!m){var p=s.rows.path;var e=p.indexOf(">");if(e>0){m=p.substr(0,e);}}if(!s.columns){s.columns=[];var g=this.getColumns();for(var i=0,l=g.length;i<l;i++){var h=g[i];if(h.getSortProperty()){s.columns.push({name:h.getLabel().getText(),template:{content:{path:h.getSortProperty(),model:m}}});}}}var E=new sap.ui.core.util.Export(s);this.addDependent(E);return E;};T.prototype._calculateAutomaticColumnWidth=function(e){var t=["sap.m.Text","sap.m.Label","sap.m.Link","sap.ui.commons.TextView","sap.ui.commons.Label","sap.ui.commons.Link"];var $=this.$();var h=0;var f=$.find('td[headers=\"'+this.getId()+'_col'+e+'\"]').children("div");var o=this.getColumns();var g=o[e];if(!g){return null;}var H=g.getHeaderSpan();var j=g.getLabel();var k=this;var l=g.getTemplate();var m=q.inArray(l.getMetadata().getName(),t)!=-1||sap.ui.commons&&sap.ui.commons.TextField&&l instanceof sap.ui.commons.TextField||sap.m&&sap.m.Input&&l instanceof sap.m.Input;var n=document.createElement("div");document.body.appendChild(n);q(n).addClass("sapUiTableHiddenSizeDetector");var p=g.getMultiLabels();if(p.length==0&&!!j){p=[j];}if(p.length>0){q.each(p,function(u,L){var v;if(!!L.getText()){q(n).text(L.getText());h=n.scrollWidth;}else{h=L.$().scrollWidth;}h=h+$.find("#"+g.getId()+"-icons").first().width();$.find(".sapUiTableColIcons#"+g.getId()+"_"+u+"-icons").first().width();if(H instanceof Array&&H[u]>1){v=H[u];}else if(H>1){v=H;}if(!!v){var i=v-1;while(i>e){h=h-(k._oCalcColumnWidths[e+i]||0);i-=1;}}});}var r=Math.max.apply(null,f.map(function(){var _=q(this);return parseInt(_.css('padding-left'),10)+parseInt(_.css('padding-right'),10)+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10);}).get());var s=Math.max.apply(null,f.children().map(function(){var w=0,W=0;var _=q(this);var i=_.text()||_.val();if(m){q(n).text(i);W=n.scrollWidth;}else{W=this.scrollWidth;}if(h>W){W=h;}w=W+parseInt(_.css('margin-left'),10)+parseInt(_.css('margin-right'),10)+r+1;return w;}).get());q(n).remove();return Math.max(s,this._iColMinWidth);};T.prototype._onPersoApplied=function(){var e=this.getColumns();var s=[];for(var i=0,l=e.length;i<l;i++){var o=e[i];if(o.getSorted()){s.push(new sap.ui.model.Sorter(o.getSortProperty(),o.getSortOrder()===sap.ui.table.SortOrder.Descending));}}if(s.length>0&&this.getBinding("rows")){this.getBinding("rows").sort(s);}this.refreshRows();};T.prototype._toggleSelectAll=function(){if(!this.$("selall").hasClass("sapUiTableSelAll")){this.clearSelection();}else{this.selectAll();}if(!!sap.ui.Device.browser.internet_explorer){this.$("selall").focus();}};T.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var e=this.getColumns();q.each(e,function(i,o){o._restoreAppDefaults();});};T.prototype._setBusy=function(p){var B,i,s;if(!this.getEnableBusyIndicator()||!this._bBusyIndicatorAllowed){return;}B=this.getBinding("rows");if(!B){return;}this.setBusy(false);if(p){if(p.contexts&&p.contexts.length!==undefined){s=false;for(i=0;i<p.contexts.length;i++){if(p.contexts[i]===undefined){s=true;break;}}}else if(p.changeReason===sap.ui.model.ChangeReason.Expand){this.setBusy(true);}var l=B.getLength();if(s||(B.isInitial())||(p.receivedLength===0&&this._iDataRequestedCounter!==0)||(p.receivedLength<p.requestedLength&&p.receivedLength!==l&&p.receivedLength!==l-this.getFirstVisibleRow())){this.setBusy(true);}}};T.prototype.setEnableBusyIndicator=function(v){this.setProperty("enableBusyIndicator",v,true);};T.prototype.setColumnHeaderVisible=function(e){this.setProperty("columnHeaderVisible",e);this._iLastSelectedDataRow=this._getHeaderRowCount();};T.prototype._attachDataRequestedListeners=function(){var B=this.getBinding("rows");if(B){this._iDataRequestedCounter=0;B.detachDataRequested(this._onBindingDataRequestedListener,this);B.detachDataReceived(this._onBindingDataReceivedListener,this);B.attachDataRequested(this._onBindingDataRequestedListener,this);B.attachDataReceived(this._onBindingDataReceivedListener,this);}};T.prototype._onBindingDataRequestedListener=function(){this._iDataRequestedCounter++;};T.prototype._onBindingDataReceivedListener=function(){this._iDataRequestedCounter--;};T.prototype._attachBindingListener=function(){this._attachDataRequestedListeners();};T.prototype._setLargeDataScrolling=function(l){if(this._oVSb){this._oVSb._bLargeDataScrolling=!!l;}else{q.sap.log.error("Vertical Scrollbar wasn't initialized yet.");}};return T;},true);
