/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator'],function(q,l,C,E){"use strict";var S=C.extend("sap.m.Slider",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:""},min:{type:"float",group:"Data",defaultValue:0},max:{type:"float",group:"Data",defaultValue:100},step:{type:"float",group:"Data",defaultValue:1},progress:{type:"boolean",group:"Misc",defaultValue:true},value:{type:"float",group:"Data",defaultValue:0},showHandleTooltip:{type:"boolean",group:"Appearance",defaultValue:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"float"}}},liveChange:{parameters:{value:{type:"float"}}}}}});E.apply(S.prototype,[true]);S.prototype._convertValueToRtlMode=function(v){return this.getMax()-v+this.getMin();};S.prototype._recalculateStyles=function(){var s=this.$();this._fSliderWidth=s.width();this._fSliderPaddingLeft=parseFloat(s.css("padding-left"));this._fSliderOffsetLeft=s.offset().left;this._fHandleWidth=this.$("handle").width();};S.prototype._validateProperties=function(){var m=this.getMin(),M=this.getMax(),s=this.getStep(),b=false,e=false;if(m>=M){b=true;e=true;q.sap.log.warning("Warning: "+"Property wrong min: "+m+" >= max: "+M+" on ",this);}if(s<=0){q.sap.log.warning("Warning: "+"The step could not be negative on ",this);s=1;this.setProperty("step",s,true);}if(s>(M-m)&&!b){e=true;q.sap.log.warning("Warning: "+"Property wrong step: "+s+" > max: "+M+" - "+"min: "+m+" on ",this);}return e;};S.prototype._getPercentOfValue=function(v){var m=this.getMin();return(((v-m)/(this.getMax()-m))*100);};S.prototype._validateStep=function(s){if(typeof s==="undefined"){return 1;}if(typeof s!=="number"){q.sap.log.warning('Warning: "iStep" needs to be a number',this);return 0;}if((Math.floor(s)===s)&&isFinite(s)){return s;}q.sap.log.warning('Warning: "iStep" needs to be a finite interger',this);return 0;};S.prototype._getPrecisionOfNumber=function(v){if(Math.floor(v)===v){return 0;}var V=v.toString(),i=V.indexOf("."),I=V.indexOf("e-");if(i!==-1){return V.length-i-1;}if(I!==-1){return+V.slice(I+2);}return 0;};S.prototype._setValue=function(n,o){var m=this.getMin(),M=this.getMax(),s=this.getStep(),v=this.getValue(),f;var b=true;if(o){b=!!o.snapValue;}if(typeof n!=="number"||!isFinite(n)){q.sap.log.error("Error:",'"fNewValue" needs to be a finite number on ',this);return this;}f=Math.abs((n-m)%s);if(b&&(f!==0)){n=f*2>=s?n+s-f:n-f;}var p=this._getPrecisionOfNumber(s);if(p>20){p=20;}else if(p<0){p=0;}n=Number(n.toFixed(p));if(n<m){n=m;}else if(n>M){n=M;}this.setProperty("value",n,true);if(v!==this.getValue()){this.setDomValue(n);}return this;};S.prototype.setDomValue=function(n){var p,h,d=this.getDomRef();if(!d){return;}p=Math.max(this._getPercentOfValue(n),0)+"%";h=this.getDomRef("handle");if(!!this.getName()){this.getDomRef("input").setAttribute("value",n);}if(this.getProgress()){this.getDomRef("progress").style.width=p;}h.style[sap.ui.getCore().getConfiguration().getRTL()?"right":"left"]=p;if(this.getShowHandleTooltip()){h.title=n;}h.setAttribute("aria-valuenow",n);};S.prototype.getClosestHandleDomRef=function(){return this.getDomRef("handle");};S.prototype._increaseValueBy=function(i){var v,n;if(this.getEnabled()){v=this.getValue();this.setValue(v+(i||1));n=this.getValue();if(v<n){this._fireChangeAndLiveChange({value:n});}}};S.prototype._decreaseValueBy=function(d){var v,n;if(this.getEnabled()){v=this.getValue();this.setValue(v-(d||1));n=this.getValue();if(v>n){this._fireChangeAndLiveChange({value:n});}}};S.prototype._getLongStep=function(){var m=this.getMin(),M=this.getMax(),s=this.getStep(),L=(M-m)/10,i=(M-m)/s;return i>10?L:s;};S.prototype._fireChangeAndLiveChange=function(p){this.fireChange(p);this.fireLiveChange(p);};S.prototype._hasFocus=function(){return document.activeElement===this.getFocusDomRef();};S.prototype.onBeforeRendering=function(){var e=this._validateProperties();if(!e){this.setValue(this.getValue());this._sProgressValue=Math.max(this._getPercentOfValue(this.getValue()),0)+"%";}if(!this._hasFocus()){this._fInitialFocusValue=this.getValue();}};S.prototype.ontouchstart=function(e){var m=this.getMin(),t=e.targetTouches[0],n,a=this.getRenderer().CSS_CLASS,s="."+a;e.setMarked();if(e.targetTouches.length>1||!this.getEnabled()||e.button){return;}q(document).on("touchend"+s+" touchcancel"+s+" mouseup"+s,this._ontouchend.bind(this)).on(e.originalEvent.type==="touchstart"?"touchmove"+s:"touchmove"+s+" mousemove"+s,this._ontouchmove.bind(this));var N=this.getClosestHandleDomRef();if(t.target!==N){q.sap.delayedCall(0,N,"focus");}if(!this._hasFocus()){this._fInitialFocusValue=this.getValue();}this._recalculateStyles();this._fDiffX=this._fSliderPaddingLeft;this._fInitialValue=this.getValue();this.$("inner").addClass(a+"Pressed");if(t.target===this.getDomRef("handle")){this._fDiffX=(t.pageX-q(N).offset().left)+this._fSliderPaddingLeft-(this._fHandleWidth/2);}else{n=(((t.pageX-this._fSliderPaddingLeft-this._fSliderOffsetLeft)/this._fSliderWidth)*(this.getMax()-m))+m;if(sap.ui.getCore().getConfiguration().getRTL()){n=this._convertValueToRtlMode(n);}this.setValue(n);n=this.getValue();if(this._fInitialValue!==n){this.fireLiveChange({value:n});}}};S.prototype._ontouchmove=function(e){e.setMarked();e.preventDefault();if(e.isMarked("delayedMouseEvent")||!this.getEnabled()||e.button){return;}var m=this.getMin(),v=this.getValue(),p=e.targetTouches?e.targetTouches[0].pageX:e.pageX,n=(((p-this._fDiffX-this._fSliderOffsetLeft)/this._fSliderWidth)*(this.getMax()-m))+m;if(sap.ui.getCore().getConfiguration().getRTL()){n=this._convertValueToRtlMode(n);}this.setValue(n);n=this.getValue();if(v!==n){this.fireLiveChange({value:n});}};S.prototype._ontouchend=function(e){var a=this.getRenderer().CSS_CLASS,s="."+a;e.setMarked();if(e.isMarked("delayedMouseEvent")||!this.getEnabled()||e.button){return;}q(document).off(s);var v=this.getValue();this.$("inner").removeClass(a+"Pressed");if(this._fInitialValue!==v){this.fireChange({value:v});}};S.prototype.onsapincrease=function(e){var v,n;e.preventDefault();e.setMarked();if(this.getEnabled()){v=this.getValue();this.stepUp(1);n=this.getValue();if(v<n){this._fireChangeAndLiveChange({value:n});}}};S.prototype.onsapincreasemodifiers=function(e){e.preventDefault();e.setMarked();this._increaseValueBy(this._getLongStep());};S.prototype.onsapdecrease=function(e){var v,n;e.preventDefault();e.setMarked();if(this.getEnabled()){v=this.getValue();this.stepDown(1);n=this.getValue();if(v>n){this._fireChangeAndLiveChange({value:n});}}};S.prototype.onsapdecreasemodifiers=function(e){e.preventDefault();e.setMarked();this._decreaseValueBy(this._getLongStep());};S.prototype.onsapplus=function(e){var v,n;e.setMarked();if(this.getEnabled()){v=this.getValue();this.stepUp(1);n=this.getValue();if(v<n){this._fireChangeAndLiveChange({value:n});}}};S.prototype.onsapminus=function(e){var v,n;e.setMarked();if(this.getEnabled()){v=this.getValue();this.stepDown(1);n=this.getValue();if(v>n){this._fireChangeAndLiveChange({value:n});}}};S.prototype.onsappageup=S.prototype.onsapincreasemodifiers;S.prototype.onsappagedown=S.prototype.onsapdecreasemodifiers;S.prototype.onsaphome=function(e){e.setMarked();var m=this.getMin();e.preventDefault();if(this.getEnabled()&&this.getValue()>m){this.setValue(m);this._fireChangeAndLiveChange({value:m});}};S.prototype.onsapend=function(e){e.setMarked();var m=this.getMax();e.preventDefault();if(this.getEnabled()&&this.getValue()<m){this.setValue(m);this._fireChangeAndLiveChange({value:m});}};S.prototype.onsaptabnext=function(){this._fInitialFocusValue=this.getValue();};S.prototype.onsaptabprevious=function(){this._fInitialFocusValue=this.getValue();};S.prototype.onsapescape=function(){this.setValue(this._fInitialFocusValue);};S.prototype.getFocusDomRef=function(){return this.getDomRef("handle");};S.prototype.stepUp=function(s){return this.setValue(this.getValue()+(this._validateStep(s)*this.getStep()),{snapValue:false});};S.prototype.stepDown=function(s){return this.setValue(this.getValue()-(this._validateStep(s)*this.getStep()),{snapValue:false});};S.prototype.setValue=function(n){this.setValue=this._setValue;return this.setProperty("value",n,true);};return S;},true);
