// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.ux3.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ActionBarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.ux3.ActionBarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ActionBarRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Static initializer. Creates and empty ActionBarRenderer instance.
	 *
	 * @class ActionBar renderer.
	 * @static
	 */
	var ActionBarRenderer = {
	};



	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ActionBarRenderer.render = function(oRenderManager, oControl){
		// convenience variable
		var rm = oRenderManager;

		// render ActionBar
		// result: <div id="<id>" data-sap-ui="<id>" class="sapUiUx3ActionBar" role="toolbar">
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3ActionBar");
		rm.writeClasses();
		if ( sap.ui.getCore().getConfiguration().getAccessibility()) {
			rm.writeAttribute('role', 'toolbar');
		}
		rm.write(">");

		// render list for social actions
		rm.write("<ul");
		rm.writeAttribute('id', oControl.getId() + "-socialActions");
		rm.addClass("sapUiUx3ActionBarSocialActions");
		rm.writeClasses();

		rm.addStyle("min-width", oControl._getSocialActionListMinWidth() + "px");
		rm.writeStyles();

		rm.write(">");
		this.renderSocialActions(rm, oControl);
		rm.write("</ul>");

		// render list for business actions
		rm.write("<ul  id='" + oControl.getId() + "-businessActions' class='sapUiUx3ActionBarBusinessActions'>");
		this.renderBusinessActionButtons(rm, oControl);
		rm.write("</ul>");

		// closing tag for toolbar
		rm.write("</div>");

	};

	/**
	 * Renders the HTML for toolbar buttons of business actions
	 *
	 * @param {sap.ui.core.RenderManager}
	 *			rm the RenderManager that can be used for writing to
	 *			the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *			oControl an object representation of the control that should be
	 *			rendered
	 */
	ActionBarRenderer.renderBusinessActionButtons = function(rm, oControl) {

		var actionButtons = oControl._getBusinessActionButtons();
		var oMoreMenuButton = oControl._getMoreMenuButton();

		if (actionButtons && actionButtons.length > 0) {
			//Render list for business action buttons
			//Do not write attribue tabindex in list element because this is
			//already contained in the buttons control. If you write it twice,
			//both arrow and tab will work, which is wrong
			for ( var i = 0; i < actionButtons.length; i++) {
				var oButton = actionButtons[i];
				rm.write("<li");
				rm.addClass("sapUiUx3ActionBarItemRight");
				rm.writeClasses();
				rm.write(">");
				rm.renderControl(oButton);
				rm.write("</li>");
			}
			this._renderMoreMenuButton(rm, oMoreMenuButton);
		} else if (oMoreMenuButton) {
			//There may be business actions which have to be displayed in the "More Menu"
			this._renderMoreMenuButton(rm, oMoreMenuButton);
		}
	}

	/**
	 * Renders "More" menu button if present
	 *
	 * @param {sap.ui.core.RenderManager}
	 *			rm the RenderManager that can be used for writing to
	 *			the Render-Output-Buffer
	 * @param {sap.ui.commons.MenuButton}
	 *			oMoreMenuButton menu button to be rendered, may be null
	 * @private
	 */;
	ActionBarRenderer._renderMoreMenuButton = function (rm, oMoreMenuButton) {

		if (oMoreMenuButton) {
			rm.write("<li");
			rm.addClass("sapUiUx3ActionBarItemRight");
			rm.addClass("sapUiUx3ActionBarMoreButton");
			rm.writeClasses();
			rm.write(">");
			rm.renderControl(oMoreMenuButton);
			rm.write("</li>");
		}
	};



	/**
	 * Renders the HTML for sap.ui.ux3.Actionbar: social actions in a specified order:
	 * 1. Update (Feed)
	 * 2. Follow
	 * 3. Flag
	 * 4. Favorite
	 * 5. Open
	 *
	 * They are rendered only if they are present in action bar's 'mActionMap' though.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *			rm the RenderManager that can be used for writing to
	 *			the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *			oControl an object representation of the control that should be
	 *			rendered
	 */
	 ActionBarRenderer.renderSocialActions = function(rm, oControl) {

		var mMap = oControl.mActionMap;
		var mKeys = oControl.mActionKeys;


		if (mMap[mKeys.Update]) {
			this._renderSocialActionListItem(rm, oControl, mMap[mKeys.Update]);
		}
		if (mMap[mKeys.Follow]) {
			this._renderSocialActionListItem(rm, oControl, mMap[mKeys.Follow]);
		}
		if (mMap[mKeys.Flag]) {
			this._renderSocialActionListItem(rm, oControl, mMap[mKeys.Flag]);
		}
		if (mMap[mKeys.Favorite]) {
			this._renderSocialActionListItem(rm, oControl, mMap[mKeys.Favorite]);
		}
		if (mMap[mKeys.Open]) {
			this._renderSocialActionListItem(rm, oControl, mMap[mKeys.Open]);
		}
		//Render social actions, which might have been added by an application
		//developer to aggregation 'socialActions' manually and which are not contained
		//in the predefined list of social actions Update, Follow, Flag, Favorite, Open
		for (var sKey in  mMap) {
			if (!(sKey in sap.ui.ux3.ActionBarSocialActions)) {
				this._renderSocialActionListItem(rm, oControl, mMap[sKey]);
			}
		}
	 };

	 /**
	  * Renders the HTML for sap.ui.ux3.Actionbar: single social action list item
	  *
	  * @param {sap.ui.core.RenderManager}
	  *			rm the RenderManager that can be used for writing to
	  *			the Render-Output-Buffer
	  * @param {sap.ui.core.Control}
	  *			oControl an object representation of the control that should be
	  *			rendered
	  * @param {sap.ui.ux3.ThingAction}
	  *			action an object representation of the control that should be
	  *			rendered
	  *  @private
	  */
	  ActionBarRenderer._renderSocialActionListItem = function(rm, oControl, action) {
		if (action && !action.hide) {
			rm.write("<li");
			rm.addClass("sapUiUx3ActionBarItem");
			rm.writeClasses();
			rm.write(">");
			this._renderSocialAction(rm, oControl, action);
			rm.write("</li>");
		}
	  };


	 /**
	 * Renders the HTML for sap.ui.ux3.Actionbar: single social action
	 *
	 * @param {sap.ui.core.RenderManager}
	 *			rm the RenderManager that can be used for writing to
	 *			the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *			oControl an object representation of the control that should be
	 *			rendered
	 * @param {sap.ui.ux3.ThingAction}
	 *			action an object representation of the control that should be
	 *			rendered
	 *  @private
	 */
	 ActionBarRenderer._renderSocialAction = function(rm, oControl, action) {
		if (action.isMenu && action.isMenu(oControl)) {
			rm.write("<a role=\"button\" aria-disabled=\"false\" aria-haspopup=\"true\"");
		} else {
			rm.write("<a  role=\"button\" aria-disabled=\"false\" aria-haspopup=\"false\"");
		}
		if (action.name == oControl.mActionKeys.Flag || action.name == oControl.mActionKeys.Favorite) {
			rm.writeAttribute("aria-pressed", action.fnCalculateState(oControl) == "Selected" ? "true" : "false");
		}
		rm.writeAttribute("tabindex", "0");
		rm.writeElementData(action);
		rm.addClass(action.cssClass);
		if (action.fnCalculateState) {
			rm.addClass(action.fnCalculateState(oControl));
		}
		rm.addClass("sapUiUx3ActionBarAction");
		rm.writeClasses();

		if (action.getTooltip()) {
			rm.writeAttributeEscaped("title", action.getTooltip());
		}
		if (action.text) {
			rm.writeAttributeEscaped("text", oControl.getLocalizedText(action.getText()));
		}
		rm.write("></a>");
	 };






	return ActionBarRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ActionBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.CollectionInspectorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.Collection
jQuery.sap.declare('sap.ui.ux3.CollectionInspectorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/CollectionInspectorRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Collection renderer.
	 * @namespace
	 */
	var CollectionInspectorRenderer = {};
	
	/**
	 * Renders the Collection
	 * 
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	CollectionInspectorRenderer.render = function(oRenderManager,
			oControl) {
		// convenience variable
		var rm = oRenderManager;
	
		rm.write("<div");
		rm.addClass("sapUiUx3CI");
		if (oControl.getSidebarVisible()) {
			rm.addClass("sapUiUx3CISidebarOpened");
		} else {
			rm.addClass("sapUiUx3CISidebarClosed");
		}
		if (oControl.getFitParent()) {
			rm.addClass("sapUiUx3CIFitParent");
		}
		rm.writeClasses();
		rm.writeControlData(oControl);
		rm.write(">");
	
		rm.write("<div");
		rm.addClass("sapUiUx3CIToolBar");
		rm.writeClasses();
		rm.write(">");
	
		this.renderToggleButton(rm, oControl);
		this.renderCollectionSelector(rm, oControl);
	
		rm.write("</div>");
		
		rm.write('<div');
		rm.addClass("sapUiUx3CISidebar");
		rm.writeClasses();
		rm.writeAttribute("id", oControl.getId() + "-sidebar");
		rm.write(">");
		this.renderSidebar(rm, oControl);
		rm.write("</div>");
	
		rm.write("<div");
		rm.addClass("sapUiUx3CIContent");
		rm.writeAttribute("id", oControl.getId() + "-content");
		rm.writeClasses();
		rm.write(">");
		this.renderContent(rm, oControl);
		rm.write("</div>");
		rm.write("<div");
		rm.addClass("sapUiUx3CIClear");
		rm.writeClasses();
		rm.write(">");
		rm.write("</div>");
		rm.write("</div>");
	};
	
	/**
	 * Renders the ToggleButton to open and close the sidebar
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	CollectionInspectorRenderer.renderToggleButton = function(rm, oControl) {
		// render Togglebutton
		if (oControl.getToggleButton()) {
			rm.write("<div");
			rm.writeAttribute("id", oControl.getId() + "-togglebutton");
			rm.addClass("sapUiUx3CIToggleButton");
			rm.writeClasses();
			rm.write(">");
			rm.renderControl(oControl.getToggleButton());
			rm.write("</div>");
		}
	};
	
	/**
	 * Renders the collection selector which selects the current collection
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	CollectionInspectorRenderer.renderCollectionSelector = function(rm, oControl) {
		// render collection selector
		if (oControl.getCollectionSelector()) {
			rm.write("<div");
			rm.addClass("sapUiUx3CICollectionSelector");
			rm.writeClasses();
			rm.write(">");
			rm.renderControl(oControl.getCollectionSelector());
			rm.write("</div>");
		}
	};
	
	/**
	 * Renders the Sidebar which displays all collections
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	CollectionInspectorRenderer.renderSidebar = function(rm, oControl) {
		rm.write("<div");
		rm.addClass("sapUiUx3CICollectionListContainer");
		rm.writeClasses();
		rm.write(">");
		rm.write('<ul tabindex="-1"');
		rm.addClass("sapUiUx3CICollectionList");
		rm.writeClasses();
		var oCollection = sap.ui.getCore().byId(oControl.getSelectedCollection());
	
		//ARIA
		if (oControl.getSelectedCollection()) {
			rm.writeAccessibilityState(oCollection, {
				role: "listbox",
				multiselectable: oCollection.getMultiSelection()
			});
		}
		rm.write(">");
		if (oControl.getSelectedCollection()) {
			var iItemCount = oCollection.getItems().length;
			jQuery.each(oCollection.getItems(), function(iIndex, oCollectionItem) {
				rm.write('<li tabindex="-1"');
				rm.writeElementData(oCollectionItem);
				rm.writeAttributeEscaped("title",oCollectionItem.getText());
				rm.addClass("sapUiUx3CICollectionListItem");
				rm.writeClasses();
	
				// ARIA
				rm.writeAccessibilityState(oCollectionItem, {
					role: "option",
					selected: (jQuery.inArray(oCollectionItem.getId(),oCollection.getSelectedItems()) >= 0),
					setsize: iItemCount,
					posinset: iIndex
				});
	
				rm.write(">");
				rm.writeEscaped(oCollectionItem.getText());
				rm.write("</li>");
			});
		}
		rm.write("</ul></div>");
		rm.renderControl(oControl.getEditButton());
	};
	
	/**
	 * Renders the Content that is displayed
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	CollectionInspectorRenderer.renderContent = function(rm, oControl) {
		jQuery.each(oControl.getContent(), function(iIndex, oContent) {
			rm.renderControl(oContent);
		});
	};

	return CollectionInspectorRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/CollectionInspectorRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.DataSetRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.DataSet
jQuery.sap.declare('sap.ui.ux3.DataSetRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/DataSetRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * DataSet renderer.
	 * @namespace
	 */
	var DataSetRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered
	 */
	DataSetRenderer.render = function(oRenderManager, oControl){
		// convenience variable
		var rm = oRenderManager,
			oView = null;
	
		oControl.prepareRendering();
	
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3DS");
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
		rm.write("<div id='" + oControl.getId() + "-toolbar'");
		rm.addClass('sapUiUx3DSToolbar');
		if (!oControl.getShowToolbar()) {
			rm.addClass('noPadding');
		}
		rm.writeClasses();
		rm.write(">");
		this.renderToolbar(rm,oControl);
		rm.write("</div>");
		rm.write("<div id='" + oControl.getId() + "-filter'");
		rm.addClass('sapUiUx3DSFilterArea');
		if (!oControl.getShowFilter()) {
			rm.addClass('noPadding');
		}
		rm.writeClasses();
		rm.write(">");
		this.renderFilterArea(rm,oControl);
		rm.write("</div>");
		rm.write("<div");
		rm.writeAttribute("id", oControl.getId() + "-items");
		rm.addClass("sapUiUx3DSItems");
		rm.writeClasses();
		rm.write(">");
		oView = sap.ui.getCore().byId(oControl.getSelectedView());
		rm.renderControl(oView);
		rm.write("</div>");
		rm.write("</div>");
	};
	
	/**
	 * Renders the HTML for the DataSet Toolbar
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager The RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl An object representation of the control that should be
	 *            rendered
	 */
	DataSetRenderer.renderToolbar = function(oRenderManager,oControl) {
		var rm = oRenderManager;
		if (oControl.getShowToolbar()) {
			rm.renderControl(oControl._getToolbar());
		}
	};
	
	/**
	 * Renders the HTML for the DataSet FilterArea
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager The RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl An object representation of the control that should be
	 *            rendered
	 */
	DataSetRenderer.renderFilterArea = function(oRenderManager,oControl) {
		var rm = oRenderManager, aFilter = oControl.getFilter();
		if (oControl.getShowFilter()) {
			jQuery.each(aFilter,function(i, oFilter){
				rm.renderControl(oFilter);
			});
		}
	};
	

	return DataSetRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/DataSetRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.DataSetSimpleViewRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

 // Provides default renderer for the sap.ui.ux3.DataSetSimpleView
jQuery.sap.declare('sap.ui.ux3.DataSetSimpleViewRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/DataSetSimpleViewRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * DataSetSimpleView renderer.
	 * @namespace
	 */
	var DataSetSimpleViewRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	DataSetSimpleViewRenderer.render = function(oRenderManager, oControl){
	     // convenience variable
		var rm = oRenderManager;
		// write the HTML into the render manager
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3DSSV");
		if (oControl.getFloating()) {
			if (oControl.getResponsive()) {
				rm.addClass("sapUiUx3DSSVResponsive");
			} else {
				rm.addClass("sapUiUx3DSSVFloating");
			}
		} else {
			rm.addClass("sapUiUx3DSSVSingleRow");
		}
		if (oControl.getHeight()) {
			rm.addStyle("height", oControl.getHeight());
			rm.addClass("sapUiUx3DSSVSA");
		}
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">"); // SPAN element
		if ( oControl.items) {
			for (var i = 0; i < oControl.items.length; i++) {
				this.renderItem(rm, oControl, oControl.items[i]);
			}
		}
		rm.write("</div>");
	};
	
	DataSetSimpleViewRenderer.renderItem = function(rm, oControl, oItem){
		rm.write("<div");
		rm.addClass("sapUiUx3DSSVItem");
		if (oControl.getFloating()) {
			rm.addClass("sapUiUx3DSSVFlow");
			if (oControl.getItemMinWidth() > 0) {
				rm.writeAttribute("style","min-width:" + oControl.getItemMinWidth() + "px");
			}
		}
		if (oControl.isItemSelected(oItem)) {
			rm.addClass("sapUiUx3DSSVSelected");
		}
		rm.writeClasses();
		rm.writeElementData(oItem);
		rm.write(">");
		rm.renderControl(oItem.getAggregation("_template"));
		rm.write("</div>");
	};
	

	return DataSetSimpleViewRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/DataSetSimpleViewRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ExactAreaRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.ExactArea
jQuery.sap.declare('sap.ui.ux3.ExactAreaRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ExactAreaRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ExactArea renderer.
	 * @namespace
	 */
	var ExactAreaRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ExactAreaRenderer.render = function(oRenderManager, oControl){
		var rm = oRenderManager;

		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3ExactArea");
		rm.writeClasses();
		rm.write(">");
		if (oControl.getToolbarVisible()) {
			rm.write("<div id=\"" + oControl.getId() + "-tb\" class=\"sapUiTb sapUiTbDesignFlat sapUiTbStandalone\" role=\"toolbar\">");
			rm.write("<div class=\"sapUiTbCont\"><div class=\"sapUiTbInner\">");
			var aToolbarItems = oControl.getToolbarItems();
			for (var idx = 0; idx < aToolbarItems.length; idx++) {
				var oToolbarItem = aToolbarItems[idx];
				if (oToolbarItem instanceof sap.ui.commons.ToolbarSeparator) {
					sap.ui.commons.ToolbarRenderer.renderSeparator(rm, oToolbarItem);
				} else if (oToolbarItem instanceof sap.ui.ux3.ExactAreaToolbarTitle) {
					rm.write("<div class=\"sapUiUx3ExactAreaTbTitle\">" + jQuery.sap.encodeHTML(oToolbarItem.getText()) + "</div>");
				} else {
					rm.renderControl(oToolbarItem);
				}
			}
			rm.write("</div></div></div>");
		}
		rm.write("<div id=\"" + oControl.getId() + "-ct\" class=\"sapUiUx3ExactAreaCont\">");
		var aChildren = oControl.getContent();
		for (var idx = 0; idx < aChildren.length; idx++) {
			rm.renderControl(aChildren[idx]);
		}
		rm.write("</div>");
		rm.write("</div>");
	};

	return ExactAreaRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ExactAreaRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ExactBrowserRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.ExactBrowser
jQuery.sap.declare('sap.ui.ux3.ExactBrowserRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ExactBrowserRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ExactBrowser renderer.
	 * @namespace
	 */
	var ExactBrowserRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ExactBrowserRenderer.render = function(oRenderManager, oControl){
		var rm = oRenderManager;
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3ExactBrwsr");
		rm.writeClasses();
		rm.writeAttribute("role", "region");
		if (oControl.getShowHeader()) {
			rm.writeAttribute("aria-labelledby", oControl.getId() + "-hdtitle");
		}
		if (oControl.getFollowUpControl()) {
			rm.writeAttribute("aria-controls", oControl.getFollowUpControl());
		}
	
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		rm.write(">");
	
		if (oControl.getShowHeader()) {
			rm.write("<div class=\"sapUiUx3ExactBrwsrHd\"><h2 id=\"" + oControl.getId() + "-hdtitle\">");
			rm.write(jQuery.sap.encodeHTML(oControl.getHeaderTitle()));
			rm.write("</h2><div class=\"sapUiUx3ExactBrwsrHdTool\" role=\"toolbar\">");
			if (oControl.getEnableSave()) {
				rm.renderControl(oControl._saveButton);
			}
			if (oControl.getEnableReset()) {
				rm.renderControl(oControl._resetButton);
			}
			rm.write("</div></div>");
		}
		rm.renderControl(oControl._rootList);
		rm.write("</div>");
	};

	return ExactBrowserRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ExactBrowserRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ExactListRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.ExactListRenderer
jQuery.sap.declare('sap.ui.ux3.ExactListRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ExactListRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ExactList renderer.
	 * @namespace
	 */
	var ExactListRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ExactListRenderer.render = function(oRenderManager, oControl){
	
		var rm = oRenderManager;
		var aSubLists = oControl.getSubLists();
		var oAttribute = oControl._getAtt();
		
		if (!oAttribute) {
			return; //No Attribute attached to this list -> ignore rendering
		}
		
		var bIsTop = oControl._isTop();
	
		// render the root tag
	    rm.write("<div");
	    rm.writeControlData(oControl);
	    rm.addClass("sapUiUx3ExactLst");
	    var bActiveTitle = false;
	    
	    var bTopListHidden = false;
	    
	    if (bIsTop) {
				var oBrowser = oControl.getParent();
				if (oBrowser) {
					if (oBrowser.hasOptionsMenu) {
						bActiveTitle = oBrowser.hasOptionsMenu();
						if (bActiveTitle) {
							rm.addClass("sapUiUx3ExactLstTopActive");
						}
					}
					if (oBrowser.getShowTopList && !oBrowser.getShowTopList()) {
						rm.addClass("sapUiUx3ExactLstTopHidden");
						bTopListHidden = true;
					}
				}
				
			rm.addClass("sapUiUx3ExactLstTop");
			rm.addStyle("height", oControl.getTopHeight() + "px");
	    }
	    if (oControl._bCollapsed) {
			rm.addClass("sapUiUx3ExactLstCollapsed");
	    }
	    
	    rm.addClass("sapUiUx3ExactLstLvl_" + oControl._iLevel);
	
	    rm.writeClasses();
	    rm.writeStyles();
	    rm.write(">");
	    
	    if (bTopListHidden) {
				rm.write("<div id=\"" + oControl.getId() + "-foc\" class=\"sapUiUx3ExactLstFoc\" tabindex=\"0\"></div>");
	    }
	
	    if (!oControl._bPopupOpened) {
			// render the list area with the used listbox
			rm.write("<div id=\"" + oControl.getId() + "-lst\" class=\"sapUiUx3ExactLstLst\"");
				if (oControl._bCollapsed && oControl._oCollapseStyles && oControl._oCollapseStyles["lst"]) {
					rm.write(" style=\"" + oControl._oCollapseStyles["lst"] + "\"");
				}
				
				rm.write(">");
			rm.renderControl(oControl._lb);
			rm.write("<a id=\"" + oControl.getId() + "-exp\" class=\"sapUiUx3ExactLstExp\">" + this.getExpanderSymbol(false, false) + "</a>");
			rm.write("</div>");
	    } else {
				oControl._bRefreshList = true;
	    }
	
	    // render the content area with the sub lists
	    rm.write("<div id=\"" + oControl.getId() + "-cntnt\" ");
	    rm.write("class=\"sapUiUx3ExactLstCntnt");
	    if (aSubLists.length == 0) {
			rm.write(" sapUiUx3ExactLstCntntEmpty");
	    }
	    rm.write("\"");
	    if (oControl._bCollapsed && oControl._oCollapseStyles && oControl._oCollapseStyles["cntnt"]) {
				rm.write(" style=\"" + oControl._oCollapseStyles["cntnt"] + "\"");
	    }
	    rm.write(">");
	    for (var i = 0; i < aSubLists.length; i++) {
			rm.renderControl(aSubLists[i]);
	    }
	    rm.write("</div>");
	
	    // render the header
	    rm.write("<header id=\"" + oControl.getId() + "-head\" class=\"sapUiUx3ExactLstHead\"");
	    if (bIsTop && bActiveTitle) {
				rm.write(" role=\"button\" aria-haspopup=\"true\"");
	    }
	    if (!bIsTop && oControl._bCollapsed && oAttribute) {
				rm.writeAttribute("role", "region");
				rm.writeAttribute("aria-expanded", "false");
				rm.writeAttributeEscaped("aria-label", oControl._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL", [oControl._iLevel, oAttribute.getText()]));
	    }
	    rm.write(" tabindex=\"" + (bIsTop ? "0" : "-1") + "\">");
	    if (bIsTop) {
			// render the header content for top list
			rm.write("<h3 id=\"" + oControl.getId() + "-head-txt\" class=\"sapUiUx3ExactLstHeadTopTxt\"><span class=\"sapUiUx3ExactLstHeadTopTxtTxt\">");
			if (oControl.getTopTitle()) {
				rm.writeEscaped(oControl.getTopTitle());
			}
			rm.write("</span>");
			if (bActiveTitle) {
				rm.write("<span class=\"sapUiUx3ExactLstHeadTopIco\"></span>");
			}
			rm.write("</span></h3>");
	    } else {
			// render the header content for non-top list
			rm.write("<h3 id=\"" + oControl.getId() + "-head-txt\" class=\"sapUiUx3ExactLstHeadTxt\"");
			if (oAttribute && oAttribute.getTooltip_AsString()) {
				rm.writeAttributeEscaped("title", oAttribute.getTooltip_AsString());
			} else if (oAttribute && oAttribute.getText()) {
				rm.writeAttributeEscaped("title", oAttribute.getText());
			}
			if (oControl._bCollapsed && oControl._oCollapseStyles && oControl._oCollapseStyles["head-txt"]) {
					rm.write(" style=\"" + oControl._oCollapseStyles["head-txt"] + "\"");
			}
			rm.write(">");
			if (oAttribute) {
				rm.writeEscaped(oAttribute.getText());
			}
			rm.write("</h3>");
	
			// render header actions
			rm.write("<div id=\"" + oControl.getId() + "-head-action\" class=\"sapUiUx3ExactLstHeadAct" + (oControl.getShowClose() ? "" : " sapUiUx3ExactLstHeadActNoClose") + "\">");
			rm.write("<a id=\"" + oControl.getId() + "-hide\" class=\"sapUiUx3ExactLstHide\" role=\"presentation\"");
			rm.writeAttributeEscaped("title", oControl._rb.getText(oControl._bCollapsed ? "EXACT_LST_LIST_EXPAND" : "EXACT_LST_LIST_COLLAPSE"));
			rm.write(">", this.getExpanderSymbol(!oControl._bCollapsed, true), "</a>");
			rm.write("<a id=\"" + oControl.getId() + "-close\" role=\"presentation\" class=\"sapUiUx3ExactLstClose\"");
			rm.writeAttributeEscaped("title", oControl._rb.getText("EXACT_LST_LIST_CLOSE"));
			rm.write(">X</a>");
			rm.write("</div>");
	    }
	    rm.write("</header>");
	
	    // render resize bar
	    rm.write("<div id=\"" + oControl.getId() + "-rsz\" class=\"sapUiUx3ExactLstRSz\"></div>");
	
		// close the root tag
	    rm.write("</div>");
	};
	
	
	/**
	 * Returns the symbol for the vertical or horizontal expander depending on the given expand state.
	 * @private
	 */
	ExactListRenderer.getExpanderSymbol = function(bExpanded, bHorizontal){
		if (bHorizontal) {
			if (sap.ui.getCore().getConfiguration().getRTL()) {
				return bExpanded ? "&#9654;" : "&#9664;";
			} else {
				return bExpanded ? "&#9664;" : "&#9654;";
			}
		} else {
			return bExpanded ? "&#9650;" : "&#9660;";
		}
	};
	

	return ExactListRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ExactListRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ExactRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.Exact
jQuery.sap.declare('sap.ui.ux3.ExactRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ExactRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Exact renderer.
	 * @namespace
	 */
	var ExactRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ExactRenderer.render = function(oRenderManager, oControl){
		var rm = oRenderManager;
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3Exact");
		rm.writeClasses();
		var sTooltip = oControl.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		rm.write(">");
		rm.renderControl(oControl._searchArea);
		if (oControl._bDetailsVisible) {
			rm.renderControl(oControl._browser);
			rm.renderControl(oControl._resultText);
			rm.renderControl(oControl._resultArea);
		}
		rm.write("</div>");
	};

	return ExactRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ExactRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.FacetFilterListRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.FacetFilterListRenderer
jQuery.sap.declare('sap.ui.ux3.FacetFilterListRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/FacetFilterListRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * FacetFilterList renderer.
	 * @namespace
	 */
	var FacetFilterListRenderer = {};
	
	/**
	 * Renders the HTML for the given control, using the provided
	 * {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FacetFilterListRenderer.render = function(oRenderManager, oControl) {
	
		var rm = oRenderManager;
	
		rm.write("<div ");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3FFLst");
		rm.writeClasses();
		rm.writeAttribute("style", "width:" + oControl.sWidth);
		rm.write(">");
	
		/*Header*/
		rm.write("<header id=\"" + oControl.getId() + "-head\"  class=\"sapUiUx3FFLstHead\"");
		if (oControl.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oControl.getTooltip_AsString());
		}
		rm.write(">");
		rm.write("<h3 id=\"" + oControl.getId() + "-head-txt\"  class=\"sapUiUx3FFLstHeadTxt\">");
		if (oControl.getTitle()) {
			rm.writeEscaped(oControl.getTitle());
		}
		rm.write("</h3>");
		rm.write("</header>");
	
		// render the list area with the used listbox
		rm.renderControl(oControl._oListBox);
	
		rm.write("</div>");
	};
	

	return FacetFilterListRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/FacetFilterListRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.FacetFilterRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.FacetFilter
jQuery.sap.declare('sap.ui.ux3.FacetFilterRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/FacetFilterRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * FacetFilter renderer.
	 * @namespace
	 */
	var FacetFilterRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FacetFilterRenderer.render = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		var bFullHeight = (oControl.getVisibleItemCountMode() === sap.ui.ux3.VisibleItemCountMode.Auto); // "Auto"
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3FacetFilter");
		rm.writeClasses();
		if (bFullHeight) {
			rm.writeAttribute("style", "height:100%");
		}
		rm.write(">");
		var aLists = oControl.getLists();
		if (aLists) {
			for (var i = 0; i < aLists.length; i++) {
				aLists[i].sWidth = 100 / aLists.length + "%";
				aLists[i].bFullHeight = bFullHeight;
				rm.renderControl(aLists[i]);
			}
		}
		rm.write("</div>");
	};

	return FacetFilterRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/FacetFilterRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.FeedChunkRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.FeedChunk
jQuery.sap.declare('sap.ui.ux3.FeedChunkRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/FeedChunkRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * FeedChunk renderer.
	 * @namespace
	 */
	var FeedChunkRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FeedChunkRenderer.render = function(oRenderManager, oControl){
		// convenience variable
		var rm = oRenderManager;
		var oChunk = oControl;
		// check if chunk is a comment (child) of an other chunk
		if (oChunk.getParent() instanceof sap.ui.ux3.FeedChunk) {
			oChunk.bComment = true;
		} else {
			oChunk.bComment = false;
		}
		var sMyId = oChunk.getId();

		rm.write('<ARTICLE');
		rm.writeControlData(oChunk);
		rm.addClass('sapUiFeedChunk');
		if (oChunk.bComment) {
			rm.addClass('sapUiFeedChunkComment');
		}

		rm.writeClasses();
		rm.write('>');

		// thumbnail
		rm.write('<img id=' + sMyId + '-thumb');
		var sThumbnail = oChunk.getThumbnailSrc();
		if (!sThumbnail) {
			sThumbnail = jQuery.sap.getModulePath("sap.ui.ux3.themes." + sap.ui.getCore().getConfiguration().getTheme(), sap.ui.core.theming.Parameters.get('sapUiFeedPersonPlaceholder'));
		}
		rm.writeAttributeEscaped('src', sThumbnail);
		rm.writeAttributeEscaped('alt', oChunk.getSender());
		rm.writeClasses();
		rm.write('>');

		// text (starting with sender)
		rm.write('<DIV class= "sapUiFeedChunkText" >');
		rm.write('<a id=' + sMyId + '-sender ');
		/* eslint-disable no-script-url */
		rm.writeAttribute('href', 'javascript:void(0);');
		/* eslint-enable no-script-url */
		rm.write('>');
		rm.writeEscaped(oChunk.getSender());
		rm.write('</a> ');

		// HCM action MenuButton
		if (oChunk.oHCMMenuButton) {
			rm.renderControl(oChunk.oHCMMenuButton);
		}

		this.renderText(rm, oChunk);
		rm.write('</DIV>');

		// status icons
		if (!oChunk.bComment) {
			rm.write('<UL class= "sapUiFeedChunkStatusIcons" >');
			if (oChunk.getFlagged()) {
				rm.write('<LI class= "sapUiFeedChunkFlagged" title="' + oChunk.rb.getText('FEED_FLAGGED') + '" >&#9873</LI>');
			}
			if (oChunk.getFavorite()) {
				rm.write('<LI class= "sapUiFeedChunkFavorite" title="' + oChunk.rb.getText('FEED_FAVORITE') + '" >&#9733</LI>');
			}
			if (oChunk.getShared()) {
				rm.write('<LI class= "sapUiFeedChunkShared" title="' + oChunk.rb.getText('FEED_SHARED') + '" >&#8635</LI>');
			}
			rm.write('</UL>');
		}

		// date
		rm.write('<SPAN class= "sapUiFeedChunkByline" >');
		rm.writeEscaped(oChunk.getTimestamp());
		rm.write('</SPAN>');

		if (!oChunk.bComment) {
			// action buttons (only if exists)
			if (oChunk.oToolsButton) {
				rm.renderControl(oChunk.oToolsButton);
			}
			if (oChunk.getEnableShare()) {
				rm.write('<BUTTON type = "button" id=' + sMyId + '-ActShare class= "sapUiFeedChunkAct sapUiFeedChunkActShare" title="' + oChunk.rb.getText('FEED_ACT_SHARE') + '" >&#8635</BUTTON>');
			}
			if (oChunk.getEnableInspect()) {
				rm.write('<BUTTON type = "button" id=' + sMyId + '-ActInspect class= "sapUiFeedChunkAct sapUiFeedChunkActInspect" title="' + oChunk.rb.getText('FEED_ACT_INSPECT') + '" >i</BUTTON>');
			}
			if (oChunk.getEnableFavorite()) {
				rm.write('<BUTTON type = "button" id=' + sMyId + '-ActFavorite class= "sapUiFeedChunkAct sapUiFeedChunkActFavorite" title="' + oChunk.rb.getText('FEED_ACT_FAVORITE') + '" >&#9733</BUTTON>');
			}
			if (oChunk.getEnableFlag()) {
				rm.write('<BUTTON type = "button" id=' + sMyId + '-ActFlag class= "sapUiFeedChunkAct sapUiFeedChunkActFlag" title="' + oChunk.rb.getText('FEED_ACT_FLAG') + '" >&#9873</BUTTON>');
			}
			if (oChunk.getEnableComment()) {
				rm.write('<BUTTON type = "button" id=' + sMyId + '-ActComment class= "sapUiFeedChunkAct sapUiFeedChunkActComment" title="' + oChunk.rb.getText('FEED_ACT_COMMENT') + '" >C</BUTTON>');
			}
		}

		// delete button
		if (oChunk.getDeletionAllowed() && oChunk.bComment) {
			rm.write('<BUTTON type = "button" id=' + sMyId + '-delete class= "sapUiFeedChunkDel" title="' + oChunk.rb.getText('FEED_DELETE') + '" >X</BUTTON>');
		}

		// comments
		if (oChunk.getComments().length > 0 || oChunk.showCommentFeeder) {
			rm.write("<SECTION>");
			this.renderComments(rm, oChunk);
			rm.write("</SECTION>");
		}

		rm.write('</ARTICLE>');
	};

	/*
	 *	Render text with @References
	 */
	FeedChunkRenderer.renderText = function(rm, oChunk){

		var sText = oChunk.getText();
		var i = 0;
		var iPos = 0;

		do {
			iPos = sText.search(/\s/);
			var sSpace = "",
				sWord = "";

			if (iPos < 0) {
				// only 1 word
				sWord = sText;
			} else {
				sWord = sText.slice(0, iPos);
				sSpace = sText.slice(iPos, iPos + 1);
				sText = sText.slice(iPos + 1);
			}

			// check for special strings
			if (/^@/.test(sWord)) {
				// @-reference
				rm.write('<a id=' + oChunk.getId() + '-Ref' + i);
				/* eslint-disable no-script-url */
				rm.writeAttribute('href', 'javascript:void(0);');
				/* eslint-enable no-script-url */
				rm.write('>');
				rm.writeEscaped(sWord, true);
				rm.write('</a>', sSpace);
				i++;
			} else if (/^(https?|ftp):\/\//i.test(sWord) && jQuery.sap.validateUrl(sWord)) {
				// web link - valid URL
				rm.write('<a');
				rm.writeAttribute('href', jQuery.sap.encodeHTML(sWord));
				rm.write('>');
				rm.writeEscaped(sWord, true);
				rm.write('</a>',sSpace);
			} else if (/^(www\.)/i.test(sWord) && jQuery.sap.validateUrl("http://" + sWord)) {
				// web link without protocol -> use HTTP - valid URL
				rm.write('<a');
				rm.writeAttribute('href', jQuery.sap.encodeHTML("http://" + sWord));
				rm.write('>');
				rm.writeEscaped(sWord, true);
				rm.write('</a>',sSpace);
			} else if (/^[\w\.=-]+@[\w\.-]+\.[\w]{2,5}$/.test(sWord)) {
				//email - not 100% validity check and validation missing
				rm.write('<a');
				rm.writeAttribute('href', "mailto:" + jQuery.sap.encodeHTML(sWord));
				rm.write('>');
				rm.writeEscaped(sWord, true);
				rm.write('</a>',sSpace);
			} else {
				// normal word
				rm.writeEscaped(sWord + sSpace, true);
			}
		}while (iPos >= 0);

	};

	/*
	 *	Render comment section content
	 */
	FeedChunkRenderer.renderComments = function(rm, oChunk){

		var oComments = oChunk.getComments();
		var iLength = oComments.length;

		// number of comments
		rm.write('<HEADER class= "sapUiFeedChunkComments" >');
		if (oChunk.rb) {
			rm.write(oChunk.rb.getText('FEED_NO_COMMENTS', [iLength]));

			if (iLength > oChunk.maxComments) {
				rm.write('<a id=' + oChunk.getId() + '-all ');
				/* eslint-disable no-script-url */
				rm.writeAttribute('href', 'javascript:void(0);');
				/* eslint-enable no-script-url */
				rm.write('>');
				if (!oChunk.allComments) {
					rm.write(oChunk.rb.getText('FEED_ALL_COMMENTS'));
				} else {
					rm.write(oChunk.rb.getText('FEED_MAX_COMMENTS'));
				}
				rm.write('</a>');
			}
		}
		rm.write("</HEADER>");

		// comments are sorted from old to new. Newest comment is on the bottom
		var iNumberChunks = iLength;
		if (!oChunk.allComments && oChunk.maxComments < iNumberChunks) {
			iNumberChunks = oChunk.maxComments;
		}

		for ( var i = 0; i < iNumberChunks; i++) {
			rm.renderControl(oComments[iLength - iNumberChunks + i]);
		}

		// comment feeder
		if (oChunk.oCommentFeeder) {
			rm.renderControl(oChunk.oCommentFeeder);
		}

	};

	/*
	 *	Render expand button
	 */
	FeedChunkRenderer.renderExpander = function(oChunk){

		if (oChunk.expanded) {
			return "<button id= '" + oChunk.getId() + "-exp' class='sapUiFeedChunkCollapse' title='" + oChunk.rb.getText("FEED_COLLAPS") + "'>&#9660</button>";
		} else {
			return "<button id= '" + oChunk.getId() + "-exp' class='sapUiFeedChunkExpand' title='" + oChunk.rb.getText("FEED_EXPAND") + "'>&#9660</button>";
		}

	};

	return FeedChunkRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/FeedChunkRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.FeedRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.ux3.FeedRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/FeedRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Feed renderer.
	 * @namespace
	 */
	var FeedRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FeedRenderer.render = function(oRenderManager, oControl){
	    // convenience variable
		var rm = oRenderManager;
		var oFeed = oControl;
	
		// write the HTML into the render manager
	    rm.write('<DIV');
	    rm.writeControlData(oFeed);
		rm.addClass('sapUiFeed');
		rm.writeClasses();
	    rm.write('>');
	
	    //feeder
		rm.renderControl(oFeed.oFeeder);
	
	    rm.write('<HEADER class=sapUiFeedTitle ><H4>');
	    //titlebar
	    var sTitle = oFeed.getTitle();
	    if (!sTitle || sTitle == "") {
			// use default title
			sTitle = oFeed.rb.getText('FEED_TITLE');
		}
		rm.writeEscaped(sTitle);
		//menu button (only if exist)
		if (oFeed.oToolsButton) {
			rm.renderControl(oFeed.oToolsButton);
		}
	    //live-button (alsways must exist)
		rm.renderControl(oFeed.oLiveButton);
	    rm.write('</H4>');
	
	    //toolbar
	    rm.write('<DIV class="sapUiFeedToolbar" >');
		rm.renderControl(oFeed.oFilter);
		rm.renderControl(oFeed.oSearchField);
	
	    rm.write('</DIV>');
	    rm.write('</HEADER>');
	
	    //Chunks
	    rm.write('<SECTION>');
	    for ( var i = 0; i < oFeed.getChunks().length; i++) {
			var oChunk = oFeed.getChunks()[i];
			rm.renderControl(oChunk);
		}
	
	    rm.write('</SECTION>');
	
	    rm.write('</DIV>');
	
	};
	

	return FeedRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/FeedRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.FeederRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.Feeder
jQuery.sap.declare('sap.ui.ux3.FeederRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/FeederRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Feeder renderer.
	 * @namespace
	 */
	var FeederRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FeederRenderer.render = function(oRenderManager, oControl){
	    // convenience variable
		var rm = oRenderManager;
		var oFeeder = oControl;
	
		// write the HTML into the render manager
	    rm.write('<DIV');
	    rm.writeControlData(oFeeder);
		rm.addClass('sapUiFeeder');
	
		switch (oFeeder.getType()) {
		case sap.ui.ux3.FeederType.Medium:
			rm.addClass('sapUiFeederMedium');
		break;
		case sap.ui.ux3.FeederType.Comment:
			rm.addClass('sapUiFeederComment');
		break;
		default: // large feeder is default
			rm.addClass('sapUiFeederLarge');
		break;
		}
	
		rm.writeClasses();
	    rm.write('>');
	
	    // thumbnail
		rm.write('<img id=' + oFeeder.getId() + '-thumb');
		var sThumbnail = oFeeder.getThumbnailSrc();
		if (!sThumbnail) {
			sThumbnail = jQuery.sap.getModulePath("sap.ui.ux3.themes." + sap.ui.getCore().getConfiguration().getTheme(), sap.ui.core.theming.Parameters.get("sapUiFeedPersonPlaceholder"));
		}
		rm.writeAttributeEscaped('src', sThumbnail);
	
	//	rm.writeAttributeEscaped('alt', oChunk.getSender());
		rm.writeClasses();
		rm.write('>');
	
		// input area as editable DIV because of dynamic content
	    rm.write('<DIV id=' + oFeeder.getId() + '-input contenteditable="true" class="sapUiFeederInput" >');
	
	    // text
	    if (oFeeder.getText() == '') {
			rm.write(this.getEmptyTextInfo( oFeeder ));
	    } else {
			rm.writeEscaped(oFeeder.getText(), true);
	    }
	
	    rm.write('</DIV>');
	
	    //send button
	    oFeeder.initSendButton();
	    rm.renderControl(oFeeder.oSendButton);
	
	    rm.write('</DIV>');
	};
	
	FeederRenderer.getEmptyTextInfo = function( oFeeder ){
		return "<span class='sapUiFeederEmptyText'>" + jQuery.sap.encodeHTML(oFeeder.getPlaceholderText() || oFeeder.rb.getText("FEED_EMPTY_FEEDER")) + "</span>";
	};
	

	return FeederRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/FeederRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.NavigationBarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.NavigationBar
jQuery.sap.declare('sap.ui.ux3.NavigationBarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/NavigationBarRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * NavigationBar renderer.
	 * @namespace
	 */
	var NavigationBarRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	NavigationBarRenderer.render = function(oRenderManager, oControl) {
		// convenience variable
		var rm = oRenderManager;
		var sId = oControl.getId();

		// write the HTML into the render manager
		rm.addClass("sapUiUx3NavBar");
		if (oControl.getToplevelVariant()) {
			rm.addClass("sapUiUx3NavBarToplevel");
		}

		rm.write("<nav");
		rm.writeControlData(oControl);
		rm.writeClasses();
		rm.write("role='navigation'>");
		rm.write("<ul id='" + sId + "-list' role='menubar' class='sapUiUx3NavBarList'");
		rm.addStyle("white-space", "nowrap");
		rm.writeStyles();
		rm.write(">");
		NavigationBarRenderer.renderItems(rm, oControl);
		rm.write("</ul>");
		rm.write("<a id='" + sId + "-ofb' tabindex='-1' role='presentation' class='sapUiUx3NavBarBack' href='javascript:void(0)'>&lt;&lt;</a>");
		rm.write("<a id='" + sId + "-off' tabindex='-1' role='presentation' class='sapUiUx3NavBarForward' href='javascript:void(0)'>&gt;&gt;</a>");
		rm.write("<a id='" + sId + "-ofl' tabindex='-1' role='presentation' class='sapUiUx3NavBarOverflowBtn' href='javascript:void(0)'>");
		rm.writeIcon("sap-icon://overflow", [], { id : sId + "-oflt" });
		rm.write("</a>");
		rm.write("</nav>");
	};



	NavigationBarRenderer.renderItems = function(oRm, oControl) {
		var aItems = oControl.getItems();
		var bNeedToGetInstances = false;
		if (!aItems || aItems.length == 0) { // use the association instead, if the aggregation is empty
			aItems = oControl.getAssociatedItems();
			bNeedToGetInstances = true; // avoid type checks in the loop
		}

		var iNoOfItems = aItems.length;

		// dummy item to avoid jumping while animating
		oRm.write("<li");
		oRm.addStyle("display", "inline-block");
		oRm.writeStyles();
		oRm.write(">");
		oRm.write("<a id='" + oControl.getId() + "-dummyItem' class='sapUiUx3NavBarDummyItem sapUiUx3NavBarItem'>&nbsp;</a></li>");
		var selId = oControl.getSelectedItem();

		for (var i = 0; i < iNoOfItems; i++) {
			var item = bNeedToGetInstances ? sap.ui.getCore().byId(aItems[i]) : aItems[i];
			if (item.getVisible()) {
				var itemId = item.getId();
				var bIsSelected = itemId == selId;
				oRm.write("<li");
				oRm.addStyle("display", "inline-block");
				oRm.writeStyles();
				if (bIsSelected) {
					oRm.write(" class='sapUiUx3NavBarItemSel'");
				}

				oRm.write("><a ");

				// Psssst. This is not right. Don't tell anyone, because it works like this.
				// The element data should be written into the li-element so that it is removed
				// automatically on destroy. Since when removing items an invalidate is called the list
				// is built up from scratch anyway, so it does not cause any problems. If this leads
				// to any problems, the onclick/userActivation code must be changed to reflect this
				// change.
				// TL;DR: Not correct, won't fix - because it works and things might depend on the DOM
				//        being this way.
				oRm.writeElementData(item);
				/* eslint-disable no-script-url */
				oRm.writeAttributeEscaped("href", item.getHref() || "javascript:void(0);");
				/* eslint-enable no-script-url */
				oRm.write(" aria-setsize='" + iNoOfItems + "' aria-posinset='" + (i + 1) + "' role='menuitemradio' class='sapUiUx3NavBarItem'");
				if (bIsSelected) {
					oRm.write(" tabindex='0'");
				}
				oRm.write(" aria-checked='" + (bIsSelected ? "true" : "false") + "'");

				var tooltip = item.getTooltip_AsString();
				if (tooltip) {
					oRm.write(" title='" + jQuery.sap.encodeHTML(tooltip) + "'");
				}

				oRm.write(">");
				oRm.write(jQuery.sap.encodeHTML(item.getText()));
				oRm.write("</a></li>");
			}
		}

		var arrowPos;
		if (oControl._bRtl) {
			arrowPos = "right:" + oControl._iLastArrowPos;
		} else {
			arrowPos = "left:" + oControl._iLastArrowPos;
		}
		oRm.write("<span id='" + oControl.getId() + "-arrow' style='" + arrowPos + "px;");
		if ((aItems.length == 1) && !oControl.getToplevelVariant() && !!sap.ui.Device.browser.internet_explorer && (sap.ui.Device.browser.version == 8 || sap.ui.Device.browser.version == 7)) { // IE8 workaround; other browsers understand nth-child, see Base-CSS
			oRm.write("display:none;"); // hide arrow when there is only one item
		}
		oRm.write("' class='sapUiUx3NavBarArrow'></span>");
	};


	return NavigationBarRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/NavigationBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.NotificationBarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.ux3.NotificationBarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/NotificationBarRenderer",['jquery.sap.global', 'sap/ui/core/theming/Parameters'],
	function(jQuery, Parameters) {
	"use strict";


	/**
	 * NotificationBar renderer.
	 * @namespace
	 */
	var NotificationBarRenderer = {};
	
	/*
	 * Set all methods into a close to prevent any abuse of helping methods
	 */
	(function() {
		/**
		 * Renders the HTML for the given control, using the provided
		 * {@link sap.ui.core.RenderManager}.
		 * 
		 * @param {sap.ui.core.RenderManager}
		 *            oRm the RenderManager that can be used for writing to the
		 *            render output buffer
		 * @param {sap.ui.core.Control}
		 *            oControl an object representation of the control that should
		 *            be rendered
		 */
		NotificationBarRenderer.render = function(oRm, oControl) {
			fnWriteHeader(oRm, oControl);
			fnWriteItems(oRm, oControl);
			fnWriteFooter(oRm, oControl);
		};
	
		/**
		 * @private
		 */
		var fnWriteHeader = function(oRm, oControl) {
	
			oRm.write("<div");
			oRm.writeControlData(oControl);
	
			if (oControl.getVisibleStatus() === sap.ui.ux3.NotificationBarStatus.None) {
				if (oControl.$().length > 0) {
					// if NotiBar is already rendered
					if (oControl._resizeFrom) {
						oControl.$().stop().animate({
							height : 0
						}, "fast", function() {
							oControl.$().css("display", "none");
	
							oRm.addStyle("display", "none");
							oRm.writeAttribute("aria-hidden", "true");
						});
					} else {
						oRm.addStyle("display", "none");
						oRm.writeAttribute("aria-hidden", "true");
					}
				} else {
					/*
					 * setting the display attribute prevents the bar from
					 * flickering when the bar is initially loaded
					 */
					oRm.addStyle("display", "none");
					oRm.writeAttribute("aria-hidden", "true");
				}
			} else {
				oRm.writeAttribute("aria-hidden", "false");
				oRm.addStyle("display", "block");
			}
			oRm.writeStyles();
	
			oRm.addClass("sapUiNotificationBar");
			/*
			 * This ensures the maximize and minimize animation
			 */
			if (oControl._resizeTo) {
				if (oControl._resizeFrom == sap.ui.ux3.NotificationBarStatus.Max) {
					if (oControl._resizeTo == sap.ui.ux3.NotificationBarStatus.Default) {
						// Resizing from maximize back to default (class will be
						// removed in 'afterRendering')
						oRm.addClass("sapUiNotificationBarMaximized");
					}
				}
			}
	
			oRm.writeClasses();
	
			oRm.write(">"); // div element
	
			/*
			 * Rendering the hover element that helps to indicate if the bar is
			 * hovered. It is important that this element is within the root element
			 * of the NotificationBar since outside is strictly forbidden!
			 */
			fnRenderHoverItem(oRm, oControl);
		};
	
		var fnRenderToggler = function(oRm, oControl) {
			var sStatus = oControl.getVisibleStatus();
			if (sStatus !== "None") {
				var sId = oControl.getId() + "-toggler";
	
				oRm.write("<div");
				oRm.writeAttribute("id", sId);
	
				oRm.addClass("sapUiBarToggle");
				if (sStatus !== "Min") {
					oRm.addClass("sapUiBarToggleWide");
				}
	
				oRm.writeClasses();
	
				// check the status of the property. For mobile it should be set to true on init
				if (oControl.getAlwaysShowToggler()) {
					oRm.addStyle("display", "block");
					oRm.writeStyles();
				}
	
				oRm.write(">");
	
				fRenderToggleItem(oRm, oControl, "ArrowUp");
				fRenderToggleItem(oRm, oControl, "ArrowDown");
				fRenderToggleItem(oRm, oControl, "BarUp");
				fRenderToggleItem(oRm, oControl, "BarDown");
	
				oRm.write("</div>"); // div Toggler
			} else {
				// if the NotificationBar is in VisibleStatus:None also hide the toggler
				oRm.addStyle("display", "none");
				oRm.writeStyles();
			}
		};
	
		var fRenderToggleItem = function(oRm, oControl, sItemType) {
			oRm.write("<div");
	
			var sId = oControl.getId() + "-" + sItemType;
			oRm.writeAttribute("id", sId);
	
			var sStatus = oControl.getVisibleStatus();
			var bHide = true;
	
			var sTitle = "";
	
			switch (sItemType) {
			case "ArrowUp":
				if (sStatus === "Default") {
					bHide = false;
				}
				sTitle = oControl._oResBundle.getText("NOTIBAR_TITLE_ENLARGE");
				break;
	
			case "ArrowDown":
				if (sStatus === "Max") {
					bHide = false;
				}
				sTitle = oControl._oResBundle.getText("NOTIBAR_TITLE_MINIMIZE");
				break;
	
			case "BarUp":
				if (sStatus === "Min") {
					bHide = false;
				}
				sTitle = oControl._oResBundle.getText("NOTIBAR_TITLE_BAR_UP");
				break;
	
			case "BarDown":
				if (sStatus === "Max" || sStatus === "Default") {
					bHide = false;
				}
				sTitle = oControl._oResBundle.getText("NOTIBAR_TITLE_BAR_DOWN");
				break;
	
			}
			oRm.writeAttributeEscaped("title", sTitle);
	
			if (bHide) {
				oRm.addClass("sapUiBarToggleHide");
			}
	
			oRm.addClass("sapUiBarToggle" + sItemType);
			oRm.addClass("sapUiBarToggleItem");
	
			oRm.writeClasses();
			oRm.write(">");
	
			oRm.write("</div>");
		};
	
		var fnRenderHoverItem = function(oRm, oControl) {
			oRm.write("<div");
			var sId = oControl.getId() + "-hoverItem";
			oRm.writeAttribute("id", "" + sId);
	
			var sStatus = oControl.getVisibleStatus();
			if (sStatus === "Min") {
				oRm.addStyle("top", "-" + sap.ui.ux3.NotificationBar.HOVER_ITEM_HEIGHT + "px");
				oRm.addStyle("display", "block");
			} else {
				oRm.addStyle("display", "none");
			}
			if (oControl.getDomRef()) {
				var $domRef = jQuery(oControl.getDomRef());
				var sWidth = $domRef.width() + "px";
				oRm.addStyle("width", sWidth);
			}
			oRm.writeStyles();
	
			oRm.addClass("sapUiNotiHover");
			oRm.writeClasses();
			oRm.write(">");
	
			oRm.write("</div>"); // div hover item
		};
	
		/**
		 * Renders all notifiers
		 */
		var fnWriteItems = function(oRm, oControl) {
			if (oControl.getResizeEnabled()) {
				fnRenderToggler(oRm, oControl);
			}
	
			if (oControl.hasItems()) {
				if (oControl.getVisibleStatus() == sap.ui.ux3.NotificationBarStatus.Max) {
					fnWriteItemsMaximized(oRm, oControl);
				} else {
					fnWriteItemsDefault(oRm, oControl);
				}
			}
		};
	
		var fnWriteItemsMaximized = function(oRm, oControl) {
			var aNotifiers = oControl.getNotifiers();
			var oMessageNotifier = oControl.getMessageNotifier();
			var sId = "";
	
			oRm.write("<div");
			oRm.writeAttribute("id", oControl.getId() + "-containers");
	
			oRm.addClass("sapUiNotifierContainers");
			oRm.writeClasses();
			oRm.write(">");
	
			// suppress any invalidate since we are already rendering ;-)
			if (oMessageNotifier && oMessageNotifier.hasItems()) {
				oMessageNotifier.destroyAggregation("views", true);
	
				sId = oMessageNotifier.getId() + "-messageNotifierView";
	
				var oMNView = fnCreateNotifierViewMaximized(sId, oMessageNotifier);
				oMessageNotifier.addAggregation("views", oMNView, true);
	
				oRm.renderControl(oMNView);
			}
	
			if (aNotifiers.length > 0) {
				for ( var i = 0; i < aNotifiers.length; i++) {
					if (aNotifiers[i].hasItems()) {
						aNotifiers[i].destroyAggregation("views", true);
	
						sId = aNotifiers[i].getId() + "-notifierView";
	
						var oView = fnCreateNotifierViewMaximized(sId, aNotifiers[i]);
						aNotifiers[i].addAggregation("views", oView, true);
	
						oRm.renderControl(oView);
					}
				}
			}
	
			oRm.write("</div");
		};
	
		var fnWriteItemsDefault = function(oRm, oControl) {
			var aNotifiers = oControl.getNotifiers();
			var oMN = oControl.getMessageNotifier();
	
			oRm.write("<ul");
			oRm.writeAttribute("id", oControl.getId() + "-notifiers");
			oRm.addClass("sapUiNotifiers");
			oRm.writeClasses();
			oRm.write(">");
	
			/*
			 * Check if there is something wrong in the neighborhood... so call the
			 * Ghostbusters. If there is something to monitor/messages show it.
			 */
			var bMonitoring = false;
			for ( var i = 0; i < aNotifiers.length; i++) {
				if (aNotifiers[i].hasItems()) {
					bMonitoring = true;
					break;
				}
			}
	
			var bMessage = (oMN && oMN.hasItems()) ? true : false;
	
			if (bMonitoring) {
				fnRenderNotifiers(oRm, aNotifiers);
			}
	
			if (bMonitoring && bMessage) {
				/*
				 * Add separator between monitor controls and notification controls.
				 * The separator is only needed if monitoring controls and messages
				 * are available.
				 */
				oRm.write("<li");
				oRm.addClass("sapUiNotifierSeparator");
				oRm.writeClasses();
				oRm.write(">");
				oRm.write("&nbsp;");
				oRm.write("</li>");
			}
	
			if (bMessage) {
				fnRenderMessageNotifier(oRm, oMN, oControl);
			}
	
			oRm.write("</ul>");
		};
	
		var fnWriteFooter = function(oRm, oControl) {
			oRm.write("</div>");
		};
	
		/**
		 * Renders a single notifier
		 */
		var fnRenderNotifier = function(oRm, oNotifier, bMessageNotifier) {
			var sId = oNotifier.getId();
	
			oRm.write("<li");
			oRm.writeElementData(oNotifier);
			oRm.addClass("sapUiNotifier");
			oRm.writeClasses();
	
			// ItemNavigation can only handle focusable items
			oRm.writeAttribute("tabindex", "-1");
			oRm.writeAttribute("aria-describedby", sId + '-description>');
			oRm.write(">"); // li element
	
			fnWriteNotifierIcon(oRm, oNotifier.getIcon(), bMessageNotifier);
	
			// adding an element to enable a
			oRm.write('<div id="' + sId + '-description"');
			oRm.addStyle("display", "none");
			oRm.writeStyles();
			oRm.write(">");
	
			oRm.write("</div>");
	
			var iCount = oNotifier.getMessages().length;
			if (iCount > 0) {
				// opening the div with corresponding classes
				oRm.write('<div id="' + sId + '-counter" role="tooltip"');
				oRm.addClass("sapUiNotifierMessageCount");
				if (bMessageNotifier) {
					oRm.addClass("sapUiMessage");
				}
				oRm.writeClasses();
				oRm.write(">");
	
				// write the div's content
				if (iCount > 99) {
					iCount = ">99";
				}
				oRm.write(iCount);
	
				// closing the div
				oRm.write("</div>");
			}
	
			oRm.write("</li>"); // li element
		};
	
		var fnCreateNotifierViewMaximized = function(sId, oNotifier) {
			var oNotifierView = new sap.ui.ux3.NotificationBar.NotifierView(sId, {
				title : oNotifier.getTitle(),
				renderMode : "maximized"
			});
	
			if (oNotifier._bEnableMessageSelect) {
				oNotifierView.addStyleClass("sapUiNotifierSelectable");
			}
	
			var aMessages = oNotifier.getMessages();
			for ( var i = 0; i < aMessages.length; i++) {
				var oMessage = aMessages[i];
				var oMessageView = new sap.ui.ux3.NotificationBar.MessageView(sId + "-messageView-" + oMessage.getId(), {
					text : oMessage.getText(),
					timestamp : oMessage.getTimestamp()
				});
				oMessageView._message = oMessage;
				oMessageView.setIcon(oMessage.getIcon() || oMessage.getDefaultIcon("32x32"));
	
				oNotifierView.addMessage(oMessageView);
			}
	
			return oNotifierView;
		};
	
		/**
		 * Renders given map of notifiers
		 */
		var fnRenderNotifiers = function(oRm, aNotifiers) {
			for ( var i = 0; i < aNotifiers.length; i++) {
				fnRenderNotifier(oRm, aNotifiers[i], false);
			}
		};
	
		/**
		 * Renders the notifier's icon. If there is no icon set a default icon is
		 * used
		 */
		var fnWriteNotifierIcon = function(oRm, sUri, bMessageNotifier) {
			oRm.write("<img alt=\"\"");
			oRm.addClass("sapUiNotifierIcon");
			oRm.writeClasses();
	
			var iconUrl = "";
	
			if (sUri == null || sUri == "") {
				var sThemeModuleName = "sap.ui.ux3.themes." + sap.ui.getCore().getConfiguration().getTheme();
				if (bMessageNotifier) {
					iconUrl = jQuery.sap.getModulePath(sThemeModuleName, "/img/notification_bar/alert_white_24.png");
				} else {
					iconUrl = jQuery.sap.getModulePath(sThemeModuleName, "/img/notification_bar/notification_24.png");
				}
			} else {
				iconUrl = sUri;
			}
	
			oRm.writeAttributeEscaped("src", iconUrl);
			oRm.write(">");
	
			oRm.write("</img>");
		};
	
		/**
		 * This renders a given message notifier and its message area next to the
		 * notifier icon
		 */
		var fnRenderMessageNotifier = function(oRm, oNotifier, oNotiBar) {
			fnRenderNotifier(oRm, oNotifier, true);
			fnRenderMessageNotifierMessageArea(oRm, oNotifier, oNotiBar);
		};
	
		/**
		 * Renders the message area next to a message notifier
		 */
		var fnRenderMessageNotifierMessageArea = function(oRm, oMessageNotifier, oNotiBar) {
			if (oMessageNotifier.hasItems()) {
				var aMessages = oMessageNotifier.getMessages();
				var lastItem = aMessages[aMessages.length - 1];
	
				var oMA = oMessageNotifier._oMessageArea;
				// this ensures that this message is selectable from the bar
				oMA._message = lastItem;
				var sId = oNotiBar.getId() + "-inplaceMessage-" + oMA._message.getId();
	
				oRm.write("<li");
				oRm.writeAttribute("id", sId);
				oRm.addClass("sapUiInPlaceMessage");
				oRm.writeClasses();
	
				if (oNotiBar._gapMessageArea) {
					var sMargin = oNotiBar._gapMessageArea + "px";
					oRm.addStyle("margin-left", sMargin);
					oRm.writeStyles();
				}
				oRm.write(">");
	
				// oRm.renderControl(oMA);
				if (lastItem.getText() != "") {
					oRm.write("<div");
					oRm.writeControlData(oMA);
					// enable inplace message for item navigation
					oRm.writeAttribute("tabindex", "-1");
					oRm.addClass("sapUiNotifierMessageText");
					oRm.addClass("sapUiInPlaceMessage");
					// if the latest message is read-only don't provide a visual selectable link
					if (oMessageNotifier._bEnableMessageSelect && !oMA._message.getReadOnly()) {
						// if there is an event handler show the inplace message
						// clickable
						oRm.addClass("sapUiInPlaceMessageSelectable");
					}
					oRm.writeClasses();
					oRm.write(">");
					oRm.writeEscaped(lastItem.getText());
					oRm.write("</div>"); // Text
				}
	
				if (lastItem.getTimestamp() != "") {
					oRm.write("<div");
					oRm.addClass("sapUiNotifierMessageTimestamp");
					oRm.addClass("sapUiInPlaceMessage");
					oRm.writeClasses();
					oRm.write(">");
					oRm.writeEscaped(lastItem.getTimestamp());
					oRm.write("</div>"); // Timestamp
				}
	
				oRm.write("</li>");
			}
		};
	}());
	

	return NotificationBarRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/NotificationBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.OverlayRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.Overlay
jQuery.sap.declare('sap.ui.ux3.OverlayRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/OverlayRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Overlay renderer.
	 * @namespace
	 */
	var OverlayRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	OverlayRenderer.render = function(oRenderManager, oControl){
		// convenience variable
		var rm = oRenderManager;

		// write the HTML into the render manager
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3Overlay");

		if (this.addRootClasses) {
			this.addRootClasses(rm, oControl);
		}

		rm.writeClasses();
		rm.write(">");

		rm.write("<div role='presentation'");
		rm.addClass("sapUiUx3OverlayOverlay");

		if (this.addOverlayClasses) {
			this.addOverlayClasses(rm, oControl);
		}

		rm.writeClasses();
		rm.write(">");
		rm.write("</div>");
		rm.write("<span class='sapUiUx3OverlayFocusDummyPane' id='" + oControl.getId() + "-firstFocusDummyPaneFw'></span>");
		rm.write("<span class='sapUiUx3OverlayFocusDummyPane' id='" + oControl.getId() + "-firstFocusDummyPaneBw'></span>");
		//render open & close button
		if (oControl.getOpenButtonVisible()) {
		rm.write("<a role=\"button\" aria-disabled=\"false\" class='sapUiUx3OverlayOpenButton' id='" + oControl.getId()
				+ "-openNew' tabindex=\"0\" title=\"" + oControl._getText("OVERLAY_OPEN_BUTTON_TOOLTIP") + "\">" + oControl._getText("OVERLAY_OPEN_BUTTON_TEXT") + "</a>");
				}
		if (oControl.getCloseButtonVisible()) {
		rm.write("<a role=\"button\" aria-disabled=\"false\" class='sapUiUx3OverlayCloseButton' id='" + oControl.getId()
				+ "-close' tabindex=\"0\" aria-label='" + oControl._getText("OVERLAY_CLOSE_BUTTON_TOOLTIP") + "'></a>");
		}
		if (this.renderContent) {
			this.renderContent(rm, oControl);
		}
		rm.write("<span class='sapUiUx3OverlayFocusDummyPane' id='" + oControl.getId() + "-LastFocusDummyPane'></span>");
		rm.write("</div>");

	};


	return OverlayRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/OverlayRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.QuickViewRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.ux3.QuickViewRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.CalloutBaseRenderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/QuickViewRenderer",['jquery.sap.global', 'sap/ui/commons/CalloutBaseRenderer', 'sap/ui/core/Renderer', 'sap/ui/core/IconPool'],
	function(jQuery, CalloutBaseRenderer, Renderer, IconPool) {
	"use strict";


	/**
	 * QuickView renderer. 
	 * @namespace
	 */
	var QuickViewRenderer = Renderer.extend(CalloutBaseRenderer);
	
	
	/**
	 * Renders the HTML for the CalloutBase content, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	QuickViewRenderer.renderContent = function(oRenderManager, oControl){
	
		var rm = oRenderManager;
	
		// accessibility
		var bAcc = sap.ui.getCore().getConfiguration().getAccessibility();
	
		// control properties
		var sType	= oControl.getType(),
			sName	= oControl.getFirstTitle(),
			sHref	= oControl.getFirstTitleHref(),
			sIcon	= oControl.getIcon(),
			sDesc	= oControl.getSecondTitle(),
			sWidth	= oControl.getWidth(),
			sId = oControl.getId(),
			tooltip = oControl.getTooltip_AsString(),
			oIconAttr;
	
		// container for the QuickView header and content
		rm.write("<div");
		if (tooltip) {
			rm.writeAttributeEscaped("title", tooltip);
		}
		if (bAcc) {
			rm.writeAttribute("role", "dialog");
			rm.writeAttribute("aria-labelledby",sId + "-title");
		}
		rm.addClass("sapUiUx3QV");
		rm.writeClasses();
		if (sWidth) {
			rm.addStyle("width", sWidth);
			rm.writeStyles();
		}
		rm.write(">");
	
		//header (Thing Type) is mandatory
		rm.write("<div");
		rm.writeAttribute("id", sId + "-title");
		rm.writeAttribute("tabindex", "-1"); // ItemNavigation can only handle focusable items
		rm.addClass("sapUiUx3QVHeader");
		rm.writeClasses();
		rm.write(">");
		rm.writeEscaped(sType);
		rm.write("</div>");
	
		//heading: icon, title1, title2
		if (sIcon || sName || sDesc) {
			rm.write("<div");
			if (bAcc) {
				rm.writeAttribute("role", "heading");
			}
			rm.addClass("sapUiUx3QVHeading");
			rm.writeClasses();
			rm.write(">");
	
			//icon
			if (sIcon) {
				if (IconPool.isIconURI(sIcon)) {
					//setting title & tabindex here
					//alt, src and role=presentation are set by writeIcon
					oIconAttr = {
						title	: sName,
						tabindex: "-1"
					};
				}
				rm.writeIcon(sIcon, "sapUiUx3QVIcon", oIconAttr);
			}
	
			//name 
			rm.write("<span");
			rm.writeAttribute("id", sId + "-name");
			if (bAcc && sDesc) {
				rm.writeAttribute("aria-describedby",sId + "-descr");
			}
			rm.addClass("sapUiUx3QVTitle1");
			rm.writeClasses();
			rm.write(">");
			if (sHref) {
				rm.write("<a");
				rm.writeAttribute("id", sId + "-link");
				rm.writeAttributeEscaped("href", sHref);
				rm.writeAttribute("tabindex", "-1"); // ItemNavigation can only handle focusable items
				rm.write(">");
			}
			rm.writeEscaped(sName || "");
			if (sHref) {
				rm.write("</a>");
			}
			rm.write("</span>");
	
			//title2
			if (sDesc) {
				rm.write("<br><span");
				rm.writeAttribute("id", sId + "-descr");
				rm.writeAttribute("tabindex", "-1"); // ItemNavigation can only handle focusable items
				rm.addClass("sapUiUx3QVTitle2");
				rm.writeClasses();
				rm.write(">");
				rm.writeEscaped(sDesc);
				rm.write("</span>");
			}
			rm.write("</div>"); // heading
		}
	
		// content
		// render Header Content
		rm.write("<div id=\"" + sId + "-content\">");
		this.renderBody(rm, oControl);
		rm.write("</div>");
	
		rm.write("</div>"); // container
	
		// render the action bar 
		if (oControl.getShowActionBar() && oControl.getActionBar()) {
			rm.renderControl(oControl.getActionBar());
		}
	
	};
	
	/**
	 * Renders the HTML for the QuickView body content (form or )
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	QuickViewRenderer.renderBody = function(rm, oControl) {
		var aContent = oControl.getContent();
		for ( var i = 0; i < aContent.length; i++) {
			rm.write("<div class=\"sapUiUx3QVBody\">");
			if (aContent[i] instanceof sap.ui.core.Control) {
				rm.renderControl(aContent[i]);
			} else if (aContent[i].getContent && typeof aContent[i].getContent == "function") {
				// ThingGroups with own content are also allowed
				var aChildContent = aContent[i].getContent();
				for (var j = 0; j < aChildContent.length; j++) {
					if (aChildContent[j] instanceof sap.ui.core.Control) {
						rm.renderControl(aChildContent[j]);
					}
				}
			}
			rm.write("</div>");
		}
	};
	
	

	return QuickViewRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/QuickViewRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ShellColorPicker') ) {
/**
 * EXPERIMENTAL!  DO NOT USE!
 */

/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the class sap.ui.ux3.ShellColorPicker
jQuery.sap.declare('sap.ui.ux3.ShellColorPicker'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.EventProvider'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Button'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ShellColorPicker",['jquery.sap.global', 'sap/ui/base/EventProvider', 'sap/ui/commons/Button', 'sap/ui/core/Popup'],
	function(jQuery, EventProvider, Button, Popup) {
	"use strict";


	
	
	var ShellColorPicker = EventProvider.extend("sap.ui.ux3.ShellColorPicker", {
		constructor: function(id) {
			EventProvider.apply(this);
			this.id = id;
		}
	});
	
	
	/*  EVENT HANDLING */
	
	ShellColorPicker.M_EVENTS = {liveChange: "liveChange"};
	
	ShellColorPicker.prototype.attachLiveChange = function(fFunction, oListener) {
		this.attachEvent(ShellColorPicker.M_EVENTS.liveChange, fFunction, oListener);
	};
	
	ShellColorPicker.prototype.detachLiveChange = function(fFunction, oListener) {
		this.detachEvent(ShellColorPicker.M_EVENTS.liveChange, fFunction, oListener);
	};
	
	ShellColorPicker.prototype.fireLiveChange = function(oColor) {
		var mParameters = {cssColor:ShellColorPicker.hslToCss(oColor)};
		this.fireEvent(ShellColorPicker.M_EVENTS.liveChange, mParameters);
	};
	
	
	
	/* API METHODS */
	
	/**
	 * @public
	 */
	ShellColorPicker.prototype.isOpen = function() {
		return (this.oPopup && this.oPopup.isOpen());
	};
	
	
	/**
	 * Opens the color picker, initially showing the given color.
	 *  
	 * All parameters after <code>oColor</code> have the same meaning and accept the same values as in {@link sap.ui.core.Popup#open Popup.open()}.
	 *  
	 * @param {object} oColor a hsl-based color object, as returned by parseCssRgbString()
	 * @param {int} [iDuration] animation duration in milliseconds; default is the jQuery preset "fast". For iDuration == 0 the opening happens synchronously without animation.
	 * @param {sap.ui.core.Popup.Dock} [my=sap.ui.core.Popup.Dock.CenterCenter] the popup content's reference position for docking
	 * @param {sap.ui.core.Popup.Dock} [at=sap.ui.core.Popup.Dock.CenterCenter] the "of" element's reference point for docking to
	 * @param {Element|sap.ui.core.Element} [of=document] the DOM Element or UI5 Element to dock to
	 * @param {string} [offset='0 0'] the offset relative to the docking point, specified as a string with space-separated pixel values (e.g. "0 10" to move the popup 10 pixels to the right). If the docking of both "my" and "at" are both RTL-sensitive ("begin" or "end"), this offset is automatically mirrored in the RTL case as well.
	 * @param {string} [collision='flip'] defines how the position of an element should be adjusted in case it overflows the window in some direction.
	 *
	 * @public
	 */
	ShellColorPicker.prototype.open = function(oColor, iDuration, my, at, of, offset, collision) {
		if (this.oPopup && this.oPopup.isOpen()) {
			return;
		}
	
		this.oSlider = new sap.ui.commons.Slider({width: "225px",liveChange:[this.handleSlider, this]});
		this.oOkBtn = new Button({text:"OK",press:[this.handleOk, this]});
		this.oCancelBtn = new Button({text:"Cancel",press:[this.handleCancel, this]});
	
		this.oInitialColor = oColor;
		this.oCurrentColor = jQuery.extend({}, this.oInitialColor);
	
		this.oSlider.setValue(this.oCurrentColor.l);
		var rm = sap.ui.getCore().createRenderManager();
		var dummyDiv = document.createElement("div");
		var statArea = sap.ui.getCore().getStaticAreaRef();
		statArea.appendChild(dummyDiv);
		this.renderHtml(rm);
		rm.flush(dummyDiv);
		rm.destroy;
		this.oPopup = new Popup(dummyDiv.firstChild, false, true, true).attachClosed(this.handleClose, this);
		this.oPopup.setAutoCloseAreas([dummyDiv.firstChild]);
		this.oPopup.open(iDuration, my, at, of, offset, collision);
		statArea.removeChild(dummyDiv);
		dummyDiv = null;
	
		jQuery.sap.byId(this.id).bind("mousedown", jQuery.proxy(this.handleGeneralMouseDown, this));
		jQuery.sap.byId(this.id + "-img").bind("mousedown", jQuery.proxy(this.handleMouseDown, this));
		jQuery.sap.byId(this.id + "-marker").bind("mousedown", jQuery.proxy(this.handleMouseDown, this));
		this._imgOffset = jQuery.sap.byId(this.id + "-img").offset();
	
		this.adaptSliderBar(this.oCurrentColor);
		this.markColorOnImage(this.oCurrentColor);
		this.adaptPreview(this.oCurrentColor);
	};
	
	
	/**
	 * Returns the oColor object (hsl-based) for the given CSS string that is built like this: "rgb(127,0,1)"
	 * @param sRgbString
	 */
	ShellColorPicker.parseCssRgbString = function(sRgbString) {
		sRgbString = jQuery.trim(sRgbString.replace(/rgb\(/, "").replace(/\)/, ""));
		var aRgb = sRgbString.split(",");
		var oRgbColor = {r:parseInt(aRgb[0], 10), g:parseInt(aRgb[1], 10), b:parseInt(aRgb[2], 10)};
		return ShellColorPicker.rgbToHsl(oRgbColor);
	};
	
	/* INTERNALS */
	
	ShellColorPicker.prototype.renderHtml = function(rm) {
		rm.write("<div id='" + this.id + "' class='sapUiUx3ShellColorPicker'>");
		rm.write("<img id='" + this.id + "-img' src='" + sap.ui.resource('sap.ui.ux3', 'img/colors-h.png') + "' />");
		rm.renderControl(this.oSlider);
		rm.write("<div id='" + this.id + "-grad' class='sapUiUx3ShellColorPickerGradient'></div>");
		rm.write("<div id='" + this.id + "-marker' class='sapUiUx3ShellColorPickerMarker'></div>");
		rm.write("<div id='" + this.id + "-preview' class='sapUiUx3ShellColorPickerPreview'></div>");
		rm.renderControl(this.oOkBtn);
		rm.renderControl(this.oCancelBtn);
		rm.write("</div>");
	};// TODO: remove HTML on close
	
	ShellColorPicker.prototype.markColorOnImage = function(oColor) {
		var x = oColor.h * 225;
		var y = (1 - oColor.s) * 75;
		jQuery.sap.byId(this.id + "-marker").css("left", x + 10).css("top", y + 10);
	};
	
	ShellColorPicker.prototype.markColorOnSlider = function(oColor) {
		this.oSlider.setValue(oColor.l);
	};
	
	ShellColorPicker.prototype.adaptSliderBar = function(oColor) {
		var gradient = "";
		var oMediumColor = jQuery.extend({},oColor);
		oMediumColor.l = 50;
		var color = ShellColorPicker.hslToCss(oMediumColor);
		if (!!sap.ui.Device.browser.firefox) {
			gradient = "-moz-linear-gradient(left, black, " + color + ", white)";
		} else if (!!sap.ui.Device.browser.webkit) {
			gradient = "-webkit-gradient(linear, left center, right center, from(#000), color-stop(0.5, " + color + "), to(#FFF))";
		}
		jQuery.sap.byId(this.id + "-grad").css("background-image", gradient);
	};
	
	ShellColorPicker.prototype.adaptPreview = function(oColor) {
		jQuery.sap.byId(this.id + "-preview").css("background-color", ShellColorPicker.hslToCss(oColor));
	};
	
	
	
	ShellColorPicker.prototype.handleSlider = function(e) {
		var l = e.getParameter("value");
		this.oCurrentColor.l = l;
		this.adaptPreview(this.oCurrentColor);
		this.fireLiveChange(this.oCurrentColor);
	};
	
	ShellColorPicker.prototype.handleGeneralMouseDown = function(e) {
		e.preventDefault(); // no autoclose!
	};
	
	ShellColorPicker.prototype.handleMouseDown = function(e) {
		this.handleMousePos(e);
		e.preventDefault(); // no drag&drop of the color image!
		jQuery(document)
			.bind("mousemove", jQuery.proxy(this.handleMousePos, this))
			.bind("mouseup", jQuery.proxy(this.handleMouseUp, this));
	};
	
	ShellColorPicker.prototype.handleMouseUp = function(e) {
		this.handleMousePos(e);
		jQuery(document)
			.unbind("mousemove", this.handleMousePos)
			.unbind("mouseup", this.handleMouseUp);
	};
	
	ShellColorPicker.prototype.handleMousePos = function(e) {
		var x = e.pageX - this._imgOffset.left;
		var y = e.pageY - this._imgOffset.top;
		x = Math.min(Math.max(x, 0), 225);
		y = Math.min(Math.max(y, 0), 75);
		var hue = x / 225; // TODO: hardcoded!
		var sat = 1 - y / 75; // TODO: hardcoded!
		this.oCurrentColor.h = hue;
		this.oCurrentColor.s = sat;
		this.adaptSliderBar(this.oCurrentColor);
		this.markColorOnImage(this.oCurrentColor);
		this.adaptPreview(this.oCurrentColor);
		this.fireLiveChange(this.oCurrentColor);
	};
	
	ShellColorPicker.prototype.handleOk = function() {
		this.fireLiveChange(this.oCurrentColor);
		this.oPopup.close();
	};
	
	ShellColorPicker.prototype.handleCancel = function() {
		this.fireLiveChange(this.oInitialColor);
		this.oPopup.close();
	};
	
	
	ShellColorPicker.prototype.handleClose = function() {
		// clean up event handlers, DOM, child controls and popup
		jQuery.sap.byId(this.id + "-img")
			.unbind("mousedown", this.handleMouseDown);
		jQuery.sap.byId(this.id + "-marker")
			.unbind("mousedown", this.handleMouseDown);
		jQuery(document)
			.unbind("mousemove", this.handleMousePos)
			.unbind("mouseup", this.handleMouseUp);
		jQuery.sap.byId(this.id)
			.unbind("mousedown", this.handleGeneralMouseDown);
	
		this.oSlider.destroy();
		this.oSlider = null;
		this.oOkBtn.destroy();
		this.oOkBtn = null;
		this.oCancelBtn.destroy();
		this.oCancelBtn = null;
	
		var domRef = jQuery.sap.domById(this.id);
		domRef.parentNode.removeChild(domRef);
	
		this.oPopup.destroy();
		this.oPopup = null;
	};
	
	
	/**
	 * rgb values are 0..255
	 */
	ShellColorPicker.rgbToHsl = function(oColor) {
		var r = oColor.r / 255,
				g = oColor.g / 255,
				b = oColor.b / 255;
		var max = Math.max(r, g, b);
		var min = Math.min(r, g, b);
		var h, s, l = (max + min) / 2;
	
		if (max == min) {
			h = s = 0; // all colors equally strong -> no saturation
		} else {
			var d = max - min;
			s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
			switch (max) {
				case r: h = (g - b) / d + (g < b ? 6 : 0); break;
				case g: h = (b - r) / d + 2; break;
				case b: h = (r - g) / d + 4; break;
			}
			h /= 6;
		}
		return {h:h,s:s,l:l * 100};
	};
	
	/**
	 * hs values are 0..1, l is 0..100
	 */
	ShellColorPicker.hslToRgb = function(oColor) {
		var r, g, b;
		var l = oColor.l / 100;
	
		if (oColor.s == 0) {
			r = g = b = l; // all colors equally strong -> all equal to lightness
		} else {
			var q = l < 0.5 ? l * (1 + oColor.s) : l + oColor.s - l * oColor.s;
			var p = 2 * l - q;
			r = ShellColorPicker.hueToRgb(p, q, oColor.h + 1 / 3);
			g = ShellColorPicker.hueToRgb(p, q, oColor.h);
			b = ShellColorPicker.hueToRgb(p, q, oColor.h - 1 / 3);
		}
	
		return [r * 255, g * 255, b * 255];
	};
	
	ShellColorPicker.hueToRgb = function(p, q, t) {
	  if (t < 0) {
		t += 1;
	  }
	  if (t > 1) {
		t -= 1;
	  }
	  if (t < 1 / 6) {
		return p + (q - p) * 6 * t;
	  }
	  if (t < 1 / 2) {
		return q;
	  }
	  if (t < 2 / 3) {
		return p + (q - p) * (2 / 3 - t) * 6;
	  }
	  return p;
	};
	
	ShellColorPicker.hslToCss = function(oColor) {
		var rgbColor = ShellColorPicker.hslToRgb(oColor);
		return "rgb(" + Math.round(rgbColor[0]) + "," + Math.round(rgbColor[1]) + "," + Math.round(rgbColor[2]) + ")";
	};

	return ShellColorPicker;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ShellColorPicker.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ShellPersonalization') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the class sap.ui.ux3.ShellPersonalization
jQuery.sap.declare('sap.ui.ux3.ShellPersonalization'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.EventProvider'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Button'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Dialog'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ShellPersonalization",['jquery.sap.global', 'sap/ui/base/EventProvider', 'sap/ui/commons/Button', 'sap/ui/commons/Dialog'],
	function(jQuery, EventProvider, Button, Dialog) {
	"use strict";


	
	
	/**
	 * Experimental implementation of visual Ux3 Shell personalization / branding.
	 *
	 * DO NOT USE PRODUCTIVELY!!!
	 *
	 *
	 * Being completely non-generic as of now, this is supposed to facilitate discussions with Ux
	 * about the personalization capabilities. Once that concept is more final, we can go for a cleaner implementation,
	 * considering the number of configurable properties etc.
	 *
	 * @param oShell
	 * @public
	 * @experimental Since 1.0. The Shell-features Personalization, Color Picker and “Inspect”-Tool are only experimental work and might change or disappear in future versions.
	 * @alias sap.ui.ux3.ShellPersonalization
	 */
	var ShellPersonalization = EventProvider.extend("sap.ui.ux3.ShellPersonalization", {
		constructor: function(oShell) {
			EventProvider.apply(this);
			this.shell = oShell;
		
			this.oSettings = {}; // TODO: read user config from somewhere/server/app
		}
	});
	
	/**
	 * Makes the personalization use the given settings.
	 *
	 * @param {object} oSettings
	 * @public
	 */
	ShellPersonalization.prototype.initializeSettings = function(oSettings) {
		this.oSettings = jQuery.extend({}, oSettings);
		if (this.shell.getDomRef()) {
			this.applySettings(oSettings);
		}
	};
	
	
	
	/*  EVENT HANDLING */
	
	ShellPersonalization.M_EVENTS = {personalizationChange: "personalizationChange"};
	
	ShellPersonalization.prototype.attachPersonalizationChange = function(fFunction, oListener) {
		this.attachEvent(ShellPersonalization.M_EVENTS.personalizationChange, fFunction, oListener);
	};
	
	ShellPersonalization.prototype.detachPersonalizationChange = function(fFunction, oListener) {
		this.detachEvent(ShellPersonalization.M_EVENTS.personalizationChange, fFunction, oListener);
	};
	
	ShellPersonalization.prototype.firePersonalizationChange = function(mParameters) {
		this.fireEvent(ShellPersonalization.M_EVENTS.personalizationChange, mParameters);
	};
	
	
	
	/**
	 * The default settings
	 */
	ShellPersonalization.ORIGINAL_SETTINGS = {
			bByDStyle: false,
	
			sBgColor: "rgb(17,17,17)",
			sBgCssImg: null, // updated later
			sBgImgSrc: null,
			sBgImgPos: "tile",
			fBgImgOpacity: 1,
	
			fSidebarOpacity: 1,
			sLineColor:"rgb(239,170,0)",
	
			sLogoImageSrc: null,
			sLogoAlign: "left",
			bUseLogoSize: false
	};
	
	ShellPersonalization.TRANSPARENT_1x1 = sap.ui.resource('sap.ui.core', 'themes/base/img/1x1.gif');
	
	ShellPersonalization.IMAGE_FOLDER_PATH = jQuery.sap.getModulePath("sap.ui.ux3.themes." + sap.ui.getCore().getConfiguration().getTheme(), "/img/shell/");
	
	ShellPersonalization.getOriginalSettings = function() {
		// buffer the settings
		if (!ShellPersonalization._bOriginalSettingsInitialized) {
			ShellPersonalization._bOriginalSettingsInitialized = true;
			
			jQuery.sap.require("sap.ui.core.theming.Parameters");
			var mAllParameters = sap.ui.core.theming.Parameters.get();
			var gradientTop = mAllParameters["sap.ui.ux3.Shell:sapUiUx3ShellGradientTop"];
			var gradientBottom = mAllParameters["sap.ui.ux3.Shell:sapUiUx3ShellGradientBottom"];
	
			if (!!sap.ui.Device.browser.firefox) {
				ShellPersonalization.ORIGINAL_SETTINGS.sBgCssImg = "-moz-linear-gradient(top, " + gradientTop + " 0, " + gradientBottom + " 108px, " + gradientBottom + ")";
			} else if (!!sap.ui.Device.browser.internet_explorer) {
				if (sap.ui.Device.browser.version == 7 || sap.ui.Device.browser.version == 8 || sap.ui.Device.browser.version == 9) {
					ShellPersonalization.ORIGINAL_SETTINGS.sBgCssImg = "url("
						+ ShellPersonalization.IMAGE_FOLDER_PATH
						+ "Workset_bg.png)";
				} else { // IE10+
					ShellPersonalization.ORIGINAL_SETTINGS.sBgCssImg = "-ms-linear-gradient(top, " + gradientTop + " 0, " + gradientBottom + " 108px, " + gradientBottom + ")";
				}
			} else if (!!sap.ui.Device.browser.webkit) {
				ShellPersonalization.ORIGINAL_SETTINGS.sBgCssImg = "-webkit-linear-gradient(top, " + gradientTop + " 0, " + gradientBottom + " 108px, " + gradientBottom + ")";
			}
		}
		
		return ShellPersonalization.ORIGINAL_SETTINGS;
	};
	
	
	
	/**
	 * Returns whether there are any personalization changes
	 *
	 * @returns {boolean}
	 * @public
	 */
	ShellPersonalization.prototype.hasChanges = function() {
		var iSettings = 0;
		/* eslint-disable no-unused-vars */
		/* Needed for counting object keys since IE8 does not support Object.keys(this.oSettings).length */
		for (var key in this.oSettings) {
			iSettings++;
		}
		/* eslint-enable no-unused-vars */
		return (iSettings > 0);
	};
	
	
	/**
	 * Applies the given personalization settings to the DOM.
	 *
	 * @param oSettings
	 */
	ShellPersonalization.prototype.applySettings = function(oSettings) {
		// copy fallback settings and mix in the given settings
		var oActualSettings = jQuery.extend({}, ShellPersonalization.getOriginalSettings());
		oActualSettings = jQuery.extend(oActualSettings, oSettings);
	
		// apply the settings
		this.applyByDStyle(oActualSettings.bByDStyle);
	
		this.applyBgColor(oActualSettings.sBgColor);
		this.applyBgImage(oActualSettings.sBgCssImg, oActualSettings.sBgImgSrc);
	
	
		// TODO: bgImgPos
		this.applyBgImageOpacity(oActualSettings.fBgImgOpacity);
	
		if (oActualSettings.sHeaderImageSrc) {
			this.applyHeaderImage(oActualSettings.sHeaderImageSrc);
		} else {
			this.shell.getDomRef("hdr").style.backgroundImage = "";
		}
		this.applySidebarOpacity(oActualSettings.fSidebarOpacity);
	
		this.applyBgColor(oActualSettings.sBgColor);
		this.applyLineColor(oActualSettings.sLineColor);
	
		this.applyLogoImage(oActualSettings.sLogoImageSrc);
		this.applyLogoAlign(oActualSettings.sLogoAlign);
		this.applyUseLogoSize(oActualSettings.bUseLogoSize);
	};
	
	
	/**
	 * Opens the personalization Dialog. This can be called from wherever the application wants to offer branding changes.
	 *
	 * @public
	 */
	ShellPersonalization.prototype.openDialog = function() {
		if (this.oDialog && this._getDialog().isOpen()) {
			return;
		} // first check is important because if !this.oDialog, the getter builds the Dialog and relies on the existence of this.oSettings!
																// but on the other hand, this.oSettings must not be initialized when the Dialog is already open
		this.oTransientSettings = jQuery.extend({}, this.oSettings);
	
		this._getDialog().open();
	
		// drag&drop for images with local file API
		this._bindDragAndDrop("bg");
		this._bindDragAndDrop("hdr");
		this._bindDragAndDrop("logo");
	};
	
	
	ShellPersonalization.prototype.getTransientSettingsWithDefaults = function() {
		return jQuery.extend(jQuery.extend({}, ShellPersonalization.getOriginalSettings()), this.oTransientSettings);
	};
	
	
	ShellPersonalization.prototype._bindDragAndDrop = function(sPrefix) {
		if (window.FileReader) {
			var sId = this.shell.getId() + "-p13n_";
			jQuery.sap.byId(sId + sPrefix + "ImageImg")
				.bind('dragover', jQuery.proxy(this._handleDragover, this))
				.bind('dragend',jQuery.proxy(this._handleDragend, this))
				.bind('drop', jQuery.proxy(this._handleDrop, this));
			jQuery.sap.byId(sId + sPrefix + "ImageHolder")
				.bind('dragover', jQuery.proxy(this._handleDragover, this))
				.bind('dragend',jQuery.proxy(this._handleDragend, this))
				.bind('drop', jQuery.proxy(this._handleDrop, this));
		}
	};
	ShellPersonalization.prototype._unbindDragAndDrop = function(sPrefix) {
		if (window.FileReader) {
			var sId = this.shell.getId() + "-p13n_";
			jQuery.sap.byId(sId + "hdrImageImg")
				.unbind('dragover', this._handleDragover)
				.unbind('dragend', this._handleDragend)
				.unbind('drop', this._handleDrop);
			jQuery.sap.byId(sId + "hdrImageHolder")
				.unbind('dragover', this._handleDragover)
				.unbind('dragend', this._handleDragend)
				.unbind('drop', this._handleDrop);
		}
	};
	
	
	/**
	 * Returns and - if necessary - constructs the Dialog
	 *
	 * @returns {sap.ui.commons.Dialog}
	 */
	ShellPersonalization.prototype._getDialog = function() {
		if (!this.oDialog) {
			jQuery.sap.require("sap.ui.ux3.ShellColorPicker");
	
			var sId = this.shell.getId() + "-p13n_";
			var oSettingsWithDefaults = jQuery.extend(jQuery.extend({}, ShellPersonalization.getOriginalSettings()), this.oSettings);
			var c = sap.ui.commons;
			var that = this;
	
	
			/* build the Dialog */
	
			var d = new c.Dialog({title:"Shell Personalization",width:"544px",height:"560px",showCloseButton:false,resizable:false,closed:[function(){
				// drag&drop for images with local file API
				this._unbindDragAndDrop("bg");
				this._unbindDragAndDrop("hdr");
				this._unbindDragAndDrop("logo");
				this.oTransientSettings = null;
			},this]}).addStyleClass("sapUiUx3ShellP13n");
	
	
			/* build the tabstrip */
	
			var tabs = new c.TabStrip({width:"100%",height:"100%",select:jQuery.proxy(function(oParams){
				var oControl = sap.ui.getCore().byId(oParams.getParameter("id"));
				if (oControl) {
					var index = oParams.getParameter("index");
					oControl.setSelectedIndex(index);
					var that = this;
					if (index == 0) {
						// apply the current settings to the plain HTML parts
						window.setTimeout(function(){that.shell.$("bgColor").css("background-color", that.getTransientSettingsWithDefaults().sBgColor);},1);
	
						// bind the drop event handlers
						window.setTimeout(jQuery.proxy(function(){
							this._bindDragAndDrop("bg");
						}, this), 0);
	
					} else if (index == 1) {
						// apply the current settings to the plain HTML parts
						window.setTimeout(function(){that.shell.$("lineColor").css("background-color", that.getTransientSettingsWithDefaults().sLineColor);},1);
	
						// bind the drop event handlers
						window.setTimeout(jQuery.proxy(function(){
							this._bindDragAndDrop("hdr");
						}, this), 0);
	
					} else if (index == 2) {
						// bind the drop event handlers
						window.setTimeout(jQuery.proxy(function(){
							this._bindDragAndDrop("logo");
						}, this), 0);
					}
				}
			}, this)});
	
	
			/* build the first tab */
	
			this.oBgImgHtml = new sap.ui.core.HTML(sId + "bgImageHolder", {
				preferDOM:true,
				content:"<div id='" + sId + "bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='" + sId + "bgImageImg' src='"
				+ (this.oTransientSettings.sBackgroundImageSrc ? this.oTransientSettings.sBackgroundImageSrc : sap.ui.resource('sap.ui.core', 'themes/base/img/1x1.gif')) + "'/></div>"}
			);
	
			this.oBgImgOpacitySlider = new c.Slider({
				value:(this.oTransientSettings.fBgImgOpacity !== undefined ? 100 - this.oTransientSettings.fBgImgOpacity * 100 : 100 - ShellPersonalization.getOriginalSettings().fBgImgOpacity * 100),
				liveChange:jQuery.proxy(this._handleBgImageOpacitySliderChange,this)
			});
			this.oSidebarOpacitySlider = new c.Slider({
				value:(this.oTransientSettings.fSidebarOpacity !== undefined ? 100 - this.oTransientSettings.fSidebarOpacity * 100 : 100 - ShellPersonalization.getOriginalSettings().fSidebarOpacity * 100),
				liveChange:jQuery.proxy(this._handleSidebarOpacitySliderChange,this)
			});
	
			this.oBgColorPicker = new sap.ui.ux3.ShellColorPicker(sId + "bgColorPicker");
			this.oBgColorPicker.attachLiveChange(function(oEvent){
				that._handleBgColorChange(oEvent);
			});
			var oBgColorBtn = new c.Button({text:"Change..."});
			var that = this;
			oBgColorBtn.attachPress(function(){
				if (!that.oBgColorPicker.isOpen()) {
					that.oBgColorPicker.open(sap.ui.ux3.ShellColorPicker.parseCssRgbString(that.getTransientSettingsWithDefaults().sBgColor), sap.ui.core.Popup.Dock.BeginTop, sap.ui.core.Popup.Dock.BeginBottom, that.shell.getDomRef("bgColor"));
				}
			});
			this.oBgPreviewHtml = new sap.ui.core.HTML({preferDom:true,content:"<div id='" + this.shell.getId() + "-bgColor' style='background-color:" + oSettingsWithDefaults.sBgColor + "' class='sapUiUx3ShellColorPickerPreview'></div>"});
	
			var oBgTab = new sap.ui.commons.Tab().setText("Background").addContent(new c.layout.MatrixLayout({layoutFixed:false})
				.createRow(new c.Label({text:"Background Image:"}), this.oBgImgHtml)
				.createRow(new c.Label({text:"Image Transparency:"}), this.oBgImgOpacitySlider)
				.createRow(new c.Label({text:"Background Color:"}), new c.layout.MatrixLayoutCell().addContent(this.oBgPreviewHtml).addContent(oBgColorBtn))
				.createRow(null)
				.createRow(new c.Label({text:"Sidebar Transparency:"}), this.oSidebarOpacitySlider)
			);
			tabs.addTab(oBgTab);
	
	
			/* build the second tab */
	
			this.oByDStyleCb = new c.CheckBox({text:"ByDesign-style Header Bar",checked:this.oTransientSettings.bByDStyle,change:jQuery.proxy(this._handleByDStyleChange,this)});
			this.oHdrImgHtml = new sap.ui.core.HTML(sId + "hdrImageHolder", {
				preferDOM:true,
				content:"<div id='" + sId + "hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='" + sId + "hdrImageImg' src='"
				+ (this.oTransientSettings.sHeaderImageSrc ? this.oTransientSettings.sHeaderImageSrc : sap.ui.resource('sap.ui.core', 'themes/base/img/1x1.gif')) + "'/></div>"}
			);
	
			this.oLineColorPicker = new sap.ui.ux3.ShellColorPicker(sId + "lineColorPicker");
			this.oLineColorPicker.attachLiveChange(function(oEvent){
				that._handleLineColorChange(oEvent);
			});
			var oLineColorBtn = new c.Button({text:"Change..."});
			var that = this;
			oLineColorBtn.attachPress(function(){
				if (!that.oLineColorPicker.isOpen()) {
					that.oLineColorPicker.open(sap.ui.ux3.ShellColorPicker.parseCssRgbString(that.getTransientSettingsWithDefaults().sLineColor), sap.ui.core.Popup.Dock.BeginTop, sap.ui.core.Popup.Dock.BeginBottom, that.shell.getDomRef("lineColor"));
				}
			});
			this.oLinePreviewHtml = new sap.ui.core.HTML({preferDom:true,content:"<div id='" + this.shell.getId() + "-lineColor' style='background-color:" + oSettingsWithDefaults.sLineColor + "' class='sapUiUx3ShellColorPickerPreview'></div>"});
	
			var oHdrTab = new sap.ui.commons.Tab().setText("Header Bar").addContent(new c.layout.MatrixLayout({layoutFixed:false})
				//.createRow(this.oByDStyleCb)
				.createRow(new c.Label({text:"Line Color (ByD-style only):"}), new c.layout.MatrixLayoutCell().addContent(this.oLinePreviewHtml).addContent(oLineColorBtn))
				.createRow(null)
				.createRow(new c.Label({text:"Header Image:"}),	this.oHdrImgHtml)
			);
			tabs.addTab(oHdrTab);
	
	
			/* build the third tab */
	
			this.oLogoImgHtml = new sap.ui.core.HTML(sId + "logoImageHolder", {
				preferDOM:true,
				content:"<div id='" + sId + "logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='" + sId + "logoImageImg' src='"
				+ (this.oTransientSettings.sLogoImageSrc ? this.oTransientSettings.sLogoImageSrc : sap.ui.resource('sap.ui.core', 'themes/base/img/1x1.gif')) + "'/></div>"}
			);
			this.oLogoRbg = new c.RadioButtonGroup()
				.addItem(new sap.ui.core.Item({text:"Left",key:"left"}))
				.addItem(new sap.ui.core.Item({text:"Center",key:"center"}))
				.attachSelect(this._handleLogoAlignChange, this);
			this.oUseLogoSizeCb = new c.CheckBox({text:"Use original image size",checked:this.oTransientSettings.bUseLogoSize,change:jQuery.proxy(this._handleUseLogoSizeChange,this)});
			var oLogoTab = new sap.ui.commons.Tab().setText("Logo").addContent(new c.layout.MatrixLayout({layoutFixed:false})
				.createRow(new c.Label({text:"Logo Image:"}), this.oLogoImgHtml)
				.createRow(new c.Label({text:"Position:"}), this.oLogoRbg)
				.createRow(this.oUseLogoSizeCb)
			);
			tabs.addTab(oLogoTab);
			d.addContent(tabs);
	
	
			/* finish building the Dialog */
	
			var that = this;
			d.addButton(new c.Button({text:"Reset All",press:function(){
				that.applySettings(jQuery.extend({}, ShellPersonalization.getOriginalSettings()));
				that.oSettings = {};
				that.oTransientSettings = {};
				that.updateDialog();
				that._bindDragAndDrop("bg");
				that._bindDragAndDrop("hdr");
				that._bindDragAndDrop("logo");
				that.firePersonalizationChange({settings:{}});
			}}));
			d.addButton(new c.Button({text:"OK",press:function(){
				that.oSettings = jQuery.extend({}, that.oTransientSettings); // settings are already applied
				that.firePersonalizationChange({settings:that.oSettings});
				d.close();
			}}));
			d.addButton(new c.Button({text:"Cancel",press:function(){
				// that.applySettings(that.oSettings);
				// that.updateDialog();
				d.close();
			}}));
			this.oDialog = d;
		}
		return this.oDialog;
	};
	
	
	ShellPersonalization.prototype.updateDialog = function() {
		var oActualSettings = jQuery.extend({}, ShellPersonalization.getOriginalSettings());
		oActualSettings = jQuery.extend(oActualSettings, this.oSettings);
		var sId = this.shell.getId() + "-p13n_";
	
		this.oBgImgHtml.setContent("<div id='" + sId + "bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='" + sId + "bgImageImg' src='"
				+ (oActualSettings.sBackgroundImageSrc ? oActualSettings.sBackgroundImageSrc : sap.ui.resource('sap.ui.core', 'themes/base/img/1x1.gif')) + "'/></div>");
		this.oBgImgOpacitySlider.setValue(100 - oActualSettings.fBgImgOpacity * 100);
		this.oSidebarOpacitySlider.setValue(100 - oActualSettings.fSidebarOpacity * 100);
	
		this.oByDStyleCb.setChecked(oActualSettings.bByDStyle);
		this.oHdrImgHtml.setContent("<div id='" + sId + "hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='" + sId + "hdrImageImg' src='"
				+ (oActualSettings.sHeaderImageSrc ? oActualSettings.sHeaderImageSrc : sap.ui.resource('sap.ui.core', 'themes/base/img/1x1.gif')) + "'/></div>");
	
		this.oLogoRbg.setSelectedIndex((oActualSettings.sLogoAlign == "center") ? 1 : 0);
		this.oUseLogoSizeCb.setChecked(oActualSettings.bUseLogoSize);
		this.oLogoImgHtml.setContent("<div id='" + sId + "logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='" + sId + "logoImageImg' src='"
				+ (oActualSettings.sLogoImageSrc ? oActualSettings.sLogoImageSrc : sap.ui.resource('sap.ui.core', 'themes/base/img/1x1.gif')) + "'/></div>");
	};
	
	
	
	
	/* property change handlers and code to apply each setting to the UI */
	
	
	ShellPersonalization.prototype._handleByDStyleChange = function(oEvent) {
		var bChecked = oEvent.getParameter("checked");
		this.oTransientSettings.bByDStyle = bChecked;
		this.applyByDStyle(bChecked);
	};
	ShellPersonalization.prototype.applyByDStyle = function(bByDStyle) {
		this.shell.$().toggleClass("sapUiUx3ShellByD", bByDStyle);
	};
	
	ShellPersonalization.prototype._handleBgColorChange = function(oEvent) {
		var cssColor = oEvent.getParameter("cssColor");
		this.oTransientSettings.sBgColor = cssColor;
		this.applyBgColor(cssColor);
	};
	ShellPersonalization.prototype.applyBgColor = function(sCssColor) {
		this.shell.$("bg").css("background-color", sCssColor);
		this.shell.$("bgColor").css("background-color", sCssColor);
	};
	
	ShellPersonalization.prototype._handleBackgroundImageChange = function(url, bPersistImmediately) {
		var tile = true; // TODO
		if (bPersistImmediately) {
			if (tile) {
				this.oSettings.sBgCssImg = "url(" + url + ")";
				this.oSettings.sBgImgSrc = null;
			} else {
				this.oSettings.sBgCssImg = null;
				this.oSettings.sBgImgSrc = url;
			}
			this.applyBgImage(this.oSettings.sBgCssImg, this.oSettings.sBgImgSrc);
			this.firePersonalizationChange({settings:this.oSettings});
		} else {
			if (tile) {
				this.oTransientSettings.sBgCssImg = "url(" + url + ")";
				this.oTransientSettings.sBgImgSrc = null;
			} else {
				this.oTransientSettings.sBgCssImg = null;
				this.oTransientSettings.sBgImgSrc = url;
			}
			this.applyBgImage(this.oTransientSettings.sBgCssImg, this.oTransientSettings.sBgImgSrc);
		}
	};
	
	ShellPersonalization.prototype.applyBgImage = function(sBgCssImg, sBgImgSrc) {
		// var sForcedImgSrc = sBgImgSrc ? sBgImgSrc : sBgCssImg.substring(4, sBgCssImg.length - 1);
		sBgCssImg = sBgCssImg ? sBgCssImg : "";
		sBgImgSrc = sBgImgSrc ? sBgImgSrc : ShellPersonalization.TRANSPARENT_1x1;
	
		var oBgImgRef = this.shell.getDomRef("bgImg");
		// var oBgImgPreviewRef = this.shell.getDomRef("p13n_bgImageImg");
	
		oBgImgRef.style.backgroundImage = sBgCssImg;
		oBgImgRef.src = sBgImgSrc;
	
		/* if (oBgImgPreviewRef) {
			// TODO: understand why this code exists   oBgImgPreviewRef.src = sForcedImgSrc;
		} */
	};
	
	ShellPersonalization.prototype._handleHeaderImageChange = function(dataUrl, bPersistImmediately) {
		if (bPersistImmediately) {
			this.oSettings.sHeaderImageSrc = dataUrl;
			this.firePersonalizationChange({settings:this.oSettings});
		} else {
			this.oTransientSettings.sHeaderImageSrc = dataUrl;
		}
		this.applyHeaderImage(dataUrl);
	};
	ShellPersonalization.prototype.applyHeaderImage = function(dataUrl) {
		this.shell.$("hdr").css("background-image", "url(" + dataUrl + ")");
		if (this.oDialog && this.oDialog.isOpen()) {
			this.shell.$("p13n_hdrImageImg").attr("src", dataUrl);
		}
	};
	
	ShellPersonalization.prototype._handleLineColorChange = function(oEvent) {
		var cssColor = oEvent.getParameter("cssColor");
		this.oTransientSettings.sLineColor = cssColor;
		this.applyLineColor(cssColor);
	};
	ShellPersonalization.prototype.applyLineColor = function(sCssColor) {
		this.shell.$("hdr").find("hr").css("background-color", sCssColor);
		this.shell.$("lineColor").css("background-color", sCssColor);
	};
	
	ShellPersonalization.prototype._handleBgImageOpacitySliderChange = function(oEvent) {
		var value = (100 - oEvent.getParameter("value")) / 100;
		this.oTransientSettings.fBgImgOpacity = value;
		this.applyBgImageOpacity(value);
	};
	ShellPersonalization.prototype.applyBgImageOpacity = function(fValue) {
		this.shell.$("bgImg").css("opacity", fValue);
	};
	
	ShellPersonalization.prototype._handleSidebarOpacitySliderChange = function(oEvent) {
		var value = (100 - oEvent.getParameter("value")) / 100;
		this.oTransientSettings.fSidebarOpacity = value;
		this.applySidebarOpacity(value);
	};
	ShellPersonalization.prototype.applySidebarOpacity = function(fValue) {
		this.shell.$("tp").css("opacity", fValue);
		this.shell.$("paneBar").children(":nth-child(2)").css("opacity", fValue);
	};
	
	ShellPersonalization.prototype._handleLogoImageChange = function(url, bPersistImmediately) {
		if (bPersistImmediately) {
			this.oSettings.sLogoImageSrc = url;
			this.firePersonalizationChange({settings:this.oSettings});
		} else {
			this.oTransientSettings.sLogoImageSrc = url;
		}
		this.applyLogoImage(url);
	};
	ShellPersonalization.prototype.applyLogoImage = function(url) {
		if (!url) {
			url = this.shell.getAppIcon();
			if (!url) {
				url = ShellPersonalization.TRANSPARENT_1x1;
			}
		}
		this.shell.$("logoImg").attr("src", url);
		this.shell.$("p13n_logoImageImg").attr("src", url); // just in case the dialog is displaying it
	};
	
	ShellPersonalization.prototype._handleLogoAlignChange = function(oEvent) {
		var iIndex = oEvent.getParameter("selectedIndex");
		var sAlign = ["left","center"][iIndex];
		this.oTransientSettings.sLogoAlign = sAlign;
		this.applyLogoAlign(sAlign);
	};
	ShellPersonalization.prototype.applyLogoAlign = function(sLogoAlign) {
		var sRealAlign = sLogoAlign;
		if (sap.ui.getCore().getConfiguration().getRTL() && (sRealAlign == "right")) {
			sRealAlign = "left"; // need to use left/right, as "begin" is not supported by IE8
		}
		this.shell.$("hdr").css("text-align", sRealAlign);
	};
	
	ShellPersonalization.prototype._handleUseLogoSizeChange = function(oEvent) {
		var bUse = oEvent.getParameter("checked");
		this.oTransientSettings.bUseLogoSize = bUse;
		this.applyUseLogoSize(bUse);
	};
	ShellPersonalization.prototype.applyUseLogoSize = function(bUseLogoSize) {
		this.shell.$("hdr").toggleClass("sapUiUx3ShellHeaderFlex", bUseLogoSize);
		this.shell.$("hdrImg").toggleClass("sapUiUx3ShellHeaderImgFlex", bUseLogoSize);
	};
	
	
	
	/* drag & drop code */
	
	
	ShellPersonalization.prototype._handleDragover = function(evt) {
		var id = evt.target.id;
		if (!this._dragOverBlinking) {
			var $bg = jQuery.sap.byId(id);
			$bg.css("opacity", "0.5");
			this._dragOverBlinking = true;
			var that = this;
			window.setTimeout(function(){
				$bg.css("opacity", "1");
				window.setTimeout(function(){
					that._dragOverBlinking = null;
				}, 250);
			}, 250);
		}
	  return false;
	};
	ShellPersonalization.prototype._handleDragend = function(evt) {
		return false;
	};
	ShellPersonalization.prototype._handleDrop = function(evt) {
		var id = evt.target.id;
		evt.preventDefault();
		var e = evt.originalEvent;
		var file = e.dataTransfer.files[0];
		if (file) {
			// read file content
			var reader = new window.FileReader();
			reader.onload = jQuery.proxy(function(event) {
				var dataUrl = event.target.result;
				if ((id == this.shell.getId() + "-p13n_bgImageImg")
						|| (id == this.shell.getId() + "-p13n_bgImageHolder")) {
					this._handleBackgroundImageChange(dataUrl);
				} else if ((id == this.shell.getId() + "-p13n_hdrImageImg")
						|| (id == this.shell.getId() + "-p13n_hdrImageHolder")) {
					this._handleHeaderImageChange(dataUrl);
				} else if ((id == this.shell.getId() + "-p13n_logoImageImg")
						|| (id == this.shell.getId() + "-p13n_logoImageHolder")) {
					this._handleLogoImageChange(dataUrl);
				}
				reader = null;
			}, this);
			reader.readAsDataURL(file);
		}
	};
	

	return ShellPersonalization;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ShellPersonalization.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ShellRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for the sap.ui.ux3.Shell
jQuery.sap.declare('sap.ui.ux3.ShellRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ShellRenderer",['jquery.sap.global', 'sap/ui/core/IconPool'],
	function(jQuery, IconPool) {
	"use strict";


	
	/**
	 * GoldReflectionPageLayout renderer.
	 * @namespace
	 */
	var ShellRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ShellRenderer.render = function(oRenderManager, oControl) {
		// convenience variable
		var rm = oRenderManager;
		var bPaneOpen = oControl.isPaneOpen();
		var iPaneWidthPlus = oControl.getPaneWidth() + sap.ui.ux3.Shell.SIDE_BAR_BASE_WIDTH; // width of pane plus how far it is from the edge
		var bRtl = sap.ui.getCore().getConfiguration().getRTL();
		var sId = oControl.getId();
	
		if (sap.ui.ux3.Shell.FIRST_RENDERING) {
			document.body.style.margin = "0"; // does not seem to work in initial onBeforeRendering
		}
	
		// write the root HTML element  TODO: this should use the existing <body>! But where is the staticarea, then?
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiUx3Shell");
		rm.addClass("sapUiUx3ShellHead" + oControl.getHeaderType());
		rm.addClass("sapUiUx3ShellDesign" + oControl.getDesignType());
		
		if (!oControl._hasDarkDesign()) {
			rm.addClass("sapUiUx3ShellDesignLight");
		}
		
		if (oControl.getFullHeightContent()) {
			rm.addClass("sapUiUx3ShellFullHeightContent");
		}
		if (!oControl.getApplyContentPadding()) {
			rm.addClass("sapUiUx3ShellNoContentPadding");
		}
		if (!oControl.getShowTools()) {
			rm.addClass("sapUiUx3ShellNoTools");
		}
		if (!oControl.getShowPane()) {
			rm.addClass("sapUiUx3ShellNoPane");
		}
		if (oControl._topSyncRefId && !oControl.getAllowOverlayHeaderAccess()) {
			rm.addClass("sapUiUx3ShellBlockHeaderAccess");
		}
		rm.writeClasses();
		rm.write(">");
	
	
		// write header
		rm.write("<img id='" + sId + "-hdrImg' class='sapUiUx3ShellHeaderImg' src='");
		var sImage = sap.ui.core.theming.Parameters._getThemeImage('sapUiUx3ShellHeaderImageURL', true);
		rm.writeEscaped(sImage);
		rm.write("' />");
		rm.write("<header id='" + sId + "-hdr' class='sapUiUx3ShellHeader' role='banner'>");
		var tabIndex = oControl._topSyncRefId ? " tabindex='0'" : "";
		rm.write("<span class='sapUiUx3ShellFocusDummy' id='" + sId + "-focusDummyHdrStart'" + tabIndex + "></span>");
		ShellRenderer.renderHeader(rm, oControl);
		rm.write("<span class='sapUiUx3ShellFocusDummy' id='" + sId + "-focusDummyHdrEnd'" + tabIndex + "></span>");
		rm.write("</header>   <!-- end of sapUiUx3ShellHeader -->");
	
	
	
		// write page background
		rm.write("<div id='", sId, "-bg' class='sapUiUx3ShellBg'></div>");
		rm.write("<img id='", sId, "-bgImg' class='sapUiUx3ShellBgImg' src='");
		sImage = sap.ui.core.theming.Parameters._getThemeImage('sapUiUx3ShellBackgroundImageURL', true);
		rm.writeEscaped(sImage);
		rm.write("'/>");
	
	
		// write workset items
		var wsMargin = bPaneOpen ? " style='margin-" + (bRtl ? "left" : "right") + ":" + (iPaneWidthPlus + 22) + "px'" : "";
		rm.write("<div id='", sId, "-wBar'" + wsMargin + " class='sapUiUx3ShellWorksetBar'>");
		ShellRenderer.renderWorksetItems(rm, oControl);
		rm.write("</div>   <!--  end of worksetBar -->");
	
	
	
		// write tool palette area
		rm.write("<section id='" + sId + "-tp' class='sapUiUx3ShellToolPaletteArea' role='complementary' data-sap-ui-fastnavgroup='true'>");
		ShellRenderer.renderToolPalette(rm, oControl);
		rm.write("</section> <!-- end of toolPaletteArea -->");
	
	
	
		// write page canvas and content
		
		var paneExtraStyle = bPaneOpen ? " style='" + (bRtl ? "left" : "right") + ":" + iPaneWidthPlus + "px'" : "";
		rm.write("<div class='sapUiUx3ShellCanvas'" + paneExtraStyle + " id='" + sId + "-canvas'>");
	
		ShellRenderer.renderFacetBar(rm, oControl);
	
		rm.write("<article class='sapUiUx3ShellContent' id='" + sId + "-content' role='main' data-sap-ui-fastnavgroup='true'>");
		var aContent = oControl.getContent();
		for (var i = 0; i < aContent.length; i++) {
			rm.renderControl(aContent[i]);
		}
		rm.write("</article><div class='sapUiUx3ShellNotifySpace'></div></div>");
	
	
	
		// write pane bar
		var tabIndex = oControl._topSyncRefId ? " tabindex='0'" : "";
		rm.write("<span class='sapUiUx3ShellFocusDummy' id='" + sId + "-focusDummyPane'" + tabIndex + "></span>");
		rm.write("<aside id='" + sId + "-paneBar' class='sapUiUx3ShellPaneBar " + (bPaneOpen ? " sapUiUx3ShellPaneBarOpen sapUiUx3ShellPaneBarOpened" : " sapUiUx3ShellPaneBarClose") + "' role='complementary' style='width:" + iPaneWidthPlus + "px;'>");
		rm.write("<section id='" + sId + "-paneContent' style='width:" + oControl.getPaneWidth() + "px;' class='sapUiUx3ShellPaneBarContent' role='tabpanel'>");
		var aPaneContent = oControl.getPaneContent();
		for (var i = 0; i < aPaneContent.length; i++) {
			rm.renderControl(aPaneContent[i]);
		}
		rm.write("</section>");
	
		rm.write("<div id='" + sId + "-paneBarRight' class='sapUiUx3ShellPaneBarRight' data-sap-ui-fastnavgroup='true'>");
		rm.write("<ul id='" + sId + "-paneBarEntries' class='sapUiUx3ShellPaneEntries' role='tablist'>");
		ShellRenderer.renderPaneBarItems(rm, oControl);
		rm.write("</ul>");
	
		// Render overflow button
		rm.write("<div id='" + sId + "-paneBarOverflowButton' class='sapUiUx3ShellPaneOverflowButton'");
		rm.addStyle("display", "none;"); // So it does not depend on theme being loaded
		rm.writeStyles();
		rm.write(">");
		rm.write("<div id='" + sId + "-paneBarOverflowWrapper' class='sapUiUx3ShellPaneOverflowWrapper'>");
		rm.write("<span id='" + sId + "-paneBarOverflowText' class='sapUiUx3ShellPaneOverflowText sapUiUx3ShellPaneEntry'>");
		rm.write(sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON"));
		rm.write("</span>"); // sapUiUx3ShellPaneOverflowText
		rm.write("</div>"); // overflow-wrapper
		rm.write("</div>"); // sapUiUx3ShellPaneOverflowButton
		
		
		rm.write("</div>");
		
		
		rm.write("</aside>   <!-- end of paneBar -->");
	
	
	
		// write the purely visual background
		rm.write("<div class='sapUiUx3ShellCanvasBackground " + (bPaneOpen ? "sapUiUx3ShellCanvasBackgroundOpen" : "sapUiUx3ShellCanvasBackgroundClosed")
				+ "' id='" + sId + "-canvasBackground'" + paneExtraStyle + ">");
		rm.write("<div class='sapUiUx3ShellCanvasBackgroundRight'></div>");
		rm.write("</div>");
	
		rm.write("<div id='" + sId + "-notify' class='sapUiUx3ShellNotify'>");
		ShellRenderer.renderNotificationArea(rm, oControl);
		rm.write("</div>");
	
		// render closing tag for root element
		rm.write("</div>");
	};
	
	
	
	ShellRenderer.renderHeader = function(rm, oControl) {
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
	
		var appIcon = oControl.getAppIcon();
		rm.write("<hr id='" + oControl.getId() + "-hdrLine'/><img id='" + oControl.getId() + "-logoImg' src='");
		if (appIcon) {
			rm.writeEscaped(oControl.getAppIcon());
		} else {
			var sImage = sap.ui.core.theming.Parameters._getThemeImage('sapUiUx3ShellApplicationImageURL', true);
			rm.writeEscaped(sImage);
		}
		rm.write("'");
	
		var iconTooltip = oControl.getAppIconTooltip() || rb.getText("SHELL_LOGO");
		rm.writeAttributeEscaped("alt", iconTooltip);
		rm.writeAttributeEscaped("title", iconTooltip);
	
		rm.write("><h1");
		rm.writeAttributeEscaped("title", oControl.getAppTitle());
		rm.write(">");
		rm.writeEscaped(oControl.getAppTitle());
	
		rm.write("</h1><span id='" + oControl.getId() + "-hdr-items' class='sapUiUx3ShellHeaderTitleRight'>");
	
		// header-right-items
		var aHeaderItems = oControl.getHeaderItems();
		for (var i = 0; i < aHeaderItems.length; i++) {
			// ensure correct styling of the menu if there is a MenuButton
			if (aHeaderItems[i] instanceof sap.ui.commons.MenuButton) { // TODO: improve this
				if (aHeaderItems[i].getMenu()) {
					aHeaderItems[i].getMenu().addStyleClass("sapUiMnuTop", true); // multiple calls are ignored, so there is no check whether the class is already there
				}
			}
	
			// render the header item
			rm.renderControl(aHeaderItems[i]);
	
			if ((i < (aHeaderItems.length - 1)) || (oControl.getShowLogoutButton())) {
				rm.write("<span class='sapUiUx3ShellHeaderSep'></span>");
			}
		}
	
		// logout button
		if (oControl.getShowLogoutButton()) {
			rm.write("<a id='" + oControl.getId() + "-logout' title='");
			rm.write(oControl.getLogoutButtonTooltip() ? jQuery.sap.encodeHTML(oControl.getLogoutButtonTooltip()) : rb.getText("SHELL_LOGOUT"));
			rm.write("' tabindex='0' role='button' class='sapUiUx3ShellHeaderButton sapUiUx3ShellHeader-logout'></a>");
		}
		rm.write("</span>");
	};
	
	
	
	
	/**
	 * Renders the inner HTML of the left-side tool palette.
	 *
	 * @param oControl the Shell control
	 * @private
	 */
	ShellRenderer.renderToolPalette = function(rm, oControl) {
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
		var sId = oControl.getId();
		
		var tabIndex = oControl._topSyncRefId ? " tabindex='0'" : "";
		rm.write("<span class='sapUiUx3ShellFocusDummy' id='" + oControl.getId() + "-focusDummyTPStart'" + tabIndex + "></span>");
	
		// write standard tools
		var sAccDescr = rb.getText("SHELL_TOOLPANE_GENERIC"),
			bStandardToolPresent = false,
			bFirstTool = true,
			sStandardToolsHtml = "";
		if (oControl.getShowSearchTool()) {
			bStandardToolPresent = true;
			sStandardToolsHtml += "<a id='" + sId + sap.ui.ux3.Shell.TOOL_PREFIX + sId + "-searchTool' title='" + rb.getText("SHELL_SEARCH") + "' class='sapUiUx3ShellTool sapUiUx3ShellTool-search' tabindex='0' role='button' aria-pressed='false'></a>";
			if (bFirstTool) {
				bFirstTool = false;
			} else {
				sAccDescr += ",";
			}
			sAccDescr += " " + rb.getText("SHELL_SEARCH");
		}
		if (oControl.getShowFeederTool()) {
			bStandardToolPresent = true;
			sStandardToolsHtml += "<a id='" + sId + sap.ui.ux3.Shell.TOOL_PREFIX + sId + "-feederTool' title='" + rb.getText("SHELL_FEEDER") + "' class='sapUiUx3ShellTool sapUiUx3ShellTool-feeder' tabindex='0' role='button' aria-pressed='false'></a>";
			if (bFirstTool) {
				bFirstTool = false;
			} else {
				sAccDescr += ",";
			}
			sAccDescr += " " + rb.getText("SHELL_FEEDER");
		}
	
		if (bStandardToolPresent) {
			rm.write("<div role='toolbar'aria-describedby='" + sId + "-genericToolsDescr'>");
			rm.write("<span id='" + sId + "-genericToolsDescr' style='display:none;'>" + sAccDescr + "</span>");
			rm.write(sStandardToolsHtml + "</div>");
		}
	
		var aToolItems = oControl.getToolPopups();
	
		// write separator between standard tools and app tools, if required
		if (bStandardToolPresent && (aToolItems.length > 0)) {
			rm.write("<hr id='" + sId + "-tp-separator' class='sapUiUx3ShellToolSep'></hr>");
		}
	
		// write app tools
		if (aToolItems.length > 0) {
			rm.write("<div role='toolbar' aria-describedby='" + sId + "-appToolsDescr'>");
			rm.write("<span id='" + sId + "-appToolsDescr' style='display:none;'>" + rb.getText("SHELL_TOOLPANE_APP") + "</span>");
			for (var i = 0; i < aToolItems.length; i++) {
				var oToolItem = aToolItems[i];
				if (oToolItem instanceof sap.ui.core.SeparatorItem) { // TODO: not possible
					rm.write("<hr class='sapUiUx3ShellToolSep'></hr>");
				} else {
					// regular item
					rm.write("<a id='" + sId + "-tool-" + oToolItem.getId() + "' class='sapUiUx3ShellTool'");
					var sTooltip = oToolItem.getTooltip_AsString();
					if (!sTooltip) {
						sTooltip = oToolItem.getTitle();
					}
					if (sTooltip) {
						rm.write(" title='");
						rm.writeEscaped(sTooltip);
						rm.write("' ");
					}
					rm.write(" tabindex='0' role='button' aria-pressed='false'>");
					var sIconUrl = oToolItem.getIcon();
					if (IconPool.isIconURI(sIconUrl)) {
						rm.writeIcon(sIconUrl, ["sapUiUx3ShellToolFontIcon"], {
							// prevent default icon tooltip / ARIA attribute
							// the outer <a> tag has the information required
							"title": null,
							"aria-label": null
						});
					} else {
						rm.write("<img src='");
						rm.writeEscaped(sIconUrl);
						rm.write("' alt='' role='presentation'/>");
					}
					rm.write("</a>");
				}
			}
			rm.write("</div>");
		}
		rm.write("<span class='sapUiUx3ShellFocusDummy' id='" + oControl.getId() + "-focusDummyTPEnd'" + tabIndex + "></span>");
	};
	
	ShellRenderer.renderPaneBarItems = function(rm, oControl) {
		var sId = oControl.getId();
		var aPaneBarItems = oControl.getPaneBarItems();
		var iNoOfItems = aPaneBarItems.length;
		for (var i = 0; i < iNoOfItems; i++) {
			var item = aPaneBarItems[i];
			var itemId = item.getId();
			rm.write("<li");
			rm.writeElementData(item);
			rm.write(" role='tab' aria-controls='" + sId + "-paneContent' aria-setsize='" + iNoOfItems + "' aria-posinset='" + (i + 1) + "' tabindex='-1' class='sapUiUx3ShellPaneEntry");
			if (oControl._sOpenPaneId === itemId) { // mark pane item if opened
				rm.write(" sapUiUx3ShellPaneEntrySelected");
			}
			rm.write("'");
			if (item.getTooltip_AsString()) {
				rm.writeAttributeEscaped("title", item.getTooltip_AsString());
			}
			rm.write(">");
			rm.writeEscaped(item.getText().toUpperCase());
			rm.write("</li>");
		}
	};
	
	ShellRenderer.renderNotificationArea = function(rm, oControl) {
		rm.write("<div class='sapUiUx3ShellNotifyBG'></div>");
		if (oControl.getNotificationBar()) {
			rm.renderControl(oControl.getNotificationBar());
		}
	};
	
	ShellRenderer.renderWorksetItems = function(rm, oControl) {
		var aItems = oControl.getWorksetItems();
		oControl._oWorksetBar.setAssociatedItems(aItems);
		if (!oControl._oWorksetBar.isSelectedItemValid() && (aItems.length > 0)) {
			oControl.setAssociation("selectedWorksetItem", aItems[0], true); // set the first item as being selected if there is no item selected
			oControl._oWorksetBar.setSelectedItem(aItems[0]); // set the first item as being selected if there is no item selected
		}
		if (rm) {
			rm.renderControl(oControl._oWorksetBar);
		}
	};
	
	ShellRenderer.renderFacetBar = function(rm, oControl) {
		var oSelectedWsi = sap.ui.getCore().byId(oControl.getSelectedWorksetItem()); // by now it is guaranteed that the association is properly initialized
		if (oSelectedWsi) {
			// if parent is also a NavigationItem, the selected one is a second-level item and we need to go up one level
			var parent = oSelectedWsi.getParent();
			if (parent && parent instanceof sap.ui.ux3.NavigationItem) {
				oSelectedWsi = parent;
			}
		
			var aSubItems = oSelectedWsi.getSubItems();
			oControl._oFacetBar.setAssociatedItems(aSubItems);
			if (!oControl._oFacetBar.isSelectedItemValid() && (aSubItems.length > 0)) {
				oControl._oFacetBar.setSelectedItem(aSubItems[0]); // set the first item as being selected if there is no item selected
			}
		}
		if (rm) {
			rm.renderControl(oControl._oFacetBar);
		}
	};
	

	return ShellRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ShellRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ThingInspectorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.ThingInspector
jQuery.sap.declare('sap.ui.ux3.ThingInspectorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ThingInspectorRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './OverlayRenderer'],
	function(jQuery, Renderer, OverlayRenderer) {
	"use strict";


	/**
	 * ThingInspector renderer.
	 * @namespace
	 */
	var ThingInspectorRenderer = Renderer.extend(OverlayRenderer);
	
	/**
	 * Renders the ThingInspector content
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ThingInspectorRenderer.renderContent = function(oRenderManager, oControl) {
		// convenience variable
		var rm = oRenderManager;
		rm.write("<div role='Main' class='sapUiUx3TIContent' id='" + oControl.getId() + "-content'>");
		rm.renderControl(oControl._oThingViewer);
		rm.write("</div>");
	};
	
	/**
	 * Add root class to ThingInspector
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ThingInspectorRenderer.addRootClasses = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.addClass("sapUiUx3TI");
	};
	
	/**
	 * Add class to ThingInspector
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ThingInspectorRenderer.addOverlayClasses = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.addClass("sapUiUx3TIOverlay");
	};

	return ThingInspectorRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ThingInspectorRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ThingViewerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
 
jQuery.sap.declare('sap.ui.ux3.ThingViewerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ThingViewerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Thing renderer. 
	 * @namespace
	 */
	var ThingViewerRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * 
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ThingViewerRenderer.render = function(oRenderManager, oControl){
	    // convenience variable
		var rm = oRenderManager;
		
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.writeAttributeEscaped("style", "width:" + oControl.getWidth() + "; height:" + oControl.getHeight());
		rm.addClass('sapUiUx3TV');
		rm.writeClasses();
		rm.write(">");
		this.renderContent(rm,oControl);
		rm.write("</div>");
	};
	
	ThingViewerRenderer.renderContent = function(oRenderManager, oControl) {
	// convenience variable
		var rm = oRenderManager,
			headerType = oControl.getHeaderType();
	
		rm.write("<div role='Main' class='sapUiUx3TVContent' id='" + oControl.getId() + "-content'>");
		//render Header
		//rm.write("<div class='sapUiUx3TVHeader sapUiUx3TVNoActionBar'>");
		rm.write("<div class='sapUiUx3TVHeader sapUiUx3TVNoActionBar");
		if (oControl.getHeaderType() === sap.ui.ux3.ThingViewerHeaderType.Standard) {
			rm.write("'>");
		} else {
			rm.write(" sapUiUx3TVhorizontal'>");
		}
		rm.write("<div class='sapUiUx3TVHeaderContainerIdentifier'>");
		rm.write("<span role='heading' aria-level='1' class='sapUiUx3TVIdentifier'");
		rm.writeAttributeEscaped("title", oControl.getType());
		rm.write(">");
		rm.writeEscaped(oControl.getType());
		rm.write("</span>");
		rm.write("</div>");
	
		if (headerType === sap.ui.ux3.ThingViewerHeaderType.Standard) {
			rm.write("<div class='sapUiUx3TVHeaderGroupScrollContainer'>");
			rm.write("<div id='" + oControl.getId() + "-header' class='sapUiUx3TVHeaderContainer'>");
			this.renderHeader(rm,oControl);
			rm.write("</div>");
		} else {
			rm.write("<div id='" + oControl.getId() + "-header' class='sapUiUx3TVHeaderContainer'>");
			this.renderHeader(rm,oControl);
			rm.write("</div>");
			rm.write("<div class='sapUiUx3TVHeaderGroupScrollContainer sapUiUx3TVhorizontal'>");
		}
		// render Header Content
		rm.write("<div id='" + oControl.getId() + "-headerContent'");
		if (headerType === sap.ui.ux3.ThingViewerHeaderType.Standard) {
			rm.write(">");
		} else {
			rm.write("style='height:100%; white-space:nowrap'>");
		}
		this.renderHeaderContent(rm, oControl);
		rm.write("</div>");
	
		rm.write("</div>");
		rm.write("</div>");
	
		// render Facets
		rm.write("<div class='sapUiUx3TVFacets sapUiUx3TVNoActionBar");
		if (headerType === sap.ui.ux3.ThingViewerHeaderType.Standard) {
			rm.write("'>");
		} else {
			rm.write(" sapUiUx3TVhorizontal'>");
		}
		rm.write("<div role='Navigation' class='sapUiUx3TVFacetBar'>");
		rm.renderControl(oControl._getNavBar());
		rm.write("</div>");
		rm.write("<div id='" + oControl.getId() + "-facetContent' class='sapUiUx3TVFacetContent sapUiBodyBackground'>");
	
		// render Facet Content
		this.renderFacetContent(rm, oControl);
	
		rm.write("</div>");
		rm.write("</div>");
		this.renderToolbar(rm, oControl);
		rm.write("</div>");
	};
	
	/**
	 * Add root class to Thing
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ThingViewerRenderer.addRootClasses = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.addClass("sapUiUx3TV");
	};
	
	/**
	 * Add class to Thing
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ThingViewerRenderer.addOverlayClasses = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.addClass("sapUiUx3TVOverlay");
	};
	
	/**
	 * Renders the HTML for Thing Header
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ThingViewerRenderer.renderHeader = function(oRenderManager, oControl) {
		var rm = oRenderManager;
	
		rm.write("<div class='sapUiUx3TVIconBar'>");
		rm.writeIcon(oControl.getIcon(),["sapUiUx3TVIcon"],{
			role: 'presentation',
			id: oControl.getId() + '-swatch',
			title: null // prevent default icon tooltip
		});
		rm.write("<div class='sapUiUx3TVTitle'>");
		rm.write("<span role='heading' aria-level='2' class='sapUiUx3TVTitleFirst'");
		rm.writeAttributeEscaped("title", oControl.getTitle());
		rm.write(">");
		rm.writeEscaped(oControl.getTitle());
		rm.write("</span><br/>");
		rm.write("</div><div class='sapUiUx3TVTitle'>");
		rm.write("<span role='heading' aria-level='3' class='sapUiUx3TVTitleSecond'");
		rm.writeAttributeEscaped("title", oControl.getSubtitle());
		rm.write(">");
		rm.writeEscaped(oControl.getSubtitle());
		rm.write("</span>");
		rm.write("</div>");
		rm.write("</div>");
	};
	 
	 
	/**
	 * Renders the HTML for Thing Toolbar
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ThingViewerRenderer.renderToolbar = function(rm, oControl) {
		// render Toolbar
		if (oControl.getActionBar()) {
			rm.write("<div id='" + oControl.getId() + "-toolbar' class='sapUiUx3TVToolbar'>");
			rm.renderControl(oControl.getActionBar());
			rm.write("</div>");
		}
	};
	
	/**
	 * Renders the HTML for Thing Header content
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ThingViewerRenderer.renderHeaderContent = function(rm, oControl) {
		var headerContentList = oControl.getHeaderContent(),
			headerType = oControl.getHeaderType();
			
		for ( var i = 0; i < headerContentList.length; i++) {
			var headerContent = headerContentList[i];
			if (headerType === sap.ui.ux3.ThingViewerHeaderType.Standard) {
				rm.write("<hr class='sapUiUx3TVHRWhite'>");
			}
			rm.write("<div class='sapUiUx3TVHeaderContainer");
			if (headerType === sap.ui.ux3.ThingViewerHeaderType.Standard) {
				rm.write("' role='form'>");
			} else {
				rm.write(" sapUiUx3TVhorizontal' role='form'>");
			}
			if (headerContent.getTitle()) {
				rm.write("<div class='sapUiUx3TVHeaderGroupTitle'");
				rm.writeAttributeEscaped("title", headerContent.getTooltip_AsString() ? headerContent.getTooltip_AsString() : headerContent.getTitle());
				rm.write("><span role='heading' aria-level='4'>");
				rm.writeEscaped(headerContent.getTitle());
				rm.write("</span>");
				rm.write("</div>");
			}
			rm.write("<div class='sapUiUx3TVHeaderGroupContent'>");
			var childContent = headerContent.getContent();
			for ( var j = 0; j < childContent.length; j++) {
				var childControl = childContent[j];
				rm.renderControl(childControl);
			}
			rm.write("</div>");
			rm.write("</div>");
		}
	};
	
	/**
	 * Renders the HTML for Thing Facet content
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	ThingViewerRenderer.renderFacetContent = function(rm, oControl) {
		var facetContent = oControl.getFacetContent();
		var bTitle = true;
	
		if (facetContent.length == 1 )  {
			bTitle = false;
		}
	
		for ( var i = 0; i < facetContent.length; i++) {
			var group = facetContent[i];
			if (group.getColspan()) {
				rm.write("<div class='sapUiUx3TVFacetThingGroupSpan' role='form'>");
			} else {
				rm.write("<div class='sapUiUx3TVFacetThingGroup' role='form'>");
			}
			if (bTitle) {
				rm.write("<div class='sapUiUx3TVFacetThingGroupContentTitle'");
				rm.writeAttributeEscaped("title", group.getTooltip_AsString() ? group.getTooltip_AsString() : group.getTitle());
				rm.write("><span role='heading'>");
				rm.writeEscaped(group.getTitle());
				rm.write("</span></div>");
			}
			rm.write("<div class='sapUiUx3TVFacetThingGroupContent'>");
			var groupContent = group.getContent();
			for ( var j = 0; j < groupContent.length; j++) {
				rm.renderControl(groupContent[j]);
			}
			rm.write("</div></div>");
		}
	};

	return ThingViewerRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ThingViewerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ToolPopupRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.ToolPopup
jQuery.sap.declare('sap.ui.ux3.ToolPopupRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ToolPopupRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * ToolPopup renderer.
	 * @namespace
	 */
	var ToolPopupRenderer = {
	};
	
	
	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	ToolPopupRenderer.render = function(rm, oControl) {
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
		var sId = oControl.getId();
		var aContent = oControl.getContent();
		var aButtons = oControl.getButtons();
		var sTitle = oControl.getTitle();
		// there must be something to focus -> empty elements don't get a focus
		var sSrc = sap.ui.resource('sap.ui.core', 'themes/base/img/1x1.gif');
	
		// write the HTML into the render manager
		rm.write("<div");
		rm.writeControlData(oControl);
		
		rm.addClass("sapUiUx3TP");
		if (sTitle === "") {
			rm.addClass("sapUiUx3TPNoTitle");
		}
		if (aButtons.length === 0) {
			rm.addClass("sapUiUx3TPNoButtons");
		}
		if (oControl.isInverted()) {
			rm.addClass("sapUiTPInverted");
			rm.addClass("sapUiInverted-CTX");
		}
		rm.writeClasses();
		
		rm.write(" aria-labelledby='", sId, "-title ", sId, "-acc' role='dialog'");
		rm.writeAttribute("tabindex", "-1");
		
		rm.write(">"); // div element
	
		rm.write("<div id='" + sId + "-arrow' class='sapUiUx3TPArrow sapUiUx3TPArrowLeft'><div class='sapUiUx3TPArrowBorder'></div></div>");
		rm.write("<span style='display:none;' id='", sId, "-acc'>");
		rm.writeEscaped(rb.getText("DIALOG_CLOSE_HELP"));
		rm.write("</span>");
	
		// write a focusable element that can be focused if there is no focusable element within the control
		// OR if the shift+tab key is used to set the focus on the last focusable element
		rm.write('<span id="' + sId + '-firstFocusable' + '" tabindex="0" class="sapUiUxTPFocus">');
		rm.write('<img src="' + sSrc + '">');
		rm.write('</span>');
	
		// title
		if (sTitle && (sTitle.length !== "")) {
			rm.write('<div class="sapUiUx3TPTitle" id="' + sId + '-title">');
			rm.write('<span class="sapUiUx3TPTitleText">');
			rm.writeEscaped(sTitle);
			rm.write('</span>');
			rm.write('</div>');
			rm.write('<div class="sapUiUx3TPTitleSep" id="' + sId + '-title-separator"></div>');
		} else { // for accessibility reasons use tooltip as hidden label
			var sTooltip = oControl.getTooltip_AsString();
			if (sTooltip) {
				rm.write("<h1 id='" + sId + "-title' style='display:none;'>");
				rm.writeEscaped(sTooltip);
				rm.write("</h1>");
			}
		}
	
		// content
		rm.write('<div id="' + sId + '-content"');
		rm.addClass("sapUiUx3TPContent");
		rm.writeClasses();
		rm.write(">");
		
		for (var i = 0; i < aContent.length; i++) {
			rm.renderControl(aContent[i]);
		}
		rm.write('</div>');
	
		// button row
		if (aButtons.length > 0) {
			rm.write('<div class="sapUiUx3TPButtonsSep" id="' + sId + '-buttons-separator"></div>');
			rm.write('<div class="sapUiUx3TPBtnRow" id="' + sId + '-buttons">');
			for (var i = 0; i < aButtons.length; i++) {
				rm.renderControl(aButtons[i].addStyleClass("sapUiUx3TPBtn"));
			}
		} else {
			// hide button row
			rm.write('<div class="sapUiUx3TPButtonsSep sapUiUx3TPButtonRowHidden" id="' + sId + '-buttons-separator"></div>');
			rm.write('<div class="sapUiUx3TPBtnRow sapUiUx3TPButtonRowHidden" id="' + sId + '-buttons">');
		}
		rm.write("</div>");
	
		// write a focusable element that can be focused when the user uses the tab-key within ToolPopup and 
		// to set the focus to the first focusable element
		rm.write('<span id="' + sId + '-lastFocusable' + '" tabindex="0" class="sapUiUxTPFocus">');
		rm.write('<img src="' + sSrc + '">');
		rm.write('</span>');
	
		rm.write("</div>");
	};
	

	return ToolPopupRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ToolPopupRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.ux3.
 */
jQuery.sap.declare('sap.ui.ux3.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.library'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/library",['jquery.sap.global', 
	'sap/ui/core/library', // library dependency
	'sap/ui/commons/library'], // library dependency
	function(jQuery) {

	"use strict";

	/**
	 * Controls that implement the SAP User Experience (UX) Guidelines 3.0
	 *
	 * @namespace
	 * @name sap.ui.ux3
	 * @author SAP SE
	 * @version 1.32.6
	 * @public
	 */
	
	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.ux3",
		version: "1.32.6",
		dependencies : ["sap.ui.core","sap.ui.commons"],
		types: [
			"sap.ui.ux3.ActionBarSocialActions",
			"sap.ui.ux3.ExactOrder",
			"sap.ui.ux3.FeederType",
			"sap.ui.ux3.FollowActionState",
			"sap.ui.ux3.NotificationBarStatus",
			"sap.ui.ux3.ShellDesignType",
			"sap.ui.ux3.ShellHeaderType",
			"sap.ui.ux3.ThingViewerHeaderType",
			"sap.ui.ux3.VisibleItemCountMode"
		],
		interfaces: [
			"sap.ui.ux3.DataSetView"
		],
		controls: [
			"sap.ui.ux3.ActionBar",
			"sap.ui.ux3.CollectionInspector",
			"sap.ui.ux3.DataSet",
			"sap.ui.ux3.DataSetSimpleView",
			"sap.ui.ux3.Exact",
			"sap.ui.ux3.ExactArea",
			"sap.ui.ux3.ExactBrowser",
			"sap.ui.ux3.ExactList",
			"sap.ui.ux3.FacetFilter",
			"sap.ui.ux3.FacetFilterList",
			"sap.ui.ux3.Feed",
			"sap.ui.ux3.FeedChunk",
			"sap.ui.ux3.Feeder",
			"sap.ui.ux3.NavigationBar",
			"sap.ui.ux3.NotificationBar",
			"sap.ui.ux3.Overlay",
			"sap.ui.ux3.OverlayContainer",
			"sap.ui.ux3.OverlayDialog",
			"sap.ui.ux3.QuickView",
			"sap.ui.ux3.Shell",
			"sap.ui.ux3.ThingInspector",
			"sap.ui.ux3.ThingViewer",
			"sap.ui.ux3.ToolPopup"
		],
		elements: [
			"sap.ui.ux3.Collection",
			"sap.ui.ux3.DataSetItem",
			"sap.ui.ux3.ExactAttribute",
			"sap.ui.ux3.NavigationItem",
			"sap.ui.ux3.Notifier",
			"sap.ui.ux3.ThingAction",
			"sap.ui.ux3.ThingGroup"
		]
	});
	
	
	/**
	 * Enumeration of available standard actions for 'sap.ui.ux3.ActionBar'. To be used as parameters for function 'sap.ui.ux3.ActionBar.getSocialAction'.
	 *
	 * @enum {string}
	 * @public
	 * @experimental Since version 1.2. 
	 * API is not yet finished and might change completely
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.ux3.ActionBarSocialActions = {
	
		/**
		 * Standard action 'Create an update' (Feed)
		 * @public
		 */
		Update : "Update",
	
		/**
		 * Standard action 'Follow/Unfollow'
		 * @public
		 */
		Follow : "Follow",
	
		/**
		 * Standard action 'Mark for Follow up'
		 * @public
		 */
		Flag : "Flag",
	
		/**
		 * Standards action 'Mark as Favorite'
		 * @public
		 */
		Favorite : "Favorite",
	
		/**
		 * Standard action 'Open Thing Inspector'
		 * @public
		 */
		Open : "Open"
	
	};
	/**
	 * 
	 *   		Marker interface for controls which are suitable as view rendering for a DataSet.
	 *   	
	 *
	 * @author SAP SE
	 * @name sap.ui.ux3.DataSetView
	 * @interface
	 * @public
	 * @ui5-metamodel This interface also will be described in the UI5 (legacy) designtime metamodel
	 */
	
	
	/**
	 * Defines the order of the sub lists of a list in the ExactBrowser.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @since 1.7.1
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.ux3.ExactOrder = {
	
		/**
		 * The order of the sub lists is defined by the selection order of the user.
		 * @public
		 */
		Select : "Select",
	
		/**
		 * The order of the sub lists is defined by order of the defined sub attributes.
		 * @public
		 */
		Fixed : "Fixed"
	
	};
	
	
	/**
	 * Type of an Feeder.
	 *
	 * @enum {string}
	 * @public
	 * @experimental Since version 1.2. 
	 * The whole Feed/Feeder API is still under discussion, significant changes are likely. Especially text presentation (e.g. @-references and formatted text) is not final. Also the Feed model topic is still open.
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.ux3.FeederType = {
	
		/**
		 * large Feeder
		 * @public
		 */
		Large : "Large",
	
		/**
		 * medium feeder
		 * @public
		 */
		Medium : "Medium",
	
		/**
		 * comment feeder (small)
		 * @public
		 */
		Comment : "Comment"
	
	};
	
	
	/**
	 * Defines the states of the follow action
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.ux3.FollowActionState = {
	
		/**
		 * follow state
		 * @public
		 */
		Follow : "Follow",
	
		/**
		 * hold state
		 * @public
		 */
		Hold : "Hold",
	
		/**
		 * default state
		 * @public
		 */
		Default : "Default"
	
	};
	
	
	/**
	 * This entries are used to set the visibility status of a NotificationBar
	 *
	 * @author SAP
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.ux3.NotificationBarStatus = {
	
		/**
		 * Default height for the bar
		 * @public
		 */
		Default : "Default",
	
		/**
		 * Bar should be minimized
		 * @public
		 */
		Min : "Min",
	
		/**
		 * Bar should be maximized
		 * @public
		 */
		Max : "Max",
	
		/**
		 * Bar should not be visible
		 * @public
		 */
		None : "None"
	
	};
	
	
	/**
	 * Available shell design types.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @since 1.12.0
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.ux3.ShellDesignType = {
	
		/**
		 * The standard Shell design (dark).
		 * @public
		 */
		Standard : "Standard",
	
		/**
		 * 
		 * A lighter design. Should be used in combination with the Standard header
		 * type.
		 * 
		 * @public
		 */
		Light : "Light",
	
		/**
		 * 
		 * An even lighter design. It borrows most of its properties from the Light
		 * design and just changes a few details like the header colors in order to
		 * have a blue design within gold reflection.
		 * 
		 * @public
		 */
		Crystal : "Crystal"
	
	};
	
	
	/**
	 * Available shell header display types.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.ux3.ShellHeaderType = {
	
		/**
		 * The standard Shell header.
		 * @public
		 */
		Standard : "Standard",
	
		/**
		 * Only the branding area is visible. Top-level navigation bar, header items, title and icon are not shown.
		 * @public
		 */
		BrandOnly : "BrandOnly",
	
		/**
		 * Like the Standard Area but without top-level navigation bar.
		 * @public
		 */
		NoNavigation : "NoNavigation",
	
		/**
		 * Like the Standard Area but with a leaner top-level navigation bar.
		 * @public
		 */
		SlimNavigation : "SlimNavigation"
	
	};
	
	
	/**
	 * Available ThingViewer header display types.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @since 1.16.3
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.ux3.ThingViewerHeaderType = {
	
		/**
		 * The standard ThingViewer header.
		 * @public
		 */
		Standard : "Standard",
	
		/**
		 * The header content is displayed horizontally above the facet content
		 * @public
		 */
		Horizontal : "Horizontal"
	
	};
	
	
	/**
	 * VisibleItemCountMode of the FacetFilter defines if the FacetFilter takes the whole available height (Auto) in the surrounding container, or is so high as needed to show 5 Items ("Fixed " - default).
	 *
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.ux3.VisibleItemCountMode = {
	
		/**
		 * The FacetFilter always has as many items in the FacetFilterList as defined in the visibleItemCount property.
		 * @public
		 */
		Fixed : "Fixed",
	
		/**
		 * The FacetFilter automatically fills the height of the surrounding container. The visibleItemCount property is automatically changed accordingly.
		 * @public
		 */
		Auto : "Auto"
	
	};

	return sap.ui.ux3;

});

}; // end of sap/ui/ux3/library.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ActionBar') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ActionBar.
jQuery.sap.declare('sap.ui.ux3.ActionBar'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ActionBar",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation', './library'],
	function(jQuery, Control, ItemNavigation, library) {
	"use strict";


	
	/**
	 * Constructor for a new ActionBar.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A special toolbar with predefined social actions which can be shown as needed. These are: Create an update (Feed), Follow, Mark for Follow Up, Mark as Favorite and Open Thing.
	 * 
	 * In addition business actions (ThingAction instances) can be added which are either displayed as MenuItems of the 'More' menu button or as individual tool bar buttons.
	 * 
	 * When using this control, please be aware that it fulfills rather specific requirements: it has been designed for and is used within composite controls QuickView and ThingInspector.
	 * @extends sap.ui.core.Control
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.ActionBar
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ActionBar = Control.extend("sap.ui.ux3.ActionBar", /** @lends sap.ui.ux3.ActionBar.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * Keeps track of the actionBars Follow/Unfollow button’s state. Its value is one of
			 * - FollowActionState.Default
			 * - FollowActionState.Follow
			 * - FollowActionState.Hold
			 */
			followState : {type : "sap.ui.ux3.FollowActionState", group : "Misc", defaultValue : sap.ui.ux3.FollowActionState.Default},
	
			/**
			 * Indicates whether “Mark for Follow Up” is active
			 */
			flagState : {type : "boolean", group : "Misc", defaultValue : null},
	
			/**
			 * Indicates whether “Favorite” is active
			 */
			favoriteState : {type : "boolean", group : "Misc", defaultValue : null},
			
			/**
			 * Indicates whether “Update” is active
			 */
			updateState : {type : "boolean", group : "Misc", defaultValue : null},
	
			/**
			 * The thing icon uri. Icon will be displayed in Feeder
			 */
			thingIconURI : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * If true, business actions are rendered as menu items of the 'More' menu button. Otherwise, 'More' menu button is only displayed for overflow and business actions are rendered as inidividual buttons.
			 */
			alwaysShowMoreMenu : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Indicates whether social action “Update” is shown, default is ‘true’
			 */
			showUpdate : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Indicates whether social action “Follow” is shown, default is ‘true’
			 */
			showFollow : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Indicates whether social action “Mark for Follow Up” is shown, default is ‘true’
			 */
			showFlag : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Indicates whether social action “Favorite” is shown, default is ‘true’
			 */
			showFavorite : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Indicates whether social action “Open” is shown, default is ‘true’
			 */
			showOpen : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * The minimum width of ActionBar's the social actions part: business action controls have to be rendered outside this area
			 */
			dividerWidth : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null}
		},
		aggregations : {
	
			/**
			 * Displayed on the actionBar's right hand-side, either as menu item under 'More' or as individual buttons
			 */
			businessActions : {type : "sap.ui.ux3.ThingAction", multiple : true, singularName : "businessAction"}, 
	
			/**
			 * Buttons for the business actions - managed by this ActionBar
			 */
			_businessActionButtons : {type : "sap.ui.commons.Button", multiple : true, singularName : "_businessActionButton", visibility : "hidden"}, 
	
			/**
			 * The social actions which are managed by this ActionBar
			 */
			_socialActions : {type : "sap.ui.ux3.ThingAction", multiple : true, singularName : "_socialAction", visibility : "hidden"}
		},
		events : {
	
			/**
			 * Fired when any of the social action’s toolbar buttons except ‘Update’ or any of the business action’s menu items resp. buttons is pressed. The selected action can be identified by its id and newState (the latter if applicable only)
			 * ‘Follow’ button + menu: id: follow, newState: Follow/Hold/Default
			 * ‘Mark for follow up’ button: id: flag, newState: true/false
			 * ‘Favorite’ button: id: favorite, newState: true/false
			 * ‘Open Thing Inspector’ button id: open
			 * Business Actions: id: the ThingAction id
			 * 
			 * For ‘Update’, please refer to event ‘feedSubmit’
			 */
			actionSelected : {
				parameters : {
	
					/**
					 * Id of selected ThingAction
					 */
					id : {type : "string"}, 
	
					/**
					 * Selected ThingAction
					 */
					action : {type : "sap.ui.ux3.ThingAction"}, 
	
					/**
					 * New State of the selected action.Only filled if the respective action maintains a state property, for example 'FollowUp' or 'Favorite'
					 */
					newState : {type : "string"}
				}
			}, 
	
			/**
			 * Fired when a new feed entry is submitted.
			 */
			feedSubmit : {
				parameters : {
	
					/**
					 * Feed text
					 */
					text : {type : "string"}
				}
			}
		}
	}});
	
	
	/**
	 * Initialization hook for the Actionbar. Creates the empty action map instance
	 * 'mActionMap' and provides the convenience member 'mActionKeys' to access static
	 * 'sap.ui.ux3.ActionBar.M_ACTION_KEYS'  
	 * 
	 * @private
	 */
	ActionBar.prototype.init = function(){
		//Initialize map which will contain the actually used ThingActions
		this.mActionMap = {};
		//Provide convenient access to the static array of action identifiers for "mActionMap"
		this.mActionKeys = sap.ui.ux3.ActionBarSocialActions;
		
		this.oRb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
		
		//Show social actions. No need to call the property setters because the prperties are true
		//by default, so there is no property change
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update), true);
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow), true);
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag), true);
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite), true);
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open), true);
		
		// Initialize the ItemNavigation if required
		if (!this._oItemNavigation) {
			this._oItemNavigation = new ItemNavigation();
			this.addDelegate(this._oItemNavigation);
		}
	};
	
	
	
	
	/**
	 * Destroys this instance of ActionBar, called by Element#destroy()
	 * 
	 * @private
	 */
	ActionBar.prototype.exit = function() {
		this.closePopups();
		
		if (this._oUpdatePopup) {
			this._oUpdatePopup.destroy();
			this._oUpdatePopup = null;
		}
		
		if (this._oMoreMenuButton) {
			this._oMoreMenuButton.destroy();
			this._oMoreMenuButton = null;
		}
		
		if (this._oMoreMenu) {
			this._oMoreMenu.destroy();
			this._oMoreMenu = null;
		}
		
		if (this._oHoldItem) {
			this._oHoldItem.destroy();
		}
		if (this._oUnFollowItem) {
			this._oUnFollowItem.destroy();
		}
		if (this._oUnHoldItem) {
			this._oUnHoldItem.destroy();
		}
		// cleanup the resize handler
		if (this._sResizeListenerId) {
			sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
			this._sResizeListenerId = null;
		}
		
		this.mActionKeys = null;
		this.mActionKeys = null;
		this.oRb = null;
		
		this.destroyAggregation("_socialActions");
		this.destroyAggregation("_businessActionButtons");
	
		if (this._oItemNavigation) {
			this.removeDelegate(this._oItemNavigation);
			this._oItemNavigation.destroy();
			delete this._oItemNavigation;
		}
	};
	
	
	
	/**
	 * Checks whether the control is still valid (is in the DOM). ActionBar
	 * instance is rendered if and only if 'isActive' returns 'true'. This
	 * check is called implicitely by the rendere, MUST not be removed.
	 *
	 * @return {boolean} True if the control is still in the active DOM
	 * @protected
	 */
	ActionBar.prototype.isActive = function() {
		var bResult = this.getDomRef() != null;
		
		return bResult;
	};
		
		
	/**
	 * Load language dependent text for given resource bundle key and optional
	 * arguments, if the resource contains dynamic content
	 *
	 * @param sKey resource bundle key
	 * @param aArgs used to fill dynamic resource content 
	 * @return the resource if it was found in the bundle or 'sKey' if no matching
	 *		 resource was available. 
	 * @private
	 */
	ActionBar.prototype._getLocalizedText = function(sKey, aArgs) {
		var sText;
		if (this.oRb) {
			sText = this.oRb.getText(sKey);
		}
		if (sText && aArgs) {
			for (var index = 0; index < aArgs.length; index++) {
				sText = sText.replace("{" + index + "}", aArgs[index]);
			}
		}
		return sText ? sText : sKey;
	};
	
	
	/**
	 * Creates a new social action for the specified 'sActionId' or returns the 
	 * pooled instance of that social action. Assumes 
	 * that 'sActionId' taken from 'this.mActionKeys', otherwise
	 * a warning will be logged and 'undefined is returned'
	 * 
	 * @param sActionId
	 * @return new or pooled instance of the specified action or 'undefined'
	 */
	ActionBar.prototype._getSocialAction = function (sActionId) {
		
		var oResult = this.mActionMap[sActionId];
		if (!oResult) {
			//no instance of the social action created for this action bar instance so far
			oResult = new sap.ui.ux3.ThingAction({id : this.getId() + "-" + sActionId});
			switch (sActionId) {
				case this.mActionKeys.Update:
					oResult.name = this.mActionKeys.Update;
					oResult.tooltipKey = "ACTIONBAR_UPDATE_ACTION_TOOLTIP";
					oResult.cssClass = "sapUiUx3ActionBarUpdateAction";
					//prepares the feeder popup 
					oResult.fnInit = function ( oActionBar ) {
						oActionBar._oUpdatePopup = new sap.ui.ux3.ToolPopup({
						id : oActionBar.getId() + "-UpdateActionPopup"
						}).addStyleClass("sapUiUx3ActionBarUpdatePopup");
						oActionBar._oUpdatePopup._ensurePopup().setAutoClose(true);
						
						oActionBar._feeder = new sap.ui.ux3.Feeder({
							id: oActionBar.getId() + "-Feeder",
							type: sap.ui.ux3.FeederType.Comment,
							thumbnailSrc : oActionBar.getThingIconURI(),
							text: "",
							submit : jQuery.proxy(
							function(oEvent) {
								var feedText = oEvent.getParameter("text");
								this.fireFeedSubmit({
									text : feedText
								});
								this._oUpdatePopup.close();
							}, oActionBar)
						});
						oActionBar._feeder.addStyleClass("sapUiUx3ActionBarFeeder");
						oActionBar._oUpdatePopup.addContent(oActionBar._feeder);
					};
					//opens or closes the feeder popup
					oResult.fnActionSelected = function (oEvent, oActionBar) {
						oActionBar._setUpdateState(!oActionBar.getUpdateState());
						if (oActionBar._oUpdatePopup.isOpen()) {
							oActionBar._oUpdatePopup.close();
						} else {
							var oDomRef, iTIHeight, iContentHeight;
							
							oActionBar._oUpdatePopup.setPosition(sap.ui.core.Popup.Dock.BeginBottom, sap.ui.core.Popup.Dock.BeginTop, oEvent.getSource().getDomRef(), "-8 -13", "none");
							oActionBar._oUpdatePopup.open();
							oDomRef = jQuery(oActionBar._oUpdatePopup.getDomRef());
							iTIHeight = jQuery(window).height();
							iContentHeight = jQuery(oActionBar.getDomRef()).offset().top;
							oDomRef.css("top", "auto").css("bottom",(iTIHeight - iContentHeight + 7) + "px");
							jQuery.sap.delayedCall(1000, this, function() {
								jQuery.sap.focus(oActionBar._feeder.getFocusDomRef());
							});
							
						}
						oActionBar._updateSocialActionDomRef(oResult);
					};
					oResult.fnExit = function( oActionBar) {
						if (oActionBar._oUpdatePopup) {
							oActionBar._oUpdatePopup.destroy();
							oActionBar._oUpdatePopup = null;
						}
					};
					oResult.fnCalculateState = function ( oActionBar ) {
						var result = null;
						if (oActionBar.getUpdateState()) {
							result = "Selected";
						}
						return result;
					};
				break;
			case this.mActionKeys.Follow:
				var followAction = oResult;
				oResult.name = this.mActionKeys.Follow;
				oResult.tooltipKey = "ACTIONBAR_FOLLOW_ACTION_TOOLTIP_FOLLOW";
				oResult.cssClass = "sapUiUx3ActionBarFollowAction";
				oResult.isMenu = function(oActionBar) {
					return oActionBar.getFollowState() != sap.ui.ux3.FollowActionState.Default;
				};
				oResult.fnActionSelected = function (oEvent, oActionBar) {
					if (oActionBar.getFollowState() == sap.ui.ux3.FollowActionState.Default) {
							//set new follow state BEFORE firing the corresponding event
							oActionBar._setFollowState(sap.ui.ux3.FollowActionState.Follow);
							oActionBar.fireActionSelected({
								id : followAction.name,
								state : "followState",
								action : followAction
							});
							
							
							this._fnPrepareFollowMenu(oEvent, oActionBar);
							
						} else {
							var eDock = sap.ui.core.Popup.Dock;
							oActionBar._oMenu.open(false, followAction.getFocusDomRef(), eDock.BeginBottom, eDock.BeginTop, followAction.getDomRef());
						}
					};
				oResult.fnCalculateState = function ( oActionBar ) {
					return oActionBar.getFollowState();
				};
				//populates the menu of the 'Follow' actionBar button depending on the 'FollowState' property
				oResult._fnPrepareFollowMenu = function( oEvent, oActionBar ) {
					var imagePath = sap.ui.resource("sap.ui.ux3", "themes/" + sap.ui.getCore().getConfiguration().getTheme());
					if (oActionBar.mActionMap[oActionBar.mActionKeys.Follow]) {
						if (!oActionBar._oUnFollowItem) {
							oActionBar._oUnFollowItem = new sap.ui.commons.MenuItem({
								id : oActionBar.getId() + "-unfollowState",
								text : oActionBar._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNFOLLOW"),
								icon : imagePath + "/img/menu_unlisten.png"
							});
						}
						if (!oActionBar._oHoldItem) {
							oActionBar._oHoldItem = new sap.ui.commons.MenuItem({
								id : oActionBar.getId() + "-holdState",
								text : oActionBar._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_HOLD"),
								icon : imagePath + "/img/menu_hold.png"
							});
						}
						if (!oActionBar._oUnHoldItem) {
							oActionBar._oUnHoldItem = new sap.ui.commons.MenuItem({
								id : oActionBar.getId() + "-unholdState",
								text : oActionBar._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNHOLD"),
								icon : imagePath + "/img/menu_follow.png"
							});
						}
						if (!oActionBar._oMenu) {
							oActionBar._oMenu = new sap.ui.commons.Menu({
								id : oActionBar.getId() + "-followActionMenu"
							});
							
							oActionBar._oMenu.attachItemSelect(jQuery.proxy(function(oControlEvent) {
								this._fnFollowMenuSelected(oControlEvent, oActionBar);
							}, this));
							oActionBar._oMenu.addItem(oActionBar._oHoldItem);
							oActionBar._oMenu.addItem(oActionBar._oUnHoldItem);
							oActionBar._oMenu.addItem(oActionBar._oUnFollowItem);
						}
						if (oActionBar.getFollowState() == sap.ui.ux3.FollowActionState.Default) {
							oActionBar.mActionMap[oActionBar.mActionKeys.Follow].setTooltip(oActionBar._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_FOLLOW"));
							oActionBar._oHoldItem.setVisible(false);
							oActionBar._oUnFollowItem.setVisible(false);
							oActionBar._oUnHoldItem.setVisible(false);
						} else if (oActionBar.getFollowState() == sap.ui.ux3.FollowActionState.Follow) {
							oActionBar.mActionMap[oActionBar.mActionKeys.Follow].setTooltip(oActionBar._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPPAUSE_FOLLOW"));
							oActionBar._oHoldItem.setVisible(true);
							oActionBar._oUnFollowItem.setVisible(true);
							oActionBar._oUnHoldItem.setVisible(false);
						} else if (oActionBar.getFollowState() == sap.ui.ux3.FollowActionState.Hold) {
							oActionBar.mActionMap[oActionBar.mActionKeys.Follow].setTooltip(oActionBar._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPCONTINUE_FOLLOW"));
							oActionBar._oHoldItem.setVisible(false);
							oActionBar._oUnFollowItem.setVisible(true);
							oActionBar._oUnHoldItem.setVisible(true);
						}
						oActionBar._updateSocialActionDomRef(oResult);
					}
				};
				//takes care of selection events in the follow menu
				oResult._fnFollowMenuSelected = function(oEvent, oActionBar) {
					if (oActionBar.mActionMap[oActionBar.mActionKeys.Follow]) {
						var sId = oEvent.getParameters().item.getId();
						//set new follow state BEFORE firing the corresponding event
						if (sId == oActionBar.getId() + "-followState") {
							oActionBar._setFollowState(sap.ui.ux3.FollowActionState.Follow);
						} else if (sId == oActionBar.getId() + "-unfollowState") {
							oActionBar._setFollowState(sap.ui.ux3.FollowActionState.Default);
						} else if (sId == oActionBar.getId() + "-holdState") {
							oActionBar._setFollowState(sap.ui.ux3.FollowActionState.Hold);
						} else if (sId + "-unholdState") {
							oActionBar._setFollowState(sap.ui.ux3.FollowActionState.Follow);
						}
						
						oActionBar.fireActionSelected({
							id : followAction.name,
							state: sId,
							action : followAction
						});
						
						this._fnPrepareFollowMenu(oEvent, oActionBar);
					}
				};
				break;
			case this.mActionKeys.Favorite:
					var favoriteAction = oResult;
					oResult.name = this.mActionKeys.Favorite;
					oResult.tooltipKey = "ACTIONBAR_FAVORITE_ACTION_TOOLTIP";
				oResult.cssClass = "sapUiUx3ActionBarFavoriteAction";
				//toggles the 'FavoriteState' property
				oResult.fnActionSelected = function (oEvent, oActionBar) {
					if (oActionBar.getFavoriteState() == true) {
							oActionBar._setFavoriteState(false);
						} else {
							oActionBar._setFavoriteState(true);
						}
						oActionBar.fireActionSelected({
							id : favoriteAction.name,
							state: oActionBar.getFavoriteState(),
							action : favoriteAction
						});
						oActionBar._updateSocialActionDomRef(oResult);
					};
					oResult.fnCalculateState = function ( oActionBar ) {
						var result = null;
						if (oActionBar.getFavoriteState()) {
							result = "Selected";
						}
						return result;
					};
					break;
			case this.mActionKeys.Flag:
				var flagAction = oResult;
				oResult.name = this.mActionKeys.Flag;
				oResult.tooltipKey = "ACTIONBAR_FLAG_ACTION_TOOLTIP";
				oResult.cssClass = "sapUiUx3ActionBarFlagAction";
				//toggles the 'FlagState' property
				oResult.fnActionSelected = function (oEvent, oActionBar) {
					oActionBar._setFlagState(!oActionBar.getFlagState());
					oActionBar.fireActionSelected({
						id : flagAction.name,
						state : oActionBar.getFlagState(),
						action : flagAction
					});
					oActionBar._updateSocialActionDomRef(oResult);
				};
				oResult.fnCalculateState = function ( oActionBar ) {
					var result = null;
					if (oActionBar.getFlagState()) {
						result = "Selected";
					}
					return result;
				};
				break;
			case this.mActionKeys.Open:
				oResult.name = this.mActionKeys.Open;
				oResult.tooltipKey = "ACTIONBAR_OPEN_THING_ACTION_TOOLTIP";
				oResult.cssClass = "sapUiUx3ActionBarOpenThingAction";
				break;
			default:
				jQuery.sap.log.warning("Function \"sap.ui.ux3.ActionBar.prototype._getSocialAction\" was called with unknown action key \"" + sActionId +
					"\".\n\tNo action will not be rendered.");
				return undefined;
			}
		}
		return oResult;
	};
		
		
		
	/*=================================================================================
	 * Re-Rendering
	 * 
	 */
	
	/**    
	  * Updates css classes and aria description for a social action    
	  *    
	  * @param oSocialAction social action to be re-rendered    
	  * @private    
	  */
	ActionBar.prototype._updateSocialActionDomRef = function(oSocialAction) {
		
		var content = oSocialAction.$();
		if (content) {
			//Replace css classes with action's standard css
			content.attr("class", oSocialAction.cssClass);
			if (oSocialAction.fnCalculateState) {
				//add state specific css classes
				content.addClass("sapUiUx3ActionBarAction");
				content.addClass(oSocialAction.fnCalculateState(this));
			}
			if (oSocialAction.name == this.mActionKeys.Update || oSocialAction.name == this.mActionKeys.Flag || oSocialAction.name == this.mActionKeys.Favorite) {
				content.attr("aria-pressed", oSocialAction.fnCalculateState(this) == "Selected" ? "true" : "false");
			}
			if (oSocialAction.isMenu) {
				//Update aria description
				content.attr("aria-haspopup", oSocialAction.isMenu(this) ? "true" : "false");
			}
		}
	};
	
	 
	
		
	/**
	 * Re-renders all content of the '-socialActions' list
	 *
	 * @private
	 */
	ActionBar.prototype._rerenderSocialActions = function() {
		var content = this.$("socialActions");
		if (content.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			sap.ui.ux3.ActionBarRenderer.renderSocialActions(rm, this);
			rm.flush(content[0]);
			rm.destroy();
		}
	};
	
	
	/**
	 * Re-renders single business action toolbar button.
	 *
	 * @param oButton business action button to be re-rendered.
	 * @private
	 */
	ActionBar.prototype._rerenderBusinessAction = function(oButton) {
		var content = oButton.$();
		if (content.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			rm.renderControl(oButton);
			rm.flush(content[0].parentNode);
			rm.destroy();
		}
	};
	
	
	/**
	 * Re-renders all content of the '-businessActions' list
	 *
	 * @private
	 */
	ActionBar.prototype._rerenderBusinessActions = function() {
		if (!this.getAlwaysShowMoreMenu()) {
			var content = this.$("businessActions");
			if (content && content.length > 0) {
				var rm = sap.ui.getCore().createRenderManager();
				sap.ui.ux3.ActionBarRenderer.renderBusinessActionButtons(rm, this);
				rm.flush(content[0]);
				rm.destroy();
			}
		}
		//make sure that more menu button's visibility is up to date
		this._onresize();
	};
	
	/*=============================================================================
	 * Overwrite setter methods for show<SocialAction> properties
	 * - setShowUpdate 
	 * - setShowFollow
	 * - setShowFlag
	 * - setShowFavorite
	 * - setShowOpen
	 *
	 * Private method _setShowSocialActionProperty to be used within these setters
	 */
	
	/*
	 * Sets follow state and triggering re-rendering
	 *
	 * @param oFollowState new state
	 */
	ActionBar.prototype.setFollowState = function(oFollowState) {
		this.setProperty("followState", oFollowState);
		//CSS 0002094039 2013: Make sure that 'Follow' action menu is available
		//if the follow state is set via API
		if (!this._oMenu) {
			var oFollowAction = this._getSocialAction(this.mActionKeys.Follow);
			oFollowAction._fnPrepareFollowMenu(null, this);
		}
		return this;
	};
	
	
	 
	/*
	 * Shows or hides standard button 'Update' on toolbar
	 *
	 * @param bFlag show or hide this social action on the toolbar
	 */
	ActionBar.prototype.setShowUpdate = function(bFlag) {
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update), bFlag);
		// supress rerendering
		this.setProperty("showUpdate", bFlag, true);
		return this;
	};
	
	/*
	 * Shows or hides standard button 'Follow' on toolbar
	 *
	 * @param bFlag show or hide this social action on the toolbar
	 */
	ActionBar.prototype.setShowFollow = function(bFlag) {
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow), bFlag);
		// supress rerendering
		this.setProperty("showFollow", bFlag, true);
		return this;
	};
	
	/*
	 * Shows or hides standard button 'Flag' on toolbar
	 *
	 * @param bFlag show or hide this social action on the toolbar
	 */
	ActionBar.prototype.setShowFlag = function(bFlag) {
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag), bFlag);
		// supress rerendering
		this.setProperty("showFlag", bFlag, true);
		return this;
	};
	
	/*
	 * Shows or hides standard button 'Favorite' on toolbar
	 *
	 * @param {boolean} bFlag show or hide this social action on the toolbar
	 */
	ActionBar.prototype.setShowFavorite = function(bFlag) {
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite), bFlag);
		// supress rerendering
		this.setProperty("showFavorite", bFlag, true);
		return this;
	};
	
	/*
	 * Shows or hides standard button 'Open' on toolbar
	 *
	 * @param {boolean} bFlag show or hide this social action on the toolbar
	 */
	ActionBar.prototype.setShowOpen = function(bFlag) {
		this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open), bFlag);
		// supress rerendering
		this.setProperty("showOpen", bFlag, true);
		return this;
	};
	
	/**
	 * Sets follow state without triggering re-rendering
	 *
	 * @param oFollowState new state
	 * @private
	 */
	ActionBar.prototype._setFollowState = function(oFollowState) {
		// supress rerendering
		this.setProperty("followState", oFollowState, true);
		return this;
	};
	
	/**
	 * Sets flag state without triggering re-rendering
	 *
	 * @param oFlagState new state
	 * @private
	 */
	ActionBar.prototype._setFlagState = function(oFlagState) {
		// supress rerendering
		this.setProperty("flagState", oFlagState, true);
		return this;
	};
	
	/**
	 * Sets update state without triggering re-rendering
	 *
	 * @param oUpdateState new state
	 * @private
	 */
	ActionBar.prototype._setUpdateState = function(oUpdateState) {
		// supress rerendering
		this.setProperty("updateState", oUpdateState, true);
		return this;
	};
	/**
	 * Sets favorite state without triggering re-rendering
	 *
	 * @param oFavoriteState new state
	 * @private
	 */
	ActionBar.prototype._setFavoriteState = function(oFavoriteState) {
		// supress rerendering
		this.setProperty("favoriteState", oFavoriteState, true);
		return this;
	};
	
	// Implementation of API method
	ActionBar.prototype.setThingIconURI = function(oIcon) {
	    // supress rendering 
		this.setProperty("thingIconURI", oIcon, true);
		var oUpdateAction = this.mActionMap[this.mActionKeys.Update];
		if (oUpdateAction && this._feeder) {
			this._feeder.setThumbnailSrc(oIcon);
		} else {
			jQuery.sap.log.warning("Function \"sap.ui.ux3.ActionBar.setThingIconURI\": failed to set new icon \"" + oIcon +
				"\".\n\tReason: either updateAction " + oUpdateAction + " or feeder " + this._feeder + " is not defined."  );
		}
		return this;
	};
	
	/*
	 * Sets the minimum width of ActionBar's the social actions part: 
	 * business action controls have to be rendered outside this area
	 *
	 * @param oWidth the new width as CSSSize
	 */
	ActionBar.prototype.setDividerWidth = function(oWidth) {
		//Make sure that minim width of social actions part is re-calculated
		this._iSocActListWidth = null;
		//do not suppress rerendering
		this.setProperty("dividerWidth", oWidth);
		return this;
	};
	
	/*
	 * Renders business actions as menu items of the 'Other Actions' 
	 * toolbar button if 'bFlag' is true. Otherwise, 'Other Actions' toolbar button disappears and 
	 * business actions are rendered as individual buttons.
	 *
	 * @param {boolean} bFlag If true, business actions are rendered as menu items of the 'Other Actions' 
	 *        toolbar button. Otherwise, 'Other Actions' toolbar button disappears and 
	 *        business actions are rendered as individual buttons.
	 */
	ActionBar.prototype.setAlwaysShowMoreMenu = function(bFlag) {
		var bOldValue = this.getProperty("alwaysShowMoreMenu");
		var businessActionsList = this.getAggregation("businessActions", []);
		this.setProperty("alwaysShowMoreMenu", bFlag, true);
		
		if (bOldValue != bFlag && businessActionsList) {
			
			if (!bFlag) {
				for (var i = 0; i < businessActionsList.length; i++) {
					var oBusinessAction = businessActionsList[i];
					this._createButtonForAction(oBusinessAction,
						this._oMoreMenu._getMenuItemForAction(oBusinessAction));
				}
			} else {
				var actionButtons = this._getBusinessActionButtons();
				for (var iIndex = 0; iIndex < actionButtons.length; iIndex++) {
					if (actionButtons[iIndex].oMenuItem) {
						actionButtons[iIndex].oMenuItem.setVisible(true);
						actionButtons[iIndex].oMenuItem = null;
					}
				}
				this.destroyAggregation("_businessActionButtons");
			}
			this._styleMoreMenuButton();
		}
		this._bCallOnresize = true;
		this._rerenderBusinessActions();
		return this;
	};
	
	/**
	 * Closes all popups which might be opened as ActionBar children
	 * These are the more- and follow menu and the feeder popup
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ActionBar.prototype.closePopups = function() {
		if (this._oUpdatePopup) {
			this._oUpdatePopup.close();
		}
		if (this._oMoreMenu) {
			this._oMoreMenu.close();
		}
		if (this._oMenu) {
			this._oMenu.close();
		}
	};
	
	/*=============================================================================
	 * Methods for aggregation '_socialActions':
	 * 
	 */
	
	
		
	/**
	 * Removes the specified social action, if it was added before
	 * and re-renders the actionbar instance. 
	 * 
	 * @param oSocialAction social action to remove from the actionbar.
	 * @return the sap.ui.ux3.ActionBar instance if 'oSocialAction' was removed successfully,
	 * null otherwise.
	 * @private
	 */
	ActionBar.prototype._removeSocialAction = function(oSocialAction) {
		//check if oSocialAction to be removed is displayed at all
		var result = null;
		if (oSocialAction.name && this.mActionMap[oSocialAction.name]) {
			//Call action's clean up method which will in turn
			//destroy any controls created by the action
			if (this.mActionMap[oSocialAction.name].fnExit) {
				this.mActionMap[oSocialAction.name].fnExit(this);
			}
			result = this.removeAggregation("_socialActions", this.mActionMap[oSocialAction.name], true);
			this.mActionMap[oSocialAction.name].destroy();
			//remove both key and value from mActionMap
			delete this.mActionMap[oSocialAction.name];
			this._rerenderSocialActions();
			this._iSocActListWidth = null; //needs to be re-calculated
		}
		return result;
	};
	
	/**
	 * Removes all social actions and re-renders the actionbar instance. 
	 * 
	 * @return the sap.ui.ux3.ActionBar instance
	 * @private
	 */
	ActionBar.prototype._removeAllSocialActions = function() {
		//clear actionMap
		for (var key in this.mActionMap) {
			if (this.mActionMap[key] && this.mActionMap[key].fnExit) {
				this.mActionMap[key].fnExit(this);
			}
		}
		this.mActionMap = {};
		var result = this.removeAllAggregation("_socialActions", true);
		this._iSocActListWidth = null; //needs to be re-calculated
		this._rerenderSocialActions();
		return result;
	};
	
	
	/**
	 * Checks if given 'oSocialAction' has already been added. If not, it is passed on
	 * to private method 'sap.ui.ux3.ActionBar.prototype._prepareSocialAction'. After that,
	 * the action's 'fnInit' exit is called, if it is defined.
	 * 
	 * @param oSocialAction social action to add to the actionbar
	 * @param iIndex position at which new action shall be inserted. If not defined, new action will be appended
	 *		to the end od the aggregation.
	 * @return sap.ui.ux3.ActionBar the sap.ui.ux3.ActionBar instance if 'oSocialAction' was added successfully,
	 * null otherwise.
	 * @private
	 * @see sap.ui.ux3.ActionBar.prototype._prepareSocialAction 
	 */
	ActionBar.prototype._addSocialAction = function(oSocialAction, iIndex) {
		//make sure that each social action is only added once
		//duplicates are useless in this case
		var result = null;
		if (!this.mActionMap[oSocialAction.name]) {
			result = this._prepareSocialAction(oSocialAction, iIndex);
		
			if ( oSocialAction.fnInit ) {
				// call the action's 'fnInit' exit
				oSocialAction.fnInit(this);
			}
			this._iSocActListWidth = null; //needs to be re-calculated
		}
		if (result) {
			//Only if social action was actually added, the actionbar is 
			//rendered again 
			this._rerenderSocialActions();
		}
		return result;
	};
	
		
	/**
	 * Attaches a 'Select' listener to the passed in 'oSocialAction', which will call the
	 * actions 'fnActionSelected'. Uses the action's tooltip key to generate the i18n tooltip
	 * text of the action's button. Finally, adds 'oSocialAction' to the actionbar's 
	 * action map and its '_socialActions' aggregation.
	 *
	 * @param oSocialAction social action to add to the actionbar.
	 * @param iIndex position at which new action shall be inserted. If not defined, new action will be appended
	 *		to the end od the aggregation.
	 * @return sap.ui.ux3.ActionBar the sap.ui.ux3.ActionBar instance 
	 * @private
	 */
	ActionBar.prototype._prepareSocialAction = function(oSocialAction, iIndex) {
		
		// if 'Select' event is triggered on the action (this is done by a 'press' event
		// on the action's toolbar button'), the action's 'fnActionSelected' function is 
		// executed
		oSocialAction.attachSelect(jQuery.proxy(function(oControlEvent) {
			if (oSocialAction.fnActionSelected) {
				oSocialAction.fnActionSelected(oControlEvent, this);
			} else {
				this.fireActionSelected({
					id : oSocialAction.name,
					action : oSocialAction
				});
			}
		}, this));
		oSocialAction.setTooltip(this._getLocalizedText(oSocialAction.tooltipKey));
		this.mActionMap[oSocialAction.name] = oSocialAction;
		if (iIndex) {
			this.insertAggregation("_socialActions", oSocialAction, iIndex, true);
		} else {
			this.addAggregation("_socialActions", oSocialAction, true);
		}
		
		return oSocialAction;
	};
	
	/**
	 * Calls '_addSocialAction' or '_removeSocialAction' depending on 'bFlag'.
	 *
	 * @param oSocialAction social action to deal with.
	 * @param bFlag show the action or not.
	 * @return the sap.ui.ux3.ActionBar instance 
	 * @see sap.ui.ux3.ActionBar._addSocialAction
	 * @see sap.ui.ux3.ActionBar._removeSocialAction  
	 * @private
	 */
	ActionBar.prototype._setShowSocialAction = function (oSocialAction, bFlag) {
		return bFlag ? this._addSocialAction(oSocialAction) : this._removeSocialAction(oSocialAction);
	};
	
	/*=============================================================================
	 * Implementation of generated API methods for aggregation 'businessActions':
	 * - addBusinessAction 
	 * - insertBusinessAction
	 * - removeBusinessAction
	 * - removeAllBusinessActions
	 */
	
	/**
	 * Implementation of API method addBusinessAction.
	 * 
	 * @param oBusinessAction business action to be added 
	 * @return sap.ui.ux3.ActionBar the sap.ui.ux3.ActionBar instance 
	 */
	ActionBar.prototype.addBusinessAction = function(oBusinessAction) {
		return this._addBusinessAction(oBusinessAction);
	};
	
	/**
	 * Implementation of API method insertBusinessAction.
	 * 
	 * @param oBusinessAction business action to be added 
	 * @param iIndex position at which the business action is to be displayed amidst the 
	 *		other business actions 
	 * @return sap.ui.ux3.ActionBar the sap.ui.ux3.ActionBar instance 
	 */
	ActionBar.prototype.insertBusinessAction = function(oBusinessAction, iIndex) {
		return this._addBusinessAction(oBusinessAction, iIndex);
	};
	
	/**
	 * Implementation of API method removeBusinessAction.
	 * 
	 * @param oBusinessAction business action to be removed 
	 * @return sap.ui.ux3.ActionBar the sap.ui.ux3.ActionBar instance 
	 */
	ActionBar.prototype.removeBusinessAction = function(oBusinessAction) {
		return this._removeBusinessAction(oBusinessAction, true);
	};
	
	/**
	 * Removes oBusinessAction and cleans up corresponding menu item
	 * and buttons. Calls rerenderBusinessActions if param 'bRerender' is true
	 * 
	 * @param oBusinessAction business action to be removed 
	 * @param bRerender if this flag is set, business actions are re-rendered.
	 * @return sap.ui.ux3.ActionBar the sap.ui.ux3.ActionBar instance 
	 * @private
	 */
	ActionBar.prototype._removeBusinessAction = function(oBusinessAction, bRerender) {
			
		//Make sure that remove works for action Ids as well
		//CSN 0001948046 2013
		if (typeof oBusinessAction === "string") {
			var oCorrespondingAction;
			var sActionId = oBusinessAction;
			for (var i = 0; i < this.getBusinessActions().length; i++) {
				var oAction = this.getBusinessActions()[i];
				if (oAction.getId() === sActionId) {
					oCorrespondingAction = oAction;
					break;
				}
			}
			oBusinessAction = oCorrespondingAction;
		}
		
		if (this._oMoreMenu) {
			var oMenuItem = this._oMoreMenu._getMenuItemForAction(oBusinessAction);
			if (oMenuItem) {
				this._oMoreMenu.removeItem(oMenuItem);
				oMenuItem.destroy();
			}
			
			// Check if there are any menu items left. If not,
			// destroy the 'More' menu and corresponding menu button
			if (this._oMoreMenu.getItems().length == 0) {
				this._oMoreMenuButton.destroy();
				this._oMoreMenuButton = null;
				this._oMoreMenu.destroy();
				this._oMoreMenu = null;
			}
		}
		
		if (!this.getAlwaysShowMoreMenu()) {
			var oButton = this._getButtonForAction(oBusinessAction);
			if (oButton) {
				
				this.removeAggregation("_businessActionButtons", oButton, true);
				oButton.destroy();
			}
		}
		// do not use flag'bRerender' as parameter here since
		// only the businessActionButtons section shall be
		// rendered. This is taken care of at the end of this 
		// function
		var result = this.removeAggregation("businessActions", oBusinessAction, true);
		if (bRerender) {
			this._rerenderBusinessActions();
		}
		return result;
	};
	
	/**
	 * Implementation of API method removeAllBusinessAction.
	 * 
	 * @return sap.ui.ux3.ActionBar the ActionBar instance for method chaining 
	 */
	ActionBar.prototype.removeAllBusinessActions = function() {
		var businessActionsList = this.getAggregation("businessActions", []);
		if (businessActionsList) {
			for (var i = 0; i < businessActionsList.length; i++) {
				//Call '_removeBusinessAction' individually for each
				//action since that function contains the logic for cleaning
				//up menu items and menus
				//do not re-render inidividually but once and for all at the
				//method's end
				this._removeBusinessAction(businessActionsList[i], false);
			}
		}
		this._rerenderBusinessActions();
		var result = this.removeAllAggregation("businessActions", true);
		return result;
	};
	
	/**
	 * Implementation of API method destroyBusinessActions.
	 * 
	 * @return sap.ui.ux3.ActionBar the ActionBar instance for method chaining
	 */
	ActionBar.prototype.destroyBusinessActions = function() {
		
		var businessActionsList = this.getAggregation("businessActions", []);
		if (businessActionsList) {
			for (var i = 0; i < businessActionsList.length; i++) {
				//Call '_removeBusinessAction' individually for each
				//action since that function contains the logic for cleaning
				//up menu items and menus
				//do not re-render inidividually but once and for all at the
				//method's end
				var aChildren = this._removeBusinessAction(businessActionsList[i], false);
				//destroy each business action
				if (aChildren instanceof sap.ui.core.Element) {
					aChildren.destroy(true);
				}
			}
		}
		this._rerenderBusinessActions();
		var result = this.destroyAggregation("businessActions", true);
		return result;
	};
	
	/**
	 * Returns the aggregation for the business action buttons
	 * @private  
	 */
	ActionBar.prototype._getBusinessActionButtons = function() {
		return this.getAggregation("_businessActionButtons", []);
	};
	
	/**
	 * Checks if property 'showBusinessActionsMenu' is set. If so, it first checks if the 
	 * 'Other Actions' toolbar button is available and creates it if necessary. After that
	 * it adds the new business action as a menu item to the 'Other Actions' toolbar button.
	 * If the flag is not set, the a new '_businessActionButton' is created which is added to the
	 * private aggregation '_businessActionButtons'. If an 'iIndex' is present, it is taken into
	 * consideration in all of these cases.
	 * 
	 * @param oBusinessAction business action to be added 
	 * @param iIndex position at which new action shall be inserted. If not defined, new action will be appended
	 *		to the end of the aggregation.
	 * @return sap.ui.ux3.ActionBar the sap.ui.ux3.ActionBar instance 
	 * @private
	 */
	ActionBar.prototype._addBusinessAction = function(oBusinessAction, iIndex) {
		
		var result;
		
		if (!iIndex && iIndex != 0) {
			result = this.addAggregation("businessActions", oBusinessAction, true);
		} else {
			result = this.insertAggregation("businessActions", oBusinessAction, iIndex, true);
		}
		
		// Prepare the 'Other Actions' toolbar button and add business actions as menu items to the 
		// 'Other Actions' toolbar button
		if (!this._oMoreMenuButton) {
			this._oMoreMenuButton = new sap.ui.commons.MenuButton(this.getId() + "-MoreMenuButton");
			this._oMoreMenuButton.setText(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TEXT"));
			this._oMoreMenuButton.setTooltip(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP"));
			var eDock = sap.ui.core.Popup.Dock;
			
			//make sure menu is displayed OVER the more button and towards the inside of the containing
			//control
			this._oMoreMenuButton.setDockButton(eDock.EndTop);
			this._oMoreMenuButton.setDockMenu(eDock.EndBottom);
			
			this._styleMoreMenuButton();
			
			this._oMoreMenu = new sap.ui.commons.Menu(this.getId() + "-MoreMenu", {
				ariaDescription: this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP")
			});
			
			this._oMoreMenu._getMenuItemForAction = function (oAction) {
				for (var i = 0; i < this.getItems().length; i++) {
					var oMenuItem = this.getItems()[i];
					if (oMenuItem.action == oAction) {
						return oMenuItem;
					}
				}
				return null;
			};
			
			this._oMoreMenuButton.setMenu(this._oMoreMenu);
		}
		var sMenuItemID = this._oMoreMenu.getId() + "-MenuItem-" + oBusinessAction.getId();
		var oMenuItem = new sap.ui.commons.MenuItem( sMenuItemID, {text: oBusinessAction.getText(), enabled: oBusinessAction.getEnabled()});
		oMenuItem.action = oBusinessAction;
		oMenuItem.attachSelect(jQuery.proxy(function (oControlEvent) {
			this.fireActionSelected({
				id : oBusinessAction.getId(),
				action : oBusinessAction
			});
		}, this));
		
		if (iIndex) {
			this._oMoreMenu.insertItem(oMenuItem, iIndex);
		} else {
			this._oMoreMenu.addItem(oMenuItem);
		}
		
		this._createButtonForAction(oBusinessAction, oMenuItem, iIndex);
		this._rerenderBusinessActions();
		return result;
	};
	
	/**
	 * Returns the "More" menu button or null, if it has not been created.
	 *
	 * @return the "More" menu button 
	 */
	ActionBar.prototype._getMoreMenuButton = function() {
		return this._oMoreMenuButton;
	};
	
	
	/**
	 * Will be called by the ResizeHandler listening to size changes of the actionBar
	 * control depending on the DOM element or window size changes.
	 * If the "alwaysShowMoreMenu" property is not set, this will check if there is
	 * enough room to render the business actions individually (it does so by checking the
	 * vertical offset of the businessActions' div).
	 * If there is not enough room, the "Other Actions" toolbar button is displayed even 
	 * though "alwaysShowMoreMenu" is not set
	 *
	 * @private  
	 */
	ActionBar.prototype._onresize = function(oEvent) {
	
		//set min width for action bar
		var oActionBarDomRef = this.$();
		
		if (oActionBarDomRef) {
			var sActionBarMinWidth = this.getActionBarMinWidth() + "px";
		
			if (oActionBarDomRef.css('minWidth') != sActionBarMinWidth) {
				oActionBarDomRef.css('minWidth', sActionBarMinWidth);
			}
		}
		
		if (!this.getAlwaysShowMoreMenu() && this._oMoreMenuButton ) {
			//Only show 'More' menu button if there is more than one business action
			var bShowMoreMenuButton = false;
			if ( this._getBusinessActionButtons().length > 1) {
				var iMoreMenuButtonWidth = this._oMoreMenuButton.$().outerWidth();
				
				var iMaxButtonsWidth = oActionBarDomRef.outerWidth()
					- this._getSocialActionListMinWidth()
					- iMoreMenuButtonWidth;
				var actionButtons = this._getBusinessActionButtons();
				
				var iButtonWidth = 0;
				
				for (var iIndex = 0; iIndex < actionButtons.length; iIndex++) {
					var oIthButtonDomRef = actionButtons[iIndex].$().parent();
					iButtonWidth += oIthButtonDomRef.outerWidth();
					if (iIndex == actionButtons.length - 1) {
						//special treatment for last button since it toggles with more menu button
						iButtonWidth -= iMoreMenuButtonWidth;
					}
					
					if (iButtonWidth >= iMaxButtonsWidth) {
						if (oIthButtonDomRef.length > 0) {
							oIthButtonDomRef.css('display', 'none');
							if (actionButtons[iIndex].oMenuItem) {
								actionButtons[iIndex].oMenuItem.setVisible(true);
							}
							//There is at least one business action whose button does not fit
							//so show the 'More' button
							bShowMoreMenuButton = true;
						}
					} else {
						if (oIthButtonDomRef.length > 0) {
							oIthButtonDomRef.css('display', '');
							//due to problems in ie8
							if (!!sap.ui.Device.browser.internet_explorer) {
								this._rerenderBusinessAction(actionButtons[iIndex]);
							}
							if (actionButtons[iIndex].oMenuItem) {
								actionButtons[iIndex].oMenuItem.setVisible(false);
							}
						}
					}
				}
				
				//if there is more business actions than action buttons, there is at least
				//one business action which shall only be displayed in the 'More' menu.
				//In that case, the 'More' menu button MUST be displayed
				bShowMoreMenuButton |= this.getAggregation("businessActions").length > actionButtons.length;
			}
			
			var oMoreMenuButtonDomRef = this._oMoreMenuButton.$().parent();
			if (oMoreMenuButtonDomRef.length > 0) {
				bShowMoreMenuButton ? oMoreMenuButtonDomRef.css('display', '') : oMoreMenuButtonDomRef.css('display', 'none');
			}
			if (!bShowMoreMenuButton && this._oMoreMenu) {
				this._oMoreMenu.close();
			}
		}
		this._setItemNavigation();
		
	};
	
	/**
	 * Rerendering handling
	 * @private
	 */
	ActionBar.prototype.onBeforeRendering = function() {
		sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
		this._sResizeListenerId = null;
	};
	
	/**
	 * Rerendering handling
	 * @private
	 */
	ActionBar.prototype.onAfterRendering = function() {
		// listen to resize events of the browser (or surrounding DOM elements)
		this._sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(), jQuery.proxy(this._onresize, this));
		if (this._bCallOnresize) {
			this._onresize();
		}
		//make sure that buttons are ready for keyboard navigation
		//this is usually done within 'resize' but we have to make sure that '_setItemNavigation' called
		//at least once
		this._setItemNavigation();
	};
	
	
	/**
	 * Get the min width of the social action list
	 * @return min width of the social action list
	 * @private
	 */
	ActionBar.prototype._getSocialActionListMinWidth = function() {
		//determine minimum width for actionBar and socialActionsList
		
		if (!this._iSocActListWidth) {
			if (this.getDividerWidth()) {
				this._iSocActListWidth = parseInt(this.getDividerWidth(), 10);
			} else {
				// min width of the social actions part is determined by the number of 
				// actually displayed social actions
				
				var oSocialActions = this.getAggregation("_socialActions", []);
				var iActionCount = oSocialActions.length;
				this._iSocActListWidth = 24 * iActionCount + 12; //add some padding
			}
		}
		return this._iSocActListWidth;
	};
	
	/**
	 * Get the min width of the social action list and add the width of the "More" button
	 * @return min width of ActionBar
	 */
	ActionBar.prototype.getActionBarMinWidth = function() {
		
		var iResult = this._getSocialActionListMinWidth();
		var oRightControl = this._oMoreMenuButton;
		if (!this.getAlwaysShowMoreMenu() &&  this._getBusinessActionButtons().length == 1) {
			//If there is exactly one business action it is always displayed
			oRightControl = this._getBusinessActionButtons()[0];
		}
		if (oRightControl) {
			// use parent's outer width because the menu button's outer width
			// has turned out to change, depending on the speed in which you resize 
			// the browser window.
			var oParentDomRef =  oRightControl.$().parent();
			if (oParentDomRef) {
				iResult += oParentDomRef.outerWidth() - 3; //substract left padding
			}
		}
		return iResult;
	};
	
	/**
	 * Delivers action button for a specified action
	 * @param oAction the action for which the button should be found
	 * @return button for specified action
	 * @private
	 */
	ActionBar.prototype._getButtonForAction = function(oAction) {
		for (var i = 0; i < this._getBusinessActionButtons().length; i++) {
			var oButton = this._getBusinessActionButtons()[i];
			if (oButton.action == oAction) {
				return oButton;
			}
		}
		return null;
	};
	
	/**
	 * Creates an action button for a specified action if 
	 * @param oBusinessAction the action for which the button should be found
	 * @param oMenuItem menu item which corresponds to the button
	 * @param iIndex position at which button shall be shown
	 * @return new button for specified action
	 * @private
	 */
	ActionBar.prototype._createButtonForAction = function(oBusinessAction, oMenuItem, iIndex) {
		if (!this.getAlwaysShowMoreMenu() && !oBusinessAction.showInMoreMenu) {
			// Add business actions as individual buttons
			var oButton = new sap.ui.commons.Button({
				id : this.getId() + "-" + oBusinessAction.getId() + "Button",
				text : oBusinessAction.getText(),
				tooltip : oBusinessAction.getTooltip(),
				enabled : oBusinessAction.getEnabled()
			});
			
			oButton.attachPress(jQuery.proxy(function(oControlEvent) {
				this.fireActionSelected({
					id : oBusinessAction.getId(),
					action : oBusinessAction
				});
			}, this));
			//Link menu item to new button
			oButton.oMenuItem = oMenuItem;
			oButton.action = oBusinessAction;
			
			if (iIndex) {
				this.insertAggregation("_businessActionButtons", oButton, iIndex, true);
			} else {
				this.addAggregation("_businessActionButtons", oButton, true);
			}
			return oButton;
		}
		return null;
			
	};
	
	/**
	 * Changes css class of 'More' menu button depending on whether 'alwaysShowMoreMenu'
	 * property is set. If business actions are always displayed in the menu, 
	 * it should be rendered as a lite button.
	 * 
	 * @private
	 */
	ActionBar.prototype._styleMoreMenuButton = function() {
	    if (this._oMoreMenuButton) {
				if (this.getAlwaysShowMoreMenu()) {
				this._oMoreMenuButton.setLite(true);
				//button styling differs from standard lite button: normal font and black color
				this._oMoreMenuButton.addStyleClass("sapUiUx3ActionBarLiteMoreButton");
			}	else {
				this._oMoreMenuButton.setLite(false);
				this._oMoreMenuButton.removeStyleClass("sapUiUx3ActionBarLiteMoreButton");
			}
	    }
	};
	
	
	
	/**
	 * Add Social- and Business Actions to ItemNavigation
	 *
	 * @private
	 */
	ActionBar.prototype._setItemNavigation = function() {
	
		if (this.getDomRef()) {
			
			this._oItemNavigation.setRootDomRef(jQuery(this.getDomRef()).get(0));
			// only if already rendered, otherwise not DOM elements exists
			var aItemDomRefs = [];
			var oActions = this.getAggregation("_socialActions", []);
			for ( var i = 0; i < oActions.length; i++) {
				aItemDomRefs.push(oActions[i].getDomRef());
			}
			oActions = this.getAggregation("_businessActionButtons", []);
			for ( var i = 0; i < oActions.length; i++) {
				aItemDomRefs.push(oActions[i].getDomRef());
			}
			if (this._oMoreMenuButton && this._oMoreMenuButton.getDomRef()) {
				aItemDomRefs.push(this._oMoreMenuButton.getDomRef());
			}
			this._oItemNavigation.setItemDomRefs(aItemDomRefs);
		}
	};
	
	/**
	 * ActionBar invalidation: If ThingActions get invalidated the action buttons/items need to be updated 
	 *
	 * @private
	 */
	ActionBar.prototype.invalidate = function(oControl) {
		if (oControl instanceof sap.ui.ux3.ThingAction) {
			var oBusinessActionButton = sap.ui.getCore().byId(this.getId() + "-" + oControl.getId() + "Button");
			var oBusinessMenuItem = this._oMoreMenu && this._oMoreMenu._getMenuItemForAction(oControl);
			if (oBusinessActionButton) {
				oBusinessActionButton.setTooltip(oControl.getTooltip());
				oBusinessActionButton.setText(oControl.getText());
				oBusinessActionButton.setEnabled(oControl.getEnabled());
			}
			if (oBusinessMenuItem) {
				oBusinessMenuItem.setTooltip(oControl.getTooltip());
				oBusinessMenuItem.setText(oControl.getText());
				oBusinessMenuItem.setEnabled(oControl.getEnabled());
			}
			if (!oBusinessActionButton && !oBusinessMenuItem) {
				//the social actions are ThingActions too, but they need no special treatment
				Control.prototype.invalidate.apply(this,arguments);
			}
		}
		Control.prototype.invalidate.apply(this,arguments);
	};

	return ActionBar;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ActionBar.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.Collection') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.Collection.
jQuery.sap.declare('sap.ui.ux3.Collection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.SelectionModel'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/Collection",['jquery.sap.global', 'sap/ui/core/Element', 'sap/ui/model/SelectionModel', './library'],
	function(jQuery, Element, SelectionModel, library) {
	"use strict";


	
	/**
	 * Constructor for a new Collection.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Collection
	 * @extends sap.ui.core.Element
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @since 1.9.0
	 * @alias sap.ui.ux3.Collection
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Collection = Element.extend("sap.ui.ux3.Collection", /** @lends sap.ui.ux3.Collection.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * Name for the collection
			 */
			title : {type : "string", group : "Appearance", defaultValue : null},
	
			/**
			 * If a collection is editable an edit button will be displayed below the list of items
			 */
			editable : {type : "boolean", group : "Appearance", defaultValue : false},
	
			/**
			 * Allow multi selection of items in collection
			 */
			multiSelection : {type : "boolean", group : "Accessibility", defaultValue : false}
		},
		aggregations : {
	
			/**
			 * Items in the collection
			 */
			items : {type : "sap.ui.core.Item", multiple : true, singularName : "item"}
		},
		associations : {
	
			/**
			 * Contains all items that are currently selected
			 */
			selectedItems : {type : "sap.ui.core.Item", multiple : true, singularName : "selectedItem"}
		},
		events : {
	
			/**
			 * Fired when ever the selected items changer
			 */
			selectionChanged : {}, 
	
			/**
			 * Fires if a property has changed, and the collection inspector needs to do something after that
			 */
			propertyChanged : {}
		}
	}});
	
	
	
	Collection.prototype.init = function() {
		this.oCollectionSelection = new SelectionModel(SelectionModel.SINGLE_SELECTION);
	};
	
	/*
	 * Set multi selection for selection model
	 *
	 * @param {boolean} bMultiSelection
	 * @public
	 */
	Collection.prototype.setMultiSelection = function(bMultiSelection) {
		if (bMultiSelection) {
			this.oCollectionSelection.setSelectionMode(SelectionModel.MULTI_SELECTION);
		} else {
			this.oCollectionSelection.setSelectionMode(SelectionModel.SINGLE_SELECTION);
			this.removeAllSelectedItems();
		}
		return this.setProperty("multiSelection",bMultiSelection);
	};
	
	/*
	 * Set editable
	 *
	 * @param {boolean} bEditable
	 * @public
	 */
	Collection.prototype.setEditable = function(bEditable) {
		this.setProperty("editable",bEditable,true);
		this.firePropertyChanged();
	};
	
	/*
	 * Set title
	 *
	 * @param {string} sTitle
	 * @public
	 */
	Collection.prototype.setTitle = function(sTitle) {
		this.setProperty("title",sTitle);
		this.fireEvent('_titleChanged', { newTitle: this.getProperty("title") });
	};
	
	
	/**
	 *
	 * @param {string | sap.ui.core.Item} vSelectedItem
	 *    Id of a selectedItem which becomes an additional target of this <code>selectedItems</code> association.
	 *    Alternatively, a selectedItem instance may be given. 
	 * @return {sap.ui.ux3.Collection} <code>this</code> to allow method chaining
	 * @public
	 */
	Collection.prototype.addSelectedItem = function(vSelectedItem) {
		var oSelectedItem;
		if (typeof vSelectedItem == "object") {
			oSelectedItem = vSelectedItem;
		} else {
			oSelectedItem = sap.ui.getCore().byId(vSelectedItem);
		}
		if (jQuery.inArray(oSelectedItem.getId(),this.getSelectedItems()) >= 0) {
			return this;
		}
		var iIndex = this.indexOfItem(oSelectedItem);
		if (iIndex > -1) {
			if (this.oCollectionSelection.getSelectionMode() == SelectionModel.SINGLE_SELECTION) {
				this.removeAllAssociation("selectedItems",true);
				this.oCollectionSelection.clearSelection();
			}
			this.oCollectionSelection.addSelectionInterval(iIndex,iIndex);
		}
		this.addAssociation("selectedItems",vSelectedItem,true);
		this.fireSelectionChanged();
		return this;
	};
	
	/**
	 * @param {int | string | sap.ui.core.Item} vSelectedItem the selectedItem to remove or its index or id
	 * @return {string} the id of the removed selectedItem or null
	 * @public
	 */
	Collection.prototype.removeSelectedItem = function(vSelectedItem) {
		//Don't remove the item if there is only one item selected
		if (this.getSelectedItems().length <= 1) {
			return;
		}
		var sRemovedObject = this.removeAssociation("selectedItems",vSelectedItem,true);
		var iIndex;
		if (typeof vSelectedItem == "object") {
			iIndex = this.indexOfItem(vSelectedItem);
		} else {
			iIndex = this.indexOfItem(sap.ui.getCore().byId(vSelectedItem));
		}
		if (iIndex > -1) {
			this.oCollectionSelection.removeSelectionInterval(iIndex,iIndex);
		}
		this.fireSelectionChanged();
		return sRemovedObject;
	};
	
	/**
	 * @return {string[]} an array with the ids of the removed elements (might be empty)
	 * @public
	 */
	Collection.prototype.removeAllSelectedItems = function() {
		var aRemovedObjects = this.removeAllAssociation("selectedItems",true);
		this.oCollectionSelection.clearSelection();
		if (this.getItems().length > 0) {
			this.addSelectedItem(this.getItems()[0]);
		} else {
			this.fireSelectionChanged();
		}
		return aRemovedObjects;
	};

	return Collection;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/Collection.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.CollectionInspector') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.CollectionInspector.
jQuery.sap.declare('sap.ui.ux3.CollectionInspector'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/CollectionInspector",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation', './library'],
	function(jQuery, Control, ItemNavigation, library) {
	"use strict";


	
	/**
	 * Constructor for a new CollectionInspector.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * CollectionInspector
	 * @extends sap.ui.core.Control
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @since 1.9.0
	 * @alias sap.ui.ux3.CollectionInspector
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var CollectionInspector = Control.extend("sap.ui.ux3.CollectionInspector", /** @lends sap.ui.ux3.CollectionInspector.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * Defines if the list of collection items is visible on the left
			 */
			sidebarVisible : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * If set to true, control will fit parents content area
			 */
			fitParent : {type : "boolean", group : "Appearance", defaultValue : true}
		},
		aggregations : {
	
			/**
			 * Collections which are displayed in the COllectionInspector
			 */
			collections : {type : "sap.ui.ux3.Collection", multiple : true, singularName : "collection"}, 
	
			/**
			 * All controls that are currently displayed
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
		},
		associations : {
	
			/**
			 * Collection which is currently selected
			 */
			selectedCollection : {type : "sap.ui.ux3.Collection", multiple : false}
		},
		events : {
	
			/**
			 * Event is fired if user selects a collection
			 */
			collectionSelected : {}, 
	
			/**
			 * Fires when an item in a collection is selected
			 */
			itemSelectionChanged : {}, 
	
			/**
			 * Fires when the edit button is clicked
			 */
			editCollection : {}
		}
	}});
	
	
	/**
	 * Initialization the control
	 *
	 * @private
	 */
	CollectionInspector.prototype.init = function() {
	
		var that = this;
	
		if (!this._oItemNavigation) {
			this._oItemNavigation = new ItemNavigation();
			this._oItemNavigation.setCycling(false);
			this.addDelegate(this._oItemNavigation);
		}
	
		var oToggleButton = new sap.ui.commons.ToggleButton(this.getId() + "-toggleButton");
		oToggleButton.setParent(this);
		oToggleButton.setTooltip("This button opens and closes the sidebar");
		oToggleButton.attachPress(function() {
			if (oToggleButton.getPressed()) {
				that.openSidebar();
			} else {
				that.closeSidebar();
			}
		});
		this._oToggleButton = oToggleButton;
	
		var oCollectionSelector = new sap.ui.commons.SegmentedButton(this.getId() + "-selector");
	
		oCollectionSelector.attachSelect(function(oEvent) {
			var iCollectionIndex = this.indexOfButton(sap.ui.getCore().byId(this.getSelectedButton()));
			var oCollection = that.getCollections()[iCollectionIndex];
			that.setSelectedCollection(oCollection);
			that.fireCollectionSelected({
				collection: oCollection
			});
			that.openSidebar();
		});
	
		this._oCollectionSelector = oCollectionSelector;
	
		var oEditButton = new sap.ui.commons.Button();
		oEditButton.addStyleClass("sapUiUx3EditCollectionButton");
		oEditButton.setText("Collection");
		oEditButton.setTooltip("This button opens an edit dialog for the current collection");
		oEditButton.attachPress(function() {
			that.fireEditCollection();
		});
		this._oEditButton = oEditButton;
	};
	
	/**
	 * Destroys elements created by the control
	 *
	 * @private
	 */
	CollectionInspector.prototype.exit = function() {
		this._oToggleButton.destroy();
		this._oToggleButton = null;
		this._oEditButton.destroy();
		this._oEditButton = null;
		this._oCollectionSelector.destroy();
		this._oCollectionSelector = null;
		if (this._oItemNavigation) {
			this.removeDelegate(this._oItemNavigation);
			this._oItemNavigation.destroy();
			delete this._oItemNavigation;
		}
	};
	
	/**
	 * called before the control will be rendered
	 *
	 * @private
	 */
	CollectionInspector.prototype.onBeforeRendering = function() {
		this._oToggleButton.setPressed(this.getSidebarVisible());
	};
	
	/**
	 * called after control has been rendered
	 *
	 * @private
	 */
	CollectionInspector.prototype.onAfterRendering = function() {
		if (!this.getSelectedCollection()) {
			if (this.getCollections().length > 0) {
				this.setSelectedCollection(this.getCollections()[0]);
			}
		} else {
			var oSelectedCollection = sap.ui.getCore().byId(this.getSelectedCollection());
			if (oSelectedCollection.getSelectedItems().length == 0 && oSelectedCollection.getItems().length > 0) {
				oSelectedCollection.addSelectedItem(oSelectedCollection.getItems()[0]);
			}
		}
		this.setElementsHeight();
		this.updateItemNavigation();
		this.refreshSelectionHighlighting();
	};
	
	/**
	 * called when the control is clicked
	 *
	 * @private
	 */
	CollectionInspector.prototype.onclick = function(oEvent) {
		var oTarget = oEvent.target;
		if (jQuery(oTarget).hasClass("sapUiUx3CICollectionListItem")) {
			var oSelectedCollection = sap.ui.getCore().byId(this.getSelectedCollection());
			if (jQuery.inArray(oTarget.id,oSelectedCollection.getSelectedItems()) >= 0) {
				oSelectedCollection.removeSelectedItem(oTarget.id);
			} else {
				oSelectedCollection.addSelectedItem(oTarget.id);
			}
			this.refreshSelectionHighlighting();
			this.fireItemSelectionChanged({
				selectedItems: oSelectedCollection.getSelectedItems()
			});
		}
	};
	
	
	/**
	 * returns instance of toggle button
	 *
	 * @private
	 */
	CollectionInspector.prototype.getToggleButton = function() {
		return this._oToggleButton;
	};
	
	/**
	 * returns instance of collection selector
	 *
	 * @private
	 */
	CollectionInspector.prototype.getCollectionSelector = function() {
		return this._oCollectionSelector;
	};
	
	/**
	 * rerender the sidebar if different collection is selected
	 *
	 * @private
	 */
	CollectionInspector.prototype.rerenderSidebar = function() {
		var oCurrentCollection = sap.ui.getCore().byId(this.getSelectedCollection());
		if (oCurrentCollection && oCurrentCollection.getEditable()) {
			this._oEditButton.setVisible(true);
		} else {
			this._oEditButton.setVisible(false);
		}
		var $Content = this.$("sidebar");
		if ($Content.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			this.getRenderer().renderSidebar(rm, this);
			rm.flush($Content[0]);
			rm.destroy();
		}
		if (oCurrentCollection && oCurrentCollection.getEditable()) {
			this.$("sidebar").addClass("sapUiUx3CIWithEditButton");
		} else {
			this.$("sidebar").removeClass("sapUiUx3CIWithEditButton");
		}
		this.updateItemNavigation();
		this.refreshSelectionHighlighting();
	};
	
	/**
	 * load all dom refs to into the item navigation
	 *
	 * @private
	 */
	CollectionInspector.prototype.updateItemNavigation = function() {
		var aItemDomRefs = [];
		var $Items = this.$("sidebar").find('li');
		jQuery.each($Items, function(iIndex, $DomRef) {
			aItemDomRefs.push($DomRef);
		});
		this._oItemNavigation.setItemDomRefs(aItemDomRefs);
		this._oItemNavigation.setRootDomRef(this.$("sidebar ul")[0]);
	};
	
	/**
	 * rerender the content if different collection or collection item is selected
	 *
	 * @param int Index of the collection that should be rendered
	 *
	 * @private
	 */
	CollectionInspector.prototype.rerenderContent = function() {
		var $Content = this.$("content");
		if ($Content.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			this.getRenderer().renderContent(rm, this);
			rm.flush($Content[0]);
			rm.destroy();
		}
		this.setElementsHeight();
	};
	
	/**
	 * Calculate height, so that both the sidebar and the content have the same height
	 *
	 * @private
	 */
	CollectionInspector.prototype.setElementsHeight = function() {
		if (this.getFitParent()) {
			return;
		}
	
		var oSidebar = this.$("sidebar");
		var oContent = this.$("content");
	
		var iContentHeight = oContent.outerHeight(true);
		var iContentMargin = oContent.outerHeight(true) - oContent.height();
		var iSidebarMargin = oSidebar.outerHeight(true) - oSidebar.height();
	
		oSidebar.height(Math.max(200, iContentHeight) - iSidebarMargin);
		oContent.height(Math.max(200, iContentHeight) - iContentMargin);
	};
	
	/**
	 * Opens the sidebar
	 *
	 * @public
	 */
	CollectionInspector.prototype.openSidebar = function() {
		var $this = this.$();
		var $Sidebar = this.$("sidebar");
		var $Content = this.$("content");
		$Sidebar.stop(true, true).animate({ width : 150 }, 300, function() {
			$Sidebar.css('width', '');
		});
		$Content.stop(true, true).animate({ left : 150 }, 300, function() {
			$Content.css('left', '');
		});
		$this.removeClass("sapUiUx3CISidebarClosed");
		$this.addClass("sapUiUx3CISidebarOpened");
		this._oToggleButton.setPressed(true);
	};
	
	/**
	 * Closes the siedebar
	 *
	 * @public
	 */
	CollectionInspector.prototype.closeSidebar = function() {
		var $this = this.$();
		var $Sidebar = this.$("sidebar");
		var $Content = this.$("content");
		$Sidebar.stop(true, true).animate({ width : 0 }, 300, function() {
			$Sidebar.css('width', '');
		});
		$Content.stop(true, true).animate({ left : 0 }, 300, function() {
			$Content.css('left', '');
		});
		$this.removeClass("sapUiUx3CISidebarOpened");
		$this.addClass("sapUiUx3CISidebarClosed");
		this._oToggleButton.setPressed(false);
	};
	
	/**
	 * Inserts a collection into the aggregation named <code>collections</code>.
	 *
	 * @param {sap.ui.ux3.Collection}
	 *          oCollection the collection to insert; if empty, nothing is inserted
	 * @param {int}
	 *             iIndex the <code>0</code>-based index the collection should be inserted at; for 
	 *             a negative value of <code>iIndex</code>, the collection is inserted at position 0; for a value 
	 *             greater than the current size of the aggregation, the collection is inserted at 
	 *             the last position        
	 * @return {sap.ui.ux3.CollectionInspector} <code>this</code> to allow method chaining
	 * @public
	 */
	CollectionInspector.prototype.insertCollection = function(oCollection, iIndex) {
		var oButton = new sap.ui.commons.Button();
		oButton.setText(oCollection.getTitle());
		oCollection.attachEvent('_titleChanged', function(oEvent) {
			oButton.setText(oEvent.getParameter("newTitle"));
		});
		var that = this;
		oCollection.attachSelectionChanged(function() {
			that.refreshSelectionHighlighting();
		});
		oCollection.attachPropertyChanged(function() {
			that.rerenderSidebar();
		});
		this._oCollectionSelector.insertButton(oButton, iIndex);
		return this.insertAggregation("collections",oCollection, iIndex);
	};
	
	/**
	 * Adds some collection <code>oCollection</code> 
	 * to the aggregation named <code>collections</code>.
	 *
	 * @param {sap.ui.ux3.Collection}
	 *            oCollection the collection to add; if empty, nothing is inserted
	 * @return {sap.ui.ux3.CollectionInspector} <code>this</code> to allow method chaining
	 * @public
	 */
	CollectionInspector.prototype.addCollection = function(oCollection) {
		var oButton = new sap.ui.commons.Button();
		oButton.setText(oCollection.getTitle());
		oCollection.attachEvent('_titleChanged', function(oEvent) {
			oButton.setText(oEvent.getParameter("newTitle"));
		});
		var that = this;
		oCollection.attachSelectionChanged(function() {
			that.refreshSelectionHighlighting();
		});
		oCollection.attachPropertyChanged(function() {
			that.rerenderSidebar();
		});
		this._oCollectionSelector.addButton(oButton);
		return this.addAggregation("collections",oCollection);
	};
	
	/**
	 * Removes an collection from the aggregation named <code>collections</code>.
	 *
	 * @param {int | string | sap.ui.ux3.Collection} vCollection the collection to remove or its index or id
	 * @return {sap.ui.ux3.Collection} the removed collection or null
	 * @public
	 */
	CollectionInspector.prototype.removeCollection = function(vCollection) {
		var iIndex;
		if (typeof vCollection == "object") {
			iIndex = this.indexOfCollection(vCollection);
		} else {
			iIndex = this.indexOfCollection(sap.ui.getCore().byId(vCollection));
		}
		var oButton = this._oCollectionSelector.getButtons()[iIndex];
		this._oCollectionSelector.removeButton(oButton);
	
		var oResult = this.removeAggregation("collections",vCollection);
		if (oResult && this.getSelectedCollection() == oResult.getId()) {
			this.setSelectedCollection(null);
		}
		return oResult;
	};
	
	/**
	 * Removes all the controls in the aggregation named <code>collections</code>.<br/>
	 * Additionally unregisters them from the hosting UIArea.
	 * @return {sap.ui.ux3.Collection[]} an array of the removed elements (might be empty)
	 * @public
	 */
	CollectionInspector.prototype.removeAllCollections = function() {
		this._oCollectionSelector.removeAllButtons();
		this.setSelectedCollection(null);
		return this.removeAllAggregation("collections");
	};
	
	/**
	 * Destroys the collection aggregation
	 * @return {sap.ui.ux3.CollectionInspector} this to allow method chaining
	 * @public
	 */
	CollectionInspector.prototype.destroyCollections = function() {
		this._oCollectionSelector.destroyButtons();
		this.setSelectedCollection(null);
		return this.destroyAggregation("collections");
	};
	
	CollectionInspector.prototype.setSelectedCollection = function(oCollection) {
		this.setAssociation("selectedCollection",oCollection,true);
		if (!oCollection) {
			this._oEditButton.setVisible(false);
		} else {
			//Select the corresponding item in top navigation
			this._oCollectionSelector.setSelectedButton(this._oCollectionSelector.getButtons()[this.indexOfCollection(oCollection)]);
			//Select first item if no item is selected
			var oSelectedCollection = sap.ui.getCore().byId(this.getSelectedCollection());
			if (oSelectedCollection.getSelectedItems().length == 0 && oSelectedCollection.getItems().length > 0) {
				oSelectedCollection.addSelectedItem(oSelectedCollection.getItems()[0]);
			}
		}
		this.rerenderSidebar();
		this.refreshSelectionHighlighting();
	};
	
	/**
	 * Inserts a content into the aggregation named <code>content</code>.
	 *
	 * @param {sap.ui.core.Control}
	 *          oContent the content to insert; if empty, nothing is inserted
	 * @param {int}
	 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
	 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
	 *             greater than the current size of the aggregation, the content is inserted at 
	 *             the last position        
	 * @return {sap.ui.ux3.CollectionInspector} <code>this</code> to allow method chaining
	 * @public
	 */
	CollectionInspector.prototype.insertContent = function(oContent, iIndex) {
		this.insertAggregation("content",oContent,iIndex,true);
		this.rerenderContent();
	};
	
	/**
	 * Adds some content <code>oContent</code> 
	 * to the aggregation named <code>content</code>.
	 *
	 * @param {sap.ui.core.Control}
	 *            oContent the content to add; if empty, nothing is inserted
	 * @return {sap.ui.ux3.CollectionInspector} <code>this</code> to allow method chaining
	 * @public
	 */
	CollectionInspector.prototype.addContent = function(oContent) {
		this.addAggregation("content",oContent,true);
		this.rerenderContent();
	};
	
	/**
	 * Removes an content from the aggregation named <code>content</code>.
	 *
	 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
	 * @return {sap.ui.core.Control} the removed content or null
	 * @public
	 */
	CollectionInspector.prototype.removeContent = function(vContent) {
		this.removeAggregation("content",vContent,true);
		this.rerenderContent();
	};
	
	/**
	 * Removes all the controls in the aggregation named <code>content</code>.<br/>
	 * Additionally unregisters them from the hosting UIArea.
	 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
	 * @public
	 */
	CollectionInspector.prototype.removeAllContent = function() {
		this.removeAllAggregation("content",true);
		this.rerenderContent();
	};
	
	/**
	 * Destroys all the content in the aggregation 
	 * named <code>content</code>.
	 * @return {sap.ui.ux3.CollectionInspector} <code>this</code> to allow method chaining
	 * @public
	 */
	CollectionInspector.prototype.destroyContent = function() {
		this.destroyAggregation("content",true);
		this.rerenderContent();
	};
	
	/**
	 * When the CI looses the focus, this method is called.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	CollectionInspector.prototype.onfocusout = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		if ($Target.hasClass("sapUiUx3CICollectionListItem")) {
			$Target.removeClass("sapUiUx3CISidebarFoc");
		}
	};
	
	/**
	 * When the CI gets the focus, this method is called.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	CollectionInspector.prototype.onfocusin = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		if ($Target.hasClass("sapUiUx3CICollectionListItem")) {
			$Target.addClass("sapUiUx3CISidebarFoc");
		}
	};
	
	/**
	 * Handles the sapenter event does not bubble
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	CollectionInspector.prototype.onsapenter = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		if ($Target.hasClass("sapUiUx3CISidebarFoc")) {
			this.onclick(oEvent);
		}
		oEvent.stopPropagation();
	};
	
	/**
	 * Handles the sapspace event does not bubble
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	CollectionInspector.prototype.onsapspace = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		if ($Target.hasClass("sapUiUx3CISidebarFoc")) {
			this.onclick(oEvent);
		}
		oEvent.stopPropagation();
	};
	
	/**
	 * Updates the css classes for the selected items
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	CollectionInspector.prototype.refreshSelectionHighlighting = function() {
		var aItems = this.$("sidebar").find('.sapUiUx3CICollectionListItem');
		var aSelectedItems;
		if (this.getSelectedCollection()) {
			aSelectedItems = sap.ui.getCore().byId(this.getSelectedCollection()).getSelectedItems();
		} else {
			aSelectedItems = [];
		}
		jQuery.each(aItems, function(iIndex, oItem) {
			if (jQuery.inArray(oItem.id,aSelectedItems) >= 0) {
				jQuery(oItem).addClass("sapUiUx3CICollectionListItemSelected");
				jQuery(oItem).attr("aria-selected",true);
			} else {
				jQuery(oItem).removeClass("sapUiUx3CICollectionListItemSelected");
				jQuery(oItem).attr("aria-selected",false);
			}
		});
	};
	
	/**
	 * Return the edit button
	 *
	 * @public
	 */
	CollectionInspector.prototype.getEditButton = function() {
		return this._oEditButton;
	};

	return CollectionInspector;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/CollectionInspector.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.DataSet') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.DataSet.
jQuery.sap.declare('sap.ui.ux3.DataSet'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/DataSet",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/ResizeHandler', './library'],
	function(jQuery, Control, ResizeHandler, library) {
	"use strict";



	/**
	 * Constructor for a new DataSet.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * DataSet
	 * @extends sap.ui.core.Control
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.DataSet
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var DataSet = Control.extend("sap.ui.ux3.DataSet", /** @lends sap.ui.ux3.DataSet.prototype */ { metadata : {

		library : "sap.ui.ux3",
		properties : {

			/**
			 * show Toolbar
			 */
			showToolbar : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * show filter
			 */
			showFilter : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Show/hide SearchField in Toolbar
			 */
			showSearchField : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Selection mode of the DataSet
			 */
			multiSelect : {type : "boolean", group : "Behavior", defaultValue : false}
		},
		aggregations : {

			/**
			 * Aggregation of DataSetItems
			 */
			items : {type : "sap.ui.ux3.DataSetItem", multiple : true, singularName : "item", bindable : "bindable"},

			/**
			 * views
			 */
			views : {type : "sap.ui.ux3.DataSetView", multiple : true, singularName : "view"},

			/**
			 * Filter control (e.g. a FacetFilter) for the DataSet
			 */
			filter : {type : "sap.ui.core.Control", multiple : true, singularName : "filter"},

			/**
			 * Internally managed by Dataset
			 */
			_viewSwitches : {type : "sap.ui.core.Control", multiple : true, singularName : "_viewSwitch", visibility : "hidden"},

			/**
			 * A Toolbar, internally managed by Dataset
			 */
			_toolbar : {type : "sap.ui.commons.Toolbar", multiple : false, visibility : "hidden"}
		},
		associations : {

			/**
			 * Selected view of the Dataset
			 */
			selectedView : {type : "sap.ui.ux3.DataSetView", multiple : false}
		},
		events : {

			/**
			 * selection Changed
			 */
			selectionChanged : {
				parameters : {

					/**
					 * Old lead selected index
					 */
					oldLeadSelectedIndex : {type : "int"},

					/**
					 * New lead selected index
					 */
					newLeadSelectedIndex : {type : "int"}
				}
			},

			/**
			 * Event which is fired when the user triggers a search
			 */
			search : {
				parameters : {

					/**
					 * The search query
					 */
					query : {type : "string"}
				}
			}
		}
	}});


	DataSet.prototype.init = function() {
		var that = this, oToolbar;
		//each DS needs a selectionModel for its items
		jQuery.sap.require("sap.ui.model.SelectionModel");
		this.selectionModel = new sap.ui.model.SelectionModel(sap.ui.model.SelectionModel.SINGLE_SELECTION);
		// init toolbar
		this._oSegBut = new sap.ui.commons.SegmentedButton();
		this._oSegBut.attachSelect(function(oEvent){that.press(oEvent);}, that);
		this._oSegBut.show = false;
		this._oSearchField = new sap.ui.commons.SearchField(this.getId() + "-searchValue");
		this._oSearchField.setShowListExpander(false);
		this._oSearchField.setEnableListSuggest(false);
		this._oSearchField.setEnableFilterMode(true);
		this._oSearchField.setEnableClear(true);
		this._oSearchField.show = false;
		that = this;
		this._oSearchField.attachSearch(function(oEvent) {
			that.fireSearch(oEvent.getParameters());
		});
		this.selectionModel.attachSelectionChanged(function(oEvent){
			var oldSelectedIndex, newSelectedIndex;
			var mParameters = oEvent.getParameters();
			if (mParameters) {
				newSelectedIndex = mParameters.leadIndex;
				oldSelectedIndex = mParameters.oldIndex;
			}
			that.fireSelectionChanged({
				oldLeadSelectedIndex: oldSelectedIndex,
				newLeadSelectedIndex: newSelectedIndex
			});
			jQuery.sap.log.debug("Selection Change fired");
		});
		oToolbar = new sap.ui.commons.Toolbar();
		this._setToolbar(oToolbar);
		this._iShiftStart = null;
	};

	DataSet.prototype.exit = function() {
		this._oSegBut.destroy();
		this._oSearchField.destroy();
		this.destroyAggregation("_toolbar");
	};

	DataSet.prototype._prepareToolbar = function() {
		var iViewCount = this.getViews().length,
			oToolbar = this._getToolbar();

		if (iViewCount > 1 && this._oSegBut.show == false) {
			oToolbar.insertItem(this._oSegBut,0);
				this._oSegBut.show = true;
		} else if (iViewCount <= 1 && this._oSegBut.show) {
			oToolbar.removeItem(this._oSegBut);
			this._oSegBut.show = false;
		}
		if (this.getShowSearchField() && this._oSearchField.show == false) {
			oToolbar.insertRightItem(this._oSearchField,oToolbar.getRightItems().length);
			this._oSearchField.show = true;
		} else if (!this.getShowSearchField() && this._oSearchField.show == true) {
			oToolbar.removeRightItem(this._oSearchField);
			this._oSearchField.show = false;
		}
	};

	/**
	 * Press handler for the view selection buttons
	 *
	 * @param {sap.ui.base.Event} oEvent Press event
	 * @private
	*/
	DataSet.prototype.press = function(oEvent,iSelectedViewIndex) {
		var oButtonID = oEvent.getParameters().selectedButtonId,
			viewId = oButtonID.substring(oButtonID.lastIndexOf('-') + 1),
			oldView = sap.ui.getCore().byId(this.getSelectedView());
		oldView.exitView(this.getItems());
		this.setSelectedView(viewId);
	};

	/**
	 * Fire filter event
	 *
	 * @private
	*/
	DataSet.prototype.filter = function() {
		this.fireFilter({
						filterValue : this.getFilterValue()
					});
	};
	/**
	 * Fire sort event
	 *
	 * @private
	*/
	DataSet.prototype.sort = function() {
		this.fireSort();
	};

	/**
	 * adds selection interval to array of selected items.
	 *
	 * @private
	 */
	DataSet.prototype.addSelectionInterval = function(iIndexFrom, iIndexTo) {
		this.selectionModel.addSelectionInterval(iIndexFrom, iIndexTo);
		return this;
	};

	/**
	 * sets selection interval to array of selected items.
	 *
	 * @private
	 */
	DataSet.prototype.setSelectionInterval = function(iIndexFrom, iIndexTo) {
		this.selectionModel.setSelectionInterval(iIndexFrom, iIndexTo);
		return this;
	};
	/**
	 * removes selection interval from array of selected items
	 *
	 * @private
	 */
	DataSet.prototype.removeSelectionInterval = function(iIndexFrom, iIndexTo) {
		this.selectionModel.removeSelectionInterval(iIndexFrom, iIndexTo);
		return this;
	};

	/** use this function to retrieve the lead selected index
	 *
	 * @public
	 */
	DataSet.prototype.getSelectedIndex = function() {
			return this.selectionModel.getLeadSelectedIndex();
	};

	/** use this function to retrieve all selected indices if multiple select is enabled
	 *
	 * @public
	 */
	DataSet.prototype.getSelectedIndices = function(){
		return this.selectionModel.getSelectedIndices() || [];
	};

	/** clears dataset from all previous selections
	 *
	 * @public
	 */
	DataSet.prototype.clearSelection = function() {
		this.selectionModel.clearSelection();
		return this;
	};

	/**
	 * Selection handler for the DataSetItem selection event.
	 *
	 * @param {string} sItemId Id of the selected DataSetItem
	 * @private
	*/
	DataSet.prototype.selectItem = function(oEvent) {
		var oParams = oEvent.getParameters(),
			sItemId = oEvent.getParameters().itemId,
			oItem = sap.ui.getCore().byId(sItemId),
			aItems = this.getItems(),
			iIndex = jQuery.inArray(oItem,aItems),
			oldSelectedIndex = this.getLeadSelection();

		if (!this.getMultiSelect()) {
			if (oldSelectedIndex == iIndex && !oParams.shift) {
				this.setLeadSelection( -1);
			} else {
				this.setLeadSelection(iIndex);
			}
			this._iShiftStart = null;
		} else {
			if (oParams.ctrl) {
				if (!this.isSelectedIndex(iIndex)) {
					this.addSelectionInterval(iIndex, iIndex);
				} else {
					this.removeSelectionInterval(iIndex, iIndex);
				}
				if (this._iShiftStart >= 0) {
					this._iShiftStart = iIndex;
				}
			}

			if (oParams.shift) {
				if (!this._iShiftStart && this._iShiftStart !== 0) {
					this._iShiftStart = oldSelectedIndex;
				}
				if (this._iShiftStart >= 0 && oParams.ctrl) {
					this.addSelectionInterval(this._iShiftStart, iIndex);
				} else if (this._iShiftStart >= 0 & !oParams.ctrl) {
					this.setSelectionInterval(this._iShiftStart, iIndex);
				} else {
					this.setLeadSelection(iIndex);
					this._iShiftStart = iIndex;
				}
			}

			if (!oParams.shift && !oParams.ctrl) {
				if (oldSelectedIndex == iIndex && iIndex != this._iShiftStart) {
					this.setLeadSelection( -1);
				} else {
					this.setLeadSelection(iIndex);
				}
				this._iShiftStart = null;
			}
		}
	};

	/**
	 * Prepare rendering: Calls init end exit hooks on the selected view instance. Necessary to keep the view
	 * consistent to the DataSet state.
	 *
	 * @param {string} sItemId Id of the selected DataSetItem
	 * @private
	*/
	DataSet.prototype.prepareRendering = function() {
		var oView, iViewCount = this.getViews().length;
		if (iViewCount == 0) {
			return;
		}
		this._prepareToolbar();
		if (this._bDirty) {
			oView = sap.ui.getCore().byId(this.getSelectedView());
			if (oView.exitView) {
				oView.exitView(this.getItems());
			}
			if (oView.initView) {
				oView.initView(this.getItems());
			}
			this._bDirty = false;
		}
	};

	//*** Selection Model methods ***

	/**
	 * Returns the LeadSelection index
	 *
	 * @param {string} sItemId Id of the selected DataSetItem
	 * @return {int} selected index
	 * @protected
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	DataSet.prototype.getLeadSelection = function() {
		return this.selectionModel.getLeadSelectedIndex();
	};

	/**
	 * Set the LeadSelection index
	 *
	 * @param {int} iIIndex set LeadSelection index
	 * @type void
	 * @protected
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	DataSet.prototype.setLeadSelection = function(iIndex) {
		this.selectionModel.setLeadSelectedIndex(iIndex);
	};

	/**
	 * Returns true if iIndex is selected
	 *
	 * @param {int} iIndex index of selection
	 * @return {boolean} index selected true/false
	 * @protected
	*/
	DataSet.prototype.isSelectedIndex = function(iIndex) {
		return (this.selectionModel.isSelectedIndex(iIndex));
	};

	/**
	 * Returns id of selected Item from given index
	 *
	 * @param {int} iIndex index of selection
	 * @return {string} id of selected item
	 * @protected
	*/
	DataSet.prototype.getSelectedItemId = function(iIndex) {
		 return this.getItems()[iIndex].getId();
	};

	/**
	 * Creates a view switch button
	 *
	 * @param {object} oView View
	 * @param {int} iIndex Index of view
	 * @return {object} viewSwitch instance
	 * @protected
	*/
	DataSet.prototype.createViewSwitch = function(oView, iIndex) {
		 var oViewSwitch;

		 if (oView.getIcon()) {
			 oViewSwitch = new sap.ui.commons.Button({
				 id : this.getId() + "-view-" + oView.getId(),
				 lite: true,
				 icon:oView.getIcon(),
				 iconHovered: oView.getIconHovered(),
				 iconSelected: oView.getIconSelected()
			 });
		 } else if (oView.getName()) {
			 oViewSwitch = new sap.ui.commons.Button({
				 id : this.getId() + "-view-" + oView.getId(),
				 text : oView.getName(),
				 lite: true
			 });
		 } else {
			 oViewSwitch = new sap.ui.commons.Button({
				 id : this.getId() + "-view-" + oView.getId(),
				 text : oView.getId(),
				 lite: true
			 });
		 }
		 oViewSwitch._viewIndex = iIndex;
		 //oViewSwitch.attachPress(function(oEvent){that.press(oEvent,iIndex);}, that);
		 return oViewSwitch;
	};

	/**
	 * Rerendering of the Toolbar
	 *
	 * @protected
	*/
	DataSet.prototype._rerenderToolbar = function() {
		var $content = this.$("toolbar");
		this._prepareToolbar();
		if ($content.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			sap.ui.ux3.DataSetRenderer.renderToolbar(rm, this);
			rm.flush($content[0]);
			rm.destroy();
		}
	};
	/**
	 * Rerendering of the FilterArea
	 *
	 * @protected
	*/
	DataSet.prototype._rerenderFilter = function() {
		var $content = this.$("filter");
		if ($content.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			sap.ui.ux3.DataSetRenderer.renderFilterArea(rm, this);
			rm.flush($content[0]);
			if (this.getShowFilter()) {
				$content.removeClass("noPadding");
			} else {
				$content.addClass("noPadding");
			}
			rm.destroy();
		}
	};

	//*** override API methods ***

	/**
	 * setter for multi selection mode
	 * @param {boolean}
	 *            bMode true for multi mode, false for single mode
	 * @public
	 */
	DataSet.prototype.setMultiSelect = function(bMode) {
		this.clearSelection();
		if (!bMode) {
			this.setProperty("multiSelect", false);
			if (!!this.selectionModel) {
				this.selectionModel.setSelectionMode(sap.ui.model.SelectionModel.SINGLE_SELECTION);
			}
		} else {
			this.setProperty("multiSelect", true);
			if (!!this.selectionModel) {
				this.selectionModel.setSelectionMode(sap.ui.model.SelectionModel.MULTI_SELECTION);
			}
		}
		return this;
	};

	DataSet.prototype.removeItem = function(oItem) {
		var result = this.removeAggregation("items", oItem, true);
		if (result) {
			result.detachSelected(this.selectItem,this);
			result.destroyAggregation("_template",true);
			this._bDirty = true;
		}
		return result;
	};

	DataSet.prototype.removeAllItems = function() {
		var aItems = this.getItems(), result;
		jQuery.each(aItems,function(i,oItem) {
			oItem.destroyAggregation("_template",true);
			oItem.detachSelected(this.selectItem,this);
		});
		result = this.removeAllAggregation("items");
		this._bDirty = true;
		return result;
	};

	DataSet.prototype.destroyItems = function() {
		var result = this.destroyAggregation("items");
		this._bDirty = true;
		return result;
	};

	DataSet.prototype.addItem = function(oItem) {
		this.addAggregation("items", oItem, true);
		oItem.attachSelected(this.selectItem,this);
		this._bDirty = true;
		return this;
	};

	DataSet.prototype.insertItem = function(oItem, iIndex) {
		this.insertAggregation("items", oItem, iIndex, true);
		oItem.attachSelected(this.selectItem,this);
		this._bDirty = true;
		return this;
	};

	DataSet.prototype.setFilterValue = function(sFilterValue) {
		this.setProperty("filterValue",sFilterValue, true);
		return this;
	};

	DataSet.prototype.getFilterValue = function() {
		return this.getProperty("filterValue");
	};

	DataSet.prototype.insertView = function(oView, iIndex) {
		var oViewSwitch = this.createViewSwitch(oView,iIndex,true);
		if (!this.getSelectedView()) {
			this.setSelectedView(oView);
		}
		this.insertAggregation("views", oView, iIndex);
		this._oSegBut.insertButton(oViewSwitch,iIndex);
		this._rerenderToolbar();
		return this;
	};

	DataSet.prototype.addView = function(oView) {
		var iIndex = this.getViews().length,
			oViewSwitch = this.createViewSwitch(oView,iIndex);
		if (!this.getSelectedView()) {
			this.setSelectedView(oView);
		}
		this.addAggregation("views", oView, true);
		this._oSegBut.addButton(oViewSwitch);
		this._rerenderToolbar();
		return this;
	};

	DataSet.prototype.removeView = function(oView) {
		var result = this.removeAggregation("views", oView, true);

		if (result) {
			if (this.getSelectedView() == result.getId()) {
				this.setSelectedView(this.getViews()[0]);
				this._bDirty = true;
				result.invalidate();
			} else {
				this._rerenderToolbar();
			}

			this._oSegBut.removeButton(this.getId() + "-view-" + result.getId()).destroy();
		}
		return result;
	};

	DataSet.prototype.destroyViews = function() {
		this._oSegBut.destroyButtons();
		this.destroyAggregation("views");
		return this;
	};

	DataSet.prototype.removeAllViews = function() {
		var result = this.removeAllAggregation("views");
		this._oSegBut.destroyButtons();
		return result;
	};

	DataSet.prototype.setEnableSorting = function(bEnableSorting) {
		//suppress rerendering ofDataSet. Rerender only the toolbar.
		this.setProperty("enableSorting", bEnableSorting, true);
		this._rerenderToolbar();
		return this;
	};

	DataSet.prototype.setEnableFiltering = function(bEnableFiltering) {
		//suppress rerendering ofDataSet. Rerender only the toolbar.
		this.setProperty("enableFiltering", bEnableFiltering, true);
		this._rerenderToolbar();
		return this;
	};

	DataSet.prototype.setSelectedView = function(vView) {
		var oldSelectedView = this.getSelectedView();

		this.setAssociation("selectedView", vView);
		if (oldSelectedView != this.getSelectedView()) {
			this._bDirty = true;
		}
		if (this.getId() + "-view-" + this.getSelectedView() !== this._oSegBut.getSelectedButton()) {
			this._oSegBut.setSelectedButton(this.getId() + "-view-" + this.getSelectedView());
		}
		return this;
	};


	/**
	 * add a toolbarItem to the toolbar
	 *
	 * @param {sap.ui.commons.ToolbarItem} oOToolbarItem
	 *         ToolbarItem
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	DataSet.prototype.addToolbarItem = function(oToolbarItem) {
		this._getToolbar().addItem(oToolbarItem);
		this._rerenderToolbar();
	};


	/**
	 * remove a toolbarItem to the toolbar
	 *
	 * @param {sap.ui.commons.ToolbarItem} oOToolbarItem
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	DataSet.prototype.removeToolbarItem = function(oToolbarItem) {
		this._getToolbar().removeItem(oToolbarItem);
		this._rerenderToolbar();
	};

	DataSet.prototype.setShowToolbar = function(bShow) {
		this.setProperty("showToolbar",bShow, true);
		this._rerenderToolbar();
	};

	DataSet.prototype.setShowFilter = function(bShow) {
		this.setProperty("showFilter",bShow, true);
		this._rerenderFilter();
	};

	DataSet.prototype.setShowSearchField = function(bShow) {
		this.setProperty("showSearchField",bShow, true);
		this._rerenderToolbar();
	};
	/**
	* @private
	*/
	DataSet.prototype._setToolbar = function(oToolbar) {
		this.setAggregation("_toolbar",oToolbar,true);
		this._rerenderToolbar();
	};
	/**
	* @private
	*/
	DataSet.prototype._getToolbar = function() {
		return this.getAggregation("_toolbar");
	};

	DataSet.prototype.refreshItems = function() {
		var	oBinding = this.getBinding("items"),
			oSelectedView = sap.ui.getCore().byId(this.getSelectedView());

		oBinding.bUseExtendedChangeDetection = true;

		if (oSelectedView && oSelectedView.getItemCount && oSelectedView.getItemCount()) {
			var iItemCount = Math.max(oSelectedView.getItemCount(),this.getItems().length);
			if (iItemCount) {
				oBinding.getContexts(0, iItemCount);
			} else {
				oBinding.getContexts();
			}
		} else {
			oBinding.getContexts();
		}
	};

	DataSet.prototype.updateItems = function(sChangeReason) {
		var oBindingInfo = this.mBindingInfos["items"],
			oAggregationInfo = this.getMetadata().getAggregation("items"),
			oSelectedView = sap.ui.getCore().byId(this.getSelectedView()),
			oBinding = oBindingInfo.binding,
			fnFactory = oBindingInfo.factory,
			oClone,
			aItems,
			oItem,
			iIndex,
			that = this,
			aContexts = [];

		oBinding.bUseExtendedChangeDetection = true;

		if (oSelectedView && oSelectedView.getItemCount && oSelectedView.getItemCount()) {
			var iItemCount = Math.max(oSelectedView.getItemCount(),this.getItems().length);
			if (iItemCount) {
				aContexts = oBinding.getContexts(0, iItemCount);
			} else {
				aContexts = oBinding.getContexts();
			}
		} else {
			aContexts = oBinding.getContexts();
		}

		if (aContexts.diff && sChangeReason) {
			var aDiff = aContexts.diff;
			for (var i = 0; i < aDiff.length; i++) {
				aItems = this.getItems();
				iIndex = aDiff[i].index;
				if (aDiff[i].type === "delete") {
					oItem = aItems[iIndex];
					aDiff[i].item = oItem;
					this.removeItem(oItem);
				} else if (aContexts.diff[i].type === "insert") {
					oItem = fnFactory("", aContexts[iIndex]);
					oItem.setBindingContext(aContexts[iIndex], oBindingInfo.model);
					aDiff[i].item = oItem;
					this.insertItem(oItem, iIndex);
				}
			}
			if (oSelectedView && oSelectedView.updateView) {
				oSelectedView.updateView(aDiff);
			}
		} else {
			this[oAggregationInfo._sDestructor]();
			jQuery.each(aContexts, function(iIndex, oContext) {
				var sId = that.getId() + "-" + iIndex;
				oClone = fnFactory(sId, oContext);
				oClone.setBindingContext(oContext, oBindingInfo.model);
				that[oAggregationInfo._sMutator](oClone);
			});
		}
		
		// update context on all items after applying diff
		aItems = this.getItems();
		for (var i = 0, l = aContexts.length; i < l; i++) {
			aItems[i].setBindingContext(aContexts[i], oBindingInfo.model);
		}
	};

	return DataSet;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/DataSet.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.DataSetItem') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.DataSetItem.
jQuery.sap.declare('sap.ui.ux3.DataSetItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/DataSetItem",['jquery.sap.global', 'sap/ui/core/Element', './library'],
	function(jQuery, Element, library) {
	"use strict";


	
	/**
	 * Constructor for a new DataSetItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * DataSet Item
	 * @extends sap.ui.core.Element
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.DataSetItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var DataSetItem = Element.extend("sap.ui.ux3.DataSetItem", /** @lends sap.ui.ux3.DataSetItem.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * image
			 */
			iconSrc : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * title
			 */
			title : {type : "string", group : "Misc", defaultValue : 'Title'},
	
			/**
			 * checkable
			 */
			checkable : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * subtitle
			 */
			subtitle : {type : "string", group : "Misc", defaultValue : 'Subtitle'}
		},
		aggregations : {
	
			/**
			 * The template control currently aggregated by this item and managed by the DataSet
			 */
			_template : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}
		},
		events : {
	
			/**
			 * Event Fired when Datset item is selected.
			 */
			selected : {
				parameters : {
	
					/**
					 * Id of the selected Datset item
					 */
					itemId : {type : "string"}
				}
			}
		}
	}});
	
	/**
	 * Handle onclick event. Fires selected Event.
	 * @param {sap.ui.base.Event} oEvent click event
	 * @private
	 */
	DataSetItem.prototype.onclick = function(oEvent) {
		oEvent.stopPropagation();
		
		// determine modifier keys
		var bShift = oEvent.shiftKey;
		var bCtrl = !!(oEvent.metaKey || oEvent.ctrlKey);
		
		this.fireSelected({
			itemId: this.getId(),
			shift:  bShift,
			ctrl:   bCtrl
		});
	};
	DataSetItem.prototype.ondblclick = function(oEvent) {
		this.onclick(oEvent);
	};

	return DataSetItem;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/DataSetItem.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.DataSetSimpleView') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.DataSetSimpleView.
jQuery.sap.declare('sap.ui.ux3.DataSetSimpleView'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/DataSetSimpleView",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/ResizeHandler', './library', 'jquery.sap.script'],
	function(jQuery, Control, ResizeHandler, library/* , jQuerySap */) {
	"use strict";


	
	/**
	 * Constructor for a new DataSetSimpleView.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * DataSetSimpleView provides a simple view example for DataSet usage.
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.ux3.DataSetView
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.DataSetSimpleView
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var DataSetSimpleView = Control.extend("sap.ui.ux3.DataSetSimpleView", /** @lends sap.ui.ux3.DataSetSimpleView.prototype */ { metadata : {
	
		interfaces : [
			"sap.ui.ux3.DataSetView"
		],
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * When true the DatSet items are floating containers. When set to false The Items are rendered in a 1 column Layout.
			 */
			floating : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Name of the View
			 */
			name : {type : "string", group : "Misc", defaultValue : "Name of this View"},
	
			/**
			 * Icon source for this view
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * icon: hovered state
			 */
			iconHovered : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * icon: selected state
			 */
			iconSelected : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * When true and the property floating is true the DatSet items are floating containers filling the whole space of a row.
			 * @since 1.9.2
			 */
			responsive : {type : "boolean", group : "Misc", defaultValue : false},
	
			/**
			 * When itemMinWidth>0 and the property floating is true the given minimum width in pixels is set to DatSet items. A minimum width must be given when the property responsive is set.
			 * @since 1.9.2
			 */
			itemMinWidth : {type : "int", group : "Misc", defaultValue : 0},
	
			/**
			 * If this value is greater zero only this amount of items is loaded in the first place. New items are loaded automatically when the user scrolls down. The number of items which are reloaded can be defined with the property "reloadItemCount"
			 * @since 1.13.0
			 */
			initialItemCount : {type : "int", group : "Appearance", defaultValue : 0},
	
			/**
			 * This number defines the item count which is reloaded on scroll if initialItemCount is enabled.
			 * @since 1.13.0
			 */
			reloadItemCount : {type : "int", group : "Appearance", defaultValue : 0},
	
			/**
			 * ID of the DOM Element or jQuery reference to the dom which holds the scrollbar for the dataset
			 * @since 1.13.0
			 */
			scrollArea : {type : "any", group : "Appearance", defaultValue : null},
	
			/**
			 * If the pagination feature is used without specifying a scroll area, a height for the dataset must be defined.
			 * @since 1.13.0
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null}
		},
		aggregations : {
	
			/**
			 * template
			 */
			template : {type : "sap.ui.core.Control", multiple : false}
		}
	}});
	
	
	///**
	// * This file defines behavior for the control,
	// */
	
	/**
	 * Initialization of DataSetSimpleView
	 *
	 * @private
	*/
	DataSetSimpleView.prototype.init = function(){
		this._oDataSet = this.getParent();
		this.items = [];
		this._bRendered = false;
		if (this.getInitialItemCount() > 0 && this.getReloadItemCount() <= 0) {
			this.setReloadItemCount(this.getInitialItemCount());
		}
		this._bUsePagination = false;
	};
	
	DataSetSimpleView.prototype.exit = function() {
		// Cleanup resize event registration on exit
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
	};
	
	/**
	 * Eventhandler for the selection of an Item
	 *
	 * @param {event} oEvent SelectionChanged event
	 * @protected
	 */
	DataSetSimpleView.prototype.handleSelection = function(oEvent) {
		var oDataSet = this.getParent();
		var aItems = oDataSet.getItems(),
			aSelectedItems = oDataSet.getSelectedIndices();
			if (aSelectedItems.length > 1) {
				this._clearTextSelection();
			}
			jQuery.each(aItems, function(index, item){
				if (oDataSet.isSelectedIndex(index)) {
					item.$().addClass("sapUiUx3DSSVSelected");
				} else {
					item.$().removeClass("sapUiUx3DSSVSelected");
				}
			});
	};
	
	
	/**
	 * clears the text selection on the document (disabled for Dnd)
	 * @private
	 */
	DataSetSimpleView.prototype._clearTextSelection = function () {
		if (window.getSelection) {
			if (window.getSelection().empty) {  // Chrome
				window.getSelection().empty();
			} else if (window.getSelection().removeAllRanges) {  // Firefox
				window.getSelection().removeAllRanges();
			}
		} else if (document.selection && document.selection.empty) {  // IE?
			try {
				document.selection.empty();
			} catch (ex) {
				// ignore error to as a workaround for bug in IE8
			}
		}
	};
	
	/**
	 * Check if Item <code>oItem</code> is selected
	 *
	 * @param {sap.ui.ux3.DataSetItem} oItem DataSetItem instance
	 * @protected
	 */
	DataSetSimpleView.prototype.isItemSelected = function(oItem) {
		var iIndex = jQuery.inArray(oItem,this.items);
		if (iIndex == -1) {
			return false;
		}
		return this.getParent().isSelectedIndex(iIndex);
	};
	
	//*** Interface methods ***
	
	/**
	 * View Initialization: Called when selecting the view
	 *
	 * @param {array} aItems Array of DataSetItems added to the parent DataSet
	 * @protected
	 */
	DataSetSimpleView.prototype.initView = function(aItems) {
		this.getParent().attachSelectionChanged(this.handleSelection, this);
		this.items = this.items.concat(aItems);
		for (var i = 0; i < aItems.length; i++) {
			var template = this.getTemplate().clone();
			aItems[i].setAggregation('_template', template, true);
		}
	};
	
	/**
	 * View update: Called when pagination adds items
	 *
	 * @param {sap.ui.ux3.DataSetItem[]} aDiff Array of DataSetItems added to the parent DataSet
	 * @protected
	 */
	DataSetSimpleView.prototype.updateView = function(aDiff) {
		//if view is not rendered no Dom update is necessary
		if (!this.getDomRef()) {
			return;
		}
		var rm = sap.ui.getCore().createRenderManager(),
			iLastLength = this.items.length;
			
		for (var i = 0; i < aDiff.length; i++) {
			var oItem = aDiff[i].item;
			var iIndex = aDiff[i].index;
			
			if (aDiff[i].type === "insert") {
				var template = this.getTemplate().clone();
				oItem.setAggregation('_template', template, true);
				if (i == aDiff.length - 1 && iLastLength == 0) {
					//render all initial items first. The delegate loads all missing to fill the scrollarea
					var oDelegate = {
						/*eslint-disable no-loop-func */
						onAfterRendering: function() {
							this.calculateItemCounts();
							this.getParent().updateItems(sap.ui.model.ChangeReason.Change);
							template.removeDelegate(oDelegate);
						}
						/*eslint-enable no-loop-func */
					};
					template.addDelegate(oDelegate, false, this);
				}
				this.getRenderer().renderItem(rm, this, oItem);
				rm.flush(this.$()[0], false, iIndex);
				this.items.splice(iIndex, 0, oItem);
			} else {
				this.items.splice(iIndex, 1);
				oItem.$().remove();
				oItem.destroy();
			}
		}
		if (aDiff.length > 0 && this.getFloating() && this.getResponsive()) {
			this._computeWidths(true);
		}
		rm.destroy();
	};
	
	/**
	 * View finalization: Called when leaving the view
	 *
	 * @param {sap.ui.ux3.DataSetItem[]} aItems
	 * @protected
	 */
	DataSetSimpleView.prototype.exitView = function(aItems) {
		this.getParent().detachSelectionChanged(this.handleSelection, this);
		for (var i = 0; i < aItems.length; i++) {
			aItems[i].destroyAggregation("_template",true);
		}
		this.items = [];
	};
	
	/**
	 * Set scroll area based on selected view
	 * @private
	 */
	DataSetSimpleView.prototype.initScrollArea = function() {
		var $scrollArea = this.getScrollArea(),
			that = this;
		
		var fnScroll = function(oEvent) {
			that.getParent().updateItems(sap.ui.model.ChangeReason.Change);
		};
		if (typeof $scrollArea === 'string') {
			$scrollArea = jQuery.sap.byId($scrollArea);
		}
		if (!$scrollArea) {
			$scrollArea = this.$();
		} else if ($scrollArea.is('html')) {
			//if scrollarea is 'html' then we use the browser scrollarea
			$scrollArea = jQuery(document);
		}
		
		if (!this._bUsePagination) {
			$scrollArea.off('scroll', fnScroll);
		} else {
			$scrollArea.on('scroll', fnScroll);
		}
	};
	
	DataSetSimpleView.prototype.checkScrollItems = function() {
		if (!this._bRendered) {
			return;
		}
		
		var oBindingInfo = this.getParent().mBindingInfos["items"],
			$scrollArea = this.getScrollArea(),
			oBinding = oBindingInfo.binding,
			oParent = this.getParent(),
			iAppendItems = 0,
			iFillupSpace,
			scrollArea,
			iClientHeight,
			iScrollHeight;
			
		
		if (oParent.getItems().length === oBinding.getLength()) {
			return iAppendItems;
		}
		if (typeof $scrollArea === 'string') {
			$scrollArea = jQuery.sap.byId($scrollArea);
		}
		if (!$scrollArea) {
			$scrollArea = this.$();
		}
		if (!$scrollArea || $scrollArea.length == 0) {
			return iAppendItems;
		}
	
		scrollArea = $scrollArea[0];
		iClientHeight = scrollArea.clientHeight;
		iScrollHeight = scrollArea.scrollHeight;
	
		if ($scrollArea.is('html')) {
			//if scrollarea is 'html' then we use the browser scrollarea
			$scrollArea = jQuery(document);
		}
	
		if (iClientHeight == iScrollHeight) {
			iFillupSpace = iClientHeight + this._iScrollTrigger;
		} else {
			iFillupSpace = iClientHeight + this._iScrollTrigger + $scrollArea.scrollTop();
		}
		
		if (iFillupSpace > 0) {
			var iNewItemCount = Math.floor(iFillupSpace / this._iRowHeight) * this._iItemsPerRow;
			var iCurrentItemCount = oParent.getItems().length;
			iNewItemCount = Math.ceil(iNewItemCount / this._iItemsPerRow) * this._iItemsPerRow;
			iAppendItems = iNewItemCount - iCurrentItemCount;
		}
		
		return iAppendItems;
	};
	
	DataSetSimpleView.prototype.getItemCount = function() {
		if (this._bUsePagination) {
			var iLength = this.getParent().getItems().length,
			iAppendItems = this.checkScrollItems();
			if (iLength == 0) {
				iLength += this.getInitialItemCount();
			} else {
				iLength += iAppendItems;
			}
			//this._iLastLength = iLength;
			return iLength;
		} else {
			return null;
		}
	};
	
	DataSetSimpleView.prototype.setInitialItemCount = function(iValue) {
		this.setProperty("initialItemCount", iValue);
		this._bUsePagination = (iValue != 0);
	};
	
	/**
	 * Called after the control is rendered
	 */
	DataSetSimpleView.prototype.onBeforeRendering = function(){
		// Cleanup resize event registration before re-rendering
		if (this.sResizeListenerId) {
			ResizeHandler.deregister(this.sResizeListenerId);
			this.sResizeListenerId = null;
		}
	};
	
	/**
	 * Called after the control is rendered
	 */
	DataSetSimpleView.prototype.onAfterRendering = function(){
		this._bRendered = true;
		this.initScrollArea();
		if ((this.getFloating() && this.getResponsive()) || this._bUsePagination) {
			this._height = -1;
			this._itemsPerRow = -1;
			this.onresize();
			this.sResizeListenerId = ResizeHandler.register(this.getDomRef(), jQuery.proxy(this.onresize, this));
		}
	};
	
	/**
	 * Called after the control is rendered
	 */
	DataSetSimpleView.prototype.onThemeChanged = function(){
		if (this._bRendered) {
			this.calculateItemCounts();
			this.getParent().updateItems(sap.ui.model.ChangeReason.Change);
		}
	};
	
	/**
	 * Function is called when window is resized
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	DataSetSimpleView.prototype.onresize = function() {
	
		if (!this.getDomRef()) {
			// slider is not rendered, maybe deleted from DOM -> deregister resize handler and do nothing
			// Cleanup resize event registration on exit
			if (this.sResizeListenerId) {
				ResizeHandler.deregister(this.sResizeListenerId);
				this.sResizeListenerId = null;
			}
			return;
		}
	
		if (this.getFloating() && this.getResponsive()) {
			this._computeWidths();
		}
		if (this._bUsePagination && this.items.length > 0) {
			this.calculateItemCounts();
			this.getParent().updateItems(sap.ui.model.ChangeReason.Change);
		}
	};
	
	DataSetSimpleView.prototype.setTemplate = function(oTemplate) {
		this.setAggregation("template", oTemplate, true);
		//Here we need to rerender all items because of a new layout
		if (this.getParent()) {
			this.getParent().updateItems();
		}
	};
	
	/**
	 * Calculate Item count
	 * @private
	 */
	DataSetSimpleView.prototype.calculateItemCounts = function(){
		if (this.getDomRef()) {
			var $itemArea = this.$(),
				$firstItem = $itemArea.children().first();
			
			this._iItemsPerRow = Math.floor($itemArea.outerWidth(true) / $firstItem.outerWidth(true));
			this._iNewRows = Math.ceil(this.getReloadItemCount() / this._iItemsPerRow);
			this._iNewItems = this._iItemsPerRow * this._iNewRows;
			this._iRowHeight = $firstItem.outerHeight(true);
			this._iScrollTrigger = this._iNewRows * this._iRowHeight;
		}
	};
	
	DataSetSimpleView.prototype._computeWidths = function(bInitial){
		var $This = this.$();
		var iItemsPerRow = Math.floor($This.width() / this.getItemMinWidth());
		var width = Math.floor(100 / iItemsPerRow);
		if ($This.width() * width / 100 < this.getItemMinWidth()) {
			iItemsPerRow--;
			width = Math.floor(100 / iItemsPerRow);
		}
		
		if (bInitial || this._height != $This.height() || this._itemsPerRow != iItemsPerRow) {
			var count = -1;
			var aItems = this.getParent().getItems();
			var diff, w;
			
			for (var j = 0; j < aItems.length; j++) {
				if (count == -1 || count + 1 > iItemsPerRow) {
					count = 0;
					diff = 100 - (iItemsPerRow * width);
				}
				
				var w = width;
				if (diff > 0) {
					w++;
					diff--;
				}
				aItems[j].$().css("width", w + "%");
				count++;
			}
			
			this._height = $This.height();
			this._itemsPerRow = iItemsPerRow;
		}
	};
	
	/**
	 * @param {any[]} aScrollArea
	 * @param {boolean} bSupress
	 * @public
	 */
	DataSetSimpleView.prototype.setScrollArea = function(aScrollArea, bSupress) {
		if (typeof aScrollArea !== 'string' && !(aScrollArea instanceof jQuery)) {
			jQuery.sap.log.error('You can only pass a string (ID of scroll area DOM) or an jQuery object as scrollarea');
		}
		this.setProperty('scrollArea', aScrollArea, bSupress);
	};
	

	return DataSetSimpleView;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/DataSetSimpleView.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ExactArea') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ExactArea.
jQuery.sap.declare('sap.ui.ux3.ExactArea'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Toolbar'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ExactArea",['jquery.sap.global', 'sap/ui/commons/Toolbar', 'sap/ui/core/Control', './library'],
	function(jQuery, Toolbar, Control, library) {
	"use strict";


	
	/**
	 * Constructor for a new ExactArea.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Consists of two sections: A tool bar and a content area where arbitrary controls can be added.
	 * The ExactArea is intended to be used for the Exact design approach but alternatively also in a stand alone version.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.6. 
	 * API is not yet finished and might change completely
	 * @alias sap.ui.ux3.ExactArea
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ExactArea = Control.extend("sap.ui.ux3.ExactArea", /** @lends sap.ui.ux3.ExactArea.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * Specifies whether the tool bar shall be visible
			 */
			toolbarVisible : {type : "boolean", group : "Appearance", defaultValue : true}
		},
		defaultAggregation : "content",
		aggregations : {
	
			/**
			 * Arbitrary child controls of the content area
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
	
			/**
			 * Tool bar items which shall be shown in the tool bar.
			 */
			toolbarItems : {type : "sap.ui.commons.ToolbarItem", multiple : true, singularName : "toolbarItem"}
		}
	}});
	
	
	(function() {
	
	//*************************************************************
	//Define a private element to enable titles tin the toolbar
	//*************************************************************
	
	sap.ui.core.Element.extend("sap.ui.ux3.ExactAreaToolbarTitle", {
	  
	  metadata: {
	    interfaces : ["sap.ui.commons.ToolbarItem"],
	    properties : {
	      text : {name : "text", type : "string", group : "Appearance", defaultValue : ''}
	    }
	  }
	
	});
	
	//*************************************************************
	
	}());

	return ExactArea;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ExactArea.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ExactAttribute') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ExactAttribute.
jQuery.sap.declare('sap.ui.ux3.ExactAttribute'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ExactAttribute",['jquery.sap.global', 'sap/ui/core/Element', './library'],
	function(jQuery, Element, library) {
	"use strict";


	
	/**
	 * Constructor for a new ExactAttribute.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * An element for defining attributes and sub-attributes used within the Exact pattern.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.ExactAttribute
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ExactAttribute = Element.extend("sap.ui.ux3.ExactAttribute", /** @lends sap.ui.ux3.ExactAttribute.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * The attribute name
			 */
			text : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Specifies whether the attribute shall be selected
			 */
			selected : {type : "boolean", group : "Misc", defaultValue : null},
	
			/**
			 * Specifies the width of the corresponding list in pixels. The value must be between 70 and 500.
			 * @since 1.7.0
			 */
			width : {type : "int", group : "Misc", defaultValue : 168},
	
			/**
			 * The order how the sublists of this attribute should be displayed.
			 * @since 1.7.1
			 */
			listOrder : {type : "sap.ui.ux3.ExactOrder", defaultValue : sap.ui.ux3.ExactOrder.Select},
	
			/**
			 * Specifies whether the attribute shall have sub values for visual purposes.
			 * The indicator which is a little arrow beside an attribute in the list is computed automatically
			 * (getShowSubAttributesIndicator_Computed() of sap.ui.ux3.ExactAttribute).
			 * In the case that a supply function is attached, and the supplyActive attribute has value 'true',
			 * then the Exact pattern needs a hint if sub attributes are available. The showSubAttributesIndicator attribute is
			 * considered then and has to be maintained. If the back-end does not support count-calls, for example,
			 * showSubAttributesIndicator should be set to true.
			 */
			showSubAttributesIndicator : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * An example for additional data are database keys
			 */
			additionalData : {type : "object", group : "Misc", defaultValue : null},
	
			/**
			 * The supplyAttributes event is only fired if supplyActive has value true which is the default. After firing the event, the attribute is automatically set to false.
			 * The idea is that a supply function is called only once when the data is requested. To enable the event again it is possible to manually set the attribute back to true.
			 */
			supplyActive : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * If you want the supply function to be called on every select, you can set the autoActivateSupply attribute to true. In this case, supplyActive is automatically
			 * set to true on every unselect.
			 */
			autoActivateSupply : {type : "boolean", group : "Misc", defaultValue : false}
		},
		defaultAggregation : "attributes",
		aggregations : {
	
			/**
			 * Values (sub attributes) of this attribute
			 */
			attributes : {type : "sap.ui.ux3.ExactAttribute", multiple : true, singularName : "attribute"}
		},
		events : {
	
			/**
			 * A supply function is a handler which is attached to the supplyAttributes event. The event is fired when the corresponding ExactAttribute is selected, it was already selected when a handler is attached or function getAttributes() is called.
			 */
			supplyAttributes : {
				parameters : {
	
					/**
					 * The ExactAttribute
					 */
					attribute : {type : "sap.ui.ux3.ExactAttribute"}
				}
			}
		}
	}});
	
	
	
	
	
	
	
	(function() {
	
	ExactAttribute._MINWIDTH = 70;
	ExactAttribute._MAXWIDTH = 500;
	

	/**
	 * Scrolls the corresponding list of this attribute until the given direct child attribute is visible. If the corresponding list is not yet visible the call is buffered until the list is available.
	 *
	 * @param {sap.ui.ux3.ExactAttribute} oOAttribute
	 *         The direct child attribute
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ExactAttribute.prototype.scrollTo = function(oAttribute) {
		if (!(oAttribute instanceof ExactAttribute)) {
			this._scrollToAttributeId = undefined;
			return;
		}
		
		var oList = this.getChangeListener();
		if (oList) {
			oList = sap.ui.getCore().byId(oList.id);
			if (oList && oList._lb) {
				var iIdx = this.indexOfAttribute(oAttribute);
				if (iIdx >= 0) {
					oList._lb.scrollToIndex(iIdx, true);
				}
				this._scrollToAttributeId = undefined;
				return;
			}
		}
		this._scrollToAttributeId = oAttribute.getId();
	};
	
	//*** Overridden API functions ***
	
	ExactAttribute.prototype.setText = function(sText) {
		this.setProperty("text", sText, true);
		this._handleChange(this, "text");
		return this;
	};
	
	
	ExactAttribute.prototype.setWidth = function(iWidth) {
		this._setWidth(iWidth);
		this._handleChange(this, "width");
		return this;
	};
	
	
	/**
	 * @param {string|sap.ui.core.TooltipBase} oTooltip
	 * @see sap.ui.core.Element.prototype.setTooltip
	 * @public
	 */
	ExactAttribute.prototype.setTooltip = function(oTooltip) {
		Element.prototype.setTooltip.apply(this, arguments);
		this._handleChange(this, "tooltip", true);
		return this;
	};
	
	
	ExactAttribute.prototype.setSelected = function(bSelected) {
		this.setProperty("selected", bSelected, true);
	
		if (!this.getSelected()) {
			this._clearSelection();
		}
	
		this._handleChange(this, "selected");
		return this;
	};
	
	
	ExactAttribute.prototype.setSupplyActive = function(bSupplyActive) {
		this.setProperty("supplyActive", bSupplyActive, true);
		return this;
	};
	
	
	ExactAttribute.prototype.setAutoActivateSupply = function(bAutoActivateSupply) {
		this.setProperty("autoActivateSupply", bAutoActivateSupply, true);
		return this;
	};
	
	
	ExactAttribute.prototype.setAdditionalData = function(oAdditionalData) {
		this.setProperty("additionalData", oAdditionalData, true);
		return this;
	};
	
	
	ExactAttribute.prototype.setListOrder = function(sListOrder) {
		this.setProperty("listOrder", sListOrder, true);
		this._handleChange(this, "order");
		return this;
	};
	
	
	ExactAttribute.prototype.getAttributes = function() {
		if (this.hasListeners("supplyAttributes") && this.getSupplyActive()) {
			this._bSuppressChange = true;
			this._bChangedHappenedDuringSuppress = false;
			this.fireSupplyAttributes({attribute: this});
			this.setSupplyActive(false);
			this._bSuppressChange = undefined;
			if (this._bChangedHappenedDuringSuppress) {
				this._handleChange(this, "attributes");
			}
			this._bChangedHappenedDuringSuppress = undefined;
		}
		return this.getAggregation("attributes", []);
	};
	
	
	ExactAttribute.prototype.insertAttribute = function(oAttribute, iIndex) {
		this.insertAggregation("attributes", oAttribute, iIndex, true);
		this._handleChange(this, "attributes");
		this.setSupplyActive(false);
		return this;
	};
	
	
	ExactAttribute.prototype.addAttribute = function(oAttribute) {
		this.addAggregation("attributes", oAttribute, true);
		this._handleChange(this, "attributes");
		this.setSupplyActive(false);
		return this;
	};
	
	
	ExactAttribute.prototype.removeAttribute = function(vElement) {
		var oAtt = this.removeAggregation("attributes", vElement, true);
		if (oAtt) {
			oAtt.setChangeListener(null);
			this._handleChange(this, "attributes");
		}
		return oAtt;
	};
	
	
	ExactAttribute.prototype.removeAllAttributes = function() {
		var aAtts = this.getAttributesInternal();
		for (var idx = 0; idx < aAtts.length; idx++) {
			aAtts[idx].setChangeListener(null);
		}
		var aRes = this.removeAllAggregation("attributes", true);
		if (aAtts.length > 0) {
			this._handleChange(this, "attributes");
		}
		return aRes;
	};
	
	
	ExactAttribute.prototype.destroyAttributes = function() {
		var aAtts = this.getAttributesInternal();
		for (var idx = 0; idx < aAtts.length; idx++) {
			aAtts[idx].setChangeListener(null);
		}
		this.destroyAggregation("attributes", true);
		if (aAtts.length > 0) {
			this._handleChange(this, "attributes");
		}
		return this;
	};
	
	

	/**
	 * See attribute showSubAttributesIndicator
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ExactAttribute.prototype.getShowSubAttributesIndicator_Computed = function() {
		return this.hasListeners("supplyAttributes") && this.getSupplyActive() ? this.getShowSubAttributesIndicator() : this.getAttributesInternal().length > 0;
	};
	
	
	ExactAttribute.prototype.attachSupplyAttributes = function(oData, fnFunction, oListener) {
		this.attachEvent("supplyAttributes", oData, fnFunction, oListener);
		if (this.getSelected()) {
			this.getAttributesInternal(true); //force init of attributes (e.g. call supply function))
		}
		return this;
	};
	
	
	//*** Internal (may also used by Exact Control) functions ***
	
	
	ExactAttribute.prototype._setProperty_Orig = ExactAttribute.prototype.setProperty;
	/**
	 * @param {string} sPropertyName
	 * @param {object} oValue
	 * @param {boolean} bSuppressRerendering
	 * @see sap.ui.core.Element.prototype.setProperty
	 * @protected
	 */
	ExactAttribute.prototype.setProperty = function(sPropertyName, oValue, bSuppressRerendering) {
		this._setProperty_Orig(sPropertyName, oValue, bSuppressRerendering);
	
		if (sPropertyName == "selected") {
			if (oValue) {
				this.getAttributesInternal(true); //force init of attributes (e.g. call supply function)
			} else {
				if (this.getAutoActivateSupply()) {
					this.setSupplyActive(true);
				}
			}
		}
	
		return this;
	};
	
	
	ExactAttribute.prototype.setChangeListener = function(oChangeListener) {
		this._oChangeListener = oChangeListener;
	};
	
	
	ExactAttribute.prototype.getChangeListener = function(oChangeListener) {
		return this._oChangeListener;
	};
	
	
	ExactAttribute.prototype.getAttributesInternal = function(bForceInit) {
		return bForceInit ? this.getAttributes() : this.getAggregation("attributes", []);
	};
	
	
	ExactAttribute.prototype._handleChange = function(oSourceAttribute, sType) {
		if (this._bSuppressChange) {
			this._bChangedHappenedDuringSuppress = true;
			return;
		}
		if (this.getChangeListener()) {
			//Change is handled by the change listener
			this.getChangeListener()._notifyOnChange(sType, oSourceAttribute);
		} else if (this.getParent() && this.getParent()._handleChange) {
			//Bubble Change to next change listener
			this.getParent()._handleChange(oSourceAttribute, sType);
		}
	};
	
	
	//Sets the selection property of the attribute and all its sub-attributes to false.
	ExactAttribute.prototype._clearSelection = function(){
		this.setProperty("selected", false, true);
		var aVals = this.getAttributesInternal();
		for (var idx = 0; idx < aVals.length; idx++) {
			aVals[idx]._clearSelection();
		}
	};
	
	
	//Setter of the width property without invalidate and change notification
	ExactAttribute.prototype._setWidth = function(iWidth) {
		iWidth = Math.round(ExactAttribute._checkWidth(iWidth));
		this.setProperty("width", iWidth, true);
	};
	
	
	//Checks whether the given width is within the allowed boundaries
	ExactAttribute._checkWidth = function(iWidth) {
		iWidth = Math.max(iWidth, ExactAttribute._MINWIDTH);
		iWidth = Math.min(iWidth, ExactAttribute._MAXWIDTH);
		return iWidth;
	};
	
	}());

	return ExactAttribute;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ExactAttribute.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ExactList') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ExactList.
jQuery.sap.declare('sap.ui.ux3.ExactList'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.ListBox'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.dom'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ExactList",['jquery.sap.global', 'sap/ui/commons/ListBox', 'sap/ui/core/Control', 'sap/ui/core/Popup', 'sap/ui/core/theming/Parameters', './library', 'jquery.sap.dom'],
	function(jQuery, ListBox, Control, Popup, Parameters, library/* , jQuerySap */) {
	"use strict";


	
	/**
	 * Constructor for a new ExactList.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Internal sub-control of the ExactBrowser. The control is not intended to be used stand alone. For this purpose, the ExactBrowser control can be used.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.ExactList
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ExactList = Control.extend("sap.ui.ux3.ExactList", /** @lends sap.ui.ux3.ExactList.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * Defines whether the close icon shall be displayed in the header.
			 */
			showClose : {type : "boolean", group : "Misc", defaultValue : false},
	
			/**
			 * The title of this list is the top of the list hierarchy.
			 */
			topTitle : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * The height in px if this list is the top of the list hierarchy.
			 */
			topHeight : {type : "int", group : "Appearance", defaultValue : 290}
		},
		aggregations : {
	
			/**
			 * The sub-ExactLists of this list. This aggregation must not be maintained from outside.
			 * The control automatically takes care to fill this aggregation according to the given ExactAttribute.
			 */
			subLists : {type : "sap.ui.ux3.ExactList", multiple : true, singularName : "subList"}, 
	
			/**
			 * Hidden aggregation for internal Listbox
			 */
			controls : {type : "sap.ui.commons.ListBox", multiple : true, singularName : "control", visibility : "hidden"}
		},
		associations : {
	
			/**
			 * The associated ExactAttribute
			 */
			data : {type : "sap.ui.ux3.ExactAttribute", multiple : false}
		},
		events : {
	
			/**
			 * Event which is fired when an attribute is selected/unselected
			 */
			attributeSelected : {
				parameters : {
	
					/**
					 * The attribute which was selected/unselected recently
					 */
					attribute : {type : "sap.ui.ux3.ExactAttribute"}, 
	
					/**
					 * Array of all ExactAttributes
					 */
					allAttributes : {type : "object"}
				}
			}
		}
	}});
	
	
	/**
	 * Constructor for a new ExactList.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Internal sub-control of the ExactBrowser. The control is not intended to be used stand alone. For this purpose, the ExactBrowser control can be used.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE 
	 * @version 1.15.1-SNAPSHOT
	 *
	 * @constructor   
	 * @private
	 * @name sap.ui.ux3.ExactList
	 */
	
	(function() {
	
	
	//Private extension of the ListBox control
	ListBox.extend("sap.ui.ux3.ExactList.LB", {
		init : function() {
			ListBox.prototype.init.apply(this, arguments);
			this.setAllowMultiSelect(true);
			this.setDisplayIcons(true);
			this.addStyleClass("sapUiUx3ExactLstLb");
		},
		
		invalidate : function() {
			ListBox.prototype.invalidate.apply(this, arguments);
			if (!this.bInvalidated && this.getParent()) {
				this.getParent().invalidate();
			}
			this.bInvalidated = true;
		},
		
		_handleUserActivation : function(oEvent) {
			oEvent.metaKey = true;
			ListBox.prototype._handleUserActivation.apply(this, [oEvent]);
		},
		
		onclick : function(oEvent) {
			ListBox.prototype.onclick.apply(this, arguments);
			this.getParent().onclick(oEvent);
		},
		
		onAfterRendering : function() {
			ListBox.prototype.onAfterRendering.apply(this, arguments);
			this.bInvalidated = false;
			var oParent = this.getParent();
			
			var items = this.getItems();
			var bIsTop = oParent._isTop();
			var bHasChildren = false;
			for (var i = 0; i < items.length; i++) {
				var oItem = items[i];
				var oExactAttr = sap.ui.getCore().byId(oItem.getKey());
				var jItem = oItem.$();
				bHasChildren = false;
				if (bIsTop || (!oExactAttr || !oExactAttr.getShowSubAttributesIndicator_Computed())) {
					jItem.addClass("sapUiUx3ExactLstNoIco");
					bHasChildren = bIsTop;
				} else {
					bHasChildren = true;
				}
				
				if (bHasChildren && !bIsTop) {
					jItem.attr("aria-label", oParent._rb.getText(
							jItem.hasClass("sapUiLbxISel") ? "EXACT_LST_LIST_ITEM_SEL_ARIA_LABEL" : "EXACT_LST_LIST_ITEM_ARIA_LABEL", [oItem.getText()]
					));
				}
			}
	
			var sPos = oParent._bRTL ? "left" : "right";
			jQuery(".sapUiLbxITxt", this.getDomRef()).css("margin-" + sPos, 20 + jQuery.sap.scrollbarSize().width + "px");
			jQuery(".sapUiLbxIIco", this.getDomRef()).css(sPos, 5 + jQuery.sap.scrollbarSize().width + "px");
	
			jQuery(this.getDomRef()).attr("tabindex", "-1");
	
			var sListLabel;
			if (bIsTop) {
				sListLabel = oParent.getTopTitle();
			} else {
				sListLabel = oParent._rb.getText("EXACT_LST_LIST_ARIA_LABEL", [oParent._iLevel, oParent._getAtt().getText()]);
			}
			jQuery(this.getFocusDomRef()).attr("aria-label", sListLabel).attr("aria-expanded", "true");
	
			this.oItemNavigation.iActiveTabIndex = -1; //Do not set the tabindex to 0 on the focused list item
			this.oItemNavigation.setSelectedIndex( -1); //Reset the selected index always -> focus is set by the item navigation on the last focused item
			
			//The item navigation should not handle the arrow left and right keys
			this.oItemNavigation.onsapnext = function(oEvent) {
				if (oEvent.keyCode != jQuery.sap.KeyCodes.ARROW_DOWN) {
					return;
				}
				sap.ui.core.delegate.ItemNavigation.prototype.onsapnext.apply(this, arguments);
			};
			this.oItemNavigation.onsapprevious = function(oEvent) {
				if (oEvent.keyCode != jQuery.sap.KeyCodes.ARROW_UP) {
					return;
				}
				sap.ui.core.delegate.ItemNavigation.prototype.onsapprevious.apply(this, arguments);
			};
		},
	
		renderer: "sap.ui.commons.ListBoxRenderer"
	});
	
	
	
	/**
	 * Does the setup when the control is created.
	 * @private
	 */
	ExactList.prototype.init = function(){
		var that = this;
		
		this._iLevel = 0;
	
		this._bCollapsed = false; //Indicates whether the control is horizontally collapsed
		this._bIsFirstRendering = true; //Set to false when the first rendering was done (used to animate the first opening)
	
		this._rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
	
		//Create the used ListBox control
		this._lb = new ExactList.LB(this.getId() + "-lb", {
			select: function(oEvent){
				setHeaderText(that);
				var sKey = oEvent.getParameter("selectedItem").getKey();
				var oAttr = sap.ui.getCore().byId(sKey);
				var iSelectedIndex = oEvent.getParameter("selectedIndex");
				if (that._lb.isIndexSelected(iSelectedIndex)) {
					//select
					oAttr.setProperty("selected", true, true);
					var oSubList = createExactListForAttribute(that, oAttr);
					if (oSubList) {
						var idx = getIndexForNewSubList(that, oAttr);
						if (idx < 0) {
							that.addSubList(oSubList);
						} else {
							that.insertSubList(oSubList, idx);
						}
					}
				} else {
					//deselect
					clearAttribute(that, oAttr, iSelectedIndex);
				}
	
				getTopList(that)._selectionChanged(oAttr);
			}
		});
		this.addAggregation("controls", this._lb);
	
		this._closeHandle = jQuery.proxy(this.onForceVerticalClose, this);
	};
	
	
	/**
	 * Does all the cleanup when the control is to be destroyed.
	 * Called from Element's destroy() method.
	 * @private
	 */
	ExactList.prototype.exit = function() {
		if (this.bIsDestroyed) {
			return;
		}
		clearChangeListener(this);
		this._lb.removeAllItems(); //remove items first before destroy the list (see getOrCreateListItem function: items are reused)
		this._lb = null; //Destroy is called when the aggregation "controls" is cleaned up
		this._closeHandle = null;
		this._scrollCheckHandle = null;
		this._rb = {getText: function(){return "";}};
		this._oTopList = null;
		if (this._dirtyListsCleanupTimer) {
			jQuery.sap.clearDelayedCall(this._dirtyListsCleanupTimer);
			this._dirtyListsCleanupTimer = null;
			this._dirtyLists = null;
		}
	};
	
	
	/**
	 * @see sap.ui.core.Element.prototype.getFocusDomRef
	 * @private
	 */
	ExactList.prototype.getFocusDomRef = function() {
		if (this._isTop() && this.$().hasClass("sapUiUx3ExactLstTopHidden")) {
			return this.getDomRef("foc");
		}
		return this._bCollapsed ? this.getDomRef("head") : this._lb.getFocusDomRef();
	};
	
	
	/**
	 * Called before the re-rendering is started.
	 * @private
	 */
	ExactList.prototype.onBeforeRendering = function() {
		this._oTopList = null;
		if (!this._bIsFirstRendering) {
			return;
		}
		
		this._bRTL = sap.ui.getCore().getConfiguration().getRTL();
		
		//Init the open animation (like expand, no Open Animation when the control is the top list)
		if (!this._isTop()) {
			this._bCollapsed = true;
			
			//see also function collapseHorizontally
			this._oCollapseStyles = {
				"cntnt": "margin-" + (this._bRTL ? "right" : "left") + ":" + Parameters.get("sapUiUx3ExactLstCollapseWidth") + ";border-top-width:0px;",
				"lst": "width:0px;"
			};
		} else {
			this._bIsFirstRendering = false;
		}
	};
	
	
	/**
	 * Called when the rendering is complete.
	 * @private
	 */
	ExactList.prototype.onAfterRendering = function() {
		var that = this;
		var bIsTop = this._isTop();
	
		if (!this._iCurrentWidth) {
			this._iCurrentWidth = this._getAtt().getWidth();
		}
	
		if (bIsTop) {
			//Register listener on content overflow for scrollbar
			this._iScrollWidthDiff = -1;
			this.onCheckScrollbar();
			this.$("lst").css("bottom", jQuery.sap.scrollbarSize().height + "px");
			
			this.$("cntnt").bind("scroll", function(oEvent){
				if (oEvent.target.id === that.getId() + "-cntnt" && oEvent.target.scrollTop != 0) {
					oEvent.target.scrollTop = 0;
				}
			});
		}
		
		
	
		if (!this._bCollapsed) {
			setWidth(this, this._iCurrentWidth);
		}
	
		//Init the header text
		setHeaderText(this);
	
		if (this._bIsFirstRendering) {
			//Open Animation
			this._bIsFirstRendering = false;
			collapseHorizontally(this, false, null, true);
		} else {
			//Adapt the scrolling behavior and show the vertical list expander if necessary
			refreshScrollBehaviour(this);
			
			//Refresh the header text width in case the list is collapsed
			refreshCollapseHeaderTextWidth(this);
		}
		
		if (this._bRefreshList) {
			this._bRefreshList = false;
			setTimeout(function(){
				that._lb.invalidate();
			}, 0);
		}
	};
	
	
	//********* EVENTING *********
	
	
	/**
	 * Called when the control gets the focus.
	 * @private
	 */
	ExactList.prototype.onfocusin = function(oEvent) {
		if (oEvent.target === this.getDomRef()) {
			this.getFocusDomRef().focus();
		}
		var $head = this.$("head");
		if (this._isTop()) {
			$head.attr("tabindex", "-1");
			this.$("foc").attr("tabindex", "-1");
			if (!isTopHeaderFocusable(this) && oEvent.target === $head[0]) {
				this.getFocusDomRef().focus();
			}
			
			if (this.$().hasClass("sapUiUx3ExactLstTopHidden") && oEvent.target === this.getDomRef("foc")) {
				var aLists = this.getSubLists();
				if (aLists.length > 0) {
					aLists[0].getFocusDomRef().focus();
				}
			}
		}
		if (!oEvent.__exactHandled) {
			$head.addClass("sapUiUx3ExactLstHeadFocus");
			oEvent.__exactHandled = true;
		}
	};
	
	
	/**
	 * Called when the control loses the focus.
	 * @private
	 */
	ExactList.prototype.onfocusout = function(oEvent) {
		var $head = this.$("head");
		if (this._isTop()) {
			$head.attr("tabindex", "0");
			this.$("foc").attr("tabindex", "0");
		}
		$head.removeClass("sapUiUx3ExactLstHeadFocus");
	};
	
	
	/**
	 * Called when the control is clicked.
	 * @private
	 */
	ExactList.prototype.onclick = function(oEvent) {
		var s = this._lb.getScrollTop();
		if (jQuery(oEvent.target).attr("id") == this.getId() + "-exp") {
			//Toggle the vertically Collapse state
			toggleVerticalCollapseState(this);
			this.focus();
			// If the list is expanded, stop the event from bulling up the lists and focus the main
			// list which might be outside the scrolling area.
			oEvent.stopPropagation();
		} else if (jQuery(oEvent.target).attr("id") == this.getId() + "-close") {
			//Close this list
			close(this);
		} else if (jQuery(oEvent.target).attr("id") == this.getId() + "-hide") {
			//Toggle the horizontally Collapse state
			collapseHorizontally(this, !this._bCollapsed, oEvent);
		} else if (this._isTop() && isTopHeaderFocusable(this) && jQuery.sap.containsOrEquals(this.$("head")[0], oEvent.target)) {
			fireHeaderPress(this, oEvent, false);
			return;
		} else if (!jQuery.sap.containsOrEquals(this.$("cntnt")[0], oEvent.target)) {
			this.focus();
		}
		this._lb.setScrollTop(s);
	};
	
	
	/**
	 * Called when a key is pressed.
	 * @private
	 */
	ExactList.prototype.onkeydown = function(oEvent) {
		function _handleKeyEvent(oEvent, oTargetDomRef){
			if (jQuery(oTargetDomRef).hasClass("sapUiUx3ExactLstFoc")) {
				return;
			}
			
			if (oTargetDomRef) {
				oTargetDomRef.focus();
			}
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
		
		switch (oEvent.keyCode) {
			case jQuery.sap.KeyCodes.ENTER:
			case jQuery.sap.KeyCodes.SPACE:
				if (this._isTop() && isTopHeaderFocusable(this) && jQuery.sap.containsOrEquals(this.$("head")[0], oEvent.target)) {
					fireHeaderPress(this, oEvent, true);
				}
				break;
		
			case jQuery.sap.KeyCodes.DELETE:
				//If close functionality is active -> Close the control and deselect the corresponding attribute
				if (!this._isTop() && this.getShowClose()) {
					close(this);
					_handleKeyEvent(oEvent, this.getParent().getFocusDomRef());
				}
				break;
	
			case jQuery.sap.KeyCodes.NUMPAD_MINUS:
				/* if (!!(oEvent.metaKey || oEvent.ctrlKey)) { //NUMPAD_MINUS + CTRL: Collapse list vertically
					//Deactivated on request of UX
					var jListContRef = this.$("lst");
					if(jListContRef.hasClass("sapUiUx3ExactLstExpanded") && this.$("exp").is(":visible")){
						toggleVerticalCollapseState(this);
					}
					oEvent.preventDefault();
					oEvent.stopPropagation();
				} else */ if (oEvent.shiftKey) { //NUMPAD_MINUS + SHIFT: Make width smaller
					if (!this._bCollapsed) {
						setWidth(this, this._iCurrentWidth - 10);
						_handleKeyEvent(oEvent);
					}
				} else if (!this._bCollapsed) { //NUMPAD_MINUS: Collapse list horizontally
					collapseHorizontally(this, true, oEvent);
				}
				break;
	
			case jQuery.sap.KeyCodes.NUMPAD_PLUS:
				/* if (!!(oEvent.metaKey || oEvent.ctrlKey)) { //NUMPAD_PLUS + CTRL: Expand list vertically
					//Deactivated on request of UX
					var jListContRef = this.$("lst");
					if(!jListContRef.hasClass("sapUiUx3ExactLstExpanded") && this.$("exp").is(":visible")){
						toggleVerticalCollapseState(this);
					}
					oEvent.preventDefault();
					oEvent.stopPropagation();
				} else */ 
				if (oEvent.shiftKey) { //NUMPAD_PLUS + SHIFT: Make width larger
					if (!this._bCollapsed) {
						setWidth(this, this._iCurrentWidth + 10);
						_handleKeyEvent(oEvent);
					}
				} else if (this._bCollapsed) { //NUMPAD_PLUS: Expand list horizontally
					collapseHorizontally(this, false, oEvent);
				}
				break;
	
			case jQuery.sap.KeyCodes.TAB:
				//Handle Tabbing
				if (this._iLevel == 0) {
					var bHeaderFocusable = isTopHeaderFocusable(this);
					if (!oEvent.shiftKey && bHeaderFocusable && jQuery.sap.containsOrEquals(this.$("head")[0], oEvent.target)) {
						_handleKeyEvent(oEvent, this.getFocusDomRef());
					} else if (jQuery.sap.containsOrEquals(this.getFocusDomRef(), oEvent.target)) {
						if (oEvent.shiftKey && bHeaderFocusable) {
							_handleKeyEvent(oEvent, this.$("head")[0]);
						} else if (!oEvent.shiftKey) {
							var oSubList = getSuccessorList(this);
							if (oSubList) {
								_handleKeyEvent(oEvent, oSubList.getFocusDomRef());
							}
						}
					}
					return;
				}
				
				if (this._iLevel == 1) {
					var oSubList = null;
					if (oEvent.shiftKey) {
						if (jQuery.sap.containsOrEquals(this.$("cntnt")[0], oEvent.target)) {
							oSubList = this;
						} else {
							oSubList = getPredecessorList(this);
						}
					} else {
						oSubList = getSuccessorList(this);
					}
					if (oSubList) {
						_handleKeyEvent(oEvent, oSubList.getFocusDomRef());
					}
					oEvent.stopPropagation();
				}
				break;
				
			case jQuery.sap.KeyCodes.ARROW_LEFT:
			case jQuery.sap.KeyCodes.ARROW_RIGHT:
				var oSubList = null;
				if (this._iLevel >= 1) {
					if ((this._bRTL && oEvent.keyCode === jQuery.sap.KeyCodes.ARROW_LEFT)
							|| (!this._bRTL && oEvent.keyCode === jQuery.sap.KeyCodes.ARROW_RIGHT)) {
						oSubList = getSuccessorList(this, true);
					} else {
						oSubList = getPredecessorList(this, true);
					}
					if (oSubList) {
						_handleKeyEvent(oEvent, oSubList.getFocusDomRef());
					}
					oEvent.stopPropagation();
				}
				break;
		}
	};
	
	
	/**
	 * Called when mousedown event appears. -> Starting point for the resizing
	 * @private
	 */
	ExactList.prototype.onmousedown = function(oEvent) {
		if (oEvent.target.id === this.getId() + "-rsz") {
			jQuery(document.body).append(
					"<div id=\"" + this.getId() + "-ghost\" class=\"sapUiUx3ExactLstRSzGhost\" style =\" z-index:" + Popup.getNextZIndex() + "\" ></div>");
	
			// Fix for IE text selection while dragging
			jQuery(document.body).bind("selectstart." + this.getId(), onStartSelect);
	
			var jHandle = !!sap.ui.Device.browser.internet_explorer ? jQuery(document.body) : this.$("ghost");
			jHandle.bind("mouseup." + this.getId(), jQuery.proxy(onRelease, this)).bind("mousemove." + this.getId(), jQuery.proxy(onMove, this));
				
			this._iStartDragX = oEvent.pageX;
			this._iStartWidth  = this.$("lst").width();
	
			this.$("rsz").addClass("sapUiUx3ExactLstRSzDrag");
		}
	};
	
	
	/**
	 * Called when the vertically Collapse State should be closed immediately (e.g. outer event)
	 * @private
	 */
	ExactList.prototype.onForceVerticalClose = function(oEvent) {
		if (oEvent.type == "mousedown" ||
				oEvent.type == "click" ||
				oEvent.type == "dblclick" ||
				oEvent.type == "focusin" ||
				oEvent.type == "focusout" ||
				oEvent.type == "keydown" ||
				oEvent.type == "keypress" ||
				oEvent.type == "keyup" ||
				oEvent.type == "mousedown" ||
				oEvent.type == "mouseup") {
			var jRef = this.$("lst");
			if (!jQuery.sap.containsOrEquals(jRef[0], oEvent.target) || oEvent.target.tagName == "BODY") {
				if (jRef.hasClass("sapUiUx3ExactLstExpanded")) {
					this._oPopup.close(true);
				}
			}
		}
	};
	
	
	/**
	 * Called periodicly to check whether the content scrollbar must be show or hidden
	 * @private
	 */
	ExactList.prototype.onCheckScrollbar = function(oEvent) {
		this._scrollCheckTimer = null;
	
		var jContentArea = this.$("cntnt");
		var oContentArea = jContentArea[0];
		if (oContentArea) {
			var iNewDiff = oContentArea.scrollWidth - oContentArea.clientWidth;
			if (this._iScrollWidthDiff != iNewDiff) {
				this._iScrollWidthDiff = iNewDiff;
				if (iNewDiff <= 0) {
					//hidden scrollbar
					jContentArea.css({"overflow-x": "hidden", "bottom": jQuery.sap.scrollbarSize().height + "px"});
				} else {
					//visible scrollbar
					jContentArea.css({"overflow-x": "scroll", "bottom": "0px"});
				}
			}
			this._scrollCheckTimer = jQuery.sap.delayedCall(300, this, this.onCheckScrollbar);
		}
	};
	
	
	//********* OVERRIDDEN API FUNCTIONS *********
	
	
	ExactList.prototype.insertSubList = function(oSubList, iIndex) {
		this.insertAggregation("subLists", oSubList, iIndex);
		if (oSubList) {
			setLevel(oSubList, this._iLevel + 1);
		}
		return this;
	};
	
	
	ExactList.prototype.addSubList = function(oSubList) {
		this.addAggregation("subLists", oSubList);
		if (oSubList) {
			setLevel(oSubList, this._iLevel + 1);
		}
		return this;
	};
	
	
	ExactList.prototype.setData = function(vData) {
		if (vData != null && typeof (vData) != "string") {
			vData = vData.getId();
		}
	
		if (vData) {
			//Set the associated ExactAttribute
			this.setAssociation("data", vData);
			vData = this._getAtt();
			this._lb.removeAllItems();
			if (!vData) {
				return this;
			}
			var aAtts = vData.getAttributesInternal(true);
			var aSelectedKeys = [];
			var aLists = [];
			//Update the used ListBox accordingly and create child exact lists
			for (var i = 0; i < aAtts.length; i++) {
				var oItem = getOrCreateListItem(aAtts[i]);
				this._lb.addItem(oItem);
				if (aAtts[i].getSelected()) {
					var oList = createExactListForAttribute(this, aAtts[i]);
					if (oList) {
						aLists.push(oList);
					}
					aSelectedKeys.push(oItem.getKey());
				}
			}
			this._lb.setSelectedKeys(aSelectedKeys);
	
			//Update child lists
			var aOldChildren = this.getSubLists();
			for (var i = 0; i < aOldChildren.length; i++) {
				var idx = jQuery.inArray(aOldChildren[i], aLists);
				if (idx >= 0) {
					if (vData.getListOrder() != sap.ui.ux3.ExactOrder.Fixed /*Select*/) {
						//List is already a sublist -> remove it from the array of lists to add
						aLists.splice(idx, 1);
					}
				} else {
					//List does not exist anymore in the array of lists to add -> destroy it (also removes it from the aggregation)
					aOldChildren[i]._lb.removeAllItems();  //remove items first before destroy the list (see function getOrCreateListItem: items are reused)
					aOldChildren[i].destroy();
				}
			}
			
			if (vData.getListOrder() === sap.ui.ux3.ExactOrder.Fixed) {
				this.removeAllSubLists();
			}
			
			//Append all newly created lists
			for (var i = 0; i < aLists.length; i++) {
				this.addSubList(aLists[i]);
			}
	
			//Set the change listener to the exact attribute
			var that = this;
			vData.setChangeListener({id: that.getId(), _notifyOnChange: function(sType, oAttribute){
				if (sType === "width") {
					if (that._getAtt() === oAttribute && that.getDomRef()) {
						setWidth(that, oAttribute.getWidth());
					}
					return;
				}
				
				var oTopList = getTopList(that);
				if (!oTopList._dirtyLists) {
					oTopList._dirtyLists = {};
				}
				if (!oTopList._dirtyLists[that.getId()]) {
					oTopList._dirtyLists[that.getId()] = that;
				}
				
				if (!oTopList._dirtyListsCleanupTimer) {
					oTopList._dirtyListsCleanupTimer = jQuery.sap.delayedCall(0, oTopList, function(){
						this._dirtyListsCleanupTimer = null;
						jQuery.each(this._dirtyLists, function(i, oList){
							if (oList._lb && oList.getParent()) { //List was not destroyed in the meantime and is still active
								if (!oList._isTop()) {
									oList.getParent().setData(oList.getParent().getData());
								} else {
									oList.setData(oList.getData());
								}
							}
						});
						this._dirtyLists = null;
					}, []);
				}
			}});
		}
	
		return this;
	};
	
	
	ExactList.prototype.setShowClose = function(bShowClose) {
		if (this._isTop()) {
			this.setProperty("showClose", bShowClose);
		}
		return this;
	};
	
	
	ExactList.prototype.getShowClose = function() {
		return getTopList(this).getProperty("showClose");
	};
	
	
	ExactList.prototype.getTopTitle = function() {
		var sTitle = this.getProperty("topTitle");
		return sTitle ? sTitle : this._rb.getText("EXACT_BRWSR_LST_TITLE");
	};
	
	
	//********* GLOBAL HELPERS *********
	
	/**
	 * Returns the associated ExactAttribute.
	 * @private
	 */
	ExactList.prototype._getAtt = function() {
		return sap.ui.getCore().byId(this.getData());
	};
	
	
	/**
	 * Returns <code>true</code>, when this control is the top most in the hierarchy, <code>false</code> otherwise.
	 * @private
	 */
	ExactList.prototype._isTop = function() {
		return !(this.getParent() instanceof ExactList);
	};
	
	
	/**
	 * Handles selections of the whole list tree and fires selection change event.
	 * @private
	 */
	ExactList.prototype._selectionChanged = function(oAttribute) {
		if (!this._isTop()) {
			return;
		}
	
		// In case of TwoWay databinding the attribute might have already changed by now. Make sure
		// We use the correct one.
		// This happened for example when the selected property was bound in the same model as
		// the data for the lists
		oAttribute = sap.ui.getCore().byId(oAttribute.getId());
		
		
		//Computes recursivly all selected attributes and adds them to the given result list
		var _computeSelectedAttributes = function(oAtt, aResult){
			if (!oAtt.getSelected()) {
				return;
			}
			aResult.push(oAtt);
			var aValues = oAtt.getAttributesInternal();
			for (var idx = 0; idx < aValues.length; idx++) {
				_computeSelectedAttributes(aValues[idx], aResult);
			}
		};
	
		var aSelectedAttributes = [];
		var aTopValues = this._getAtt().getAttributesInternal();
		for (var idx = 0; idx < aTopValues.length; idx++) {
			_computeSelectedAttributes(aTopValues[idx], aSelectedAttributes);
		}
	
		
		this.fireAttributeSelected({attribute: oAttribute, allAttributes: aSelectedAttributes});
	};
	
	
	/**
	 * Closes all open sub lists and clears the selection if this list is the top list.
	 *
	 * @private
	 */
	ExactList.prototype._closeAll = function() {
		if (!this._isTop()) {
			return;
		}
	
		var that = this;
	
		var fCallback = function(){
			that._getAtt()._clearSelection();
			that._lb.clearSelection();
			that.fireAttributeSelected({attribute: undefined, allAttributes: []});
		};
	
		var aLists = this.getSubLists();
	
		if (aLists.length > 0) {
			for (var i = 0; i < aLists.length; i++) {
				close(aLists[i], true, i == aLists.length - 1 ? fCallback : null);
			}
		} else {
			fCallback();
		}
	};
	
	
	//********* LOCAL HELPERS *********
	
	//Returns the predecessor of the given list based on the level and whether TAB or the arrow keys are used
	var getPredecessorList = function(oList, bArrow){
		function getPrevOnSameLevel(oLst){
			var oParentRef = oLst.getParent();
			var aParentSubLists = oParentRef.getSubLists();
			var idx = oParentRef.indexOfSubList(oLst) - 1;
			if (idx >= 0) {
				return aParentSubLists[idx];
			}
			return null;
		}
		
		function getListOrLastChild(oLst){
			var aSubLists = oLst.getSubLists();
			if (aSubLists.length > 0) {
				return getListOrLastChild(aSubLists[aSubLists.length - 1]);
			}
			return oLst;
		}
		
		if (oList._iLevel == 0) {
			return null;
		} else if (oList._iLevel == 1) {
			if (bArrow) {
				return null;
			}
			var oPrevList = getPrevOnSameLevel(oList);
			if (oPrevList) {
				return oPrevList;
			}
			return oList.getParent();
		} else if (oList._iLevel > 1) {
			var oPrevList = getPrevOnSameLevel(oList);
			if (oPrevList) {
				return getListOrLastChild(oPrevList);
			}
			var oParent = oList.getParent();
			if (oParent._iLevel >= 1) {
				return oParent;
			}
		}
		return null;
	};
	
	//Returns the successor of the given list based on the level and whether TAB or the arrow keys are used
	var getSuccessorList = function(oList, bArrow){
		function getNextOnSameLevel(oLst){
			var oParent = oLst.getParent();
			var aParentSubLists = oParent.getSubLists();
			var idx = oParent.indexOfSubList(oLst) + 1;
			if (idx < aParentSubLists.length) {
				return aParentSubLists[idx];
			}
			return null;
		}
		
		function getFirstChild(oLst){
			var aSubLists = oLst.getSubLists();
			if (aSubLists.length > 0) {
				return aSubLists[0];
			}
			return null;
		}
		
		function getNext(oLst){
			var oNextListRef = getNextOnSameLevel(oLst);
			if (oNextListRef) {
				return oNextListRef;
			}
			var oParent = oLst.getParent();
			if (oParent._iLevel > (bArrow ? 1 : 0)) {
				return getNext(oParent);
			} else {
				return null;
			}
		}
		
		if (oList._iLevel == 0) {
			return getFirstChild(oList);
		} else if (oList._iLevel == 1) {
			return bArrow ? getFirstChild(oList) : getNextOnSameLevel(oList);
		} else if (oList._iLevel > 1) {
			var oNextList = getFirstChild(oList);
			if (oNextList) {
				return oNextList;
			}
			
			return getNext(oList);
		}
		return null;
	};
	
	var fireHeaderPress = function(oList, oEvent, bKeyboard){
		oList.fireEvent("_headerPress", {
			kexboard: bKeyboard,
			domRef: oList.$("head")
		});
		oEvent.stopPropagation();
	};
	
	var isTopHeaderFocusable = function(oList){
		return !isTopHidden(oList) && oList.$().hasClass("sapUiUx3ExactLstTopActive");
	};
	
	var isTopHidden = function(oList){
		return oList.$().hasClass("sapUiUx3ExactLstTopHidden");
	};
	
	//Returns the index in the sublists of the given list for a new list of the given attribute
	var getIndexForNewSubList = function(oList, oAttr){
		if (oList._getAtt().getListOrder() != sap.ui.ux3.ExactOrder.Fixed /*Select*/) {
			return -1;
		}
		
		var aAttributes = oList._getAtt().getAttributes();
		var idx = 0;
		for (var i = 0; i < aAttributes.length; i++) {
			if (aAttributes[i] === oAttr) {
				break;
			}
			if (aAttributes[i].getChangeListener()) {
				idx++;
			}
		}
		return idx;
	};
	
	var refreshScrollBehaviour = function(oList){
		if (adaptScollBehavior(oList)) {
			oList.$("lst").addClass("sapUiUx3ExactLstLstExp");
	
			if (!oList._oPopup) {
				var fPopupEventHandle = function(oEvent){
					oList._handleEvent(oEvent);
				};
	
				oList._oPopup = new Popup();
	
				if (!sap.ui.Device.browser.firefox) {
					oList._oPopup._fixPositioning = function(oPosition, bRtl) {
						Popup.prototype._fixPositioning.apply(this, arguments);
						if (bRtl) {
							var $Ref = this._$();
							var $Of = jQuery(oPosition.of);
							var iOffset = 0;
							if (oPosition.offset) {
								iOffset = parseInt(oPosition.offset.split(" ")[0], 10);
							}
							$Ref.css("right", (jQuery(window).width() - $Of.outerWidth() - $Of.offset().left + iOffset) + "px");
						}
					};
				}
	
				oList._oPopup.open = function(){
					var jListContRef = oList.$("lst");
					animate(jListContRef, false, -1, function(jRef){
						//Switch the expand icon
						jListContRef.addClass("sapUiUx3ExactLstExpanded");
						oList.$("exp").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(true, false));
						//Remember the current height for closing later and set the height explicitly
						oList.__sOldHeight = jListContRef.css("height");
						jListContRef.css("height", oList.__sOldHeight);
						var jListHeader = oList.$("head");
						//Calculate the target height
						var jListRef = jQuery(oList._lb.getDomRef());
						var iListHeight = jListRef[0].scrollHeight + oList.$("exp").height() + jListRef.outerHeight() - jListRef.height() + 1;
						var iMaxListHeight = jQuery(window).height() - parseInt(jListRef.offset().top, 10) + jQuery(window).scrollTop() - jListHeader.outerHeight();
						var iTargetHeight = Math.min(iListHeight, iMaxListHeight);
						//Set the list as popup content and open the popup
						oList._oPopup.setContent(jListContRef[0]);
						var sOffset = Parameters.get()["sapUiUx3ExactLst" + (oList._isTop() ? "Root" : "") + "ExpandOffset"] || "0 0";
						Popup.prototype.open.apply(oList._oPopup,
								[0, Popup.Dock.BeginTop, Popup.Dock.BeginBottom, jListHeader[0], sOffset, "none none"]);
						oList._bPopupOpened = true;
						return iTargetHeight;
					}, function(jRef){
						//Update BlindLayer of popup
						jListContRef.addClass("sapUiUx3ExactLstExpandedBL");
						oList._oPopup._updateBlindLayer();
						//Adapt the scroll behavior and set the focus
						adaptScollBehavior(oList);
						oList.getFocusDomRef().focus();
						//Bind the event handlers for closing and control events
						jQuery.sap.bindAnyEvent(oList._closeHandle);
						jRef.bind(jQuery.sap.ControlEvents.join(" "), fPopupEventHandle);
					});
				};
				oList._oPopup.close = function(bSkipFocus){
					var jListContRef = oList.$("lst");
					jListContRef.removeClass("sapUiUx3ExactLstExpandedBL");
					animate(jListContRef, false, oList.__sOldHeight, function(jRef){
						//Unbind the event handlers for closing and control events
						jQuery.sap.unbindAnyEvent(oList._closeHandle);
						jRef.unbind(jQuery.sap.ControlEvents.join(" "), fPopupEventHandle);
						//Switch the expand icon
						jListContRef.removeClass("sapUiUx3ExactLstExpanded");
						oList.$("exp").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(false, false));
					}, function(jRef){
						//Move the list to its original position
						jRef.detach();
						jListContRef.removeClass("sapUiShd");
						jRef.attr("style", "width:" + oList._iCurrentWidth + "px;");
						jQuery(oList.getDomRef()).prepend(jRef);
						//Cleanup and close the popup
						oList._oPopup.setContent(null);
						oList._bPopupOpened = undefined;
						oList.__sOldHeight = null;
						if (oList._isTop()) {
							jRef.css("bottom", jQuery.sap.scrollbarSize().height + "px");
						}
						adaptScollBehavior(oList);
						Popup.prototype.close.apply(oList._oPopup, [0]);
						if (!bSkipFocus) {
							oList.getFocusDomRef().focus();
						}
					});
				};
			}
		}
	};
	
	
	//Animates the width or height of the given jRef to the given target value
	//Optional callbacks are possible which are called before and after the animation
	var animate = function(jRef, bWidth, iValue, fDoBefore, fDoAfter){
		if (fDoBefore) {
			var iVal = fDoBefore(jRef);
			if (iVal != undefined) {
				iValue = iVal;
			}
		}
		var _fDoAfter = fDoAfter ? function(){fDoAfter(jRef);} : function(){};
		if (jQuery.fx.off) {
			if (bWidth) {
				jRef.width(iValue);
			} else {
				jRef.height(iValue);
			}
			_fDoAfter();
		} else {
			var oParam = bWidth ? {width: iValue} : {height: iValue};
			jRef.stop(true, true).animate(oParam, 200, 'linear', _fDoAfter);
		}
	};
	
	
	// Handles the StartSelect event during resizing
	// @see sap.ui.ux3.ExactList.prototype.onmousedown
	var onStartSelect = function(oEvent){
		oEvent.preventDefault();
		oEvent.stopPropagation();
		return false;
	};
	
	
	//Handles the MouseMove event during resizing
	//@see sap.ui.ux3.ExactList.prototype.onmousedown
	var onMove = function(oEvent){
		var iCurrentX = oEvent.pageX;
		var iDiff = this._bRTL ? (this._iStartDragX - iCurrentX) : (iCurrentX - this._iStartDragX);
		setWidth(this, this._iStartWidth + iDiff);
	};
	
	
	//Handles the MouseUp event during resizing
	//@see sap.ui.ux3.ExactList.prototype.onmousedown
	var onRelease = function(oEvent){
		jQuery(document.body).unbind("selectstart." + this.getId()).unbind("mouseup." + this.getId()).unbind("mousemove." + this.getId());
		this.$("ghost").remove();
		this.$("rsz").removeClass("sapUiUx3ExactLstRSzDrag");
		this._iStartWidth = undefined;
		this._iStartDragX = undefined;
		this.focus();
	};
	
	
	//Sets the width of the list to the given width (maybe the width is adapted to the allowed range (@see checkWidth))
	var setWidth = function(oList, iWidth){
		iWidth = sap.ui.ux3.ExactAttribute._checkWidth(iWidth);
		var sPos = oList._bRTL ? "right" : "left";
		oList._iCurrentWidth = iWidth;
		oList._getAtt()._setWidth(oList._iCurrentWidth);
		oList.$("lst").css("width", iWidth + "px");
		oList.$("rsz").css(sPos, (iWidth - 4) + "px");
		if (oList._isTop()) {
			if (!isTopHidden(oList)) {
				oList.$("head").css("width", iWidth + "px");
				oList.$("cntnt").css(sPos, (iWidth + 8) + "px");
				oList.$("scroll").css(sPos, (iWidth + 8) + "px");
			}
		} else {
			if (!oList.$().hasClass("sapUiUx3ExactLstCollapsed")) {
				oList.$("cntnt").css("margin-" + sPos, iWidth + "px");
			}
		}
	};
	
	
	//Refresh the header text of the list
	var setHeaderText = function(oList){
		var oAtt = oList._getAtt();
		if (oAtt && !oList._isTop()) {
			oList.$("head-txt").html(jQuery.sap.encodeHTML(oAtt.getText())
					+ "<span class=\"sapUiUx3ExactLstHeadInfo\">&nbsp;(" + oList._lb.getSelectedIndices().length + "/" + oList._lb.getItems().length + ")</span>");
		}
	};
	
	
	//Sets the level of the list and its sublists
	var setLevel = function(oList, iLevel){
		oList._iLevel = iLevel;
		var aLists = oList.getSubLists();
		for (var i = 0; i < aLists.length; i++) {
			setLevel(aLists[i], iLevel + 1);
		}
	};
	
	
	//Adapt the scrolling behavior when not all list items can be shown and return whether adaptation was done or not.
	var adaptScollBehavior = function(oList){
		if (oList._lb) {
			var jListRef = jQuery(oList._lb.getDomRef());
			oList.$("lst").removeClass("sapUiUx3ExactLstScroll");
			if (jListRef.length > 0 && jListRef.outerHeight() < jListRef[0].scrollHeight) {
				oList.$("lst").addClass("sapUiUx3ExactLstScroll");
				return true;
			}
		}
		return false;
	};
	
	
	//Collapses or expands the given list horizontally
	var collapseHorizontally = function(oList, bCollapse, oEvent, bSkipParentTraversal){
		if (oEvent) {
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
		if (oList._isTop()) {
			return;
		}
		if (oList._bCollapsed != bCollapse) {
			//Toggles the horizontal Collapse State
			var bFocus = !!oEvent;
			var cntntAnimParam = {};
			cntntAnimParam["margin-" + (oList._bRTL ? "right" : "left")] = (oList._bCollapsed ?
					(oList._iCurrentWidth + "px") : Parameters.get("sapUiUx3ExactLstCollapseWidth"));
			cntntAnimParam["border-top-width"] = (oList._bCollapsed ?
					Parameters.get("sapUiUx3ExactLstContentTop") : "0px");
			
			var $Ctnt = oList.$("cntnt");
			if (jQuery.fx.off) {
				for (var css in cntntAnimParam) {
					$Ctnt.css(css, cntntAnimParam[css]);
				}
			} else {
				$Ctnt.stop(true, true).animate(cntntAnimParam, 200, 'linear');
			}
			
			if (oList._bCollapsed) {
				//expand
				animate(oList.$("lst"), true, oList._iCurrentWidth + "px", function() {
					jQuery(oList.getDomRef()).removeClass("sapUiUx3ExactLstCollapsed");
					oList.$("head").css("overflow", "hidden");
				}, function($Ref) {
					oList.$("hide")
						.html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(true, true))
						.attr("title", oList._rb.getText("EXACT_LST_LIST_COLLAPSE"));
					if (bFocus) {
						oList.focus();
					}
					var $head = oList.$("head");
					oList.$("head-txt").removeAttr("style");
					$head.removeAttr("style");
					$Ref.removeAttr("style");
					refreshScrollBehaviour(oList);
					setWidth(oList, oList._iCurrentWidth);
					refreshCollapseHeaderTextWidth(oList);
					
					$head.removeAttr("role");
					$head.removeAttr("aria-label");
					$head.removeAttr("aria-expanded");
					
					var oAtt = oList._getAtt();
					if (oAtt && oAtt._scrollToAttributeId) {
						oAtt.scrollTo(sap.ui.getCore().byId(oAtt._scrollToAttributeId));
					}
					
				});
				
				oList._oCollapseStyles = undefined;
			} else {
				oList._oCollapseStyles = {};
				
				//collapse
				animate(oList.$("lst"), true, 0, null, function() {
					jQuery(oList.getDomRef()).addClass("sapUiUx3ExactLstCollapsed");
					oList.$("hide")
						.html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(false, true))
						.attr("title", oList._rb.getText("EXACT_LST_LIST_EXPAND"));
					if (bFocus) {
						oList.focus();
					}
					refreshCollapseHeaderTextWidth(oList);
					
					var $head = oList.$("head");
					$head.attr("role", "region");
					$head.attr("aria-label", oList._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL", [oList._iLevel, oList._getAtt().getText()]));
					$head.attr("aria-expanded", "false");
				});
				
				//Remember the current styles for rerendering
				var aStyles = [];
				for (var css in cntntAnimParam) {
					aStyles.push(css, ":", cntntAnimParam[css], ";");
				}
				oList._oCollapseStyles["cntnt"] = aStyles.join("");
				oList._oCollapseStyles["lst"] = "width:0px;";
			}
			
			oList._bCollapsed = !oList._bCollapsed;
		}
		
		if (bSkipParentTraversal) {
			return;
		}
		var oParent = oList.getParent();
		if (!oList._isTop() && oParent && oParent._isTop && !oParent._isTop()) {
			collapseHorizontally(oParent, bCollapse);
		}
	};
	
	
	//Refreshs the header text width of all collapsed lists
	var refreshCollapseHeaderTextWidth = function(oList) {
		if (oList._bCollapsed) {
			var iWidth = oList.$("cntnt").height() - 50/*Space for Header Action Buttons - Maybe provide theme parameter in future*/;
			var $txt = oList.$("head-txt");
			$txt.css("width", iWidth + "px");
			if (jQuery("html").attr("data-sap-ui-browser") == "ie8") {
				//A text with 90px width is correct aligned when bottom:75px is set
				var iBottom = 75 - (90 - iWidth);
				$txt.css("bottom", iBottom + "px");
			}
		}
		var aSubLists = oList.getSubLists();
		for (var i = 0; i < aSubLists.length; i++) {
			refreshCollapseHeaderTextWidth(aSubLists[i]);
		}
	};
	
	
	//Toggles the vertical Collapse State
	var toggleVerticalCollapseState = function(oList){
		var jListContRef = oList.$("lst");
		if (jListContRef.hasClass("sapUiUx3ExactLstExpanded")) {
			//collapse
			oList._oPopup.close();
		} else {
			//expand
			oList._oPopup.open();
		}
	};
	
	
	//Handles the close of the list
	var close = function(oList, bSkipNotify, fCallback){
		var fFinalize = function(jRef) {
			if (!bSkipNotify) {
				var oAttr = oList._getAtt();
				var iSelectedIndex = oAttr.getParent().indexOfAttribute(oAttr);
				clearAttribute(oList.getParent(), oAttr, iSelectedIndex, true);
				setHeaderText(oList.getParent());
				getTopList(oList)._selectionChanged(oAttr);
			}
			oList.destroy();
			if (fCallback) {
				fCallback();
			}
		};
	
		var oListRef = oList.getDomRef();
		if (oListRef) {
			animate(jQuery(oListRef), true, 0, function(jRef) {
				jRef.css("overflow", "hidden");
			}, fFinalize);
		} else {
			fFinalize();
		}
	};
	
	
	//Creates a new ExactList for the given attribute if the attribute is selected and does not have a corresponding list yet.
	//If the attribute has a corresponding list already this list is returned.
	var createExactListForAttribute = function(oList, oAttribute) {
		if (oAttribute.getSelected()) {
			var aAttributes = oAttribute.getAttributesInternal(true);
			if (aAttributes.length > 0) {
				var oSubList;
				if (oAttribute.getChangeListener()) {
					oSubList = sap.ui.getCore().byId(oAttribute.getChangeListener().id);
				} else {
					oSubList = new ExactList();
				}
	
				oSubList.setData(oAttribute);
				return oSubList;
			}
		}
	
		return null;
	};
	
	
	//Sets the selection property of the given attribute and all its sub-attributes to false.
	//Additionally the given index in the lists ListBox is unselected. ExactLists which corresponds
	//to the cleared attributes are closed if bSkipNotify is not set.
	var clearAttribute = function(oList, oAttribute, iSelectedIndex, bSkipNotify){
		oList._lb.removeSelectedIndex(iSelectedIndex);
		oAttribute._clearSelection();
		if (!bSkipNotify) {
			var aSubLists = oList.getSubLists();
			for (var i = 0; i < aSubLists.length; i++) {
				if (aSubLists[i].getData() === oAttribute.getId()) {
					close(aSubLists[i], true);
				}
			}
		}
	};
	
	
	//Removes the change listener which is attached to the lists attribute.
	var clearChangeListener = function(oList) {
		var oAttr = oList._getAtt();
		if (oAttr && oAttr.getChangeListener() && oAttr.getChangeListener().id === oList.getId()) {
			oAttr.setChangeListener(null);
		}
	};
	
	
	//Returns the top most list.
	var getTopList = function(oList) {
		if (oList._isTop()) {
			return oList;
		}
		if (!oList._oTopList) {
			oList._oTopList = getTopList(oList.getParent());
		}
		return oList._oTopList;
	};
	
	
	var getOrCreateListItem = function(oAttribute){
		var oItem;
		if (oAttribute.__oItem) {
			oItem = oAttribute.__oItem;
			if (oItem.getText() != oAttribute.getText()) {
				oItem.setText(oAttribute.getText());
			}
			if (oItem.getKey() != oAttribute.getId()) {
				oItem.setKey(oAttribute.getId());
			}
		} else {
			oItem = new sap.ui.core.ListItem({text:oAttribute.getText(), key: oAttribute.getId()});
			oAttribute.exit = function() {
				if (sap.ui.ux3.ExactAttribute.prototype.exit) {
					sap.ui.ux3.ExactAttribute.prototype.exit.apply(oAttribute, []);
				}
				this.__oItem.destroy();
				this.__oItem = null;
			};
			oAttribute.__oItem = oItem;
		}
		return oItem;
	};
	
	
	}());
	
	
	//Override docu of the "internal" aggregation subLists.
	
	/**
	 * Getter for aggregation <code>subLists</code>.<br/>
	 * The sub ExactLists of this list. This aggregation must not be maintained from outside. The control automatically takes care to fill this aggregation according to the given ExactAttribute.
	 *
	 * @return {sap.ui.ux3.ExactList[]}
	 * @protected
	 */
	
	/**
	 * Inserts a subList into the aggregation named <code>subLists</code>.
	 *
	 * @param {sap.ui.ux3.ExactList}
	 *          oSubList the subList to insert; if empty, nothing is inserted
	 * @param {int}
	 *             iIndex the <code>0</code>-based index the subList should be inserted at; for
	 *             a negative value of <code>iIndex</code>, the subList is inserted at position 0; for a value
	 *             greater than the current size of the aggregation, the subList is inserted at
	 *             the last position
	 * @return {sap.ui.ux3.ExactList} <code>this</code> to allow method chaining
	 * @protected
	 */
	
	/**
	 * Adds some subList <code>oSubList</code>
	 * to the aggregation named <code>subLists</code>.
	 *
	 * @param {sap.ui.ux3.ExactList}
	 *            oSubList the subList to add; if empty, nothing is inserted
	 * @return {sap.ui.ux3.ExactList} <code>this</code> to allow method chaining
	 * @protected
	 */
	
	/**
	 * Removes an subList from the aggregation named <code>subLists</code>.
	 *
	 * @param {int | string | sap.ui.ux3.ExactList} vSubList the subList to remove or its index or id
	 * @return {sap.ui.ux3.ExactList} the removed subList or null
	 * @protected
	 */
	
	/**
	 * Removes all the controls in the aggregation named <code>subLists</code>.<br/>
	 * Additionally unregisters them from the hosting UIArea.
	 * @return {sap.ui.ux3.ExactList[]} an array of the removed elements (might be empty)
	 * @protected
	 */
	
	/**
	 * Checks for the provided <code>sap.ui.ux3.ExactList</code> in the aggregation named <code>subLists</code>
	 * and returns its index if found or -1 otherwise.
	 *
	 * @param {sap.ui.ux3.ExactList}
	 *            oSubList the subList whose index is looked for.
	 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
	 * @protected
	 */
	
	/**
	 * Destroys all the subLists in the aggregation
	 * named <code>subLists</code>.
	 * @return {sap.ui.ux3.ExactList} <code>this</code> to allow method chaining
	 * @protected
	 */
	

	return ExactList;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ExactList.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.FacetFilter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.FacetFilter.
jQuery.sap.declare('sap.ui.ux3.FacetFilter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/FacetFilter",['jquery.sap.global', 'sap/ui/core/Control', './library'],
	function(jQuery, Control, library) {
	"use strict";


	
	/**
	 * Constructor for a new FacetFilter.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * FacetFilter Control.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.FacetFilter
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FacetFilter = Control.extend("sap.ui.ux3.FacetFilter", /** @lends sap.ui.ux3.FacetFilter.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
			/**
			 * If the value is "Auto" - the Facet Filter takes the whole available height. If "Fixed" , then the default number of Facet Filter Items (5) is visible.
			 */
			visibleItemCountMode : {type : "sap.ui.ux3.VisibleItemCountMode", group : "Appearance", defaultValue : sap.ui.ux3.VisibleItemCountMode.Fixed}
		},
		aggregations : {
	
			/**
			 * Facet Filter list represents the list of the filter values and the title of this list.
			 */
			lists : {type : "sap.ui.ux3.FacetFilterList", multiple : true, singularName : "list"}
		}
	}});
	
	FacetFilter.prototype.init = function() {
		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};
	

	return FacetFilter;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/FacetFilter.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.FacetFilterList') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.FacetFilterList.
jQuery.sap.declare('sap.ui.ux3.FacetFilterList'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.ListBox'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/FacetFilterList",['jquery.sap.global', 'sap/ui/commons/ListBox', 'sap/ui/core/Control', './library'],
	function(jQuery, ListBox, Control, library) {
	"use strict";


	
	/**
	 * Constructor for a new FacetFilterList.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * List to be used with the FacetFilter control. The control is not intended to be used stand alone.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.FacetFilterList
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FacetFilterList = Control.extend("sap.ui.ux3.FacetFilterList", /** @lends sap.ui.ux3.FacetFilterList.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * The title of this list.
			 */
			title : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Specifies whether multiple or single selection is used.
			 */
			multiSelect : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Specifies whether the text values from the additionalText property (see sap.ui.core.ListItems) shall be displayed.
			 * @since 1.9.0
			 */
			displaySecondaryValues : {type : "boolean", group : "Misc", defaultValue : false},
	
			/**
			 * Array of type string containing the selected keys.
			 */
			selectedKeys : {type : "string[]", group : "Misc", defaultValue : null},
	
			/**
			 * Specifies whether the counter for all entries is shown.
			 */
			showCounter : {type : "boolean", group : "Behavior", defaultValue : true}
		},
		aggregations : {
	
			/**
			 * The filter values that are presented as a list.
			 */
			items : {type : "sap.ui.core.ListItem", multiple : true, singularName : "item"}, 
	
			/**
			 * ListBoxes that are managed by this FacetFilterList
			 */
			controls : {type : "sap.ui.commons.ListBox", multiple : true, singularName : "control", visibility : "hidden"}
		},
		events : {
	
			/**
			 * On Select event.
			 */
			select : {
				parameters : {
	
					/**
					 * Id of the FacetFilterList taht fires the event.
					 */
					id : {type : "string"}, 
	
					/**
					 * Array of selected Indices.
					 */
					selectedIndices : {type : "int[]"}, 
	
					/**
					 * Array of selected Items.
					 */
					selectedItems : {type : "sap.ui.core.ListItem[]"}, 
	
					/**
					 * If it is true, then Item All is selected. That means all items in the list are selected - no filter is set.
					 */
					all : {type : "boolean"}
				}
			}
		}
	}});
	
	
	(function() {
	
	/**
	 * Does the setup when the control is created.
	 * @private
	 */
	FacetFilterList.prototype.init = function(){
	
	    // Get the translatable text
		this._oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
	
		//For later use
		//this._bAccMode = sap.ui.getCore().getConfiguration().getAccessibility();
		//this._bRtlMode = sap.ui.getCore().getConfiguration().getRTL();
	
		//Create the used ListBox control
		this._oListBox = new ListBox(this.getId() + "-lb");
		this._oListBox.setScrollTop(0);
		this._oListBox.setValueTextAlign("Begin");
		this._oListBox.setDisplaySecondaryValues(this.getDisplaySecondaryValues());
		this._oListBox.setDisplayIcons(false);
		this._oListBox.setEditable(true);
		this._oListBox.setEnabled(true);
		this._oListBox.setVisible(true);
		this._oListBox.setAllowMultiSelect(this.getMultiSelect());
		this._oListBox.addAriaLabelledBy(this.getId() + "-head-txt");
		var that = this;
		//Attach to the ListBox select event
		this._oListBox.attachSelect(function(oEvent) {
			that.onSelect(that, oEvent);
		});
		this.addAggregation("controls", this._oListBox);
		this._oItemAll = new sap.ui.core.ListItem({text: this._oResBundle.getText("FACETFILTER_ALL", [0]), key:"sapUiFacetFilter_ALL"});
		this._oListBox.addItem(this._oItemAll);
	};
	
	FacetFilterList.prototype.setMultiSelect = function(bMultiSelect) {
		this._oListBox.setAllowMultiSelect(bMultiSelect);
		this.setProperty("multiSelect", bMultiSelect, true);
	};
	
	FacetFilterList.prototype.setDisplaySecondaryValues = function(bDisplaySecondaryValues) {
		this._oListBox.setDisplaySecondaryValues(bDisplaySecondaryValues);
		this.setProperty("displaySecondaryValues", bDisplaySecondaryValues, true);
	};
	
	FacetFilterList.prototype.addItem = function(oItem) {
		this._oListBox.addItem(oItem);
		if (!oItem.getKey() || jQuery.trim(oItem.getKey()) == "" ) {
			oItem.setKey("generatedkey" + this.indexOfItem(oItem));
		}
		this.updateText4All();
	};
	
	FacetFilterList.prototype.insertItem = function(oItem, iIndex) {
		this._oListBox.insertItem(oItem, iIndex + 1); // +1 because of entry "all" on the fist position.
		if (!oItem.getKey() || jQuery.trim(oItem.getKey()) == "" ) {
			oItem.setKey("generatedkey" + this.indexOfItem(oItem));
		}
		this.updateText4All();
	};
	
	FacetFilterList.prototype.removeItem = function(oItem) {
		this._oListBox.removeItem(oItem);
		this.updateText4All();
	};
	
	FacetFilterList.prototype.removeAllItems = function() {
		this._oListBox.removeAllItems();
		this._oListBox.addItem(this._oItemAll);
		this.updateText4All();
	};
	
	FacetFilterList.prototype.destroyItems = function() {
		this._oListBox.removeItem(this._oItemAll);
		this._oListBox.destroyItems();
		this._oListBox.addItem(this._oItemAll);
		this.updateText4All();
	};
	
	FacetFilterList.prototype.indexOfItem = function(oItem) {
		var iIndex = this._oListBox.indexOfItem(oItem);
		if (iIndex > -1) { // index values -1, -2 and 0 stay unchanged
			iIndex = iIndex - 1;
		}
		return iIndex;
	};
	
	FacetFilterList.prototype.getItems = function() {
		var aListItems = this._oListBox.getItems();
		var aItems = [];
		for (var i = 1; i < aListItems.length; i++) {
			aItems.push(aListItems[i]);
		}
		return aItems;
	};
	
	FacetFilterList.prototype.setSelectedKeys = function(aSelectedKeys) {
		this.setProperty("selectedKeys", aSelectedKeys);
		this.invalidate();
	};
	
	FacetFilterList.prototype.setShowCounter = function(bShowCounter) {
		this.setProperty("showCounter", bShowCounter);
		this.updateText4All();
	};
	
	/**
	 *
	 * @private
	 */
	FacetFilterList.prototype.updateText4All = function() {
		if (this.getShowCounter()) {
			this._oItemAll.setText( this._oResBundle.getText("FACETFILTER_ALL", [this._oListBox.getItems().length - 1]));
		} else {
			this._oItemAll.setText( this._oResBundle.getText("FACETFILTER_NO_COUNT"));
		}
	};
	
	/**
	 * Used for after-rendering initialization.
	 *
	 * @private
	 */
	FacetFilterList.prototype.onBeforeRendering = function() {
		if (!this.bFullHeight) {
			this._oListBox.setVisibleItems(5);
		}
		
		var aKeys = this.getSelectedKeys();
		if (aKeys && aKeys.length > 0) {
			this._oListBox.setSelectedKeys(aKeys);
			this._bAllOnly = false;
		} else {
			this._oListBox.setSelectedKeys(["sapUiFacetFilter_ALL"]);
			this._bAllOnly = true;
		}
	};
	
	FacetFilterList.prototype.updateItems = function(){
	
		this.updateAggregation("items");
	
		var aSelectedKeys = this._oListBox.getSelectedKeys();
		//if no selection at all - mark ALL
		if (aSelectedKeys.length == 0) {
			aSelectedKeys = ["sapUiFacetFilter_ALL"];
			this._bAllOnly = true;
			this._oListBox.setSelectedKeys(aSelectedKeys);
		}
	
	};
	
	//Handles the select event of the used ListBox control
	FacetFilterList.prototype.onSelect = function(oFFList, oEvent) {
	    var aSelectedKeys = this._oListBox.getSelectedKeys();
	    //if no selection at all - mark ALL
	    if (aSelectedKeys.length == 0) {
				aSelectedKeys = ["sapUiFacetFilter_ALL"];
				this._bAllOnly = true;
				this._oListBox.setSelectedKeys(aSelectedKeys);
	    }
	    var iIndexAll = jQuery.inArray("sapUiFacetFilter_ALL", aSelectedKeys);
	    if (iIndexAll > -1) {
				if (aSelectedKeys.length == 1) {
					this._bAllOnly = true;
				} else {
					if (this._bAllOnly) {
						aSelectedKeys.splice(iIndexAll,1);
						this._bAllOnly = false;
					} else {
						aSelectedKeys = ["sapUiFacetFilter_ALL"];
						this._bAllOnly = true;
					}
					this._oListBox.setSelectedKeys(aSelectedKeys);
				}
	    } else {
				this._bAllOnly = false;
	    }
	
		this.setProperty("selectedKeys", aSelectedKeys, true);
		
		var aSelectedIndices = [];
		var aSelectedItems = [];
		var aAllSelectedItems = this._oListBox.getSelectedItems();
		if (!this._bAllOnly) {
			 for (var i = 0; i < aAllSelectedItems.length; i++) {
				 if (aAllSelectedItems[i] != this._oItemAll) {
					 aSelectedIndices.push(this.indexOfItem(aAllSelectedItems[i]));
					 aSelectedItems.push(aAllSelectedItems[i]);
				 }
			 }
		}
		
		this.fireSelect({
			id:oFFList.getId(),
			all:this._bAllOnly,
			selectedIndices: aSelectedIndices,
			selectedItems: aSelectedItems
		});
	};
	
	}());
	

	return FacetFilterList;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/FacetFilterList.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.Feeder') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.Feeder.
jQuery.sap.declare('sap.ui.ux3.Feeder'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Button'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/Feeder",['jquery.sap.global', 'sap/ui/commons/Button', 'sap/ui/core/Control', 'sap/ui/core/theming/Parameters', './library'],
	function(jQuery, Button, Control, Parameters, library) {
	"use strict";


	
	/**
	 * Constructor for a new Feeder.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This feed control flavor represents a lean common feed, or a comment feed, with a text commit function.
	 * The control can be used stand alone or in a multiple way, and generally would be integrated directly into a UIArea.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.2. 
	 * The whole Feed/Feeder API is still under discussion, significant changes are likely. Especially text presentation (e.g. @-references and formatted text) is not final. Also the Feed model topic is still open.
	 * @alias sap.ui.ux3.Feeder
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Feeder = Control.extend("sap.ui.ux3.Feeder", /** @lends sap.ui.ux3.Feeder.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * URL to the thumb nail image
			 * This property is optional if the feeder is a sub-control of a feed or a feedChunk control. In this case the value of the feed or feddChunk control is used if it's not set. So it must be only set once on the feed or feedChunk control.
			 */
			thumbnailSrc : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
	
			/**
			 * The text for the Feeder. @References are supported.
			 */
			text : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Type and size of the Feeder
			 */
			type : {type : "sap.ui.ux3.FeederType", group : "Appearance", defaultValue : sap.ui.ux3.FeederType.Large},
	
			/**
			 * This property could be used for costum placeholder. If it is not set, the default text is used.
			 */
			placeholderText : {type : "string", group : "Appearance", defaultValue : null}
		},
		events : {
	
			/**
			 * Event is fired when the entered text is submitted
			 */
			submit : {
				parameters : {
	
					/**
					 * The text that is submitted
					 */
					text : {type : "string"}
				}
			}
		}
	}});
	
	
	/**
	 * This file defines behavior for the control,
	 */
	
	Feeder.prototype.init = function(){
		this.rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
		this.oSendButton = new Button( this.getId() + "-send", {
				style: sap.ui.commons.ButtonStyle.Emph,
				icon: "sap-icon://feeder-arrow"
			}).setParent(this);
		this.oSendButton.attachEvent('press', this.handleSendButtonPress, this); // attach event this way to have the right this-reference in handler
	
	};
	
	/*
	 * as onBeforeRendering only runs while re-rendering this module is called in renderer
	 */
	Feeder.prototype.initSendButton = function(){
		if (this.getText() == "") {
			// no re-rendering as button is not rendered now.
			this.oSendButton.setProperty('enabled', false, true);
		}
	
	};
	
	Feeder.prototype.exit = function(){
		this.rb = undefined;
		this.oInput = undefined;
		if (this.oSendButton) {
			this.oSendButton.destroy();
			delete this.oSendButton;
		}
	};
	
	/**
	 * After rendering, keep the input field jQuery object as attribute
	 * for reuse
	 *
	 * @private
	 */
	Feeder.prototype.onAfterRendering = function () {
		this.oInput = this.$("input");
	};
	
	/**
	 * handler for click event
	 *
	 * @private
	 */
	Feeder.prototype.onclick = function(oEvent){
	
		var sTargetId = oEvent.target.getAttribute( 'ID' );
	
		switch ( sTargetId ) {
		case ( this.getId() + '-send' ):
			// Click on send button (should be handled in button)
		break;
		case ( this.getId() + '-input'):
			// Click on input field
	
		break;
		default:
	
		break;
		}
	
	};
	
	/**
	 * handler for focusIn
	 *
	 * If the Feeder is empty the default text must be cleared
	 * @private
	 */
	Feeder.prototype.onfocusin = function(oEvent){
	
		this.oInput.find(".sapUiFeederEmptyText").remove();
	
	};
	
	/**
	 * handler for focusOut
	 *
	 * If the Feeder is empty the default text written
	 * @private
	 */
	Feeder.prototype.onfocusout = function(oEvent){
	
		var sText = this.oInput.text();
		if (sText == "") {
			this.oInput.empty(); // to remove invisible line breaks and so on
			this.oInput.append(sap.ui.ux3.FeederRenderer.getEmptyTextInfo(this));
		}
	
		this.setProperty("text", sText, true); // no rerendering!
	
	};
	
	// overrides sap.ui.core.Element.getFocusDomRef()
	Feeder.prototype.getFocusDomRef = function(){
		return this.getDomRef("input");
	};
	
	/**
	 * handler for keyUp
	 *
	 * if text is entered the button must be enables, if empty it must be disabled
	 * @private
	 */
	Feeder.prototype.onkeyup = function(oEvent){
	
		if (this.oInput.text() == "") {
			this.oSendButton.setEnabled(false);
		} else {
			this.oSendButton.setEnabled(true);
		}
	
		//Clean input so we avoid having invisible DOM content
	//	if(!this.oInput.text()){
	//		this.oInput.empty();
	//	}
	
	};
	
	/**
	 * Handler for send-button press
	 *
	 * @private
	 */
	Feeder.prototype.handleSendButtonPress = function(oEvent){
	
		var sText = this.getMultilineText(this.oInput);
		this.setProperty("text", sText, true); // no rerendering!
		this.fireSubmit({text: sText});
		this.setText(''); // clear text after submit
	
	};
	
	/**
	 * get multiline text from input DIV
	 *
	 * @param {object} [oInput] jQuery object of the input field
	 *
	 * @private
	 */
	Feeder.prototype.getMultilineText = function(oInput) {
	
		function parseText(nodes) {
	
			var node;
			var sText = '';
	
			for (var i = 0; i < nodes.length; i++) {
				node = nodes[i];
	
				// text / cdata
				if (node.nodeType === 3 || node.nodeType === 4) {
	
					// ignore non-breakable space in IE
					if (!(!!sap.ui.Device.browser.internet_explorer && node.nodeValue === '\xA0')) {
						sText += node.nodeValue.replace(/\n/g, ''); // filter out line breaks in text-nodes
					}
				}
	
				// check for "linebreaking"-nodes
				if (node.nodeName === 'DIV' ||
						node.nodeName ===  'P' ||
						(node.nodeName === 'BR' && !sap.ui.Device.browser.webkit)) { // ignore BR in webkit
	
					// ignore last <br> with type="_moz" in mozilla
					if (node.nodeName === 'BR' &&
						!!sap.ui.Device.browser.firefox &&
						i === nodes.length - 1 &&
						jQuery(node).attr("type") === "_moz") {
						continue;
					}
	
					// do not add a newline if no text was found until now (IE)
					if (!(!!sap.ui.Device.browser.internet_explorer && sText === '') &&
	
						// same as above but only for <P> and webkit/mozilla
						!((!!sap.ui.Device.browser.firefox || !!sap.ui.Device.browser.webkit) && sText === '' && node.nodeName ===  'P') &&
	
						// ignore <P>'s containing linebreaks only (\n)
						!(!!sap.ui.Device.browser.webkit && node.nodeName ===  'P' && node.textContent.match(/^(\n)*$/))) {
	
						sText += '\n';
					}
	
				}
	
				// parse child elements, ignore comments in mozilla
				if (node.nodeType !== 8) {
					sText += parseText(node.childNodes);
				}
	
			}
	
			return sText;
		}
	
		return parseText(oInput.get(0).childNodes);
	};
	
	/*
	 * Overwrite standard getter for thumbnail source:
	 * If not set and feeder is child of a Feed or FeedChunk use the thumbnailsource of the parent
	 * So it must not be set manually for each sub-control and is always in sync
	 */
	Feeder.prototype.getThumbnailSrc = function() {
		var sThumbnailSrc =  this.getProperty("thumbnailSrc");
	
		if (!sThumbnailSrc || sThumbnailSrc == "") {
			var oParent = this.getParent();
			if (oParent && (oParent instanceof sap.ui.ux3.Feed || oParent instanceof sap.ui.ux3.FeedChunk)) {
				sThumbnailSrc = oParent.getFeederThumbnailSrc();
			}
		}
	
		return sThumbnailSrc;
	};
	
	Feeder.prototype.onpaste = function(oEvent){
	
		// call after paste function delayed to have content already pasted (in the moment only needed in FireFox)
		if (!!sap.ui.Device.browser.firefox) {
			jQuery.sap.delayedCall(10, this, "onAfterPaste");
		}
	
	};
	
	Feeder.prototype.onAfterPaste = function(){
	
		// if pasted from MS Word in FireFox text is longer that contenteditable DIV
		// -> add overflow:hidden to PRE elements
		var aChildren = this.oInput.get(0).childNodes;
	
		for ( var i = 0; i < aChildren.length; i++) {
			var oChild = aChildren[i];
			if (oChild.nodeName == "PRE") {
				jQuery(oChild).css("overflow", "hidden");
			}
		}
	
	};

	return Feeder;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/Feeder.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.NavigationBar') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.NavigationBar.
jQuery.sap.declare('sap.ui.ux3.NavigationBar'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.dom'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/NavigationBar",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation', './library', 'jquery.sap.dom'],
	function(jQuery, Control, ItemNavigation, library/* , jQuerySap */) {
	"use strict";


	
	/**
	 * Constructor for a new NavigationBar.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Provides enhanced navigation capabilities and is the parent control of NavigationItem. It is displayed in the form of a horizontal line
	 * with switching markers depending on the currently selected item. The size of an item which is currently chosen by the user is enlarged. In the case
	 * that a large number of items are defined for the bar, this is made transparent to the user by showing symbols for scrolling options (forwards and backwards)
	 * to see the next or previous items.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.NavigationBar
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var NavigationBar = Control.extend("sap.ui.ux3.NavigationBar", /** @lends sap.ui.ux3.NavigationBar.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * Defines whether the navigation bar shall have top-level appearance
			 */
			toplevelVariant : {type : "boolean", group : "Misc", defaultValue : false}
		},
		defaultAggregation : "items",
		aggregations : {
	
			/**
			 * If the navigation items need to have a different parent than the NavigationBar, alternatively the associatedItems association can be used.
			 * The NavigationBar follows the approach to use the items aggregation. If this aggregation is empty, associatedItems is used.
			 */
			items : {type : "sap.ui.ux3.NavigationItem", multiple : true, singularName : "item"}, 
	
			/**
			 * Hidden aggregation for the overflow menu if applicable
			 */
			overflowMenu : {type : "sap.ui.commons.Menu", multiple : false, visibility : "hidden"}
		},
		associations : {
	
			/**
			 * The selected NavigationItem.
			 */
			selectedItem : {type : "sap.ui.ux3.NavigationItem", multiple : false}, 
	
			/**
			 * This association is ignored as long as the items aggregation is used; and supposed to be used alternatively when the items should be aggregated by other
			 * entities.
			 */
			associatedItems : {type : "sap.ui.ux3.NavigationItem", multiple : true, singularName : "associatedItem"}
		},
		events : {
	
			/**
			 * Event is fired when an item is selected by the user
			 */
			select : {allowPreventDefault : true,
				parameters : {
	
					/**
					 * The ID of the newly selected NavigationItem.
					 */
					itemId : {type : "string"}, 
	
					/**
					 * The newly selected NavigationItem.
					 */
					item : {type : "sap.ui.ux3.NavigationItem"}
				}
			}
		}
	}});
	
	
	NavigationBar.SCROLL_STEP = 250; // how many pixels to scroll with every overflow arrow click
	//sap.ui.ux3.NavigationBar._MAX_ITEM_WIDTH = 300;
	
	NavigationBar.prototype.init = function() {
		this._bPreviousScrollForward = false; // remember the item overflow state
		this._bPreviousScrollBack = false;
		this._iLastArrowPos = -100; // this property is always read and applied as "left"/"right" depending on RTL configuration
		this._bRtl = sap.ui.getCore().getConfiguration().getRTL();
	
		this.allowTextSelection(false);
	
	
		this.startScrollX = 0;
		this.startTouchX = 0;
		var that = this;
	
		// Initialize the ItemNavigation
		this._oItemNavigation = new ItemNavigation().setCycling(false);
		this.addDelegate(this._oItemNavigation);
		
		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	
		if (jQuery.sap.touchEventMode === "ON") {
			var fnTouchStart = function(evt) {
				evt.preventDefault();
	
				// stop any inertia scrolling
				if (that._iInertiaIntervalId) {
					window.clearInterval(that._iInertiaIntervalId);
				}
	
				that.startScrollX = that.getDomRef("list").scrollLeft;
				that.startTouchX = evt.touches[0].pageX;
				that._bTouchNotMoved = true;
				that._lastMoveTime = new Date().getTime();
			};
	
			var fnTouchMove = function(evt) {
				var dx = evt.touches[0].pageX - that.startTouchX;
	
				var oListRef = that.getDomRef("list");
				var oldScrollLeft = oListRef.scrollLeft;
				var newScrollLeft = that.startScrollX - dx;
				oListRef.scrollLeft = newScrollLeft;
				that._bTouchNotMoved = false;
	
				// inertia scrolling: prepare continuation even after touchend by calculating the current velocity
				var dt = new Date().getTime() - that._lastMoveTime;
				that._lastMoveTime = new Date().getTime();
				if (dt > 0) {
					that._velocity = (newScrollLeft - oldScrollLeft) / dt;
				}
	
				evt.preventDefault();
			};
	
			var fnTouchEnd = function(evt) {
				if (that._bTouchNotMoved === false) { // swiping ends now
					evt.preventDefault();
	
					// add some inertia... continue scrolling with decreasing velocity
					var oListRef = that.getDomRef("list");
					var dt = 50;
					var endVelocity = Math.abs(that._velocity / 10); // continue scrolling until the speed has decreased to a fraction (v/10 means 11 iterations with slowing-down factor 0.8)
					that._iInertiaIntervalId = window.setInterval(function(){
						that._velocity = that._velocity * 0.80;
						var dx = that._velocity * dt;
						oListRef.scrollLeft = oListRef.scrollLeft + dx;
						if (Math.abs(that._velocity) < endVelocity) {
							window.clearInterval(that._iInertiaIntervalId);
							that._iInertiaIntervalId = undefined;
						}
					}, dt);
	
				} else if (that._bTouchNotMoved === true) { //touchstart and touchend without move is a click; trigger it directly to avoid the usual delay
					that.onclick(evt);
					evt.preventDefault();
				} //else  touchend without corresponding start do nothing special
				that._bTouchNotMoved = undefined;
				that._lastMoveTime = undefined;
			};
	
			this.ontouchstart = fnTouchStart;
			this.ontouchend = fnTouchEnd;
			this.ontouchmove = fnTouchMove;
		}
	
	};
	
	NavigationBar.prototype.exit = function () {
		if (this._oItemNavigation) {
			this.removeDelegate(this._oItemNavigation);
			this._oItemNavigation.destroy();
			delete this._oItemNavigation;
		}

		if (this._checkOverflowIntervalId) {
			jQuery.sap.clearIntervalCall(this._checkOverflowIntervalId);
			this._checkOverflowIntervalId = null;
		}

		// no super.exit() to call
	};
	
	
	NavigationBar.prototype.onBeforeRendering = function() {
		// stop the periodic overflow checker
		if (this._checkOverflowIntervalId) {
			jQuery.sap.clearIntervalCall(this._checkOverflowIntervalId);
			this._checkOverflowIntervalId = null;
		}
	
		if (!!sap.ui.Device.browser.firefox) { // TODO: feature detection... not used yet because of performance implications (may involve creating elements)
			this.$().unbind("DOMMouseScroll", this._handleScroll);
		} else {
			this.$().unbind("mousewheel", this._handleScroll);
		}
	
		var arrow = this.getDomRef("arrow");
		this._iLastArrowPos = arrow ? parseInt(this._bRtl ? arrow.style.right : arrow.style.left, 10) : -100;
	};
	
	
	NavigationBar.prototype.invalidate = function(oSource) {
		// In case the source of invalidation is a navigation item, it most likely changed something
		// that we have to reflect in the overflow-menu
		if (oSource instanceof sap.ui.ux3.NavigationItem) {
			this._menuInvalid = true;
		}
		Control.prototype.invalidate.apply(this, arguments);
	};
	
	/**
	 * Calculates the (initial) position of the indicator-arrow and the overflow-arrows
	 * 
	 * @private
	 */
	NavigationBar.prototype._calculatePositions = function() {
		var oDomRef = this.getDomRef();
		
		// re-initialize display of scroll arrows
		this._bPreviousScrollForward = false;
		this._bPreviousScrollBack = false;
		this._checkOverflow(oDomRef.firstChild, this.getDomRef("ofb"), this.getDomRef("off"));
	};
	
	/**
	 * Attaches to a themechange and recalculates the positions of the arrows in the NavigationBar
	 */
	NavigationBar.prototype.onThemeChanged = function() {
		if (this.getDomRef()) {
			this._calculatePositions();
		}
	};
	
	
	NavigationBar.prototype.onAfterRendering = function() {
		var oDomRef = this.getDomRef();
	
		// start the periodic checking for overflow of the item area
		var oListDomRef = oDomRef.firstChild;
		var of_back = this.getDomRef("ofb");
		var of_fw = this.getDomRef("off");
		this._checkOverflowIntervalId = jQuery.sap.intervalCall(350, this, "_checkOverflow", [oListDomRef,of_back,of_fw]);
	
		// bind a scroll handler to the workset item area
		if (!!sap.ui.Device.browser.firefox) { // TODO: feature detection... not used yet because of performance implications (may involve creating elements)
			jQuery(oDomRef).bind("DOMMouseScroll", jQuery.proxy(this._handleScroll, this));
		} else {
			jQuery(oDomRef).bind("mousewheel", jQuery.proxy(this._handleScroll, this));
		}
	
		this._calculatePositions();
		
		this._updateItemNavigation();
		
		// Workaround for sporadic weird scrolling behavior in NavigationBar when there is 
		// mobile content in the Shell.
		// TODO: We should get to the bottom of why this happens, but after 6 hours of debugging, I give up.
		// See for example CSS 0120061532 0002361191 2013 - HPAs had the same problems
		// This happens in the BC as well as GC theme
		var $NavBar = this.$();
		$NavBar.on("scroll", function() {
			$NavBar.children().scrollTop(0);
			$NavBar.scrollTop(0);
		});
	};
	
	
	NavigationBar.prototype._updateItemNavigation = function() {
		var oDomRef = this.getDomRef();
		if (oDomRef) {
			// reinitialize the ItemNavigation after rendering
			var iSelectedDomIndex = -1;
			var sSelectedId = this.getSelectedItem();
	
			var $ItemRefs = jQuery(oDomRef).children().children("li").children().not(".sapUiUx3NavBarDummyItem");
			$ItemRefs.each(function(index, element) {
				if (element.id == sSelectedId) {
					iSelectedDomIndex = index;
				}
			});
	
			this._oItemNavigation.setRootDomRef(oDomRef);
			this._oItemNavigation.setItemDomRefs($ItemRefs.toArray());
			this._oItemNavigation.setSelectedIndex(iSelectedDomIndex);
		}
	};
	
	
	NavigationBar.prototype.onsapspace = function(oEvent) {
		this._handleActivation(oEvent);
	};
	
	NavigationBar.prototype.onclick = function(oEvent) {
		this._handleActivation(oEvent);
	};
	
	
	NavigationBar.prototype._handleActivation = function(oEvent) {
		var sTargetId = oEvent.target.id;
	
		if (sTargetId) {
			var sId = this.getId();
			
			// For items: do not navigate away! Stay on the page and handle the click in-place. Right-click + "Open in new Tab" still works.
			// For scroll buttons: Prevent IE from firing beforeunload event -> see CSN 4378288 2012
			oEvent.preventDefault();
	
			if (sTargetId == sId + "-ofb") {
				// scroll back/left button
				this._scroll( -NavigationBar.SCROLL_STEP, 500);
	
			} else if (sTargetId == sId + "-off") {
				// scroll forward/right button
				this._scroll(NavigationBar.SCROLL_STEP, 500);
			} else if (sTargetId == sId + "-oflt" || sTargetId == sId + "-ofl") {
				// Overflow Button has been activated
				this._showOverflowMenu();
			} else {
				// should be one of the items - select it
				
				var item = sap.ui.getCore().byId(sTargetId);
				if (item
						&& (sTargetId != this.getSelectedItem())
						&& (sap.ui.getCore().byId(sTargetId) instanceof sap.ui.ux3.NavigationItem)) {
					// select the item and fire the event
					if (this.fireSelect({item:item,itemId:sTargetId})) {
						this.setAssociation("selectedItem", item, true); // avoid rerendering, animate
						this._updateSelection(sTargetId);
					}
				}
			}
		}
	};
	
	
	/**
	 * Return the overflow Menu, creates it if it does not exist. 
	 * 
	 * @returns {sap.ui.commons.Menu}
	 */
	NavigationBar.prototype._getOverflowMenu = function() {
		var oMenu = this.getAggregation("overflowMenu");
		if (!oMenu || this._menuInvalid) {
			// TODO: Check with new destroy-behavior: The Menu might not be there because it was already destroyed. In that case this might create a memory leak.
			if (oMenu) {
				oMenu.destroyAggregation("items", true);
			} else {
				oMenu = new sap.ui.commons.Menu();
			}
	
			var aItems = this._getCurrentItems();
			var that = this;
			var sSelectedId = this.getSelectedItem();
			
			for (var i = 0; i < aItems.length; ++i) {
				var oNavItem = aItems[i];
				
				var oMenuItem = new sap.ui.commons.MenuItem(oNavItem.getId() + "-overflowItem", {
					text : oNavItem.getText(),
					visible : oNavItem.getVisible(),
					// Like the normal NavigationBar Items, disabled items are shown and handled
					// like enabled items. The application can check the item for its 
					// enabled-property
					/* enabled : oNavItem.getEnabled(), */
					icon : sSelectedId == oNavItem.getId() ? "sap-icon://accept" : null,
					/* eslint-disable no-loop-func */
					select : (function(oNavItem) { 
						return function(oEvent) {
							that._handleActivation({
								target : { id : oNavItem.getId() },
								preventDefault : function() { /* Ignore */ }
							});
						};
					})(oNavItem)
					/* eslint-enable no-loop-func */
				});
				oMenu.addAggregation("items", oMenuItem, true);
			}
	
			this.setAggregation("overflowMenu", oMenu, true);
			this._menuInvalid = false;
		}
		
		return oMenu;
	};
	
	/**
	 * Returns the items added to the items aggregation, or (if empty) the items that are
	 * referred to in the associatedItems association.
	 */
	NavigationBar.prototype._getCurrentItems = function() {
		var aItems = this.getItems();
		if (aItems.length < 1) {
			aItems = this.getAssociatedItems();
	
			var oCore = sap.ui.getCore();
			for (var i = 0; i < aItems.length; ++i) {
				aItems[i] = oCore.byId(aItems[i]);
			}
		}
		
		return aItems;
	};
	
	
	/**
	 * Shows the menu items that do not fit into the navigation bar. Or in the case of overflow being
	 * set to MenuAndButtons: All items (since we cannot know what is currently scrolled into view).
	 */
	NavigationBar.prototype._showOverflowMenu = function() {
		var oMenu = this._getOverflowMenu();
		var oTarget = this.$("ofl").get(0);
	
		oMenu.open(
			true, // First item highlighted. Check whether this is the correct behavior
			oTarget,
			sap.ui.core.Popup.Dock.EndTop,
			sap.ui.core.Popup.Dock.CenterCenter,
			oTarget
		);
	};
	
	
	/**
	 * Visually adapts the NavigationBar to the new selection, using animations instead of re-rendering.
	 *
	 * @param sItemId may be null, which means all selection is removed
	 * @private
	 */
	NavigationBar.prototype._updateSelection = function(sItemId) {
		this._menuInvalid = true;
	
		// update the css classes to make the selected item larger etc.
		var $newSel = jQuery.sap.byId(sItemId);
		$newSel.attr("tabindex", "0").attr("aria-checked", "true");
		$newSel.parent().addClass("sapUiUx3NavBarItemSel");
		$newSel.parent().parent().children().each(function(){
			var a = this.firstChild;
			if (a && (a.id != sItemId) && (a.className.indexOf("Dummy") == -1)) {
				jQuery(a).attr("tabindex", "-1"); // includes arrow and dummy, but does not hurt TODO?
				jQuery(a).parent().removeClass("sapUiUx3NavBarItemSel");
				jQuery(a).attr("aria-checked", "false");
			}
		});
	
		// let the ItemNavigation know about the new selection
		var iSelectedDomIndex = $newSel.parent().index();
		if (iSelectedDomIndex > 0) {
			iSelectedDomIndex--; // if a selected element is found, its index in the ItemNavigation is the DOM index minus the dummy element, which is the first sibling
		}
		this._oItemNavigation.setSelectedIndex(iSelectedDomIndex);
	
		// make the arrow slide to the selected item
		var $Arrow = this.$("arrow");
		var arrowWidth = $Arrow.outerWidth();
		var targetPos = NavigationBar._getArrowTargetPos(sItemId, arrowWidth, this._bRtl);
		$Arrow.stop(); // stop any ongoing animation
		var animation_1 = this._bRtl ? {right:targetPos + "px"} : {left:targetPos + "px"};
		$Arrow.animate(animation_1, 500, "linear");
		var that = this;
		window.setTimeout(function(){ // because the items resize (for 300ms), interrupt and adjust the animation in the middle
			targetPos = NavigationBar._getArrowTargetPos(sItemId, arrowWidth, that._bRtl);
			$Arrow.stop();
			var animation_2 = that._bRtl ? {right:targetPos + "px"} : {left:targetPos + "px"};
			$Arrow.animate(animation_2, 200, "linear", function(){
				var item = jQuery.sap.domById(sItemId);
				that._scrollItemIntoView(item);
			});
		}, 300);
	};
	
	NavigationBar.prototype._scrollItemIntoView = function(item) {
		if (!item) {
			return;
		}
		
		var li = jQuery(item.parentNode);
		var ul = li.parent();
		var targetPos;
		var bRtl = sap.ui.getCore().getConfiguration().getRTL();
	
		// special handling for first and last item to not only scroll them into view but to scroll to the very start/end
		var index = li.index() - 1; // -1 because of leading dummy item
		if (index == 0) {
			targetPos = bRtl ? (ul[0].scrollWidth - ul.innerWidth() + 20) : 0; // +20 to account for margins etc.
		} else if (index == li.siblings().length - 2) { // siblings() excludes the item itself, but (apart from the already subtracted dummy) also the arrow => -2
			targetPos = bRtl ? 0 : (ul[0].scrollWidth - ul.innerWidth() + 20); // +20 to account for margins etc.
		} else {
			var liLeft = li.position().left;
			var ulScrollLeft = bRtl ? ul.scrollLeftRTL() : ul.scrollLeft();
			
			if (liLeft < 0) {
				// item cut at the left => scroll right to make it left-aligned
				targetPos = ulScrollLeft + liLeft;
			} else {
				var rightDistance = ul.innerWidth() - (liLeft + li.outerWidth(true));  // the distance from the right item edge to the end of the ul; negative if the item is cut
				if (rightDistance < 0) {
					targetPos = ulScrollLeft - rightDistance; // rightDistance is negative, add its amount to the current scroll amount
					// but now it might be that we scroll so far to the left that the left part of the item is hidden, which may not happen!
					targetPos = Math.min(targetPos, ulScrollLeft + liLeft);
				}
			}
		}
	
		if (targetPos !== undefined) {
			if (bRtl) {
				targetPos = jQuery.sap.denormalizeScrollLeftRTL(targetPos, ul.get(0)); // fix browser differences*/
			}
			ul.stop(true, true).animate({scrollLeft: targetPos}); // should be a string like "-50px"
		}
	};
	
	/**
	 * Calculates the required position of the selection arrow to highlight the item with the given ID.
	 * If null is given, the position will be outside the visible area.
	 *
	 * If bRight is set, the distance to the *right* border will be returned (instead of the normal position from left),
	 * this can be used for RTL mode.
	 *
	 * @static
	 * @private
	 */
	NavigationBar._getArrowTargetPos = function(sTargetItemId, arrowWidth, bRight) {
		var $Item = jQuery.sap.byId(sTargetItemId);
		if ($Item.length > 0) {
			var width = $Item.outerWidth(); //Math.min($Item.outerWidth(), sap.ui.ux3.NavigationBar._MAX_ITEM_WIDTH);
			var leftDistance = Math.round($Item[0].offsetLeft + (width / 2) - (arrowWidth / 2));
			if (!bRight) {
				return leftDistance;
			} else {
				return $Item.parent().parent().innerWidth() - leftDistance - arrowWidth;
			}
		} else {
			return -100;
		}
	};
	
	
	/**
	 * Handles a mouse scroll event, scrolling the items if possible.
	 *
	 * @param oEvent
	 * @private
	 */
	NavigationBar.prototype._handleScroll = function(oEvent) {
		if (oEvent.type == "DOMMouseScroll") { // Firefox
			var scrollAmount = oEvent.originalEvent.detail * 40; // in FF you get 3 ticks at once, *40 gives reasonable speed
			this._scroll(scrollAmount, 50);          // scroll fast to avoid temporal overlap
		} else { // other browsers
			var scrollAmount = -oEvent.originalEvent.wheelDelta; // in IE you get 120 as basic amount, direction is inverted
			this._scroll(scrollAmount, 50);          // scroll fast to avoid temporal overlap
		}
		oEvent.preventDefault(); // do not scroll the window (?)
	};
	
	
	/**
	 * Scrolls the items if possible, using an animation.
	 *
	 * @param iDelta how far to scroll
	 * @param iDuration how long to scroll (ms)
	 * @private
	 */
	NavigationBar.prototype._scroll = function(iDelta, iDuration) {
		var oDomRef = this.$()[0].firstChild;
		var iScrollLeft = oDomRef.scrollLeft;
		if (!sap.ui.Device.browser.internet_explorer && this._bRtl) {
			iDelta = -iDelta;
		} // RTL lives in the negative space
		var iScrollTarget = iScrollLeft + iDelta;
		jQuery(oDomRef).stop(true, true).animate({scrollLeft: iScrollTarget}, iDuration);
	};
	
	
	
	/**
	 * Changes the state of the scroll arrows depending on whether they are required due to overflow.
	 *
	 * @param oListDomRef the ul tag containing the items
	 * @param of_back the backward scroll arrow
	 * @param of_fw the forward scroll arrow
	 * @private
	 */
	NavigationBar.prototype._checkOverflow = function(oListDomRef, of_back, of_fw) {

		function isChromeOnMac() {
			return sap.ui.Device.os.macintosh && sap.ui.Device.browser.chrome;
		}

		if (oListDomRef && this.getDomRef() && jQuery.sap.act.isActive()) {
			var iScrollLeft = oListDomRef.scrollLeft;

			// check whether scrolling to the left is possible
			var bScrollBack = false;
			var bScrollForward = false;

			var realWidth = oListDomRef.scrollWidth;
			var availableWidth = oListDomRef.clientWidth;

			// Exceptional case for Chrome on Mac OS
			// Added scroll tolerance to ensure that the arrows are hidden correctly
			// see BCP Internal Incident 1570758438
			var iScrollTolerance = isChromeOnMac() ? 5 : 0;

			if (Math.abs(realWidth - availableWidth) == 1) { // Avoid rounding issues see CSN 1316630 2013
				realWidth = availableWidth;
			}

			if (!this._bRtl) {   // normal LTR mode

				if (iScrollLeft > iScrollTolerance) {
					bScrollBack = true;
				}
				if ((realWidth > availableWidth) && (realWidth - (iScrollLeft + availableWidth) > iScrollTolerance)) {
					bScrollForward = true;
				}
	
			} else {  // RTL mode
				var $List = jQuery(oListDomRef);
				if ($List.scrollLeftRTL() > iScrollTolerance) {
					bScrollForward = true;
				}
				if ($List.scrollRightRTL() > iScrollTolerance) {
					bScrollBack = true;
				}
			}

			// only do DOM changes if the state changed to avoid periodic application of identical values
			if ((bScrollForward != this._bPreviousScrollForward) || (bScrollBack != this._bPreviousScrollBack)) {
				this._bPreviousScrollForward = bScrollForward;
				this._bPreviousScrollBack = bScrollBack;
				this.$().toggleClass("sapUiUx3NavBarScrollBack", bScrollBack)
						.toggleClass("sapUiUx3NavBarScrollForward", bScrollForward);
				if (!NavigationBar._bMenuLoaded && (bScrollBack || bScrollForward)) {
					NavigationBar._bMenuLoaded = true;
					jQuery.sap.require("sap.ui.commons.Menu");
				}
			}
			
			// paint selection arrow in the right place
			var selItem = sap.ui.getCore().byId(this.getSelectedItem());
			if (selItem) {
				var $Arrow = this.$("arrow");
				var arrowWidth = $Arrow.outerWidth();
				var targetPos = NavigationBar._getArrowTargetPos(selItem.getId(), arrowWidth, this._bRtl) + "px";
				if (!this._bRtl) {
					if ($Arrow[0].style.left != targetPos) {
						$Arrow[0].style.left = targetPos;
					}
				} else {
					if ($Arrow[0].style.right != targetPos) {
						$Arrow[0].style.right = targetPos;
					}
				}
			}
		}
	};
	
	
	
	
	/* API methods */
	
	/* overwritten association methods */
	
	NavigationBar.prototype.setSelectedItem = function(vItem) {
		this.setAssociation("selectedItem", vItem, true); // avoid rerendering
		if (this.getDomRef()) {
			var sItemId = (!vItem || (typeof (vItem) == "string")) ? vItem : vItem.getId();
			this._updateSelection(sItemId); // animate selection
		}
	};
	
	
	/* overridden aggregation items */
	
	NavigationBar.prototype.addItem = function(oItem) {
		this._menuInvalid = true;
		return this.addAggregation("items", oItem);
	};
	
	NavigationBar.prototype.destroyItems = function() {
		this._menuInvalid = true;
		return this.destroyAggregation("items");
	};
	
	NavigationBar.prototype.insertItem = function(oItem, iIndex) {
		this._menuInvalid = true;
		return this.insertAggregation("items", oItem, iIndex);
	};
	
	NavigationBar.prototype.removeItem = function(oItem) {
		this._menuInvalid = true;
		return this.removeAggregation("items", oItem);
	};
	
	NavigationBar.prototype.removeAllItems = function() {
		this._menuInvalid = true;
		return this.removeAllAggregation("items");
	};
	
	
	/* overridden association associatedItems */
	
	NavigationBar.prototype.addAssociatedItem = function(vItemOrId) {
		this._menuInvalid = true;
		return this.addAssociation("associatedItems", vItemOrId);
	};
	
	NavigationBar.prototype.removeAssociatedItem = function(vItemOrId) {
		this._menuInvalid = true;
		return this.removeAssociation("associatedItems", vItemOrId);
	};
	
	NavigationBar.prototype.removeAllAssociatedItems = function() {
		this._menuInvalid = true;
		return this.removeAllAssociation("associatedItems");
	};
	
	
	/* API method implementations */
	

	/**
	 * Replaces the currently associated items with the ones in the given array
	 *
	 * @param {sap.ui.ux3.NavigationItem[]} aItems
	 *         The items to associate
	 * @type sap.ui.ux3.NavigationBar
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavigationBar.prototype.setAssociatedItems = function(aItems /* bResetArrowPosition */) { // second parameter is currently not in the public API
		jQuery.sap.assert(jQuery.isArray(aItems), "aItems must be an array");
	
		var oListDomRef = this.getDomRef("list");
	
		// remove old items
		this.removeAllAssociation("associatedItems", true);
	
		// add new items
		for (var i = 0; i < aItems.length; i++) {
			this.addAssociation("associatedItems", aItems[i], true);
		}
	
		// if already rendered, update the UI
		if (oListDomRef) {
			var $FocusRef = jQuery(oListDomRef).find(":focus");
			var focusId = ($FocusRef.length > 0) ? $FocusRef.attr("id") : null;
	
			if (arguments.length > 1 && typeof arguments[1] === "boolean") { // checking for the second, hidden parameter "bResetArrowPosition"
				this._iLastArrowPos = -100;
			} else {
				var arrow = this.getDomRef("arrow");
				this._iLastArrowPos = parseInt(this._bRtl ? arrow.style.right : arrow.style.left, 10);
			}
			
			oListDomRef.innerHTML = "";
			var rm = sap.ui.getCore().createRenderManager();
			
			sap.ui.ux3.NavigationBarRenderer.renderItems(rm, this);
			
			rm.flush(oListDomRef, true);
			rm.destroy();
	
			// restore focus
			var oNewFocusRef;
			if (focusId && (oNewFocusRef = jQuery.sap.domById(focusId))) {
				jQuery.sap.focus(oNewFocusRef);
			}
	
			this._updateSelection(this.getSelectedItem());
	
			// update the item navigation, as the item HTML has changed
			this._updateItemNavigation();
		}
	
		return this;
	};
	
	

	/**
	 * Returns whether there is a selectedItem set which is actually present in the items aggregation; or, if the aggregation is empty, in the associatedItems association.
	 *
	 * @type boolean
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	NavigationBar.prototype.isSelectedItemValid = function() {
		var selId = this.getSelectedItem();
		if (!selId) {
			return false;
		} // no selection means no selected item out of those which are present
	
		var items = this.getItems();
		if (!items || items.length == 0) {
			items = this.getAssociatedItems();
			for (var i = 0; i < items.length; i++) {
				if (items[i] == selId) {
					return true;
				}
			}
		} else {
			for (var i = 0; i < items.length; i++) {
				if (items[i].getId() == selId) {
					return true;
				}
			}
		}
		return false;
	};
	

	return NavigationBar;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/NavigationBar.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.NavigationItem') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.NavigationItem.
jQuery.sap.declare('sap.ui.ux3.NavigationItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Item'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/NavigationItem",['jquery.sap.global', 'sap/ui/core/Item', './library'],
	function(jQuery, Item, library) {
	"use strict";


	
	/**
	 * Constructor for a new NavigationItem.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Is the item to be used within the NavigationBar
	 * @extends sap.ui.core.Item
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.NavigationItem
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var NavigationItem = Item.extend("sap.ui.ux3.NavigationItem", /** @lends sap.ui.ux3.NavigationItem.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * Whether the NavigationItem is currently visible. When making NavigationItems invisible at runtime it is the application's responsibility to make sure it is not the currently selected one - or to select another one in this case.
			 * @since 1.9.0
			 */
			visible : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * Defines the link target URL. This property is optional and should only be set when required!
			 * The use of the href property is to not only allow users to navigate in-place by left-clicking NavigationItems, but also to allow right-click and then "open in new tab" or "open in new window". As long as href is not set, an empty window will open and stay blank. But when href is set, the new window/tab will load this URL and it is the application's responsibility to display what the user expects (e.g. the Shell, with the respective NavigationItem being selected).
			 */
			href : {type : "sap.ui.core.URI", group : "Behavior", defaultValue : null}
		},
		defaultAggregation : "subItems",
		aggregations : {
	
			/**
			 * Any NavigationItems on the next hierarchy level connected to this NavigationItem
			 */
			subItems : {type : "sap.ui.ux3.NavigationItem", multiple : true, singularName : "subItem"}
		}
	}});
	
	

	return NavigationItem;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/NavigationItem.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.NotificationBar') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.NotificationBar.
jQuery.sap.declare('sap.ui.ux3.NotificationBar'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/NotificationBar",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation', 'sap/ui/core/theming/Parameters', './library'],
	function(jQuery, Control, ItemNavigation, Parameters, library) {
	"use strict";


	
	/**
	 * Constructor for a new NotificationBar.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A NotificationBar is a "toolbar" that can be added to a page to show messages and notifications from the application.
	 * Its position, height and width is inherited from the element that the notification bar is added to.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @since 1.7.0
	 * @alias sap.ui.ux3.NotificationBar
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var NotificationBar = Control.extend("sap.ui.ux3.NotificationBar", /** @lends sap.ui.ux3.NotificationBar.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * This property displays the bar corresponding to given status
			 */
			visibleStatus : {type : "sap.ui.ux3.NotificationBarStatus", group : "Misc", defaultValue : sap.ui.ux3.NotificationBarStatus.Default},
	
			/**
			 * This property enables the bar to be resized by the user.
			 */
			resizeEnabled : {type : "boolean", group : "Misc", defaultValue : true},
			
			/**
			 * This property defines if the toggler should be displayed the whole time when the NotificationBar is shown.
			 */
			alwaysShowToggler : {
				type : "boolean",
				defaultValue : false,
				since : "1.24.5"
			}
		},
		aggregations : {
	
			/**
			 * Notifier that shows messages
			 */
			messageNotifier : {type : "sap.ui.core.Element", multiple : false}, 
	
			/**
			 * Notifiers that monitor something within the application and display the corresponding notifications.
			 */
			notifiers : {type : "sap.ui.core.Element", multiple : true, singularName : "notifier"}
		},
		events : {
	
			/**
			 * Event is fired when the bar wants to be displayed depending on given flag. This allows the application to decide what to do.
			 */
			display : {
				parameters : {
	
					/**
					 * Indicates if the bar wants to be shown or hidden
					 */
					show : {type : "boolean"}
				}
			}, 
	
			/**
			 * This event is thrown when the bar was resized (to the different valid states: Min, Max, Default, None). The event itself can be used from SAPUI5-version 1.12.2 since there was a bug in the previous versions firing this event.
			 * @since 1.12.2
			 */
			resize : {
				parameters : {
	
					/**
					 * The corresponding status to which the bar was resized. The corresponding heights can be taken for the bar's CSS file.
					 */
					status : {type : "sap.ui.ux3.NotificationBarStatus"}
				}
			}
		}
	}});
	
	
	/**
	 * This file defines behavior for the control
	 */
	Control.extend("sap.ui.ux3.NotificationBar.NotifierView", {
		renderMessages : function(oRm) {
			oRm.write("<div");
			oRm.writeAttribute("id", this.getId() + "-content");
			oRm.addClass("sapUiNotifierContent");
			oRm.writeClasses();
			oRm.write(">");
	
			/*
			 * By setting the counter before running through loop this ensures that
			 * the most recent added message will be displayed first within rendered
			 * Callout
			 */
			var aMessages = this.getMessages();
			var i = aMessages.length - 1;
			var bFirst = true;
	
			for (; i >= 0; i--) {
				// Since first and last message don't need a
				// separator ->
				// prevent it
				if (!bFirst || (i == 0 && aMessages.length > 1)) {
					// if not the first message is being processed
					// OR
					// if the last available message is being
					// processed but
					// only
					// if there are more than one messages in total
	
					oRm.write("<div");
					oRm.addClass("sapUiNotificationBarCltSep");
					oRm.writeClasses();
					oRm.write(">");
	
					oRm.write("</div>");
				} else {
					// After first message was processed start
					// inserting a
					// separator
					bFirst = false;
				}
	
				var oMessage = aMessages[i];
				if (oMessage._message && oMessage._message.getReadOnly()) {
					oMessage.addStyleClass("sapUiNotifierMessageReadOnly");
				}
				oRm.renderControl(oMessage);
			}
	
			oRm.write("</div>"); // sapUiNotifierContent
		},
	
		metadata : {
			properties : {
				"title" : "string",
				"visibleItems" : "int",
				"renderMode" : {
					type : "string",
					defaultValue : "callout"
				}
			},
	
			aggregations : {
				"messages" : "sap.ui.ux3.NotificationBar.MessageView"
			}
		},
	
		init : function() {
			this._oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
		},
	
		exit : function() {
			if (this._renderedControl) {
				delete this._renderedControl;
			}
	
			delete this._oResBundle;
		},
	
		getTitle : function() {
			var sTitle = this.getProperty("title");
			var iCount = this.getMessages().length;
	
			if (iCount > 0) {
				var sKey = "NOTIBAR_NOTIFIER_VIEW_TITLE";
				sTitle = this._oResBundle.getText(sKey, [ sTitle, iCount ]);
			}
	
			return sTitle;
		},
	
		renderer : function(oRm, oControl) {
			oRm.write("<div");
			oRm.addClass("sapUiNotifierContainer");
			oRm.writeControlData(oControl);
			oRm.writeClasses();
			oRm.write(">");
	
			/*
			 * Render title
			 */
			oRm.write("<div");
			oRm.writeAttribute("id", oControl.getId() + "-title");
			oRm.addClass("sapUiNotifierTitle");
			oRm.writeClasses();
			oRm.write(">");
	
			oRm.writeEscaped(oControl.getTitle());
	
			oRm.write("</div>"); // div sapUiNotifierTitle
	
			/*
			 * Render messages
			 */
			if (oControl.getMessages().length > 0) {
				oControl.renderMessages(oRm);
			}
	
			oRm.write("</div>"); // sapUiNotifierContainer
		},
	
		onAfterRendering : function() {
			/*
			 * After all items are rendered it is needed to get the Callout's
			 * height. Since a single message could contain no, little or much text.
			 * So the messages' heights may vary.
			 */
			var $viewContent = this.$("content");
			var $aChildren = $viewContent.children();
	
			var iTotalHeight = 0, iCount = 0;
			// Used to prevent unneeded method calls within loop
			var iVisibleItems = this.getVisibleItems();
	
			// i=1 since view's title should be skipped for
			// calculation
			for (var i = 1; i < $aChildren.length; i++) {
				var child = jQuery($aChildren[i]);
	
				if (child.hasClass("sapUiNotifierMessage")) {
					iCount++;
				}
	
				var height = child.outerHeight(true);
				iTotalHeight += height;
	
				if (iCount == iVisibleItems) {
					// I don't know why these 2 pixels are needed
					// additionally
					// but
					// it works :-)
					iTotalHeight += 2;
					$viewContent.css("max-height", iTotalHeight);
				}
			}
		}
	});
	
	/**
	 * Internal control that renders a single message for the NotificationBar
	 * corresponding to its needs
	 */
	Control.extend("sap.ui.ux3.NotificationBar.MessageView", {
		metadata : {
			properties : {
				"text" : "string",
				"timestamp" : "string",
				"icon" : "sap.ui.core.URI"
			}
		},
	
		renderer : function(oRm, oControl) {
			var sId = oControl.getId();
	
			oRm.write("<div");
			oRm.writeControlData(oControl);
	
			oRm.addClass("sapUiNotifierMessage");
			oRm.writeClasses();
			oRm.writeAttribute("tabindex", "0");
			oRm.write(">");
	
			if (oControl.getIcon()) {
				oRm.write("<div");
				oRm.writeAttribute("id", sId + "-icon");
				oRm.addClass("sapUiNotifierMessageIcon");
				oRm.writeClasses();
				oRm.write(">");
	
				oRm.write("<img");
				oRm.writeAttributeEscaped("src", oControl.getIcon());
				oRm.write("/>");
	
				oRm.write("</div>");
			}
	
			oRm.write("<div");
			oRm.writeAttribute("id", sId + "-text");
			oRm.addClass("sapUiNotifierMessageText");
			oRm.writeClasses();
			oRm.write(">");
			oRm.writeEscaped(oControl.getText());
			oRm.write("</div>"); // Text
	
			oRm.write("<div");
			oRm.writeAttribute("id", sId + "-timestamp");
			oRm.addClass("sapUiNotifierMessageTimestamp");
			oRm.writeClasses();
			oRm.write(">");
			oRm.writeEscaped(oControl.getTimestamp());
			oRm.write("</div>"); // Timestamp
	
			oRm.write("</div>"); // NotificationItem
		},
	
		onclick : function(oEvent) {
			// only fire selected event if the message can be selected at all
			if (!this._message.getReadOnly()) {
				var oNotifier = this._message.getParent();
	
				oNotifier.fireMessageSelected({
					message : this._message,
					notifier : oNotifier
				});
			}
		},
	
		onsapselect : function(oEvent) {
			this.onclick(oEvent);
		},
	
		exit : function(oEvent) {
			if (this._message) {
				delete this._message;
			}
		}
	});
	
	(function() {
		var fnChangeVisibility = function(that) {
			var bShouldBeVisible = that.hasItems();
			var sStatus = that.getVisibleStatus();
	
			if (bShouldBeVisible && sStatus === "None") {
				return true;
			} else if (!bShouldBeVisible && sStatus !== "None") {
				return true;
			} else if (!bShouldBeVisible && sStatus !== "Min") {
				return true;
			} else {
				return false;
			}
	
		};
		
		var fnSortMessages = function(that, oNotifier) {
			var aSortMessages = oNotifier.getMessages().concat([]);
			if (aSortMessages.length > 0) {
				// sort ascending the messages via their level
				aSortMessages.sort(sap.ui.core.Message.compareByType);

				var iIndex = aSortMessages.length - 1;
				that._sSeverestMessageLevel = aSortMessages[iIndex].getLevel();
			}
		};
	
		/**
		 * This is the eventListener of the NotificationBar. All triggered events
		 * from the bar's notifiers will be caught here.
		 * 
		 * @param {sap.ui.base.Event}
		 *            oEvent the event will all needed stuff. It can contain
		 *            'added', 'removed' or 'openCallout' as a parameter to identify
		 *            the event.
		 */
		var fnChildEventListener = function(oEvent) {
			var oCallout = oEvent.getParameter("callout");
	
			switch (oEvent.getParameter("type")) {
			case "added":
			case "removed":
				var oNotifier = oEvent.getParameter("notifier");
	
				if (this.getMessageNotifier() && this.getMessageNotifier().getId() === oNotifier.getId()) {
					// clone the message array to sort it
					fnSortMessages(this, this.getMessageNotifier());
				}
	
				if (fnChangeVisibility(this)) {
					var bShouldBeVisible = this.hasItems();
					this.fireDisplay({
						show : bShouldBeVisible
					});
				} else {
					/*
					 * Needed if i.e. all messages of a notifier were removed but if
					 * there are still notifications or messages to display
					 */
					this.invalidate();
	
					/*
					 * Needed if the message is directly removed from the Callout
					 * without any request to the user.
					 */
					if (oEvent.getParameter("type") === "removed") {
						/*
						 * Since the Callout has only one content - the NotifierView -
						 * it can be checked this way. If there is no content the
						 * Callout has been closed already.
						 */
						if (oCallout.getContent().length > 0) {
							var oNotiView = oCallout.getContent()[0];
							var oMessage = oEvent.getParameter("message");
	
							var aMessageViews = oNotiView.getMessages();
							var tmpMsgView;
	
							for (var i = 0; i < aMessageViews.length; i++) {
								tmpMsgView = aMessageViews[i];
	
								if (oMessage.getId() === tmpMsgView._message.getId()) {
									tmpMsgView.destroy();
	
									/*
									 * A normal invalidate on the NotifierView
									 * doesn't work here since the invalidate is
									 * delegated to the most upper parent -> the
									 * NotificationBar. If the NotificationBar is
									 * rendered it doesn't know something of the
									 * corresponding Callout. It would be possible
									 * to rerender the NotifierView but since the
									 * height of the Callout is reduced the
									 * Callout's position must be fixed as well.
									 * This happens also when the Callout is
									 * rerendered, so it saves some lines of codes
									 * to rerender the Callout itself.
									 */
									oCallout.rerender();
	
									/*
									 * An open Callout would loose its correct
									 * position due to the re-rendering. The
									 * followOf-functionality of the Popup doesn't
									 * work here, since the opener hasn't moved. See
									 * CSN 1625930 2013
									 */
									oCallout.adjustPosition();
									break;
								}
							}
						}
					}
				}
	
				break;
	
			case "openCallout":
				oCallout.destroyContent();
	
				var oNotifier = oEvent.getParameter("notifier");
				// destroy (renew) views that were previously created in maximized
				// mode
				oNotifier.destroyAggregation("views", true);
				var sId = oNotifier.getId();
	
				var oMessageNotifier = this.getMessageNotifier();
	
				if (oMessageNotifier && sId === oMessageNotifier.getId()) {
					sId += "-messageNotifierView";
				} else {
					sId += "-messageView";
				}
	
				// create control that renders the notifier's messages
				var oNotifierView = new NotificationBar.NotifierView(sId, {
					title : oNotifier.getTitle(),
					visibleItems : this._visibleItems
				});
	
				if (oNotifier._bEnableMessageSelect) {
					oNotifierView.addStyleClass("sapUiNotifierSelectable");
				}
	
				var aMessages = oNotifier.getMessages();
				for (var i = 0; i < aMessages.length; i++) {
					var oView = fnCreateMessageView(aMessages[i], oNotifier, this);
					oNotifierView.addMessage(oView);
				}
	
				// with adding this aggregation the view is destroyed as well if
				// needed
				oNotifier.addAggregation("views", oNotifierView, true);
	
				oCallout.addContent(oNotifierView);
				break;
			}
		};
	
		NotificationBar.HOVER_ITEM_HEIGHT = 16;
	
		NotificationBar.prototype.init = function() {
			this._oItemNavigation = new ItemNavigation();
			this._oItemNavigation.setCycling(true);
			this.addDelegate(this._oItemNavigation);
	
			this._iCalloutWidth = parseInt(250, 10);
			this._iCalloutHeight = parseInt(200, 10);
	
			this._visibleItems = 5;
	
			this._eventListener = jQuery.proxy(fnChildEventListener, this);
	
			// needed within Renderer
			this._oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
	
			this._togglerPosition = "50%";
			this._gapMessageArea = "5";
	
			this._sSeverestMessageLevel = sap.ui.core.MessageType.None;
	
			// TODO maybe the ResizeHandler should be used
			/*
			 * Frank Weigel: I wonder whether the window.resize is sufficient. If
			 * the NotificationBar is not used top level (e.g. in Shell) but in some
			 * smaller portion of the screen (e.g. Panel), then resizing might occur
			 * without a window.resize. Unfortunately, there is no cross browser
			 * Element.resize event available. Instead, one can use our
			 * ResizeHandler, but this might need more discussion about the Pros and
			 * Cons (ResizeHandler does some kind of polling which is nasty...)
			 */
			jQuery(window).bind("resize", jQuery.proxy(fnOnResize, this));
	
			this._proxyEnableMessageSelect = jQuery.proxy(fnEnableMessageSelect, this);
			
			this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling

			// set toggler always to visible if running on a mobile device
			this.setAlwaysShowToggler(false);
		};
	
		NotificationBar.prototype.exit = function() {
			this.removeDelegate(this._oItemNavigation);
			this._oItemNavigation.destroy();
			delete this._oItemNavigation;
	
			delete this._iCalloutWidth;
			delete this._iCalloutHeight;
	
			delete this._visibleItems;
	
			delete this._eventListener;
	
			if (this.getMessageNotifier()) {
				var oMN = this.getMessageNotifier();
				oMN._oMessageArea.destroy();
				delete oMN._oMessageArea;
			}
	
			delete this._resizeFrom;
			delete this._resizeTo;
	
			delete this._oResBundle;
	
			delete this._formerVisibleStatus;
	
			delete this._togglerPosition;
			delete this._gapMessageArea;
	
			delete this._isHovered;
			delete this._togglerClicked;
	
			delete this._sSeverestMessageLevel;
	
			jQuery(window).unbind("resize", fnOnResize);
	
			delete this._proxyEnableMessageSelect;
		};
		/**
		 * This method creates an instance of the internal control
		 * {@link sap.ui.ux3.NotificationBar.MessageView} corresponding to the given
		 * message
		 * 
		 * @param {sap.ui.core.Message}
		 *            oMessage from that should be created a view
		 * @returns {sap.ui.ux3.NotificationBar.MessageView}
		 */
		var fnCreateMessageView = function(oMessage, oNotifier, oNotiBar) {
			var oMessageView = new NotificationBar.MessageView(oNotifier.getId() + "-messageView-" + oMessage.getId(), {
				text : oMessage.getText(),
				timestamp : oMessage.getTimestamp()
			});
			oMessageView._message = oMessage;
	
			if (oNotifier.sParentAggregationName == "messageNotifier") {
				if (oNotiBar.getVisibleStatus() == sap.ui.ux3.NotificationBarStatus.Max) {
					oMessageView.setIcon(oMessage.getIcon() || oMessage.getDefaultIcon("32x32"));
				} else {
					oMessageView.setIcon(oMessage.getIcon() || oMessage.getDefaultIcon());
				}
			} else {
				oMessageView.setIcon(oMessage.getIcon());
			}
	
			return oMessageView;
		};
	
		/**
		 * This attaches the given notifier to all necessary events that a notifier
		 * can trigger. A transformation is needed because 'this' in this method is
		 * the window instance
		 * 
		 * @param {sap.ui.ux3.NotificationBar}
		 *            The bar itself since 'this' is the window's instance
		 * @param {sap.ui.ux3.Notifier}
		 *            oNotifier that should be registered
		 */
		var fnRegisterNotifierToEvents = function(that, oNotifier) {
			oNotifier.attachEvent("_childControlCalling", that._eventListener, that);
		};
	
		/**
		 * This detaches the given notifier to all necessary events that a notifier
		 * can trigger. A transformation is needed because 'this' in this method is
		 * the window instance
		 * 
		 * @param {sap.ui.ux3.NotificationBar}
		 *            The bar itself since 'this' is the window's instance
		 * @param {sap.ui.ux3.Notifier}
		 *            oNotifier that should be detached
		 */
		var fnDeregisterNotifierFromEvents = function(that, oNotifier) {
			oNotifier.detachEvent("_childControlCalling", that._eventListener, that);
		};
	
		/*
		 * Add, insert, remove, removeAll methods for notifiers
		 */
		NotificationBar.prototype.addNotifier = function(oNotifier) {
			if (oNotifier) {
				var bSuppress = (this.getVisibleStatus() == sap.ui.ux3.NotificationBarStatus.None) ? true : false;
				this.addAggregation("notifiers", oNotifier, bSuppress);
				fnRegisterNotifierToEvents(this, oNotifier);
			}
	
			return this;
		};
		NotificationBar.prototype.insertNotifier = function(oNotifier, iIndex) {
			if (oNotifier) {
				this.insertAggregation("notifiers", oNotifier, iIndex);
				fnRegisterNotifierToEvents(this, oNotifier);
			}
	
			return this;
		};
		NotificationBar.prototype.removeNotifier = function(oNotifier) {
			var oRemovedNotifier = this.removeAggregation("notifiers", oNotifier);
			fnDeregisterNotifierFromEvents(this, oRemovedNotifier);
	
			return oRemovedNotifier;
		};
		NotificationBar.prototype.removeAllNotifiers = function() {
			var aChildren = this.removeAllAggregation("notifiers");
	
			for (var i = 0; i < aChildren.length; i++) {
				var oNotifier = aChildren[i];
				fnDeregisterNotifierFromEvents(this, oNotifier);
			}
	
			return aChildren;
		};
		NotificationBar.prototype.destroyNotifiers = function() {
			var aChildren = this.getNotifiers();
	
			for (var i = 0; i < aChildren.length; i++) {
				var oNotifier = aChildren[i];
				fnDeregisterNotifierFromEvents(this, oNotifier);
			}
	
			this.destroyAggregation("notifiers");
			return this;
		};
	
		/**
		 * This function is called when the 'messageSelected' event listener was
		 * attached/detached to the MessageNotifier. If the MessageNotifier is
		 * affected it is invalidated accordingly so the inplace message of the
		 * MessageNotifier is clickable or not and has visual features as if it were
		 * clickable.
		 */
		var fnEnableMessageSelect = function(oEvent) {
			var oMN = this.getMessageNotifier();
	
			if (oMN && oMN.getId() === oEvent.getParameter("notifier").getId()) {
				oMN.invalidate();
			}
		};
	
		/*
		 * Set, remove, destroy methods for message notifier
		 */
		NotificationBar.prototype.setMessageNotifier = function(oMessageNotifier) {
	
			var oMN = this.getMessageNotifier();
			if (oMN) {
				oMN._oMessageArea.destroy();
				delete oMN._oMessageArea;
	
				oMN.detachEvent("_enableMessageSelect", this._proxyEnableMessageSelect);
				fnDeregisterNotifierFromEvents(this, oMN);
			}
	
			this.setAggregation("messageNotifier", oMessageNotifier);
	
			if (oMessageNotifier) {
				oMessageNotifier._oMessageArea = new NotificationBar.MessageView(this.getId() + "-inplaceMessage");
				oMessageNotifier._oMessageArea.setParent(oMessageNotifier);
	
				oMessageNotifier.attachEvent("_enableMessageSelect", this._proxyEnableMessageSelect);
				fnRegisterNotifierToEvents(this, oMessageNotifier);
			}
	
			return this;
		};
		NotificationBar.prototype.destroyMessageNotifier = function(oMsgNotifier) {
	
			var oMN = this.getMessageNotifier();
			if (oMN) {
				oMN._oMessageArea.destroy();
				delete oMN._oMessageArea;
	
				oMN.detachEvent("_enableMessageSelect", this._proxyEnableMessageSelect);
				fnDeregisterNotifierFromEvents(this, oMN);
			}
	
			this.destroyAggregation("messageNotifier");
	
			return this;
		};
	
		var fnSetResizeClasses = function(that, sStatus) {
			var $That = that.$();
	
			switch (sStatus) {
			case sap.ui.ux3.NotificationBarStatus.Min:
				$That.addClass("sapUiNotificationBarMinimized");
				break;
	
			case sap.ui.ux3.NotificationBarStatus.Max:
				var sHeight = that.getHeightOfStatus(that.getVisibleStatus());
	
				$That.addClass("sapUiNotificationBarMaximized");
				$That.css("height", sHeight);
	
				var $containers = that.$("containers");
				$containers.css("max-height", sHeight);
				break;
	
			case sap.ui.ux3.NotificationBarStatus.None:
				if (!that._resizeTo) {
					$That.css("display", "none");
				}
				break;
	
			case sap.ui.ux3.NotificationBarStatus.Default:
			default:
				$That.removeClass("sapUiNotificationBarMaximized");
				$That.removeClass("sapUiNotificationBarMinimized");
	
				break;
			}
		};
	
		var fnResizeStuff = function(oThat) {
			if (fnWasResized(oThat)) {
				var sFromHeight = oThat.getHeightOfStatus(oThat._resizeFrom);
				var $That = oThat.$();
				$That.css("height", sFromHeight);
	
				var sToHeight = oThat.getHeightOfStatus(oThat._resizeTo);
	
				// animate accordingly to the used jQuery version
				$That.stop(true, true).animate({
					height : sToHeight
				}, "fast", function() {
					var sStatus = oThat.getVisibleStatus();
					if (sStatus === "None") {
						$That.css("display", "none");
	
						if (oThat.hasItems()) {
							if (oThat.getMessageNotifier()) {
								var oMN = oThat.getMessageNotifier();
								oMN.$().css("display", "none");
							}
	
							if (oThat.getNotifiers().length > 0) {
								var aNotifiers = oThat.getNotifiers();
								for (var i = 0; i < aNotifiers.length; i++) {
									aNotifiers[i].$().css("display", "none");
								}
							}
						}
					}
	
					fnSetResizeClasses(oThat, sStatus);
					fnResize(oThat, sStatus);
				});
			} else {
				/*
				 * Setting the correct size of the bar is necessary if the bar is
				 * maximized e.g. and a new message was added and triggered a
				 * re-rendering
				 */
				var sStatus = oThat.getVisibleStatus();
				fnSetResizeClasses(oThat, sStatus);
			}
	
			delete oThat._resizeFrom;
			delete oThat._resizeTo;
		};
	
		var fnSettingWidth = function(that) {
			if (that.getMessageNotifier() && that.getMessageNotifier().hasItems()) {
				var $messageArea;
				var sId = that.getId() + "-notifiers";
				var $domRef = jQuery.sap.byId(sId);
				if ($domRef.length > 0) {
					var iTotalWidth = parseInt($domRef.width(), 10);
	
					var $children = $domRef.children();
	
					for (var i = 0; i < $children.length; i++) {
						var $child = jQuery($children[i]);
	
						if ($child.hasClass("sapUiNotifier")) {
							iTotalWidth -= $child.width();
						} else if ($child.hasClass("sapUiNotifierSeparator")) {
							iTotalWidth -= $child.width();
						} else if ($child.hasClass("sapUiInPlaceMessage")) {
							$messageArea = $child;
						}
					}
	
					if ($messageArea) {
						// +2 since otherwise the inplace message has no place to be
						// displayed
						iTotalWidth -= that._gapMessageArea + 2;
						$messageArea.css("width", iTotalWidth + "px");
					}
				}
			}
		};
	
		var fnMouseMoveListener = function(oEvent) {
			var height = jQuery(window).height();
	
			var oNotiBar = oEvent.data.notibar;
			var $hoverDomRef = oNotiBar.$("hoverItem");
	
			var clientY = oEvent.clientY;
			var iClientTop = parseInt(clientY, 10);
	
			/*
			 * Border has to be moved up a little since the IE doesn't react anymore
			 * if the mouse cursor is too close to the boder.
			 */
			var iBorder = height - $hoverDomRef.outerHeight();
			if (oNotiBar._isHovered) {
				if (iClientTop < iBorder) {
					var fnHoverProxy = jQuery.proxy(fnHover, oNotiBar);
					$hoverDomRef.on("mouseleave", fnHoverProxy);
	
					window.setTimeout(function() {
						var oEvt = jQuery.Event("mouseleave", {
							notibar : oNotiBar
						});
						$hoverDomRef.trigger(oEvt);
	
						$hoverDomRef.off("mouseleave", fnHoverProxy);
					}, 100);
	
					delete oNotiBar._isHovered;
				}
			} else {
				if (iClientTop >= iBorder) {
					var fnHoverProxy = jQuery.proxy(fnHover, oNotiBar);
					$hoverDomRef.on("mouseenter", fnHoverProxy);
	
					window.setTimeout(function() {
						var oEvt = jQuery.Event("mouseenter", {
							notibar : oNotiBar
						});
						$hoverDomRef.trigger(oEvt);
	
						$hoverDomRef.off("mouseenter", fnHoverProxy);
					}, 100);
	
					oNotiBar._isHovered = true;
				}
			}
		};
	
		/*
		 * When the NotiBar is minimized the IE doesn't get the mouseenter and
		 * mouseleave events on the bar's parent element. So it's needed to simulate
		 * these events with checking if the mouse cursor is near the bottom of the
		 * window to manually trigger these events.
		 */
		var simulateMouseEventsForIE = function(oNotiBar) {
			var $doc = jQuery(document);
	
			if (oNotiBar.getVisibleStatus() === "Min") {
				$doc.on("mousemove", {
					notibar : oNotiBar
				}, fnMouseMoveListener);
			} else {
				$doc.off("mousemove", fnMouseMoveListener);
			}
		};
	
		/**
		 * @private
		 */
		NotificationBar.prototype.onAfterRendering = function() {
			this._oItemNavigation.setRootDomRef(this.getDomRef());
	
			var aItemDomRefs = [];
			var bIsMaximized = this.getVisibleStatus() === sap.ui.ux3.NotificationBarStatus.Max;
	
			// use different elements for navigation in maximized-mode
			if (bIsMaximized) {
				// add notifiers and messages reverse so the arrow keys can be used
				// properly. Or the whole control of the item navigation is
				// inverted.
				var oMessageNotifier = this.getMessageNotifier();
				if (oMessageNotifier != null) {
					var aMessages = oMessageNotifier.getMessages();
					var sId = oMessageNotifier.getId() + "-messageNotifierView-messageView-";
	
					for (var i = aMessages.length - 1; i >= 0; i--) {
						var oDomRef = jQuery.sap.domById(sId + aMessages[i].getId());
						if (oDomRef) {
							aItemDomRefs.push(oDomRef);
						}
					}
				}
	
				var aNotifiers = this.getNotifiers();
				for (var i = 0; i < aNotifiers.length; i++) {
					var aMessages = aNotifiers[i].getMessages();
					var sId = aNotifiers[i].getId() + "-notifierView-messageView-";
	
					for (var j = aMessages.length - 1; j >= 0; j--) {
						var oDomRef = jQuery.sap.domById(sId + aMessages[j].getId());
						if (oDomRef) {
							aItemDomRefs.push(oDomRef);
						}
					}
				}
	
			} else {
				var aNotifiers = this.getNotifiers();
				for (var i = 0; i < aNotifiers.length; i++) {
					var oDomRef = aNotifiers[i].getDomRef();
					if (oDomRef) {
						aItemDomRefs.push(oDomRef);
					}
				}
	
				var oMessageNotifier = this.getMessageNotifier();
				if (oMessageNotifier != null) {
					var oDomRef = oMessageNotifier.getDomRef();
					if (oDomRef) {
						aItemDomRefs.push(oDomRef);
					}
	
					// add the inplace message to the item navigation as well
					oDomRef = this.getDomRef("inplaceMessage");
					if (oDomRef && jQuery(oDomRef).hasClass("sapUiInPlaceMessageSelectable")) {
						aItemDomRefs.push(oDomRef);
					}
				}
			}
	
			this._oItemNavigation.setItemDomRefs(aItemDomRefs);
	
			/*
			 * Stuff for resizing
			 */
			fnResizeStuff(this);
	
			/*
			 * Calculating of the width to get the correct width for the message
			 * area
			 */
			fnSettingWidth(this);
	
			/*
			 * Set corresponding color for MessageNotifier's counter and description
			 * for the MessageNotifier
			 */
			fnSetSeverityForMessageNotifier(this, this.getMessageNotifier());
	
			// set descriptions for all normal notifiers
			fnSetItemsDescription(this);
	
			if (!!sap.ui.Device.browser.internet_explorer) {
				simulateMouseEventsForIE(this);
			}
	
			// set toggler always to visible if running on a mobile device
			if (sap.ui.Device.browser.mobile) {
				var $toggler = this.$("toggler");
	
				if (this.getVisibleStatus() !== sap.ui.ux3.NotificationBarStatus.None) {
					$toggler.css("display", "block");
				} else {
					$toggler.css("display", "none");
				}
			}
		};
	
		/**
		 * This method sets the corresponding CSS class to the message notifier's
		 * counter to set its corresponding color and sets the corresponding ARIA
		 * information to the notifier's description element
		 * 
		 * @private
		 */
		var fnSetSeverityForMessageNotifier = function(oThis, oMN) {
			if (oMN && oMN.hasItems()) {
				var $messageCount = oMN.$("counter");
	
				// remove all possible classes
				$messageCount.removeClass("sapUiMessageInformation");
				$messageCount.removeClass("sapUiMessageSuccess");
				$messageCount.removeClass("sapUiMessageWarning");
				$messageCount.removeClass("sapUiMessageError");

				// re-sort the messages and re-calc the severity level because they could have been changed 
				// if the NotiBar was invisible
				fnSortMessages(oThis, oMN);
				// add new corresponding class
				var sLvl = oThis._sSeverestMessageLevel;
				$messageCount.addClass("sapUiMessage" + sLvl);
	
				// create key for description text
				var iCount = oMN.getMessages().length;
				var sKey = "NOTIBAR_MESSAGE_NOTIFIER_DESC_LEVEL_" + sLvl.toUpperCase() + (iCount === 1 ? "_SING" : "_PL");
	
				// set description (i.e. "3 messages available: Highest severity
				// "Error")
				fnSetNotifierDescription(oThis, oMN, sKey, iCount);
			}
		};
	
		/**
		 * Sets all description of all notifiers
		 * 
		 * @private
		 */
		var fnSetItemsDescription = function(oThis) {
			var aNotifiers = oThis.getNotifiers();
	
			for (var i = 0; i < aNotifiers.length; i++) {
				var iCount = aNotifiers[i].getMessages().length;
				var sKey = "NOTIBAR_NOTIFIER_COUNT_TEXT_" + (iCount === 1 ? "SING" : "PL");
	
				fnSetNotifierDescription(oThis, aNotifiers[i], sKey, iCount);
			}
		};
	
		var fnSetNotifierDescription = function(oThis, oNotifier, sKey, iCount) {
			var $description = oNotifier.$("description");
	
			var sMessage = oThis._oResBundle.getText(sKey, [ iCount ]);
			$description.html(sMessage);
		};
	
		/*
		 * Event listener for mouseenter/mouseleave for NotificationBar's parent
		 * HTML-element
		 */
		var fnHover = function(oEvent) {
			var $toggler = this.$("toggler");
	
			var bDisplay = ($toggler.css("display") === "block") ? true : false;
			if (bDisplay) {
				// if toggler is being displayed
				if (oEvent.type === "mouseleave") {
					$toggler.css("display", "none");
				}
			} else {
				if (oEvent.type === "mouseenter") {
					$toggler.css("display", "block");
				}
			}
		};
	
		/*
		 * EventListener when bar was resized
		 */
		var fnOnResize = function(oEvent) {
			/*
			 * Calculating of the width to get the correct width for the message
			 * area
			 */
			fnSettingWidth(this);
		};
	
		var fnWasResized = function(that) {
			if (that._resizeFrom && that._resizeTo) {
				if (that._resizeFrom != that._resizeTo) {
					return true;
				}
			}
	
			return false;
		};
	

		/**
		 * This method checks if the NotificationBar has any items (notifications or messages) to show and returns true if there are any items to show. So the application should decide if the bar should be displayed.
		 *
		 * @type boolean
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
		 */
		NotificationBar.prototype.hasItems = function() {
			// Checking all notifiers if any has items
			var mNotifiers = this.getNotifiers();
			if (mNotifiers.length > 0) {
				for (var i = 0; i < mNotifiers.length; i++) {
					var oNotifier = mNotifiers[i];
					if (oNotifier.hasItems()) {
						return true;
					}
				}
			}
	
			// Checking MessageNotifier if it has items
			if (this.getMessageNotifier()) {
				if (this.getMessageNotifier().hasItems()) {
					return true;
				}
			}
	
			return false;
		};
	
		var fnResize = function(oNotiBar, toStatus) {
			var display = "none";
			var $NotiBar = oNotiBar.$();
	
			switch (toStatus) {
			/*
			 * These cases are only mentioned to prevent running into default
			 */
			case sap.ui.ux3.NotificationBarStatus.Max:
			case sap.ui.ux3.NotificationBarStatus.None:
				break;
	
			case sap.ui.ux3.NotificationBarStatus.Min:
				/*
				 * Since minimizing doesn't need any re-rendering all necessary
				 * stuff can be done here
				 */
				$NotiBar.stop().animate({
					height : oNotiBar.getHeightOfStatus(toStatus)
				}, {
					duration : "fast",
					queue : true
				});
	
				$NotiBar.addClass("sapUiNotificationBarMinimized");
	
				oNotiBar.$("notifiers").css("display", "none");
	
				display = "block";
				break;
	
			default:
			case sap.ui.ux3.NotificationBarStatus.Default:
				/*
				 * If bar should be resized from maximized to default a re-rendering
				 * is needed. Otherwise a simple animation and CSS exchange is
				 * enough
				 */
				$NotiBar.stop().animate({
					height : oNotiBar.getHeightOfStatus(toStatus)
				}, {
					duration : "fast",
					queue : true
				});
	
				$NotiBar.removeClass("sapUiNotificationBarMaximized");
				$NotiBar.removeClass("sapUiNotificationBarMinimized");
	
				break;
			}
	
			var $hover = oNotiBar.$("hoverItem");
			$hover.css("display", display);
		};
	
		NotificationBar.prototype.onfocusin = function(oEvent) {
			if (this._togglerClicked) {
				delete this._togglerClicked;
	
				/*
				 * if the bar is minimized and a notifiers still has the focus it is
				 * needed to stop this event to prevent webkit browsers from
				 * scrolling down
				 */
				oEvent.stopImmediatePropagation(true);
			}
		};
	
		NotificationBar.prototype.onclick = function(oEvent) {
			/*
			 * if the bar is minimized and a notifiers still has the focus it is
			 * needed to stop this event to prevent webkit browsers from scrolling
			 * down
			 */
			this._togglerClicked = true;
			/*
			 * Prevent that the NotificationBar itselft gets the focus and causes a
			 * (dotted) border around the hover item and/or the bar iteslef
			 */
			this.$().blur();
			var $activeElement = jQuery(document.activeElement);
	
			fnCloseAllCallouts(this);
	
			var sId = oEvent.target.id;
			var aSplit = sId.split("-");
	
			if (aSplit) {
				var sVisibleStatus = this.getVisibleStatus();
				var iIndex = aSplit.length - 1;
	
				switch (aSplit[iIndex]) {
				case "ArrowUp":
					if (sVisibleStatus === "Min") {
						this.setVisibleStatus("Default");
					} else {
						// if current state is default -> maximize bar
						this.setVisibleStatus("Max");
					}
					break;
	
				case "ArrowDown":
					if (sVisibleStatus === "Max") {
						this.setVisibleStatus("Default");
					} else {
						// if current state is default -> minimize bar
						this.setVisibleStatus("Min");
					}
					oEvent.preventDefault();
					break;
	
				case "BarUp":
					if (this._formerVisibleStatus) {
						this.setVisibleStatus(this._formerVisibleStatus);
					} else {
						this.setVisibleStatus("Default");
					}
	
					break;
	
				case "BarDown":
					this._formerVisibleStatus = sVisibleStatus;
					this.setVisibleStatus("Min");
	
					$activeElement.blur();
					break;
	
				default:
					if ($activeElement.hasClass("sapUiNotifier")) {
						$activeElement.focus();
					} else {
						if (this.hasItems()) {
							var aNotifiers = this.getNotifiers();
							if (aNotifiers.length > 0) {
								var $firstNoti = jQuery(aNotifiers[0]);
								$firstNoti.focus();
							} else {
								var messageNoti = this.getMessageNotifier();
								if (messageNoti) {
									jQuery(messageNoti).focus();
								}
							}
						}
					}
					break;
				}
			}
		};
	
		NotificationBar.prototype.onThemeChanged = function(oEvent) {
			if (this.getDomRef()) {
				this.invalidate();
			}
		};
	
		/**
		 * Forces a close of all Callouts of all notifiers of the NotificationBar.
		 */
		var fnCloseAllCallouts = function(that) {
			var mNotifiers = that.getNotifiers();
	
			for (var i = 0; i < mNotifiers.length; i++) {
				var oNotifier = mNotifiers[i];
	
				oNotifier._oCallout.close();
			}
	
			if (that.getMessageNotifier()) {
				that.getMessageNotifier()._oCallout.close();
			}
		};
	
		NotificationBar.prototype.getHeightOfStatus = function(sStatus) {
			var sParam = "";
	
			if (sStatus == sap.ui.ux3.NotificationBarStatus.Min) {
				sParam = "sapUiNotificationBarHeightMinimized";
			} else if (sStatus == sap.ui.ux3.NotificationBarStatus.Default) {
				sParam = "sapUiNotificationBarHeight";
			} else if (sStatus == sap.ui.ux3.NotificationBarStatus.Max) {
				sParam = "sapUiNotificationBarHeightMaximized";
				sParam = Parameters.get(sParam);
	
				var iIndex = sParam.indexOf("%");
				if (iIndex != -1) {
					var iPercentage = sParam.substring(0, iIndex);
					var iHeight = jQuery(window).height();
					iHeight = parseInt(iHeight / 100 * iPercentage, 10);
	
					// Ensure that the MaxHeight is at least 1 px larger than the
					// Default
					// Maybe disabling the resize feature would be the better
					// approach in this case
					var _iHeight = parseInt(this.getHeightOfStatus(sap.ui.ux3.NotificationBarStatus.Default), 10);
					if (iHeight < _iHeight) {
						iHeight = _iHeight + 1;
					}
				} else {
					var sMessage = "No valid percantage value given for maximized size. 400px is used";
					jQuery.sap.log.warning(sMessage);
	
					iHeight = 400;
				}
				return iHeight + "px";
			} else {
				// sStatus == sap.ui.ux3.NotificationBarStatus.None
				return "0px";
			}
	
			sParam = Parameters.get(sParam);
			return sParam;
		};
	
		NotificationBar.prototype.setVisibleStatus = function(toStatus) {
			this._resizeFrom = this.getVisibleStatus();
			this._resizeTo = toStatus;
	
			// skip setting the property if 'toStatus' equals the current status
			if (this._resizeFrom !== this._resizeTo) {
				if (toStatus === sap.ui.ux3.NotificationBarStatus.None) {
					fnCloseAllCallouts(this);
	
					if (this.getDomRef()) {
						fnResize(this, toStatus);
					} else {
						this.$().css({
							"height" : "0px",
							"display" : "none"
						});
					}
				}
	
				this.setProperty("visibleStatus", toStatus);
	
				this.fireResize({
					status : toStatus
				});
			}
		};

		/**
		 * @param [boolean]
		 *            {bAlwaysShow} if the toggler should be visible all the time
		 *            set this parameter to <b>true</b>
		 * @public
		 * @since 1.22.11
		 */
		sap.ui.ux3.NotificationBar.prototype.setAlwaysShowToggler = function(bAlwaysShow) {
			// set toggler always to visible if running on a mobile device
			if (sap.ui.Device.browser.mobile) {
				bAlwaysShow = true;
			}
			
			this.setProperty("alwaysShowToggler", bAlwaysShow, true);
			
			var $toggler = this.$("toggler");
			if (bAlwaysShow) {
				$toggler.css("display", "block");
			} else {
				$toggler.css("display", "none");
			}
		};
	}());

	return NotificationBar;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/NotificationBar.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.Notifier') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.Notifier.
jQuery.sap.declare('sap.ui.ux3.Notifier'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Callout'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/Notifier",['jquery.sap.global', 'sap/ui/commons/Callout', 'sap/ui/core/Element', './library'],
	function(jQuery, Callout, Element, library) {
	"use strict";



	/**
	 * Constructor for a new Notifier.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This element can be docked to a notification bar to show notification items
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.Notifier
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Notifier = Element.extend("sap.ui.ux3.Notifier", /** @lends sap.ui.ux3.Notifier.prototype */ { metadata : {

		library : "sap.ui.ux3",
		properties : {

			/**
			 * Icon of the control that should be displayed within the corresponding bar
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},

			/**
			 * Defines the title that should be displayed within the opening popup
			 */
			title : {type : "string", group : "Misc", defaultValue : null}
		},
		aggregations : {

			/**
			 * Messages of this notifier.
			 */
			messages : {type : "sap.ui.core.Message", multiple : true, singularName : "message"}, 

			/**
			 * Views aggregated with this Notifier and managed by the parent NotificationBar.
			 */
			views : {type : "sap.ui.core.Control", multiple : true, singularName : "view", visibility : "hidden"}
		},
		events : {

			/**
			 * Event is fired when a message of the notifiers was selected.
			 */
			messageSelected : {
				parameters : {

					/**
					 * The message that was selected
					 */
					message : {type : "sap.ui.core.Message"}, 

					/**
					 * The notifier that contains the selected message
					 */
					notifier : {type : "sap.ui.ux3.Notifier"}
				}
			}
		}
	}});


	


	/**
	 * This file defines behavior for the control,
	 */

	(function() {
		var fBeforeOpen = function() {
			this.fireEvent("_childControlCalling", {
				type : "openCallout",
				callout : this._oCallout,
				notifier : this
			});
		};

		/**
		 * This is to ensure that all content is destroyed when the Callout is
		 * closed. Otherwise the content is destroyed when the Callout should be
		 * opened again. But who knows if the user will really do this :-)?
		 */
		var fCalloutClosed = function(oEvent) {
			if (oEvent.getSource()) {
				oEvent.getSource().destroyContent();
			}
			if (this._oCallout) {
				this._oCallout.$().css("display", "none");
			}
		};


		/**
		 * This method checks if the notifier has any items.
		 *
		 * @type boolean
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
		Notifier.prototype.hasItems = function() {
			if (this.getMessages().length > 0) {
				return true;
			}
			return false;
		};

		Notifier.prototype.init = function() {

			/*
			 * Setting a parent isn't needed due to it will be set below when
			 * Callout is set as Tooltip
			 */
			this._oCallout = new Callout(this.getId() + "-callout", {
				beforeOpen : jQuery.proxy(fBeforeOpen, this),
				open : function(oEvent) {
					// to prevent that the Callout moves if the window is scrolled
					this.$().css({
						position : "fixed",
						display : "block"
					});
				},
				close : jQuery.proxy(fCalloutClosed, this),
				collision : "none"
			});
			this._oCallout.addStyleClass("sapUiNotifierCallout");
			if (sap.ui.Device.browser.mobile) {
				// if used on a mobile device the tab-event is transfered into a
				// 'mouseover' to open the Callout. To simulate a real tab-event the
				// open delay of the callout has to be eleminated.
				this._oCallout.setOpenDelay(0);
			}

			/*
			 * Though it seems that these are properties -> they're not. There are
			 * only methods to do this so a method-call is needed.
			 */
			this._oCallout.setMyPosition("begin bottom");
			this._oCallout.setAtPosition("begin top");

			/*
			 * The method needs to be overwritten since the positioning of the
			 * callout's arrow does currently not work for transparent arrows. The
			 * transparent arrow is styled differently than defined within the
			 * callout and therefore the hard-coded position of the arrow has to be
			 * corrected
			 */
			this._oCallout.setTip = function() {
				Callout.prototype.setTip.apply(this, arguments);

				/*
				 * Since the arrow is set with another CSS technique the position
				 * needs to be corrected as well
				 */
				var $arrow = this.$("arrow");
				$arrow.css("bottom", "-24px");

				/*
				 * Since the calculation of the callout's arrow works fine for RTL
				 * and must be corrected for LTR only a manipulation of the arrow's
				 * position is needed if LTR is active
				 */
				var bRtl = sap.ui.getCore().getConfiguration().getRTL();
				if (!bRtl) {
					$arrow.css("left", "6px");
				}
			};

			this.setTooltip(this._oCallout);
			this.setTooltip = function() {
				jQuery.sap.log.warning("Setting toolstips for notifiers deactivated");
			};

			this._proxyEnableMessageSelect = jQuery.proxy(fnEnableMessageSelect, this);
			this.attachEvent(sap.ui.base.EventProvider.M_EVENTS.EventHandlerChange, this._proxyEnableMessageSelect);
		};

		/**
		 * Checks if the 'messageSelected' event was attached to the Notifier. If so
		 * the corresponding event is fired and e.g. the NotificationBar can react
		 * on that.
		 */
		var fnEnableMessageSelect = function(oEvent) {
			var sEventId = oEvent.getParameter("EventId");

			if (sEventId === "messageSelected") {
				if (oEvent.getParameter("type") === "listenerAttached") {
					this._bEnableMessageSelect = true;
				} else if (oEvent.getParameter("type") === "listenerDetached") {
					this._bEnableMessageSelect = false;
				}

				this.fireEvent("_enableMessageSelect", {
					enabled : this._bEnableMessageSelect,
					notifier : this
				});
			}
		};

		Notifier.prototype.exit = function(oEvent) {
			this._oCallout = undefined;

			/*
			 * Instance is created when adding the Notifier as MessageNotifier to
			 * the NotificationBar
			 */
			if (this._oMessageView) {
				this._oMessageView.destroy();
				delete this._oMessageView;
			}

			this.detachEvent(sap.ui.base.EventProvider.M_EVENTS.EventHandlerChange, this._proxyEnableMessageSelect);
			delete this._proxyEnableMessageSelect;
		};

		Notifier.prototype.onclick = function(oEvent) {
			oEvent.preventDefault();

			this.$().trigger("mouseover");
		};

		var fnFireChildControlCalling = function(sType, oMessage, oThat) {
			var sLevel = oMessage ? oMessage.getLevel() : sap.ui.core.MessageType.None;

			oThat.fireEvent("_childControlCalling", {
				type : sType,
				notifier : oThat,
				level : sLevel,
				// these two values are needed if a message was removed
				message : oMessage,
				callout : oThat._oCallout
			});
		};

		Notifier.prototype.addMessage = function(oMessage) {
			this.addAggregation("messages", oMessage);
			fnFireChildControlCalling("added", oMessage, this);

			return this;
		};

		Notifier.prototype.insertMessage = function(oMessage, index) {
			this.insertAggregation("messages", oMessage, index);
			fnFireChildControlCalling("added", oMessage, this);

			return this;
		};

		Notifier.prototype.removeMessage = function(oMessage) {
			var oRemovedMessage = this.removeAggregation("messages", oMessage);
			if (oRemovedMessage) {
				fnFireChildControlCalling("removed", oRemovedMessage, this);
			}

			return oRemovedMessage;
		};

		Notifier.prototype.removeAllMessages = function() {
			var aRemovedMessages = this.removeAllAggregation("messages");
			if (aRemovedMessages.length > 0) {
				// only re-render if there were messages removed
				fnFireChildControlCalling("removed", null, this);
			}

			return aRemovedMessages;
		};
		Notifier.prototype.destroyMessages = function() {
			var iLength = this.getMessages().length;
			this.destroyAggregation("messages");

			if (iLength > 0) {
				// only re-render if there were messages removed
				fnFireChildControlCalling("removed", null, this);
			}

			return this;
		};
	}());

	return Notifier;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/Notifier.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.Overlay') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.Overlay.
jQuery.sap.declare('sap.ui.ux3.Overlay'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/Overlay",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/Popup', './library'],
	function(jQuery, Control, Popup, library) {
	"use strict";

	/**
	 * Constructor for a new Overlay.
	 *
	 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
	 * @param {object} [mSettings] Initial settings for the new control
	 *
	 * @class
	 * Overlay Control
	 * @extends sap.ui.core.Control
	 * @implements sap.ui.core.PopupInterface
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.Overlay
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Overlay = Control.extend("sap.ui.ux3.Overlay", /** @lends sap.ui.ux3.Overlay.prototype */ { metadata : {

		interfaces : [
			"sap.ui.core.PopupInterface"
		],
		library : "sap.ui.ux3",
		properties : {

			/**
			 * Defines whether the 'Open' button shall be visible.
			 */
			openButtonVisible : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Defines whether the 'Close' button shall be visible.
			 */
			closeButtonVisible : {type : "boolean", group : "Misc", defaultValue : true}
		},
		events : {

			/**
			 * Event is fired when the Overlay starts closing.
			 */
			close : {allowPreventDefault : true,
				parameters : {

					/**
					 * The ID of the Overlay instance.
					 */
					id : {type : "string"}
				}
			},

			/**
			 * Event is fired when the Overlay is closed.
			 */
			closed : {allowPreventDefault : true,
				parameters : {

					/**
					 * The ID of the Overlay instance.
					 */
					id : {type : "string"}
				}
			},

			/**
			 * Event is fired when the 'Open' button of the Overlay is clicked.
			 */
			openNew : {
				parameters : {

					/**
					 * The ID of the Overlay instance.
					 */
					id : {type : "string"}
				}
			},

			/**
			 * Event is fired when the Overlay is opened.
			 */
			open : {
				parameters : {

					/**
					 * The ID of the Overlay instance
					 */
					id : {type : "string"}
				}
			}
		}
	}});

	Overlay.prototype.init = function() {
		var that = this;
		this._oPopup = new Popup(this, false, true);
		this._oPopup.attachOpened(function(oEvent){
			var domRef = jQuery.sap.byId(that._initialFocusId)[0];
			if (!domRef && that._getShell() && that.getOpenButtonVisible()) {
				domRef = jQuery.sap.domById(that._getOpenButtonId());
			} else if (!domRef && that._getShell() && that.getCloseButtonVisible()) {
				domRef = jQuery.sap.domById(that._getCloseButtonId());
			} else if (!domRef) {
				domRef = that.$("content").firstFocusableDomRef();
			}
			if (!domRef) {
				domRef = that.$().firstFocusableDomRef();
			}
			if (domRef) {
				jQuery.sap.focus(domRef);
			}
		});
		this._oPopup.attachClosed(function(oEvent){
			that.fireClosed({id : that.getId()});
		});
		this._overridePopupEventing();
	};

	/**
	 * Override Popup Events. Don't put Overlay to the front on mousedown.
	 * ToolPopups should always be in front of the Overlay.
	 *
	 * @private
	 */
	Overlay.prototype._overridePopupEventing = function() {
		this._oPopup.onmousedown = function(oEvent) {
			return;
		};
	};

	/**
	 * Returns the Shell (if both Overlay and Shell are rendered).
	 *
	 * @private
	 */
	Overlay.prototype._getShell = function() {
		var oShell = jQuery(".sapUiUx3Shell").control();

		if (oShell.length > 0 && !this._oShell) {
			this._oShell = oShell.length ? oShell[0] : null;
		}
		return this._oShell;
	};


	/**
	 * Returns the ID of the close button element.
	 *
	 * @return {string} The close button ID.
	 * @private
	 */
	Overlay.prototype._getCloseButtonId = function() {
		return this.getId() + "-close";
	};


	/**
	 * Returns the ID of the open button element.
	 *
	 * @return {string} The open button ID.
	 * @private
	 */
	Overlay.prototype._getOpenButtonId = function() {
		return this.getId() + "-openNew";
	};

	/**
	 *
	 * @param fFocusFirst
	 * @param fFocusLast
	 * @param fApplyChanges
	 * @private
	 */
	Overlay.prototype._initDom = function(fFocusFirst, fFocusLast, fApplyChanges) {
		//Override the popup theming and init the focus handling
		var oShell = jQuery(".sapUiUx3Shell").control();
		this._oShell = oShell.length ? oShell[0] : null;
		oShell = this._oShell;
		this.$().css("position", "fixed");
		if (oShell) {
			this._bFocusEventsRegistered = true;
			oShell.syncWithCanvasSize(this.getId(), true, fFocusFirst, fFocusLast, fApplyChanges);
			this.$("firstFocusDummyPaneFw").attr("tabindex", "0").focusin(jQuery.proxy(oShell.focusFirstHdr,oShell));
			this.$("firstFocusDummyPaneBw").attr("tabindex", "0").focusin(jQuery.proxy(oShell.focusLastTool,oShell));
			this.$("LastFocusDummyPane").attr("tabindex", "0").focusin(jQuery.proxy(oShell.focusPaneStart,oShell));
		} else {
			this.$().css("bottom", "0").css("top", "0").css("left", "0").css("right", "0");
		}
	};

	/**
	 *
	 * @private
	 */
	Overlay.prototype._cleanupDom = function() {
		if (this._oShell) {
			this._oShell.syncWithCanvasSize(this.getId(), false);
		}
		if (this._bFocusEventsRegistered) {
			this._bFocusEventsRegistered = false;
			this.$("firstFocusDummyPaneFw").removeAttr("tabindex").unbind("focusin");
			this.$("firstFocusDummyPaneBw").removeAttr("tabindex").unbind("focusin");
			this.$("LastFocusDummyPane").removeAttr("tabindex").unbind("focusin");
		}
	};

	/**
	 * Set size after rendering: If running in Shell && Popup is open/opening we sync with the shell canvas
	 * The size will then be set by the shell.
	 */
	Overlay.prototype.onAfterRendering = function() {
	    var oPopupState = this._oPopup.getOpenState();
	    if (oPopupState === sap.ui.core.OpenState.OPEN || oPopupState === sap.ui.core.OpenState.OPENING) {
	          this._initDom(jQuery.proxy(this._setFocusFirst, this), jQuery.proxy(this._setFocusLast, this), jQuery.proxy(this._applyChanges, this));
	    }
	};

	Overlay.prototype.onBeforeRendering = function() {
	};

	/**
	 * Destroys this instance of Overlay. It's called by Element destroy().
	 *
	 * @private
	 */
	Overlay.prototype.exit = function() {
		this.close();
		this._oPopup.destroy();
		this._oPopup = null;
		this._oShell = null;
	};

	/**
	 * Opens the Overlay.
	 *
	 * @param {string} initialFocusId ID of the control that gets focused when the overlay is openend
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Overlay.prototype.open = function(initialFocusId) {
		this._initialFocusId = initialFocusId;
		if (this._oPopup.isOpen()) {
			return;
		}
		if (initialFocusId) {
			this._oPopup.setInitialFocusId(initialFocusId);
		}

		this._oPreviousFocus = Popup.getCurrentFocusInfo();

		this._oPopup.open(400);

		this._initDom(jQuery.proxy(this._setFocusFirst, this), jQuery.proxy(this._setFocusLast, this), jQuery.proxy(this._applyChanges, this));

		//fire open event
		this.fireOpen({
			id : this.getId()
		});
	};

	/**
	 * Closes the Overlay.
	 *
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Overlay.prototype.close = function() {
		if (!this._oPopup.isOpen()) {
			return;
		}
		this._oPopup.close(400);
		jQuery.sap.delayedCall(400, this, 'restorePreviousFocus');
		this._cleanupDom();
	};

	/**
	 * Handle the click event happening on the Overlay.
	 *
	 * @param {jQuery.EventObject} oEvent
	 * @private
	 */
	Overlay.prototype.onclick = function(oEvent) {
		this._handleButtonEvent(oEvent);
	};

	/**
	 * Handle the sapselect pseudo event happening on the Overlay.
	 *
	 * @param {jQuery.EventObject} oEvent
	 * @private
	 */
	Overlay.prototype.onsapselect = function(oEvent) {
		this._handleButtonEvent(oEvent);
	};

	/**
	 * Event handling for Overlay Buttons.
	 *
	 * @param {jQuery.EventObject} oEvent
	 * @private
	 */
	Overlay.prototype._handleButtonEvent = function(oEvent) {
		var elementId = oEvent.target.id;
		if (elementId === this._getCloseButtonId()) {
			if (this.fireClose({id : this.getId()})) {
				this.close();
			}
		} else if (elementId === this._getOpenButtonId()) {
			this.fireOpenNew({
				id : this.getId()
			});
		}
	};

	/**
	 * Load language dependent texts.
	 *
	 * @param {string} sKey
	 * @param aArgs
	 * @returns {string}
	 * @private
	 */
	Overlay.prototype._getText = function(sKey, aArgs) {
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
		var sText;
		if (rb) {
			sText = rb.getText(sKey);
		}
		if (sText && aArgs) {
			for (var index = 0; index < aArgs.length; index++) {
				sText = sText.replace("{" + index + "}", aArgs[index]);
			}
		}
		return sText ? sText : sKey;
	};

	/**
	 * Returns the first focusable DOM element which is contained in this Overlay.
	 * This function is used for the Shell integration for a proper keyboard handling (tab chain).
	 *
	 * This function must be overridden in sub classes appropriately.
	 *
	 * @private
	 */
	Overlay.prototype._setFocusFirst = function() {
		jQuery.sap.focus(jQuery.sap.domById(this._getOpenButtonId()));
	};

	/**
	 * Returns the last focusable DOM element which is contained in this Overlay.
	 * This function is used for the Shell integration for a proper keyboard handling (tab chain).
	 *
	 * This function must be overridden in sub classes appropriately.
	 *
	 * @private
	 */
	Overlay.prototype._setFocusLast = function() {
		jQuery.sap.focus(jQuery.sap.domById(this._getCloseButtonId()));
	};

	/**
	 * Called from the Shell when properties (e.g. the HeaderType) are changing.
	 *
	 * This function must be overridden in sub classes appropriately.
	 * @param {Object} oChanges
	 * @private
	 */
	Overlay.prototype._applyChanges = function(oChanges) {
		return this;
	};

	/* Redefinition of generated API methods */
	// Implementation of API method isOpen

	/**
	 * Checks whether Overlay is open.
	 *
	 * @type boolean
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Overlay.prototype.isOpen = function() {
		return this._oPopup.isOpen();
	};

	/* restore previous focus when closing */
	Overlay.prototype.restorePreviousFocus = function() {
		Popup.applyFocusInfo(this._oPreviousFocus);
	};

	return Overlay;
}, /* bExport= */ true);

}; // end of sap/ui/ux3/Overlay.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.OverlayContainer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.OverlayContainer.
jQuery.sap.declare('sap.ui.ux3.OverlayContainer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/OverlayContainer",['jquery.sap.global', './Overlay', './library'],
	function(jQuery, Overlay, library) {
	"use strict";


	
	/**
	 * Constructor for a new OverlayContainer.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Is to be embedded into the Overlay control as content container
	 * @extends sap.ui.ux3.Overlay
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.OverlayContainer
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var OverlayContainer = Overlay.extend("sap.ui.ux3.OverlayContainer", /** @lends sap.ui.ux3.OverlayContainer.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		defaultAggregation : "content",
		aggregations : {
	
			/**
			 * Aggregation for content
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
		}
	}});
	
	/**
	 * Focus Last Element
	 *
	 * @private
	 */
	OverlayContainer.prototype._setFocusLast = function() {
		var oFocus = this.$("content").lastFocusableDomRef();
		if (!oFocus && this.getCloseButtonVisible()) {
			oFocus = this.getDomRef("close");
		} else if (!oFocus && this.getOpenButtonVisible()) {
			oFocus = this.getDomRef("openNew");
		}
		jQuery.sap.focus(oFocus);
	};
	
	/**
	 * Focus First Element
	 *
	 * @private
	 */
	OverlayContainer.prototype._setFocusFirst = function() {
		if (this.getOpenButtonVisible()) {
			jQuery.sap.focus(this.getDomRef("openNew"));
		} else if (this.getCloseButtonVisible()) {
			jQuery.sap.focus(this.getDomRef("close"));
		} else {
			jQuery.sap.focus(this.$("content").firstFocusableDomRef());
		}
	};

	return OverlayContainer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/OverlayContainer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.OverlayContainerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.OverlayContainer
jQuery.sap.declare('sap.ui.ux3.OverlayContainerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/OverlayContainerRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './OverlayRenderer'],
	function(jQuery, Renderer, OverlayRenderer) {
	"use strict";

/**
	 * OverlayContainer renderer.
	 * @namespace
	 */
	var OverlayContainerRenderer = Renderer.extend(OverlayRenderer);
	
	/**
	 * Renders the Overlay content
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	OverlayContainerRenderer.renderContent = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.write("<div role='Main' class='sapUiUx3OCContent' id='" + oControl.getId() + "-content'>");
		var content = oControl.getContent();
		for (var i = 0; i < content.length; i++) {
			var control = content[i];
			rm.renderControl(control);
		}
		rm.write("</div>");
	};
	
	/**
	 * Add root class to Overlay
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	OverlayContainerRenderer.addRootClasses = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.addClass("sapUiUx3OC");
	};
	
	/**
	 * Add class to Overlay
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	OverlayContainerRenderer.addOverlayClasses = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.addClass("sapUiUx3OCOverlay");
	};
	

	return OverlayContainerRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/OverlayContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.OverlayDialog') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.OverlayDialog.
jQuery.sap.declare('sap.ui.ux3.OverlayDialog'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IntervalTrigger'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/OverlayDialog",['jquery.sap.global', 'sap/ui/core/IntervalTrigger', './Overlay', './library'],
	function(jQuery, IntervalTrigger, Overlay, library) {
	"use strict";

	/**
	 * Constructor for a new OverlayDialog.
	 *
	 * @param {string} [sId] ID for the new control, generated automatically if no ID is given.
	 * @param {object} [mSettings] Initial settings for the new control.
	 *
	 * @class
	 * Dialog implementation based on the Overlay. If used in a Shell it leaves the Tool-Palette, Pane-Bar and Header-Items accessible.
	 * @extends sap.ui.ux3.Overlay
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.OverlayDialog
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var OverlayDialog = Overlay.extend("sap.ui.ux3.OverlayDialog", /** @lends sap.ui.ux3.OverlayDialog.prototype */ {
		metadata: {
			library: "sap.ui.ux3",
			properties: {
				/**
				 * Determines the width of the Overlay Dialog. If the width is set to "auto" it is always 50% of the overlay width.
				 */
				width: {type: "sap.ui.core.CSSSize", group: "Dimension", defaultValue: 'auto'},

				/**
				 * Determines the height of the Overlay Dialog. If the height is set to "auto" it is always 50% of the overlay height.
				 */
				height: {type: "sap.ui.core.CSSSize", group: "Dimension", defaultValue: 'auto'}
			},
			aggregations: {
				/**
				 * Content for the OverlayDialog.
				 */
				content: {type: "sap.ui.core.Control", multiple: true, singularName: "content"}
			}
		}
	});

	/**
	 * @private
	 */
	OverlayDialog.prototype.init = function(){
		Overlay.prototype.init.apply(this);
		//OverlayDialog must not have an open button
		this.setProperty("openButtonVisible",false);
		OverlayDialog.Trigger = new IntervalTrigger(300);
	};

	/**
	 * Focus the last focusable element.
	 *
	 * @private
	 */
	OverlayDialog.prototype._setFocusLast = function() {
		var oFocus = this.$("content").lastFocusableDomRef();
		if (!oFocus && this.getCloseButtonVisible()) {
			oFocus = this.getDomRef("close");
		}
		jQuery.sap.focus(oFocus);
	};

	/**
	 * Focus the first focusable element.
	 *
	 * @private
	 */
	OverlayDialog.prototype._setFocusFirst = function() {
		if (this.getCloseButtonVisible()) {
			jQuery.sap.focus(this.getDomRef("close"));
		} else {
			jQuery.sap.focus(this.$("content").firstFocusableDomRef());
		}
	};

	/**
	 * This Method is not supported for the OverlayDialog.
	 *
	 * @param {boolean} bVisible
	 * @public
	 */
	OverlayDialog.prototype.setOpenButtonVisible = function(bVisible) {
		jQuery.sap.log.warning("OverlayDialog does not support an openButton.");
		return undefined;
	};

	/**
	 * The width for the OverlayDialog.
	 *
	 * @param {sap.ui.core.CSSSize} sWidth
	 * @public
	 */
	OverlayDialog.prototype.setWidth = function(sWidth) {
		if (sWidth == "auto" || sWidth == "inherit") {
			sWidth = "auto";
		}
		return this.setProperty("width", sWidth);
	};

	/**
	 * The height for the OverlayDialog.
	 *
	 * @param {sap.ui.core.CSSSize} sHeight
	 * @public
	 */
	OverlayDialog.prototype.setHeight = function(sHeight) {
		if (sHeight == "auto" || sHeight == "inherit") {
			sHeight = "auto";
		}
		return this.setProperty("height", sHeight);
	};

	/**
	 * @private
	 */
	OverlayDialog.prototype.onBeforeRendering = function(){
		Overlay.prototype.onBeforeRendering.apply(this, arguments);
		this._cleanup();
	};

	/**
	 * @private
	 */
	OverlayDialog.prototype.onAfterRendering = function(){
		Overlay.prototype.onAfterRendering.apply(this, arguments);
		OverlayDialog.Trigger.addListener(this._checkChange, this);
	};

	/**
	 * @private
	 */
	OverlayDialog.prototype._cleanup = function(){
		OverlayDialog.Trigger.removeListener(this._checkChange, this);
		this.contentWidth = null;
		this.contentHeight = null;
		this.overlayWidth = null;
		this.overlayHeight = null;
	};

	/**
	 * @private
	 */
	OverlayDialog.prototype.exit = function() {
		this._cleanup();
		Overlay.prototype.exit.apply(this,arguments);
	};

	/**
	 * @private
	 */
	OverlayDialog.prototype._checkChange = function(){
		if (!this.getDomRef()) {
			return;
		}

		var $content = this.$("content"),
			$overlay = this.$(),
			bAutoWidth = this.getWidth() === "auto",
			bAutoHeight = this.getHeight() === "auto";

		var contentWidth = bAutoWidth ? $overlay.width() / 2 : $content.width(),
			contentHeight = bAutoHeight ? $overlay.height() / 2 : $content.height(),
			overlayWidth = $overlay.width(),
			overlayHeight = $overlay.height();

		if (contentWidth != this.contentWidth || contentHeight != this.contentHeight
			|| overlayWidth != this.overlayWidth || overlayHeight != this.overlayHeight) {

			$content.css("left", "0").css("right", "auto").css("top", "0").css("bottom", "auto").css("width", this.getWidth()).css("height", this.getHeight());

			this.contentWidth = bAutoWidth ? $overlay.width() / 2 : $content.width();
			this.contentHeight = bAutoHeight ? $overlay.height() / 2 : $content.height();
			this.overlayWidth = overlayWidth;
			this.overlayHeight = overlayHeight;

			var $close = this.$("close");

			if (this.contentWidth < this.overlayWidth) {
				$content.css("left", "50%");
				$content.css("right", "auto");
				$content.css("margin-left", ( -1) * this.contentWidth / 2 + "px");
				$content.css("width",  bAutoHeight ? this.contentWidth : this.getWidth());
				$close.css("right", "50%");
				$close.css("margin-right", ( -1) * this.contentWidth / 2 - 10 + "px");
			} else {
				$content.css("left", "0");
				$content.css("right", "10px");
				$content.css("margin-left", "0");
				$content.css("width", "auto");
				$close.css("right", "0");
				$close.css("margin-right", "0");
			}

			if (this.contentHeight < this.overlayHeight - 30/*Bottom Border (NotificationBar)*/) {
				$content.css("top", "50%");
				$content.css("bottom", "auto");
				$content.css("margin-top", ( -1) * this.contentHeight / 2 + "px");
				$content.css("height",  bAutoHeight ? this.contentHeight : this.getHeight());
				$close.css("top", "50%");
				$close.css("margin-top", ( -1) * this.contentHeight / 2 - 10 + "px");
			} else {
				$content.css("top", "10px");
				$content.css("bottom", "30px");
				$content.css("margin-top", "0");
				$content.css("height", "auto");
				$close.css("top", "0");
				$close.css("margin-top", "0");
			}
		}
	};

	return OverlayDialog;
}, /* bExport= */ true);

}; // end of sap/ui/ux3/OverlayDialog.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.OverlayDialogRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.ui.ux3.OverlayDialog
jQuery.sap.declare('sap.ui.ux3.OverlayDialogRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/OverlayDialogRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './OverlayRenderer'],
	function(jQuery, Renderer, OverlayRenderer) {
	"use strict";

/**
	 * OverlayDialog renderer.
	 * @namespace
	 */
	var OverlayDialogRenderer = Renderer.extend(OverlayRenderer);
	
	/**
	 * Renders the Overlay content
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	OverlayDialogRenderer.renderContent = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.write("<div role='Main' class='sapUiUx3ODContent' id='" + oControl.getId() + "-content'>");
		var content = oControl.getContent();
		for (var i = 0; i < content.length; i++) {
			var control = content[i];
			rm.renderControl(control);
		}
		rm.write("</div>");
	};
	
	/**
	 * Add root class to Overlay
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	OverlayDialogRenderer.addRootClasses = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.addClass("sapUiUx3OD");
	};
	
	/**
	 * Add class to Overlay
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRenderManager the RenderManager that can be used for writing to
	 *            the Render-Output-Buffer
	 * @param {sap.ui.core.Control}
	 *            oControl an object representation of the control that should be
	 *            rendered
	 */
	OverlayDialogRenderer.addOverlayClasses = function(oRenderManager, oControl) {
		var rm = oRenderManager;
		rm.addClass("sapUiUx3ODOverlay");
	};
	

	return OverlayDialogRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/OverlayDialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.QuickView') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.QuickView.
jQuery.sap.declare('sap.ui.ux3.QuickView'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.CalloutBase'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/QuickView",['jquery.sap.global', 'sap/ui/commons/CalloutBase', 'sap/ui/core/delegate/ItemNavigation', './ActionBar', './library'],
	function(jQuery, CalloutBase, ItemNavigation, ActionBar, library) {
	"use strict";


	
	/**
	 * Constructor for a new QuickView.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * QuickView is a small popup with a short overview of a Thing.
	 * QuickView is shown when a user holds the mouse pointer over a related screen element.
	 * @extends sap.ui.commons.CalloutBase
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.QuickView
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var QuickView = CalloutBase.extend("sap.ui.ux3.QuickView", /** @lends sap.ui.ux3.QuickView.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * Thing type (mandatory) like Account, Material, Employee etc. is displayed in a header at the top part of the QuickView.
			 */
			type : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Thing name shown in the header of the QuickView
			 */
			firstTitle : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * URI to Thing Inspector
			 */
			firstTitleHref : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Optional short text shown under the firstTitle
			 */
			secondTitle : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * URI of the Thing icon image (mandatory). The image is scaled down to the maximal size of 32 pixel (vertical or horizontal).
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
	
			/**
			 * Control width as common CSS-size (px or % as unit, for example).
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
	
			/**
			 * Show Action Bar
			 */
			showActionBar : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Follow State of a Thing
			 */
			followState : {type : "sap.ui.ux3.FollowActionState", group : "Misc", defaultValue : sap.ui.ux3.FollowActionState.Default},
	
			/**
			 * State of Flag Action
			 */
			flagState : {type : "boolean", group : "Misc", defaultValue : false},
	
			/**
			 * State Of favorite Action
			 */
			favoriteState : {type : "boolean", group : "Misc", defaultValue : false},
	
			/**
			 * Favorite action enabled/disabled. If disabled the action will be invisible.
			 */
			favoriteActionEnabled : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Update action enabled/disabled. If disabled the action will be invisible.
			 */
			updateActionEnabled : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Follow action enabled/disabled. If disabled the action will be invisible.
			 */
			followActionEnabled : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Flag action enabled/disabled. If disabled the action will be invisible.
			 */
			flagActionEnabled : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Open Thing action enabled/disabled. If disabled the action will be invisible.
			 */
			openActionEnabled : {type : "boolean", group : "Misc", defaultValue : true}
		},
		aggregations : {
	
			/**
			 * Body content of the QuickView
			 */
			content : {type : "sap.ui.core.Element", multiple : true, singularName : "content"}, 
	
			/**
			 * Actions of a Thing
			 */
			actions : {type : "sap.ui.ux3.ThingAction", multiple : true, singularName : "action"}, 
	
			/**
			 * ActionBar. If no actionBar is set a default ActionBar will be created.
			 * In any case, ActionBar is displayed only when the showActionBar property is set to true.
			 */
			actionBar : {type : "sap.ui.ux3.ActionBar", multiple : false}
		},
		events : {
	
			/**
			 * Action is selected in Action Bar
			 */
			actionSelected : {
				parameters : {
	
					/**
					 * Id of selected ThingAction
					 */
					id : {type : "string"}, 
	
					/**
					 * Selected ThingAction
					 */
					action : {type : "sap.ui.ux3.ThingAction"}, 
	
					/**
					 * New State of the selected action. Only filled if the respective action maintains a state property, for example 'FollowUp' or 'Favorite'
					 */
					newState : {type : "string"}
				}
			}, 
	
			/**
			 * Fired when a new feed entry is submitted.
			 */
			feedSubmit : {
				parameters : {
	
					/**
					 * Feed text
					 */
					text : {type : "string"}
				}
			}, 
	
			/**
			 * Event is fired when a user clicks on the firstTitle link. Call the preventDefault method of the event object to cancel browser navigation.
			 */
			navigate : {allowPreventDefault : true,
				parameters : {
	
					/**
					 * URI of the Thing Inspector application.
					 */
					href : {type : "string"}
				}
			}
		}
	}});
	
	///**
	// * This file defines behavior for the QuickView control,
	// */
	
	
	/**
	 * Initialization of the QuickView control.
	 * 
	 * @private
	 */
	QuickView.prototype.init = function(){
	
		var oActionBar;
	
		// react on the ActionSelected event of the ActionBar
		function onActionSelected(oControlEvent){
			var parameters = oControlEvent.getParameters();
			this.fireActionSelected(parameters);
		}
	
		// react on the FeedSubmit event of the ActionBar
		function onFeedSubmit(oControlEvent){
			var parameters = oControlEvent.getParameters();
			this.fireFeedSubmit(parameters);
		}
	
		// Initialize CalloutBase
		CalloutBase.prototype.init.call(this);
	
		if (!this.getActionBar()) {
			oActionBar = new ActionBar();
	
			oActionBar.attachActionSelected(jQuery.proxy(onActionSelected, this));
	
			oActionBar.attachFeedSubmit(jQuery.proxy(onFeedSubmit, this));
			this.setAggregation("actionBar", oActionBar, true);
		}
	};
	
	/**
	* Handle the mouseover event
	* @param {jQuery.EventObject} oEvent The event that occurred on the QuickView link
	* @private
	 */
	QuickView.prototype.onmouseover = function(oEvent) {
		//jQuery.sap.log.debug("QuickView: mouseover");
		var oPopup = this._getPopup();
		// do not close my pop-up if it was opened already
		if (oPopup.isOpen() && oPopup.getContent() == this) {
			if (this.sCloseNowTimeout) {
				jQuery.sap.clearDelayedCall(this.sCloseNowTimeout);
				this.sCloseNowTimeout = null;
			}
			return;
		}
	
		sap.ui.core.TooltipBase.prototype.onmouseover.call(this, oEvent);
	};
	
	/**
	 * Organize header fields navigation with help of arrow keys.
	 * 
	 * @private
	 */
	QuickView.prototype.onAfterRendering = function(){
		// Collect the DOM references of items that are accessible via keyboard arrow keys
	
		var oFocusRef = this.getDomRef(),
			aDomRefs = [];
	
		// Title
		var oRef = this.$("title");
		aDomRefs.push(oRef);
	
		// Name
		oRef = this.$("link");
		if (!oRef.length) {oRef = this.$("name"); } // when no link, navigate to -name
		if (!oRef.length) { return; } // do nothing if we have a title only
		aDomRefs.push(oRef);
	
		// Description
		oRef = this.$("descr");
		if (oRef.length) {aDomRefs.push(oRef);}
	
		// initialize item navigation
		if (!this.oItemNavigation) {
			this.oItemNavigation = new ItemNavigation(null, null, false);
			this.addDelegate(this.oItemNavigation);
		}
		this.oItemNavigation.setRootDomRef(oFocusRef);
		this.oItemNavigation.setItemDomRefs(aDomRefs);
		this.oItemNavigation.setCycling(false);
		this.oItemNavigation.setSelectedIndex(1); // UX3 requirement: the Name field must be focused first
		this.oItemNavigation.setPageSize(aDomRefs.length);
	};
	
	/**
	 * Function is called when the Control is clicked.
	 * If one of the links on the form is clicked, fire a "navigate" event, otherwise ignore the click.
	 * If one of the "navigate" event handlers calls <code>preventDefault()</code>,
	 * prevent the original event too (cancel browser navigation).
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	QuickView.prototype.onclick = function(oEvent) {
	
		var oTarget = oEvent.target;
		// react only on clicks over links:
		if (!oTarget || !oTarget.hasAttribute("href") ) { return; }
	
		// fire the "navigate" event and prevent browser navigation if the application requests this
		if (!this.fireEvent("navigate", {href:oTarget.href}, true, false)) {
			oEvent.preventDefault();
		}
	};
	
	/**
	 * Clean up on exit.
	 * 
	 * @private
	 */
	QuickView.prototype.exit = function() {
		if (this.oItemNavigation) {
			this.removeDelegate(this.oItemNavigation);
			this.oItemNavigation.destroy();
			delete this.oItemNavigation;
		}
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.insertAction = function(oAction, iIndex) {
		if (this.getActionBar()) {
			this.getActionBar().insertBusinessAction(oAction, iIndex);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.addAction = function(oAction) {
		if (this.getActionBar()) {
			this.getActionBar().addBusinessAction(oAction);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.removeAction = function(oAction) {
		if (this.getActionBar()) {
			this.getActionBar().removeBusinessAction(oAction);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.removeAllActions = function() {
		if (this.getActionBar()) {
			this.getActionBar().removeAllBusinessActions();
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.getActions = function() {
		if (this.getActionBar()) {
			this.getActionBar().getBusinessActions();
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.destroyActions = function() {
		if (this.getActionBar()) {
			this.getActionBar().destroyBusinessActions();
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.setFollowState = function(oFollowState) {
		if (this.getActionBar()) {
			this.getActionBar().setFollowState(oFollowState);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.getFollowState = function() {
		var result = null;
		if (this.getActionBar()) {
			result = this.getActionBar().getFollowState();
		}
		return result;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.setFlagState = function(oFlagState) {
		if (this.getActionBar()) {
			this.getActionBar().setFlagState(oFlagState);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.getFlagState = function() {
		var result = null;
		if (this.getActionBar()) {
			result = this.getActionBar().getFlagState();
		}
		return result;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.setFavoriteState = function(oFavoriteState) {
		if (this.getActionBar()) {
			this.getActionBar().setFavoriteState(oFavoriteState);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.getFavoriteState = function() {
		var result = null;
		if (this.getActionBar()) {
			result = this.getActionBar().getFavoriteState();
		}
		return result;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.setFavoriteActionEnabled = function(bEnabled) {
		if (this.getActionBar()) {
			this.getActionBar().setShowFavorite(bEnabled);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.getFavoriteActionEnabled = function() {
		var result;
		if (this.getActionBar()) {
			result = this.getActionBar().getShowFavorite();
		}
		return result;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.setFlagActionEnabled = function(bEnabled) {
		if (this.getActionBar()) {
			this.getActionBar().setShowFlag(bEnabled);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.getFlagActionEnabled = function() {
		var result;
		if (this.getActionBar()) {
			result = this.getActionBar().getShowFlag();
		}
		return result;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.setUpdateActionEnabled = function(bEnabled) {
		if (this.getActionBar()) {
			this.getActionBar().setShowUpdate(bEnabled);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.getUpdateActionEnabled = function() {
		var result;
		if (this.getActionBar()) {
			result = this.getActionBar().getShowUpdate();
		}
		return result;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.setFollowActionEnabled = function(bEnabled) {
		if (this.getActionBar()) {
			this.getActionBar().setShowFollow(bEnabled);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.getFollowActionEnabled = function() {
		var result;
		if (this.getActionBar()) {
			result = this.getActionBar().getShowFollow();
		}
		return result;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.setOpenActionEnabled = function(bEnabled) {
		if (this.getActionBar()) {
			this.getActionBar().setShowOpen(bEnabled);
		}
		return this;
	};
	
	// Interface method to ActionBar API
	QuickView.prototype.getOpenActionEnabled = function() {
		var result;
		if (this.getActionBar()) {
			result = this.getActionBar().getShowOpen();
		}
		return result;
	};
	
	// Implementation of API method
	QuickView.prototype.setIcon = function(oIcon) {
		this.setProperty("icon", oIcon);
		if (this.getActionBar()) {
			this.getActionBar().setThingIconURI(oIcon);
		}
		return this;
	};
	
	// Implementation of API method
	QuickView.prototype.setActionBar = function(oActionBar) {
		this.setAggregation("actionBar", oActionBar, true);
		if (this.getIcon() && this.getActionBar()) {
			this.getActionBar().setThingIconURI(this.getIcon());
		}
		return this;
	};
	

	return QuickView;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/QuickView.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.Shell') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.Shell.
jQuery.sap.declare('sap.ui.ux3.Shell'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Menu'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/Shell",['jquery.sap.global', 'sap/ui/commons/Menu', 'sap/ui/core/Control', 'sap/ui/core/theming/Parameters', './library'],
	function(jQuery, Menu, Control, Parameters, library) {
	"use strict";



	/**
	 * Constructor for a new Shell.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The Ux3 GoldReflection Shell, which is an application frame with navigation capabilities.
	 * It is supposed to be added to a direct child of the BODY tag of a page and there should be no other parts of the page consuming space outside the Shell.
	 * @extends sap.ui.core.Control
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.Shell
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Shell = Control.extend("sap.ui.ux3.Shell", /** @lends sap.ui.ux3.Shell.prototype */ { metadata : {

		library : "sap.ui.ux3",
		properties : {

			/**
			 * The application title to appear in the left part of the header, usually a company and/or product name. appIcon and appTitle are both optional and can both be set; in this case the icon appears first.
			 */
			appTitle : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * The URL of the image to appear in the left part of the header, usually a branding image containing a logo and/or product name. appIcon and appTitle are both optional and can both be set; in this case the icon appears first.
			 * If the appIcon is set, for accessibility reasons the appIconTooltip must also be set.
			 */
			appIcon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},

			/**
			 * The tooltip of the application icon in the header
			 */
			appIconTooltip : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Whether the Logoff button in the header should be displayed or not.
			 */
			showLogoutButton : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * The tooltip to be displayed for the Logout Button of the Shell. If not set, a text meaning "Logout" in the current language will be displayed.
			 * @since 1.9.0
			 */
			logoutButtonTooltip : {type : "string", group : "Accessibility", defaultValue : null},

			/**
			 * Whether the "Global Search" tool should be displayed or not.
			 */
			showSearchTool : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Whether the "Inspector" tool should be displayed or not.
			 * @deprecated Since version 1.7.2.
			 * According to the current Ux designs, the ThingInspector should NOT be opened like this from the Tool Pane. And technically, the ThingInspector is not a ToolPopup.
			 * Instead trigger it from the respective elements in the Shell content.
			 */
			showInspectorTool : {type : "boolean", group : "Misc", defaultValue : false, deprecated: true},

			/**
			 * Whether the "Feeder" tool should be displayed or not.
			 */
			showFeederTool : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Whether the tool area should be displayed at all or not.
			 */
			showTools : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Whether the pane bar should be displayed at all or not.
			 */
			showPane : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Defines which header type to be used. Depending on the header type some other functionality might be obsolete.
			 */
			headerType : {type : "sap.ui.ux3.ShellHeaderType", group : "Misc", defaultValue : sap.ui.ux3.ShellHeaderType.Standard},

			/**
			 * Defines which design type is to be used.
			 * @since 1.12.0
			 */
			designType : {type : "sap.ui.ux3.ShellDesignType", group : "Misc", defaultValue : sap.ui.ux3.ShellDesignType.Standard},

			/**
			 * The width of the right-hand side pane in pixels. The value must be a non-negative integer. The Shell reserves the right to define a minimum width (currently 50px).
			 */
			paneWidth : {type : "int", group : "Misc", defaultValue : 250},

			/**
			 * Whether the Shell content area should have a theme-dependent padding or not.
			 * @since 1.9.0
			 */
			applyContentPadding : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * If set to true, the content area has a defined height. This means that any content put inside can use "100%" height in CSS and will then consume all available space.
			 * However, if content is larger, scrollbars will appear at the content area of the Shell and not on window level.
			 * @since 1.9.0
			 */
			fullHeightContent : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Whether the Shell header (Title Area + Header Items) can be accessed when an Overlay, OverlayContainer or ThingInspector is open.
			 * @since 1.14.0
			 */
			allowOverlayHeaderAccess : {type : "boolean", group : "Appearance", defaultValue : false}
		},
		defaultAggregation : "content",
		aggregations : {

			/**
			 * The workset items.
			 */
			worksetItems : {type : "sap.ui.ux3.NavigationItem", multiple : true, singularName : "worksetItem"},

			/**
			 * The items to appear in the PaneBar.
			 */
			paneBarItems : {type : "sap.ui.core.Item", multiple : true, singularName : "paneBarItem"},

			/**
			 * The content to appear in the pane area.
			 */
			paneContent : {type : "sap.ui.core.Control", multiple : true, singularName : "paneContent"},

			/**
			 * The content to appear in the main canvas. Each modification of this aggregation leads to a re-rendering of the content area - but not to a re-rendering of the complete Shell.
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"},

			/**
			 * The items which appear in the ToolPalette and are opened as popup when clicked.
			 */
			toolPopups : {type : "sap.ui.ux3.ToolPopup", multiple : true, singularName : "toolPopup"},

			/**
			 * Controls to appear in the header next to the logout button. It is recommended to only use controls of type Button, MenuButton and TextView.
			 * The respective UI guidelines need to be enforced on a higher level.
			 */
			headerItems : {type : "sap.ui.core.Control", multiple : true, singularName : "headerItem"},

			/**
			 * The NotificationBar which should be integrated into the Shell.
			 * @since 1.7.0
			 */
			notificationBar : {type : "sap.ui.ux3.NotificationBar", multiple : false},

			/**
			 *
			 * The menu that is shown when there are too many pane-bar entries to fit onto the screen.
			 * It is shown after a click on the overflow button that appears in that case.
			 * @since 1.14.0
			 */
			_paneOverflowMenu : {type : "sap.ui.commons.Menu", multiple : false, visibility : "hidden"}
		},
		associations : {

			/**
			 * The ID of the Item that is currently selected.
			 * When setting, the NavigationItem itself can be given instead of its ID. There will not be a worksetItemSelected event, the application is responsible to show the proper content according to the newly selected WorksetItem. If the set WorksetItem does not exist in this Shell, the first item (and first sub-item) will be selected after the call.
			 * When getting, always the ID is returned, by which the NavigationItem instance can be retrieved.
			 */
			selectedWorksetItem : {type : "sap.ui.ux3.NavigationItem", multiple : false}
		},
		events : {

			/**
			 * Fired when a workset item was selected by the user. The application may populate the sub-items of the given workset item in the event handler, but this must happen synchronously. If this is done, the application is responsible for displaying the correct content for the selected one of the newly created sub-items. The Shell will currently always mark the first sub-item as selected.
			 */
			worksetItemSelected : {allowPreventDefault : true,
				parameters : {

					/**
					 * The id of the workset item that has been newly selected by the user. If a top-level item has been clicked which has sub-items, the ID of the currently active sub-item (/leaf) is given.
					 */
					id : {type : "string"},

					/**
					 * The selected NavigationItem
					 */
					item : {type : "sap.ui.ux3.NavigationItem"},

					/**
					 * The key of the selected NavigationItem (or null if there is no key)
					 */
					key : {type : "string"}
				}
			},

			/**
			 * An item in the right-hand-side pane bar has been selected, the pane is now visible and can be filled with UI elements.
			 */
			paneBarItemSelected : {
				parameters : {

					/**
					 * The ID of the selected PaneBarItem.
					 */
					id : {type : "string"},

					/**
					 * The selected Item
					 */
					item : {type : "sap.ui.core.Item"},

					/**
					 * The key of the selected Item (or null if there is no key)
					 */
					key : {type : "string"}
				}
			},

			/**
			 * Fired when the user clicks the "Log-off" button
			 */
			logout : {},

			/**
			 * Fired when search has been triggered.
			 */
			search : {},

			/**
			 * Fired when a new feed entry is submitted.
			 */
			feedSubmit : {},

			/**
			 * Fired after a side pane of the shell is closed. It is also fired, when an open pane is closed by calling setShowPane(false), if and only if the pane was opened before.
			 * @since 1.12.0
			 */
			paneClosed : {
				parameters : {

					/**
					 * The id of the PaneBarItem to which the closed pane belonged.
					 */
					id : {type : "string"}
				}
			}
		}
	}});


	Shell.WSI_MENU_DELAY = 200;
	Shell.WSI_OVERFLOW_SCROLL_STEP = 250; // how many pixels to scroll with every overflow arrow click
	Shell.TOOL_PREFIX = "-tool-";
	Shell.FIRST_RENDERING = true; // used for detecting the single very first rendering of any Shell on the page

	/**
	 * The basic width of the ToolPalette if all icons fit into one column. Multiplied if more than
	 * one column of items must be used.
	 *
	 * This value might change after rendering from the LESS parameter "sapUiUx3ShellSideBarBaseWidth"
	 * @see onBeforeRendering and onThemeChanged
	 */
	Shell.SIDE_BAR_BASE_WIDTH = null;

	/**
	 * The basic height of the overflow button in the right pane. Shown when there are too many entries.
	 *
	 * This value might change after rendering from the LESS parameter "sapUiUx3ShellPaneOverflowButtonHeight",
	 * @see onBeforeRendering and onThemeChanged
	 */
	Shell.PANE_OVERFLOW_BUTTON_HEIGHT = null;

	Shell.prototype.init = function() {
		this._iOpenPaneIndex = -1;
		this._sOpenWsiId = null;

		this._bPreviousScrollRight = false; // remember the workset item overflow state
		this._bPreviousScrollLeft = false;

		this._sSelectedWorksetId = null;
		this._sSelectedFacetId = null;

		this._aSyncRefStack = [];
		this._mSyncRefs = {};

		this._oWorksetBar = new sap.ui.ux3.NavigationBar(this.getId() + "-wsBar", {
			toplevelVariant : true,
			select          : [this._handleWorksetBarSelect, this]
		}).setParent(this);
		this._oFacetBar = new sap.ui.ux3.NavigationBar(this.getId() + "-facetBar", {
			select          : [this._handleFacetBarSelect, this]
		}).setParent(this);

		this.setAggregation("_paneOverflowMenu", new Menu());

		// Resize check closure, to be used with bind and unbind (so the right one gets unbound)
		var that = this;
		this._checkResizeClosure = function() { that._checkResize(); };

		// The following calue is updated when the ToolPalette is resized.
		// (It is used in methods like _closePane and setOffsetRight)
		this.currentToolPaletteWidth = 0;

		this._updateThemeVariables();
	};


	Shell.prototype.exit = function() {
		if (this._oWorksetBar) {
			this._oWorksetBar.destroy();
			delete this._oWorksetBar;
		}
		if (this._oFacetBar) {
			this._oFacetBar.destroy();
			delete this._oFacetBar;
		}
		this._oSearchField = null;

		jQuery(window).unbind("resize", this._checkResizeClosure);
	};


	Shell.prototype.onBeforeRendering = function() {

		// unbind the tool palette mouse (hover effect) handlers
		this._beforeRenderingToolPalette();

		this.$("focusDummyPane").unbind("focusin");

		// drag&drop for images with local file API
		if (window.FileReader) {
			var $hdr = this.$("hdr");
			$hdr.unbind('dragover', this._handleDragover)
			.unbind('dragend', this._handleDragend)
			.unbind('drop', this._handleDrop);
			var $bg = this.$("bgImg");
			$bg.unbind('dragover', jQuery.proxy(this._handleDragover))
			.unbind('dragend', this._handleDragend)
			.unbind('drop', this._handleDrop);
		}

	};


	Shell.prototype.onAfterRendering = function() {

		// register hover effect handlers for application-provided tool icons
		this._afterRenderingToolPalette();

		if (this._topSyncRefId && this._mSyncRefs[this._topSyncRefId].focusLast) {
			this.$("focusDummyPane").focusin(this._mSyncRefs[this._topSyncRefId].focusLast);
		}

		// drag&drop for images with local file API
		if (window.FileReader) {
			var $hdr = this.$("hdr");
			$hdr.bind('dragover', jQuery.proxy(this._handleDragover, this))
			.bind('dragend',jQuery.proxy(this._handleDragend, this))
			.bind('drop', jQuery.proxy(this._handleDrop, this));
			var $bg = this.$("bgImg");
			$bg.bind('dragover', jQuery.proxy(this._handleDragover, this))
			.bind('dragend',jQuery.proxy(this._handleDragend, this))
			.bind('drop', jQuery.proxy(this._handleDrop, this));
		}

		// hide or show the facet bar depending on whether the current workset item has sub-items
		var bShowFacetBar = (this._oFacetBar.getAssociatedItems().length > 0);
		var $FacetBar = this.$("facetBar");
		$FacetBar.css("display", (bShowFacetBar ? "block" : "none"));
		this._adaptContentHeight();

		// remember RTL mode to avoid repeated checks
		this._bRtl = sap.ui.getCore().getConfiguration().getRTL();

		if (this._getPersonalization().hasChanges()) {
			this._getPersonalization().applySettings(this._getPersonalization().oSettings);
		}

		// ItemNavigation for PaneBar items
		if (!this._oPaneItemNavigation) {
			this._oPaneItemNavigation = new sap.ui.core.delegate.ItemNavigation().setCycling(false);
			this.addDelegate(this._oPaneItemNavigation);
		}
		var $PaneListRef = this.$("paneBarEntries");
		this._updatePaneBarItemNavigation($PaneListRef);

		this._setNotifyVisibility();

		if (Shell.FIRST_RENDERING) {
			jQuery(window).bind("resize", this._checkResizeClosure);
		}
		this._checkResize();

		Shell.FIRST_RENDERING = false;

		// Firefox ESR (17) workaround
		// TODO: Remove when Firefox ESR is updated
		if (!!sap.ui.Device.browser.firefox && sap.ui.Device.browser.version == 17) {
			jQuery.sap.delayedCall(500, this, this._checkResize);
		}
	};

	/**
	 * Reads LESS parameter values from the currently active theme.
	 * If any of the values are set to NaN, something went wrong.
	 *
	 * @private
	 */
	Shell.prototype._updateThemeVariables = function() {
		Shell.SIDE_BAR_BASE_WIDTH = parseInt(
			Parameters.get("sapUiUx3ShellSideBarBaseWidth"),
			10
		);

		Shell.PANE_OVERFLOW_BUTTON_HEIGHT = parseInt(
			Parameters.get("sapUiUx3ShellPaneOverflowButtonHeight"),
			10
		);
		// Save the original button height to be referenced as maximum height
		Shell.PANE_OVERFLOW_BUTTON_MAX_HEIGHT = Shell.PANE_OVERFLOW_BUTTON_HEIGHT;
	};


	/**
	 * Triggers a delayed check that determines whether the overflow mechanism of the side bars
	 * must be activated.
	 *
	 * @private
	 */
	Shell.prototype._checkResize = function() {
		if (!this.getDomRef()) {
			return;
		}

		// The browser window is (depending on the configuration) repainted several hundred times
		// during resize, which triggers several resize-events
		// Keep it from executing several times when only once suffices...
		jQuery.sap.clearDelayedCall(this._checkResizeDelayId);
		this._checkResizeDelayId = jQuery.sap.delayedCall(100, this, function() {
			this._rerenderPaneBarItems();
			this._checkToolPaletteSize();
		});
	};


	/**
	 * Checks whether there are too many ToolPopups to fit into the ToolPalette (left bar) and changes
	 * its width accordingly.
	 */
	Shell.prototype._checkToolPaletteSize = function(bHideBar) {
		if (!this.getDomRef()) {
			// Do not try to calculate anything if nothing has been rendered
			return;
		}

		if (bHideBar === undefined) {
			bHideBar = !this.getShowTools();
		}

		// Check whether the last item is still visible on the screen
		var oToolPalette = this.$("tp");

		var iColumns = 1;
		var iLastTop = 9999999; // Just some very large number...
		var iCurrentTop = 0;
		var bKeepGrowing = true;

		if (bHideBar) {
			iColumns = 0;
			bKeepGrowing = false;
		}

		do { // Loop at least once
			var iBarWidth  = iColumns * Shell.SIDE_BAR_BASE_WIDTH;
			var iSepWidth  = Math.floor(iBarWidth / 2);
			var iSepMargin = Math.floor(iBarWidth / 4);

			var sSide1 = this._bRtl ? "right" : "left";

			// Move left side of canvas
			this.$("canvas").css(sSide1, iBarWidth + "px");
			this.$("canvasBackground").css(sSide1, iBarWidth + "px");
			// Move left side of WorksetItems (Navigation)
			this.$("wBar").css("margin-" + sSide1, iBarWidth + "px");

			// Resize the Notification Area
			var mProps = {};
			mProps[sSide1] = iBarWidth + "px";
			this.$("notify").css(mProps);

			// Resize ToolPalette
			oToolPalette.css("width", iBarWidth + "px");
			// Resize Toolpalette Separators
			var mProps = {};
			mProps["width"] = iSepWidth + "px";
			mProps["margin-" + sSide1] = iSepMargin + "px";
			this.$("tp-separator").css(mProps);

			if (!bKeepGrowing) {
				// Break if we have to stop growing...
				break;
			}

			sap.ui.core.RenderManager.forceRepaint(oToolPalette[0]);
			iCurrentTop = oToolPalette.children().last()[0].offsetTop;
			if (iCurrentTop >= iLastTop) {
				// Reset to previous size...
				iColumns--;
				// and break (see if-condition above)
				bKeepGrowing = false;
				continue;
			}
			iLastTop = iCurrentTop;

			iColumns++;
			if (iColumns > 10) {
				// Now this is just silly....
				jQuery.sap.log.error("The ToolPalette is growing too much, this must be a bug.");
				break;
			}

		} while (
			iCurrentTop > oToolPalette.height()
		);

		this.currentToolPaletteWidth = this.getShowTools() ? iBarWidth : 0;

		this._updateOverlaysOnToolPaletteChange();
	};


	Shell.prototype._updateOverlaysOnToolPaletteChange = function() {
		// Resize visible Overlays when the ToolPalette changes its width.
		// Overlays can for example be ThingInspectors that leave room to the sides so the user is able
		// to use the panes while having the overlay open.
		// See setShowTools-method for another location that updates positions in this way
		var $OpenOverlays = this._getSyncRefs();
		if (this._bRtl) {
			$OpenOverlays.css("right", this.currentToolPaletteWidth + "px");
		} else {
			$OpenOverlays.css("left", this.currentToolPaletteWidth + "px");
		}
	};


	/**
	 * Updates the ItemNavigation for the PaneBarItems after the HTML has changed due to re-rendering
	 *
	 * @param $PaneListRef
	 */
	Shell.prototype._updatePaneBarItemNavigation = function($PaneListRef) {
		this._oPaneItemNavigation.setRootDomRef($PaneListRef[0]);
		var aPaneItems = $PaneListRef.children().toArray();
		this._oPaneItemNavigation.setItemDomRefs(aPaneItems);

		if (this._oPaneItemNavigation.getFocusedIndex() > aPaneItems.length) { // if items have been removed
			this._oPaneItemNavigation.setFocusedIndex( -1);
		}

		this._checkPaneBarOverflow($PaneListRef);
	};

	/**
	 * Called in onAfterRendering and onThemeChanged to make sure that the paneBar-items that do not
	 * fit on screen are rendered in a separate menu.
	 *
	 * @param $PaneListRef jQuery object pointing to the List containing the items
	 * @private
	 */
	Shell.prototype._checkPaneBarOverflow = function($PaneListRef) {
		// Keep it from executing several times when only once suffices...
		jQuery.sap.clearDelayedCall(this._checkPaneBarOverflowDelayId);
		this._checkPaneBarOverflowDelayId = jQuery.sap.delayedCall(200, this, function() {
			this._delayedCheckPaneBarOverflow($PaneListRef);
		});
	};

	Shell.prototype._delayedCheckPaneBarOverflow = function($PaneListRef) {

		if (!$PaneListRef) {
			$PaneListRef = this.$("paneBarEntries");
		}
		if ($PaneListRef.length == 0) {
			// If it is still not there, try again later...
			this._checkPaneBarOverflow();
			return;
		}

		var iListHeight =
			$PaneListRef.parent().height() -
			// The container itself overflows and its height is defined by its padding which changes
			// the available space in RTL mode...
			// TODO: Check for a more elegant solution and - if found - rewrite
			(this._bRtl ? $PaneListRef.innerHeight() : 0);
		var iItemBottomPosition = 0;
		var $Entries = $PaneListRef.children();

		$Entries.css("display", "inline-block");
		var bItemsInMenu = false;
		var len = $Entries.length;
		for (var i = len - 1; i >= 0; --i) {
			// TODO: Maybe we can loop backwards and just brake when the first one fits.

			var oDomEntry = $Entries[i];
			// Find out at which position the bottom end of the item lies
			if (this._bRtl) {
				// When RTL-mode is enabled the rotated left side of the pane entry is at the bottom,
				// so the negative offsetLeft value indicates how far down the item goes...
				iItemBottomPosition = (0 - oDomEntry.offsetLeft);
			} else {
				// In normal mode, the rotated left is at the top, so we have to add the item width
				// to the offsetLeft value in order to get the bottom position
				iItemBottomPosition = oDomEntry.offsetLeft + oDomEntry.offsetWidth;
			}

			var bItemInPane = iItemBottomPosition < iListHeight;

			// Hide/show the main item
			jQuery(oDomEntry).css("display", bItemInPane ? "inline-block" : "none");
			// Hide/show the submenu item
			sap.ui.getCore().byId(oDomEntry.id + "-overflow").setVisible(!bItemInPane);

			if (bItemInPane) {
				// This item is inside the pane
				continue;
				// We cannot break at this point, since we don't know which items have been visible
				// in the overflow-menu before - so we have to loop over all items and set the
				// visibility for all of them. Else, menu items could be set to visible that should
				// be hidden. Another solution would be to always show every entry in the overflow
				// menu.
			} else {
				bItemsInMenu = true;
			}
		}

		var $OverflowButton = this.$("paneBarOverflowButton");
		if (bItemsInMenu) {
			// Overflow is happening. Show button.
			$OverflowButton.css("display", "block");

		} else {
			// No overflow. Hide button.
			$OverflowButton.css("display", "none");
			// // Remove buffer for overflow menu button
			// $PaneBar.css("padding-bottom", "0");

			// Firefox ESR (17) Redraw bug workaround
			// TODO: Remove when Firefox ESR is updated
			if (!!sap.ui.Device.browser.firefox && sap.ui.Device.browser.version == 17) {
				sap.ui.core.RenderManager.forceRepaint(document.getElementsByTagName("body")[0]);
			}
		}

		// This is tricky: Because of this method, the overflow-button might change, but since the
		// calculation depends on the size of the overflow-button we have to check whether something
		// changed and then restart the calculation if it did (or else we have an endless loop).
		var bOverflowButtonChanged = this._changeOverflowButton();
		if (bOverflowButtonChanged) {
			this._checkPaneBarOverflow();
		}

	};


	/**
	 * Checks the text content of the overflow-button and resizes it depending on the text. The
	 * maximum height is defined through the less-parameter and written to
	 * sap.ui.ux3.Shell.PANE_OVERFLOW_BUTTON_MAX_HEIGHT while the current height is saved in
	 * sap.ui.ux3.Shell.PANE_OVERFLOW_BUTTON_HEIGHT
	 *
	 * @returns {bool} Returns whether a change to the button height has been made.
	 */
	Shell.prototype._adaptOverflowButtonHeight = function() {
		var $Button = this.$("paneBarOverflowButton");
		var $ButtonWrapper = this.$("paneBarOverflowWrapper");
		var $ButtonText = this.$("paneBarOverflowText");
		var $PaneBar = this.$("paneBarRight");

		// Make the span small so it does not increase the button size without having content
		$ButtonText.css("width", "");


		var iOldHeight = Shell.PANE_OVERFLOW_BUTTON_HEIGHT;

		// We need the scroll_Width_ because the content of the button is rotated by 90°
		var iScrollWidth = $ButtonText[0].scrollWidth + /* buffer: */ 5;

		if (iScrollWidth > Shell.PANE_OVERFLOW_BUTTON_MAX_HEIGHT) {
			// Use the size specified in the theme as maximum width
			Shell.PANE_OVERFLOW_BUTTON_HEIGHT = Shell.PANE_OVERFLOW_BUTTON_MAX_HEIGHT;
		} else {
			// The button does not need the maximum amount of allowed space, give it whatever it needs
			Shell.PANE_OVERFLOW_BUTTON_HEIGHT = iScrollWidth;
		}

		$Button.css("height", Shell.PANE_OVERFLOW_BUTTON_HEIGHT);
		$ButtonWrapper.css("width", Shell.PANE_OVERFLOW_BUTTON_HEIGHT);
		// Make the span as large as the surrounding box again, so ellipsis works
		$ButtonText.css("width", "100%");
		// Make sure there is room for overflow menu button
		$PaneBar.css("padding-bottom", Shell.PANE_OVERFLOW_BUTTON_HEIGHT + "px");


		return (iOldHeight != Shell.PANE_OVERFLOW_BUTTON_HEIGHT);
	};

	/**
	 * Changes the overflow button from the standard text to the currently active overflowing
	 * item and back.
	 *
	 * @returns {bool} Returns whether a change to the button height has been made.
	 */
	Shell.prototype._changeOverflowButton = function() {
		// Only if this._sOpenPaneId is not null, an overflow item could be active
		// Whether the item is really in the overflow menu will be checked later by checking
		// its visible-property
		var oOverflowItem = null;
		if (this._sOpenPaneId) {
			oOverflowItem = sap.ui.getCore().byId(this._sOpenPaneId + "-overflow");
		}


		var sText = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON");
		var bSelected = false;
		if (oOverflowItem && oOverflowItem.getVisible()) {
			// This activation is from an overflow menu item: Change overflow button
			sText = oOverflowItem.getText();
			bSelected = true;
		}

		sText = sText.toUpperCase(); // TODO: This should be done in CSS, see also renderer

		var oButtonText = this.$("paneBarOverflowText");

		oButtonText.text(sText);
		oButtonText.attr("title", sText);
		oButtonText.toggleClass("sapUiUx3ShellPaneEntrySelected", bSelected);

		return this._adaptOverflowButtonHeight();
	};

	Shell.prototype._getPaneOverflowMenu = function() {
		return this.getAggregation("_paneOverflowMenu");
	};

	/**
	 * @returns an object defining the current focus in the Shell
	 */
	Shell.prototype.getFocusInfo = function() {
		try {
			var oElement = document.activeElement;
			return oElement ? {'sFocusId': oElement.id,'oFocusedElement': oElement} : {};
		} catch (ex) {
			// IE9 throws an Unspecified Error when accessing document.activeElement inside a frame before body.onload. This is not an issue, as there is just no focus yet to restore.
			return {};
		}
	};

	/**
	 * Restores focus according to the given oFocusInfo which has been acquired by calling Shell.getFocusInfo
	 * @param oFocusInfo
	 */
	Shell.prototype.applyFocusInfo = function(oFocusInfo) {
		var oElement = jQuery.sap.domById(oFocusInfo.sFocusId)
		|| oFocusInfo.oFocusedElement; // if not even an ID was available when focus was lost maybe the original DOM element is still there
		jQuery.sap.focus(oElement); // also works for oElement == null
	};


	/**
	 *
	 * @private
	 * @static
	 */
	Shell._updateToolIcon = function(oDomRef) {
		if (oDomRef && oDomRef.firstChild) {
			var $elem = jQuery(oDomRef);
			var toolId = oDomRef.id.substr(oDomRef.id.indexOf(Shell.TOOL_PREFIX) + 6);
			var tool = sap.ui.getCore().byId(toolId);
			var icon;
			if ($elem.is(".sapUiUx3ShellToolSelected")) {
				icon = tool.getIconSelected();
			} else if ($elem.is(".sapUiUx3ShellToolHover")) {
				icon = tool.getIconHover();
			} else {
				icon = tool.getIcon();
			}
			oDomRef.firstChild.src = icon;
		}
	};


	Shell.prototype.onclick = function(oEvent) {
		this.onUserActivation(oEvent);
	};
	Shell.prototype.onsapspace = function(oEvent) {
		this.onUserActivation(oEvent);
	};
	Shell.prototype.onsapenter = function(oEvent) {
		this.onUserActivation(oEvent);
	};

	Shell.prototype.onUserActivation = function(oEvent) {
		var sTargetId = oEvent.target.id;
		var parent = oEvent.target.parentNode;
		var sId = this.getId();

		if (oEvent.target.className
			&& oEvent.target.className.indexOf /* not available for SVG elements */
			&& oEvent.target.className.indexOf("sapUiUx3ShellHeader-logout") > -1) { // logout button clicked
			this.fireLogout();

		} else if (parent && parent.parentNode
			&& parent.parentNode.className
			&& parent.parentNode.className.indexOf /* not available for SVG elements */
			&& parent.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea") > -1) {  // tool item clicked
			this._handleToolItemClick(sTargetId);

		} else if (parent && parent.parentNode
			&& parent.parentNode.parentNode
			&& parent.parentNode.parentNode.className
			&& parent.parentNode.parentNode.className.indexOf /* not available for SVG elements */
			&& parent.parentNode.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea") > -1) {  // image in tool item clicked
			this._handleToolItemClick(parent.id);

		} else if (sTargetId === sId + "-paneBarOverflowText") {
			// Show/Hide overflow menu
			var oTarget = this.$("paneBarOverflowButton")[0];
			this._getPaneOverflowMenu().open(
				true,
				oTarget,
				(this._bRtl ? "left" : "right") + " bottom",
				"center center",
				oTarget
			);

		} else if (sTargetId) {
			if (parent && parent.className
				&& parent.className.indexOf /* not available for SVG elements */
				&& parent.className.indexOf("sapUiUx3ShellPaneEntries") > -1) {  // pane bar item clicked

				this._handlePaneBarItemClick(sTargetId);
			}
		}
	};


	/* ====== WORKSET ITEMS ====== */


	Shell.prototype._handleWorksetBarSelect = function(oEvent) {
		var bProcessSelection = this._handleWorksetItemClick(oEvent.getParameter("item"));
		if (!bProcessSelection) {
			oEvent.preventDefault();
		}
	};

	Shell.prototype._handleFacetBarSelect = function(oEvent) {
		var bProcessSelection = this._handleWorksetItemClick(oEvent.getParameter("item"));
		if (!bProcessSelection) {
			oEvent.preventDefault();
		}
	};


	Shell.prototype._handleWorksetItemClick = function(oElement) {
		var parent = oElement.getParent(),
		id = oElement.getId(),
		facetId = id,
		bProcessSelection = true;

		if (parent instanceof Shell) { // 1st-level
			if (id != this._sSelectedWorksetId) {   // it's actually a change

				var aSubItems = oElement.getSubItems();
				if (aSubItems.length > 0) {
					facetId = aSubItems[0].getId();
				}

				// tell the application what the user has done and give the chance to supply new/more/changed subitems
				bProcessSelection = this._fireWorksetItemSelected(facetId);
				if (bProcessSelection) {

					this._sSelectedWorksetId = id;
					if (aSubItems.length > 0) {
						this._sSelectedFacetId = aSubItems[0].getId();
						id = this._sSelectedFacetId; // the user clicked first-level, but if the first-level has children there must be one of them selected
					} else {
						this._sSelectedFacetId = null;
					}

					// if the application modifies/sets the selected subId, this should work, as long as this._sSelectedFacetId is updated

					// application has received the event and potentially modified the subitems
					var aSubItems = oElement.getSubItems();
					this._oFacetBar.setAssociatedItems(aSubItems, true); // exchange the items in the second-level navigation; force an "arrow flies in" animation

					var $FacetBar = this.$("facetBar");
					var iFacetBarHeight = this._calcFacetBarHeight($FacetBar);

					// hide/show the second-level navigation
					if (aSubItems.length > 0) {
						if (!this._oFacetBar.isSelectedItemValid()) {
							this._oFacetBar.setSelectedItem(aSubItems[0]);
							this._sSelectedFacetId = aSubItems[0].getId();
						}
						$FacetBar.slideDown();
						this._adaptContentHeight(null, true, iFacetBarHeight);
					} else {
						this._oFacetBar.setSelectedItem(null);
						$FacetBar.slideUp();
						this._adaptContentHeight(null, true, iFacetBarHeight);
					}
				}
			}

		} else {									 // 2nd-level - it is a sub-item
			if (id != this._sSelectedFacetId) { // it's actually a change
				bProcessSelection = this._fireWorksetItemSelected(facetId);
				if (bProcessSelection) {
					this._sSelectedFacetId = id;
				}
			}
		}
		return bProcessSelection;
	};


	Shell.prototype._fireWorksetItemSelected = function(sId) {
		var item = sap.ui.getCore().byId(sId);
		var key = (item ? item.getKey() : null);
		var bProcessSelection = this.fireWorksetItemSelected({id:sId,item:item,key:key});
		if (bProcessSelection) {
			this.setAssociation("selectedWorksetItem", sId, true); // update the internal and publicly available knowledge about which item is selected
		}
		return bProcessSelection;
	};





	/* ====== TOOL PALETTE ====== */

	Shell.prototype._closeCurrentToolPopup = function() {
		var sOpenToolId;
		if (this._oOpenToolPopup) {
			sOpenToolId = this._oOpenToolPopup.getId();
			jQuery.sap.byId(this.getId() + Shell.TOOL_PREFIX + this._oOpenToolPopup.getId()).removeClass("sapUiUx3ShellToolSelected").attr("aria-pressed", "false");
			if (sOpenToolId === this.getId() + "-feederTool") {
				var feeder = sap.ui.getCore().byId(this.getId() + "-feeder");
				feeder.setText("");
				feeder.rerender();
			}
			this._oOpenToolPopup.close();
			this._oOpenToolPopup = null;
		}
		return sOpenToolId;
	};

	Shell.prototype._handleToolItemClick = function(sId) {

		// close any previously open tool and remember ID of open tool, so it does not get opened again below
		var sAlreadyOpenId = this._closeCurrentToolPopup();

		// identify new tool
		var tool;
		var toolId = sId.substr(sId.indexOf(Shell.TOOL_PREFIX) + 6);
		if (toolId == (this.getId() + "-searchTool")) {
			tool = this._getSearchTool();
		} else if (toolId == (this.getId() + "-feederTool")) {
			tool = this._getFeederTool();
		} else  {
			// application tool clicked
			tool = sap.ui.getCore().byId(toolId);
		}

		// open the new tool
		if (tool && (tool.getId() != sAlreadyOpenId)) {
			this._oOpenToolPopup = tool;
			tool.setPosition(sap.ui.core.Popup.Dock.BeginTop, sap.ui.core.Popup.Dock.EndTop, jQuery.sap.domById(sId), "13 -6", "fit");
			tool.open();

			// mark icon as "tool opened"
			jQuery.sap.byId(sId).addClass("sapUiUx3ShellToolSelected").attr("aria-pressed", "true");
			Shell._updateToolIcon(jQuery.sap.domById(sId));

			// need to reset the icon also when the tool is closed by the application
			var that = this;
			var fnOnClosed = function(oEvent) {
				tool.detachClosed(fnOnClosed);

				if (that._oOpenToolPopup && that._oOpenToolPopup.getId() === oEvent.getParameter("id")) {
					//that._oOpenToolPopup = null;
					that._closeCurrentToolPopup();
				}

				jQuery.sap.byId(sId).removeClass("sapUiUx3ShellToolSelected");
				Shell._updateToolIcon(jQuery.sap.domById(sId));
			};
			tool.attachClosed(fnOnClosed);

		} else if (tool.getId() == sAlreadyOpenId) {
			Shell._updateToolIcon(jQuery.sap.domById(sId));
		}
	};


	/**
	 * Returns whether or not the design is dark, which means that for example the
	 * ToolPopup should be dark as well (inverted-property set to true), which in
	 * turn means that the popup content should be dark...
	 *
	 * @private
	 * @returns Boolean
	 */
	Shell.prototype._hasDarkDesign = function() {
		return (
			this.getDesignType() !== sap.ui.ux3.ShellDesignType.Light
			&& this.getDesignType() !== sap.ui.ux3.ShellDesignType.Crystal
		);
	};

	Shell.prototype._getSearchTool = function() {
		if (!this._oSearchPopup) {
			var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
			this._oSearchPopup = new sap.ui.ux3.ToolPopup(this.getId() + "-searchTool", {tooltip:rb.getText("SHELL_SEARCH")}).addStyleClass("sapUiUx3TP-search");

			// Create the popup in an inverted state if the shell is dark.
			// This will be changed when the design is changed: see setDesignType()
			var bInverted = this._hasDarkDesign();
			this._oSearchPopup.setInverted(bInverted);

			var that = this;
			var sf = new sap.ui.commons.SearchField(this.getId() + "-searchField", {
				enableListSuggest: false,
				search: function(oEvent) {
					that.fireSearch({text:oEvent.getParameter("query")});
				}
			});
			var label = new sap.ui.commons.Label({text:rb.getText("SHELL_SEARCH_LABEL") + ":"}).setLabelFor(sf);
			this._oSearchPopup.addContent(label).addContent(sf);
			this._oSearchPopup.attachOpen(function(){
				window.setTimeout(function(){sf.focus();},100);
			});
			this._oSearchField = sf;
		}
		return this._oSearchPopup;
	};


	/**
	 * Returns the SearchField control which is used in the Search Tool.
	 *
	 * @type sap.ui.commons.SearchField
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Shell.prototype.getSearchField = function() {
		if (!this._oSearchField) {
			this._getSearchTool();
		}
		return this._oSearchField;
	};

	Shell.prototype._getFeederTool = function() {
		if (!this._oFeederPopup) {
			var that = this;
			var rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
			this._oFeederPopup = new sap.ui.ux3.ToolPopup(this.getId() + "-feederTool", {tooltip:rb.getText("SHELL_FEEDER")}).addStyleClass("sapUiUx3TP-feeder");

			// Create the popup in an inverted state if the shell is dark.
			// This will be changed when the design is changed: see setDesignType()
			var bInverted = this._hasDarkDesign();
			this._oFeederPopup.setInverted(bInverted);

			var f = new sap.ui.ux3.Feeder(this.getId() + "-feeder", {type:sap.ui.ux3.FeederType.Medium,submit:function(oEvent){
				that.fireFeedSubmit({text:oEvent.getParameter("text")});
				f.setText("");
				f.rerender();
				that._oFeederPopup.close();
			}});
			this._oFeederPopup.setInitialFocus(this.getId() + "-feeder");
			this._oFeederPopup.attachClose(function(){
				// TODO: maybe the text should stay when closing?
				f.setText("");
			});
			this._oFeederPopup.addContent(f);
		}
		return this._oFeederPopup;
	};




	/* ====== PANE BAR ====== */



	/**
	 * Opens the side Pane.
	 *
	 * A valid ID of a paneBarItem must be given, so this item can be marked as selected. A "paneBarItemSelected" event is then fired as if the opening was triggered by the user by a click on the respective PaneBarItem.
	 * This method can be called (with different IDs) even when the Pane is already open. It has then the same effect as if the user switches between PaneBarItems.
	 *
	 * Returns 'this' to allow method chaining.
	 *
	 * @param {string} sPaneBarItemId
	 *         The ID of the PaneBarItem which should be marked as selected.
	 * @type sap.ui.ux3.Shell
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Shell.prototype.openPane = function(sPaneId) {
		var that = this;
		jQuery.sap.assert(typeof sPaneId === "string", "sPaneId must be given as string");
		var item = sap.ui.getCore().byId(sPaneId);
		if (item && (sPaneId != this._sOpenPaneId) && this.getShowPane()) {
			var key;
			if (item) {
				if (item.getKey() == "") {
					key = null;
				} else {
					key = item.getKey();
				}
			} else {
				key = null;
			}
			this.firePaneBarItemSelected({"id":sPaneId,"item":item,"key":key});

			var oPaneButton = jQuery.sap.byId(sPaneId);
			oPaneButton.siblings().removeClass("sapUiUx3ShellPaneEntrySelected");
			oPaneButton.addClass("sapUiUx3ShellPaneEntrySelected");

			if (!this._sOpenPaneId) {
				// pane area not open yet, open it
				this._openPane(function() {
					// Due to the display:none of the pane bar content in bluecrystal in combination
					// with the jQuery-animation, we need to wait until the pane bar content animation
					// is finished and thus the content focusable by jQuery.
					that.focusPaneStart();
				});
			} else {
				// pane area already open for a different pane bar item - unselect that one
				jQuery.sap.byId(this.getId() + "-pb_" + this._sOpenPaneId).removeClass("sapUiUx3ShellPaneEntrySelected");
			}

			this._sOpenPaneId = sPaneId;

		}
		return this;
	};


	/**
	 * Closes the side Pane (if open).
	 *
	 * Returns 'this' to allow method chaining.
	 *
	 * @type sap.ui.ux3.Shell
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Shell.prototype.closePane = function() {
		this._closePane();
		return this;
	};


	/**
	 * Returns 'true' if the side Pane is currently open.
	 *
	 * @type boolean
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Shell.prototype.isPaneOpen = function() {
		return (this._sOpenPaneId != null);
	};


	Shell.prototype._handlePaneBarItemClick = function(sPaneId) {
		if (sPaneId === this._sOpenPaneId) { // close currently opened pane area
			this.closePane();
		} else { // a pane needs to be displayed
			this.openPane(sPaneId);
		}

		this._checkPaneBarOverflow();
	};



	(function() {

		Shell._SHELL_OFFSET_RIGHT = 0;   // can be changed during runtime
	//	sap.ui.ux3.Shell._PANE_OUTER_DISTANCE = 40; //TODO: Theme Parameter?

		Shell.prototype._closePane = function(fCompleteCallback) {
			if (!this._sOpenPaneId) {
				if (fCompleteCallback) {
					fCompleteCallback();
				}

				// If the paneId is not set, it  means that there was no open pane, thus
				// the paneClosed-event (see below where the callback is called as well)
				// is not fired.
				return;
			}

			// Keep the pane-ID for use as a parameter to the paneClosed-event below
			var sOpenPaneId = this._sOpenPaneId;
			var that = this; // this-reference for closures below

			var id = this.getId();
			var dist = this.getShowPane() ? (jQuery.sap.byId(id + "-paneBarRight").outerWidth() + Shell._SHELL_OFFSET_RIGHT) : Shell._SHELL_OFFSET_RIGHT;
			var props = {};
			props[this._bRtl ? "left" : "right"] = dist + "px";
			var props2 = {};
			props2[this._bRtl ? "marginLeft" : "marginRight"] = (dist - Shell._SHELL_OFFSET_RIGHT) + "px";

			jQuery.sap.byId(id + "-content").css("overflow-x", "hidden");
			jQuery.sap.byId(id + "-canvas").stop().animate(props);
			jQuery.sap.byId(id + "-notify").stop().animate(props);
			this._getSyncRefs().stop(false, true).animate(props);
			jQuery.sap.byId(id + "-wBar").stop().animate(props2);
			jQuery.sap.byId(id + "-paneBar")
				.removeClass("sapUiUx3ShellPaneBarOpened")
				.addClass("sapUiUx3ShellPaneBarClose");
			jQuery.sap.byId(id + "-canvasBackground")
			.removeClass("sapUiUx3ShellCanvasBackgroundOpen")
			.addClass("sapUiUx3ShellCanvasBackgroundClosed")
			.stop().animate(props, function() {
				jQuery.sap.byId(id + "-paneBar").removeClass("sapUiUx3ShellPaneBarOpen");
				jQuery.sap.byId(id + "-content").css("overflow-x", "");
				if (fCompleteCallback) {
					fCompleteCallback();
				}

				// When pane closing is finished, the event paneClosed is fired with
				// the id of the closed pane in its parameter.
				that.firePaneClosed({ "id" : sOpenPaneId });
			});

			jQuery.sap.byId(this._sOpenPaneId).removeClass("sapUiUx3ShellPaneEntrySelected");
			this._sOpenPaneId = null;
		};

		Shell.prototype._openPane = function(fnOpenedCallback) {
			var id = this.getId();
			var PANE_WIDTH = this.getPaneWidth();
			var iPaneBarWidth = jQuery.sap.byId(id + "-paneBarRight").outerWidth();

			jQuery.sap.byId(id + "-content").css("overflow-x", "hidden");
			if (this._bRtl) {
				jQuery.sap.byId(id + "-paneBar")
					.removeClass("sapUiUx3ShellPaneBarClose")
					.addClass("sapUiUx3ShellPaneBarOpen");
				jQuery.sap.byId(id + "-wBar").stop().animate({marginLeft: (PANE_WIDTH + iPaneBarWidth) + "px"});
				jQuery.sap.byId(id + "-canvas").stop().animate({left: (PANE_WIDTH + iPaneBarWidth + Shell._SHELL_OFFSET_RIGHT) + "px"});
				jQuery.sap.byId(id + "-notify").stop().animate({left: (PANE_WIDTH + iPaneBarWidth + Shell._SHELL_OFFSET_RIGHT) + "px"});
				this._getSyncRefs().stop(false, true).animate({left: (PANE_WIDTH + iPaneBarWidth + Shell._SHELL_OFFSET_RIGHT) + "px"});
				jQuery.sap.byId(id + "-canvasBackground").stop().animate({left: (PANE_WIDTH + iPaneBarWidth + Shell._SHELL_OFFSET_RIGHT) + "px"}, function() {
					jQuery.sap.byId(id + "-content").css("overflow-x", "");
					jQuery.sap.byId(id + "-canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");
					jQuery.sap.byId(id + "-paneBar").addClass("sapUiUx3ShellPaneBarOpened");

					if (fnOpenedCallback) {
						fnOpenedCallback();
					}
				});
			} else {
				jQuery.sap.byId(id + "-paneBar")
					.removeClass("sapUiUx3ShellPaneBarClose")
					.addClass("sapUiUx3ShellPaneBarOpen");
				jQuery.sap.byId(id + "-wBar").stop().animate({marginRight: (PANE_WIDTH + iPaneBarWidth) + "px"});
				jQuery.sap.byId(id + "-canvas").stop().animate({right: (PANE_WIDTH + iPaneBarWidth + Shell._SHELL_OFFSET_RIGHT) + "px"});
				jQuery.sap.byId(id + "-notify").stop().animate({right: (PANE_WIDTH + iPaneBarWidth + Shell._SHELL_OFFSET_RIGHT) + "px"});
				this._getSyncRefs().stop(false, true).animate({right: (PANE_WIDTH + iPaneBarWidth + Shell._SHELL_OFFSET_RIGHT) + "px"});
				jQuery.sap.byId(id + "-canvasBackground").stop().animate({right: (PANE_WIDTH + iPaneBarWidth + Shell._SHELL_OFFSET_RIGHT) + "px"}, function() {
					jQuery.sap.byId(id + "-content").css("overflow-x", "");
					jQuery.sap.byId(id + "-canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");
					jQuery.sap.byId(id + "-paneBar").addClass("sapUiUx3ShellPaneBarOpened");

					if (fnOpenedCallback) {
						fnOpenedCallback();
					}
				});
			}
		};

		Shell.prototype.setPaneWidth = function (iWidth) {
			if (typeof iWidth == "number" && (iWidth > 0)) {
				iWidth = Math.max(iWidth, 50);

				// apply width
				if (this.getDomRef()) {
					var id = this.getId();
					jQuery.sap.byId(id + "-paneContent").css("width", iWidth + "px");
					jQuery.sap.byId(id + "-paneBar").css("width", (iWidth + Shell.SIDE_BAR_BASE_WIDTH) + "px");

					if (!!this._sOpenPaneId) { // pane area is open
						if (this._bRtl) {
							jQuery.sap.byId(id + "-wBar").css("marginLeft", (iWidth + Shell.SIDE_BAR_BASE_WIDTH) + "px");
							jQuery.sap.byId(id + "-canvas").css("left", (iWidth + Shell.SIDE_BAR_BASE_WIDTH + Shell._SHELL_OFFSET_RIGHT) + "px");
							jQuery.sap.byId(id + "-notify").css("left", (iWidth + Shell.SIDE_BAR_BASE_WIDTH + Shell._SHELL_OFFSET_RIGHT) + "px");
							this._getSyncRefs().css("left", (iWidth + Shell.SIDE_BAR_BASE_WIDTH + Shell._SHELL_OFFSET_RIGHT) + "px");
							jQuery.sap.byId(id + "-canvasBackground").css("left", (iWidth + Shell.SIDE_BAR_BASE_WIDTH + Shell._SHELL_OFFSET_RIGHT) + "px");
						} else {
							jQuery.sap.byId(id + "-wBar").css("marginRight", (iWidth + Shell.SIDE_BAR_BASE_WIDTH) + "px");
							jQuery.sap.byId(id + "-canvas").css("right", (iWidth + Shell.SIDE_BAR_BASE_WIDTH + Shell._SHELL_OFFSET_RIGHT) + "px");
							jQuery.sap.byId(id + "-notify").css("right", (iWidth + Shell.SIDE_BAR_BASE_WIDTH + Shell._SHELL_OFFSET_RIGHT) + "px");
							this._getSyncRefs().css("right", (iWidth + Shell.SIDE_BAR_BASE_WIDTH + Shell._SHELL_OFFSET_RIGHT) + "px");
							jQuery.sap.byId(id + "-canvasBackground").css("right", (iWidth + Shell.SIDE_BAR_BASE_WIDTH + Shell._SHELL_OFFSET_RIGHT) + "px");
						}
					}
				}

				this.setProperty("paneWidth", iWidth, true);
			}

			return this;
		};

		/**
		 * Moves the complete Shell away from the right window border by the given number of pixels (left border in RTL case).
		 *
		 * So there is space for a sidebar or so outside the Shell. The CSS class 'sapUiUx3ShellOuterSideBar' provides the basic position
		 * capabilities for the sidebar DOM element.
		 *
		 * This feature is not public. The usage is only granted to special groups on request.
		 *
		 * @param {int} px how many pixels of free space should be next to the Shell (between 0 and 600)
		 * @param {function} [complete] optional callback function to call after the animation
		 * @param {string} [outerId] optional id of the content representing the outside sidebar. If specified the width of the content is animated.
		 * @since 1.7.0
		 *
		 * @protected
		 */
		Shell.prototype.setOffsetRight = function(px, complete, outerId) {
			if (px < 0) {
				px = 0;
			}
			if (px > 600) {
				px = 600;
			}

			// adapt value used for animations
			Shell._SHELL_OFFSET_RIGHT = px;

			// adapt DOM elements
			var pxVal = px + "px";
			var id = this.getId();
			var animCnfg = this._bRtl ? {"left": pxVal} : {"right": pxVal};

			jQuery.sap.byId(id + "-hdr").stop().animate(animCnfg);
			jQuery.sap.byId(id + "-hdrImg").stop().animate(animCnfg);
			jQuery.sap.byId(id + "-bg").stop().animate(animCnfg, function() {
				if (complete) {
					complete();
				}
			});

			jQuery.sap.byId(id + "-bgImg").stop().animate(animCnfg);
			jQuery.sap.byId(id + "-wBar").stop().animate(animCnfg);
			jQuery.sap.byId(id + "-paneBar").stop().animate(animCnfg);
			jQuery.sap.byId(outerId).stop().animate({"width": pxVal});

			if (!this.$().hasClass("sapUiUx3ShellNoPane")) {
				pxVal = (px + (this._sOpenPaneId ? this.getPaneWidth() : 0) + Shell.SIDE_BAR_BASE_WIDTH) + "px";
			}

			animCnfg = this._bRtl ? {"left": pxVal} : {"right": pxVal};

			jQuery.sap.byId(id + "-notify").stop().animate(animCnfg);
			this._getSyncRefs().stop(false, true).animate(animCnfg);
			jQuery.sap.byId(id + "-canvas").stop().animate(animCnfg);
			jQuery.sap.byId(id + "-canvasBackground").stop().animate(animCnfg);
		};

		Shell.prototype._refreshCanvasOffsetRight = function(bPaneShown) {
			var id = this.getId();
			var right = this._bRtl ? "left" : "right";
			var pxVal = Shell._SHELL_OFFSET_RIGHT;
			if (bPaneShown) {
				var iPaneBarWidth = jQuery.sap.byId(id + "-paneBarRight").outerWidth();
				pxVal = pxVal + (this._sOpenPaneId ? this.getPaneWidth() : 0) + iPaneBarWidth;
			}
			pxVal = pxVal + "px";

			jQuery.sap.byId(id + "-notify").css(right, pxVal);
			jQuery.sap.byId(id + "-canvas").css(right, pxVal);
			jQuery.sap.byId(id + "-canvasBackground").css(right, pxVal);
			this._getSyncRefs().css(right, pxVal);
		};

		Shell.prototype._setNotifyVisibility = function(sVisibleStatus) {
			var oNotificationBar = this.getNotificationBar();
			if (!oNotificationBar) {
				return;
			}

			if (!sVisibleStatus) {
				sVisibleStatus = oNotificationBar.getVisibleStatus();
			}

			var $notify = this.$("notify");
			var $syncRef = this._topSyncRefId ? jQuery.sap.byId(this._topSyncRefId) : jQuery(null);
			var bIsThingInspector = $syncRef.hasClass("sapUiUx3TI");

			var iHeight = 0;
			var iBottom = 0;

			if (sVisibleStatus === sap.ui.ux3.NotificationBarStatus.Min) {
				iHeight = 10;
			} else if (sVisibleStatus === sap.ui.ux3.NotificationBarStatus.Max || sVisibleStatus === sap.ui.ux3.NotificationBarStatus.Default) {
				if (this.getHeaderType() === sap.ui.ux3.ShellHeaderType.BrandOnly && bIsThingInspector) {
					iHeight = parseInt(oNotificationBar.getHeightOfStatus(sap.ui.ux3.NotificationBarStatus.Default), 10);
				} else {
					iHeight = 10;
				}
				iBottom = iHeight;
			}

			$notify.removeClass("sapUiUx3ShellNotifyTI").removeClass("sapUiUx3ShellNotifyOverlay");

			if (this._topSyncRefId) {
				this._getSyncRefs().animate({"bottom" : iBottom + "px"}, "fast");
				//$syncRef.css("bottom", iBottom+"px");
				if (iBottom > 0) {
					$notify.addClass(bIsThingInspector ? "sapUiUx3ShellNotifyTI" : "sapUiUx3ShellNotifyOverlay");
				}
			}

			// TODO replace 100000 when there is something smart to handle the z-index centrally
			if (sVisibleStatus === sap.ui.ux3.NotificationBarStatus.Min) {
				// this enables the NotificationBar to be usable if it's minimized.
				// If there is a ComboBox in the content area the NotificationBar should
				// be behind the ComboBox if the NotificationBar is minimized. Otherwise
				// the NotificationBar must cover all content.
				$notify.css("height", iHeight + "px").css("z-index", 1);
			} else {
				$notify.css("height", iHeight + "px").css("z-index", 100000);
			}

			if (iHeight > 0 && !this.$().hasClass("sapUiUx3ShellNotifyVisible")) {
				this.$().addClass("sapUiUx3ShellNotifyVisible");
			} else if (iHeight == 0 && this.$().hasClass("sapUiUx3ShellNotifyVisible")) {
				this.$().removeClass("sapUiUx3ShellNotifyVisible");
			}

			this._adaptContentHeight(sVisibleStatus);
		};



		/**
		 * Used to hand a DomRef to the Shell which should always cover the canvas area and also be animated
		 * with PaneBar opening/closing.
		 *
		 * Only to be used internally (by the ThingInspector/OverlayContainer)! Marking as "private", but
		 * actually is "package" visibility.
		 * @private
		 */
		Shell.prototype.syncWithCanvasSize = function(sId, bInit, fFocusFirst, fFocusLast, fApplyChanges) {
			var idx = jQuery.inArray(sId, this._aSyncRefStack);

			//Update sync ref data structure
			if (bInit) {
				var oRef = {id: sId, focusFirst: fFocusFirst, focusLast: fFocusLast, applyChanges: fApplyChanges};
				if (idx < 0) {
					this._aSyncRefStack.push(sId);
				}
				this._mSyncRefs[sId] = oRef;
				//notify TI for property changes
				oRef.applyChanges({showOverlay: this.getHeaderType() !== sap.ui.ux3.ShellHeaderType.BrandOnly});
			} else {
				if (idx >= 0) {
					delete this._mSyncRefs[sId];
					this._aSyncRefStack.splice(idx, 1);
				}
			}

			//Cleanup Shell
			this.$("canvas").removeAttr("aria-hidden");
			this.$("focusDummyTPStart").removeAttr("tabindex").unbind("focusin");
			this.$("focusDummyTPEnd").removeAttr("tabindex").unbind("focusin");
			this.$("focusDummyHdrStart").removeAttr("tabindex").unbind("focusin");
			this.$("focusDummyHdrEnd").removeAttr("tabindex").unbind("focusin");
			this.$("focusDummyPane").removeAttr("tabindex").unbind("focusin");
			this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess", false);
			delete this._topSyncRefId;

			//Reinitialize Shell
			if (this._aSyncRefStack.length > 0) {
				var oRef = this._mSyncRefs[this._aSyncRefStack[this._aSyncRefStack.length - 1]];
				var $DomRefs = this._getSyncRefs();
				var oCanvas = this.getDomRef("canvas");
				$DomRefs.css(this._bRtl ? "right" : "left", (this.getShowTools() ? this.currentToolPaletteWidth : 0) + "px");
				var iRight = Shell._SHELL_OFFSET_RIGHT;
				if (this.getShowPane()) {
					iRight += Shell.SIDE_BAR_BASE_WIDTH;
					if (this._sOpenPaneId) {
						iRight += this.getPaneWidth();
					}
				}
				$DomRefs.css(this._bRtl ? "left" : "right", iRight + "px");
				$DomRefs.css("top", jQuery.sap.domById(this.getId() + (this.getAllowOverlayHeaderAccess() ? "-hdr" : "-hdrLine")).offsetHeight + "px");
				$DomRefs.css("bottom", "0");
				jQuery(oCanvas).attr("aria-hidden", "true");
				this.$("focusDummyTPEnd").attr("tabindex", "0").focusin(oRef.focusFirst);
				this.$("focusDummyHdrStart").attr("tabindex", "0").focusin(jQuery.proxy(this.focusPaneEnd, this));
				this.$("focusDummyHdrEnd").attr("tabindex", "0").focusin(jQuery.proxy(this.focusFirstTool, this));
				this.$("focusDummyTPStart").attr("tabindex", "0").focusin(jQuery.proxy(this.focusLastHdr, this));
				this.$("focusDummyPane").attr("tabindex", "0").focusin(oRef.focusLast);
				this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess", !this.getAllowOverlayHeaderAccess());
				this._topSyncRefId = oRef.id;
			}

			jQuery.sap.require("jquery.sap.script");
			if (this._sUpdateNotificationZIndex) {
				jQuery.sap.clearDelayedCall(this._sUpdateNotificationZIndex);
				delete this._sUpdateNotificationZIndex;
			}
			this._sUpdateNotificationZIndex = jQuery.sap.delayedCall(0, this, function(){
				delete this._sUpdateNotificationZIndex;
				this._setNotifyVisibility();

				if (this._oOpenToolPopup && this._topSyncRefId) {
					var $syncRef = jQuery.sap.byId(this._topSyncRefId);
					this._oOpenToolPopup.$().css("z-index", parseInt($syncRef.css("z-index"), 10) + 1);
				}
			});
		};

	}());

	/**
	 * Returns a jQuery object containing all registered "special cases" aka overlays (ThingInspector,
	 * etc.) that cover the canvas area, but not the panes. Whenever the canvas size is changes, all
	 * these have to be updated as well.
	 *
	 * @private
	 * @return {jQuery} $Refs A jQuery-object referencing all "overlaying" elements
	 */
	Shell.prototype._getSyncRefs = function(){
		var aRefs = [];
		var oRef;
		for (var i = 0; i < this._aSyncRefStack.length; i++) {
			oRef = jQuery.sap.domById(this._aSyncRefStack[i]);
			if (oRef) {
				aRefs.push(oRef);
			}
		}
		return jQuery(aRefs);
	};


	/**
	 * Focuses the first element in the Shell Header which is in the logical tab chain while the ThingInspector is open. This is either the first element in the header,
	 * or if there is no such element, it is the first tool.
	 *
	 * Only to be used internally (by the ThingInspector)! Marking as "private", but actually is "package" visibility.
	 * @private
	 */
	Shell.prototype.focusFirstHdr = function() {
		// tabbing forward into the page from the browser UI
		var oToFocus = this.$("hdr-items").firstFocusableDomRef();
		if (oToFocus && this.getAllowOverlayHeaderAccess() && this.getHeaderType() != sap.ui.ux3.ShellHeaderType.BrandOnly) {
			jQuery.sap.focus(oToFocus);
		} else {
			// otherwise focus the first tool
			this.focusFirstTool();
		}
	};

	/**
	 * Focuses the last element in the Shell Header which is in the logical tab chain while the ThingInspector is open. This is either the last element in the header,
	 * or if there is no such element, it is the last entry in the pane area.
	 *
	 * Only to be used internally (by the ThingInspector)! Marking as "private", but actually is "package" visibility.
	 * @private
	 */
	Shell.prototype.focusLastHdr = function() {
		// tabbing forward into the page from the browser UI
		var oToFocus = this.$("hdr-items").lastFocusableDomRef();
		if (oToFocus && this.getAllowOverlayHeaderAccess() && this.getHeaderType() != sap.ui.ux3.ShellHeaderType.BrandOnly) {
			jQuery.sap.focus(oToFocus);
		} else {
			// otherwise focus the last pane entry
			this.focusPaneEnd();
		}
	};

	/**
	 * Focuses the first element in the Shell which is in the logical tab chain while the ThingInspector is open. This is either the first Tool,
	 * or if there is no tool, it is the first item in the ThingInspector.
	 *
	 * Only to be used internally (by the ThingInspector)! Marking as "private", but actually is "package" visibility.
	 * @private
	 */
	Shell.prototype.focusFirstTool = function() {
		// tabbing forward into the page from the browser UI
		var $firstTool = this.$("tp").find(".sapUiUx3ShellTool").first();
		if ($firstTool.length && this.getShowTools()) {
			jQuery.sap.focus($firstTool[0]);
		} else {
			// otherwise focus the first item in the ThingInspector
			this._mSyncRefs[this._topSyncRefId].focusFirst();
		}
	};

	/**
	 * Focuses the last element in the tab chain which is logically BEFORE the ThingInspector
	 *
	 * Only to be used internally (by the ThingInspector)! Marking as "private", but actually is "package" visibility.
	 * @private
	 */
	Shell.prototype.focusLastTool = function() {
		// tabbing backward out of the ThingInspector
		var $lastTool = this.$("tp").find(".sapUiUx3ShellTool").last();
		if ($lastTool.length && this.getShowTools()) {
			jQuery.sap.focus($lastTool[0]);
		} else {
			// no tool present => jump to end of the Pane
			this.focusPaneEnd();
		}
	};

	/**
	 * Focuses the first element in the tab chain which is logically AFTER the ThingInspector
	 *
	 * Only to be used internally (by the ThingInspector)! Marking as "private", but actually is "package" visibility.
	 * @private
	 */
	Shell.prototype.focusPaneStart = function() {
		// tabbing forward, ThingInspector is being left
		var oToFocus = this.$("paneBar").firstFocusableDomRef();
		if (oToFocus) {
			jQuery.sap.focus(oToFocus);
		} else {
			// no focusable element in the pane => focus first tool
			this.focusFirstTool();
		}
	};

	/**
	 * Focuses the last element in the tab chain which belongs to the Shell Pane. This is also the "last" element of the Shell.
	 *
	 * @private
	 */
	Shell.prototype.focusPaneEnd = function() {
		// The ThingInspector tried to focus the last tool, but there was no tool. Or tools were being focused and we are tabbing backwards.
		var oToFocus = this.$("paneBar").lastFocusableDomRef();
		if (oToFocus) {
			jQuery.sap.focus(oToFocus);
		} else {
			// no focusable element in the pane, so focus the last element in the ThingInspector
			this._mSyncRefs[this._topSyncRefId].focusLast();
		}
	};


	//invalidation avoiding code

	Shell.prototype.setAppTitle = function(sAppTitle) {
		this.setProperty("appTitle", sAppTitle, true);
		this._rerenderHeader();
		return this;
	};

	Shell.prototype.setAppIcon = function(sAppIcon) {
		this.setProperty("appIcon", sAppIcon, true);
		this._rerenderHeader();
		return this;
	};

	Shell.prototype.setShowLogoutButton = function(bShowLogoutButton) {
		this.setProperty("showLogoutButton", bShowLogoutButton, true);
		this._rerenderHeader();
		return this;
	};

	Shell.prototype.setLogoutButtonTooltip = function(sTooltip) {
		this.setProperty("logoutButtonTooltip", sTooltip, true);
		this._rerenderHeader();
		return this;
	};

	Shell.prototype.insertHeaderItem = function(oHeaderItem, iIndex) {
		if (sap.ui.commons && sap.ui.commons.Button && (oHeaderItem instanceof sap.ui.commons.Button)) {
			oHeaderItem.setStyled(false);
		}
		this.insertAggregation("headerItems", oHeaderItem, iIndex, true);
		this._rerenderHeader();
		return this;
	};
	Shell.prototype.addHeaderItem = function(oHeaderItem) {
		if (sap.ui.commons && sap.ui.commons.Button && (oHeaderItem instanceof sap.ui.commons.Button)) {
			oHeaderItem.setStyled(false);
		}
		this.addAggregation("headerItems", oHeaderItem, true);
		this._rerenderHeader();
		return this;
	};
	Shell.prototype.removeHeaderItem = function(vIndex) {
		var result = this.removeAggregation("headerItems", vIndex, true);
		this._rerenderHeader();
		return result;
	};
	Shell.prototype.removeAllHeaderItems = function() {
		var result = this.removeAllAggregation("headerItems", true);
		this._rerenderHeader();
		return result;
	};
	Shell.prototype.destroyHeaderItems = function() {
		this.destroyAggregation("headerItems", true);
		this._rerenderHeader();
		return this;
	};


	Shell.prototype.setShowSearchTool = function(bShowSearchTool) {
		this.setProperty("showSearchTool", bShowSearchTool, true);
		this._rerenderToolPalette();
		return this;
	};

	Shell.prototype.setShowFeederTool = function(bShowFeederTool) {
		this.setProperty("showFeederTool", bShowFeederTool, true);
		this._rerenderToolPalette();
		return this;
	};

	Shell.prototype.setHeaderType = function(sHeaderType) {
		var sCurrentType = this.getHeaderType();
		this.setProperty("headerType", sHeaderType, true);
		this.$().removeClass("sapUiUx3ShellHead" + sCurrentType).addClass("sapUiUx3ShellHead" + this.getHeaderType());

		var $SyncRefs = this._getSyncRefs();
		if ($SyncRefs.length) {
			$SyncRefs.css("top", jQuery.sap.domById(this.getId() + (this.getAllowOverlayHeaderAccess() ? "-hdr" : "-hdrLine")).offsetHeight + "px");
		}

		//notify TI for changes
		var oChanges = {showOverlay: sHeaderType !== sap.ui.ux3.ShellHeaderType.BrandOnly};
		jQuery.each(this._mSyncRefs,function(sId,oRef) {
			oRef.applyChanges(oChanges);
		});
		return this;
	};

	Shell.prototype.setAllowOverlayHeaderAccess = function(bAllowOverlayHeaderAccess) {
		this.setProperty("allowOverlayHeaderAccess", bAllowOverlayHeaderAccess, true);

		var $SyncRefs = this._getSyncRefs();
		if ($SyncRefs.length) {
			this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess", !this.getAllowOverlayHeaderAccess());
			$SyncRefs.css("top", jQuery.sap.domById(this.getId() + (this.getAllowOverlayHeaderAccess() ? "-hdr" : "-hdrLine")).offsetHeight + "px");
		}

		return this;
	};

	Shell.prototype.setDesignType = function(sDesignType) {
		var sCurrentType = this.getDesignType();
		this.setProperty("designType", sDesignType, true);

		// Set inverted state of registered tool popups based on design
		var bInverted = this._hasDarkDesign();

		if (this._oSearchPopup) {
			// If it does not exist at this time, the inverted state will be set on
			// creation of the ToolPopup: see _getSearchTool()
			this._oSearchPopup.setInverted(bInverted);
		}
		if (this._oFeederPopup) {
			// If it does not exist at this time, the inverted state will be set on
			// creation of the ToolPopup: see _getFeederTool()
			this._oFeederPopup.setInverted(bInverted);
		}

		// Make sure that all registered ToolPopups have the correct inverted state
		var aToolPopups = this.getToolPopups();
		for (var i = 0; i < aToolPopups.length; ++i) {
			aToolPopups[i].setInverted(bInverted);
		}



		this.$()
		.removeClass("sapUiUx3ShellDesign" + sCurrentType)
		.addClass("sapUiUx3ShellDesign" + sDesignType)
		.toggleClass("sapUiUx3ShellDesignLight", !bInverted);

		return this;
	};

	Shell.prototype.setShowTools = function(bShowTools) {
		this.setProperty("showTools", bShowTools, true);
		if (bShowTools) {
			this.$().removeClass("sapUiUx3ShellNoTools");
			this._checkResize();
		} else {
			this.$().addClass("sapUiUx3ShellNoTools");
			this._closeCurrentToolPopup();
			// Remove custom styles for ToolPalette size
			this.$("tp").attr("style", "");
		}

		this._checkToolPaletteSize(true); // Also updates SyncRefs

		return this;
	};


	Shell.prototype.setShowPane = function(bShowPane) {
		this.setProperty("showPane", bShowPane, true);

		if (bShowPane) {
			this.$().removeClass("sapUiUx3ShellNoPane");
			this._refreshCanvasOffsetRight(true);
			this._checkPaneBarOverflow();
		} else {
			var that = this;
			this._closePane(function() {
				that._refreshCanvasOffsetRight(false);
				that.$().addClass("sapUiUx3ShellNoPane");
			});
		}


		return this;
	};

	Shell.prototype.insertToolPopup = function(oToolPopup, iIndex) {
		this.insertAggregation("toolPopups", oToolPopup, iIndex, true);
		oToolPopup.attachIconChanged(this._rerenderToolPalette, this);
		this._rerenderToolPalette();
		return this;
	};

	Shell.prototype.addToolPopup = function(oToolPopup) {
		// Set inverted state of registered tool popups based on design
		var bInverted = this._hasDarkDesign();
		oToolPopup.setInverted(bInverted);

		this.addAggregation("toolPopups", oToolPopup, true);
		oToolPopup.attachIconChanged(this._rerenderToolPalette, this);
		this._rerenderToolPalette();
		return this;
	};

	Shell.prototype.removeToolPopup = function(vIndex) {
		var result = this.removeAggregation("toolPopups", vIndex, true);
		if (result === this._oOpenToolPopup) {
			this._closeCurrentToolPopup();
		}
		this._rerenderToolPalette();
		return result;
	};
	Shell.prototype.removeAllToolPopups = function() {
		var result = this.removeAllAggregation("toolPopups", true);
		this._rerenderToolPalette();
		return result;
	};
	Shell.prototype.destroyToolPopups = function() {
		this.destroyAggregation("toolPopups", true);
		this._rerenderToolPalette();
		return this;
	};

	Shell.prototype.insertContent = function(oContent, iIndex) {
		this.insertAggregation("content", oContent, iIndex, true);
		this._rerenderContent();
		return this;
	};
	Shell.prototype.addContent = function(oContent) {
		this.addAggregation("content", oContent, true);
		this._rerenderContent();
		return this;
	};
	Shell.prototype.removeContent = function(vIndex) {
		var result = this.removeAggregation("content", vIndex, true);
		this._rerenderContent();
		return result;
	};
	Shell.prototype.removeAllContent = function() {
		var result = this.removeAllAggregation("content", true);
		this._rerenderContent();
		return result;
	};
	Shell.prototype.destroyContent = function() {
		this.destroyAggregation("content", true);
		this._rerenderContent();
		return this;
	};



	Shell.prototype.addPaneBarItem = function(oPaneBarItem) {
		this.addAggregation("paneBarItems", oPaneBarItem, true);
		this._rerenderPaneBarItems();
		return this;
	};
	Shell.prototype.insertPaneBarItem = function(oPaneBarItem, iIndex) {
		this.insertAggregation("paneBarItems", oPaneBarItem, iIndex, true);
		this._rerenderPaneBarItems();
		return this;
	};
	Shell.prototype.removePaneBarItem = function(vPaneBarItem) {
		var oResult = this.removeAggregation("paneBarItems", vPaneBarItem, true);

		// Remove the corresponding item in the overflow-menu (if it exists)
		if (oResult) {
			var oItem = sap.ui.getCore().byId(oResult.getId() + "-overflow");
			if (oItem) {
				oItem.destroy();
			}
		}

		this._rerenderPaneBarItems();
		return oResult;
	};
	Shell.prototype.removeAllPaneBarItems = function() {
		var result = this.removeAllAggregation("paneBarItems", true);

		// Overflowmenu-entries are not needed anymore
		this._getPaneOverflowMenu().destroyItems();

		this._rerenderPaneBarItems();
		return result;
	};
	Shell.prototype.destroyPaneBarItems = function() {
		this.destroyAggregation("paneBarItems", true);

		// Overflowmenu-entries are not needed anymore
		this._getPaneOverflowMenu().destroyItems();

		this._rerenderPaneBarItems();
		return this;
	};

	Shell.prototype.addWorksetItem = function(oWorksetItem) {
		this.addAggregation("worksetItems", oWorksetItem, true);
		this._rerenderWorksetItems();
		return this;
	};
	Shell.prototype.insertWorksetItem = function(oWorksetItem, iIndex) {
		this.insertAggregation("worksetItems", oWorksetItem, iIndex, true);
		this._rerenderWorksetItems();
		return this;
	};
	Shell.prototype.removeWorksetItem = function(vWorksetItem) {
		var result = this.removeAggregation("worksetItems", vWorksetItem, true);
		this._rerenderWorksetItems();
		return result;
	};
	Shell.prototype.removeAllWorksetItems = function() {
		var result = this.removeAllAggregation("worksetItems", true);
		this._rerenderWorksetItems();
		return result;
	};
	Shell.prototype.destroyWorksetItems = function() {
		this.destroyAggregation("worksetItems", true);
		this._rerenderWorksetItems();
		return this;
	};

	(function() {

		function clearNotificationBar(oShell) {
			var oOldNotificationBar = oShell.getNotificationBar();
			if (oOldNotificationBar) {
				oShell._setNotifyVisibility(sap.ui.ux3.NotificationBarStatus.None);
				oOldNotificationBar.setVisibleStatus = oOldNotificationBar.__orig_setVisibleStatus;
				oOldNotificationBar.detachDisplay(oOldNotificationBar.__fHandleNotifyDisplay);
				delete oOldNotificationBar.__orig_setVisibleStatus;
				delete oOldNotificationBar.__fHandleNotifyDisplay;
			}
		}

		/**
		 * This sets a NotificationBar to the Shell. If there is a NotificationBar
		 * attached already the old one will be removed. Additionally the Shell attaches
		 * itself to the NotificationBar's <code>display</code>-event.
		 *
		 * @param {object} oNotificationBar is the NotificationBar that should be
		 * attached to the Shell
		 * @return {object} this to enable chaining of setters and getters
		 */
		Shell.prototype.setNotificationBar = function(oNotificationBar) {
			clearNotificationBar(this);
			if (oNotificationBar) {
				var that = this;
				oNotificationBar.__orig_setVisibleStatus = oNotificationBar.setVisibleStatus;
				oNotificationBar.setVisibleStatus = function(sVisibleStatus){
					this.__orig_setVisibleStatus.apply(this, arguments);
					that._setNotifyVisibility();
				};
			}
			this.setAggregation("notificationBar", oNotificationBar, true);
			this._rerenderNotificationArea();
			if (oNotificationBar) {
				oNotificationBar.__fHandleNotifyDisplay = function(oEvent){
					var bShow = oEvent ? oEvent.getParameter("show") : oNotificationBar.hasItems();
					oNotificationBar.setVisibleStatus(bShow ? sap.ui.ux3.NotificationBarStatus.Default : sap.ui.ux3.NotificationBarStatus.None);
				};
				oNotificationBar.attachDisplay(oNotificationBar.__fHandleNotifyDisplay);
				oNotificationBar.__fHandleNotifyDisplay();
			}
			return this;
		};

		Shell.prototype.destroyNotificationBar = function() {
			clearNotificationBar(this);
			this.destroyAggregation("notificationBar", true);
			this._rerenderNotificationArea();
			return this;
		};

	}());

	Shell.prototype._rerenderNotificationArea = function() {
		var $notify = this.$("notify");
		if ($notify.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			sap.ui.ux3.ShellRenderer.renderNotificationArea(rm, this);
			rm.flush($notify[0], true);
			rm.destroy();
		}
	};

	Shell.prototype._rerenderHeader = function() {
		var $hdr = this.$("hdr");
		if ($hdr.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			sap.ui.ux3.ShellRenderer.renderHeader(rm, this);
			rm.flush($hdr[0], true);
			rm.destroy();
		}
	};

	Shell.prototype._rerenderToolPalette = function() {
		var $tp = this.$("tp");
		if ($tp.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			this._beforeRenderingToolPalette();
			sap.ui.ux3.ShellRenderer.renderToolPalette(rm, this);
			rm.flush($tp[0], true);
			this._afterRenderingToolPalette();
			rm.destroy();

			this._checkResize();
		}
	};

	Shell.prototype._beforeRenderingToolPalette = function() {
		// unbind the tool palette mouse (hover effect) handlers
		this.$("tp").find(".sapUiUx3ShellTool").unbind("mouseenter mouseleave");

		this.$("focusDummyTPEnd").unbind("focusin");
		this.$("focusDummyTPStart").unbind("focusin");
	};

	Shell.prototype._afterRenderingToolPalette = function() {
		// register hover effect handlers for application-provided tool icons
		var sIdPrefix = this.getId() + Shell.TOOL_PREFIX;
		var aToolItems = this.getToolPopups();

		var bValidOpenTool = false;
		if (this._oOpenToolPopup && this._oOpenToolPopup.isOpen() && (this.indexOfToolPopup(this._oOpenToolPopup) >= 0 || this._oOpenToolPopup === this._oSearchPopup || this._oOpenToolPopup === this._oFeederPopup)) {
			this._oOpenToolPopup.setPosition(sap.ui.core.Popup.Dock.BeginTop, sap.ui.core.Popup.Dock.EndTop, jQuery.sap.domById(sIdPrefix + this._oOpenToolPopup.getId()), "13 -6", "fit");
			var oPopupTool = jQuery.sap.domById(sIdPrefix + this._oOpenToolPopup.getId());
			jQuery(oPopupTool).toggleClass("sapUiUx3ShellToolSelected", true);
			Shell._updateToolIcon(oPopupTool);
			bValidOpenTool = true;
		}

		if (!bValidOpenTool && this._oOpenToolPopup) {
			this._closeCurrentToolPopup();
		}

		for (var i = 0; i < aToolItems.length; i++) {
			var oToolItem = aToolItems[i];
			if (oToolItem instanceof sap.ui.ux3.ToolPopup) {	// regular item
				jQuery.sap.byId(sIdPrefix + oToolItem.getId()).hover(
					/*eslint-disable no-loop-func */
					function(evt) {
						jQuery(this).toggleClass("sapUiUx3ShellToolHover", (evt.type === "mouseenter")); // set/remove class depending on mouseenter/mouseleave
						Shell._updateToolIcon(this);
					}
					/*eslint-enable no-loop-func */
				);
			}
		}

		if (this._topSyncRefId && this._mSyncRefs[this._topSyncRefId].focusFirst) {
			this.$("focusDummyTPEnd").attr("tabindex", "0").focusin(this._mSyncRefs[this._topSyncRefId].focusFirst);
		}
		if (this._aSyncRefStack.length > 0) {
			this.$("focusDummyTPStart").attr("tabindex", "0").focusin(jQuery.proxy(this.focusLastHdr, this));
		}
	};

	Shell.prototype._rerenderContent = function(bPreventPreserve) {
		var $content = this.$("content");
		if ($content.length > 0) {
			var aContent = this.getContent(),
			rm = sap.ui.getCore().createRenderManager();
			for (var i = 0; i < aContent.length; i++) {
				rm.renderControl(aContent[i]);
			}
			rm.flush($content[0], bPreventPreserve);
			rm.destroy();
		}
	};

	Shell.prototype._rerenderPane = function(bPreventPreserve) {
		var $paneContent = this.$("paneContent");
		if ($paneContent.length > 0) {
			var aPaneContent = this.getPaneContent(),
			rm = sap.ui.getCore().createRenderManager();
			for (var i = 0; i < aPaneContent.length; i++) {
				rm.renderControl(aPaneContent[i]);
			}
			rm.flush($paneContent[0], bPreventPreserve);
			rm.destroy();
		}
	};

	Shell.prototype._rerenderPaneBarItems = function() {
		var $PaneListRef = this.$("paneBar").find(".sapUiUx3ShellPaneEntries");

		if ($PaneListRef.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			sap.ui.ux3.ShellRenderer.renderPaneBarItems(rm, this);
			rm.flush($PaneListRef[0]);
			rm.destroy();

			this._updatePaneBarItemNavigation($PaneListRef);
		}

		// Create overflow menu
		var that = this;
		var oMenu = this._getPaneOverflowMenu();
		var aPaneBarItems = this.getPaneBarItems();

		var fnOnItemSelect = function(oEvent) {
			// Emulate an event-object to "trick" the Shell into believing a real panel
			// item was selected
			var mPseudoEvent = {
				overflowItem : oEvent.getParameter("item"),
				target : {
					id : oEvent.getParameter("id").replace(/-overflow$/, ""),
					parentNode : {
						className : "sapUiUx3ShellPaneEntries"
					}
				}
			};

			that.onUserActivation(mPseudoEvent);
		};

		for (var i = 0; i < aPaneBarItems.length; ++i) {
			var sItemId = aPaneBarItems[i].getId() + "-overflow";
			var oItem = sap.ui.getCore().byId(sItemId);

			if (!oItem) {
				var oOverflowItem = new sap.ui.commons.MenuItem(sItemId, {
					text : aPaneBarItems[i].getText(),
					visible : false,
					select : fnOnItemSelect
				});

				oMenu.addItem(oOverflowItem);
			}
		}

		this._checkPaneBarOverflow($PaneListRef);
	};

	Shell.prototype._rerenderWorksetItems = function() {
		if (this.$("wBar").length > 0) {
			sap.ui.ux3.ShellRenderer.renderWorksetItems(null, this);
			sap.ui.ux3.ShellRenderer.renderFacetBar(null, this);
			var items = this._oFacetBar.getAssociatedItems();
			this._oFacetBar.$().css("display", (items && items.length > 0 ? "block" : "none"));
			this._adaptContentHeight();
		}
	};



	/* DEBUG code for tracking invalidation */

	/**
	 * Forces invalidation and rerendering (.invalidate() is disabled)
	 * @private
	 */
	Shell.prototype.forceInvalidation = Control.prototype.invalidate;

	/**
	 * Hack that prevents Shell invalidation by default.
	 * Later, invalidation should return to normal, but be prevented in all typical cases by bSuppressRerendering with explicit change handling.
	 *
	 * @private
	 */
	Shell.prototype.invalidate = function(oSource) {

		/* if (oSource == this) {
			// does not happen because the source is only given when propagating to a parent

		} else */ if (!oSource) {
			// direct invalidation of the Shell; this means a property has been modified
			this.forceInvalidation(); // let invalidation occur

		} else if (oSource instanceof sap.ui.ux3.NavigationItem) {
			// a workset item was changed/renamed or, more likely, subitems were added/exchanged
			if (this._oWorksetBar && this._oFacetBar) { // if already destroyed no update
				this._oWorksetBar.setAssociatedItems(this.getWorksetItems());
				var wsi = this.getSelectedWorksetItem();
				if (wsi) {
					var items;
					var sel = sap.ui.getCore().byId(wsi);
					if (sel && sel.getParent() instanceof sap.ui.ux3.NavigationItem) { // second-level item is selected
						this._oFacetBar.setAssociatedItems(sel.getParent().getSubItems()); // update the second-level NavigationBar as well
					} else if (sel && (items = sel.getSubItems())) {                            // toplevel item is selected and has children
						if (items && (items.length > 0)) {
							this._oFacetBar.setAssociatedItems(items); // update the second-level NavigationBar as well
						}
					} /* else {
						// toplevel item with no children, TODO: removing/adding the only child may be interesting to look at
					} */

					items = this._oFacetBar.getAssociatedItems();
					this._oFacetBar.$().css("display", (items && items.length > 0 ? "block" : "none"));
					this._adaptContentHeight();
				}
			}

		} else if ((oSource instanceof sap.ui.core.Item) && (oSource.getParent() == this)) {
			// a PaneBarItem was changed/added/removed
			this.forceInvalidation();

		} else if (oSource instanceof sap.ui.ux3.ToolPopup) {
			// This is needed for changes due to databinding. When the model changes for example the
			// tooltip, the Shell's invalidate function is called.
			this._rerenderToolPalette();

		} else if (this.indexOfHeaderItem(oSource) >= 0) {
			// a header item was invalidated - rerender the header
			this._rerenderHeader();

		} /* else {
			// a child was invalidated - TODO: check what kind of child and either handle directly or re-render
		} */
	};


	Shell.prototype._setParent = Control.prototype.setParent;
	Shell.prototype.setParent = function(oParent, sAggregationName, bSuppressRerendering) {
		this._setParent(oParent, sAggregationName, bSuppressRerendering);
		this.forceInvalidation(); // TODO: temporary hack to force invalidation when the Shell is added to a UiArea
	};


	/*  METHODS  */


	/**
	 * Replaces the existing Shell content with the given Control(-Tree). Only leads to a re-rendering of the content area (not the complete Shell).
	 * This method may be more convenient than a series of calls to "removeContent" and "addContent", which each lead to a re-rendering of the content area (but again not of the complete Shell).
	 *
	 * By default the old content is not destroyed and is returned by this method in an array for further usage. To avoid memory leaks, the old content should be destroyed (if not needed later), by setting the "destroyOldContent" flag or by destroying it manually later on. If "destroyOldContent" is set, an empty array is returned.
	 *
	 * @param {sap.ui.core.Control} oContent
	 *         The new Content. In this method it must be exactly one control (-tree). Use addContent() to add more control (-trees) to the main content area of the Shell.
	 * @param {boolean} bDestroyOldContent
	 *         If set, the controls previously contained in the Shell will be destroyed, to avoid memory leaks.
	 * @type sap.ui.core.Control[]
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Shell.prototype.setContent = function(vContent, bDestruct) {
		jQuery.sap.assert(vContent === null
			|| (vContent instanceof Control)
			|| ((jQuery.isArray(vContent) && ((vContent.length > 0) ? (vContent[0] instanceof Control) : true))),
			"vContent must be a control or array of controls or null"); // only the first array element is checked
		jQuery.sap.assert((bDestruct === undefined || bDestruct === true || bDestruct === false), "bDestruct must be true, false, or undefined");

		var oldContent = [];
		var $content = this.$("content");
		var bPreventPreserve = false;

		if (!bDestruct) {
			oldContent = this.removeAllAggregation("content", true);

			if ($content.length > 0) {
				sap.ui.core.RenderManager.preserveContent($content[0]);
				bPreventPreserve = true;
				$content.empty();
			}
		} else {
			this.destroyAggregation("content", true);
		}

		// add new control(s) to aggregation
		if (vContent instanceof Control) { // one single control
			this.addAggregation("content", vContent, true);
		} else if (vContent && typeof (vContent) == "object" && vContent.length) { // an array of (hopefully) controls
			for (var i = 0; i < vContent.length; i++) {
				this.addAggregation("content", vContent[i], true);
			}
		}

		// if Shell is already rendered, update the UI
		this._rerenderContent(bPreventPreserve);

		return oldContent;
	};



	/**
	 * Replaces the existing side pane content with the given Control(-Tree). This method is optimized to only re-render the pane content (and not the shell) which is faster and smoother than any other way of changing the "paneContent" aggregation.
	 *
	 * By default, the old pane content is not destroyed and is returned by this method in an array for further usage. To avoid memory leaks, the old content should be destroyed (if not needed later), by setting the "destroyOldContent" flag or by destroying it manually later on. If "destroyOldContent" is set, an empty array is returned.
	 *
	 * @param {sap.ui.core.Control} oContent
	 *         The new Pane content. In this method it must be exactly one control (-tree). This could likely be a layout or a specific ux3 Pane control. Use addPaneContent() to add more control (-trees) to the Pane.
	 * @param {boolean} bDestroyOldContent
	 *         If set, the controls previously contained in the pane will be destroyed, to avoid memory leaks.
	 * @type sap.ui.core.Control[]
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Shell.prototype.setPaneContent = function(vContent, bDestruct) {
		jQuery.sap.assert((vContent instanceof Control)
			|| ((jQuery.isArray(vContent) && ((vContent.length > 0) ? (vContent[0] instanceof Control) : true))),
			"vContent must be a control or array of controls"); // only the first array element is checked
		jQuery.sap.assert((bDestruct === undefined || bDestruct === true || bDestruct === false), "bDestruct must be true, false, or undefined");

		var oldContent = [];
		var $paneContent = this.$("paneContent");
		var bPreventPreserve = false;

		if (!bDestruct) {
			oldContent = this.removeAllAggregation("paneContent", true);

			if ($paneContent.length > 0) {
				sap.ui.core.RenderManager.preserveContent($paneContent[0]);
				bPreventPreserve = true; // HTML content is already preserved; do not do it again in the RenderManager
				$paneContent.empty();
			}
		} else {
			this.destroyAggregation("paneContent", true);
		}

		// add new control(s) to aggregation
		if (vContent instanceof Control) { // one single control
			this.addAggregation("paneContent", vContent, true);
		} else if (vContent && typeof (vContent) == "object" && vContent.length) { // an array of (hopefully) controls
			for (var i = 0; i < vContent.length; i++) {
				this.addAggregation("paneContent", vContent[i], true);
			}
		}

		// if Shell is already rendered, update the UI
		this._rerenderPane(bPreventPreserve);

		return oldContent;
	};



	Shell.prototype.getSelectedWorksetItem = function() {
		/* Initially, this is null
		 * There is a value as soon as:
		 * 1. The application sets a value
		 * 2. The Shell is rendered without a value (the first toplevel item will be used then (respectively its first child, if present))
		 */
		return this.getAssociation("selectedWorksetItem");
	};

	Shell.prototype.setSelectedWorksetItem = function(selectedWorksetItem) {
		var oldSelectedId = this.getSelectedWorksetItem();
		this.setAssociation("selectedWorksetItem", selectedWorksetItem, true);
		var newSelectedId = this.getSelectedWorksetItem();

		if (oldSelectedId != newSelectedId) { // only do something if selected item really changed
			var newSelectedItem = sap.ui.getCore().byId(newSelectedId);

			if (newSelectedItem) {

				this._sSelectedWorksetId = newSelectedId;
				this._sSelectedFacetId = null;

				var sub = newSelectedItem.getSubItems();
				if (sub.length > 0) { // app set a parent item that has children, so select automatically the first child
					newSelectedItem = sub[0];
				}

				if (newSelectedItem && (newSelectedItem.getParent() instanceof sap.ui.ux3.NavigationItem)) { // if selected item is sub-item
					var newParentItem = newSelectedItem.getParent();
					this._sSelectedWorksetId = newParentItem.getId();
					this._sSelectedFacetId = newSelectedItem.getId();

					this._oWorksetBar.setSelectedItem(newParentItem);
					this._oFacetBar.setAssociatedItems(newParentItem.getSubItems());
					this._oFacetBar.setSelectedItem(newSelectedItem);

					if (this.getDomRef()) {
						var $FacetBar = this.$("facetBar");
						var iFacetBarHeight = this._calcFacetBarHeight($FacetBar);
						$FacetBar.slideDown();
						this._adaptContentHeight(null, true, iFacetBarHeight);
					}

				} else if (newSelectedItem) {
					this._oWorksetBar.setSelectedItem(newSelectedItem);
					this._oFacetBar.setAssociatedItems([]);
					this._oFacetBar.setSelectedItem(null);

					if (this.getDomRef()) {
						var $FacetBar = this.$("facetBar");
						var iFacetBarHeight = this._calcFacetBarHeight($FacetBar);
						$FacetBar.slideUp();
						this._adaptContentHeight(null, true, iFacetBarHeight);
					}

				} /* else {
					// newSelectedItem == null  after selecting the child
				} */
			} else {
				// newSelectedItem == null
				throw new Error("WorksetItem with ID " + newSelectedId + " cannot be found.");
			}
		}

		return this;
	};


	/* FullHeight / ContentPadding */

	Shell.prototype.setApplyContentPadding = function(bApplyContentPadding) {
		this.setProperty("applyContentPadding", bApplyContentPadding, true); // no re-rendering
		this.$().toggleClass("sapUiUx3ShellNoContentPadding", !bApplyContentPadding);
		this._adaptContentHeight();
	};

	Shell.prototype.setFullHeightContent = function(bFullHeightContent) {
		this.setProperty("fullHeightContent", bFullHeightContent, true); // no re-rendering
		this.$().toggleClass("sapUiUx3ShellFullHeightContent", bFullHeightContent);
		this._adaptContentHeight();
	};

	Shell.prototype._calcFacetBarHeight = function($FacetBar){
		if (this._iFacetBarHeight === undefined) {
			this._iFacetBarHeight = 0;
		}

		if (!$FacetBar) {
			$FacetBar = this.$("facetBar");
		}
		if ($FacetBar.length > 0) {
			var h = this.$("facetBar").outerHeight(true);
			this._iFacetBarHeight = Math.max(this._iFacetBarHeight, h);
		}

		return this._iFacetBarHeight;
	};

	Shell.prototype._adaptContentHeight = function(sNotificationBarVisibleStatus, bAnimate, iFacetBarHeight) {
		if (!this.getDomRef()) {
			return;
		}

		var $content = this.$("content");
		var $canvas = this.$("canvas");

		if (this.getFullHeightContent()) {
			var bPad = this.getApplyContentPadding();
			var iTop = !bPad ? 0 : parseInt($canvas.css("paddingTop"), 10);
			var iLeft = !bPad ? 0 : parseInt($canvas.css("paddingLeft"), 10);
			var iRight = !bPad ? 0 : parseInt($canvas.css("paddingRight"), 10);

			var _iFacetBarHeight = iFacetBarHeight ? iFacetBarHeight : this._calcFacetBarHeight();

			var sTop = (iTop + (this._oFacetBar.getAssociatedItems().length > 0 ? _iFacetBarHeight : 0)) + "px";

			if (bAnimate) {
				$content.stop().animate({top: sTop});
			} else {
				$content.stop().css("top", sTop);
			}

			var oNotify = this.getNotificationBar();
			if (oNotify && !sNotificationBarVisibleStatus) {
				sNotificationBarVisibleStatus = oNotify.getVisibleStatus();
			}

			if (sNotificationBarVisibleStatus === sap.ui.ux3.NotificationBarStatus.Default
				|| sNotificationBarVisibleStatus === sap.ui.ux3.NotificationBarStatus.Max) {
				$content.css("bottom", oNotify.getHeightOfStatus(sap.ui.ux3.NotificationBarStatus.Default));
			} else {
				var iBottom = !bPad ? 0 : parseInt($canvas.css("paddingBottom"), 10);
				if (oNotify && sNotificationBarVisibleStatus === sap.ui.ux3.NotificationBarStatus.Min) {
					iBottom += sap.ui.ux3.NotificationBar.HOVER_ITEM_HEIGHT;
				}
				$content.css("bottom", iBottom + "px");
			}

			$content.css(this._bRtl ? "right" : "left", iLeft + "px");
			$content.css(this._bRtl ? "left" : "right", iRight + "px");
		} else {
			$content.removeAttr("style");
		}

		if (!!sap.ui.Device.browser.webkit) {
			//Force Webkit Browsers to do a repaint
			sap.ui.core.RenderManager.forceRepaint(this.getId() + "-canvas");
		}
	};


	/* Drag&Drop personalization */

	Shell.prototype._handleDragover = function(evt) {
		var id = evt.target.id;
		if (!this._dragOverBlinking) {
			var $bg = jQuery.sap.byId(id);
			$bg.css("opacity", "0.5");
			this._dragOverBlinking = true;
			var that = this;
			window.setTimeout(function(){
				$bg.css("opacity", "1");
				window.setTimeout(function(){
					that._dragOverBlinking = null;
				}, 300);
			}, 300);
		}
		return false;
	};
	Shell.prototype._handleDragend = function(evt) {
		return false;
	};
	Shell.prototype._handleDrop = function(evt) {
		var id = evt.target.id;
		evt.preventDefault();
		var e = evt.originalEvent;
		var file = e.dataTransfer.files[0];
		if (file) {
			// read file content
			var reader = new window.FileReader();
			reader.onload = jQuery.proxy(function(event) {
				var dataUrl = event.target.result;
				if (id == this.getId() + "-bgImg") {
					this._getPersonalization()._handleBackgroundImageChange(dataUrl, true);
				} else if (id == this.getId() + "-hdr") {
					this._getPersonalization()._handleHeaderImageChange(dataUrl, true);
				} else if (id == this.getId() + "-logoImg") {
					this._getPersonalization()._handleLogoImageChange(dataUrl, true);
				}
				reader = null;
			}, this);
			reader.readAsDataURL(file);
		}
	};



	Shell.prototype._getPersonalization = function() {
		if (!this.oPersonalization) {
			jQuery.sap.require("sap.ui.ux3.ShellPersonalization");
			this.oPersonalization = new sap.ui.ux3.ShellPersonalization(this);
		}
		return this.oPersonalization;
	};


	/**
	 * Experimental method! Do not use!
	 *
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Shell.prototype.openPersonalizationDialog = function() {
		this._getPersonalization().openDialog();
	};


	/**
	 * Experimental method! Do not use!
	 *
	 * Makes Shell personalization available and injects the given personalization settings. This should be called before the user can do any adaptations per drag&drop or using the personalization dialog. Otherwise it may override the user's new settings.
	 *
	 * @param {object} oSettings
	 *         Personalization settings object
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Shell.prototype.initializePersonalization = function(oSettings) {
		this._getPersonalization().initializeSettings(oSettings);
	};

	Shell.prototype.onThemeChanged = function(oEvent) {
		this._iFacetBarHeight = undefined;

		if (!this.getDomRef()) {
			// If there is no DOM-element, we cant do anything - onAfterRendering will be called later.
			return;
		}

		var sImage = "";
		// if already rendered update images
		if (!this.getAppIcon()) {
			sImage = Parameters._getThemeImage('sapUiUx3ShellApplicationImageURL', true);
			this.$("logoImg").attr('src', sImage);
		}

		sImage = Parameters._getThemeImage('sapUiUx3ShellHeaderImageURL', true);
		this.$("hdrImg").attr('src', sImage);

		sImage = Parameters._getThemeImage('sapUiUx3ShellBackgroundImageURL', true);
		this.$("bgImg").attr('src', sImage);

		this.$("facetBar").stop(true, true); //Stop potentially running animations
		this._adaptContentHeight();

		this._updateThemeVariables();

		this._checkResize();
	};


	return Shell;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/Shell.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ThingAction') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ThingAction.
jQuery.sap.declare('sap.ui.ux3.ThingAction'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ThingAction",['jquery.sap.global', 'sap/ui/core/Element', './library'],
	function(jQuery, Element) {
	"use strict";



	/**
	 * Constructor for a new ThingAction.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Thing Action for Swatch, QuickView, Thinginspector
	 * @extends sap.ui.core.Element
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.ThingAction
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ThingAction = Element.extend("sap.ui.ux3.ThingAction", /** @lends sap.ui.ux3.ThingAction.prototype */ { metadata : {

		library : "sap.ui.ux3",
		properties : {

			/**
			 * text of action
			 */
			text : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * action enabled (true/false)
			 */
			enabled : {type : "boolean", group : "Misc", defaultValue : true}
		},
		events : {

			/**
			 * Event will be fired when the action was triggered.
			 */
			select : {
				parameters : {

					/**
					 * Id of selected action
					 */
					id : {type : "string"},

					/**
					 * Selected Thing Action
					 */
					action : {type : "sap.ui.ux3.ThingAction"}
				}
			}
		}
	}});

	ThingAction.prototype.onclick = function(oEvent) {
		this.fireSelect({
			id : this.getId(),
			action: this
		});
	};
	ThingAction.prototype.onsapselect = function(oEvent) {
		this.fireSelect({
			id : this.getId(),
			action: this
		});
	};

	return ThingAction;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ThingAction.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ThingGroup') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ThingGroup.
jQuery.sap.declare('sap.ui.ux3.ThingGroup'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ThingGroup",['jquery.sap.global', 'sap/ui/core/Element', './library'],
	function(jQuery, Element) {
	"use strict";



	/**
	 * Constructor for a new ThingGroup.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Thing Group Area
	 * @extends sap.ui.core.Element
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.ThingGroup
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ThingGroup = Element.extend("sap.ui.ux3.ThingGroup", /** @lends sap.ui.ux3.ThingGroup.prototype */ { metadata : {

		library : "sap.ui.ux3",
		properties : {

			/**
			 * Title of Group
			 */
			title : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * If Group is used in a column layout the groups spans the all columns if set to true.
			 */
			colspan : {type : "boolean", group : "Misc", defaultValue : false}
		},
		defaultAggregation : "content",
		aggregations : {

			/**
			 * Content of Group
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"},

			/**
			 * Actions of the groups content
			 */
			actions : {type : "sap.ui.ux3.ThingGroup", multiple : true, singularName : "action"}
		}
	}});

	return ThingGroup;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ThingGroup.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ThingViewer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ThingViewer.
jQuery.sap.declare('sap.ui.ux3.ThingViewer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ThingViewer",['jquery.sap.global', 'sap/ui/core/Control', './library'],
	function(jQuery, Control) {
	"use strict";



	/**
	 * Constructor for a new ThingViewer.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * ThingViewer: Same as ThingInspector but decoupled from the Overlay and the ActionBar.
	 * The control can be added to a Parent container that has a defined width. The ThingViewer fill the whole container. If the parent container has no width defined the control will not work properly.
	 * @extends sap.ui.core.Control
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @since 1.9.1
	 * @alias sap.ui.ux3.ThingViewer
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ThingViewer = Control.extend("sap.ui.ux3.ThingViewer", /** @lends sap.ui.ux3.ThingViewer.prototype */ { metadata : {

		library : "sap.ui.ux3",
		properties : {

			/**
			 * Title of the Thing Inspector
			 */
			title : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Thing type
			 */
			type : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Thing Icon Url
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},

			/**
			 * Subtitle of the Thing Inspector
			 */
			subtitle : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Width of the ThingViewer
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : '100%'},

			/**
			 * Height of the ThingViewer
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : '100%'},

			/**
			 * Defines which header type should be used.
			 * @since 1.16.3
			 */
			headerType : {type : "sap.ui.ux3.ThingViewerHeaderType", group : "Misc", defaultValue : sap.ui.ux3.ThingViewerHeaderType.Standard}
		},
		aggregations : {

			/**
			 * ThingGroups for the header content
			 */
			headerContent : {type : "sap.ui.ux3.ThingGroup", multiple : true, singularName : "headerContent"},

			/**
			 * Thing Inspector facets
			 */
			facets : {type : "sap.ui.ux3.NavigationItem", multiple : true, singularName : "facet"},

			/**
			 * ThingGroups for content of the selected facet
			 */
			facetContent : {type : "sap.ui.ux3.ThingGroup", multiple : true, singularName : "facetContent"},

			/**
			 * An ActionBar can be given
			 */
			actionBar : {type : "sap.ui.ux3.ActionBar", multiple : false},

			/**
			 * NavigationBar that is managed by this ThingViewer
			 */
			navBar : {type : "sap.ui.ux3.NavigationBar", multiple : false, visibility : "hidden"}
		},
		associations : {

			/**
			 * The Facet that is currently selected.
			 */
			selectedFacet : {type : "sap.ui.ux3.NavigationItem", multiple : false}
		},
		events : {

			/**
			 * Event for facet selection. The application is responsible for displaying the correct content for the selected one. The ThingInspector will currently always mark the first facet as selected.
			 */
			facetSelected : {allowPreventDefault : true,
				parameters : {

					/**
					 * Id of selected NavigationItem
					 */
					id : {type : "string"},

					/**
					 * The selected NavigationItem
					 */
					item : {type : "sap.ui.ux3.NavigationItem"},

					/**
					 * Key of selected NavigationItem
					 */
					key : {type : "string"}
				}
			}
		}
	}});

	(function() {
		/**
		 * Initialization hook for the ThingViewer. It creates the instance of the
		 * Popup helper service and does some basic configuration for it.
		 *
		 * @private
		 */
		ThingViewer.prototype.init = function() {
			var that = this;
			this._oNavBar = new sap.ui.ux3.NavigationBar();
			this.setAggregation("navBar",this._oNavBar);
			// attach NavBar selection
			this._oNavBar.attachSelect(function(oControlEvent) {
				var item = oControlEvent.getParameters().item;
				if (that.fireFacetSelected({id:item.getId(), key:item.getKey(),item:item})) {
					that.setSelectedFacet(item);
				} else {
					 oControlEvent.preventDefault();
				}
			});
		};

		/*
		 * Set size of TI after rendering: If running in Shell we sync with shell
		 * canvas. The size will then be set by the shell.
		 */
		ThingViewer.prototype.onAfterRendering = function() {
			// register resize handler
			this._resize = false;
			if (this.getActionBar()) {
				this._adjustStyles();
			}
			if (this.$().find(".sapUiUx3TVFacetContent").length <= 0) {
				return;
			}
			this._resizeListenerId = sap.ui.core.ResizeHandler.register(this.$().find(".sapUiUx3TVFacetContent")[0], jQuery.proxy(this._onresize, this));

			// initial resize handling
			this._setTriggerValue();
			this._setHeaderPosition();
			this._onresize();
		};

		ThingViewer.prototype.onBeforeRendering = function() {
			if (this._resizeListenerId) {
				sap.ui.core.ResizeHandler.deregister(this._resizeListenerId);
				this._resizeListenerId = null;
			}
		};

		ThingViewer.prototype._setHeaderPosition = function() {
			if (this.getHeaderType() === sap.ui.ux3.ThingViewerHeaderType.Standard) {
				var $typeContainer = this.$().find(".sapUiUx3TVHeaderContainerIdentifier"),
				    $scrollContainer = this.$().find(".sapUiUx3TVHeaderGroupScrollContainer");
				$scrollContainer.css("top", $typeContainer.outerHeight());
			}
		};

		/**
		 * Resize handler listening to the facet content area. If the area will be
		 * resized and the blocks will be rearranged to one column the width will be set
		 * to 100%. After resize to a width greater than two times the minimum width of
		 * a single block the size will be set back to 50%
		 *
		 * @private
		 */
		ThingViewer.prototype._onresize = function(oEvent) {
			var width;
			if (oEvent) {
				width = jQuery(oEvent.target).width();
			}
			if (!width) {
				width = jQuery(this.$().find(".sapUiUx3TVFacetContent")[0]).width();
			}
			if (width < this._triggerValue && this._resize == false) {
				var facetGroups = this.$().find(".sapUiUx3TVFacetThingGroup");
				for ( var i = 0; i < facetGroups.length; i++) {
					jQuery(facetGroups[i]).animate({
						width : "100%"
					}, "fast");
				}
				this._resize = true;
			} else if (width > this._triggerValue && this._resize == true) {
				var facetGroups = this.$().find(".sapUiUx3TVFacetThingGroup");
				for ( var i = 0; i < facetGroups.length; i++) {
					jQuery(facetGroups[i]).animate({
						width : "50%"
					}, "fast");
				}
				this._resize = false;
			}
			if (this.getActionBar()) {
				var minWidth = this.getActionBar().getActionBarMinWidth(),
					minWidthTI = minWidth;
				if (this._bShell) {
					minWidth += 36;
					minWidthTI  = minWidth + 60;
				}
				this.$().find(".sapUiUx3TV").css("min-width",minWidthTI + "px");
				this.$().find(".sapUiUx3TVContent").css("min-width",minWidth + "px");
			}
		};

		/**
		 * Destroys this instance of ThingViewer, called by Element#destroy()
		 *
		 * @private
		 */
		ThingViewer.prototype.exit = function() {
			this._oNavBar.destroy();
			if (this._resizeListenerId) {
				sap.ui.core.ResizeHandler.deregister(this._resizeListenerId);
				this._resizeListenerId = null;
			}
		};

		/**
		 * get Navigation Bar control
		 *
		 * @private
		 */
		ThingViewer.prototype._getNavBar = function() {
			return this._oNavBar;
		};

		/**
		 * setDefault NavBar selection and fire SelectedItem Event
		 *
		 * @private
		 */
		ThingViewer.prototype._selectDefault = function() {
			var navBarItems = this._oNavBar.getItems();
			if (navBarItems.length && !this._oNavBar.getSelectedItem()) {
				if (!this.getSelectedFacet()) {
					this.setSelectedFacet(navBarItems[0]);
				}
				var itemID = this._oNavBar.getSelectedItem(),
					item = sap.ui.getCore().byId(itemID);
				this.fireFacetSelected({
					id : item.getId(),
					key : item.getKey(),
					item : item
				});
			}
		};

		/**
		 * equal Columns
		 *
		 * @private
		 */
		ThingViewer.prototype._equalColumns = function() {
			var headerColumn = this.$().find(".sapUiUx3TVHeader"),
			    facetsColumn = this.$().find(".sapUiUx3TVFacets"),
			    scrollContainer = this.$().find(".sapUiUx3TVContentScrollContainer"),
				scrollContainerColumnHeight = scrollContainer.get(0).scrollHeight;
			facetsColumn.height(scrollContainerColumnHeight);
			headerColumn.height(scrollContainerColumnHeight);
		};

		/**
		 * Rerender Header
		 *
		 * @private
		 */
		ThingViewer.prototype._rerenderHeader = function() {
			var $content = this.$("header");
			if ($content.length > 0) {
				var rm = sap.ui.getCore().createRenderManager();
				sap.ui.ux3.ThingViewerRenderer.renderHeader(rm, this);
				rm.flush($content[0]);
				rm.destroy();
			}
		};

		/**
		 * Rerender Header Content
		 *
		 * @private
		 */
		ThingViewer.prototype._rerenderHeaderContent = function() {
			var $content = this.$("headerContent");
			if ($content.length > 0) {
				var rm = sap.ui.getCore().createRenderManager();
				sap.ui.ux3.ThingViewerRenderer.renderHeaderContent(rm, this);
				rm.flush($content[0]);
				rm.destroy();
			}
		};

		/**
		 * Rerender Toolbar
		 *
		 * @private
		 */
		ThingViewer.prototype._rerenderToolbar = function() {
			var $content = this.$("toolbar");
			if ($content.length > 0) {
				var rm = sap.ui.getCore().createRenderManager();
				sap.ui.ux3.ThingViewerRenderer.renderToolbar(rm, this);
				rm.flush($content[0]);
				rm.destroy();
			}
		};

		/**
		 * Rerender Facet Content
		 *
		 * @private
		 */
		ThingViewer.prototype._rerenderFacetContent = function() {
			var $content = this.$("facetContent");
			if ($content.length > 0) {
				var rm = sap.ui.getCore().createRenderManager();
				sap.ui.ux3.ThingViewerRenderer.renderFacetContent(rm, this);
				rm.flush($content[0]);
				rm.destroy();
				this._resize = false;
				this._setTriggerValue();
				this._onresize();
			}
		};

		/**
		 * set trigger value for resize handler
		 *
		 * @private
		 */
		ThingViewer.prototype._setTriggerValue = function() {
			var facetGroups,
				minWidth,
				$content = this.$("facetContent");

			// get triggerValue for facet content resize handler
			if ($content.length > 0) {
				facetGroups = this.$().find(".sapUiUx3TVFacetThingGroup");
				minWidth = jQuery(facetGroups[0]).css("min-width");
				if (minWidth) {
					this._triggerValue = parseInt(minWidth, 10) * 2;
				}
			}
		};

		/* Redefinition of generated API methods */

		// Implementation of API method
		ThingViewer.prototype.getFacets = function() {
			return this._oNavBar.getItems();
		};

		// Implementation of API method insertFacet
		ThingViewer.prototype.insertFacet = function(oFacet, iIndex) {
			this._oNavBar.insertItem(oFacet, iIndex);
			return this;
		};

		// Implementation of API method
		ThingViewer.prototype.addFacet = function(oFacet) {
			this._oNavBar.addItem(oFacet);
			return this;
		};

		// Implementation of API method
		ThingViewer.prototype.removeFacet = function(vElement) {
			return this._oNavBar.removeItem(vElement);
		};

		// Implementation of API method
		ThingViewer.prototype.removeAllFacets = function() {
			return this._oNavBar.removeAllItems();
		};

		// Implementation of API method
		ThingViewer.prototype.destroyFacets = function() {
			this._oNavBar.destroyItems();
			return this;
		};

		// Implementation of API method
		ThingViewer.prototype.setIcon = function(oIcon) {
			this.setProperty("icon", oIcon);
			if (this.getActionBar()) {
				this.getActionBar().setThingIconURI(oIcon);
			}
			this._rerenderHeader();
			return this;
		};

		// Implementation of API method
		ThingViewer.prototype.insertFacetContent = function(oFacetContent, iIndex) {
			this.insertAggregation("facetContent", oFacetContent, iIndex, true);
			this._rerenderFacetContent();
			return this;
		};
		// Implementation of API method
		ThingViewer.prototype.addFacetContent = function(oFacetContent) {
			this.addAggregation("facetContent", oFacetContent, true);
			this._rerenderFacetContent();
			return this;
		};
		// Implementation of API method
		ThingViewer.prototype.removeFacetContent = function(vFacetContent) {
			var result = this.removeAggregation("facetContent", vFacetContent, true);
			this._rerenderFacetContent();
			return result;
		};
		// Implementation of API method
		ThingViewer.prototype.removeAllFacetContent = function() {
			var result = this.removeAllAggregation("facetContent", true);
			this._rerenderFacetContent();
			return result;
		};
		// Implementation of API method
		ThingViewer.prototype.destroyFacetContent = function() {
			this.destroyAggregation("facetContent", true);
			this._rerenderFacetContent();
			return this;
		};
		// Implementation of API method
		ThingViewer.prototype.insertHeaderContent = function(oHeaderContent, iIndex) {
			this.insertAggregation("headerContent", oHeaderContent, iIndex, true);
			this._rerenderHeaderContent();
			return this;
		};
		// Implementation of API method
		ThingViewer.prototype.addHeaderContent = function(oHeaderContent) {
			this.addAggregation("headerContent", oHeaderContent, true);
			this._rerenderHeaderContent();
			return this;
		};
		// Implementation of API method
		ThingViewer.prototype.removeHeaderContent = function(vHeaderContent) {
			var result = this.removeAggregation("headerContent", vHeaderContent, true);
			this._rerenderHeaderContent();
			return result;
		};
		// Implementation of API method
		ThingViewer.prototype.removeAllHeaderContent = function() {
			var result = this.removeAllAggregation("headerContent", true);
			this._rerenderHeaderContent();
			return result;
		};
		// Implementation of API method
		ThingViewer.prototype.destroyHeaderContent = function() {
			this.destroyAggregation("headerContent", true);
			this._rerenderHeaderContent();
			return this;
		};
		// Implementation of API method
		ThingViewer.prototype.setSelectedFacet = function(selectedFacet) {
			var oldSelectedFacet = this.getSelectedFacet();
			this.setAssociation("selectedFacet", selectedFacet, true);
			var newSelectedFacet = this.getSelectedFacet();

			if (oldSelectedFacet != newSelectedFacet) {
				this._oNavBar.setSelectedItem(newSelectedFacet);
			}
		};
		//Implementation of API method
		ThingViewer.prototype.setTitle = function(sTitle) {
			this.setProperty("title", sTitle, true);
			this._rerenderHeader();
		};
		//Implementation of API method
		ThingViewer.prototype.setSubtitle = function(sTitle) {
			this.setProperty("subtitle", sTitle, true);
			this._rerenderHeader();
		};
		// Implementation of API method
		ThingViewer.prototype.setActionBar = function(oActionBar) {
			this.setAggregation("actionBar", oActionBar, true);
			if (this.getIcon() && this.getActionBar()) {
				this.getActionBar().setThingIconURI(this.getIcon());
			}
			this._rerenderToolbar();
			this._adjustStyles();
			return this;
		};
		ThingViewer.prototype._adjustStyles = function() {
			var $header = this.$().find(".sapUiUx3TVHeader"),
			    $facets = this.$().find(".sapUiUx3TVFacets");
			if ($header.length > 0) {
				$header.addClass("sapUiUx3TVActionBar");
				$header.removeClass("sapUiUx3TVNoActionBar");
			}
			if ($facets.length > 0) {
				$facets.addClass("sapUiUx3TVActionBar");
				$facets.removeClass("sapUiUx3TVNoActionBar");
			}
		};
	}());

	return ThingViewer;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ThingViewer.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ToolPopup') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ToolPopup.
jQuery.sap.declare('sap.ui.ux3.ToolPopup'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ToolPopup",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/IconPool', 'sap/ui/core/Popup', 'sap/ui/core/theming/Parameters', './library'],
	function (jQuery, Control, IconPool, Popup, Parameters, library) {
		"use strict";


		/**
		 * Constructor for a new ToolPopup.
		 *
		 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
		 * @param {object} [mSettings] Initial settings for the new control
		 *
		 * @class
		 * A popup which the user can open from the Shell's tool pane. Generally, the starting point would be an icon.
		 * For this pop up, buttons can be defined with any text; therefore, it has the same purpose
		 * and similar look like any common dialog box.
		 * A ToolPopup can have any content. Depending on the application type and design, the structure
		 * of the texts and input fields can be for example form-like.
		 * @extends sap.ui.core.Control
		 * @implements sap.ui.core.PopupInterface
		 *
		 * @namespace
		 * @author SAP SE
		 * @version 1.32.6
		 *
		 * @constructor
		 * @public
		 * @alias sap.ui.ux3.ToolPopup
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var ToolPopup = Control.extend("sap.ui.ux3.ToolPopup", /** @lends sap.ui.ux3.ToolPopup.prototype */ {
			metadata: {

				interfaces: [
					"sap.ui.core.PopupInterface"
				],
				library: "sap.ui.ux3",
				properties: {

					/**
					 * Determines the title displayed in the pop up window
					 */
					title: {type: "string", group: "Misc", defaultValue: null},

					/**
					 * This property is relevant for Shell use:
					 * The URL to the icon displayed in the tool area which is used to open the ToolPopup.
					 * The recommended size is 32x32px, including some transparent border. Therefore,
					 * the content will cover about 20x20px.
					 */
					icon: {type: "sap.ui.core.URI", group: "Misc", defaultValue: null},

					/**
					 * This property is relevant for Shell use:
					 * The URL to the icon in hover state, displayed in the tool area which is used to open the popup.
					 */
					iconHover: {type: "sap.ui.core.URI", group: "Misc", defaultValue: null},

					/**
					 * This property is relevant for Shell use:
					 * The URL to the icon in selected state displayed in the tool area which is used to open the popup.
					 * If no selected icon is given, the hover icon is used.
					 */
					iconSelected: {type: "sap.ui.core.URI", group: "Misc", defaultValue: null},

					/**
					 * Specifies whether the popup is modal and blocks any user-interaction with controls in the background.
					 * Changing this property while the ToolPopup is open will not have any effect.
					 * Please don't use "modal" and "autoclose" at the same time. In this case a warning will
					 * be prompted to the console and "autoclose" won't be used.
					 */
					modal: {type: "boolean", group: "Behavior", defaultValue: false},

					/**
					 * Specifies whether the ToolPopup has a dark or bright background. If set to true
					 * the background and borders will be dark. If false they will be bright.
					 * This property only has an effect for the GoldReflection-theme.
					 * @since 1.11.1
					 */
					inverted: {type: "boolean", group: "Misc", defaultValue: true},

					/**
					 * Determines whether the ToolPopup will auto close when it loses focus.
					 * If the user e.g. clicks outside of the ToolPopup it will be closed.
					 * Please don't use "modal" and "autoclose" at the same time.
					 * In this case a warning will be prompted to the console and "autoclose" won't be used.
					 * @since 1.13.2
					 */
					autoClose: {type: "boolean", group: "Misc", defaultValue: false},

					/**
					 * Forces a maximum height of the ToolPopup in pixels. If the ToolPopup content
					 * is higher than the ToolPopup, the content will be scrollable.
					 * @since 1.13.2
					 */
					maxHeight: {type: "sap.ui.core.CSSSize", group: "Misc", defaultValue: null},

					/**
					 * Forces a maximum width of the ToolPopup in pixels.
					 * @since 1.15.0
					 */
					maxWidth: {type: "sap.ui.core.CSSSize", group: "Misc", defaultValue: null},

					/**
					 * Time in milliseconds for the open animation.
					 * @since 1.19.0
					 */
					openDuration: {type: "int", group: "Misc", defaultValue: 400},

					/**
					 * Time in milliseconds for the close animation.
					 * @since 1.19.0
					 */
					closeDuration: {type: "int", group: "Misc", defaultValue: 400}
				},
				defaultAggregation: "content",
				aggregations: {

					/**
					 * Defines the buttons to appear in the popup
					 */
					buttons: {type: "sap.ui.core.Control", multiple: true, singularName: "button"},

					/**
					 * Defines the content of the popup
					 */
					content: {type: "sap.ui.core.Control", multiple: true, singularName: "content"}
				},
				associations: {

					/**
					 * Defines the control that will get the focus when the ToolPopup is opened.
					 */
					initialFocus: {type: "sap.ui.core.Control", multiple: false},

					/**
					 * This property is relevant for stand-alone use:
					 * This association needs to be set if the ToolPopup should not be opened by/with
					 * the Shell. This association contains the instance of the control that
					 * assigns the ToolPopup's position.
					 */
					opener: {type: "sap.ui.core.Control", multiple: false},

					/**
					 * Defines one of the buttons that have been provided via button aggregation to be
					 * the default button. This default button is initially selected, if no control
					 * is set via the initialFocus association explicitly. The default button is activated
					 * when Enter is pressed in the context of the dialog and when the currently selected element
					 * does not handle the Enter event itself.
					 * @since 1.20.1
					 */
					defaultButton: {type: "sap.ui.core.Control", multiple: false}
				},
				events: {

					/**
					 * Event is fired when the popup opens
					 */
					open: {},

					/**
					 * Event is fired when the popup closes because the user pressed Escape or the ToolPopup
					 * Button in the Shell. This is called before the closing animation.
					 */
					close: {allowPreventDefault: true},

					/**
					 * Event is fired whenever the user clicks the Enter or the Enter key inside the pop up
					 */
					enter: {
						parameters: {

							/**
							 * The onsapenter event, received by the pop up
							 */
							originalEvent: {type: "object"},

							/**
							 * The control that was focused when the user pressed the Enter key (may be null)
							 */
							originalSrcControl: {type: "sap.ui.core.Control"}
						}
					},

					/**
					 * Event is fired when one of the icon properties is modified (Note: The icon is not
					 * rendered by the ToolPopup).
					 * To be used by other controls which want to update the icon in their UI.
					 */
					iconChanged: {},

					/**
					 * This event is fired after the ToolPopup has finished its closing animation.
					 * It is called for EVERY close, regardless of whether the user has triggered the
					 * close or whether the ToolPopup was closed via API call.
					 */
					closed: {},

					/**
					 * Event is being fired after the ToolPopup has been opened.
					 * @since 1.19.0
					 */
					opened: {}
				}
			}
		});

		// regex rules for arrows corresponding to the given 'my' and 'at' parameters
		// these regexes also consider the new offset style of jQueryUI-position from version 1.10.x
		// from version 1.10.x the offset is used right within the 'my' parameter
		ToolPopup.ARROW_LEFT = new RegExp(/my:(left|begin)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(right|end)\|[a-z]+/);
		ToolPopup.ARROW_RIGHT = new RegExp(/my:(right|end)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(left|begin)\|[a-z]+/);
		ToolPopup.ARROW_UP = new RegExp(/my:[a-z]+([-+]\d*\%?)?\|top([-+]\d*\%?)? at:[a-z]+\|bottom/);
		ToolPopup.ARROW_DOWN = new RegExp(/my:[a-z]+([-+]\d*\%?)?\|bottom([-+]\d*\%?)? at:[a-z]+\|top/);

		(function () {
			ToolPopup.prototype.init = function () {
				this.oPopup = null;
				this._bPositionSet = false;

				this._mParameters = {};
				this._mParameters.that = this;
				this._mParameters.firstFocusable = this.getId() + "-firstFocusable";
				this._mParameters.lastFocusable = this.getId() + "-lastFocusable";

				this._bFocusSet = false;
				this._proxyOpened = jQuery.proxy(fnPopupOpened, this);
				this._proxyClosed = jQuery.proxy(fnOnClosed, this);
				this._proxyFixSize = jQuery.proxy(fnFixSize, this);
				this._proxyOnResize = jQuery.proxy(fnOnResize, this);

				fnSetArrowDimensions(this);
			};
			ToolPopup.prototype.exit = function () {
				if (this.oPopup) {
					this.oPopup.detachOpened(this._proxyOpened);
					this.oPopup.detachClosed(this._proxyClosed);
					this.oPopup.destroy();
					delete this.oPopup;
				}
				delete this._bPositionSet;

				delete this._mParameters;

				delete this._bFocusSet;
				delete this._bPreventRestoreFocus;
				delete this._proxyOpened;
				delete this._proxyClosed;

				delete this._bRTL;
				delete this._sArrowDir;
				delete this._oArrowIcon;
				delete this._bThemeInverted;

				delete this._sInitialFocusId;
			};

			/**
			 * Checks if the ToolPopup already has a tabbable element.
			 * If not, it's checked whether the fake-element should be used or if there is an element that could be focused instead.
			 *
			 * @param {sap.ui.ux3.ToolPopup} that to get/set instance values
			 * @returns {string} _sInitialFocusId that has been determined here
			 * @private
			 */
			var fnGetInitialFocus = function (that) {
				jQuery.sap.assert(!!that, "No ToolPopup instance given for fnGetInitialFocus");

				var oElement;
				var aTabbables = jQuery(":sapTabbable", that.$()).get();

				// if there is an initial focus it was already set to the Popup onBeforeRendering
				if (!that._bFocusSet) {
					// search the first tabbable element
					if (aTabbables.length > 0) {
						for (var i = 0; i < aTabbables.length; i++) {
							if (aTabbables[i].id !== that._mParameters.firstFocusable &&
								aTabbables[i].id !== that._mParameters.lastFocusable) {

								oElement = aTabbables[i];
								break;
							}
						}
					}

					// If a tabbable element is part of a control, focus the controls instead
					var oFocusControl = jQuery(oElement).control();
					if (oFocusControl[0]) {
						var oFocusDomRef = oFocusControl[0].getFocusDomRef();
						oElement = oFocusDomRef ? oFocusDomRef : oElement;
					} else {
						// if there is no tabbable element in the content use the first fake
						// element to set the focus to the toolpopup
						oElement = jQuery.sap.domById(that._mParameters.firstFocusable);
					}

					// oElement might not be available if this function is called during destroy
					if (oElement) {
						jQuery.sap.focus(oElement);
						that._sInitialFocusId = oElement.id;
					}

				} else {
					that._sInitialFocusId = that.oPopup._sInitialFocusId;
				}

				return that._sInitialFocusId;
			};

			/**
			 * Handler for focus, adapted for this control,
			 * @param {jQuery.EventObject} oEvent
			 *
			 * @private
			 */
			ToolPopup.prototype.onfocusin = function (oEvent) {
				this._mParameters.event = oEvent;
				this._mParameters.$FocusablesContent = jQuery(":sapTabbable", this.$("content"));
				this._mParameters.$FocusablesFooter = jQuery(":sapTabbable", this.$("buttons"));

				this.oPopup.focusTabChain(this._mParameters);
			};

			/**
			 * This function fixes the height of the ToolPopup if the content is too large.
			 * So the height will be set to the possible maximum and a scrollbar is provided.
			 * Additionally the width of the ToolPopup is fixed as well since the scrollbar reduces
			 * the possible space for the content.
			 *
			 * @private
			 */
			var fnFixSize = function () {
				var $This = this.$();
				var iValue = 0;

				var sMaxHeight = this.getMaxHeight();
				var iMaxHeight = sMaxHeight ? parseInt(sMaxHeight, 10) : 0;

				/*
				 * Fix the width (if necessary)
				 */
				var sMaxWidth = this.getMaxWidth();
				if (sMaxWidth) {
					var iMaxWidth = parseInt(sMaxWidth, 10);

					var sBorderLeft = $This.css("border-left-width");
					var iBorderLeft = parseInt(sBorderLeft, 10);
					var sBorderRight = $This.css("border-right-width");
					var iBorderRight = parseInt(sBorderRight, 10);

					var sPaddingLeft = $This.css("padding-left");
					var iPaddingLeft = parseInt(sPaddingLeft, 10);
					var sPaddingRight = $This.css("padding-right");
					var iPaddingRight = parseInt(sPaddingRight, 10);

					iMaxWidth -= iBorderLeft + iPaddingLeft + iPaddingRight + iBorderRight;
					$This.css("max-width", iMaxWidth + "px");
				} else {
					$This.css("max-width", "");
				}

				/*
				 * Fix the height
				 */
				// get all paddings
				var sPaddingTop = $This.css("padding-top");
				var iPaddingTop = parseInt(sPaddingTop, 10);
				var sPaddingBottom = $This.css("padding-bottom");
				var iPaddingBottom = parseInt(sPaddingBottom, 10);

				// get all border widths
				var sBorderTop = $This.css("border-top-width");
				var iBorderTop = parseInt(sBorderTop, 10);
				var sBorderBottom = $This.css("border-bottom-width");
				var iBorderBottom = parseInt(sBorderBottom, 10);

				var iPaddings = iPaddingTop + iPaddingBottom + iBorderTop + iBorderBottom;

				// determine the corresponding scrollTop to calculate the proper bottom end of the ToolPopup
				var iScrollTop = jQuery(document).scrollTop();
				var oThisRect = $This.rect();
				var iBottomEnd = oThisRect.top - iScrollTop + $This.outerHeight(true);

				// only use this mechanism when there is NO maxHeight set
				var iWinHeight = jQuery(window).height();
				var bTooHigh = (iBottomEnd > iWinHeight) && (iMaxHeight === 0);
				var iYOffset = 0;

				// check if an offset forces the ToolPopup out of the window
				// and below the opener
				if (bTooHigh) {
					var $Opener = jQuery.sap.byId(this.getOpener());
					var oOpenerRect = $Opener.rect();
					var iOpenerBottom = oOpenerRect.top - iScrollTop + $Opener.outerHeight(true);

					// if bottom of the ToolPopup is below the opener and there is a possible offset
					var aOffset = this.oPopup._getPositionOffset();
					if (iBottomEnd > iOpenerBottom && aOffset.length > 0) {
						// check if the offset is responsible for pushing the ToolPopup below the opener
						// and therefore out of the window
						iYOffset = Math.abs(parseInt(aOffset[1], 10));

						// this check inverts the variable to prevent any resize of the ToolPopup since it
						// is pushed out of the window because of the offset
						if ((iBottomEnd - iYOffset) < iWinHeight) {
							bTooHigh = false;
							var sMessage = "Offset of " + iYOffset + " pushes ToolPopup out of the window";
							jQuery.sap.log.warning(sMessage, "", "sap.ui.ux3.ToolPopup");
						}
					}

					iMaxHeight = iMaxHeight ? iMaxHeight : iWinHeight - oThisRect.top;
				}

				$This.toggleClass("sapUiUx3TPLargeContent", bTooHigh);

				if (iMaxHeight || bTooHigh) {
					$This.css("max-height", iMaxHeight + "px");

					var $Title = this.$("title");
					var $TitleSep = this.$("title-separator");

					var $Buttons = this.$("buttons");
					var $ButtonsSep = this.$("buttons-separator");

					// Calculate the correct start value. Either simply take the set maxHeight
					// or calculate the value between Popup.top and window end (incl. padding and offset)
					iValue = iMaxHeight > 0 ? iMaxHeight : iWinHeight - oThisRect.top - iPaddingBottom - iYOffset;

					// subtract all paddings and border-widths
					iValue -= iPaddings;

					// subtracting all corresponding values from top to down
					iValue -= $Title.outerHeight(true);
					iValue -= $TitleSep.outerHeight(true); // including margin

					// height of content needn't to be subtracted

					iValue -= $ButtonsSep.outerHeight(true); // including margin
					iValue -= $Buttons.length > 0 ? $Buttons.outerHeight(true) : 0;

					// if the height has to be corrected
					iValue = parseInt(iValue, 10);

					var $Content = this.$("content");
					$Content.css("max-height", iValue + "px");

					$Content.toggleClass("sapUiUx3TPLargeContent", true);
				}

				fnSetArrow(this);
			};

			/**
			 * Function is called via 'jQuery.proxy()' when the ToolPopup has been opened
			 * including the fade-in-animation of the Popup
			 *
			 * @private
			 */
			var fnPopupOpened = function () {
				this._proxyFixSize();

				if (!this._sInitialFocusId) {
					var sInitFocusId = fnGetInitialFocus(this);

					// Compare the initial focus id with the current focus that is
					// stored in the FocusHandler in the core.
					// If the initial focus was set properly already by the Popup
					// don't focus twice. Because Internet Explorer will be confused with
					// two focusin and focusout events
					if (sInitFocusId !== sap.ui.getCore().getCurrentFocusedControlId()) {
						var oControl = jQuery.sap.byId(sInitFocusId);
						oControl.focus();
					}
				}

				if (!this._sResizeID) {
					// register the ResizeHandler for the content of the toolPopup and not the whole toolPopup itself.
					// In this way when resized the toolPopup does not change its height indefinitely.
					this._sResizeID = sap.ui.core.ResizeHandler.register(this.$('content')[0], this._proxyOnResize);
				}

				// forward the Popup's opened event accordingly
				// was added in "1.19.0" as a fix for a CSN and was downported to "1.18.2" and "1.16.6"
				this.fireOpened();
			};


			/**
			 * Indicates whether the pop up is currently open
			 *
			 * @returns {boolean}
			 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
			 * @public
			 */
			ToolPopup.prototype.isOpen = function () {
				return this.oPopup && (this.oPopup.getOpenState() == "OPENING" || this.oPopup.getOpenState() == "OPEN");
			};

			/**
			 * Indicates whether the control will be closed
			 *
			 * @returns {boolean}
			 * @private
			 */
			ToolPopup.prototype.willBeClosed = function () {
				var eState = this.oPopup && this.oPopup.getOpenState();
				return eState !== sap.ui.core.OpenState.OPENING && eState !== sap.ui.core.OpenState.OPEN;
			};

			// first variant of the documentation: to be parsed by the metamodel derivation
			/**
			 * Opens the ToolPopup.
			 * It is checked which control wants to open the ToolPopup. The Shell was previously
			 * set as parent so the corresponding parent element is used to set the correct position of the ToolPopup.
			 * If another control (i.e. a button) opens the ToolPopup, the control must be previously
			 * set as <code>opener</code> via <code>setOpener</code> to the ToolPopup.
			 * Corresponding to this opener the position of the ToolPopup will be set.
			 * It's also possible to set the position above, below or left from the opener.
			 * This can be done via the possible parameters <code>my</code> and <code>at</code>.
			 * These parameters refers to work the same way as they do of sap.ui.core.Popup.open.
			 *
			 * @param {sap.ui.core.Popup.Dock} [my=sap.ui.core.Popup.Dock.CenterCenter] The ToolPopup's content
			 * reference position for docking
			 * @param {sap.ui.core.Popup.Dock} [at=sap.ui.core.Popup.Dock.CenterCenter] The "of" element's
			 * reference point for docking to
			 * @returns {sap.ui.ux3.ToolPopup}
			 * @public
			 */
			ToolPopup.prototype.open = function (my, at) {
				this._my = my;
				this._at = at;
				this._sArrowDir = fnGetArrowDirection(this);
				var $OpenerRef = null;
				this.sOffset = "";
				fnUpdateThemeInverted(this);

				// if the popup position has not been (re-)initialized since the last time this was opened,
				// try to apply the default position
				if (!this._bPositionSet) {
					var iOffsetX = 0;
					var iOffsetY = 0;

					// any further validation of the values is done within the Popup
					if (!this._my) {
						this._my = Popup.Dock.BeginTop;
					}
					if (!this._at) {
						this._at = Popup.Dock.EndTop;
					}

					$OpenerRef = jQuery.sap.domById(this.getOpener());
					if ($OpenerRef) {
						switch (this._sArrowDir) {
							case "Up":
								iOffsetX = 0;
								iOffsetY = this.iArrowWidth;
								break;

							case "Down":
								iOffsetX = 0;
								iOffsetY = -this.iArrowWidth;
								break;

							case "Right":
								iOffsetX = -this.iArrowWidth;
								break;

							default:
							case "Left":
								iOffsetX = this.iArrowWidth;
								break;
						}

						iOffsetX = parseInt(iOffsetX, 10);
						iOffsetY = parseInt(iOffsetY, 10);
						this.sOffset = "" + iOffsetX + " " + iOffsetY;
						// my, at, of, offset, collision /*none*/
						this.setPosition(this._my, this._at, $OpenerRef, this.sOffset, "none");
					} else {
						this.setPosition(Popup.Dock.BeginTop, Popup.Dock.BeginTop, window, "0 0", "fit");
						jQuery.sap.log.warning("No opener set. Using a default position for Popup", "", "sap.ui.ux3.ToolPopup");
					}
					/* value is set in 'setPosition'. This value shows if the position was previously set manually =>
					 * in this case it was definitely not set manually
					 */
					this._bPositionSet = false;
				}
				// create popup if required
				this._ensurePopup();

				var bAutoClose = this.getAutoClose();
				var bModal = this.getModal();
				if (bAutoClose && bModal) {
					jQuery.sap.log.warning("A modal & autoclose ToolPopup will not work properly. Therefore 'autoclose' will be deactived!");
					bAutoClose = false;
				}
				this.oPopup.setAutoClose(bAutoClose);
				this.oPopup.setModal(bModal);

				// Save current focused element to restore the focus after closing the dialog
				this._oPreviousFocus = Popup.getCurrentFocusInfo();
				// open popup
				this.fireOpen();

				// the opener is needed for the intelligent arrow positioning
				fnCheckOpener(this);

				// function(iDuration, my, at, of, offset, collision /*empty to avoid any override*/, followOf /*true*/)
				this.oPopup.open(this.getOpenDuration(), this._my, this._at, $OpenerRef, this.sOffset, "", true);
				fnSetArrow(this);

				return this;
			};

			/**
			 * Checks if an opener was set. If not, this functions tries to get the opener from the Popup.
			 *
			 * @private
			 */
			var fnCheckOpener = function (oThis) {
				if (!oThis.getOpener()) {
					var sId = "";
					if (oThis.oPopup) {
						if (oThis.oPopup._oPosition.of instanceof sap.ui.core.Element) {
							sId = oThis.oPopup._oPosition.of.getId();
						} else {
							if (oThis.oPopup._oPosition.of.length > 0) {
								sId = oThis.oPopup._oPosition.of[0].id;
							} else {
								sId = oThis.oPopup._oPosition.of.id;
							}
						}
					}

					if (sId !== "") {
						oThis.setAssociation("opener", sId, true);
					} else {
						jQuery.sap.log.error("Neither an opener was set properly nor a corresponding one can be distinguished", "", "sap.ui.ux3.ToolPopup");
					}
				}
			};

			/**
			 * Sets the arrow dimensions.
			 *
			 * @param {sap.ui.ux3.ToolPopup} oThis The Toolpopup instnace
			 * @private
			 */
			var fnSetArrowDimensions = function (oThis) {
				var sParam = "sapUiUx3ToolPopupArrowWidth";
				oThis.sArrowWidth = Parameters.get(sParam);
				oThis.iArrowWidth = parseInt(oThis.sArrowWidth, 10);

				sParam = "sapUiUx3ToolPopupArrowHeight";
				oThis.sArrowHeight = Parameters.get(sParam);
				oThis.iArrowHeight = parseInt(oThis.sArrowHeight, 10);

				sParam = "sapUiUx3ToolPopupArrowRightMarginCorrection";
				oThis.sArrowPadding = Parameters.get(sParam);
				oThis.iArrowPadding = parseInt(oThis.sArrowPadding, 10);

				sParam = "sapUiUx3ToolPopupArrowRightMarginCorrectionInverted";
				oThis.sArrowPaddingInverted = Parameters.get(sParam);
				oThis.iArrowPaddingInverted = parseInt(oThis.sArrowPaddingInverted, 10);
			};

			/**
			 * Calculates the desired arrow direction related to the set docking.
			 * This only works when "my" and "at" both use the jQuery-based docking which means they are strings like "begin top".
			 *
			 * @param {sap.ui.ux3.ToolPopup} oThis the instance of the ToolPopup
			 * @returns {string} with arrow's direction
			 * @private
			 */
			var fnGetArrowDirection = function (oThis) {

				// do not mirror the arrow direction here in RTL mode, because otherwise the offset is calculated wrong
				// (Because the offset mirroring happens inside popup)
				// the arrow is later mirrored at the output...

				// this is the default case if no match was found
				var sDirection = "Left";

				// if 'my' is not set check if it was previously set via 'setPosition'
				var my = oThis._my;
				var at = oThis._at;
				if (!my && oThis.oPopup) {
					my = oThis.oPopup._oPosition.my;
				}
				if (!at && oThis.oPopup) {
					at = oThis.oPopup._oPosition.at;
				}

				oThis._bHorizontalArrow = false;

				if (my && at) {
					var aMy = my.split(" ");
					var aAt = at.split(" ");
					// create a rule like "my:top|left at:left|top"
					var sRule = "my:" + aMy[0] + "|" + aMy[1];
					sRule += " at:" + aAt[0] + "|" + aAt[1];

					if (ToolPopup.ARROW_LEFT.exec(sRule)) {
						oThis._bHorizontalArrow = true;
						sDirection = "Left";
					} else if (ToolPopup.ARROW_RIGHT.exec(sRule)) {
						oThis._bHorizontalArrow = true;
						sDirection = "Right";
					} else if (ToolPopup.ARROW_UP.exec(sRule)) {
						sDirection = "Up";
					} else if (ToolPopup.ARROW_DOWN.exec(sRule)) {
						sDirection = "Down";
					}

					if (oThis.getDomRef() && oThis.isOpen()) {
						var $This = oThis.$();
						var oPopRect = $This.rect();
						var $Opener = jQuery.sap.byId(oThis.getOpener());
						var oOpenerRect = $Opener.rect();

						if (oOpenerRect) {
							// check if the ToolPopup was positioned at another side relative to the opener due to any collision.
							if (oThis._bHorizontalArrow) {
								// left/right arrow
								var iPopRight = oPopRect.left + $This.outerWidth(true) + oThis.iArrowWidth;
								var iOpenerRight = oOpenerRect.left + $Opener.outerWidth(true);

								if (iPopRight <= iOpenerRight) {
									sDirection = "Right";

								} else {
									sDirection = "Left";
								}
							} else {
								// up/down arrow
								var iPopBottom = oPopRect.top + $This.outerHeight(true) + oThis.iArrowWidth;
								var iOpenerBottom = oOpenerRect.top + $Opener.outerHeight(true);

								if (iPopBottom <= iOpenerBottom) {
									sDirection = "Down";
								} else {
									sDirection = "Up";
								}
							}
						}
					}
				}

				return sDirection;
			};

			/**
			 * Calculates the desired arrow position related to the set docking and to the size of the popup.
			 * This only works when "my" and "at" both use the jQuery-based docking which means they
			 * are strings like "begin top".
			 * If there is no opener set properly an error is logged into the console and there will
			 * be no arrow for the ToolPopup.
			 *
			 * @param {sap.ui.ux3.ToolPopup} oThis
			 * @private
			 */
			var fnSetArrow = function (oThis) {
				if (!oThis.getDomRef()) {
					return;
				}

				var sKey = "";
				var iVal = 0;
				var iZero = 0; // this is the 0 of the  relative position between ToolPopup and Opener
				var iHalfArrow = oThis.iArrowHeight / 2;

				oThis._sArrowDir = fnGetArrowDirection(oThis);
				var sArrowDir = oThis._sArrowDir;
				if (oThis._bRTL) {
					// in RTL mode arrow must be mirrowed here
					if (oThis._sArrowDir === "Right") {
						sArrowDir = "Left";
					} else if (oThis._sArrowDir === "Left") {
						sArrowDir = "Right";
					}
				}

				var oPopRect = oThis.$().rect();
				var oOpenerRect = jQuery.sap.byId(oThis.getOpener()).rect();
				if (!oOpenerRect) {
					// if a proper opener isn't available
					jQuery.sap.log.warning("Opener wasn't set properly. Therefore arrow will be at a default position", "", "sap.ui.ux3.ToolPopup");
				}
				var $Arrow = oThis.$("arrow");

				// get the corresponding my-property
				if (!oThis._my && oThis.oPopup) {
					oThis._my = oThis.oPopup._oPosition.my;
				}

				// calculate the horizontal/vertical value of the arrow
				if (oThis._bHorizontalArrow) {
					// left or right arrow
					sKey = "top";

					if (oOpenerRect) {
						iZero = oOpenerRect.top - oPopRect.top;

						iVal = Math.round(iZero + oOpenerRect.height / 2);

						// if the position would exceed the ToolPopup's height
						iVal = iVal + iHalfArrow > oPopRect.height ? iVal - oThis.iArrowHeight : iVal;
					}
				} else {
					// up/down arrow
					sKey = "left";

					if (oOpenerRect) {
						iZero = oOpenerRect.left - oPopRect.left;
						if (iZero < 0) {
							iZero = oPopRect.width - oThis.iArrowHeight;
						}

						iVal = Math.round(iZero + oOpenerRect.width / 2);
						// if the position would exceed the ToolPopup's width
						iVal = iVal + iHalfArrow > oPopRect.width ? iVal - oThis.iArrowHeight : iVal;
					}
				}

				if (oOpenerRect) {
					iVal -= iHalfArrow;
				} else {
					iVal = oThis.iArrowHeight;
				}


				// set the corresponding classes
				var sClassAttr = "";
				if ($Arrow.hasClass("sapUiUx3TPNewArrow")) {
					sClassAttr = "sapUiUx3TPNewArrow sapUiUx3TPNewArrow";
				} else {
					sClassAttr = oThis.isInverted() ? "sapUiUx3TPArrow sapUiTPInverted sapUiUx3TPArrow" : "sapUiUx3TPArrow sapUiUx3TPArrow";
				}
				$Arrow.attr("class", sClassAttr + sArrowDir);

				if (sArrowDir === "Right") {
					var iWidth = oPopRect.width;
					// if the ToolPopup is invertable and it is being inverted use another
					// value since in such a case the padding is different for the arrow
					if (oThis.isInverted()) {
						iWidth += oThis.iArrowPaddingInverted;
					} else {
						iWidth += oThis.iArrowPadding;
					}

					oThis._bRTL = sap.ui.getCore().getConfiguration().getRTL();
					if (oThis._bRTL) {
						$Arrow.css("right", iWidth + "px");
					} else {
						$Arrow.css("left", iWidth + "px");
					}
				} else {
					$Arrow.css({
						"left": "",
						"right": ""
					});
				}

				iVal = parseInt(iVal, 10);
				iVal = iVal < 0 ? 0 : iVal;
				if (iVal > 0) {
					iVal -= 2; // due to some padding
					// only correct corresponding position if there is something to correct
					// otherwise the default position is used (via styling)
					$Arrow.css(sKey, iVal + "px");
				}
			};
			/**
			 * Handles the sapescape event, triggers closing of the ToolPopup.
			 *
			 * @private
			 */
			ToolPopup.prototype.onsapescape = function () {
				if (this.fireClose()) {
					this.close();
				}
			};

			/**
			 * This function is called when the Popup has been closed.
			 * It does not matter if it is closed through the "close"-function or through the autoClose-mechanism.
			 * Additionally it is necessary to restore the focus as if the ToolPopup was closed via "close()".
			 * If the corresponding suppress-parameter was given to "close" no focus will be restored.
			 *
			 * @param {jQuery.EventObject} oEvent
			 * @private
			 */
			var fnOnClosed = function (oEvent) {
				if (!this._bPreventRestoreFocus) {
					Popup.applyFocusInfo(this._oPreviousFocus);
				}

				// Not removing the content DOM leads to the  problem that control DOM with the same ID exists in two places if
				// the control is added to a different aggregation without the dialog being destroyed. In this special case the
				// RichTextEditor (as an example) renders a textarea-element and afterwards tells the TinyMCE component which ID
				// to use for rendering; since there are two elements with the same ID at that point, it does not work.
				// As the Dialog can only contain other controls, we can safely discard the DOM - we cannot do this inside
				// the Popup, since it supports displaying arbitrary HTML content.
				this.$().remove();

				this.fireClosed();
			};


			/**
			 * Closes the pop up.
			 * Can be called by the Shell when the pop up's button is clicked again; or by the application
			 * when the interaction in the pop up has been completed or canceled.
			 *
			 * @param {boolean} bPreventRestoreFocus
			 *         If set, the focus is NOT restored to the element that had the focus before the ToolPopup was opened.
			 *         This makes sense when the ToolPopup is closed programmatically from a different area of the application
			 *         (outside the ToolPopup) and the focus should not move aways from that place.
			 * @returns {sap.ui.ux3.ToolPopup}
			 * @public
			 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
			 */
			ToolPopup.prototype.close = function (bPreventRestoreFocus) {
				if (this.oPopup && this.oPopup.isOpen()) {
					if (this._sResizeID) {
						sap.ui.core.ResizeHandler.deregister(this._sResizeID);
						delete this._sResizeID;
					}

					this.oPopup.close(this.getCloseDuration());
					this._bPreventRestoreFocus = bPreventRestoreFocus;

				}
				return this;
			};

			/**
			 * Indicates whether the ToolPopup is currently enabled or not.
			 *
			 * Applications can't control the enabled state via a property. A ToolPopup is implicitly
			 * enabled depending on its <code>openState</code>. Descendant controls that honor the
			 * enabled state of their ancestors will appear disabled after the ToolPopup is closed.
			 *
			 * Since 1.13.1. Whether a dialog is regarded as "enabled" during the state transitions
			 * (OPENING, CLOSING) is not fully decided. Currently, it is enabled during the OPENING phase
			 * and disabled during the CLOSING phase. The only potential change would be to treat the
			 * OPENING phase as disabled as well. Applications should be prepared to receive events from
			 * "enabled" controls after they called open() on the dialog until close() is called on it.
			 * If the mentioned potential change should happen, the dialog will become enabled only
			 * after the transition to OPEN. Events from "enabled" children then can still only arrive
			 * between open() and close(), so applications that obey the previous rule should continue
			 * to work. Only end users or code that explicitly triggers pseudo user events would notice
			 * a difference. <br>
			 * A second aspect that might change is the visual behavior of the content: during the CLOSING
			 * phase it 'looks' enabled but in fact it is already disabled. This avoids unnecessary redraws
			 * for content that becomes hidden soon. Should this show to be confusing for end users, it might
			 * be changed.
			 *
			 * @since 1.13.1
			 * @returns {boolean}
			 * @public
			 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
			 */
			ToolPopup.prototype.getEnabled = function () {
				// assuming that a ToolPopup without a Popup can’t be open
				var eState = this.oPopup ? this.oPopup.getOpenState() : sap.ui.core.OpenState.CLOSED;

				//TODO the check for state OPENING is a compromise. Without that, the content of the dialog will render
				// in disabled state but will be enabled. As an alternative, the dialog could render again after OPEN is reached
				// and after switching to CLOSING (to properly reflect the changed enabled state in the descendants)
				return eState === sap.ui.core.OpenState.OPENING || eState === sap.ui.core.OpenState.OPEN;
			};

			ToolPopup.prototype.onsapenter = function (oEvent) {
				// See open-method
				var sInitFocus = this.getDefaultButton();
				var oFocusCtrl = sap.ui.getCore().byId(sInitFocus);

				// trigger the default button if it exists and is inside the Dialog
				if (sInitFocus && oFocusCtrl && jQuery.contains(this.getDomRef(), oFocusCtrl.getDomRef())) {
					// Okay, we have the control
					if (oFocusCtrl instanceof sap.ui.commons.Button) {
						var $FocusCtrl = oFocusCtrl.$();
						$FocusCtrl.click();
						$FocusCtrl.focus();
					}
				}

				oEvent.preventDefault();
				oEvent.stopPropagation();
			};

			ToolPopup.prototype.onBeforeRendering = function () {
				var sInitialFocusId = this.getInitialFocus();
				var sDefaultButtontId = this.getDefaultButton();
				this._bFocusSet = true;

				if (sInitialFocusId) {
					this.oPopup.setInitialFocusId(sInitialFocusId);
				} else if (sDefaultButtontId) {
					this.oPopup.setInitialFocusId(sDefaultButtontId);
				} else {
					this._bFocusSet = false;
				}

				this._bRTL = sap.ui.getCore().getConfiguration().getRTL();
			};

			ToolPopup.prototype._ensurePopup = function () {
				if (!this.oPopup) {
					this.oPopup = new Popup(this, false, true, false);
					this.oPopup.attachOpened(this._proxyOpened);
					this.oPopup.attachClosed(this._proxyClosed);

					var that = this;
					this.oPopup._applyPosition = function () {
						Popup.prototype._applyPosition.apply(that.oPopup, arguments);

						var of = that.oPopup._oLastPosition.of;
						if (!of) {
							// In case setPosition is called from the outside and the opener has
							// been removed, this leads to closing the ToolPopup instead of causing
							// an error
							that.oPopup.close();
						} else {
							var $of = jQuery.sap.byId(of.id);
							// only after an open popup the corresponding arrow can be determined
							// if the position was set manually
							if (that._bPositionSet) {
								// shell stuff should still use the left arrow
								if (!$of.hasClass("sapUiUx3ShellTool")) {
									that._my = that.oPopup._oLastPosition.my;
									that._at = that.oPopup._oLastPosition.at;
								}
							}
							fnSetArrow(that);
						}
					};
				}
				return this.oPopup;
			};

			var fnOnResize = function () {
				if (this.getContent().length) {
					// This fixes the height of the ToolPopup if the height exceeds the window height.
					// Maybe there is a Layout as content that changed its aggregation
					this._proxyFixSize();

					// If the height/width changed the Popup's position has to be fixed as well.
					// Setting the arrow isn't needed after that because it happens inside "_applyPosition"
					this.oPopup._applyPosition(this.oPopup._oLastPosition);
				}
			};

			/**
			 * Sets the position of the pop up, the same parameters as for sap.ui.core.Popup can be used.
			 *
			 * @public
			 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
			 */
			ToolPopup.prototype.setPosition = function () {
				this._ensurePopup();
				this.oPopup.setPosition.apply(this.oPopup, arguments);
				this._bPositionSet = true;

				fnCheckOpener(this);

				return this;
			};

			var fnChangeContent = function (that, sType) {
				if (sType === "content") {
					fnRenderContent(that);
				} else if (sType === "buttons") {
					fnRenderButtons(that);
				}

				// this fixes the height of the ToolPopup if the height exceeds the window height
				that._proxyFixSize();
				// If the height/width changed the Popup's position has to be fixed as well
				// Setting the arrow isn't needed after that because it happens inside "_applyPosition"
				that.oPopup._applyPosition(that.oPopup._oLastPosition);
			};

			var fnRenderContent = function (oThis) {
				var oContentDomRef = oThis.getDomRef("content");
				oContentDomRef.innerHTML = "";

				var aContent = oThis.getContent();
				var rm = sap.ui.getCore().createRenderManager();

				for (var i = 0; i < aContent.length; i++) {
					rm.renderControl(aContent[i]);
				}

				rm.flush(oContentDomRef, true);
				rm.destroy();
			};
			var fnRenderButtons = function (oThis) {
				var oButtons = oThis.getDomRef("buttons");
				var oSeparator = oThis.getDomRef("buttons-separator");
				var aButtons = oThis.getButtons();

				if (aButtons.length === 0) {
					jQuery(oButtons).addClass("sapUiUx3TPButtonRowHidden");
					jQuery(oSeparator).addClass("sapUiUx3TPButtonRowHidden");
				} else {
					jQuery(oButtons).removeClass("sapUiUx3TPButtonRowHidden");
					jQuery(oSeparator).removeClass("sapUiUx3TPButtonRowHidden");
					oButtons.innerHTML = "";
					var rm = sap.ui.getCore().createRenderManager();

					for (var i = 0; i < aButtons.length; i++) {
						rm.renderControl(aButtons[i]);
					}

					rm.flush(oButtons, true);
					rm.destroy();
				}
			};

			ToolPopup.prototype.addContent = function (oContent) {
				this.addAggregation("content", oContent, /* suppressInvalidate */true);

				if (this.isOpen()) {
					fnChangeContent(this, "content");
				}

				return this;
			};
			ToolPopup.prototype.insertContent = function (oContent, index) {
				this.insertAggregation("content", oContent, index, /* suppressInvalidate */true);

				if (this.isOpen()) {
					fnChangeContent(this, "content");
				}

				return this;
			};
			ToolPopup.prototype.removeContent = function (oContent) {
				this.removeAggregation("content", oContent, /* suppressInvalidate */true);

				if (this.isOpen()) {
					fnChangeContent(this, "content");
				}

				return this;
			};
			ToolPopup.prototype.addButton = function (oButton) {
				this.addAggregation("buttons", oButton, /* suppressInvalidate */true);

				if (this.isOpen()) {
					fnChangeContent(this, "buttons");
				}

				return this;
			};
			ToolPopup.prototype.insertButton = function (oButton, index) {
				this.insertAggregation("buttons", oButton, index, /* suppressInvalidate */true);

				if (this.isOpen()) {
					fnChangeContent(this, "buttons");
				}

				return this;
			};
			ToolPopup.prototype.removeButton = function (oButton) {
				this.removeAggregation("button", oButton, /* suppressInvalidate */true);

				if (this.isOpen()) {
					fnChangeContent(this, "buttons");
				}

				return this;
			};

			/**
			 * This updates the instance's parameter if the ToolPopup is inverted per default
			 *
			 * @private
			 */
			var fnUpdateThemeInverted = function (oThis) {
				var sParam = "sapUiUx3ToolPopupInverted";

				sParam = Parameters.get(sParam);
				oThis._bThemeInverted = sParam === "true";
			};

			/**
			 * @private
			 */
			ToolPopup.prototype.onThemeChanged = function () {
				fnUpdateThemeInverted(this);
			};

			/**
			 * This checks if the ToolPopup is inverted. This depends on the parameter
			 * 'inverted' and the LESS-parameter 'sapUiUx3ToolPopupInverted' in the current
			 * theme.
			 *
			 * @returns {boolean} Whether the ToolPopup is inverted
			 * @private
			 */
			ToolPopup.prototype.isInverted = function () {
				fnUpdateThemeInverted(this);
				return this.getInverted() && this._bThemeInverted;
			};

			/**
			 * This is just a forward to the Popup's function (sap.ui.core.Popup.setAutoCloseAreas)
			 * with the same functionality.
			 *
			 * @param {Element[]} aAutoCloseAreas
			 * @public
			 * @since 1.19.0
			 */
			ToolPopup.prototype.setAutoCloseAreas = function (aAutoCloseAreas) {
				this._ensurePopup();
				return this.oPopup.setAutoCloseAreas(aAutoCloseAreas);
			};

			/**
			 * Adds an ID to the Popup that should be focusable as well when using <code>autoclose</code>.
			 * Chaining is only possible if a valid type (string) is given.
			 *
			 * @param {sap.ui.core.string} [sID] ID of the corresponding element that should be focusable as well
			 * @since 1.19.0
			 * @public
			 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
			 */
			ToolPopup.prototype.addFocusableArea = function (sID) {
				this._ensurePopup();

				if (typeof (sID) === "string") {
					// channelId & eventId are mandatory dummy values
					this.oPopup._addFocusableArea("channelId", "eventId", {
						id: sID
					});
					return this;
				} else {
					jQuery.sap.log.error("Wrong type of focusable area ID - string expected", "", "sap.ui.ux3.ToolPopup");
				}
			};

			/**
			 * Removes an ID to the Popup that should be focusable as well when using <code>autoclose</code>.
			 * Chaining is only possible if a valid type (string) is given.
			 *
			 * @param {sap.ui.core.string} [sID] ID of the corresponding element
			 * @since 1.19.0
			 * @public
			 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
			 */
			ToolPopup.prototype.removeFocusableArea = function (sID) {
				this._ensurePopup();

				if (typeof (sID) === "string") {
					// channelId & eventId are mandatory dummy values
					this.oPopup._removeFocusableArea("channelId", "eventId", {
						id: sID
					});
					return this;
				} else {
					jQuery.sap.log.error("Wrong type of focusable area ID - string expected", "", "sap.ui.ux3.ToolPopup");
				}
			};
		}());

		/**
		 * Overriden setter for the Icon.
		 *
		 * @param {string} sIcon
		 * @returns {sap.ui.ux3.ToolPopup}
		 */
		ToolPopup.prototype.setIcon = function (sIcon) {
			this.setProperty("icon", sIcon, true); // rerendering makes no sense, as this icon is not rendered by the ToolPopup
			this.fireIconChanged(); // tell other interested parties to update the icon
			return this;
		};

		/**
		 * Overriden setter for the icon hover.
		 *
		 * @param {string} sIconHover
		 * @returns {sap.ui.ux3.ToolPopup}
		 */
		ToolPopup.prototype.setIconHover = function (sIconHover) {
			this.setProperty("iconHover", sIconHover, true); // rerendering makes no sense, as this icon is not rendered by the ToolPopup
			this.fireIconChanged(); // tell other interested parties to update the icon
			return this;
		};

		/**
		 * Overriden setter for the selected icon.
		 * @param {string} sIconSelected
		 * @returns {sap.ui.ux3.ToolPopup}
		 */
		ToolPopup.prototype.setIconSelected = function (sIconSelected) {
			this.setProperty("iconSelected", sIconSelected, true); // rerendering makes no sense, as this icon is not rendered by the ToolPopup
			this.fireIconChanged(); // tell other interested parties to update the icon
			return this;
		};

		/**
		 * Gets the selected icon or icon hover.
		 *
		 * @returns {object}
		 */
		ToolPopup.prototype.getIconSelected = function () {
			return this.getProperty("iconSelected") || this.getProperty("iconHover"); // implement the documented fallback
		};

		/**
		 * Overriden setter for the max width internally.
		 *
		 * @param sMaxWidth
		 */
		ToolPopup.prototype.setMaxWidth = function (sMaxWidth) {
			var pattern = /[0-9]+px/;

			if (pattern.test(sMaxWidth)) {
				this.setProperty("maxWidth", sMaxWidth);
			} else {
				jQuery.sap.log.error("Only values in pixels are possible", "", "sap.ui.ux3.ToolPopup");
			}
		};

		return ToolPopup;

	}, /* bExport= */ true);

}; // end of sap/ui/ux3/ToolPopup.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ExactBrowser') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ExactBrowser.
jQuery.sap.declare('sap.ui.ux3.ExactBrowser'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Button'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Menu'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ExactBrowser",['jquery.sap.global', 'sap/ui/commons/Button', 'sap/ui/commons/Menu', 'sap/ui/core/Control', './ExactAttribute', './ExactList', './library'],
	function(jQuery, Button, Menu, Control, ExactAttribute, ExactList, library) {
	"use strict";


	
	/**
	 * Constructor for a new ExactBrowser.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Attribute browse area used within the Exact pattern. The main benefit of this control is the high flexibility when large data amounts shall be displayed
	 * in the form of structured data sets with a high or low interdependency level. From lists - which can be nested according to the defined attributes - the user can choose
	 * entries and thereby trigger the display of further information, depending on the chosen entry/entries (multiple selection supported).
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.ExactBrowser
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ExactBrowser = Control.extend("sap.ui.ux3.ExactBrowser", /** @lends sap.ui.ux3.ExactBrowser.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * Title text in the list area of the Exact Browser. The title is not shown when the property showTopList is set to false.
			 */
			title : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * Title text in the header of the Exact Browser.
			 */
			headerTitle : {type : "string", group : "Misc", defaultValue : null},
	
			/**
			 * The order how the sublists of the top level list should be displayed.
			 * @since 1.7.1
			 */
			topListOrder : {type : "sap.ui.ux3.ExactOrder", defaultValue : sap.ui.ux3.ExactOrder.Select},
	
			/**
			 * Enables the close icons of the displayed lists.
			 */
			enableListClose : {type : "boolean", group : "Misc", defaultValue : false},
	
			/**
			 * The height of the list area in px.
			 */
			listHeight : {type : "int", group : "Appearance", defaultValue : 290},
	
			/**
			 * Whether the header area of the ExactBrowser should be shown.
			 */
			showHeader : {type : "boolean", group : "Misc", defaultValue : false},
	
			/**
			 * Whether the top list of the ExactBrowser should be shown. When the property is set to false the
			 * application must ensure to select top level attributes appropriately.
			 * @since 1.7.0
			 */
			showTopList : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Whether the reset functionality should be available in the header area.
			 */
			enableReset : {type : "boolean", group : "Misc", defaultValue : true},
	
			/**
			 * Whether the save button should be available in the header area.
			 * @since 1.9.2
			 */
			enableSave : {type : "boolean", group : "Misc", defaultValue : false},
	
			/**
			 * Specifies the width of the top list in pixels. The value must be between 70 and 500.
			 * @since 1.7.0
			 */
			topListWidth : {type : "int", group : "Misc", defaultValue : 168}
		},
		defaultAggregation : "attributes",
		aggregations : {
	
			/**
			 * The attributes which shall be available.
			 */
			attributes : {type : "sap.ui.ux3.ExactAttribute", multiple : true, singularName : "attribute"}, 
	
			/**
			 * Menu with options. The menu can not used when the property showTopList is set to false.
			 */
			optionsMenu : {type : "sap.ui.commons.Menu", multiple : false}, 
	
			/**
			 * Controls managed by this ExactBrowser
			 */
			controls : {type : "sap.ui.core.Control", multiple : true, singularName : "control", visibility : "hidden"}, 
	
			/**
			 * root attribute managed by this ExactBrowser
			 */
			rootAttribute : {type : "sap.ui.core.Element", multiple : false, visibility : "hidden"}
		},
		associations : {
	
			/**
			 * The successor control of the Exact Browser. The id of this control is used in the ARIA description of the control.
			 */
			followUpControl : {type : "sap.ui.core.Control", multiple : false}
		},
		events : {
	
			/**
			 * Event is fired when an attribute is selected or unselected.
			 */
			attributeSelected : {
				parameters : {
	
					/**
					 * The attribute which was selected or unselected recently
					 */
					attribute : {type : "sap.ui.ux3.ExactAttribute"}, 
	
					/**
					 * Array of all selected ExactAttributes
					 */
					allAttributes : {type : "object"}
				}
			}, 
	
			/**
			 * Event is fired when an attribute is selected or unselected.
			 */
			save : {}
		}
	}});
	
	
	
	
	
	(function() {
		
		/**
		 * Does the setup when the ExactBrowser is created.
		 * @private
		 */
		ExactBrowser.prototype.init = function(){
			var that = this;
			
			this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	
			this._rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
	
			//Create a root node for the attributes tree
			this._attributeRoot = new ExactAttribute();
			this.setAggregation("rootAttribute",this._attributeRoot);
			//Init the used subcontrols
			this._rootList = new ExactList(this.getId() + "-rootlist");
			this._rootList.setData(this._attributeRoot);
			this.addAggregation("controls", this._rootList);
	
			this._resetButton = new Button(this.getId() + "-RstBtn", {text: this._rb.getText("EXACT_BRWSR_RESET"), lite: true});
			this._resetButton.addStyleClass("sapUiUx3ExactBrwsrReset");
			this.addAggregation("controls", this._resetButton);
			this._resetButton.attachPress(function(){
				that.reset();
			});
	
			this._saveButton = new Button(this.getId() + "-SvBtn", {text: this._rb.getText("EXACT_BRWSR_SAVE"), lite: true});
			this._saveButton.addStyleClass("sapUiUx3ExactBrwsrSave");
			this.addAggregation("controls", this._saveButton);
			this._saveButton.attachPress(function(){
				that.fireSave();
			});
	
			this._rootList.attachAttributeSelected(function(oEvent){
				that.fireAttributeSelected({attribute: oEvent.getParameter("attribute"), allAttributes: oEvent.getParameter("allAttributes")});
			});
			this._rootList.attachEvent("_headerPress", function(oEvent){
				var oMenu = that.getOptionsMenu();
				if (oMenu) {
					var oDomRef = oEvent.getParameter("domRef");
					oMenu.open(oEvent.getParameter("keyboard"), oDomRef, sap.ui.core.Popup.Dock.BeginTop, sap.ui.core.Popup.Dock.BeginBottom, oDomRef);
				}
			});
		};
	
	
		/**
		 * Does all the cleanup when the ExactBrowser is to be destroyed.
		 * Called from Element's destroy() method.
		 * @private
		 */
		ExactBrowser.prototype.exit = function(){
			this._rootList.destroy();
			this._attributeRoot.destroy();
			this._rootList = null;
			this._attributeRoot = null;
			this._resetButton = null;
			this._saveButton = null;
			this._saveDialog = null;
			this._saveTextField = null;
			this._rb = null;
		};
		
		
		/**
		 * Called when the theme is changed.
		 * @private
		 */
		ExactBrowser.prototype.onThemeChanged = function(oEvent) {
			if (this.getDomRef()) {
				this.invalidate();
			}
		};
	
	
		//*** Overridden API functions ***
	
		ExactBrowser.prototype.getTitle = function() {
			return this._rootList.getTopTitle();
		};
	
	
		ExactBrowser.prototype.setTitle = function(sTitle) {
			this._rootList.setTopTitle(sTitle);
			return this;
		};
		
		
		ExactBrowser.prototype.setTopListOrder = function(sListOrder) {
			this.setProperty("topListOrder", sListOrder, true);
			this._attributeRoot.setListOrder(sListOrder);
			return this;
		};
		
		
		ExactBrowser.prototype.getTopListWidth = function() {
			return this._attributeRoot.getWidth();
		};
	
	
		ExactBrowser.prototype.setTopListWidth = function(iWidth) {
			this._attributeRoot.setWidth(iWidth);
			return this;
		};
	
	
		ExactBrowser.prototype.getHeaderTitle = function() {
			var sTitle = this.getProperty("headerTitle");
			return sTitle ? sTitle : this._rb.getText("EXACT_BRWSR_TITLE");
		};
	
	
		ExactBrowser.prototype.getEnableListClose = function() {
			return this._rootList.getShowClose();
		};
	
	
		ExactBrowser.prototype.setEnableListClose = function(bEnableListClose) {
			this._rootList.setShowClose(bEnableListClose);
			return this;
		};
	
	
		ExactBrowser.prototype.getListHeight = function() {
			return this._rootList.getTopHeight();
		};
	
	
		ExactBrowser.prototype.setListHeight = function(iListHeight) {
			this._rootList.setTopHeight(iListHeight);
			return this;
		};
	
	
		ExactBrowser.prototype.getAttributes = function() {
			return this._attributeRoot.getAttributesInternal();
		};
	
	
		ExactBrowser.prototype.insertAttribute = function(oAttribute, iIndex) {
			this._attributeRoot.insertAttribute(oAttribute, iIndex);
			return this;
		};
	
	
		ExactBrowser.prototype.addAttribute = function(oAttribute) {
			this._attributeRoot.addAttribute(oAttribute);
			return this;
		};
	
	
		ExactBrowser.prototype.removeAttribute = function(vElement) {
			return this._attributeRoot.removeAttribute(vElement);
		};
	
	
		ExactBrowser.prototype.removeAllAttributes = function() {
			return this._attributeRoot.removeAllAttributes();
		};
	
	
		ExactBrowser.prototype.indexOfAttribute = function(oAttribute) {
			return this._attributeRoot.indexOfAttribute(oAttribute);
		};
	
	
		ExactBrowser.prototype.destroyAttributes = function() {
			this._attributeRoot.destroyAttributes();
			return this;
		};
	
	

		/**
		 * Deselects all currently selected attributes and closes all attribute lists.
		 *
		 * @type void
		 * @public
		 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
		ExactBrowser.prototype.reset = function() {
			this._rootList._closeAll();
		};
	
	
		//*** Private helper functions ***
		
		ExactBrowser.prototype.hasOptionsMenu = function() {
			return !!this.getOptionsMenu();
		};
	
	/*	//Closes the save dialog and triggers the save event
		function doSave(oExactBrowser, bSkip) {
			oExactBrowser._saveDialog.close();
			if(!bSkip){
				alert("Save: "+oExactBrowser._saveTextField.getValue());
			}
		}
	
	
		//Opens the save dialog
		function openSaveDialog(oExactBrowser) {
			if(!oExactBrowser._saveDialog){
				jQuery.sap.require("sap.ui.ux3.ToolPopup");
				jQuery.sap.require("sap.ui.commons.TextField");
				jQuery.sap.require("sap.ui.commons.Label");
				oExactBrowser._saveTextField = new sap.ui.commons.TextField(oExactBrowser.getId()+"-SvDlgTf");
				var label = new sap.ui.commons.Label({text: oExactBrowser._rb.getText("EXACT_BRWSR_DLG_LABEL")}).setLabelFor(oExactBrowser._saveTextField);
				oExactBrowser._saveDialog = new sap.ui.ux3.ToolPopup(oExactBrowser.getId()+"-SvDlg", {
					content:[label, oExactBrowser._saveTextField],
					buttons: [
						new sap.ui.commons.Button(oExactBrowser.getId()+"-SvDlgSvBtn", {
							text: oExactBrowser._rb.getText("EXACT_BRWSR_DLG_SAVE"),
							press: function(){
								doSave(oExactBrowser);
							}
						}),
						new sap.ui.commons.Button(oExactBrowser.getId()+"-SvDlgCnclBtn", {
							text: oExactBrowser._rb.getText("EXACT_BRWSR_DLG_CANCEL"),
							press: function(){
								doSave(oExactBrowser, true);
							}
						})
					]
				});
				oExactBrowser._saveDialog.addStyleClass("sapUiUx3ExactBrwsrSaveDlg");
				oExactBrowser.addAggregation("controls", oExactBrowser._saveDialog);
			}
			oExactBrowser._saveDialog.setPosition(sap.ui.core.Popup.Dock.EndTop, sap.ui.core.Popup.Dock.EndBottom, oExactBrowser._saveButton.getDomRef(), "0 13", "none");
			oExactBrowser._saveDialog.open();
		}
	*/
	
	}());

	return ExactBrowser;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ExactBrowser.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.Feed') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.Feed.
jQuery.sap.declare('sap.ui.ux3.Feed'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.DropdownBox'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.MenuButton'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.SearchField'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.ToggleButton'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/Feed",['jquery.sap.global', 'sap/ui/commons/DropdownBox', 'sap/ui/commons/MenuButton', 'sap/ui/commons/SearchField', 'sap/ui/commons/ToggleButton', 'sap/ui/core/Control', './Feeder', './library'],
	function(jQuery, DropdownBox, MenuButton, SearchField, ToggleButton, Control, Feeder, library) {
	"use strict";


	
	/**
	 * Constructor for a new Feed.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A container control representing a full feed page, including feeder and updates.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.2. 
	 * The whole Feed/Feeder API is still under discussion, significant changes are likely. Especially text presentation (e.g. @-references and formatted text) is not final. Also the Feed model topic is still open.
	 * @alias sap.ui.ux3.Feed
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Feed = Control.extend("sap.ui.ux3.Feed", /** @lends sap.ui.ux3.Feed.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * The path to the thumbnail image used for the feeder
			 */
			feederThumbnailSrc : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
	
			/**
			 * The sender of the feeder
			 */
			feederSender : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Specifies whether the feed shall be in live mode
			 */
			live : {type : "boolean", group : "Behavior", defaultValue : true},
	
			/**
			 * Title text of the Feed. If no text is entered "FEED" is displayed.
			 */
			title : {type : "string", group : "Data", defaultValue : null}
		},
		aggregations : {
	
			/**
			 * Items of the filter
			 */
			filterItems : {type : "sap.ui.core.ListItem", multiple : true, singularName : "filterItem", bindable : "bindable"}, 
	
			/**
			 * The chunks
			 */
			chunks : {type : "sap.ui.ux3.FeedChunk", multiple : true, singularName : "chunk", bindable : "bindable"}, 
	
			/**
			 * MenuItems to open when the tool button is clicked by the user
			 */
			toolsMenuItems : {type : "sap.ui.commons.MenuItem", multiple : true, singularName : "toolsMenuItem", bindable : "bindable"}
		},
		events : {
	
			/**
			 * Event is fired when the filter is changed
			 */
			filterChange : {
				parameters : {
	
					/**
					 * The new/changed value of the filter
					 */
					newValue : {type : "string"}
				}
			}, 
	
			/**
			 * Event is fired when the search function on SearchField is triggered
			 */
			search : {
				parameters : {
	
					/**
					 * The search query
					 */
					query : {type : "string"}
				}
			}, 
	
			/**
			 * Event is fired when a new chunk is added
			 */
			chunkAdded : {
				parameters : {
	
					/**
					 * New chunk
					 */
					chunk : {type : "sap.ui.ux3.FeedChunk"}
				}
			}, 
	
			/**
			 * Event is fired when an item from the tools MenuButton was selected
			 */
			toolsItemSelected : {
				parameters : {
	
					/**
					 * The Id of the selected item
					 */
					itemId : {type : "string"}, 
	
					/**
					 * The selected item
					 */
					item : {type : "sap.ui.unified.MenuItemBase"}
				}
			}, 
	
			/**
			 * Event is fired when the live mode has changed
			 */
			toggleLive : {
				parameters : {
	
					/**
					 * Current live indicator
					 */
					live : {type : "boolean"}
				}
			}
		}
	}});
	
	
	///**
	// * This file defines behavior for the control,
	// */
	
	Feed.prototype.init = function(){
	
		this.rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
		
		this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	
		// init sub-controls
		this.oFeeder = new Feeder( this.getId() + '-Feeder', {
			type: sap.ui.ux3.FeederType.Medium
		}).setParent(this);
		this.oFeeder.attachEvent('submit', this.handleFeederSubmit, this); // attach event this way to have the right this-reference in handler
	
		this.oLiveButton = new ToggleButton( this.getId() + '-liveButton', {
			text: this.rb.getText('FEED_LIVE'),
			pressed: this.getLive(), // initialize with default value because setter not called for it
			lite: true
		}).setParent(this);
		this.oLiveButton.attachEvent('press', this.handleLiveButtonPress, this); // attach event this way to have the right this-reference in handler
	
		this.oFilter = new DropdownBox( this.getId() + '-filter').setParent(this);
		this.oFilter.attachEvent('change', this.handleFilterChange, this); // attach event this way to have the right this-reference in handler
	
		this.oSearchField = new SearchField( this.getId() + '-search', {
			enableListSuggest: false
		}).setParent(this);
		this.oSearchField.attachEvent('search', this.handleSearchFieldSearch, this); // attach event this way to have the right this-reference in handler
	
	};
	
	/*
	 * create menu button without items. The items are added later
	 */
	Feed.prototype.initToolsButton = function(){
	
		if (!this.oToolsButton) {
			this.oToolsButton = new MenuButton( this.getId() + '-toolsButton', {
				tooltip: this.rb.getText('FEED_TOOLS'),
				lite: true,
				menu: new sap.ui.commons.Menu(this.getId() + '-toolsMenu')
			}).setParent(this);
			this.oToolsButton.attachEvent('itemSelected', this.handleLtoolsButtonSelected, this); // attach event this way to have the right this-reference in handler
	
			var sIcon = sap.ui.core.theming.Parameters.get('sap.ui.ux3.Feed:sapUiFeedToolsIconUrl');
			var sIconHover = sap.ui.core.theming.Parameters.get('sap.ui.ux3.Feed:sapUiFeedToolsIconHoverUrl');
			var sThemeModuleName = "sap.ui.ux3.themes." + sap.ui.getCore().getConfiguration().getTheme();
			if (sIcon) {
				this.oToolsButton.setProperty('icon', jQuery.sap.getModulePath(sThemeModuleName, sIcon), true);
			}
			if (sIconHover) {
				this.oToolsButton.setProperty('iconHovered', jQuery.sap.getModulePath(sThemeModuleName, sIconHover), true);
			}
		}
	
	};
	
	Feed.prototype.exit = function(){
	
		if (this.oFeeder) {
			this.oFeeder.destroy();
			delete this.oFeeder;
		}
		if (this.oLiveButton) {
			this.oLiveButton.destroy();
			delete this.oLiveButton;
		}
		if (this.oToolsButton) {
			this.oToolsButton.destroy();
			delete this.oToolsButton;
		}
		if (this.oFilter) {
			this.oFilter.destroy();
			delete this.oFilter;
		}
		if (this.oSearchField) {
			this.oSearchField.destroy();
			delete this.oSearchField;
		}
		this.rb = undefined;
	
	};
	
	/**
	 * Handler for feeder submit event
	 *
	 * @private
	 */
	Feed.prototype.handleFeederSubmit = function(oEvent){
	
		var oDate = new Date();
	//	var sDate = String(oDate.getFullYear()) + String(oDate.getMonth()) + String(oDate.getDate()) + String(oDate.getHours()) + String(oDate.getMinutes()) + String(oDate.getSeconds());
		var sDate = String(oDate);
	
		var oNewChunk = new sap.ui.ux3.FeedChunk(this.getId() + '-new-' + this.getChunks().length, {
			text: oEvent.getParameter('text'),
			commentChunk: false,
			deletionAllowed: true,
			timestamp: sDate,
			sender: this.getFeederSender(),
			thumbnailSrc: this.getFeederThumbnailSrc()
		});
	
		// new chunks are inserted at the top
		this.insertChunk(oNewChunk, 0);
		this.fireChunkAdded({chunk: oNewChunk});
	
	};
	
	/*
	 * overwrite of setLive
	 */
	Feed.prototype.setLive = function(bLive) {
		this.setProperty("live", bLive, true); //no re-rendering because only ToggleButton is changed
	
		if (this.oLiveButton) {
			// update ToggleButton
			this.oLiveButton.setPressed(bLive);
		}
		return this;
	};
	
	/**
	 * Handler for live-button press
	 *
	 * @private
	 */
	Feed.prototype.handleLiveButtonPress = function(oEvent){
	
		var bPressed = oEvent.getParameter("pressed");
	
		this.setProperty("live", bPressed, true); //no re-rendering because ToggleButton is already changed
		this.fireToggleLive({live: bPressed});
	
	};
	
	/**
	 * Handler for tools menu button item selection
	 *
	 * @private
	 */
	Feed.prototype.handleLtoolsButtonSelected = function(oEvent){
	
		// just forward event
		this.fireToolsItemSelected(oEvent.mParameters);
	
	};
	
	/**
	 * Handler for filter change
	 *
	 * @private
	 */
	Feed.prototype.handleFilterChange = function(oEvent){
	
		// just forward event
		this.fireFilterChange(oEvent.mParameters);
	
	};
	
	/**
	 * Handler for search field
	 *
	 * @private
	 */
	Feed.prototype.handleSearchFieldSearch = function(oEvent){
	
		// just forward event
		this.fireSearch(oEvent.mParameters);
	
	};
	
	/*
	 * Overwrite generated function
	 */
	Feed.prototype.setFeederThumbnailSrc = function(sFeederThumbnailSrc) {
	
		this.setProperty("feederThumbnailSrc", sFeederThumbnailSrc, true); // no rerendering, only feeder is changed
		this.oFeeder.setThumbnailSrc(sFeederThumbnailSrc);
		return this;
	
	};
	
	Feed.prototype.setLive = function(bLive) {
	
		this.setProperty("live", bLive, true); // no rerendering, only button is changed
		this.oLiveButton.setPressed(bLive);
		return this;
	
	};
	
	// connect toolsMenuItems to MenuButtons menu
	Feed.prototype.getToolsMenuItems = function() {
	
		if (this.oToolsButton) {
			// as parent of items is the menu use menus aggregation
			return this.oToolsButton.getMenu().getItems();
		}
	
	};
	
	Feed.prototype.insertToolsMenuItem = function(oToolsMenuItem, iIndex) {
	
		this.initToolsButton();
		// as parent of items is the menu use menus aggregation
		this.oToolsButton.getMenu().insertItem(oToolsMenuItem, iIndex);
		return this;
	
	};
	
	Feed.prototype.addToolsMenuItem = function(oToolsMenuItem) {
	
		this.initToolsButton();
		// as parent of items is the menu use menus aggregation
		this.oToolsButton.getMenu().addItem(oToolsMenuItem);
		return this;
	
	};
	
	Feed.prototype.removeToolsMenuItem = function(vToolsMenuItem) {
	
		if (this.oToolsButton) {
			// as parent of items is the menu use menus aggregation
			return this.oToolsButton.getMenu().removeItem(vToolsMenuItem);
		}
	
	};
	
	Feed.prototype.removeAllToolsMenuItems = function() {
	
		if (this.oToolsButton) {
			// as parent of items is the menu use menus aggregation
			return this.oToolsButton.getMenu().removeAllItems();
		}
	
	};
	
	Feed.prototype.indexOfToolsMenuItem = function(oToolsMenuItem) {
	
		if (this.oToolsButton) {
			// as parent of items is the menu use menus aggregation
			return this.oToolsButton.getMenu().indexOfItem(oToolsMenuItem);
		}
	
	};
	
	Feed.prototype.destroyToolsMenuItems = function() {
	
		if (this.oToolsButton) {
			// as parent of items is the menu use menus aggregation
			this.oToolsButton.getMenu().destroyItems();
		}
	
		return this;
	
	};
	
	Feed.prototype.bindToolsMenuItems = function(sPath, oTemplate, oSorter, aFilters) {
	
		this.initToolsButton();
		// as parent of items is the menu use menus aggregation
		this.oToolsButton.getMenu().bindItems(sPath, oTemplate, oSorter, aFilters);
	
		return this;
	
	};
	
	Feed.prototype.unbindToolsMenuItems = function() {
	
		if (this.oToolsButton) {
			this.oToolsButton.getMenu().unbindItems();
		}
	
		return this;
	
	};
	
	// connect filterItems to filter
	Feed.prototype.getFilterItems = function() {
	
		return this.oFilter.getItems();
	
	};
	
	Feed.prototype.insertFilterItem = function(oFilterItem, iIndex) {
	
		this.oFilter.insertItem(oFilterItem, iIndex);
		return this;
	
	};
	
	Feed.prototype.addFilterItem = function(oFilterItem) {
	
		this.oFilter.addItem(oFilterItem);
		return this;
	
	};
	
	Feed.prototype.removeFilterItem = function(vFilterItem) {
	
		return this.oFilter.removeItem(vFilterItem);
	
	};
	
	Feed.prototype.removeAllFilterItems = function() {
	
		return this.oFilter.removeAllItems();
	
	};
	
	Feed.prototype.indexOfFilterItem = function(oFilterItem) {
	
		return this.oFilter.indexOfItem(oFilterItem);
	
	};
	
	Feed.prototype.destroyFilterItems = function() {
	
		this.oFilter.destroyItems();
	
		return this;
	
	};
	
	Feed.prototype.bindFilterItems = function(sPath, oTemplate, oSorter, aFilters) {
	
		this.oFilter.bindItems(sPath, oTemplate, oSorter, aFilters);
	
		return this;
	
	};
	
	Feed.prototype.unbindFilterItems = function() {
	
		this.oFilter.unbindItems();
	
		return this;
	
	};
	

	return Feed;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/Feed.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.FeedChunk') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.FeedChunk.
jQuery.sap.declare('sap.ui.ux3.FeedChunk'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.MenuButton'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/FeedChunk",['jquery.sap.global', 'sap/ui/commons/MenuButton', 'sap/ui/core/Control', 'sap/ui/core/theming/Parameters', './Feeder', './library'],
	function(jQuery, MenuButton, Control, Parameters, Feeder, library) {
	"use strict";


	
	/**
	 * Constructor for a new FeedChunk.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The unit that is embedded - single-wise or in a multiple way - into a Feed control.
	 * The control provides a set of properties for text, sender information, time stamp,
	 * comments, and functions such as flagging the entry to be favorite, shared, or flagged.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.2. 
	 * The whole Feed/Feeder API is still under discussion, significant changes are likely. Especially text presentation (e.g. @-references and formatted text) is not final. Also the Feed model topic is still open.
	 * @alias sap.ui.ux3.FeedChunk
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var FeedChunk = Control.extend("sap.ui.ux3.FeedChunk", /** @lends sap.ui.ux3.FeedChunk.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * URL to the thumbnail image.
			 */
			thumbnailSrc : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
	
			/**
			 * The FeedChunk text. @References are supported.
			 */
			text : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Sender of the chunk
			 */
			sender : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Format is ISO 8601 YYYY-MM-DDThh:mm:ss.sZ, Z meaning the time is in UTC time zone
			 */
			timestamp : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Flag if the deletion of the chunk shall be allowed
			 */
			deletionAllowed : {type : "boolean", group : "Behavior", defaultValue : false},
	
			/**
			 * This flag changes a FeedChunk into a CommentChunk. In this case, it can not have own comments,
			 * furthermore it must be assigned to a FeedChunk.
			 * @deprecated Since version 1.4.0. 
			 * Not longer used. If a chunk is a comment is determined from hierarchy. If the parent is a chunk it's automatically a comment.
			 */
			commentChunk : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true},
	
			/**
			 * URL to the thumbnail image for the comment feeder.
			 * This property is optional if the chunk is a sub-control of a feed control. In this case the value of the feed control is used if it's not set. So it must be only set once on the feed control.
			 */
			feederThumbnailSrc : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
	
			/**
			 * Sender for the comment feeder
			 * This property is optional if the chunk is a sub-control of a feed control. In this case the value of the feed control is used if it's not set. So it must be only set once on the feed control.
			 */
			feederSender : {type : "string", group : "Data", defaultValue : null},
	
			/**
			 * Defines whether the entry is flagged. This property is not supported for comment chunks.
			 */
			flagged : {type : "boolean", group : "Data", defaultValue : false},
	
			/**
			 * Defines whether the entry shall be displayed as favorite. This property is not supported for comment chunks.
			 */
			favorite : {type : "boolean", group : "Data", defaultValue : null},
	
			/**
			 * Defines whether the entry shall be shared. This property is not supported for comment chunks.
			 */
			shared : {type : "boolean", group : "Data", defaultValue : false},
	
			/**
			 * If true the flag action is enabled.
			 */
			enableFlag : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * If true the share action is enabled.
			 */
			enableShare : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * If true the comment action is enabled.
			 */
			enableComment : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * If true the inspect action is enabled.
			 */
			enableInspect : {type : "boolean", group : "Appearance", defaultValue : true},
	
			/**
			 * If true the favorite action is enabled.
			 */
			enableFavorite : {type : "boolean", group : "Appearance", defaultValue : true}
		},
		aggregations : {
	
			/**
			 * Comments on this chunk
			 */
			comments : {type : "sap.ui.ux3.FeedChunk", multiple : true, singularName : "comment", bindable : "bindable"}, 
	
			/**
			 * MenuItems to open when there is a click on the action menu button
			 */
			actionMenuItems : {type : "sap.ui.commons.MenuItem", multiple : true, singularName : "actionMenuItem", bindable : "bindable"}
		},
		events : {
	
			/**
			 * Event is fired when the deletion button is pressed.
			 */
			deleted : {}, 
	
			/**
			 * Event is raised when a comment is added to the entry. This event is not supported for comment chunks.
			 */
			commentAdded : {
				parameters : {
	
					/**
					 * New comment chunk
					 */
					comment : {type : "sap.ui.ux3.FeedChunk"}
				}
			}, 
	
			/**
			 * Event is raised when the user clicks to flag the entry. This event is not supported for comment chunks.
			 */
			toggleFlagged : {
				parameters : {
	
					/**
					 * Current flagged state
					 */
					flagged : {type : "boolean"}
				}
			}, 
	
			/**
			 * Event is fired when the thumbnail or the name of the sender is clicked.
			 */
			senderClicked : {}, 
	
			/**
			 * Click on a @-reference
			 */
			referenceClicked : {
				parameters : {
	
					/**
					 * Text of the @-reference
					 */
					text : {type : "string"}
				}
			}, 
	
			/**
			 * Event is raised when the user clicks to set the entry as favorite. This event is not supported for comment chunks.
			 */
			toggleFavorite : {
				parameters : {
	
					/**
					 * Current favorite state
					 */
					favorite : {type : "boolean"}
				}
			}, 
	
			/**
			 * Event is fired when the inspect button was pressed
			 */
			inspect : {}, 
	
			/**
			 * Event is raised when the user clicks to share the entry. This event is not supported for comment chunks.
			 */
			toggleShared : {
				parameters : {
	
					/**
					 * Current shared state
					 */
					shareed : {type : "boolean"}
				}
			}, 
	
			/**
			 * Event is fired when an item from the action menu button was selected.
			 */
			actionItemSelected : {
				parameters : {
	
					/**
					 * The Id of the selected item
					 */
					itemId : {type : "string"}, 
	
					/**
					 * The selected item
					 */
					item : {type : "sap.ui.unified.MenuItemBase"}
				}
			}
		}
	}});
	
	
	///**
	// * This file defines behavior for the control,
	// */
	
	FeedChunk.prototype.init = function(){
	   this.maxComments = 2; // max. number of comments displayed initially
	   this.allComments = false; // initially render only maxComments
	   this.rb = sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");
	   this.expanded = false;
	};
	
	FeedChunk.prototype.initCommentFeeder = function(){
	
		// create comment feeder if needed
		if (!this.oCommentFeeder) {
			this.oCommentFeeder = new Feeder( this.getId() + '-CommentFeeder', {
				type: sap.ui.ux3.FeederType.Comment
			}).setParent(this);
			this.oCommentFeeder.attachEvent('submit', this.handleCommentFeederSubmit, this); // attach event this way to have the right this-reference in handler
			this.showCommentFeeder = true;
		}
	
	};
	
	FeedChunk.prototype.initToolsButton = function(){
	
		if (!this.oToolsButton) {
			this.oToolsButton = new MenuButton( this.getId() + '-toolsButton', {
				tooltip: this.rb.getText('FEED_TOOLS'),
				lite: true,
				menu: new sap.ui.commons.Menu(this.getId() + '-toolsMenu')
			}).setParent(this);
			this.oToolsButton.attachEvent('itemSelected', this.handleToolsButtonSelected, this); // attach event this way to have the right this-reference in handler
	
			var sIcon = Parameters.get('sap.ui.ux3.Feed:sapUiFeedToolsIconUrl');
			var sIconHover = Parameters.get('sap.ui.ux3.Feed:sapUiFeedToolsIconHoverUrl');
			var sThemeModulePath = "sap.ui.ux3.themes." + sap.ui.getCore().getConfiguration().getTheme();
			if (sIcon) {
				this.oToolsButton.setProperty('icon', jQuery.sap.getModulePath(sThemeModulePath, sIcon), true);
			}
			if (sIconHover) {
				this.oToolsButton.setProperty('iconHovered', jQuery.sap.getModulePath(sThemeModulePath, sIconHover), true);
			}
		}
	
	};
	
	FeedChunk.prototype.exit = function(){
	
		if (this.oCommentFeeder) {
			this.oCommentFeeder.destroy();
			delete this.oCommentFeeder;
		}
		if (this.oToolsButton) {
			this.oToolsButton.destroy();
			delete this.oToolsButton;
		}
		this.rb = undefined;
		this.showCommentFeeder = undefined;
		this.expanded = undefined;
		this.oText = undefined;
		if (this.oHCMMenuButton) {
			this.oHCMMenuButton.destroy();
			delete this.oHCMMenuButton;
		}
	
	};
	
	FeedChunk.prototype.onAfterRendering = function(){
	
		// if text is cut show expand button
		this.oText = this.$().children(".sapUiFeedChunkText").get(0);
		if (this.oText.clientHeight < this.oText.scrollHeight) {
			// if tags are rendered put button in tag-DIV
			var oFather = this.$().children(".sapUiFeedChunkByline").get(0);
			jQuery(oFather).append(sap.ui.ux3.FeedChunkRenderer.renderExpander(this));
	
			if (this.expanded) {
				// expanded
				jQuery(this.oText).css('height', 'auto');
			}
		}
	
	};
	
	/**
	 * handler for click event
	 *
	 * @private
	 */
	FeedChunk.prototype.onclick = function(oEvent){
	
		var sTargetId = oEvent.target.getAttribute( 'ID' );
	
		if (sTargetId) {
			switch ( sTargetId ) {
			case ( this.getId() + '-delete' ):
				// Click on delete button
				this.fireDeleted();
			break;
			case ( this.getId() + '-sender'):
				// Click on sender
				this.fireSenderClicked();
			break;
			case ( this.getId() + '-thumb' ):
				// Click on sender
				this.fireSenderClicked();
			break;
			case ( this.getId() + '-exp' ):
				// Click on expand/collapse button
				var sNewTitle = '';
				if (this.expanded) {
					// collapse
					jQuery(this.oText).css('height', '');
					sNewTitle = this.rb.getText("FEED_EXPAND");
					this.expanded = false;
				} else {
					// expand
					jQuery(this.oText).css('height', 'auto');
					sNewTitle = this.rb.getText("FEED_COLLAPSE");
					this.expanded = true;
				}
				jQuery.sap.byId(sTargetId).attr('title',sNewTitle).toggleClass('sapUiFeedChunkExpand sapUiFeedChunkCollapse');
			break;
			case ( this.getId() + '-all' ):
				// Click on sender
				this.showAllComments();
			break;
			case ( this.getId() + '-ActComment' ):
				// Click Add comment button
				if (!this.showCommentFeeder) {
					this.initCommentFeeder();
					this.rerender();
				}
			break;
			case ( this.getId() + '-ActFlag' ):
				// Click flag button
				this.setFlagged(!this.getFlagged());
				this.fireToggleFlagged({flagged: this.getFlagged()});
			break;
			case ( this.getId() + '-ActFavorite' ):
				// Click favorite button
				this.setFavorite(!this.getFavorite());
				this.fireToggleFavorite({favorite: this.getFavorite()});
			break;
			case ( this.getId() + '-ActInspect' ):
				// Click inspect button
				this.fireInspect();
			break;
			case ( this.getId() + '-ActShare' ):
				// Click favorite button
				this.setShared(!this.getShared());
				this.fireToggleShared({shared: this.getShared()});
			break;
			default:
				//Reference
				if (sTargetId.search(this.getId() + '-Ref') != -1) {
					this.fireReferenceClicked({text: jQuery(oEvent.target).text()});
				}
	
			break;
			}
		}
	
		oEvent.stopPropagation(); //to prevent comment chunks to propagate event to parentChunk
	
	};
	
	/**
	 * show all comments
	 * rerender comment section
	 *
	 * @private
	 */
	FeedChunk.prototype.showAllComments = function(){
	
		this.allComments = !this.allComments;
	
		var $commentSection = jQuery.sap.byId(this.getId() + " > section"); // use sap function instead of jQuery child selector because of escaping ID
		if ($commentSection.length > 0) {
			var rm = sap.ui.getCore().createRenderManager();
			this.getRenderer().renderComments(rm, this);
			rm.flush($commentSection[0]);
			rm.destroy();
		}
	
	};
	
	/**
	 * Handler for Comment feeder submit event
	 *
	 * @private
	 */
	FeedChunk.prototype.handleCommentFeederSubmit = function(oEvent){
	
		var oDate = new Date();
	//	var sDate = String(oDate.getFullYear()) + String(oDate.getMonth()) + String(oDate.getDate()) + String(oDate.getHours()) + String(oDate.getMinutes()) + String(oDate.getSeconds());
		var sDate = String(oDate);
	
		var oNewComment = new FeedChunk(this.getId() + '-new-' + this.getComments().length, {
			text: oEvent.getParameter('text'),
			commentChunk: true,
			deletionAllowed: true,
			timestamp: sDate,
			sender: this.getFeederSender(),
			thumbnailSrc: this.getFeederThumbnailSrc()
		});
	
		// new comments are shown at the bottom
		this.addComment(oNewComment);
		this.fireCommentAdded({comment: oNewComment});
	
	};
	
	/**
	 * Handler for tools menu button item selection
	 *
	 * @private
	 */
	FeedChunk.prototype.handleToolsButtonSelected = function(oEvent){
	
		if (oEvent.getParameter('itemId') == this.getId() + '-actDelete') {
			this.fireDeleted();
		} else {
			// just forward event
			this.fireActionItemSelected(oEvent.mParameters);
		}
	
	};
	
	/*
	 * Overwrite generated function
	 */
	FeedChunk.prototype.insertComment = function(oComment, iIndex) {
	
		this.insertAggregation("comments", oComment, iIndex);
		this.initCommentFeeder();
		return this;
	
	};
	
	FeedChunk.prototype.addComment = function(oComment) {
	
		this.addAggregation("comments", oComment);
		this.initCommentFeeder();
		return this;
	
	};
	
	FeedChunk.prototype.setDeletionAllowed = function(bDeletionAllowed) {
	
		if (bDeletionAllowed == this.getDeletionAllowed()) {
			// nothing to do
			return this;
		}
	
		this.setProperty("deletionAllowed", bDeletionAllowed);
		if (bDeletionAllowed) {
			this.initToolsButton();
			//add deletion item from menu
			this.oToolsButton.getMenu().insertItem(new sap.ui.commons.MenuItem(this.getId() + '-actDelete',{text: this.rb.getText('FEED_DELETE')}), 0);
		} else {
			//remove deletion item from menu
			if (this.oToolsButton) {
				this.oToolsButton.getMenu().removeItem(this.getId() + '-actDelete');
			}
		}
	
		return this;
	
	};
	
	// connect ActionMenuItems to MenuButtons menu
	FeedChunk.prototype.getActionMenuItems = function() {
	
		if (this.oToolsButton) {
			// as parent of items is the menu use menus aggregation
			var aItems = this.oToolsButton.getMenu().getItems();
			// remove delete item
			if (aItems.length > 0 && aItems[0].getId() == (this.getId() + '-actDelete')) {
				aItems.shift();
			}
			return aItems;
		}
	
	};
	
	FeedChunk.prototype.insertActionMenuItem = function(oActionMenuItem, iIndex) {
	
		this.initToolsButton();
		// if there is a delete item adjust index
		var aItems = this.oToolsButton.getMenu().getItems();
		if (aItems.length > 0 && aItems[0].getId() == (this.getId() + '-actDelete')) {
			iIndex++;
		}
		this.oToolsButton.getMenu().insertItem(oActionMenuItem, iIndex);
		return this;
	
	};
	
	FeedChunk.prototype.addActionMenuItem = function(oActionMenuItem) {
	
		this.initToolsButton();
		// as parent of items is the menu use menus aggregation
		this.oToolsButton.getMenu().addItem(oActionMenuItem);
		return this;
	
	};
	
	FeedChunk.prototype.removeActionMenuItem = function(vActionMenuItem) {
	
		if (this.oToolsButton) {
			return this.oToolsButton.getMenu().removeItem(vActionMenuItem);
		}
	
	};
	
	FeedChunk.prototype.removeAllActionMenuItems = function() {
	
		if (this.oToolsButton) {
			// if there is a delete item do not remove it
			var aItems = this.oToolsButton.getMenu().getItems();
			if (aItems.length > 0 && aItems[0].getId() == (this.getId() + '-actDelete')) {
				aItems.shift();
				for ( var i = 0; i < aItems.length; i++) {
					this.oToolsButton.getMenu().removeItem(aItems[i]);
				}
				return aItems;
			} else {
				return this.oToolsButton.getMenu().removeAllItems();
			}
		}
	
	};
	
	FeedChunk.prototype.indexOfActionMenuItem = function(oActionMenuItem) {
	
		if (this.oToolsButton) {
			var iIndex = this.oToolsButton.getMenu().indexOfItem(oActionMenuItem);
			// if there is a delete item adjust index
			var aItems = this.oToolsButton.getMenu().getItems();
			if (aItems.length > 0 && aItems[0].getId() == (this.getId() + '-actDelete')) {
				iIndex--;
			}
			return iIndex;
		}
	
	};
	
	FeedChunk.prototype.destroyActionMenuItems = function() {
	
		if (this.oToolsButton) {
			// if there is a delete item only remove all other items
			var aItems = this.oToolsButton.getMenu().getItems();
			if (aItems.length > 0 && aItems[0].getId() == (this.getId() + '-actDelete')) {
				this.removeAllActionMenuItems();
			} else {
				this.oToolsButton.getMenu().destroyItems();
			}
		}
	
		return this;
	
	};
	
	FeedChunk.prototype.bindActionMenuItems = function(sPath, oTemplate, oSorter, aFilters) {
	
		this.initToolsButton();
		// as parent of items is the menu use menus aggregation
		this.oToolsButton.getMenu().bindItems(sPath, oTemplate, oSorter, aFilters);
	
		return this;
	
	};
	
	FeedChunk.prototype.unbindActionMenuItems = function() {
	
		if (this.oToolsButton) {
			this.oToolsButton.getMenu().unbindItems();
		}
	
		return this;
	
	};
	
	/*
	 * Overwrite standard getter for feeder thumbnail source:
	 * If not set and feedChunk is child of a Feed or FeedChunk use the thumbnailsource of the parent
	 * So it must not be set manual for each sub-control and is always synchron
	 */
	FeedChunk.prototype.getFeederThumbnailSrc = function() {
		var sThumbnailSrc =  this.getProperty("feederThumbnailSrc");
	
		if (!sThumbnailSrc || sThumbnailSrc == "") {
			var oParent = this.getParent();
			if (oParent && (oParent instanceof sap.ui.ux3.Feed || oParent instanceof FeedChunk)) {
				sThumbnailSrc = oParent.getFeederThumbnailSrc();
			}
		}
	
		return sThumbnailSrc;
	};
	
	/*
	 * Overwrite standard getter for feeder sender:
	 * If not set and feedChunk is child of a Feed or FeedChunk use the feederSender of the parent
	 * So it must not be set manual for each sub-control and is always synchron
	 */
	FeedChunk.prototype.getFeederSender = function() {
		var sSender =  this.getProperty("feederSender");
	
		if (!sSender || sSender == "") {
			var oParent = this.getParent();
			if (oParent && (oParent instanceof sap.ui.ux3.Feed || oParent instanceof FeedChunk)) {
				sSender = oParent.getFeederSender();
			}
		}
	
		return sSender;
	};
	
	FeedChunk.prototype.initHCMMenuButton = function(){
	
		if (!this.oHCMMenuButton) {
			this.oHCMMenuButton = new MenuButton(this.getId() + "-HCMMenu",{
				lite: true
			}).setParent(this);
			this.oHCMMenuButton.attachEvent('itemSelected', this.handleHCMMenuButtonSelected, this); // attach event this way to have the right this-reference in handler
		}
	
	};
	
	/**
	 * Sets the MenuButton for HCM applications
	 * This is NOT an official API method and must be only uses with approval of SAPUI5 team
	 * @param(sap.ui.commons.Menu) oMenu Menu control
	 * @private
	 */
	FeedChunk.prototype.setHCMMenu = function(oMenu) {
	
		this.initHCMMenuButton();
		this.oHCMMenuButton.setMenu(oMenu);
	
		return this;
	
	};
	
	/**
	 * Handler for HCM menu button item selection
	 *
	 * @private
	 */
	FeedChunk.prototype.handleHCMMenuButtonSelected = function(oEvent){
	
		this.fireEvent("HCMMenuItemSelected", oEvent.mParameters);
	
	};

	return FeedChunk;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/FeedChunk.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.ThingInspector') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.ThingInspector.
jQuery.sap.declare('sap.ui.ux3.ThingInspector'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/ThingInspector",['jquery.sap.global', './ActionBar', './Overlay', './ThingViewer', './library'],
	function(jQuery, ActionBar, Overlay, ThingViewer) {
	"use strict";



	/**
	 * Constructor for a new ThingInspector.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Thing Inspector
	 * @extends sap.ui.ux3.Overlay
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.ux3.ThingInspector
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ThingInspector = Overlay.extend("sap.ui.ux3.ThingInspector", /** @lends sap.ui.ux3.ThingInspector.prototype */ { metadata : {

		library : "sap.ui.ux3",
		properties : {

			/**
			 * First Line of the Thing Inspector Title
			 */
			firstTitle : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Thing type
			 */
			type : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Thing Icon Url
			 */
			icon : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},

			/**
			 * Second Line of the Thing Inspector Title
			 */
			secondTitle : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Follow State of a Thing
			 */
			followState : {type : "sap.ui.ux3.FollowActionState", group : "Misc", defaultValue : sap.ui.ux3.FollowActionState.Default},

			/**
			 * State of Flag Action
			 */
			flagState : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * State Of favorite Action
			 */
			favoriteState : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Favorite action enabled/disabled. If disabled the action will be invisible.
			 */
			favoriteActionEnabled : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Update action enabled/disabled. If disabled the action will be invisible.
			 */
			updateActionEnabled : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Follow action enabled/disabled. If disabled the action will be invisible.
			 */
			followActionEnabled : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Flag action enabled/disabled. If disabled the action will be invisible.
			 */
			flagActionEnabled : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Defines which header type should be used.
			 * @since 1.16.3
			 */
			headerType : {type : "sap.ui.ux3.ThingViewerHeaderType", group : "Misc", defaultValue : sap.ui.ux3.ThingViewerHeaderType.Standard}
		},
		aggregations : {

			/**
			 * Actions of a Thing
			 */
			actions : {type : "sap.ui.ux3.ThingAction", multiple : true, singularName : "action"},

			/**
			 * ThingGroups for the header content
			 */
			headerContent : {type : "sap.ui.ux3.ThingGroup", multiple : true, singularName : "headerContent"},

			/**
			 * Thing Inspector facets
			 */
			facets : {type : "sap.ui.ux3.NavigationItem", multiple : true, singularName : "facet"},

			/**
			 * ThingGroups for content of the selected facet
			 */
			facetContent : {type : "sap.ui.ux3.ThingGroup", multiple : true, singularName : "facetContent"},

			/**
			 * ActionBar. If no actionBar is set a default ActionBar will be created.
			 */
			actionBar : {type : "sap.ui.ux3.ActionBar", multiple : false},

			/**
			 * The ThingViewer managed by this ThingInspector
			 */
			thingViewer : {type : "sap.ui.ux3.ThingViewer", multiple : false, visibility : "hidden"}
		},
		associations : {

			/**
			 * The Facet that is currently selected.
			 */
			selectedFacet : {type : "sap.ui.ux3.NavigationItem", multiple : false}
		},
		events : {

			/**
			 * Further thing related Action selected
			 */
			actionSelected : {
				parameters : {

					/**
					 * Id of selected ThingAction
					 */
					id : {type : "string"},

					/**
					 * Selected ThingAction
					 */
					action : {type : "sap.ui.ux3.ThingAction"}
				}
			},

			/**
			 * Event for facet selection. The application is responsible for displaying the correct content for the selected one. The ThingInspector will currently always mark the first facet as selected.
			 */
			facetSelected : {allowPreventDefault : true,
				parameters : {

					/**
					 * Id of selected NavigationItem
					 */
					id : {type : "string"},

					/**
					 * The selected NavigationItem
					 */
					item : {type : "sap.ui.ux3.NavigationItem"},

					/**
					 * Key of selected NavigationItem
					 */
					key : {type : "string"}
				}
			},

			/**
			 * Fired when a new feed entry is submitted.
			 */
			feedSubmit : {
				parameters : {

					/**
					 * Feed text
					 */
					text : {type : "string"}
				}
			}
		}
	}});


	(function() {
		/**
		 * Initialization hook for the Thinginspector. It creates the instance of the
		 * Popup helper service and does some basic configuration for it.
		 *
		 * @private
		 */
		ThingInspector.prototype.init = function() {
			var oActionBar, that = this;
			Overlay.prototype.init.apply(this);
			this._oThingViewer = new ThingViewer(this.getId() + "-thingViewer");
			this.setAggregation("thingViewer",this._oThingViewer);
			this._oThingViewer.attachFacetSelected(function(oEvent) {
				var item = oEvent.getParameters().item;
				if (that.fireFacetSelected({id:item.getId(), key:item.getKey(),item:item})) {
					that.setSelectedFacet(item);
				} else {
					 oEvent.preventDefault();
				}
			});
			this._oSocialActions = {};
			if (this.getActionBar() == null) {
				oActionBar = new ActionBar(this.getId() + "-actionBar");
				oActionBar.setShowOpen(false);
				oActionBar.setAlwaysShowMoreMenu(false);
				oActionBar.setDividerWidth("252px");
				oActionBar.attachActionSelected(function (oEvent) {
					var sActionID = oEvent.getParameters().id,
						oBarAction = oEvent.getParameters().action,
						oThingAction;

					if (sActionID.indexOf(sap.ui.ux3.ActionBarSocialActions.Favorite) !== -1 ||
						sActionID.indexOf(sap.ui.ux3.ActionBarSocialActions.Follow) !== -1 ||
						sActionID.indexOf(sap.ui.ux3.ActionBarSocialActions.Flag) !== -1) {
						if (that._oSocialActions[sActionID]) {
							oThingAction = that._oSocialActions[sActionID];
						} else {
							oThingAction =  new sap.ui.ux3.ThingAction({
								id: that.getId() + "-" + sActionID.toLowerCase(),
								text: oBarAction.text,
								enabled: oBarAction.enabled
							});
							that._oSocialActions[sActionID] = oThingAction;
						}
						that.fireActionSelected({
							id : sActionID.toLowerCase(),
							action : oThingAction
						});
					} else {
						that.fireActionSelected({
							id : oEvent.getParameters().id,
							action : oEvent.getParameters().action
						});
					}
				});
				oActionBar.attachFeedSubmit(function (oEvent) {
					that.fireFeedSubmit({
						text : oEvent.getParameters().text
					});
				});
				this.setActionBar(oActionBar);
			}
		};

		/*
		 * Set size of TI after rendering: If running in Shell we sync with shell
		 * canvas. The size will then be set by the shell.
		 */
		ThingInspector.prototype.onAfterRendering = function() {
			Overlay.prototype.onAfterRendering.apply(this,arguments);
			var oShell = this._getShell();
			this._bShell = !!oShell;
			if (!oShell) {
				this._applyChanges({showOverlay:false});
			}
		};

		ThingInspector.prototype.onBeforeRendering = function() {
			Overlay.prototype.onBeforeRendering.apply(this,arguments);
		};

		/**
		 * Destroys this instance of ThingInspector, called by Element#destroy()
		 *
		 * @private
		 */
		ThingInspector.prototype.exit = function() {
			this._oThingViewer.exit(arguments);
			this._oThingViewer.destroy();
			this._oThingViewer = null;
			Overlay.prototype.exit.apply(this,arguments);
		};

		/**
		 * Opens this instance of ThingIspector
		 *
		 * @param {string} [initialFocusId]
		 * @public
		 */
		ThingInspector.prototype.open = function(initialFocusId) {
			if (this.getDomRef()) {
				this.rerender();
			}
			Overlay.prototype.open.apply(this,arguments);
			this._selectDefault();
		};

		/**
		 * get Navigation Bar control
		 *
		 * @private
		 */
		ThingInspector.prototype._getNavBar = function() {
			return this._oThingViewer._oNavBar;
		};

		/**
		 * setDefault NavBar selection and fire SelectedItem Event
		 *
		 * @private
		 */
		ThingInspector.prototype._selectDefault = function() {
			this._oThingViewer._selectDefault();
		};

		/**
		 * equal Columns
		 *
		 * @private
		 */
		ThingInspector.prototype._equalColumns = function() {
			this._oThingViewer._equalColumns();
		};

		/**
		 * set trigger value for resize handler
		 *
		 * @private
		 */
		ThingInspector.prototype._setTriggerValue = function() {
			this._oThingViewer._setTriggerValue();
		};

		/**
		 * Focus Last Element
		 *
		 * @private
		 */
		ThingInspector.prototype._setFocusLast = function() {
			var oFocus = this.$("thingViewer-toolbar").lastFocusableDomRef();
			if (!oFocus && this.getCloseButtonVisible() && this.$("close").is(":sapFocusable")) {
				oFocus = this.getDomRef("close");
			} else if (!oFocus && this.getOpenButtonVisible() && this.$("openNew").is(":sapFocusable")) {
				oFocus = this.getDomRef("openNew");
			}
			jQuery.sap.focus(oFocus);
		};

		/**
		 * Focus First Element
		 *
		 * @private
		 */
		ThingInspector.prototype._setFocusFirst = function() {
			if (this.getOpenButtonVisible() && this.$("openNew").is(":sapFocusable")) {
				jQuery.sap.focus(this.getDomRef("openNew"));
			} else if (this.getCloseButtonVisible() && this.$("close").is(":sapFocusable")) {
				jQuery.sap.focus(this.getDomRef("close"));
			} else {
				jQuery.sap.focus(this.$("thingViewer-content").firstFocusableDomRef());
			}
		};

		/* Redefinition of generated API methods */

		// Implementation of API method insertAction
		ThingInspector.prototype.insertAction = function(oAction, iIndex) {
			if (this.getActionBar()) {
				this.getActionBar().insertBusinessAction(oAction, iIndex);
			}
			return this;
		};

		// Implementation of API method addAction
		ThingInspector.prototype.addAction = function(oAction) {
			if (this.getActionBar()) {
				this.getActionBar().addBusinessAction(oAction);
			}
			return this;
		};

		// Implementation of API method removeAction
		ThingInspector.prototype.removeAction = function(oAction) {
			var result;
			if (this.getActionBar()) {
				result = this.getActionBar().removeBusinessAction(oAction);
			}
			return result;
		};

		// Implementation of API method removeAllActions
		ThingInspector.prototype.removeAllActions = function() {
			var result;
			if (this.getActionBar()) {
				result = this.getActionBar().removeAllBusinessActions();
			}
			return result;
		};

		// Implementation of API method getActions
		ThingInspector.prototype.getActions = function() {
			var result;
			if (this.getActionBar()) {
				result = this.getActionBar().getBusinessActions();
			}
			return result;
		};

		// Implementation of API method destroyActions
		ThingInspector.prototype.destroyActions = function() {
			if (this.getActionBar()) {
				this.getActionBar().destroyBusinessActions();
			}
			return this;
		};

		ThingInspector.prototype.indexOfAction = function(oAction) {
			var result = -1;
			if (this.getActionBar()) {
				result = this.getActionBar().indexOfBusinessAction(oAction);
			}
			return result;
		};


		// Implementation of API method
		ThingInspector.prototype.getFacets = function() {
			return this._oThingViewer.getFacets();
		};

		// Implementation of API method insertFacet
		ThingInspector.prototype.insertFacet = function(oFacet, iIndex) {
			this._oThingViewer.insertFacet(oFacet, iIndex);
			return this;
		};

		// Implementation of API method
		ThingInspector.prototype.addFacet = function(oFacet) {
			this._oThingViewer.addFacet(oFacet);
			return this;
		};

		// Implementation of API method
		ThingInspector.prototype.removeFacet = function(vElement) {
			return this._oThingViewer.removeFacet(vElement);
		};

		// Implementation of API method
		ThingInspector.prototype.removeAllFacets = function() {
			return this._oThingViewer.removeAllFacets();
		};

		// Implementation of API method
		ThingInspector.prototype.destroyFacets = function() {
			this._oThingViewer.destroyFacets();
			return this;
		};

		ThingInspector.prototype.indexOfFacet = function(oFacet) {
			return this._oThingViewer.indexOfFacet(oFacet);
		};


		// Implementation of API method
		ThingInspector.prototype.setFollowState = function(oFollowState) {
			if (this.getActionBar()) {
				this.getActionBar().setFollowState(oFollowState);
			}
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.getFollowState = function() {
			var result = null;
			if (this.getActionBar()) {
				result = this.getActionBar().getFollowState();
			}
			return result;
		};
		// Implementation of API method
		ThingInspector.prototype.setFlagState = function(oFlagState) {
			if (this.getActionBar()) {
				this.getActionBar().setFlagState(oFlagState);
			}
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.getFlagState = function() {
			var result = null;
			if (this.getActionBar()) {
				result = this.getActionBar().getFlagState();
			}
			return result;
		};
		// Implementation of API method
		ThingInspector.prototype.setFavoriteState = function(oFavoriteState) {
			if (this.getActionBar()) {
				this.getActionBar().setFavoriteState(oFavoriteState);
			}
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.getFavoriteState = function() {
			var result = null;
			if (this.getActionBar()) {
				result = this.getActionBar().getFavoriteState();
			}
			return result;
		};

		// Implementation of API method
		ThingInspector.prototype.setIcon = function(oIcon) {
			this._oThingViewer.setIcon(oIcon);
			if (this.getActionBar()) {
				this.getActionBar().setThingIconURI(oIcon);
			}
			return this;
		};

		// Implementation of API method
		ThingInspector.prototype.getIcon = function() {
			return this._oThingViewer.getIcon();
		};

		// Implementation of API method
		ThingInspector.prototype.setType = function(sType) {
			this._oThingViewer.setType(sType);
			return this;
		};

		// Implementation of API method
		ThingInspector.prototype.getType = function() {
			return this._oThingViewer.getType();
		};

		// Implementation of API method
		ThingInspector.prototype.insertFacetContent = function(oFacetContent, iIndex) {
			this._oThingViewer.insertFacetContent(oFacetContent, iIndex);
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.addFacetContent = function(oFacetContent) {
			this._oThingViewer.addFacetContent(oFacetContent);
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.removeFacetContent = function(vFacetContent) {
			var result = this._oThingViewer.removeFacetContent(vFacetContent);
			return result;
		};
		// Implementation of API method
		ThingInspector.prototype.removeAllFacetContent = function() {
			var result = this._oThingViewer.removeAllFacetContent();
			return result;
		};
		// Implementation of API method
		ThingInspector.prototype.destroyFacetContent = function() {
			this._oThingViewer.destroyFacetContent();
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.getFacetContent = function() {
			return this._oThingViewer.getFacetContent();
		};

		ThingInspector.prototype.indexOfFacetContent = function(oFacetContent) {
			return this._oThingViewer.indexOfFacetContent(oFacetContent);
		};


		// Implementation of API method
		ThingInspector.prototype.setActionBar = function(oActionBar) {
			this._oThingViewer.setActionBar(oActionBar);
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.getActionBar = function() {
			return this._oThingViewer.getActionBar();
		};
		// Implementation of API method
		ThingInspector.prototype.destroyActionBar = function() {
			this._oThingViewer.destroyActionBar();
		};
		// Implementation of API method
		ThingInspector.prototype.insertHeaderContent = function(oHeaderContent, iIndex) {
			this._oThingViewer.insertHeaderContent(oHeaderContent, iIndex);
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.addHeaderContent = function(oHeaderContent) {
			this._oThingViewer.addHeaderContent(oHeaderContent);
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.getHeaderContent = function() {
			return this._oThingViewer.getHeaderContent();
		};
		// Implementation of API method
		ThingInspector.prototype.removeHeaderContent = function(vHeaderContent) {
			var result = this._oThingViewer.removeHeaderContent(vHeaderContent);
			return result;
		};
		// Implementation of API method
		ThingInspector.prototype.removeAllHeaderContent = function() {
			var result = this._oThingViewer.removeAllHeaderContent();
			return result;
		};
		// Implementation of API method
		ThingInspector.prototype.destroyHeaderContent = function() {
			this._oThingViewer.destroyHeaderContent();
			return this;
		};

		ThingInspector.prototype.indexOfHeaderContent = function(oHeaderContent) {
			return this._oThingViewer.indexOfHeaderContent(oHeaderContent);
		};


		// Implementation of API method
		ThingInspector.prototype.setSelectedFacet = function(selectedFacet) {
			this._oThingViewer.setSelectedFacet(selectedFacet);
		};
		// Implementation of API method
		ThingInspector.prototype.getSelectedFacet = function(selectedFacet) {
			return this._oThingViewer.getSelectedFacet();
		};
		//Implementation of API method
		ThingInspector.prototype.setFavoriteActionEnabled = function(bEnabled) {
			if (this.getActionBar()) {
				this.getActionBar().setShowFavorite(bEnabled);
			}
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.getFavoriteActionEnabled = function() {
			var result;
			if (this.getActionBar()) {
				result = this.getActionBar().getShowFavorite();
			}
			return result;
		};

		//Implementation of API method
		ThingInspector.prototype.setFlagActionEnabled = function(bEnabled) {
			if (this.getActionBar()) {
				this.getActionBar().setShowFlag(bEnabled);
			}
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.getFlagActionEnabled = function() {
			var result;
			if (this.getActionBar()) {
				result = this.getActionBar().getShowFlag();
			}
			return result;
		};

		//Implementation of API method
		ThingInspector.prototype.setUpdateActionEnabled = function(bEnabled) {
			if (this.getActionBar()) {
				this.getActionBar().setShowUpdate(bEnabled);
			}
			return this;
		};
		// Implementation of API method
		ThingInspector.prototype.getUpdateActionEnabled = function() {
			var result;
			if (this.getActionBar()) {
				result = this.getActionBar().getShowUpdate();
			}
			return result;
		};

		//Implementation of API method
		ThingInspector.prototype.setFollowActionEnabled = function(bEnabled) {
			if (this.getActionBar()) {
				this.getActionBar().setShowFollow(bEnabled);
			}
			return this;
		};
		//Implementation of API method
		ThingInspector.prototype.getFollowActionEnabled = function() {
			var result;
			if (this.getActionBar()) {
				result = this.getActionBar().getShowFollow();
			}
			return result;
		};
		//Implementation of API method
		ThingInspector.prototype.setFirstTitle = function(sTitle) {
			this._oThingViewer.setTitle(sTitle);
		};

		//Implementation of API method
		ThingInspector.prototype.getFirstTitle = function() {
			return this._oThingViewer.getTitle();
		};

		//Implementation of API method
		ThingInspector.prototype.setSecondTitle = function(sTitle) {
			this._oThingViewer.setSubtitle(sTitle);
		};

		//Implementation of API method
		ThingInspector.prototype.getSecondTitle = function() {
			return this._oThingViewer.getSubtitle();
		};
		ThingInspector.prototype.setHeaderType = function(vHeaderType) {
			this._oThingViewer.setHeaderType(vHeaderType);
			return this;
		};
		ThingInspector.prototype.getHeaderType = function() {
			var result = this._oThingViewer.getHeaderType();
			return result;
		};

		ThingInspector.prototype._applyChanges = function(oChanges) {
			this.oChanges = oChanges;
			if ( oChanges.showOverlay ) {
				this.$().removeClass("sapUiUx3TINoFrame");
			} else {
				this.$().addClass("sapUiUx3TINoFrame");
			}
			return this;
		};
	}());


	return ThingInspector;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/ThingInspector.js
if ( !jQuery.sap.isDeclared('sap.ui.ux3.Exact') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.ux3.Exact.
jQuery.sap.declare('sap.ui.ux3.Exact'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Button'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Menu'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.SearchField'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.TextView'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/ux3/Exact",['jquery.sap.global', 'sap/ui/commons/Button', 'sap/ui/commons/Menu', 'sap/ui/commons/SearchField', 'sap/ui/commons/TextView', 'sap/ui/core/Control', './ExactArea', './ExactAttribute', './ExactBrowser', './library'],
	function(jQuery, Button, Menu, SearchField, TextView, Control, ExactArea, ExactAttribute, ExactBrowser, library) {
	"use strict";


	
	/**
	 * Constructor for a new Exact.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A comprehensive UI design approach with graphical and functional elements for searching data, exploring data, and acting on the data
	 * ("Explore and Act (Exact) Pattern").
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.32.6
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.2. 
	 * API is not yet finished and might change completely
	 * @alias sap.ui.ux3.Exact
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Exact = Control.extend("sap.ui.ux3.Exact", /** @lends sap.ui.ux3.Exact.prototype */ { metadata : {
	
		library : "sap.ui.ux3",
		properties : {
	
			/**
			 * A title text which is displayed above the result section
			 */
			resultText : {type : "string", group : "Misc", defaultValue : null}
		},
		defaultAggregation : "attributes",
		aggregations : {
	
			/**
			 * Defines the 'Settings' button in the browse section tool bar
			 */
			settingsMenu : {type : "sap.ui.commons.Menu", multiple : false}, 
	
			/**
			 * The attributes which shall be available to refine the search
			 */
			attributes : {type : "sap.ui.ux3.ExactAttribute", multiple : true, singularName : "attribute"}, 
	
			/**
			 * Controls managed by the Exact control
			 */
			controls : {type : "sap.ui.core.Control", multiple : true, singularName : "control", visibility : "hidden"}
		},
		events : {
	
			/**
			 * Event is fired when the search button is clicked
			 */
			search : {
				parameters : {
	
					/**
					 * The query string which was entered in the search field.
					 */
					query : {type : "string"}
				}
			}, 
	
			/**
			 * Event which is fired when an attribute is selected or unselected.
			 */
			refineSearch : {
				parameters : {
	
					/**
					 * The query string which was entered in the search field
					 */
					query : {type : "string"}, 
	
					/**
					 * The attribute which was selected or unselected recently
					 */
					changedAttribute : {type : "sap.ui.ux3.ExactAttribute"}, 
	
					/**
					 * Array of all selected ExcatAttribute.
					 */
					allSelectedAttributes : {type : "object"}
				}
			}
		}
	}});
	
	
	
	
	
	
	
	
	
	(function() {
	
	/**
	 * Does the setup when the Exact is created.
	 * @private
	 */
	Exact.prototype.init = function(){
		var that = this;
	
		//Init the used subcontrols
		//Init Search Area
		this._searchArea = new ExactArea(this.getId() + "-searchArea", {toolbarVisible: false});
		this._searchArea.addStyleClass("sapUiUx3ExactSearchArea");
		this.addAggregation("controls", this._searchArea);
	
		this._search_input = new SearchField(this.getId() + "-searchTF", {enableListSuggest: false});
		this._search_input.attachSearch(function(oEvent){
			_handleSearch(that, oEvent);
		});
		this._search_input.addStyleClass("sapUiUx3ExactSearchText");
		this._searchArea.addContent(this._search_input);
	
		//Init Browse Area
		this._browser = new ExactBrowser(this.getId() + "-browser", {title: "Attributes"}); //TODO: I18n
		this._browser.addStyleClass("sapUiUx3ExactBrowseArea");
		this.addAggregation("controls", this._browser);
		this._browser.attachAttributeSelected(function(oEvent){
			_handleAttributeSelected(that, oEvent);
		});
	
		//Init Result Area
		this._resultArea = new ExactArea(this.getId() + "-resultArea");
		this.addAggregation("controls", this._resultArea);
	
		this._resultText = new TextView(this.getId() + "-resultAreaTitle", {design: sap.ui.commons.TextViewDesign.Bold});
		this._resultText.addStyleClass("sapUiUx3ExactViewTitle");
		this.addAggregation("controls", this._resultText);
	
		this._bDetailsVisible = false;
	};
	
	
	//*** Overridden API functions ***
	
	
	Exact.prototype.getSettingsMenu = function() {
		return this._browser.getOptionsMenu();
	};
	
	
	Exact.prototype.setSettingsMenu = function(oSettingsMenu) {
		this._browser.setOptionsMenu(oSettingsMenu);
		return this;
	};
	
	
	Exact.prototype.destroySettingsMenu = function() {
		this._browser.destroyOptionsMenu();
		return this;
	};
	
	
	Exact.prototype.getResultText = function() {
		return this._resultText.getText();
	};
	
	
	Exact.prototype.setResultText = function(sResultText) {
		this._resultText.setText(sResultText);
		return this;
	};
	
	
	Exact.prototype.getAttributes = function() {
		return this._browser.getAttributes();
	};
	
	
	Exact.prototype.insertAttribute = function(oAttribute, iIndex) {
		this._browser.insertAttribute(oAttribute, iIndex);
		return this;
	};
	
	
	Exact.prototype.addAttribute = function(oAttribute) {
		this._browser.addAttribute(oAttribute);
		return this;
	};
	
	
	Exact.prototype.removeAttribute = function(vElement) {
		return this._browser.removeAttribute(vElement);
	};
	
	
	Exact.prototype.removeAllAttributes = function() {
		return this._browser.removeAllAttributes();
	};
	
	
	Exact.prototype.indexOfAttribute = function(oAttribute) {
		return this._browser.indexOfAttribute(oAttribute);
	};
	
	
	Exact.prototype.destroyAttributes = function() {
		this._browser.destroyAttributes();
		return this;
	};
	
	

	/**
	 * Returns the ExactArea representing the result section. Arbitrary content can be added here.
	 *
	 * @type sap.ui.ux3.ExactArea
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Exact.prototype.getResultArea = function() {
		return this._resultArea;
	};
	

	/**
	 * Returns the SearchField control which is used by the Exact control.
	 *
	 * @type sap.ui.commons.SearchField
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Exact.prototype.getSearchField = function() {
		return this._search_input;
	};
	
	
	//*** Behavior functions ***
	
	
	
	
	
	//*** Private helper functions ***
	
	
	//Handles the search event
	var _handleSearch = function(oThis, oEvent){
		oThis._sSearchQuery = oEvent.getParameter("query"); //Store the value until next Search
		oThis.fireSearch({query: oThis._sSearchQuery});
		oThis._bDetailsVisible = true;
		oThis.invalidate();
	};
	
	
	//Handles attribute selections
	var _handleAttributeSelected = function(oThis, oEvent){
		oThis.fireRefineSearch({
			query: oThis._sSearchQuery,
			changedAttribute: oEvent.getParameter("attribute"),
			allSelectedAttributes: oEvent.getParameter("allAttributes")
		});
	};
	
	
	}());

	return Exact;

}, /* bExport= */ true);

}; // end of sap/ui/ux3/Exact.js
