/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./InputBase','./MaskInputRule','sap/ui/core/Control'],function(q,I,M,C){"use strict";var a=I.extend("sap.m.MaskInput",{metadata:{library:"sap.m",properties:{placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"}}}});a.prototype.init=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;s.call(this);h.call(this);};a.prototype.exit=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;};a.prototype.onBeforeRendering=function(){var V=c.call(this);if(V){q.sap.log.warning("Invalid mask input: "+V);}I.prototype.onBeforeRendering.apply(this,arguments);};a.prototype.onAfterRendering=function(){I.prototype.onAfterRendering.apply(this,arguments);};a.prototype.onfocusin=function(E){this._sOldInputValue=this._getInputValue();I.prototype.onfocusin.apply(this,arguments);j.call(this);B.call(this,true);};a.prototype.onfocusout=function(E){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);q(document).off('.sapMIBtouchstart');if(this.bRenderingPhase){return;}this.closeValueStateMessage();x.call(this);};a.prototype.oninput=function(E){I.prototype.oninput.apply(this,arguments);j.call(this);B.call(this,false);};a.prototype.onkeypress=function(E){t.call(this,E);};a.prototype.onkeydown=function(E){I.prototype.onkeydown.apply(this,arguments);u.call(this,E);};a.prototype.addAggregation=function(i,O,S){if(i==="rules"){if(!v.call(this,O)){return this;}r.call(this,O.getMaskFormatSymbol());C.prototype.addAggregation.apply(this,arguments);h.call(this);return this;}else{return C.prototype.addAggregation.apply(this,arguments);}};a.prototype.insertAggregation=function(i,O,D,S){if(i==="rules"){if(!v.call(this,O)){return this;}r.call(this,O.getMaskFormatSymbol());C.prototype.insertAggregation.apply(this,arguments);h.call(this);return this;}else{return C.prototype.insertAggregation.apply(this,arguments);}};function v(R){if(new RegExp(R.getRegex()).test(this.getPlaceholderSymbol())){q.sap.log.error("Rejecting input mask rule because it includes the currently set placeholder symbol.");return false;}return true;}a.prototype.setPlaceholderSymbol=function(S){var i=false;if(!/^.$/i.test(S)){q.sap.log.error("Invalid placeholder symbol string given");return this;}i=this.getRules().some(function(R){return new RegExp(R.getRegex()).test(S);});if(i){q.sap.log.error("Rejecting placeholder symbol because it is included as a regex in an existing mask input rule.");}else{this.setProperty("placeholderSymbol",S);h.call(this);}return this;};a.prototype.setMask=function(i){if(!i){var E="Setting empty mask does not make sense. Make sure you set it with a non empty value.";q.sap.log.warning(E);return this;}this.setProperty("mask",i,true);h.call(this);return this;};a.prototype._isCharAllowed=function(i,D){return this._oRules.applyCharAt(i,D);};a.prototype._feedReplaceChar=function(i,P,D){return i;};var b=function(i){this._aInitial=i.slice(0);this._aContent=i;};b.prototype.setCharAt=function(i,P){this._aContent[P]=i;};b.prototype.charAt=function(P){return this._aContent[P];};b.prototype.toString=function(){return this._aContent.join('');};b.prototype.differsFromOriginal=function(){return this.differsFrom(this._aInitial);};b.prototype.differsFrom=function(V){var i=0;if(V.length!==this._aContent.length){return true;}for(i=0;i<V.length;i++){if(V[i]!==this._aContent[i]){return true;}}return false;};b.prototype.getSize=function(){return this._aContent.length;};var T=function(R){this._aRules=R;};T.prototype.nextTo=function(i){var P=i;if(typeof P==="undefined"){P=-1;}do{P++;}while(P<this._aRules.length&&!this._aRules[P]);return P;};T.prototype.previous=function(i){var P=i;do{P--;}while(!this._aRules[P]&&P>0);return P;};T.prototype.hasRuleAt=function(i){return!!this._aRules[i];};T.prototype.applyCharAt=function(i,D){return this._aRules[D].test(i);};function s(){this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"a",regex:"[A-Za-z]"}));this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"9",regex:"[0-9]"}));}function c(){var P=this.getPlaceholderSymbol(),R=this.getRules(),i=[],E=[];if(!this.getMask()){E.push("Empty mask");}if(R.length){i=[];R.every(function(D){var F=D.getMaskFormatSymbol(),G=F!==P,H;H=!i.some(function(S){return F===S;});i.push(F);if(!G){E.push("Placeholder symbol is the  same as the existing rule's mask format symbol");}if(!H){E.push("Duplicated rule's maskFormatSymbol ["+F+"]");}return G&&H;});}return E.length?E.join(". "):null;}function r(S){var i=f(S,this.getRules());if(i){this.removeAggregation('rules',i.oRule);}}function f(i,R){var D=null;if(typeof i!=="string"||i.length!==1){q.sap.log.error(i+" does not appear to be a valid mask rule symbol");return null;}q.each(R,function(E,F){if(F.getMaskFormatSymbol()===i){D={oRule:F,iIndex:E};return false;}});return D;}function g(){var _=q(this.getFocusDomRef());if(!_&&(_.length===0||_.is(":hidden"))){return;}return{iFrom:_[0].selectionStart,iTo:_[0].selectionEnd,bHasSelection:(_[0].selectionEnd-_[0].selectionStart!==0)};}function d(P){var _=q(this.getFocusDomRef());return _.cursorPos(P);}function e(){var _=q(this.getFocusDomRef());return _.cursorPos();}function h(){var R=this.getRules(),i=this.getMask(),D=i.split(""),P=this.getPlaceholderSymbol();var V=y(D,P,R);this._oTempValue=new b(V);var E=z(D,R);this._iMaskLength=E.length;this._oRules=new T(E);this._iUserInputStartPosition=this._oRules.nextTo();}function j(){var i=this._getInputValue();if(!this.getEditable()){return;}n.call(this,i);}function k(F,i){var D,N,E,G,P=this.getPlaceholderSymbol();if(F>=0){N=this._oRules.nextTo(i);for(D=F;D<this._iMaskLength;D++){if(this._oRules.hasRuleAt(D)){G=this._oTempValue.charAt(N);E=this._oRules.applyCharAt(G,D);if(N<this._iMaskLength&&E){this._oTempValue.setCharAt(P,N);this._oTempValue.setCharAt(G,D);N=this._oRules.nextTo(N);}else{this.updateDomValue(this._oTempValue.toString());d.call(this,Math.max(this._iUserInputStartPosition,F));return;}}}}}function l(S){var i,N,D,P=this.getPlaceholderSymbol(),E=P;for(i=S;i<this._iMaskLength;i++){if(this._oRules.hasRuleAt(i)){this._oTempValue.setCharAt(E,i);N=this._oRules.nextTo(i);if(N>=this._iMaskLength){return;}D=this._oTempValue.charAt(i);if(!this._oRules.applyCharAt(D,N)){return;}E=D;}}}function m(F,i){var D,P=this.getPlaceholderSymbol();if(typeof F==="undefined"||F===null){F=0;i=this._oTempValue.getSize()-1;}for(D=F;D<=i;D++){if(this._oRules.hasRuleAt(D)){this._oTempValue.setCharAt(P,D);}}}function n(i){p.call(this,i);this.updateDomValue(this._oTempValue.toString());}function o(){return this._iLastMatch;}function p(i){var D,E=0,F,P=this.getPlaceholderSymbol(),G;this._iLastMatch=-1;for(F=0;F<this._iMaskLength;F++){if(this._oRules.hasRuleAt(F)){this._oTempValue.setCharAt(P,F);G=false;if(i.length){do{D=i.charAt(E);E++;if(this._oRules.applyCharAt(D,F)){this._oTempValue.setCharAt(D,F);this._iLastMatch=F;G=true;}}while(!G&&(E<i.length));}if(!G){m.call(this,F+1,this._iMaskLength-1);break;}}else{if(this._oTempValue.charAt(F)===i.charAt(E)){E++;}this._iLastMatch=F;}}}function t(E){if(!this.getEditable()){return;}var S=g.call(this),P,i,K=A(E);if(K.bCtrlKey||K.bAltKey||K.bMetaKey||K.bBeforeSpace){return;}if(!K.bEnter&&!K.bShiftLeftOrRightArrow&&!K.bHome&&!K.bEnd&&!(K.bShift&&K.bDelete)&&!(K.bCtrlKey&&K.bInsert)&&!(K.bShift&&K.bInsert)){if(S.bHasSelection){m.call(this,S.iFrom,S.iTo-1);k.call(this,S.iFrom,S.iTo-1);}P=this._oRules.nextTo(S.iFrom-1);if(P<this._iMaskLength){i=this._feedReplaceChar(K.sChar,P,this._getInputValue());w.call(this,i,P);}E.preventDefault();}}function u(E){var S,i,D,F,N,K=A(E);if(!this.getEditable()){return;}if(!K.bShift&&(K.bArrowRight||K.bArrowLeft)){F=e.call(this);N=(K.bArrowRight?this._oRules.nextTo(F):this._oRules.previous(F));d.call(this,N);E.preventDefault();}else if(K.bEscape){n.call(this,this._sOldInputValue);B.call(this,true);E.preventDefault();}else if(K.bEnter){x.call(this,E);}else if((K.bShift&&K.bDelete)||(K.bCtrlKey&&K.bInsert)||(K.bShift&&K.bInsert)){I.prototype.onkeydown.apply(this,arguments);}else if(K.bDelete||K.bBackspace){S=g.call(this);i=S.iFrom;D=S.iTo;if(!S.bHasSelection){if(K.bDelete){D=this._oRules.nextTo(i-1);i=D;D=this._oRules.nextTo(D);}else{i=this._oRules.previous(i);}}m.call(this,i,D-1);k.call(this,i,D-1);E.preventDefault();}}function w(N,P){var i,D=false,E=N.split(""),F;while(E.length){F=E.splice(0,1)[0];if(this._oRules.applyCharAt(F,P)){D=true;l.call(this,P);this._oTempValue.setCharAt(F,P);P=this._oRules.nextTo(P);}}if(D){i=P;this.updateDomValue(this._oTempValue.toString());d.call(this,i);}}function x(){var N=this._getInputValue(),i,V,E,D;if(this._oTempValue.differsFrom(N)){n.call(this,N);}i=this._oTempValue.differsFromOriginal();V=i?this._oTempValue.toString():"";E=!this._sOldInputValue;D=!N;if(E&&(D||!i)){this.updateDomValue("");return;}if(this._sOldInputValue!==this._oTempValue.toString()){this.setValue(V);this.onChange({value:V});this.fireChangeEvent(V);}}function y(i,P,R){return i.map(function(D,E){return f(D,R)?P:D;});}function z(i,R){var D=[];q.each(i,function(E,F){var S=f(F,R);D.push(S?new RegExp(S.oRule.getRegex()):null);});return D;}function A(E){var P=E.which||E.keyCode,K=q.sap.KeyCodes,i=P===K.ARROW_RIGHT,D=P===K.ARROW_LEFT,S=E.shiftKey;return{iCode:P,sChar:String.fromCharCode(P),bCtrlKey:E.ctrlKey,bAltKey:E.altKey,bMetaKey:E.metaKey,bShift:S,bInsert:P===q.sap.KeyCodes.INSERT,bBackspace:P===K.BACKSPACE,bDelete:P===K.DELETE,bEscape:P===K.ESCAPE,bEnter:P===K.ENTER,bIphoneEscape:(sap.ui.Device.system.phone&&sap.ui.Device.os.ios&&P===127),bArrowRight:i,bArrowLeft:D,bHome:P===q.sap.KeyCodes.HOME,bEnd:P===q.sap.KeyCodes.END,bShiftLeftOrRightArrow:S&&(D||i),bBeforeSpace:P<K.SPACE};}function B(S){var i=this.getMask(),E;clearTimeout(this._iCaretTimeoutId);E=o.call(this);this._iCaretTimeoutId=q.sap.delayedCall(0,this,function(){if(this.getFocusDomRef()!==document.activeElement){return;}if(S&&(E===(i.length-1))){this.selectText(0,E+1);}else{d.call(this,E+1);}});}return a;},false);
