/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./BindingMode','./ChangeReason','./PropertyBinding','./CompositeType','./DataState'],function(q,B,C,P,a,D){"use strict";var b=P.extend("sap.ui.model.CompositeBinding",{constructor:function(c,r){P.apply(this,[null,""]);this.aBindings=c;this.aValues=null;this.bRawValues=r;this.bPreventUpdate=false;},metadata:{publicMethods:["getBindings","attachChange","detachChange"]}});b.prototype.getPath=function(){return null;};b.prototype.getModel=function(){return null;};b.prototype.getContext=function(){return null;};b.prototype.setType=function(t,i){if(t&&!(t instanceof a)){throw new Error("Only CompositeType can be used as type for composite bindings!");}P.prototype.setType.apply(this,arguments);if(this.oType){this.bRawValues=this.oType.getUseRawValues();}};b.prototype.setContext=function(c){q.each(this.aBindings,function(i,o){if(!c||o.updateRequired(c.getModel())){o.setContext(c);}});};b.prototype.setValue=function(v){var V;q.each(this.aBindings,function(i,o){V=v[i];if(V!==undefined){o.setValue(V);}});};b.prototype.getValue=function(){var v=[],V;q.each(this.aBindings,function(i,o){V=o.getValue();v.push(V);});return v;};b.prototype.setExternalValue=function(v){var V,c;if(this.fnFormatter){q.sap.log.warning("Tried to use twoway binding, but a formatter function is used");return;}if(this.oType){if(this.oType.getParseWithValues()){c=[];if(this.bRawValues){c=this.getValue();}else{q.each(this.aBindings,function(i,o){c.push(o.getExternalValue());});}}V=this.oType.parseValue(v,this.sInternalType,c);}else{if(typeof v=="string"){V=v.split(" ");}else{V=[v];}}if(this.bRawValues){this.setValue(V);}else{q.each(this.aBindings,function(i,o){v=V[i];if(v!==undefined){o.setExternalValue(v);}});}};b.prototype.getExternalValue=function(){var v=[];if(this.bRawValues){v=this.getValue();}else{q.each(this.aBindings,function(i,o){v.push(o.getExternalValue());});}return this._toExternalValue(v);};b.prototype._toExternalValue=function(v){var V;if(this.fnFormatter){V=this.fnFormatter.apply(this,v);}else if(this.oType){V=this.oType.formatValue(v,this.sInternalType);}else{if(v.length>1){V=v.join(" ");}else{V=v[0];}}return V;};b.prototype.getBindings=function(){return this.aBindings;};b.prototype.attachChange=function(f,l){var t=this;this.fChangeHandler=function(e){var o=e.getSource();if(o.getBindingMode()==B.OneTime){o.detachChange(t.fChangeHandler);}t.checkUpdate(true);};this.attachEvent("change",f,l);if(this.aBindings){q.each(this.aBindings,function(i,o){o.attachChange(t.fChangeHandler);});}};b.prototype.detachChange=function(f,l){var t=this;this.detachEvent("change",f,l);if(this.aBindings){q.each(this.aBindings,function(i,o){o.detachChange(t.fChangeHandler);});}};b.prototype.attachDataStateChange=function(f,l){var t=this;this.fDataStateChangeHandler=function(e){var o=e.getSource();if(o.getBindingMode()==B.OneTime){o.detachDataStateChange(t.fChangeHandler);}t.checkDataState();};this.attachEvent("DataStateChange",f,l);if(this.aBindings){q.each(this.aBindings,function(i,o){o.attachDataStateChange(t.fDataStateChangeHandler);});}};b.prototype.detachDataStateChange=function(f,l){var t=this;this.detachEvent("DataStateChange",f,l);if(this.aBindings){q.each(this.aBindings,function(i,o){o.detachDataStateChange(t.fDataStateChangeHandler);});}};b.prototype.updateRequired=function(m){var u=false;q.each(this.aBindings,function(i,o){u=u||o.updateRequired(m);});return u;};b.prototype.initialize=function(){this.bPreventUpdate=true;if(this.aBindings){q.each(this.aBindings,function(i,o){o.initialize();});}this.bPreventUpdate=false;this.checkUpdate(true);return this;};b.prototype.checkUpdate=function(f){if(this.bPreventUpdate){return;}var v=this.getValue();if(!q.sap.equal(v,this.aValues)||f){this.aValues=v;this._fireChange({reason:C.Change});}};b.prototype._updateDataState=function(){var d=P.prototype._updateDataState.call(this),o=[],m=[],c=d.getControlMessages(),t=this;q.each(this.aBindings,function(i,e){var I=e._updateDataState();if(t.bRawValues){o.push(I.getOriginalValue());}else{o.push(I.getOriginalInternalValue());}if(I.getModelMessages()){m=m.concat(I.getModelMessages());}if(I.getControlMessages()){c=c.concat(I.getControlMessages());}});d.setModelMessages(m);d.setControlMessages(c);d.setOriginalInternalValue(o);d.setValue(this._toExternalValue(d.getInternalValue()));d.setOriginalValue(this._toExternalValue(o));return d;};return b;});
