/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/delegate/ScrollEnablement"],function(q,l,C,S){"use strict";var a=C.extend("sap.m.ScrollContainer",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},horizontal:{type:"boolean",group:"Behavior",defaultValue:true},vertical:{type:"boolean",group:"Behavior",defaultValue:false},focusable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});a.prototype.init=function(){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false});};a.prototype.onBeforeRendering=function(){this._oScroller.setHorizontal(this.getHorizontal());this._oScroller.setVertical(this.getVertical());};a.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}};a.prototype.getScrollDelegate=function(){return this._oScroller;};a.prototype.scrollTo=function(x,y,t){if(this._oScroller){var d=this.getDomRef();if(d){if(sap.ui.getCore().getConfiguration().getRTL()){x=q.sap.denormalizeScrollBeginRTL(x,d);}this._oScroller.scrollTo(x,y,t);}else{this._oScroller._scrollX=x;this._oScroller._scrollY=y;}}return this;};a.prototype.scrollToElement=function(e,t){if(e instanceof sap.ui.core.Element){e=e.getDomRef();}if(this._oScroller){this._oScroller.scrollToElement(e,t);}return this;};a.prototype.setHorizontal=function(h){this._oScroller.setHorizontal(h);this.setProperty("horizontal",h,true);};a.prototype.setVertical=function(v){this._oScroller.setVertical(v);this.setProperty("vertical",v,true);};return a;},true);
