/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/Header','./calendar/Month','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,b,H,M,c,d,Y,U,l){"use strict";var e=b.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Misc"},days:{type:"int",group:"Misc",defaultValue:7},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}}}});(function(){e.prototype.init=function(){b.prototype.init.apply(this,arguments);var m=this.getAggregation("monthPicker");m.setColumns(0);m.setMonths(3);var y=this.getAggregation("yearPicker");y.setColumns(0);y.setYears(3);this._iDaysLarge=10;this._iDaysMonthHead=35;};e.prototype._createMonth=function(i){var m=new c(i);return m;};e.prototype.setStartDate=function(s){if(!(s instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var y=s.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}var u=a._createUniversalUTCDate(s);this.setProperty("startDate",s,true);this._oUTCStartDate=u;var o=this.getAggregation("month")[0];o.setStartDate(s);this._updateHeader(u);var g=a._createLocalDate(this._getFocusedDate());if(!o.checkDateFocusable(g)){this._setFocusedDate(u);o.setDate(s);}return this;};e.prototype.setDays=function(i){this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);var m=this.getAggregation("monthPicker");var g=Math.ceil(i/3);if(g>12){g=12;}m.setMonths(g);var y=this.getAggregation("yearPicker");var h=Math.floor(i/2);if(h>20){h=20;}y.setYears(h);var t=this;var s=f(t);this._updateHeader(s);if(this.getDomRef()){if(i>this._iDaysLarge){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}};e.prototype._getDays=function(){var i=this.getDays();if(sap.ui.Device.system.phone&&i>8){return 8;}else{return i;}};e.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};e.prototype._getFocusedDate=function(){if(!this._oFocusedDate){b.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){var t=this;_(t,this._oFocusedDate,false);}else if(!o.checkDateFocusable(a._createLocalDate(this._oFocusedDate))){this._oFocusedDate=a._createUniversalUTCDate(s);}}return this._oFocusedDate;};e.prototype.setMonths=function(m){if(m==1){this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};e.prototype.setFirstDayOfWeek=function(F){if(F==-1){this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};e.prototype.focusDate=function(o){var g=this.getAggregation("month")[0];if(!g.checkDateFocusable(o)){var u=a._createUniversalUTCDate(o);this._focusDateExtend(u,true);}b.prototype.focusDate.apply(this,arguments);return this;};e.prototype._focusDateExtend=function(o,O){if(O){var t=this;var g=this._getFocusedDate();var s=f(t);var i=Math.ceil((g.getTime()-s.getTime())/(1000*3600*24));s=new U(o.getTime());s.setUTCDate(s.getUTCDate()-i);_(t,s,false);}};e.prototype._handlePrevious=function(E){var t=this;var F=new U(this._getFocusedDate().getTime());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=new U(f(t).getTime());var i=this._getDays();switch(this._iMode){case 0:s.setUTCDate(s.getUTCDate()-i);F.setUTCDate(F.getUTCDate()-i);this._setFocusedDate(F);_(t,s,true);break;case 1:if(m.getMonths()<12){m.previousPage();}else{F.setUTCFullYear(F.getUTCFullYear()-1);this._focusDateExtend(F,true);this._setFocusedDate(F);this._updateHeader(F);}break;case 2:y.previousPage();break;}};e.prototype._handleNext=function(E){var t=this;var F=new U(this._getFocusedDate().getTime());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=new U(f(t).getTime());var i=this._getDays();switch(this._iMode){case 0:s.setUTCDate(s.getUTCDate()+i);F.setUTCDate(F.getUTCDate()+i);this._setFocusedDate(F);_(t,s,true);break;case 1:if(m.getMonths()<12){m.nextPage();}else{F.setUTCFullYear(F.getUTCFullYear()+1);this._focusDateExtend(F,true);this._setFocusedDate(F);this._updateHeader(F);}break;case 2:y.nextPage();break;}};e.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getUTCMonth();var g=this._getDays();m.push(i);if(g>this._iDaysLarge){var E=new U(o.getTime());E.setUTCDate(E.getUTCDate()+g-1);var h=E.getUTCMonth();while(i!=h){i=(i+1)%12;m.push(i);}}return m;};function _(t,s,S){var m=new U(t._oMaxDate.getTime());m.setUTCDate(m.getUTCDate()-t._getDays());if(s.getTime()<t._oMinDate.getTime()){s=t._oMinDate;}else if(s.getTime()>m.getTime()){s=m;}var o=a._createLocalDate(s);t.setProperty("startDate",o,true);t._oUTCStartDate=s;var g=t.getAggregation("month")[0];g.setStartDate(o);t._updateHeader(s);if(S){var h=a._createLocalDate(t._getFocusedDate());if(!g.checkDateFocusable(h)){t._setFocusedDate(s);g.setDate(o);}else{g.setDate(h);}}}function f(t){if(!t._oUTCStartDate){t._oUTCStartDate=t._getFocusedDate();}return t._oUTCStartDate;}}());return e;},true);
