/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,M,b,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",properties:{intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},months:{type:"int",group:"Misc",defaultValue:1},firstDayOfWeek:{type:"int",group:"Misc",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},cancel:{}}}});(function(){c.prototype.init=function(){this._iMode=0;this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(U.UTC(1,0,1));this._oMinDate.setUTCFullYear(1);this._oMaxDate=new U(U.UTC(9999,11,31));var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",r,this);i.attachEvent("pressButton2",s,this);this.setAggregation("header",i);var B=this._createMonth(this.getId()+"--Month0");B.attachEvent("focus",v,this);B.attachEvent("select",u,this);B.attachEvent("_renderMonth",t,this);B.attachEvent("_bindMousemove",w,this);B.attachEvent("_unbindMousemove",x,this);B._bNoThemeChange=true;this.addAggregation("month",B);var E=new b(this.getId()+"--MP");E.attachEvent("select",y,this);E._bNoThemeChange=true;this.setAggregation("monthPicker",E);var F=new Y(this.getId()+"--YP");F.attachEvent("select",z,this);this.setAggregation("yearPicker",F);};c.prototype.exit=function(){if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}};c.prototype._createMonth=function(i){var B=new M(i);return B;};c.prototype.onBeforeRendering=function(){var B=this.getAggregation("month");var E;var F=B[0].getDate();if(B.length>1&&F){E=new U(F.getTime());}else{E=this._getFocusedDate();}this._updateHeader(E);for(var i=0;i<B.length;i++){var G=B[i];F=new U(E.getTime());if(i>0){F.setUTCDate(1);F.setUTCMonth(E.getUTCMonth()+i);}G.setDate(a._createLocalDate(F));}};c.prototype.onAfterRendering=function(){var i=this;j(i);};c.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){var i=this;this._sInvalidateMonth=q.sap.delayedCall(0,i,A,[i]);}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};c.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){var i=this;d(i);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(i.getTime());};c.prototype.focusDate=function(i){var B=this;o(B,i,false);return this;};c.prototype.displayDate=function(i){var B=this;o(B,i,true);return this;};c.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};c.prototype.setMonths=function(B){this.setProperty("months",B,false);var E=this;B=p(E);var F=this.getAggregation("month");var i=0;var G;if(F.length<B){for(i=F.length;i<B;i++){G=this._createMonth(this.getId()+"--Month"+i);G.attachEvent("focus",v,this);G.attachEvent("select",u,this);G.attachEvent("_renderMonth",t,this);G.attachEvent("_bindMousemove",w,this);G.attachEvent("_unbindMousemove",x,this);G._bNoThemeChange=true;this.addAggregation("month",G);}}else if(F.length>B){for(i=F.length;i>B;i--){G=this.removeAggregation("month",i-1);G.destroy();}}return this;};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var B=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(B);}return this._oLocaleData;};c.prototype._getShowMonthHeader=function(){var i=this;var B=p(i);if(B>2){return true;}else{return false;}};c.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};c.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};c.prototype.onsapescape=function(E){var i=this;switch(this._iMode){case 0:this.fireCancel();break;case 1:f(i);break;case 2:h(i);break;}};c.prototype.onsapshow=function(E){if(this._bPoupupMode){var i=this;switch(this._iMode){case 1:f(i);break;case 2:h(i);break;}this.fireCancel();E.preventDefault();}};c.prototype.onsaphide=c.prototype.onsapshow;c.prototype.onsaptabnext=function(E){var B=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(B.getDomRef("B1"));if(!this._bPoupupMode){var F=this.getAggregation("month");var G=this.getAggregation("monthPicker");var I=this.getAggregation("yearPicker");for(var i=0;i<F.length;i++){var J=F[i];q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}else if(E.target.id==B.getId()+"-B1"){q.sap.focus(B.getDomRef("B2"));E.preventDefault();}};c.prototype.onsaptabprevious=function(E){var B=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(B.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==B.getId()+"-B1"){var F=this.getAggregation("month");var G=this.getAggregation("monthPicker");var I=this.getAggregation("yearPicker");var J;switch(this._iMode){case 0:J=this._getFocusedDate();for(var i=0;i<F.length;i++){var K=F[i];var N=a._createUniversalUTCDate(K.getDate());if(J.getTime()==N.getTime()){K._oItemNavigation.focusItem(K._oItemNavigation.getFocusedIndex());}else{q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());break;case 2:I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}else if(E.target.id==B.getId()+"-B2"){q.sap.focus(B.getDomRef("B1"));E.preventDefault();}};c.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var B=this.getAggregation("header");var F=this.getAggregation("month");var G=this.getAggregation("monthPicker");var I=this.getAggregation("yearPicker");q.sap.focus(B.getDomRef("B2"));if(!this._bPoupupMode){for(var i=0;i<F.length;i++){var J=F[i];q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");switch(this._iMode){case 0:for(var i=0;i<B.length;i++){var I=B[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};c.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}var B=this;this._bNamesLengthChecked=undefined;var E=this.getAggregation("monthPicker");e(B,true);E._bNoThemeChange=false;E.onThemeChanged(arguments);E._bNoThemeChange=true;this._bLongMonth=E._bLongMonth;f(B,true);var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];G._bNoThemeChange=false;G.onThemeChanged(arguments);G._bNoThemeChange=true;}var I=this._getFocusedDate();n(B,I);j(B);};c.prototype._updateHeader=function(i){var B=this;n(B,i);k(B,i,true);};c.prototype._handlePrevious=function(E){var i=this;var F=this._getFocusedDate();var B=this.getAggregation("header");var G=this.getAggregation("yearPicker");var I=p(i);var J;var N=false;switch(this._iMode){case 0:if(I>1){J=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate());J.setUTCDate(1);this._setFocusedDate(J);F=this._getFocusedDate();}else{F.setUTCDate(1);}F.setUTCDate(F.getUTCDate()-1);_(i,N,true);break;case 1:F.setUTCFullYear(F.getUTCFullYear()-1);B.setTextButton2((F.getUTCFullYear()).toString());k(i,F);break;case 2:G.previousPage();break;}};c.prototype._handleNext=function(E){var i=this;var F=this._getFocusedDate();var B=this.getAggregation("header");var G=this.getAggregation("yearPicker");var I=p(i);var J;switch(this._iMode){case 0:if(I>1){J=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate());this._setFocusedDate(J);F=this._getFocusedDate();}F.setUTCMonth(F.getUTCMonth()+I,1);_(i);break;case 1:F.setUTCFullYear(F.getUTCFullYear()+1);B.setTextButton2((F.getUTCFullYear()).toString());k(i,F);break;case 2:G.nextPage();break;}};c.prototype._getDisplayedMonths=function(B){var E=this;var F=[];var G=B.getUTCMonth();var I=p(E);if(I>1){for(var i=0;i<I;i++){F.push((G+i)%12);}}else{F.push(G);}return F;};function _(T,N,I){var B=T._getFocusedDate();var E=T.getAggregation("month");var F=false;var G;var J;var K;var i=0;for(i=0;i<E.length;i++){G=E[i];if(G.checkDateFocusable(a._createLocalDate(B))){F=true;}if(F||E.length==1){if(!N){G.setDate(a._createLocalDate(B));}else{G.displayDate(a._createLocalDate(B));}break;}}if(!F){K=new U(B.getTime());if(E.length>1){K.setUTCDate(1);if(I){K.setUTCMonth(K.getUTCMonth()-E.length+1);}for(i=0;i<E.length;i++){G=E[i];J=new U(K.getTime());J.setUTCMonth(K.getUTCMonth()+i);if(!N&&J.getUTCFullYear()==B.getUTCFullYear()&&J.getUTCMonth()==B.getUTCMonth()){G.setDate(a._createLocalDate(B));}else{G.displayDate(a._createLocalDate(J));}}}T._updateHeader(K);}}function d(T){var S=T.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){T._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate());}else{var N=new Date();T._oFocusedDate=a._createUniversalUTCDate(N);}}function e(T,N){if(T._iMode==2){h(T,true);}var B=T._getFocusedDate();var E=T.getAggregation("monthPicker");if(E.getDomRef()){E.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=T.$("content");R.renderControl(E);R.flush($[0],false,true);R.destroy();}T.$("contentOver").css("display","");if(!N){E.setMonth(B.getUTCMonth());if(T._iMode==0){var F=T.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}T._iMode=1;k(T,B,false);}function f(T,N){T._iMode=0;var B=T.getAggregation("monthPicker");B.$().css("display","none");T.$("contentOver").css("display","none");if(!N){_(T);if(T.getMonths()>1){var E=T.getAggregation("month");for(var i=0;i<E.length;i++){var F=E[i];q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}}function g(T){if(T._iMode==1){f(T,true);}var B=T._getFocusedDate();var E=B.getUTCFullYear();var F=T._oMaxDate.getUTCFullYear();var G=T._oMinDate.getUTCFullYear();if(F-G<=20){return;}var I=T.getAggregation("header");if(E>(F-10)){E=F-9;I.setEnabledNext(false);}else{I.setEnabledNext(true);}if(E<(G+9)){E=G+10;I.setEnabledPrevious(false);}else{I.setEnabledPrevious(true);}var J=T.getAggregation("yearPicker");if(J.getDomRef()){J.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=T.$("content");R.renderControl(J);R.flush($[0],false,true);R.destroy();}T.$("contentOver").css("display","");J.setYear(E);if(p(T)==1){var K=T.getAggregation("month")[0];var N=K.$("days").find(".sapUiCalItem");if(N.length==28){J.$().addClass("sapUiCalYearNoTop");}else{J.$().removeClass("sapUiCalYearNoTop");}}if(T._iMode==0){var O=T.getAggregation("month");for(var i=0;i<O.length;i++){var K=O[i];q(K._oItemNavigation.getItemDomRefs()[K._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}T._iMode=2;}function h(T,N){T._iMode=0;var B=T.getAggregation("yearPicker");B.$().css("display","none");T.$("contentOver").css("display","none");if(!N){_(T);if(T.getMonths()>1){var E=T.getAggregation("month");for(var i=0;i<E.length;i++){var F=E[i];q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}}function j(T){if(!T._bNamesLengthChecked){e(T,true);f(T,true);var i=T.getAggregation("monthPicker");T._bLongMonth=i._bLongMonth;T._bNamesLengthChecked=true;if(!T._bLongMonth){var B=T._getFocusedDate();n(T,B);}}else if(T.getMonths()>1){m(T,T._getFocusedDate(),true);}}function k(T,i,B){var E=i.getUTCFullYear();var F=T._oMaxDate.getUTCFullYear();var G=T._oMinDate.getUTCFullYear();var I=i.getUTCMonth();var J=T._oMaxDate.getUTCMonth();var K=T._oMinDate.getUTCMonth();var N=T.getAggregation("header");if(E>F||(E==F&&(!B||I>=J))){N.setEnabledNext(false);}else{N.setEnabledNext(true);}if(E<G||(E==G&&(!B||I<=K))){N.setEnabledPrevious(false);}else{N.setEnabledPrevious(true);}}function m(T,i,O){var F;var B=false;if(i.getTime()<T._oMinDate.getTime()){F=T._oMinDate;B=true;}else if(i.getTime()>T._oMaxDate.getTime()){F=T._oMaxDate;B=true;}else{F=i;}if(T._focusDateExtend){T._focusDateExtend(i,O);}var I=F.getTime()<T._getFocusedDate().getTime();T._setFocusedDate(F);if(B||O){_(T,false,I);}}function n(T,i){var B=T._getLocaleData();var E=[];var F=[];var G;var S=false;if(T._bLongMonth||!T._bNamesLengthChecked){E=B.getMonthsStandAlone("wide");}else{S=true;E=B.getMonthsStandAlone("abbreviated");F=B.getMonthsStandAlone("wide");}var I=T._getDisplayedMonths(i);var J;if(I.length>1){var P=B.getIntervalPattern();J=P.replace(/\{0\}/,E[I[0]]).replace(/\{1\}/,E[I[I.length-1]]);if(S){G=P.replace(/\{0\}/,F[I[0]]).replace(/\{1\}/,F[I[I.length-1]]);}}else{J=E[I[0]];if(S){G=F[E[I[0]]];}}var K=T.getAggregation("header");K.setTextButton1(J);if(S){K.setAriaLabelButton1(G);}K.setTextButton2((i.getUTCFullYear()).toString());}function o(T,i,N){if(i&&(!T._oFocusedDate||T._oFocusedDate.getTime()!=i.getTime())){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+T);}i=a._createUniversalUTCDate(i);var B=i.getUTCFullYear();if(B<1||B>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+T);}T._setFocusedDate(i);if(T.getDomRef()&&T._iMode==0){_(T,N);}}}function p(T){if(sap.ui.Device.system.phone){return 1;}else{return T.getMonths();}}function r(E){var i=this;if(this._iMode!=1){e(i);}else{f(i);}}function s(E){var i=this;if(this._iMode!=2){g(i);}else{h(i);}}function t(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function u(E){var B=this;if(p(B)>1){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];if(G.getId()!=E.oSource.getId()){G._updateSelection();}}}this.fireSelect();}function v(E){var i=a._createUniversalUTCDate(E.getParameter("date"));var O=E.getParameter("otherMonth");var R=E.getParameter("restoreOldDate");var B=this;if(R){if(!q.sap.equal(this._getFocusedDate(),i)){_(B,false);}}else{m(B,i,O);}}function w(E){var B=this;if(p(B)>1){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];if(G.getId()!=E.oSource.getId()){G._bindMousemove();}}}}function x(E){var B=this;if(p(B)>1){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){var G=F[i];if(G.getId()!=E.oSource.getId()){G._unbindMousemove();}}}}function y(E){var F=new U(this._getFocusedDate().getTime());var i=this.getAggregation("monthPicker");var B=i.getMonth();var G=this;F.setUTCMonth(B);if(B!=F.getUTCMonth()){F.setUTCDate(0);}m(G,F,true);f(G);}function z(E){var F=new U(this._getFocusedDate().getTime());var i=this.getAggregation("yearPicker");var B=i.getYear();var G=this;F.setUTCFullYear(B);m(G,F,true);h(G);}function A(T){T._sInvalidateMonth=undefined;var B=T.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];E._bDateRangeChanged=true;E._bInvalidateSync=true;if(B.length>1){E._bNoFocus=true;}E.invalidate();E._bInvalidateSync=undefined;}if(B.length>1){m(T,T._getFocusedDate(),true);}T._bDateRangeChanged=undefined;}}());return c;},true);
