/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/m/Text","sap/m/Link","sap/m/ActionSelect","sap/m/Button","sap/ui/core/Item","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device"],function(C,T,L,S,B,I,a,R,b,D){"use strict";var c=C.extend("sap.m.Breadcrumbs",{metadata:{library:"sap.m",properties:{currentLocationText:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},_currentLocation:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},defaultAggregation:"links"}});c.prototype.onBeforeRendering=function(){if(this._bControlsInfoCached){this._updateSelect(true);}};c.prototype.onAfterRendering=function(){if(!this._bControlsInfoCached){this._updateSelect(true);return;}this._configureKeyboardHandling();};c.prototype.exit=function(){this._resetControl();this._destroyItemNavigation();};c.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;c._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m");};c.prototype._getAugmentedId=function(s){return this.getId()+"-"+s;};c.prototype._getSelectButton=function(){if(!this._closeButton){this._closeButton=new B({id:this._getAugmentedId("closeButton"),text:c._getResourceBundle().getText("BREADCRUMB_CLOSE"),press:this._selectCancelButtonHandler.bind(this),visible:D.system.phone});}return this._closeButton;};c.prototype._getSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",this._decorateSelect(new S({id:this._getAugmentedId("select"),change:this._selectChangeHandler.bind(this),forceSelection:false,autoAdjustWidth:true,icon:b.getIconURI("slim-arrow-down"),type:sap.m.SelectType.IconOnly,buttons:[this._getSelectButton()]})));}return this.getAggregation("_select");};c.prototype._getCurrentLocation=function(){if(!this.getAggregation("_currentLocation")){this.setAggregation("_currentLocation",new T({id:this._getAugmentedId("currentText"),text:this.getCurrentLocationText(),wrapping:false}).addStyleClass("sapMBreadcrumbsCurrentLocation"));}return this.getAggregation("_currentLocation");};function f(A,d){var e=Array.prototype.slice.apply(d);e.unshift(A);return e;}c.prototype.insertLink=function(l){var r=this.insertAggregation.apply(this,f("links",arguments));this._registerControlListener(l);this._resetControl();return r;};c.prototype.addLink=function(l){var r=this.addAggregation.apply(this,f("links",arguments));this._registerControlListener(l);this._resetControl();return r;};c.prototype.removeLink=function(l){this._deregisterControlListener(l);this._resetControl();return this.removeAggregation.apply(this,f("links",arguments));};c.prototype.removeAllLinks=function(){this.getAggregation("links").forEach(this._deregisterControlListener,this);this._resetControl();return this.removeAllAggregation.apply(this,f("links",arguments));};c.prototype.destroyLinks=function(){this.getAggregation("links").forEach(this._deregisterControlListener,this);this._resetControl();return this.destroyAggregation.apply(this,f("links",arguments));};c.prototype._decorateSelect=function(s){s.getPicker().attachAfterOpen(this._removeItemNavigation,this).attachBeforeClose(this._restoreItemNavigation,this);s._onBeforeOpenDialog=this._onSelectBeforeOpenDialog.bind(this);s._onBeforeOpenPopover=this._onSelectBeforeOpenPopover.bind(this);s.onsapescape=this._onSelectEscPress.bind(this);return s;};c.prototype._removeItemNavigation=function(){this.removeDelegate(this._getItemNavigation());};c.prototype._onSelectBeforeOpenDialog=function(){var s=this._getSelect();if(this.getCurrentLocationText()&&D.system.phone){s.setSelectedIndex(0);}else{s.setSelectedItem(null);s.getPicker().getCustomHeader().getContentLeft()[0].setValue(null);}S.prototype._onBeforeOpenDialog.call(s);this._removeItemNavigation();};c.prototype._onSelectBeforeOpenPopover=function(){this._getSelect().setSelectedItem(null);this._removeItemNavigation();};c.prototype._restoreItemNavigation=function(){this.addDelegate(this._getItemNavigation());};c.prototype._onSelectEscPress=function(){this._getSelect().close();};c.prototype._createSelectItem=function(i){return new I({key:i.getId(),text:i.getText()});};c.prototype._selectChangeHandler=function(e){var l,s,d,o=e.getParameter("selectedItem");if(!o){return;}if(!this._getSelect().isOpen()){return;}l=sap.ui.getCore().byId(o.getKey());if(!(l instanceof L)){return;}s=l.getHref();d=l.getTarget();l.firePress();if(s){if(d){window.open(s,d);}else{window.location.href=s;}}};c.prototype._selectCancelButtonHandler=function(){this._getSelect().close();};c.prototype._getItemsForMobile=function(){var i=this.getLinks();if(this.getCurrentLocationText()){i.push(this._getCurrentLocation());}return i;};c.prototype._updateSelect=function(i){var s=this._getSelect(),d,o=this._getControlDistribution();if(!this._bControlDistributionCached||i){s.removeAllItems();d=D.system.phone?this._getItemsForMobile():o.aControlsForSelect;d.map(this._createSelectItem).reverse().forEach(s.insertItem,s);this._bControlDistributionCached=true;this.invalidate(this);}s.setVisible(!!o.aControlsForSelect.length);if(!this._sResizeListenerId){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}};c.prototype._getControlsForBreadcrumbTrail=function(){if(this._bControlDistributionCached&&this._oDistributedControls){return this._oDistributedControls.aControlsForBreadcrumbTrail;}if(this.getCurrentLocationText()){return this.getLinks().concat([this._getCurrentLocation()]);}return this.getLinks();};c.prototype._getControlInfo=function(o){return{id:o.getId(),control:o,width:o.$().parent().outerWidth(true),bCanOverflow:o instanceof L};};c.prototype._getControlDistribution=function(m){m=m||this._iContainerSize;this._iContainerSize=m;this._oDistributedControls=this._determineControlDistribution(m);return this._oDistributedControls;};c.prototype._determineControlDistribution=function(m){var i,o,d=this._getControlsInfo().aControlInfo,s=this._iSelectWidth,e=[],g=[],u=s;for(i=d.length-1;i>=0;i--){o=d[i];u+=o.width;if(d.length-1===i){g.push(o.control);continue;}if(i===0){u-=s;}if(u>m&&o.bCanOverflow){e.unshift(o.control);}else{g.unshift(o.control);}}return{aControlsForBreadcrumbTrail:g,aControlsForSelect:e};};c.prototype._getControlsInfo=function(){if(!this._bControlsInfoCached){this._iSelectWidth=this._getSelect().$().parent().outerWidth(true)||0;this._aControlInfo=this._getControlsForBreadcrumbTrail().map(this._getControlInfo);this._iContainerSize=this.$().outerWidth(true);this._bControlsInfoCached=true;}return{aControlInfo:this._aControlInfo,iSelectWidth:this._iSelectWidth,iContentSize:this._iContainerSize};};c.prototype._handleScreenResize=function(e){var i=this._oDistributedControls.aControlsForBreadcrumbTrail.length,o=this._getControlDistribution(e.size.width),d=o.aControlsForBreadcrumbTrail.length;if(i!==d){this._updateSelect(true);}return this;};c.prototype._getItemsToNavigate=function(){var i=this._getControlsForBreadcrumbTrail().slice(),s=this._getSelect();if(s.getVisible()){i.unshift(s);}return i;};c.prototype._getItemNavigation=function(){if(!this._itemNavigation){this._itemNavigation=new a();}return this._itemNavigation;};c.prototype._destroyItemNavigation=function(){if(this._itemNavigation){this.removeEventDelegate(this._itemNavigation);this._itemNavigation.destroy();this._itemNavigation=null;}};c.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),s=-1,d=this._getItemsToNavigate(),n=[];d.forEach(function(o,e){if(e===0){o.$().attr("tabIndex","0");}o.$().attr("tabIndex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setCycling(false);i.setPageSize(c.PAGEUP_AND_PAGEDOWN_JUMP_SIZE);i.setRootDomRef(this.getDomRef());i.setItemDomRefs(n);i.setSelectedIndex(s);return this;};c.prototype._registerControlListener=function(o){if(o){o.attachEvent("_change",this._resetControl,this);}};c.prototype._deregisterControlListener=function(o){if(o){o.detachEvent("_change",this._resetControl,this);}};c.prototype.setCurrentLocationText=function(t){var o=this._getCurrentLocation(),r=this.setProperty("currentLocationText",t,true);if(o.getText()!==t){o.setText(t);this._resetControl();}return r;};c.prototype._resetControl=function(){this._aControlInfo=null;this._iContainerSize=null;this._bControlsInfoCached=null;this._bControlDistributionCached=null;this._oDistributedControls=null;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.removeDelegate(this._getItemNavigation());this.invalidate(this);return this;};return c;},true);
