/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";var T=C.extend("sap.m.TabContainer",{metadata:{library:"sap.m",properties:{showAddNewButton:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{items:{type:"sap.m.TabContainerItem",multiple:true},_addNewButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_tabStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.m.TabContainerItem",multiple:false}},events:{itemClose:{allowPreventDefault:true,parameters:{item:{type:"sap.m.TabContainerItem"}}},itemSelect:{parameters:{item:{type:"sap.m.TabContainerItem"}}},addNewButtonPress:{}}},constructor:function(i,s){var S=[];if(!s&&typeof i==='object'){s=i;}if(s&&Array.isArray(s['items'])){S=s['items'];delete s['items'];}sap.ui.base.ManagedObject.prototype.constructor.apply(this,arguments);var c=new sap.m.TabStrip(this.getId()+"--tabstrip",{hasSelect:true,itemPress:function(e){var I=e.getParameter("item"),o=this._fromTabStripItem(I);this.fireItemSelect({item:o});this.setSelectedItem(o);}.bind(this),itemCloseRequest:function(e){var I=e.getParameter("item"),r=this._fromTabStripItem(I);e.preventDefault();if(this.fireItemClose({item:r})){this.removeItem(r);}}.bind(this)});this.setAggregation("_tabStrip",c,true);if(s&&s['showAddNewButton']){this.setShowAddNewButton(true);}S.forEach(function(I){this.addItem(I);},this);}});T.prototype.onBeforeRendering=function(){if(this.getSelectedItem()){return;}this._setDefaultTab();};T.prototype._getAddNewTabButton=function(){var c=this.getAggregation("_addNewButton");var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!c){c=new sap.m.Button({type:sap.m.ButtonType.Transparent,tooltip:r.getText("TABCONTAINER_ADD_NEW_TAB"),icon:sap.ui.core.IconPool.getIconURI("add"),press:function(){this.getParent().getParent().fireAddNewButtonPress();}});this.setAggregation("_addNewButton",c,true);}return c;};T.prototype._getTabStrip=function(){return this.getAggregation("_tabStrip");};T.prototype._fromTabStripItem=function(I){var a=this.getItems()||[],b=a.length,i=0;for(;i<b;i++){if(a[i].getId()===I.getKey()){return a[i];}}return null;};T.prototype._toTabStripItem=function(I){var i=0,k=I,t,o,a=this._getTabStrip();if(!a){return null;}t=a.getItems();o=t.length;if(typeof I==="object"){k=I.getId();}for(;i<o;i++){if(t[i].getKey()===k){return t[i];}}return null;};T.prototype._getSelectedItemContent=function(){var t=this._getTabStrip(),s=this.getSelectedItem(),S=sap.ui.getCore().byId(s),o=this._toTabStripItem(S);if(t){t.setSelectedItem(o);}return S?S.getContent():null;};T.prototype._moveToNextItem=function(s){var i=this.getItems().length,c=this._getTabStrip()._oItemNavigation.getFocusedIndex(),n=i===c?--c:c,N=this.getItems()[n],f=function(){this._getTabStrip()._oItemNavigation.focusItem(n);};if(s){this.setSelectedItem(N);this.fireItemSelect({item:N});}q.sap.delayedCall(0,this,f);};T.prototype.removeItem=function(i){var I;if(!i){return null;}I=i.getId()===this.getSelectedItem();i=this.removeAggregation("items",i);this._getTabStrip().removeItem(this._toTabStripItem(i));this._moveToNextItem(I);return i;};T.prototype.addAggregation=function(a,o,s){if(a==='items'){o.attachItemPropertyChanged(function(e){var t=this._toTabStripItem(e.getSource());var p=e['mParameters'].propertyKey;if(p==='name'){p='text';}if(t){t.setProperty(p,e['mParameters'].propertyValue);}}.bind(this));}return C.prototype.addAggregation.call(this,a,o,s);};T.prototype.addItem=function(i){this.addAggregation("items",i);this._getTabStrip().addItem(new sap.m.TabStripItem({key:i.getId(),text:i.getName(),modified:i.getModified()}));return i;};T.prototype.destroyItems=function(){this._getTabStrip().destroyItems();return this.destroyAggregation("items");};T.prototype.insertItem=function(i,I){this._getTabStrip().insertItem(new sap.m.TabStripItem({key:i.getId(),text:i.getName(),modified:i.getModified()}),I);return this.insertAggregation("items",i,I);};T.prototype.removeAllItems=function(){this._getTabStrip().removeAllItems();this.setSelectedItem(null);return this.removeAllAggregation("items");};T.prototype.setAddButton=function(b){return this._getTabStrip().setAddButton(b);};T.prototype.getAddButton=function(){return this._getTabStrip().getAddButton();};T.prototype.setShowAddNewButton=function(s){var t=this._getTabStrip();if(t){t.setAddButton(s?this._getAddNewTabButton():null);}};T.prototype.setSelectedItem=function(s){var t=this._getTabStrip();if(s&&t){t.setSelectedItem(this._toTabStripItem(s));this._rerenderContent(s.getContent());}return T.prototype.setAssociation.call(this,"selectedItem",s,true);};T.prototype._rerenderContent=function(c){var $=this.$("content"),r;if(!c||($.length<=0)){return;}r=sap.ui.getCore().createRenderManager();for(var i=0;i<c.length;i++){r.renderControl(c[i]);}r.flush($[0]);r.destroy();};T.prototype._setDefaultTab=function(){var f=this.getItems()[0]||null;this.setSelectedItem(f);return f;};return T;},true);
