/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/Header','./calendar/Month','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,b,H,M,c,d,Y,U,l){"use strict";var e=b.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}}}});e.prototype.init=function(){b.prototype.init.apply(this,arguments);var m=this.getAggregation("monthPicker");m.setColumns(0);m.setMonths(3);var y=this.getAggregation("yearPicker");y.setColumns(0);y.setYears(3);this._iDaysLarge=10;this._iDaysMonthHead=35;};e.prototype._createMonth=function(i){var m=new c(i);return m;};e.prototype.setStartDate=function(s){if(!(s instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var y=s.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}var u=a._createUniversalUTCDate(s,this.getPrimaryCalendarType());this.setProperty("startDate",s,true);this._oUTCStartDate=u;var o=this.getAggregation("month")[0];o.setStartDate(s);this._updateHeader(u);var h=a._createLocalDate(this._getFocusedDate());if(!o.checkDateFocusable(h)){this._setFocusedDate(u);o.displayDate(s);}return this;};e.prototype.getStartDate=function(){return this.getProperty("startDate");};e.prototype.setDays=function(i){this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var h=Math.ceil(i/3);if(h>12){h=12;}m.setMonths(h);var y=this.getAggregation("yearPicker");var j=Math.floor(i/2);if(j>20){j=20;}y.setYears(j);}var s=f.call(this);this._updateHeader(s);if(this.getDomRef()){if(i>this._iDaysLarge){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};e.prototype._getDays=function(){var i=this.getDays();if(sap.ui.Device.system.phone&&i>8){return 8;}else{return i;}};e.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};e.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};e.prototype._getFocusedDate=function(){if(!this._oFocusedDate){b.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){_.call(this,this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(a._createLocalDate(this._oFocusedDate))){this._oFocusedDate=a._createUniversalUTCDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};e.prototype.setMonths=function(m){if(m==1){this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};e.prototype.setFirstDayOfWeek=function(F){if(F==-1){this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};e.prototype.focusDate=function(o){var h=this.getAggregation("month")[0];if(!h.checkDateFocusable(o)){var u=a._createUniversalUTCDate(o,this.getPrimaryCalendarType());this._focusDateExtend(u,true,true);}b.prototype.focusDate.apply(this,arguments);return this;};e.prototype._focusDateExtend=function(o,O,n){if(O){var h=this._getFocusedDate();var s=f.call(this);var i=Math.ceil((h.getTime()-s.getTime())/(1000*3600*24));s=this._newUniversalDate(o);s.setUTCDate(s.getUTCDate()-i);_.call(this,s,false,true);if(!n){return true;}}return false;};e.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(p){m.setColumns(3);m.setMonths(12);y.setColumns(4);y.setYears(20);}else{m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);}};e.prototype._handlePrevious=function(E){var F=this._newUniversalDate(this._getFocusedDate());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=this._newUniversalDate(f.call(this));var i=this._getDays();switch(this._iMode){case 0:s.setUTCDate(s.getUTCDate()-i);F.setUTCDate(F.getUTCDate()-i);this._setFocusedDate(F);_.call(this,s,true);break;case 1:if(m.getMonths()<12){m.previousPage();}else{F.setUTCFullYear(F.getUTCFullYear()-1);var h=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);if(h){this.fireStartDateChange();}}break;case 2:y.previousPage();break;}};e.prototype._handleNext=function(E){var F=this._newUniversalDate(this._getFocusedDate());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=this._newUniversalDate(f.call(this));var i=this._getDays();switch(this._iMode){case 0:s.setUTCDate(s.getUTCDate()+i);F.setUTCDate(F.getUTCDate()+i);this._setFocusedDate(F);_.call(this,s,true);break;case 1:if(m.getMonths()<12){m.nextPage();}else{F.setUTCFullYear(F.getUTCFullYear()+1);var h=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);if(h){this.fireStartDateChange();}}break;case 2:y.nextPage();break;}};e.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getUTCMonth();var h=this._getDays();m.push(i);if(h>this._iDaysLarge){var E=this._newUniversalDate(o);E.setUTCDate(E.getUTCDate()+h-1);var j=E.getUTCMonth();while(i!=j){i=(i+1)%12;m.push(i);}}return m;};e.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=f.call(this);S=U.getInstance(S.getJSDate(),s);var h=S.getUTCMonth();var E=this._newUniversalDate(S);E.setUTCDate(E.getUTCDate()+i-1);E=U.getInstance(E.getJSDate(),s);var j=E.getUTCMonth();return{start:h,end:j};};e.prototype._openPickerPopup=function(p){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(g,this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var h=this.getAggregation("header");var i=sap.ui.core.Popup.Dock;this._oPopup.open(0,i.CenterTop,i.CenterBottom,h,null,"flipfit",true);};function _(s,S,n){var m=this._newUniversalDate(this._oMaxDate);m.setUTCDate(m.getUTCDate()-this._getDays());if(s.getTime()<this._oMinDate.getTime()){s=this._oMinDate;}else if(s.getTime()>m.getTime()){s=m;}var o=a._createLocalDate(s);this.setProperty("startDate",o,true);this._oUTCStartDate=s;var h=this.getAggregation("month")[0];h.setStartDate(o);this._updateHeader(s);if(S){var i=a._createLocalDate(this._getFocusedDate());if(!h.checkDateFocusable(i)){this._setFocusedDate(s);h.setDate(o);}else{h.setDate(i);}}if(!n){this.fireStartDateChange();}}function f(){if(!this._oUTCStartDate){this._oUTCStartDate=this._getFocusedDate();}return this._oUTCStartDate;}function g(E){this._closedPickers();}return e;},true);
