// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.uxap.library-all');
if ( !jQuery.sap.isDeclared('sap.uxap.BlockBaseMetadata') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.uxap.BlockBaseMetadata
jQuery.sap.declare('sap.uxap.BlockBaseMetadata'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ElementMetadata'); // unlisted dependency retained
sap.ui.define("sap/uxap/BlockBaseMetadata",["jquery.sap.global", "sap/ui/core/ElementMetadata"], function (jQuery, ElementMetadata) {
	"use strict";


	/**
	 * Creates a new metadata object for a BlockBase subclass.
	 *
	 * @param {string} sClassName fully qualified name of the class that is described by this metadata object
	 * @param {object} oClassInfo static info to construct the metadata from
	 *
	 * @class
	 * @author SAP SE
	 * @version 1.34.6
	 * @since 1.26
	 * @alias sap.uxap.BlockBaseMetadata
	 */
	var BlockBaseMetadata = function (sClassName, oClassInfo) {

		// call super constructor
		ElementMetadata.apply(this, arguments);
		this._mViews = oClassInfo.metadata.views || {};

	};

	//chain the prototypes
	BlockBaseMetadata.prototype = jQuery.sap.newObject(ElementMetadata.prototype);

	BlockBaseMetadata.prototype.applySettings = function (oClassInfo) {
		var vRenderer = oClassInfo.hasOwnProperty("renderer") ? (oClassInfo.renderer || "") : undefined;
		ElementMetadata.prototype.applySettings.call(this, oClassInfo);
		if (vRenderer == null) {
			// If a renderer has been defined on the block then use it, otherwise use the BlockBaseRenderer
			this._sRendererName = null;
		}
	};

	/**
	 * Determines the class name of the renderer for the described control class.
	 * @returns {string} renderer name
	 */
	BlockBaseMetadata.prototype.getRendererName = function () {

		//if we have not resolved the renderer yet
		if (!this._sBlockRenderer) {
			this._sBlockRenderer = this._resolveRendererName();
			jQuery.sap.log.debug("BlockBaseMetadata :: " + this.getName() + " is renderer with " + this._sBlockRenderer);
		}

		return this._sBlockRenderer;
	};

	BlockBaseMetadata.prototype._resolveRendererName = function () {
		var sCandidateRenderer = ElementMetadata.prototype.getRendererName.call(this);

		//we test if a specific render has been provided, in this case we keep it
		if (sCandidateRenderer == null) {
			var oParent = this.getParent();
			if (oParent) {
				sCandidateRenderer = BlockBaseMetadata.prototype._resolveRendererName.apply(oParent);
			} else {
				throw new Error("BlockBaseMetadata :: no renderer found for " + this.getName());
			}
		}
		return sCandidateRenderer;
	};


	/**
	 * return a view from its name
	 * @param {*} sViewName
	 * @returns {*} view
	 */
	BlockBaseMetadata.prototype.getView = function (sViewName) {
		return this._mViews[sViewName];
	};

	/**
	 * return the view definition object
	 * @returns {*} view
	 */
	BlockBaseMetadata.prototype.getViews = function () {
		return this._mViews;
	};

	/**
	 * setter for the view
	 * @param {*} sViewName the name of the view
	 * @param {*} oViewParameters view parameters
	 * @returns {*} this
	 */
	BlockBaseMetadata.prototype.setView = function (sViewName, oViewParameters) {
		this._mViews[sViewName] = oViewParameters;
		return this;
	};

	/**
	 * checks whether some view are defined
	 * @returns {*} has views
	 */
	BlockBaseMetadata.prototype.hasViews = function () {
		return !jQuery.isEmptyObject(this._mViews);
	};

	return BlockBaseMetadata;

}, /* bExport= */ true);

}; // end of sap/uxap/BlockBaseMetadata.js
if ( !jQuery.sap.isDeclared('sap.uxap.BlockBaseRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.BlockBaseRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/uxap/BlockBaseRenderer",function () {
	"use strict";

	var BlockBaseRenderer = {};

	BlockBaseRenderer.render = function (oRm, oControl) {

		if (!oControl.getVisible()) {
			return;
		}

		oRm.write("<div");
		oRm.writeControlData(oControl);
		if (oControl._getSelectedViewContent()) {
			oRm.addClass('sapUxAPBlockBase');
			oRm.addClass("sapUxAPBlockBase" + oControl.getMode());
		} else {
			var sClassShortName = oControl.getMetadata().getName().split(".").pop();

			oRm.addClass('sapUxAPBlockBaseDefaultSize');
			oRm.addClass('sapUxAPBlockBaseDefaultSize' + sClassShortName + oControl.getMode());
		}
		oRm.writeClasses();
		oRm.write(">");

		if (oControl._getSelectedViewContent()) {
			oRm.renderControl(oControl._getSelectedViewContent());
		}
		oRm.write("</div>");
	};

	return BlockBaseRenderer;

}, /* bExport= */ true);

}; // end of sap/uxap/BlockBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.uxap.BreadCrumbsRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.BreadCrumbsRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/uxap/BreadCrumbsRenderer",function () {
	"use strict";

	/**
	 * @class BreadCrumbs renderer.
	 * @static
	 */
	var BreadCrumbsRenderer = {};

	BreadCrumbsRenderer.render = function (oRm, oControl) {
		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass("sapUxAPBreadCrumbs");
		oRm.writeClasses();
		oRm.writeAttribute("role", "navigation");
		oRm.writeAttributeEscaped("aria-labelledby", oControl._getAriaLabelledBy().getId());
		oRm.write(">");

		this._renderOverflowSelect(oRm, oControl);

		if (!oControl._bOnPhone) {
			this._renderBreadcrumbTrail(oRm, oControl);
		}

		oRm.write("</div>");
	};

	BreadCrumbsRenderer._renderBreadcrumbTrail = function (oRm, oControl) {
		var aLinks = oControl.getLinks(),
			oCurrentLocation = oControl.getCurrentLocation(),
			oTubeIcon = oControl._getTubeIcon(),
			bShowCurrentLocation = oControl.getShowCurrentLocation();

		oRm.write("<ul id='" + oControl.getId() + "-breadcrumbs'");
		oRm.write(">");
		aLinks.forEach(function (oLink) {
			oRm.write("<li>");
			oRm.renderControl(oLink);
			oRm.renderControl(oTubeIcon);
			oRm.write("</li>");
		});
		if (bShowCurrentLocation) {
			oRm.write("<li>");
			oRm.renderControl(oCurrentLocation);
			oRm.write("</li>");
		}
		oRm.write("</ul>");
	};

	BreadCrumbsRenderer._renderOverflowSelect = function (oRm, oControl) {
		var oTubeIcon = oControl._getTubeIcon();

		oRm.write("<div id='" + oControl.getId() + "-select'");
		oRm.addClass("sapUiHidden");
		oRm.writeClasses();
		oRm.write(">");
		oRm.write('<span class="sapUxAPBreadCrumbsDots">...</span>');
		oRm.renderControl(oTubeIcon);
		oRm.renderControl(oControl._getOverflowSelect());
		oRm.write("</div>");
	};

	return BreadCrumbsRenderer;

}, /* bExport= */ true);

}; // end of sap/uxap/BreadCrumbsRenderer.js
if ( !jQuery.sap.isDeclared('sap.uxap.HierarchicalSelectRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.HierarchicalSelectRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.SelectRenderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/uxap/HierarchicalSelectRenderer",["sap/m/SelectRenderer", "sap/ui/core/Renderer"
], function (SelectRenderer, Renderer) {
	"use strict";

	/**
	 * @class ObjectPageRenderer renderer.
	 * @static
	 */
	var HierarchicalSelectRenderer = Renderer.extend(SelectRenderer);

	HierarchicalSelectRenderer.addStyleClass = function (oRm) {
		oRm.addClass("sapUxAPHierarchicalSelect");
	};

	return HierarchicalSelectRenderer;

}, /* bExport= */ true);

}; // end of sap/uxap/HierarchicalSelectRenderer.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderActionButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.ObjectPageHeaderActionButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.ButtonRenderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageHeaderActionButtonRenderer",["sap/m/ButtonRenderer", "sap/ui/core/Renderer"],
	function (ButtonRenderer, Renderer) {
		"use strict";

		/**
		 * @class ObjectPageRenderer renderer.
		 * @static
		 */
		var ObjectPageHeaderActionButtonRenderer = Renderer.extend(ButtonRenderer);


		return ObjectPageHeaderActionButtonRenderer;

	}, /* bExport= */ true);

}; // end of sap/uxap/ObjectPageHeaderActionButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageLayout.designtime') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the Design Time Metadata for the sap.uxap.ObjectPageLayout control
jQuery.sap.declare('sap.uxap.ObjectPageLayout.designtime'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/uxap/ObjectPageLayout.designtime",[],
	function() {
	"use strict";

	return {
		aggregations : {
			sections : {
				domRef : ":sap-domref > .sapUxAPObjectPageWrapper"
			}
		},

		cloneDomRef : ":sap-domref > header"
	};

}, /* bExport= */ false);
}; // end of sap/uxap/ObjectPageLayout.designtime.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageSectionRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.ObjectPageSectionRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/uxap/ObjectPageSectionRenderer",function () {
	"use strict";

	/**
	 * @class Section renderer.
	 * @static
	 */
	var ObjectPageSectionRenderer = {};

	ObjectPageSectionRenderer.render = function (oRm, oControl) {

		if (!oControl.getVisible() || !oControl._getInternalVisible()) {
			return;
		}
		var sTitle = oControl._getInternalTitle() ? oControl._getInternalTitle() : oControl.getTitle();

		oRm.write("<section ");
		oRm.addClass("sapUxAPObjectPageSection");
		oRm.writeClasses();
		oRm.writeAttribute("role", "region");
		oRm.writeAttributeEscaped("aria-labelledby", oControl.getAggregation("ariaLabelledBy").getId());
		oRm.writeControlData(oControl);
		oRm.write(">");

		if (oControl.getShowTitle() && oControl._getInternalTitleVisible()) {
			oRm.write("<div");
			oRm.writeAttribute("role", "heading");
			oRm.writeAttributeEscaped("id", oControl.getId() + "-header");
			oRm.addClass("sapUxAPObjectPageSectionHeader");
			oRm.writeClasses();
			oRm.write(">");

			oRm.write("<div");
			oRm.writeAttributeEscaped("id", oControl.getId() + "-title");
			oRm.addClass("sapUxAPObjectPageSectionTitle");
			if (oControl.getTitleUppercase()) {
				oRm.addClass("sapUxAPObjectPageSectionTitleUppercase");
			}
			oRm.writeClasses();
			oRm.write(">");
			oRm.writeEscaped(sTitle);
			oRm.write("</div>");
			oRm.renderControl(oControl._getShowHideAllButton());
			oRm.renderControl(oControl._getShowHideButton());
			oRm.write("</div>");
		}

		oRm.write("<div");
		oRm.addClass("sapUxAPObjectPageSectionContainer");
		oRm.writeClasses();
		oRm.write(">");

		oControl.getSubSections().forEach(oRm.renderControl);

		oRm.write("</div>");

		oRm.write("</section>");
	};

	return ObjectPageSectionRenderer;

}, /* bExport= */ true);

}; // end of sap/uxap/ObjectPageSectionRenderer.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageSubSectionRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.ObjectPageSubSectionRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/uxap/ObjectPageSubSectionRenderer",function () {
	"use strict";

	/**
	 * @class Section renderer.
	 * @static
	 */
	var ObjectPageSubSectionRenderer = {};

	ObjectPageSubSectionRenderer.render = function (oRm, oControl) {
		var aActions, bHasTitle, bHasTitleLine, bHasActions;

		if (!oControl.getVisible() || !oControl._getInternalVisible()) {
			return;
		}

		aActions = oControl.getActions() || [];
		bHasActions = aActions.length > 0;
		bHasTitle = (oControl._getInternalTitleVisible() && (oControl.getTitle().trim() !== ""));
		bHasTitleLine = bHasTitle || bHasActions;

		oRm.write("<div ");
		oRm.writeAttribute("role", "region");
		oRm.writeControlData(oControl);
		oRm.addClass("sapUxAPObjectPageSubSection");
		oRm.writeClasses(oControl);
		oRm.writeClasses();
		oRm.write(">");

		if (bHasTitleLine) {
			oRm.write("<div");
			oRm.addClass("sapUxAPObjectPageSubSectionHeader");
			oRm.writeAttributeEscaped("id", oControl.getId() + "-header");
			oRm.writeClasses();
			oRm.write(">");

			oRm.write("<div");
			if (bHasTitle) {
				oRm.writeAttribute("role", "heading");
			}
			oRm.addClass('sapUxAPObjectPageSubSectionHeaderTitle');
			if (oControl.getTitleUppercase()) {
				oRm.addClass("sapUxAPObjectPageSubSectionHeaderTitleUppercase");
			}
			oRm.writeAttributeEscaped("id", oControl.getId() + "-headerTitle");
			oRm.writeClasses();
			oRm.writeAttribute("data-sap-ui-customfastnavgroup", true);
			if (bHasTitle) {
				oRm.writeAttribute("tabindex", 0);
			}
			oRm.write(">");
			if (bHasTitle) {
				oRm.writeEscaped(oControl.getTitle());
			}
			oRm.write("</div>");

			if (bHasActions) {
				oRm.write("<div");
				oRm.addClass('sapUxAPObjectPageSubSectionHeaderActions');
				oRm.writeClasses();
				oRm.writeAttribute("data-sap-ui-customfastnavgroup", true);
				oRm.write(">");
				aActions.forEach(oRm.renderControl);
				oRm.write("</div>");
			}

			oRm.write("</div>");
		}

		oRm.write("<div");
		oRm.addClass("ui-helper-clearfix");
		oRm.addClass("sapUxAPBlockContainer");
		oRm.addClass("sapUiResponsiveMargin");
		oRm.writeClasses();
		oRm.write(">");

		oRm.renderControl(oControl._getGrid());

		oRm.write("<div");
		oRm.addClass("sapUxAPSubSectionSeeMoreContainer");
		oRm.writeClasses();
		oRm.write(">");
		oRm.renderControl(oControl._getSeeMoreButton());
		oRm.write("</div>");
		oRm.write("</div>");
		oRm.write("</div>");
	};


	return ObjectPageSubSectionRenderer;

}, /* bExport= */ true);

}; // end of sap/uxap/ObjectPageSubSectionRenderer.js
if ( !jQuery.sap.isDeclared('sap.uxap.component.Component') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.component.Component'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.uxap.ObjectPageConfigurationMode'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
sap.ui.define("sap/uxap/component/Component",[
	"sap/uxap/ObjectPageConfigurationMode",
	"sap/ui/core/UIComponent",
	"sap/ui/model/json/JSONModel",
	"sap/ui/core/Component"
], function (ObjectPageConfigurationMode, UIComponent, JSONModel /*, Component*/) {
	"use strict";

	var Component = UIComponent.extend("sap.uxap.component.Component", {
		metadata: {
			/* nothing new compared to a standard UIComponent */
		},

		/**
		 * initialize the view containing the objectPageLayout
		 */
		init: function () {

			//step1: create model from configuration
			this._oModel = null;               //internal component model
			this._oViewConfig = {              //internal view configuration
				viewData: {
					component: this
				}
			};

			//step2: load model from the component configuration
			switch (this.oComponentData.mode) {
				case ObjectPageConfigurationMode.JsonURL:
					// jsonUrl bootstraps the ObjectPageLayout on a json config url jsonConfigurationURL
					// case 1: load from an XML view + json for the object page layout configuration
					this._oModel = new UIComponent(this.oComponentData.jsonConfigurationURL);
					this._oViewConfig.viewName = "sap.uxap.component.ObjectPageLayoutUXDrivenFactory";
					this._oViewConfig.type = sap.ui.core.mvc.ViewType.XML;
					break;
				case ObjectPageConfigurationMode.JsonModel:
					// JsonModel bootstraps the ObjectPageLayout from the external model objectPageLayoutMedatadata
					this._oViewConfig.viewName = "sap.uxap.component.ObjectPageLayoutUXDrivenFactory";
					this._oViewConfig.type = sap.ui.core.mvc.ViewType.XML;
					break;
				default:
					jQuery.sap.log.error("UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation");
			}
			//create the UIComponent
			UIComponent.prototype.init.call(this);
		},

		/**
		 * Create view corresponding to the chosen config
		 * @returns {sap.ui.view} Created view
		 */
		createContent: function () {
			var oController;

			//step3: create view
			this._oView = sap.ui.view(this._oViewConfig);

			//step4: bind the view with the model
			if (this._oModel) {
				oController = this._oView.getController();

				//some factory requires pre-processing once the view and model are created
				if (oController && oController.connectToComponent) {
					oController.connectToComponent(this._oModel);
				}

				//can now apply the model and rely on the underlying factory logic
				this._oView.setModel(this._oModel, "objectPageLayoutMetadata");
			}

			return this._oView;
		},

		/**
		 * traps propagated properties for postprocessing on useExternalModel cases
		 * @param {*} vName the name of the property
		 * @returns {*} result of the function
		 */
		propagateProperties: function (vName) {

			if (this.oComponentData.mode === ObjectPageConfigurationMode.JsonModel) {
				var oController = this._oView.getController();

				//some factory requires post-processing once the view and model are created
				if (oController && oController.connectToComponent) {
					oController.connectToComponent(this.getModel("objectPageLayoutMetadata"));
				}
			}
			return UIComponent.prototype.propagateProperties.apply(this, arguments);
		},

		/**
		 * destroy the view and model before exiting
		 */
		destroy: function () {
			if (this._oView) {
				this._oView.destroy();
				this._oView = null;
			}

			if (this._oModel) {
				this._oModel.destroy();
				this._oModel = null;
			}

			if (UIComponent.prototype.destroy) {
				UIComponent.prototype.destroy.call(this);
			}
		}
	});

	return Component;
});

}; // end of sap/uxap/component/Component.js
if ( !jQuery.sap.isDeclared('sap.uxap.component.ObjectPageComponentContainer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.component.ObjectPageComponentContainer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.ComponentContainer'); // unlisted dependency retained
jQuery.sap.require('sap.uxap.ObjectPageConfigurationMode'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
sap.ui.define("sap/uxap/component/ObjectPageComponentContainer",['sap/ui/core/ComponentContainer', 'sap/uxap/ObjectPageConfigurationMode', "sap/ui/core/Component"],
	function (ComponentContainer, ObjectPageConfigurationMode /*, Component */)  {
		"use strict";

		/**
		 * The objectPageComponentContainer initialize and render an objectPageLayout
		 */
		var ObjectPageComponentContainer = ComponentContainer.extend("sap.uxap.component.ObjectPageComponentContainer", {
			metadata: {
				properties: {
					"jsonConfigurationURL": {type: "string", group: "Behavior"},
					"mode": {type: "sap.uxap.ObjectPageConfigurationMode", group: "Behavior"}
				}
			},

			/**
			 *  initialize the component container and set default configuration
			 */
			init: function () {
				//set default config
				this.setPropagateModel(true);
				this.setName("sap.uxap.component");
			},

			/**
			 * this ComponentContainer is working only with one component: the objectPageLayout
			 * unlike the standard ComponentContainer, this ones exposes properties to the outside world and pass them on to the underlying component
			 */
			onBeforeRendering: function () {
				this._oComponent = sap.ui.component("sap.uxap");
				if (!this._oComponent) {
					this._oComponent = sap.ui.component({
						name: this.getName(),
						url: this.getUrl(),
						componentData: {            //forward configuration to underlying component
							jsonConfigurationURL: this.getJsonConfigurationURL(),
							mode: this.getMode()
						}
					});

					this.setComponent(this._oComponent, true);
				}

				// call the parent onBeforeRendering
				if (ComponentContainer.prototype.onBeforeRendering) {
					ComponentContainer.prototype.onBeforeRendering.call(this);
				}
			},

			/**
			 * Returns the instantiated objectPageLayout for further api manipulations or null if not not rendered already.
			 * @returns {sap.uxap.ObjectPageLayout} Layout instanse
			 */
			getObjectPageLayoutInstance: function () {
				var oObjectPageLayoutInstance = null;
				if (this._oComponent && this._oComponent._oView) {
					oObjectPageLayoutInstance = this._oComponent._oView.byId("ObjectPageLayout");
				} else {
					jQuery.sap.log.error("ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?");
				}

				return oObjectPageLayoutInstance;
			},

			/**
			 * use the standard renderer
			 */
			renderer: "sap.ui.core.ComponentContainerRenderer"
		});

		return ObjectPageComponentContainer;
	});

}; // end of sap/uxap/component/ObjectPageComponentContainer.js
if ( !jQuery.sap.isDeclared('sap.uxap.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.uxap.
 */
jQuery.sap.declare('sap.uxap.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.m.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.library'); // unlisted dependency retained
sap.ui.define("sap/uxap/library",["jquery.sap.global", "sap/ui/core/Core", "sap/ui/core/library", "sap/m/library", "sap/ui/layout/library"], function (jQuery, Core, library) {
	"use strict";

	/**
	 * SAP UxAP
	 *
	 * @namespace
	 * @name sap.uxap
	 * @public
	 */
		// library dependencies
		// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name: "sap.uxap",
		dependencies: ["sap.ui.core", "sap.m", "sap.ui.layout"],
		types: [
			"sap.uxap.BlockBaseColumnLayout",
			"sap.uxap.ObjectPageConfigurationMode",
			"sap.uxap.ObjectPageHeaderDesign",
			"sap.uxap.ObjectPageHeaderPictureShape",
			"sap.uxap.ObjectPageSubSectionLayout",
			"sap.uxap.ObjectPageSubSectionMode"
		],
		interfaces: [],
		controls: [
			"sap.uxap.AnchorBar",
			"sap.uxap.BlockBase",
			"sap.uxap.BreadCrumbs",
			"sap.uxap.HierarchicalSelect",
			"sap.uxap.ObjectPageHeader",
			"sap.uxap.ObjectPageHeaderActionButton",
			"sap.uxap.ObjectPageHeaderContent",
			"sap.uxap.ObjectPageLayout",
			"sap.uxap.ObjectPageSection",
			"sap.uxap.ObjectPageSectionBase",
			"sap.uxap.ObjectPageSubSection"
		],
		elements: [
			"sap.uxap.ModelMapping",
			"sap.uxap.ObjectPageHeaderLayoutData"
		],
		version: "1.34.6"
	});

	/**
	 * @class Used by the BlockBase control to define how many columns should it be assigned by the objectPageSubSection.
	 *     The allowed values can be auto (subsection assigned a number of columns based on the parent objectPageLayout subsectionLayout property), 1, 2 or 3
	 *     (This may not be a valid value for some subSectionLayout, for example asking for 3 columns in a 2 column layout would raise warnings).
	 *
	 * @static
	 * @public
	 * @ui5-metamodel This simple type also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.uxap.BlockBaseColumnLayout = sap.ui.base.DataType.createType('sap.uxap.BlockBaseColumnLayout', {
			isValid: function (vValue) {
				return /^(auto|[1-4]{1})$/.test(vValue);
			}

		},
		sap.ui.base.DataType.getType('string')
	);

	/**
	 * Used by the BlockBase control to define if it should do automatic adjustment of its nested forms.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @static
	 * @public
	 * @ui5-metamodel This simple type also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.uxap.BlockBaseFormAdjustment = {

		/**
		 * Any form within the block will be automatically adjusted to have as many columns as the colspan of its parent block.
		 * @public
		 */
		BlockColumns: "BlockColumns",
		/**
		 * Any form within the block will be automatically adjusted to have only one column.
		 * @public
		 */
		OneColumn: "OneColumn",
		/**
		 * No automatic adjustment of forms.
		 * @public
		 */
		None: "None"
	};

	/**
	 * Used by the sap.uxap.component.Component how to initialize the ObjectPageLayout sections and subsections.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.uxap.ObjectPageConfigurationMode = {

		/**
		 * Determines the JSON url
		 * @public
		 */
		JsonURL: "JsonURL",

		/**
		 * Determines the JSON model
		 * @public
		 */
		JsonModel: "JsonModel"

	};
	/**
	 * Used by the ObjectPageHeader control to define which design to use.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.uxap.ObjectPageHeaderDesign = {

		/**
		 * Light theme for the ObjectPageHeader.
		 * @public
		 */
		Light: "Light",

		/**
		 * Dark theme for the ObjectPageHeader.
		 * @public
		 */
		Dark: "Dark"

	};
	/**
	 * Used by the ObjectPageHeader control to define which shape to use for the image.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.uxap.ObjectPageHeaderPictureShape = {

		/**
		 * Circle shape for the images in the ObjectPageHeader.
		 * @public
		 */
		Circle: "Circle",

		/**
		 * Square shape for the images in the ObjectPageHeader.
		 * @public
		 */
		Square: "Square"

	};
	/**
	 * Used by the ObjectPagSubSection control to define which layout to apply.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.uxap.ObjectPageSubSectionLayout = {

		/**
		 * TitleOnTop: title and actions on top of the block area.
		 * @public
		 */
		TitleOnTop: "TitleOnTop",

		/**
		 * TitleOnLeft: title and actions on the left, inside the block area.
		 * @public
		 */
		TitleOnLeft: "TitleOnLeft"

	};
	/**
	 * Used by the ObjectPageLayout control to define which layout to use (either Collapsed or Expanded).
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.uxap.ObjectPageSubSectionMode = {

		/**
		 * Collapsed mode of display of the ObjectPageLayout.
		 * @public
		 */
		Collapsed: "Collapsed",

		/**
		 * Expanded mode of displaying the ObjectPageLayout.
		 * @public
		 */
		Expanded: "Expanded"

	};

	/**
	 * Used by the ObjectSectionBase control to define the importance of the content contained in it.
	 *
	 * @author SAP SE
	 * @enum {string}
	 * @public
	 * @since 1.32.0
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.uxap.Importance = {

		/**
		 * Low importance of the content
		 * @public
		 */
		Low: "Low",

		/**
		 * Medium importance of the content
		 * @public
		 */
		Medium: "Medium",

		/**
		 * High importance of the content
		 * @public
		 */
		High: "High"
	};

	sap.uxap.i18nModel = (function () {
		return new sap.ui.model.resource.ResourceModel({
			bundleUrl: jQuery.sap.getModulePath("sap.uxap.i18n.i18n", ".properties")
		});
	}());

	/**
	 *
	 * @type {{getClosestOPL: Function}}
	 */
	sap.uxap.Utilities = {

		/**
		 * Returns the reference to the ObjectPageLayout for a given control
		 * @static
		 * @param {sap.ui.core.Control} oControl - the control to find ObjectPageLayout for
		 * @private
		 * @returns {*} Object Page layout referance
		 */
		getClosestOPL: function (oControl) {

			while (oControl && oControl.getMetadata().getName() !== "sap.uxap.ObjectPageLayout") {
				oControl = oControl.getParent();
			}

			return oControl;
		},
		isPhoneScenario: function () {
			if (sap.ui.Device.system.phone) {
				return true;
			}

			return sap.uxap.Utilities._isCurrentMediaSize("Phone");
		},
		isTabletScenario: function () {

			if (sap.ui.Device.system.tablet) {
				return true;
			}

			return sap.uxap.Utilities._isCurrentMediaSize("Tablet");
		},
		_isCurrentMediaSize: function (sMedia) {
			if (sap.ui.Device.media.hasRangeSet(sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED)) {
				var oRange = sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED);
				if (oRange && oRange.name === sMedia) {
					return true;
				}
			}

			return jQuery("html").hasClass("sapUiMedia-Std-" + sMedia);
		}
	};

	return sap.uxap;

}, /* bExport= */ true);

}; // end of sap/uxap/library.js
if ( !jQuery.sap.isDeclared('sap.uxap.AnchorBarRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.AnchorBarRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.ToolbarRenderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.m.BarInPageEnabler'); // unlisted dependency retained
sap.ui.define("sap/uxap/AnchorBarRenderer",["sap/m/ToolbarRenderer", "sap/ui/core/Renderer", "sap/m/BarInPageEnabler", "./library"],
	function (ToolbarRenderer, Renderer, BarInPageEnabler, library) {
		"use strict";

		/**
		 * @class ObjectPageRenderer renderer.
		 * @static
		 */
		var AnchorBarRenderer = Renderer.extend(ToolbarRenderer);
		AnchorBarRenderer.renderBarContent = function (rm, oToolbar) {
			if (oToolbar._bHasButtonsBar) {

				rm.renderControl(oToolbar._getScrollArrowLeft());

				rm.write("<div");
				rm.writeAttributeEscaped("id", oToolbar.getId() + "-scrollContainer");
				// ARIA attributes
				rm.writeAttributeEscaped("aria-label", library.i18nModel.getResourceBundle().getText("ANCHOR_BAR_LABEL"));
				//
				rm.addClass("sapUxAPAnchorBarScrollContainer");
				rm.writeClasses();
				rm.write(">");

				rm.write("<div");
				rm.writeAttributeEscaped("id", oToolbar.getId() + "-scroll");
				rm.write(">");

				ToolbarRenderer.renderBarContent.apply(this, arguments);

				rm.write("</div>");

				rm.write("</div>");

				rm.renderControl(oToolbar._getScrollArrowRight());
			}

			BarInPageEnabler.addChildClassTo(oToolbar._oSelect, oToolbar);
			rm.renderControl(oToolbar._oSelect);

		};


		return AnchorBarRenderer;

	}, /* bExport= */ true);

}; // end of sap/uxap/AnchorBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.uxap.BreadCrumbs') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.BreadCrumbs.
jQuery.sap.declare('sap.uxap.BreadCrumbs'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.Link'); // unlisted dependency retained
jQuery.sap.require('sap.m.Select'); // unlisted dependency retained
jQuery.sap.require('sap.m.Text'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Item'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Icon'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/uxap/BreadCrumbs",[
	"sap/m/Link",
	"sap/m/Select",
	"sap/m/Text",
	"sap/ui/core/Control",
	"sap/ui/core/ResizeHandler",
	"sap/ui/core/delegate/ItemNavigation",
	"sap/ui/core/Item",
	"sap/ui/core/Icon",
	"sap/ui/Device",
	"./library"
], function (Link, Select, Text, Control, ResizeHandler, ItemNavigation, Item, Icon, Device, library) {
	"use strict";

	/**
	 * Constructor for a new BreadCrumbs.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 *
	 * The BreadCrumbs control represents the navigation steps up to the current location in the application and allows
	 * the user to quickly navigate to a previous location on the path that got him to the current location.
	 * It has two main modes of operation. One is a trail of links followed by separators (when there's enough space
	 * for the control to fit on one line), and the other is a dropdown list with the links (when the trail of links
	 * wouldn't fit on one line).
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 *
	 * @constructor
	 * @public
	 * @since 1.30
	 * @alias sap.uxap.BreadCrumbs
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var BreadCrumbs = Control.extend("sap.uxap.BreadCrumbs", /** @lends sap.uxap.BreadCrumbs.prototype */ {
		metadata: {

			library: "sap.uxap",
			properties: {

				/**
				 * Sets the visibility of the current/last element in the BreadCrumbs path.
				 */
				showCurrentLocation: {type: "boolean", group: "Behavior", defaultValue: true}
			},
			defaultAggregation: "links",
			aggregations: {

				/**
				 * A list of all the active link elements in the BreadCrumbs control.
				 */
				links: {type: "sap.m.Link", multiple: true, singularName: "link"},

				/**
				 * The current/last element in the BreadCrumbs path.
				 */
				currentLocation: {type: "sap.m.Text", multiple: false},

				/**
				 * An icon that is used as a separator after each link in the standard mode.
				 */
				_tubeIcon: {type: "sap.ui.core.Icon", multiple: false, visibility: "hidden"},

				/**
				 *
				 * A select control which is used to display the BreadCrumbs content on smaller mobile devices or
				 * when there's not enough space for the control to fit on one line.
				 */
				_overflowSelect: {type: "sap.m.Select", multiple: false, visibility: "hidden"}
			}
		}
	});

	BreadCrumbs.PAGEUP_AND_PAGEDOWN_JUMP_SIZE = 5;

	BreadCrumbs.prototype.init = function () {
		this._iREMSize = parseInt(jQuery("body").css("font-size"), 10);
		this._iContainerMaxHeight = this._iREMSize * 2;
	};

	BreadCrumbs.prototype.onBeforeRendering = function () {
		this._bOnPhone = Device.system.phone;
		this._resetControl();
	};

	BreadCrumbs.prototype.onAfterRendering = function () {
		this._handleInitialModeSelection();
	};

	/**
	 * Handles the the initial mode selection between overflowSelect and normal mode
	 *
	 * @private
	 * @returns {object} this
	 */
	BreadCrumbs.prototype._handleInitialModeSelection = function () {
		if (this._bOnPhone) {
			this._setSelectVisible(true);
			return this;
		}

		this._configureKeyboardHandling();

		if (!this._iContainerHeight) {
			this._iContainerHeight = this.$().outerHeight();
		}

		if (this._iContainerHeight > this._iContainerMaxHeight) {
			this._toggleOverflowMode(true);
			return this;
		}

		this._sResizeListenerId = ResizeHandler.register(this, this._handleScreenResize.bind(this));

		return this;
	};

	/**
	 * Handles the switching between overflowSelect and normal mode
	 *
	 * @private
	 * @param {*} bUseOverFlowSelect use overflow select
	 * @returns {object} this
	 */
	BreadCrumbs.prototype._toggleOverflowMode = function (bUseOverFlowSelect) {
		if (this._sResizeListenerId) {
			ResizeHandler.deregister(this._sResizeListenerId);
		}
		this._setSelectVisible(bUseOverFlowSelect);
		this._setBreadcrumbsVisible(!bUseOverFlowSelect);
		this._sResizeListenerId = ResizeHandler.register(this, this._handleScreenResize.bind(this));
		return this;
	};

	/**
	 * Retrieves the tube separator icon with lazy loading
	 *
	 * @returns {sap.ui.core.Icon} tube icon
	 * @private
	 */
	BreadCrumbs.prototype._getTubeIcon = function () {

		if (!this.getAggregation("_tubeIcon")) {
			this.setAggregation("_tubeIcon", new Icon({
				"src": "sap-icon://slim-arrow-right",
				"color": "#bfbfbf",
				"size": "1rem",
				"useIconTooltip": false
			}).addStyleClass("sapUxAPTubeIcon"));
		}

		return this.getAggregation("_tubeIcon");
	};

	/**
	 * Retrieves the overflowSelect with lazy loading
	 *
	 * @returns {sap.m.Select} select
	 * @private
	 */
	BreadCrumbs.prototype._getOverflowSelect = function () {
		var oOverflowSelect,
			aSelectItems;

		if (!this.getAggregation("_overflowSelect")) {
			aSelectItems = this.getLinks().reverse() || [];
			aSelectItems.unshift(this.getCurrentLocation());

			oOverflowSelect = new Select({
				items: aSelectItems.map(this._createSelectItem),
				autoAdjustWidth: true
			});

			oOverflowSelect.attachChange(this._overflowSelectChangeHandler);
			this.setAggregation("_overflowSelect", oOverflowSelect);
		}

		return this.getAggregation("_overflowSelect");
	};

	/**
	 * Retrieves the an overflowSelect item using an sap.m.Link or sap.m.Text
	 *
	 * @param {sap.m.Text} oItem item
	 * @returns  {sap.ui.core.Item} new item
	 * @private
	 */
	BreadCrumbs.prototype._createSelectItem = function (oItem) {
		return new Item({
			key: oItem.getId(),
			text: oItem.getText()
		});
	};

	/**
	 * Handles the overflowSelect "select" event
	 *
	 * @param {jQuery.Event} oEvent event
	 * @returns {object} this
	 * @private
	 */
	BreadCrumbs.prototype._overflowSelectChangeHandler = function (oEvent) {
		var oSelectedKey = oEvent.getParameter("selectedItem").getKey(),
			oControl = sap.ui.getCore().byId(oSelectedKey),
			sLinkHref,
			sLinkTarget;

		if (oControl instanceof Link) {
			sLinkHref = oControl.getHref();
			oControl.firePress();
			if (sLinkHref) {
				sLinkTarget = oControl.getTarget();
				if (sLinkTarget) {
					window.open(sLinkHref, sLinkTarget);
				} else {
					window.location.href = sLinkHref;
				}
			}
		}

		return this;
	};

	/**
	 * Handles the resize event of the Breadcrumbs control container
	 *
	 * @param {jQuery.Event} oEvent event
	 * @returns {object} this
	 * @private
	 */
	BreadCrumbs.prototype._handleScreenResize = function (oEvent) {
		var bShouldSwitchToOverflow = this._shouldOverflow(),
			bUsingOverflowSelect = this._getUsingOverflowSelect();

		if (bShouldSwitchToOverflow && !bUsingOverflowSelect) {
			this._toggleOverflowMode(true);
		} else if (!bShouldSwitchToOverflow && bUsingOverflowSelect) {
			this._toggleOverflowMode(false);
		}

		return this;
	};

	/**
	 * Handles the decision making on whether or not the control should go into overflow mode
	 *
	 * @returns {boolean} should overflow
	 * @private
	 */
	BreadCrumbs.prototype._shouldOverflow = function () {
		var $breadcrumbs = this._getBreadcrumbsAsJQueryObject(),
			bShouldOverflow,
			bUsingOverflowSelect = this._getUsingOverflowSelect();

		if (bUsingOverflowSelect) {
			this._setBreadcrumbsVisible(true);
		}

		$breadcrumbs.addClass("sapUxAPInvisible");
		bShouldOverflow = $breadcrumbs.outerHeight() > this._iContainerMaxHeight;
		$breadcrumbs.removeClass("sapUxAPInvisible");

		if (bUsingOverflowSelect) {
			this._setBreadcrumbsVisible(false);
		}

		return bShouldOverflow;
	};

	/**
	 * Retrieves the Breadcrumbs jQuery object
	 *
	 * @returns {jQuery.Object} breadcrumbs jQuery instance
	 * @private
	 */
	BreadCrumbs.prototype._getBreadcrumbsAsJQueryObject = function () {
		if (!this._$breadcrumbs) {
			this._$breadcurmbs = this.$("breadcrumbs");
		}

		return this._$breadcurmbs;
	};

	/**
	 * Retrieves the overflowSelect jQuery object
	 *
	 * @returns {jQuery.Object} jQuery select object
	 * @private
	 */
	BreadCrumbs.prototype._getOverflowSelectAsJQueryObject = function () {
		if (!this._$select) {
			this._$select = this.$("select");
		}

		return this._$select;
	};

	/**
	 * Sets the visibility of the Breadcrumbs
	 *
	 * @param {boolean} bVisible visibility of breadcrumbs
	 * @returns {jQuery.Object} $this
	 * @private
	 */
	BreadCrumbs.prototype._setBreadcrumbsVisible = function (bVisible) {
		var $this = this.$(),
			$breadcrumbs = this._getBreadcrumbsAsJQueryObject(),
			sFullWidthClass = "sapUxAPFullWidth",
			sSapHiddenClass = "sapUiHidden";

		if (bVisible) {
			$breadcrumbs.removeClass(sSapHiddenClass);
			$this.removeClass(sFullWidthClass);
		} else {
			$breadcrumbs.addClass(sSapHiddenClass);
			$this.addClass(sFullWidthClass);
		}

		return $this;
	};

	/**
	 * Sets the visibility of the overflowSelect
	 *
	 * @param {boolean} bVisible select visibility state
	 * @returns {*} this
	 * @private
	 */
	BreadCrumbs.prototype._setSelectVisible = function (bVisible) {
		var $select = this._getOverflowSelectAsJQueryObject(),
			sSapHiddenClass = "sapUiHidden";

		if (bVisible) {
			$select.removeClass(sSapHiddenClass);
		} else {
			$select.addClass(sSapHiddenClass);
		}

		return this;
	};

	/**
	 * Resets all of the internally cached values used by the control
	 *
	 * @returns {object} this
	 * @private
	 */
	BreadCrumbs.prototype._resetControl = function () {
		this._iContainerHeight = null;
		this._$select = null;
		this._$breadcrumbs = null;
		this.setAggregation("_overflowSelect", null, true);

		if (this._sResizeListenerId) {
			ResizeHandler.deregister(this._sResizeListenerId);
		}

		return this;
	};

	/**
	 * Provides a default aria-labelled text
	 *
	 * @private
	 * @returns {sap.ui.core.InvisibleText} Aria Labelled By
	 */
	BreadCrumbs.prototype._getAriaLabelledBy = function () {
		if (!this._oAriaLabelledBy) {
			BreadCrumbs.prototype._oAriaLabelledBy = new sap.ui.core.InvisibleText({
				text: library.i18nModel.getResourceBundle().getText("BREADCRUMB_TRAIL_LABEL")
			}).toStatic();
		}

		return this._oAriaLabelledBy;
	};

	/**
	 * Retrieves the ItemNavigation with lazy loading
	 *
	 * @private
	 * @returns {sap.ui.core.delegate.ItemNavigation} item navigation
	 */
	BreadCrumbs.prototype._getItemNavigation = function () {
		if (!this._ItemNavigation) {
			this._ItemNavigation = new ItemNavigation();
		}

		return this._ItemNavigation;
	};

	/**
	 * Retrieves the items which should be included in navigation.
	 *
	 * @private
	 * @returns {array} aItemsToNavigate
	 */
	BreadCrumbs.prototype._getItemsToNavigate = function () {
		var aItemsToNavigate = this.getLinks(),
			oCurrentLocation = this.getCurrentLocation(),
			bShowCurrentLocation = this.getShowCurrentLocation();

		if (bShowCurrentLocation && oCurrentLocation) {
			aItemsToNavigate.push(oCurrentLocation);
		}

		return aItemsToNavigate;
	};

	/**
	 * Configures the Keyboard handling for the control
	 *
	 * @private
	 * @returns {object} this
	 */
	BreadCrumbs.prototype._configureKeyboardHandling = function () {
		var oItemNavigation = this._getItemNavigation(),
			oHeadDomRef = this._getBreadcrumbsAsJQueryObject()[0],
			iSelectedDomIndex = -1,
			aItemsToNavigate = this._getItemsToNavigate(),
			aNavigationDomRefs = [];

		aItemsToNavigate.forEach(function (oItem) {
			oItem.$().attr("tabIndex", "-1");
			aNavigationDomRefs.push(oItem.getDomRef());
		});

		this.addDelegate(oItemNavigation);
		oItemNavigation.setCycling(false);
		oItemNavigation.setRootDomRef(oHeadDomRef);
		oItemNavigation.setItemDomRefs(aNavigationDomRefs);
		oItemNavigation.setSelectedIndex(iSelectedDomIndex);

		// fix the tab indexes so the first link to be 0 and read correctly by the screen reader
		this._getBreadcrumbsAsJQueryObject().attr("tabindex", "-1");
		aItemsToNavigate[0].$().attr("tabindex", "0");

		return this;
	};

	/**
	 * Handles PAGE UP key.
	 *
	 * @param {jQuery.Event} oEvent event
	 * @private
	 */
	BreadCrumbs.prototype.onsappageup = function (oEvent) {
		this._handlePageKeys(oEvent, false);
	};

	/**
	 * Handles PAGE DOWN key.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	BreadCrumbs.prototype.onsappagedown = function (oEvent) {
		this._handlePageKeys(oEvent, true);
	};

	BreadCrumbs.prototype._handlePageKeys = function (oEvent, bMovingDown) {
		var iNextIndex,
			aBreadCrumbs = this._getItemsToNavigate(),
			iEventTargetIndex = 0,
			iLastIndex = bMovingDown ? aBreadCrumbs.length - 1 : 0;

		oEvent.preventDefault();

		aBreadCrumbs.some(function (oItem, iIndex) {
			if (oItem.getId() === oEvent.target.id) {
				iEventTargetIndex = iIndex;
				return true;
			}
		});

		if (bMovingDown) {
			iNextIndex = iEventTargetIndex + BreadCrumbs.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;
		} else {
			iNextIndex = iEventTargetIndex - BreadCrumbs.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;
		}

		if (iNextIndex && aBreadCrumbs[iNextIndex]) {
			aBreadCrumbs[iNextIndex].focus();
		} else if (aBreadCrumbs[iLastIndex]) {
			aBreadCrumbs[iLastIndex].focus();
		}
	};

	BreadCrumbs.prototype._getUsingOverflowSelect = function () {
		return !this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden");
	};

	BreadCrumbs.prototype.exit = function () {
		if (this._ItemNavigation) {
			this.removeDelegate(this._ItemNavigation);
			this._ItemNavigation.destroy();
			this._ItemNavigation = null;
		}

		this._resetControl();
	};

	return BreadCrumbs;

});

}; // end of sap/uxap/BreadCrumbs.js
if ( !jQuery.sap.isDeclared('sap.uxap.HierarchicalSelect') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.HierarchicalSelect.
jQuery.sap.declare('sap.uxap.HierarchicalSelect'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.m.Select'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/uxap/HierarchicalSelect",["jquery.sap.global", "sap/m/Select", "sap/ui/Device", "./library"], function (jQuery, Select, Device, library) {
	"use strict";

	/**
	 * Constructor for a new HierarchicalSelect.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A select that display items on 2 level of hierarchy.
	 * If a provided item has a custom data named "secondLevel", then it will be displayed as a second level, otherwise it would be displayed as a first level.
	 * @extends sap.m.Select
	 *
	 * @author SAP SE
	 *
	 * @constructor
	 * @public
	 * @since 1.26
	 * @alias sap.uxap.HierarchicalSelect
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var HierarchicalSelect = Select.extend("sap.uxap.HierarchicalSelect", /** @lends sap.uxap.HierarchicalSelect.prototype */ {
		metadata: {

			library: "sap.uxap",
			properties: {

				/**
				 * Determines whether the HierarchicalSelect items are displayed in upper case.
				 */
				upperCase: {type: "boolean", group: "Appearance", defaultValue: false}
			}
		}
	});

	HierarchicalSelect.POPOVER_MIN_WIDTH_REM = 11;

	HierarchicalSelect.prototype.onAfterRenderingPicker = function () {

		Select.prototype.onAfterRenderingPicker.call(this);

		var aItems = this.getItems() || [];

		aItems.forEach(function (oItem) {
			var sClass = (oItem.data("secondLevel") === true) ? "sapUxAPHierarchicalSelectSecondLevel" : "sapUxAPHierarchicalSelectFirstLevel";

			oItem.$().addClass(sClass);
		}, this);
	};


	HierarchicalSelect.prototype.setUpperCase = function (bValue, bSuppressInvalidate) {

		this.setProperty("upperCase", bValue, bSuppressInvalidate);
		this.toggleStyleClass("sapUxAPHierarchicalSelectUpperCase", bValue);
		var oPicker = this.getAggregation("picker");
		if (oPicker) {
			oPicker.toggleStyleClass("sapMSltPickerFirstLevelUpperCase", bValue);
			if (!bSuppressInvalidate) {
				oPicker.invalidate();
			}
		}
		return this;
	};

	/**
	 * Keyboard handling requirement to have the same behavior on [ENTER] key
	 * as on [SPACE] key (namely, to toggle the open state the select dropdown)
	 */
	HierarchicalSelect.prototype.onsapenter = Select.prototype.onsapspace;

	/**
	 * Keyboard handling of [UP], [PAGE-UP], [PAGE-DOWN], [HOME], [END] keys
	 * Stops propagation to avoid triggering the listeners for the same keys of the parent control (the AnchorBar)
	 */
	["onsapup", "onsappageup", "onsappagedown", "onsaphome", "onsapend"].forEach(function (sName) {
		HierarchicalSelect.prototype[sName] = function (oEvent) {
			Select.prototype[sName].call(this, oEvent);
			oEvent.stopPropagation();
		};
	});

	HierarchicalSelect.prototype._createDialog = function () {

		var oDialog = Select.prototype._createDialog.call(this);

		oDialog.getCustomHeader().addStyleClass("sapUxAPHierarchicalSelect");

		return oDialog;

	};

	/**
	 * Decorate a Popover instance by adding some private methods.
	 *
	 * We are overriding function from sap.m.Select
	 * in order to redefine position of popover
	 *
	 * @param {sap.m.Popover}
	 * @private
	 */
	HierarchicalSelect.prototype._decoratePopover = function (oPopover) {

		Select.prototype._decoratePopover.call(this, oPopover);

		oPopover._adaptPositionParams = function () {
			this._marginTop = 0;
			this._marginLeft = 0;
			this._marginRight = 0;
			this._marginBottom = 0;

			this._arrowOffset = 0;
			this._offsets = ["0 0", "0 0", "0 0", "0 0"];

			this._myPositions = ["end bottom", "end center", "end top", "begin center"];
			this._atPositions = ["end top", "end center", "end bottom", "begin center"];
		};

		// offset the popup to make it cover the scrollbar (to avoid having page-scrollbar and popup-scrollbar appearing next to each other)
		if (Device.system.tablet || Device.system.desktop) {
			var fRight = jQuery.position.scrollbarWidth();
			if (fRight > 0) {
				oPopover.setOffsetX(fRight);
			}
		}
	};

	/**
	 * Overriding function from sap.m.Select to access min-width of the popover
	 * in order to ensure that min-width is not smaller than sap.uxap.HierarchicalSelect.POPOVER_MIN_WIDTH_REM
	 */
	HierarchicalSelect.prototype._onAfterRenderingPopover = function () {

		Select.prototype._onAfterRenderingPopover.call(this);

		// ensure popover min-width is not smaller than sap.uxap.HierarchicalSelect.POPOVER_MIN_WIDTH_REM
		if (Device.system.tablet || Device.system.desktop) {

			var oPopover = this.getPicker(),
				sMinWidth = oPopover.getDomRef().style.minWidth;

			if (jQuery.sap.endsWith(sMinWidth, "rem")) {
				sMinWidth = sMinWidth.substring(0, sMinWidth.length - 3);
				var iMinWidth = parseFloat(sMinWidth);
				if (iMinWidth < HierarchicalSelect.POPOVER_MIN_WIDTH_REM) {
					oPopover._setMinWidth(HierarchicalSelect.POPOVER_MIN_WIDTH_REM + "rem");
				}
			}
		}
	};

	return HierarchicalSelect;
});

}; // end of sap/uxap/HierarchicalSelect.js
if ( !jQuery.sap.isDeclared('sap.uxap.ModelMapping') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.ModelMapping.
jQuery.sap.declare('sap.uxap.ModelMapping'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/uxap/ModelMapping",["sap/ui/core/Element", "./library"],
	function (Element, library) {
		"use strict";

	/**
	 * Constructor for a new ModelMapping.
	 *
	 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
	 * @param {object} [mSettings] Initial settings for the new control
	 *
	 * @class
	 *
	 * Define the entity that will be passed to the ObjectPageLayout.
	 * @extends sap.ui.core.Element
	 *
	 * @author SAP SE
	 *
	 * @constructor
	 * @public
	 * @alias sap.uxap.ModelMapping
	 * @since 1.26
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ModelMapping = Element.extend("sap.uxap.ModelMapping", /** @lends sap.uxap.ModelMapping.prototype */ {
		metadata: {

			library: "sap.uxap",
			properties: {

				/**
				 * Determines the the external model name.
				 */
				externalModelName: {type: "string", group: "Misc", defaultValue: null},

				/**
				 * Determines the the internal model name.
				 */
				internalModelName: {type: "string", group: "Misc", defaultValue: "Model"},

				/**
				 * Determines the the external path.
				 */
				externalPath: {type: "string", group: "Misc", defaultValue: null}
			}
		}
	});

	return ModelMapping;
});

}; // end of sap/uxap/ModelMapping.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderActionButton') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.ObjectPageHeaderActionButton.
jQuery.sap.declare('sap.uxap.ObjectPageHeaderActionButton'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageHeaderActionButton",["sap/m/Button", "./library"], function (Button, library) {
	"use strict";

	/**
	 * Constructor for a new ObjectPageHeaderActionButton.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 *
	 * Button that can be used in the ObjectPageHeader action aggregation.
	 * @extends sap.m.Button
	 *
	 * @author SAP SE
	 *
	 * @constructor
	 * @public
	 * @since 1.26
	 * @alias sap.uxap.ObjectPageHeaderActionButton
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectPageHeaderActionButton = Button.extend("sap.uxap.ObjectPageHeaderActionButton", /** @lends sap.uxap.ObjectPageHeaderActionButton.prototype */ {
		metadata: {

			library: "sap.uxap",
			properties: {

				/**
				 * Hide the button text when rendered into the headerTitle part of the ObjectPageLayout.
				 * This is useful if you want to display icons only in the headerTitle part but still want to display text + icon in the actionSheet that appears when not enough space is available on the screen for displaying all actions.
				 */
				hideText: {type: "boolean", defaultValue: true},

				/**
				 * Hide the button icon when rendered into the headerTitle part of the ObjectPageLayout.
				 * This is useful if you want to display texts only in the headerTitle part but still want to display text + icon in the actionSheet that appears when not enough space is available on the screen for displaying all actions.
				 */
				hideIcon: {type: "boolean", defaultValue: false},

				/**
				 * Determines the order in which the button overflows.
				 * @since 1.34.0
				 */
				importance: {
					type: "sap.uxap.Importance",
					group: "Behavior",
					defaultValue: library.Importance.High
				}
			}
		}
	});

	ObjectPageHeaderActionButton.prototype.applySettings = function (mSettings, oScope) {

		if (Button.prototype.applySettings) {
			Button.prototype.applySettings.call(this, mSettings, oScope);
		}

		this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText", this.getHideText());
		this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon", this.getHideIcon());
	};

	ObjectPageHeaderActionButton.prototype.setHideText = function (bValue, bInvalidate) {

		this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText", bValue);

		return this.setProperty("hideText", bValue, bInvalidate);
	};


	ObjectPageHeaderActionButton.prototype.setHideIcon = function (bValue, bInvalidate) {

		this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon", bValue);

		return this.setProperty("hideIcon", bValue, bInvalidate);
	};

	return ObjectPageHeaderActionButton;

});

}; // end of sap/uxap/ObjectPageHeaderActionButton.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderContent') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.ObjectPageHeaderContent.
jQuery.sap.declare('sap.uxap.ObjectPageHeaderContent'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageHeaderContent",["sap/ui/core/Control", "./library", "sap/m/Button"],
	function (Control, library, Button) {
		"use strict";

		/**
		 * Constructor for a new ObjectPageHeaderContent.
		 *
		 * @param {string} [sId] id for the new control, generated automatically if no id is given
		 * @param {object} [mSettings] initial settings for the new control
		 *
		 * @class
		 * ObjectPageHeaderContent represents the dynamic part of an Object page header. May contain any control.
		 * Unlike the Object page header title, the Object page header content is part of the scrolling area of the Object page.
		 * This enables it to hold any amount of information and still be usable on a mobile device.
		 * @extends sap.ui.core.Control
		 *
		 * @author SAP SE
		 *
		 * @constructor
		 * @public
		 * @since 1.30
		 * @alias sap.uxap.ObjectPageHeaderContent
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */
		var ObjectPageHeaderContent = Control.extend("sap.uxap.ObjectPageHeaderContent", /** @lends sap.uxap.ObjectPageHeaderContent.prototype */ {
			metadata: {

				library: "sap.uxap",
				properties: {

					/**
					 * Determines the design of the header - Light or Dark
					 */
					contentDesign: {
						type: "sap.uxap.ObjectPageHeaderDesign",
						group: "Misc",
						defaultValue: sap.uxap.ObjectPageHeaderDesign.Light
					}
				},
				aggregations: {

					/**
					 * The list of Objects of type sap.ui.core.Control.
					 */
					content: {type: "sap.ui.core.Control", multiple: true, singularName: "content"},

					/**
					 *
					 * Internal aggregation for the "Edit Header" button.
					 */
					_editHeaderButton: {type: "sap.m.Button", multiple: false, visibility: "hidden"}
				}
			}
		});


		ObjectPageHeaderContent.prototype.onBeforeRendering = function () {
			var oParent = this.getParent();

			if (oParent && (oParent instanceof library.ObjectPageLayout) && oParent.getShowEditHeaderButton()) {
				this._getInternalBtnAggregation("_editHeaderButton", "EDIT_HEADER", "-editHeaderBtn", "Transparent").attachPress(this._handleEditHeaderButtonPress, this);
			}
		};

		ObjectPageHeaderContent.prototype._handleEditHeaderButtonPress = function (oEvent) {
			this.getParent().fireEditHeaderButtonPress();
		};

		ObjectPageHeaderContent.prototype._getInternalBtnAggregation = function (sAggregationName, sBtnText, sBtnIdText, sBtnType) {
			if (!this.getAggregation(sAggregationName)) {
				var oBtn = new Button({
					text: library.i18nModel.getResourceBundle().getText(sBtnText),
					type: sBtnType,
					id: this.getId() + sBtnIdText
				});
				this.setAggregation(sAggregationName, oBtn);
			}
			return this.getAggregation(sAggregationName);
		};

		/**
		 * The layout data to apply to a header cluster
		 * called from the renderer
		 * @private
		 */
		ObjectPageHeaderContent.prototype._getLayoutDataForControl = function (oControl) {
			var oLayoutData = oControl.getLayoutData();

			if (!oLayoutData) {
				return;
			} else if (oLayoutData instanceof library.ObjectPageHeaderLayoutData) {
				return oLayoutData;
			} else if (oLayoutData.getMetadata().getName() == "sap.ui.core.VariantLayoutData") {
				// multiple LayoutData available - search here
				var aLayoutData = oLayoutData.getMultipleLayoutData();
				for (var i = 0; i < aLayoutData.length; i++) {
					var oLayoutData2 = aLayoutData[i];
					if (oLayoutData2 instanceof library.ObjectPageHeaderLayoutData) {
						return oLayoutData2;
					}
				}
			}
		};

		return ObjectPageHeaderContent;

	});

}; // end of sap/uxap/ObjectPageHeaderContent.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderLayoutData') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.ObjectPageHeaderLayoutData.
jQuery.sap.declare('sap.uxap.ObjectPageHeaderLayoutData'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.LayoutData'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageHeaderLayoutData",["sap/ui/core/LayoutData", "./library"], function (LayoutData, library) {
	"use strict";

	/**
	 * Constructor for a new ObjectPageHeaderLayoutData.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This is a LayoutData Element that can be added to a control if this control is used within an ObjectPage headerContent aggregation
	 * @extends sap.ui.core.LayoutData
	 *
	 * @author SAP SE
	 *
	 * @constructor
	 * @public
	 * @since 1.26
	 * @alias sap.uxap.ObjectPageHeaderLayoutData
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectPageHeaderLayoutData = LayoutData.extend("sap.uxap.ObjectPageHeaderLayoutData", /** @lends sap.uxap.ObjectPageHeaderLayoutData.prototype */ {
		metadata: {

			library: "sap.uxap",
			properties: {

				/**
				 * If this property is set the control will be visible (or not) in a small sized layout.
				 */
				visibleS: {type: "boolean", group: "Misc", defaultValue: true},

				/**
				 * If this property is set the control will be visible (or not) in a medium sized layout.
				 */
				visibleM: {type: "boolean", group: "Misc", defaultValue: true},

				/**
				 * If this property is set the control will be visible (or not) in a large sized layout.
				 */
				visibleL: {type: "boolean", group: "Misc", defaultValue: true},

				/**
				 * If this property is set the control will display a separator before it.
				 */
				showSeparatorBefore: {type: "boolean", group: "Misc", defaultValue: false},

				/**
				 * If this property is set the control will display a separator after it.
				 */
				showSeparatorAfter: {type: "boolean", group: "Misc", defaultValue: false},

				/**
				 * If this property is set the control will take the provided size.
				 */
				width: {type: "sap.ui.core.CSSSize", group: "Misc", defaultValue: 'auto'}
			}
		}
	});

	/*!
	 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
	 */

	return ObjectPageHeaderLayoutData;

});

}; // end of sap/uxap/ObjectPageHeaderLayoutData.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageSectionBase') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.ObjectPageSectionBase.
jQuery.sap.declare('sap.uxap.ObjectPageSectionBase'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageSectionBase",["jquery.sap.global", "sap/ui/core/Control", "./library"], function (jQuery, Control, library) {
	"use strict";

	/**
	 * Constructor for a new ObjectPageSectionBase.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * An abstract container for object page sections and subSections
	 * @extends sap.ui.core.Control
	 *
	 * @constructor
	 * @public
	 * @alias sap.uxap.ObjectPageSectionBase
	 * @since 1.26
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectPageSectionBase = Control.extend("sap.uxap.ObjectPageSectionBase", /** @lends sap.uxap.ObjectPageSectionBase.prototype */ {
		metadata: {

			"abstract": true,
			library: "sap.uxap",
			properties: {

				/**
				 * Section Title
				 */
				title: {type: "string", group: "Appearance", defaultValue: null},

				/**
				 * Invisible ObjectPageSectionBase are not rendered
				 */
				visible: {type: "boolean", group: "Appearance", defaultValue: true},

				/**
				 * Determines whether the section will be hidden on low resolutions.
				 * @since 1.32.0
				 */
				importance: {
					type: "sap.uxap.Importance",
					group: "Behavior",
					defaultValue: library.Importance.High
				}
			},
			aggregations: {

				/**
				 * The custom button that will provide a link to the section in the ObjectPageLayout anchor bar.
				 * This button will be used as a custom template to be into the ObjectPageLayout anchorBar area, therefore property changes happening on this button template after the first rendering won't affect the actual button copy used in the anchorBar.
				 *
				 * If you want to change some of the button properties, you would need to bind them to a model.
				 */
				customAnchorBarButton: {type: "sap.m.Button", multiple: false}
			}
		}
	});


	/**
	 * Explicitly ask to connect to the UI5 model tree
	 *
	 * @name sap.uxap.ObjectPageSectionBase#connectToModels
	 * @function
	 * @type void
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */

	ObjectPageSectionBase.prototype.init = function () {

		//handled for ux rules management
		this._bInternalVisible = true;
		this._bInternalTitleVisible = true;
		this._sInternalTitle = "";

		//hidden status
		this._isHidden = false;

		this._oParentObjectPageLayout = undefined; //store the parent objectPageLayout
	};

	ObjectPageSectionBase.prototype.onAfterRendering = function () {
		if (this._getObjectPageLayout()) {
			this._getObjectPageLayout()._adjustLayout();
			this._getObjectPageLayout()._setSectionsFocusValues();
		}
	};

	/**
	 * set the internal visibility of the sectionBase. This is set by the ux rules (for example don't display a section that has no subSections)
	 * @param bValue
	 * @param bInvalidate if set to true, the sectionBase should be rerendered in order to be added or removed to the dom (similar to what a "real" internalVisibility property would trigger
	 * @private
	 */
	ObjectPageSectionBase.prototype._setInternalVisible = function (bValue, bInvalidate) {
		if (bValue != this._bInternalVisible) {
			this._bInternalVisible = bValue;
			if (bInvalidate) {
				this.invalidate();
			}
		}
	};

	ObjectPageSectionBase.prototype._getInternalVisible = function () {
		return this._bInternalVisible;
	};

	/**
	 * set the internal visibility of the sectionBase title. This is set by the ux rules (for example don't display a subSection title if there are only 1 in the section)
	 * @param bValue
	 * @param bInvalidate if set to true, the sectionBase should be rerendered in order to be added or removed to the dom (similar to what a "real" internalVisibility property would trigger
	 * @private
	 */
	ObjectPageSectionBase.prototype._setInternalTitleVisible = function (bValue, bInvalidate) {
		if (bValue != this._bInternalTitleVisible) {
			this._bInternalTitleVisible = bValue;
			if (bInvalidate) {
				this.invalidate();
			}
		}
	};

	ObjectPageSectionBase.prototype._getInternalTitleVisible = function () {
		return this._bInternalTitleVisible;
	};

	/**
	 * set the internal title of the sectionBase. This is set by the ux rules (for example the subSection title becomes the section title if there are only 1 subSection in the section)
	 * @param sValue
	 * @param bInvalidate if set to true, the sectionBase should be rerendered in order to be added or removed to the dom (similar to what a "real" internalVisibility property would trigger
	 * @private
	 */

	ObjectPageSectionBase.prototype._setInternalTitle = function (sValue, bInvalidate) {
		if (sValue != this._sInternalTitle) {
			this._sInternalTitle = sValue;
			if (bInvalidate) {
				this.invalidate();
			}
		}
	};

	ObjectPageSectionBase.prototype._getInternalTitle = function () {
		return this._sInternalTitle;
	};

	/**
	 * getter for the parent object page layout
	 * @returns {*}
	 * @private
	 */
	ObjectPageSectionBase.prototype._getObjectPageLayout = function () {

		if (!this._oParentObjectPageLayout) {
			this._oParentObjectPageLayout = library.Utilities.getClosestOPL(this);
		}

		return this._oParentObjectPageLayout;
	};

	/**
	 * Notify the parent objectPageLayout of structural changes after the first rendering
	 * @private
	 */
	ObjectPageSectionBase.prototype._notifyObjectPageLayout = function () {
		if (this.$().length && this._getObjectPageLayout()) {
			this._getObjectPageLayout()._adjustLayoutAndUxRules();
		}
	};

	// Generate proxies for aggregation mutators
	["addAggregation", "insertAggregation", "removeAllAggregation", "removeAggregation", "destroyAggregation"].forEach(function (sMethod) {
		ObjectPageSectionBase.prototype[sMethod] = function () {
			var vResult = Control.prototype[sMethod].apply(this, arguments);
			this._notifyObjectPageLayout();
			return vResult;
		};
	});

	ObjectPageSectionBase.prototype.setVisible = function (bValue, bSuppressInvalidate) {
		if (!this._getObjectPageLayout()) {
			return this.setProperty("visible", bValue, bSuppressInvalidate);
		}

		this.setProperty("visible", bValue, true);
		/* handle invalidation ourselves in adjustLayoutAndUxRules */
		this._getObjectPageLayout()._adjustLayoutAndUxRules();
		this.invalidate();
		return this;
	};

	ObjectPageSectionBase.prototype.setTitle = function (sValue, bSuppressInvalidate) {

		this.setProperty("title", sValue, bSuppressInvalidate);
		this._notifyObjectPageLayout();

		return this;
	};

	ObjectPageSectionBase.prototype._shouldBeHidden = function () {
		return ObjectPageSectionBase._importanceMap[this.getImportance()] >
			ObjectPageSectionBase._importanceMap[this._sCurrentLowestImportanceLevelToShow];
	};

	ObjectPageSectionBase._importanceMap = {
		"Low": 3,
		"Medium": 2,
		"High": 1
	};

	ObjectPageSectionBase.prototype._updateShowHideState = function (bHide) {
		var oObjectPage = this._getObjectPageLayout();
		this._isHidden = bHide;
		this.$().children(this._sContainerSelector).toggle(!bHide);
		if (oObjectPage) {
			oObjectPage._adjustLayout();
		}
		return this;
	};

	ObjectPageSectionBase.prototype._getIsHidden = function () {
		return this._isHidden;
	};

	ObjectPageSectionBase.prototype._expandSection = function () {
		return this._updateShowHideState(false);
	};

	ObjectPageSectionBase.prototype._showHideContent = function () {
		return this._updateShowHideState(!this._getIsHidden());
	};

	/**
	 * Called to set the visibility of the section / subsection
	 * @params oSection, sCurrentLowestImportanceLevelToShow
	 *
	 * @private
	 */
	ObjectPageSectionBase.prototype._applyImportanceRules = function (sCurrentLowestImportanceLevelToShow) {
		this._sCurrentLowestImportanceLevelToShow = sCurrentLowestImportanceLevelToShow;
		this._updateShowHideState(this._shouldBeHidden());
	};

	/*******************************************************************************
	 * Keyboard navigation
	 ******************************************************************************/

	ObjectPageSectionBase.PAGEUP_AND_PAGEDOWN_JUMP_SIZE = 5;

	/**
	 * Handler for key down - handle
	 * @param oEvent - The event object
	 */

	ObjectPageSectionBase.prototype.onkeydown = function (oEvent) {
		// Filter F7 key down
		if (oEvent.keyCode === jQuery.sap.KeyCodes.F7) {
			var aSubSections = this.getSubSections(),
				oFirstSubSection = aSubSections[0],
				oLastFocusedEl;

			if (aSubSections.length === 1) {
				oLastFocusedEl = oFirstSubSection._oLastFocusedControlF7;
				if (oLastFocusedEl) {
					oLastFocusedEl.$().focus();
				} else {
					oFirstSubSection.$().firstFocusableDomRef().focus();
				}
			} else {
				if (oFirstSubSection.getActions().length) {
					oFirstSubSection.getActions()[0].$().focus();
				}
			}
		}
	};

	/**
	 * Handler for arrow down
	 * @param oEvent - The event object
	 */
	ObjectPageSectionBase.prototype.onsapdown = function (oEvent) {
		this._handleFocusing(oEvent, oEvent.currentTarget.nextSibling);
	};

	ObjectPageSectionBase.prototype._handleFocusing = function (oEvent, oElementToReceiveFocus) {
		if (this._targetIsCorrect(oEvent) && oElementToReceiveFocus) {
			oEvent.preventDefault();
			oElementToReceiveFocus.focus();
			this._scrollParent(jQuery(oElementToReceiveFocus).attr("id"));
		}
	};

	ObjectPageSectionBase.prototype._targetIsCorrect = function (oEvent) {
		return oEvent.srcControl === this;
	};

	/**
	 * Handler for arrow right
	 */
	ObjectPageSectionBase.prototype.onsapright = ObjectPageSectionBase.prototype.onsapdown;

	/**
	 * Handler for arrow up
	 * @param oEvent - The event object
	 */
	ObjectPageSectionBase.prototype.onsapup = function (oEvent) {
		this._handleFocusing(oEvent, oEvent.currentTarget.previousSibling);
	};

	/**
	 * Handler for arrow left
	 */
	ObjectPageSectionBase.prototype.onsapleft = ObjectPageSectionBase.prototype.onsapup;

	/**
	 * Handler for HOME key
	 * @param oEvent - The event object
	 */
	ObjectPageSectionBase.prototype.onsaphome = function (oEvent) {
		this._handleFocusing(oEvent, oEvent.currentTarget.parentElement.firstChild);
	};

	/**
	 * Handler for END key
	 * @param oEvent - The event object
	 */
	ObjectPageSectionBase.prototype.onsapend = function (oEvent) {
		this._handleFocusing(oEvent, oEvent.currentTarget.parentElement.lastChild);
	};

	/**
	 * Handler for PAGE UP event.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	ObjectPageSectionBase.prototype.onsappageup = function (oEvent) {
		if (!this._targetIsCorrect(oEvent)) {
			return;
		}

		oEvent.preventDefault();

		var iNextIndex;
		var aSections = jQuery(oEvent.currentTarget).parent().children();
		var focusedSectionId;

		aSections.each(function (iSectionIndex, oSection) {
			if (jQuery(oSection).attr("id") === oEvent.currentTarget.id) {
				iNextIndex = iSectionIndex - (ObjectPageSectionBase.PAGEUP_AND_PAGEDOWN_JUMP_SIZE + 1);
				return;
			}
		});

		if (iNextIndex && aSections[iNextIndex]) {
			aSections[iNextIndex].focus();
			focusedSectionId = jQuery(aSections[iNextIndex]).attr("id");
		} else if (aSections[0]) {
			aSections[0].focus();
			focusedSectionId = jQuery(aSections[0]).attr("id");
		}

		this._scrollParent(focusedSectionId);
	};

	/**
	 * Handler for PAGE DOWN event.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	ObjectPageSectionBase.prototype.onsappagedown = function (oEvent) {
		if (!this._targetIsCorrect(oEvent)) {
			return;
		}

		oEvent.preventDefault();

		var iNextIndex;
		var aSections = jQuery(oEvent.currentTarget).parent().children();
		var focusedSectionId;

		aSections.each(function (iSectionIndex, oSection) {
			if (jQuery(oSection).attr("id") === oEvent.currentTarget.id) {
				iNextIndex = iSectionIndex + ObjectPageSectionBase.PAGEUP_AND_PAGEDOWN_JUMP_SIZE + 1;
				return;
			}
		});

		if (iNextIndex && aSections[iNextIndex]) {
			aSections[iNextIndex].focus();
			focusedSectionId = jQuery(aSections[iNextIndex]).attr("id");
		} else if (aSections[aSections.length - 1]) {
			aSections[aSections.length - 1].focus();
			focusedSectionId = jQuery(aSections[aSections.length - 1]).attr("id");
		}

		this._scrollParent(focusedSectionId);
	};

	/**
	 * Tells the ObjectPageLayout instance to scroll itself to a given section (by Id)
	 * @param sId
	 * @private
	 */
	ObjectPageSectionBase.prototype._scrollParent = function (sId) {
		if (this._getObjectPageLayout()) {
			this._getObjectPageLayout().scrollToSection(sId, 0, 10);
		}
	};

	return ObjectPageSectionBase;

});

}; // end of sap/uxap/ObjectPageSectionBase.js
if ( !jQuery.sap.isDeclared('sap.uxap.AnchorBar') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.AnchorBar.
jQuery.sap.declare('sap.uxap.AnchorBar'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.PlacementType'); // unlisted dependency retained
jQuery.sap.require('sap.m.Popover'); // unlisted dependency retained
jQuery.sap.require('sap.m.Toolbar'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Item'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ScrollEnablement'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.HorizontalLayout'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.CustomData'); // unlisted dependency retained
sap.ui.define("sap/uxap/AnchorBar",[
	"sap/m/Button",
	"sap/m/PlacementType",
	"sap/m/Popover",
	"sap/m/Toolbar",
	"sap/ui/core/IconPool",
	"sap/ui/core/Item",
	"sap/ui/core/ResizeHandler",
	"sap/ui/core/delegate/ScrollEnablement",
	"sap/ui/layout/HorizontalLayout",
	"sap/ui/Device",
	"sap/ui/core/CustomData",
	"./HierarchicalSelect",
	"./library"
], function (Button, PlacementType, Popover, Toolbar, IconPool, Item, ResizeHandler,
			 ScrollEnablement, HorizontalLayout, Device, CustomData, HierarchicalSelect, library) {
	"use strict";

	/**
	 * Constructor for a new AnchorBar.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Anchor bar is the navigation bar of an Object page. Its purpose is to provide links to all Sections and Subsections. Takes the form of a Select on phone.
	 * @extends sap.m.Toolbar
	 *
	 * @author SAP SE
	 *
	 * @constructor
	 * @public
	 * @since 1.26
	 * @alias sap.uxap.AnchorBar
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var AnchorBar = Toolbar.extend("sap.uxap.AnchorBar", /** @lends sap.uxap.AnchorBar.prototype */ {
		metadata: {

			library: "sap.uxap",
			properties: {

				/**
				 * Determines whether to show a Popover with Subsection links when clicking on Section links in the Anchor bar.
				 */
				showPopover: {type: "boolean", defaultValue: true},

				/**
				 * Determines whether the Anchor bar items are displayed in upper case.
				 */
				upperCase: {type: "boolean", defaultValue: false}
			},
			associations: {

				/**
				 * The button that represents the Section being scrolled by the user.
				 */
				selectedButton: {type: "sap.m.Button", multiple: false}
			},
			aggregations: {

				_select: {type: "sap.uxap.HierarchicalSelect", multiple: false, visibility: "hidden"},
				_popovers: {type: "sap.m.Popover", multiple: true, visibility: "hidden"},
				_scrollArrowLeft: {type: "sap.ui.core.Control", multiple: false, visibility: "hidden"},
				_scrollArrowRight: {type: "sap.ui.core.Control", multiple: false, visibility: "hidden"}
			}
		}
	});


	/**
	 * Scrolls to the given Section
	 *
	 * @name sap.uxap.AnchorBar#scrollToSection
	 * @function
	 * @param {string} sId
	 *         The Section ID to scroll to
	 * @param {int} iDuration
	 *         Scroll duration (in ms). Default value is 0
	 * @type sap.uxap.ObjectPageLayout
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */


	/**
	 * Returns a sap.ui.core.delegate.ScrollEnablement object used to handle scrolling
	 *
	 * @name sap.uxap.AnchorBar#getScrollDelegate
	 * @function
	 * @type object
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */

	AnchorBar.prototype.init = function () {
		if (Toolbar.prototype.init) {
			Toolbar.prototype.init.call(this);
		}

		this.addStyleClass("sapUxAPAnchorBar");

		this._oPressHandlers = {};  //keep references on the press handlers we set on first level items (in case of behavior change)
		this._oSectionInfo = {};    //keep scrolling info on sections
		this._oScroller = null;

		//are we on a rtl scenario?
		//IE handles rtl in a transparent way (positions positives, scroll starts at the end)
		//while firefox, safari and chrome have a special management (scroll at the beginning and negative positioning)
		//therefore we will apply some specific actions only if are in rtl and not in IE.
		this._bRtlScenario = sap.ui.getCore().getConfiguration().getRTL() && !Device.browser.msie;

		//there are 2 different uses cases:
		//case 1: on a real phone we don't need the scrolling anchorBar, just the hierarchicalSelect
		//case 2: on a a real ipad or a desktop we need both as the size may change
		this._bHasButtonsBar = Device.system.tablet || Device.system.desktop;

		this._oSelect = this._getHierarchicalSelect();

		//case 2 requires the scrolling anchorBar
		if (this._bHasButtonsBar) {
			//horizontal scrolling
			this._oScroller = new ScrollEnablement(this, this.getId() + "-scroll", {
				horizontal: true,
				vertical: false,
				nonTouchScrolling: true
			});

			this._iREMSize = parseInt(jQuery("body").css("font-size"), 10);
			this._iTolerance = this._iREMSize * 1;  // 1 rem
			this._iOffset = this._iREMSize * 3;  // 3 rem

			//listen to resize
			this._sResizeListenerId = undefined; //defined in onAfterRendering
		}

		//composite controls
		this.setDesign("Transparent"); //styling is coming from css
	};

	/*******************************************************************************
	 * UX design
	 ******************************************************************************/
	AnchorBar.SCROLL_STEP = 250;// how many pixels to scroll with every overflow arrow click
	AnchorBar.SCROLL_DURATION = 500; // ms

	AnchorBar.prototype.setSelectedButton = function (oButton) {

		if (typeof oButton === "string") {
			oButton = sap.ui.getCore().byId(oButton);
		}

		if (oButton) {

			if (oButton.getId() === this.getSelectedButton()) {
				return;
			}

			var oSelectedSectionId = oButton.data("sectionId");

			if (oSelectedSectionId) {
				this._oSelect.setSelectedKey(oButton.getId());
			}

			if (this._bHasButtonsBar) {
				//remove selection class from the currently selected item
				this.$().find(".sapUxAPAnchorBarButtonSelected").removeClass("sapUxAPAnchorBarButtonSelected");
				oButton.$().addClass("sapUxAPAnchorBarButtonSelected");

				if (oSelectedSectionId) {
					this.scrollToSection(oSelectedSectionId, AnchorBar.SCROLL_DURATION);
				}

				this._setAnchorButtonsTabFocusValues(oButton);
			}
		}

		return this.setAssociation("selectedButton", oButton, true /* don't rerender */);
	};

	/*******************************************************************************
	 * Responsive behavior
	 ******************************************************************************/

	AnchorBar.prototype.setShowPopover = function (bValue, bSuppressInvalidate) {

		if (this.getShowPopover() === bValue) {
			return this;
		}

		var sSelectedButton, bNeedInvalidate = !jQuery.isEmptyObject(this._oPressHandlers);

		//changing the behavior after the firstRendering is removing all press handlers on first level items
		if (bNeedInvalidate) {
			var aContent = this.getContent() || [];
			sSelectedButton = this.getSelectedButton();

			aContent.forEach(this._detachPopoverHandler, this);
		}

		this.setProperty("showPopover", bValue, true /* always trigger re-rendering manually */);

		if (bNeedInvalidate) {
			this.rerender();

			if (sSelectedButton) {
				this.setSelectedButton(sSelectedButton);
			}
		}

		return this;
	};

	AnchorBar.prototype.getSelectedSection = function () {

		var oSelectedButton = this.getSelectedButton();

		if (oSelectedButton && (typeof (oSelectedButton) === "string" )) {
			oSelectedButton = sap.ui.getCore().byId(oSelectedButton);
		}

		if (oSelectedButton && (oSelectedButton instanceof Button)
			&& oSelectedButton.data("sectionId")) {

			return sap.ui.getCore().byId(oSelectedButton.data("sectionId"));
		}

		return null;
	};

	/**
	 * create phone equivalents for each of the provided content controls
	 */
	AnchorBar.prototype.onBeforeRendering = function () {
		if (Toolbar.prototype.onBeforeRendering) {
			Toolbar.prototype.onBeforeRendering.call(this);
		}

		var aContent = this.getContent() || [],
			bUpperCase = this.getUpperCase(),
			oPopoverState = {
				oLastFirstLevelButton: null,
				oCurrentPopover: null
			};

		//rebuild select items
		this._oSelect.removeAllItems();
		this._oSelect.setUpperCase(bUpperCase);
		this.toggleStyleClass("sapUxAPAnchorBarUpperCase", bUpperCase);


		//create responsive equivalents of the provided controls
		aContent.forEach(function (oButton) {

			this._createSelectItem(oButton);

			//desktop scenario logic: builds the scrolling anchorBar
			if (this._bHasButtonsBar) {
				this._createPopoverSubMenu(oButton, oPopoverState);
			}

		}, this);
	};

	AnchorBar.prototype.addContent = function (oButton, bInvalidate) {
		oButton.addStyleClass("sapUxAPAnchorBarButton");
		oButton.removeAllAriaDescribedBy();

		if (this._bHasButtonsBar && (oButton.data("secondLevel") === true || oButton.data("secondLevel") === "true")) {

			//attach handler on the scrolling mechanism
			oButton.attachPress(this._handleDirectScroll, this);
		}

		return this.addAggregation("content", oButton, bInvalidate);
	};

	AnchorBar.prototype._createSelectItem = function (oButton) {
		var bIsSecondLevel = oButton.data("secondLevel") === true || oButton.data("secondLevel") === "true";

		//create the phone equivalent item if the button has some visible text (UX rule)
		if (oButton.getText().trim() != "" && (!bIsSecondLevel || oButton.data("bTitleVisible") === true)) {
			var oPhoneItem = new Item({
				key: oButton.getId(),
				text: oButton.getText(),
				customData: [
					new CustomData({
						key: "secondLevel",
						value: oButton.data("secondLevel")
					})
				]
			});

			this._oSelect.addItem(oPhoneItem);
		}

	};

	AnchorBar.prototype._createPopoverSubMenu = function (oButton, oPopoverState) {

		var bIsSecondLevel = oButton.data("secondLevel") === true || oButton.data("secondLevel") === "true",
			fnPressHandler = null;

		//handles the tablet/desktop hierarchical behavior
		//a second level is injected into the latest first level
		//at this point we know that there are children to the last firstLevel therefore we can create the popover
		if (bIsSecondLevel) {

			if (oPopoverState.oLastFirstLevelButton && oPopoverState.oCurrentPopover) {

				//don't attach the parent press handler for each child
				if (!this._oPressHandlers[oPopoverState.oLastFirstLevelButton.getId()]) {

					fnPressHandler = jQuery.proxy(this._handlePopover, /* closure with oLastFirstLevelButton and oCurrentPopover as context */
						{
							oCurrentPopover: oPopoverState.oCurrentPopover,
							oLastFirstLevelButton: oPopoverState.oLastFirstLevelButton
						}
					);


					oPopoverState.oLastFirstLevelButton.attachPress(fnPressHandler);
					this._oPressHandlers[oPopoverState.oLastFirstLevelButton.getId()] = fnPressHandler;
				}

				oPopoverState.oCurrentPopover.addContent(oButton);
			} else if (this.getShowPopover()) {
				jQuery.sap.log.error("sapUxApAnchorBar :: missing parent first level for item " + oButton.getText());
			} else {
				this.removeContent(oButton);
			}
		} else {
			oPopoverState.oLastFirstLevelButton = oButton;

			//default behavior: the first level show a popover containing second levels
			if (this.getShowPopover()) {
				oPopoverState.oCurrentPopover = new Popover({
					placement: PlacementType.Bottom,
					showHeader: false,
					verticalScrolling: true,
					horizontalScrolling: false,
					contentWidth: "auto",
					showArrow: false
				});

				oPopoverState.oCurrentPopover.addStyleClass("sapUxAPAnchorBarPopover");

				this._addKeyboardHandling(oPopoverState.oCurrentPopover);

				this.addAggregation('_popovers', oPopoverState.oCurrentPopover);
				//alternative behavior: the first level triggers direct navigation
			} else if (!this._oPressHandlers[oPopoverState.oLastFirstLevelButton.getId()]) {
				fnPressHandler = jQuery.proxy(this._handleDirectScroll, this);

				oPopoverState.oLastFirstLevelButton.attachPress(fnPressHandler);

				this._oPressHandlers[oPopoverState.oLastFirstLevelButton.getId()] = fnPressHandler;
			}
		}
	};

	AnchorBar.prototype._addKeyboardHandling = function (oCurrentPopover) {
		oCurrentPopover.onsapdown = function (oEvent) {
			if (oEvent.target.nextSibling) {
				oEvent.target.nextSibling.focus();
			}
		};
		oCurrentPopover.onsapright = function (oEvent) {
			oCurrentPopover.onsapdown(oEvent);
		};
		oCurrentPopover.onsapup = function (oEvent) {
			if (oEvent.target.previousSibling) {
				oEvent.target.previousSibling.focus();
			}
		};
		oCurrentPopover.onsapleft = function (oEvent) {
			oCurrentPopover.onsapup(oEvent);
		};
		oCurrentPopover.onsaphome = function (oEvent) {
			if (oEvent.target.parentElement.firstChild) {
				oEvent.target.parentElement.firstChild.focus();
			}
		};
		oCurrentPopover.onsapend = function (oEvent) {
			if (oEvent.target.parentElement.lastChild) {
				oEvent.target.parentElement.lastChild.focus();
			}
		};
		oCurrentPopover.onsappageup = this._handlePageUp.bind(oCurrentPopover);
		oCurrentPopover.onsappagedown = this._handlePageDown.bind(oCurrentPopover);
	};

	AnchorBar.prototype._detachPopoverHandler = function (oButton) {
		if (this._oPressHandlers[oButton.getId()]) {
			oButton.detachPress(this._oPressHandlers[oButton.getId()]);
			this._oPressHandlers[oButton.getId()] = null;
		}
	};

	AnchorBar.prototype._handlePopover = function (oEvent) {
		var aPopoverButtons = this.oCurrentPopover.getContent() || [];

		//open the popover only if we are in Tablet/Desktop scenario = the button is visible in the anchorBar
		if (this.oLastFirstLevelButton.$().is(":visible")) {

			//specific use case management: if there are only 1 button in the popover, then we don't display it and navigate directly (= the subsection is "promoted" it to a section level)
			//this is a specific behavior asked by UX as of Sep 25, 2014
			if (aPopoverButtons.length == 1) {
				aPopoverButtons[0].firePress({});
			} else {
				this.oCurrentPopover.openBy(this.oLastFirstLevelButton);
			}
		}
	};

	AnchorBar.prototype._handleDirectScroll = function (oEvent) {

		if (oEvent.getSource().getParent() instanceof Popover) {
			oEvent.getSource().getParent().close();
		}

		this._requestScrollToSection(oEvent.getSource().data("sectionId"));
	};

	AnchorBar.prototype._requestScrollToSection = function (sRequestedSectionId) {

		var oRequestedSection = sap.ui.getCore().byId(sRequestedSectionId),
			oRequestedSectionParent = oRequestedSection.getParent();

		if (this.getParent() instanceof library.ObjectPageLayout) {

			// determine the next section that will appear selected in the anchorBar after the scroll
			var sNextSelectedSection = sRequestedSectionId;

			// if the requestedSection is a subsection, the the nextSelectedSection will be its parent (since anchorBar contains only first-level sections)
			if (oRequestedSection instanceof library.ObjectPageSubSection &&
				oRequestedSectionParent instanceof library.ObjectPageSection) {
				sNextSelectedSection = oRequestedSectionParent.getId();
			}
			// we set *direct* scrolling by which we instruct the page to *skip* processing of intermediate sections (sections between current and requested)
			this.getParent().setDirectScrollingToSection(sNextSelectedSection);
			// finally request the page to scroll to the requested section
			this.getParent().scrollToSection(oRequestedSection.getId());
		}

		if (oRequestedSection instanceof library.ObjectPageSubSection &&
			oRequestedSectionParent instanceof library.ObjectPageSection) {
			oRequestedSectionParent.setAssociation("selectedSubSection", oRequestedSection, true);
		}
	};

	/**
	 * called on phone display only when a user selects a section to navigate to
	 * simulate the press on the corresponding button
	 * @param {*} oEvent event
	 * @private
	 */
	AnchorBar.prototype._onSelectChange = function (oEvent) {
		var oSelectedItem = oEvent.getParameter("selectedItem"), oOriginalControl;

		oOriginalControl = sap.ui.getCore().byId(oSelectedItem.getKey());

		if (oOriginalControl) {

			this._requestScrollToSection(oOriginalControl.data("sectionId"));
		} else {
			jQuery.sap.log.error("AnchorBar :: cannot find corresponding button", oSelectedItem.getKey());
		}
	};

	AnchorBar.prototype._getHierarchicalSelect = function () {

		if (!this.getAggregation('_select')) {

			this.setAggregation('_select', new HierarchicalSelect({
				width: "100%",
				icon: "sap-icon://slim-arrow-down",
				change: jQuery.proxy(this._onSelectChange, this)
			}));
		}

		return this.getAggregation('_select');
	};

	/**
	 * Creates a new scroll arrow. The scroll arrow consists of two controls:
	 * 1. A HorizontalLayout which is used to display the gradient mask and to serve as a container for the arrow.
	 * 2. A Button which displays the arrow itself.
	 * In bluecrystal theme the button appears when hovering over the gradient mask and is not focusable.
	 * In HCB, the button is always visible and can receive focus.
	 *
	 * @param {boolean} bLeft indicates whether this is the left button
	 * @return {sap.ui.layout.HorizontalLayout} a new scroll arrow
	 * @private
	 */
	AnchorBar.prototype._createScrollArrow = function (bLeft) {
		var sArrowId,
			sIconName,
			sArrowClass,
			oScrollButton,
			that = this;

		if (bLeft) {
			sArrowId = this.getId() + "-arrowScrollLeft";
			sIconName = "slim-arrow-left";
			sArrowClass = "anchorBarArrowLeft";
		} else {
			sArrowId = this.getId() + "-arrowScrollRight";
			sIconName = "slim-arrow-right";
			sArrowClass = "anchorBarArrowRight";
		}

		oScrollButton = new Button(sArrowId, {
			icon: IconPool.getIconURI(sIconName),
			type: "Transparent",
			press: function (oEvent) {
				oEvent.preventDefault();
				that._handleScrollButtonTap(bLeft);
			}
		});

		oScrollButton.addEventDelegate({
			onAfterRendering: function () {
				if (sap.ui.getCore().getConfiguration().getTheme() != "sap_hcb") {
					this.$().attr("tabindex", -1);
				}
			},
			onThemeChanged: function () {
				if (sap.ui.getCore().getConfiguration().getTheme() == "sap_hcb") {
					this.$().removeAttr("tabindex");
				} else {
					this.$().attr("tabindex", -1);
				}
			}
		}, oScrollButton);

		return new HorizontalLayout({
			content: [oScrollButton]
		}).addStyleClass("anchorBarArrow").addStyleClass(sArrowClass);
	};

	/**
	 * Overwritten getter for aggregation "_scrollArrowLeft".
	 * Implements lazy loading mechanism.
	 *
	 * @return {sap.ui.layout.HorizontalLayout} reference to the left scroll arrow instance
	 * @private
	 */
	AnchorBar.prototype._getScrollArrowLeft = function () {

		var oScrollArrowLeft = this.getAggregation("_scrollArrowLeft");

		if (oScrollArrowLeft) {
			return oScrollArrowLeft;
		} else {
			oScrollArrowLeft = this._createScrollArrow(true);
			this.setAggregation("_scrollArrowLeft", oScrollArrowLeft);
			return oScrollArrowLeft;
		}
	};

	/**
	 * Overwritten getter for aggregation "_scrollArrowRight".
	 * Implements lazy loading mechanism.
	 *
	 * @return {sap.ui.layout.HorizontalLayout} reference to the right scroll arrow instance
	 * @private
	 */
	AnchorBar.prototype._getScrollArrowRight = function () {

		var oScrollArrowRight = this.getAggregation("_scrollArrowRight");

		if (oScrollArrowRight) {
			return oScrollArrowRight;
		} else {
			oScrollArrowRight = this._createScrollArrow(false);
			this.setAggregation("_scrollArrowRight", oScrollArrowRight);
			return oScrollArrowRight;
		}
	};

	/*******************************************************************************
	 * Horizontal scrolling
	 ******************************************************************************/
	AnchorBar._hierarchicalSelectModes = {
		"Icon": "icon",   // Only icon - overview button mode
		"Text": "text"    // Text - phone mode
	};

	AnchorBar.prototype._applyHierarchicalSelectMode = function () {

		if (this._sHierarchicalSelectMode === AnchorBar._hierarchicalSelectModes.Icon) {
			this.$().find(".sapUxAPAnchorBarScrollContainer").show();

			this._oSelect.setWidth("auto");
			this._oSelect.setAutoAdjustWidth(true);
			this._oSelect.setType(sap.m.SelectType.IconOnly);
			this._computeBarSectionsInfo();

		} else {
			this.$().find(".sapUxAPAnchorBarScrollContainer").hide();

			this._oSelect.setWidth("100%");
			this._oSelect.setAutoAdjustWidth(false);
			this._oSelect.setType(sap.m.SelectType.Default);
		}

		this.$().toggleClass("sapUxAPAnchorBarOverflow", this._sHierarchicalSelectMode === AnchorBar._hierarchicalSelectModes.Icon);
	};

	AnchorBar.prototype._adjustSize = function () {

		//size changed => check if switch in display-mode (phone-view vs. desktop-view) needed
		var sNewMode = library.Utilities.isPhoneScenario() ?
			AnchorBar._hierarchicalSelectModes.Text :
			AnchorBar._hierarchicalSelectModes.Icon;

		if (sNewMode !== this._sHierarchicalSelectMode) {
			this._sHierarchicalSelectMode = sNewMode;
			this._applyHierarchicalSelectMode();
		}

		//size changed => check if overflow gradients needed
		if (this._sHierarchicalSelectMode === AnchorBar._hierarchicalSelectModes.Icon) {

			//don't go any further if the positions of the items are not calculated yet
			if (this._iMaxPosition < 0) {
				return;
			}

			var $dom = this.$(),
				$scrollContainer = $dom.find(".sapUxAPAnchorBarScrollContainer"),
				bNeedScrollingBegin,
				bNeedScrollingEnd,
				iContainerWidth;


			iContainerWidth = $scrollContainer.width();

			//do we need to scroll left or right
			if (this._bRtlScenario) {

				if (Device.browser.firefox) {
					bNeedScrollingEnd = Math.abs($scrollContainer.scrollLeft()) + iContainerWidth < (this._iMaxPosition - this._iTolerance);
					bNeedScrollingBegin = Math.abs($scrollContainer.scrollLeft()) >= this._iTolerance;
				} else {
					bNeedScrollingEnd = Math.abs($scrollContainer.scrollLeft()) >= this._iTolerance;
					bNeedScrollingBegin = Math.abs($scrollContainer.scrollLeft()) + iContainerWidth < (this._iMaxPosition - this._iTolerance);
				}
			} else {
				bNeedScrollingEnd = $scrollContainer.scrollLeft() + iContainerWidth < (this._iMaxPosition - this._iTolerance);
				bNeedScrollingBegin = $scrollContainer.scrollLeft() >= this._iTolerance;
			}

			jQuery.sap.log.debug("AnchorBar :: scrolled at " + $scrollContainer.scrollLeft(), "scrollBegin [" + (bNeedScrollingBegin ? "true" : "false") + "] scrollEnd [" + (bNeedScrollingEnd ? "true" : "false") + "]");

			$dom.toggleClass("sapUxAPAnchorBarScrollLeft", bNeedScrollingBegin);
			$dom.toggleClass("sapUxAPAnchorBarScrollRight", bNeedScrollingEnd);
		}


	};

	/**
	 * Handles scrolling via the scroll buttons.
	 *
	 * @param boolean bScrollLeft indicates whether the left arrow button was pressed
	 * @private
	 */
	AnchorBar.prototype._handleScrollButtonTap = function (bScrollLeft) {

		/* calculate the direction where to scroll
		 increase if:
		 - ltr and right arrow was pressed
		 - rtl and the left arrow was pressed
		 decrease if:
		 - ltr and the left arrow was pressed
		 - rtl and the right arrow was pressed */
		var iScrollDirection = ((!this._bRtlScenario && bScrollLeft) || (this._bRtlScenario && !bScrollLeft)) ? -1 : 1;

		this._oScroller.scrollTo(this._iMaxPosition * iScrollDirection, 0, AnchorBar.SCROLL_DURATION * 3); //increase scroll duration when scrolling to the other end of the anchorBar (UX requirement)
	};

	/**
	 * Scroll to a specific Section
	 *
	 * @param sId       id of the section to scroll to
	 * @param duration  Scroll duration. Default value is 0
	 *
	 */
	AnchorBar.prototype.scrollToSection = function (sId, duration) {

		if (this._bHasButtonsBar) {
			var iDuration = duration || AnchorBar.SCROLL_DURATION,
				iScrollTo;

			if ((this._sHierarchicalSelectMode === AnchorBar._hierarchicalSelectModes.Icon)
				&& this._oSectionInfo[sId]) {

				if (this._bRtlScenario && Device.browser.firefox) {
					// in firefox RTL mode we are working with negative numbers and we have to add the offset in order not to hide the selected item
					iScrollTo = this._oSectionInfo[sId].scrollLeft + this._iOffset;
				} else {
						//scroll to the positionRtl minus the offset (so the gradient never hide the selected item)
						iScrollTo = this._oSectionInfo[sId].scrollLeft - this._iOffset;
						if (iScrollTo < 0) { //do not allow hiding part of the content if negative value for scroll is calculated here
							iScrollTo = 0;
						}
				}

				jQuery.sap.log.debug("AnchorBar :: scrolling to section " + sId + " of " + iScrollTo);

				//avoid triggering twice the scrolling onto the same target section
				if (this._sCurrentScrollId != sId) {
					this._sCurrentScrollId = sId;

					if (this._iCurrentScrollTimeout) {
						jQuery.sap.clearDelayedCall(this._iCurrentScrollTimeout);
						jQuery.sap.byId(this.getId() + "-scroll").parent().stop(true, false);
					}

					this._iCurrentScrollTimeout = jQuery.sap.delayedCall(duration, this, function () {
						this._sCurrentScrollId = undefined;
						this._iCurrentScrollTimeout = undefined;
					});

					this._oScroller.scrollTo(iScrollTo, 0, iDuration);
				}
			} else {
				jQuery.sap.log.debug("AnchorBar :: no need to scroll to " + sId);
			}
		}
	};

	/**
	 * Returns the sap.ui.core.ScrollEnablement delegate which is used with this control.
	 */
	AnchorBar.prototype.getScrollDelegate = function () {
		return this._oScroller;
	};

	/*******************************************************************************
	 * Keyboard navigation
	 ******************************************************************************/
	AnchorBar.PAGEUP_AND_PAGEDOWN_JUMP_SIZE = 5;

	/**
	 * Handles DOWN key, triggered on anchor bar level.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype.onsapdown = function (oEvent) {
		oEvent.preventDefault();
		if (oEvent.target.nextSibling) {
			oEvent.target.nextSibling.focus();
		}
	};

	/**
	 * Handles RIGHT key, triggered on anchor bar level.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype.onsapright = function (oEvent) {
		this.onsapdown(oEvent);
	};

	/**
	 * Handles UP key, triggered on anchor bar level.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype.onsapup = function (oEvent) {
		oEvent.preventDefault();
		if (oEvent.target.previousSibling) {
			oEvent.target.previousSibling.focus();
		}
	};

	/**
	 * Handles LEFT key, triggered on anchor bar level.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype.onsapleft = function (oEvent) {
		this.onsapup(oEvent);
	};

	/**
	 * Handles HOME key, triggered on anchor bar level.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype.onsaphome = function (oEvent) {
		oEvent.preventDefault();
		if (oEvent.target.parentElement.firstChild) {
			oEvent.target.parentElement.firstChild.focus();
		}
	};

	/**
	 * Handles END key, triggered on anchor bar level.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype.onsapend = function (oEvent) {
		oEvent.preventDefault();
		if (oEvent.target.parentElement.lastChild) {
			oEvent.target.parentElement.lastChild.focus();
		}
	};

	/**
	 * Handles PAGE UP key, triggered on anchor bar level.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype.onsappageup = function (oEvent) {
		this._handlePageUp(oEvent);
	};

	/**
	 * Handles PAGE DOWN key, triggered on anchor bar level.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype.onsappagedown = function (oEvent) {
		this._handlePageDown(oEvent);
	};

	/**
	 * Handler for sappageup event.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype._handlePageUp = function (oEvent) {
		oEvent.preventDefault();

		var iNextIndex;
		var aAnchors = this.getContent();

		aAnchors.forEach(function (oAnchor, iAnchorIndex) {
			if (oAnchor.getId() === oEvent.target.id) {
				iNextIndex = iAnchorIndex - (AnchorBar.PAGEUP_AND_PAGEDOWN_JUMP_SIZE + 1);
				return;
			}
		});

		if (iNextIndex && aAnchors[iNextIndex]) {
			aAnchors[iNextIndex].focus();
		} else if (aAnchors[0]) {
			aAnchors[0].focus();
		}
	};

	/**
	 * Handler for sappagedown event.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	AnchorBar.prototype._handlePageDown = function (oEvent) {
		oEvent.preventDefault();

		var iNextIndex;
		var aAnchors = this.getContent();

		aAnchors.forEach(function (oAnchor, iAnchorIndex) {
			if (oAnchor.getId() === oEvent.target.id) {
				iNextIndex = iAnchorIndex + AnchorBar.PAGEUP_AND_PAGEDOWN_JUMP_SIZE + 1;
				return;
			}
		});

		if (iNextIndex && aAnchors[iNextIndex]) {
			aAnchors[iNextIndex].focus();
		} else if (aAnchors[aAnchors.length - 1]) {
			aAnchors[aAnchors.length - 1].focus();
		}
	};

	/**
	 * handle tab focusing
	 */
	AnchorBar.prototype._setAnchorButtonsTabFocusValues = function (oSelectedButton) {
		var aAnchorBarContent = this.getContent() || [],
			$anchorBarItem,
			sFocusable = '0',
			sNotFocusable = '-1',
			sTabIndex = "tabIndex";

		aAnchorBarContent.forEach(function (oAnchorBarItem) {
			$anchorBarItem = oAnchorBarItem.$();
			if (oAnchorBarItem.sId === oSelectedButton.sId) {
				$anchorBarItem.attr(sTabIndex, sFocusable);
			} else {
				$anchorBarItem.attr(sTabIndex, sNotFocusable);
			}
		});
	};

	/**
	 * Handler for F6
	 *
	 * @param oEvent - The event object
	 */
	AnchorBar.prototype.onsapskipforward = function (oEvent) {
		this._handleGroupNavigation(oEvent, false);
	};

	/**
	 * Handler for F6 and Shift + F6 group navigation
	 *
	 * @param oEvent {jQuery.EventObject}
	 * @param bShiftKey serving as a reference if shift is used
	 * @private
	 */
	AnchorBar.prototype._handleGroupNavigation = function (oEvent, bShiftKey) {
		var oEventF6 = jQuery.Event("keydown"),
			oSettings = {},
			aSections = this.getParent().getSections(),
			aSubSections = [this.getDomRef()],
			aCurruntSubSections;

		//this is needed in order to be sure that next F6 group will be found in sub sections
		aSections.forEach(function (oSection) {
			aCurruntSubSections = oSection.getSubSections().map(function (oSubSection) {
				return oSubSection.$().attr("tabindex", -1)[0];
			});

			aSubSections = aSubSections.concat(aCurruntSubSections);
		});
		oSettings.scope = aSubSections;

		oEvent.preventDefault();
		this.$().focus();

		oEventF6.target = oEvent.target;
		oEventF6.keyCode = jQuery.sap.KeyCodes.F6;
		oEventF6.shiftKey = bShiftKey;

		jQuery.sap.handleF6GroupNavigation(oEventF6, oSettings);
	};

	/**
	 * called for figuring out responsive scenarios
	 */
	AnchorBar.prototype.onAfterRendering = function () {
		if (Toolbar.prototype.onAfterRendering) {
			Toolbar.prototype.onAfterRendering.call(this);
		}

		this._sHierarchicalSelectMode = AnchorBar._hierarchicalSelectModes.Text;

		//save max for arrow show/hide management, the max position is the required scroll for the the item to be fully visible
		this._iMaxPosition = -1;

		//show/hide scrolling arrows
		this._sResizeListenerId = ResizeHandler.register(this, jQuery.proxy(this._adjustSize, this));

		this.$().find(".sapUxAPAnchorBarScrollContainer").scroll(jQuery.proxy(this._onScroll, this));

		//restore state from previous rendering
		if (this.getSelectedButton()) {
			this.setSelectedButton(this.getSelectedButton());
		}

		//initial state
		if (this._bHasButtonsBar) {
			this._adjustSize();
		}
	};

	AnchorBar.prototype._onScroll = function () {
		if (!this._iCurrentSizeCheckTimeout) {
			this._iCurrentSizeCheckTimeout = jQuery.sap.delayedCall(AnchorBar.SCROLL_DURATION, this, function () {
				this._iCurrentSizeCheckTimeout = undefined;
				this._adjustSize();
			});
		}
	};

	AnchorBar.prototype._computeBarSectionsInfo = function () {

		//reset the max position
		this._iMaxPosition = 0;

		var aContent = this.getContent() || [];

		aContent.forEach(this._computeNextSectionInfo, this);

		//post processing based on how browsers implement rtl
		//chrome, safari && Device.browser.webkit && firefox
		if (this._bRtlScenario && (Device.browser.webkit || Device.browser.firefox)) {
			aContent.forEach(this._adjustNextSectionInfo, this); // adjust positions depending of the browser
			this._oScroller.scrollTo(this._iMaxPosition, 0, 0);
		}
	};

	AnchorBar.prototype._computeNextSectionInfo = function (oContent) {
		// set ARIA has-popup if button opens submenu
		if (oContent.data("bHasSubMenu")) {
			oContent.$().attr("aria-haspopup", "true");
		}
		// set ARIA attributes of main buttons
		oContent.$().attr("aria-controls", oContent.data("sectionId"));

		var iWidth = oContent.$().outerWidth(true);

		//store info on the various sections for horizontalScrolling
		//scrollLeft is the amount of scroll required for reaching that item in normal mode
		this._oSectionInfo[oContent.data("sectionId")] = {
			scrollLeft: this._iMaxPosition,
			width: iWidth
		};

		this._iMaxPosition += iWidth;
	};

	/**
	 * Adjustment for webkit only
	 *
	 * Reverse the position as the scroll 0 is at the far end (first item = maxPosition, last item = 0)
	 */
	AnchorBar.prototype._adjustNextSectionInfo = function (oContent) {

		var oSectionInfo = this._oSectionInfo[oContent.data("sectionId")];

		if (Device.browser.firefox) {
			// 27.11.2015 fix made for the following issue
			// firefox not working yet see internal incident 1570001701
			oSectionInfo.scrollLeft = -oSectionInfo.scrollLeft;
		} else {
			 // Reverse all positions as the scroll 0 is at the far end (first item = maxPosition, last item = 0)
			oSectionInfo.scrollLeft = this._iMaxPosition - oSectionInfo.scrollLeft - oSectionInfo.width;
		}


	};

	/**
	 * clean created controls and deregister handlers
	 */
	AnchorBar.prototype.exit = function () {

		if (this._sResizeListenerId) {
			ResizeHandler.deregister(this._sResizeListenerId);
			this._sResizeListenerId = null;
		}

		if (this._oScroller) {
			this._oScroller.destroy();
			this._oScroller = null;
		}
	};


	return AnchorBar;

});

}; // end of sap/uxap/AnchorBar.js
if ( !jQuery.sap.isDeclared('sap.uxap.BlockBase') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.BlockBase.
jQuery.sap.declare('sap.uxap.BlockBase'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.CustomData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Context'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.ResponsiveGridLayout'); // unlisted dependency retained
sap.ui.define("sap/uxap/BlockBase",[
	"sap/ui/core/Control",
	"sap/ui/core/CustomData",
	"./BlockBaseMetadata",
	"./ModelMapping",
	"sap/ui/model/Context",
	"sap/ui/Device",
	"sap/ui/layout/form/ResponsiveGridLayout",
	"./library"
], function (Control, CustomData, BlockBaseMetadata, ModelMapping, Context, Device, ResponsiveGridLayout, library) {
		"use strict";

		/**
		 * Constructor for a new BlockBase.
		 *
		 * @param {string} [sId] id for the new control, generated automatically if no id is given
		 * @param {object} [mSettings] initial settings for the new control
		 *
		 * @class
		 *
		 * A block is the main element that will be displayed, mainly in an object page, but not necessarily
		 * only there.
		 *
		 * A block is a control that use a view for storing its internal control tree.
		 * A block is a control that has modes and a view associated to each modes.
		 * At rendering time, the view associated to the mode is rendered.
		 *
		 * As any UI5 views, the view can have a controller which automatically comes a this.oParentBlock attribute (so that the controller can interacts with the block).
		 * If the controller implements the onParentBlockModeChange method, this method will get called with the sMode parameter when the view is used or re-used by the block.
		 *
		 * @extends sap.ui.core.Control
		 * @author SAP SE
		 * @constructor
		 * @public
		 * @since 1.26
		 * @alias sap.uxap.BlockBase
		 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
		 */

		var BlockBase = Control.extend("sap.uxap.BlockBase", {
			metadata: {
				library: "sap.uxap",
				properties: {
					/**
					 * Determines the mode of the block.
					 * When block is used inside ObjectPage this mode is inherited my the SubSection.
					 * The mode of the block is changed when SubSection mode changes.
					 */
					"mode": {type: "string", group: "Appearance"},

					/**
					 * Determines the visibility of the block.
					 */
					"visible": {type: "boolean", group: "Appearance", defaultValue: true},

					/**
					 * Determines on how columns the layout will be rendered.
					 * Allowed values are integers from 1 to 4 and "auto".
					 */
					"columnLayout": {type: "sap.uxap.BlockBaseColumnLayout", group: "Behavior", defaultValue: "auto"},

					/**
					 * Determines if the block should automatically adjust its inner forms.
					 * Allowed values are "BlockColumns" and "OneColumn" and "None".
					 * If the value is "BlockColumns", then the inner form will have as many columns as the colspan of its parent block.
					 * If the value is "OneColumn", the inner form will have exactly one column, regardless the colspan of its parent block.
					 * If the value is "None", no automatic adjustment of inner forms will be made and the form will keep its original column count.
					 */
					"formAdjustment": {
						type: "sap.uxap.BlockBaseFormAdjustment",
						group: "Behavior",
						defaultValue: sap.uxap.BlockBaseFormAdjustment.BlockColumns
					},

					/**
					 * Determines whether the show more button should be shown.
					 */
					"showSubSectionMore": {type: "boolean", group: "Behavior", defaultValue: false}
				},
				defaultAggregation: "mappings",
				aggregations: {

					/**
					 * Map external UI5 model and internal Block model
					 */
					"mappings": {type: "sap.uxap.ModelMapping", multiple: true, singularName: "mapping"},

					/**
					 * Internal aggregation that contains all views inside this Block
					 */
					"_views": {type: "sap.ui.core.Control", multiple: true, singularName: "view", visibility: "hidden"}
				},
				associations: {

					/**
					 * The view that is rendered now.
					 * Can be used as getter for the rendered view.
					 */
					"selectedView": {type: "sap.ui.core.Control", multiple: false}
				},
				views: {

//				 define your views here following the pattern:
//				 "yourModeName": {viewName: "your.view.path" , type: "yourUI5ViewType" }
//				 for example:
//				 "Collapsed": {
//				 viewName: "sap.uxap.testblocks.multiview.MultiViewBlockCollapsed",
//				 type: "XML"
//				 },
//				 "Expanded": {
//				 viewName: "sap.uxap.testblocks.multiview.MultiViewBlockExpanded",
//				 type: "XML"
//				 }
//
//				 if no views are provided, the blockBase looks for an xml view which name is equal to the block's one
//
				}
			},
			renderer: "sap.uxap.BlockBaseRenderer"
		}, BlockBaseMetadata);

		BlockBase.prototype.init = function () {
			//convenience mechanism:
			//if there are no views defined by the Block,
			// we look for the default one which would have the same name as the block and type XML
			if (!this.getMetadata().hasViews()) {
				this.getMetadata().setView("defaultXML", {viewName: this.getMetadata().getName(), type: "XML"});
			}

			//for performance optimization
			this._oMappingApplied = {};

			//lazy loading
			this._bLazyLoading = false; //by default, no lazy loading so we can use it out of an objectPageLayout
			this._bConnected = false;   //indicates connectToModels function has been called
			this._oUpdatedModels = {};
		};

		BlockBase.prototype.onBeforeRendering = function () {
			if (!this.getMode() || this.getMode() === "") {
				if (this.getMetadata().getView("defaultXML")) {
					this.setMode("defaultXML");
				} else {
					jQuery.sap.log.error("BlockBase ::: there is no mode defined for rendering " + this.getMetadata().getName() +
						". You can either set a default mode on the block metadata or set the mode property before rendering the block.");
				}
			}

			this._applyFormAdjustment();

			//TODO: for iconTabBar mode, specify lazyLoading for selectedTab only?
			this._bLazyLoading = this._getObjectPageLayout()
								&& (this._getObjectPageLayout().getEnableLazyLoading() || this._getObjectPageLayout().getUseIconTabBar());
		};

		BlockBase.prototype.onAfterRendering = function () {
			if (this._getObjectPageLayout()) {
				this._getObjectPageLayout()._adjustLayout();
			}
		};

		/**
		 * Set the parent control for the current block.
		 * Every time the parent changes, we try to find the parent objectPageLayout in order to determine the lazy loading strategy to apply.
		 * @param {*} oParent parent instance
		 * @param {*} sAggregationName aggregation name
		 * @param {*} bSuppressInvalidate invalidate
		 */
		BlockBase.prototype.setParent = function (oParent, sAggregationName, bSuppressInvalidate) {
			Control.prototype.setParent.call(this, oParent, sAggregationName, bSuppressInvalidate);

			if (oParent instanceof library.ObjectPageSubSection) {
				this._bLazyLoading = true; //we activate the block lazy loading since we are within an objectPageLayout
				this._oParentObjectPageSubSection = oParent;
			}
		};

		/*********************************************
		 * model mapping management
		 * *******************************************/


		/**
		 * This triggers rerendering of itself and its children.<br/> As <code>sap.ui.base.ManagedObject</code> "bubbles up" the
		 * invalidate, changes to child-<code>Elements</code> will also result in rerendering of the whole sub tree.
		 * @protected
		 * @name sap.ui.base.ManagedObject#invalidate
		 * @function
		 * @param {*} oOrigin the name of the origin
		 */
		BlockBase.prototype.invalidate = function (oOrigin) {
			this._applyMapping();
			Control.prototype.invalidate.call(this, oOrigin);
		};

		/**
		 * Intercept direct setModel calls.
		 * @param {*} oModel model instance
		 * @param {*} sName name of the model
		 * @returns {sap.ui.base.ManagedObject} instance of managed object
		 */
		BlockBase.prototype.setModel = function (oModel, sName) {
			this._applyMapping(sName);
			return Control.prototype.setModel.call(this, oModel, sName);
		};

		/**
		 * Called for applying the modelmapping once all properties are set.
		 * @private
		 */
		BlockBase.prototype._applyMapping = function () {
			if (this._bLazyLoading && !this._bConnected) {
				jQuery.sap.log.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected");
			} else {
				this.getMappings().forEach(function (oMapping, iIndex) {
					var oModel,
						sInternalModelName = oMapping.getInternalModelName(),
						sExternalPath = oMapping.getExternalPath(),
						sExternalModelName = oMapping.getExternalModelName(),
						sPath;

					if (sExternalPath) {
						if (sInternalModelName == "" || sExternalPath == "") {
							throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty");
						}

						if (!this._isMappingApplied(sInternalModelName) /* check if mapping is set already */
							|| (this.getModel(sInternalModelName) != this.getModel(sExternalModelName)) /* model changed, then we have to update internal model mapping */) {

							jQuery.sap.log.info("BlockBase :: mapping external model " + sExternalModelName + " to " + sInternalModelName);

							oModel = this.getModel(sExternalModelName);

							if (oModel) {
								sPath = oModel.resolve(sExternalPath, this.getBindingContext(sExternalModelName));

								this._oMappingApplied[sInternalModelName] = true;
								Control.prototype.setModel.call(this, oModel, sInternalModelName);
								this.setBindingContext(new Context(oModel, sPath), sInternalModelName);
							}
						}
					}
				}, this);
			}
		};

		BlockBase.prototype._isMappingApplied = function (sInternalModelName) {
			return this.getModel(sInternalModelName) && this._oMappingApplied[sInternalModelName];
		};

		/**
		 * Intercept propagated properties.
		 * @param {*} vName property instance or property name
		 * @returns {*} propagateProperties function result
		 */
		BlockBase.prototype.propagateProperties = function (vName) {
			if (this._bLazyLoading && !this._bConnected && !this._oUpdatedModels.hasOwnProperty(vName)) {
				this._oUpdatedModels[vName] = true;
			} else {
				this._applyMapping(vName);
			}

			return Control.prototype.propagateProperties.call(this, vName);
		};

		/*********************************************
		 * mode vs views management
		 * *******************************************/

		/**
		 * Returns an object containing the supported modes for the block.
		 * @returns {sap.ui.core/object} supported modes
		 */
		BlockBase.prototype.getSupportedModes = function () {
			var oSupportedModes = jQuery.extend({}, this.getMetadata().getViews());

			for (var key in oSupportedModes) {
				oSupportedModes[key] = key; //this is what developers expect, for ex: {Collapsed:"Collapsed"}
			}

			return oSupportedModes;
		};

		/**
		 * Set the view mode for this particular block.
		 * @public
		 * @param {string} sMode the mode to apply to the control (that should be synchronized with view declared)
		 * @returns {*} this
		 */
		BlockBase.prototype.setMode = function (sMode) {
			sMode = this._validateMode(sMode);

			if (this.getMode() !== sMode) {
				this.setProperty("mode", sMode, false);
				//if Lazy loading is enabled, and if the block is not connected
				//delay the view creation (will be done in connectToModels function)
				if (!this._bLazyLoading || this._bConnected) {
					this._initView(sMode);
				}
			}

			return this;
		};

		/**
		 * Set the column layout for this particular block.
		 * @param {string} sLayout The column layout to apply to the control
		 * @public
		 */
		BlockBase.prototype.setColumnLayout = function (sLayout) {
			if (this._oParentObjectPageSubSection) {
				this._oParentObjectPageSubSection.invalidate();
				/*the parent subsection needs to recalculate block layout data
				 based on the changed block column layout */
			}
			this.setProperty("columnLayout", sLayout);
		};

		/**
		 * Provide a clone mechanism: the selectedView needs to point to one of the _views.
		 * @returns {sap.ui.core.Element} cloned element
		 */
		BlockBase.prototype.clone = function () {
			var iAssocIndex = -1,
				sAssoc = this.getAssociation("selectedView"),
				aViews = this.getAggregation("_views") || [];

			//find the n-view associated
			if (sAssoc) {
				aViews.forEach(function (oView, iIndex) {

					if (oView.getId() === sAssoc) {
						iAssocIndex = iIndex;
					}

					return iAssocIndex < 0;
				});
			}

			var oNewThis = Control.prototype.clone.call(this);
			//we need to maintain the association onto the new object
			if (iAssocIndex >= 0) {
				oNewThis.setAssociation("selectedView", oNewThis.getAggregation("_views")[iAssocIndex]);
			}

			return oNewThis;
		};

		/**
		 * Validate that the provided mode has been declared in the metadata views section, throw an exception otherwise.
		 * @param {*} sMode mode
		 * @returns {*} sMode
		 * @private
		 */
		BlockBase.prototype._validateMode = function (sMode) {
			this.validateProperty("mode", sMode); //type expected as per properties definition

			if (!this.getMetadata().getView(sMode)) {
				var sBlockName = this.getMetadata()._sClassName || this.getId();

				//the view wasn't defined.
				//as a fallback mechanism: we look for the defaultXML one and raise an error before raising an exception
				if (this.getMetadata().getView("defaultXML")) {
					jQuery.sap.log.warning("BlockBase :: no view defined for block " + sBlockName + " for mode " + sMode + ", loading defaultXML instead");
					sMode = "defaultXML";
				} else {
					throw new Error("BlockBase :: no view defined for block " + sBlockName + " for mode " + sMode);
				}
			}

			return sMode;
		};

		/**
		 * Get the view associated with the selectedView.
		 * @returns {*} Selected view
		 * @private
		 */
		BlockBase.prototype._getSelectedViewContent = function () {
			var oView = null, sSelectedViewId, aViews;

			sSelectedViewId = this.getAssociation("selectedView");
			aViews = this.getAggregation("_views");

			if (aViews) {
				for (var i = 0; !oView && i < aViews.length; i++) {
					if (aViews[i].getId() === sSelectedViewId) {
						oView = aViews[i];
					}
				}
			}

			return oView;
		};

		/***
		 * Create view
		 * @param {*} mParameter parameter
		 * @returns {sap.ui.core.mvc.View} view
		 * @protected
		 */
		BlockBase.prototype.createView = function (mParameter) {
			return sap.ui.xmlview(mParameter);
		};

		/**
		 * Initialize a view and returns it if it has not been defined already.
		 * @param {*} sMode the valid mode corresponding to the view to initialize
		 * @returns {sap.ui.view} view
		 * @private
		 */
		BlockBase.prototype._initView = function (sMode) {
			var oView,
				aViews = this.getAggregation("_views") || [],
				mParameter = this.getMetadata().getView(sMode);

			//look for the views if it was already instantiated
			aViews.forEach(function (oCurrentView, iIndex) {
				if (oCurrentView.data("layoutMode") === sMode) {
					oView = oCurrentView;
				}
			});

			//the view is not instantiated yet, handle a new view scenario
			if (!oView) {
				oView = this._initNewView(sMode);
			}

			this.setAssociation("selectedView", oView, true);

			//try to notify the associated controller that the view is being used for this mode
			if (oView.getController() && oView.getController().onParentBlockModeChange) {
				oView.getController().onParentBlockModeChange(sMode);
			} else {
				jQuery.sap.log.info("BlockBase ::: could not notify " + mParameter.viewName + " of loading in mode " + sMode + ": missing controller onParentBlockModeChange method");
			}

			return oView;
		};

		/**
		 * Initialize new BlockBase view
		 * @param {*} sMode the valid mode corresponding to the view to initialize
		 * @returns {sap.ui.view} view
		 * @private
		 */
		BlockBase.prototype._initNewView = function (sMode) {
			var oView = this._getSelectedViewContent(),
				mParameter = this.getMetadata().getView(sMode);

			//check if the new view is not the current one (we may want to have the same view for several modes)
			if (!oView || mParameter.viewName != oView.getViewName()) {
				oView = this.createView(mParameter);

				//link to the controller defined in the Block
				if (oView) {

					//inject a reference to this
					if (oView.getController()) {
						oView.getController().oParentBlock = this;
					}

					oView.addCustomData(new CustomData({
						"key": "layoutMode",
						"value": sMode
					}));

					this.addAggregation("_views", oView, true);
				} else {
					throw new Error("BlockBase :: no view defined in metadata.views for mode " + sMode);
				}
			}

			return oView;
		};

		BlockBase._FORM_ADJUSTMENT_CONST = {
			breakpoints: {
				XL: Device.media._predefinedRangeSets.StdExt.points[2],
				L: Device.media._predefinedRangeSets.StdExt.points[1],
				M: Device.media._predefinedRangeSets.StdExt.points[0]
			},
			labelSpan: {
				/* values specified by design requirement */
				XL: 12,
				L: 12,
				M: 12,
				S: 12
			},
			emptySpan: {
				/* values specified by design requirement */
				XL: 0,
				L: 0,
				M: 0,
				S: 0
			},
			columns: {
				XL: 1,
				L: 1,
				M: 1
			}
		};

		BlockBase._PARENT_GRID_SIZE = 12;

		BlockBase.prototype._computeFormAdjustmentFields = function (oView, oLayoutData, sFormAdjustment, oParentColumns) {

			if (oView && oLayoutData && sFormAdjustment && oParentColumns) {

				var oColumns = this._computeFormColumns(oLayoutData, sFormAdjustment, oParentColumns),
					oBreakpoints = this._computeFormBreakpoints(oLayoutData, sFormAdjustment);

				return jQuery.extend({},
					BlockBase._FORM_ADJUSTMENT_CONST,
					{columns: oColumns},
					{breakpoints: oBreakpoints});
			}
		};

		BlockBase.prototype._computeFormColumns = function (oLayoutData, sFormAdjustment, oParentColumns) {

			var oColumns = jQuery.extend({}, BlockBase._FORM_ADJUSTMENT_CONST.columns);

			if (sFormAdjustment === sap.uxap.BlockBaseFormAdjustment.BlockColumns) {

				var iColumnSpanXL = BlockBase._PARENT_GRID_SIZE / oParentColumns.XL,
					iColumnSpanL = BlockBase._PARENT_GRID_SIZE / oParentColumns.L,
					iColumnSpanM = BlockBase._PARENT_GRID_SIZE / oParentColumns.M;

				oColumns.XL = oLayoutData.getSpanXL() / iColumnSpanXL;
				oColumns.L = oLayoutData.getSpanL() / iColumnSpanL;
				oColumns.M = oLayoutData.getSpanM() / iColumnSpanM;
			}

			return oColumns;
		};

		BlockBase.prototype._computeFormBreakpoints = function (oLayoutData, sFormAdjustment) {

			var oBreakpoints = jQuery.extend({}, BlockBase._FORM_ADJUSTMENT_CONST.breakpoints);

			if (sFormAdjustment === sap.uxap.BlockBaseFormAdjustment.BlockColumns) {
				oBreakpoints.XL = Math.round(oBreakpoints.XL * oLayoutData.getSpanXL() / BlockBase._PARENT_GRID_SIZE);
				oBreakpoints.L = Math.round(oBreakpoints.L * oLayoutData.getSpanL() / BlockBase._PARENT_GRID_SIZE);
				oBreakpoints.M = Math.round(oBreakpoints.M * oLayoutData.getSpanM() / BlockBase._PARENT_GRID_SIZE);
			}

			return oBreakpoints;
		};

		BlockBase.prototype._applyFormAdjustment = function () {

			var oLayoutData = this.getLayoutData(),
				sFormAdjustment = this.getFormAdjustment(),
				oView = this._getSelectedViewContent(),
				oParent = this._oParentObjectPageSubSection,
				oFormAdjustmentFields;

			if (sFormAdjustment && (sFormAdjustment !== sap.uxap.BlockBaseFormAdjustment.None)
				&& oView && oLayoutData && oParent) {

				var oParentColumns = oParent._oLayoutConfig;

				oView.getContent().forEach(function (oItem) {
					if (oItem.getMetadata().getName() === "sap.ui.layout.form.SimpleForm") {

						oItem.setLayout(sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout);

						if (!oFormAdjustmentFields) {
							oFormAdjustmentFields = this._computeFormAdjustmentFields(oView, oLayoutData, sFormAdjustment, oParentColumns);
						}

						this._applyFormAdjustmentFields(oFormAdjustmentFields, oItem);

						oItem.setWidth("100%");
					} else if (oItem.getMetadata().getName() === "sap.ui.layout.form.Form") {

						var oLayout = oItem.getLayout(),
							oResponsiveGridLayout;

						if (oLayout && oLayout.getMetadata().getName() === "sap.ui.layout.form.ResponsiveGridLayout") {
							oResponsiveGridLayout = oLayout; // existing ResponsiveGridLayout must be reused, otherwise an error is thrown in the existing implementation
						} else {
							oResponsiveGridLayout = new ResponsiveGridLayout();
							oItem.setLayout(oResponsiveGridLayout);
						}

						if (!oFormAdjustmentFields) {
							oFormAdjustmentFields = this._computeFormAdjustmentFields(oView, oLayoutData, sFormAdjustment, oParentColumns);
						}

						this._applyFormAdjustmentFields(oFormAdjustmentFields, oResponsiveGridLayout);

						oItem.setWidth("100%");
					}
				}, this);
			}
		};

		BlockBase.prototype._applyFormAdjustmentFields = function (oFormAdjustmentFields, oFormLayout) {

			//oFormLayout.setColumnsXL(oFormAdjustmentFields.columns.XL);
			oFormLayout.setColumnsL(oFormAdjustmentFields.columns.L);
			oFormLayout.setColumnsM(oFormAdjustmentFields.columns.M);

			//oFormLayout.setLabelSpanXL(oFormAdjustmentFields.labelSpan.XL);
			oFormLayout.setLabelSpanL(oFormAdjustmentFields.labelSpan.L);
			oFormLayout.setLabelSpanM(oFormAdjustmentFields.labelSpan.M);
			oFormLayout.setLabelSpanS(oFormAdjustmentFields.labelSpan.S);

			//oFormLayout.setEmptySpanXL(oFormAdjustmentFields.emptySpan.XL);
			oFormLayout.setEmptySpanL(oFormAdjustmentFields.emptySpan.L);
			oFormLayout.setEmptySpanM(oFormAdjustmentFields.emptySpan.M);
			oFormLayout.setEmptySpanS(oFormAdjustmentFields.emptySpan.S);

			//oFormLayout.setBreakpointXL(oFormAdjustmentFields.breakpoint.XL);
			oFormLayout.setBreakpointL(oFormAdjustmentFields.breakpoints.L);
			oFormLayout.setBreakpointM(oFormAdjustmentFields.breakpoints.M);
		};

		/*************************************************************************************
		 * objectPageLayout integration & lazy loading management
		 ************************************************************************************/

		/**
		 * Getter for the parent object page layout.
		 * @returns {*} OP layout
		 * @private
		 */
		BlockBase.prototype._getObjectPageLayout = function () {
			if (!this._oParentObjectPageLayout) {
				this._oParentObjectPageLayout = library.Utilities.getClosestOPL(this);
			}

			return this._oParentObjectPageLayout;
		};

		/**
		 * Setter for the visibility of the block.
		 * @public
		 */
		BlockBase.prototype.setVisible = function (bValue, bSuppressInvalidate) {
			this.setProperty("visible", bValue, bSuppressInvalidate);
			this._getObjectPageLayout() && this._getObjectPageLayout()._adjustLayoutAndUxRules();

			return this;
		};

		/**
		 * Set the showSubSectionMore property.
		 * Ask the parent ObjectPageSubSection to refresh its see more visibility state if present.
		 * @param bValue
		 * @param bInvalidate
		 * @returns {*}
		 */
		BlockBase.prototype.setShowSubSectionMore = function (bValue, bInvalidate) {
			//suppress invalidate as ShowSubSectionMore has no impact on block itself.
			if (bValue != this.getShowSubSectionMore()) {
				this.setProperty("showSubSectionMore", bValue, true);

				//refresh the parent subsection see more visibility if we have changed it and we are within an objectPageSubSection
				if (this._oParentObjectPageSubSection) {
					this._oParentObjectPageSubSection.refreshSeeMoreVisibility();
				}
			}

			return this;
		};

		/**
		 * Connect Block to the UI5 model tree.
		 * Initialize view if lazy loading is enabled.
		 * @returns {*}
		 */
		BlockBase.prototype.connectToModels = function () {
			if (!this._bConnected) {
				jQuery.sap.log.debug("BlockBase :: Connecting block to the UI5 model tree");
				this._bConnected = true;
				if (this._bLazyLoading) {
					//if lazy loading is enabled, the view has not been created during the setMode
					//so create it now
					var sMode = this.getMode();
					sMode && this._initView(sMode);
				}

				this.invalidate();
			}
		};

		/**
		 * Override of the default model lifecycle method to disable the automatic binding resolution for lazyloading.
		 * @override
		 * @param bSkipLocal
		 * @param bSkipChildren
		 * @param sModelName
		 * @param bUpdateAll
		 * @returns {*}
		 */
		BlockBase.prototype.updateBindingContext = function (bSkipLocal, bSkipChildren, sModelName, bUpdateAll) {
			if (!this._bLazyLoading || this._bConnected) {
				return Control.prototype.updateBindingContext.call(this, bSkipLocal, bSkipChildren, sModelName, bUpdateAll);
			} else {
				jQuery.sap.log.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");
			}
		};

		/**
		 * Override of the default model lifecycle method to disable the automatic binding resolution for lazyloading.
		 * @override
		 * @param bUpdateAll
		 * @param sModelName
		 * @returns {*}
		 */
		BlockBase.prototype.updateBindings = function (bUpdateAll, sModelName) {
			if (!this._bLazyLoading || this._bConnected) {
				return Control.prototype.updateBindings.call(this, bUpdateAll, sModelName);
			} else {
				jQuery.sap.log.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");
			}
		};

	return BlockBase;
});

}; // end of sap/uxap/BlockBase.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageHeader') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.ObjectPageHeader.
jQuery.sap.declare('sap.uxap.ObjectPageHeader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.CustomData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('sap.m.Text'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.ActionSheet'); // unlisted dependency retained
jQuery.sap.require('sap.m.Image'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Icon'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageHeader",[
	"sap/ui/core/Control",
	"sap/ui/core/IconPool",
	"sap/ui/core/CustomData",
	"sap/ui/Device",
	"./BreadCrumbs",
	"./ObjectPageHeaderActionButton",
	"sap/ui/core/ResizeHandler",
	"sap/m/Text",
	"sap/m/Button",
	"sap/m/ActionSheet",
	"sap/m/Image",
	"sap/ui/core/Icon",
	"./library"
], function (Control, IconPool, CustomData, Device, BreadCrumbs, ObjectPageHeaderActionButton,
			 ResizeHandler, Text, Button, ActionSheet, Image, Icon, library) {
	"use strict";

	/**
	 * Constructor for a new ObjectPageHeader.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * ObjectPageHeader represents the static part of an Object page header.
	 * Typically used to display the basic information about a business object, such as title/description/picture, as well as a list of common actions.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 *
	 * @constructor
	 * @public
	 * @alias sap.uxap.ObjectPageHeader
	 * @since 1.26
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectPageHeader = Control.extend("sap.uxap.ObjectPageHeader", /** @lends sap.uxap.ObjectPageHeader.prototype */ {
		metadata: {
			library: "sap.uxap",
			properties: {

				/**
				 * The URL of the image, representing the business object
				 */
				objectImageURI: {type: "string", defaultValue: null},

				/**
				 * The text to be used for the Alt and Tooltip attribute of the image, supplied via the objectImageURI property
				 */
				objectImageAlt: {type: "string", defaultValue: ''},

				/**
				 * The value of densityAware for the image, supplied via the objectImageURI property.
				 * See sap.m.Image for more details on densityAware.
				 */
				objectImageDensityAware: {type: "boolean", defaultValue: false},

				/**
				 * The title of the object
				 */
				objectTitle: {type: "string", defaultValue: null},

				/**
				 * The description of the object
				 */
				objectSubtitle: {type: "string", defaultValue: null},

				/**
				 * Determines whether the picture should be displayed in a square or with a circle-shaped mask.
				 */
				objectImageShape: {
					type: "sap.uxap.ObjectPageHeaderPictureShape",
					defaultValue: sap.uxap.ObjectPageHeaderPictureShape.Square
				},

				/**
				 * Determines whether the icon should always be visible or if it should be visible only when scrolling.
				 */
				isObjectIconAlwaysVisible: {type: "boolean", defaultValue: false},

				/**
				 * Determines whether the title should always be visible or if it should be visible only when scrolling.
				 */
				isObjectTitleAlwaysVisible: {type: "boolean", defaultValue: true},

				/**
				 * Determines whether the subtitle should always be visible or if it should be visible only when scrolling.
				 */
				isObjectSubtitleAlwaysVisible: {type: "boolean", defaultValue: true},

				/**
				 * Determines whether the action buttons should always be visible or if they should be visible only when scrolling.
				 */
				isActionAreaAlwaysVisible: {type: "boolean", defaultValue: true},

				/**
				 * Determines the design of the header - Light or Dark
				 */
				headerDesign: {
					type: "sap.uxap.ObjectPageHeaderDesign",
					defaultValue: sap.uxap.ObjectPageHeaderDesign.Light
				},

				/**
				 * When set to true, the selector arrow icon/image is shown and can be pressed.
				 */
				showTitleSelector: {type: "boolean", group: "Misc", defaultValue: false},

				/**
				 * Set the favorite state to true or false. The showMarkers property must be true for this property to take effect.
				 */
				markFavorite: {type: "boolean", group: "Misc", defaultValue: false},

				/**
				 * Set the flagged state to true or false. The showMarkers property must be true for this property to take effect.
				 */
				markFlagged: {type: "boolean", group: "Misc", defaultValue: false},

				/**
				 * Indicates if object page header title supports showing markers such as flagged and favorite.
				 */
				showMarkers: {type: "boolean", group: "Misc", defaultValue: false},

				/**
				 * Set the locked state of the objectPageHeader.
				 */
				markLocked: {type: "boolean", group: "Misc", defaultValue: false},

				/**
				 * Enables support of a placeholder image in case no image is specified or the URL of the provided image is invalid.
				 */
				showPlaceholder: {type: "boolean", group: "Misc", defaultValue: false},

				/**
				 * Marks that there are unsaved changes in the objectPageHeader.
				 * The markChanges state cannot be used together with the markLocked state.
				 * If both are set to true, only the locked state will be displayed.
				 * @since 1.34.0
				 */
				markChanges: {type: "boolean", group: "Misc", defaultValue: false}
			},
			defaultAggregation: "actions",
			aggregations: {

				/**
				 *
				 * Internal aggregation for the BreadCrumbs in the header.
				 */
				_breadCrumbs: {type: "sap.uxap.BreadCrumbs", multiple: false, visibility: "hidden"},

				/**
				 *
				 * A list of all the active link elements in the BreadCrumbs control.
				 */
				breadCrumbsLinks: {type: "sap.m.Link", multiple: true, singularName: "breadCrumbLink"},

				/**
				 *
				 * Internal aggregation for the overflow button in the header.
				 */
				_overflowButton: {type: "sap.m.Button", multiple: false, visibility: "hidden"},

				/**
				 *
				 * Internal aggregation for the expand header button.
				 */
				_expandButton: {type: "sap.m.Button", multiple: false, visibility: "hidden"},

				/**
				 *
				 * Icon for the identifier line.
				 */
				_objectImage: {type: "sap.ui.core.Control", multiple: false, visibility: "hidden"},
				_lockIconCont: {type: "sap.m.Button", multiple: false, visibility: "hidden"},
				_lockIcon: {type: "sap.m.Button", multiple: false, visibility: "hidden"},
				_titleArrowIconCont: {type: "sap.m.Button", multiple: false, visibility: "hidden"},
				_titleArrowIcon: {type: "sap.m.Button", multiple: false, visibility: "hidden"},
				_favIcon: {type: "sap.ui.core.Icon", multiple: false, visibility: "hidden"},
				_flagIcon: {type: "sap.ui.core.Icon", multiple: false, visibility: "hidden"},
				_overflowActionSheet: {type: "sap.m.ActionSheet", multiple: false, visibility: "hidden"},
				_changesIconCont: {type: "sap.m.Button", multiple: false, visibility: "hidden"},
				_changesIcon: {type: "sap.m.Button", multiple: false, visibility: "hidden"},

				/**
				 *
				 * An instance of sap.uxap.AnchorBar to be embedded in the header
				 */
				navigationBar: {type: "sap.m.Bar", multiple: false},

				/**
				 *
				 * List of actions that will be displayed in the header.
				 * You can use ObjectPageHeaderActionButton controls to achieve a different visual representation of the action buttons in the action bar and the action sheet (overflow menu).
				 * You can use ObjectPageHeaderLayoutData to display a visual separator.
				 */
				actions: {type: "sap.ui.core.Control", multiple: true, singularName: "action"}
			},
			events: {

				/**
				 * The event is fired when the objectPage header title selector (down-arrow) is pressed
				 */
				titleSelectorPress: {
					parameters: {

						/**
						 * DOM reference of the title item's icon to be used for positioning.
						 */
						domRef: {type: "string"}
					}
				},

				/**
				 * The event is fired when the Locked button is pressed
				 */
				markLockedPress: {
					parameters: {

						/**
						 * DOM reference of the lock item's icon to be used for positioning.
						 */
						domRef: {type: "string"}
					}
				},

				/**
				 * The event is fired when the unsaved changes button is pressed
				 */
				markChangesPress: {
					parameters: {

						/**
						 * DOM reference of the changed item's icon to be used for positioning.
						 * @since 1.34.0
						 */
						domRef: {type: "string"}
					}
				}
			}
		}
	});

	ObjectPageHeader.prototype._iAvailablePercentageForActions = 0.3;

	ObjectPageHeader.prototype.init = function () {
		if (!this.oLibraryResourceBundle) {
			this.oLibraryResourceBundle = sap.ui.getCore().getLibraryResourceBundle("sap.m"); // get resource translation bundle
		}
		if (!this.oLibraryResourceBundleOP) {
			this.oLibraryResourceBundleOP = library.i18nModel.getResourceBundle(); // get resource translation bundle
		}

		this._iREMSize = parseInt(jQuery("body").css("font-size"), 10);
		this._iOffset = parseInt(0.25 * this._iREMSize, 10);
		this._iScrollBarWidth = jQuery.position.scrollbarWidth();

		// Overflow button
		this._oOverflowActionSheet = this._getInternalAggregation("_overflowActionSheet");
		this._oOverflowButton = this._getInternalAggregation("_overflowButton").attachPress(this._handleOverflowButtonPress, this);
		this._oExpandButton = this._getInternalAggregation("_expandButton");
		this._oActionSheetButtonMap = {};
		this._oFlagIcon = this._getInternalAggregation("_flagIcon");
		this._oFavIcon = this._getInternalAggregation("_favIcon");
		this._oTitleArrowIcon = this._getInternalAggregation("_titleArrowIcon").attachPress(this._handleArrowPress, this);
		this._oTitleArrowIconCont = this._getInternalAggregation("_titleArrowIconCont").attachPress(this._handleArrowPress, this);
		this._oLockIcon = this._getInternalAggregation("_lockIcon").attachPress(this._handleLockPress, this);
		this._oLockIconCont = this._getInternalAggregation("_lockIconCont").attachPress(this._handleLockPress, this);
		this._oChangesIcon = this._getInternalAggregation("_changesIcon").attachPress(this._handleChangesPress, this);
		this._oChangesIconCont = this._getInternalAggregation("_changesIconCont").attachPress(this._handleChangesPress, this);
	};

	ObjectPageHeader.prototype._handleOverflowButtonPress = function (oEvent) {
		this._oOverflowActionSheet.openBy(this._oOverflowButton);
	};

	ObjectPageHeader.prototype._handleArrowPress = function (oEvent) {
		this.fireTitleSelectorPress({
			domRef: oEvent.getSource().getDomRef()
		});
	};

	ObjectPageHeader.prototype._handleLockPress = function (oEvent) {
		this.fireMarkLockedPress({
			domRef: oEvent.getSource().getDomRef()
		});
	};

	ObjectPageHeader.prototype._handleChangesPress = function (oEvent) {
		this.fireMarkChangesPress({
			domRef: oEvent.getSource().getDomRef()
		});
	};

	ObjectPageHeader._internalAggregationFactory = {
		"_objectImage": function (oParent) {
			var oObjectImage,
				sObjectImageURI = oParent.getObjectImageURI();

			if (sObjectImageURI.indexOf("sap-icon://") == 0) {
				oObjectImage = new Icon();
			} else {
				oObjectImage = new Image({
					densityAware: oParent.getObjectImageDensityAware(),
					alt: oParent.getObjectImageAlt(),
					decorative: false
				});
			}

			oObjectImage.setSrc(sObjectImageURI);
			oObjectImage.addStyleClass("sapUxAPObjectPageHeaderObjectImage");
			if (oParent.getObjectImageAlt()) {
				oObjectImage.setTooltip(oParent.getObjectImageAlt());
			}
			return oObjectImage;
		},
		"_overflowActionSheet": function () {
			return new ActionSheet({placement: sap.m.PlacementType.Bottom});
		},
		"_lockIconCont": function (oParent) {
			return this._getButton(oParent, "sap-icon://locked", "lock-cont", oParent.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));
		},
		"_breadCrumbs": function (oParent) {
			return new BreadCrumbs({
				links: oParent.getAggregation("breadCrumbLinks"),
				currentLocation: new Text({
					text: oParent.getProperty("objectTitle")
				}),
				showCurrentLocation: false
			});
		},
		"_lockIcon": function (oParent) {
			return this._getButton(oParent, "sap-icon://locked", "lock");
		},
		"_titleArrowIconCont": function (oParent) {
			return this._getButton(oParent, "sap-icon://arrow-down", "titleArrow-cont", oParent.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));
		},
		"_titleArrowIcon": function (oParent) {
			return this._getButton(oParent, "sap-icon://arrow-down", "titleArrow", oParent.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));
		},
		"_favIcon": function (oParent) {
			return this._getIcon(oParent, "favorite", oParent.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));
		},
		"_flagIcon": function (oParent) {
			return this._getIcon(oParent, "flag", oParent.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));
		},
		"_overflowButton": function (oParent) {
			return this._getButton(oParent, "sap-icon://overflow", "overflow");
		},
		"_expandButton": function (oParent) {
			return this._getButton(oParent, "sap-icon://slim-arrow-down", "expand", oParent.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));
		},
		"_changesIconCont": function (oParent) {
			return this._getButton(oParent, "sap-icon://request", "changes-cont", oParent.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));
		},
		"_changesIcon": function (oParent) {
			return this._getButton(oParent, "sap-icon://request", "changes", oParent.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));
		},
		_getIcon: function (oParent, sIcon, sTooltip) {
			return IconPool.createControlByURI({
				id: this._getParentAugmentedId(oParent, sIcon),
				tooltip: sTooltip,
				src: IconPool.getIconURI(sIcon),
				visible: false
			});
		},
		_getButton: function (oParent, sIcon, sChildSignature, sTooltip) {
			return new Button({
				id: this._getParentAugmentedId(oParent, sChildSignature),
				tooltip: sTooltip,
				icon: sIcon,
				type: sap.m.ButtonType.Transparent
			});
		},
		_getParentAugmentedId: function (oParent, sChildSignature) {
			return oParent.getId() + "-" + sChildSignature;
		}
	};


	ObjectPageHeader.prototype._getInternalAggregation = function (sAggregationName) {
		if (!this.getAggregation(sAggregationName)) {
			this.setAggregation(sAggregationName, ObjectPageHeader._internalAggregationFactory[sAggregationName](this));
		}
		return this.getAggregation(sAggregationName);
	};

	ObjectPageHeader.prototype._applyActionProperty = function (sPropertyName, aArguments) {
		var newValue = aArguments[0];

		if (this.getProperty(sPropertyName) !== newValue) {
			aArguments.unshift(sPropertyName);
			this.setProperty.apply(this, aArguments);
			this._notifyParentOfChanges();
		}

		return this;
	};

	ObjectPageHeader.prototype._applyObjectImageProperty = function (sPropertyName, aArguments) {
		var newValue = aArguments[0];

		if (this.getProperty(sPropertyName) !== newValue) {
			aArguments.unshift(sPropertyName);
			this.setProperty.apply(this, aArguments);
			this._destroyObjectImage();
			this._notifyParentOfChanges();
		}

		return this;
	};

	ObjectPageHeader.prototype._proxyMethodToBreadCrumbControl = function (sFuncName, aArguments) {
		var oBreadCrumbs = this._getInternalAggregation("_breadCrumbs");
		return oBreadCrumbs[sFuncName].apply(oBreadCrumbs, aArguments);
	};

	ObjectPageHeader.prototype.setHeaderDesign = function (sHeaderDesign) {
		this.setProperty("headerDesign", sHeaderDesign);
		if (this.getParent()) {
			this.getParent().invalidate(); // Force rerendering of ObjectPageLayout if the design change
		}
		return this;
	};

	ObjectPageHeader.prototype._shiftHeaderTitle = function () {
		var oParent = this.getParent(),
			iHeaderOffset = 0,
			sStyleAttribute = sap.ui.getCore().getConfiguration().getRTL() ? "left" : "right",
			$actions = this.$().find(".sapUxAPObjectPageHeaderIdentifierActions"),
			bHasVerticalScroll = true,
			iActionsOffset = this._iOffset;

		if (typeof oParent._hasVerticalScrollBar === "function") {
			bHasVerticalScroll = oParent._hasVerticalScrollBar();
		}

		if (sap.ui.Device.system.desktop) {
			iHeaderOffset = this._iScrollBarWidth;
			if (!bHasVerticalScroll) {
				iHeaderOffset = 0;
				iActionsOffset += this._iScrollBarWidth;
			}
		}

		$actions.css(sStyleAttribute, iActionsOffset + "px");

		if (typeof oParent._shiftHeader === "function"){
			oParent._shiftHeader(sStyleAttribute, iHeaderOffset + "px");
		}
	};

	/**
	 * get current title and if it is different from the new one rerender the HeaderContent
	 * @param {string} sTitle title string
	 * @return {*} this
	 */
	ObjectPageHeader.prototype.setObjectTitle = function (sTitle) {
		var oBreadcrumbs = this._getInternalAggregation("_breadCrumbs");
		if (oBreadcrumbs) {
			oBreadcrumbs.getCurrentLocation().setText(sTitle);
		}

		return this._applyActionProperty("objectTitle", Array.prototype.slice.call(arguments));
	};

	var aPropertiesToOverride = ["objectSubtitle", "showTitleSelector", "markLocked", "markFavorite", "markFlagged",
			"showMarkers", "showPlaceholder", "markChanges"],
		aObjectImageProperties = ["objectImageURI", "objectImageAlt", "objectImageDensityAware", "objectImageShape"];

	var fnGenerateSetter = function (sPropertyName) {
		var sConvertedSetterName = "set" + sPropertyName.charAt(0).toUpperCase() + sPropertyName.slice(1);

		ObjectPageHeader.prototype[sConvertedSetterName] = function () {
			var aArgumentsPassedToTheProperty = Array.prototype.slice.call(arguments);
			this._applyActionProperty.call(this, sPropertyName, aArgumentsPassedToTheProperty);
		};
	};

	var fnGenerateSetterForObjectImageProperties = function (sPropertyName) {
		var sConvertedSetterName = "set" + sPropertyName.charAt(0).toUpperCase() + sPropertyName.slice(1);

		ObjectPageHeader.prototype[sConvertedSetterName] = function () {
			var aArgumentsPassedToTheProperty = Array.prototype.slice.call(arguments);
			this._applyObjectImageProperty.call(this, sPropertyName, aArgumentsPassedToTheProperty);
		};
	};

	aPropertiesToOverride.forEach(fnGenerateSetter);
	aObjectImageProperties.forEach(fnGenerateSetterForObjectImageProperties);

	ObjectPageHeader.prototype.getBreadCrumbsLinks = function () {
		return this._getInternalAggregation("_breadCrumbs").getLinks();
	};

	ObjectPageHeader.prototype.addBreadCrumbLink = function () {
		return this._proxyMethodToBreadCrumbControl("addLink", arguments);
	};

	ObjectPageHeader.prototype.indexOfBreadCrumbLink = function () {
		return this._proxyMethodToBreadCrumbControl("indexOfLink", arguments);
	};

	ObjectPageHeader.prototype.insertBreadCrumbLink = function () {
		return this._proxyMethodToBreadCrumbControl("insertLink", arguments);
	};

	ObjectPageHeader.prototype.removeBreadCrumbLink = function () {
		return this._proxyMethodToBreadCrumbControl("removeLink", arguments);
	};

	ObjectPageHeader.prototype.removeAllBreadCrumbsLinks = function () {
		return this._proxyMethodToBreadCrumbControl("removeAllLinks", arguments);
	};

	ObjectPageHeader.prototype.destroyBreadCrumbsLinks = function () {
		return this._proxyMethodToBreadCrumbControl("destroyLinks", arguments);
	};

	ObjectPageHeader.prototype._destroyObjectImage = function () {
		var sObjectImage = "_objectImage",
			oObjectImage = this.getAggregation(sObjectImage);

		if (oObjectImage) {
			oObjectImage.destroy();
			this.setAggregation(sObjectImage, null);
		}
	};

	ObjectPageHeader.prototype.onBeforeRendering = function () {
		if (this.getShowPlaceholder()) {
			this._oPlaceholder = IconPool.createControlByURI({
				src: IconPool.getIconURI("picture"),
				visible: true
			});
		}

		var aActions = this.getActions() || [];
		this._oOverflowActionSheet.removeAllButtons();
		this._oActionSheetButtonMap = {};

		//display overflow if there are more than 1 item or only 1 item and it is showing its text
		if (aActions.length > 1 || this._hasOneButtonShowText(aActions)) {
			//create responsive equivalents of the provided controls
			jQuery.each(aActions, jQuery.proxy(function (iIndex, oAction) {
				// Force the design of the button to transparent
				if (oAction instanceof Button && oAction.getVisible()) {
					if (oAction instanceof Button && (oAction.getType() === "Default" || oAction.getType() === "Unstyled")) {
						oAction.setProperty("type", sap.m.ButtonType.Transparent, false);
					}

					var oActionSheetButton = this._createActionSheetButton(oAction);

					this._oActionSheetButtonMap[oAction.getId()] = oActionSheetButton; //store the originalId/reference for later use (adaptLayout)

					this._oOverflowActionSheet.addButton(oActionSheetButton);
				}
			}, this));
		}
		this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());
		this._oFavIcon.setVisible(this.getMarkFavorite());
		this._oFlagIcon.setVisible(this.getMarkFlagged());
		this._attachDetachActionButtonsHandler(false);
	};

	/**
	 * "clone" the button provided by the app developer in order to create an equivalent for the actionsheet (displayed in overflowing scenarios)
	 * @param {*} oButton the button to copy
	 * @returns {sap.m.Button} the copied button
	 * @private
	 */
	ObjectPageHeader.prototype._createActionSheetButton = function (oButton) {

		//copy binding if present
		var oCopy = new Button({
			press: jQuery.proxy(this._onSeeMoreContentSelect, this),
			enabled: oButton.getEnabled(),
			customData: new CustomData({
				key: "originalId",
				value: oButton.getId()
			})
		});

		//carry property & binding on text
		var oTextBinding = oButton.getBindingInfo("text"),
			oIconBinding = oButton.getBindingInfo("icon"),
			sModelName;

		if (oTextBinding && oTextBinding.parts && oTextBinding.parts.length > 0) {
			sModelName = oTextBinding.parts[0].model;

			//copy binding information
			oCopy.bindProperty("text", {
				path: oTextBinding.parts[0].path,
				model: sModelName,
				formatter: oTextBinding.formatter
			});

			//handle relative binding scenarios
			oCopy.setBindingContext(oButton.getBindingContext(sModelName), sModelName);
			oCopy.setModel(oButton.getModel(sModelName), sModelName);
		} else {
			oCopy.setText(oButton.getText());
		}

		//carry property & binding on icon
		if (oIconBinding && oIconBinding.parts && oIconBinding.parts.length > 0) {
			sModelName = oIconBinding.parts[0].model;

			//copy binding information
			oCopy.bindProperty("icon", {
				path: oIconBinding.parts[0].path,
				model: sModelName,
				formatter: oIconBinding.formatter
			});

			//handle relative binding scenarios
			oCopy.setBindingContext(oButton.getBindingContext(sModelName), sModelName);
			oCopy.setModel(oButton.getModel(sModelName), sModelName);
		} else {
			oCopy.setIcon(oButton.getIcon());
		}

		return oCopy;
	};

	ObjectPageHeader.prototype.onAfterRendering = function () {

		this._adaptLayout();

		if (this.getShowPlaceholder()) {
			jQuery(".sapUxAPObjectPageHeaderObjectImage").off("error").error(function () {
				jQuery(this).hide();
				jQuery(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");
			});
		} else {
			jQuery(".sapUxAPObjectPageHeaderObjectImage").off("error").error(function () {
				jQuery(this).addClass("sapMNoImg");
			});
		}

		if (!this._iResizeId) {
			this._iResizeId = ResizeHandler.register(this, this._adaptLayout.bind(this));
		}

		this._attachDetachActionButtonsHandler(true);
	};

	ObjectPageHeader.prototype._attachDetachActionButtonsHandler = function (bAttach) {
		var aActions = this.getActions() || [];
		if (aActions.length < 1) {
			return;
		}
		aActions.forEach(function (oAction) {
			if (oAction instanceof ObjectPageHeaderActionButton) {
				if (bAttach) {
					oAction.attachEvent("_change", this._adaptLayout, this);
				} else {
					oAction.detachEvent("_change", this._adaptLayout, this);
				}
			}
		}, this);
	};

	ObjectPageHeader.prototype._onSeeMoreContentSelect = function (oEvent) {
		var oPressedButton = oEvent.getSource(),
			oOriginalControl = sap.ui.getCore().byId(oPressedButton.data("originalId"));

		//forward press event
		if (oOriginalControl.firePress) {
			//provide parameters in case the handlers wants to know where was the event fired from
			oOriginalControl.firePress({
				overflowButtonId: this._oOverflowButton.getId()
			});
		}
		this._oOverflowActionSheet.close();
	};

	ObjectPageHeader._actionImportanceMap = {
			"Low": 3,
			"Medium": 2,
			"High": 1
	};

	/**
	 * Actions custom sorter function
	 * @private
	 */
	ObjectPageHeader._sortActionsByImportance = function (oActionA, oActionB) {
		var sImportanceA = (oActionA instanceof ObjectPageHeaderActionButton) ? oActionA.getImportance() : sap.uxap.Importance.High,
			sImportanceB = (oActionB instanceof ObjectPageHeaderActionButton) ? oActionB.getImportance() : sap.uxap.Importance.High,
			iImportanceDifference = ObjectPageHeader._actionImportanceMap[sImportanceA] - ObjectPageHeader._actionImportanceMap[sImportanceB];

		if (iImportanceDifference === 0) {
			return oActionA.position - oActionB.position;
		}

		return iImportanceDifference;
	};

	ObjectPageHeader.prototype._hasOneButtonShowText = function (aActions) {
		var bOneButtonShowingText = false;

		if (aActions.length !== 1) {
			return bOneButtonShowingText;
		}

		if (aActions[0] instanceof ObjectPageHeaderActionButton) {
			bOneButtonShowingText = (!aActions[0].getHideText() && aActions[0].getText() != "" );
		} else if (aActions[0] instanceof Button) {
			bOneButtonShowingText = (aActions[0].getText() != "" );
		}

		return bOneButtonShowingText;
	};

	/*************************************************************************************
	 * Adapting ObjectPage image, title/subtitle container and actions container
	 ************************************************************************************/

	/**
	 * Adapt title/subtitle container and action buttons and overflow button
	 * @private
	 */
	ObjectPageHeader.prototype._adaptLayout = function () {
		var iIdentifierContWidth = this.$("identifierLine").width(),
			iActionsWidth = this._getActionsWidth(), // the width off all actions without hidden one
			iActionsContProportion = iActionsWidth / iIdentifierContWidth, // the percentage(proportion) that action buttons take from the available space
			iAvailableSpaceForActions = this._iAvailablePercentageForActions * iIdentifierContWidth;

		if (iActionsContProportion > this._iAvailablePercentageForActions) {
			this._adaptActions(iAvailableSpaceForActions);
		} else {
			this._oOverflowButton.$().hide();
		}

		this.$("actions").find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton").css("visibility", "visible");
		this._adaptObjectPageHeaderIndentifierLine();
	};

	/**
	 * Adapt title/subtitle container and action buttons
	 * @private
	 */
	ObjectPageHeader.prototype._adaptObjectPageHeaderIndentifierLine = function () {
		var iIdentifierContWidth = this.$("identifierLine").width(),
			$subtitle = this.$("subtitle"),
			iSubtitleBottom,
			iTitleBottom,
			iActionsAndImageWidth = this.$("actions").width() + this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer").width(),
			iPixelTolerance = 3; // the tolerance of pixels from which we can tell that the title and subtitle are on the same row

		if ($subtitle.length) {
			if ($subtitle.hasClass("sapOPHSubtitleBlock")) {
				$subtitle.removeClass("sapOPHSubtitleBlock");
			}

			iSubtitleBottom = $subtitle.outerHeight() + $subtitle.position().top;
			iTitleBottom = this.$("innerTitle").outerHeight() + this.$("innerTitle").position().top;
			// check if subtitle is below the title and add it a display block class
			if (Math.abs(iSubtitleBottom - iTitleBottom) > iPixelTolerance) {
				$subtitle.addClass("sapOPHSubtitleBlock");
			}
		}

		this.$("identifierLineContainer").width((0.95 - (iActionsAndImageWidth / iIdentifierContWidth)) * 100 + "%");
	};

	/**
	 * Show or hide action buttons depending on how much space is available
	 * @private
	 */
	ObjectPageHeader.prototype._adaptActions = function (iAvailableSpaceForActions) {
		var bMobileScenario = jQuery("html").hasClass("sapUiMedia-Std-Phone") || Device.system.phone,
			iVisibleActionsWidth = this._oOverflowButton.$().show().width(),
			aActions = this.getActions(),
			iActionsLength = aActions.length,
			oActionSheetButton;

		for (var i = 0; i < iActionsLength; i++) {
			aActions[i].position = i;
		}
		aActions.sort(ObjectPageHeader._sortActionsByImportance);

		aActions.forEach(function (oAction) {
			oActionSheetButton = this._oActionSheetButtonMap[oAction.getId()];

			//separators and non sap.m.Button or not visible buttons have no equivalent in the overflow
			if (oActionSheetButton) {
				iVisibleActionsWidth += oAction.$().width();

				if (iAvailableSpaceForActions > iVisibleActionsWidth && !bMobileScenario) {
					oActionSheetButton.setVisible(false);
				} else {
					this._setActionButtonVisibility(oAction, false);
				}
			}
		}, this);
	};

	/**
	 * Set visibility of action button and the button in action sheet
	 * @private
	 */
	ObjectPageHeader.prototype._setActionButtonVisibility = function (oAction, bVisible) {
		var oActionSheetButton = this._oActionSheetButtonMap[oAction.getId()];

		//separators and non sap.m.Button or not visible buttons have no equivalent in the overflow
		if (oActionSheetButton) {
			if (bVisible) {
				oAction.$().show();
			} else {
				oAction.$().hide();
			}
			oActionSheetButton.setVisible(!bVisible);
		}
	};

	/**
	 * The sum of widths(+ margins) of all action buttons
	 * @private
	 */
	ObjectPageHeader.prototype._getActionsWidth = function () {
		var iWidthSum = 0;

		this.getActions().forEach(function (oAction) {
			if (oAction instanceof Button) {
				oAction.$().show();
				oAction.$().css("visibility", "hidden");

				iWidthSum += oAction.$().outerWidth(true);
			}
		});

		return iWidthSum;
	};

	/*************************************************************************************/

	/**
	 * rerender the title in the ContentHeader if something in it is changed
	 * @private
	 */
	ObjectPageHeader.prototype._notifyParentOfChanges = function () {
		if (this.getParent() && typeof this.getParent()._headerTitleChangeHandler === "function") {
			this.getParent()._headerTitleChangeHandler();
		}
	};

	/**
	 * check if the ActionBar has padding on top, if not in case of rerendering of the control it has to be removed
	 * @returns {boolean}
	 * @private
	 */
	ObjectPageHeader.prototype._getActionsPaddingStatus = function () {
		return this.$("actions").hasClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding");
	};

	ObjectPageHeader.prototype._setActionsPaddingStatus = function (bShow) {
		return this.$("actions").toggleClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding", bShow);
	};

	ObjectPageHeader.prototype.exit = function () {
		jQuery(".sapUxAPObjectPageHeaderObjectImage").off("error");
		if (this._iResizeId) {
			ResizeHandler.deregister(this._iResizeId);
		}
	};

	return ObjectPageHeader;
});

}; // end of sap/uxap/ObjectPageHeader.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageLayoutABHelper') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.ObjectPageLayoutABHelper'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.Metadata'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.CustomData'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageLayoutABHelper",[
	"jquery.sap.global",
	"sap/ui/base/Metadata",
	"sap/ui/core/CustomData",
	"./AnchorBar",
	"sap/m/Button",
	"sap/ui/core/IconPool"
], function (jQuery, Metadata, CustomData, AnchorBar, Button, IconPool) {
	"use strict";

	var ABHelper = Metadata.createClass("sap.uxap._helpers.AB", {
		/**
		 * @private
		 * @param {sap.uxap.ObjectPageLayout} oObjectPageLayout Object Page layout instance
		 */
		constructor: function (oObjectPageLayout) {
			this._oObjectPageLayout = oObjectPageLayout;
		}
	});

	ABHelper.prototype.getObjectPageLayout = function () {
		return this._oObjectPageLayout;
	};

	/**
	 * Lazy loads the hidden Aggregation "_anchorBar"
	 * @returns {sap.uxap.AnchorBar} AnchorBar
	 * @private
	 */
	ABHelper.prototype._getAnchorBar = function () {
		var oAnchorBar = this.getObjectPageLayout().getAggregation("_anchorBar");

		if (!oAnchorBar) {

			oAnchorBar = new AnchorBar({
				showPopover: this.getObjectPageLayout().getShowAnchorBarPopover()
			});

			this.getObjectPageLayout().setAggregation("_anchorBar", oAnchorBar);
		}

		return oAnchorBar;
	};

	/**
	 * build the anchorBar and all the anchorBar buttons
	 * @private
	 */
	ABHelper.prototype._buildAnchorBar = function () {
		var aSections = this.getObjectPageLayout().getSections() || [],
			oAnchorBar = this._getAnchorBar();

		//tablet & desktop mechanism
		if (oAnchorBar && this.getObjectPageLayout().getShowAnchorBar()) {

			oAnchorBar.removeAllContent();

			//first level
			aSections.forEach(function (oSection) {

				if (!oSection.getVisible() || !oSection._getInternalVisible()) {
					return true;
				}

				var oButtonClone,
					aSubSections = oSection.getSubSections() || [];

				oButtonClone = this._buildAnchorBarButton(oSection, true);

				if (oButtonClone) {
					oAnchorBar.addContent(oButtonClone);

					//second Level
					aSubSections.forEach(function (oSubSection) {

						if (!oSubSection.getVisible() || !oSubSection._getInternalVisible()) {
							return;
						}

						var oButtonClone = this._buildAnchorBarButton(oSubSection, false);

						if (oButtonClone) {
							oAnchorBar.addContent(oButtonClone);
						}

					}, this);
				}

			}, this);
		}
	};

	/**
	 * build a sap.m.button equivalent to a section or sub section for insertion in the anchorBar
	 * also registers the section info for further dom position updates
	 * @param oSectionBase
	 * @param bIsSection
	 * @returns {null}
	 * @private
	 */
	ABHelper.prototype._buildAnchorBarButton = function (oSectionBase, bIsSection) {

		var oButtonClone = null,
			oObjectPageLayout = this.getObjectPageLayout(),
			oButton,
			oSectionBindingInfo,
			sModelName,
			aSubSections = oSectionBase.getAggregation("subSections");

		if (oSectionBase.getVisible() && oSectionBase._getInternalVisible()) {
			oButton = oSectionBase.getCustomAnchorBarButton();

			//by default we get create a button with the section title as text
			if (!oButton) {
				oButtonClone = new Button({
					ariaDescribedBy: oSectionBase
				});

				//has a ux rule been applied that we need to reflect here?
				if (oSectionBase._getInternalTitle() != "") {
					oButtonClone.setText(oSectionBase._getInternalTitle());
				} else {

					//is the section title bound to a model? in this case we need to apply the same binding
					oSectionBindingInfo = oSectionBase.getBindingInfo("title");
					if (oSectionBindingInfo && oSectionBindingInfo.parts && oSectionBindingInfo.parts.length > 0) {

						sModelName = oSectionBindingInfo.parts[0].model;

						//handle relative binding scenarios
						oButtonClone.setBindingContext(oSectionBase.getBindingContext(sModelName), sModelName);

						//copy binding information
						oButtonClone.bindProperty("text", {
							path: oSectionBindingInfo.parts[0].path,
							model: sModelName
						});
					} else { //otherwise just copy the plain text
						oButtonClone.setText(oSectionBase.getTitle());
					}
				}
			} else {
				oButtonClone = oButton.clone(); //keep original button parent control hierarchy
			}

			//update the section info
			oObjectPageLayout._oSectionInfo[oSectionBase.getId()].buttonId = oButtonClone.getId();

			//the anchorBar needs to know the sectionId for automatic horizontal scrolling
			oButtonClone.addCustomData(new CustomData({
				key: "sectionId",
				value: oSectionBase.getId()
			}));

			//the anchorBar needs to know whether the title is actually displayed or not (so the anchorBar is really reflecting the objactPage layout state)
			oButtonClone.addCustomData(new CustomData({
				key: "bTitleVisible",
				value: oSectionBase._getInternalTitleVisible()
			}));

			if (!bIsSection) {
				//the anchorBar needs to know that this is a second section because it will handle responsive scenarios
				oButtonClone.addCustomData(new CustomData({
					key: "secondLevel",
					value: true
				}));
			}

			if (aSubSections && aSubSections.length > 1) {
				// the anchor bar need to know if the button has submenu for accessibility rules
				oButtonClone.addCustomData(new CustomData({
					key: "bHasSubMenu",
					value: true
				}));

				if (oObjectPageLayout.getShowAnchorBarPopover()) {
					// Add arrow icon-down in order to indicate that on click will open popover
					oButtonClone.setIcon(IconPool.getIconURI("slim-arrow-down"));
					oButtonClone.setIconFirst(false);
				}
			}
		}

		return oButtonClone;
	};

	return ABHelper;

}, /* bExport= */ false);

}; // end of sap/uxap/ObjectPageLayoutABHelper.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageSection') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.ObjectPageSection.
jQuery.sap.declare('sap.uxap.ObjectPageSection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.InvisibleText'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageSection",[
	"jquery.sap.global",
	"sap/ui/core/InvisibleText",
	"./ObjectPageSectionBase",
	"sap/ui/Device",
	"sap/m/Button",
	"./library"
], function (jQuery, InvisibleText, ObjectPageSectionBase, Device, Button, library) {
	"use strict";

	/**
	 * Constructor for a new ObjectPageSection.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 *
	 * An ObjectPageSection is the top-level information container of an Object page. Its purpose is to aggregate Subsections.
	 * Disclaimer: This control is intended to be used only as part of the Object page layout
	 * @extends sap.uxap.ObjectPageSectionBase
	 *
	 * @constructor
	 * @public
	 * @alias sap.uxap.ObjectPageSection
	 * @since 1.26
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectPageSection = ObjectPageSectionBase.extend("sap.uxap.ObjectPageSection", /** @lends sap.uxap.ObjectPageSection.prototype */ {
		metadata: {

			library: "sap.uxap",
			properties: {

				/**
				 * Determines whether to display the Section title or not.
				 */
				showTitle: {type: "boolean", group: "Appearance", defaultValue: true},

				/**
				 * Determines whether the Section title is displayed in upper case.
				 */
				titleUppercase: {type: "boolean", group: "Appearance", defaultValue: true}
			},
			defaultAggregation: "subSections",
			aggregations: {

				/**
				 * The list of Subsections.
				 */
				subSections: {type: "sap.uxap.ObjectPageSubSection", multiple: true, singularName: "subSection"},

				/**
				 * Screen Reader ariaLabelledBy
				 */
				ariaLabelledBy: {type: "sap.ui.core.InvisibleText", multiple: false, visibility: "hidden"},
				_showHideAllButton: {type: "sap.m.Button", multiple: false, visibility: "hidden"},
				_showHideButton: {type: "sap.m.Button", multiple: false, visibility: "hidden"}
			},
			associations: {

				/**
				 * The most recently selected Subsection by the user.
				 */
				selectedSubSection: {type: "sap.uxap.ObjectPageSubSection", multiple: false}
			}
		}
	});

	ObjectPageSection.MEDIA_RANGE = Device.media.RANGESETS.SAP_STANDARD;

	ObjectPageSection.prototype._expandSection = function () {
		ObjectPageSectionBase.prototype._expandSection.call(this)
			._updateShowHideAllButton(!this._thereAreHiddenSubSections());
	};

	ObjectPageSection.prototype.init = function () {
		ObjectPageSectionBase.prototype.init.call(this);
		this._sContainerSelector = ".sapUxAPObjectPageSectionContainer";
		Device.media.attachHandler(this._updateImportance, this, ObjectPageSection.MEDIA_RANGE);
	};

	ObjectPageSection.prototype.exit = function () {
		Device.media.detachHandler(this._updateImportance, this, ObjectPageSection.MEDIA_RANGE);
	};

	/**
	 * Handler for key up - handle
	 * @param oEvent - The event object
	 */

	ObjectPageSection.prototype.onkeyup = function (oEvent) {
		var eventTarget = sap.ui.getCore().byId(jQuery(oEvent.target).attr("id"));
		if (oEvent.keyCode === jQuery.sap.KeyCodes.TAB && eventTarget instanceof sap.uxap.ObjectPageSection && this._getObjectPageLayout()._isFirstSection(this)) {
			this._getObjectPageLayout().$("opwrapper").scrollTop(0);
		}
	};

	ObjectPageSection.prototype._updateImportance = function (oCurrentMedia) {
		var oObjectPage = this._getObjectPageLayout(),
			oMedia = oCurrentMedia || Device.media.getCurrentRange(ObjectPageSection.MEDIA_RANGE),
			bShowOnlyHighImportance = oObjectPage && oObjectPage.getShowOnlyHighImportance(),
			sImportanceLevelToHide = this._determineTheLowestLevelOfImportanceToShow(oMedia.name, bShowOnlyHighImportance);

		this.getSubSections().forEach(function (oSubSection) {
			oSubSection._applyImportanceRules(sImportanceLevelToHide);
		});

		this._applyImportanceRules(sImportanceLevelToHide);
		this._updateShowHideAllButton(false);

		if (oObjectPage) {
			oObjectPage._adjustLayout();
		}
	};

	ObjectPageSection.prototype._determineTheLowestLevelOfImportanceToShow = function (sMedia, bShowOnlyHighImportance) {
		if (bShowOnlyHighImportance || sMedia === "Phone") {
			return library.Importance.High;
		}
		if (sMedia === "Tablet") {
			return library.Importance.Medium;
		}

		return library.Importance.Low;
	};

	ObjectPageSection.prototype.connectToModels = function () {
		this.getSubSections().forEach(function (oSubSection) {
			oSubSection.connectToModels();
		});
	};

	ObjectPageSection.prototype.onBeforeRendering = function () {
		var sAriaLabeledBy = "ariaLabelledBy";

		if (!this.getAggregation(sAriaLabeledBy)) {
			this.setAggregation(sAriaLabeledBy, this._getAriaLabelledBy());
		}
	};

	ObjectPageSection.prototype.onAfterRendering = function () {
		this._updateImportance();
	};

	/**
	 * provide a default aria-labeled by text
	 * @private
	 * @returns {*} sap.ui.core.InvisibleText
	 */
	ObjectPageSection.prototype._getAriaLabelledBy = function () {
		return new InvisibleText({
			text: this._getInternalTitle() || this.getTitle()
		}).toStatic();
	};

	/**
	 * set subsections focus rules
	 * @private
	 * @returns {*} this
	 */
	ObjectPageSection.prototype._setSubSectionsFocusValues = function () {
		var aSubSections = this.getSubSections() || [],
			sLastSelectedSubSectionId = this.getSelectedSubSection(),
			bPreselectedSection;

		if (aSubSections.length === 0) {
			return this;
		}

		aSubSections.forEach(function (oSubsection) {
			if (sLastSelectedSubSectionId === oSubsection.sId) {
				oSubsection._setToFocusable(true);
				bPreselectedSection = true;
			} else {
				oSubsection._setToFocusable(false);
			}
		});

		if (!bPreselectedSection) {
			aSubSections[0]._setToFocusable(true);
		}

		return this;
	};

	ObjectPageSection.prototype._disableSubSectionsFocus = function () {
		var aSubSections = this.getSubSections() || [];

		aSubSections.forEach(function (oSubsection) {
			oSubsection._setToFocusable(false);
		});

		return this;
	};

	ObjectPageSection.prototype._thereAreHiddenSubSections = function () {
		return this.getSubSections().some(function (oSubSection) {
			return oSubSection._getIsHidden();
		});
	};

	ObjectPageSection.prototype._updateShowHideSubSections = function (bHide) {
		this.getSubSections().forEach(function (oSubSection) {
			if (bHide && oSubSection._shouldBeHidden()) {
				oSubSection._updateShowHideState(true);
			} else if (!bHide) {
				oSubSection._updateShowHideState(false);
			}
		});
	};

	ObjectPageSection.prototype._getShouldDisplayShowHideAllButton = function () {
		return this.getSubSections().some(function (oSubSection) {
			return oSubSection._shouldBeHidden();
		});
	};

	ObjectPageSection.prototype._showHideContentAllContent = function () {
		var bShouldShowSubSections = this._thereAreHiddenSubSections();

		if (this._getIsHidden() && bShouldShowSubSections) {
			this._updateShowHideState(false);
		}

		this._updateShowHideSubSections(!bShouldShowSubSections);
		this._updateShowHideAllButton(bShouldShowSubSections);
	};

	ObjectPageSection.prototype._updateShowHideState = function (bHide) {
		this._updateShowHideButton(bHide);
		this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());
		return ObjectPageSectionBase.prototype._updateShowHideState.call(this, bHide);
	};

	ObjectPageSection.prototype._updateShowHideAllButton = function (bHide) {
		this._getShowHideAllButton()
			.setVisible(this._getShouldDisplayShowHideAllButton())
			.setText(this._getShowHideAllButtonText(bHide));
	};

	ObjectPageSection.prototype._getShowHideAllButton = function () {
		if (!this.getAggregation("_showHideAllButton")) {
			this.setAggregation("_showHideAllButton", new Button({
				text: this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),
				press: this._showHideContentAllContent.bind(this),
				type: sap.m.ButtonType.Transparent
			}).addStyleClass("sapUxAPSectionShowHideButton"));
		}

		return this.getAggregation("_showHideAllButton");
	};

	ObjectPageSection.prototype._getShowHideButtonText = function (bHide) {
		return library.i18nModel.getResourceBundle().getText(bHide ? "HIDE" : "SHOW");
	};

	ObjectPageSection.prototype._getShowHideAllButtonText = function (bHide) {
		return library.i18nModel.getResourceBundle().getText(bHide ? "HIDE_ALL" : "SHOW_ALL");
	};

	ObjectPageSection.prototype._updateShowHideButton = function (bHide) {
		this._getShowHideButton()
			.setVisible(this._shouldBeHidden())
			.setText(this._getShowHideButtonText(!bHide));
	};

	ObjectPageSection.prototype._getShowHideButton = function () {
		if (!this.getAggregation("_showHideButton")) {
			this.setAggregation("_showHideButton", new Button({
				text: this._getShowHideButtonText(!this._getIsHidden()),
				press: this._showHideContent.bind(this),
				type: sap.m.ButtonType.Transparent
			}).addStyleClass("sapUxAPSectionShowHideButton"));
		}

		return this.getAggregation("_showHideButton");
	};

	return ObjectPageSection;
});

}; // end of sap/uxap/ObjectPageSection.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageSubSection') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.ObjectPageSubSection.
jQuery.sap.declare('sap.uxap.ObjectPageSubSection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.CustomData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.Grid'); // unlisted dependency retained
jQuery.sap.require('sap.uxap.ObjectPageSubSectionLayout'); // unlisted dependency retained
jQuery.sap.require('sap.uxap.ObjectPageSubSectionMode'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.GridData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageSubSection",[
	"sap/ui/core/CustomData",
	"sap/ui/layout/Grid",
	"./ObjectPageSectionBase",
	"./ObjectPageSubSectionLayout",
	"./ObjectPageSubSectionMode",
	"./BlockBase",
	"sap/ui/layout/GridData",
	"sap/ui/core/ResizeHandler",
	"sap/m/Button",
	"./library"
], function (CustomData, Grid, ObjectPageSectionBase, ObjectPageSubSectionLayout,
			 ObjectPageSubSectionMode, BlockBase, GridData, ResizeHandler, Button, library) {
	"use strict";

	/**
	 * Constructor for a new ObjectPageSubSection.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 *
	 * An ObjectPageSubSection is the second-level information container of an Object page and may only be used within an Object page section.
	 * Subsections may display primary information in the so called blocks aggregation (always visible)
	 * and not-so-important information in the moreBlocks aggregation, whose content is initially hidden, but may be accessed via a See more (...) button.
	 * Disclaimer: This control is intended to be used only as part of the Object page layout
	 * @extends sap.uxap.ObjectPageSectionBase
	 *
	 * @constructor
	 * @public
	 * @alias sap.uxap.ObjectPageSubSection
	 * @since 1.26
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectPageSubSection = ObjectPageSectionBase.extend("sap.uxap.ObjectPageSubSection", /** @lends sap.uxap.ObjectPageSubSection.prototype */ {
		metadata: {

			library: "sap.uxap",
			properties: {

				/**
				 * A mode property that will be passed to the controls in the blocks and moreBlocks aggregations. Only relevant if these aggregations use Object page blocks.
				 */
				mode: {
					type: "sap.uxap.ObjectPageSubSectionMode",
					group: "Appearance",
					defaultValue: ObjectPageSubSectionMode.Collapsed
				},

				/**
				 * Determines whether the Subsection title is displayed in upper case.
				 */
				titleUppercase: {type: "boolean", group: "Appearance", defaultValue: false}
			},
			defaultAggregation: "blocks",
			aggregations: {

				/**
				 * Internal grid aggregation
				 */
				_grid: {type: "sap.ui.core.Control", multiple: false, visibility: "hidden"},

				/**
				 * Controls to be displayed in the subsection
				 */
				blocks: {type: "sap.ui.core.Control", multiple: true, singularName: "block"},

				/**
				 * Additional controls to display when the Show more / See all / (...) button is pressed
				 */
				moreBlocks: {type: "sap.ui.core.Control", multiple: true, singularName: "moreBlock"},

				/**
				 * Actions available for this Subsection
				 */
				actions: {type: "sap.ui.core.Control", multiple: true, singularName: "action"}
			}
		}
	});


	/**
	 * @private
	 */
	ObjectPageSubSection.prototype.init = function () {
		ObjectPageSectionBase.prototype.init.call(this);

		//proxy public aggregations
		this._bRenderedFirstTime = false;
		this._aAggregationProxy = {blocks: [], moreBlocks: []};

		//dom reference
		this._$spacer = [];
		this._sContainerSelector = ".sapUxAPBlockContainer";

		//switch logic for the default mode
		this._switchSubSectionMode(this.getMode());
	};

	ObjectPageSubSection.prototype._expandSection = function () {
		ObjectPageSectionBase.prototype._expandSection.call(this);
		var oParent = this.getParent();
		oParent && typeof oParent._expandSection === "function" && oParent._expandSection();
		return this;
	};

	ObjectPageSubSection.prototype._getGrid = function () {
		if (!this.getAggregation("_grid")) {
			this.setAggregation("_grid", new Grid({
				id: this.getId() + "-innerGrid",
				defaultSpan: "XL12 L12 M12 S12",
				hSpacing: 0,
				vSpacing: 1,
				width: "100%",
				containerQuery: true
			}));
		}

		return this.getAggregation("_grid");
	};

	ObjectPageSubSection.prototype.connectToModels = function () {
		var aBlocks = this.getBlocks() || [],
			aMoreBlocks = this.getMoreBlocks() || [],
			sCurrentMode = this.getMode();

		aBlocks.forEach(function (oBlock) {
			if (oBlock instanceof BlockBase) {
				if (!oBlock.getMode()) {
					oBlock.setMode(sCurrentMode);
				}
				oBlock.connectToModels();
			}
		});

		if (aMoreBlocks.length > 0 && sCurrentMode === ObjectPageSubSectionMode.Expanded) {
			aMoreBlocks.forEach(function (oMoreBlock) {
				if (oMoreBlock instanceof BlockBase) {
					if (!oMoreBlock.getMode()) {
						oMoreBlock.setMode(sCurrentMode);
					}
					oMoreBlock.connectToModels();
				}
			});
		}
	};

	ObjectPageSubSection.prototype.exit = function () {
		if (this._oSeeMoreButton) {
			this._oSeeMoreButton.destroy();
			this._oSeeMoreButton = null;
		}

		if (this._iResizeId) {
			ResizeHandler.deregister(this._iResizeId);
		}

		if (ObjectPageSectionBase.prototype.exit) {
			ObjectPageSectionBase.prototype.exit.call(this);
		}
	};

	ObjectPageSubSection.prototype.onAfterRendering = function () {
		var oObjectPageLayout = this._getObjectPageLayout();

		if (ObjectPageSectionBase.prototype.onAfterRendering) {
			ObjectPageSectionBase.prototype.onAfterRendering.call(this);
		}

		if (!oObjectPageLayout) {
			return;
		}

		if (oObjectPageLayout.getSubSectionLayout() === ObjectPageSubSectionLayout.TitleOnLeft) {
			this._afterRenderingTitleOnLeftLayout();
		}

		this._$spacer = jQuery.sap.byId(oObjectPageLayout.getId() + "-spacer");
	};

	ObjectPageSubSection.prototype.onBeforeRendering = function () {
		if (ObjectPageSectionBase.prototype.onBeforeRendering) {
			ObjectPageSectionBase.prototype.onBeforeRendering.call(this);
		}

		this._setAggregationProxy();
		this._getGrid().removeAllContent();
		this._applyLayout(this._getObjectPageLayout());
		this.refreshSeeMoreVisibility();
	};

	ObjectPageSubSection.prototype._applyLayout = function (oLayoutProvider) {
		var aVisibleBlocks,
			oGrid = this._getGrid(),
			sCurrentMode = this.getMode(),
			sLayout = oLayoutProvider.getSubSectionLayout(),
			oLayoutConfig = this._calculateLayoutConfiguration(sLayout, oLayoutProvider),
			aBlocks = this.getBlocks(),
			aAllBlocks = aBlocks.concat(this.getMoreBlocks());

		this._oLayoutConfig = oLayoutConfig;
		this._resetLayoutData(aAllBlocks);

		//also add the more blocks defined for being visible in expanded mode only
		if (sCurrentMode === ObjectPageSubSectionMode.Expanded) {
			aVisibleBlocks = aAllBlocks;
		} else {
			aVisibleBlocks = aBlocks;
		}

		this._calcBlockColumnLayout(aVisibleBlocks, this._oLayoutConfig);

		try {
			aVisibleBlocks.forEach(function (oBlock) {
				this._setBlockMode(oBlock, sCurrentMode);
				oGrid.addContent(oBlock);
			}, this);
		} catch (sError) {
			jQuery.sap.log.error("ObjectPageSubSection :: error while building layout " + sLayout + ": " + sError);
		}

		return this;
	};

	ObjectPageSubSection.prototype._calculateLayoutConfiguration = function (sLayout, oLayoutProvider) {
		var oLayoutConfig = {M: 2, L: 3, XL: 4},
			iLargeScreenColumns = oLayoutConfig.L,
			iExtraLargeScreenColumns = oLayoutConfig.XL,
			bTitleOnTheLeft = (sLayout === ObjectPageSubSectionLayout.TitleOnLeft),
			bUseTwoColumnsOnLargeScreen = oLayoutProvider.getUseTwoColumnsForLargeScreen();

		if (bTitleOnTheLeft) {
			iLargeScreenColumns -= 1;
			iExtraLargeScreenColumns -= 1;
		}

		if (bUseTwoColumnsOnLargeScreen) {
			iLargeScreenColumns -= 1;
		}

		oLayoutConfig.L = iLargeScreenColumns;
		oLayoutConfig.XL = iExtraLargeScreenColumns;

		return oLayoutConfig;
	};

	ObjectPageSubSection.prototype.refreshSeeMoreVisibility = function () {
		var bBlockHasMore = !!this.getMoreBlocks().length,
			oSeeMoreControl = this._getSeeMoreButton(),
			$seeMoreControl = oSeeMoreControl.$(),
			$this = this.$();

		if (!bBlockHasMore) {
			bBlockHasMore = this.getBlocks().some(function (oBlock) {
				//check if the block ask for the global see more the rule is
				//by default we don't display the see more
				//if one control is visible and ask for it then we display it
				if (oBlock instanceof BlockBase && oBlock.getVisible() && oBlock.getShowSubSectionMore()) {
					return true;
				}
			});
		}

		//if the subsection is already rendered, don't rerender it all for showing a more button
		if ($this.length) {
			$this.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore", bBlockHasMore);
		}

		this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore", bBlockHasMore);

		if ($seeMoreControl.length) {
			$seeMoreControl.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible", bBlockHasMore);
		}

		oSeeMoreControl.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible", bBlockHasMore);

		return bBlockHasMore;
	};

	ObjectPageSubSection.prototype.setMode = function (sMode) {
		if (this.getMode() !== sMode) {
			this._switchSubSectionMode(sMode);

			if (this._bRenderedFirstTime) {
				this.rerender();
			}
		}
		return this;
	};

	/*******************************************************************************
	 * Keyboard navigation
	 ******************************************************************************/

	/**
	 * Handler for key down - handle
	 * @param oEvent - The event object
	 */

	ObjectPageSubSection.prototype.onkeydown = function (oEvent) {
		// Filter F7 key down
		if (oEvent.keyCode === jQuery.sap.KeyCodes.F7) {
			oEvent.stopPropagation();
			var oTarget = sap.ui.getCore().byId(oEvent.target.id);

			//define if F7 is pressed from SubSection itself or active element inside SubSection
			if (oTarget instanceof ObjectPageSubSection) {
				this._handleSubSectionF7();
			} else {
				this._handleInteractiveElF7();
				this._oLastFocusedControlF7 = oTarget;
			}
		}
	};

	// It's used when F7 key is pressed and the focus is on interactive element
	ObjectPageSubSection.prototype._handleInteractiveElF7 = function () {
		//If there are more sub sections focus current subsection otherwise focus the parent section
		if (this.getParent().getSubSections().length > 1) {
			this.$().focus();
		} else {
			this.getParent().$().focus();
		}
	};

	//It's used when F7 key is pressed and the focus is on SubSection
	ObjectPageSubSection.prototype._handleSubSectionF7 = function (oEvent) {
		if (this._oLastFocusedControlF7) {
			this._oLastFocusedControlF7.$().focus();
		} else {
			this.$().firstFocusableDomRef().focus();
		}
	};

	/*************************************************************************************
	 * generic block layout calculation
	 ************************************************************************************/

	/**
	 * calculate the layout data to use for subsection blocks
	 * Aligned with PUX specifications as of Oct 14, 2014
	 */
	ObjectPageSubSection.prototype._calcBlockColumnLayout = function (aBlocks, oColumnConfig) {
		var iGridSize = 12,
			aVisibleBlocks,
			M, L, XL,
			aDisplaySizes;

		M = {
			iRemaining: oColumnConfig.M,
			iColumnConfig: oColumnConfig.M
		};

		L = {
			iRemaining: oColumnConfig.L,
			iColumnConfig: oColumnConfig.L
		};

		XL = {
			iRemaining: oColumnConfig.XL,
			iColumnConfig: oColumnConfig.XL
		};

		aDisplaySizes = [XL, L, M];

		//step 1: get only visible blocks into consideration
		aVisibleBlocks = aBlocks.filter(function (oBlock) {
			return oBlock.getVisible && oBlock.getVisible();
		});

		//step 2: set layout for each blocks based on their columnLayout configuration
		//As of Oct 14, 2014, the default behavior is:
		//on phone, blocks take always the full line
		//on tablet, desktop:
		//1 block on the line: takes 3/3 columns
		//2 blocks on the line: takes 1/3 columns then 2/3 columns
		//3 blocks on the line: takes 1/3 columns then 1/3 columns and last 1/3 columns

		aVisibleBlocks.forEach(function (oBlock, iIndex) {

			aDisplaySizes.forEach(function (oConfig) {
				oConfig.iCalculatedSize = this._calculateBlockSize(oBlock, oConfig.iRemaining,
					aVisibleBlocks, iIndex, oConfig.iColumnConfig);
			}, this);

			//set block layout based on resolution and break to a new line if necessary
			oBlock.setLayoutData(new GridData({
				spanS: iGridSize,
				spanM: M.iCalculatedSize * (iGridSize / M.iColumnConfig),
				spanL: L.iCalculatedSize * (iGridSize / L.iColumnConfig),
				spanXL: XL.iCalculatedSize * (iGridSize / XL.iColumnConfig),
				linebreakM: (iIndex > 0 && M.iRemaining === M.iColumnConfig),
				linebreakL: (iIndex > 0 && L.iRemaining === L.iColumnConfig),
				linebreakXL: (iIndex > 0 && XL.iRemaining === XL.iColumnConfig)
			}));

			aDisplaySizes.forEach(function (oConfig) {
				oConfig.iRemaining -= oConfig.iCalculatedSize;
				if (oConfig.iRemaining < 1) {
					oConfig.iRemaining = oConfig.iColumnConfig;
				}
			});

		}, this);

		return aVisibleBlocks;
	};

	ObjectPageSubSection.prototype._calculateBlockSize = function (oBlock, iRemaining, aVisibleBlocks, iCurrentIndex, iMax) {
		var iCalc, iForewordBlocksToCheck = iMax, indexOffset;

		if (!this._hasAutoLayout(oBlock)) {
			return Math.min(iMax, parseInt(oBlock.getColumnLayout(), 10));
		}

		for (indexOffset = 1; indexOffset <= iForewordBlocksToCheck; indexOffset++) {
			iCalc = this._calcLayout(aVisibleBlocks[iCurrentIndex + indexOffset]);
			if (iCalc < iRemaining) {
				iRemaining -= iCalc;
			} else {
				break;
			}
		}

		return iRemaining;
	};

	ObjectPageSubSection.prototype._calcLayout = function (oBlock) {
		var iLayoutCols = 1;

		if (!oBlock) {
			iLayoutCols = 0;
		} else if (oBlock instanceof BlockBase && oBlock.getColumnLayout() != "auto") {
			iLayoutCols = parseInt(oBlock.getColumnLayout(), 10);
		}

		return iLayoutCols;
	};

	ObjectPageSubSection.prototype._hasAutoLayout = function (oBlock) {
		return !(oBlock instanceof BlockBase) || oBlock.getColumnLayout() == "auto";
	};


	/*************************************************************************************
	 * TitleOnLeft layout
	 ************************************************************************************/

	/**
	 * on after rendering actions for the titleOnLeft Layout
	 * @private
	 */
	ObjectPageSubSection.prototype._afterRenderingTitleOnLeftLayout = function () {
		this._$standardHeader = jQuery.sap.byId(this.getId() + "-header");
		this._$grid = this._getGrid().$();

		if (!this._iResizeId) {
			this._iResizeId = ResizeHandler.register(this, this._titleOnLeftSynchronizeLayouts.bind(this));
		}

		this._titleOnLeftSynchronizeLayouts();
	};

	ObjectPageSubSection.prototype._titleOnLeftSynchronizeLayouts = function () {
		jQuery.sap.delayedCall(50 /* dom painting */, this, function () {

			var oRootNode = jQuery("html"),
				bUseTitleOnTheLeftLayout = oRootNode.hasClass("sapUiMedia-Std-Desktop")
					|| oRootNode.hasClass("sapUiMedia-Std-LargeDesktop");
			this._$standardHeader.toggleClass("titleOnLeftLayout", bUseTitleOnTheLeftLayout);
		});
	};


	/*************************************************************************************
	 *  blocks & moreBlocks aggregation proxy
	 *  getter and setters works with _aAggregationProxy instead of the blocks aggregation
	 ************************************************************************************/

	ObjectPageSubSection.prototype._setAggregationProxy = function () {
		if (this._bRenderedFirstTime) {
			return;
		}

		//empty real aggregations and feed internal ones at first rendering only
		jQuery.each(this._aAggregationProxy, jQuery.proxy(function (sAggregationName, aValue) {
			this._setAggregation(sAggregationName, this.removeAllAggregation(sAggregationName));
		}, this));

		this._bRenderedFirstTime = true;
	};

	ObjectPageSubSection.prototype.hasProxy = function (sAggregationName) {
		return this._bRenderedFirstTime && this._aAggregationProxy.hasOwnProperty(sAggregationName);
	};

	ObjectPageSubSection.prototype._getAggregation = function (sAggregationName) {
		return this._aAggregationProxy[sAggregationName];
	};

	ObjectPageSubSection.prototype._setAggregation = function (sAggregationName, aValue) {
		this._aAggregationProxy[sAggregationName] = aValue;
		this._notifyObjectPageLayout();
		this.invalidate();
		return this._aAggregationProxy[sAggregationName];
	};

	ObjectPageSubSection.prototype.addAggregation = function (sAggregationName, oObject) {
		var aAggregation;

		if (this.hasProxy(sAggregationName)) {
			aAggregation = this._getAggregation(sAggregationName);
			aAggregation.push(oObject);
			this._setAggregation(aAggregation);

			if (oObject instanceof BlockBase) {
				oObject.setParent(this); //let the block know of its parent subsection
			}

			return this;
		}

		return ObjectPageSectionBase.prototype.addAggregation.apply(this, arguments);
	};

	ObjectPageSubSection.prototype.insertAggregation = function (sAggregationName, oObject, iIndex) {
		if (this.hasProxy(sAggregationName)) {
			jQuery.sap.log.warning("ObjectPageSubSection :: used of insertAggregation for " + sAggregationName + " is not supported, will use addAggregation instead");
			return this.addAggregation(sAggregationName, oObject);
		}

		return ObjectPageSectionBase.prototype.insertAggregation.apply(this, arguments);
	};

	ObjectPageSubSection.prototype.removeAllAggregation = function (sAggregationName) {
		var aInternalAggregation, aItems;

		if (this.hasProxy(sAggregationName)) {
			aInternalAggregation = this._getAggregation(sAggregationName);
			aItems = aInternalAggregation.slice(0, aInternalAggregation.length - 1);
			this._setAggregation(sAggregationName, []);
			return aItems;
		}

		return ObjectPageSectionBase.prototype.removeAllAggregation.apply(this, arguments);
	};

	ObjectPageSubSection.prototype.removeAggregation = function (sAggregationName, oObject) {
		var bRemoved = false, aInternalAggregation;

		if (this.hasProxy(sAggregationName)) {
			aInternalAggregation = this._getAggregation(sAggregationName);
			aInternalAggregation.forEach(function (oObjectCandidate, iIndex) {
				if (oObjectCandidate.getId() === oObject.getId()) {
					aInternalAggregation.splice(iIndex, 1);
					this._setAggregation(aInternalAggregation);
					bRemoved = true;
				}
				return !bRemoved;
			}, this);

			return (bRemoved ? oObject : null);
		}

		return ObjectPageSectionBase.prototype.removeAggregation.apply(this, arguments);
	};

	ObjectPageSubSection.prototype.indexOfAggregation = function (sAggregationName, oObject) {
		var iIndexFound = -1;

		if (this.hasProxy(sAggregationName)) {
			this._getAggregation(sAggregationName).some(function (oObjectCandidate, iIndex) {
				if (oObjectCandidate.getId() === oObject.getId()) {
					iIndexFound = iIndex;
					return true;
				}
			}, this);

			return iIndexFound;
		}

		return ObjectPageSectionBase.prototype.indexOfAggregation.apply(this, arguments);
	};

	ObjectPageSubSection.prototype.getAggregation = function (sAggregationName) {
		if (this.hasProxy(sAggregationName)) {
			return this._getAggregation(sAggregationName);
		}

		return ObjectPageSectionBase.prototype.getAggregation.apply(this, arguments);
	};

	ObjectPageSubSection.prototype.destroyAggregation = function (sAggregationName) {
		if (this.hasProxy(sAggregationName)) {
			this._getAggregation(sAggregationName).forEach(function (object) {
				object.destroy();
			});

			this._setAggregation(sAggregationName, []);

			return this;
		}

		return ObjectPageSectionBase.prototype.destroyAggregation.apply(this, arguments);
	};

	/*************************************************************************************
	 *  Private section : should overridden with care
	 ************************************************************************************/

	/**
	 * build the control that will used internally for the see more / see less
	 * @private
	 */
	ObjectPageSubSection.prototype._getSeeMoreButton = function () {
		if (!this._oSeeMoreButton) {
			this._oSeeMoreButton = new Button(this.getId() + "--seeMore", {
				type: sap.m.ButtonType.Transparent,
				iconFirst: false
			}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler, this);
		}

		return this._oSeeMoreButton;
	};

	/**
	 * called when a user clicks on the see more or see all button
	 * @param oEvent
	 * @private
	 */
	ObjectPageSubSection.prototype._seeMoreLessControlPressHandler = function (oEvent) {
		var sCurrentMode = this.getMode(),
			sTargetMode,
			aMoreBlocks = this.getMoreBlocks() || [];

		//we just switch the layoutMode for the underlying blocks
		if (sCurrentMode === ObjectPageSubSectionMode.Expanded) {
			sTargetMode = ObjectPageSubSectionMode.Collapsed;
		} else {/* we are in Collapsed */
			sTargetMode = ObjectPageSubSectionMode.Expanded;

			aMoreBlocks.forEach(function (oBlock) {
				if (oBlock instanceof BlockBase) {
					oBlock.setMode(sCurrentMode);
					oBlock.connectToModels();
				}
			}, this);
		}
		this._switchSubSectionMode(sTargetMode);

		//in case of the last subsection of an objectpage we need to compensate its height change while rerendering)
		if (this._$spacer.length > 0) {
			this._$spacer.height(this._$spacer.height() + this.$().height());
		}

		//need to re-render the subsection in order to render all the blocks with the appropriate mode & layout
		//0000811842 2014
		this.rerender();
	};

	/**
	 * switch the state for the subsection
	 * @param sSwitchToMode
	 * @private
	 */
	ObjectPageSubSection.prototype._switchSubSectionMode = function (sSwitchToMode) {
		sSwitchToMode = this.validateProperty("mode", sSwitchToMode);

		if (sSwitchToMode === ObjectPageSubSectionMode.Collapsed) {
			this.setProperty("mode", ObjectPageSubSectionMode.Collapsed, true);
			this._getSeeMoreButton().setText(library.i18nModel.getResourceBundle().getText("SEE_MORE"));
		} else {
			this.setProperty("mode", ObjectPageSubSectionMode.Expanded, true);
			this._getSeeMoreButton().setText(library.i18nModel.getResourceBundle().getText("SEE_LESS"));
		}
	};

	/**
	 * set the mode on a control if there is such mode property
	 * @param oBlock
	 * @param sMode
	 * @private
	 */
	ObjectPageSubSection.prototype._setBlockMode = function (oBlock, sMode) {
		if (oBlock instanceof BlockBase) {
			oBlock.setMode(sMode);
		} else {
			jQuery.sap.log.debug("ObjectPageSubSection :: cannot propagate mode " + sMode + " to " + oBlock.getMetadata().getName());
		}
	};

	ObjectPageSubSection.prototype._setToFocusable = function (bFocusable) {
		var sFocusable = '0',
			sNotFocusable = '-1',
			sTabIndex = "tabIndex";

		if (bFocusable) {
			this.$().attr(sTabIndex, sFocusable);
		} else {
			this.$().attr(sTabIndex, sNotFocusable);
		}

		return this;
	};

	/**
	 * If this is the first rendering and a layout has been defined by the subsection developer,
	 * We remove it and let the built-in mechanism decide on the layouting aspects
	 * @param aBlocks
	 * @private
	 */
	ObjectPageSubSection.prototype._resetLayoutData = function (aBlocks) {
		aBlocks.forEach(function (oBlock) {
			if (!this._bRenderedFirstTime && oBlock.getLayoutData()) {
				oBlock.destroyLayoutData();
				jQuery.sap.log.warning("ObjectPageSubSection :: forbidden use of layoutData for block " +
					oBlock.getMetadata().getName(), "layout will be set by subSection");
			}
		}, this);
	};

	ObjectPageSubSection.prototype.getVisibleBlocksCount = function () {
		var iVisibleBlocks = 0;

		(this.getBlocks() || []).forEach(function (oBlock) {
			if (oBlock.getVisible && !oBlock.getVisible()) {
				return true;
			}

			iVisibleBlocks++;
		});

		(this.getMoreBlocks() || []).forEach(function (oMoreBlock) {
			if (oMoreBlock.getVisible && !oMoreBlock.getVisible()) {
				return true;
			}

			iVisibleBlocks++;
		});

		return iVisibleBlocks;
	};

	return ObjectPageSubSection;
});

}; // end of sap/uxap/ObjectPageSubSection.js
if ( !jQuery.sap.isDeclared('sap.uxap.component.ObjectPageLayoutUXDrivenFactory.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.component.ObjectPageLayoutUXDrivenFactory.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.layout.GridData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.BindingMode'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Context'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
sap.ui.define("sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller",[
	"sap/ui/layout/GridData",
	"sap/ui/model/BindingMode",
	"sap/uxap/BlockBase",
	"sap/uxap/ModelMapping",
	"sap/ui/model/Context",
	"sap/ui/base/ManagedObject",
	"sap/ui/core/mvc/Controller"
], function (GridData, BindingMode, BlockBase, ModelMapping, Context, ManagedObject, Controller) {
	"use strict";

	return Controller.extend("sap.uxap.component.ObjectPageLayoutUXDrivenFactory", {

		/**
		 * injects the header based on configuration
		 * @param {object} oModel model instanse
		 */
		connectToComponent: function (oModel) {

			var bHasPendingRequest = jQuery.isEmptyObject(oModel.getData());

			//ensure a 1 way binding otherwise it cause any block property change to update the entire subSections
			oModel.setDefaultBindingMode(BindingMode.OneWay);

			var fnHeaderFactory = jQuery.proxy(function () {

				if (bHasPendingRequest) {
					oModel.detachRequestCompleted(fnHeaderFactory);
				}

				var oHeaderTitleContext = new Context(oModel, "/headerTitle"),
					oObjectPageLayout = this.getView().byId("ObjectPageLayout");

				//create the header title if provided in the config
				if (oHeaderTitleContext.getProperty("")) {
					try {
						//retrieve the header class
						this._oHeader = this.controlFactory(oObjectPageLayout.getId(), oHeaderTitleContext);
						oObjectPageLayout.setHeaderTitle(this._oHeader);
					} catch (sError) {
						jQuery.sap.log.error("ObjectPageLayoutFactory :: error in header creation from config: " + sError);
					}
				}

			}, this);

			//if data are not there yet, we wait for them
			if (bHasPendingRequest) {
				oModel.attachRequestCompleted(fnHeaderFactory);
			} else { //otherwise we apply the header factory immediately
				fnHeaderFactory();
			}
		},

		/**
		 * generates a control to be used in actions, blocks or moreBlocks aggregations
		 * known issue: bindings are not applied, the control is built with data only
		 * @param {string} sParentId the Id of the parent
		 * @param {object} oBindingContext binding context
		 * @returns {*} new control
		 */
		controlFactory: function (sParentId, oBindingContext) {
			var oControlInfo = oBindingContext.getProperty(""), oControl, oControlClass, oControlMetadata;

			try {
				//retrieve the block class
				jQuery.sap.require(oControlInfo.Type);
				oControlClass = jQuery.sap.getObject(oControlInfo.Type);
				oControlMetadata = oControlClass.getMetadata();

				//pre-processing: substitute event handler as strings by their function instance
				jQuery.each(oControlMetadata._mAllEvents, jQuery.proxy(function (sEventName, oEventProperties) {
					if (typeof oControlInfo[sEventName] == "string") {
						oControlInfo[sEventName] = this.convertEventHandler(oControlInfo[sEventName]);
					}
				}, this));

				//creates the control with control info = create with provided properties
				oControl = ManagedObject.create(oControlInfo);

				//post-processing: bind properties on the objectPageLayoutMetadata model
				jQuery.each(oControlMetadata._mAllProperties, jQuery.proxy(function (sPropertyName, oProperty) {
					if (oControlInfo[sPropertyName]) {
						oControl.bindProperty(sPropertyName, "objectPageLayoutMetadata>" + oBindingContext.getPath() + "/" + sPropertyName);
					}
				}, this));
			} catch (sError) {
				jQuery.sap.log.error("ObjectPageLayoutFactory :: error in control creation from config: " + sError);
			}

			return oControl;
		},

		/**
		 * determine the static function to use from its name
		 * @param {string} sStaticHandlerName the name of the handler
		 * @returns {*|window|window} function
		 */
		convertEventHandler: function (sStaticHandlerName) {

			var fnNameSpace = window, aNameSpaceParts = sStaticHandlerName.split('.');

			try {
				jQuery.each(aNameSpaceParts, function (iIndex, sNameSpacePart) {
					fnNameSpace = fnNameSpace[sNameSpacePart];
				});
			} catch (sError) {
				jQuery.sap.log.error("ObjectPageLayoutFactory :: undefined event handler: " + sStaticHandlerName + ". Did you forget to require its static class?");
				fnNameSpace = undefined;
			}

			return fnNameSpace;
		}
	});
}, /* bExport= */ true);

}; // end of sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller.js
if ( !jQuery.sap.isDeclared('sap.uxap.LazyLoading') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.LazyLoading'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.Metadata'); // unlisted dependency retained
sap.ui.define("sap/uxap/LazyLoading",["jquery.sap.global",	"sap/ui/Device", "sap/ui/base/Metadata", "./ObjectPageSubSection"],
	function (jQuery, Device, Metadata, ObjectPageSubSection) {
		"use strict";

		var LazyLoading = Metadata.createClass("sap.uxap._helpers.LazyLoading", {
			/**
			 * @private
			 * @param {*} oObjectPageLayout Object Layout instance
			 */
			constructor: function (oObjectPageLayout) {

				this._oObjectPageLayout = oObjectPageLayout;

				this._$html = jQuery("html");

				this._iPreviousScrollTop = 0;               //scroll top of the last scroll event
				this._iScrollProgress = 0;                  //progress done between the 2 last scroll events
				this._iPreviousScrollTimestamp = 0;         //Timestamp of the last scroll event
				this._sLazyLoadingTimer = null;

				this.setLazyLoadingParameters();
			}
		});


		/**
		 * Set the lazy loading tuning parameters.
		 */
		LazyLoading.prototype.setLazyLoadingParameters = function () {
			//delay before loading data for visible sub-sections
			//this delay avoid loading data for every subsections during scroll
			this.LAZY_LOADING_DELAY = 200;  //ms.

			//lazy loading fine tuning
			//An extra non visible subsection will be loaded if the the top of this subsection is at
			//no more than LAZY_LOADING_EXTRA_PAGE_SIZE * page height from the the bottom of the page.
			this.LAZY_LOADING_EXTRA_PAGE_SIZE = 0.5;

			//number of subsections which should be preloaded :
			//   - FirstRendering : for first loading
			//   - ScrollToSection : default value when scrolling to a subsection
			if (this._isPhone()) {
				this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD = {"FirstRendering": 1, "ScrollToSection": 1};
			} else if (this._isTablet()) {
				//on tablet scrolling may be slow.
				this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD = {"FirstRendering": 2, "ScrollToSection": 1};
			} else if (this._isTabletSize()) {
				//Desktop with a "tablet" window size
				this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD = {"FirstRendering": 2, "ScrollToSection": 2};
			} else {
				this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD = {"FirstRendering": 3, "ScrollToSection": 3};
			}

			//Threshold beyond which we consider that user is scrolling fast and thus that lazy loading must be differed.
			//(percentage of the pageheight).
			this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD = 5;
		};

		LazyLoading.prototype.lazyLoadDuringScroll = function (iScrollTop, timeStamp, iPageHeight) {
			var iProgressPercentage,
				iDelay,
				bFastScrolling = false;

			this._iScrollProgress = iScrollTop - this._iPreviousScrollTop;
			iProgressPercentage = Math.round(Math.abs(this._iScrollProgress) / iPageHeight * 100);
			if (iProgressPercentage >= this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD) {
				bFastScrolling = true;
			}
			this._iPreviousScrollTop = iScrollTop;
			this._iPreviousScrollTimestamp = timeStamp || 0;

			iDelay = (iScrollTop === 0 ) ? 0 : this.LAZY_LOADING_DELAY;
			//if we are scrolling fast, clear the previous delayed lazy loading call if any
			//as we don't want to load intermediate subsections which are visible only
			//during a brief moment during scroll.
			if (bFastScrolling && this._sLazyLoadingTimer) {
				jQuery.sap.log.debug("ObjectPageLayout :: lazyLoading", "delayed by " + iDelay + " ms because of fast scroll");
				jQuery.sap.clearDelayedCall(this._sLazyLoadingTimer);
				this._sLazyLoadingTimer = null;
			}

			//If there's no delayed lazy loading call, create a new one.
			if (!this._sLazyLoadingTimer) {
				this._sLazyLoadingTimer = jQuery.sap.delayedCall(iDelay, this, this.doLazyLoading);
			}
		};

		LazyLoading.prototype.doLazyLoading = function () {
			var oHeightParams = this._oObjectPageLayout._getHeightRelatedParameters(),
				oSectionInfo = this._oObjectPageLayout._oSectionInfo,
				iScrollTop,
				iScrollPageBottom,
				iPageHeight,
				bShouldStick = this._iPreviousScrollTop >= (oHeightParams.iHeaderContentHeight), // iHeaderContentHeight
				sExtraSubSectionId,
				iExtraSubSectionTop = -1,
				oSubSectionsToLoad = {},
				iTimeDifference,
				bOnGoingScroll,
				iShift;


			//calculate the limit of visible sections to be lazy loaded
			iPageHeight = (
				oHeightParams.iScreenHeight                                            /* the total screen height */
				- (bShouldStick ? oHeightParams.iAnchorBarHeight : 0)              /* minus the part taken by the anchor bar (when sticky)*/
				- (bShouldStick ? oHeightParams.iHeaderTitleHeightStickied : 0)    /* minus the part taken by the header title (mandatory) */
			);
			iScrollTop = oHeightParams.iScrollTop;

			//we consider that the scroll is still ongoing if:
			//   - a scroll event has been received for less than half of the LAZY_LOADING_DELAY (100 ms)
			//   - progress done between the last 2 scroll event is greater than 5 pixels.
			iTimeDifference = Date.now() - this._iPreviousScrollTimestamp;
			bOnGoingScroll = (iTimeDifference < (this.LAZY_LOADING_DELAY / 2) ) && (Math.abs(this._iScrollProgress) > 5);

			// if scroll is ongoing, we shift the pages top and height to:
			//     - avoid loading subsections which will likely no more be visible at the end of scroll
			//       (Next lazyLoading calls will anyway load them if they are still visible at the end of scroll)
			//     - load in advance subsections which will likely be visible at the end of scroll
			if (bOnGoingScroll) {
				if (this._iScrollProgress >= 0) {
					iShift = Math.round(Math.min(this._iScrollProgress * 20, iPageHeight / 2));
				} else {
					iShift = -1 * Math.round(Math.min(Math.abs(this._iScrollProgress) * 20, iPageHeight / 2));
				}
				iScrollTop += iShift;
				jQuery.sap.log.debug("ObjectPageLayout :: lazyLoading", "Visible page shifted from : " + iShift);
			}
			iScrollPageBottom = iScrollTop + iPageHeight;       //the bottom limit

			//don't load subsections which are hardly visible at the top of the page (less than 16 pixels visible)
			//to avoid having the following subsections moving downward as subsection size will likely increase during loading
			iScrollTop += 16;

			//check the visible subsections
			//only consider subsections not yet loaded
			jQuery.each(oSectionInfo, jQuery.proxy(function (sId, oInfo) {
				// on desktop/tablet, find a section, not a subsection
				if (!oInfo.isSection && !oInfo.loaded && oInfo.sectionReference.getParent().getVisible()) {
					// 1D segment intersection between visible page and current sub section
					// C <= B and A <= D -> intersection
					//    A-----B
					//  C---D
					//       C----D
					//     C-D
					// C-----------D
					if (oInfo.positionTop <= iScrollPageBottom && iScrollTop < oInfo.positionBottom - 1) {
						oSubSectionsToLoad[sId] = sId;
						// Lazy loading will add an extra subsection :
						//    the first (highest) subsection not yet visible (and not yet loaded)
						//    top of this subsection must be close from page bottom (less than 0.5 page : LAZY_LOADING_EXTRA_PAGE_SIZE)
					} else if (oInfo.positionTop > iScrollPageBottom &&
						oInfo.positionTop < iScrollPageBottom + iPageHeight * this.LAZY_LOADING_EXTRA_PAGE_SIZE &&
						(iExtraSubSectionTop == -1 || oInfo.positionTop < iExtraSubSectionTop)) {
						iExtraSubSectionTop = oInfo.positionTop;
						sExtraSubSectionId = sId;
					}
				}

			}, this));

			//add the extra subsection if:
			//      - we have found one
			//      - we have no visible subsections to load
			if (iExtraSubSectionTop != -1 &&
				jQuery.isEmptyObject(oSubSectionsToLoad)) {
				jQuery.sap.log.debug("ObjectPageLayout :: lazyLoading", "extra section added : " + sExtraSubSectionId);
				oSubSectionsToLoad[sExtraSubSectionId] = sExtraSubSectionId;
			}

			//Load the subsections
			jQuery.each(oSubSectionsToLoad, jQuery.proxy(function (idx, sSectionId) {
				jQuery.sap.log.debug("ObjectPageLayout :: lazyLoading", "connecting " + sSectionId);
				sap.ui.getCore().byId(sSectionId).connectToModels();
				oSectionInfo[sSectionId].loaded = true;
			}, this));

			if (bOnGoingScroll) {
				//bOnGoingScroll is just a prediction, we can't be 100% sure as there's no end-of-scroll event
				//so we relaunch a new delayed lazy loading to ensure all visible
				//sections will actually be loaded (no shift) if scroll stops suddenly.
				this._sLazyLoadingTimer = jQuery.sap.delayedCall(this.LAZY_LOADING_DELAY, this, this.doLazyLoading);
			} else {
				if (iExtraSubSectionTop) {
					//An extra subsection has been found
					//relaunch a delayed lazy loading call to check if there's another extra subsection to load
					//We use a long delay (5* LAZY_LOADING_DELAY) to wait for current loading completion.
					this._sLazyLoadingTimer = jQuery.sap.delayedCall(5 * this.LAZY_LOADING_DELAY, this, this.doLazyLoading);
				} else {
					//reset the lazy loading timer
					this._sLazyLoadingTimer = null;
				}
			}
		};


		/**
		 * Load in advance the subsections which will likely be visible once the operation (firstRendering or scrolltoSection)
		 * will be complete.
		 * @private
		 * @param {*} aAllSections all sections
		 * @param {*} sId id of the section
		 * @returns {*} sections to preload
		 */
		LazyLoading.prototype.getSubsectionsToPreload = function (aAllSections, sId) {
			var iSubsectionsToPreLoad,
				bTargetSubsectionReached;

			//if no sId, target section is the first section (first rendering).
			if (sId) {
				iSubsectionsToPreLoad = this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;
				bTargetSubsectionReached = false;
			} else {
				iSubsectionsToPreLoad = this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;
				bTargetSubsectionReached = true;
			}

			var aSectionsToPreload = [];

			aAllSections.some(function (oSection) {
				if (!bTargetSubsectionReached && sId) {
					bTargetSubsectionReached = oSection.getId() == sId;
				}
				if (bTargetSubsectionReached && oSection instanceof ObjectPageSubSection) {
					if (oSection.getVisible() && oSection._getInternalVisible()) {
						aSectionsToPreload.push(oSection);
						iSubsectionsToPreLoad--;
					}
				}
				return iSubsectionsToPreLoad <= 0;
			});

			return aSectionsToPreload;
		};


		LazyLoading.prototype._isPhone = function () {
			return this._$html.hasClass("sapUiMedia-Std-Phone") || Device.system.phone;
		};

		LazyLoading.prototype._isTablet = function () {
			return Device.system.tablet;
		};

		LazyLoading.prototype._isTabletSize = function () {
			return this._$html.hasClass("sapUiMedia-Std-Tablet");
		};

		return LazyLoading;

	}, /* bExport= */ false);

}; // end of sap/uxap/LazyLoading.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageLayout') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.uxap.ObjectPageLayout.
jQuery.sap.declare('sap.uxap.ObjectPageLayout'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.CustomData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ScrollEnablement'); // unlisted dependency retained
jQuery.sap.require('sap.uxap.ObjectPageSubSectionLayout'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageLayout",[
	"jquery.sap.global",
	"sap/ui/core/ResizeHandler",
	"sap/ui/core/Control",
	"sap/ui/core/CustomData",
	"sap/ui/Device",
	"sap/ui/core/delegate/ScrollEnablement",
	"./ObjectPageSubSection",
	"./ObjectPageSubSectionLayout",
	"./LazyLoading",
	"./ObjectPageLayoutABHelper",
	"./library"
], function (jQuery, ResizeHandler, Control, CustomData, Device, ScrollEnablement, ObjectPageSubSection, ObjectPageSubSectionLayout, LazyLoading, ABHelper, library) {
	"use strict";

	/**
	 * Constructor for a new ObjectPageLayout.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * An ObjectPageLayout is the layout control, used to put together all parts of an Object page - Header, Navigation bar and Sections/Subsections.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 *
	 * @constructor
	 * @public
	 * @alias sap.uxap.ObjectPageLayout
	 * @since 1.26
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ObjectPageLayout = Control.extend("sap.uxap.ObjectPageLayout", /** @lends sap.uxap.ObjectPageLayout.prototype */ {
		metadata: {

			library: "sap.uxap",
			properties: {

				/**
				 * Determines whether the Navigation bar (Anchor bar) is displayed.
				 */
				showAnchorBar: {type: "boolean", defaultValue: true},

				/**
				 * Determines whether to show a Popover with Subsection links when clicking on Section links in the Anchor bar.
				 */
				showAnchorBarPopover: {type: "boolean", defaultValue: true},

				/**
				 * Determines whether the Anchor bar items are displayed in upper case.
				 */
				upperCaseAnchorBar: {type: "boolean", defaultValue: true},

				/**
				 * Determines the height of the ObjectPage.
				 */
				height: {type: "sap.ui.core.CSSSize", defaultValue: "100%"},

				/**
				 * Enable lazy loading for the Object page Subsections.
				 */
				enableLazyLoading: {type: "boolean", defaultValue: false},

				/**
				 * Determines whether Subsection titles are displayed on top or to the left of the Subsection content.
				 */
				subSectionLayout: {
					type: "sap.uxap.ObjectPageSubSectionLayout",
					defaultValue: ObjectPageSubSectionLayout.TitleOnTop
				},

				/**
				 * Use sap.m.IconTabBar instead of the default Anchor bar
				 */
				useIconTabBar: {type: "boolean", group: "Misc", defaultValue: false},

				/**
				 * Determines the visibility of the Header content (headerContent aggregation).
				 */
				showHeaderContent: {type: "boolean", group: "Misc", defaultValue: true},

				/**
				 * Determines whether the to use two column layout for the L screen size.
				 */
				useTwoColumnsForLargeScreen: {type: "boolean", group: "Appearance", defaultValue: false},

				/**
				 * Determines whether the title, image, markers and selectTitleArrow are shown in the Header content area.
				 */
				showTitleInHeaderContent: {type: "boolean", group: "Appearance", defaultValue: false},

				/**
				 * Determines whether sections and subsections with importance Low and Medium are hidden even on large screens.
				 * @since 1.32.0
				 */
				showOnlyHighImportance: {type: "boolean", group: "Behavior", defaultValue: false},

				/**
				 * Determines whether the page is a child page and renders it with a different design.
				 * Child pages have an additional (darker/lighter) stripe on the left side of their header content area.
				 * @since 1.34.0
				 */
				isChildPage: {type: "boolean", group: "Appearance", defaultValue: false},

				/**
				 * Determines whether Header Content will always be expanded on desktop.
				 * @since 1.34.0
				 */
				alwaysShowContentHeader: {type: "boolean", group: "Behavior", defaultValue: false},

				/**
				 * Determines whether an Edit button will be shown in Header Content.
				 * @since 1.34.0
				 */
				showEditHeaderButton: {type: "boolean", group: "Behavior", defaultValue: false},

				/**
				 * Specifies whether the object page enables flexibility features, such as hiding and adding sections.<br>
				 * For more information about SAPUI5 flexibility, refer to the Developer Guide.
				 * @since 1.34.0
				 */
				flexEnabled: {type: "boolean", group: "Misc", defaultValue: false}
			},
			defaultAggregation: "sections",
			aggregations: {

				/**
				 * The sections that make up the Object page content area.
				 */
				sections: {type: "sap.uxap.ObjectPageSection", multiple: true, singularName: "section"},

				/**
				 * Object page header title - the upper, always static, part of the Object page header.
				 */
				headerTitle: {type: "sap.uxap.ObjectPageHeader", multiple: false},

				/**
				 * Object page header content - the dynamic part of the Object page header.
				 */
				headerContent: {type: "sap.ui.core.Control", multiple: true, singularName: "headerContent"},

				/**
				 * Internal aggregation to hold the reference to the AnchorBar.
				 */
				_anchorBar: {type: "sap.uxap.AnchorBar", multiple: false, visibility: "hidden"},

				/**
				 * Internal aggregation to hold the reference to the IconTabBar.
				 */
				_iconTabBar: {type: "sap.m.IconTabBar", multiple: false, visibility: "hidden"},

				/**
				 * Internal aggregation to hold the reference to the ObjectPageHeaderContent.
				 */
				_headerContent: {type: "sap.uxap.ObjectPageHeaderContent", multiple: false, visibility: "hidden"}
			},
			events: {

				/**
				 * The event is fired when the Anchor bar is switched from moving to fixed or the other way round.
				 */
				toggleAnchorBar: {
					parameters: {

						/**
						 * False indicates that the Anchor bar has just detached from the Header and became part of the scrolling area. True means that the Anchor bar has just snapped to the Header.
						 */
						fixed: {type: "boolean"}
					}
				},

				/**
				 * The event is fired when the Edit Header button is pressed
				 */
				editHeaderButtonPress: {}
			},
			designTime : true
		}
	});


	/**
	 * Scrolls the Object page to the given Section
	 *
	 * @name sap.uxap.ObjectPageLayout#scrollToSection
	 * @function
	 * @param {string} sId
	 *         The Section ID to scroll to
	 * @param {int} iDuration
	 *         Scroll duration (in ms). Default value is 0
	 * @param {int} iOffset
	 *         Additional pixels to scroll
	 * @type sap.uxap.ObjectPageLayout
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */


	/**
	 * Returns a sap.ui.core.delegate.ScrollEnablement object used to handle scrolling
	 *
	 * @name sap.uxap.ObjectPageLayout#getScrollDelegate
	 * @function
	 * @type object
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */


	/*************************************************************************************
	 * life cycle management
	 ************************************************************************************/

	ObjectPageLayout.prototype.init = function () {

		// lazy loading
		this._bFirstRendering = true;
		this._bDomReady = false;                    //dom is fully ready to be inspected
		this._bStickyAnchorBar = false;             //status of the header

		// anchorbar management
		this._bInternalAnchorBarVisible = true;

		this._$opWrapper = [];                      //dom reference to the header for Dark mode background image scrolling scenario
		this._$anchorBar = [];                      //dom reference to the anchorBar
		this._$headerTitle = [];                    //dom reference to the header title
		this._$stickyAnchorBar = [];                //dom reference to the sticky anchorBar
		this._$headerContent = [];                  //dom reference to the headerContent
		this._$stickyHeaderContent = [];            //dom reference to the stickyHeaderContent

		// header animation && anchor bar management
		this._bMobileScenario = false;              //are we in a mobile scenario or the desktop one?
		this._oSectionInfo = {};                    //register some of the section info sSectionId:{offset,buttonClone} for updating the anchorbar accordingly
		this._aSectionBases = [];                   //hold reference to all sections and subsections alike (for perf reasons)
		this._sScrolledSectionId = "";              //section id that is currently scrolled
		this._iScrollToSectionDuration = 600;       //ms
		this._$spacer = [];                         //dom reference to the bottom padding spacing
		this.iHeaderContentHeight = 0;              // original height of the header content
		this.iStickyHeaderContentHeight = 0;        // original height of the sticky header content
		this.iHeaderTitleHeight = 0;                // original height of the header title
		this.iHeaderTitleHeightStickied = 0;        // height of the header title when stickied (can be different from the collapsed height because of isXXXAlwaysVisible options or text wrapping)
		this.iAnchorBarHeight = 0;                  // original height of the anchorBar
		this.iTotalHeaderSize = 0;                  // total size of headerTitle + headerContent

		this._iResizeId = ResizeHandler.register(this, this._onUpdateScreenSize.bind(this));

		this._oLazyLoading = new LazyLoading(this);
		this._oABHelper = new ABHelper(this);
	};

	/**
	 * update the anchor bar content accordingly to the section info and enable the lazy loading of the first visible sections
	 */

	ObjectPageLayout.prototype.onBeforeRendering = function () {
		this._bMobileScenario = library.Utilities.isPhoneScenario();
		this._bTabletScenario = library.Utilities.isTabletScenario();

		// if we have Header Content on a desktop, check if it is always expanded
		this._bHContentAlwaysExpanded = this._checkAlwaysShowContentHeader();

		this._initializeScroller();

		this._getHeaderContent().setContentDesign(this._getHeaderDesign());
		this._oABHelper._getAnchorBar().setUpperCase(this.getUpperCaseAnchorBar());

		this._applyUxRules();

		// If we are on the first true rendering : first time we render the page with section and blocks
		if (!jQuery.isEmptyObject(this._oSectionInfo) && this._bFirstRendering) {
			this._preloadSectionsOnBeforeFirstRendering();
			this._bFirstRendering = false;
		}

		this._bStickyAnchorBar = false; //reset default state in case of re-rendering

		var oHeaderTitle = this.getHeaderTitle();
		if (oHeaderTitle && oHeaderTitle.getAggregation("_expandButton")) {
			oHeaderTitle.getAggregation("_expandButton").attachPress(this._handleExpandButtonPress, this);
		}
	};

	ObjectPageLayout.prototype._preloadSectionsOnBeforeFirstRendering = function () {
		var aToLoad;
		if (!this.getEnableLazyLoading()) {
			// In case we are not lazy loaded make sure that we connect the blocks properly...
			aToLoad = this.getUseIconTabBar() ? [this._oFirstVisibleSection] : this.getSections(); // for iconTabBar, load only the section that corresponds to first tab

		} else { //lazy loading, so connect first visible subsections
			var aSectionBasesToLoad = this.getUseIconTabBar() ? this._grepCurrentTabSectionBases() : this._aSectionBases;
			aToLoad = this._oLazyLoading.getSubsectionsToPreload(aSectionBasesToLoad);
		}

		this._connectModelsForSections(aToLoad);
	};

	ObjectPageLayout.prototype._grepCurrentTabSectionBases = function () {
		var oFiltered = [],
		oSectionToLoad = this._oCurrentTabSection || this._oFirstVisibleSection;

		if (oSectionToLoad) {
			var sSectionToLoadId = oSectionToLoad.getId();
			this._aSectionBases.forEach(function(oSection) {
				if (oSection.getParent().getId() === sSectionToLoadId) {
					oFiltered.push(oSection);
				}
			});
		}
		return oFiltered;
	};

	/*************************************************************************************
	 * header & scroll management
	 ************************************************************************************/

	ObjectPageLayout.prototype.onAfterRendering = function () {

		this._ensureCorrectParentHeight();

		this._cacheDomElements();

		this._$opWrapper.on("scroll", this._onScroll.bind(this));

		//the dom is already ready (re-rendering case), thus we compute the header immediately
		//in order to avoid flickering (see Incident 1570011343)
		if (this._bDomReady && this.$().parents(":hidden").length === 0) {
			this._onAfterRenderingDomReady();
		} else {
			jQuery.sap.delayedCall(ObjectPageLayout.HEADER_CALC_DELAY, this, this._onAfterRenderingDomReady);
		}

	};

	ObjectPageLayout.prototype._onAfterRenderingDomReady = function () {
		this._bDomReady = true;

		this._adjustHeaderHeights();

		if (this.getUseIconTabBar()) {
			this._setCurrentTabSection(this._oFirstVisibleSection);
		}

		this._initAnchorBarScroll();
		this.getHeaderTitle() && this.getHeaderTitle()._shiftHeaderTitle();

		this._setSectionsFocusValues();
	};

	ObjectPageLayout.prototype.exit = function () {
		if (this._oScroller) {
			this._oScroller.destroy();
			this._oScroller = null;
		}

		if (this._iResizeId) {
			ResizeHandler.deregister(this._iResizeId);
		}
	};

	ObjectPageLayout.prototype.setShowOnlyHighImportance = function (bValue) {
		var bOldValue = this.getShowOnlyHighImportance();

		if (bOldValue !== bValue) {
			this.setProperty("showOnlyHighImportance", bValue, true);
			this.getSections().forEach(function (oSection) {
				oSection._updateImportance();
			});
		}
		return this;
	};

	ObjectPageLayout.prototype.setIsHeaderContentAlwaysExpanded = function (bValue) {
		var bOldValue = this.getAlwaysShowContentHeader();
		var bSuppressInvalidate = (Device.system.phone || Device.system.tablet);

		if (bOldValue !== bValue) {
			this.setProperty("alwaysShowContentHeader", bValue, bSuppressInvalidate);
		}
		return this;
	};

	ObjectPageLayout.prototype._initializeScroller = function () {
		//are we re-rendering an existing objectPageLayout?
		//if so we need to reset the scroller as it gets confused
		if (this._oScroller) {
			this._oScroller.scrollTo(0, 0, 0);         //reset the actual scroll position
			this._oScroller.destroy();
		}

		//Internal Incident: 1482023778: workaround BB10 = use zynga instead of iScroll
		var bEnforceZynga = (Device.os.blackberry && Device.os.version >= 10.0 && Device.os.version < 11.0);

		this._oScroller = new ScrollEnablement(this, this.getId() + "-scroll", {
			horizontal: false,
			vertical: true,
			zynga: bEnforceZynga,
			preventDefault: true,
			nonTouchScrolling: "scrollbar",
			scrollbarClass: "sapUxAPObjectPageScroll"
		});
	};

	ObjectPageLayout.prototype._ensureCorrectParentHeight = function () {
		//if our container has not set a height, we need to enforce it or nothing will get displayed
		//the reason is the objectPageLayout has 2 containers with position:absolute, height:100%
		if (this.getParent().getHeight && ["", "auto"].indexOf(this.getParent().getHeight()) !== -1) {
			this.$().parent().css("height", "100%");
		}
	};

	ObjectPageLayout.prototype._cacheDomElements = function () {
		this._$headerTitle = jQuery.sap.byId(this.getId() + "-headerTitle");
		this._$anchorBar = jQuery.sap.byId(this.getId() + "-anchorBar");
		this._$stickyAnchorBar = jQuery.sap.byId(this.getId() + "-stickyAnchorBar");
		this._$opWrapper = jQuery.sap.byId(this.getId() + "-opwrapper");
		this._$spacer = jQuery.sap.byId(this.getId() + "-spacer");
		this._$headerContent = jQuery.sap.byId(this.getId() + "-headerContent");
		this._$stickyHeaderContent = jQuery.sap.byId(this.getId() + "-stickyHeaderContent");
		this._$contentContainer = jQuery.sap.byId(this.getId() + "-scroll");
	};

	/**
	 * Handles the press of the expand header button
	 * @private
	 */
	ObjectPageLayout.prototype._handleExpandButtonPress = function (oEvent) {
		this._expandCollapseHeader(true);
	};

	/**
	 * Toggles visual rules on manually expand or collapses the sticky header
	 * @private
	 */
	ObjectPageLayout.prototype._toggleStickyHeader = function (bExpand) {
		this._bIsHeaderExpanded = bExpand;
		this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied", !bExpand);
		this._toggleHeaderStyleRules(!bExpand);
	};

	/**
	 * Expands or collapses the sticky header
	 * @private
	 */
	ObjectPageLayout.prototype._expandCollapseHeader = function (bExpand) {
		var oHeaderTitle = this.getHeaderTitle();
		if (this._bHContentAlwaysExpanded) {
			return;
		}

		if (bExpand && this._bStickyAnchorBar) {
			// if the title in the header is not always visible but the action buttons are there we have remove the padding of the action buttons
			if (oHeaderTitle && oHeaderTitle.getIsActionAreaAlwaysVisible() && !oHeaderTitle.getIsObjectTitleAlwaysVisible()) {
				oHeaderTitle._setActionsPaddingStatus(bExpand);
			}
			this._$headerContent.css("height", this.iHeaderContentHeight).children().appendTo(this._$stickyHeaderContent); // when removing the header content, preserve the height of its placeholder, to avoid automatic repositioning of scrolled content as it gets shortened (as its topmost part is cut off)
			this._toggleStickyHeader(bExpand);
		} else if (!bExpand && this._bIsHeaderExpanded) {
			this._$headerContent.css("height", "auto").append(this._$stickyHeaderContent.children());
			this._$stickyHeaderContent.children().remove();
			this._toggleStickyHeader(bExpand);
		}
	};

	/*************************************************************************************
	 * Ux rules
	 ************************************************************************************/
	/**
	 * updates the objectPageLayout structure based on ux rules
	 * This affects data!
	 * @private
	 * @param {boolean} bInvalidate request the invalidation of the sectionBase that would turn into visible or hidden. This may not be necessary if you are already within a rendering process.
	 */
	ObjectPageLayout.prototype._applyUxRules = function (bInvalidate) {
		var aSections, aSubSections, iVisibleSubSections, iVisibleSection, iVisibleBlocks,
			bVisibleAnchorBar, bVisibleIconTabBar, oFirstVisibleSection, oFirstVisibleSubSection;

		aSections = this.getSections() || [];
		iVisibleSection = 0;
		bVisibleAnchorBar = this.getShowAnchorBar();
		bVisibleIconTabBar = this.getUseIconTabBar();

		oFirstVisibleSection = null;

		this._cleanMemory();

		aSections.forEach(function (oSection) {

			//ignore hidden sections
			if (!oSection.getVisible()) {
				return true;
			}

			this._registerSectionBaseInfo(oSection);
			aSubSections = oSection.getSubSections() || [];
			iVisibleSubSections = 0;
			oFirstVisibleSubSection = null;

			aSubSections.forEach(function (oSubSection) {

				//ignore hidden subSection
				if (!oSubSection.getVisible()) {
					return true;
				}

				this._registerSectionBaseInfo(oSubSection);
				iVisibleBlocks = oSubSection.getVisibleBlocksCount();

				//rule noVisibleBlock: If a subsection has no visible content the subsection will be hidden.
				if (iVisibleBlocks === 0) {
					oSubSection._setInternalVisible(false, bInvalidate);
					jQuery.sap.log.info("ObjectPageLayout :: noVisibleBlock UX rule matched", "subSection " + oSubSection.getTitle() + " forced to hidden");
				} else {
					oSubSection._setInternalVisible(true, bInvalidate);
					//if TitleOnTop.sectionGetSingleSubSectionTitle is matched, this will be hidden back
					oSubSection._setInternalTitleVisible(true, bInvalidate);
					iVisibleSubSections++;
					if (!oFirstVisibleSubSection) {
						oFirstVisibleSubSection = oSubSection;
					}
				}

			}, this);

			//rule noVisibleSubSection: If a section has no content (or only empty subsections) the section will be hidden.
			if (iVisibleSubSections == 0) {
				oSection._setInternalVisible(false, bInvalidate);
				jQuery.sap.log.info("ObjectPageLayout :: noVisibleSubSection UX rule matched", "section " + oSection.getTitle() + " forced to hidden");
			} else {
				oSection._setInternalVisible(true, bInvalidate);
				oSection._setInternalTitleVisible(true, bInvalidate);
				if (!oFirstVisibleSection) {
					oFirstVisibleSection = oSection;
				}

				//rule TitleOnTop.sectionGetSingleSubSectionTitle: If a section as only 1 subsection and the subsection title is not empty, the section takes the subsection title on titleOnTop layout only
				if (this.getSubSectionLayout() === ObjectPageSubSectionLayout.TitleOnTop &&
					iVisibleSubSections === 1 && oFirstVisibleSubSection.getTitle().trim() !== "") {
					jQuery.sap.log.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched", "section " + oSection.getTitle() + " is taking its single subsection title " + oFirstVisibleSubSection.getTitle());
					oSection._setInternalTitle(oFirstVisibleSubSection.getTitle(), bInvalidate);
					oFirstVisibleSubSection._setInternalTitleVisible(false, bInvalidate);
				} else {
					oSection._setInternalTitle("", bInvalidate);
				}

				iVisibleSection++;
			}

			if (bVisibleIconTabBar) {
				oSection._setInternalTitleVisible(false, bInvalidate);
			}

		}, this);

		//rule notEnoughVisibleSection: If there is only 1 section overall, the navigation control shall be hidden.
		if (iVisibleSection <= 1) {
			bVisibleAnchorBar = false;
			jQuery.sap.log.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched", "anchorBar forced to hidden");
			//rule firstSectionTitleHidden: the first section title is never visible if there is an anchorBar
		} else if (oFirstVisibleSection && bVisibleAnchorBar) {
			oFirstVisibleSection._setInternalTitleVisible(false, bInvalidate);
			jQuery.sap.log.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched", "section " + oFirstVisibleSection.getTitle() + " title forced to hidden");
		}

		// the AnchorBar needs to reflect the dom state
		 if (bVisibleAnchorBar) {
			this._oABHelper._buildAnchorBar();
		}

		this._setInternalAnchorBarVisible(bVisibleAnchorBar, bInvalidate);
		this._oFirstVisibleSection = oFirstVisibleSection;
	};

	/*************************************************************************************
	 * IconTabBar management
	 ************************************************************************************/

	/**
	 * Overrides the setter for the useIconTabBar property
	 * @param bValue
	 * @returns this
	 */
	ObjectPageLayout.prototype.setUseIconTabBar = function (bValue) {

		var bOldValue = this.getUseIconTabBar();
		if (bValue != bOldValue) {
			this._applyUxRules(); // UxRules contain logic that depends on whether we use iconTabBar or not
		}
		this.setProperty("useIconTabBar", bValue);
		return this;
	};

	/**
	 * Sets a new section to be displayed as currently selected tab
	 * @param oSection
	 * @private
	 */
	ObjectPageLayout.prototype._setCurrentTabSection = function (oSection) {

		if (!oSection) {
			return;
		}

		var oSubsection;

		if (oSection instanceof sap.uxap.ObjectPageSubSection) {
			oSubsection = oSection;
			oSection = oSection.getParent();
		} else {
			oSubsection = this._getFirstVisibleSubSection(oSection);
		}

		if (this._oCurrentTabSection !== oSection) {
			this._renderSection(oSection);
			this._oCurrentTabSection = oSection;
		}
		this._oCurrentTabSubSection = oSubsection;
	};

	/**
	 * renders the given section in the ObjectPageContainer html element, without causing re-rendering of the ObjectPageLayout,
	 * used for switching between sections, when the navigation is through IconTabBar
	 * @param oSection
	 * @private
	 */
	ObjectPageLayout.prototype._renderSection = function (oSection) {

		var $objectPageContainer = this.$().find(".sapUxAPObjectPageContainer"),
			oRm;

		if (oSection && $objectPageContainer.length) {

			oRm = sap.ui.getCore().createRenderManager();
			oRm.renderControl(oSection);
			oRm.flush($objectPageContainer[0]);// place the section in the ObjectPageContainer
		}

		oRm.destroy();
	};

	/*************************************************************************************
	 * anchor bar management
	 ************************************************************************************/

	ObjectPageLayout.prototype.setShowAnchorBarPopover = function (bValue, bSuppressInvalidate) {
		this._oABHelper._buildAnchorBar();
		this._oABHelper._getAnchorBar().setShowPopover(bValue);
		return this.setProperty("showAnchorBarPopover", bValue, true /* don't re-render the whole objectPageLayout */);
	};

	ObjectPageLayout.prototype._getInternalAnchorBarVisible = function () {
		return this._bInternalAnchorBarVisible;
	};

	ObjectPageLayout.prototype._setInternalAnchorBarVisible = function (bValue, bInvalidate) {
		if (bValue != this._bInternalAnchorBarVisible) {
			this._bInternalAnchorBarVisible = bValue;
			if (bInvalidate === true) {
				this.invalidate();
			}
		}
	};

	ObjectPageLayout.prototype._adjustLayout = function (oEvent, bImmediate, bNeedLazyLoading) {

		//adjust the layout only if the object page is full ready
		if (!this._bDomReady) {
			return;
		}

		//postpone until we get requests
		if (this._iLayoutTimer) {
			jQuery.sap.log.debug("ObjectPageLayout :: _adjustLayout", "delayed by " + ObjectPageLayout.DOM_CALC_DELAY + " ms because of dom modifications");
			jQuery.sap.clearDelayedCall(this._iLayoutTimer);
		}

		if (bImmediate) {
			this._updateScreenHeightSectionBasesAndSpacer();
			this._iLayoutTimer = undefined;
		} else {
			//need to "remember" if one of the adjustLayout is requesting the lazyLoading
			this._bNeedLazyLoading = this._bNeedLazyLoading !== undefined || bNeedLazyLoading;

			this._iLayoutTimer = jQuery.sap.delayedCall(ObjectPageLayout.DOM_CALC_DELAY, this, function () {
				jQuery.sap.log.debug("ObjectPageLayout :: _adjustLayout", "re-evaluating dom positions");
				this._updateScreenHeightSectionBasesAndSpacer();

				//in case the layout has changed we need to re-evaluate the lazy loading
				if (this._bNeedLazyLoading) {
					this._oLazyLoading.doLazyLoading();
				}

				this._bNeedLazyLoading = undefined;
				this._iLayoutTimer = undefined;
			});
		}
	};


	/**
	 * adjust the layout but also the ux rules
	 * used for refreshing the overall structure of the objectPageLayout when it as been updated after the first rendering
	 * @private
	 */

	ObjectPageLayout.prototype._adjustLayoutAndUxRules = function () {
		//in case we have added a section or subSection which change the ux rules
		jQuery.sap.log.debug("ObjectPageLayout :: _adjustLayout", "refreshing ux rules");

		var sSelectedSectionId = this._getSelectedSectionId(); //obtain the currently selected section in the navBar before navBar is destroyed

		this._applyUxRules(true);

		this._setSelectedSectionId(sSelectedSectionId); //reselect the current section in the navBar

		this._adjustLayout(null, false, true /* requires a check on lazy loading */);
	};


	ObjectPageLayout.prototype._getSelectedSectionId = function () {

		var oAnchorBar = this.getAggregation("_anchorBar"),
			sSelectedSectionId;

		if (oAnchorBar && oAnchorBar.getSelectedSection()) {
			sSelectedSectionId = oAnchorBar.getSelectedSection().getId();
		}

		return sSelectedSectionId;
	};


	ObjectPageLayout.prototype._setSelectedSectionId = function (sSelectedSectionId) {
		var oAnchorBar = this.getAggregation("_anchorBar"),
			oSelectedSectionInfo = sSelectedSectionId && this._oSectionInfo[sSelectedSectionId];

		if (!oSelectedSectionInfo) {
			return;
		}

		if (oAnchorBar && oSelectedSectionInfo.buttonId) {
			oAnchorBar.setSelectedButton(oSelectedSectionInfo.buttonId);
		}
	};


	ObjectPageLayout.prototype.isFirstRendering = function () {
		return this._bFirstRendering;
	};

	/**
	 * clean the oSectionInfo and aSectionBases internal properties
	 * as the oSectionInfo contains references to created objects, we make sure to destroy them properly in order to avoid memory leaks
	 * @private
	 */
	ObjectPageLayout.prototype._cleanMemory = function () {

		var oAnchorBar = this.getAggregation("_anchorBar");
		if (oAnchorBar) {
			oAnchorBar.destroyContent();
		}

		this._oSectionInfo = {};
		this._aSectionBases = [];
	};

	/**
	 * register the section within the internal property used for lazy loading and navigation
	 * most of these properties are going to be updated later when the dom will be ready (positions) or when the anchorBar button will be created (buttonId)
	 * @param oSectionBase the section to register
	 * @private
	 */
	ObjectPageLayout.prototype._registerSectionBaseInfo = function (oSectionBase) {
		this._oSectionInfo[oSectionBase.getId()] = {
			$dom: [],
			positionTop: 0,
			positionTopMobile: 0,
			realTop: 0.0,
			buttonId: "",
			isSection: (oSectionBase instanceof library.ObjectPageSection),
			sectionReference: oSectionBase
		};

		this._aSectionBases.push(oSectionBase);
	};

	/**
	 * Scroll to a specific Section
	 *
	 * @param sId       id of the section to scroll to
	 * @param iDuration  Scroll duration. Default value is 0
	 * @param iOffset Additional offset to scroll
	 *
	 */
	ObjectPageLayout.prototype.scrollToSection = function (sId, iDuration, iOffset) {

		var oSection = sap.ui.getCore().byId(sId);

		if (this.getUseIconTabBar()) {

			this._setCurrentTabSection(oSection);

			var oToSelect = oSection;
			if (oToSelect instanceof sap.uxap.ObjectPageSubSection) {
				oToSelect = oToSelect.getParent();
			}
			this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[oToSelect.getId()].buttonId);
		}

		if (this._bIsHeaderExpanded) {
			this._expandCollapseHeader(false);
		}

		iOffset = iOffset || 0;

		oSection._expandSection();
		//call _adjustLayout synchronously to make extra sure we have the right positionTops for all sectionBase before scrolling
		this._adjustLayout(null, true);

		iDuration = this._computeScrollDuration(iDuration, oSection);

		var iScrollTo = this._computeScrollPosition(oSection);

		//avoid triggering twice the scrolling onto the same target section
		if (this._sCurrentScrollId != sId) {
			this._sCurrentScrollId = sId;

			if (this._iCurrentScrollTimeout) {
				clearTimeout(this._iCurrentScrollTimeout);
				this._$contentContainer.parent().stop(true, false);
			}

			this._iCurrentScrollTimeout = jQuery.sap.delayedCall(iDuration, this, function () {
				this._sCurrentScrollId = undefined;
				this._iCurrentScrollTimeout = undefined;
			});

			this._preloadSectionsOnScroll(oSection);

			this.getHeaderTitle() && this.getHeaderTitle()._shiftHeaderTitle();

			this._scrollTo(iScrollTo + iOffset, iDuration);
		}

	};

	ObjectPageLayout.prototype._computeScrollDuration = function (iAppSpecifiedDuration, oTargetSection) {
		var iDuration = parseInt(iAppSpecifiedDuration, 10);
		iDuration = iDuration >= 0 ? iDuration : this._iScrollToSectionDuration;

		if (this.getUseIconTabBar()
				&& ((oTargetSection instanceof sap.uxap.ObjectPageSection) || this._isFirstVisibleSubSection(oTargetSection))
				&& this._bStickyAnchorBar) { // in this case we are only scrolling
											 // a section from expanded to sticky position,
											 // so the scrolling animation in not needed, instead it looks unnatural, so set a 0 duration
			iDuration = 0;
		}
		return iDuration;
	};

	ObjectPageLayout.prototype._computeScrollPosition = function (oTargetSection) {

		var bFirstLevel = oTargetSection && (oTargetSection instanceof sap.uxap.ObjectPageSection),
			sId = oTargetSection.getId();

		var iScrollTo = this._bMobileScenario || bFirstLevel ? this._oSectionInfo[sId].positionTopMobile : this._oSectionInfo[sId].positionTop;

		if (this.getUseIconTabBar()
				&& ((oTargetSection instanceof sap.uxap.ObjectPageSection) || this._isFirstVisibleSubSection(oTargetSection))
				&& !this._bStickyAnchorBar) { // preserve expanded header if no need to stick

				iScrollTo -= this.iHeaderContentHeight; // scroll to the position where the header is still expanded
		}
		return iScrollTo;
	};

	ObjectPageLayout.prototype._preloadSectionsOnScroll = function (oTargetSection) {

		var sId = oTargetSection.getId(),
			aToLoad;

		if (!this.getEnableLazyLoading() && this.getUseIconTabBar()) {
			aToLoad = (oTargetSection instanceof sap.uxap.ObjectPageSection) ? oTargetSection : oTargetSection.getParent();
			this._connectModelsForSections([aToLoad]);
		}

		if (this.getEnableLazyLoading()) {
			//connect target subsection to avoid delay in data loading
			var oSectionBasesToLoad = this.getUseIconTabBar() ? this._grepCurrentTabSectionBases() : this._aSectionBases;
			aToLoad = this._oLazyLoading.getSubsectionsToPreload(oSectionBasesToLoad, sId);

			if (Device.system.desktop) {
				//on desktop we delay the call to have the preload done during the scrolling animation
				jQuery.sap.delayedCall(50, this, function () {
					this._connectModelsForSections(aToLoad);
				});
			} else {
				//on device, do the preload first then scroll.
				//doing anything during the scrolling animation may
				//trouble animation and lazy loading on slow devices.
				this._connectModelsForSections(aToLoad);
			}
		}
	};

	/**
	 * Returns the UI5 ID of the Section that is currently being scrolled.
	 *
	 * @type string
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	ObjectPageLayout.prototype.getScrollingSectionId = function () {
		return this._sScrolledSectionId;
	};

	/**
	 * Set for reference the destination section of the ongoing scroll
	 * When this one is set, then the page will skip intermediate sections [during the scroll from the current to the destination section]
	 * and will scroll directly to the given section
	 * @param sDirectSectionId - the section to be scrolled directly to
	 */
	ObjectPageLayout.prototype.setDirectScrollingToSection = function (sDirectSectionId) {
		this.sDirectSectionId = sDirectSectionId;
	};

	/**
	 * Get the destination section of the ongoing scroll
	 * When this one is non-null, then the page will skip intermediate sections [during the scroll from the current to the destination section]
	 * and will scroll directly to the given section
	 * @param sDirectSectionId - the section to be scrolled directly to
	 */
	ObjectPageLayout.prototype.getDirectScrollingToSection = function () {
		return this.sDirectSectionId;
	};

	/**
	 * Clear the destination section of the ongoing scroll
	 * When this one is null, then the page will process all intermediate sections [during the scroll to some Y position]
	 * and select each one in sequence
	 */
	ObjectPageLayout.prototype.clearDirectScrollingToSection = function () {
		this.sDirectSectionId = null;
	};

	/**
	 * Scroll to the y position in dom
	 * @param y the position in pixel
	 * @param time the animation time
	 * @private
	 */
	ObjectPageLayout.prototype._scrollTo = function (y, time) {
		if (this._oScroller) {
			jQuery.sap.log.debug("ObjectPageLayout :: scrolling to " + y);
			this._oScroller.scrollTo(0, y, time);
		}
		return this;
	};

	/**
	 * update the section dom reference
	 * @private
	 */
	ObjectPageLayout.prototype._updateScreenHeightSectionBasesAndSpacer = function () {
		var iLastVisibleHeight,
			oLastVisibleSubSection,
			iSpacerHeight,
			sPreviousSubSectionId,
			sPreviousSectionId,
			iHeaderGap = 0;

		this.iScreenHeight = this.$().height();

		if (this.iHeaderContentHeight && !this._bHContentAlwaysExpanded) {
			iHeaderGap = this.iHeaderTitleHeightStickied - this.iHeaderTitleHeight;
		}

		this._aSectionBases.forEach(function (oSectionBase) {
			var oInfo = this._oSectionInfo[oSectionBase.getId()],
				$this = oSectionBase.$(),
				$mobileAnchor;

			if (!oInfo /* sectionBase is visible */ || !$this.length) {
				return;
			}

			oInfo.$dom = $this;

			//calculate the scrollTop value to get the section title at the bottom of the header
			//performance improvements possible here as .position() is costly
			oInfo.realTop = $this.position().top; //first get the dom position = scrollTop to get the section at the window top
			var bHasTitle = (oSectionBase._getInternalTitleVisible() && (oSectionBase.getTitle().trim() !== ""));
			if (!oInfo.isSection && !bHasTitle) {
				oInfo.realTop = $this.find(".sapUiResponsiveMargin.sapUxAPBlockContainer").position().top;
			}

			//the amount of scrolling required is the distance between their position().top and the bottom of the anchorBar
			oInfo.positionTop = Math.ceil(oInfo.realTop) - this.iAnchorBarHeight - iHeaderGap;

			//the amount of scrolling required for the mobile scenario
			//we want to navigate just below its title
			//as of UX specs Oct 7, 2014
			if (oInfo.isSection) {
				$mobileAnchor = oSectionBase.$("header");
			} else {
				$mobileAnchor = oSectionBase.$("headerTitle");
			}

			//calculate the mobile position
			if ($mobileAnchor.length > 0) {
				oInfo.positionTopMobile = Math.ceil($mobileAnchor.position().top) + $mobileAnchor.outerHeight() - this.iAnchorBarHeight - iHeaderGap;
			} else {
				//title wasn't found (=first section, hidden title, promoted subsection), scroll to the same position as desktop
				oInfo.positionTopMobile = oInfo.positionTop;
			}

			//for calculating the currently scrolled section of subsection (and for lazy loading) we also need to know the bottom of the section and subsections
			//we can't use oInfo.$dom.height() since the margin are not taken into account.
			//therefore the most reliable calculation is to consider as a bottom, the top of the next section/subsection
			//on mobile, each section and subsection is considered equally (a section is a very tiny subsection containing only a title)
			if (this._bMobileScenario) {
				if (sPreviousSectionId) {               //except for the very first section
					this._oSectionInfo[sPreviousSectionId].positionBottom = oInfo.positionTop;
				}
				sPreviousSectionId = oSectionBase.getId();
				oLastVisibleSubSection = oSectionBase;
			} else { //on desktop, we update section by section (each section is resetting the calculation)
				//on a desktop the previous section bottom is the top of the current section
				if (oInfo.isSection) {
					if (sPreviousSectionId) {           //except for the very first section
						this._oSectionInfo[sPreviousSectionId].positionBottom = oInfo.positionTop;
						this._oSectionInfo[sPreviousSubSectionId].positionBottom = oInfo.positionTop;
					}
					sPreviousSectionId = oSectionBase.getId();
					sPreviousSubSectionId = null;
				} else { //on desktop, the previous subsection bottom is the top of the current subsection
					if (sPreviousSubSectionId) {        //except for the very first subSection
						this._oSectionInfo[sPreviousSubSectionId].positionBottom = oInfo.positionTop;
					}
					sPreviousSubSectionId = oSectionBase.getId();
					oLastVisibleSubSection = oSectionBase;
				}
			}

		}, this);

		//calculate the bottom spacer height and update the last section/subSection bottom (with our algorithm of having section tops based on the next section, we need to have a special handling for the very last subSection)
		if (oLastVisibleSubSection) {
			iLastVisibleHeight = this._$spacer.position().top - this._oSectionInfo[oLastVisibleSubSection.getId()].realTop;

			//on desktop we need to set the bottom of the last section as well
			if (this._bMobileScenario) {
				this._oSectionInfo[sPreviousSectionId].positionBottom = this._oSectionInfo[sPreviousSectionId].positionTop + iLastVisibleHeight;
			} else { //update the position bottom for the last subsection
				this._oSectionInfo[sPreviousSubSectionId].positionBottom = this._oSectionInfo[sPreviousSubSectionId].positionTop + iLastVisibleHeight;
				this._oSectionInfo[sPreviousSectionId].positionBottom = this._oSectionInfo[sPreviousSubSectionId].positionTop + iLastVisibleHeight;
			}

			//calculate the required additional space for the last section only
			if (iLastVisibleHeight < this.iScreenHeight) {// see if this line can be skipped

				if (this._isSpacerRequired(oLastVisibleSubSection, iLastVisibleHeight)) {

					//the amount of space required is what is needed to get the latest position you can scroll to up to the "top"
					//therefore we need to create enough space below the last subsection to get it displayed on top = the spacer
					//the "top" is just below the sticky header + anchorBar, therefore we just need enough space to get the last subsection below these elements

					//the latest position is below the last subsection title in case of a mobile scroll to the last subsection
					if (this.iHeaderContentHeight || this._bHContentAlwaysExpanded) {
						// Not always when we scroll the HeaderTitle is in Sticky position so instead of taking out its StickyHeight we have to take out its height and the HeaderGap,
						// which will be zero when the HeaderTitle is in normal mode
						iSpacerHeight = this.iScreenHeight - iLastVisibleHeight - this.iHeaderTitleHeight - iHeaderGap - this.iAnchorBarHeight;
					} else {
						iSpacerHeight = this.iScreenHeight - iLastVisibleHeight - this.iAnchorBarHeight;
					}

					//take into account that we may need to scroll down to the positionMobile, thus we need to make sure we have enough space at the bottom
					if (this._bMobileScenario) {
						iSpacerHeight += (this._oSectionInfo[oLastVisibleSubSection.getId()].positionTopMobile - this._oSectionInfo[oLastVisibleSubSection.getId()].positionTop);
					}
				} else {
					iSpacerHeight = 0;
				}

				this._$spacer.height(iSpacerHeight + "px");
				jQuery.sap.log.debug("ObjectPageLayout :: bottom spacer is now " + iSpacerHeight + "px");
			}
		}
	};

	/*
	* Determines wheder spacer, after the last subsection, is needed on the screen.
	* The main reason for spacer to exist is to have enogth space for scrolling to the last section.
	*/
	ObjectPageLayout.prototype._isSpacerRequired = function (oLastVisibleSubSection, iLastVisibleHeight) {
		var oSelectedSection = this.getAggregation("_anchorBar").getSelectedSection(),
			bIconTabBarWithOneSectionAndOneSubsection = this.getUseIconTabBar() && oSelectedSection
					&& oSelectedSection.getSubSections().length === 1,
			bOneSectionOneSubsection = this.getSections().length === 1 && this.getSections()[0].getSubSections().length === 1;

		// When there there is only one element the scrolling is not required so the spacer is redundant.
		if (bIconTabBarWithOneSectionAndOneSubsection || bOneSectionOneSubsection) {
			return false;
		}

		if (this._bStickyAnchorBar) { // UX Rule: if the user has scrolled to sticky anchorBar, keep it sticky i.e. do not expand the header *automatically*
			return true;
		}

		var bContentFitsViewport = ((this._oSectionInfo[oLastVisibleSubSection.getId()].realTop + iLastVisibleHeight) <= this.iScreenHeight);
		if (!bContentFitsViewport) {
			return true;
		}

		if (!this._isFirstVisibleSubSection(this._oCurrentTabSubSection)) {
			return true;
		}

		return false;
	};

	ObjectPageLayout.prototype._isFirstVisibleSubSection = function (oSectionBase) {
		if (oSectionBase) {
			var oSectionInfo = this._oSectionInfo[oSectionBase.getId()];
			if (oSectionInfo) {
				return oSectionInfo.realTop === (this.iAnchorBarHeight + this.iHeaderContentHeight);
			}
		}
		return false;
	};

	ObjectPageLayout.prototype._getFirstVisibleSubSection = function (oSection) {
		if (!oSection) {
			return;
		}
		var oFirstSubSection;
		this._aSectionBases.every(function(oSectionBase) {
			if (oSectionBase.getParent() && (oSectionBase.getParent().getId() === oSection.getId())) {
				oFirstSubSection = oSectionBase;
				return false;
			}
			return true;
		});
		return oFirstSubSection;
	};

	/**
	 * init the internal section info {positionTop}
	 * @private
	 */
	ObjectPageLayout.prototype._initAnchorBarScroll = function () {

		this._adjustLayout(null, true);

		//reset the scroll to top for anchorbar & scrolling management
		this._sScrolledSectionId = "";
		this._onScroll({target: {scrollTop: 0}});//make sure we got the very last scroll event even on slow devices
	};

	/**
	 * Set a given section as the currently scrolled section and update the anchorBar relatively
	 * @param sSectionId the section id
	 * @private
	 */
	ObjectPageLayout.prototype._setAsCurrentSection = function (sSectionId) {
		var oAnchorBar, oSectionBase, bShouldDisplayParentTitle;

		if (this._sScrolledSectionId === sSectionId) {
			return;
		}

		jQuery.sap.log.debug("ObjectPageLayout :: current section is " + sSectionId);
		this._sScrolledSectionId = sSectionId;

		oAnchorBar = this.getAggregation("_anchorBar");

		if (oAnchorBar && this._getInternalAnchorBarVisible()) {
			oSectionBase = sap.ui.getCore().byId(sSectionId);

			bShouldDisplayParentTitle = oSectionBase && oSectionBase instanceof ObjectPageSubSection &&
				(oSectionBase.getTitle().trim() === "" || !oSectionBase._getInternalTitleVisible() || oSectionBase.getParent()._getIsHidden());

			//the sectionBase title needs to be visible (or the user won't "feel" scrolling that sectionBase but its parent)
			//see Incident 1570016975 for more details
			if (bShouldDisplayParentTitle) {
				sSectionId = oSectionBase.getParent().getId();

				jQuery.sap.log.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent " + sSectionId);
			}

			if (this._oSectionInfo[sSectionId]) {
				oAnchorBar.setSelectedButton(this._oSectionInfo[sSectionId].buttonId);
				this._setSectionsFocusValues(sSectionId);
			}
		}
	};

	/**
	 * called when the screen is resize by users. Updates the screen height
	 * @param oEvent
	 * @private
	 */
	ObjectPageLayout.prototype._onUpdateScreenSize = function (oEvent) {

		if (!this._bDomReady) {
			jQuery.sap.log.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");
			return;
		}

		this._oLazyLoading.setLazyLoadingParameters();

		jQuery.sap.delayedCall(ObjectPageLayout.HEADER_CALC_DELAY, this, function () {
			this._bMobileScenario = library.Utilities.isPhoneScenario();
			this._bTabletScenario = library.Utilities.isTabletScenario();

			if (this._bHContentAlwaysExpanded != this._checkAlwaysShowContentHeader()) {
				this.invalidate();
			}

			this._adjustHeaderHeights();

			this._adjustLayout(null, true);

			this._oScroller.scrollTo(0, this._$opWrapper.scrollTop(), 0);
		});

	};

	/**
	 * called when the user scrolls on the page
	 * @param oEvent
	 * @private
	 */

	ObjectPageLayout.prototype._onScroll = function (oEvent) {
		var iScrollTop = Math.max(oEvent.target.scrollTop, 0), // top of the visible page
			iPageHeight,
			oHeader = this.getHeaderTitle(),
			bShouldStick = iScrollTop >= (this.iHeaderContentHeight - (this.iHeaderTitleHeightStickied - this.iHeaderTitleHeight)), // iHeaderContentHeight minus the gap between the two headerTitle
			sClosestId,
			bScrolled = false;

		//calculate the limit of visible sections to be lazy loaded
		iPageHeight = this.iScreenHeight;
		if (bShouldStick && !this._bHContentAlwaysExpanded) {
			iPageHeight -= (this.iAnchorBarHeight + this.iHeaderTitleHeightStickied);
		} else {
			if (bShouldStick && this._bHContentAlwaysExpanded) {
				iPageHeight = iPageHeight - (this._$stickyAnchorBar.height() + this.iHeaderTitleHeight + this.iStickyHeaderContentHeight); // - this.iStickyHeaderContentHeight
			}
		}

		if (this._bIsHeaderExpanded) {
			this._expandCollapseHeader(false);
		}

		//don't apply parallax effects if there are not enough space for it
		if (!this._bHContentAlwaysExpanded && ((oHeader && this.getShowHeaderContent()) || this.getShowAnchorBar())) {
			this._toggleHeader(bShouldStick);

			//if we happen to have been able to collapse it at some point (section height had increased)
			//and we no longer are (section height is reduced) and we are at the top of the page we expand it back anyway
		} else if (iScrollTop == 0 && ((oHeader && this.getShowHeaderContent()) || this.getShowAnchorBar())) {
			this._toggleHeader(false);
		}

		if (!this._bHContentAlwaysExpanded) {
			this._adjustHeaderTitleBackgroundPosition(iScrollTop);
		}

		jQuery.sap.log.debug("ObjectPageLayout :: lazy loading : Scrolling at " + iScrollTop, "----------------------------------------");

		//find the currently scrolled section = where position - iScrollTop is closest to 0
		sClosestId = this._getClosestScrolledSectionId(iScrollTop, iPageHeight);

		if (sClosestId) {

			// check if scroll destination is set in advance
			// (this is when a particular section is requested from the anchorBar sectionsList and we are now scrolling to reach it)
			var sDestinationSectionId = this.getDirectScrollingToSection();

			if (sClosestId !== this._sScrolledSectionId) {
				jQuery.sap.log.debug("ObjectPageLayout :: closest id " + sClosestId, "----------------------------------------");

				// check if scroll-destination section is explicitly set
				var sDestinationSectionId = this.getDirectScrollingToSection();

				// if scroll-destination section is explicitly set
				// then we do not want to process intermediate sections (i.e. sections between scroll-start section and scroll-destination sections)
				// so if current section is not destination section
				// then no need to proceed further
				if (sDestinationSectionId && sDestinationSectionId !== sClosestId) {
					return;
				}
				this.clearDirectScrollingToSection();

				this._setAsCurrentSection(sClosestId);
			} else if (sClosestId === this.getDirectScrollingToSection()) { //we are already in the destination section
				this.clearDirectScrollingToSection();
			}
		}

		//lazy load only the visible subSections
		if (this.getEnableLazyLoading()) {
			//calculate the progress done between this scroll event and the previous one
			//to see if we are scrolling fast (more than 5% of the page height)
			this._oLazyLoading.lazyLoadDuringScroll(iScrollTop, oEvent.timeStamp, iPageHeight);
		}

		if (oHeader && this.getShowHeaderContent() && this.getShowTitleInHeaderContent() && oHeader.getShowTitleSelector()) {
			if (iScrollTop === 0) {
				// if we have arrow from the title inside the ContentHeader and the ContentHeader isn't scrolled we have to put higher z-index to the ContentHeader
				// otherwise part of the arrow is cut off
				jQuery.sap.byId(this.getId() + "-scroll").css("z-index", "1000");
				bScrolled = false;
			} else if (!bScrolled) {
				bScrolled = true;
				// and we have to "reset" the z-index it when we start scrolling
				jQuery.sap.byId(this.getId() + "-scroll").css("z-index", "0");
			}
		}
	};

	ObjectPageLayout.prototype._getClosestScrolledSectionId = function (iScrollTop, iPageHeight) {

		if (this.getUseIconTabBar() && this._oCurrentTabSection) {
			return this._oCurrentTabSection.getId();
		}

		var iScrollPageBottom = iScrollTop + iPageHeight,                 //the bottom limit
			sClosestId;

		jQuery.each(this._oSectionInfo, function (sId, oInfo) {
			// on desktop/tablet, skip subsections
			if (oInfo.isSection || this._bMobileScenario) {
				//we need to set the sClosest to the first section for handling the scrollTop = 0
				if (!sClosestId) {
					sClosestId = sId;
				}

				// current section/subsection is inside the view port
				if (oInfo.positionTop <= iScrollPageBottom && iScrollTop <= oInfo.positionBottom) {
					// scrolling position is over current section/subsection
					if (oInfo.positionTop <= iScrollTop && oInfo.positionBottom >= iScrollTop) {
						sClosestId = sId;
						return false;
					}
				}
			}

		}.bind(this));

		return sClosestId;
	};


	/**
	 * toggles the header state
	 * @param bStick boolean true for fixing the header, false for keeping it moving
	 * @private
	 */
	ObjectPageLayout.prototype._toggleHeader = function (bStick) {
		var oHeaderTitle = this.getHeaderTitle();

		//switch to stickied
		if (!this._bHContentAlwaysExpanded && !this._bIsHeaderExpanded) {
			this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied", bStick);
		}

		// if the title in the header is not always visible but the action buttons are there we have to adjust header height and remove the padding of the action buttons
		if (oHeaderTitle && oHeaderTitle.getIsActionAreaAlwaysVisible() && !oHeaderTitle.getIsObjectTitleAlwaysVisible()) {
			oHeaderTitle._setActionsPaddingStatus(!bStick);
		}

		if (!this._bStickyAnchorBar && bStick) {
			this._restoreFocusAfter(this._convertHeaderToStickied);
			oHeaderTitle && oHeaderTitle._adaptLayout();
			this._adjustHeaderHeights();
		} else if (this._bStickyAnchorBar && !bStick) {
			this._restoreFocusAfter(this._convertHeaderToExpanded);
			oHeaderTitle && oHeaderTitle._adaptLayout();
			this._adjustHeaderHeights();
		}
	};

	/**
	 * Restores the focus after moving the Navigation bar after moving it between containers
	 * @private
	 * @param fnMoveNavBar a function that moves the navigation bar
	 * @returns this
	 */
	ObjectPageLayout.prototype._restoreFocusAfter = function (fnMoveNavBar) {
		var oCore = sap.ui.getCore(),
			oLastSelectedElement = oCore.byId(oCore.getCurrentFocusedControlId());

		fnMoveNavBar.call(this);
		if (Device.system.phone !== true) { // FIX - can not convert to expanded on windows phone
			if (!oCore.byId(oCore.getCurrentFocusedControlId())) {
				oLastSelectedElement && oLastSelectedElement.$().focus();
			}
		}

		return this;
	};

	/**
	 * Converts the Header to stickied (collapsed) mode
	 * @private
	 * @returns this
	 */
	ObjectPageLayout.prototype._convertHeaderToStickied = function () {
		if (!this._bHContentAlwaysExpanded) {
			this._$anchorBar.css("height", this.iAnchorBarHeight).children().appendTo(this._$stickyAnchorBar);

			this._toggleHeaderStyleRules(true);

			//Internal Incident: 1472003895: FIT W7 MI: Dual color in the header
			//we need to adjust the header background now in case its size is different
			if (this.iHeaderTitleHeight != this.iHeaderTitleHeightStickied) {
				this._adjustHeaderBackgroundSize();
			}
		}

		return this;
	};

	/**
	 * Converts the Header to expanded (moving) mode
	 * @private
	 * @returns this
	 */
	ObjectPageLayout.prototype._convertHeaderToExpanded = function () {
		if (!this._bHContentAlwaysExpanded) {
			this._$anchorBar.css("height", "auto").append(this._$stickyAnchorBar.children());

			this._toggleHeaderStyleRules(false);
		}
		return this;
	};

	/**
	 * Toggles the header styles for between stickied and expanded modes
	 * @private
	 * @returns this
	 */
	ObjectPageLayout.prototype._toggleHeaderStyleRules = function (bStuck) {
		bStuck = !!bStuck;
		var sValue = bStuck ? "hidden" : "inherit",
			sABarVisible = this._bIsHeaderExpanded ? "hidden" : "inherit";
		this._bStickyAnchorBar = bStuck;
		this._$headerContent.css("overflow", sValue);
		this._$headerContent.css("visibility", sValue);
		this._$anchorBar.css("visibility", sABarVisible);
		this.fireToggleAnchorBar({fixed: bStuck});
	};

	/**
	 * Returns the sap.ui.core.ScrollEnablement delegate which is used with this control.
	 */
	ObjectPageLayout.prototype.getScrollDelegate = function () {
		return this._oScroller;
	};


	/************************************************************************************************************
	 * Header specific methods
	 ***********************************************************************************************************/

	ObjectPageLayout.prototype.setHeaderTitle = function (oHeaderTitle, bSuppressInvalidate) {

		oHeaderTitle.addEventDelegate({
			onAfterRendering: this._adjustHeaderHeights.bind(this)
		});

		return this.setAggregation("headerTitle", oHeaderTitle, bSuppressInvalidate);
	};

	ObjectPageLayout.prototype._adjustHeaderBackgroundSize = function () {
		// Update the background image size and position
		var oHeaderTitle = this.getHeaderTitle();
		if (oHeaderTitle && oHeaderTitle.getHeaderDesign() == "Dark") {

			if (!this._bHContentAlwaysExpanded) {
				this.iTotalHeaderSize = this.iHeaderTitleHeight + this.iHeaderContentHeight;
				this._$headerContent.css("background-size", "100% " + this.iTotalHeaderSize + "px");
			} else {
				// The header size in this case contains the header content and the anchor bar, we have to exclude the anchor bar, since no background is applyied to it
				this.iTotalHeaderSize = this.iHeaderTitleHeight - this._$stickyAnchorBar.height();
				// here the sticky header content has to be updated not the content like in the upper case
				this._$stickyHeaderContent.css("background-size", "100% " + this.iTotalHeaderSize + "px");
			}

			oHeaderTitle.$().css("background-size", "100% " + this.iTotalHeaderSize + "px");

			this._adjustHeaderTitleBackgroundPosition(0);
		}
	};

	ObjectPageLayout.prototype._adjustHeaderTitleBackgroundPosition = function (iScrollTop) {

		var oHeaderTitle = this.getHeaderTitle();
		if (oHeaderTitle && oHeaderTitle.getHeaderDesign() == "Dark") {
			if (this._bStickyAnchorBar) {
				oHeaderTitle.$().css("background-position", "0px " + ((this.iTotalHeaderSize - this.iHeaderTitleHeightStickied) * -1) + "px");
			} else {
				if (this._bHContentAlwaysExpanded) {
					// If the header is always expanded, there is no neeed to scroll the background so we setting it to 0 position
					oHeaderTitle.$().css("background-position", "0px 0px");
				} else {
					oHeaderTitle.$().css("background-position", "0px " + (this.iHeaderTitleHeight + this.iHeaderContentHeight - this.iTotalHeaderSize - iScrollTop) + "px");
				}
			}
		}
	};

	ObjectPageLayout.prototype._adjustHeaderHeights = function () {
		//checking the $headerTitle we prevent from checking the headerHeights multiple times during the first rendering
		//$headerTitle is set in the objectPageLayout.onAfterRendering, thus before the objectPageLayout is fully rendered once, we don't enter here multiple times (performance tweak)
		if (this._$headerTitle.length > 0) {
			var $headerTitleClone = this._$headerTitle.clone();

			//read the headerContentHeight ---------------------------
			this.iHeaderContentHeight = this._$headerContent.height();

			//read the sticky headerContentHeight ---------------------------
			this.iStickyHeaderContentHeight = this._$stickyHeaderContent.height();

			//figure out the anchorBarHeight  ------------------------
			this.iAnchorBarHeight = this._$anchorBar.height();

			//prepare: make sure it won't be visible ever and fix width to the original headerTitle which is 100%
			$headerTitleClone.css({left: "-10000px", top: "-10000px", width: this._$headerTitle.width() + "px"});

			//in sticky mode, we need to calculate the size of original header
			if (this._bStickyAnchorBar) {

				//read the headerTitleStickied ---------------------------
				this.iHeaderTitleHeightStickied = this._$headerTitle.height() - this.iAnchorBarHeight;

				//adjust the headerTitle  -------------------------------
				$headerTitleClone.removeClass("sapUxAPObjectPageHeaderStickied");
				$headerTitleClone.appendTo(this._$headerTitle.parent());

				this.iHeaderTitleHeight = $headerTitleClone.is(":visible") ? $headerTitleClone.height() - this.iAnchorBarHeight : 0;
			} else { //otherwise it's the sticky that we need to calculate

				//read the headerTitle -----------------------------------
				this.iHeaderTitleHeight = this._$headerTitle.is(":visible") ? this._$headerTitle.height() : 0;

				//adjust headerTitleStickied ----------------------------
				$headerTitleClone.addClass("sapUxAPObjectPageHeaderStickied");
				$headerTitleClone.appendTo(this._$headerTitle.parent());

				this.iHeaderTitleHeightStickied = $headerTitleClone.height();
			}

			//clean dom
			$headerTitleClone.remove();

			//adjust dom element directly depending on the adjusted height
			// Adjust wrapper top position
			var iPadding = this.iHeaderContentHeight ? this.iHeaderTitleHeight : this.iHeaderTitleHeightStickied; // if no header content, the top padding has to be larger
			// so that the static header does not overlap the beginning of the first section
			this._$opWrapper.css("padding-top", iPadding);
			this._adjustHeaderBackgroundSize();

			jQuery.sap.log.info("ObjectPageLayout :: adjustHeaderHeight", "headerTitleHeight: " + this.iHeaderTitleHeight + " - headerTitleStickiedHeight: " + this.iHeaderTitleHeightStickied + " - headerContentHeight: " + this.iHeaderContentHeight);
		} else {
			jQuery.sap.log.debug("ObjectPageLayout :: adjustHeaderHeight", "skipped as the objectPageLayout is being rendered");
		}
	};

	/**
	 * Retrieve the current header design that was defined in the headerTitle if available
	 *
	 * @private
	 */
	ObjectPageLayout.prototype._getHeaderDesign = function () {
		var oHeader = this.getHeaderTitle(),
			sDesign = library.ObjectPageHeaderDesign.Light;

		if (oHeader != null) {
			sDesign = oHeader.getHeaderDesign();
		}
		return sDesign;
	};

	/**
	 * Gets only the visible sections
	 *
	 * @private
	 */

	ObjectPageLayout.prototype._getVisibleSections = function () {
		return this.getSections().filter(function (oSection) {
			return oSection.getVisible() && oSection._getInternalVisible();
		});
	};

	/**
	 * Sets appropriate focus to the sections
	 *
	 * @private
	 */

	ObjectPageLayout.prototype._setSectionsFocusValues = function (sSectionId) {
		var aSections = this._getVisibleSections() || [],
			$section,
			sFocusable = '0',
			sNotFocusable = '-1',
			sTabIndex = "tabIndex",
			oSelectedElement,
			oFirstSection = aSections[0];

		aSections.forEach(function (oSection) {
			$section = oSection.$();

			if (sSectionId === oSection.sId) {
				$section.attr(sTabIndex, sFocusable);
				oSelectedElement = oSection;
				oSection._setSubSectionsFocusValues();
			} else {
				$section.attr(sTabIndex, sNotFocusable);
				oSection._disableSubSectionsFocus();
			}
		});

		if (!oSelectedElement && aSections.length > 0) {
			oFirstSection.$().attr(sTabIndex, sFocusable);
			oFirstSection._setSubSectionsFocusValues();
			oSelectedElement = oFirstSection;
		}

		return oSelectedElement;
	};

	/**
	 * get current visibility of the HeaderContent and if it is different from the new one rererender it
	 */
	ObjectPageLayout.prototype.setShowHeaderContent = function (bShow) {
		var bOldShow = this.getShowHeaderContent();

		if (bOldShow !== bShow) {
			if (bOldShow && this._bIsHeaderExpanded) {
				this._expandCollapseHeader(false);
			}
			this.setProperty("showHeaderContent", bShow);
			this._getHeaderContent().setProperty("visible", bShow);
		}
		return this;
	};

	/**
	 * Calls the renderer function that will rerender the ContentHeader when something is changed in the ObjectPageHeader Title
	 *
	 * @private
	 */
	ObjectPageLayout.prototype._headerTitleChangeHandler = function () {

		if (!this.getShowTitleInHeaderContent() || this._bFirstRendering) {
			return;
		}

		var oRm = sap.ui.getCore().createRenderManager();
		this.getRenderer()._rerenderHeaderContentArea(oRm, this);
		oRm.destroy();
	};

	/**
	 * Maintain ObjectPageHeaderContent aggregation
	 *
	 */
	ObjectPageLayout.prototype.getHeaderContent = function () {
		return this._getHeaderContent().getAggregation("content");
	};

	ObjectPageLayout.prototype.insertHeaderContent = function (oObject, iIndex, bSuppressInvalidate) {
		return this._getHeaderContent().insertAggregation("content", oObject, iIndex, bSuppressInvalidate);
	};

	ObjectPageLayout.prototype.addHeaderContent = function (oObject, bSuppressInvalidate) {
		return this._getHeaderContent().addAggregation("content", oObject, bSuppressInvalidate);
	};

	ObjectPageLayout.prototype.removeAllHeaderContent = function (bSuppressInvalidate) {
		return this._getHeaderContent().removeAllAggregation("content", bSuppressInvalidate);
	};

	ObjectPageLayout.prototype.removeHeaderContent = function (oObject, bSuppressInvalidate) {
		return this._getHeaderContent().removeAggregation("content", oObject, bSuppressInvalidate);
	};

	ObjectPageLayout.prototype.destroyHeaderContent = function (bSuppressInvalidate) {
		return this._getHeaderContent().destroyAggregation("content", bSuppressInvalidate);
	};

	ObjectPageLayout.prototype.indexOfHeaderContent = function (oObject) {
		return this._getHeaderContent().indexOfAggregation("content", oObject);
	};

	/**
	 * Lazy loading of the _headerContent aggregation
	 *
	 * @private
	 */
	ObjectPageLayout.prototype._getHeaderContent = function () {

		if (!this.getAggregation("_headerContent")) {
			this.setAggregation("_headerContent", new library.ObjectPageHeaderContent({
				visible: this.getShowHeaderContent(),
				contentDesign: this._getHeaderDesign(),
				content: this.getAggregation("headerContent")
			}), true);
		}

		return this.getAggregation("_headerContent");
	};

	ObjectPageLayout.prototype._checkAlwaysShowContentHeader = function () {
		return !this._bMobileScenario
			&& !this._bTabletScenario
			&& this.getShowHeaderContent()
			&& this.getAlwaysShowContentHeader();
	};

	ObjectPageLayout.prototype._connectModelsForSections = function (aSections) {
		aSections = aSections || [];
		aSections.forEach(function (oSection) {
			oSection.connectToModels();
		});
	};

	ObjectPageLayout.prototype._getHeightRelatedParameters = function () {
		return {
			iHeaderContentHeight: this.iHeaderContentHeight,
			iScreenHeight: this.iScreenHeight,
			iAnchorBarHeight: this.iAnchorBarHeight,
			iHeaderTitleHeightStickied: this.iHeaderTitleHeightStickied,
			iStickyHeaderContentHeight: this.iStickyHeaderContentHeight,
			iScrollTop: this._$opWrapper.scrollTop()
		};
	};

	ObjectPageLayout.prototype._hasVerticalScrollBar = function () {
		if (this._$opWrapper.length) {
			return this._$opWrapper[0].scrollHeight > this._$opWrapper.innerHeight();
		} else {
			return !this.getUseIconTabBar();
		}
	};

	ObjectPageLayout.prototype._shiftHeader = function (sDirection, sPixels) {
		this.$().find(".sapUxAPObjectPageHeaderTitle").css(sDirection, sPixels);
	};

	/**
	 * Checks if a section is the first visible one
	 * @private
	 */
	ObjectPageLayout.prototype._isFirstSection = function (oSection) {
		var aSections = this._getVisibleSections();
		if (oSection === aSections[0]) {
			return true;
		}
		return false;
	};

	ObjectPageLayout.HEADER_CALC_DELAY = 350;   //ms. The higher the safer and the uglier...
	ObjectPageLayout.DOM_CALC_DELAY = 200;      //ms.

	return ObjectPageLayout;

});

}; // end of sap/uxap/ObjectPageLayout.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.ObjectPageHeaderRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/uxap/ObjectPageHeaderRenderer",["./ObjectPageLayout"], function (ObjectPageLayout) {
	"use strict";

	/**
	 * @class HeaderBase renderer.
	 * @static
	 */
	var ObjectPageHeaderRenderer = {};

	ObjectPageHeaderRenderer.render = function (oRm, oControl) {

		var oNavigationBar = oControl.getNavigationBar(),
			bTitleVisible = (oControl.getIsObjectIconAlwaysVisible() || oControl.getIsObjectTitleAlwaysVisible() || oControl.getIsObjectSubtitleAlwaysVisible() || oControl.getIsActionAreaAlwaysVisible()),
			oParent = oControl.getParent(),
			oExpandButton = oControl.getAggregation("_expandButton"),
			bIsDesktop = sap.ui.Device.system.desktop,
			bIsHeaderContentVisible = oParent && oParent instanceof ObjectPageLayout && oParent.getHeaderContent() && oParent.getHeaderContent().length > 0 && oParent.getShowHeaderContent();

		oRm.write("<div");
		oRm.writeControlData(oControl);
		oRm.addClass('sapUxAPObjectPageHeader');
		oRm.addClass('sapUxAPObjectPageHeaderDesign-' + oControl.getHeaderDesign());
		oRm.writeClasses();
		oRm.write(">");
		// if an navigationBar has been provided display it

		if (oNavigationBar) {
			oRm.write("<div");
			oRm.addClass('sapUxAPObjectPageHeaderNavigation');
			oRm.writeClasses();
			oRm.write(">");
			oRm.renderControl(oNavigationBar);
			oRm.write("</div>");
		}

		// first line
		oRm.write("<div");
		oRm.writeAttributeEscaped("id", oControl.getId() + "-identifierLine");
		oRm.addClass('sapUxAPObjectPageHeaderIdentifier');
		if (bTitleVisible) {
			oRm.addClass('sapUxAPObjectPageHeaderIdentifierForce');
		}
		oRm.writeClasses();
		oRm.write(">");

		if (oParent && oParent instanceof ObjectPageLayout && oParent.getIsChildPage()) {
			oRm.write("<div");
			oRm.addClass('sapUxAPObjectChildPage');
			oRm.writeClasses();
			oRm.write("></div>");
		}

		// If picturePath is provided show image
		if (oControl.getObjectImageURI() || oControl.getShowPlaceholder()) {
			oRm.write("<span ");
			oRm.addClass('sapUxAPObjectPageHeaderObjectImageContainer');
			oRm.addClass('sapUxAPObjectPageHeaderObjectImage-' + oControl.getObjectImageShape());
			if (oControl.getIsObjectIconAlwaysVisible()) {
				oRm.addClass('sapUxAPObjectPageHeaderObjectImageForce');
			}
			oRm.writeClasses();
			oRm.write(">");
			oRm.write("<span class='sapUxAPObjectPageHeaderObjectImageContainerSub'>");
			if (oControl.getObjectImageURI()) {
				oRm.renderControl(oControl._getInternalAggregation("_objectImage"));
				if (oControl.getShowPlaceholder()) {
					this._renderPlaceholder(oRm, oControl, false);
				}
			} else {
				this._renderPlaceholder(oRm, oControl, true);
			}

			oRm.write("</span>");
			oRm.write("</span>");
		}
		oRm.write("<span ");
		oRm.writeAttributeEscaped("id", oControl.getId() + "-identifierLineContainer");
		oRm.addClass('sapUxAPObjectPageHeaderIdentifierContainer');
		oRm.writeClasses();
		oRm.write(">");

		this._renderObjectPageTitle(oRm, oControl);
		oRm.write("</span>");

		oRm.write("<span");
		oRm.writeAttributeEscaped("id", oControl.getId() + "-actions");
		oRm.addClass('sapUxAPObjectPageHeaderIdentifierActions');
		if (oControl.getIsActionAreaAlwaysVisible()) {
			oRm.addClass('sapUxAPObjectPageHeaderIdentifierActionsForce');
		}
		if (oControl._getActionsPaddingStatus()) {
			oRm.addClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding");
		}
		oRm.writeClasses();
		oRm.write(">");

		// Render the expand button only if there is a content to expand and we are on desktop
		if (bIsDesktop && bIsHeaderContentVisible) {
			oExpandButton.addStyleClass("sapUxAPObjectPageHeaderExpandButton");
			oRm.renderControl(oExpandButton);
		}

		var aActions = oControl.getActions();
		for (var i = 0; i < aActions.length; i++) {
			var oAction = aActions[i];

			oRm.renderControl(oAction);
		}
		var oOverflowButton = oControl.getAggregation("_overflowButton");
		oRm.renderControl(oOverflowButton);
		oRm.write("</span>");

		oRm.write("</div>");

		oRm.write("</div>");
	};


	/**
	 * Renders the SelectTitleArrow icon.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.uxap.ObjecPageHeader}
	 *            oControl the ObjectPageHeader
	 *
	 * @param {bVisible}  if the placeholder will be visible
	 *
	 * @private
	 */
	ObjectPageHeaderRenderer._renderPlaceholder = function (oRm, oControl, bVisible, bTitleInContent) {
		oRm.write("<div");
		oRm.addClass('sapUxAPObjectPageHeaderPlaceholder');
		oRm.addClass('sapUxAPObjectPageHeaderObjectImage');
		if (!bVisible) {
			oRm.addClass('sapUxAPHidePlaceholder');
		}
		oRm.writeClasses();
		oRm.write(">");
		oRm.renderControl(oControl._oPlaceholder);
		oRm.write("</div>");
	};

	/**
	 * Renders the SelectTitleArrow icon.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.uxap.ObjecPageHeader}
	 *            oControl the ObjectPageHeader
	 *
	 * @private
	 */
	ObjectPageHeaderRenderer._renderObjectPageTitle = function (oRm, oControl, bTitleInContent) {
		var sOHTitle = oControl.getObjectTitle(),
			bMarkers = (oControl.getShowMarkers() && (oControl.getMarkFavorite() || oControl.getMarkFlagged())),
			oBreadCrumbs = oControl._getInternalAggregation('_breadCrumbs');

		if (!bTitleInContent && oBreadCrumbs && oBreadCrumbs.getLinks().length) {
			oRm.renderControl(oBreadCrumbs);
		}
		oRm.write("<h1");
		oRm.addClass('sapUxAPObjectPageHeaderIdentifierTitle');
		if (oControl.getIsObjectTitleAlwaysVisible()) {
			oRm.addClass('sapUxAPObjectPageHeaderIdentifierTitleForce');
		}
		if (bTitleInContent) {
			oRm.addClass('sapUxAPObjectPageHeaderIdentifierTitleInContent');
		}
		if (oControl.getShowTitleSelector()) { // if we have arrow to render, the subtitle should have smaller top margin
			oRm.addClass('sapUxAPObjectPageHeaderTitleFollowArrow');
		}

		oRm.writeClasses();
		oRm.writeAttributeEscaped("id", oControl.getId() + "-title");
		oRm.write(">");
		oRm.write("<span");
		oRm.addClass("sapUxAPObjectPageHeaderTitleTextWrappable");
		oRm.writeClasses();
		oRm.writeAttributeEscaped("id", oControl.getId() + "-innerTitle");
		oRm.write(">");

		// if we have markers or arrow we have to cut the last word and bind it to the markers and arrow so that the icons never occur in one line but are accompanied by the last word of the title.

		if (bMarkers || oControl.getShowTitleSelector() || oControl.getMarkLocked() || oControl.getMarkChanges()) {
			var sOHTitleEnd = sOHTitle.substr(sOHTitle.lastIndexOf(" ") + 1);
			var sOHTitleStart = sOHTitle.substr(0, sOHTitle.lastIndexOf(" ") + 1);

			if (sOHTitleEnd.length === 1) {
				sOHTitleEnd = sOHTitle;
				sOHTitleStart = '';
			}

			oRm.writeEscaped(sOHTitleStart);
			oRm.write("</span>");
			oRm.write("<span");
			oRm.addClass('sapUxAPObjectPageHeaderNowrapMarkers');
			if (oControl.getMarkLocked() || oControl.getMarkChanges()) {
				oRm.addClass('sapUxAPObjectPageHeaderMarks');
			}
			oRm.writeClasses();
			oRm.write(">");
			oRm.writeEscaped(sOHTitleEnd);

			// if someone has set both Locked and Unsaved Changes icons, then show only Locked icon
			if (oControl.getMarkLocked()) {
				this._renderLock(oRm, oControl, bTitleInContent);
			} else if (oControl.getMarkChanges()) {
				this._renderMarkChanges(oRm, oControl, bTitleInContent);
			}

			this._renderMarkers(oRm, oControl);
			this._renderSelectTitleArrow(oRm, oControl, bTitleInContent);
			oRm.write("</span>");
		} else {
			oRm.writeEscaped(sOHTitle);
			oRm.write("</span>");
		}
		oRm.write("</h1>");

		oRm.write("<span");
		oRm.addClass('sapUxAPObjectPageHeaderIdentifierDescription');
		if (oControl.getIsObjectSubtitleAlwaysVisible() && oControl.getObjectSubtitle()) {
			oRm.addClass('sapUxAPObjectPageHeaderIdentifierDescriptionForce');
		}
		if (bTitleInContent) {
			oRm.addClass('sapUxAPObjectPageHeaderIdentifierSubTitleInContent');
		}
		oRm.writeClasses();
		oRm.writeAttributeEscaped("id", oControl.getId() + "-subtitle");
		oRm.write(">");
		oRm.writeEscaped(oControl.getObjectSubtitle());
		oRm.write("</span>");
	};
	/**
	 * Renders the SelectTitleArrow icon.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.m.ObjectHeader}
	 *            oControl the ObjectPageHeader
	 * @param {boolean}
	 *      bTitleInContent - if the arrow will be rendered in content or in title
	 * @private
	 */
	ObjectPageHeaderRenderer._renderSelectTitleArrow = function (oRm, oControl, bTitleInContent) {
		if (oControl.getShowTitleSelector()) { // render select title arrow
			oRm.write("<span"); // Start title arrow container
			oRm.addClass("sapUxAPObjectPageHeaderTitleArrow");
			oRm.writeClasses();
			oRm.write(">");
			if (bTitleInContent) {
				oRm.renderControl(oControl._oTitleArrowIconCont);
			} else {
				oRm.renderControl(oControl._oTitleArrowIcon);
			}
			oRm.write("</span>"); // end title arrow container
		}
	};

	/**
	 * Renders the Unsaved Changes icon.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.uxap.ObjectPageHeader}
	 *            oControl the ObjectPageHeader
	 * @param {boolean}
	 *      bTitleInContent - if the Unsaved changes icon will be rendered in content or in title
	 * @private
	 */
	ObjectPageHeaderRenderer._renderMarkChanges = function (oRm, oControl, bTitleInContent) {
		oRm.write("<span");
		oRm.addClass("sapUxAPObjectPageHeaderChangesBtn");
		oRm.addClass("sapUiSizeCompact");
		oRm.writeClasses();
		oRm.write(">");
		if (bTitleInContent) {
			oRm.renderControl(oControl._oChangesIconCont);
		} else {
			oRm.renderControl(oControl._oChangesIcon);
		}
		oRm.write("</span>");
	};

	/**
	 * Renders the Lock icon.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.uxap.ObjectPageHeader}
	 *            oControl the ObjectPageHeader
	 * @param {boolean}
	 *      bTitleInContent - if the lock will be rendered in content or in title
	 * @private
	 */
	ObjectPageHeaderRenderer._renderLock = function (oRm, oControl, bTitleInContent) {
		oRm.write("<span");
		oRm.addClass("sapUxAPObjectPageHeaderLockBtn");
		oRm.addClass("sapUiSizeCompact");
		oRm.writeClasses();
		oRm.write(">");
		if (bTitleInContent) {
			oRm.renderControl(oControl._oLockIconCont);
		} else {
			oRm.renderControl(oControl._oLockIcon);
		}
		oRm.write("</span>");
	};

	/**
	 * Renders the favorite and flag icons.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.m.ObjectHeader}
	 *            oControl the ObjectPageHeader
	 *
	 * @private
	 */
	ObjectPageHeaderRenderer._renderMarkers = function (oRm, oControl) {
		var aIcons = [];

		// load icons based on control state
		if (oControl.getShowMarkers()) {
			aIcons.push(oControl._oFavIcon);
			aIcons.push(oControl._oFlagIcon);

			this._renderMarkersAria(oRm, oControl); // render hidden aria description of flag and favorite icons

			// render icons
			oRm.write("<span");
			oRm.addClass("sapMObjStatusMarker");

			oRm.writeClasses();
			oRm.writeAttributeEscaped("id", oControl.getId() + "-markers");
			oRm.writeAttributeEscaped("aria-describedby", oControl.getId() + "-markers-aria");

			oRm.write(">");
			for (var i = 0; i < aIcons.length; i++) {
				oRm.renderControl(aIcons[i]);
			}
			oRm.write("</span>");
		}
	};

	/**
	 * Renders hidden div with ARIA descriptions of the favorite and flag icons.
	 *
	 * @param {sap.ui.core.RenderManager}
	 *            oRm the RenderManager that can be used for writing to the render output buffer
	 *
	 * @param {sap.m.ObjectHeader}
	 *            oControl the ObjectPageHeader
	 *
	 * @private
	 */
	ObjectPageHeaderRenderer._renderMarkersAria = function (oRm, oControl) {
		var sAriaDescription = ""; // ARIA description message

		// check if flag mark is set
		if (oControl.getMarkFlagged()) {
			sAriaDescription += (oControl.oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE") + " ");
		}

		// check if favorite mark is set
		if (oControl.getMarkFavorite()) {
			sAriaDescription += (oControl.oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE") + " ");
		}

		// if there is a description render ARIA node
		if (sAriaDescription !== "") {
			// BEGIN ARIA hidden node
			oRm.write("<div");

			oRm.writeAttributeEscaped("id", oControl.getId() + "-markers-aria");
			oRm.writeAttribute("aria-hidden", "false");
			oRm.addClass("sapUiHidden");
			oRm.writeClasses();
			oRm.write(">");
			oRm.writeEscaped(sAriaDescription);

			oRm.write("</div>");
			// END ARIA hidden node
		}
	};


	return ObjectPageHeaderRenderer;

}, /* bExport= */ true);

}; // end of sap/uxap/ObjectPageHeaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.ObjectPageLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/uxap/ObjectPageLayoutRenderer",["sap/ui/core/Renderer", "./ObjectPageHeaderRenderer"],
	function (Renderer, ObjectPageHeaderRenderer) {
		"use strict";

		/**
		 * @class ObjectPageRenderer renderer.
		 * @static
		 */
		var ObjectPageLayoutRenderer = {};

		ObjectPageLayoutRenderer.render = function (oRm, oControl) {
			var aSections,
				oHeader = oControl.getHeaderTitle(),
				oAnchorBar = null;

			if (oControl.getShowAnchorBar() && oControl._getInternalAnchorBarVisible()) {
				oAnchorBar = oControl.getAggregation("_anchorBar");
			}

			oRm.write("<div");
			oRm.writeControlData(oControl);
			if (oHeader) {
				oRm.writeAttributeEscaped("aria-label", oHeader.getObjectTitle());
			}
			oRm.addClass("sapUxAPObjectPageLayout");
			oRm.writeClasses();
			oRm.addStyle("height", oControl.getHeight());
			oRm.writeStyles();
			oRm.write(">");

			// Header
			oRm.write("<header ");
			oRm.writeAttribute("role", "header");
			oRm.writeAttributeEscaped("id", oControl.getId() + "-headerTitle");
			oRm.addClass("sapUxAPObjectPageHeaderTitle");
			oRm.writeClasses();
			oRm.write(">");
			if (oHeader) {
				oRm.renderControl(oHeader);
			}

			this._renderHeaderContentDOM(oRm, oControl, oControl._bHContentAlwaysExpanded, "-stickyHeaderContent");

			// Sticky anchorBar placeholder
			oRm.write("<div ");
			oRm.writeAttributeEscaped("id", oControl.getId() + "-stickyAnchorBar");
			oRm.addClass("sapUxAPObjectPageStickyAnchorBar");
			oRm.addClass("sapUxAPObjectPageNavigation");
			oRm.writeClasses();
			oRm.write(">");

			// if the content is expanded render bars outside the scrolling div
			this._renderAnchorBar(oRm, oControl, oAnchorBar, oControl._bHContentAlwaysExpanded);

			oRm.write("</div>");
			oRm.write("</header>");

			oRm.write("<div ");
			oRm.writeAttributeEscaped("id", oControl.getId() + "-opwrapper");
			oRm.addClass("sapUxAPObjectPageWrapper");
			// set transform only if we don't have title arrow inside the header content, otherwise the z-index is not working
			if (!(oControl.getShowTitleInHeaderContent() && oHeader.getShowTitleSelector())) {
				oRm.addClass("sapUxAPObjectPageWrapperTransform");
			}
			oRm.writeClasses();
			oRm.write(">");

			oRm.write("<div ");
			oRm.writeAttributeEscaped("id", oControl.getId() + "-scroll");
			oRm.addClass("sapUxAPObjectPageScroll");
			oRm.writeClasses();
			oRm.write(">");

			// Header Content
			this._renderHeaderContentDOM(oRm, oControl, !oControl._bHContentAlwaysExpanded, "-headerContent");

			// Anchor Bar
			oRm.write("<section ");
			oRm.writeAttributeEscaped("id", oControl.getId() + "-anchorBar");
			// write ARIA role
			oRm.writeAttribute("role", "navigaiton");
			oRm.addClass("sapUxAPObjectPageNavigation");
			oRm.writeClasses();
			oRm.write(">");

			this._renderAnchorBar(oRm, oControl, oAnchorBar, !oControl._bHContentAlwaysExpanded);

			oRm.write("</section>");

			// Content section
			oRm.write("<section");
			oRm.addClass("sapUxAPObjectPageContainer");
			if (!oAnchorBar) {
				oRm.addClass("sapUxAPObjectPageContainerNoBar");
			}
			oRm.writeClasses();
			oRm.write(">");
			aSections = oControl.getAggregation("sections");
			if (jQuery.isArray(aSections)) {
				jQuery.each(aSections, function (iIndex, oSection) {
					oRm.renderControl(oSection);
				});
			}
			oRm.write("</section>");

			// run hook method
			this.renderFooterContent(oRm, oControl);

			oRm.write("<div");
			oRm.writeAttributeEscaped("id", oControl.getId() + "-spacer");
			oRm.write("></div>");

			oRm.write("</div>");  // END scroll

			oRm.write("</div>"); // END wrapper

			oRm.write("</div>"); // END page
		};

		/**
		 * This method is called to render AnchorBar
		 *
		 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
		 */
		ObjectPageLayoutRenderer._renderAnchorBar = function (oRm, oControl, oAnchorBar, bRender) {
			if (bRender) {
				if (oControl.getIsChildPage()) {
					oRm.write("<div ");
					oRm.writeAttributeEscaped("id", oControl.getId() + "-childPageBar");
					oRm.addClass('sapUxAPObjectChildPage');
					oRm.writeClasses();
					oRm.write("></div>");
				}

				if (oAnchorBar) {
					oRm.renderControl(oAnchorBar);
				}
			}
		};

		/**
		 * This method is called to render header content DOM structure
		 *
		 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
		 * @param bRender - shows if the control should be rendered
		 * @param sId - the id of the div that should be rendered
		 * @param bRenderAlways - shows if the DOM of the control should be rendered no matter if the control is rendered inside or not
		 */
		ObjectPageLayoutRenderer._renderHeaderContentDOM = function (oRm, oControl, bRender, sId) {
			oRm.write("<header ");
			oRm.writeAttributeEscaped("id", oControl.getId() + sId);
			oRm.addClass("ui-helper-clearfix");
			oRm.addClass("sapUxAPObjectPageHeaderDetails");
			oRm.addClass("sapUxAPObjectPageHeaderDetailsDesign-" + oControl._getHeaderDesign());
			oRm.writeClasses();
			oRm.writeAttribute("data-sap-ui-customfastnavgroup", true);
			oRm.write(">");
			// render Header Content control
			if (bRender) {
				this.renderHeaderContent(oRm, oControl);
			}
			oRm.write("</header>");
		};

		/**
		 * This hook method is called to render objectpagelayout header content
		 *
		 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
		 */
		ObjectPageLayoutRenderer.renderHeaderContent = function (oRm, oControl) {
			oRm.renderControl(oControl._getHeaderContent());
		};

		/**
		 * This hook method is called to render objectpagelayout footer content
		 *
		 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
		 */
		ObjectPageLayoutRenderer.renderFooterContent = function (oRm, oControl) {
		};


		/**
		 * This method is called to rerender headerContent
		 *
		 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
		 */
		ObjectPageLayoutRenderer._rerenderHeaderContentArea = function (oRm, oControl) {
			var sId = oControl.getId();
			this.renderHeaderContent(oRm, oControl);
			oRm.flush(jQuery.sap.byId(sId + "-headerContent")[0]);
		};


		return ObjectPageLayoutRenderer;

	}, /* bExport= */ true);

}; // end of sap/uxap/ObjectPageLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderContentRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.uxap.ObjectPageHeaderContentRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/uxap/ObjectPageHeaderContentRenderer",["./ObjectPageHeaderRenderer", "./ObjectPageLayout"], function (ObjectPageHeaderRenderer, ObjectPageLayout) {
	"use strict";

	/**
	 * @class HeaderContent renderer.
	 * @static
	 */
	var ObjectPageHeaderContentRenderer = {};

	ObjectPageHeaderContentRenderer.render = function (oRm, oControl) {
		var oParent = oControl.getParent(),
			bParentLayout = (oParent instanceof ObjectPageLayout),
			oHeader = (oParent && bParentLayout) ? oParent.getHeaderTitle() : false,
			bRenderTitle = (oParent && bParentLayout) ? ((oParent instanceof ObjectPageLayout)
			&& oParent.getShowTitleInHeaderContent()) : false,
			bRenderEditBtn = bParentLayout && oParent.getShowEditHeaderButton();

		if (bRenderEditBtn) {
			oRm.write("<div ");
			oRm.addClass("sapUxAPObjectPageHeaderContentFlexBox");
			oRm.addClass("sapUxAPObjectPageHeaderContentDesign-" + oControl.getContentDesign());
			oRm.writeClasses();
			oRm.write(">");
		}
		oRm.write("<div ");
		oRm.writeControlData(oControl);
		if (bRenderEditBtn) {
			oRm.addClass("sapUxAPObjectPageHeaderContentCellLeft");
		} else {
			oRm.addClass("sapUxAPObjectPageHeaderContentDesign-" + oControl.getContentDesign());
		}
		oRm.addClass("ui-helper-clearfix");
		oRm.addClass("sapUxAPObjectPageHeaderContent");

		if (!oControl.getVisible()) {
			oRm.addClass("sapUxAPObjectPageHeaderContentHidden");
		}
		oRm.writeClasses();
		oRm.write(">");

		if (bParentLayout && oParent.getIsChildPage()) {
			oRm.write("<div");
			oRm.addClass('sapUxAPObjectChildPage');
			oRm.writeClasses();
			oRm.write("></div>");
		}

		if (bRenderTitle) {
			this._renderTitleImage(oRm, oHeader);

			if (oControl.getContent().length == 0) {
				oRm.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");
				this._renderTitle(oRm, oHeader);
				oRm.write("</span>");
			}
		}

		oControl.getContent().forEach(function (oItem, iIndex) {
			this._renderHeaderContent(oItem, iIndex, oRm, bRenderTitle, oHeader, oControl);
		}, this);

		oRm.write("</div>");

		if (bRenderEditBtn) {
			this._renderEditButton(oRm, oControl);

			oRm.write("</div>"); // end of "sapUxAPObjectPageHeaderContentFlexBox" div
		}
	};

	/**
	 * This method is called to render the content
	 * @param {*} oHeaderContent header content
	 * @param {*} iIndex index
	 * @param {*} oRm oRm
	 * @param {*} bRenderTitle render title
	 * @param {*} oHeader header
	 * @param {*} oControl control
	 */
	ObjectPageHeaderContentRenderer._renderHeaderContent = function (oHeaderContent, iIndex, oRm, bRenderTitle, oHeader, oControl) {
		var bHasSeparatorBefore = false,
			bHasSeparatorAfter = false,
			oLayoutData = oControl._getLayoutDataForControl(oHeaderContent),
			bIsFirstControl = iIndex === 0,
			bIsLastControl = iIndex === (oControl.getContent().length - 1);

		if (oLayoutData) {
			bHasSeparatorBefore = oLayoutData.getShowSeparatorBefore();
			bHasSeparatorAfter = oLayoutData.getShowSeparatorAfter();

			oRm.write("<span ");
			oRm.addClass("sapUxAPObjectPageHeaderWidthContainer");
			oRm.addClass("sapUxAPObjectPageHeaderContentItem");
			oRm.addStyle("width", oLayoutData.getWidth());
			oRm.writeStyles();

			if (bHasSeparatorAfter || bHasSeparatorBefore) {
				oRm.addClass("sapUxAPObjectPageHeaderSeparatorContainer");
			}

			if (!oLayoutData.getVisibleL()) {
				oRm.addClass("sapUxAPObjectPageHeaderLayoutHiddenL");
			}
			if (!oLayoutData.getVisibleM()) {
				oRm.addClass("sapUxAPObjectPageHeaderLayoutHiddenM");
			}
			if (!oLayoutData.getVisibleS()) {
				oRm.addClass("sapUxAPObjectPageHeaderLayoutHiddenS");
			}

			oRm.writeClasses();
			oRm.write(">");

			if (bHasSeparatorBefore) {
				oRm.write("<span class=\"sapUxAPObjectPageHeaderSeparatorBefore\"/>");
			}

			if (bIsFirstControl && bRenderTitle) { // render title inside the first contentItem
				this._renderTitle(oRm, oHeader);
			}
		} else {
			if (bIsFirstControl && bRenderTitle) { // render title inside the first contentItem
				oRm.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");
				this._renderTitle(oRm, oHeader);
			} else {
				oHeaderContent.addStyleClass("sapUxAPObjectPageHeaderContentItem");
			}
		}

		oRm.renderControl(oHeaderContent);

		if (bHasSeparatorAfter) {
			oRm.write("<span class=\"sapUxAPObjectPageHeaderSeparatorAfter\"/>");
		}

		if (oLayoutData || (bIsFirstControl && bRenderTitle) || bIsLastControl) {
			oRm.write("</span>");
		}
	};

	/**
	 * This method is called to render title and all it's parts if the property showTitleInHeaderContent is set to true
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 * @param {sap.ui.core.Control} oHeader an object representation of the titleHeader that should be rendered
	 */
	ObjectPageHeaderContentRenderer._renderTitleImage = function (oRm, oHeader) {

		if (oHeader.getObjectImageURI() || oHeader.getShowPlaceholder()) {
			oRm.write("<span");
			oRm.addClass("sapUxAPObjectPageHeaderContentImageContainer");
			oRm.addClass("sapUxAPObjectPageHeaderObjectImage-" + oHeader.getObjectImageShape());
			oRm.writeClasses();
			oRm.write(">");

			if (oHeader.getObjectImageURI()) {
				oRm.renderControl(oHeader._getInternalAggregation("_objectImage"));
				if (oHeader.getShowPlaceholder()) {
					ObjectPageHeaderRenderer._renderPlaceholder(oRm, oHeader, false);
				}
			} else {
				ObjectPageHeaderRenderer._renderPlaceholder(oRm, oHeader, true);
			}

			oRm.write("</span>");
		}
	};

	/**
	 * This method is called to render title and all it's parts if the property showTitleInHeaderContent is set to true
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oHeader an object representation of the control that should be rendered
	 */
	ObjectPageHeaderContentRenderer._renderTitle = function (oRm, oHeader) {
		ObjectPageHeaderRenderer._renderObjectPageTitle(oRm, oHeader, true); // force title to be visible inside the content header
	};

	/**
	 * This method is called to render the Edit button when the property showEditHeaderButton is set to true
	 *
	 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
	 * @param {sap.ui.core.Control} oHeader an object representation of the control that should be rendered
	 */
	ObjectPageHeaderContentRenderer._renderEditButton = function (oRm, oHeader) {
		oRm.write("<div class=\"sapUxAPObjectPageHeaderContentCellRight\">");
		oRm.renderControl(oHeader.getAggregation("_editHeaderButton"));
		oRm.write("</div>");
	};

	return ObjectPageHeaderContentRenderer;

}, /* bExport= */ true);

}; // end of sap/uxap/ObjectPageHeaderContentRenderer.js
