/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./InputBase','./MaskInputRule','sap/ui/core/Control'],function(q,I,M,C){"use strict";var a=I.extend("sap.m.MaskInput",{metadata:{library:"sap.m",properties:{placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"}}}});a.prototype.init=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;s.call(this);h.call(this);};a.prototype.exit=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;};a.prototype.onBeforeRendering=function(){var V=c.call(this);if(V){q.sap.log.warning("Invalid mask input: "+V);}I.prototype.onBeforeRendering.apply(this,arguments);};a.prototype.onAfterRendering=function(){I.prototype.onAfterRendering.apply(this,arguments);};a.prototype.onfocusin=function(i){this._sOldInputValue=this._getInputValue();I.prototype.onfocusin.apply(this,arguments);if(!this._oTempValue.differsFromOriginal()||!A.call(this,this._sOldInputValue)){j.call(this);}z.call(this,true);};a.prototype.onfocusout=function(i){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);q(document).off('.sapMIBtouchstart');if(this.bRenderingPhase){return;}this.closeValueStateMessage();u.call(this);};a.prototype.oninput=function(i){I.prototype.oninput.apply(this,arguments);j.call(this);z.call(this,false);};a.prototype.onkeypress=function(i){o.call(this,i);};a.prototype.onkeydown=function(i){var K=y(i),L=sap.ui.Device.browser;var N=(K.bBackspace||K.bDelete)&&L.msie&&L.version<10;if(!N){I.prototype.onkeydown.apply(this,arguments);}p.call(this,i,K);};a.prototype.onsapenter=function(i){};a.prototype.onsapfocusleave=function(i){};a.prototype.addAggregation=function(i,O,S){if(i==="rules"){if(!v.call(this,O)){return this;}r.call(this,O.getMaskFormatSymbol());C.prototype.addAggregation.apply(this,arguments);h.call(this);return this;}else{return C.prototype.addAggregation.apply(this,arguments);}};a.prototype.insertAggregation=function(i,O,K,S){if(i==="rules"){if(!v.call(this,O)){return this;}r.call(this,O.getMaskFormatSymbol());C.prototype.insertAggregation.apply(this,arguments);h.call(this);return this;}else{return C.prototype.insertAggregation.apply(this,arguments);}};function v(R){if(new RegExp(R.getRegex()).test(this.getPlaceholderSymbol())){q.sap.log.error("Rejecting input mask rule because it includes the currently set placeholder symbol.");return false;}return true;}a.prototype.setPlaceholderSymbol=function(S){var i=false;if(!/^.$/i.test(S)){q.sap.log.error("Invalid placeholder symbol string given");return this;}i=this.getRules().some(function(R){return new RegExp(R.getRegex()).test(S);});if(i){q.sap.log.error("Rejecting placeholder symbol because it is included as a regex in an existing mask input rule.");}else{this.setProperty("placeholderSymbol",S);h.call(this);}return this;};a.prototype.setMask=function(i){if(!i){var K="Setting an empty mask is pointless. Make sure you set it with a non-empty value.";q.sap.log.warning(K);return this;}this.setProperty("mask",i,true);h.call(this);return this;};a.prototype._isCharAllowed=function(i,K){return this._oRules.applyCharAt(i,K);};a.prototype._feedReplaceChar=function(i,P,K){return i;};var b=function(i){this._aInitial=i.slice(0);this._aContent=i;};b.prototype.setCharAt=function(i,P){this._aContent[P]=i;};b.prototype.charAt=function(P){return this._aContent[P];};b.prototype.toString=function(){return this._aContent.join('');};b.prototype.differsFromOriginal=function(){return this.differsFrom(this._aInitial);};b.prototype.differsFrom=function(V){var i=0;if(V.length!==this._aContent.length){return true;}for(i=0;i<V.length;i++){if(V[i]!==this._aContent[i]){return true;}}return false;};b.prototype.getSize=function(){return this._aContent.length;};var T=function(R){this._aRules=R;};T.prototype.nextTo=function(i){var P=i;if(typeof P==="undefined"){P=-1;}do{P++;}while(P<this._aRules.length&&!this._aRules[P]);return P;};T.prototype.previousTo=function(i){var P=i;do{P--;}while(!this._aRules[P]&&P>0);return P;};T.prototype.hasRuleAt=function(i){return!!this._aRules[i];};T.prototype.applyCharAt=function(i,K){return this._aRules[K].test(i);};function s(){this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"a",regex:"[A-Za-z]"}));this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"9",regex:"[0-9]"}));}function c(){var P=this.getPlaceholderSymbol(),R=this.getRules(),i=[],K=[];if(!this.getMask()){K.push("Empty mask");}if(R.length){i=[];R.every(function(L){var N=L.getMaskFormatSymbol(),O=N!==P,Q;Q=!i.some(function(S){return N===S;});i.push(N);if(!O){K.push("Placeholder symbol is the  same as the existing rule's mask format symbol");}if(!Q){K.push("Duplicated rule's maskFormatSymbol ["+N+"]");}return O&&Q;});}return K.length?K.join(". "):null;}function r(S){var i=f(S,this.getRules());if(i){this.removeAggregation('rules',i.oRule);}}function f(i,R){var K=null;if(typeof i!=="string"||i.length!==1){q.sap.log.error(i+" is not a valid mask rule symbol");return null;}q.each(R,function(L,N){if(N.getMaskFormatSymbol()===i){K={oRule:N,iIndex:L};return false;}});return K;}function g(){var _=q(this.getFocusDomRef());if(!_&&(_.length===0||_.is(":hidden"))){return;}return{iFrom:_[0].selectionStart,iTo:_[0].selectionEnd,bHasSelection:(_[0].selectionEnd-_[0].selectionStart!==0)};}function d(P){var _=q(this.getFocusDomRef());return _.cursorPos(P);}function e(){var _=q(this.getFocusDomRef());return _.cursorPos();}function h(){var R=this.getRules(),i=this.getMask(),K=i.split(""),P=this.getPlaceholderSymbol();var V=w(K,P,R);this._oTempValue=new b(V);var L=x(K,R);this._iMaskLength=L.length;this._oRules=new T(L);this._iUserInputStartPosition=this._oRules.nextTo();}function j(){var i=this._getInputValue();if(!this.getEditable()){return;}l.call(this,i);}function k(i,K){var L,P=this.getPlaceholderSymbol();if(typeof i==="undefined"||i===null){i=0;K=this._oTempValue.getSize()-1;}for(L=i;L<=K;L++){if(this._oRules.hasRuleAt(L)){this._oTempValue.setCharAt(P,L);}}}function l(i){n.call(this,i);this.updateDomValue(this._oTempValue.toString());}function m(){return this._oTempValue.toString().indexOf(this.getPlaceholderSymbol());}function n(i){var K,L=0,N,P=this.getPlaceholderSymbol(),O;for(N=0;N<this._iMaskLength;N++){if(this._oRules.hasRuleAt(N)){this._oTempValue.setCharAt(P,N);O=false;if(i.length){do{K=i.charAt(L);L++;if(this._oRules.applyCharAt(K,N)){this._oTempValue.setCharAt(K,N);O=true;}}while(!O&&(L<i.length));}if(!O){k.call(this,N+1,this._iMaskLength-1);break;}}else{if(this._oTempValue.charAt(N)===i.charAt(L)){L++;}}}}function o(i){if(!this.getEditable()){return;}var S=g.call(this),P,K,L=y(i);if(L.bCtrlKey||L.bAltKey||L.bMetaKey||L.bBeforeSpace){return;}if(!L.bEnter&&!L.bShiftLeftOrRightArrow&&!L.bHome&&!L.bEnd&&!(L.bShift&&L.bDelete)&&!(L.bCtrlKey&&L.bInsert)&&!(L.bShift&&L.bInsert)){if(S.bHasSelection){k.call(this,S.iFrom,S.iTo-1);this.updateDomValue(this._oTempValue.toString());d.call(this,Math.max(this._iUserInputStartPosition,S.iFrom));}P=this._oRules.nextTo(S.iFrom-1);if(P<this._iMaskLength){K=this._feedReplaceChar(L.sChar,P,this._getInputValue());t.call(this,K,P);}i.preventDefault();}}a.prototype.oncut=function(i){var S=g.call(this),K=S.iFrom,L=S.iTo;I.prototype.oncut.call(this,i);if(!S.bHasSelection){return;}L=L-1;k.call(this,K,L);q.sap.delayedCall(0,this,function updateDomAndCursor(V,P,O){this._oTempValue._aContent=O;this.updateDomValue(V);q.sap.delayedCall(0,this,d,[P]);},[this._oTempValue.toString(),Math.max(this._iUserInputStartPosition,K),this._oTempValue._aContent.slice(0)]);};function p(i,K){var L,S,N,O,P,Q,K=K||y(i);if(!this.getEditable()){return;}if(!K.bShift&&(K.bArrowRight||K.bArrowLeft)){P=e.call(this);S=g.call(this);L=H.call(this,K,S);if(F.call(this)&&S.bHasSelection){Q=J.call(this,L);}else{Q=this._oRules[L](P);}if(G.call(this)){Q=D.call(this,Q,L);}d.call(this,Q);i.preventDefault();}else if(K.bEscape){l.call(this,this._sOldInputValue);z.call(this,true);i.preventDefault();}else if(K.bEnter){u.call(this,i);}else if((K.bCtrlKey&&K.bInsert)||(K.bShift&&K.bInsert)){I.prototype.onkeydown.apply(this,arguments);}else if((!K.bShift&&K.bDelete)||K.bBackspace){S=g.call(this);N=S.iFrom;O=S.iTo;if(!S.bHasSelection){if(K.bBackspace){N=this._oRules.previousTo(N);}}if(K.bBackspace||(K.bDelete&&S.bHasSelection)){O=O-1;}k.call(this,N,O);this.updateDomValue(this._oTempValue.toString());d.call(this,Math.max(this._iUserInputStartPosition,N));i.preventDefault();}}function t(N,P){var i,K=false,L=N.split(""),O;while(L.length){O=L.splice(0,1)[0];if(this._oRules.applyCharAt(O,P)){K=true;this._oTempValue.setCharAt(O,P);P=this._oRules.nextTo(P);}}if(K){i=P;this.updateDomValue(this._oTempValue.toString());d.call(this,i);}}function u(){var N=this._getInputValue(),i,V,K,L;if(this._oTempValue.differsFrom(N)){l.call(this,N);}i=this._oTempValue.differsFromOriginal();V=i?this._oTempValue.toString():"";K=!this._sOldInputValue;L=!N;if(K&&(L||!i)){this.updateDomValue("");return;}if(this._sOldInputValue!==this._oTempValue.toString()){this.setValue(V);if(this.onChange&&!this.onChange({value:V})){this.fireChangeEvent(V);}}}function w(i,P,R){return i.map(function(K,L){return f(K,R)?P:K;});}function x(i,R){var K=[];q.each(i,function(L,N){var S=f(N,R);K.push(S?new RegExp(S.oRule.getRegex()):null);});return K;}function y(i){var P=i.which||i.keyCode,K=q.sap.KeyCodes,L=P===K.ARROW_RIGHT,N=P===K.ARROW_LEFT,S=i.shiftKey;return{iCode:P,sChar:String.fromCharCode(P),bCtrlKey:i.ctrlKey,bAltKey:i.altKey,bMetaKey:i.metaKey,bShift:S,bInsert:P===q.sap.KeyCodes.INSERT,bBackspace:P===K.BACKSPACE,bDelete:P===K.DELETE,bEscape:P===K.ESCAPE,bEnter:P===K.ENTER,bIphoneEscape:(sap.ui.Device.system.phone&&sap.ui.Device.os.ios&&P===127),bArrowRight:L,bArrowLeft:N,bHome:P===q.sap.KeyCodes.HOME,bEnd:P===q.sap.KeyCodes.END,bShiftLeftOrRightArrow:S&&(N||L),bBeforeSpace:P<K.SPACE};}function z(S){var i=this.getMask(),K;clearTimeout(this._iCaretTimeoutId);K=m.call(this);if(K<0){K=i.length;}this._iCaretTimeoutId=q.sap.delayedCall(0,this,function(){if(this.getFocusDomRef()!==document.activeElement){return;}if(S&&(K===(i.length))){this.selectText(0,K);}else{d.call(this,K);}});}function A(K){var L=K.length;for(var i=0;i<L;i++){var N=K[i];if(this._oRules.hasRuleAt(i)&&(!this._oRules.applyCharAt(N,i)&&N!==this.getPlaceholderSymbol())){return false;}if(!this._oRules.hasRuleAt(i)&&N!==this._oTempValue.charAt(i)){return false;}}return true;}function B(S){var i='A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF'+'\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF',K='\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC',L=new RegExp('^[^'+i+']*['+K+']');return L.test(S);}function D(i,K){if(!G.call(this)){return i;}var N=i;if(K==='nextTo'){if(i===0){N=0;}if(i===this._oTempValue.toString().length){N=0;}if(i===1){N=0;}if(i===this._oTempValue.toString().length+1){N=1;}}else{if(i===this._oTempValue.toString().length){N=this._oTempValue.toString().length-1;}if(i===0){N=this._oTempValue.toString().length;}if(i===this._oTempValue.toString().length-1){N=this._oTempValue.toString().length;}if(i===-1){N=this._oTempValue.toString().length-1;}}return N;}function E(){var K=this._oTempValue.toString(),L=false;for(var i=0;i<K.length;i++){L=B(K[i]);}return L;}function F(){return sap.ui.getCore().getConfiguration().getRTL()||(this.getTextDirection()===sap.ui.core.TextDirection.RTL);}function G(){return(sap.ui.Device.browser.webkit&&F.call(this)&&!E.call(this));}function H(K,S){var i;if(!F.call(this)||!E.call(this)||S.bHasSelection){if(K.bArrowRight){i='nextTo';}else{i='previousTo';}}else{if(K.bArrowRight){i='previousTo';}else{i='nextTo';}}return i;}function J(i,W){var N,S=g.call(this);if(W){if(i==='nextTo'){if(!E.call(this)){N=S.iFrom;}else{N=S.iTo;}}else{if(!E.call(this)){N=S.iTo;}else{N=S.iFrom;}}}else{if(i==='nextTo'){if(!E.call(this)){N=S.iTo;}else{N=S.iFrom;}}else{if(!E.call(this)){N=S.iFrom;}else{N=S.iTo;}}}return N;}return a;},true);
