/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control'],function(q,C){"use strict";var B=C.extend("sap.ui.layout.BlockLayoutRow",{metadata:{library:"sap.ui.layout",properties:{scrollable:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"content"}}}});B.CONSTANTS={maxScrollableCellsPerRow:10,minScrollableCellsPerRow:3,guidelineRatios:[0.25,0.5,0.75,1.0]};B.prototype.onBeforeRendering=function(){this._checkGuidelinesAndUpdateCells();};B.prototype._checkGuidelinesAndUpdateCells=function(){var t=this,c=this.getContent(),a=this._calcCellRatios(),d=this._checkDifferentSBreakpointCase(),g=this._guidelinesCheck();c.forEach(function(b,i){b._clearState();if(t.getScrollable()){b._setParentRowScrollable(true);}else if(d&&g){b._setDifferentSBreakpointSize(true,a[i]);}});if(!this.getScrollable()&&d&&g){this._rowSCase=true;this.addStyleClass("sapUiBlockRowSCase",true);}else{this._rowSCase=false;this.removeStyleClass("sapUiBlockRowSCase",true);}};B.prototype._guidelinesCheck=function(){if(this.getScrollable()){return this._checkScrollableCellsCount();}else{return this._checkNonScrollableGuidelines();}};B.prototype._calcCellRatios=function(){var c=[],t=0,a=this.getContent();a.forEach(function(b){var d=(b.getWidth()==0)?1:b.getWidth();t+=d;});a.forEach(function(b){var d=(b.getWidth()==0)?1:b.getWidth(),e=d/t;c.push(e);});return c;};B.prototype._checkNonScrollableGuidelines=function(){var t=this,c=this._calcCellRatios(),g=true;c.forEach(function(a){if(!t._isCellRatioIncluded(a)){g=false;}});if(!g){q.sap.log.error("In your BlockLayoutRow "+this.getId()+" you are using cell ratios that are "+"not recommended in the guidelines. Cells can be with width of 25% 50% 75% or 100% according to the guidelines.");}return g;};B.prototype._checkDifferentSBreakpointCase=function(){var c=this._calcCellRatios(),a=this.getContent();if(a.length==4||(a.length==3&&c[1]!=0.5)){return true;}return false;};B.prototype._isCellRatioIncluded=function(r){var g=B.CONSTANTS.guidelineRatios;for(var i=0;i<g.length;i++){if(g[i]===r){return true;}}return false;};B.prototype._checkScrollableCellsCount=function(){if(this.getContent().length>B.CONSTANTS.maxScrollableCellsPerRow){q.sap.log.error("You are using too much cells in your scrollable row: "+this.getId()+"."+"This is violating the BlockLayout guidelines, please consider changing your implementation. Max cells allowed: 10.");return false;}if(this.getContent().length<B.CONSTANTS.minScrollableCellsPerRow){q.sap.log.error("You are using not enough cells in your scrollable row: "+this.getId()+"."+"This is violating the BlockLayout guidelines, please consider changing your implementation. Min cells allowed: 3.");return false;}return true;};return B;},true);
