jQuery.sap.declare('sap.uxap.library-all');if(!jQuery.sap.isDeclared('sap.uxap.BlockBaseMetadata')){
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.uxap.BlockBaseMetadata');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.ElementMetadata');sap.ui.define("sap/uxap/BlockBaseMetadata",["jquery.sap.global","sap/ui/core/ElementMetadata"],function(q,E){"use strict";var B=function(c,C){E.apply(this,arguments);this._mViews=C.metadata.views||{};};B.prototype=q.sap.newObject(E.prototype);B.prototype.applySettings=function(c){var r=c.hasOwnProperty("renderer")?(c.renderer||""):undefined;E.prototype.applySettings.call(this,c);if(r==null){this._sRendererName=null;}};B.prototype.getRendererName=function(){if(!this._sBlockRenderer){this._sBlockRenderer=this._resolveRendererName();q.sap.log.debug("BlockBaseMetadata :: "+this.getName()+" is renderer with "+this._sBlockRenderer);}return this._sBlockRenderer;};B.prototype._resolveRendererName=function(){var c=E.prototype.getRendererName.call(this);if(c==null){var p=this.getParent();if(p){c=B.prototype._resolveRendererName.apply(p);}else{throw new Error("BlockBaseMetadata :: no renderer found for "+this.getName());}}return c;};B.prototype.getView=function(v){return this._mViews[v];};B.prototype.getViews=function(){return this._mViews;};B.prototype.setView=function(v,V){this._mViews[v]=V;return this;};B.prototype.hasViews=function(){return!q.isEmptyObject(this._mViews);};return B;},true);};if(!jQuery.sap.isDeclared('sap.uxap.BlockBaseRenderer')){jQuery.sap.declare('sap.uxap.BlockBaseRenderer');sap.ui.define("sap/uxap/BlockBaseRenderer",function(){"use strict";var B={};B.render=function(r,c){if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);if(c._getSelectedViewContent()){r.addClass('sapUxAPBlockBase');r.addClass("sapUxAPBlockBase"+c.getMode());}else{var C=c.getMetadata().getName().split(".").pop();r.addClass('sapUxAPBlockBaseDefaultSize');r.addClass('sapUxAPBlockBaseDefaultSize'+C+c.getMode());}r.writeClasses();r.write(">");if(c._getSelectedViewContent()){r.renderControl(c._getSelectedViewContent());}r.write("</div>");};return B;},true);};if(!jQuery.sap.isDeclared('sap.uxap.BreadCrumbsRenderer')){jQuery.sap.declare('sap.uxap.BreadCrumbsRenderer');sap.ui.define("sap/uxap/BreadCrumbsRenderer",function(){"use strict";var B={};B.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUxAPBreadCrumbs");r.writeClasses();r.writeAttribute("role","navigation");r.writeAttributeEscaped("aria-labelledby",c._getAriaLabelledBy().getId());r.write(">");this._renderOverflowSelect(r,c);if(!c._bOnPhone){this._renderBreadcrumbTrail(r,c);}r.write("</div>");};B._renderBreadcrumbTrail=function(r,c){var l=c.getLinks(),C=c.getCurrentLocation(),t=c._getTubeIcon(),s=c.getShowCurrentLocation();r.write("<ul id='"+c.getId()+"-breadcrumbs'");r.write(">");l.forEach(function(L){r.write("<li>");r.renderControl(L);r.renderControl(t);r.write("</li>");});if(s){r.write("<li>");r.renderControl(C);r.write("</li>");}r.write("</ul>");};B._renderOverflowSelect=function(r,c){var t=c._getTubeIcon();r.write("<div id='"+c.getId()+"-select'");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.write('<span class="sapUxAPBreadCrumbsDots">...</span>');r.renderControl(t);r.renderControl(c._getOverflowSelect());r.write("</div>");};return B;},true);};if(!jQuery.sap.isDeclared('sap.uxap.HierarchicalSelectRenderer')){jQuery.sap.declare('sap.uxap.HierarchicalSelectRenderer');jQuery.sap.require('sap.m.SelectRenderer');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/uxap/HierarchicalSelectRenderer",["sap/m/SelectRenderer","sap/ui/core/Renderer"],function(S,R){"use strict";var H=R.extend(S);H.addStyleClass=function(r){r.addClass("sapUxAPHierarchicalSelect");};return H;},true);};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderActionButtonRenderer')){jQuery.sap.declare('sap.uxap.ObjectPageHeaderActionButtonRenderer');jQuery.sap.require('sap.m.ButtonRenderer');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/uxap/ObjectPageHeaderActionButtonRenderer",["sap/m/ButtonRenderer","sap/ui/core/Renderer"],function(B,R){"use strict";var O=R.extend(B);return O;},true);};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageLayout.designtime')){jQuery.sap.declare('sap.uxap.ObjectPageLayout.designtime');sap.ui.define("sap/uxap/ObjectPageLayout.designtime",[],function(){"use strict";return{aggregations:{sections:{domRef:":sap-domref > .sapUxAPObjectPageWrapper"}},cloneDomRef:":sap-domref > header"};},false);};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageSectionRenderer')){jQuery.sap.declare('sap.uxap.ObjectPageSectionRenderer');sap.ui.define("sap/uxap/ObjectPageSectionRenderer",function(){"use strict";var O={};O.render=function(r,c){if(!c.getVisible()||!c._getInternalVisible()){return;}var t=c._getInternalTitle()?c._getInternalTitle():c.getTitle();r.write("<section ");r.addClass("sapUxAPObjectPageSection");r.writeClasses();r.writeAttribute("role","region");r.writeAttributeEscaped("aria-labelledby",c.getAggregation("ariaLabelledBy").getId());r.writeControlData(c);r.write(">");if(c.getShowTitle()&&c._getInternalTitleVisible()){r.write("<div");r.writeAttribute("role","heading");r.writeAttributeEscaped("id",c.getId()+"-header");r.addClass("sapUxAPObjectPageSectionHeader");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-title");r.addClass("sapUxAPObjectPageSectionTitle");if(c.getTitleUppercase()){r.addClass("sapUxAPObjectPageSectionTitleUppercase");}r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div>");r.renderControl(c._getShowHideAllButton());r.renderControl(c._getShowHideButton());r.write("</div>");}r.write("<div");r.addClass("sapUxAPObjectPageSectionContainer");r.writeClasses();r.write(">");c.getSubSections().forEach(r.renderControl);r.write("</div>");r.write("</section>");};return O;},true);};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageSubSectionRenderer')){jQuery.sap.declare('sap.uxap.ObjectPageSubSectionRenderer');sap.ui.define("sap/uxap/ObjectPageSubSectionRenderer",function(){"use strict";var O={};O.render=function(r,c){var a,h,H,b;if(!c.getVisible()||!c._getInternalVisible()){return;}a=c.getActions()||[];b=a.length>0;h=(c._getInternalTitleVisible()&&(c.getTitle().trim()!==""));H=h||b;r.write("<div ");r.writeAttribute("role","region");r.writeControlData(c);r.addClass("sapUxAPObjectPageSubSection");r.writeClasses(c);r.writeClasses();r.write(">");if(H){r.write("<div");r.addClass("sapUxAPObjectPageSubSectionHeader");r.writeAttributeEscaped("id",c.getId()+"-header");r.writeClasses();r.write(">");r.write("<div");if(h){r.writeAttribute("role","heading");}r.addClass('sapUxAPObjectPageSubSectionHeaderTitle');if(c.getTitleUppercase()){r.addClass("sapUxAPObjectPageSubSectionHeaderTitleUppercase");}r.writeAttributeEscaped("id",c.getId()+"-headerTitle");r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);if(h){r.writeAttribute("tabindex",0);}r.write(">");if(h){r.writeEscaped(c.getTitle());}r.write("</div>");if(b){r.write("<div");r.addClass('sapUxAPObjectPageSubSectionHeaderActions');r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");a.forEach(r.renderControl);r.write("</div>");}r.write("</div>");}r.write("<div");r.addClass("ui-helper-clearfix");r.addClass("sapUxAPBlockContainer");r.addClass("sapUiResponsiveMargin");r.writeClasses();r.write(">");r.renderControl(c._getGrid());r.write("<div");r.addClass("sapUxAPSubSectionSeeMoreContainer");r.writeClasses();r.write(">");r.renderControl(c._getSeeMoreButton());r.write("</div>");r.write("</div>");r.write("</div>");};return O;},true);};if(!jQuery.sap.isDeclared('sap.uxap.component.Component')){jQuery.sap.declare('sap.uxap.component.Component');jQuery.sap.require('sap.uxap.ObjectPageConfigurationMode');jQuery.sap.require('sap.ui.core.UIComponent');jQuery.sap.require('sap.ui.model.json.JSONModel');jQuery.sap.require('sap.ui.core.Component');sap.ui.define("sap/uxap/component/Component",["sap/uxap/ObjectPageConfigurationMode","sap/ui/core/UIComponent","sap/ui/model/json/JSONModel","sap/ui/core/Component"],function(O,U,J){"use strict";var C=U.extend("sap.uxap.component.Component",{metadata:{},init:function(){this._oModel=null;this._oViewConfig={viewData:{component:this}};switch(this.oComponentData.mode){case O.JsonURL:this._oModel=new U(this.oComponentData.jsonConfigurationURL);this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=sap.ui.core.mvc.ViewType.XML;break;case O.JsonModel:this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=sap.ui.core.mvc.ViewType.XML;break;default:jQuery.sap.log.error("UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation");}U.prototype.init.call(this);},createContent:function(){var c;this._oView=sap.ui.view(this._oViewConfig);if(this._oModel){c=this._oView.getController();if(c&&c.connectToComponent){c.connectToComponent(this._oModel);}this._oView.setModel(this._oModel,"objectPageLayoutMetadata");}return this._oView;},propagateProperties:function(n){if(this.oComponentData.mode===O.JsonModel){var c=this._oView.getController();if(c&&c.connectToComponent){c.connectToComponent(this.getModel("objectPageLayoutMetadata"));}}return U.prototype.propagateProperties.apply(this,arguments);},destroy:function(){if(this._oView){this._oView.destroy();this._oView=null;}if(this._oModel){this._oModel.destroy();this._oModel=null;}if(U.prototype.destroy){U.prototype.destroy.call(this);}}});return C;});};if(!jQuery.sap.isDeclared('sap.uxap.component.ObjectPageComponentContainer')){jQuery.sap.declare('sap.uxap.component.ObjectPageComponentContainer');jQuery.sap.require('sap.ui.core.ComponentContainer');jQuery.sap.require('sap.uxap.ObjectPageConfigurationMode');jQuery.sap.require('sap.ui.core.Component');sap.ui.define("sap/uxap/component/ObjectPageComponentContainer",['sap/ui/core/ComponentContainer','sap/uxap/ObjectPageConfigurationMode',"sap/ui/core/Component"],function(C,O){"use strict";var a=C.extend("sap.uxap.component.ObjectPageComponentContainer",{metadata:{properties:{"jsonConfigurationURL":{type:"string",group:"Behavior"},"mode":{type:"sap.uxap.ObjectPageConfigurationMode",group:"Behavior"}}},init:function(){this.setPropagateModel(true);this.setName("sap.uxap.component");},onBeforeRendering:function(){this._oComponent=sap.ui.component("sap.uxap");if(!this._oComponent){this._oComponent=sap.ui.component({name:this.getName(),url:this.getUrl(),componentData:{jsonConfigurationURL:this.getJsonConfigurationURL(),mode:this.getMode()}});this.setComponent(this._oComponent,true);}if(C.prototype.onBeforeRendering){C.prototype.onBeforeRendering.call(this);}},getObjectPageLayoutInstance:function(){var o=null;if(this._oComponent&&this._oComponent._oView){o=this._oComponent._oView.byId("ObjectPageLayout");}else{jQuery.sap.log.error("ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?");}return o;},renderer:"sap.ui.core.ComponentContainerRenderer"});return a;});};if(!jQuery.sap.isDeclared('sap.uxap.library')){jQuery.sap.declare('sap.uxap.library');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Core');jQuery.sap.require('sap.ui.core.library');jQuery.sap.require('sap.m.library');jQuery.sap.require('sap.ui.layout.library');sap.ui.define("sap/uxap/library",["jquery.sap.global","sap/ui/core/Core","sap/ui/core/library","sap/m/library","sap/ui/layout/library"],function(q,C,l){"use strict";sap.ui.getCore().initLibrary({name:"sap.uxap",dependencies:["sap.ui.core","sap.m","sap.ui.layout"],types:["sap.uxap.BlockBaseColumnLayout","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],interfaces:[],controls:["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],elements:["sap.uxap.ModelMapping","sap.uxap.ObjectPageHeaderLayoutData"],version:"1.34.6"});sap.uxap.BlockBaseColumnLayout=sap.ui.base.DataType.createType('sap.uxap.BlockBaseColumnLayout',{isValid:function(v){return/^(auto|[1-4]{1})$/.test(v);}},sap.ui.base.DataType.getType('string'));sap.uxap.BlockBaseFormAdjustment={BlockColumns:"BlockColumns",OneColumn:"OneColumn",None:"None"};sap.uxap.ObjectPageConfigurationMode={JsonURL:"JsonURL",JsonModel:"JsonModel"};sap.uxap.ObjectPageHeaderDesign={Light:"Light",Dark:"Dark"};sap.uxap.ObjectPageHeaderPictureShape={Circle:"Circle",Square:"Square"};sap.uxap.ObjectPageSubSectionLayout={TitleOnTop:"TitleOnTop",TitleOnLeft:"TitleOnLeft"};sap.uxap.ObjectPageSubSectionMode={Collapsed:"Collapsed",Expanded:"Expanded"};sap.uxap.Importance={Low:"Low",Medium:"Medium",High:"High"};sap.uxap.i18nModel=(function(){return new sap.ui.model.resource.ResourceModel({bundleUrl:q.sap.getModulePath("sap.uxap.i18n.i18n",".properties")});}());sap.uxap.Utilities={getClosestOPL:function(c){while(c&&c.getMetadata().getName()!=="sap.uxap.ObjectPageLayout"){c=c.getParent();}return c;},isPhoneScenario:function(){if(sap.ui.Device.system.phone){return true;}return sap.uxap.Utilities._isCurrentMediaSize("Phone");},isTabletScenario:function(){if(sap.ui.Device.system.tablet){return true;}return sap.uxap.Utilities._isCurrentMediaSize("Tablet");},_isCurrentMediaSize:function(m){if(sap.ui.Device.media.hasRangeSet(sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED)){var r=sap.ui.Device.media.getCurrentRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED);if(r&&r.name===m){return true;}}return q("html").hasClass("sapUiMedia-Std-"+m);}};return sap.uxap;},true);};if(!jQuery.sap.isDeclared('sap.uxap.AnchorBarRenderer')){jQuery.sap.declare('sap.uxap.AnchorBarRenderer');jQuery.sap.require('sap.m.ToolbarRenderer');jQuery.sap.require('sap.ui.core.Renderer');jQuery.sap.require('sap.m.BarInPageEnabler');sap.ui.define("sap/uxap/AnchorBarRenderer",["sap/m/ToolbarRenderer","sap/ui/core/Renderer","sap/m/BarInPageEnabler","./library"],function(T,R,B,l){"use strict";var A=R.extend(T);A.renderBarContent=function(r,t){if(t._bHasButtonsBar){r.renderControl(t._getScrollArrowLeft());r.write("<div");r.writeAttributeEscaped("id",t.getId()+"-scrollContainer");r.writeAttributeEscaped("aria-label",l.i18nModel.getResourceBundle().getText("ANCHOR_BAR_LABEL"));r.addClass("sapUxAPAnchorBarScrollContainer");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",t.getId()+"-scroll");r.write(">");T.renderBarContent.apply(this,arguments);r.write("</div>");r.write("</div>");r.renderControl(t._getScrollArrowRight());}B.addChildClassTo(t._oSelect,t);r.renderControl(t._oSelect);};return A;},true);};if(!jQuery.sap.isDeclared('sap.uxap.BreadCrumbs')){jQuery.sap.declare('sap.uxap.BreadCrumbs');jQuery.sap.require('sap.m.Link');jQuery.sap.require('sap.m.Select');jQuery.sap.require('sap.m.Text');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.ResizeHandler');jQuery.sap.require('sap.ui.core.delegate.ItemNavigation');jQuery.sap.require('sap.ui.core.Item');jQuery.sap.require('sap.ui.core.Icon');jQuery.sap.require('sap.ui.Device');sap.ui.define("sap/uxap/BreadCrumbs",["sap/m/Link","sap/m/Select","sap/m/Text","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/Device","./library"],function(L,S,T,C,R,I,a,b,D,l){"use strict";var B=C.extend("sap.uxap.BreadCrumbs",{metadata:{library:"sap.uxap",properties:{showCurrentLocation:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"links",aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},currentLocation:{type:"sap.m.Text",multiple:false},_tubeIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowSelect:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}}});B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;B.prototype.init=function(){this._iREMSize=parseInt(jQuery("body").css("font-size"),10);this._iContainerMaxHeight=this._iREMSize*2;};B.prototype.onBeforeRendering=function(){this._bOnPhone=D.system.phone;this._resetControl();};B.prototype.onAfterRendering=function(){this._handleInitialModeSelection();};B.prototype._handleInitialModeSelection=function(){if(this._bOnPhone){this._setSelectVisible(true);return this;}this._configureKeyboardHandling();if(!this._iContainerHeight){this._iContainerHeight=this.$().outerHeight();}if(this._iContainerHeight>this._iContainerMaxHeight){this._toggleOverflowMode(true);return this;}this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};B.prototype._toggleOverflowMode=function(u){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}this._setSelectVisible(u);this._setBreadcrumbsVisible(!u);this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};B.prototype._getTubeIcon=function(){if(!this.getAggregation("_tubeIcon")){this.setAggregation("_tubeIcon",new b({"src":"sap-icon://slim-arrow-right","color":"#bfbfbf","size":"1rem","useIconTooltip":false}).addStyleClass("sapUxAPTubeIcon"));}return this.getAggregation("_tubeIcon");};B.prototype._getOverflowSelect=function(){var o,s;if(!this.getAggregation("_overflowSelect")){s=this.getLinks().reverse()||[];s.unshift(this.getCurrentLocation());o=new S({items:s.map(this._createSelectItem),autoAdjustWidth:true});o.attachChange(this._overflowSelectChangeHandler);this.setAggregation("_overflowSelect",o);}return this.getAggregation("_overflowSelect");};B.prototype._createSelectItem=function(i){return new a({key:i.getId(),text:i.getText()});};B.prototype._overflowSelectChangeHandler=function(e){var s=e.getParameter("selectedItem").getKey(),c=sap.ui.getCore().byId(s),d,f;if(c instanceof L){d=c.getHref();c.firePress();if(d){f=c.getTarget();if(f){window.open(d,f);}else{window.location.href=d;}}}return this;};B.prototype._handleScreenResize=function(e){var s=this._shouldOverflow(),u=this._getUsingOverflowSelect();if(s&&!u){this._toggleOverflowMode(true);}else if(!s&&u){this._toggleOverflowMode(false);}return this;};B.prototype._shouldOverflow=function(){var $=this._getBreadcrumbsAsJQueryObject(),s,u=this._getUsingOverflowSelect();if(u){this._setBreadcrumbsVisible(true);}$.addClass("sapUxAPInvisible");s=$.outerHeight()>this._iContainerMaxHeight;$.removeClass("sapUxAPInvisible");if(u){this._setBreadcrumbsVisible(false);}return s;};B.prototype._getBreadcrumbsAsJQueryObject=function(){if(!this._$breadcrumbs){this._$breadcurmbs=this.$("breadcrumbs");}return this._$breadcurmbs;};B.prototype._getOverflowSelectAsJQueryObject=function(){if(!this._$select){this._$select=this.$("select");}return this._$select;};B.prototype._setBreadcrumbsVisible=function(v){var $=this.$(),c=this._getBreadcrumbsAsJQueryObject(),f="sapUxAPFullWidth",s="sapUiHidden";if(v){c.removeClass(s);$.removeClass(f);}else{c.addClass(s);$.addClass(f);}return $;};B.prototype._setSelectVisible=function(v){var $=this._getOverflowSelectAsJQueryObject(),s="sapUiHidden";if(v){$.removeClass(s);}else{$.addClass(s);}return this;};B.prototype._resetControl=function(){this._iContainerHeight=null;this._$select=null;this._$breadcrumbs=null;this.setAggregation("_overflowSelect",null,true);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}return this;};B.prototype._getAriaLabelledBy=function(){if(!this._oAriaLabelledBy){B.prototype._oAriaLabelledBy=new sap.ui.core.InvisibleText({text:l.i18nModel.getResourceBundle().getText("BREADCRUMB_TRAIL_LABEL")}).toStatic();}return this._oAriaLabelledBy;};B.prototype._getItemNavigation=function(){if(!this._ItemNavigation){this._ItemNavigation=new I();}return this._ItemNavigation;};B.prototype._getItemsToNavigate=function(){var i=this.getLinks(),c=this.getCurrentLocation(),s=this.getShowCurrentLocation();if(s&&c){i.push(c);}return i;};B.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),h=this._getBreadcrumbsAsJQueryObject()[0],s=-1,c=this._getItemsToNavigate(),n=[];c.forEach(function(o){o.$().attr("tabIndex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setCycling(false);i.setRootDomRef(h);i.setItemDomRefs(n);i.setSelectedIndex(s);this._getBreadcrumbsAsJQueryObject().attr("tabindex","-1");c[0].$().attr("tabindex","0");return this;};B.prototype.onsappageup=function(e){this._handlePageKeys(e,false);};B.prototype.onsappagedown=function(e){this._handlePageKeys(e,true);};B.prototype._handlePageKeys=function(e,m){var n,c=this._getItemsToNavigate(),E=0,i=m?c.length-1:0;e.preventDefault();c.some(function(o,d){if(o.getId()===e.target.id){E=d;return true;}});if(m){n=E+B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}else{n=E-B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}if(n&&c[n]){c[n].focus();}else if(c[i]){c[i].focus();}};B.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden");};B.prototype.exit=function(){if(this._ItemNavigation){this.removeDelegate(this._ItemNavigation);this._ItemNavigation.destroy();this._ItemNavigation=null;}this._resetControl();};return B;});};if(!jQuery.sap.isDeclared('sap.uxap.HierarchicalSelect')){jQuery.sap.declare('sap.uxap.HierarchicalSelect');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.m.Select');jQuery.sap.require('sap.ui.Device');sap.ui.define("sap/uxap/HierarchicalSelect",["jquery.sap.global","sap/m/Select","sap/ui/Device","./library"],function(q,S,D,l){"use strict";var H=S.extend("sap.uxap.HierarchicalSelect",{metadata:{library:"sap.uxap",properties:{upperCase:{type:"boolean",group:"Appearance",defaultValue:false}}}});H.POPOVER_MIN_WIDTH_REM=11;H.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var i=this.getItems()||[];i.forEach(function(I){var c=(I.data("secondLevel")===true)?"sapUxAPHierarchicalSelectSecondLevel":"sapUxAPHierarchicalSelectFirstLevel";I.$().addClass(c);},this);};H.prototype.setUpperCase=function(v,s){this.setProperty("upperCase",v,s);this.toggleStyleClass("sapUxAPHierarchicalSelectUpperCase",v);var p=this.getAggregation("picker");if(p){p.toggleStyleClass("sapMSltPickerFirstLevelUpperCase",v);if(!s){p.invalidate();}}return this;};H.prototype.onsapenter=S.prototype.onsapspace;["onsapup","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(n){H.prototype[n]=function(e){S.prototype[n].call(this,e);e.stopPropagation();};});H.prototype._createDialog=function(){var d=S.prototype._createDialog.call(this);d.getCustomHeader().addStyleClass("sapUxAPHierarchicalSelect");return d;};H.prototype._decoratePopover=function(p){S.prototype._decoratePopover.call(this,p);p._adaptPositionParams=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["end bottom","end center","end top","begin center"];this._atPositions=["end top","end center","end bottom","begin center"];};if(D.system.tablet||D.system.desktop){var r=q.position.scrollbarWidth();if(r>0){p.setOffsetX(r);}}};H.prototype._onAfterRenderingPopover=function(){S.prototype._onAfterRenderingPopover.call(this);if(D.system.tablet||D.system.desktop){var p=this.getPicker(),m=p.getDomRef().style.minWidth;if(q.sap.endsWith(m,"rem")){m=m.substring(0,m.length-3);var M=parseFloat(m);if(M<H.POPOVER_MIN_WIDTH_REM){p._setMinWidth(H.POPOVER_MIN_WIDTH_REM+"rem");}}}};return H;});};if(!jQuery.sap.isDeclared('sap.uxap.ModelMapping')){jQuery.sap.declare('sap.uxap.ModelMapping');jQuery.sap.require('sap.ui.core.Element');sap.ui.define("sap/uxap/ModelMapping",["sap/ui/core/Element","./library"],function(E,l){"use strict";var M=E.extend("sap.uxap.ModelMapping",{metadata:{library:"sap.uxap",properties:{externalModelName:{type:"string",group:"Misc",defaultValue:null},internalModelName:{type:"string",group:"Misc",defaultValue:"Model"},externalPath:{type:"string",group:"Misc",defaultValue:null}}}});return M;});};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderActionButton')){jQuery.sap.declare('sap.uxap.ObjectPageHeaderActionButton');jQuery.sap.require('sap.m.Button');sap.ui.define("sap/uxap/ObjectPageHeaderActionButton",["sap/m/Button","./library"],function(B,l){"use strict";var O=B.extend("sap.uxap.ObjectPageHeaderActionButton",{metadata:{library:"sap.uxap",properties:{hideText:{type:"boolean",defaultValue:true},hideIcon:{type:"boolean",defaultValue:false},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}}}});O.prototype.applySettings=function(s,S){if(B.prototype.applySettings){B.prototype.applySettings.call(this,s,S);}this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",this.getHideText());this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",this.getHideIcon());};O.prototype.setHideText=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",v);return this.setProperty("hideText",v,i);};O.prototype.setHideIcon=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",v);return this.setProperty("hideIcon",v,i);};return O;});};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderContent')){jQuery.sap.declare('sap.uxap.ObjectPageHeaderContent');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.m.Button');sap.ui.define("sap/uxap/ObjectPageHeaderContent",["sap/ui/core/Control","./library","sap/m/Button"],function(C,l,B){"use strict";var O=C.extend("sap.uxap.ObjectPageHeaderContent",{metadata:{library:"sap.uxap",properties:{contentDesign:{type:"sap.uxap.ObjectPageHeaderDesign",group:"Misc",defaultValue:sap.uxap.ObjectPageHeaderDesign.Light}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_editHeaderButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}}});O.prototype.onBeforeRendering=function(){var p=this.getParent();if(p&&(p instanceof l.ObjectPageLayout)&&p.getShowEditHeaderButton()){this._getInternalBtnAggregation("_editHeaderButton","EDIT_HEADER","-editHeaderBtn","Transparent").attachPress(this._handleEditHeaderButtonPress,this);}};O.prototype._handleEditHeaderButtonPress=function(e){this.getParent().fireEditHeaderButtonPress();};O.prototype._getInternalBtnAggregation=function(a,b,s,c){if(!this.getAggregation(a)){var o=new B({text:l.i18nModel.getResourceBundle().getText(b),type:c,id:this.getId()+s});this.setAggregation(a,o);}return this.getAggregation(a);};O.prototype._getLayoutDataForControl=function(c){var L=c.getLayoutData();if(!L){return;}else if(L instanceof l.ObjectPageHeaderLayoutData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var a=L.getMultipleLayoutData();for(var i=0;i<a.length;i++){var o=a[i];if(o instanceof l.ObjectPageHeaderLayoutData){return o;}}}};return O;});};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderLayoutData')){jQuery.sap.declare('sap.uxap.ObjectPageHeaderLayoutData');jQuery.sap.require('sap.ui.core.LayoutData');sap.ui.define("sap/uxap/ObjectPageHeaderLayoutData",["sap/ui/core/LayoutData","./library"],function(L,l){"use strict";var O=L.extend("sap.uxap.ObjectPageHeaderLayoutData",{metadata:{library:"sap.uxap",properties:{visibleS:{type:"boolean",group:"Misc",defaultValue:true},visibleM:{type:"boolean",group:"Misc",defaultValue:true},visibleL:{type:"boolean",group:"Misc",defaultValue:true},showSeparatorBefore:{type:"boolean",group:"Misc",defaultValue:false},showSeparatorAfter:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'}}}});return O;});};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageSectionBase')){jQuery.sap.declare('sap.uxap.ObjectPageSectionBase');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.Control');sap.ui.define("sap/uxap/ObjectPageSectionBase",["jquery.sap.global","sap/ui/core/Control","./library"],function(q,C,l){"use strict";var O=C.extend("sap.uxap.ObjectPageSectionBase",{metadata:{"abstract":true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},aggregations:{customAnchorBarButton:{type:"sap.m.Button",multiple:false}}}});O.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._isHidden=false;this._oParentObjectPageLayout=undefined;};O.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._adjustLayout();this._getObjectPageLayout()._setSectionsFocusValues();}};O.prototype._setInternalVisible=function(v,i){if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};O.prototype._getInternalVisible=function(){return this._bInternalVisible;};O.prototype._setInternalTitleVisible=function(v,i){if(v!=this._bInternalTitleVisible){this._bInternalTitleVisible=v;if(i){this.invalidate();}}};O.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible;};O.prototype._setInternalTitle=function(v,i){if(v!=this._sInternalTitle){this._sInternalTitle=v;if(i){this.invalidate();}}};O.prototype._getInternalTitle=function(){return this._sInternalTitle;};O.prototype._getObjectPageLayout=function(){if(!this._oParentObjectPageLayout){this._oParentObjectPageLayout=l.Utilities.getClosestOPL(this);}return this._oParentObjectPageLayout;};O.prototype._notifyObjectPageLayout=function(){if(this.$().length&&this._getObjectPageLayout()){this._getObjectPageLayout()._adjustLayoutAndUxRules();}};["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(m){O.prototype[m]=function(){var r=C.prototype[m].apply(this,arguments);this._notifyObjectPageLayout();return r;};});O.prototype.setVisible=function(v,s){if(!this._getObjectPageLayout()){return this.setProperty("visible",v,s);}this.setProperty("visible",v,true);this._getObjectPageLayout()._adjustLayoutAndUxRules();this.invalidate();return this;};O.prototype.setTitle=function(v,s){this.setProperty("title",v,s);this._notifyObjectPageLayout();return this;};O.prototype._shouldBeHidden=function(){return O._importanceMap[this.getImportance()]>O._importanceMap[this._sCurrentLowestImportanceLevelToShow];};O._importanceMap={"Low":3,"Medium":2,"High":1};O.prototype._updateShowHideState=function(h){var o=this._getObjectPageLayout();this._isHidden=h;this.$().children(this._sContainerSelector).toggle(!h);if(o){o._adjustLayout();}return this;};O.prototype._getIsHidden=function(){return this._isHidden;};O.prototype._expandSection=function(){return this._updateShowHideState(false);};O.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden());};O.prototype._applyImportanceRules=function(c){this._sCurrentLowestImportanceLevelToShow=c;this._updateShowHideState(this._shouldBeHidden());};O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;O.prototype.onkeydown=function(e){if(e.keyCode===q.sap.KeyCodes.F7){var s=this.getSubSections(),f=s[0],L;if(s.length===1){L=f._oLastFocusedControlF7;if(L){L.$().focus();}else{f.$().firstFocusableDomRef().focus();}}else{if(f.getActions().length){f.getActions()[0].$().focus();}}}};O.prototype.onsapdown=function(e){this._handleFocusing(e,e.currentTarget.nextSibling);};O.prototype._handleFocusing=function(e,E){if(this._targetIsCorrect(e)&&E){e.preventDefault();E.focus();this._scrollParent(q(E).attr("id"));}};O.prototype._targetIsCorrect=function(e){return e.srcControl===this;};O.prototype.onsapright=O.prototype.onsapdown;O.prototype.onsapup=function(e){this._handleFocusing(e,e.currentTarget.previousSibling);};O.prototype.onsapleft=O.prototype.onsapup;O.prototype.onsaphome=function(e){this._handleFocusing(e,e.currentTarget.parentElement.firstChild);};O.prototype.onsapend=function(e){this._handleFocusing(e,e.currentTarget.parentElement.lastChild);};O.prototype.onsappageup=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S-(O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[0]){s[0].focus();f=q(s[0]).attr("id");}this._scrollParent(f);};O.prototype.onsappagedown=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S+O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[s.length-1]){s[s.length-1].focus();f=q(s[s.length-1]).attr("id");}this._scrollParent(f);};O.prototype._scrollParent=function(i){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(i,0,10);}};return O;});};if(!jQuery.sap.isDeclared('sap.uxap.AnchorBar')){jQuery.sap.declare('sap.uxap.AnchorBar');jQuery.sap.require('sap.m.Button');jQuery.sap.require('sap.m.PlacementType');jQuery.sap.require('sap.m.Popover');jQuery.sap.require('sap.m.Toolbar');jQuery.sap.require('sap.ui.core.IconPool');jQuery.sap.require('sap.ui.core.Item');jQuery.sap.require('sap.ui.core.ResizeHandler');jQuery.sap.require('sap.ui.core.delegate.ScrollEnablement');jQuery.sap.require('sap.ui.layout.HorizontalLayout');jQuery.sap.require('sap.ui.Device');jQuery.sap.require('sap.ui.core.CustomData');sap.ui.define("sap/uxap/AnchorBar",["sap/m/Button","sap/m/PlacementType","sap/m/Popover","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","./HierarchicalSelect","./library"],function(B,P,a,T,I,b,R,S,H,D,C,c,l){"use strict";var A=T.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_popovers:{type:"sap.m.Popover",multiple:true,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});A.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._bRtlScenario=sap.ui.getCore().getConfiguration().getRTL()&&!D.browser.msie;this._bHasButtonsBar=D.system.tablet||D.system.desktop;this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=parseInt(jQuery("body").css("font-size"),10);this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3;this._sResizeListenerId=undefined;}this.setDesign("Transparent");};A.SCROLL_STEP=250;A.SCROLL_DURATION=500;A.prototype.setSelectedButton=function(o){if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o){if(o.getId()===this.getSelectedButton()){return;}var s=o.data("sectionId");if(s){this._oSelect.setSelectedKey(o.getId());}if(this._bHasButtonsBar){this.$().find(".sapUxAPAnchorBarButtonSelected").removeClass("sapUxAPAnchorBarButtonSelected");o.$().addClass("sapUxAPAnchorBarButtonSelected");if(s){this.scrollToSection(s,A.SCROLL_DURATION);}this._setAnchorButtonsTabFocusValues(o);}}return this.setAssociation("selectedButton",o,true);};A.prototype.setShowPopover=function(v,s){if(this.getShowPopover()===v){return this;}var d,n=!jQuery.isEmptyObject(this._oPressHandlers);if(n){var e=this.getContent()||[];d=this.getSelectedButton();e.forEach(this._detachPopoverHandler,this);}this.setProperty("showPopover",v,true);if(n){this.rerender();if(d){this.setSelectedButton(d);}}return this;};A.prototype.getSelectedSection=function(){var s=this.getSelectedButton();if(s&&(typeof(s)==="string")){s=sap.ui.getCore().byId(s);}if(s&&(s instanceof B)&&s.data("sectionId")){return sap.ui.getCore().byId(s.data("sectionId"));}return null;};A.prototype.onBeforeRendering=function(){if(T.prototype.onBeforeRendering){T.prototype.onBeforeRendering.call(this);}var d=this.getContent()||[],u=this.getUpperCase(),p={oLastFirstLevelButton:null,oCurrentPopover:null};this._oSelect.removeAllItems();this._oSelect.setUpperCase(u);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",u);d.forEach(function(o){this._createSelectItem(o);if(this._bHasButtonsBar){this._createPopoverSubMenu(o,p);}},this);};A.prototype.addContent=function(o,i){o.addStyleClass("sapUxAPAnchorBarButton");o.removeAllAriaDescribedBy();if(this._bHasButtonsBar&&(o.data("secondLevel")===true||o.data("secondLevel")==="true")){o.attachPress(this._handleDirectScroll,this);}return this.addAggregation("content",o,i);};A.prototype._createSelectItem=function(o){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true";if(o.getText().trim()!=""&&(!i||o.data("bTitleVisible")===true)){var p=new b({key:o.getId(),text:o.getText(),customData:[new C({key:"secondLevel",value:o.data("secondLevel")})]});this._oSelect.addItem(p);}};A.prototype._createPopoverSubMenu=function(o,p){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true",f=null;if(i){if(p.oLastFirstLevelButton&&p.oCurrentPopover){if(!this._oPressHandlers[p.oLastFirstLevelButton.getId()]){f=jQuery.proxy(this._handlePopover,{oCurrentPopover:p.oCurrentPopover,oLastFirstLevelButton:p.oLastFirstLevelButton});p.oLastFirstLevelButton.attachPress(f);this._oPressHandlers[p.oLastFirstLevelButton.getId()]=f;}p.oCurrentPopover.addContent(o);}else if(this.getShowPopover()){jQuery.sap.log.error("sapUxApAnchorBar :: missing parent first level for item "+o.getText());}else{this.removeContent(o);}}else{p.oLastFirstLevelButton=o;if(this.getShowPopover()){p.oCurrentPopover=new a({placement:P.Bottom,showHeader:false,verticalScrolling:true,horizontalScrolling:false,contentWidth:"auto",showArrow:false});p.oCurrentPopover.addStyleClass("sapUxAPAnchorBarPopover");this._addKeyboardHandling(p.oCurrentPopover);this.addAggregation('_popovers',p.oCurrentPopover);}else if(!this._oPressHandlers[p.oLastFirstLevelButton.getId()]){f=jQuery.proxy(this._handleDirectScroll,this);p.oLastFirstLevelButton.attachPress(f);this._oPressHandlers[p.oLastFirstLevelButton.getId()]=f;}}};A.prototype._addKeyboardHandling=function(o){o.onsapdown=function(e){if(e.target.nextSibling){e.target.nextSibling.focus();}};o.onsapright=function(e){o.onsapdown(e);};o.onsapup=function(e){if(e.target.previousSibling){e.target.previousSibling.focus();}};o.onsapleft=function(e){o.onsapup(e);};o.onsaphome=function(e){if(e.target.parentElement.firstChild){e.target.parentElement.firstChild.focus();}};o.onsapend=function(e){if(e.target.parentElement.lastChild){e.target.parentElement.lastChild.focus();}};o.onsappageup=this._handlePageUp.bind(o);o.onsappagedown=this._handlePageDown.bind(o);};A.prototype._detachPopoverHandler=function(o){if(this._oPressHandlers[o.getId()]){o.detachPress(this._oPressHandlers[o.getId()]);this._oPressHandlers[o.getId()]=null;}};A.prototype._handlePopover=function(e){var p=this.oCurrentPopover.getContent()||[];if(this.oLastFirstLevelButton.$().is(":visible")){if(p.length==1){p[0].firePress({});}else{this.oCurrentPopover.openBy(this.oLastFirstLevelButton);}}};A.prototype._handleDirectScroll=function(e){if(e.getSource().getParent()instanceof a){e.getSource().getParent().close();}this._requestScrollToSection(e.getSource().data("sectionId"));};A.prototype._requestScrollToSection=function(r){var o=sap.ui.getCore().byId(r),d=o.getParent();if(this.getParent()instanceof l.ObjectPageLayout){var n=r;if(o instanceof l.ObjectPageSubSection&&d instanceof l.ObjectPageSection){n=d.getId();}this.getParent().setDirectScrollingToSection(n);this.getParent().scrollToSection(o.getId());}if(o instanceof l.ObjectPageSubSection&&d instanceof l.ObjectPageSection){d.setAssociation("selectedSubSection",o,true);}};A.prototype._onSelectChange=function(e){var s=e.getParameter("selectedItem"),o;o=sap.ui.getCore().byId(s.getKey());if(o){this._requestScrollToSection(o.data("sectionId"));}else{jQuery.sap.log.error("AnchorBar :: cannot find corresponding button",s.getKey());}};A.prototype._getHierarchicalSelect=function(){if(!this.getAggregation('_select')){this.setAggregation('_select',new c({width:"100%",icon:"sap-icon://slim-arrow-down",change:jQuery.proxy(this._onSelectChange,this)}));}return this.getAggregation('_select');};A.prototype._createScrollArrow=function(L){var s,i,d,o,t=this;if(L){s=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";d="anchorBarArrowLeft";}else{s=this.getId()+"-arrowScrollRight";i="slim-arrow-right";d="anchorBarArrowRight";}o=new B(s,{icon:I.getIconURI(i),type:"Transparent",press:function(e){e.preventDefault();t._handleScrollButtonTap(L);}});o.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().getConfiguration().getTheme()!="sap_hcb"){this.$().attr("tabindex",-1);}},onThemeChanged:function(){if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",-1);}}},o);return new H({content:[o]}).addStyleClass("anchorBarArrow").addStyleClass(d);};A.prototype._getScrollArrowLeft=function(){var s=this.getAggregation("_scrollArrowLeft");if(s){return s;}else{s=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",s);return s;}};A.prototype._getScrollArrowRight=function(){var s=this.getAggregation("_scrollArrowRight");if(s){return s;}else{s=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",s);return s;}};A._hierarchicalSelectModes={"Icon":"icon","Text":"text"};A.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===A._hierarchicalSelectModes.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(sap.m.SelectType.IconOnly);this._computeBarSectionsInfo();}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(sap.m.SelectType.Default);}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===A._hierarchicalSelectModes.Icon);};A.prototype._adjustSize=function(){var n=l.Utilities.isPhoneScenario()?A._hierarchicalSelectModes.Text:A._hierarchicalSelectModes.Icon;if(n!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=n;this._applyHierarchicalSelectMode();}if(this._sHierarchicalSelectMode===A._hierarchicalSelectModes.Icon){if(this._iMaxPosition<0){return;}var $=this.$(),d=$.find(".sapUxAPAnchorBarScrollContainer"),N,e,i;i=d.width();if(this._bRtlScenario){if(D.browser.firefox){e=Math.abs(d.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);N=Math.abs(d.scrollLeft())>=this._iTolerance;}else{e=Math.abs(d.scrollLeft())>=this._iTolerance;N=Math.abs(d.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);}}else{e=d.scrollLeft()+i<(this._iMaxPosition-this._iTolerance);N=d.scrollLeft()>=this._iTolerance;}jQuery.sap.log.debug("AnchorBar :: scrolled at "+d.scrollLeft(),"scrollBegin ["+(N?"true":"false")+"] scrollEnd ["+(e?"true":"false")+"]");$.toggleClass("sapUxAPAnchorBarScrollLeft",N);$.toggleClass("sapUxAPAnchorBarScrollRight",e);}};A.prototype._handleScrollButtonTap=function(s){var i=((!this._bRtlScenario&&s)||(this._bRtlScenario&&!s))?-1:1;this._oScroller.scrollTo(this._iMaxPosition*i,0,A.SCROLL_DURATION*3);};A.prototype.scrollToSection=function(i,d){if(this._bHasButtonsBar){var e=d||A.SCROLL_DURATION,s;if((this._sHierarchicalSelectMode===A._hierarchicalSelectModes.Icon)&&this._oSectionInfo[i]){if(this._bRtlScenario&&D.browser.firefox){s=this._oSectionInfo[i].scrollLeft+this._iOffset;}else{s=this._oSectionInfo[i].scrollLeft-this._iOffset;if(s<0){s=0;}}jQuery.sap.log.debug("AnchorBar :: scrolling to section "+i+" of "+s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){jQuery.sap.clearDelayedCall(this._iCurrentScrollTimeout);jQuery.sap.byId(this.getId()+"-scroll").parent().stop(true,false);}this._iCurrentScrollTimeout=jQuery.sap.delayedCall(d,this,function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;});this._oScroller.scrollTo(s,0,e);}}else{jQuery.sap.log.debug("AnchorBar :: no need to scroll to "+i);}}};A.prototype.getScrollDelegate=function(){return this._oScroller;};A.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;A.prototype.onsapdown=function(e){e.preventDefault();if(e.target.nextSibling){e.target.nextSibling.focus();}};A.prototype.onsapright=function(e){this.onsapdown(e);};A.prototype.onsapup=function(e){e.preventDefault();if(e.target.previousSibling){e.target.previousSibling.focus();}};A.prototype.onsapleft=function(e){this.onsapup(e);};A.prototype.onsaphome=function(e){e.preventDefault();if(e.target.parentElement.firstChild){e.target.parentElement.firstChild.focus();}};A.prototype.onsapend=function(e){e.preventDefault();if(e.target.parentElement.lastChild){e.target.parentElement.lastChild.focus();}};A.prototype.onsappageup=function(e){this._handlePageUp(e);};A.prototype.onsappagedown=function(e){this._handlePageDown(e);};A.prototype._handlePageUp=function(e){e.preventDefault();var n;var d=this.getContent();d.forEach(function(o,i){if(o.getId()===e.target.id){n=i-(A.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&d[n]){d[n].focus();}else if(d[0]){d[0].focus();}};A.prototype._handlePageDown=function(e){e.preventDefault();var n;var d=this.getContent();d.forEach(function(o,i){if(o.getId()===e.target.id){n=i+A.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&d[n]){d[n].focus();}else if(d[d.length-1]){d[d.length-1].focus();}};A.prototype._setAnchorButtonsTabFocusValues=function(s){var d=this.getContent()||[],$,f='0',n='-1',t="tabIndex";d.forEach(function(o){$=o.$();if(o.sId===s.sId){$.attr(t,f);}else{$.attr(t,n);}});};A.prototype.onsapskipforward=function(e){this._handleGroupNavigation(e,false);};A.prototype._handleGroupNavigation=function(e,s){var E=jQuery.Event("keydown"),o={},d=this.getParent().getSections(),f=[this.getDomRef()],g;d.forEach(function(h){g=h.getSubSections().map(function(i){return i.$().attr("tabindex",-1)[0];});f=f.concat(g);});o.scope=f;e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=jQuery.sap.KeyCodes.F6;E.shiftKey=s;jQuery.sap.handleF6GroupNavigation(E,o);};A.prototype.onAfterRendering=function(){if(T.prototype.onAfterRendering){T.prototype.onAfterRendering.call(this);}this._sHierarchicalSelectMode=A._hierarchicalSelectModes.Text;this._iMaxPosition=-1;this._sResizeListenerId=R.register(this,jQuery.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").scroll(jQuery.proxy(this._onScroll,this));if(this.getSelectedButton()){this.setSelectedButton(this.getSelectedButton());}if(this._bHasButtonsBar){this._adjustSize();}};A.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=jQuery.sap.delayedCall(A.SCROLL_DURATION,this,function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize();});}};A.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var d=this.getContent()||[];d.forEach(this._computeNextSectionInfo,this);if(this._bRtlScenario&&(D.browser.webkit||D.browser.firefox)){d.forEach(this._adjustNextSectionInfo,this);this._oScroller.scrollTo(this._iMaxPosition,0,0);}};A.prototype._computeNextSectionInfo=function(o){if(o.data("bHasSubMenu")){o.$().attr("aria-haspopup","true");}o.$().attr("aria-controls",o.data("sectionId"));var w=o.$().outerWidth(true);this._oSectionInfo[o.data("sectionId")]={scrollLeft:this._iMaxPosition,width:w};this._iMaxPosition+=w;};A.prototype._adjustNextSectionInfo=function(o){var s=this._oSectionInfo[o.data("sectionId")];if(D.browser.firefox){s.scrollLeft=-s.scrollLeft;}else{s.scrollLeft=this._iMaxPosition-s.scrollLeft-s.width;}};A.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}};return A;});};if(!jQuery.sap.isDeclared('sap.uxap.BlockBase')){jQuery.sap.declare('sap.uxap.BlockBase');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.CustomData');jQuery.sap.require('sap.ui.model.Context');jQuery.sap.require('sap.ui.Device');jQuery.sap.require('sap.ui.layout.form.ResponsiveGridLayout');sap.ui.define("sap/uxap/BlockBase",["sap/ui/core/Control","sap/ui/core/CustomData","./BlockBaseMetadata","./ModelMapping","sap/ui/model/Context","sap/ui/Device","sap/ui/layout/form/ResponsiveGridLayout","./library"],function(C,a,B,M,b,D,R,l){"use strict";var c=C.extend("sap.uxap.BlockBase",{metadata:{library:"sap.uxap",properties:{"mode":{type:"string",group:"Appearance"},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"columnLayout":{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},"formAdjustment":{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:sap.uxap.BlockBaseFormAdjustment.BlockColumns},"showSubSectionMore":{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{"mappings":{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},"_views":{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{"selectedView":{type:"sap.ui.core.Control",multiple:false}},views:{}},renderer:"sap.uxap.BlockBaseRenderer"},B);c.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"});}this._oMappingApplied={};this._bLazyLoading=false;this._bConnected=false;this._oUpdatedModels={};};c.prototype.onBeforeRendering=function(){if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML");}else{jQuery.sap.log.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.");}}this._applyFormAdjustment();this._bLazyLoading=this._getObjectPageLayout()&&(this._getObjectPageLayout().getEnableLazyLoading()||this._getObjectPageLayout().getUseIconTabBar());};c.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._adjustLayout();}};c.prototype.setParent=function(p,A,s){C.prototype.setParent.call(this,p,A,s);if(p instanceof l.ObjectPageSubSection){this._bLazyLoading=true;this._oParentObjectPageSubSection=p;}};c.prototype.invalidate=function(o){this._applyMapping();C.prototype.invalidate.call(this,o);};c.prototype.setModel=function(m,n){this._applyMapping(n);return C.prototype.setModel.call(this,m,n);};c.prototype._applyMapping=function(){if(this._bLazyLoading&&!this._bConnected){jQuery.sap.log.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected");}else{this.getMappings().forEach(function(m,i){var o,I=m.getInternalModelName(),e=m.getExternalPath(),E=m.getExternalModelName(),p;if(e){if(I==""||e==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty");}if(!this._isMappingApplied(I)||(this.getModel(I)!=this.getModel(E))){jQuery.sap.log.info("BlockBase :: mapping external model "+E+" to "+I);o=this.getModel(E);if(o){p=o.resolve(e,this.getBindingContext(E));this._oMappingApplied[I]=true;C.prototype.setModel.call(this,o,I);this.setBindingContext(new b(o,p),I);}}}},this);}};c.prototype._isMappingApplied=function(i){return this.getModel(i)&&this._oMappingApplied[i];};c.prototype.propagateProperties=function(n){if(this._bLazyLoading&&!this._bConnected&&!this._oUpdatedModels.hasOwnProperty(n)){this._oUpdatedModels[n]=true;}else{this._applyMapping(n);}return C.prototype.propagateProperties.call(this,n);};c.prototype.getSupportedModes=function(){var s=jQuery.extend({},this.getMetadata().getViews());for(var k in s){s[k]=k;}return s;};c.prototype.setMode=function(m){m=this._validateMode(m);if(this.getMode()!==m){this.setProperty("mode",m,false);if(!this._bLazyLoading||this._bConnected){this._initView(m);}}return this;};c.prototype.setColumnLayout=function(L){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate();}this.setProperty("columnLayout",L);};c.prototype.clone=function(){var A=-1,s=this.getAssociation("selectedView"),v=this.getAggregation("_views")||[];if(s){v.forEach(function(V,i){if(V.getId()===s){A=i;}return A<0;});}var n=C.prototype.clone.call(this);if(A>=0){n.setAssociation("selectedView",n.getAggregation("_views")[A]);}return n;};c.prototype._validateMode=function(m){this.validateProperty("mode",m);if(!this.getMetadata().getView(m)){var s=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){jQuery.sap.log.warning("BlockBase :: no view defined for block "+s+" for mode "+m+", loading defaultXML instead");m="defaultXML";}else{throw new Error("BlockBase :: no view defined for block "+s+" for mode "+m);}}return m;};c.prototype._getSelectedViewContent=function(){var v=null,s,V;s=this.getAssociation("selectedView");V=this.getAggregation("_views");if(V){for(var i=0;!v&&i<V.length;i++){if(V[i].getId()===s){v=V[i];}}}return v;};c.prototype.createView=function(p){return sap.ui.xmlview(p);};c.prototype._initView=function(m){var v,V=this.getAggregation("_views")||[],p=this.getMetadata().getView(m);V.forEach(function(o,i){if(o.data("layoutMode")===m){v=o;}});if(!v){v=this._initNewView(m);}this.setAssociation("selectedView",v,true);if(v.getController()&&v.getController().onParentBlockModeChange){v.getController().onParentBlockModeChange(m);}else{jQuery.sap.log.info("BlockBase ::: could not notify "+p.viewName+" of loading in mode "+m+": missing controller onParentBlockModeChange method");}return v;};c.prototype._initNewView=function(m){var v=this._getSelectedViewContent(),p=this.getMetadata().getView(m);if(!v||p.viewName!=v.getViewName()){v=this.createView(p);if(v){if(v.getController()){v.getController().oParentBlock=this;}v.addCustomData(new a({"key":"layoutMode","value":m}));this.addAggregation("_views",v,true);}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+m);}}return v;};c._FORM_ADJUSTMENT_CONST={breakpoints:{XL:D.media._predefinedRangeSets.StdExt.points[2],L:D.media._predefinedRangeSets.StdExt.points[1],M:D.media._predefinedRangeSets.StdExt.points[0]},labelSpan:{XL:12,L:12,M:12,S:12},emptySpan:{XL:0,L:0,M:0,S:0},columns:{XL:1,L:1,M:1}};c._PARENT_GRID_SIZE=12;c.prototype._computeFormAdjustmentFields=function(v,L,f,p){if(v&&L&&f&&p){var o=this._computeFormColumns(L,f,p),d=this._computeFormBreakpoints(L,f);return jQuery.extend({},c._FORM_ADJUSTMENT_CONST,{columns:o},{breakpoints:d});}};c.prototype._computeFormColumns=function(L,f,p){var o=jQuery.extend({},c._FORM_ADJUSTMENT_CONST.columns);if(f===sap.uxap.BlockBaseFormAdjustment.BlockColumns){var i=c._PARENT_GRID_SIZE/p.XL,d=c._PARENT_GRID_SIZE/p.L,e=c._PARENT_GRID_SIZE/p.M;o.XL=L.getSpanXL()/i;o.L=L.getSpanL()/d;o.M=L.getSpanM()/e;}return o;};c.prototype._computeFormBreakpoints=function(L,f){var o=jQuery.extend({},c._FORM_ADJUSTMENT_CONST.breakpoints);if(f===sap.uxap.BlockBaseFormAdjustment.BlockColumns){o.XL=Math.round(o.XL*L.getSpanXL()/c._PARENT_GRID_SIZE);o.L=Math.round(o.L*L.getSpanL()/c._PARENT_GRID_SIZE);o.M=Math.round(o.M*L.getSpanM()/c._PARENT_GRID_SIZE);}return o;};c.prototype._applyFormAdjustment=function(){var L=this.getLayoutData(),f=this.getFormAdjustment(),v=this._getSelectedViewContent(),p=this._oParentObjectPageSubSection,F;if(f&&(f!==sap.uxap.BlockBaseFormAdjustment.None)&&v&&L&&p){var P=p._oLayoutConfig;v.getContent().forEach(function(i){if(i.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){i.setLayout(sap.ui.layout.form.SimpleFormLayout.ResponsiveGridLayout);if(!F){F=this._computeFormAdjustmentFields(v,L,f,P);}this._applyFormAdjustmentFields(F,i);i.setWidth("100%");}else if(i.getMetadata().getName()==="sap.ui.layout.form.Form"){var o=i.getLayout(),r;if(o&&o.getMetadata().getName()==="sap.ui.layout.form.ResponsiveGridLayout"){r=o;}else{r=new R();i.setLayout(r);}if(!F){F=this._computeFormAdjustmentFields(v,L,f,P);}this._applyFormAdjustmentFields(F,r);i.setWidth("100%");}},this);}};c.prototype._applyFormAdjustmentFields=function(f,F){F.setColumnsL(f.columns.L);F.setColumnsM(f.columns.M);F.setLabelSpanL(f.labelSpan.L);F.setLabelSpanM(f.labelSpan.M);F.setLabelSpanS(f.labelSpan.S);F.setEmptySpanL(f.emptySpan.L);F.setEmptySpanM(f.emptySpan.M);F.setEmptySpanS(f.emptySpan.S);F.setBreakpointL(f.breakpoints.L);F.setBreakpointM(f.breakpoints.M);};c.prototype._getObjectPageLayout=function(){if(!this._oParentObjectPageLayout){this._oParentObjectPageLayout=l.Utilities.getClosestOPL(this);}return this._oParentObjectPageLayout;};c.prototype.setVisible=function(v,s){this.setProperty("visible",v,s);this._getObjectPageLayout()&&this._getObjectPageLayout()._adjustLayoutAndUxRules();return this;};c.prototype.setShowSubSectionMore=function(v,i){if(v!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",v,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility();}}return this;};c.prototype.connectToModels=function(){if(!this._bConnected){jQuery.sap.log.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._bLazyLoading){var m=this.getMode();m&&this._initView(m);}this.invalidate();}};c.prototype.updateBindingContext=function(s,S,m,u){if(!this._bLazyLoading||this._bConnected){return C.prototype.updateBindingContext.call(this,s,S,m,u);}else{jQuery.sap.log.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};c.prototype.updateBindings=function(u,m){if(!this._bLazyLoading||this._bConnected){return C.prototype.updateBindings.call(this,u,m);}else{jQuery.sap.log.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};return c;});};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageHeader')){jQuery.sap.declare('sap.uxap.ObjectPageHeader');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.IconPool');jQuery.sap.require('sap.ui.core.CustomData');jQuery.sap.require('sap.ui.Device');jQuery.sap.require('sap.ui.core.ResizeHandler');jQuery.sap.require('sap.m.Text');jQuery.sap.require('sap.m.Button');jQuery.sap.require('sap.m.ActionSheet');jQuery.sap.require('sap.m.Image');jQuery.sap.require('sap.ui.core.Icon');sap.ui.define("sap/uxap/ObjectPageHeader",["sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","./BreadCrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Text","sap/m/Button","sap/m/ActionSheet","sap/m/Image","sap/ui/core/Icon","./library"],function(C,I,a,D,B,O,R,T,b,A,c,d,l){"use strict";var e=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.uxap.ObjectPageHeaderPictureShape",defaultValue:sap.uxap.ObjectPageHeaderPictureShape.Square},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:sap.uxap.ObjectPageHeaderDesign.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.uxap.BreadCrumbs",multiple:false,visibility:"hidden"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}}}});e.prototype._iAvailablePercentageForActions=0.3;e.prototype.init=function(){if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();}this._iREMSize=parseInt(jQuery("body").css("font-size"),10);this._iOffset=parseInt(0.25*this._iREMSize,10);this._iScrollBarWidth=jQuery.position.scrollbarWidth();this._oOverflowActionSheet=this._getInternalAggregation("_overflowActionSheet");this._oOverflowButton=this._getInternalAggregation("_overflowButton").attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._getInternalAggregation("_expandButton");this._oActionSheetButtonMap={};this._oFlagIcon=this._getInternalAggregation("_flagIcon");this._oFavIcon=this._getInternalAggregation("_favIcon");this._oTitleArrowIcon=this._getInternalAggregation("_titleArrowIcon").attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._getInternalAggregation("_titleArrowIconCont").attachPress(this._handleArrowPress,this);this._oLockIcon=this._getInternalAggregation("_lockIcon").attachPress(this._handleLockPress,this);this._oLockIconCont=this._getInternalAggregation("_lockIconCont").attachPress(this._handleLockPress,this);this._oChangesIcon=this._getInternalAggregation("_changesIcon").attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._getInternalAggregation("_changesIconCont").attachPress(this._handleChangesPress,this);};e.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};e.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};e.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};e.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};e._internalAggregationFactory={"_objectImage":function(P){var f,s=P.getObjectImageURI();if(s.indexOf("sap-icon://")==0){f=new d();}else{f=new c({densityAware:P.getObjectImageDensityAware(),alt:P.getObjectImageAlt(),decorative:false});}f.setSrc(s);f.addStyleClass("sapUxAPObjectPageHeaderObjectImage");if(P.getObjectImageAlt()){f.setTooltip(P.getObjectImageAlt());}return f;},"_overflowActionSheet":function(){return new A({placement:sap.m.PlacementType.Bottom});},"_lockIconCont":function(P){return this._getButton(P,"sap-icon://locked","lock-cont",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(P){return new B({links:P.getAggregation("breadCrumbLinks"),currentLocation:new T({text:P.getProperty("objectTitle")}),showCurrentLocation:false});},"_lockIcon":function(P){return this._getButton(P,"sap-icon://locked","lock");},"_titleArrowIconCont":function(P){return this._getButton(P,"sap-icon://arrow-down","titleArrow-cont",P.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(P){return this._getButton(P,"sap-icon://arrow-down","titleArrow",P.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(P){return this._getIcon(P,"favorite",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(P){return this._getIcon(P,"flag",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(P){return this._getButton(P,"sap-icon://overflow","overflow");},"_expandButton":function(P){return this._getButton(P,"sap-icon://slim-arrow-down","expand",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(P){return this._getButton(P,"sap-icon://request","changes-cont",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(P){return this._getButton(P,"sap-icon://request","changes",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(P,i,t){return I.createControlByURI({id:this._getParentAugmentedId(P,i),tooltip:t,src:I.getIconURI(i),visible:false});},_getButton:function(P,i,s,t){return new b({id:this._getParentAugmentedId(P,s),tooltip:t,icon:i,type:sap.m.ButtonType.Transparent});},_getParentAugmentedId:function(P,s){return P.getId()+"-"+s;}};e.prototype._getInternalAggregation=function(s){if(!this.getAggregation(s)){this.setAggregation(s,e._internalAggregationFactory[s](this));}return this.getAggregation(s);};e.prototype._applyActionProperty=function(P,f){var n=f[0];if(this.getProperty(P)!==n){f.unshift(P);this.setProperty.apply(this,f);this._notifyParentOfChanges();}return this;};e.prototype._applyObjectImageProperty=function(P,f){var n=f[0];if(this.getProperty(P)!==n){f.unshift(P);this.setProperty.apply(this,f);this._destroyObjectImage();this._notifyParentOfChanges();}return this;};e.prototype._proxyMethodToBreadCrumbControl=function(f,h){var i=this._getInternalAggregation("_breadCrumbs");return i[f].apply(i,h);};e.prototype.setHeaderDesign=function(h){this.setProperty("headerDesign",h);if(this.getParent()){this.getParent().invalidate();}return this;};e.prototype._shiftHeaderTitle=function(){var P=this.getParent(),h=0,s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",$=this.$().find(".sapUxAPObjectPageHeaderIdentifierActions"),H=true,i=this._iOffset;if(typeof P._hasVerticalScrollBar==="function"){H=P._hasVerticalScrollBar();}if(sap.ui.Device.system.desktop){h=this._iScrollBarWidth;if(!H){h=0;i+=this._iScrollBarWidth;}}$.css(s,i+"px");if(typeof P._shiftHeader==="function"){P._shiftHeader(s,h+"px");}};e.prototype.setObjectTitle=function(t){var f=this._getInternalAggregation("_breadCrumbs");if(f){f.getCurrentLocation().setText(t);}return this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));};var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],o=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape"];var g=function(P){var s="set"+P.charAt(0).toUpperCase()+P.slice(1);e.prototype[s]=function(){var f=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,P,f);};};var G=function(P){var s="set"+P.charAt(0).toUpperCase()+P.slice(1);e.prototype[s]=function(){var f=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,P,f);};};p.forEach(g);o.forEach(G);e.prototype.getBreadCrumbsLinks=function(){return this._getInternalAggregation("_breadCrumbs").getLinks();};e.prototype.addBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("addLink",arguments);};e.prototype.indexOfBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("indexOfLink",arguments);};e.prototype.insertBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("insertLink",arguments);};e.prototype.removeBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("removeLink",arguments);};e.prototype.removeAllBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("removeAllLinks",arguments);};e.prototype.destroyBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("destroyLinks",arguments);};e.prototype._destroyObjectImage=function(){var s="_objectImage",f=this.getAggregation(s);if(f){f.destroy();this.setAggregation(s,null);}};e.prototype.onBeforeRendering=function(){if(this.getShowPlaceholder()){this._oPlaceholder=I.createControlByURI({src:I.getIconURI("picture"),visible:true});}var f=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._oActionSheetButtonMap={};if(f.length>1||this._hasOneButtonShowText(f)){jQuery.each(f,jQuery.proxy(function(i,h){if(h instanceof b&&h.getVisible()){if(h instanceof b&&(h.getType()==="Default"||h.getType()==="Unstyled")){h.setProperty("type",sap.m.ButtonType.Transparent,false);}var j=this._createActionSheetButton(h);this._oActionSheetButtonMap[h.getId()]=j;this._oOverflowActionSheet.addButton(j);}},this));}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);};e.prototype._createActionSheetButton=function(f){var h=new b({press:jQuery.proxy(this._onSeeMoreContentSelect,this),enabled:f.getEnabled(),customData:new a({key:"originalId",value:f.getId()})});var t=f.getBindingInfo("text"),i=f.getBindingInfo("icon"),m;if(t&&t.parts&&t.parts.length>0){m=t.parts[0].model;h.bindProperty("text",{path:t.parts[0].path,model:m,formatter:t.formatter});h.setBindingContext(f.getBindingContext(m),m);h.setModel(f.getModel(m),m);}else{h.setText(f.getText());}if(i&&i.parts&&i.parts.length>0){m=i.parts[0].model;h.bindProperty("icon",{path:i.parts[0].path,model:m,formatter:i.formatter});h.setBindingContext(f.getBindingContext(m),m);h.setModel(f.getModel(m),m);}else{h.setIcon(f.getIcon());}return h;};e.prototype.onAfterRendering=function(){this._adaptLayout();if(this.getShowPlaceholder()){jQuery(".sapUxAPObjectPageHeaderObjectImage").off("error").error(function(){jQuery(this).hide();jQuery(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");});}else{jQuery(".sapUxAPObjectPageHeaderObjectImage").off("error").error(function(){jQuery(this).addClass("sapMNoImg");});}if(!this._iResizeId){this._iResizeId=R.register(this,this._adaptLayout.bind(this));}this._attachDetachActionButtonsHandler(true);};e.prototype._attachDetachActionButtonsHandler=function(f){var h=this.getActions()||[];if(h.length<1){return;}h.forEach(function(i){if(i instanceof O){if(f){i.attachEvent("_change",this._adaptLayout,this);}else{i.detachEvent("_change",this._adaptLayout,this);}}},this);};e.prototype._onSeeMoreContentSelect=function(E){var P=E.getSource(),f=sap.ui.getCore().byId(P.data("originalId"));if(f.firePress){f.firePress({overflowButtonId:this._oOverflowButton.getId()});}this._oOverflowActionSheet.close();};e._actionImportanceMap={"Low":3,"Medium":2,"High":1};e._sortActionsByImportance=function(f,h){var i=(f instanceof O)?f.getImportance():sap.uxap.Importance.High,s=(h instanceof O)?h.getImportance():sap.uxap.Importance.High,j=e._actionImportanceMap[i]-e._actionImportanceMap[s];if(j===0){return f.position-h.position;}return j;};e.prototype._hasOneButtonShowText=function(f){var h=false;if(f.length!==1){return h;}if(f[0]instanceof O){h=(!f[0].getHideText()&&f[0].getText()!="");}else if(f[0]instanceof b){h=(f[0].getText()!="");}return h;};e.prototype._adaptLayout=function(){var i=this.$("identifierLine").width(),f=this._getActionsWidth(),h=f/i,j=this._iAvailablePercentageForActions*i;if(h>this._iAvailablePercentageForActions){this._adaptActions(j);}else{this._oOverflowButton.$().hide();}this.$("actions").find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton").css("visibility","visible");this._adaptObjectPageHeaderIndentifierLine();};e.prototype._adaptObjectPageHeaderIndentifierLine=function(){var i=this.$("identifierLine").width(),$=this.$("subtitle"),s,t,f=this.$("actions").width()+this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer").width(),P=3;if($.length){if($.hasClass("sapOPHSubtitleBlock")){$.removeClass("sapOPHSubtitleBlock");}s=$.outerHeight()+$.position().top;t=this.$("innerTitle").outerHeight()+this.$("innerTitle").position().top;if(Math.abs(s-t)>P){$.addClass("sapOPHSubtitleBlock");}}this.$("identifierLineContainer").width((0.95-(f/i))*100+"%");};e.prototype._adaptActions=function(f){var m=jQuery("html").hasClass("sapUiMedia-Std-Phone")||D.system.phone,v=this._oOverflowButton.$().show().width(),h=this.getActions(),j=h.length,k;for(var i=0;i<j;i++){h[i].position=i;}h.sort(e._sortActionsByImportance);h.forEach(function(n){k=this._oActionSheetButtonMap[n.getId()];if(k){v+=n.$().width();if(f>v&&!m){k.setVisible(false);}else{this._setActionButtonVisibility(n,false);}}},this);};e.prototype._setActionButtonVisibility=function(f,v){var h=this._oActionSheetButtonMap[f.getId()];if(h){if(v){f.$().show();}else{f.$().hide();}h.setVisible(!v);}};e.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(f){if(f instanceof b){f.$().show();f.$().css("visibility","hidden");w+=f.$().outerWidth(true);}});return w;};e.prototype._notifyParentOfChanges=function(){if(this.getParent()&&typeof this.getParent()._headerTitleChangeHandler==="function"){this.getParent()._headerTitleChangeHandler();}};e.prototype._getActionsPaddingStatus=function(){return this.$("actions").hasClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding");};e.prototype._setActionsPaddingStatus=function(s){return this.$("actions").toggleClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding",s);};e.prototype.exit=function(){jQuery(".sapUxAPObjectPageHeaderObjectImage").off("error");if(this._iResizeId){R.deregister(this._iResizeId);}};return e;});};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageLayoutABHelper')){jQuery.sap.declare('sap.uxap.ObjectPageLayoutABHelper');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.base.Metadata');jQuery.sap.require('sap.ui.core.CustomData');jQuery.sap.require('sap.m.Button');jQuery.sap.require('sap.ui.core.IconPool');sap.ui.define("sap/uxap/ObjectPageLayoutABHelper",["jquery.sap.global","sap/ui/base/Metadata","sap/ui/core/CustomData","./AnchorBar","sap/m/Button","sap/ui/core/IconPool"],function(q,M,C,A,B,I){"use strict";var a=M.createClass("sap.uxap._helpers.AB",{constructor:function(o){this._oObjectPageLayout=o;}});a.prototype.getObjectPageLayout=function(){return this._oObjectPageLayout;};a.prototype._getAnchorBar=function(){var o=this.getObjectPageLayout().getAggregation("_anchorBar");if(!o){o=new A({showPopover:this.getObjectPageLayout().getShowAnchorBarPopover()});this.getObjectPageLayout().setAggregation("_anchorBar",o);}return o;};a.prototype._buildAnchorBar=function(){var s=this.getObjectPageLayout().getSections()||[],o=this._getAnchorBar();if(o&&this.getObjectPageLayout().getShowAnchorBar()){o.removeAllContent();s.forEach(function(S){if(!S.getVisible()||!S._getInternalVisible()){return true;}var b,c=S.getSubSections()||[];b=this._buildAnchorBarButton(S,true);if(b){o.addContent(b);c.forEach(function(d){if(!d.getVisible()||!d._getInternalVisible()){return;}var b=this._buildAnchorBarButton(d,false);if(b){o.addContent(b);}},this);}},this);}};a.prototype._buildAnchorBarButton=function(s,i){var b=null,o=this.getObjectPageLayout(),c,S,m,d=s.getAggregation("subSections");if(s.getVisible()&&s._getInternalVisible()){c=s.getCustomAnchorBarButton();if(!c){b=new B({ariaDescribedBy:s});if(s._getInternalTitle()!=""){b.setText(s._getInternalTitle());}else{S=s.getBindingInfo("title");if(S&&S.parts&&S.parts.length>0){m=S.parts[0].model;b.setBindingContext(s.getBindingContext(m),m);b.bindProperty("text",{path:S.parts[0].path,model:m});}else{b.setText(s.getTitle());}}}else{b=c.clone();}o._oSectionInfo[s.getId()].buttonId=b.getId();b.addCustomData(new C({key:"sectionId",value:s.getId()}));b.addCustomData(new C({key:"bTitleVisible",value:s._getInternalTitleVisible()}));if(!i){b.addCustomData(new C({key:"secondLevel",value:true}));}if(d&&d.length>1){b.addCustomData(new C({key:"bHasSubMenu",value:true}));if(o.getShowAnchorBarPopover()){b.setIcon(I.getIconURI("slim-arrow-down"));b.setIconFirst(false);}}}return b;};return a;},false);};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageSection')){jQuery.sap.declare('sap.uxap.ObjectPageSection');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.InvisibleText');jQuery.sap.require('sap.ui.Device');jQuery.sap.require('sap.m.Button');sap.ui.define("sap/uxap/ObjectPageSection",["jquery.sap.global","sap/ui/core/InvisibleText","./ObjectPageSectionBase","sap/ui/Device","sap/m/Button","./library"],function(q,I,O,D,B,l){"use strict";var a=O.extend("sap.uxap.ObjectPageSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"subSections",aggregations:{subSections:{type:"sap.uxap.ObjectPageSubSection",multiple:true,singularName:"subSection"},ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_showHideAllButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_showHideButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{selectedSubSection:{type:"sap.uxap.ObjectPageSubSection",multiple:false}}}});a.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;a.prototype._expandSection=function(){O.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections());};a.prototype.init=function(){O.prototype.init.call(this);this._sContainerSelector=".sapUxAPObjectPageSectionContainer";D.media.attachHandler(this._updateImportance,this,a.MEDIA_RANGE);};a.prototype.exit=function(){D.media.detachHandler(this._updateImportance,this,a.MEDIA_RANGE);};a.prototype.onkeyup=function(e){var b=sap.ui.getCore().byId(q(e.target).attr("id"));if(e.keyCode===q.sap.KeyCodes.TAB&&b instanceof sap.uxap.ObjectPageSection&&this._getObjectPageLayout()._isFirstSection(this)){this._getObjectPageLayout().$("opwrapper").scrollTop(0);}};a.prototype._updateImportance=function(c){var o=this._getObjectPageLayout(),m=c||D.media.getCurrentRange(a.MEDIA_RANGE),s=o&&o.getShowOnlyHighImportance(),i=this._determineTheLowestLevelOfImportanceToShow(m.name,s);this.getSubSections().forEach(function(S){S._applyImportanceRules(i);});this._applyImportanceRules(i);this._updateShowHideAllButton(false);if(o){o._adjustLayout();}};a.prototype._determineTheLowestLevelOfImportanceToShow=function(m,s){if(s||m==="Phone"){return l.Importance.High;}if(m==="Tablet"){return l.Importance.Medium;}return l.Importance.Low;};a.prototype.connectToModels=function(){this.getSubSections().forEach(function(s){s.connectToModels();});};a.prototype.onBeforeRendering=function(){var A="ariaLabelledBy";if(!this.getAggregation(A)){this.setAggregation(A,this._getAriaLabelledBy());}};a.prototype.onAfterRendering=function(){this._updateImportance();};a.prototype._getAriaLabelledBy=function(){return new I({text:this._getInternalTitle()||this.getTitle()}).toStatic();};a.prototype._setSubSectionsFocusValues=function(){var s=this.getSubSections()||[],L=this.getSelectedSubSection(),p;if(s.length===0){return this;}s.forEach(function(S){if(L===S.sId){S._setToFocusable(true);p=true;}else{S._setToFocusable(false);}});if(!p){s[0]._setToFocusable(true);}return this;};a.prototype._disableSubSectionsFocus=function(){var s=this.getSubSections()||[];s.forEach(function(S){S._setToFocusable(false);});return this;};a.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(s){return s._getIsHidden();});};a.prototype._updateShowHideSubSections=function(h){this.getSubSections().forEach(function(s){if(h&&s._shouldBeHidden()){s._updateShowHideState(true);}else if(!h){s._updateShowHideState(false);}});};a.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(s){return s._shouldBeHidden();});};a.prototype._showHideContentAllContent=function(){var s=this._thereAreHiddenSubSections();if(this._getIsHidden()&&s){this._updateShowHideState(false);}this._updateShowHideSubSections(!s);this._updateShowHideAllButton(s);};a.prototype._updateShowHideState=function(h){this._updateShowHideButton(h);this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());return O.prototype._updateShowHideState.call(this,h);};a.prototype._updateShowHideAllButton=function(h){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(h));};a.prototype._getShowHideAllButton=function(){if(!this.getAggregation("_showHideAllButton")){this.setAggregation("_showHideAllButton",new B({text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:sap.m.ButtonType.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"));}return this.getAggregation("_showHideAllButton");};a.prototype._getShowHideButtonText=function(h){return l.i18nModel.getResourceBundle().getText(h?"HIDE":"SHOW");};a.prototype._getShowHideAllButtonText=function(h){return l.i18nModel.getResourceBundle().getText(h?"HIDE_ALL":"SHOW_ALL");};a.prototype._updateShowHideButton=function(h){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!h));};a.prototype._getShowHideButton=function(){if(!this.getAggregation("_showHideButton")){this.setAggregation("_showHideButton",new B({text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:sap.m.ButtonType.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"));}return this.getAggregation("_showHideButton");};return a;});};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageSubSection')){jQuery.sap.declare('sap.uxap.ObjectPageSubSection');jQuery.sap.require('sap.ui.core.CustomData');jQuery.sap.require('sap.ui.layout.Grid');jQuery.sap.require('sap.uxap.ObjectPageSubSectionLayout');jQuery.sap.require('sap.uxap.ObjectPageSubSectionMode');jQuery.sap.require('sap.ui.layout.GridData');jQuery.sap.require('sap.ui.core.ResizeHandler');jQuery.sap.require('sap.m.Button');sap.ui.define("sap/uxap/ObjectPageSubSection",["sap/ui/core/CustomData","sap/ui/layout/Grid","./ObjectPageSectionBase","./ObjectPageSubSectionLayout","./ObjectPageSubSectionMode","./BlockBase","sap/ui/layout/GridData","sap/ui/core/ResizeHandler","sap/m/Button","./library"],function(C,G,O,a,b,B,c,R,d,l){"use strict";var e=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:b.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}}}});e.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._switchSubSectionMode(this.getMode());};e.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};e.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:0,vSpacing:1,width:"100%",containerQuery:true}));}return this.getAggregation("_grid");};e.prototype.connectToModels=function(){var f=this.getBlocks()||[],m=this.getMoreBlocks()||[],s=this.getMode();f.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(s);}o.connectToModels();}});if(m.length>0&&s===b.Expanded){m.forEach(function(M){if(M instanceof B){if(!M.getMode()){M.setMode(s);}M.connectToModels();}});}};e.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}if(this._iResizeId){R.deregister(this._iResizeId);}if(O.prototype.exit){O.prototype.exit.call(this);}};e.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}if(o.getSubSectionLayout()===a.TitleOnLeft){this._afterRenderingTitleOnLeftLayout();}this._$spacer=jQuery.sap.byId(o.getId()+"-spacer");};e.prototype.onBeforeRendering=function(){if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(this._getObjectPageLayout());this.refreshSeeMoreVisibility();};e.prototype._applyLayout=function(L){var v,g=this._getGrid(),s=this.getMode(),f=L.getSubSectionLayout(),o=this._calculateLayoutConfiguration(f,L),h=this.getBlocks(),A=h.concat(this.getMoreBlocks());this._oLayoutConfig=o;this._resetLayoutData(A);if(s===b.Expanded){v=A;}else{v=h;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(i){this._setBlockMode(i,s);g.addContent(i);},this);}catch(E){jQuery.sap.log.error("ObjectPageSubSection :: error while building layout "+f+": "+E);}return this;};e.prototype._calculateLayoutConfiguration=function(L,o){var f={M:2,L:3,XL:4},i=f.L,E=f.XL,t=(L===a.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){i-=1;E-=1;}if(u){i-=1;}f.L=i;f.XL=E;return f;};e.prototype.refreshSeeMoreVisibility=function(){var f=!!this.getMoreBlocks().length,s=this._getSeeMoreButton(),$=s.$(),g=this.$();if(!f){f=this.getBlocks().some(function(o){if(o instanceof B&&o.getVisible()&&o.getShowSubSectionMore()){return true;}});}if(g.length){g.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore",f);}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",f);if($.length){$.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible",f);}s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",f);return f;};e.prototype.setMode=function(m){if(this.getMode()!==m){this._switchSubSectionMode(m);if(this._bRenderedFirstTime){this.rerender();}}return this;};e.prototype.onkeydown=function(E){if(E.keyCode===jQuery.sap.KeyCodes.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof e){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};e.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().focus();}else{this.getParent().$().focus();}};e.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().focus();}else{this.$().firstFocusableDomRef().focus();}};e.prototype._calcBlockColumnLayout=function(f,o){var g=12,v,M,L,X,D;M={iRemaining:o.M,iColumnConfig:o.M};L={iRemaining:o.L,iColumnConfig:o.L};X={iRemaining:o.XL,iColumnConfig:o.XL};D=[X,L,M];v=f.filter(function(h){return h.getVisible&&h.getVisible();});v.forEach(function(h,i){D.forEach(function(j){j.iCalculatedSize=this._calculateBlockSize(h,j.iRemaining,v,i,j.iColumnConfig);},this);h.setLayoutData(new c({spanS:g,spanM:M.iCalculatedSize*(g/M.iColumnConfig),spanL:L.iCalculatedSize*(g/L.iColumnConfig),spanXL:X.iCalculatedSize*(g/X.iColumnConfig),linebreakM:(i>0&&M.iRemaining===M.iColumnConfig),linebreakL:(i>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(i>0&&X.iRemaining===X.iColumnConfig)}));D.forEach(function(j){j.iRemaining-=j.iCalculatedSize;if(j.iRemaining<1){j.iRemaining=j.iColumnConfig;}});},this);return v;};e.prototype._calculateBlockSize=function(o,r,v,i,m){var f,F=m,g;if(!this._hasAutoLayout(o)){return Math.min(m,parseInt(o.getColumnLayout(),10));}for(g=1;g<=F;g++){f=this._calcLayout(v[i+g]);if(f<r){r-=f;}else{break;}}return r;};e.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout(),10);}return L;};e.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};e.prototype._afterRenderingTitleOnLeftLayout=function(){this._$standardHeader=jQuery.sap.byId(this.getId()+"-header");this._$grid=this._getGrid().$();if(!this._iResizeId){this._iResizeId=R.register(this,this._titleOnLeftSynchronizeLayouts.bind(this));}this._titleOnLeftSynchronizeLayouts();};e.prototype._titleOnLeftSynchronizeLayouts=function(){jQuery.sap.delayedCall(50,this,function(){var r=jQuery("html"),u=r.hasClass("sapUiMedia-Std-Desktop")||r.hasClass("sapUiMedia-Std-LargeDesktop");this._$standardHeader.toggleClass("titleOnLeftLayout",u);});};e.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}jQuery.each(this._aAggregationProxy,jQuery.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A));},this));this._bRenderedFirstTime=true;};e.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};e.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};e.prototype._setAggregation=function(A,v){this._aAggregationProxy[A]=v;this._notifyObjectPageLayout();this.invalidate();return this._aAggregationProxy[A];};e.prototype.addAggregation=function(A,o){var f;if(this.hasProxy(A)){f=this._getAggregation(A);f.push(o);this._setAggregation(f);if(o instanceof B){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};e.prototype.insertAggregation=function(A,o,i){if(this.hasProxy(A)){jQuery.sap.log.warning("ObjectPageSubSection :: used of insertAggregation for "+A+" is not supported, will use addAggregation instead");return this.addAggregation(A,o);}return O.prototype.insertAggregation.apply(this,arguments);};e.prototype.removeAllAggregation=function(A){var i,I;if(this.hasProxy(A)){i=this._getAggregation(A);I=i.slice(0,i.length-1);this._setAggregation(A,[]);return I;}return O.prototype.removeAllAggregation.apply(this,arguments);};e.prototype.removeAggregation=function(A,o){var r=false,i;if(this.hasProxy(A)){i=this._getAggregation(A);i.forEach(function(f,I){if(f.getId()===o.getId()){i.splice(I,1);this._setAggregation(i);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};e.prototype.indexOfAggregation=function(A,o){var i=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(f,I){if(f.getId()===o.getId()){i=I;return true;}},this);return i;}return O.prototype.indexOfAggregation.apply(this,arguments);};e.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};e.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};e.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new d(this.getId()+"--seeMore",{type:sap.m.ButtonType.Transparent,iconFirst:false}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};e.prototype._seeMoreLessControlPressHandler=function(E){var s=this.getMode(),t,m=this.getMoreBlocks()||[];if(s===b.Expanded){t=b.Collapsed;}else{t=b.Expanded;m.forEach(function(o){if(o instanceof B){o.setMode(s);o.connectToModels();}},this);}this._switchSubSectionMode(t);if(this._$spacer.length>0){this._$spacer.height(this._$spacer.height()+this.$().height());}this.rerender();};e.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===b.Collapsed){this.setProperty("mode",b.Collapsed,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_MORE"));}else{this.setProperty("mode",b.Expanded,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_LESS"));}};e.prototype._setBlockMode=function(o,m){if(o instanceof B){o.setMode(m);}else{jQuery.sap.log.debug("ObjectPageSubSection :: cannot propagate mode "+m+" to "+o.getMetadata().getName());}};e.prototype._setToFocusable=function(f){var F='0',n='-1',t="tabIndex";if(f){this.$().attr(t,F);}else{this.$().attr(t,n);}return this;};e.prototype._resetLayoutData=function(f){f.forEach(function(o){if(!this._bRenderedFirstTime&&o.getLayoutData()){o.destroyLayoutData();jQuery.sap.log.warning("ObjectPageSubSection :: forbidden use of layoutData for block "+o.getMetadata().getName(),"layout will be set by subSection");}},this);};e.prototype.getVisibleBlocksCount=function(){var v=0;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(m){if(m.getVisible&&!m.getVisible()){return true;}v++;});return v;};return e;});};if(!jQuery.sap.isDeclared('sap.uxap.component.ObjectPageLayoutUXDrivenFactory.controller')){jQuery.sap.declare('sap.uxap.component.ObjectPageLayoutUXDrivenFactory.controller');jQuery.sap.require('sap.ui.layout.GridData');jQuery.sap.require('sap.ui.model.BindingMode');jQuery.sap.require('sap.ui.model.Context');jQuery.sap.require('sap.ui.base.ManagedObject');jQuery.sap.require('sap.ui.core.mvc.Controller');sap.ui.define("sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller",["sap/ui/layout/GridData","sap/ui/model/BindingMode","sap/uxap/BlockBase","sap/uxap/ModelMapping","sap/ui/model/Context","sap/ui/base/ManagedObject","sap/ui/core/mvc/Controller"],function(G,B,a,M,C,b,c){"use strict";return c.extend("sap.uxap.component.ObjectPageLayoutUXDrivenFactory",{connectToComponent:function(m){var h=jQuery.isEmptyObject(m.getData());m.setDefaultBindingMode(B.OneWay);var H=jQuery.proxy(function(){if(h){m.detachRequestCompleted(H);}var o=new C(m,"/headerTitle"),O=this.getView().byId("ObjectPageLayout");if(o.getProperty("")){try{this._oHeader=this.controlFactory(O.getId(),o);O.setHeaderTitle(this._oHeader);}catch(e){jQuery.sap.log.error("ObjectPageLayoutFactory :: error in header creation from config: "+e);}}},this);if(h){m.attachRequestCompleted(H);}else{H();}},controlFactory:function(p,o){var d=o.getProperty(""),e,f,g;try{jQuery.sap.require(d.Type);f=jQuery.sap.getObject(d.Type);g=f.getMetadata();jQuery.each(g._mAllEvents,jQuery.proxy(function(s,h){if(typeof d[s]=="string"){d[s]=this.convertEventHandler(d[s]);}},this));e=b.create(d);jQuery.each(g._mAllProperties,jQuery.proxy(function(P,h){if(d[P]){e.bindProperty(P,"objectPageLayoutMetadata>"+o.getPath()+"/"+P);}},this));}catch(E){jQuery.sap.log.error("ObjectPageLayoutFactory :: error in control creation from config: "+E);}return e;},convertEventHandler:function(s){var n=window,N=s.split('.');try{jQuery.each(N,function(i,d){n=n[d];});}catch(e){jQuery.sap.log.error("ObjectPageLayoutFactory :: undefined event handler: "+s+". Did you forget to require its static class?");n=undefined;}return n;}});},true);};if(!jQuery.sap.isDeclared('sap.uxap.LazyLoading')){jQuery.sap.declare('sap.uxap.LazyLoading');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.Device');jQuery.sap.require('sap.ui.base.Metadata');sap.ui.define("sap/uxap/LazyLoading",["jquery.sap.global","sap/ui/Device","sap/ui/base/Metadata","./ObjectPageSubSection"],function(q,D,M,O){"use strict";var L=M.createClass("sap.uxap._helpers.LazyLoading",{constructor:function(o){this._oObjectPageLayout=o;this._$html=q("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this.setLazyLoadingParameters();}});L.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;this.LAZY_LOADING_EXTRA_PAGE_SIZE=0.5;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":1,"ScrollToSection":1};}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":1};}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":2};}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":3,"ScrollToSection":3};}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5;};L.prototype.lazyLoadDuringScroll=function(s,t,p){var P,d,f=false;this._iScrollProgress=s-this._iPreviousScrollTop;P=Math.round(Math.abs(this._iScrollProgress)/p*100);if(P>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){f=true;}this._iPreviousScrollTop=s;this._iPreviousScrollTimestamp=t||0;d=(s===0)?0:this.LAZY_LOADING_DELAY;if(f&&this._sLazyLoadingTimer){q.sap.log.debug("ObjectPageLayout :: lazyLoading","delayed by "+d+" ms because of fast scroll");q.sap.clearDelayedCall(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null;}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=q.sap.delayedCall(d,this,this.doLazyLoading);}};L.prototype.doLazyLoading=function(){var h=this._oObjectPageLayout._getHeightRelatedParameters(),s=this._oObjectPageLayout._oSectionInfo,S,i,p,b=this._iPreviousScrollTop>=(h.iHeaderContentHeight),e,E=-1,o={},t,a,c;p=(h.iScreenHeight-(b?h.iAnchorBarHeight:0)-(b?h.iHeaderTitleHeightStickied:0));S=h.iScrollTop;t=Date.now()-this._iPreviousScrollTimestamp;a=(t<(this.LAZY_LOADING_DELAY/2))&&(Math.abs(this._iScrollProgress)>5);if(a){if(this._iScrollProgress>=0){c=Math.round(Math.min(this._iScrollProgress*20,p/2));}else{c=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,p/2));}S+=c;q.sap.log.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+c);}i=S+p;S+=16;q.each(s,q.proxy(function(I,d){if(!d.isSection&&!d.loaded&&d.sectionReference.getParent().getVisible()){if(d.positionTop<=i&&S<d.positionBottom-1){o[I]=I;}else if(d.positionTop>i&&d.positionTop<i+p*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(E==-1||d.positionTop<E)){E=d.positionTop;e=I;}}},this));if(E!=-1&&q.isEmptyObject(o)){q.sap.log.debug("ObjectPageLayout :: lazyLoading","extra section added : "+e);o[e]=e;}q.each(o,q.proxy(function(d,f){q.sap.log.debug("ObjectPageLayout :: lazyLoading","connecting "+f);sap.ui.getCore().byId(f).connectToModels();s[f].loaded=true;},this));if(a){this._sLazyLoadingTimer=q.sap.delayedCall(this.LAZY_LOADING_DELAY,this,this.doLazyLoading);}else{if(E){this._sLazyLoadingTimer=q.sap.delayedCall(5*this.LAZY_LOADING_DELAY,this,this.doLazyLoading);}else{this._sLazyLoadingTimer=null;}}};L.prototype.getSubsectionsToPreload=function(a,i){var s,t;if(i){s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;t=false;}else{s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;t=true;}var S=[];a.some(function(o){if(!t&&i){t=o.getId()==i;}if(t&&o instanceof O){if(o.getVisible()&&o._getInternalVisible()){S.push(o);s--;}}return s<=0;});return S;};L.prototype._isPhone=function(){return this._$html.hasClass("sapUiMedia-Std-Phone")||D.system.phone;};L.prototype._isTablet=function(){return D.system.tablet;};L.prototype._isTabletSize=function(){return this._$html.hasClass("sapUiMedia-Std-Tablet");};return L;},false);};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageLayout')){jQuery.sap.declare('sap.uxap.ObjectPageLayout');jQuery.sap.require('jquery.sap.global');jQuery.sap.require('sap.ui.core.ResizeHandler');jQuery.sap.require('sap.ui.core.Control');jQuery.sap.require('sap.ui.core.CustomData');jQuery.sap.require('sap.ui.Device');jQuery.sap.require('sap.ui.core.delegate.ScrollEnablement');jQuery.sap.require('sap.uxap.ObjectPageSubSectionLayout');sap.ui.define("sap/uxap/ObjectPageLayout",["jquery.sap.global","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSubSection","./ObjectPageSubSectionLayout","./LazyLoading","./ObjectPageLayoutABHelper","./library"],function(q,R,C,a,D,S,O,b,L,A,l){"use strict";var c=C.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:b.TitleOnTop},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.ObjectPageHeader",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.ObjectPageHeaderContent",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},editHeaderButtonPress:{}},designTime:true}});c.prototype.init=function(){this._bFirstRendering=true;this._bDomReady=false;this._bStickyAnchorBar=false;this._bInternalAnchorBarVisible=true;this._$opWrapper=[];this._$anchorBar=[];this._$headerTitle=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iTotalHeaderSize=0;this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._oLazyLoading=new L(this);this._oABHelper=new A(this);};c.prototype.onBeforeRendering=function(){this._bMobileScenario=l.Utilities.isPhoneScenario();this._bTabletScenario=l.Utilities.isTabletScenario();this._bHContentAlwaysExpanded=this._checkAlwaysShowContentHeader();this._initializeScroller();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setUpperCase(this.getUpperCaseAnchorBar());this._applyUxRules();if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;var h=this.getHeaderTitle();if(h&&h.getAggregation("_expandButton")){h.getAggregation("_expandButton").attachPress(this._handleExpandButtonPress,this);}};c.prototype._preloadSectionsOnBeforeFirstRendering=function(){var t;if(!this.getEnableLazyLoading()){t=this.getUseIconTabBar()?[this._oFirstVisibleSection]:this.getSections();}else{var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;t=this._oLazyLoading.getSubsectionsToPreload(s);}this._connectModelsForSections(t);};c.prototype._grepCurrentTabSectionBases=function(){var f=[],s=this._oCurrentTabSection||this._oFirstVisibleSection;if(s){var d=s.getId();this._aSectionBases.forEach(function(o){if(o.getParent().getId()===d){f.push(o);}});}return f;};c.prototype.onAfterRendering=function(){this._ensureCorrectParentHeight();this._cacheDomElements();this._$opWrapper.on("scroll",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{q.sap.delayedCall(c.HEADER_CALC_DELAY,this,this._onAfterRenderingDomReady);}};c.prototype._onAfterRenderingDomReady=function(){this._bDomReady=true;this._adjustHeaderHeights();if(this.getUseIconTabBar()){this._setCurrentTabSection(this._oFirstVisibleSection);}this._initAnchorBarScroll();this.getHeaderTitle()&&this.getHeaderTitle()._shiftHeaderTitle();this._setSectionsFocusValues();};c.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._iResizeId){R.deregister(this._iResizeId);}};c.prototype.setShowOnlyHighImportance=function(v){var o=this.getShowOnlyHighImportance();if(o!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(s){s._updateImportance();});}return this;};c.prototype.setIsHeaderContentAlwaysExpanded=function(v){var o=this.getAlwaysShowContentHeader();var s=(D.system.phone||D.system.tablet);if(o!==v){this.setProperty("alwaysShowContentHeader",v,s);}return this;};c.prototype._initializeScroller=function(){if(this._oScroller){this._oScroller.scrollTo(0,0,0);this._oScroller.destroy();}var e=(D.os.blackberry&&D.os.version>=10.0&&D.os.version<11.0);this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true,zynga:e,preventDefault:true,nonTouchScrolling:"scrollbar",scrollbarClass:"sapUxAPObjectPageScroll"});};c.prototype._ensureCorrectParentHeight=function(){if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}};c.prototype._cacheDomElements=function(){this._$headerTitle=q.sap.byId(this.getId()+"-headerTitle");this._$anchorBar=q.sap.byId(this.getId()+"-anchorBar");this._$stickyAnchorBar=q.sap.byId(this.getId()+"-stickyAnchorBar");this._$opWrapper=q.sap.byId(this.getId()+"-opwrapper");this._$spacer=q.sap.byId(this.getId()+"-spacer");this._$headerContent=q.sap.byId(this.getId()+"-headerContent");this._$stickyHeaderContent=q.sap.byId(this.getId()+"-stickyHeaderContent");this._$contentContainer=q.sap.byId(this.getId()+"-scroll");};c.prototype._handleExpandButtonPress=function(e){this._expandCollapseHeader(true);};c.prototype._toggleStickyHeader=function(e){this._bIsHeaderExpanded=e;this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",!e);this._toggleHeaderStyleRules(!e);};c.prototype._expandCollapseHeader=function(e){var h=this.getHeaderTitle();if(this._bHContentAlwaysExpanded){return;}if(e&&this._bStickyAnchorBar){if(h&&h.getIsActionAreaAlwaysVisible()&&!h.getIsObjectTitleAlwaysVisible()){h._setActionsPaddingStatus(e);}this._$headerContent.css("height",this.iHeaderContentHeight).children().appendTo(this._$stickyHeaderContent);this._toggleStickyHeader(e);}else if(!e&&this._bIsHeaderExpanded){this._$headerContent.css("height","auto").append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._toggleStickyHeader(e);}};c.prototype._applyUxRules=function(i){var s,d,v,V,e,f,g,F,o;s=this.getSections()||[];V=0;f=this.getShowAnchorBar();g=this.getUseIconTabBar();F=null;this._cleanMemory();s.forEach(function(h){if(!h.getVisible()){return true;}this._registerSectionBaseInfo(h);d=h.getSubSections()||[];v=0;o=null;d.forEach(function(j){if(!j.getVisible()){return true;}this._registerSectionBaseInfo(j);e=j.getVisibleBlocksCount();if(e===0){j._setInternalVisible(false,i);q.sap.log.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+j.getTitle()+" forced to hidden");}else{j._setInternalVisible(true,i);j._setInternalTitleVisible(true,i);v++;if(!o){o=j;}}},this);if(v==0){h._setInternalVisible(false,i);q.sap.log.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+h.getTitle()+" forced to hidden");}else{h._setInternalVisible(true,i);h._setInternalTitleVisible(true,i);if(!F){F=h;}if(this.getSubSectionLayout()===b.TitleOnTop&&v===1&&o.getTitle().trim()!==""){q.sap.log.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+h.getTitle()+" is taking its single subsection title "+o.getTitle());h._setInternalTitle(o.getTitle(),i);o._setInternalTitleVisible(false,i);}else{h._setInternalTitle("",i);}V++;}if(g){h._setInternalTitleVisible(false,i);}},this);if(V<=1){f=false;q.sap.log.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");}else if(F&&f){F._setInternalTitleVisible(false,i);q.sap.log.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+F.getTitle()+" title forced to hidden");}if(f){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(f,i);this._oFirstVisibleSection=F;};c.prototype.setUseIconTabBar=function(v){var o=this.getUseIconTabBar();if(v!=o){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};c.prototype._setCurrentTabSection=function(s){if(!s){return;}var o;if(s instanceof sap.uxap.ObjectPageSubSection){o=s;s=s.getParent();}else{o=this._getFirstVisibleSubSection(s);}if(this._oCurrentTabSection!==s){this._renderSection(s);this._oCurrentTabSection=s;}this._oCurrentTabSubSection=o;};c.prototype._renderSection=function(s){var $=this.$().find(".sapUxAPObjectPageContainer"),r;if(s&&$.length){r=sap.ui.getCore().createRenderManager();r.renderControl(s);r.flush($[0]);}r.destroy();};c.prototype.setShowAnchorBarPopover=function(v,s){this._oABHelper._buildAnchorBar();this._oABHelper._getAnchorBar().setShowPopover(v);return this.setProperty("showAnchorBarPopover",v,true);};c.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};c.prototype._setInternalAnchorBarVisible=function(v,i){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(i===true){this.invalidate();}}};c.prototype._adjustLayout=function(e,i,n){if(!this._bDomReady){return;}if(this._iLayoutTimer){q.sap.log.debug("ObjectPageLayout :: _adjustLayout","delayed by "+c.DOM_CALC_DELAY+" ms because of dom modifications");q.sap.clearDelayedCall(this._iLayoutTimer);}if(i){this._updateScreenHeightSectionBasesAndSpacer();this._iLayoutTimer=undefined;}else{this._bNeedLazyLoading=this._bNeedLazyLoading!==undefined||n;this._iLayoutTimer=q.sap.delayedCall(c.DOM_CALC_DELAY,this,function(){q.sap.log.debug("ObjectPageLayout :: _adjustLayout","re-evaluating dom positions");this._updateScreenHeightSectionBasesAndSpacer();if(this._bNeedLazyLoading){this._oLazyLoading.doLazyLoading();}this._bNeedLazyLoading=undefined;this._iLayoutTimer=undefined;});}};c.prototype._adjustLayoutAndUxRules=function(){q.sap.log.debug("ObjectPageLayout :: _adjustLayout","refreshing ux rules");var s=this._getSelectedSectionId();this._applyUxRules(true);this._setSelectedSectionId(s);this._adjustLayout(null,false,true);};c.prototype._getSelectedSectionId=function(){var o=this.getAggregation("_anchorBar"),s;if(o&&o.getSelectedSection()){s=o.getSelectedSection().getId();}return s;};c.prototype._setSelectedSectionId=function(s){var o=this.getAggregation("_anchorBar"),d=s&&this._oSectionInfo[s];if(!d){return;}if(o&&d.buttonId){o.setSelectedButton(d.buttonId);}};c.prototype.isFirstRendering=function(){return this._bFirstRendering;};c.prototype._cleanMemory=function(){var o=this.getAggregation("_anchorBar");if(o){o.destroyContent();}this._oSectionInfo={};this._aSectionBases=[];};c.prototype._registerSectionBaseInfo=function(s){this._oSectionInfo[s.getId()]={$dom:[],positionTop:0,positionTopMobile:0,realTop:0.0,buttonId:"",isSection:(s instanceof l.ObjectPageSection),sectionReference:s};this._aSectionBases.push(s);};c.prototype.scrollToSection=function(i,d,o){var s=sap.ui.getCore().byId(i);if(this.getUseIconTabBar()){this._setCurrentTabSection(s);var t=s;if(t instanceof sap.uxap.ObjectPageSubSection){t=t.getParent();}this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[t.getId()].buttonId);}if(this._bIsHeaderExpanded){this._expandCollapseHeader(false);}o=o||0;s._expandSection();this._adjustLayout(null,true);d=this._computeScrollDuration(d,s);var e=this._computeScrollPosition(s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);this._$contentContainer.parent().stop(true,false);}this._iCurrentScrollTimeout=q.sap.delayedCall(d,this,function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;});this._preloadSectionsOnScroll(s);this.getHeaderTitle()&&this.getHeaderTitle()._shiftHeaderTitle();this._scrollTo(e+o,d);}};c.prototype._computeScrollDuration=function(i,t){var d=parseInt(i,10);d=d>=0?d:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((t instanceof sap.uxap.ObjectPageSection)||this._isFirstVisibleSubSection(t))&&this._bStickyAnchorBar){d=0;}return d;};c.prototype._computeScrollPosition=function(t){var f=t&&(t instanceof sap.uxap.ObjectPageSection),i=t.getId();var s=this._bMobileScenario||f?this._oSectionInfo[i].positionTopMobile:this._oSectionInfo[i].positionTop;if(this.getUseIconTabBar()&&((t instanceof sap.uxap.ObjectPageSection)||this._isFirstVisibleSubSection(t))&&!this._bStickyAnchorBar){s-=this.iHeaderContentHeight;}return s;};c.prototype._preloadSectionsOnScroll=function(t){var i=t.getId(),T;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){T=(t instanceof sap.uxap.ObjectPageSection)?t:t.getParent();this._connectModelsForSections([T]);}if(this.getEnableLazyLoading()){var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;T=this._oLazyLoading.getSubsectionsToPreload(s,i);if(D.system.desktop){q.sap.delayedCall(50,this,function(){this._connectModelsForSections(T);});}else{this._connectModelsForSections(T);}}};c.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};c.prototype.setDirectScrollingToSection=function(d){this.sDirectSectionId=d;};c.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};c.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};c.prototype._scrollTo=function(y,t){if(this._oScroller){q.sap.log.debug("ObjectPageLayout :: scrolling to "+y);this._oScroller.scrollTo(0,y,t);}return this;};c.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var i,o,s,p,P,h=0;this.iScreenHeight=this.$().height();if(this.iHeaderContentHeight&&!this._bHContentAlwaysExpanded){h=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;}this._aSectionBases.forEach(function(d){var I=this._oSectionInfo[d.getId()],$=d.$(),e;if(!I||!$.length){return;}I.$dom=$;I.realTop=$.position().top;var H=(d._getInternalTitleVisible()&&(d.getTitle().trim()!==""));if(!I.isSection&&!H){I.realTop=$.find(".sapUiResponsiveMargin.sapUxAPBlockContainer").position().top;}I.positionTop=Math.ceil(I.realTop)-this.iAnchorBarHeight-h;if(I.isSection){e=d.$("header");}else{e=d.$("headerTitle");}if(e.length>0){I.positionTopMobile=Math.ceil(e.position().top)+e.outerHeight()-this.iAnchorBarHeight-h;}else{I.positionTopMobile=I.positionTop;}if(this._bMobileScenario){if(P){this._oSectionInfo[P].positionBottom=I.positionTop;}P=d.getId();o=d;}else{if(I.isSection){if(P){this._oSectionInfo[P].positionBottom=I.positionTop;this._oSectionInfo[p].positionBottom=I.positionTop;}P=d.getId();p=null;}else{if(p){this._oSectionInfo[p].positionBottom=I.positionTop;}p=d.getId();o=d;}}},this);if(o){i=this._$spacer.position().top-this._oSectionInfo[o.getId()].realTop;if(this._bMobileScenario){this._oSectionInfo[P].positionBottom=this._oSectionInfo[P].positionTop+i;}else{this._oSectionInfo[p].positionBottom=this._oSectionInfo[p].positionTop+i;this._oSectionInfo[P].positionBottom=this._oSectionInfo[p].positionTop+i;}if(i<this.iScreenHeight){if(this._isSpacerRequired(o,i)){if(this.iHeaderContentHeight||this._bHContentAlwaysExpanded){s=this.iScreenHeight-i-this.iHeaderTitleHeight-h-this.iAnchorBarHeight;}else{s=this.iScreenHeight-i-this.iAnchorBarHeight;}if(this._bMobileScenario){s+=(this._oSectionInfo[o.getId()].positionTopMobile-this._oSectionInfo[o.getId()].positionTop);}}else{s=0;}this._$spacer.height(s+"px");q.sap.log.debug("ObjectPageLayout :: bottom spacer is now "+s+"px");}}};c.prototype._isSpacerRequired=function(o,i){var s=this.getAggregation("_anchorBar").getSelectedSection(),I=this.getUseIconTabBar()&&s&&s.getSubSections().length===1,d=this.getSections().length===1&&this.getSections()[0].getSubSections().length===1;if(I||d){return false;}if(this._bStickyAnchorBar){return true;}var e=((this._oSectionInfo[o.getId()].realTop+i)<=this.iScreenHeight);if(!e){return true;}if(!this._isFirstVisibleSubSection(this._oCurrentTabSubSection)){return true;}return false;};c.prototype._isFirstVisibleSubSection=function(s){if(s){var o=this._oSectionInfo[s.getId()];if(o){return o.realTop===(this.iAnchorBarHeight+this.iHeaderContentHeight);}}return false;};c.prototype._getFirstVisibleSubSection=function(s){if(!s){return;}var f;this._aSectionBases.every(function(o){if(o.getParent()&&(o.getParent().getId()===s.getId())){f=o;return false;}return true;});return f;};c.prototype._initAnchorBarScroll=function(){this._adjustLayout(null,true);this._sScrolledSectionId="";this._onScroll({target:{scrollTop:0}});};c.prototype._setAsCurrentSection=function(s){var o,d,e;if(this._sScrolledSectionId===s){return;}q.sap.log.debug("ObjectPageLayout :: current section is "+s);this._sScrolledSectionId=s;o=this.getAggregation("_anchorBar");if(o&&this._getInternalAnchorBarVisible()){d=sap.ui.getCore().byId(s);e=d&&d instanceof O&&(d.getTitle().trim()===""||!d._getInternalTitleVisible()||d.getParent()._getIsHidden());if(e){s=d.getParent().getId();q.sap.log.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+s);}if(this._oSectionInfo[s]){o.setSelectedButton(this._oSectionInfo[s].buttonId);this._setSectionsFocusValues(s);}}};c.prototype._onUpdateScreenSize=function(e){if(!this._bDomReady){q.sap.log.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();q.sap.delayedCall(c.HEADER_CALC_DELAY,this,function(){this._bMobileScenario=l.Utilities.isPhoneScenario();this._bTabletScenario=l.Utilities.isTabletScenario();if(this._bHContentAlwaysExpanded!=this._checkAlwaysShowContentHeader()){this.invalidate();}this._adjustHeaderHeights();this._adjustLayout(null,true);this._oScroller.scrollTo(0,this._$opWrapper.scrollTop(),0);});};c.prototype._onScroll=function(e){var s=Math.max(e.target.scrollTop,0),p,h=this.getHeaderTitle(),d=s>=(this.iHeaderContentHeight-(this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight)),f,g=false;p=this.iScreenHeight;if(d&&!this._bHContentAlwaysExpanded){p-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}else{if(d&&this._bHContentAlwaysExpanded){p=p-(this._$stickyAnchorBar.height()+this.iHeaderTitleHeight+this.iStickyHeaderContentHeight);}}if(this._bIsHeaderExpanded){this._expandCollapseHeader(false);}if(!this._bHContentAlwaysExpanded&&((h&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(d);}else if(s==0&&((h&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(false);}if(!this._bHContentAlwaysExpanded){this._adjustHeaderTitleBackgroundPosition(s);}q.sap.log.debug("ObjectPageLayout :: lazy loading : Scrolling at "+s,"----------------------------------------");f=this._getClosestScrolledSectionId(s,p);if(f){var i=this.getDirectScrollingToSection();if(f!==this._sScrolledSectionId){q.sap.log.debug("ObjectPageLayout :: closest id "+f,"----------------------------------------");var i=this.getDirectScrollingToSection();if(i&&i!==f){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(f);}else if(f===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}}if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(s,e.timeStamp,p);}if(h&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&h.getShowTitleSelector()){if(s===0){q.sap.byId(this.getId()+"-scroll").css("z-index","1000");g=false;}else if(!g){g=true;q.sap.byId(this.getId()+"-scroll").css("z-index","0");}}};c.prototype._getClosestScrolledSectionId=function(s,p){if(this.getUseIconTabBar()&&this._oCurrentTabSection){return this._oCurrentTabSection.getId();}var i=s+p,d;q.each(this._oSectionInfo,function(I,o){if(o.isSection||this._bMobileScenario){if(!d){d=I;}if(o.positionTop<=i&&s<=o.positionBottom){if(o.positionTop<=s&&o.positionBottom>=s){d=I;return false;}}}}.bind(this));return d;};c.prototype._toggleHeader=function(s){var h=this.getHeaderTitle();if(!this._bHContentAlwaysExpanded&&!this._bIsHeaderExpanded){this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",s);}if(h&&h.getIsActionAreaAlwaysVisible()&&!h.getIsObjectTitleAlwaysVisible()){h._setActionsPaddingStatus(!s);}if(!this._bStickyAnchorBar&&s){this._restoreFocusAfter(this._convertHeaderToStickied);h&&h._adaptLayout();this._adjustHeaderHeights();}else if(this._bStickyAnchorBar&&!s){this._restoreFocusAfter(this._convertHeaderToExpanded);h&&h._adaptLayout();this._adjustHeaderHeights();}};c.prototype._restoreFocusAfter=function(m){var o=sap.ui.getCore(),d=o.byId(o.getCurrentFocusedControlId());m.call(this);if(D.system.phone!==true){if(!o.byId(o.getCurrentFocusedControlId())){d&&d.$().focus();}}return this;};c.prototype._convertHeaderToStickied=function(){if(!this._bHContentAlwaysExpanded){this._$anchorBar.css("height",this.iAnchorBarHeight).children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}}return this;};c.prototype._convertHeaderToExpanded=function(){if(!this._bHContentAlwaysExpanded){this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._toggleHeaderStyleRules(false);}return this;};c.prototype._toggleHeaderStyleRules=function(s){s=!!s;var v=s?"hidden":"inherit",d=this._bIsHeaderExpanded?"hidden":"inherit";this._bStickyAnchorBar=s;this._$headerContent.css("overflow",v);this._$headerContent.css("visibility",v);this._$anchorBar.css("visibility",d);this.fireToggleAnchorBar({fixed:s});};c.prototype.getScrollDelegate=function(){return this._oScroller;};c.prototype.setHeaderTitle=function(h,s){h.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)});return this.setAggregation("headerTitle",h,s);};c.prototype._adjustHeaderBackgroundSize=function(){var h=this.getHeaderTitle();if(h&&h.getHeaderDesign()=="Dark"){if(!this._bHContentAlwaysExpanded){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}h.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};c.prototype._adjustHeaderTitleBackgroundPosition=function(s){var h=this.getHeaderTitle();if(h&&h.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){h.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._bHContentAlwaysExpanded){h.$().css("background-position","0px 0px");}else{h.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-s)+"px");}}}};c.prototype._adjustHeaderHeights=function(){if(this._$headerTitle.length>0){var $=this._$headerTitle.clone();this.iHeaderContentHeight=this._$headerContent.height();this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._$anchorBar.height();$.css({left:"-10000px",top:"-10000px",width:this._$headerTitle.width()+"px"});if(this._bStickyAnchorBar){this.iHeaderTitleHeightStickied=this._$headerTitle.height()-this.iAnchorBarHeight;$.removeClass("sapUxAPObjectPageHeaderStickied");$.appendTo(this._$headerTitle.parent());this.iHeaderTitleHeight=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;}else{this.iHeaderTitleHeight=this._$headerTitle.is(":visible")?this._$headerTitle.height():0;$.addClass("sapUxAPObjectPageHeaderStickied");$.appendTo(this._$headerTitle.parent());this.iHeaderTitleHeightStickied=$.height();}$.remove();var p=this.iHeaderContentHeight?this.iHeaderTitleHeight:this.iHeaderTitleHeightStickied;this._$opWrapper.css("padding-top",p);this._adjustHeaderBackgroundSize();q.sap.log.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{q.sap.log.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};c.prototype._getHeaderDesign=function(){var h=this.getHeaderTitle(),d=l.ObjectPageHeaderDesign.Light;if(h!=null){d=h.getHeaderDesign();}return d;};c.prototype._getVisibleSections=function(){return this.getSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};c.prototype._setSectionsFocusValues=function(s){var d=this._getVisibleSections()||[],$,f='0',n='-1',t="tabIndex",o,F=d[0];d.forEach(function(e){$=e.$();if(s===e.sId){$.attr(t,f);o=e;e._setSubSectionsFocusValues();}else{$.attr(t,n);e._disableSubSectionsFocus();}});if(!o&&d.length>0){F.$().attr(t,f);F._setSubSectionsFocusValues();o=F;}return o;};c.prototype.setShowHeaderContent=function(s){var o=this.getShowHeaderContent();if(o!==s){if(o&&this._bIsHeaderExpanded){this._expandCollapseHeader(false);}this.setProperty("showHeaderContent",s);this._getHeaderContent().setProperty("visible",s);}return this;};c.prototype._headerTitleChangeHandler=function(){if(!this.getShowTitleInHeaderContent()||this._bFirstRendering){return;}var r=sap.ui.getCore().createRenderManager();this.getRenderer()._rerenderHeaderContentArea(r,this);r.destroy();};c.prototype.getHeaderContent=function(){return this._getHeaderContent().getAggregation("content");};c.prototype.insertHeaderContent=function(o,i,s){return this._getHeaderContent().insertAggregation("content",o,i,s);};c.prototype.addHeaderContent=function(o,s){return this._getHeaderContent().addAggregation("content",o,s);};c.prototype.removeAllHeaderContent=function(s){return this._getHeaderContent().removeAllAggregation("content",s);};c.prototype.removeHeaderContent=function(o,s){return this._getHeaderContent().removeAggregation("content",o,s);};c.prototype.destroyHeaderContent=function(s){return this._getHeaderContent().destroyAggregation("content",s);};c.prototype.indexOfHeaderContent=function(o){return this._getHeaderContent().indexOfAggregation("content",o);};c.prototype._getHeaderContent=function(){if(!this.getAggregation("_headerContent")){this.setAggregation("_headerContent",new l.ObjectPageHeaderContent({visible:this.getShowHeaderContent(),contentDesign:this._getHeaderDesign(),content:this.getAggregation("headerContent")}),true);}return this.getAggregation("_headerContent");};c.prototype._checkAlwaysShowContentHeader=function(){return!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};c.prototype._connectModelsForSections=function(s){s=s||[];s.forEach(function(o){o.connectToModels();});};c.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};c.prototype._hasVerticalScrollBar=function(){if(this._$opWrapper.length){return this._$opWrapper[0].scrollHeight>this._$opWrapper.innerHeight();}else{return!this.getUseIconTabBar();}};c.prototype._shiftHeader=function(d,p){this.$().find(".sapUxAPObjectPageHeaderTitle").css(d,p);};c.prototype._isFirstSection=function(s){var d=this._getVisibleSections();if(s===d[0]){return true;}return false;};c.HEADER_CALC_DELAY=350;c.DOM_CALC_DELAY=200;return c;});};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderRenderer')){jQuery.sap.declare('sap.uxap.ObjectPageHeaderRenderer');sap.ui.define("sap/uxap/ObjectPageHeaderRenderer",["./ObjectPageLayout"],function(O){"use strict";var a={};a.render=function(r,c){var n=c.getNavigationBar(),t=(c.getIsObjectIconAlwaysVisible()||c.getIsObjectTitleAlwaysVisible()||c.getIsObjectSubtitleAlwaysVisible()||c.getIsActionAreaAlwaysVisible()),p=c.getParent(),e=c.getAggregation("_expandButton"),I=sap.ui.Device.system.desktop,b=p&&p instanceof O&&p.getHeaderContent()&&p.getHeaderContent().length>0&&p.getShowHeaderContent();r.write("<div");r.writeControlData(c);r.addClass('sapUxAPObjectPageHeader');r.addClass('sapUxAPObjectPageHeaderDesign-'+c.getHeaderDesign());r.writeClasses();r.write(">");if(n){r.write("<div");r.addClass('sapUxAPObjectPageHeaderNavigation');r.writeClasses();r.write(">");r.renderControl(n);r.write("</div>");}r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-identifierLine");r.addClass('sapUxAPObjectPageHeaderIdentifier');if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierForce');}r.writeClasses();r.write(">");if(p&&p instanceof O&&p.getIsChildPage()){r.write("<div");r.addClass('sapUxAPObjectChildPage');r.writeClasses();r.write("></div>");}if(c.getObjectImageURI()||c.getShowPlaceholder()){r.write("<span ");r.addClass('sapUxAPObjectPageHeaderObjectImageContainer');r.addClass('sapUxAPObjectPageHeaderObjectImage-'+c.getObjectImageShape());if(c.getIsObjectIconAlwaysVisible()){r.addClass('sapUxAPObjectPageHeaderObjectImageForce');}r.writeClasses();r.write(">");r.write("<span class='sapUxAPObjectPageHeaderObjectImageContainerSub'>");if(c.getObjectImageURI()){r.renderControl(c._getInternalAggregation("_objectImage"));if(c.getShowPlaceholder()){this._renderPlaceholder(r,c,false);}}else{this._renderPlaceholder(r,c,true);}r.write("</span>");r.write("</span>");}r.write("<span ");r.writeAttributeEscaped("id",c.getId()+"-identifierLineContainer");r.addClass('sapUxAPObjectPageHeaderIdentifierContainer');r.writeClasses();r.write(">");this._renderObjectPageTitle(r,c);r.write("</span>");r.write("<span");r.writeAttributeEscaped("id",c.getId()+"-actions");r.addClass('sapUxAPObjectPageHeaderIdentifierActions');if(c.getIsActionAreaAlwaysVisible()){r.addClass('sapUxAPObjectPageHeaderIdentifierActionsForce');}if(c._getActionsPaddingStatus()){r.addClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding");}r.writeClasses();r.write(">");if(I&&b){e.addStyleClass("sapUxAPObjectPageHeaderExpandButton");r.renderControl(e);}var A=c.getActions();for(var i=0;i<A.length;i++){var o=A[i];r.renderControl(o);}var d=c.getAggregation("_overflowButton");r.renderControl(d);r.write("</span>");r.write("</div>");r.write("</div>");};a._renderPlaceholder=function(r,c,v,t){r.write("<div");r.addClass('sapUxAPObjectPageHeaderPlaceholder');r.addClass('sapUxAPObjectPageHeaderObjectImage');if(!v){r.addClass('sapUxAPHidePlaceholder');}r.writeClasses();r.write(">");r.renderControl(c._oPlaceholder);r.write("</div>");};a._renderObjectPageTitle=function(r,c,t){var o=c.getObjectTitle(),m=(c.getShowMarkers()&&(c.getMarkFavorite()||c.getMarkFlagged())),b=c._getInternalAggregation('_breadCrumbs');if(!t&&b&&b.getLinks().length){r.renderControl(b);}r.write("<h1");r.addClass('sapUxAPObjectPageHeaderIdentifierTitle');if(c.getIsObjectTitleAlwaysVisible()){r.addClass('sapUxAPObjectPageHeaderIdentifierTitleForce');}if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierTitleInContent');}if(c.getShowTitleSelector()){r.addClass('sapUxAPObjectPageHeaderTitleFollowArrow');}r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-title");r.write(">");r.write("<span");r.addClass("sapUxAPObjectPageHeaderTitleTextWrappable");r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-innerTitle");r.write(">");if(m||c.getShowTitleSelector()||c.getMarkLocked()||c.getMarkChanges()){var s=o.substr(o.lastIndexOf(" ")+1);var d=o.substr(0,o.lastIndexOf(" ")+1);if(s.length===1){s=o;d='';}r.writeEscaped(d);r.write("</span>");r.write("<span");r.addClass('sapUxAPObjectPageHeaderNowrapMarkers');if(c.getMarkLocked()||c.getMarkChanges()){r.addClass('sapUxAPObjectPageHeaderMarks');}r.writeClasses();r.write(">");r.writeEscaped(s);if(c.getMarkLocked()){this._renderLock(r,c,t);}else if(c.getMarkChanges()){this._renderMarkChanges(r,c,t);}this._renderMarkers(r,c);this._renderSelectTitleArrow(r,c,t);r.write("</span>");}else{r.writeEscaped(o);r.write("</span>");}r.write("</h1>");r.write("<span");r.addClass('sapUxAPObjectPageHeaderIdentifierDescription');if(c.getIsObjectSubtitleAlwaysVisible()&&c.getObjectSubtitle()){r.addClass('sapUxAPObjectPageHeaderIdentifierDescriptionForce');}if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierSubTitleInContent');}r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-subtitle");r.write(">");r.writeEscaped(c.getObjectSubtitle());r.write("</span>");};a._renderSelectTitleArrow=function(r,c,t){if(c.getShowTitleSelector()){r.write("<span");r.addClass("sapUxAPObjectPageHeaderTitleArrow");r.writeClasses();r.write(">");if(t){r.renderControl(c._oTitleArrowIconCont);}else{r.renderControl(c._oTitleArrowIcon);}r.write("</span>");}};a._renderMarkChanges=function(r,c,t){r.write("<span");r.addClass("sapUxAPObjectPageHeaderChangesBtn");r.addClass("sapUiSizeCompact");r.writeClasses();r.write(">");if(t){r.renderControl(c._oChangesIconCont);}else{r.renderControl(c._oChangesIcon);}r.write("</span>");};a._renderLock=function(r,c,t){r.write("<span");r.addClass("sapUxAPObjectPageHeaderLockBtn");r.addClass("sapUiSizeCompact");r.writeClasses();r.write(">");if(t){r.renderControl(c._oLockIconCont);}else{r.renderControl(c._oLockIcon);}r.write("</span>");};a._renderMarkers=function(r,c){var I=[];if(c.getShowMarkers()){I.push(c._oFavIcon);I.push(c._oFlagIcon);this._renderMarkersAria(r,c);r.write("<span");r.addClass("sapMObjStatusMarker");r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-markers");r.writeAttributeEscaped("aria-describedby",c.getId()+"-markers-aria");r.write(">");for(var i=0;i<I.length;i++){r.renderControl(I[i]);}r.write("</span>");}};a._renderMarkersAria=function(r,c){var A="";if(c.getMarkFlagged()){A+=(c.oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE")+" ");}if(c.getMarkFavorite()){A+=(c.oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE")+" ");}if(A!==""){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-markers-aria");r.writeAttribute("aria-hidden","false");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.writeEscaped(A);r.write("</div>");}};return a;},true);};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageLayoutRenderer')){jQuery.sap.declare('sap.uxap.ObjectPageLayoutRenderer');jQuery.sap.require('sap.ui.core.Renderer');sap.ui.define("sap/uxap/ObjectPageLayoutRenderer",["sap/ui/core/Renderer","./ObjectPageHeaderRenderer"],function(R,O){"use strict";var a={};a.render=function(r,c){var s,h=c.getHeaderTitle(),A=null;if(c.getShowAnchorBar()&&c._getInternalAnchorBarVisible()){A=c.getAggregation("_anchorBar");}r.write("<div");r.writeControlData(c);if(h){r.writeAttributeEscaped("aria-label",h.getObjectTitle());}r.addClass("sapUxAPObjectPageLayout");r.writeClasses();r.addStyle("height",c.getHeight());r.writeStyles();r.write(">");r.write("<header ");r.writeAttribute("role","header");r.writeAttributeEscaped("id",c.getId()+"-headerTitle");r.addClass("sapUxAPObjectPageHeaderTitle");r.writeClasses();r.write(">");if(h){r.renderControl(h);}this._renderHeaderContentDOM(r,c,c._bHContentAlwaysExpanded,"-stickyHeaderContent");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-stickyAnchorBar");r.addClass("sapUxAPObjectPageStickyAnchorBar");r.addClass("sapUxAPObjectPageNavigation");r.writeClasses();r.write(">");this._renderAnchorBar(r,c,A,c._bHContentAlwaysExpanded);r.write("</div>");r.write("</header>");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-opwrapper");r.addClass("sapUxAPObjectPageWrapper");if(!(c.getShowTitleInHeaderContent()&&h.getShowTitleSelector())){r.addClass("sapUxAPObjectPageWrapperTransform");}r.writeClasses();r.write(">");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-scroll");r.addClass("sapUxAPObjectPageScroll");r.writeClasses();r.write(">");this._renderHeaderContentDOM(r,c,!c._bHContentAlwaysExpanded,"-headerContent");r.write("<section ");r.writeAttributeEscaped("id",c.getId()+"-anchorBar");r.writeAttribute("role","navigaiton");r.addClass("sapUxAPObjectPageNavigation");r.writeClasses();r.write(">");this._renderAnchorBar(r,c,A,!c._bHContentAlwaysExpanded);r.write("</section>");r.write("<section");r.addClass("sapUxAPObjectPageContainer");if(!A){r.addClass("sapUxAPObjectPageContainerNoBar");}r.writeClasses();r.write(">");s=c.getAggregation("sections");if(jQuery.isArray(s)){jQuery.each(s,function(i,S){r.renderControl(S);});}r.write("</section>");this.renderFooterContent(r,c);r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-spacer");r.write("></div>");r.write("</div>");r.write("</div>");r.write("</div>");};a._renderAnchorBar=function(r,c,A,b){if(b){if(c.getIsChildPage()){r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-childPageBar");r.addClass('sapUxAPObjectChildPage');r.writeClasses();r.write("></div>");}if(A){r.renderControl(A);}}};a._renderHeaderContentDOM=function(r,c,b,i){r.write("<header ");r.writeAttributeEscaped("id",c.getId()+i);r.addClass("ui-helper-clearfix");r.addClass("sapUxAPObjectPageHeaderDetails");r.addClass("sapUxAPObjectPageHeaderDetailsDesign-"+c._getHeaderDesign());r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");if(b){this.renderHeaderContent(r,c);}r.write("</header>");};a.renderHeaderContent=function(r,c){r.renderControl(c._getHeaderContent());};a.renderFooterContent=function(r,c){};a._rerenderHeaderContentArea=function(r,c){var i=c.getId();this.renderHeaderContent(r,c);r.flush(jQuery.sap.byId(i+"-headerContent")[0]);};return a;},true);};if(!jQuery.sap.isDeclared('sap.uxap.ObjectPageHeaderContentRenderer')){jQuery.sap.declare('sap.uxap.ObjectPageHeaderContentRenderer');sap.ui.define("sap/uxap/ObjectPageHeaderContentRenderer",["./ObjectPageHeaderRenderer","./ObjectPageLayout"],function(O,a){"use strict";var b={};b.render=function(r,c){var p=c.getParent(),P=(p instanceof a),h=(p&&P)?p.getHeaderTitle():false,R=(p&&P)?((p instanceof a)&&p.getShowTitleInHeaderContent()):false,d=P&&p.getShowEditHeaderButton();if(d){r.write("<div ");r.addClass("sapUxAPObjectPageHeaderContentFlexBox");r.addClass("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());r.writeClasses();r.write(">");}r.write("<div ");r.writeControlData(c);if(d){r.addClass("sapUxAPObjectPageHeaderContentCellLeft");}else{r.addClass("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());}r.addClass("ui-helper-clearfix");r.addClass("sapUxAPObjectPageHeaderContent");if(!c.getVisible()){r.addClass("sapUxAPObjectPageHeaderContentHidden");}r.writeClasses();r.write(">");if(P&&p.getIsChildPage()){r.write("<div");r.addClass('sapUxAPObjectChildPage');r.writeClasses();r.write("></div>");}if(R){this._renderTitleImage(r,h);if(c.getContent().length==0){r.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");this._renderTitle(r,h);r.write("</span>");}}c.getContent().forEach(function(i,I){this._renderHeaderContent(i,I,r,R,h,c);},this);r.write("</div>");if(d){this._renderEditButton(r,c);r.write("</div>");}};b._renderHeaderContent=function(h,i,r,R,H,c){var d=false,e=false,l=c._getLayoutDataForControl(h),I=i===0,f=i===(c.getContent().length-1);if(l){d=l.getShowSeparatorBefore();e=l.getShowSeparatorAfter();r.write("<span ");r.addClass("sapUxAPObjectPageHeaderWidthContainer");r.addClass("sapUxAPObjectPageHeaderContentItem");r.addStyle("width",l.getWidth());r.writeStyles();if(e||d){r.addClass("sapUxAPObjectPageHeaderSeparatorContainer");}if(!l.getVisibleL()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenL");}if(!l.getVisibleM()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenM");}if(!l.getVisibleS()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenS");}r.writeClasses();r.write(">");if(d){r.write("<span class=\"sapUxAPObjectPageHeaderSeparatorBefore\"/>");}if(I&&R){this._renderTitle(r,H);}}else{if(I&&R){r.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");this._renderTitle(r,H);}else{h.addStyleClass("sapUxAPObjectPageHeaderContentItem");}}r.renderControl(h);if(e){r.write("<span class=\"sapUxAPObjectPageHeaderSeparatorAfter\"/>");}if(l||(I&&R)||f){r.write("</span>");}};b._renderTitleImage=function(r,h){if(h.getObjectImageURI()||h.getShowPlaceholder()){r.write("<span");r.addClass("sapUxAPObjectPageHeaderContentImageContainer");r.addClass("sapUxAPObjectPageHeaderObjectImage-"+h.getObjectImageShape());r.writeClasses();r.write(">");if(h.getObjectImageURI()){r.renderControl(h._getInternalAggregation("_objectImage"));if(h.getShowPlaceholder()){O._renderPlaceholder(r,h,false);}}else{O._renderPlaceholder(r,h,true);}r.write("</span>");}};b._renderTitle=function(r,h){O._renderObjectPageTitle(r,h,true);};b._renderEditButton=function(r,h){r.write("<div class=\"sapUxAPObjectPageHeaderContentCellRight\">");r.renderControl(h.getAggregation("_editHeaderButton"));r.write("</div>");};return b;},true);};
