/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/MonthsRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,M,b,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},cancel:{},startDateChange:{}}}});c.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y"});this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31)));var x=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});x.attachEvent("pressPrevious",this._handlePrevious,this);x.attachEvent("pressNext",this._handleNext,this);x.attachEvent("pressButton2",o,this);this.setAggregation("header",x);var y=new M(this.getId()+"--MonthsRow");y.attachEvent("focus",r,this);y.attachEvent("select",p,this);y._bNoThemeChange=true;this.setAggregation("monthsRow",y);var z=new Y(this.getId()+"--YP",{columns:0,years:6});z.attachEvent("select",s,this);this.setAggregation("yearPicker",z);this._iDaysMonthsHead=15;};c.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};c.prototype.onBeforeRendering=function(){var x=this.getAggregation("monthsRow");var y=this._getFocusedDate();i.call(this);x.setDate(a._createLocalDate(y));};c.prototype.setStartDate=function(S){if(!(S instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var y=S.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}var x=a._createUniversalUTCDate(S);this.setProperty("startDate",S,true);this._oUTCStartDate=x;this._oUTCStartDate.setUTCDate(1);var z=this.getAggregation("monthsRow");z.setStartDate(S);i.call(this);var A=a._createLocalDate(this._getFocusedDate());if(!z.checkDateFocusable(A)){this._setFocusedDate(this._oUTCStartDate);z.displayDate(S);}return this;};c.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,t);}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var x=this.destroyAggregation("selectedDates");return x;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var x=this.destroyAggregation("specialDates");return x;};c.prototype.setLocale=function(x){if(this._sLocale!=x){this._sLocale=x;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){f.call(this);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(x){if(!(x instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(x.getTime());};c.prototype.focusDate=function(x){var F=false;var y=this.getAggregation("monthsRow");if(!y.checkDateFocusable(x)){var z=a._createUniversalUTCDate(x);u.call(this,z);F=true;}n.call(this,x,false);if(F){this.fireStartDateChange();}return this;};c.prototype.displayDate=function(x){n.call(this,x,true);return this;};c.prototype.setMonths=function(x){this.setProperty("months",x,true);x=this._getMonths();var y=this.getAggregation("monthsRow");y.setMonths(x);var z=a._createLocalDate(this._getFocusedDate());if(!y.checkDateFocusable(z)){var S=d.call(this);this._setFocusedDate(this._oUTCStartDate);y.setDate(a._createLocalDate(S));}if(!this.getPickerPopup()){var A=this.getAggregation("yearPicker");var B=Math.floor(x/2);if(B>20){B=20;}A.setYears(B);}i.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}};c.prototype._getMonths=function(){var x=this.getMonths();if(sap.ui.Device.system.phone&&x>6){return 6;}else{return x;}};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var x=this.getLocale();var y=new sap.ui.core.Locale(x);this._oLocaleData=L.getInstance(y);}return this._oLocaleData;};c.prototype.setPickerPopup=function(P){this.setProperty("pickerPopup",P,true);var y=this.getAggregation("yearPicker");if(P){y.setColumns(4);y.setYears(20);}else{y.setColumns(0);y.setYears(6);}};c.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};c.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};c.prototype.onsapescape=function(E){switch(this._iMode){case 0:this.fireCancel();break;case 1:h.call(this);break;}};c.prototype.onsaptabnext=function(E){var x=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(x.getDomRef("B2"));if(!this._bPoupupMode){var y=this.getAggregation("monthsRow");var z=this.getAggregation("yearPicker");q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(z.getDomRef()){q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}};c.prototype.onsaptabprevious=function(E){var x=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(x.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==x.getId()+"-B2"){var y=this.getAggregation("monthsRow");var z=this.getAggregation("yearPicker");switch(this._iMode){case 0:y._oItemNavigation.focusItem(y._oItemNavigation.getFocusedIndex());break;case 1:z._oItemNavigation.focusItem(z._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}};c.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var x=this.getAggregation("header");var y=this.getAggregation("monthsRow");var z=this.getAggregation("yearPicker");q.sap.focus(x.getDomRef("B2"));if(!this._bPoupupMode){q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(z.getDomRef()){q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var x=this.getAggregation("monthsRow");var y=this.getAggregation("yearPicker");switch(this._iMode){case 0:q(x._oItemNavigation.getItemDomRefs()[x._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};c.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var x=this._getMonths();var S=new U(d.call(this).getTime());switch(this._iMode){case 0:S.setUTCMonth(S.getUTCMonth()-x);F.setUTCMonth(F.getUTCMonth()-x);this._setFocusedDate(F);_.call(this,S,true);break;case 1:y.previousPage();break;}};c.prototype._handleNext=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var x=this._getMonths();var S=new U(d.call(this).getTime());switch(this._iMode){case 0:S.setUTCMonth(S.getUTCMonth()+x);F.setUTCMonth(F.getUTCMonth()+x);this._setFocusedDate(F);_.call(this,S,true);break;case 1:y.nextPage();break;}};c.prototype._getShowItemHeader=function(){var x=this.getMonths();if(x>this._iDaysMonthsHead){return true;}else{return false;}};function _(S,x,N){var y=new U(this._oMaxDate.getTime());y.setUTCMonth(y.getUTCMonth()-this._getMonths()+1);if(S.getTime()<this._oMinDate.getTime()){S=this._oMinDate;}else if(S.getTime()>y.getTime()){S=y;}S.setUTCDate(1);var z=a._createLocalDate(S);this.setProperty("startDate",z,true);this._oUTCStartDate=S;var A=this.getAggregation("monthsRow");A.setStartDate(z);i.call(this);if(x){var B=a._createLocalDate(this._getFocusedDate());if(!A.checkDateFocusable(B)){this._setFocusedDate(S);A.setDate(z);}else{A.setDate(B);}}if(!N){this.fireStartDateChange();}}function d(){if(!this._oUTCStartDate){this._oUTCStartDate=this._getFocusedDate();this._oUTCStartDate.setUTCDate(1);}return this._oUTCStartDate;}function e(N){var x=this._getFocusedDate();var y=this.getAggregation("monthsRow");if(!N){y.setDate(a._createLocalDate(x));}else{y.displayDate(a._createLocalDate(x));}i.call(this);}function f(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate());this._oFocusedDate.setUTCDate(1);}else{var N=new Date();this._oFocusedDate=a._createUniversalUTCDate(N);this._oFocusedDate.setUTCDate(1);}}function g(){var x=this._getFocusedDate();var y=x.getJSDate().getUTCFullYear();var z=this._oMaxDate.getJSDate().getUTCFullYear();var A=this._oMinDate.getJSDate().getUTCFullYear();if(z-A<=20){return;}var B=this.getAggregation("header");if(y>(z-10)){y=z-9;B.setEnabledNext(false);}else{B.setEnabledNext(true);}if(y<(A+9)){y=A+10;B.setEnabledPrevious(false);}else{B.setEnabledPrevious(true);}var E=this.getAggregation("yearPicker");if(!this.getPickerPopup()){if(E.getDomRef()){E.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(E);R.flush($[0],false,true);R.destroy();}}else{v.call(this,E);}this.$("contentOver").css("display","");E.setDate(x.getJSDate());if(this._iMode==0){var F=this.getAggregation("monthsRow");q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}function h(N){this._iMode=0;if(!this.getPickerPopup()){var y=this.getAggregation("yearPicker");y.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){e.call(this);var x=this.getAggregation("monthsRow");q(x._oItemNavigation.getItemDomRefs()[x._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function i(){k.call(this);j.call(this);}function j(){var x=new U(d.call(this).getTime());var y=this._getMonths();var z=x.getJSDate().getUTCFullYear();var A=this._oMaxDate.getJSDate().getUTCFullYear();var B=this._oMinDate.getJSDate().getUTCFullYear();var E=x.getJSDate().getUTCMonth();var F=this._oMaxDate.getJSDate().getUTCMonth();var G=this._oMinDate.getJSDate().getUTCMonth();var I=this.getAggregation("header");if(z<B||(z==B&&E<=G)){I.setEnabledPrevious(false);}else{I.setEnabledPrevious(true);}x.setUTCMonth(x.getUTCMonth()+y-1);z=x.getJSDate().getUTCFullYear();E=x.getJSDate().getUTCMonth();if(z>A||(z==A&&E>=F)){I.setEnabledNext(false);}else{I.setEnabledNext(true);}}function k(){var T;var S=d.call(this);var x=this._oYearFormat.format(S,true);var E=new U(S.getTime());E.setUTCMonth(E.getUTCMonth()+this._getMonths()-1);var y=this._oYearFormat.format(E,true);if(x!=y){var z=this._getLocaleData();var P=z.getIntervalPattern();T=P.replace(/\{0\}/,x).replace(/\{1\}/,y);}else{T=x;}var A=this.getAggregation("header");A.setTextButton2(T);}function m(x,N){var F;var y=false;if(x.getTime()<this._oMinDate.getTime()){F=this._oMinDate;y=true;}else if(x.getTime()>this._oMaxDate.getTime()){F=this._oMaxDate;y=true;}else{F=x;}this._setFocusedDate(F);if(y||N){u.call(this,F);e.call(this,false);this.fireStartDateChange();}}function n(x,N){if(x&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=x.getTime())){if(!(x instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}x=a._createUniversalUTCDate(x);var y=x.getUTCFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this._setFocusedDate(x);if(this.getDomRef()&&this._iMode==0){e.call(this,N);}}}function o(E){if(this._iMode!=1){g.call(this);}else{h.call(this);}}function p(E){this.fireSelect();}function r(E){var x=a._createUniversalUTCDate(E.getParameter("date"));var N=E.getParameter("notVisible");m.call(this,x,N);}function s(E){var F=new U(this._getFocusedDate().getTime());var y=this.getAggregation("yearPicker");var x=a._createUniversalUTCDate(y.getDate());x.setUTCMonth(F.getUTCMonth(),F.getUTCDate());F=x;m.call(this,F,true);h.call(this);}function t(){this._sInvalidateContent=undefined;var x=this.getAggregation("monthsRow");x._bDateRangeChanged=true;x._bInvalidateSync=true;x.invalidate();x._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function u(x){var y=this.getAggregation("monthsRow");var S=d.call(this);var z=y._oItemNavigation.getFocusedIndex();S=new U(x.getTime());S.setUTCMonth(S.getUTCMonth()-z);_.call(this,S,false,true);}function v(P){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(w,this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(P);var x=this.getAggregation("header");var y=sap.ui.core.Popup.Dock;this._oPopup.open(0,y.CenterTop,y.CenterBottom,x,null,"flipfit",true);}function w(E){switch(this._iMode){case 0:break;case 1:h.call(this);break;}}return c;},true);
